#ifndef _DP_FI_DEFAULT_H
#define _DP_FI_DEFAULT_H

extern tVoid vInitDefault(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclDefaultBTName{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultBTName(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultBTName() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tBTNameParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tBTNameParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tBTNameParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultWifiName{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultWifiName(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultWifiName() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tWifiNameParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tWifiNameParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tWifiNameParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultkeyIlluminationAlignmentCoefficients{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultkeyIlluminationAlignmentCoefficients(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultkeyIlluminationAlignmentCoefficients() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tkeyIlluminationAlignmentCoefficientsParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tkeyIlluminationAlignmentCoefficientsParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tkeyIlluminationAlignmentCoefficientsParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultSmartphoneIntegration{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultSmartphoneIntegration(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultSmartphoneIntegration() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tSmartphoneIntegrationParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tSmartphoneIntegrationParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tSmartphoneIntegrationParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultIntercomPhoneName{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultIntercomPhoneName(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultIntercomPhoneName() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tIntercomPhoneNameParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tIntercomPhoneNameParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tIntercomPhoneNameParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultBluetoothPhoneECNRNBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultBluetoothPhoneECNRNBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultBluetoothPhoneECNRNBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tBluetoothPhoneECNRNBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tBluetoothPhoneECNRNBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tBluetoothPhoneECNRNBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultBluetoothPhoneECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultBluetoothPhoneECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultBluetoothPhoneECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tBluetoothPhoneECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tBluetoothPhoneECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tBluetoothPhoneECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultCarplayPhoneECNRNBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultCarplayPhoneECNRNBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultCarplayPhoneECNRNBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tCarplayPhoneECNRNBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tCarplayPhoneECNRNBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tCarplayPhoneECNRNBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultCarplayPhoneECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultCarplayPhoneECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultCarplayPhoneECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tCarplayPhoneECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tCarplayPhoneECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tCarplayPhoneECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultCarplayFacetimeECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultCarplayFacetimeECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultCarplayFacetimeECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tCarplayFacetimeECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tCarplayFacetimeECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tCarplayFacetimeECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultAAVoiceECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultAAVoiceECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultAAVoiceECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tAAVoiceECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tAAVoiceECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tAAVoiceECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultBluetoothSiriECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultBluetoothSiriECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultBluetoothSiriECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tBluetoothSiriECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tBluetoothSiriECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tBluetoothSiriECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultBluetoothVoiceECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultBluetoothVoiceECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultBluetoothVoiceECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tBluetoothVoiceECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tBluetoothVoiceECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tBluetoothVoiceECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultBluetoothVoiceECNRNBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultBluetoothVoiceECNRNBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultBluetoothVoiceECNRNBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tBluetoothVoiceECNRNBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tBluetoothVoiceECNRNBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tBluetoothVoiceECNRNBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultCarplaySiriECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultCarplaySiriECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultCarplaySiriECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tCarplaySiriECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tCarplaySiriECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tCarplaySiriECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultINTVoiceECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultINTVoiceECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultINTVoiceECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tINTVoiceECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tINTVoiceECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tINTVoiceECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDefaultVPAVoiceECNRWBS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDefaultVPAVoiceECNRWBS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDefaultVPAVoiceECNRWBS() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tVPAVoiceECNRWBSParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tVPAVoiceECNRWBSParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tVPAVoiceECNRWBSParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

#endif
