
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDefault.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BTName"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultBTName::dp_tclDefaultBTName(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultBTName::s32SetData( tU8* tBTNameParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BTName", (tS32)0x424d3);
   (tVoid)myDpElem.bFillData((tVoid*)tBTNameParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultBTName::s32GetData(tU8* tBTNameParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BTName", (tS32)0x424d3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBTNameParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultBTName::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultBTName::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultBTName::u16GetData(tU8* tBTNameParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBTNameParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultBTName::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "BTName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultBTName::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "BTName", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultBTName::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BTName", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element BTName has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "WifiName"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultWifiName::dp_tclDefaultWifiName(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultWifiName::s32SetData( tU8* tWifiNameParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("WifiName", (tS32)0x86ce88);
   (tVoid)myDpElem.bFillData((tVoid*)tWifiNameParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultWifiName::s32GetData(tU8* tWifiNameParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("WifiName", (tS32)0x86ce88);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tWifiNameParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultWifiName::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultWifiName::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultWifiName::u16GetData(tU8* tWifiNameParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tWifiNameParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultWifiName::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "WifiName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultWifiName::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "WifiName", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultWifiName::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: WifiName", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element WifiName has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "keyIlluminationAlignmentCoefficients"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultkeyIlluminationAlignmentCoefficients::dp_tclDefaultkeyIlluminationAlignmentCoefficients(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultkeyIlluminationAlignmentCoefficients::s32SetData( tU8* tkeyIlluminationAlignmentCoefficientsParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("keyIlluminationAlignmentCoefficients", (tS32)0x81aecbb7L);
   (tVoid)myDpElem.bFillData((tVoid*)tkeyIlluminationAlignmentCoefficientsParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultkeyIlluminationAlignmentCoefficients::s32GetData(tU8* tkeyIlluminationAlignmentCoefficientsParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("keyIlluminationAlignmentCoefficients", (tS32)0x81aecbb7L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tkeyIlluminationAlignmentCoefficientsParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultkeyIlluminationAlignmentCoefficients::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultkeyIlluminationAlignmentCoefficients::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultkeyIlluminationAlignmentCoefficients::u16GetData(tU8* tkeyIlluminationAlignmentCoefficientsParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tkeyIlluminationAlignmentCoefficientsParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultkeyIlluminationAlignmentCoefficients::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "keyIlluminationAlignmentCoefficients", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultkeyIlluminationAlignmentCoefficients::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "keyIlluminationAlignmentCoefficients", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultkeyIlluminationAlignmentCoefficients::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: keyIlluminationAlignmentCoefficients", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element keyIlluminationAlignmentCoefficients has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SmartphoneIntegration"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultSmartphoneIntegration::dp_tclDefaultSmartphoneIntegration(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultSmartphoneIntegration::s32SetData( tU8* tSmartphoneIntegrationParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SmartphoneIntegration", (tS32)0x293054d9);
   (tVoid)myDpElem.bFillData((tVoid*)tSmartphoneIntegrationParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultSmartphoneIntegration::s32GetData(tU8* tSmartphoneIntegrationParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SmartphoneIntegration", (tS32)0x293054d9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSmartphoneIntegrationParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultSmartphoneIntegration::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultSmartphoneIntegration::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultSmartphoneIntegration::u16GetData(tU8* tSmartphoneIntegrationParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSmartphoneIntegrationParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultSmartphoneIntegration::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "SmartphoneIntegration", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultSmartphoneIntegration::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "SmartphoneIntegration", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultSmartphoneIntegration::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SmartphoneIntegration", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element SmartphoneIntegration has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "IntercomPhoneName"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultIntercomPhoneName::dp_tclDefaultIntercomPhoneName(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultIntercomPhoneName::s32SetData( tU8* tIntercomPhoneNameParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("IntercomPhoneName", (tS32)0x8c0f346c);
   (tVoid)myDpElem.bFillData((tVoid*)tIntercomPhoneNameParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultIntercomPhoneName::s32GetData(tU8* tIntercomPhoneNameParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("IntercomPhoneName", (tS32)0x8c0f346c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tIntercomPhoneNameParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultIntercomPhoneName::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultIntercomPhoneName::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultIntercomPhoneName::u16GetData(tU8* tIntercomPhoneNameParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tIntercomPhoneNameParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultIntercomPhoneName::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "IntercomPhoneName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultIntercomPhoneName::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "IntercomPhoneName", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultIntercomPhoneName::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: IntercomPhoneName", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element IntercomPhoneName has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BluetoothPhoneECNRNBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultBluetoothPhoneECNRNBS::dp_tclDefaultBluetoothPhoneECNRNBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultBluetoothPhoneECNRNBS::s32SetData( tU8* tBluetoothPhoneECNRNBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BluetoothPhoneECNRNBS", (tS32)0x7fa509bf);
   (tVoid)myDpElem.bFillData((tVoid*)tBluetoothPhoneECNRNBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultBluetoothPhoneECNRNBS::s32GetData(tU8* tBluetoothPhoneECNRNBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BluetoothPhoneECNRNBS", (tS32)0x7fa509bf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBluetoothPhoneECNRNBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultBluetoothPhoneECNRNBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultBluetoothPhoneECNRNBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultBluetoothPhoneECNRNBS::u16GetData(tU8* tBluetoothPhoneECNRNBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBluetoothPhoneECNRNBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultBluetoothPhoneECNRNBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothPhoneECNRNBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultBluetoothPhoneECNRNBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothPhoneECNRNBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultBluetoothPhoneECNRNBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BluetoothPhoneECNRNBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element BluetoothPhoneECNRNBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BluetoothPhoneECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultBluetoothPhoneECNRWBS::dp_tclDefaultBluetoothPhoneECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultBluetoothPhoneECNRWBS::s32SetData( tU8* tBluetoothPhoneECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BluetoothPhoneECNRWBS", (tS32)0x7fa50aa0);
   (tVoid)myDpElem.bFillData((tVoid*)tBluetoothPhoneECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultBluetoothPhoneECNRWBS::s32GetData(tU8* tBluetoothPhoneECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BluetoothPhoneECNRWBS", (tS32)0x7fa50aa0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBluetoothPhoneECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultBluetoothPhoneECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultBluetoothPhoneECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultBluetoothPhoneECNRWBS::u16GetData(tU8* tBluetoothPhoneECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBluetoothPhoneECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultBluetoothPhoneECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothPhoneECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultBluetoothPhoneECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothPhoneECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultBluetoothPhoneECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BluetoothPhoneECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element BluetoothPhoneECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CarplayPhoneECNRNBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultCarplayPhoneECNRNBS::dp_tclDefaultCarplayPhoneECNRNBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultCarplayPhoneECNRNBS::s32SetData( tU8* tCarplayPhoneECNRNBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("CarplayPhoneECNRNBS", (tS32)0xa65d238d);
   (tVoid)myDpElem.bFillData((tVoid*)tCarplayPhoneECNRNBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultCarplayPhoneECNRNBS::s32GetData(tU8* tCarplayPhoneECNRNBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("CarplayPhoneECNRNBS", (tS32)0xa65d238d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tCarplayPhoneECNRNBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultCarplayPhoneECNRNBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultCarplayPhoneECNRNBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultCarplayPhoneECNRNBS::u16GetData(tU8* tCarplayPhoneECNRNBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tCarplayPhoneECNRNBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultCarplayPhoneECNRNBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "CarplayPhoneECNRNBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultCarplayPhoneECNRNBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "CarplayPhoneECNRNBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultCarplayPhoneECNRNBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CarplayPhoneECNRNBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element CarplayPhoneECNRNBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CarplayPhoneECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultCarplayPhoneECNRWBS::dp_tclDefaultCarplayPhoneECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultCarplayPhoneECNRWBS::s32SetData( tU8* tCarplayPhoneECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("CarplayPhoneECNRWBS", (tS32)0xa65d246e);
   (tVoid)myDpElem.bFillData((tVoid*)tCarplayPhoneECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultCarplayPhoneECNRWBS::s32GetData(tU8* tCarplayPhoneECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("CarplayPhoneECNRWBS", (tS32)0xa65d246e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tCarplayPhoneECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultCarplayPhoneECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultCarplayPhoneECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultCarplayPhoneECNRWBS::u16GetData(tU8* tCarplayPhoneECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tCarplayPhoneECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultCarplayPhoneECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "CarplayPhoneECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultCarplayPhoneECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "CarplayPhoneECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultCarplayPhoneECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CarplayPhoneECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element CarplayPhoneECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CarplayFacetimeECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultCarplayFacetimeECNRWBS::dp_tclDefaultCarplayFacetimeECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultCarplayFacetimeECNRWBS::s32SetData( tU8* tCarplayFacetimeECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("CarplayFacetimeECNRWBS", (tS32)0x4d5bf60a);
   (tVoid)myDpElem.bFillData((tVoid*)tCarplayFacetimeECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultCarplayFacetimeECNRWBS::s32GetData(tU8* tCarplayFacetimeECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("CarplayFacetimeECNRWBS", (tS32)0x4d5bf60a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tCarplayFacetimeECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultCarplayFacetimeECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultCarplayFacetimeECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultCarplayFacetimeECNRWBS::u16GetData(tU8* tCarplayFacetimeECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tCarplayFacetimeECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultCarplayFacetimeECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "CarplayFacetimeECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultCarplayFacetimeECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "CarplayFacetimeECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultCarplayFacetimeECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CarplayFacetimeECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element CarplayFacetimeECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AAVoiceECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultAAVoiceECNRWBS::dp_tclDefaultAAVoiceECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultAAVoiceECNRWBS::s32SetData( tU8* tAAVoiceECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("AAVoiceECNRWBS", (tS32)0x753ad0ac);
   (tVoid)myDpElem.bFillData((tVoid*)tAAVoiceECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultAAVoiceECNRWBS::s32GetData(tU8* tAAVoiceECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("AAVoiceECNRWBS", (tS32)0x753ad0ac);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tAAVoiceECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultAAVoiceECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultAAVoiceECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultAAVoiceECNRWBS::u16GetData(tU8* tAAVoiceECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tAAVoiceECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultAAVoiceECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "AAVoiceECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultAAVoiceECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "AAVoiceECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultAAVoiceECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AAVoiceECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element AAVoiceECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BluetoothSiriECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultBluetoothSiriECNRWBS::dp_tclDefaultBluetoothSiriECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultBluetoothSiriECNRWBS::s32SetData( tU8* tBluetoothSiriECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BluetoothSiriECNRWBS", (tS32)0x4e9bc125);
   (tVoid)myDpElem.bFillData((tVoid*)tBluetoothSiriECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultBluetoothSiriECNRWBS::s32GetData(tU8* tBluetoothSiriECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BluetoothSiriECNRWBS", (tS32)0x4e9bc125);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBluetoothSiriECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultBluetoothSiriECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultBluetoothSiriECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultBluetoothSiriECNRWBS::u16GetData(tU8* tBluetoothSiriECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBluetoothSiriECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultBluetoothSiriECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothSiriECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultBluetoothSiriECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothSiriECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultBluetoothSiriECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BluetoothSiriECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element BluetoothSiriECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BluetoothVoiceECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultBluetoothVoiceECNRWBS::dp_tclDefaultBluetoothVoiceECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultBluetoothVoiceECNRWBS::s32SetData( tU8* tBluetoothVoiceECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BluetoothVoiceECNRWBS", (tS32)0x943a1794);
   (tVoid)myDpElem.bFillData((tVoid*)tBluetoothVoiceECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultBluetoothVoiceECNRWBS::s32GetData(tU8* tBluetoothVoiceECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BluetoothVoiceECNRWBS", (tS32)0x943a1794);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBluetoothVoiceECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultBluetoothVoiceECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultBluetoothVoiceECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultBluetoothVoiceECNRWBS::u16GetData(tU8* tBluetoothVoiceECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBluetoothVoiceECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultBluetoothVoiceECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothVoiceECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultBluetoothVoiceECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothVoiceECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultBluetoothVoiceECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BluetoothVoiceECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element BluetoothVoiceECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BluetoothVoiceECNRNBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultBluetoothVoiceECNRNBS::dp_tclDefaultBluetoothVoiceECNRNBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultBluetoothVoiceECNRNBS::s32SetData( tU8* tBluetoothVoiceECNRNBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BluetoothVoiceECNRNBS", (tS32)0x943a16b3);
   (tVoid)myDpElem.bFillData((tVoid*)tBluetoothVoiceECNRNBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultBluetoothVoiceECNRNBS::s32GetData(tU8* tBluetoothVoiceECNRNBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BluetoothVoiceECNRNBS", (tS32)0x943a16b3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBluetoothVoiceECNRNBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultBluetoothVoiceECNRNBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultBluetoothVoiceECNRNBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultBluetoothVoiceECNRNBS::u16GetData(tU8* tBluetoothVoiceECNRNBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBluetoothVoiceECNRNBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultBluetoothVoiceECNRNBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothVoiceECNRNBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultBluetoothVoiceECNRNBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "BluetoothVoiceECNRNBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultBluetoothVoiceECNRNBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BluetoothVoiceECNRNBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element BluetoothVoiceECNRNBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CarplaySiriECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultCarplaySiriECNRWBS::dp_tclDefaultCarplaySiriECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultCarplaySiriECNRWBS::s32SetData( tU8* tCarplaySiriECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("CarplaySiriECNRWBS", (tS32)0xbcc0931b);
   (tVoid)myDpElem.bFillData((tVoid*)tCarplaySiriECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultCarplaySiriECNRWBS::s32GetData(tU8* tCarplaySiriECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("CarplaySiriECNRWBS", (tS32)0xbcc0931b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tCarplaySiriECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultCarplaySiriECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultCarplaySiriECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultCarplaySiriECNRWBS::u16GetData(tU8* tCarplaySiriECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tCarplaySiriECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultCarplaySiriECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "CarplaySiriECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultCarplaySiriECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "CarplaySiriECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultCarplaySiriECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CarplaySiriECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element CarplaySiriECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "INTVoiceECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultINTVoiceECNRWBS::dp_tclDefaultINTVoiceECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultINTVoiceECNRWBS::s32SetData( tU8* tINTVoiceECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("INTVoiceECNRWBS", (tS32)0xf8d5feb1);
   (tVoid)myDpElem.bFillData((tVoid*)tINTVoiceECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultINTVoiceECNRWBS::s32GetData(tU8* tINTVoiceECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("INTVoiceECNRWBS", (tS32)0xf8d5feb1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tINTVoiceECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultINTVoiceECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultINTVoiceECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultINTVoiceECNRWBS::u16GetData(tU8* tINTVoiceECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tINTVoiceECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultINTVoiceECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "INTVoiceECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultINTVoiceECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "INTVoiceECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultINTVoiceECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: INTVoiceECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element INTVoiceECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VPAVoiceECNRWBS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDefaultVPAVoiceECNRWBS::dp_tclDefaultVPAVoiceECNRWBS(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDefaultVPAVoiceECNRWBS::s32SetData( tU8* tVPAVoiceECNRWBSParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("VPAVoiceECNRWBS", (tS32)0xef3dbaad);
   (tVoid)myDpElem.bFillData((tVoid*)tVPAVoiceECNRWBSParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDefaultVPAVoiceECNRWBS::s32GetData(tU8* tVPAVoiceECNRWBSParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("VPAVoiceECNRWBS", (tS32)0xef3dbaad);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DEFAULT, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tVPAVoiceECNRWBSParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDefaultVPAVoiceECNRWBS::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDefaultVPAVoiceECNRWBS::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDefaultVPAVoiceECNRWBS::u16GetData(tU8* tVPAVoiceECNRWBSParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tVPAVoiceECNRWBSParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDefaultVPAVoiceECNRWBS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DEFAULT, "VPAVoiceECNRWBS", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDefaultVPAVoiceECNRWBS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DEFAULT, "VPAVoiceECNRWBS", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDefaultVPAVoiceECNRWBS::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VPAVoiceECNRWBS", DP_U32_POOL_ID_DEFAULT);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DEFAULT);
		}
		else
		{
			fprintf(stdout,"Element VPAVoiceECNRWBS has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

