
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppDiag_CMC.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DTCConfiguration"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppDiag_CMCDTCConfiguration::dp_tclAppDiag_CMCDTCConfiguration(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAppDiag_CMCDTCConfiguration::s32SetData( tU8* tDTCConfigurationParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DTCConfiguration", (tS32)0xf62f9593);
   (tVoid)myDpElem.bFillData((tVoid*)tDTCConfigurationParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPDIAG_CMC, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAppDiag_CMCDTCConfiguration::s32GetData(tU8* tDTCConfigurationParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DTCConfiguration", (tS32)0xf62f9593);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPDIAG_CMC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDTCConfigurationParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAppDiag_CMCDTCConfiguration::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAppDiag_CMCDTCConfiguration::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAppDiag_CMCDTCConfiguration::u16GetData(tU8* tDTCConfigurationParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDTCConfigurationParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAppDiag_CMCDTCConfiguration::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_APPDIAG_CMC, "DTCConfiguration", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppDiag_CMCDTCConfiguration::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_APPDIAG_CMC, "DTCConfiguration", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAppDiag_CMCDTCConfiguration::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DTCConfiguration", DP_U32_POOL_ID_APPDIAG_CMC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_APPDIAG_CMC);
		}
		else
		{
			fprintf(stdout,"Element DTCConfiguration has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

