/*
 * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
 *               The reproduction, distribution and utilization of this file as well as the
 *               communication of its contents to others without express authorization is prohibited.
 *               Offenders will be held liable for the payment of damages.
 *               All rights reserved in the event of the grant of a patent, utility model or design.
 * @brief        generated file, which includes the function bSetInitCallbackCore(). 
 *               This function would be called by the core datapool, if the callback pointer not set by the process. 
 *               --If the product shared_datapool is build, the file dpBaseCoreFi_gen.cpp is used. 
 *                 For all pools which aren't not defined with dpfi="app" this file includes the function call
 *                 to set the initialization callbacks.
 *               --If the product dp_core is build, the file dpBaseCore_gen.cpp is used. 
 *                 The process, which has defined the pool with dpfi="app" should call the function
 *                 bSetInitCallbackCore() at startup of the process!!!
 * @addtogroup   Datapool 
 * @{
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
  
#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_TRACE_CLASS
#include "trcGenProj/Header/dpBaseCore_gen.cpp.trc.h"
#endif

extern tVoid vInitDpEndUserMode(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDpInternData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);


tBool dp_tclDpBase::bSetInitCallbackCore(tU32 u32PoolId) 
{
  tBool VbReturn=TRUE;
    switch (u32PoolId) 
    {
        case DP_U32_POOL_ID_DPENDUSERMODE:
            vAddInitCallbacktoList(vInitDpEndUserMode,DP_U32_POOL_ID_DPENDUSERMODE);
        break;
        case DP_U32_POOL_ID_DPINTERNDATA:
            vAddInitCallbacktoList(vInitDpInternData,DP_U32_POOL_ID_DPINTERNDATA);
        break;

        default:
        {   
          tU32 u32CCAId=(u32PoolId>>16)&0xffff;
          ETG_TRACE_FATAL(("!!!!! dp_tclDpBase::bSetInitCallbackCore: Init callpack pointer for pool 0x%x not set. Please call the function vSetInitCallback_%x at start of the process",u32PoolId,u32CCAId));
          ETG_TRACE_ERRMEM(("!!!!! dp_tclDpBase::bSetInitCallbackCore: Init callpack pointer for pool 0x%x not set. Please call the function vSetInitCallback_%x at start of the process",u32PoolId,u32CCAId));
          NORMAL_M_ASSERT_ALWAYS();
          VbReturn=FALSE;
        }
    }
    return(VbReturn);
}
