/*
 * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
 *               The reproduction, distribution and utilization of this file as well as the
 *               communication of its contents to others without express authorization is prohibited.
 *               Offenders will be held liable for the payment of damages.
 *               All rights reserved in the event of the grant of a patent, utility model or design.
 * @brief        generated file, which includes the function bSetInitCallbackCore(). 
 *               This function would be called by the core datapool, if the callback pointer not set by the process. 
 *               --If the product shared_datapool is build, the file dpBaseCoreFi_gen.cpp is used. 
 *                 For all pools which aren't not defined with dpfi="app" this file includes the function call
 *                 to set the initialization callbacks.
 *               --If the product dp_core is build, the file dpBaseCore_gen.cpp is used. 
 *                 The process, which has defined the pool with dpfi="app" should call the function
 *                 bSetInitCallbackCore() at startup of the process!!!
 * @addtogroup   Datapool 
 * @{
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_TRACE_CLASS
#include "trcGenProj/Header/dpBaseCoreFi_gen.cpp.trc.h"
#endif

extern tVoid vInitVehFuncPDD(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitVehDataProfile(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitVehData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitVehFunc(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitfc_sds_adapter_SpeechSettings(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitFCMcanTcuDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitFCUsbTcuDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitFCDumm(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitArkamysDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEngineSoundDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_AID_AUDIO_SRC_OFFSET(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPAID_DatasetEcnr(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMD_AlignmentData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMD_CMVariantCoding(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_PNM_DATA_SYNC_WITH_NVM(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPAID_DatasetProject(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDpPddKernel(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitFcSxmDPUser(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitFcSxmDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpmDpEngData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpmDpPowOn(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpmDpEngState(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpmDpFeature(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpmDpInternData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpmDpThread(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpmDpConfig(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpmDpRnAivi(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitdevicemanagerDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitHeatCtrlDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitThmDpPDD(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitCMRDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitVDClockDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDABTunerDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDABTunerUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitVehFuncProfile(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitmeterDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDispUsrProfileDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEarlyConfigCSC(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEarlyConfigDisplay(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEarlyConfigRTCDriver(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEarlyConfigTouchDriver(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEarlyConfigTwoDisplays(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEarlyConfigTwoTouchDriver(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDimmingDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDimmingDpPDD(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEarlyConfigLayerManager(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_VD_EARLY_CONFIG(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_VD_EARLY_FORCE_CONFIG(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitfc_sds_adapter(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppHmi_Master(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppHmi_Tuner(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppHmi_Navigation(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppHmi_Media(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppHmi_Phone(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppHmi_SPI(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppHmi_Sxm(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppHmi_System(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAuxiliaryDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitInputDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitprofileMngrPIVI(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitprofileMngr(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitParkasDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitprofileData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEngineSoundSettingsDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAudioManagerUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAudioManagerDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitTmcTunerUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitTmcTunerDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_AID_AIVI_REPROGRAMMING(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_DEF_ECNR_CP_FACETIME_SWB(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_DEF_ECNR_CP_PHONE_NB(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_DEF_ECNR_CP_PHONE_WB(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_DEF_ECNR_PHONE_NB(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDATASET_DEF_ECNR_PHONE_WB(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMD_temperatureHistograms(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_TesterIdentification(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAppDiag_CMC(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_CISConfiguration(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_AVDECCConfiguration(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_RunTimeSourceAM(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_RunTimeSourceFM(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_RunTimeSourceSXM(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_RunTimeSourceWX(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_RunTimeSourceDAB(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_RunTimeSourcePassengerMapOut(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDPCMC_RunTimeSourceRouteGuidance(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitSpiDpInternalData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInittestPool(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitConfigManagerDatapoolData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitConfigManagerLocalData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitFC_STCDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAudioStackUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAudioStackDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAudioStackMultiUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitAudioStackMultiDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitCsmEarlyNorConfig(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitCsmDpPDD(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDpEndUserMode(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDpInternData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitmediaplayerDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitEMP_LH(tU8 u8Bank=DP_U8_NO_BANK_ACTION);
extern tVoid vInitDefault(tU8 u8Bank=DP_U8_NO_BANK_ACTION);


tBool dp_tclDpBase::bSetInitCallbackCore(tU32 u32PoolId) 
{
    tBool VbReturn=TRUE;
    switch (u32PoolId) 
    {
        case DP_U32_POOL_ID_VEHFUNCPDD:
            vAddInitCallbacktoList(vInitVehFuncPDD,DP_U32_POOL_ID_VEHFUNCPDD);
        break;
        case DP_U32_POOL_ID_VEHDATAPROFILE:
            vAddInitCallbacktoList(vInitVehDataProfile,DP_U32_POOL_ID_VEHDATAPROFILE);
        break;
        case DP_U32_POOL_ID_VEHDATA:
            vAddInitCallbacktoList(vInitVehData,DP_U32_POOL_ID_VEHDATA);
        break;
        case DP_U32_POOL_ID_VEHFUNC:
            vAddInitCallbacktoList(vInitVehFunc,DP_U32_POOL_ID_VEHFUNC);
        break;
        case DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS:
            vAddInitCallbacktoList(vInitfc_sds_adapter_SpeechSettings,DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
        break;
        case DP_U32_POOL_ID_FCMCANTCUDP:
            vAddInitCallbacktoList(vInitFCMcanTcuDp,DP_U32_POOL_ID_FCMCANTCUDP);
        break;
        case DP_U32_POOL_ID_FCUSBTCUDP:
            vAddInitCallbacktoList(vInitFCUsbTcuDp,DP_U32_POOL_ID_FCUSBTCUDP);
        break;
        case DP_U32_POOL_ID_FCDUMM:
            vAddInitCallbacktoList(vInitFCDumm,DP_U32_POOL_ID_FCDUMM);
        break;
        case DP_U32_POOL_ID_ARKAMYSDP:
            vAddInitCallbacktoList(vInitArkamysDP,DP_U32_POOL_ID_ARKAMYSDP);
        break;
        case DP_U32_POOL_ID_ENGINESOUNDDP:
            vAddInitCallbacktoList(vInitEngineSoundDP,DP_U32_POOL_ID_ENGINESOUNDDP);
        break;
        case DP_U32_POOL_ID_DATASET_AID_AUDIO_SRC_OFFSET:
            vAddInitCallbacktoList(vInitDATASET_AID_AUDIO_SRC_OFFSET,DP_U32_POOL_ID_DATASET_AID_AUDIO_SRC_OFFSET);
        break;
        case DP_U32_POOL_ID_DPAID_DATASETECNR:
            vAddInitCallbacktoList(vInitDPAID_DatasetEcnr,DP_U32_POOL_ID_DPAID_DATASETECNR);
        break;
        case DP_U32_POOL_ID_DPCMD_ALIGNMENTDATA:
            vAddInitCallbacktoList(vInitDPCMD_AlignmentData,DP_U32_POOL_ID_DPCMD_ALIGNMENTDATA);
        break;
        case DP_U32_POOL_ID_DPCMD_CMVARIANTCODING:
            vAddInitCallbacktoList(vInitDPCMD_CMVariantCoding,DP_U32_POOL_ID_DPCMD_CMVARIANTCODING);
        break;
        case DP_U32_POOL_ID_DPCMC_PNM_DATA_SYNC_WITH_NVM:
            vAddInitCallbacktoList(vInitDPCMC_PNM_DATA_SYNC_WITH_NVM,DP_U32_POOL_ID_DPCMC_PNM_DATA_SYNC_WITH_NVM);
        break;
        case DP_U32_POOL_ID_DPAID_DATASETPROJECT:
            vAddInitCallbacktoList(vInitDPAID_DatasetProject,DP_U32_POOL_ID_DPAID_DATASETPROJECT);
        break;
        case DP_U32_POOL_ID_DPPDDKERNEL:
            vAddInitCallbacktoList(vInitDpPddKernel,DP_U32_POOL_ID_DPPDDKERNEL);
        break;
        case DP_U32_POOL_ID_FCSXMDPUSER:
            vAddInitCallbacktoList(vInitFcSxmDPUser,DP_U32_POOL_ID_FCSXMDPUSER);
        break;
        case DP_U32_POOL_ID_FCSXMDP:
            vAddInitCallbacktoList(vInitFcSxmDP,DP_U32_POOL_ID_FCSXMDP);
        break;
        case DP_U32_POOL_ID_SPMDPENGDATA:
            vAddInitCallbacktoList(vInitSpmDpEngData,DP_U32_POOL_ID_SPMDPENGDATA);
        break;
        case DP_U32_POOL_ID_SPMDPPOWON:
            vAddInitCallbacktoList(vInitSpmDpPowOn,DP_U32_POOL_ID_SPMDPPOWON);
        break;
        case DP_U32_POOL_ID_SPMDPENGSTATE:
            vAddInitCallbacktoList(vInitSpmDpEngState,DP_U32_POOL_ID_SPMDPENGSTATE);
        break;
        case DP_U32_POOL_ID_SPMDPFEATURE:
            vAddInitCallbacktoList(vInitSpmDpFeature,DP_U32_POOL_ID_SPMDPFEATURE);
        break;
        case DP_U32_POOL_ID_SPMDPINTERNDATA:
            vAddInitCallbacktoList(vInitSpmDpInternData,DP_U32_POOL_ID_SPMDPINTERNDATA);
        break;
        case DP_U32_POOL_ID_SPMDPTHREAD:
            vAddInitCallbacktoList(vInitSpmDpThread,DP_U32_POOL_ID_SPMDPTHREAD);
        break;
        case DP_U32_POOL_ID_SPMDPCONFIG:
            vAddInitCallbacktoList(vInitSpmDpConfig,DP_U32_POOL_ID_SPMDPCONFIG);
        break;
        case DP_U32_POOL_ID_SPMDPRNAIVI:
            vAddInitCallbacktoList(vInitSpmDpRnAivi,DP_U32_POOL_ID_SPMDPRNAIVI);
        break;
        case DP_U32_POOL_ID_DEVICEMANAGERDP:
            vAddInitCallbacktoList(vInitdevicemanagerDP,DP_U32_POOL_ID_DEVICEMANAGERDP);
        break;
        case DP_U32_POOL_ID_HEATCTRLDP:
            vAddInitCallbacktoList(vInitHeatCtrlDP,DP_U32_POOL_ID_HEATCTRLDP);
        break;
        case DP_U32_POOL_ID_THMDPPDD:
            vAddInitCallbacktoList(vInitThmDpPDD,DP_U32_POOL_ID_THMDPPDD);
        break;
        case DP_U32_POOL_ID_CMRDP:
            vAddInitCallbacktoList(vInitCMRDp,DP_U32_POOL_ID_CMRDP);
        break;
        case DP_U32_POOL_ID_VDCLOCKDP:
            vAddInitCallbacktoList(vInitVDClockDp,DP_U32_POOL_ID_VDCLOCKDP);
        break;
        case DP_U32_POOL_ID_DABTUNERDP:
            vAddInitCallbacktoList(vInitDABTunerDP,DP_U32_POOL_ID_DABTUNERDP);
        break;
        case DP_U32_POOL_ID_DABTUNERUSRDP:
            vAddInitCallbacktoList(vInitDABTunerUsrDP,DP_U32_POOL_ID_DABTUNERUSRDP);
        break;
        case DP_U32_POOL_ID_VEHFUNCPROFILE:
            vAddInitCallbacktoList(vInitVehFuncProfile,DP_U32_POOL_ID_VEHFUNCPROFILE);
        break;
        case DP_U32_POOL_ID_METERDP:
            vAddInitCallbacktoList(vInitmeterDp,DP_U32_POOL_ID_METERDP);
        break;
        case DP_U32_POOL_ID_DISPUSRPROFILEDP:
            vAddInitCallbacktoList(vInitDispUsrProfileDP,DP_U32_POOL_ID_DISPUSRPROFILEDP);
        break;
        case DP_U32_POOL_ID_EARLYCONFIGCSC:
            vAddInitCallbacktoList(vInitEarlyConfigCSC,DP_U32_POOL_ID_EARLYCONFIGCSC);
        break;
        case DP_U32_POOL_ID_EARLYCONFIGDISPLAY:
            vAddInitCallbacktoList(vInitEarlyConfigDisplay,DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
        break;
        case DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER:
            vAddInitCallbacktoList(vInitEarlyConfigRTCDriver,DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER);
        break;
        case DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER:
            vAddInitCallbacktoList(vInitEarlyConfigTouchDriver,DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER);
        break;
        case DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS:
            vAddInitCallbacktoList(vInitEarlyConfigTwoDisplays,DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
        break;
        case DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER:
            vAddInitCallbacktoList(vInitEarlyConfigTwoTouchDriver,DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
        break;
        case DP_U32_POOL_ID_DIMMINGDP:
            vAddInitCallbacktoList(vInitDimmingDP,DP_U32_POOL_ID_DIMMINGDP);
        break;
        case DP_U32_POOL_ID_DIMMINGDPPDD:
            vAddInitCallbacktoList(vInitDimmingDpPDD,DP_U32_POOL_ID_DIMMINGDPPDD);
        break;
        case DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER:
            vAddInitCallbacktoList(vInitEarlyConfigLayerManager,DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER);
        break;
        case DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG:
            vAddInitCallbacktoList(vInitDATASET_VD_EARLY_CONFIG,DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG);
        break;
        case DP_U32_POOL_ID_DATASET_VD_EARLY_FORCE_CONFIG:
            vAddInitCallbacktoList(vInitDATASET_VD_EARLY_FORCE_CONFIG,DP_U32_POOL_ID_DATASET_VD_EARLY_FORCE_CONFIG);
        break;
        case DP_U32_POOL_ID_FC_SDS_ADAPTER:
            vAddInitCallbacktoList(vInitfc_sds_adapter,DP_U32_POOL_ID_FC_SDS_ADAPTER);
        break;
        case DP_U32_POOL_ID_APPHMI_MASTER:
            vAddInitCallbacktoList(vInitAppHmi_Master,DP_U32_POOL_ID_APPHMI_MASTER);
        break;
        case DP_U32_POOL_ID_APPHMI_TUNER:
            vAddInitCallbacktoList(vInitAppHmi_Tuner,DP_U32_POOL_ID_APPHMI_TUNER);
        break;
        case DP_U32_POOL_ID_APPHMI_NAVIGATION:
            vAddInitCallbacktoList(vInitAppHmi_Navigation,DP_U32_POOL_ID_APPHMI_NAVIGATION);
        break;
        case DP_U32_POOL_ID_APPHMI_MEDIA:
            vAddInitCallbacktoList(vInitAppHmi_Media,DP_U32_POOL_ID_APPHMI_MEDIA);
        break;
        case DP_U32_POOL_ID_APPHMI_PHONE:
            vAddInitCallbacktoList(vInitAppHmi_Phone,DP_U32_POOL_ID_APPHMI_PHONE);
        break;
        case DP_U32_POOL_ID_APPHMI_SPI:
            vAddInitCallbacktoList(vInitAppHmi_SPI,DP_U32_POOL_ID_APPHMI_SPI);
        break;
        case DP_U32_POOL_ID_APPHMI_SXM:
            vAddInitCallbacktoList(vInitAppHmi_Sxm,DP_U32_POOL_ID_APPHMI_SXM);
        break;
        case DP_U32_POOL_ID_APPHMI_SYSTEM:
            vAddInitCallbacktoList(vInitAppHmi_System,DP_U32_POOL_ID_APPHMI_SYSTEM);
        break;
        case DP_U32_POOL_ID_AUXILIARYDP:
            vAddInitCallbacktoList(vInitAuxiliaryDP,DP_U32_POOL_ID_AUXILIARYDP);
        break;
        case DP_U32_POOL_ID_INPUTDP:
            vAddInitCallbacktoList(vInitInputDP,DP_U32_POOL_ID_INPUTDP);
        break;
        case DP_U32_POOL_ID_PROFILEMNGRPIVI:
            vAddInitCallbacktoList(vInitprofileMngrPIVI,DP_U32_POOL_ID_PROFILEMNGRPIVI);
        break;
        case DP_U32_POOL_ID_PROFILEMNGR:
            vAddInitCallbacktoList(vInitprofileMngr,DP_U32_POOL_ID_PROFILEMNGR);
        break;
        case DP_U32_POOL_ID_PARKASDP:
            vAddInitCallbacktoList(vInitParkasDP,DP_U32_POOL_ID_PARKASDP);
        break;
        case DP_U32_POOL_ID_PROFILEDATA:
            vAddInitCallbacktoList(vInitprofileData,DP_U32_POOL_ID_PROFILEDATA);
        break;
        case DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP:
            vAddInitCallbacktoList(vInitEngineSoundSettingsDP,DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
        break;
        case DP_U32_POOL_ID_AUDIOMANAGERUSRDP:
            vAddInitCallbacktoList(vInitAudioManagerUsrDP,DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
        break;
        case DP_U32_POOL_ID_AUDIOMANAGERDP:
            vAddInitCallbacktoList(vInitAudioManagerDP,DP_U32_POOL_ID_AUDIOMANAGERDP);
        break;
        case DP_U32_POOL_ID_TMCTUNERUSRDP:
            vAddInitCallbacktoList(vInitTmcTunerUsrDP,DP_U32_POOL_ID_TMCTUNERUSRDP);
        break;
        case DP_U32_POOL_ID_TMCTUNERDP:
            vAddInitCallbacktoList(vInitTmcTunerDP,DP_U32_POOL_ID_TMCTUNERDP);
        break;
        case DP_U32_POOL_ID_DATASET_AID_AIVI_REPROGRAMMING:
            vAddInitCallbacktoList(vInitDATASET_AID_AIVI_REPROGRAMMING,DP_U32_POOL_ID_DATASET_AID_AIVI_REPROGRAMMING);
        break;
        case DP_U32_POOL_ID_DATASET_DEF_ECNR_CP_FACETIME_SWB:
            vAddInitCallbacktoList(vInitDATASET_DEF_ECNR_CP_FACETIME_SWB,DP_U32_POOL_ID_DATASET_DEF_ECNR_CP_FACETIME_SWB);
        break;
        case DP_U32_POOL_ID_DATASET_DEF_ECNR_CP_PHONE_NB:
            vAddInitCallbacktoList(vInitDATASET_DEF_ECNR_CP_PHONE_NB,DP_U32_POOL_ID_DATASET_DEF_ECNR_CP_PHONE_NB);
        break;
        case DP_U32_POOL_ID_DATASET_DEF_ECNR_CP_PHONE_WB:
            vAddInitCallbacktoList(vInitDATASET_DEF_ECNR_CP_PHONE_WB,DP_U32_POOL_ID_DATASET_DEF_ECNR_CP_PHONE_WB);
        break;
        case DP_U32_POOL_ID_DATASET_DEF_ECNR_PHONE_NB:
            vAddInitCallbacktoList(vInitDATASET_DEF_ECNR_PHONE_NB,DP_U32_POOL_ID_DATASET_DEF_ECNR_PHONE_NB);
        break;
        case DP_U32_POOL_ID_DATASET_DEF_ECNR_PHONE_WB:
            vAddInitCallbacktoList(vInitDATASET_DEF_ECNR_PHONE_WB,DP_U32_POOL_ID_DATASET_DEF_ECNR_PHONE_WB);
        break;
        case DP_U32_POOL_ID_DPCMD_TEMPERATUREHISTOGRAMS:
            vAddInitCallbacktoList(vInitDPCMD_temperatureHistograms,DP_U32_POOL_ID_DPCMD_TEMPERATUREHISTOGRAMS);
        break;
        case DP_U32_POOL_ID_DPCMC_TESTERIDENTIFICATION:
            vAddInitCallbacktoList(vInitDPCMC_TesterIdentification,DP_U32_POOL_ID_DPCMC_TESTERIDENTIFICATION);
        break;
        case DP_U32_POOL_ID_APPDIAG_CMC:
            vAddInitCallbacktoList(vInitAppDiag_CMC,DP_U32_POOL_ID_APPDIAG_CMC);
        break;
        case DP_U32_POOL_ID_DPCMC_CISCONFIGURATION:
            vAddInitCallbacktoList(vInitDPCMC_CISConfiguration,DP_U32_POOL_ID_DPCMC_CISCONFIGURATION);
        break;
        case DP_U32_POOL_ID_DPCMC_AVDECCCONFIGURATION:
            vAddInitCallbacktoList(vInitDPCMC_AVDECCConfiguration,DP_U32_POOL_ID_DPCMC_AVDECCCONFIGURATION);
        break;
        case DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEAM:
            vAddInitCallbacktoList(vInitDPCMC_RunTimeSourceAM,DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEAM);
        break;
        case DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEFM:
            vAddInitCallbacktoList(vInitDPCMC_RunTimeSourceFM,DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEFM);
        break;
        case DP_U32_POOL_ID_DPCMC_RUNTIMESOURCESXM:
            vAddInitCallbacktoList(vInitDPCMC_RunTimeSourceSXM,DP_U32_POOL_ID_DPCMC_RUNTIMESOURCESXM);
        break;
        case DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEWX:
            vAddInitCallbacktoList(vInitDPCMC_RunTimeSourceWX,DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEWX);
        break;
        case DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEDAB:
            vAddInitCallbacktoList(vInitDPCMC_RunTimeSourceDAB,DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEDAB);
        break;
        case DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEPASSENGERMAPOUT:
            vAddInitCallbacktoList(vInitDPCMC_RunTimeSourcePassengerMapOut,DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEPASSENGERMAPOUT);
        break;
        case DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEROUTEGUIDANCE:
            vAddInitCallbacktoList(vInitDPCMC_RunTimeSourceRouteGuidance,DP_U32_POOL_ID_DPCMC_RUNTIMESOURCEROUTEGUIDANCE);
        break;
        case DP_U32_POOL_ID_SPIDPINTERNALDATA:
            vAddInitCallbacktoList(vInitSpiDpInternalData,DP_U32_POOL_ID_SPIDPINTERNALDATA);
        break;
        case DP_U32_POOL_ID_TESTPOOL:
            vAddInitCallbacktoList(vInittestPool,DP_U32_POOL_ID_TESTPOOL);
        break;
        case DP_U32_POOL_ID_CONFIGMANAGERDATAPOOLDATA:
            vAddInitCallbacktoList(vInitConfigManagerDatapoolData,DP_U32_POOL_ID_CONFIGMANAGERDATAPOOLDATA);
        break;
        case DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA:
            vAddInitCallbacktoList(vInitConfigManagerLocalData,DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA);
        break;
        case DP_U32_POOL_ID_FC_STCDP:
            vAddInitCallbacktoList(vInitFC_STCDP,DP_U32_POOL_ID_FC_STCDP);
        break;
        case DP_U32_POOL_ID_AUDIOSTACKUSRDP:
            vAddInitCallbacktoList(vInitAudioStackUsrDP,DP_U32_POOL_ID_AUDIOSTACKUSRDP);
        break;
        case DP_U32_POOL_ID_AUDIOSTACKDP:
            vAddInitCallbacktoList(vInitAudioStackDP,DP_U32_POOL_ID_AUDIOSTACKDP);
        break;
        case DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP:
            vAddInitCallbacktoList(vInitAudioStackMultiUsrDP,DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
        break;
        case DP_U32_POOL_ID_AUDIOSTACKMULTIDP:
            vAddInitCallbacktoList(vInitAudioStackMultiDP,DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
        break;
        case DP_U32_POOL_ID_CSMEARLYNORCONFIG:
            vAddInitCallbacktoList(vInitCsmEarlyNorConfig,DP_U32_POOL_ID_CSMEARLYNORCONFIG);
        break;
        case DP_U32_POOL_ID_CSMDPPDD:
            vAddInitCallbacktoList(vInitCsmDpPDD,DP_U32_POOL_ID_CSMDPPDD);
        break;
        case DP_U32_POOL_ID_DPENDUSERMODE:
            vAddInitCallbacktoList(vInitDpEndUserMode,DP_U32_POOL_ID_DPENDUSERMODE);
        break;
        case DP_U32_POOL_ID_DPINTERNDATA:
            vAddInitCallbacktoList(vInitDpInternData,DP_U32_POOL_ID_DPINTERNDATA);
        break;
        case DP_U32_POOL_ID_MEDIAPLAYERDP:
            vAddInitCallbacktoList(vInitmediaplayerDP,DP_U32_POOL_ID_MEDIAPLAYERDP);
        break;
        case DP_U32_POOL_ID_EMP_LH:
            vAddInitCallbacktoList(vInitEMP_LH,DP_U32_POOL_ID_EMP_LH);
        break;
        case DP_U32_POOL_ID_DEFAULT:
            vAddInitCallbacktoList(vInitDefault,DP_U32_POOL_ID_DEFAULT);
        break;

        default:
        {     
          ETG_TRACE_FATAL(("!!!!! dp_tclDpBase::bSetInitCallbackCore:  Pool 0x%x unknown. Please download the new libshared_datapool_so.so too !!!!",(unsigned int)u32PoolId));
          ETG_TRACE_ERRMEM(("!!!!! dp_tclDpBase::bSetInitCallbackCore:  Pool 0x%x unknown. Please download the new libshared_datapool_so.so too !!!!",(unsigned int)u32PoolId));
          NORMAL_M_ASSERT_ALWAYS();
          VbReturn=FALSE;
        }break;
    }
    return(VbReturn);
}
