
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppHmi_System.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RVC_BrightnessValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SystemRVC_BrightnessValue::dp_tclAppHmi_SystemRVC_BrightnessValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRVC_BrightnessValue,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SystemRVC_BrightnessValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RVC_BrightnessValue",(tS32) 0x44395ed8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRVC_BrightnessValue = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SystemRVC_BrightnessValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RVC_BrightnessValue", (tS32)0x44395ed8);
   (tVoid)myDpElem.bFillData((tVoid*)&tRVC_BrightnessValue, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SystemRVC_BrightnessValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SystemRVC_BrightnessValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_SystemRVC_BrightnessValue::tGetData() {
   vUpdate();
   return tRVC_BrightnessValue;
};
tS32 dp_tclAppHmi_SystemRVC_BrightnessValue::s32GetData(tU8& tRVC_BrightnessValueParam) { 
   vUpdate();
   tRVC_BrightnessValueParam = tRVC_BrightnessValue;
   return _s32Status;
}
tS32 dp_tclAppHmi_SystemRVC_BrightnessValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RVC_BrightnessValue", (tS32)0x44395ed8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SystemRVC_BrightnessValue::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SystemRVC_BrightnessValue::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SystemRVC_BrightnessValue::s32SetData(tU8 &tRVC_BrightnessValueParam) {
   //init parameter
   (tVoid)memcpy(&tRVC_BrightnessValue,(tVoid*)&tRVC_BrightnessValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRVC_BrightnessValueParam' in function 'dp_tclAppHmi_SystemRVC_BrightnessValue::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_SystemRVC_BrightnessValue::s32SetData(const tU8 &tRVC_BrightnessValueParam) {
   //init parameter
   (tVoid)memcpy(&tRVC_BrightnessValue,(tVoid*)&tRVC_BrightnessValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRVC_BrightnessValueParam' in function 'dp_tclAppHmi_SystemRVC_BrightnessValue::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SystemRVC_BrightnessValue::u8GetData(tU8& tRVC_BrightnessValueParam) {  
   vUpdate();
   tRVC_BrightnessValueParam = tRVC_BrightnessValue;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SystemRVC_BrightnessValue::vSetData(tU8 &tRVC_BrightnessValueParam) { 
   //init parameter
   (tVoid)memcpy(&tRVC_BrightnessValue,(tVoid*)&tRVC_BrightnessValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRVC_BrightnessValueParam' in function 'dp_tclAppHmi_SystemRVC_BrightnessValue::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_SystemRVC_BrightnessValue::vSetData(const tU8 &tRVC_BrightnessValueParam) { 
   //init parameter
   (tVoid)memcpy(&tRVC_BrightnessValue,(tVoid*)&tRVC_BrightnessValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRVC_BrightnessValueParam' in function 'dp_tclAppHmi_SystemRVC_BrightnessValue::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_SystemRVC_BrightnessValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SystemRVC_BrightnessValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SYSTEM, "RVC_BrightnessValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SystemRVC_BrightnessValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SYSTEM, "RVC_BrightnessValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SystemRVC_BrightnessValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RVC_BrightnessValue", DP_U32_POOL_ID_APPHMI_SYSTEM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SYSTEM);
   }
   else
   {
      fprintf(stdout,"Element RVC_BrightnessValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RVC_ContrastValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SystemRVC_ContrastValue::dp_tclAppHmi_SystemRVC_ContrastValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRVC_ContrastValue,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SystemRVC_ContrastValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RVC_ContrastValue",(tS32) 0xe42a0519);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRVC_ContrastValue = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SystemRVC_ContrastValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RVC_ContrastValue", (tS32)0xe42a0519);
   (tVoid)myDpElem.bFillData((tVoid*)&tRVC_ContrastValue, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SystemRVC_ContrastValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SystemRVC_ContrastValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_SystemRVC_ContrastValue::tGetData() {
   vUpdate();
   return tRVC_ContrastValue;
};
tS32 dp_tclAppHmi_SystemRVC_ContrastValue::s32GetData(tU8& tRVC_ContrastValueParam) { 
   vUpdate();
   tRVC_ContrastValueParam = tRVC_ContrastValue;
   return _s32Status;
}
tS32 dp_tclAppHmi_SystemRVC_ContrastValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RVC_ContrastValue", (tS32)0xe42a0519);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SystemRVC_ContrastValue::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SystemRVC_ContrastValue::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SystemRVC_ContrastValue::s32SetData(tU8 &tRVC_ContrastValueParam) {
   //init parameter
   (tVoid)memcpy(&tRVC_ContrastValue,(tVoid*)&tRVC_ContrastValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRVC_ContrastValueParam' in function 'dp_tclAppHmi_SystemRVC_ContrastValue::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_SystemRVC_ContrastValue::s32SetData(const tU8 &tRVC_ContrastValueParam) {
   //init parameter
   (tVoid)memcpy(&tRVC_ContrastValue,(tVoid*)&tRVC_ContrastValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRVC_ContrastValueParam' in function 'dp_tclAppHmi_SystemRVC_ContrastValue::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SystemRVC_ContrastValue::u8GetData(tU8& tRVC_ContrastValueParam) {  
   vUpdate();
   tRVC_ContrastValueParam = tRVC_ContrastValue;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SystemRVC_ContrastValue::vSetData(tU8 &tRVC_ContrastValueParam) { 
   //init parameter
   (tVoid)memcpy(&tRVC_ContrastValue,(tVoid*)&tRVC_ContrastValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRVC_ContrastValueParam' in function 'dp_tclAppHmi_SystemRVC_ContrastValue::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_SystemRVC_ContrastValue::vSetData(const tU8 &tRVC_ContrastValueParam) { 
   //init parameter
   (tVoid)memcpy(&tRVC_ContrastValue,(tVoid*)&tRVC_ContrastValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRVC_ContrastValueParam' in function 'dp_tclAppHmi_SystemRVC_ContrastValue::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_SystemRVC_ContrastValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SystemRVC_ContrastValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SYSTEM, "RVC_ContrastValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SystemRVC_ContrastValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SYSTEM, "RVC_ContrastValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SystemRVC_ContrastValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RVC_ContrastValue", DP_U32_POOL_ID_APPHMI_SYSTEM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SYSTEM);
   }
   else
   {
      fprintf(stdout,"Element RVC_ContrastValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CAA_MicBeepVolValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SystemCAA_MicBeepVolValue::dp_tclAppHmi_SystemCAA_MicBeepVolValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCAA_MicBeepVolValue,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SystemCAA_MicBeepVolValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CAA_MicBeepVolValue",(tS32) 0x7c2f8517);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCAA_MicBeepVolValue = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SystemCAA_MicBeepVolValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CAA_MicBeepVolValue", (tS32)0x7c2f8517);
   (tVoid)myDpElem.bFillData((tVoid*)&tCAA_MicBeepVolValue, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SystemCAA_MicBeepVolValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SystemCAA_MicBeepVolValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_SystemCAA_MicBeepVolValue::tGetData() {
   vUpdate();
   return tCAA_MicBeepVolValue;
};
tS32 dp_tclAppHmi_SystemCAA_MicBeepVolValue::s32GetData(tU8& tCAA_MicBeepVolValueParam) { 
   vUpdate();
   tCAA_MicBeepVolValueParam = tCAA_MicBeepVolValue;
   return _s32Status;
}
tS32 dp_tclAppHmi_SystemCAA_MicBeepVolValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CAA_MicBeepVolValue", (tS32)0x7c2f8517);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SystemCAA_MicBeepVolValue::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SystemCAA_MicBeepVolValue::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SystemCAA_MicBeepVolValue::s32SetData(tU8 &tCAA_MicBeepVolValueParam) {
   //init parameter
   (tVoid)memcpy(&tCAA_MicBeepVolValue,(tVoid*)&tCAA_MicBeepVolValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCAA_MicBeepVolValueParam' in function 'dp_tclAppHmi_SystemCAA_MicBeepVolValue::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_SystemCAA_MicBeepVolValue::s32SetData(const tU8 &tCAA_MicBeepVolValueParam) {
   //init parameter
   (tVoid)memcpy(&tCAA_MicBeepVolValue,(tVoid*)&tCAA_MicBeepVolValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCAA_MicBeepVolValueParam' in function 'dp_tclAppHmi_SystemCAA_MicBeepVolValue::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SystemCAA_MicBeepVolValue::u8GetData(tU8& tCAA_MicBeepVolValueParam) {  
   vUpdate();
   tCAA_MicBeepVolValueParam = tCAA_MicBeepVolValue;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SystemCAA_MicBeepVolValue::vSetData(tU8 &tCAA_MicBeepVolValueParam) { 
   //init parameter
   (tVoid)memcpy(&tCAA_MicBeepVolValue,(tVoid*)&tCAA_MicBeepVolValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCAA_MicBeepVolValueParam' in function 'dp_tclAppHmi_SystemCAA_MicBeepVolValue::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_SystemCAA_MicBeepVolValue::vSetData(const tU8 &tCAA_MicBeepVolValueParam) { 
   //init parameter
   (tVoid)memcpy(&tCAA_MicBeepVolValue,(tVoid*)&tCAA_MicBeepVolValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCAA_MicBeepVolValueParam' in function 'dp_tclAppHmi_SystemCAA_MicBeepVolValue::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_SystemCAA_MicBeepVolValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SystemCAA_MicBeepVolValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SYSTEM, "CAA_MicBeepVolValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SystemCAA_MicBeepVolValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SYSTEM, "CAA_MicBeepVolValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SystemCAA_MicBeepVolValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CAA_MicBeepVolValue", DP_U32_POOL_ID_APPHMI_SYSTEM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SYSTEM);
   }
   else
   {
      fprintf(stdout,"Element CAA_MicBeepVolValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SWUpdateTypeValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SystemSWUpdateTypeValue::dp_tclAppHmi_SystemSWUpdateTypeValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSWUpdateTypeValue,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SystemSWUpdateTypeValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SWUpdateTypeValue",(tS32) 0xa7ff3898);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSWUpdateTypeValue = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SystemSWUpdateTypeValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SWUpdateTypeValue", (tS32)0xa7ff3898);
   (tVoid)myDpElem.bFillData((tVoid*)&tSWUpdateTypeValue, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SystemSWUpdateTypeValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SystemSWUpdateTypeValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_SystemSWUpdateTypeValue::tGetData() {
   vUpdate();
   return tSWUpdateTypeValue;
};
tS32 dp_tclAppHmi_SystemSWUpdateTypeValue::s32GetData(tU8& tSWUpdateTypeValueParam) { 
   vUpdate();
   tSWUpdateTypeValueParam = tSWUpdateTypeValue;
   return _s32Status;
}
tS32 dp_tclAppHmi_SystemSWUpdateTypeValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SWUpdateTypeValue", (tS32)0xa7ff3898);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SYSTEM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SystemSWUpdateTypeValue::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SystemSWUpdateTypeValue::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SystemSWUpdateTypeValue::s32SetData(tU8 &tSWUpdateTypeValueParam) {
   //init parameter
   (tVoid)memcpy(&tSWUpdateTypeValue,(tVoid*)&tSWUpdateTypeValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSWUpdateTypeValueParam' in function 'dp_tclAppHmi_SystemSWUpdateTypeValue::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_SystemSWUpdateTypeValue::s32SetData(const tU8 &tSWUpdateTypeValueParam) {
   //init parameter
   (tVoid)memcpy(&tSWUpdateTypeValue,(tVoid*)&tSWUpdateTypeValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSWUpdateTypeValueParam' in function 'dp_tclAppHmi_SystemSWUpdateTypeValue::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SystemSWUpdateTypeValue::u8GetData(tU8& tSWUpdateTypeValueParam) {  
   vUpdate();
   tSWUpdateTypeValueParam = tSWUpdateTypeValue;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SystemSWUpdateTypeValue::vSetData(tU8 &tSWUpdateTypeValueParam) { 
   //init parameter
   (tVoid)memcpy(&tSWUpdateTypeValue,(tVoid*)&tSWUpdateTypeValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSWUpdateTypeValueParam' in function 'dp_tclAppHmi_SystemSWUpdateTypeValue::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_SystemSWUpdateTypeValue::vSetData(const tU8 &tSWUpdateTypeValueParam) { 
   //init parameter
   (tVoid)memcpy(&tSWUpdateTypeValue,(tVoid*)&tSWUpdateTypeValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSWUpdateTypeValueParam' in function 'dp_tclAppHmi_SystemSWUpdateTypeValue::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_SystemSWUpdateTypeValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SystemSWUpdateTypeValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SYSTEM, "SWUpdateTypeValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SystemSWUpdateTypeValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SYSTEM, "SWUpdateTypeValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SystemSWUpdateTypeValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SWUpdateTypeValue", DP_U32_POOL_ID_APPHMI_SYSTEM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SYSTEM);
   }
   else
   {
      fprintf(stdout,"Element SWUpdateTypeValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
