
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclEngineSoundSettingsDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESESoundTypeEco"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESESoundTypeEco::dp_tclEngineSoundSettingsDPESESoundTypeEco(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESESoundTypeEco,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESESoundTypeEco::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESESoundTypeEco",(tS32) 0xd41b33d7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESESoundTypeEco = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESESoundTypeEco::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESESoundTypeEco", (tS32)0xd41b33d7);
   (tVoid)myDpElem.bFillData((tVoid*)&tESESoundTypeEco, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESESoundTypeEco::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESESoundTypeEco::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESESoundTypeEco::tGetData() {
   vUpdate();
   return tESESoundTypeEco;
};
tS32 dp_tclEngineSoundSettingsDPESESoundTypeEco::s32GetData(tU8& tESESoundTypeEcoParam) { 
   vUpdate();
   tESESoundTypeEcoParam = tESESoundTypeEco;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESESoundTypeEco::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESESoundTypeEco", (tS32)0xd41b33d7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypeEco::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESESoundTypeEco::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESESoundTypeEco::s32SetData(tU8 &tESESoundTypeEcoParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypeEco,(tVoid*)&tESESoundTypeEcoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypeEcoParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeEco::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESESoundTypeEco::s32SetData(const tU8 &tESESoundTypeEcoParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypeEco,(tVoid*)&tESESoundTypeEcoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypeEcoParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeEco::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESESoundTypeEco::u8GetData(tU8& tESESoundTypeEcoParam) {  
   vUpdate();
   tESESoundTypeEcoParam = tESESoundTypeEco;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypeEco::vSetData(tU8 &tESESoundTypeEcoParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypeEco,(tVoid*)&tESESoundTypeEcoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypeEcoParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeEco::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESESoundTypeEco::vSetData(const tU8 &tESESoundTypeEcoParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypeEco,(tVoid*)&tESESoundTypeEcoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypeEcoParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeEco::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESESoundTypeEco::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESESoundTypeEco::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypeEco", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypeEco::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypeEco", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypeEco::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESESoundTypeEco", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESESoundTypeEco has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESESoundTypeComfort"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESESoundTypeComfort::dp_tclEngineSoundSettingsDPESESoundTypeComfort(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESESoundTypeComfort,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESESoundTypeComfort::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESESoundTypeComfort",(tS32) 0xd669e2c2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESESoundTypeComfort = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESESoundTypeComfort::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESESoundTypeComfort", (tS32)0xd669e2c2);
   (tVoid)myDpElem.bFillData((tVoid*)&tESESoundTypeComfort, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESESoundTypeComfort::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESESoundTypeComfort::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESESoundTypeComfort::tGetData() {
   vUpdate();
   return tESESoundTypeComfort;
};
tS32 dp_tclEngineSoundSettingsDPESESoundTypeComfort::s32GetData(tU8& tESESoundTypeComfortParam) { 
   vUpdate();
   tESESoundTypeComfortParam = tESESoundTypeComfort;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESESoundTypeComfort::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESESoundTypeComfort", (tS32)0xd669e2c2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypeComfort::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESESoundTypeComfort::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESESoundTypeComfort::s32SetData(tU8 &tESESoundTypeComfortParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypeComfort,(tVoid*)&tESESoundTypeComfortParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypeComfortParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeComfort::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESESoundTypeComfort::s32SetData(const tU8 &tESESoundTypeComfortParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypeComfort,(tVoid*)&tESESoundTypeComfortParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypeComfortParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeComfort::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESESoundTypeComfort::u8GetData(tU8& tESESoundTypeComfortParam) {  
   vUpdate();
   tESESoundTypeComfortParam = tESESoundTypeComfort;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypeComfort::vSetData(tU8 &tESESoundTypeComfortParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypeComfort,(tVoid*)&tESESoundTypeComfortParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypeComfortParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeComfort::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESESoundTypeComfort::vSetData(const tU8 &tESESoundTypeComfortParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypeComfort,(tVoid*)&tESESoundTypeComfortParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypeComfortParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeComfort::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESESoundTypeComfort::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESESoundTypeComfort::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypeComfort", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypeComfort::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypeComfort", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypeComfort::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESESoundTypeComfort", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESESoundTypeComfort has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESESoundTypeNormal"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESESoundTypeNormal::dp_tclEngineSoundSettingsDPESESoundTypeNormal(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESESoundTypeNormal,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESESoundTypeNormal::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESESoundTypeNormal",(tS32) 0x9148e991);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESESoundTypeNormal = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESESoundTypeNormal::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESESoundTypeNormal", (tS32)0x9148e991);
   (tVoid)myDpElem.bFillData((tVoid*)&tESESoundTypeNormal, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESESoundTypeNormal::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESESoundTypeNormal::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESESoundTypeNormal::tGetData() {
   vUpdate();
   return tESESoundTypeNormal;
};
tS32 dp_tclEngineSoundSettingsDPESESoundTypeNormal::s32GetData(tU8& tESESoundTypeNormalParam) { 
   vUpdate();
   tESESoundTypeNormalParam = tESESoundTypeNormal;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESESoundTypeNormal::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESESoundTypeNormal", (tS32)0x9148e991);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypeNormal::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESESoundTypeNormal::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESESoundTypeNormal::s32SetData(tU8 &tESESoundTypeNormalParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypeNormal,(tVoid*)&tESESoundTypeNormalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypeNormalParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeNormal::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESESoundTypeNormal::s32SetData(const tU8 &tESESoundTypeNormalParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypeNormal,(tVoid*)&tESESoundTypeNormalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypeNormalParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeNormal::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESESoundTypeNormal::u8GetData(tU8& tESESoundTypeNormalParam) {  
   vUpdate();
   tESESoundTypeNormalParam = tESESoundTypeNormal;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypeNormal::vSetData(tU8 &tESESoundTypeNormalParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypeNormal,(tVoid*)&tESESoundTypeNormalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypeNormalParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeNormal::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESESoundTypeNormal::vSetData(const tU8 &tESESoundTypeNormalParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypeNormal,(tVoid*)&tESESoundTypeNormalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypeNormalParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeNormal::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESESoundTypeNormal::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESESoundTypeNormal::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypeNormal", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypeNormal::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypeNormal", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypeNormal::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESESoundTypeNormal", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESESoundTypeNormal has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESESoundTypeDynamic"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESESoundTypeDynamic::dp_tclEngineSoundSettingsDPESESoundTypeDynamic(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESESoundTypeDynamic,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESESoundTypeDynamic::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESESoundTypeDynamic",(tS32) 0xd66a996d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESESoundTypeDynamic = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESESoundTypeDynamic::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESESoundTypeDynamic", (tS32)0xd66a996d);
   (tVoid)myDpElem.bFillData((tVoid*)&tESESoundTypeDynamic, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESESoundTypeDynamic::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESESoundTypeDynamic::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESESoundTypeDynamic::tGetData() {
   vUpdate();
   return tESESoundTypeDynamic;
};
tS32 dp_tclEngineSoundSettingsDPESESoundTypeDynamic::s32GetData(tU8& tESESoundTypeDynamicParam) { 
   vUpdate();
   tESESoundTypeDynamicParam = tESESoundTypeDynamic;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESESoundTypeDynamic::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESESoundTypeDynamic", (tS32)0xd66a996d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypeDynamic::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESESoundTypeDynamic::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESESoundTypeDynamic::s32SetData(tU8 &tESESoundTypeDynamicParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypeDynamic,(tVoid*)&tESESoundTypeDynamicParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypeDynamicParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeDynamic::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESESoundTypeDynamic::s32SetData(const tU8 &tESESoundTypeDynamicParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypeDynamic,(tVoid*)&tESESoundTypeDynamicParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypeDynamicParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeDynamic::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESESoundTypeDynamic::u8GetData(tU8& tESESoundTypeDynamicParam) {  
   vUpdate();
   tESESoundTypeDynamicParam = tESESoundTypeDynamic;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypeDynamic::vSetData(tU8 &tESESoundTypeDynamicParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypeDynamic,(tVoid*)&tESESoundTypeDynamicParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypeDynamicParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeDynamic::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESESoundTypeDynamic::vSetData(const tU8 &tESESoundTypeDynamicParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypeDynamic,(tVoid*)&tESESoundTypeDynamicParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypeDynamicParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypeDynamic::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESESoundTypeDynamic::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESESoundTypeDynamic::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypeDynamic", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypeDynamic::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypeDynamic", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypeDynamic::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESESoundTypeDynamic", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESESoundTypeDynamic has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESESoundTypePerso"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESESoundTypePerso::dp_tclEngineSoundSettingsDPESESoundTypePerso(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESESoundTypePerso,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESESoundTypePerso::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESESoundTypePerso",(tS32) 0xb6a82ecd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESESoundTypePerso = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESESoundTypePerso::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESESoundTypePerso", (tS32)0xb6a82ecd);
   (tVoid)myDpElem.bFillData((tVoid*)&tESESoundTypePerso, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESESoundTypePerso::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESESoundTypePerso::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESESoundTypePerso::tGetData() {
   vUpdate();
   return tESESoundTypePerso;
};
tS32 dp_tclEngineSoundSettingsDPESESoundTypePerso::s32GetData(tU8& tESESoundTypePersoParam) { 
   vUpdate();
   tESESoundTypePersoParam = tESESoundTypePerso;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESESoundTypePerso::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESESoundTypePerso", (tS32)0xb6a82ecd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypePerso::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESESoundTypePerso::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESESoundTypePerso::s32SetData(tU8 &tESESoundTypePersoParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypePerso,(tVoid*)&tESESoundTypePersoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypePersoParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypePerso::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESESoundTypePerso::s32SetData(const tU8 &tESESoundTypePersoParam) {
   //init parameter
   (tVoid)memcpy(&tESESoundTypePerso,(tVoid*)&tESESoundTypePersoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESESoundTypePersoParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypePerso::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESESoundTypePerso::u8GetData(tU8& tESESoundTypePersoParam) {  
   vUpdate();
   tESESoundTypePersoParam = tESESoundTypePerso;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESESoundTypePerso::vSetData(tU8 &tESESoundTypePersoParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypePerso,(tVoid*)&tESESoundTypePersoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypePersoParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypePerso::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESESoundTypePerso::vSetData(const tU8 &tESESoundTypePersoParam) { 
   //init parameter
   (tVoid)memcpy(&tESESoundTypePerso,(tVoid*)&tESESoundTypePersoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESESoundTypePersoParam' in function 'dp_tclEngineSoundSettingsDPESESoundTypePerso::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESESoundTypePerso::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESESoundTypePerso::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypePerso", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypePerso::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESESoundTypePerso", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESESoundTypePerso::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESESoundTypePerso", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESESoundTypePerso has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeEcoNeutral"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeEcoNeutral,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeEcoNeutral",(tS32) 0x1c32661f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeEcoNeutral = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeEcoNeutral", (tS32)0x1c32661f);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeEcoNeutral, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::tGetData() {
   vUpdate();
   return tESEVolumeEcoNeutral;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::s32GetData(tU8& tESEVolumeEcoNeutralParam) { 
   vUpdate();
   tESEVolumeEcoNeutralParam = tESEVolumeEcoNeutral;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeEcoNeutral", (tS32)0x1c32661f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::s32SetData(tU8 &tESEVolumeEcoNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoNeutral,(tVoid*)&tESEVolumeEcoNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeEcoNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::s32SetData(const tU8 &tESEVolumeEcoNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoNeutral,(tVoid*)&tESEVolumeEcoNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeEcoNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::u8GetData(tU8& tESEVolumeEcoNeutralParam) {  
   vUpdate();
   tESEVolumeEcoNeutralParam = tESEVolumeEcoNeutral;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::vSetData(tU8 &tESEVolumeEcoNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoNeutral,(tVoid*)&tESEVolumeEcoNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeEcoNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::vSetData(const tU8 &tESEVolumeEcoNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoNeutral,(tVoid*)&tESEVolumeEcoNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeEcoNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeEcoNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeEcoNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeEcoNeutral", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeEcoNeutral has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeEcoSound1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::dp_tclEngineSoundSettingsDPESEVolumeEcoSound1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeEcoSound1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeEcoSound1",(tS32) 0x6c0a68be);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeEcoSound1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeEcoSound1", (tS32)0x6c0a68be);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeEcoSound1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::tGetData() {
   vUpdate();
   return tESEVolumeEcoSound1;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::s32GetData(tU8& tESEVolumeEcoSound1Param) { 
   vUpdate();
   tESEVolumeEcoSound1Param = tESEVolumeEcoSound1;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeEcoSound1", (tS32)0x6c0a68be);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::s32SetData(tU8 &tESEVolumeEcoSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoSound1,(tVoid*)&tESEVolumeEcoSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeEcoSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::s32SetData(const tU8 &tESEVolumeEcoSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoSound1,(tVoid*)&tESEVolumeEcoSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeEcoSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::u8GetData(tU8& tESEVolumeEcoSound1Param) {  
   vUpdate();
   tESEVolumeEcoSound1Param = tESEVolumeEcoSound1;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::vSetData(tU8 &tESEVolumeEcoSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoSound1,(tVoid*)&tESEVolumeEcoSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeEcoSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::vSetData(const tU8 &tESEVolumeEcoSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoSound1,(tVoid*)&tESEVolumeEcoSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeEcoSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeEcoSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeEcoSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoSound1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeEcoSound1", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeEcoSound1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeEcoSound2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::dp_tclEngineSoundSettingsDPESEVolumeEcoSound2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeEcoSound2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeEcoSound2",(tS32) 0x6c0a68bf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeEcoSound2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeEcoSound2", (tS32)0x6c0a68bf);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeEcoSound2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::tGetData() {
   vUpdate();
   return tESEVolumeEcoSound2;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::s32GetData(tU8& tESEVolumeEcoSound2Param) { 
   vUpdate();
   tESEVolumeEcoSound2Param = tESEVolumeEcoSound2;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeEcoSound2", (tS32)0x6c0a68bf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::s32SetData(tU8 &tESEVolumeEcoSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoSound2,(tVoid*)&tESEVolumeEcoSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeEcoSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::s32SetData(const tU8 &tESEVolumeEcoSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoSound2,(tVoid*)&tESEVolumeEcoSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeEcoSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::u8GetData(tU8& tESEVolumeEcoSound2Param) {  
   vUpdate();
   tESEVolumeEcoSound2Param = tESEVolumeEcoSound2;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::vSetData(tU8 &tESEVolumeEcoSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoSound2,(tVoid*)&tESEVolumeEcoSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeEcoSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::vSetData(const tU8 &tESEVolumeEcoSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeEcoSound2,(tVoid*)&tESEVolumeEcoSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeEcoSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeEcoSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeEcoSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeEcoSound2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeEcoSound2", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeEcoSound2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeComfortNeutral"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeComfortNeutral,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeComfortNeutral",(tS32) 0xfd5c2bde);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeComfortNeutral = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeComfortNeutral", (tS32)0xfd5c2bde);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeComfortNeutral, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::tGetData() {
   vUpdate();
   return tESEVolumeComfortNeutral;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::s32GetData(tU8& tESEVolumeComfortNeutralParam) { 
   vUpdate();
   tESEVolumeComfortNeutralParam = tESEVolumeComfortNeutral;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeComfortNeutral", (tS32)0xfd5c2bde);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::s32SetData(tU8 &tESEVolumeComfortNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortNeutral,(tVoid*)&tESEVolumeComfortNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeComfortNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::s32SetData(const tU8 &tESEVolumeComfortNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortNeutral,(tVoid*)&tESEVolumeComfortNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeComfortNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::u8GetData(tU8& tESEVolumeComfortNeutralParam) {  
   vUpdate();
   tESEVolumeComfortNeutralParam = tESEVolumeComfortNeutral;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::vSetData(tU8 &tESEVolumeComfortNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortNeutral,(tVoid*)&tESEVolumeComfortNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeComfortNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::vSetData(const tU8 &tESEVolumeComfortNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortNeutral,(tVoid*)&tESEVolumeComfortNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeComfortNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeComfortNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeComfortNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeComfortNeutral", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeComfortNeutral has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeComfortSound1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::dp_tclEngineSoundSettingsDPESEVolumeComfortSound1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeComfortSound1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeComfortSound1",(tS32) 0xcc45f6b1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeComfortSound1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeComfortSound1", (tS32)0xcc45f6b1);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeComfortSound1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::tGetData() {
   vUpdate();
   return tESEVolumeComfortSound1;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::s32GetData(tU8& tESEVolumeComfortSound1Param) { 
   vUpdate();
   tESEVolumeComfortSound1Param = tESEVolumeComfortSound1;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeComfortSound1", (tS32)0xcc45f6b1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::s32SetData(tU8 &tESEVolumeComfortSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortSound1,(tVoid*)&tESEVolumeComfortSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeComfortSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::s32SetData(const tU8 &tESEVolumeComfortSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortSound1,(tVoid*)&tESEVolumeComfortSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeComfortSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::u8GetData(tU8& tESEVolumeComfortSound1Param) {  
   vUpdate();
   tESEVolumeComfortSound1Param = tESEVolumeComfortSound1;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::vSetData(tU8 &tESEVolumeComfortSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortSound1,(tVoid*)&tESEVolumeComfortSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeComfortSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::vSetData(const tU8 &tESEVolumeComfortSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortSound1,(tVoid*)&tESEVolumeComfortSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeComfortSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeComfortSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeComfortSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortSound1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeComfortSound1", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeComfortSound1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeComfortSound2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::dp_tclEngineSoundSettingsDPESEVolumeComfortSound2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeComfortSound2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeComfortSound2",(tS32) 0xcc45f6b2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeComfortSound2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeComfortSound2", (tS32)0xcc45f6b2);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeComfortSound2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::tGetData() {
   vUpdate();
   return tESEVolumeComfortSound2;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::s32GetData(tU8& tESEVolumeComfortSound2Param) { 
   vUpdate();
   tESEVolumeComfortSound2Param = tESEVolumeComfortSound2;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeComfortSound2", (tS32)0xcc45f6b2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::s32SetData(tU8 &tESEVolumeComfortSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortSound2,(tVoid*)&tESEVolumeComfortSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeComfortSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::s32SetData(const tU8 &tESEVolumeComfortSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortSound2,(tVoid*)&tESEVolumeComfortSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeComfortSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::u8GetData(tU8& tESEVolumeComfortSound2Param) {  
   vUpdate();
   tESEVolumeComfortSound2Param = tESEVolumeComfortSound2;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::vSetData(tU8 &tESEVolumeComfortSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortSound2,(tVoid*)&tESEVolumeComfortSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeComfortSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::vSetData(const tU8 &tESEVolumeComfortSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeComfortSound2,(tVoid*)&tESEVolumeComfortSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeComfortSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeComfortSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeComfortSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeComfortSound2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeComfortSound2", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeComfortSound2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeNormalNeutral"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeNormalNeutral,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeNormalNeutral",(tS32) 0x6faf168d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeNormalNeutral = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeNormalNeutral", (tS32)0x6faf168d);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeNormalNeutral, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::tGetData() {
   vUpdate();
   return tESEVolumeNormalNeutral;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::s32GetData(tU8& tESEVolumeNormalNeutralParam) { 
   vUpdate();
   tESEVolumeNormalNeutralParam = tESEVolumeNormalNeutral;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeNormalNeutral", (tS32)0x6faf168d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::s32SetData(tU8 &tESEVolumeNormalNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalNeutral,(tVoid*)&tESEVolumeNormalNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeNormalNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::s32SetData(const tU8 &tESEVolumeNormalNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalNeutral,(tVoid*)&tESEVolumeNormalNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeNormalNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::u8GetData(tU8& tESEVolumeNormalNeutralParam) {  
   vUpdate();
   tESEVolumeNormalNeutralParam = tESEVolumeNormalNeutral;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::vSetData(tU8 &tESEVolumeNormalNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalNeutral,(tVoid*)&tESEVolumeNormalNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeNormalNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::vSetData(const tU8 &tESEVolumeNormalNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalNeutral,(tVoid*)&tESEVolumeNormalNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeNormalNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeNormalNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeNormalNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeNormalNeutral", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeNormalNeutral has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeNormalSound1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::dp_tclEngineSoundSettingsDPESEVolumeNormalSound1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeNormalSound1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeNormalSound1",(tS32) 0xe32358d4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeNormalSound1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeNormalSound1", (tS32)0xe32358d4);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeNormalSound1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::tGetData() {
   vUpdate();
   return tESEVolumeNormalSound1;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::s32GetData(tU8& tESEVolumeNormalSound1Param) { 
   vUpdate();
   tESEVolumeNormalSound1Param = tESEVolumeNormalSound1;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeNormalSound1", (tS32)0xe32358d4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::s32SetData(tU8 &tESEVolumeNormalSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalSound1,(tVoid*)&tESEVolumeNormalSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeNormalSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::s32SetData(const tU8 &tESEVolumeNormalSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalSound1,(tVoid*)&tESEVolumeNormalSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeNormalSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::u8GetData(tU8& tESEVolumeNormalSound1Param) {  
   vUpdate();
   tESEVolumeNormalSound1Param = tESEVolumeNormalSound1;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::vSetData(tU8 &tESEVolumeNormalSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalSound1,(tVoid*)&tESEVolumeNormalSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeNormalSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::vSetData(const tU8 &tESEVolumeNormalSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalSound1,(tVoid*)&tESEVolumeNormalSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeNormalSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeNormalSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeNormalSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalSound1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeNormalSound1", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeNormalSound1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeNormalSound2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::dp_tclEngineSoundSettingsDPESEVolumeNormalSound2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeNormalSound2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeNormalSound2",(tS32) 0xe32358d5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeNormalSound2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeNormalSound2", (tS32)0xe32358d5);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeNormalSound2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::tGetData() {
   vUpdate();
   return tESEVolumeNormalSound2;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::s32GetData(tU8& tESEVolumeNormalSound2Param) { 
   vUpdate();
   tESEVolumeNormalSound2Param = tESEVolumeNormalSound2;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeNormalSound2", (tS32)0xe32358d5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::s32SetData(tU8 &tESEVolumeNormalSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalSound2,(tVoid*)&tESEVolumeNormalSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeNormalSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::s32SetData(const tU8 &tESEVolumeNormalSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalSound2,(tVoid*)&tESEVolumeNormalSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeNormalSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::u8GetData(tU8& tESEVolumeNormalSound2Param) {  
   vUpdate();
   tESEVolumeNormalSound2Param = tESEVolumeNormalSound2;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::vSetData(tU8 &tESEVolumeNormalSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalSound2,(tVoid*)&tESEVolumeNormalSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeNormalSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::vSetData(const tU8 &tESEVolumeNormalSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeNormalSound2,(tVoid*)&tESEVolumeNormalSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeNormalSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeNormalSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeNormalSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeNormalSound2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeNormalSound2", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeNormalSound2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeDynamicNeutral"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeDynamicNeutral,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeDynamicNeutral",(tS32) 0xd71e02ed);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeDynamicNeutral = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeDynamicNeutral", (tS32)0xd71e02ed);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeDynamicNeutral, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::tGetData() {
   vUpdate();
   return tESEVolumeDynamicNeutral;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::s32GetData(tU8& tESEVolumeDynamicNeutralParam) { 
   vUpdate();
   tESEVolumeDynamicNeutralParam = tESEVolumeDynamicNeutral;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeDynamicNeutral", (tS32)0xd71e02ed);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::s32SetData(tU8 &tESEVolumeDynamicNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicNeutral,(tVoid*)&tESEVolumeDynamicNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeDynamicNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::s32SetData(const tU8 &tESEVolumeDynamicNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicNeutral,(tVoid*)&tESEVolumeDynamicNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeDynamicNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::u8GetData(tU8& tESEVolumeDynamicNeutralParam) {  
   vUpdate();
   tESEVolumeDynamicNeutralParam = tESEVolumeDynamicNeutral;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::vSetData(tU8 &tESEVolumeDynamicNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicNeutral,(tVoid*)&tESEVolumeDynamicNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeDynamicNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::vSetData(const tU8 &tESEVolumeDynamicNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicNeutral,(tVoid*)&tESEVolumeDynamicNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeDynamicNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeDynamicNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeDynamicNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeDynamicNeutral", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeDynamicNeutral has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeDynamicSound1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeDynamicSound1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeDynamicSound1",(tS32) 0xf7d321b4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeDynamicSound1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeDynamicSound1", (tS32)0xf7d321b4);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeDynamicSound1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::tGetData() {
   vUpdate();
   return tESEVolumeDynamicSound1;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::s32GetData(tU8& tESEVolumeDynamicSound1Param) { 
   vUpdate();
   tESEVolumeDynamicSound1Param = tESEVolumeDynamicSound1;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeDynamicSound1", (tS32)0xf7d321b4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::s32SetData(tU8 &tESEVolumeDynamicSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicSound1,(tVoid*)&tESEVolumeDynamicSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeDynamicSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::s32SetData(const tU8 &tESEVolumeDynamicSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicSound1,(tVoid*)&tESEVolumeDynamicSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeDynamicSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::u8GetData(tU8& tESEVolumeDynamicSound1Param) {  
   vUpdate();
   tESEVolumeDynamicSound1Param = tESEVolumeDynamicSound1;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::vSetData(tU8 &tESEVolumeDynamicSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicSound1,(tVoid*)&tESEVolumeDynamicSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeDynamicSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::vSetData(const tU8 &tESEVolumeDynamicSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicSound1,(tVoid*)&tESEVolumeDynamicSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeDynamicSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeDynamicSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeDynamicSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeDynamicSound1", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeDynamicSound1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumeDynamicSound2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumeDynamicSound2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumeDynamicSound2",(tS32) 0xf7d321b5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumeDynamicSound2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumeDynamicSound2", (tS32)0xf7d321b5);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumeDynamicSound2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::tGetData() {
   vUpdate();
   return tESEVolumeDynamicSound2;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::s32GetData(tU8& tESEVolumeDynamicSound2Param) { 
   vUpdate();
   tESEVolumeDynamicSound2Param = tESEVolumeDynamicSound2;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumeDynamicSound2", (tS32)0xf7d321b5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::s32SetData(tU8 &tESEVolumeDynamicSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicSound2,(tVoid*)&tESEVolumeDynamicSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeDynamicSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::s32SetData(const tU8 &tESEVolumeDynamicSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicSound2,(tVoid*)&tESEVolumeDynamicSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumeDynamicSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::u8GetData(tU8& tESEVolumeDynamicSound2Param) {  
   vUpdate();
   tESEVolumeDynamicSound2Param = tESEVolumeDynamicSound2;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::vSetData(tU8 &tESEVolumeDynamicSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicSound2,(tVoid*)&tESEVolumeDynamicSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeDynamicSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::vSetData(const tU8 &tESEVolumeDynamicSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumeDynamicSound2,(tVoid*)&tESEVolumeDynamicSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumeDynamicSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeDynamicSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumeDynamicSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumeDynamicSound2", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumeDynamicSound2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumePersoNeutral"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::dp_tclEngineSoundSettingsDPESEVolumePersoNeutral(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumePersoNeutral,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumePersoNeutral",(tS32) 0xe3518ff5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumePersoNeutral = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumePersoNeutral", (tS32)0xe3518ff5);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumePersoNeutral, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::tGetData() {
   vUpdate();
   return tESEVolumePersoNeutral;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::s32GetData(tU8& tESEVolumePersoNeutralParam) { 
   vUpdate();
   tESEVolumePersoNeutralParam = tESEVolumePersoNeutral;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumePersoNeutral", (tS32)0xe3518ff5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::s32SetData(tU8 &tESEVolumePersoNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoNeutral,(tVoid*)&tESEVolumePersoNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumePersoNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::s32SetData(const tU8 &tESEVolumePersoNeutralParam) {
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoNeutral,(tVoid*)&tESEVolumePersoNeutralParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumePersoNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::u8GetData(tU8& tESEVolumePersoNeutralParam) {  
   vUpdate();
   tESEVolumePersoNeutralParam = tESEVolumePersoNeutral;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::vSetData(tU8 &tESEVolumePersoNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoNeutral,(tVoid*)&tESEVolumePersoNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumePersoNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::vSetData(const tU8 &tESEVolumePersoNeutralParam) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoNeutral,(tVoid*)&tESEVolumePersoNeutralParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumePersoNeutralParam' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumePersoNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumePersoNeutral", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumePersoNeutral::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumePersoNeutral", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumePersoNeutral has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumePersoSound1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumePersoSound1::dp_tclEngineSoundSettingsDPESEVolumePersoSound1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumePersoSound1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumePersoSound1",(tS32) 0x93dd711c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumePersoSound1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumePersoSound1", (tS32)0x93dd711c);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumePersoSound1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumePersoSound1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumePersoSound1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumePersoSound1::tGetData() {
   vUpdate();
   return tESEVolumePersoSound1;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoSound1::s32GetData(tU8& tESEVolumePersoSound1Param) { 
   vUpdate();
   tESEVolumePersoSound1Param = tESEVolumePersoSound1;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoSound1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumePersoSound1", (tS32)0x93dd711c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoSound1::s32SetData(tU8 &tESEVolumePersoSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoSound1,(tVoid*)&tESEVolumePersoSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumePersoSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoSound1::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoSound1::s32SetData(const tU8 &tESEVolumePersoSound1Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoSound1,(tVoid*)&tESEVolumePersoSound1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumePersoSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoSound1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumePersoSound1::u8GetData(tU8& tESEVolumePersoSound1Param) {  
   vUpdate();
   tESEVolumePersoSound1Param = tESEVolumePersoSound1;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound1::vSetData(tU8 &tESEVolumePersoSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoSound1,(tVoid*)&tESEVolumePersoSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumePersoSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoSound1::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound1::vSetData(const tU8 &tESEVolumePersoSound1Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoSound1,(tVoid*)&tESEVolumePersoSound1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumePersoSound1Param' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoSound1::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumePersoSound1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumePersoSound1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumePersoSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumePersoSound1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumePersoSound1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumePersoSound1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumePersoSound1", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumePersoSound1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEVolumePersoSound2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEVolumePersoSound2::dp_tclEngineSoundSettingsDPESEVolumePersoSound2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEVolumePersoSound2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEVolumePersoSound2",(tS32) 0x93dd711d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEVolumePersoSound2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEVolumePersoSound2", (tS32)0x93dd711d);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEVolumePersoSound2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEVolumePersoSound2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEVolumePersoSound2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEVolumePersoSound2::tGetData() {
   vUpdate();
   return tESEVolumePersoSound2;
};
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoSound2::s32GetData(tU8& tESEVolumePersoSound2Param) { 
   vUpdate();
   tESEVolumePersoSound2Param = tESEVolumePersoSound2;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoSound2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEVolumePersoSound2", (tS32)0x93dd711d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoSound2::s32SetData(tU8 &tESEVolumePersoSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoSound2,(tVoid*)&tESEVolumePersoSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumePersoSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoSound2::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEVolumePersoSound2::s32SetData(const tU8 &tESEVolumePersoSound2Param) {
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoSound2,(tVoid*)&tESEVolumePersoSound2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEVolumePersoSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoSound2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEVolumePersoSound2::u8GetData(tU8& tESEVolumePersoSound2Param) {  
   vUpdate();
   tESEVolumePersoSound2Param = tESEVolumePersoSound2;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound2::vSetData(tU8 &tESEVolumePersoSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoSound2,(tVoid*)&tESEVolumePersoSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumePersoSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoSound2::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEVolumePersoSound2::vSetData(const tU8 &tESEVolumePersoSound2Param) { 
   //init parameter
   (tVoid)memcpy(&tESEVolumePersoSound2,(tVoid*)&tESEVolumePersoSound2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEVolumePersoSound2Param' in function 'dp_tclEngineSoundSettingsDPESEVolumePersoSound2::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEVolumePersoSound2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEVolumePersoSound2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumePersoSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumePersoSound2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEVolumePersoSound2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEVolumePersoSound2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEVolumePersoSound2", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEVolumePersoSound2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ESEDriveMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPESEDriveMode::dp_tclEngineSoundSettingsDPESEDriveMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tESEDriveMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPESEDriveMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ESEDriveMode",(tS32) 0x3665cd0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tESEDriveMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPESEDriveMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ESEDriveMode", (tS32)0x3665cd0);
   (tVoid)myDpElem.bFillData((tVoid*)&tESEDriveMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPESEDriveMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPESEDriveMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPESEDriveMode::tGetData() {
   vUpdate();
   return tESEDriveMode;
};
tS32 dp_tclEngineSoundSettingsDPESEDriveMode::s32GetData(tU8& tESEDriveModeParam) { 
   vUpdate();
   tESEDriveModeParam = tESEDriveMode;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPESEDriveMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ESEDriveMode", (tS32)0x3665cd0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPESEDriveMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPESEDriveMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPESEDriveMode::s32SetData(tU8 &tESEDriveModeParam) {
   //init parameter
   (tVoid)memcpy(&tESEDriveMode,(tVoid*)&tESEDriveModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEDriveModeParam' in function 'dp_tclEngineSoundSettingsDPESEDriveMode::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPESEDriveMode::s32SetData(const tU8 &tESEDriveModeParam) {
   //init parameter
   (tVoid)memcpy(&tESEDriveMode,(tVoid*)&tESEDriveModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tESEDriveModeParam' in function 'dp_tclEngineSoundSettingsDPESEDriveMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPESEDriveMode::u8GetData(tU8& tESEDriveModeParam) {  
   vUpdate();
   tESEDriveModeParam = tESEDriveMode;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPESEDriveMode::vSetData(tU8 &tESEDriveModeParam) { 
   //init parameter
   (tVoid)memcpy(&tESEDriveMode,(tVoid*)&tESEDriveModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEDriveModeParam' in function 'dp_tclEngineSoundSettingsDPESEDriveMode::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPESEDriveMode::vSetData(const tU8 &tESEDriveModeParam) { 
   //init parameter
   (tVoid)memcpy(&tESEDriveMode,(tVoid*)&tESEDriveModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tESEDriveModeParam' in function 'dp_tclEngineSoundSettingsDPESEDriveMode::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPESEDriveMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPESEDriveMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEDriveMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEDriveMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "ESEDriveMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPESEDriveMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ESEDriveMode", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element ESEDriveMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RSoundOnOff"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPRSoundOnOff::dp_tclEngineSoundSettingsDPRSoundOnOff(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRSoundOnOff,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPRSoundOnOff::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RSoundOnOff",(tS32) 0x3ca5a0e3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tRSoundOnOff = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPRSoundOnOff::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RSoundOnOff", (tS32)0x3ca5a0e3);
   (tVoid)myDpElem.bFillData((tVoid*)&tRSoundOnOff, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPRSoundOnOff::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPRSoundOnOff::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclEngineSoundSettingsDPRSoundOnOff::tGetData() {
   vUpdate();
   return tRSoundOnOff;
};
tS32 dp_tclEngineSoundSettingsDPRSoundOnOff::s32GetData(tBool& tRSoundOnOffParam) { 
   vUpdate();
   tRSoundOnOffParam = tRSoundOnOff;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPRSoundOnOff::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RSoundOnOff", (tS32)0x3ca5a0e3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPRSoundOnOff::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPRSoundOnOff::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPRSoundOnOff::s32SetData(tBool &tRSoundOnOffParam) {
   //init parameter
   (tVoid)memcpy(&tRSoundOnOff,(tVoid*)&tRSoundOnOffParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRSoundOnOffParam' in function 'dp_tclEngineSoundSettingsDPRSoundOnOff::vSetData(tBool)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPRSoundOnOff::s32SetData(const tBool &tRSoundOnOffParam) {
   //init parameter
   (tVoid)memcpy(&tRSoundOnOff,(tVoid*)&tRSoundOnOffParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRSoundOnOffParam' in function 'dp_tclEngineSoundSettingsDPRSoundOnOff::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPRSoundOnOff::u8GetData(tBool& tRSoundOnOffParam) {  
   vUpdate();
   tRSoundOnOffParam = tRSoundOnOff;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPRSoundOnOff::vSetData(tBool &tRSoundOnOffParam) { 
   //init parameter
   (tVoid)memcpy(&tRSoundOnOff,(tVoid*)&tRSoundOnOffParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tRSoundOnOffParam' in function 'dp_tclEngineSoundSettingsDPRSoundOnOff::vSetData(tBool)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPRSoundOnOff::vSetData(const tBool &tRSoundOnOffParam) { 
   //init parameter
   (tVoid)memcpy(&tRSoundOnOff,(tVoid*)&tRSoundOnOffParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tRSoundOnOffParam' in function 'dp_tclEngineSoundSettingsDPRSoundOnOff::vSetData(tBool)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPRSoundOnOff::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPRSoundOnOff::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "RSoundOnOff", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPRSoundOnOff::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "RSoundOnOff", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPRSoundOnOff::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RSoundOnOff", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element RSoundOnOff has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RSoundType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPRSoundType::dp_tclEngineSoundSettingsDPRSoundType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRSoundType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPRSoundType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RSoundType",(tS32) 0xc212441);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRSoundType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPRSoundType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RSoundType", (tS32)0xc212441);
   (tVoid)myDpElem.bFillData((tVoid*)&tRSoundType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPRSoundType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPRSoundType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPRSoundType::tGetData() {
   vUpdate();
   return tRSoundType;
};
tS32 dp_tclEngineSoundSettingsDPRSoundType::s32GetData(tU8& tRSoundTypeParam) { 
   vUpdate();
   tRSoundTypeParam = tRSoundType;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPRSoundType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RSoundType", (tS32)0xc212441);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPRSoundType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPRSoundType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPRSoundType::s32SetData(tU8 &tRSoundTypeParam) {
   //init parameter
   (tVoid)memcpy(&tRSoundType,(tVoid*)&tRSoundTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRSoundTypeParam' in function 'dp_tclEngineSoundSettingsDPRSoundType::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPRSoundType::s32SetData(const tU8 &tRSoundTypeParam) {
   //init parameter
   (tVoid)memcpy(&tRSoundType,(tVoid*)&tRSoundTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRSoundTypeParam' in function 'dp_tclEngineSoundSettingsDPRSoundType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPRSoundType::u8GetData(tU8& tRSoundTypeParam) {  
   vUpdate();
   tRSoundTypeParam = tRSoundType;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPRSoundType::vSetData(tU8 &tRSoundTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tRSoundType,(tVoid*)&tRSoundTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRSoundTypeParam' in function 'dp_tclEngineSoundSettingsDPRSoundType::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPRSoundType::vSetData(const tU8 &tRSoundTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tRSoundType,(tVoid*)&tRSoundTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRSoundTypeParam' in function 'dp_tclEngineSoundSettingsDPRSoundType::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPRSoundType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPRSoundType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "RSoundType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPRSoundType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "RSoundType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPRSoundType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RSoundType", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element RSoundType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RSoundVolume"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPRSoundVolume::dp_tclEngineSoundSettingsDPRSoundVolume(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRSoundVolume,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPRSoundVolume::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RSoundVolume",(tS32) 0x2f3c8c7b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRSoundVolume = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPRSoundVolume::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RSoundVolume", (tS32)0x2f3c8c7b);
   (tVoid)myDpElem.bFillData((tVoid*)&tRSoundVolume, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPRSoundVolume::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPRSoundVolume::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEngineSoundSettingsDPRSoundVolume::tGetData() {
   vUpdate();
   return tRSoundVolume;
};
tS32 dp_tclEngineSoundSettingsDPRSoundVolume::s32GetData(tU8& tRSoundVolumeParam) { 
   vUpdate();
   tRSoundVolumeParam = tRSoundVolume;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPRSoundVolume::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RSoundVolume", (tS32)0x2f3c8c7b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPRSoundVolume::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPRSoundVolume::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPRSoundVolume::s32SetData(tU8 &tRSoundVolumeParam) {
   //init parameter
   (tVoid)memcpy(&tRSoundVolume,(tVoid*)&tRSoundVolumeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRSoundVolumeParam' in function 'dp_tclEngineSoundSettingsDPRSoundVolume::vSetData(tU8)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPRSoundVolume::s32SetData(const tU8 &tRSoundVolumeParam) {
   //init parameter
   (tVoid)memcpy(&tRSoundVolume,(tVoid*)&tRSoundVolumeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRSoundVolumeParam' in function 'dp_tclEngineSoundSettingsDPRSoundVolume::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPRSoundVolume::u8GetData(tU8& tRSoundVolumeParam) {  
   vUpdate();
   tRSoundVolumeParam = tRSoundVolume;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPRSoundVolume::vSetData(tU8 &tRSoundVolumeParam) { 
   //init parameter
   (tVoid)memcpy(&tRSoundVolume,(tVoid*)&tRSoundVolumeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRSoundVolumeParam' in function 'dp_tclEngineSoundSettingsDPRSoundVolume::vSetData(tU8)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPRSoundVolume::vSetData(const tU8 &tRSoundVolumeParam) { 
   //init parameter
   (tVoid)memcpy(&tRSoundVolume,(tVoid*)&tRSoundVolumeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRSoundVolumeParam' in function 'dp_tclEngineSoundSettingsDPRSoundVolume::vSetData(tU8)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPRSoundVolume::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPRSoundVolume::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "RSoundVolume", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPRSoundVolume::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "RSoundVolume", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPRSoundVolume::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RSoundVolume", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element RSoundVolume has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RSoundActivation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEngineSoundSettingsDPRSoundActivation::dp_tclEngineSoundSettingsDPRSoundActivation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRSoundActivation,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEngineSoundSettingsDPRSoundActivation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RSoundActivation",(tS32) 0x5020ef09);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tRSoundActivation = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEngineSoundSettingsDPRSoundActivation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RSoundActivation", (tS32)0x5020ef09);
   (tVoid)myDpElem.bFillData((tVoid*)&tRSoundActivation, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEngineSoundSettingsDPRSoundActivation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEngineSoundSettingsDPRSoundActivation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclEngineSoundSettingsDPRSoundActivation::tGetData() {
   vUpdate();
   return tRSoundActivation;
};
tS32 dp_tclEngineSoundSettingsDPRSoundActivation::s32GetData(tBool& tRSoundActivationParam) { 
   vUpdate();
   tRSoundActivationParam = tRSoundActivation;
   return _s32Status;
}
tS32 dp_tclEngineSoundSettingsDPRSoundActivation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RSoundActivation", (tS32)0x5020ef09);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEngineSoundSettingsDPRSoundActivation::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEngineSoundSettingsDPRSoundActivation::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEngineSoundSettingsDPRSoundActivation::s32SetData(tBool &tRSoundActivationParam) {
   //init parameter
   (tVoid)memcpy(&tRSoundActivation,(tVoid*)&tRSoundActivationParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRSoundActivationParam' in function 'dp_tclEngineSoundSettingsDPRSoundActivation::vSetData(tBool)' could be made const reference
tS32 dp_tclEngineSoundSettingsDPRSoundActivation::s32SetData(const tBool &tRSoundActivationParam) {
   //init parameter
   (tVoid)memcpy(&tRSoundActivation,(tVoid*)&tRSoundActivationParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRSoundActivationParam' in function 'dp_tclEngineSoundSettingsDPRSoundActivation::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclEngineSoundSettingsDPRSoundActivation::u8GetData(tBool& tRSoundActivationParam) {  
   vUpdate();
   tRSoundActivationParam = tRSoundActivation;
   return _u8DataStatus;
}
tVoid dp_tclEngineSoundSettingsDPRSoundActivation::vSetData(tBool &tRSoundActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tRSoundActivation,(tVoid*)&tRSoundActivationParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tRSoundActivationParam' in function 'dp_tclEngineSoundSettingsDPRSoundActivation::vSetData(tBool)' could be made const reference
tVoid dp_tclEngineSoundSettingsDPRSoundActivation::vSetData(const tBool &tRSoundActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tRSoundActivation,(tVoid*)&tRSoundActivationParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tRSoundActivationParam' in function 'dp_tclEngineSoundSettingsDPRSoundActivation::vSetData(tBool)' could be made const reference
tU8   dp_tclEngineSoundSettingsDPRSoundActivation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEngineSoundSettingsDPRSoundActivation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "RSoundActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPRSoundActivation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP, "RSoundActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEngineSoundSettingsDPRSoundActivation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RSoundActivation", DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_ENGINESOUNDSETTINGSDP);
   }
   else
   {
      fprintf(stdout,"Element RSoundActivation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
