#ifndef _DP_FI_AUDIOMANAGERDP_H
#define _DP_FI_AUDIOMANAGERDP_H

extern tVoid vInitAudioManagerDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_DP_FC_AUDIOMANAGER 
#include "fc_audiomanager_if.h"
//lint +e750




class dp_tclAudioManagerDPADR3_ConfBalance{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfBalance(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfBalance() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfBalanceParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfBalanceParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfBalanceParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfBass{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfBass(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfBass() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfBassParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfBassParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfBassParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_Conf_SD_Bass{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_Conf_SD_Bass(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_Conf_SD_Bass() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_Conf_SD_BassParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_Conf_SD_BassParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_Conf_SD_BassParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfMidRange{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfMidRange(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfMidRange() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfMidRangeParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfMidRangeParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfMidRangeParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfFader{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfFader(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfFader() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfFaderParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfFaderParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfFaderParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfLoudness{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfLoudness(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfLoudness() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfLoudnessParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfLoudnessParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfLoudnessParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfTreble{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfTreble(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfTreble() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfTrebleParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfTrebleParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfTrebleParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_Conf_SD_Treble{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_Conf_SD_Treble(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_Conf_SD_Treble() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_Conf_SD_TrebleParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_Conf_SD_TrebleParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_Conf_SD_TrebleParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfSrcOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfSrcOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfSrcOffset() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfSrcOffsetParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfSrcOffsetParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfSrcOffsetParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfDelay{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfDelay(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfDelay() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfDelayParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfDelayParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfDelayParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfEqu{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfEqu(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfEqu() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfEquParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfEquParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfEquParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPEngineeringData{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPEngineeringData(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPEngineeringData() {};

   //read access for pool element 
   tS32  s32GetData(tS32* tEngineeringDataParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS32* tEngineeringDataParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS32* tEngineeringDataParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPSoundToolFlag{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSoundToolFlag;
   
public:
   dp_tclAudioManagerDPSoundToolFlag(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPSoundToolFlag() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSoundToolFlagParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSoundToolFlagParam);
   tS32  s32SetData(const tU8 &tSoundToolFlagParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSoundToolFlagParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSoundToolFlagParam);
   tVoid vSetData(const tU8& tSoundToolFlagParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPADR3_ConfSddc{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfSddc(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfSddc() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfSddcParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfSddcParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfSddcParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfSdvc{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfSdvc(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfSdvc() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfSdvcParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfSdvcParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfSdvcParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfSrcOffsetIn{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfSrcOffsetIn(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfSrcOffsetIn() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfSrcOffsetInParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfSrcOffsetInParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfSrcOffsetInParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfSrcOffsetOut{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfSrcOffsetOut(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfSrcOffsetOut() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfSrcOffsetOutParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfSrcOffsetOutParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfSrcOffsetOutParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfLoudnessHigh{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfLoudnessHigh(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfLoudnessHigh() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfLoudnessHighParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfLoudnessHighParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfLoudnessHighParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfPreMix{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfPreMix(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfPreMix() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfPreMixParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfPreMixParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfPreMixParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfSDFC{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfSDFC(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfSDFC() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfSDFCParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfSDFCParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfSDFCParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPADR3_ConfOutputPhase{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPADR3_ConfOutputPhase(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPADR3_ConfOutputPhase() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tADR3_ConfOutputPhaseParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tADR3_ConfOutputPhaseParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tADR3_ConfOutputPhaseParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPTreble{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tTreble;
   
public:
   dp_tclAudioManagerDPTreble(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPTreble() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tTrebleParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tTrebleParam);
   tS32  s32SetData(const tS8 &tTrebleParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tTrebleParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tTrebleParam);
   tVoid vSetData(const tS8& tTrebleParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPBass{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tBass;
   
public:
   dp_tclAudioManagerDPBass(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPBass() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tBassParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tBassParam);
   tS32  s32SetData(const tS8 &tBassParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tBassParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tBassParam);
   tVoid vSetData(const tS8& tBassParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPMidRange{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tMidRange;
   
public:
   dp_tclAudioManagerDPMidRange(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPMidRange() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tMidRangeParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tMidRangeParam);
   tS32  s32SetData(const tS8 &tMidRangeParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tMidRangeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tMidRangeParam);
   tVoid vSetData(const tS8& tMidRangeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPFader{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tFader;
   
public:
   dp_tclAudioManagerDPFader(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPFader() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tFaderParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tFaderParam);
   tS32  s32SetData(const tS8 &tFaderParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tFaderParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tFaderParam);
   tVoid vSetData(const tS8& tFaderParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPBalance{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tBalance;
   
public:
   dp_tclAudioManagerDPBalance(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPBalance() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tBalanceParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tBalanceParam);
   tS32  s32SetData(const tS8 &tBalanceParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tBalanceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tBalanceParam);
   tVoid vSetData(const tS8& tBalanceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPGala{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tGala;
   
public:
   dp_tclAudioManagerDPGala(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPGala() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tGalaParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tGalaParam);
   tS32  s32SetData(const tU8 &tGalaParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tGalaParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tGalaParam);
   tVoid vSetData(const tU8& tGalaParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPPSA_Gala{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPSA_Gala;
   
public:
   dp_tclAudioManagerDPPSA_Gala(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPPSA_Gala() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPSA_GalaParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPSA_GalaParam);
   tS32  s32SetData(const tU8 &tPSA_GalaParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPSA_GalaParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPSA_GalaParam);
   tVoid vSetData(const tU8& tPSA_GalaParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPAuxInLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAuxInLevel;
   
public:
   dp_tclAudioManagerDPAuxInLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPAuxInLevel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAuxInLevelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAuxInLevelParam);
   tS32  s32SetData(const tU8 &tAuxInLevelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAuxInLevelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAuxInLevelParam);
   tVoid vSetData(const tU8& tAuxInLevelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPBeepLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tBeepLevel;
   
public:
   dp_tclAudioManagerDPBeepLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPBeepLevel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tBeepLevelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tBeepLevelParam);
   tS32  s32SetData(const tU8 &tBeepLevelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tBeepLevelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tBeepLevelParam);
   tVoid vSetData(const tU8& tBeepLevelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPRearMute{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRearMute;
   
public:
   dp_tclAudioManagerDPRearMute(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPRearMute() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRearMuteParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRearMuteParam);
   tS32  s32SetData(const tU8 &tRearMuteParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRearMuteParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRearMuteParam);
   tVoid vSetData(const tU8& tRearMuteParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPEntOnVolumeSet{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tEntOnVolumeSet;
   
public:
   dp_tclAudioManagerDPEntOnVolumeSet(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPEntOnVolumeSet() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tEntOnVolumeSetParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tEntOnVolumeSetParam);
   tS32  s32SetData(const tU8 &tEntOnVolumeSetParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tEntOnVolumeSetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tEntOnVolumeSetParam);
   tVoid vSetData(const tU8& tEntOnVolumeSetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPMinimumOnVolLimit{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMinimumOnVolLimit;
   
public:
   dp_tclAudioManagerDPMinimumOnVolLimit(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPMinimumOnVolLimit() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMinimumOnVolLimitParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMinimumOnVolLimitParam);
   tS32  s32SetData(const tU8 &tMinimumOnVolLimitParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMinimumOnVolLimitParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMinimumOnVolLimitParam);
   tVoid vSetData(const tU8& tMinimumOnVolLimitParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPGeometryMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tGeometryMode;
   
public:
   dp_tclAudioManagerDPGeometryMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPGeometryMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tGeometryModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tGeometryModeParam);
   tS32  s32SetData(const tU8 &tGeometryModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tGeometryModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tGeometryModeParam);
   tVoid vSetData(const tU8& tGeometryModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPLoudness{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLoudness;
   
public:
   dp_tclAudioManagerDPLoudness(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPLoudness() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLoudnessParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLoudnessParam);
   tS32  s32SetData(const tU8 &tLoudnessParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLoudnessParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLoudnessParam);
   tVoid vSetData(const tU8& tLoudnessParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPLoudness_TEF{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLoudness_TEF;
   
public:
   dp_tclAudioManagerDPLoudness_TEF(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPLoudness_TEF() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLoudness_TEFParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLoudness_TEFParam);
   tS32  s32SetData(const tU8 &tLoudness_TEFParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLoudness_TEFParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLoudness_TEFParam);
   tVoid vSetData(const tU8& tLoudness_TEFParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPDynCompression{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDynCompression;
   
public:
   dp_tclAudioManagerDPDynCompression(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPDynCompression() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDynCompressionParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDynCompressionParam);
   tS32  s32SetData(const tU8 &tDynCompressionParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDynCompressionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDynCompressionParam);
   tVoid vSetData(const tU8& tDynCompressionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPEquPreset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tEquPreset;
   
public:
   dp_tclAudioManagerDPEquPreset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPEquPreset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tEquPresetParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tEquPresetParam);
   tS32  s32SetData(const tU8 &tEquPresetParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tEquPresetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tEquPresetParam);
   tVoid vSetData(const tU8& tEquPresetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPOptimization{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tOptimization;
   
public:
   dp_tclAudioManagerDPOptimization(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPOptimization() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tOptimizationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tOptimizationParam);
   tS32  s32SetData(const tU8 &tOptimizationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tOptimizationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tOptimizationParam);
   tVoid vSetData(const tU8& tOptimizationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPRoomEffect{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRoomEffect;
   
public:
   dp_tclAudioManagerDPRoomEffect(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPRoomEffect() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRoomEffectParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRoomEffectParam);
   tS32  s32SetData(const tU8 &tRoomEffectParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRoomEffectParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRoomEffectParam);
   tVoid vSetData(const tU8& tRoomEffectParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPSoundStaging{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSoundStaging;
   
public:
   dp_tclAudioManagerDPSoundStaging(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPSoundStaging() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSoundStagingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSoundStagingParam);
   tS32  s32SetData(const tU8 &tSoundStagingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSoundStagingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSoundStagingParam);
   tVoid vSetData(const tU8& tSoundStagingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPAdas_UPASoundtype{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_UPASoundtype;
   
public:
   dp_tclAudioManagerDPAdas_UPASoundtype(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPAdas_UPASoundtype() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_UPASoundtypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_UPASoundtypeParam);
   tS32  s32SetData(const tU8 &tAdas_UPASoundtypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_UPASoundtypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_UPASoundtypeParam);
   tVoid vSetData(const tU8& tAdas_UPASoundtypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPAdas_ParkAssitVol{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_ParkAssitVol;
   
public:
   dp_tclAudioManagerDPAdas_ParkAssitVol(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPAdas_ParkAssitVol() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_ParkAssitVolParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_ParkAssitVolParam);
   tS32  s32SetData(const tU8 &tAdas_ParkAssitVolParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_ParkAssitVolParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_ParkAssitVolParam);
   tVoid vSetData(const tU8& tAdas_ParkAssitVolParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPAdas_UPAMute{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_UPAMute;
   
public:
   dp_tclAudioManagerDPAdas_UPAMute(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPAdas_UPAMute() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_UPAMuteParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_UPAMuteParam);
   tS32  s32SetData(const tU8 &tAdas_UPAMuteParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_UPAMuteParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_UPAMuteParam);
   tVoid vSetData(const tU8& tAdas_UPAMuteParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPAdas_LDWUSerVol{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_LDWUSerVol;
   
public:
   dp_tclAudioManagerDPAdas_LDWUSerVol(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPAdas_LDWUSerVol() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_LDWUSerVolParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_LDWUSerVolParam);
   tS32  s32SetData(const tU8 &tAdas_LDWUSerVolParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_LDWUSerVolParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_LDWUSerVolParam);
   tVoid vSetData(const tU8& tAdas_LDWUSerVolParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPAdas_SRSoundState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_SRSoundState;
   
public:
   dp_tclAudioManagerDPAdas_SRSoundState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPAdas_SRSoundState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_SRSoundStateParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_SRSoundStateParam);
   tS32  s32SetData(const tU8 &tAdas_SRSoundStateParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_SRSoundStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_SRSoundStateParam);
   tVoid vSetData(const tU8& tAdas_SRSoundStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPBass_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tBass_Max;
   
public:
   dp_tclAudioManagerDPBass_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPBass_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tBass_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tBass_MaxParam);
   tS32  s32SetData(const tS8 &tBass_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tBass_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tBass_MaxParam);
   tVoid vSetData(const tS8& tBass_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPCenter_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tCenter_Max;
   
public:
   dp_tclAudioManagerDPCenter_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPCenter_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tCenter_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tCenter_MaxParam);
   tS32  s32SetData(const tS8 &tCenter_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tCenter_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tCenter_MaxParam);
   tVoid vSetData(const tS8& tCenter_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPSubWoofer_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tSubWoofer_Max;
   
public:
   dp_tclAudioManagerDPSubWoofer_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPSubWoofer_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tSubWoofer_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tSubWoofer_MaxParam);
   tS32  s32SetData(const tS8 &tSubWoofer_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tSubWoofer_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tSubWoofer_MaxParam);
   tVoid vSetData(const tS8& tSubWoofer_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPTreble_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tTreble_Max;
   
public:
   dp_tclAudioManagerDPTreble_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPTreble_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tTreble_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tTreble_MaxParam);
   tS32  s32SetData(const tS8 &tTreble_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tTreble_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tTreble_MaxParam);
   tVoid vSetData(const tS8& tTreble_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPMidRange_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tMidRange_Max;
   
public:
   dp_tclAudioManagerDPMidRange_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPMidRange_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tMidRange_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tMidRange_MaxParam);
   tS32  s32SetData(const tS8 &tMidRange_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tMidRange_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tMidRange_MaxParam);
   tVoid vSetData(const tS8& tMidRange_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPFader_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tFader_Max;
   
public:
   dp_tclAudioManagerDPFader_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPFader_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tFader_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tFader_MaxParam);
   tS32  s32SetData(const tS8 &tFader_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tFader_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tFader_MaxParam);
   tVoid vSetData(const tS8& tFader_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPBalance_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tBalance_Max;
   
public:
   dp_tclAudioManagerDPBalance_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPBalance_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tBalance_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tBalance_MaxParam);
   tS32  s32SetData(const tS8 &tBalance_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tBalance_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tBalance_MaxParam);
   tVoid vSetData(const tS8& tBalance_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPGala_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tGala_Max;
   
public:
   dp_tclAudioManagerDPGala_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPGala_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tGala_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tGala_MaxParam);
   tS32  s32SetData(const tS8 &tGala_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tGala_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tGala_MaxParam);
   tVoid vSetData(const tS8& tGala_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPLoudness_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tLoudness_Max;
   
public:
   dp_tclAudioManagerDPLoudness_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPLoudness_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tLoudness_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tLoudness_MaxParam);
   tS32  s32SetData(const tS8 &tLoudness_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tLoudness_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tLoudness_MaxParam);
   tVoid vSetData(const tS8& tLoudness_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPDynCompression_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tDynCompression_Max;
   
public:
   dp_tclAudioManagerDPDynCompression_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPDynCompression_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tDynCompression_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tDynCompression_MaxParam);
   tS32  s32SetData(const tS8 &tDynCompression_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tDynCompression_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tDynCompression_MaxParam);
   tVoid vSetData(const tS8& tDynCompression_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPEquPreset_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tEquPreset_Max;
   
public:
   dp_tclAudioManagerDPEquPreset_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPEquPreset_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tEquPreset_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tEquPreset_MaxParam);
   tS32  s32SetData(const tS8 &tEquPreset_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tEquPreset_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tEquPreset_MaxParam);
   tVoid vSetData(const tS8& tEquPreset_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPOptimization_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tOptimization_Max;
   
public:
   dp_tclAudioManagerDPOptimization_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPOptimization_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tOptimization_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tOptimization_MaxParam);
   tS32  s32SetData(const tS8 &tOptimization_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tOptimization_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tOptimization_MaxParam);
   tVoid vSetData(const tS8& tOptimization_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPRoomEffect_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tRoomEffect_Max;
   
public:
   dp_tclAudioManagerDPRoomEffect_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPRoomEffect_Max() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tRoomEffect_MaxParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tRoomEffect_MaxParam);
   tS32  s32SetData(const tS8 &tRoomEffect_MaxParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tRoomEffect_MaxParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tRoomEffect_MaxParam);
   tVoid vSetData(const tS8& tRoomEffect_MaxParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPBass_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tBass_Min;
   
public:
   dp_tclAudioManagerDPBass_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPBass_Min() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tBass_MinParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tBass_MinParam);
   tS32  s32SetData(const tS8 &tBass_MinParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tBass_MinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tBass_MinParam);
   tVoid vSetData(const tS8& tBass_MinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPCenter_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tCenter_Min;
   
public:
   dp_tclAudioManagerDPCenter_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPCenter_Min() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tCenter_MinParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tCenter_MinParam);
   tS32  s32SetData(const tS8 &tCenter_MinParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tCenter_MinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tCenter_MinParam);
   tVoid vSetData(const tS8& tCenter_MinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPSubWoofer_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tSubWoofer_Min;
   
public:
   dp_tclAudioManagerDPSubWoofer_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPSubWoofer_Min() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tSubWoofer_MinParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tSubWoofer_MinParam);
   tS32  s32SetData(const tS8 &tSubWoofer_MinParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tSubWoofer_MinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tSubWoofer_MinParam);
   tVoid vSetData(const tS8& tSubWoofer_MinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPTreble_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tTreble_Min;
   
public:
   dp_tclAudioManagerDPTreble_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPTreble_Min() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tTreble_MinParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tTreble_MinParam);
   tS32  s32SetData(const tS8 &tTreble_MinParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tTreble_MinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tTreble_MinParam);
   tVoid vSetData(const tS8& tTreble_MinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPMidRange_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tMidRange_Min;
   
public:
   dp_tclAudioManagerDPMidRange_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPMidRange_Min() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tMidRange_MinParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tMidRange_MinParam);
   tS32  s32SetData(const tS8 &tMidRange_MinParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tMidRange_MinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tMidRange_MinParam);
   tVoid vSetData(const tS8& tMidRange_MinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPFader_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tFader_Min;
   
public:
   dp_tclAudioManagerDPFader_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPFader_Min() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tFader_MinParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tFader_MinParam);
   tS32  s32SetData(const tS8 &tFader_MinParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tFader_MinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tFader_MinParam);
   tVoid vSetData(const tS8& tFader_MinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPBalance_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tBalance_Min;
   
public:
   dp_tclAudioManagerDPBalance_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPBalance_Min() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tBalance_MinParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tBalance_MinParam);
   tS32  s32SetData(const tS8 &tBalance_MinParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tBalance_MinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tBalance_MinParam);
   tVoid vSetData(const tS8& tBalance_MinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPLoudness_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tLoudness_Min;
   
public:
   dp_tclAudioManagerDPLoudness_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPLoudness_Min() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tLoudness_MinParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tLoudness_MinParam);
   tS32  s32SetData(const tS8 &tLoudness_MinParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tLoudness_MinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tLoudness_MinParam);
   tVoid vSetData(const tS8& tLoudness_MinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPVolumes{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPVolumes(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPVolumes() {};

   //read access for pool element 
   tS32  s32GetData(VolumeManager::tVolumelistEntry* tVolumesParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(VolumeManager::tVolumelistEntry* tVolumesParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(VolumeManager::tVolumelistEntry* tVolumesParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPVolumes_Sink2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPVolumes_Sink2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPVolumes_Sink2() {};

   //read access for pool element 
   tS32  s32GetData(VolumeManager::tVolumelistEntry* tVolumes_Sink2Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(VolumeManager::tVolumelistEntry* tVolumes_Sink2Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(VolumeManager::tVolumelistEntry* tVolumes_Sink2Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPPDCSetup_Volume{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDCSetup_Volume;
   
public:
   dp_tclAudioManagerDPPDCSetup_Volume(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPPDCSetup_Volume() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDCSetup_VolumeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDCSetup_VolumeParam);
   tS32  s32SetData(const tU8 &tPDCSetup_VolumeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDCSetup_VolumeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDCSetup_VolumeParam);
   tVoid vSetData(const tU8& tPDCSetup_VolumeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPCenterGain{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tCenterGain;
   
public:
   dp_tclAudioManagerDPCenterGain(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPCenterGain() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tCenterGainParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tCenterGainParam);
   tS32  s32SetData(const tS16 &tCenterGainParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tCenterGainParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tCenterGainParam);
   tVoid vSetData(const tS16& tCenterGainParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPSubWoofer{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tSubWoofer;
   
public:
   dp_tclAudioManagerDPSubWoofer(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPSubWoofer() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tSubWooferParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tSubWooferParam);
   tS32  s32SetData(const tS16 &tSubWooferParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tSubWooferParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tSubWooferParam);
   tVoid vSetData(const tS16& tSubWooferParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPSurroundLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSurroundLevel;
   
public:
   dp_tclAudioManagerDPSurroundLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPSurroundLevel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSurroundLevelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSurroundLevelParam);
   tS32  s32SetData(const tU8 &tSurroundLevelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSurroundLevelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSurroundLevelParam);
   tVoid vSetData(const tU8& tSurroundLevelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPArkamys_AvcFlatConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPArkamys_AvcFlatConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPArkamys_AvcFlatConfig() {};

   //read access for pool element 
   tS32  s32GetData(tU32* tArkamys_AvcFlatConfigParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU32* tArkamys_AvcFlatConfigParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU32* tArkamys_AvcFlatConfigParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPArkamys_SSS4FlatConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPArkamys_SSS4FlatConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPArkamys_SSS4FlatConfig() {};

   //read access for pool element 
   tS32  s32GetData(tU32* tArkamys_SSS4FlatConfigParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU32* tArkamys_SSS4FlatConfigParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU32* tArkamys_SSS4FlatConfigParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig() {};

   //read access for pool element 
   tS32  s32GetData(tU32* tArkamys_VirtualSubwooferFlatConfigParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU32* tArkamys_VirtualSubwooferFlatConfigParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU32* tArkamys_VirtualSubwooferFlatConfigParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerDPArkamys_SteeringRight{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tArkamys_SteeringRight;
   
public:
   dp_tclAudioManagerDPArkamys_SteeringRight(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPArkamys_SteeringRight() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tArkamys_SteeringRightParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tArkamys_SteeringRightParam);
   tS32  s32SetData(const tBool &tArkamys_SteeringRightParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tArkamys_SteeringRightParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tArkamys_SteeringRightParam);
   tVoid vSetData(const tBool& tArkamys_SteeringRightParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPArkamys_SoundStagingMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tArkamys_SoundStagingMode;
   
public:
   dp_tclAudioManagerDPArkamys_SoundStagingMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPArkamys_SoundStagingMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tArkamys_SoundStagingModeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tArkamys_SoundStagingModeParam);
   tS32  s32SetData(const tU16 &tArkamys_SoundStagingModeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tArkamys_SoundStagingModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tArkamys_SoundStagingModeParam);
   tVoid vSetData(const tU16& tArkamys_SoundStagingModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPArkamys_Ambiance{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tArkamys_Ambiance;
   
public:
   dp_tclAudioManagerDPArkamys_Ambiance(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPArkamys_Ambiance() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tArkamys_AmbianceParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tArkamys_AmbianceParam);
   tS32  s32SetData(const tU16 &tArkamys_AmbianceParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tArkamys_AmbianceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tArkamys_AmbianceParam);
   tVoid vSetData(const tU16& tArkamys_AmbianceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPArkamys_AutomaticGainControl{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tArkamys_AutomaticGainControl;
   
public:
   dp_tclAudioManagerDPArkamys_AutomaticGainControl(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPArkamys_AutomaticGainControl() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tArkamys_AutomaticGainControlParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tArkamys_AutomaticGainControlParam);
   tS32  s32SetData(const tBool &tArkamys_AutomaticGainControlParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tArkamys_AutomaticGainControlParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tArkamys_AutomaticGainControlParam);
   tVoid vSetData(const tBool& tArkamys_AutomaticGainControlParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPCenter_GainPerStep{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCenter_GainPerStep;
   
public:
   dp_tclAudioManagerDPCenter_GainPerStep(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPCenter_GainPerStep() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCenter_GainPerStepParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCenter_GainPerStepParam);
   tS32  s32SetData(const tU8 &tCenter_GainPerStepParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCenter_GainPerStepParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCenter_GainPerStepParam);
   tVoid vSetData(const tU8& tCenter_GainPerStepParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPSubWoofer_GainPerStep{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSubWoofer_GainPerStep;
   
public:
   dp_tclAudioManagerDPSubWoofer_GainPerStep(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPSubWoofer_GainPerStep() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSubWoofer_GainPerStepParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSubWoofer_GainPerStepParam);
   tS32  s32SetData(const tU8 &tSubWoofer_GainPerStepParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSubWoofer_GainPerStepParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSubWoofer_GainPerStepParam);
   tVoid vSetData(const tU8& tSubWoofer_GainPerStepParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPAudioPilotMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tAudioPilotMode;
   
public:
   dp_tclAudioManagerDPAudioPilotMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPAudioPilotMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tAudioPilotModeParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tAudioPilotModeParam);
   tS32  s32SetData(const tBool &tAudioPilotModeParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tAudioPilotModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tAudioPilotModeParam);
   tVoid vSetData(const tBool& tAudioPilotModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerDPAudioPilotIntensity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAudioPilotIntensity;
   
public:
   dp_tclAudioManagerDPAudioPilotIntensity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerDPAudioPilotIntensity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAudioPilotIntensityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAudioPilotIntensityParam);
   tS32  s32SetData(const tU8 &tAudioPilotIntensityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAudioPilotIntensityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAudioPilotIntensityParam);
   tVoid vSetData(const tU8& tAudioPilotIntensityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
