
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAudioManagerDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfBalance"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfBalance::dp_tclAudioManagerDPADR3_ConfBalance(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfBalance::s32SetData( tU8* tADR3_ConfBalanceParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfBalance", (tS32)0xfc873ba5);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfBalanceParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfBalance::s32GetData(tU8* tADR3_ConfBalanceParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfBalance", (tS32)0xfc873ba5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfBalanceParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfBalance::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfBalance::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfBalance::u16GetData(tU8* tADR3_ConfBalanceParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfBalanceParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfBalance::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfBalance", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfBalance::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfBalance", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfBalance::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfBalance", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfBalance has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfBass"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfBass::dp_tclAudioManagerDPADR3_ConfBass(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfBass::s32SetData( tU8* tADR3_ConfBassParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfBass", (tS32)0xb019a884);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfBassParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfBass::s32GetData(tU8* tADR3_ConfBassParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfBass", (tS32)0xb019a884);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfBassParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfBass::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfBass::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfBass::u16GetData(tU8* tADR3_ConfBassParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfBassParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfBass::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfBass", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfBass::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfBass", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfBass::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfBass", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfBass has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_Conf_SD_Bass"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_Conf_SD_Bass::dp_tclAudioManagerDPADR3_Conf_SD_Bass(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_Conf_SD_Bass::s32SetData( tU8* tADR3_Conf_SD_BassParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_Conf_SD_Bass", (tS32)0xeec163b5);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_Conf_SD_BassParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_Conf_SD_Bass::s32GetData(tU8* tADR3_Conf_SD_BassParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_Conf_SD_Bass", (tS32)0xeec163b5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_Conf_SD_BassParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_Conf_SD_Bass::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_Conf_SD_Bass::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_Conf_SD_Bass::u16GetData(tU8* tADR3_Conf_SD_BassParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_Conf_SD_BassParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_Conf_SD_Bass::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_Conf_SD_Bass", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_Conf_SD_Bass::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_Conf_SD_Bass", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_Conf_SD_Bass::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_Conf_SD_Bass", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_Conf_SD_Bass has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfMidRange"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfMidRange::dp_tclAudioManagerDPADR3_ConfMidRange(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfMidRange::s32SetData( tU8* tADR3_ConfMidRangeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfMidRange", (tS32)0xeeb2a452);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfMidRangeParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfMidRange::s32GetData(tU8* tADR3_ConfMidRangeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfMidRange", (tS32)0xeeb2a452);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfMidRangeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfMidRange::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfMidRange::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfMidRange::u16GetData(tU8* tADR3_ConfMidRangeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfMidRangeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfMidRange::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfMidRange", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfMidRange::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfMidRange", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfMidRange::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfMidRange", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfMidRange has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfFader"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfFader::dp_tclAudioManagerDPADR3_ConfFader(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfFader::s32SetData( tU8* tADR3_ConfFaderParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfFader", (tS32)0x7080530d);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfFaderParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfFader::s32GetData(tU8* tADR3_ConfFaderParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfFader", (tS32)0x7080530d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfFaderParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfFader::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfFader::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfFader::u16GetData(tU8* tADR3_ConfFaderParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfFaderParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfFader::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfFader", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfFader::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfFader", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfFader::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfFader", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfFader has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfLoudness"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfLoudness::dp_tclAudioManagerDPADR3_ConfLoudness(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfLoudness::s32SetData( tU8* tADR3_ConfLoudnessParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfLoudness", (tS32)0xeeb3e294);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfLoudnessParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfLoudness::s32GetData(tU8* tADR3_ConfLoudnessParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfLoudness", (tS32)0xeeb3e294);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfLoudnessParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfLoudness::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfLoudness::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfLoudness::u16GetData(tU8* tADR3_ConfLoudnessParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfLoudnessParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfLoudness::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfLoudness", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfLoudness::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfLoudness", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfLoudness::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfLoudness", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfLoudness has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfTreble"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfTreble::dp_tclAudioManagerDPADR3_ConfTreble(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfTreble::s32SetData( tU8* tADR3_ConfTrebleParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfTreble", (tS32)0x32827421);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfTrebleParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfTreble::s32GetData(tU8* tADR3_ConfTrebleParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfTreble", (tS32)0x32827421);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfTrebleParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfTreble::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfTreble::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfTreble::u16GetData(tU8* tADR3_ConfTrebleParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfTrebleParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfTreble::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfTreble", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfTreble::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfTreble", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfTreble::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfTreble", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfTreble has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_Conf_SD_Treble"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_Conf_SD_Treble::dp_tclAudioManagerDPADR3_Conf_SD_Treble(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_Conf_SD_Treble::s32SetData( tU8* tADR3_Conf_SD_TrebleParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_Conf_SD_Treble", (tS32)0x50e3bbea);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_Conf_SD_TrebleParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_Conf_SD_Treble::s32GetData(tU8* tADR3_Conf_SD_TrebleParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_Conf_SD_Treble", (tS32)0x50e3bbea);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_Conf_SD_TrebleParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_Conf_SD_Treble::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_Conf_SD_Treble::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_Conf_SD_Treble::u16GetData(tU8* tADR3_Conf_SD_TrebleParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_Conf_SD_TrebleParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_Conf_SD_Treble::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_Conf_SD_Treble", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_Conf_SD_Treble::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_Conf_SD_Treble", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_Conf_SD_Treble::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_Conf_SD_Treble", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_Conf_SD_Treble has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfSrcOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfSrcOffset::dp_tclAudioManagerDPADR3_ConfSrcOffset(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfSrcOffset::s32SetData( tU8* tADR3_ConfSrcOffsetParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfSrcOffset", (tS32)0xa9ab5bba);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfSrcOffsetParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfSrcOffset::s32GetData(tU8* tADR3_ConfSrcOffsetParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfSrcOffset", (tS32)0xa9ab5bba);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfSrcOffsetParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfSrcOffset::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfSrcOffset::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfSrcOffset::u16GetData(tU8* tADR3_ConfSrcOffsetParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfSrcOffsetParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSrcOffset", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSrcOffset", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffset::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfSrcOffset", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfSrcOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfDelay"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfDelay::dp_tclAudioManagerDPADR3_ConfDelay(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfDelay::s32SetData( tU8* tADR3_ConfDelayParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfDelay", (tS32)0x708050da);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfDelayParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfDelay::s32GetData(tU8* tADR3_ConfDelayParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfDelay", (tS32)0x708050da);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfDelayParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfDelay::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfDelay::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfDelay::u16GetData(tU8* tADR3_ConfDelayParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfDelayParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfDelay::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfDelay", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfDelay::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfDelay", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfDelay::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfDelay", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfDelay has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfEqu"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfEqu::dp_tclAudioManagerDPADR3_ConfEqu(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfEqu::s32SetData( tU8* tADR3_ConfEquParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfEqu", (tS32)0xf005223a);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfEquParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfEqu::s32GetData(tU8* tADR3_ConfEquParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfEqu", (tS32)0xf005223a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfEquParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfEqu::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfEqu::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfEqu::u16GetData(tU8* tADR3_ConfEquParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfEquParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfEqu::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfEqu", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfEqu::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfEqu", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfEqu::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfEqu", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfEqu has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EngineeringData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPEngineeringData::dp_tclAudioManagerDPEngineeringData(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPEngineeringData::s32SetData( tS32* tEngineeringDataParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("EngineeringData", (tS32)0xacd614f5);
   (tVoid)myDpElem.bFillData((tVoid*)tEngineeringDataParam, ((tU32)sizeof(tS32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPEngineeringData::s32GetData(tS32* tEngineeringDataParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("EngineeringData", (tS32)0xacd614f5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tEngineeringDataParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPEngineeringData::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPEngineeringData::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPEngineeringData::u16GetData(tS32* tEngineeringDataParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tEngineeringDataParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPEngineeringData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "EngineeringData", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPEngineeringData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "EngineeringData", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPEngineeringData::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EngineeringData", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element EngineeringData has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SoundToolFlag"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPSoundToolFlag::dp_tclAudioManagerDPSoundToolFlag(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSoundToolFlag,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPSoundToolFlag::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SoundToolFlag",(tS32) 0x4e9e4e85);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSoundToolFlag = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPSoundToolFlag::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SoundToolFlag", (tS32)0x4e9e4e85);
   (tVoid)myDpElem.bFillData((tVoid*)&tSoundToolFlag, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPSoundToolFlag::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPSoundToolFlag::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPSoundToolFlag::tGetData() {
   vUpdate();
   return tSoundToolFlag;
};
tS32 dp_tclAudioManagerDPSoundToolFlag::s32GetData(tU8& tSoundToolFlagParam) { 
   vUpdate();
   tSoundToolFlagParam = tSoundToolFlag;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPSoundToolFlag::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SoundToolFlag", (tS32)0x4e9e4e85);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPSoundToolFlag::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPSoundToolFlag::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPSoundToolFlag::s32SetData(tU8 &tSoundToolFlagParam) {
   //init parameter
   (tVoid)memcpy(&tSoundToolFlag,(tVoid*)&tSoundToolFlagParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSoundToolFlagParam' in function 'dp_tclAudioManagerDPSoundToolFlag::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPSoundToolFlag::s32SetData(const tU8 &tSoundToolFlagParam) {
   //init parameter
   (tVoid)memcpy(&tSoundToolFlag,(tVoid*)&tSoundToolFlagParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSoundToolFlagParam' in function 'dp_tclAudioManagerDPSoundToolFlag::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPSoundToolFlag::u8GetData(tU8& tSoundToolFlagParam) {  
   vUpdate();
   tSoundToolFlagParam = tSoundToolFlag;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPSoundToolFlag::vSetData(tU8 &tSoundToolFlagParam) { 
   //init parameter
   (tVoid)memcpy(&tSoundToolFlag,(tVoid*)&tSoundToolFlagParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSoundToolFlagParam' in function 'dp_tclAudioManagerDPSoundToolFlag::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPSoundToolFlag::vSetData(const tU8 &tSoundToolFlagParam) { 
   //init parameter
   (tVoid)memcpy(&tSoundToolFlag,(tVoid*)&tSoundToolFlagParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSoundToolFlagParam' in function 'dp_tclAudioManagerDPSoundToolFlag::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPSoundToolFlag::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPSoundToolFlag::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SoundToolFlag", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSoundToolFlag::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SoundToolFlag", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSoundToolFlag::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SoundToolFlag", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element SoundToolFlag has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfSddc"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfSddc::dp_tclAudioManagerDPADR3_ConfSddc(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfSddc::s32SetData( tU8* tADR3_ConfSddcParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfSddc", (tS32)0xb019b0c1);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfSddcParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfSddc::s32GetData(tU8* tADR3_ConfSddcParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfSddc", (tS32)0xb019b0c1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfSddcParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfSddc::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfSddc::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfSddc::u16GetData(tU8* tADR3_ConfSddcParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfSddcParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfSddc::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSddc", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfSddc::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSddc", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfSddc::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfSddc", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfSddc has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfSdvc"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfSdvc::dp_tclAudioManagerDPADR3_ConfSdvc(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfSdvc::s32SetData( tU8* tADR3_ConfSdvcParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfSdvc", (tS32)0xb019b11b);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfSdvcParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfSdvc::s32GetData(tU8* tADR3_ConfSdvcParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfSdvc", (tS32)0xb019b11b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfSdvcParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfSdvc::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfSdvc::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfSdvc::u16GetData(tU8* tADR3_ConfSdvcParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfSdvcParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfSdvc::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSdvc", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfSdvc::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSdvc", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfSdvc::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfSdvc", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfSdvc has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfSrcOffsetIn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::dp_tclAudioManagerDPADR3_ConfSrcOffsetIn(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::s32SetData( tU8* tADR3_ConfSrcOffsetInParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfSrcOffsetIn", (tS32)0x91bbf705);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfSrcOffsetInParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::s32GetData(tU8* tADR3_ConfSrcOffsetInParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfSrcOffsetIn", (tS32)0x91bbf705);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfSrcOffsetInParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::u16GetData(tU8* tADR3_ConfSrcOffsetInParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfSrcOffsetInParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSrcOffsetIn", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSrcOffsetIn", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffsetIn::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfSrcOffsetIn", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfSrcOffsetIn has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfSrcOffsetOut"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::dp_tclAudioManagerDPADR3_ConfSrcOffsetOut(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::s32SetData( tU8* tADR3_ConfSrcOffsetOutParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfSrcOffsetOut", (tS32)0xd8abd446);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfSrcOffsetOutParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::s32GetData(tU8* tADR3_ConfSrcOffsetOutParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfSrcOffsetOut", (tS32)0xd8abd446);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfSrcOffsetOutParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::u16GetData(tU8* tADR3_ConfSrcOffsetOutParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfSrcOffsetOutParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSrcOffsetOut", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSrcOffsetOut", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfSrcOffsetOut::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfSrcOffsetOut", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfSrcOffsetOut has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfLoudnessHigh"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfLoudnessHigh::dp_tclAudioManagerDPADR3_ConfLoudnessHigh(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfLoudnessHigh::s32SetData( tU8* tADR3_ConfLoudnessHighParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfLoudnessHigh", (tS32)0xc52c5b28);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfLoudnessHighParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfLoudnessHigh::s32GetData(tU8* tADR3_ConfLoudnessHighParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfLoudnessHigh", (tS32)0xc52c5b28);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfLoudnessHighParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfLoudnessHigh::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfLoudnessHigh::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfLoudnessHigh::u16GetData(tU8* tADR3_ConfLoudnessHighParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfLoudnessHighParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfLoudnessHigh::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfLoudnessHigh", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfLoudnessHigh::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfLoudnessHigh", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfLoudnessHigh::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfLoudnessHigh", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfLoudnessHigh has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfPreMix"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfPreMix::dp_tclAudioManagerDPADR3_ConfPreMix(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfPreMix::s32SetData( tU8* tADR3_ConfPreMixParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfPreMix", (tS32)0x32824144);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfPreMixParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfPreMix::s32GetData(tU8* tADR3_ConfPreMixParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfPreMix", (tS32)0x32824144);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfPreMixParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfPreMix::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfPreMix::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfPreMix::u16GetData(tU8* tADR3_ConfPreMixParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfPreMixParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfPreMix::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfPreMix", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfPreMix::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfPreMix", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfPreMix::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfPreMix", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfPreMix has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfSDFC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfSDFC::dp_tclAudioManagerDPADR3_ConfSDFC(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfSDFC::s32SetData( tU8* tADR3_ConfSDFCParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfSDFC", (tS32)0xb019aceb);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfSDFCParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfSDFC::s32GetData(tU8* tADR3_ConfSDFCParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfSDFC", (tS32)0xb019aceb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfSDFCParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfSDFC::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfSDFC::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfSDFC::u16GetData(tU8* tADR3_ConfSDFCParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfSDFCParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfSDFC::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSDFC", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfSDFC::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfSDFC", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfSDFC::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfSDFC", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfSDFC has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADR3_ConfOutputPhase"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPADR3_ConfOutputPhase::dp_tclAudioManagerDPADR3_ConfOutputPhase(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPADR3_ConfOutputPhase::s32SetData( tU8* tADR3_ConfOutputPhaseParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ADR3_ConfOutputPhase", (tS32)0x9051e76d);
   (tVoid)myDpElem.bFillData((tVoid*)tADR3_ConfOutputPhaseParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPADR3_ConfOutputPhase::s32GetData(tU8* tADR3_ConfOutputPhaseParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ADR3_ConfOutputPhase", (tS32)0x9051e76d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tADR3_ConfOutputPhaseParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPADR3_ConfOutputPhase::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPADR3_ConfOutputPhase::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPADR3_ConfOutputPhase::u16GetData(tU8* tADR3_ConfOutputPhaseParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tADR3_ConfOutputPhaseParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPADR3_ConfOutputPhase::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfOutputPhase", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPADR3_ConfOutputPhase::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "ADR3_ConfOutputPhase", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPADR3_ConfOutputPhase::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADR3_ConfOutputPhase", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element ADR3_ConfOutputPhase has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPTreble::dp_tclAudioManagerDPTreble(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTreble,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPTreble::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Treble",(tS32) 0x5551a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tTreble = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPTreble::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Treble", (tS32)0x5551a);
   (tVoid)myDpElem.bFillData((tVoid*)&tTreble, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPTreble::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPTreble::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPTreble::tGetData() {
   vUpdate();
   return tTreble;
};
tS32 dp_tclAudioManagerDPTreble::s32GetData(tS8& tTrebleParam) { 
   vUpdate();
   tTrebleParam = tTreble;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPTreble::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Treble", (tS32)0x5551a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPTreble::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPTreble::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPTreble::s32SetData(tS8 &tTrebleParam) {
   //init parameter
   (tVoid)memcpy(&tTreble,(tVoid*)&tTrebleParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrebleParam' in function 'dp_tclAudioManagerDPTreble::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPTreble::s32SetData(const tS8 &tTrebleParam) {
   //init parameter
   (tVoid)memcpy(&tTreble,(tVoid*)&tTrebleParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrebleParam' in function 'dp_tclAudioManagerDPTreble::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPTreble::u8GetData(tS8& tTrebleParam) {  
   vUpdate();
   tTrebleParam = tTreble;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPTreble::vSetData(tS8 &tTrebleParam) { 
   //init parameter
   (tVoid)memcpy(&tTreble,(tVoid*)&tTrebleParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tTrebleParam' in function 'dp_tclAudioManagerDPTreble::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPTreble::vSetData(const tS8 &tTrebleParam) { 
   //init parameter
   (tVoid)memcpy(&tTreble,(tVoid*)&tTrebleParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tTrebleParam' in function 'dp_tclAudioManagerDPTreble::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPTreble::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPTreble::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Treble", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPTreble::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Treble", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPTreble::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Treble has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPBass::dp_tclAudioManagerDPBass(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBass,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPBass::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Bass",(tS32) 0x2c65);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tBass = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPBass::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Bass", (tS32)0x2c65);
   (tVoid)myDpElem.bFillData((tVoid*)&tBass, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPBass::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPBass::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPBass::tGetData() {
   vUpdate();
   return tBass;
};
tS32 dp_tclAudioManagerDPBass::s32GetData(tS8& tBassParam) { 
   vUpdate();
   tBassParam = tBass;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPBass::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Bass", (tS32)0x2c65);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPBass::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPBass::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPBass::s32SetData(tS8 &tBassParam) {
   //init parameter
   (tVoid)memcpy(&tBass,(tVoid*)&tBassParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBassParam' in function 'dp_tclAudioManagerDPBass::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPBass::s32SetData(const tS8 &tBassParam) {
   //init parameter
   (tVoid)memcpy(&tBass,(tVoid*)&tBassParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBassParam' in function 'dp_tclAudioManagerDPBass::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPBass::u8GetData(tS8& tBassParam) {  
   vUpdate();
   tBassParam = tBass;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPBass::vSetData(tS8 &tBassParam) { 
   //init parameter
   (tVoid)memcpy(&tBass,(tVoid*)&tBassParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBassParam' in function 'dp_tclAudioManagerDPBass::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPBass::vSetData(const tS8 &tBassParam) { 
   //init parameter
   (tVoid)memcpy(&tBass,(tVoid*)&tBassParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBassParam' in function 'dp_tclAudioManagerDPBass::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPBass::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPBass::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Bass", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBass::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Bass", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBass::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Bass has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPMidRange::dp_tclAudioManagerDPMidRange(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMidRange,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPMidRange::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MidRange",(tS32) 0x7a9ca3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tMidRange = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPMidRange::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MidRange", (tS32)0x7a9ca3);
   (tVoid)myDpElem.bFillData((tVoid*)&tMidRange, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPMidRange::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPMidRange::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPMidRange::tGetData() {
   vUpdate();
   return tMidRange;
};
tS32 dp_tclAudioManagerDPMidRange::s32GetData(tS8& tMidRangeParam) { 
   vUpdate();
   tMidRangeParam = tMidRange;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPMidRange::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MidRange", (tS32)0x7a9ca3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPMidRange::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPMidRange::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPMidRange::s32SetData(tS8 &tMidRangeParam) {
   //init parameter
   (tVoid)memcpy(&tMidRange,(tVoid*)&tMidRangeParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMidRangeParam' in function 'dp_tclAudioManagerDPMidRange::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPMidRange::s32SetData(const tS8 &tMidRangeParam) {
   //init parameter
   (tVoid)memcpy(&tMidRange,(tVoid*)&tMidRangeParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMidRangeParam' in function 'dp_tclAudioManagerDPMidRange::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPMidRange::u8GetData(tS8& tMidRangeParam) {  
   vUpdate();
   tMidRangeParam = tMidRange;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPMidRange::vSetData(tS8 &tMidRangeParam) { 
   //init parameter
   (tVoid)memcpy(&tMidRange,(tVoid*)&tMidRangeParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tMidRangeParam' in function 'dp_tclAudioManagerDPMidRange::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPMidRange::vSetData(const tS8 &tMidRangeParam) { 
   //init parameter
   (tVoid)memcpy(&tMidRange,(tVoid*)&tMidRangeParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tMidRangeParam' in function 'dp_tclAudioManagerDPMidRange::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPMidRange::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPMidRange::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "MidRange", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPMidRange::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "MidRange", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPMidRange::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element MidRange has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPFader::dp_tclAudioManagerDPFader(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFader,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPFader::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Fader",(tS32) 0xe672);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tFader = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPFader::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Fader", (tS32)0xe672);
   (tVoid)myDpElem.bFillData((tVoid*)&tFader, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPFader::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPFader::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPFader::tGetData() {
   vUpdate();
   return tFader;
};
tS32 dp_tclAudioManagerDPFader::s32GetData(tS8& tFaderParam) { 
   vUpdate();
   tFaderParam = tFader;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPFader::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Fader", (tS32)0xe672);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPFader::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPFader::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPFader::s32SetData(tS8 &tFaderParam) {
   //init parameter
   (tVoid)memcpy(&tFader,(tVoid*)&tFaderParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFaderParam' in function 'dp_tclAudioManagerDPFader::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPFader::s32SetData(const tS8 &tFaderParam) {
   //init parameter
   (tVoid)memcpy(&tFader,(tVoid*)&tFaderParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFaderParam' in function 'dp_tclAudioManagerDPFader::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPFader::u8GetData(tS8& tFaderParam) {  
   vUpdate();
   tFaderParam = tFader;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPFader::vSetData(tS8 &tFaderParam) { 
   //init parameter
   (tVoid)memcpy(&tFader,(tVoid*)&tFaderParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tFaderParam' in function 'dp_tclAudioManagerDPFader::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPFader::vSetData(const tS8 &tFaderParam) { 
   //init parameter
   (tVoid)memcpy(&tFader,(tVoid*)&tFaderParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tFaderParam' in function 'dp_tclAudioManagerDPFader::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPFader::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPFader::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Fader", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPFader::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Fader", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPFader::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Fader has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPBalance::dp_tclAudioManagerDPBalance(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBalance,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPBalance::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Balance",(tS32) 0x15a082);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tBalance = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPBalance::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Balance", (tS32)0x15a082);
   (tVoid)myDpElem.bFillData((tVoid*)&tBalance, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPBalance::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPBalance::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPBalance::tGetData() {
   vUpdate();
   return tBalance;
};
tS32 dp_tclAudioManagerDPBalance::s32GetData(tS8& tBalanceParam) { 
   vUpdate();
   tBalanceParam = tBalance;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPBalance::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Balance", (tS32)0x15a082);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPBalance::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPBalance::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPBalance::s32SetData(tS8 &tBalanceParam) {
   //init parameter
   (tVoid)memcpy(&tBalance,(tVoid*)&tBalanceParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBalanceParam' in function 'dp_tclAudioManagerDPBalance::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPBalance::s32SetData(const tS8 &tBalanceParam) {
   //init parameter
   (tVoid)memcpy(&tBalance,(tVoid*)&tBalanceParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBalanceParam' in function 'dp_tclAudioManagerDPBalance::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPBalance::u8GetData(tS8& tBalanceParam) {  
   vUpdate();
   tBalanceParam = tBalance;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPBalance::vSetData(tS8 &tBalanceParam) { 
   //init parameter
   (tVoid)memcpy(&tBalance,(tVoid*)&tBalanceParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBalanceParam' in function 'dp_tclAudioManagerDPBalance::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPBalance::vSetData(const tS8 &tBalanceParam) { 
   //init parameter
   (tVoid)memcpy(&tBalance,(tVoid*)&tBalanceParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBalanceParam' in function 'dp_tclAudioManagerDPBalance::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPBalance::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPBalance::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Balance", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBalance::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Balance", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBalance::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Balance has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Gala"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPGala::dp_tclAudioManagerDPGala(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGala,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPGala::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Gala",(tS32) 0x2ea1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tGala = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPGala::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Gala", (tS32)0x2ea1);
   (tVoid)myDpElem.bFillData((tVoid*)&tGala, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPGala::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPGala::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPGala::tGetData() {
   vUpdate();
   return tGala;
};
tS32 dp_tclAudioManagerDPGala::s32GetData(tU8& tGalaParam) { 
   vUpdate();
   tGalaParam = tGala;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPGala::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Gala", (tS32)0x2ea1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPGala::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPGala::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPGala::s32SetData(tU8 &tGalaParam) {
   //init parameter
   (tVoid)memcpy(&tGala,(tVoid*)&tGalaParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGalaParam' in function 'dp_tclAudioManagerDPGala::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPGala::s32SetData(const tU8 &tGalaParam) {
   //init parameter
   (tVoid)memcpy(&tGala,(tVoid*)&tGalaParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGalaParam' in function 'dp_tclAudioManagerDPGala::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPGala::u8GetData(tU8& tGalaParam) {  
   vUpdate();
   tGalaParam = tGala;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPGala::vSetData(tU8 &tGalaParam) { 
   //init parameter
   (tVoid)memcpy(&tGala,(tVoid*)&tGalaParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGalaParam' in function 'dp_tclAudioManagerDPGala::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPGala::vSetData(const tU8 &tGalaParam) { 
   //init parameter
   (tVoid)memcpy(&tGala,(tVoid*)&tGalaParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGalaParam' in function 'dp_tclAudioManagerDPGala::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPGala::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPGala::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Gala", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPGala::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Gala", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPGala::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Gala", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Gala has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PSA_Gala"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPPSA_Gala::dp_tclAudioManagerDPPSA_Gala(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPSA_Gala,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPPSA_Gala::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PSA_Gala",(tS32) 0x775800);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPSA_Gala = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPPSA_Gala::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PSA_Gala", (tS32)0x775800);
   (tVoid)myDpElem.bFillData((tVoid*)&tPSA_Gala, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPPSA_Gala::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPPSA_Gala::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPPSA_Gala::tGetData() {
   vUpdate();
   return tPSA_Gala;
};
tS32 dp_tclAudioManagerDPPSA_Gala::s32GetData(tU8& tPSA_GalaParam) { 
   vUpdate();
   tPSA_GalaParam = tPSA_Gala;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPPSA_Gala::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PSA_Gala", (tS32)0x775800);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPPSA_Gala::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPPSA_Gala::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPPSA_Gala::s32SetData(tU8 &tPSA_GalaParam) {
   //init parameter
   (tVoid)memcpy(&tPSA_Gala,(tVoid*)&tPSA_GalaParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPSA_GalaParam' in function 'dp_tclAudioManagerDPPSA_Gala::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPPSA_Gala::s32SetData(const tU8 &tPSA_GalaParam) {
   //init parameter
   (tVoid)memcpy(&tPSA_Gala,(tVoid*)&tPSA_GalaParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPSA_GalaParam' in function 'dp_tclAudioManagerDPPSA_Gala::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPPSA_Gala::u8GetData(tU8& tPSA_GalaParam) {  
   vUpdate();
   tPSA_GalaParam = tPSA_Gala;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPPSA_Gala::vSetData(tU8 &tPSA_GalaParam) { 
   //init parameter
   (tVoid)memcpy(&tPSA_Gala,(tVoid*)&tPSA_GalaParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPSA_GalaParam' in function 'dp_tclAudioManagerDPPSA_Gala::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPPSA_Gala::vSetData(const tU8 &tPSA_GalaParam) { 
   //init parameter
   (tVoid)memcpy(&tPSA_Gala,(tVoid*)&tPSA_GalaParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPSA_GalaParam' in function 'dp_tclAudioManagerDPPSA_Gala::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPPSA_Gala::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPPSA_Gala::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "PSA_Gala", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPPSA_Gala::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "PSA_Gala", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPPSA_Gala::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PSA_Gala", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element PSA_Gala has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AuxInLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPAuxInLevel::dp_tclAudioManagerDPAuxInLevel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAuxInLevel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPAuxInLevel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AuxInLevel",(tS32) 0xaf132b1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAuxInLevel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPAuxInLevel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AuxInLevel", (tS32)0xaf132b1);
   (tVoid)myDpElem.bFillData((tVoid*)&tAuxInLevel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPAuxInLevel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPAuxInLevel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPAuxInLevel::tGetData() {
   vUpdate();
   return tAuxInLevel;
};
tS32 dp_tclAudioManagerDPAuxInLevel::s32GetData(tU8& tAuxInLevelParam) { 
   vUpdate();
   tAuxInLevelParam = tAuxInLevel;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPAuxInLevel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AuxInLevel", (tS32)0xaf132b1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPAuxInLevel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPAuxInLevel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPAuxInLevel::s32SetData(tU8 &tAuxInLevelParam) {
   //init parameter
   (tVoid)memcpy(&tAuxInLevel,(tVoid*)&tAuxInLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAuxInLevelParam' in function 'dp_tclAudioManagerDPAuxInLevel::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPAuxInLevel::s32SetData(const tU8 &tAuxInLevelParam) {
   //init parameter
   (tVoid)memcpy(&tAuxInLevel,(tVoid*)&tAuxInLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAuxInLevelParam' in function 'dp_tclAudioManagerDPAuxInLevel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPAuxInLevel::u8GetData(tU8& tAuxInLevelParam) {  
   vUpdate();
   tAuxInLevelParam = tAuxInLevel;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPAuxInLevel::vSetData(tU8 &tAuxInLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tAuxInLevel,(tVoid*)&tAuxInLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAuxInLevelParam' in function 'dp_tclAudioManagerDPAuxInLevel::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPAuxInLevel::vSetData(const tU8 &tAuxInLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tAuxInLevel,(tVoid*)&tAuxInLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAuxInLevelParam' in function 'dp_tclAudioManagerDPAuxInLevel::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPAuxInLevel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPAuxInLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "AuxInLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAuxInLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "AuxInLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAuxInLevel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AuxInLevel", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element AuxInLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BeepLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPBeepLevel::dp_tclAudioManagerDPBeepLevel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBeepLevel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPBeepLevel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BeepLevel",(tS32) 0x2202f48);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tBeepLevel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPBeepLevel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BeepLevel", (tS32)0x2202f48);
   (tVoid)myDpElem.bFillData((tVoid*)&tBeepLevel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPBeepLevel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPBeepLevel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPBeepLevel::tGetData() {
   vUpdate();
   return tBeepLevel;
};
tS32 dp_tclAudioManagerDPBeepLevel::s32GetData(tU8& tBeepLevelParam) { 
   vUpdate();
   tBeepLevelParam = tBeepLevel;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPBeepLevel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BeepLevel", (tS32)0x2202f48);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPBeepLevel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPBeepLevel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPBeepLevel::s32SetData(tU8 &tBeepLevelParam) {
   //init parameter
   (tVoid)memcpy(&tBeepLevel,(tVoid*)&tBeepLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBeepLevelParam' in function 'dp_tclAudioManagerDPBeepLevel::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPBeepLevel::s32SetData(const tU8 &tBeepLevelParam) {
   //init parameter
   (tVoid)memcpy(&tBeepLevel,(tVoid*)&tBeepLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBeepLevelParam' in function 'dp_tclAudioManagerDPBeepLevel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPBeepLevel::u8GetData(tU8& tBeepLevelParam) {  
   vUpdate();
   tBeepLevelParam = tBeepLevel;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPBeepLevel::vSetData(tU8 &tBeepLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tBeepLevel,(tVoid*)&tBeepLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBeepLevelParam' in function 'dp_tclAudioManagerDPBeepLevel::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPBeepLevel::vSetData(const tU8 &tBeepLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tBeepLevel,(tVoid*)&tBeepLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBeepLevelParam' in function 'dp_tclAudioManagerDPBeepLevel::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPBeepLevel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPBeepLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "BeepLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBeepLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "BeepLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBeepLevel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BeepLevel", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element BeepLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RearMute"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPRearMute::dp_tclAudioManagerDPRearMute(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRearMute,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPRearMute::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RearMute",(tS32) 0x7fbf0d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRearMute = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPRearMute::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RearMute", (tS32)0x7fbf0d);
   (tVoid)myDpElem.bFillData((tVoid*)&tRearMute, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPRearMute::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPRearMute::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPRearMute::tGetData() {
   vUpdate();
   return tRearMute;
};
tS32 dp_tclAudioManagerDPRearMute::s32GetData(tU8& tRearMuteParam) { 
   vUpdate();
   tRearMuteParam = tRearMute;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPRearMute::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RearMute", (tS32)0x7fbf0d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPRearMute::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPRearMute::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPRearMute::s32SetData(tU8 &tRearMuteParam) {
   //init parameter
   (tVoid)memcpy(&tRearMute,(tVoid*)&tRearMuteParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRearMuteParam' in function 'dp_tclAudioManagerDPRearMute::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPRearMute::s32SetData(const tU8 &tRearMuteParam) {
   //init parameter
   (tVoid)memcpy(&tRearMute,(tVoid*)&tRearMuteParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRearMuteParam' in function 'dp_tclAudioManagerDPRearMute::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPRearMute::u8GetData(tU8& tRearMuteParam) {  
   vUpdate();
   tRearMuteParam = tRearMute;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPRearMute::vSetData(tU8 &tRearMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tRearMute,(tVoid*)&tRearMuteParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRearMuteParam' in function 'dp_tclAudioManagerDPRearMute::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPRearMute::vSetData(const tU8 &tRearMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tRearMute,(tVoid*)&tRearMuteParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRearMuteParam' in function 'dp_tclAudioManagerDPRearMute::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPRearMute::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPRearMute::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "RearMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPRearMute::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "RearMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPRearMute::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RearMute", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element RearMute has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EntOnVolumeSet"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPEntOnVolumeSet::dp_tclAudioManagerDPEntOnVolumeSet(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEntOnVolumeSet,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPEntOnVolumeSet::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EntOnVolumeSet",(tS32) 0x6c29846c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tEntOnVolumeSet = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPEntOnVolumeSet::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EntOnVolumeSet", (tS32)0x6c29846c);
   (tVoid)myDpElem.bFillData((tVoid*)&tEntOnVolumeSet, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPEntOnVolumeSet::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPEntOnVolumeSet::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPEntOnVolumeSet::tGetData() {
   vUpdate();
   return tEntOnVolumeSet;
};
tS32 dp_tclAudioManagerDPEntOnVolumeSet::s32GetData(tU8& tEntOnVolumeSetParam) { 
   vUpdate();
   tEntOnVolumeSetParam = tEntOnVolumeSet;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPEntOnVolumeSet::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EntOnVolumeSet", (tS32)0x6c29846c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPEntOnVolumeSet::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPEntOnVolumeSet::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPEntOnVolumeSet::s32SetData(tU8 &tEntOnVolumeSetParam) {
   //init parameter
   (tVoid)memcpy(&tEntOnVolumeSet,(tVoid*)&tEntOnVolumeSetParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEntOnVolumeSetParam' in function 'dp_tclAudioManagerDPEntOnVolumeSet::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPEntOnVolumeSet::s32SetData(const tU8 &tEntOnVolumeSetParam) {
   //init parameter
   (tVoid)memcpy(&tEntOnVolumeSet,(tVoid*)&tEntOnVolumeSetParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEntOnVolumeSetParam' in function 'dp_tclAudioManagerDPEntOnVolumeSet::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPEntOnVolumeSet::u8GetData(tU8& tEntOnVolumeSetParam) {  
   vUpdate();
   tEntOnVolumeSetParam = tEntOnVolumeSet;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPEntOnVolumeSet::vSetData(tU8 &tEntOnVolumeSetParam) { 
   //init parameter
   (tVoid)memcpy(&tEntOnVolumeSet,(tVoid*)&tEntOnVolumeSetParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEntOnVolumeSetParam' in function 'dp_tclAudioManagerDPEntOnVolumeSet::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPEntOnVolumeSet::vSetData(const tU8 &tEntOnVolumeSetParam) { 
   //init parameter
   (tVoid)memcpy(&tEntOnVolumeSet,(tVoid*)&tEntOnVolumeSetParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEntOnVolumeSetParam' in function 'dp_tclAudioManagerDPEntOnVolumeSet::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPEntOnVolumeSet::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPEntOnVolumeSet::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "EntOnVolumeSet", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPEntOnVolumeSet::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "EntOnVolumeSet", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPEntOnVolumeSet::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EntOnVolumeSet", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element EntOnVolumeSet has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MinimumOnVolLimit"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPMinimumOnVolLimit::dp_tclAudioManagerDPMinimumOnVolLimit(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMinimumOnVolLimit,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPMinimumOnVolLimit::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MinimumOnVolLimit",(tS32) 0xa4bc5ad1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMinimumOnVolLimit = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPMinimumOnVolLimit::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MinimumOnVolLimit", (tS32)0xa4bc5ad1);
   (tVoid)myDpElem.bFillData((tVoid*)&tMinimumOnVolLimit, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPMinimumOnVolLimit::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPMinimumOnVolLimit::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPMinimumOnVolLimit::tGetData() {
   vUpdate();
   return tMinimumOnVolLimit;
};
tS32 dp_tclAudioManagerDPMinimumOnVolLimit::s32GetData(tU8& tMinimumOnVolLimitParam) { 
   vUpdate();
   tMinimumOnVolLimitParam = tMinimumOnVolLimit;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPMinimumOnVolLimit::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MinimumOnVolLimit", (tS32)0xa4bc5ad1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPMinimumOnVolLimit::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPMinimumOnVolLimit::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPMinimumOnVolLimit::s32SetData(tU8 &tMinimumOnVolLimitParam) {
   //init parameter
   (tVoid)memcpy(&tMinimumOnVolLimit,(tVoid*)&tMinimumOnVolLimitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMinimumOnVolLimitParam' in function 'dp_tclAudioManagerDPMinimumOnVolLimit::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPMinimumOnVolLimit::s32SetData(const tU8 &tMinimumOnVolLimitParam) {
   //init parameter
   (tVoid)memcpy(&tMinimumOnVolLimit,(tVoid*)&tMinimumOnVolLimitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMinimumOnVolLimitParam' in function 'dp_tclAudioManagerDPMinimumOnVolLimit::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPMinimumOnVolLimit::u8GetData(tU8& tMinimumOnVolLimitParam) {  
   vUpdate();
   tMinimumOnVolLimitParam = tMinimumOnVolLimit;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPMinimumOnVolLimit::vSetData(tU8 &tMinimumOnVolLimitParam) { 
   //init parameter
   (tVoid)memcpy(&tMinimumOnVolLimit,(tVoid*)&tMinimumOnVolLimitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMinimumOnVolLimitParam' in function 'dp_tclAudioManagerDPMinimumOnVolLimit::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPMinimumOnVolLimit::vSetData(const tU8 &tMinimumOnVolLimitParam) { 
   //init parameter
   (tVoid)memcpy(&tMinimumOnVolLimit,(tVoid*)&tMinimumOnVolLimitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMinimumOnVolLimitParam' in function 'dp_tclAudioManagerDPMinimumOnVolLimit::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPMinimumOnVolLimit::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPMinimumOnVolLimit::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "MinimumOnVolLimit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPMinimumOnVolLimit::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "MinimumOnVolLimit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPMinimumOnVolLimit::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MinimumOnVolLimit", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element MinimumOnVolLimit has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GeometryMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPGeometryMode::dp_tclAudioManagerDPGeometryMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGeometryMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPGeometryMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GeometryMode",(tS32) 0x197de3c1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tGeometryMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPGeometryMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GeometryMode", (tS32)0x197de3c1);
   (tVoid)myDpElem.bFillData((tVoid*)&tGeometryMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPGeometryMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPGeometryMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPGeometryMode::tGetData() {
   vUpdate();
   return tGeometryMode;
};
tS32 dp_tclAudioManagerDPGeometryMode::s32GetData(tU8& tGeometryModeParam) { 
   vUpdate();
   tGeometryModeParam = tGeometryMode;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPGeometryMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GeometryMode", (tS32)0x197de3c1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPGeometryMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPGeometryMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPGeometryMode::s32SetData(tU8 &tGeometryModeParam) {
   //init parameter
   (tVoid)memcpy(&tGeometryMode,(tVoid*)&tGeometryModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGeometryModeParam' in function 'dp_tclAudioManagerDPGeometryMode::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPGeometryMode::s32SetData(const tU8 &tGeometryModeParam) {
   //init parameter
   (tVoid)memcpy(&tGeometryMode,(tVoid*)&tGeometryModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGeometryModeParam' in function 'dp_tclAudioManagerDPGeometryMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPGeometryMode::u8GetData(tU8& tGeometryModeParam) {  
   vUpdate();
   tGeometryModeParam = tGeometryMode;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPGeometryMode::vSetData(tU8 &tGeometryModeParam) { 
   //init parameter
   (tVoid)memcpy(&tGeometryMode,(tVoid*)&tGeometryModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGeometryModeParam' in function 'dp_tclAudioManagerDPGeometryMode::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPGeometryMode::vSetData(const tU8 &tGeometryModeParam) { 
   //init parameter
   (tVoid)memcpy(&tGeometryMode,(tVoid*)&tGeometryModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGeometryModeParam' in function 'dp_tclAudioManagerDPGeometryMode::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPGeometryMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPGeometryMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "GeometryMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPGeometryMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "GeometryMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPGeometryMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GeometryMode", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element GeometryMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Loudness"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPLoudness::dp_tclAudioManagerDPLoudness(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLoudness,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPLoudness::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Loudness",(tS32) 0x7bdae5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLoudness = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPLoudness::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Loudness", (tS32)0x7bdae5);
   (tVoid)myDpElem.bFillData((tVoid*)&tLoudness, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPLoudness::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPLoudness::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPLoudness::tGetData() {
   vUpdate();
   return tLoudness;
};
tS32 dp_tclAudioManagerDPLoudness::s32GetData(tU8& tLoudnessParam) { 
   vUpdate();
   tLoudnessParam = tLoudness;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPLoudness::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Loudness", (tS32)0x7bdae5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPLoudness::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPLoudness::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPLoudness::s32SetData(tU8 &tLoudnessParam) {
   //init parameter
   (tVoid)memcpy(&tLoudness,(tVoid*)&tLoudnessParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLoudnessParam' in function 'dp_tclAudioManagerDPLoudness::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPLoudness::s32SetData(const tU8 &tLoudnessParam) {
   //init parameter
   (tVoid)memcpy(&tLoudness,(tVoid*)&tLoudnessParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLoudnessParam' in function 'dp_tclAudioManagerDPLoudness::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPLoudness::u8GetData(tU8& tLoudnessParam) {  
   vUpdate();
   tLoudnessParam = tLoudness;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPLoudness::vSetData(tU8 &tLoudnessParam) { 
   //init parameter
   (tVoid)memcpy(&tLoudness,(tVoid*)&tLoudnessParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLoudnessParam' in function 'dp_tclAudioManagerDPLoudness::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPLoudness::vSetData(const tU8 &tLoudnessParam) { 
   //init parameter
   (tVoid)memcpy(&tLoudness,(tVoid*)&tLoudnessParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLoudnessParam' in function 'dp_tclAudioManagerDPLoudness::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPLoudness::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPLoudness::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Loudness", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPLoudness::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Loudness", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPLoudness::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Loudness", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Loudness has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Loudness_TEF"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPLoudness_TEF::dp_tclAudioManagerDPLoudness_TEF(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLoudness_TEF,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPLoudness_TEF::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Loudness_TEF",(tS32) 0x2e61a14b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLoudness_TEF = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPLoudness_TEF::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Loudness_TEF", (tS32)0x2e61a14b);
   (tVoid)myDpElem.bFillData((tVoid*)&tLoudness_TEF, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPLoudness_TEF::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPLoudness_TEF::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPLoudness_TEF::tGetData() {
   vUpdate();
   return tLoudness_TEF;
};
tS32 dp_tclAudioManagerDPLoudness_TEF::s32GetData(tU8& tLoudness_TEFParam) { 
   vUpdate();
   tLoudness_TEFParam = tLoudness_TEF;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPLoudness_TEF::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Loudness_TEF", (tS32)0x2e61a14b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPLoudness_TEF::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPLoudness_TEF::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPLoudness_TEF::s32SetData(tU8 &tLoudness_TEFParam) {
   //init parameter
   (tVoid)memcpy(&tLoudness_TEF,(tVoid*)&tLoudness_TEFParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLoudness_TEFParam' in function 'dp_tclAudioManagerDPLoudness_TEF::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPLoudness_TEF::s32SetData(const tU8 &tLoudness_TEFParam) {
   //init parameter
   (tVoid)memcpy(&tLoudness_TEF,(tVoid*)&tLoudness_TEFParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLoudness_TEFParam' in function 'dp_tclAudioManagerDPLoudness_TEF::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPLoudness_TEF::u8GetData(tU8& tLoudness_TEFParam) {  
   vUpdate();
   tLoudness_TEFParam = tLoudness_TEF;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPLoudness_TEF::vSetData(tU8 &tLoudness_TEFParam) { 
   //init parameter
   (tVoid)memcpy(&tLoudness_TEF,(tVoid*)&tLoudness_TEFParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLoudness_TEFParam' in function 'dp_tclAudioManagerDPLoudness_TEF::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPLoudness_TEF::vSetData(const tU8 &tLoudness_TEFParam) { 
   //init parameter
   (tVoid)memcpy(&tLoudness_TEF,(tVoid*)&tLoudness_TEFParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLoudness_TEFParam' in function 'dp_tclAudioManagerDPLoudness_TEF::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPLoudness_TEF::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPLoudness_TEF::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Loudness_TEF", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPLoudness_TEF::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Loudness_TEF", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPLoudness_TEF::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Loudness_TEF", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Loudness_TEF has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DynCompression"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPDynCompression::dp_tclAudioManagerDPDynCompression(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDynCompression,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPDynCompression::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DynCompression",(tS32) 0xabaf9df5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDynCompression = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPDynCompression::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DynCompression", (tS32)0xabaf9df5);
   (tVoid)myDpElem.bFillData((tVoid*)&tDynCompression, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPDynCompression::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPDynCompression::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPDynCompression::tGetData() {
   vUpdate();
   return tDynCompression;
};
tS32 dp_tclAudioManagerDPDynCompression::s32GetData(tU8& tDynCompressionParam) { 
   vUpdate();
   tDynCompressionParam = tDynCompression;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPDynCompression::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DynCompression", (tS32)0xabaf9df5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPDynCompression::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPDynCompression::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPDynCompression::s32SetData(tU8 &tDynCompressionParam) {
   //init parameter
   (tVoid)memcpy(&tDynCompression,(tVoid*)&tDynCompressionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDynCompressionParam' in function 'dp_tclAudioManagerDPDynCompression::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPDynCompression::s32SetData(const tU8 &tDynCompressionParam) {
   //init parameter
   (tVoid)memcpy(&tDynCompression,(tVoid*)&tDynCompressionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDynCompressionParam' in function 'dp_tclAudioManagerDPDynCompression::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPDynCompression::u8GetData(tU8& tDynCompressionParam) {  
   vUpdate();
   tDynCompressionParam = tDynCompression;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPDynCompression::vSetData(tU8 &tDynCompressionParam) { 
   //init parameter
   (tVoid)memcpy(&tDynCompression,(tVoid*)&tDynCompressionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDynCompressionParam' in function 'dp_tclAudioManagerDPDynCompression::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPDynCompression::vSetData(const tU8 &tDynCompressionParam) { 
   //init parameter
   (tVoid)memcpy(&tDynCompression,(tVoid*)&tDynCompressionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDynCompressionParam' in function 'dp_tclAudioManagerDPDynCompression::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPDynCompression::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPDynCompression::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "DynCompression", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPDynCompression::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "DynCompression", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPDynCompression::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DynCompression", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element DynCompression has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EquPreset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPEquPreset::dp_tclAudioManagerDPEquPreset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEquPreset,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPEquPreset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EquPreset",(tS32) 0x243057a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tEquPreset = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPEquPreset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EquPreset", (tS32)0x243057a);
   (tVoid)myDpElem.bFillData((tVoid*)&tEquPreset, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPEquPreset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPEquPreset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPEquPreset::tGetData() {
   vUpdate();
   return tEquPreset;
};
tS32 dp_tclAudioManagerDPEquPreset::s32GetData(tU8& tEquPresetParam) { 
   vUpdate();
   tEquPresetParam = tEquPreset;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPEquPreset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EquPreset", (tS32)0x243057a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPEquPreset::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPEquPreset::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPEquPreset::s32SetData(tU8 &tEquPresetParam) {
   //init parameter
   (tVoid)memcpy(&tEquPreset,(tVoid*)&tEquPresetParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEquPresetParam' in function 'dp_tclAudioManagerDPEquPreset::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPEquPreset::s32SetData(const tU8 &tEquPresetParam) {
   //init parameter
   (tVoid)memcpy(&tEquPreset,(tVoid*)&tEquPresetParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEquPresetParam' in function 'dp_tclAudioManagerDPEquPreset::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPEquPreset::u8GetData(tU8& tEquPresetParam) {  
   vUpdate();
   tEquPresetParam = tEquPreset;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPEquPreset::vSetData(tU8 &tEquPresetParam) { 
   //init parameter
   (tVoid)memcpy(&tEquPreset,(tVoid*)&tEquPresetParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEquPresetParam' in function 'dp_tclAudioManagerDPEquPreset::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPEquPreset::vSetData(const tU8 &tEquPresetParam) { 
   //init parameter
   (tVoid)memcpy(&tEquPreset,(tVoid*)&tEquPresetParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEquPresetParam' in function 'dp_tclAudioManagerDPEquPreset::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPEquPreset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPEquPreset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "EquPreset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPEquPreset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "EquPreset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPEquPreset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EquPreset", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element EquPreset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Optimization"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPOptimization::dp_tclAudioManagerDPOptimization(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tOptimization,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPOptimization::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Optimization",(tS32) 0x37b1ca9b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tOptimization = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPOptimization::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Optimization", (tS32)0x37b1ca9b);
   (tVoid)myDpElem.bFillData((tVoid*)&tOptimization, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPOptimization::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPOptimization::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPOptimization::tGetData() {
   vUpdate();
   return tOptimization;
};
tS32 dp_tclAudioManagerDPOptimization::s32GetData(tU8& tOptimizationParam) { 
   vUpdate();
   tOptimizationParam = tOptimization;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPOptimization::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Optimization", (tS32)0x37b1ca9b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPOptimization::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPOptimization::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPOptimization::s32SetData(tU8 &tOptimizationParam) {
   //init parameter
   (tVoid)memcpy(&tOptimization,(tVoid*)&tOptimizationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOptimizationParam' in function 'dp_tclAudioManagerDPOptimization::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPOptimization::s32SetData(const tU8 &tOptimizationParam) {
   //init parameter
   (tVoid)memcpy(&tOptimization,(tVoid*)&tOptimizationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOptimizationParam' in function 'dp_tclAudioManagerDPOptimization::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPOptimization::u8GetData(tU8& tOptimizationParam) {  
   vUpdate();
   tOptimizationParam = tOptimization;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPOptimization::vSetData(tU8 &tOptimizationParam) { 
   //init parameter
   (tVoid)memcpy(&tOptimization,(tVoid*)&tOptimizationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tOptimizationParam' in function 'dp_tclAudioManagerDPOptimization::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPOptimization::vSetData(const tU8 &tOptimizationParam) { 
   //init parameter
   (tVoid)memcpy(&tOptimization,(tVoid*)&tOptimizationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tOptimizationParam' in function 'dp_tclAudioManagerDPOptimization::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPOptimization::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPOptimization::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Optimization", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPOptimization::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Optimization", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPOptimization::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Optimization", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Optimization has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RoomEffect"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPRoomEffect::dp_tclAudioManagerDPRoomEffect(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRoomEffect,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPRoomEffect::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RoomEffect",(tS32) 0xcc4379e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRoomEffect = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPRoomEffect::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RoomEffect", (tS32)0xcc4379e);
   (tVoid)myDpElem.bFillData((tVoid*)&tRoomEffect, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPRoomEffect::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPRoomEffect::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPRoomEffect::tGetData() {
   vUpdate();
   return tRoomEffect;
};
tS32 dp_tclAudioManagerDPRoomEffect::s32GetData(tU8& tRoomEffectParam) { 
   vUpdate();
   tRoomEffectParam = tRoomEffect;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPRoomEffect::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RoomEffect", (tS32)0xcc4379e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPRoomEffect::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPRoomEffect::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPRoomEffect::s32SetData(tU8 &tRoomEffectParam) {
   //init parameter
   (tVoid)memcpy(&tRoomEffect,(tVoid*)&tRoomEffectParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRoomEffectParam' in function 'dp_tclAudioManagerDPRoomEffect::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPRoomEffect::s32SetData(const tU8 &tRoomEffectParam) {
   //init parameter
   (tVoid)memcpy(&tRoomEffect,(tVoid*)&tRoomEffectParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRoomEffectParam' in function 'dp_tclAudioManagerDPRoomEffect::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPRoomEffect::u8GetData(tU8& tRoomEffectParam) {  
   vUpdate();
   tRoomEffectParam = tRoomEffect;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPRoomEffect::vSetData(tU8 &tRoomEffectParam) { 
   //init parameter
   (tVoid)memcpy(&tRoomEffect,(tVoid*)&tRoomEffectParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRoomEffectParam' in function 'dp_tclAudioManagerDPRoomEffect::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPRoomEffect::vSetData(const tU8 &tRoomEffectParam) { 
   //init parameter
   (tVoid)memcpy(&tRoomEffect,(tVoid*)&tRoomEffectParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRoomEffectParam' in function 'dp_tclAudioManagerDPRoomEffect::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPRoomEffect::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPRoomEffect::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "RoomEffect", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPRoomEffect::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "RoomEffect", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPRoomEffect::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RoomEffect", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element RoomEffect has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SoundStaging"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPSoundStaging::dp_tclAudioManagerDPSoundStaging(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSoundStaging,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPSoundStaging::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SoundStaging",(tS32) 0x42ec54e2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSoundStaging = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPSoundStaging::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SoundStaging", (tS32)0x42ec54e2);
   (tVoid)myDpElem.bFillData((tVoid*)&tSoundStaging, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPSoundStaging::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPSoundStaging::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPSoundStaging::tGetData() {
   vUpdate();
   return tSoundStaging;
};
tS32 dp_tclAudioManagerDPSoundStaging::s32GetData(tU8& tSoundStagingParam) { 
   vUpdate();
   tSoundStagingParam = tSoundStaging;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPSoundStaging::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SoundStaging", (tS32)0x42ec54e2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPSoundStaging::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPSoundStaging::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPSoundStaging::s32SetData(tU8 &tSoundStagingParam) {
   //init parameter
   (tVoid)memcpy(&tSoundStaging,(tVoid*)&tSoundStagingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSoundStagingParam' in function 'dp_tclAudioManagerDPSoundStaging::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPSoundStaging::s32SetData(const tU8 &tSoundStagingParam) {
   //init parameter
   (tVoid)memcpy(&tSoundStaging,(tVoid*)&tSoundStagingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSoundStagingParam' in function 'dp_tclAudioManagerDPSoundStaging::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPSoundStaging::u8GetData(tU8& tSoundStagingParam) {  
   vUpdate();
   tSoundStagingParam = tSoundStaging;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPSoundStaging::vSetData(tU8 &tSoundStagingParam) { 
   //init parameter
   (tVoid)memcpy(&tSoundStaging,(tVoid*)&tSoundStagingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSoundStagingParam' in function 'dp_tclAudioManagerDPSoundStaging::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPSoundStaging::vSetData(const tU8 &tSoundStagingParam) { 
   //init parameter
   (tVoid)memcpy(&tSoundStaging,(tVoid*)&tSoundStagingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSoundStagingParam' in function 'dp_tclAudioManagerDPSoundStaging::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPSoundStaging::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPSoundStaging::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SoundStaging", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSoundStaging::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SoundStaging", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSoundStaging::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SoundStaging", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element SoundStaging has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_UPASoundtype"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPAdas_UPASoundtype::dp_tclAudioManagerDPAdas_UPASoundtype(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_UPASoundtype,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPAdas_UPASoundtype::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_UPASoundtype",(tS32) 0xecc601b9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_UPASoundtype = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPAdas_UPASoundtype::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_UPASoundtype", (tS32)0xecc601b9);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_UPASoundtype, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPAdas_UPASoundtype::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPAdas_UPASoundtype::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPAdas_UPASoundtype::tGetData() {
   vUpdate();
   return tAdas_UPASoundtype;
};
tS32 dp_tclAudioManagerDPAdas_UPASoundtype::s32GetData(tU8& tAdas_UPASoundtypeParam) { 
   vUpdate();
   tAdas_UPASoundtypeParam = tAdas_UPASoundtype;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPAdas_UPASoundtype::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_UPASoundtype", (tS32)0xecc601b9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPAdas_UPASoundtype::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPAdas_UPASoundtype::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPAdas_UPASoundtype::s32SetData(tU8 &tAdas_UPASoundtypeParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_UPASoundtype,(tVoid*)&tAdas_UPASoundtypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_UPASoundtypeParam' in function 'dp_tclAudioManagerDPAdas_UPASoundtype::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPAdas_UPASoundtype::s32SetData(const tU8 &tAdas_UPASoundtypeParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_UPASoundtype,(tVoid*)&tAdas_UPASoundtypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_UPASoundtypeParam' in function 'dp_tclAudioManagerDPAdas_UPASoundtype::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPAdas_UPASoundtype::u8GetData(tU8& tAdas_UPASoundtypeParam) {  
   vUpdate();
   tAdas_UPASoundtypeParam = tAdas_UPASoundtype;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPAdas_UPASoundtype::vSetData(tU8 &tAdas_UPASoundtypeParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_UPASoundtype,(tVoid*)&tAdas_UPASoundtypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_UPASoundtypeParam' in function 'dp_tclAudioManagerDPAdas_UPASoundtype::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPAdas_UPASoundtype::vSetData(const tU8 &tAdas_UPASoundtypeParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_UPASoundtype,(tVoid*)&tAdas_UPASoundtypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_UPASoundtypeParam' in function 'dp_tclAudioManagerDPAdas_UPASoundtype::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPAdas_UPASoundtype::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPAdas_UPASoundtype::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_UPASoundtype", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_UPASoundtype::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_UPASoundtype", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_UPASoundtype::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_UPASoundtype", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_UPASoundtype has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_ParkAssitVol"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPAdas_ParkAssitVol::dp_tclAudioManagerDPAdas_ParkAssitVol(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_ParkAssitVol,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPAdas_ParkAssitVol::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_ParkAssitVol",(tS32) 0xee2a3d0b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_ParkAssitVol = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPAdas_ParkAssitVol::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_ParkAssitVol", (tS32)0xee2a3d0b);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_ParkAssitVol, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPAdas_ParkAssitVol::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPAdas_ParkAssitVol::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPAdas_ParkAssitVol::tGetData() {
   vUpdate();
   return tAdas_ParkAssitVol;
};
tS32 dp_tclAudioManagerDPAdas_ParkAssitVol::s32GetData(tU8& tAdas_ParkAssitVolParam) { 
   vUpdate();
   tAdas_ParkAssitVolParam = tAdas_ParkAssitVol;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPAdas_ParkAssitVol::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_ParkAssitVol", (tS32)0xee2a3d0b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPAdas_ParkAssitVol::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPAdas_ParkAssitVol::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPAdas_ParkAssitVol::s32SetData(tU8 &tAdas_ParkAssitVolParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_ParkAssitVol,(tVoid*)&tAdas_ParkAssitVolParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_ParkAssitVolParam' in function 'dp_tclAudioManagerDPAdas_ParkAssitVol::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPAdas_ParkAssitVol::s32SetData(const tU8 &tAdas_ParkAssitVolParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_ParkAssitVol,(tVoid*)&tAdas_ParkAssitVolParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_ParkAssitVolParam' in function 'dp_tclAudioManagerDPAdas_ParkAssitVol::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPAdas_ParkAssitVol::u8GetData(tU8& tAdas_ParkAssitVolParam) {  
   vUpdate();
   tAdas_ParkAssitVolParam = tAdas_ParkAssitVol;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPAdas_ParkAssitVol::vSetData(tU8 &tAdas_ParkAssitVolParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_ParkAssitVol,(tVoid*)&tAdas_ParkAssitVolParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_ParkAssitVolParam' in function 'dp_tclAudioManagerDPAdas_ParkAssitVol::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPAdas_ParkAssitVol::vSetData(const tU8 &tAdas_ParkAssitVolParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_ParkAssitVol,(tVoid*)&tAdas_ParkAssitVolParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_ParkAssitVolParam' in function 'dp_tclAudioManagerDPAdas_ParkAssitVol::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPAdas_ParkAssitVol::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPAdas_ParkAssitVol::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_ParkAssitVol", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_ParkAssitVol::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_ParkAssitVol", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_ParkAssitVol::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_ParkAssitVol", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_ParkAssitVol has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_UPAMute"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPAdas_UPAMute::dp_tclAudioManagerDPAdas_UPAMute(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_UPAMute,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPAdas_UPAMute::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_UPAMute",(tS32) 0x5e45d59);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_UPAMute = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPAdas_UPAMute::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_UPAMute", (tS32)0x5e45d59);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_UPAMute, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPAdas_UPAMute::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPAdas_UPAMute::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPAdas_UPAMute::tGetData() {
   vUpdate();
   return tAdas_UPAMute;
};
tS32 dp_tclAudioManagerDPAdas_UPAMute::s32GetData(tU8& tAdas_UPAMuteParam) { 
   vUpdate();
   tAdas_UPAMuteParam = tAdas_UPAMute;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPAdas_UPAMute::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_UPAMute", (tS32)0x5e45d59);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPAdas_UPAMute::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPAdas_UPAMute::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPAdas_UPAMute::s32SetData(tU8 &tAdas_UPAMuteParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_UPAMute,(tVoid*)&tAdas_UPAMuteParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_UPAMuteParam' in function 'dp_tclAudioManagerDPAdas_UPAMute::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPAdas_UPAMute::s32SetData(const tU8 &tAdas_UPAMuteParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_UPAMute,(tVoid*)&tAdas_UPAMuteParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_UPAMuteParam' in function 'dp_tclAudioManagerDPAdas_UPAMute::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPAdas_UPAMute::u8GetData(tU8& tAdas_UPAMuteParam) {  
   vUpdate();
   tAdas_UPAMuteParam = tAdas_UPAMute;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPAdas_UPAMute::vSetData(tU8 &tAdas_UPAMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_UPAMute,(tVoid*)&tAdas_UPAMuteParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_UPAMuteParam' in function 'dp_tclAudioManagerDPAdas_UPAMute::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPAdas_UPAMute::vSetData(const tU8 &tAdas_UPAMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_UPAMute,(tVoid*)&tAdas_UPAMuteParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_UPAMuteParam' in function 'dp_tclAudioManagerDPAdas_UPAMute::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPAdas_UPAMute::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPAdas_UPAMute::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_UPAMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_UPAMute::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_UPAMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_UPAMute::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_UPAMute", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_UPAMute has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_LDWUSerVol"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPAdas_LDWUSerVol::dp_tclAudioManagerDPAdas_LDWUSerVol(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_LDWUSerVol,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPAdas_LDWUSerVol::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_LDWUSerVol",(tS32) 0xdf48452f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_LDWUSerVol = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPAdas_LDWUSerVol::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_LDWUSerVol", (tS32)0xdf48452f);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_LDWUSerVol, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPAdas_LDWUSerVol::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPAdas_LDWUSerVol::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPAdas_LDWUSerVol::tGetData() {
   vUpdate();
   return tAdas_LDWUSerVol;
};
tS32 dp_tclAudioManagerDPAdas_LDWUSerVol::s32GetData(tU8& tAdas_LDWUSerVolParam) { 
   vUpdate();
   tAdas_LDWUSerVolParam = tAdas_LDWUSerVol;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPAdas_LDWUSerVol::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_LDWUSerVol", (tS32)0xdf48452f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPAdas_LDWUSerVol::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPAdas_LDWUSerVol::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPAdas_LDWUSerVol::s32SetData(tU8 &tAdas_LDWUSerVolParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_LDWUSerVol,(tVoid*)&tAdas_LDWUSerVolParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_LDWUSerVolParam' in function 'dp_tclAudioManagerDPAdas_LDWUSerVol::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPAdas_LDWUSerVol::s32SetData(const tU8 &tAdas_LDWUSerVolParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_LDWUSerVol,(tVoid*)&tAdas_LDWUSerVolParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_LDWUSerVolParam' in function 'dp_tclAudioManagerDPAdas_LDWUSerVol::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPAdas_LDWUSerVol::u8GetData(tU8& tAdas_LDWUSerVolParam) {  
   vUpdate();
   tAdas_LDWUSerVolParam = tAdas_LDWUSerVol;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPAdas_LDWUSerVol::vSetData(tU8 &tAdas_LDWUSerVolParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_LDWUSerVol,(tVoid*)&tAdas_LDWUSerVolParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_LDWUSerVolParam' in function 'dp_tclAudioManagerDPAdas_LDWUSerVol::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPAdas_LDWUSerVol::vSetData(const tU8 &tAdas_LDWUSerVolParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_LDWUSerVol,(tVoid*)&tAdas_LDWUSerVolParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_LDWUSerVolParam' in function 'dp_tclAudioManagerDPAdas_LDWUSerVol::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPAdas_LDWUSerVol::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPAdas_LDWUSerVol::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_LDWUSerVol", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_LDWUSerVol::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_LDWUSerVol", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_LDWUSerVol::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_LDWUSerVol", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_LDWUSerVol has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_SRSoundState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPAdas_SRSoundState::dp_tclAudioManagerDPAdas_SRSoundState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_SRSoundState,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPAdas_SRSoundState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_SRSoundState",(tS32) 0xeae2159f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_SRSoundState = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPAdas_SRSoundState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_SRSoundState", (tS32)0xeae2159f);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_SRSoundState, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPAdas_SRSoundState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPAdas_SRSoundState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPAdas_SRSoundState::tGetData() {
   vUpdate();
   return tAdas_SRSoundState;
};
tS32 dp_tclAudioManagerDPAdas_SRSoundState::s32GetData(tU8& tAdas_SRSoundStateParam) { 
   vUpdate();
   tAdas_SRSoundStateParam = tAdas_SRSoundState;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPAdas_SRSoundState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_SRSoundState", (tS32)0xeae2159f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPAdas_SRSoundState::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPAdas_SRSoundState::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPAdas_SRSoundState::s32SetData(tU8 &tAdas_SRSoundStateParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_SRSoundState,(tVoid*)&tAdas_SRSoundStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_SRSoundStateParam' in function 'dp_tclAudioManagerDPAdas_SRSoundState::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPAdas_SRSoundState::s32SetData(const tU8 &tAdas_SRSoundStateParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_SRSoundState,(tVoid*)&tAdas_SRSoundStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_SRSoundStateParam' in function 'dp_tclAudioManagerDPAdas_SRSoundState::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPAdas_SRSoundState::u8GetData(tU8& tAdas_SRSoundStateParam) {  
   vUpdate();
   tAdas_SRSoundStateParam = tAdas_SRSoundState;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPAdas_SRSoundState::vSetData(tU8 &tAdas_SRSoundStateParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_SRSoundState,(tVoid*)&tAdas_SRSoundStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_SRSoundStateParam' in function 'dp_tclAudioManagerDPAdas_SRSoundState::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPAdas_SRSoundState::vSetData(const tU8 &tAdas_SRSoundStateParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_SRSoundState,(tVoid*)&tAdas_SRSoundStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_SRSoundStateParam' in function 'dp_tclAudioManagerDPAdas_SRSoundState::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPAdas_SRSoundState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPAdas_SRSoundState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_SRSoundState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_SRSoundState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Adas_SRSoundState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAdas_SRSoundState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_SRSoundState", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_SRSoundState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPBass_Max::dp_tclAudioManagerDPBass_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBass_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPBass_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Bass_Max",(tS32) 0x6c9ada);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tBass_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPBass_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Bass_Max", (tS32)0x6c9ada);
   (tVoid)myDpElem.bFillData((tVoid*)&tBass_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPBass_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPBass_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPBass_Max::tGetData() {
   vUpdate();
   return tBass_Max;
};
tS32 dp_tclAudioManagerDPBass_Max::s32GetData(tS8& tBass_MaxParam) { 
   vUpdate();
   tBass_MaxParam = tBass_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPBass_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Bass_Max", (tS32)0x6c9ada);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPBass_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPBass_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPBass_Max::s32SetData(tS8 &tBass_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tBass_Max,(tVoid*)&tBass_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBass_MaxParam' in function 'dp_tclAudioManagerDPBass_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPBass_Max::s32SetData(const tS8 &tBass_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tBass_Max,(tVoid*)&tBass_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBass_MaxParam' in function 'dp_tclAudioManagerDPBass_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPBass_Max::u8GetData(tS8& tBass_MaxParam) {  
   vUpdate();
   tBass_MaxParam = tBass_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPBass_Max::vSetData(tS8 &tBass_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tBass_Max,(tVoid*)&tBass_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBass_MaxParam' in function 'dp_tclAudioManagerDPBass_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPBass_Max::vSetData(const tS8 &tBass_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tBass_Max,(tVoid*)&tBass_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBass_MaxParam' in function 'dp_tclAudioManagerDPBass_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPBass_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPBass_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Bass_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBass_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Bass_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBass_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Bass_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Center_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPCenter_Max::dp_tclAudioManagerDPCenter_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCenter_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPCenter_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Center_Max",(tS32) 0xacbac1e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tCenter_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPCenter_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Center_Max", (tS32)0xacbac1e);
   (tVoid)myDpElem.bFillData((tVoid*)&tCenter_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPCenter_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPCenter_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPCenter_Max::tGetData() {
   vUpdate();
   return tCenter_Max;
};
tS32 dp_tclAudioManagerDPCenter_Max::s32GetData(tS8& tCenter_MaxParam) { 
   vUpdate();
   tCenter_MaxParam = tCenter_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPCenter_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Center_Max", (tS32)0xacbac1e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPCenter_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPCenter_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPCenter_Max::s32SetData(tS8 &tCenter_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tCenter_Max,(tVoid*)&tCenter_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenter_MaxParam' in function 'dp_tclAudioManagerDPCenter_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPCenter_Max::s32SetData(const tS8 &tCenter_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tCenter_Max,(tVoid*)&tCenter_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenter_MaxParam' in function 'dp_tclAudioManagerDPCenter_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPCenter_Max::u8GetData(tS8& tCenter_MaxParam) {  
   vUpdate();
   tCenter_MaxParam = tCenter_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPCenter_Max::vSetData(tS8 &tCenter_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tCenter_Max,(tVoid*)&tCenter_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tCenter_MaxParam' in function 'dp_tclAudioManagerDPCenter_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPCenter_Max::vSetData(const tS8 &tCenter_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tCenter_Max,(tVoid*)&tCenter_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tCenter_MaxParam' in function 'dp_tclAudioManagerDPCenter_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPCenter_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPCenter_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Center_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPCenter_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Center_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPCenter_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Center_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Center_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SubWoofer_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPSubWoofer_Max::dp_tclAudioManagerDPSubWoofer_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSubWoofer_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPSubWoofer_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SubWoofer_Max",(tS32) 0x52b73411);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tSubWoofer_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPSubWoofer_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SubWoofer_Max", (tS32)0x52b73411);
   (tVoid)myDpElem.bFillData((tVoid*)&tSubWoofer_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPSubWoofer_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPSubWoofer_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPSubWoofer_Max::tGetData() {
   vUpdate();
   return tSubWoofer_Max;
};
tS32 dp_tclAudioManagerDPSubWoofer_Max::s32GetData(tS8& tSubWoofer_MaxParam) { 
   vUpdate();
   tSubWoofer_MaxParam = tSubWoofer_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPSubWoofer_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SubWoofer_Max", (tS32)0x52b73411);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPSubWoofer_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPSubWoofer_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPSubWoofer_Max::s32SetData(tS8 &tSubWoofer_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Max,(tVoid*)&tSubWoofer_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWoofer_MaxParam' in function 'dp_tclAudioManagerDPSubWoofer_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPSubWoofer_Max::s32SetData(const tS8 &tSubWoofer_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Max,(tVoid*)&tSubWoofer_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWoofer_MaxParam' in function 'dp_tclAudioManagerDPSubWoofer_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPSubWoofer_Max::u8GetData(tS8& tSubWoofer_MaxParam) {  
   vUpdate();
   tSubWoofer_MaxParam = tSubWoofer_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPSubWoofer_Max::vSetData(tS8 &tSubWoofer_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Max,(tVoid*)&tSubWoofer_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tSubWoofer_MaxParam' in function 'dp_tclAudioManagerDPSubWoofer_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPSubWoofer_Max::vSetData(const tS8 &tSubWoofer_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Max,(tVoid*)&tSubWoofer_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tSubWoofer_MaxParam' in function 'dp_tclAudioManagerDPSubWoofer_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPSubWoofer_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPSubWoofer_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SubWoofer_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSubWoofer_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SubWoofer_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSubWoofer_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SubWoofer_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element SubWoofer_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPTreble_Max::dp_tclAudioManagerDPTreble_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTreble_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPTreble_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Treble_Max",(tS32) 0xd04fcbf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tTreble_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPTreble_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Treble_Max", (tS32)0xd04fcbf);
   (tVoid)myDpElem.bFillData((tVoid*)&tTreble_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPTreble_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPTreble_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPTreble_Max::tGetData() {
   vUpdate();
   return tTreble_Max;
};
tS32 dp_tclAudioManagerDPTreble_Max::s32GetData(tS8& tTreble_MaxParam) { 
   vUpdate();
   tTreble_MaxParam = tTreble_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPTreble_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Treble_Max", (tS32)0xd04fcbf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPTreble_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPTreble_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPTreble_Max::s32SetData(tS8 &tTreble_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tTreble_Max,(tVoid*)&tTreble_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTreble_MaxParam' in function 'dp_tclAudioManagerDPTreble_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPTreble_Max::s32SetData(const tS8 &tTreble_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tTreble_Max,(tVoid*)&tTreble_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTreble_MaxParam' in function 'dp_tclAudioManagerDPTreble_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPTreble_Max::u8GetData(tS8& tTreble_MaxParam) {  
   vUpdate();
   tTreble_MaxParam = tTreble_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPTreble_Max::vSetData(tS8 &tTreble_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tTreble_Max,(tVoid*)&tTreble_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tTreble_MaxParam' in function 'dp_tclAudioManagerDPTreble_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPTreble_Max::vSetData(const tS8 &tTreble_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tTreble_Max,(tVoid*)&tTreble_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tTreble_MaxParam' in function 'dp_tclAudioManagerDPTreble_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPTreble_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPTreble_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Treble_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPTreble_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Treble_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPTreble_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Treble_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPMidRange_Max::dp_tclAudioManagerDPMidRange_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMidRange_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPMidRange_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MidRange_Max",(tS32) 0x2b58a238);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tMidRange_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPMidRange_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MidRange_Max", (tS32)0x2b58a238);
   (tVoid)myDpElem.bFillData((tVoid*)&tMidRange_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPMidRange_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPMidRange_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPMidRange_Max::tGetData() {
   vUpdate();
   return tMidRange_Max;
};
tS32 dp_tclAudioManagerDPMidRange_Max::s32GetData(tS8& tMidRange_MaxParam) { 
   vUpdate();
   tMidRange_MaxParam = tMidRange_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPMidRange_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MidRange_Max", (tS32)0x2b58a238);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPMidRange_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPMidRange_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPMidRange_Max::s32SetData(tS8 &tMidRange_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tMidRange_Max,(tVoid*)&tMidRange_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMidRange_MaxParam' in function 'dp_tclAudioManagerDPMidRange_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPMidRange_Max::s32SetData(const tS8 &tMidRange_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tMidRange_Max,(tVoid*)&tMidRange_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMidRange_MaxParam' in function 'dp_tclAudioManagerDPMidRange_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPMidRange_Max::u8GetData(tS8& tMidRange_MaxParam) {  
   vUpdate();
   tMidRange_MaxParam = tMidRange_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPMidRange_Max::vSetData(tS8 &tMidRange_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tMidRange_Max,(tVoid*)&tMidRange_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tMidRange_MaxParam' in function 'dp_tclAudioManagerDPMidRange_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPMidRange_Max::vSetData(const tS8 &tMidRange_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tMidRange_Max,(tVoid*)&tMidRange_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tMidRange_MaxParam' in function 'dp_tclAudioManagerDPMidRange_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPMidRange_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPMidRange_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "MidRange_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPMidRange_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "MidRange_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPMidRange_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element MidRange_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPFader_Max::dp_tclAudioManagerDPFader_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFader_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPFader_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Fader_Max",(tS32) 0x232d497);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tFader_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPFader_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Fader_Max", (tS32)0x232d497);
   (tVoid)myDpElem.bFillData((tVoid*)&tFader_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPFader_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPFader_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPFader_Max::tGetData() {
   vUpdate();
   return tFader_Max;
};
tS32 dp_tclAudioManagerDPFader_Max::s32GetData(tS8& tFader_MaxParam) { 
   vUpdate();
   tFader_MaxParam = tFader_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPFader_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Fader_Max", (tS32)0x232d497);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPFader_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPFader_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPFader_Max::s32SetData(tS8 &tFader_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tFader_Max,(tVoid*)&tFader_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFader_MaxParam' in function 'dp_tclAudioManagerDPFader_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPFader_Max::s32SetData(const tS8 &tFader_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tFader_Max,(tVoid*)&tFader_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFader_MaxParam' in function 'dp_tclAudioManagerDPFader_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPFader_Max::u8GetData(tS8& tFader_MaxParam) {  
   vUpdate();
   tFader_MaxParam = tFader_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPFader_Max::vSetData(tS8 &tFader_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tFader_Max,(tVoid*)&tFader_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tFader_MaxParam' in function 'dp_tclAudioManagerDPFader_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPFader_Max::vSetData(const tS8 &tFader_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tFader_Max,(tVoid*)&tFader_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tFader_MaxParam' in function 'dp_tclAudioManagerDPFader_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPFader_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPFader_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Fader_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPFader_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Fader_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPFader_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Fader_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPBalance_Max::dp_tclAudioManagerDPBalance_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBalance_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPBalance_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Balance_Max",(tS32) 0x34cd15a7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tBalance_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPBalance_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Balance_Max", (tS32)0x34cd15a7);
   (tVoid)myDpElem.bFillData((tVoid*)&tBalance_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPBalance_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPBalance_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPBalance_Max::tGetData() {
   vUpdate();
   return tBalance_Max;
};
tS32 dp_tclAudioManagerDPBalance_Max::s32GetData(tS8& tBalance_MaxParam) { 
   vUpdate();
   tBalance_MaxParam = tBalance_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPBalance_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Balance_Max", (tS32)0x34cd15a7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPBalance_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPBalance_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPBalance_Max::s32SetData(tS8 &tBalance_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tBalance_Max,(tVoid*)&tBalance_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBalance_MaxParam' in function 'dp_tclAudioManagerDPBalance_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPBalance_Max::s32SetData(const tS8 &tBalance_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tBalance_Max,(tVoid*)&tBalance_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBalance_MaxParam' in function 'dp_tclAudioManagerDPBalance_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPBalance_Max::u8GetData(tS8& tBalance_MaxParam) {  
   vUpdate();
   tBalance_MaxParam = tBalance_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPBalance_Max::vSetData(tS8 &tBalance_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tBalance_Max,(tVoid*)&tBalance_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBalance_MaxParam' in function 'dp_tclAudioManagerDPBalance_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPBalance_Max::vSetData(const tS8 &tBalance_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tBalance_Max,(tVoid*)&tBalance_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBalance_MaxParam' in function 'dp_tclAudioManagerDPBalance_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPBalance_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPBalance_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Balance_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBalance_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Balance_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBalance_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Balance_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Gala_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPGala_Max::dp_tclAudioManagerDPGala_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGala_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPGala_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Gala_Max",(tS32) 0x720f56);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tGala_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPGala_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Gala_Max", (tS32)0x720f56);
   (tVoid)myDpElem.bFillData((tVoid*)&tGala_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPGala_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPGala_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPGala_Max::tGetData() {
   vUpdate();
   return tGala_Max;
};
tS32 dp_tclAudioManagerDPGala_Max::s32GetData(tS8& tGala_MaxParam) { 
   vUpdate();
   tGala_MaxParam = tGala_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPGala_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Gala_Max", (tS32)0x720f56);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPGala_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPGala_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPGala_Max::s32SetData(tS8 &tGala_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tGala_Max,(tVoid*)&tGala_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGala_MaxParam' in function 'dp_tclAudioManagerDPGala_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPGala_Max::s32SetData(const tS8 &tGala_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tGala_Max,(tVoid*)&tGala_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGala_MaxParam' in function 'dp_tclAudioManagerDPGala_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPGala_Max::u8GetData(tS8& tGala_MaxParam) {  
   vUpdate();
   tGala_MaxParam = tGala_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPGala_Max::vSetData(tS8 &tGala_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tGala_Max,(tVoid*)&tGala_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tGala_MaxParam' in function 'dp_tclAudioManagerDPGala_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPGala_Max::vSetData(const tS8 &tGala_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tGala_Max,(tVoid*)&tGala_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tGala_MaxParam' in function 'dp_tclAudioManagerDPGala_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPGala_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPGala_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Gala_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPGala_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Gala_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPGala_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Gala_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Gala_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Loudness_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPLoudness_Max::dp_tclAudioManagerDPLoudness_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLoudness_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPLoudness_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Loudness_Max",(tS32) 0x2e61a15a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tLoudness_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPLoudness_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Loudness_Max", (tS32)0x2e61a15a);
   (tVoid)myDpElem.bFillData((tVoid*)&tLoudness_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPLoudness_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPLoudness_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPLoudness_Max::tGetData() {
   vUpdate();
   return tLoudness_Max;
};
tS32 dp_tclAudioManagerDPLoudness_Max::s32GetData(tS8& tLoudness_MaxParam) { 
   vUpdate();
   tLoudness_MaxParam = tLoudness_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPLoudness_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Loudness_Max", (tS32)0x2e61a15a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPLoudness_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPLoudness_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPLoudness_Max::s32SetData(tS8 &tLoudness_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tLoudness_Max,(tVoid*)&tLoudness_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLoudness_MaxParam' in function 'dp_tclAudioManagerDPLoudness_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPLoudness_Max::s32SetData(const tS8 &tLoudness_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tLoudness_Max,(tVoid*)&tLoudness_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLoudness_MaxParam' in function 'dp_tclAudioManagerDPLoudness_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPLoudness_Max::u8GetData(tS8& tLoudness_MaxParam) {  
   vUpdate();
   tLoudness_MaxParam = tLoudness_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPLoudness_Max::vSetData(tS8 &tLoudness_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tLoudness_Max,(tVoid*)&tLoudness_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tLoudness_MaxParam' in function 'dp_tclAudioManagerDPLoudness_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPLoudness_Max::vSetData(const tS8 &tLoudness_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tLoudness_Max,(tVoid*)&tLoudness_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tLoudness_MaxParam' in function 'dp_tclAudioManagerDPLoudness_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPLoudness_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPLoudness_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Loudness_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPLoudness_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Loudness_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPLoudness_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Loudness_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Loudness_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DynCompression_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPDynCompression_Max::dp_tclAudioManagerDPDynCompression_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDynCompression_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPDynCompression_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DynCompression_Max",(tS32) 0x27c0db6a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tDynCompression_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPDynCompression_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DynCompression_Max", (tS32)0x27c0db6a);
   (tVoid)myDpElem.bFillData((tVoid*)&tDynCompression_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPDynCompression_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPDynCompression_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPDynCompression_Max::tGetData() {
   vUpdate();
   return tDynCompression_Max;
};
tS32 dp_tclAudioManagerDPDynCompression_Max::s32GetData(tS8& tDynCompression_MaxParam) { 
   vUpdate();
   tDynCompression_MaxParam = tDynCompression_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPDynCompression_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DynCompression_Max", (tS32)0x27c0db6a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPDynCompression_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPDynCompression_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPDynCompression_Max::s32SetData(tS8 &tDynCompression_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tDynCompression_Max,(tVoid*)&tDynCompression_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDynCompression_MaxParam' in function 'dp_tclAudioManagerDPDynCompression_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPDynCompression_Max::s32SetData(const tS8 &tDynCompression_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tDynCompression_Max,(tVoid*)&tDynCompression_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDynCompression_MaxParam' in function 'dp_tclAudioManagerDPDynCompression_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPDynCompression_Max::u8GetData(tS8& tDynCompression_MaxParam) {  
   vUpdate();
   tDynCompression_MaxParam = tDynCompression_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPDynCompression_Max::vSetData(tS8 &tDynCompression_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tDynCompression_Max,(tVoid*)&tDynCompression_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tDynCompression_MaxParam' in function 'dp_tclAudioManagerDPDynCompression_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPDynCompression_Max::vSetData(const tS8 &tDynCompression_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tDynCompression_Max,(tVoid*)&tDynCompression_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tDynCompression_MaxParam' in function 'dp_tclAudioManagerDPDynCompression_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPDynCompression_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPDynCompression_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "DynCompression_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPDynCompression_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "DynCompression_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPDynCompression_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DynCompression_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element DynCompression_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EquPreset_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPEquPreset_Max::dp_tclAudioManagerDPEquPreset_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEquPreset_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPEquPreset_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EquPreset_Max",(tS32) 0x85a0971f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tEquPreset_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPEquPreset_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EquPreset_Max", (tS32)0x85a0971f);
   (tVoid)myDpElem.bFillData((tVoid*)&tEquPreset_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPEquPreset_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPEquPreset_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPEquPreset_Max::tGetData() {
   vUpdate();
   return tEquPreset_Max;
};
tS32 dp_tclAudioManagerDPEquPreset_Max::s32GetData(tS8& tEquPreset_MaxParam) { 
   vUpdate();
   tEquPreset_MaxParam = tEquPreset_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPEquPreset_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EquPreset_Max", (tS32)0x85a0971f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPEquPreset_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPEquPreset_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPEquPreset_Max::s32SetData(tS8 &tEquPreset_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tEquPreset_Max,(tVoid*)&tEquPreset_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEquPreset_MaxParam' in function 'dp_tclAudioManagerDPEquPreset_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPEquPreset_Max::s32SetData(const tS8 &tEquPreset_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tEquPreset_Max,(tVoid*)&tEquPreset_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEquPreset_MaxParam' in function 'dp_tclAudioManagerDPEquPreset_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPEquPreset_Max::u8GetData(tS8& tEquPreset_MaxParam) {  
   vUpdate();
   tEquPreset_MaxParam = tEquPreset_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPEquPreset_Max::vSetData(tS8 &tEquPreset_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tEquPreset_Max,(tVoid*)&tEquPreset_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tEquPreset_MaxParam' in function 'dp_tclAudioManagerDPEquPreset_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPEquPreset_Max::vSetData(const tS8 &tEquPreset_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tEquPreset_Max,(tVoid*)&tEquPreset_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tEquPreset_MaxParam' in function 'dp_tclAudioManagerDPEquPreset_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPEquPreset_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPEquPreset_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "EquPreset_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPEquPreset_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "EquPreset_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPEquPreset_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EquPreset_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element EquPreset_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Optimization_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPOptimization_Max::dp_tclAudioManagerDPOptimization_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tOptimization_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPOptimization_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Optimization_Max",(tS32) 0xf90fdcb0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tOptimization_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPOptimization_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Optimization_Max", (tS32)0xf90fdcb0);
   (tVoid)myDpElem.bFillData((tVoid*)&tOptimization_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPOptimization_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPOptimization_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPOptimization_Max::tGetData() {
   vUpdate();
   return tOptimization_Max;
};
tS32 dp_tclAudioManagerDPOptimization_Max::s32GetData(tS8& tOptimization_MaxParam) { 
   vUpdate();
   tOptimization_MaxParam = tOptimization_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPOptimization_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Optimization_Max", (tS32)0xf90fdcb0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPOptimization_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPOptimization_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPOptimization_Max::s32SetData(tS8 &tOptimization_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tOptimization_Max,(tVoid*)&tOptimization_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOptimization_MaxParam' in function 'dp_tclAudioManagerDPOptimization_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPOptimization_Max::s32SetData(const tS8 &tOptimization_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tOptimization_Max,(tVoid*)&tOptimization_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOptimization_MaxParam' in function 'dp_tclAudioManagerDPOptimization_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPOptimization_Max::u8GetData(tS8& tOptimization_MaxParam) {  
   vUpdate();
   tOptimization_MaxParam = tOptimization_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPOptimization_Max::vSetData(tS8 &tOptimization_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tOptimization_Max,(tVoid*)&tOptimization_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tOptimization_MaxParam' in function 'dp_tclAudioManagerDPOptimization_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPOptimization_Max::vSetData(const tS8 &tOptimization_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tOptimization_Max,(tVoid*)&tOptimization_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tOptimization_MaxParam' in function 'dp_tclAudioManagerDPOptimization_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPOptimization_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPOptimization_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Optimization_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPOptimization_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Optimization_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPOptimization_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Optimization_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Optimization_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RoomEffect_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPRoomEffect_Max::dp_tclAudioManagerDPRoomEffect_Max(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRoomEffect_Max,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPRoomEffect_Max::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RoomEffect_Max",(tS32) 0x2b0c0103);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tRoomEffect_Max = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPRoomEffect_Max::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RoomEffect_Max", (tS32)0x2b0c0103);
   (tVoid)myDpElem.bFillData((tVoid*)&tRoomEffect_Max, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPRoomEffect_Max::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPRoomEffect_Max::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPRoomEffect_Max::tGetData() {
   vUpdate();
   return tRoomEffect_Max;
};
tS32 dp_tclAudioManagerDPRoomEffect_Max::s32GetData(tS8& tRoomEffect_MaxParam) { 
   vUpdate();
   tRoomEffect_MaxParam = tRoomEffect_Max;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPRoomEffect_Max::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RoomEffect_Max", (tS32)0x2b0c0103);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPRoomEffect_Max::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPRoomEffect_Max::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPRoomEffect_Max::s32SetData(tS8 &tRoomEffect_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tRoomEffect_Max,(tVoid*)&tRoomEffect_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRoomEffect_MaxParam' in function 'dp_tclAudioManagerDPRoomEffect_Max::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPRoomEffect_Max::s32SetData(const tS8 &tRoomEffect_MaxParam) {
   //init parameter
   (tVoid)memcpy(&tRoomEffect_Max,(tVoid*)&tRoomEffect_MaxParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRoomEffect_MaxParam' in function 'dp_tclAudioManagerDPRoomEffect_Max::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPRoomEffect_Max::u8GetData(tS8& tRoomEffect_MaxParam) {  
   vUpdate();
   tRoomEffect_MaxParam = tRoomEffect_Max;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPRoomEffect_Max::vSetData(tS8 &tRoomEffect_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tRoomEffect_Max,(tVoid*)&tRoomEffect_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tRoomEffect_MaxParam' in function 'dp_tclAudioManagerDPRoomEffect_Max::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPRoomEffect_Max::vSetData(const tS8 &tRoomEffect_MaxParam) { 
   //init parameter
   (tVoid)memcpy(&tRoomEffect_Max,(tVoid*)&tRoomEffect_MaxParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tRoomEffect_MaxParam' in function 'dp_tclAudioManagerDPRoomEffect_Max::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPRoomEffect_Max::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPRoomEffect_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "RoomEffect_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPRoomEffect_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "RoomEffect_Max", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPRoomEffect_Max::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RoomEffect_Max", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element RoomEffect_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPBass_Min::dp_tclAudioManagerDPBass_Min(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBass_Min,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPBass_Min::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Bass_Min",(tS32) 0x6c9af8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tBass_Min = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPBass_Min::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Bass_Min", (tS32)0x6c9af8);
   (tVoid)myDpElem.bFillData((tVoid*)&tBass_Min, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPBass_Min::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPBass_Min::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPBass_Min::tGetData() {
   vUpdate();
   return tBass_Min;
};
tS32 dp_tclAudioManagerDPBass_Min::s32GetData(tS8& tBass_MinParam) { 
   vUpdate();
   tBass_MinParam = tBass_Min;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPBass_Min::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Bass_Min", (tS32)0x6c9af8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPBass_Min::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPBass_Min::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPBass_Min::s32SetData(tS8 &tBass_MinParam) {
   //init parameter
   (tVoid)memcpy(&tBass_Min,(tVoid*)&tBass_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBass_MinParam' in function 'dp_tclAudioManagerDPBass_Min::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPBass_Min::s32SetData(const tS8 &tBass_MinParam) {
   //init parameter
   (tVoid)memcpy(&tBass_Min,(tVoid*)&tBass_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBass_MinParam' in function 'dp_tclAudioManagerDPBass_Min::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPBass_Min::u8GetData(tS8& tBass_MinParam) {  
   vUpdate();
   tBass_MinParam = tBass_Min;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPBass_Min::vSetData(tS8 &tBass_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tBass_Min,(tVoid*)&tBass_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBass_MinParam' in function 'dp_tclAudioManagerDPBass_Min::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPBass_Min::vSetData(const tS8 &tBass_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tBass_Min,(tVoid*)&tBass_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBass_MinParam' in function 'dp_tclAudioManagerDPBass_Min::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPBass_Min::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPBass_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Bass_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBass_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Bass_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBass_Min::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass_Min", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Bass_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Center_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPCenter_Min::dp_tclAudioManagerDPCenter_Min(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCenter_Min,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPCenter_Min::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Center_Min",(tS32) 0xacbac3c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tCenter_Min = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPCenter_Min::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Center_Min", (tS32)0xacbac3c);
   (tVoid)myDpElem.bFillData((tVoid*)&tCenter_Min, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPCenter_Min::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPCenter_Min::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPCenter_Min::tGetData() {
   vUpdate();
   return tCenter_Min;
};
tS32 dp_tclAudioManagerDPCenter_Min::s32GetData(tS8& tCenter_MinParam) { 
   vUpdate();
   tCenter_MinParam = tCenter_Min;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPCenter_Min::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Center_Min", (tS32)0xacbac3c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPCenter_Min::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPCenter_Min::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPCenter_Min::s32SetData(tS8 &tCenter_MinParam) {
   //init parameter
   (tVoid)memcpy(&tCenter_Min,(tVoid*)&tCenter_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenter_MinParam' in function 'dp_tclAudioManagerDPCenter_Min::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPCenter_Min::s32SetData(const tS8 &tCenter_MinParam) {
   //init parameter
   (tVoid)memcpy(&tCenter_Min,(tVoid*)&tCenter_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenter_MinParam' in function 'dp_tclAudioManagerDPCenter_Min::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPCenter_Min::u8GetData(tS8& tCenter_MinParam) {  
   vUpdate();
   tCenter_MinParam = tCenter_Min;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPCenter_Min::vSetData(tS8 &tCenter_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tCenter_Min,(tVoid*)&tCenter_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tCenter_MinParam' in function 'dp_tclAudioManagerDPCenter_Min::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPCenter_Min::vSetData(const tS8 &tCenter_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tCenter_Min,(tVoid*)&tCenter_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tCenter_MinParam' in function 'dp_tclAudioManagerDPCenter_Min::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPCenter_Min::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPCenter_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Center_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPCenter_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Center_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPCenter_Min::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Center_Min", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Center_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SubWoofer_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPSubWoofer_Min::dp_tclAudioManagerDPSubWoofer_Min(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSubWoofer_Min,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPSubWoofer_Min::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SubWoofer_Min",(tS32) 0x52b7342f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tSubWoofer_Min = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPSubWoofer_Min::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SubWoofer_Min", (tS32)0x52b7342f);
   (tVoid)myDpElem.bFillData((tVoid*)&tSubWoofer_Min, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPSubWoofer_Min::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPSubWoofer_Min::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPSubWoofer_Min::tGetData() {
   vUpdate();
   return tSubWoofer_Min;
};
tS32 dp_tclAudioManagerDPSubWoofer_Min::s32GetData(tS8& tSubWoofer_MinParam) { 
   vUpdate();
   tSubWoofer_MinParam = tSubWoofer_Min;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPSubWoofer_Min::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SubWoofer_Min", (tS32)0x52b7342f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPSubWoofer_Min::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPSubWoofer_Min::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPSubWoofer_Min::s32SetData(tS8 &tSubWoofer_MinParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Min,(tVoid*)&tSubWoofer_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWoofer_MinParam' in function 'dp_tclAudioManagerDPSubWoofer_Min::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPSubWoofer_Min::s32SetData(const tS8 &tSubWoofer_MinParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Min,(tVoid*)&tSubWoofer_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWoofer_MinParam' in function 'dp_tclAudioManagerDPSubWoofer_Min::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPSubWoofer_Min::u8GetData(tS8& tSubWoofer_MinParam) {  
   vUpdate();
   tSubWoofer_MinParam = tSubWoofer_Min;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPSubWoofer_Min::vSetData(tS8 &tSubWoofer_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Min,(tVoid*)&tSubWoofer_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tSubWoofer_MinParam' in function 'dp_tclAudioManagerDPSubWoofer_Min::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPSubWoofer_Min::vSetData(const tS8 &tSubWoofer_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Min,(tVoid*)&tSubWoofer_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tSubWoofer_MinParam' in function 'dp_tclAudioManagerDPSubWoofer_Min::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPSubWoofer_Min::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPSubWoofer_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SubWoofer_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSubWoofer_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SubWoofer_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSubWoofer_Min::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SubWoofer_Min", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element SubWoofer_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPTreble_Min::dp_tclAudioManagerDPTreble_Min(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTreble_Min,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPTreble_Min::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Treble_Min",(tS32) 0xd04fcdd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tTreble_Min = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPTreble_Min::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Treble_Min", (tS32)0xd04fcdd);
   (tVoid)myDpElem.bFillData((tVoid*)&tTreble_Min, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPTreble_Min::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPTreble_Min::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPTreble_Min::tGetData() {
   vUpdate();
   return tTreble_Min;
};
tS32 dp_tclAudioManagerDPTreble_Min::s32GetData(tS8& tTreble_MinParam) { 
   vUpdate();
   tTreble_MinParam = tTreble_Min;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPTreble_Min::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Treble_Min", (tS32)0xd04fcdd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPTreble_Min::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPTreble_Min::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPTreble_Min::s32SetData(tS8 &tTreble_MinParam) {
   //init parameter
   (tVoid)memcpy(&tTreble_Min,(tVoid*)&tTreble_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTreble_MinParam' in function 'dp_tclAudioManagerDPTreble_Min::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPTreble_Min::s32SetData(const tS8 &tTreble_MinParam) {
   //init parameter
   (tVoid)memcpy(&tTreble_Min,(tVoid*)&tTreble_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTreble_MinParam' in function 'dp_tclAudioManagerDPTreble_Min::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPTreble_Min::u8GetData(tS8& tTreble_MinParam) {  
   vUpdate();
   tTreble_MinParam = tTreble_Min;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPTreble_Min::vSetData(tS8 &tTreble_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tTreble_Min,(tVoid*)&tTreble_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tTreble_MinParam' in function 'dp_tclAudioManagerDPTreble_Min::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPTreble_Min::vSetData(const tS8 &tTreble_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tTreble_Min,(tVoid*)&tTreble_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tTreble_MinParam' in function 'dp_tclAudioManagerDPTreble_Min::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPTreble_Min::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPTreble_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Treble_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPTreble_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Treble_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPTreble_Min::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble_Min", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Treble_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPMidRange_Min::dp_tclAudioManagerDPMidRange_Min(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMidRange_Min,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPMidRange_Min::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MidRange_Min",(tS32) 0x2b58a256);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tMidRange_Min = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPMidRange_Min::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MidRange_Min", (tS32)0x2b58a256);
   (tVoid)myDpElem.bFillData((tVoid*)&tMidRange_Min, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPMidRange_Min::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPMidRange_Min::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPMidRange_Min::tGetData() {
   vUpdate();
   return tMidRange_Min;
};
tS32 dp_tclAudioManagerDPMidRange_Min::s32GetData(tS8& tMidRange_MinParam) { 
   vUpdate();
   tMidRange_MinParam = tMidRange_Min;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPMidRange_Min::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MidRange_Min", (tS32)0x2b58a256);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPMidRange_Min::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPMidRange_Min::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPMidRange_Min::s32SetData(tS8 &tMidRange_MinParam) {
   //init parameter
   (tVoid)memcpy(&tMidRange_Min,(tVoid*)&tMidRange_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMidRange_MinParam' in function 'dp_tclAudioManagerDPMidRange_Min::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPMidRange_Min::s32SetData(const tS8 &tMidRange_MinParam) {
   //init parameter
   (tVoid)memcpy(&tMidRange_Min,(tVoid*)&tMidRange_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMidRange_MinParam' in function 'dp_tclAudioManagerDPMidRange_Min::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPMidRange_Min::u8GetData(tS8& tMidRange_MinParam) {  
   vUpdate();
   tMidRange_MinParam = tMidRange_Min;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPMidRange_Min::vSetData(tS8 &tMidRange_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tMidRange_Min,(tVoid*)&tMidRange_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tMidRange_MinParam' in function 'dp_tclAudioManagerDPMidRange_Min::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPMidRange_Min::vSetData(const tS8 &tMidRange_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tMidRange_Min,(tVoid*)&tMidRange_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tMidRange_MinParam' in function 'dp_tclAudioManagerDPMidRange_Min::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPMidRange_Min::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPMidRange_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "MidRange_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPMidRange_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "MidRange_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPMidRange_Min::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange_Min", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element MidRange_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPFader_Min::dp_tclAudioManagerDPFader_Min(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFader_Min,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPFader_Min::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Fader_Min",(tS32) 0x232d4b5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tFader_Min = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPFader_Min::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Fader_Min", (tS32)0x232d4b5);
   (tVoid)myDpElem.bFillData((tVoid*)&tFader_Min, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPFader_Min::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPFader_Min::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPFader_Min::tGetData() {
   vUpdate();
   return tFader_Min;
};
tS32 dp_tclAudioManagerDPFader_Min::s32GetData(tS8& tFader_MinParam) { 
   vUpdate();
   tFader_MinParam = tFader_Min;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPFader_Min::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Fader_Min", (tS32)0x232d4b5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPFader_Min::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPFader_Min::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPFader_Min::s32SetData(tS8 &tFader_MinParam) {
   //init parameter
   (tVoid)memcpy(&tFader_Min,(tVoid*)&tFader_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFader_MinParam' in function 'dp_tclAudioManagerDPFader_Min::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPFader_Min::s32SetData(const tS8 &tFader_MinParam) {
   //init parameter
   (tVoid)memcpy(&tFader_Min,(tVoid*)&tFader_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFader_MinParam' in function 'dp_tclAudioManagerDPFader_Min::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPFader_Min::u8GetData(tS8& tFader_MinParam) {  
   vUpdate();
   tFader_MinParam = tFader_Min;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPFader_Min::vSetData(tS8 &tFader_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tFader_Min,(tVoid*)&tFader_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tFader_MinParam' in function 'dp_tclAudioManagerDPFader_Min::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPFader_Min::vSetData(const tS8 &tFader_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tFader_Min,(tVoid*)&tFader_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tFader_MinParam' in function 'dp_tclAudioManagerDPFader_Min::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPFader_Min::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPFader_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Fader_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPFader_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Fader_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPFader_Min::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader_Min", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Fader_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPBalance_Min::dp_tclAudioManagerDPBalance_Min(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBalance_Min,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPBalance_Min::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Balance_Min",(tS32) 0x34cd15c5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tBalance_Min = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPBalance_Min::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Balance_Min", (tS32)0x34cd15c5);
   (tVoid)myDpElem.bFillData((tVoid*)&tBalance_Min, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPBalance_Min::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPBalance_Min::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPBalance_Min::tGetData() {
   vUpdate();
   return tBalance_Min;
};
tS32 dp_tclAudioManagerDPBalance_Min::s32GetData(tS8& tBalance_MinParam) { 
   vUpdate();
   tBalance_MinParam = tBalance_Min;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPBalance_Min::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Balance_Min", (tS32)0x34cd15c5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPBalance_Min::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPBalance_Min::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPBalance_Min::s32SetData(tS8 &tBalance_MinParam) {
   //init parameter
   (tVoid)memcpy(&tBalance_Min,(tVoid*)&tBalance_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBalance_MinParam' in function 'dp_tclAudioManagerDPBalance_Min::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPBalance_Min::s32SetData(const tS8 &tBalance_MinParam) {
   //init parameter
   (tVoid)memcpy(&tBalance_Min,(tVoid*)&tBalance_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBalance_MinParam' in function 'dp_tclAudioManagerDPBalance_Min::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPBalance_Min::u8GetData(tS8& tBalance_MinParam) {  
   vUpdate();
   tBalance_MinParam = tBalance_Min;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPBalance_Min::vSetData(tS8 &tBalance_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tBalance_Min,(tVoid*)&tBalance_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBalance_MinParam' in function 'dp_tclAudioManagerDPBalance_Min::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPBalance_Min::vSetData(const tS8 &tBalance_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tBalance_Min,(tVoid*)&tBalance_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBalance_MinParam' in function 'dp_tclAudioManagerDPBalance_Min::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPBalance_Min::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPBalance_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Balance_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBalance_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Balance_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPBalance_Min::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance_Min", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Balance_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Loudness_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPLoudness_Min::dp_tclAudioManagerDPLoudness_Min(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLoudness_Min,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPLoudness_Min::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Loudness_Min",(tS32) 0x2e61a178);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tLoudness_Min = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPLoudness_Min::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Loudness_Min", (tS32)0x2e61a178);
   (tVoid)myDpElem.bFillData((tVoid*)&tLoudness_Min, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPLoudness_Min::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPLoudness_Min::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerDPLoudness_Min::tGetData() {
   vUpdate();
   return tLoudness_Min;
};
tS32 dp_tclAudioManagerDPLoudness_Min::s32GetData(tS8& tLoudness_MinParam) { 
   vUpdate();
   tLoudness_MinParam = tLoudness_Min;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPLoudness_Min::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Loudness_Min", (tS32)0x2e61a178);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPLoudness_Min::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPLoudness_Min::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPLoudness_Min::s32SetData(tS8 &tLoudness_MinParam) {
   //init parameter
   (tVoid)memcpy(&tLoudness_Min,(tVoid*)&tLoudness_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLoudness_MinParam' in function 'dp_tclAudioManagerDPLoudness_Min::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerDPLoudness_Min::s32SetData(const tS8 &tLoudness_MinParam) {
   //init parameter
   (tVoid)memcpy(&tLoudness_Min,(tVoid*)&tLoudness_MinParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLoudness_MinParam' in function 'dp_tclAudioManagerDPLoudness_Min::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPLoudness_Min::u8GetData(tS8& tLoudness_MinParam) {  
   vUpdate();
   tLoudness_MinParam = tLoudness_Min;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPLoudness_Min::vSetData(tS8 &tLoudness_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tLoudness_Min,(tVoid*)&tLoudness_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tLoudness_MinParam' in function 'dp_tclAudioManagerDPLoudness_Min::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerDPLoudness_Min::vSetData(const tS8 &tLoudness_MinParam) { 
   //init parameter
   (tVoid)memcpy(&tLoudness_Min,(tVoid*)&tLoudness_MinParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tLoudness_MinParam' in function 'dp_tclAudioManagerDPLoudness_Min::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerDPLoudness_Min::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPLoudness_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Loudness_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPLoudness_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Loudness_Min", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPLoudness_Min::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Loudness_Min", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Loudness_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Volumes"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPVolumes::dp_tclAudioManagerDPVolumes(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPVolumes::s32SetData( VolumeManager::tVolumelistEntry* tVolumesParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Volumes", (tS32)0x1b19df);
   (tVoid)myDpElem.bFillData((tVoid*)tVolumesParam, ((tU32)sizeof(VolumeManager::tVolumelistEntry))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPVolumes::s32GetData(VolumeManager::tVolumelistEntry* tVolumesParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Volumes", (tS32)0x1b19df);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(VolumeManager::tVolumelistEntry)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(VolumeManager::tVolumelistEntry));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tVolumesParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(VolumeManager::tVolumelistEntry));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPVolumes::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPVolumes::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPVolumes::u16GetData(VolumeManager::tVolumelistEntry* tVolumesParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tVolumesParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPVolumes::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Volumes", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPVolumes::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Volumes", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPVolumes::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Volumes", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element Volumes has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Volumes_Sink2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPVolumes_Sink2::dp_tclAudioManagerDPVolumes_Sink2(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPVolumes_Sink2::s32SetData( VolumeManager::tVolumelistEntry* tVolumes_Sink2Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Volumes_Sink2", (tS32)0x76239e71);
   (tVoid)myDpElem.bFillData((tVoid*)tVolumes_Sink2Param, ((tU32)sizeof(VolumeManager::tVolumelistEntry))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPVolumes_Sink2::s32GetData(VolumeManager::tVolumelistEntry* tVolumes_Sink2Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Volumes_Sink2", (tS32)0x76239e71);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(VolumeManager::tVolumelistEntry)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(VolumeManager::tVolumelistEntry));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tVolumes_Sink2Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(VolumeManager::tVolumelistEntry));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPVolumes_Sink2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPVolumes_Sink2::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPVolumes_Sink2::u16GetData(VolumeManager::tVolumelistEntry* tVolumes_Sink2Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tVolumes_Sink2Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPVolumes_Sink2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Volumes_Sink2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPVolumes_Sink2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Volumes_Sink2", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPVolumes_Sink2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Volumes_Sink2", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element Volumes_Sink2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDCSetup_Volume"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPPDCSetup_Volume::dp_tclAudioManagerDPPDCSetup_Volume(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDCSetup_Volume,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPPDCSetup_Volume::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDCSetup_Volume",(tS32) 0xfabc497);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDCSetup_Volume = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPPDCSetup_Volume::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDCSetup_Volume", (tS32)0xfabc497);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDCSetup_Volume, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPPDCSetup_Volume::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPPDCSetup_Volume::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPPDCSetup_Volume::tGetData() {
   vUpdate();
   return tPDCSetup_Volume;
};
tS32 dp_tclAudioManagerDPPDCSetup_Volume::s32GetData(tU8& tPDCSetup_VolumeParam) { 
   vUpdate();
   tPDCSetup_VolumeParam = tPDCSetup_Volume;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPPDCSetup_Volume::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDCSetup_Volume", (tS32)0xfabc497);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPPDCSetup_Volume::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPPDCSetup_Volume::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPPDCSetup_Volume::s32SetData(tU8 &tPDCSetup_VolumeParam) {
   //init parameter
   (tVoid)memcpy(&tPDCSetup_Volume,(tVoid*)&tPDCSetup_VolumeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDCSetup_VolumeParam' in function 'dp_tclAudioManagerDPPDCSetup_Volume::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPPDCSetup_Volume::s32SetData(const tU8 &tPDCSetup_VolumeParam) {
   //init parameter
   (tVoid)memcpy(&tPDCSetup_Volume,(tVoid*)&tPDCSetup_VolumeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDCSetup_VolumeParam' in function 'dp_tclAudioManagerDPPDCSetup_Volume::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPPDCSetup_Volume::u8GetData(tU8& tPDCSetup_VolumeParam) {  
   vUpdate();
   tPDCSetup_VolumeParam = tPDCSetup_Volume;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPPDCSetup_Volume::vSetData(tU8 &tPDCSetup_VolumeParam) { 
   //init parameter
   (tVoid)memcpy(&tPDCSetup_Volume,(tVoid*)&tPDCSetup_VolumeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDCSetup_VolumeParam' in function 'dp_tclAudioManagerDPPDCSetup_Volume::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPPDCSetup_Volume::vSetData(const tU8 &tPDCSetup_VolumeParam) { 
   //init parameter
   (tVoid)memcpy(&tPDCSetup_Volume,(tVoid*)&tPDCSetup_VolumeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDCSetup_VolumeParam' in function 'dp_tclAudioManagerDPPDCSetup_Volume::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPPDCSetup_Volume::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPPDCSetup_Volume::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "PDCSetup_Volume", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPPDCSetup_Volume::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "PDCSetup_Volume", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPPDCSetup_Volume::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDCSetup_Volume", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element PDCSetup_Volume has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CenterGain"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPCenterGain::dp_tclAudioManagerDPCenterGain(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCenterGain,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPCenterGain::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CenterGain",(tS32) 0xacba278);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCenterGain = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPCenterGain::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CenterGain", (tS32)0xacba278);
   (tVoid)myDpElem.bFillData((tVoid*)&tCenterGain, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPCenterGain::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPCenterGain::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclAudioManagerDPCenterGain::tGetData() {
   vUpdate();
   return tCenterGain;
};
tS32 dp_tclAudioManagerDPCenterGain::s32GetData(tS16& tCenterGainParam) { 
   vUpdate();
   tCenterGainParam = tCenterGain;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPCenterGain::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CenterGain", (tS32)0xacba278);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPCenterGain::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPCenterGain::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPCenterGain::s32SetData(tS16 &tCenterGainParam) {
   //init parameter
   (tVoid)memcpy(&tCenterGain,(tVoid*)&tCenterGainParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenterGainParam' in function 'dp_tclAudioManagerDPCenterGain::vSetData(tS16)' could be made const reference
tS32 dp_tclAudioManagerDPCenterGain::s32SetData(const tS16 &tCenterGainParam) {
   //init parameter
   (tVoid)memcpy(&tCenterGain,(tVoid*)&tCenterGainParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenterGainParam' in function 'dp_tclAudioManagerDPCenterGain::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPCenterGain::u8GetData(tS16& tCenterGainParam) {  
   vUpdate();
   tCenterGainParam = tCenterGain;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPCenterGain::vSetData(tS16 &tCenterGainParam) { 
   //init parameter
   (tVoid)memcpy(&tCenterGain,(tVoid*)&tCenterGainParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCenterGainParam' in function 'dp_tclAudioManagerDPCenterGain::vSetData(tS16)' could be made const reference
tVoid dp_tclAudioManagerDPCenterGain::vSetData(const tS16 &tCenterGainParam) { 
   //init parameter
   (tVoid)memcpy(&tCenterGain,(tVoid*)&tCenterGainParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCenterGainParam' in function 'dp_tclAudioManagerDPCenterGain::vSetData(tS16)' could be made const reference
tU8   dp_tclAudioManagerDPCenterGain::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPCenterGain::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "CenterGain", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPCenterGain::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "CenterGain", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPCenterGain::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CenterGain", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element CenterGain has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SubWoofer"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPSubWoofer::dp_tclAudioManagerDPSubWoofer(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSubWoofer,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPSubWoofer::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SubWoofer",(tS32) 0x297068c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tSubWoofer = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPSubWoofer::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SubWoofer", (tS32)0x297068c);
   (tVoid)myDpElem.bFillData((tVoid*)&tSubWoofer, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPSubWoofer::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPSubWoofer::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclAudioManagerDPSubWoofer::tGetData() {
   vUpdate();
   return tSubWoofer;
};
tS32 dp_tclAudioManagerDPSubWoofer::s32GetData(tS16& tSubWooferParam) { 
   vUpdate();
   tSubWooferParam = tSubWoofer;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPSubWoofer::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SubWoofer", (tS32)0x297068c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPSubWoofer::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPSubWoofer::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPSubWoofer::s32SetData(tS16 &tSubWooferParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer,(tVoid*)&tSubWooferParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWooferParam' in function 'dp_tclAudioManagerDPSubWoofer::vSetData(tS16)' could be made const reference
tS32 dp_tclAudioManagerDPSubWoofer::s32SetData(const tS16 &tSubWooferParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer,(tVoid*)&tSubWooferParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWooferParam' in function 'dp_tclAudioManagerDPSubWoofer::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPSubWoofer::u8GetData(tS16& tSubWooferParam) {  
   vUpdate();
   tSubWooferParam = tSubWoofer;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPSubWoofer::vSetData(tS16 &tSubWooferParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer,(tVoid*)&tSubWooferParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tSubWooferParam' in function 'dp_tclAudioManagerDPSubWoofer::vSetData(tS16)' could be made const reference
tVoid dp_tclAudioManagerDPSubWoofer::vSetData(const tS16 &tSubWooferParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer,(tVoid*)&tSubWooferParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tSubWooferParam' in function 'dp_tclAudioManagerDPSubWoofer::vSetData(tS16)' could be made const reference
tU8   dp_tclAudioManagerDPSubWoofer::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPSubWoofer::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SubWoofer", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSubWoofer::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SubWoofer", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSubWoofer::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SubWoofer", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element SubWoofer has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SurroundLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPSurroundLevel::dp_tclAudioManagerDPSurroundLevel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSurroundLevel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPSurroundLevel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SurroundLevel",(tS32) 0x5f34ba9a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSurroundLevel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPSurroundLevel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SurroundLevel", (tS32)0x5f34ba9a);
   (tVoid)myDpElem.bFillData((tVoid*)&tSurroundLevel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPSurroundLevel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPSurroundLevel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPSurroundLevel::tGetData() {
   vUpdate();
   return tSurroundLevel;
};
tS32 dp_tclAudioManagerDPSurroundLevel::s32GetData(tU8& tSurroundLevelParam) { 
   vUpdate();
   tSurroundLevelParam = tSurroundLevel;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPSurroundLevel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SurroundLevel", (tS32)0x5f34ba9a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPSurroundLevel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPSurroundLevel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPSurroundLevel::s32SetData(tU8 &tSurroundLevelParam) {
   //init parameter
   (tVoid)memcpy(&tSurroundLevel,(tVoid*)&tSurroundLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSurroundLevelParam' in function 'dp_tclAudioManagerDPSurroundLevel::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPSurroundLevel::s32SetData(const tU8 &tSurroundLevelParam) {
   //init parameter
   (tVoid)memcpy(&tSurroundLevel,(tVoid*)&tSurroundLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSurroundLevelParam' in function 'dp_tclAudioManagerDPSurroundLevel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPSurroundLevel::u8GetData(tU8& tSurroundLevelParam) {  
   vUpdate();
   tSurroundLevelParam = tSurroundLevel;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPSurroundLevel::vSetData(tU8 &tSurroundLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tSurroundLevel,(tVoid*)&tSurroundLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSurroundLevelParam' in function 'dp_tclAudioManagerDPSurroundLevel::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPSurroundLevel::vSetData(const tU8 &tSurroundLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tSurroundLevel,(tVoid*)&tSurroundLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSurroundLevelParam' in function 'dp_tclAudioManagerDPSurroundLevel::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPSurroundLevel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPSurroundLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SurroundLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSurroundLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SurroundLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSurroundLevel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SurroundLevel", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element SurroundLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Arkamys_AvcFlatConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPArkamys_AvcFlatConfig::dp_tclAudioManagerDPArkamys_AvcFlatConfig(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0444;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPArkamys_AvcFlatConfig::s32SetData( tU32* tArkamys_AvcFlatConfigParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Arkamys_AvcFlatConfig", (tS32)0x5432ef1e);
   (tVoid)myDpElem.bFillData((tVoid*)tArkamys_AvcFlatConfigParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPArkamys_AvcFlatConfig::s32GetData(tU32* tArkamys_AvcFlatConfigParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Arkamys_AvcFlatConfig", (tS32)0x5432ef1e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tArkamys_AvcFlatConfigParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPArkamys_AvcFlatConfig::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPArkamys_AvcFlatConfig::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPArkamys_AvcFlatConfig::u16GetData(tU32* tArkamys_AvcFlatConfigParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tArkamys_AvcFlatConfigParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPArkamys_AvcFlatConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_AvcFlatConfig", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPArkamys_AvcFlatConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_AvcFlatConfig", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPArkamys_AvcFlatConfig::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Arkamys_AvcFlatConfig", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element Arkamys_AvcFlatConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Arkamys_SSS4FlatConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPArkamys_SSS4FlatConfig::dp_tclAudioManagerDPArkamys_SSS4FlatConfig(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0444;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPArkamys_SSS4FlatConfig::s32SetData( tU32* tArkamys_SSS4FlatConfigParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Arkamys_SSS4FlatConfig", (tS32)0x8816891d);
   (tVoid)myDpElem.bFillData((tVoid*)tArkamys_SSS4FlatConfigParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPArkamys_SSS4FlatConfig::s32GetData(tU32* tArkamys_SSS4FlatConfigParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Arkamys_SSS4FlatConfig", (tS32)0x8816891d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tArkamys_SSS4FlatConfigParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPArkamys_SSS4FlatConfig::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPArkamys_SSS4FlatConfig::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPArkamys_SSS4FlatConfig::u16GetData(tU32* tArkamys_SSS4FlatConfigParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tArkamys_SSS4FlatConfigParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPArkamys_SSS4FlatConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_SSS4FlatConfig", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPArkamys_SSS4FlatConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_SSS4FlatConfig", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPArkamys_SSS4FlatConfig::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Arkamys_SSS4FlatConfig", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element Arkamys_SSS4FlatConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Arkamys_VirtualSubwooferFlatConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0444;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::s32SetData( tU32* tArkamys_VirtualSubwooferFlatConfigParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Arkamys_VirtualSubwooferFlatConfig", (tS32)0x9c1223a7L);
   (tVoid)myDpElem.bFillData((tVoid*)tArkamys_VirtualSubwooferFlatConfigParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::s32GetData(tU32* tArkamys_VirtualSubwooferFlatConfigParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Arkamys_VirtualSubwooferFlatConfig", (tS32)0x9c1223a7L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tArkamys_VirtualSubwooferFlatConfigParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::u16GetData(tU32* tArkamys_VirtualSubwooferFlatConfigParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tArkamys_VirtualSubwooferFlatConfigParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_VirtualSubwooferFlatConfig", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_VirtualSubwooferFlatConfig", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerDPArkamys_VirtualSubwooferFlatConfig::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Arkamys_VirtualSubwooferFlatConfig", DP_U32_POOL_ID_AUDIOMANAGERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
		}
		else
		{
			fprintf(stdout,"Element Arkamys_VirtualSubwooferFlatConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Arkamys_SteeringRight"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPArkamys_SteeringRight::dp_tclAudioManagerDPArkamys_SteeringRight(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tArkamys_SteeringRight,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPArkamys_SteeringRight::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Arkamys_SteeringRight",(tS32) 0x59433d12);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tArkamys_SteeringRight = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPArkamys_SteeringRight::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Arkamys_SteeringRight", (tS32)0x59433d12);
   (tVoid)myDpElem.bFillData((tVoid*)&tArkamys_SteeringRight, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPArkamys_SteeringRight::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPArkamys_SteeringRight::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAudioManagerDPArkamys_SteeringRight::tGetData() {
   vUpdate();
   return tArkamys_SteeringRight;
};
tS32 dp_tclAudioManagerDPArkamys_SteeringRight::s32GetData(tBool& tArkamys_SteeringRightParam) { 
   vUpdate();
   tArkamys_SteeringRightParam = tArkamys_SteeringRight;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPArkamys_SteeringRight::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Arkamys_SteeringRight", (tS32)0x59433d12);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPArkamys_SteeringRight::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPArkamys_SteeringRight::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPArkamys_SteeringRight::s32SetData(tBool &tArkamys_SteeringRightParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_SteeringRight,(tVoid*)&tArkamys_SteeringRightParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_SteeringRightParam' in function 'dp_tclAudioManagerDPArkamys_SteeringRight::vSetData(tBool)' could be made const reference
tS32 dp_tclAudioManagerDPArkamys_SteeringRight::s32SetData(const tBool &tArkamys_SteeringRightParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_SteeringRight,(tVoid*)&tArkamys_SteeringRightParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_SteeringRightParam' in function 'dp_tclAudioManagerDPArkamys_SteeringRight::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPArkamys_SteeringRight::u8GetData(tBool& tArkamys_SteeringRightParam) {  
   vUpdate();
   tArkamys_SteeringRightParam = tArkamys_SteeringRight;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPArkamys_SteeringRight::vSetData(tBool &tArkamys_SteeringRightParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_SteeringRight,(tVoid*)&tArkamys_SteeringRightParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tArkamys_SteeringRightParam' in function 'dp_tclAudioManagerDPArkamys_SteeringRight::vSetData(tBool)' could be made const reference
tVoid dp_tclAudioManagerDPArkamys_SteeringRight::vSetData(const tBool &tArkamys_SteeringRightParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_SteeringRight,(tVoid*)&tArkamys_SteeringRightParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tArkamys_SteeringRightParam' in function 'dp_tclAudioManagerDPArkamys_SteeringRight::vSetData(tBool)' could be made const reference
tU8   dp_tclAudioManagerDPArkamys_SteeringRight::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPArkamys_SteeringRight::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_SteeringRight", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPArkamys_SteeringRight::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_SteeringRight", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPArkamys_SteeringRight::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Arkamys_SteeringRight", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Arkamys_SteeringRight has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Arkamys_SoundStagingMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPArkamys_SoundStagingMode::dp_tclAudioManagerDPArkamys_SoundStagingMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tArkamys_SoundStagingMode,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPArkamys_SoundStagingMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Arkamys_SoundStagingMode",(tS32) 0x5511afda);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tArkamys_SoundStagingMode = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPArkamys_SoundStagingMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Arkamys_SoundStagingMode", (tS32)0x5511afda);
   (tVoid)myDpElem.bFillData((tVoid*)&tArkamys_SoundStagingMode, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPArkamys_SoundStagingMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPArkamys_SoundStagingMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclAudioManagerDPArkamys_SoundStagingMode::tGetData() {
   vUpdate();
   return tArkamys_SoundStagingMode;
};
tS32 dp_tclAudioManagerDPArkamys_SoundStagingMode::s32GetData(tU16& tArkamys_SoundStagingModeParam) { 
   vUpdate();
   tArkamys_SoundStagingModeParam = tArkamys_SoundStagingMode;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPArkamys_SoundStagingMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Arkamys_SoundStagingMode", (tS32)0x5511afda);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPArkamys_SoundStagingMode::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPArkamys_SoundStagingMode::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPArkamys_SoundStagingMode::s32SetData(tU16 &tArkamys_SoundStagingModeParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_SoundStagingMode,(tVoid*)&tArkamys_SoundStagingModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_SoundStagingModeParam' in function 'dp_tclAudioManagerDPArkamys_SoundStagingMode::vSetData(tU16)' could be made const reference
tS32 dp_tclAudioManagerDPArkamys_SoundStagingMode::s32SetData(const tU16 &tArkamys_SoundStagingModeParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_SoundStagingMode,(tVoid*)&tArkamys_SoundStagingModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_SoundStagingModeParam' in function 'dp_tclAudioManagerDPArkamys_SoundStagingMode::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPArkamys_SoundStagingMode::u8GetData(tU16& tArkamys_SoundStagingModeParam) {  
   vUpdate();
   tArkamys_SoundStagingModeParam = tArkamys_SoundStagingMode;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPArkamys_SoundStagingMode::vSetData(tU16 &tArkamys_SoundStagingModeParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_SoundStagingMode,(tVoid*)&tArkamys_SoundStagingModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tArkamys_SoundStagingModeParam' in function 'dp_tclAudioManagerDPArkamys_SoundStagingMode::vSetData(tU16)' could be made const reference
tVoid dp_tclAudioManagerDPArkamys_SoundStagingMode::vSetData(const tU16 &tArkamys_SoundStagingModeParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_SoundStagingMode,(tVoid*)&tArkamys_SoundStagingModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tArkamys_SoundStagingModeParam' in function 'dp_tclAudioManagerDPArkamys_SoundStagingMode::vSetData(tU16)' could be made const reference
tU8   dp_tclAudioManagerDPArkamys_SoundStagingMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPArkamys_SoundStagingMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_SoundStagingMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPArkamys_SoundStagingMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_SoundStagingMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPArkamys_SoundStagingMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Arkamys_SoundStagingMode", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Arkamys_SoundStagingMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Arkamys_Ambiance"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPArkamys_Ambiance::dp_tclAudioManagerDPArkamys_Ambiance(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tArkamys_Ambiance,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPArkamys_Ambiance::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Arkamys_Ambiance",(tS32) 0x5bc51f83);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tArkamys_Ambiance = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPArkamys_Ambiance::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Arkamys_Ambiance", (tS32)0x5bc51f83);
   (tVoid)myDpElem.bFillData((tVoid*)&tArkamys_Ambiance, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPArkamys_Ambiance::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPArkamys_Ambiance::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclAudioManagerDPArkamys_Ambiance::tGetData() {
   vUpdate();
   return tArkamys_Ambiance;
};
tS32 dp_tclAudioManagerDPArkamys_Ambiance::s32GetData(tU16& tArkamys_AmbianceParam) { 
   vUpdate();
   tArkamys_AmbianceParam = tArkamys_Ambiance;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPArkamys_Ambiance::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Arkamys_Ambiance", (tS32)0x5bc51f83);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPArkamys_Ambiance::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPArkamys_Ambiance::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPArkamys_Ambiance::s32SetData(tU16 &tArkamys_AmbianceParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_Ambiance,(tVoid*)&tArkamys_AmbianceParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_AmbianceParam' in function 'dp_tclAudioManagerDPArkamys_Ambiance::vSetData(tU16)' could be made const reference
tS32 dp_tclAudioManagerDPArkamys_Ambiance::s32SetData(const tU16 &tArkamys_AmbianceParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_Ambiance,(tVoid*)&tArkamys_AmbianceParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_AmbianceParam' in function 'dp_tclAudioManagerDPArkamys_Ambiance::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPArkamys_Ambiance::u8GetData(tU16& tArkamys_AmbianceParam) {  
   vUpdate();
   tArkamys_AmbianceParam = tArkamys_Ambiance;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPArkamys_Ambiance::vSetData(tU16 &tArkamys_AmbianceParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_Ambiance,(tVoid*)&tArkamys_AmbianceParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tArkamys_AmbianceParam' in function 'dp_tclAudioManagerDPArkamys_Ambiance::vSetData(tU16)' could be made const reference
tVoid dp_tclAudioManagerDPArkamys_Ambiance::vSetData(const tU16 &tArkamys_AmbianceParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_Ambiance,(tVoid*)&tArkamys_AmbianceParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tArkamys_AmbianceParam' in function 'dp_tclAudioManagerDPArkamys_Ambiance::vSetData(tU16)' could be made const reference
tU8   dp_tclAudioManagerDPArkamys_Ambiance::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPArkamys_Ambiance::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_Ambiance", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPArkamys_Ambiance::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_Ambiance", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPArkamys_Ambiance::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Arkamys_Ambiance", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Arkamys_Ambiance has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Arkamys_AutomaticGainControl"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPArkamys_AutomaticGainControl::dp_tclAudioManagerDPArkamys_AutomaticGainControl(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tArkamys_AutomaticGainControl,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPArkamys_AutomaticGainControl::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Arkamys_AutomaticGainControl",(tS32) 0xc35cf536L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tArkamys_AutomaticGainControl = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPArkamys_AutomaticGainControl::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Arkamys_AutomaticGainControl", (tS32)0xc35cf536L);
   (tVoid)myDpElem.bFillData((tVoid*)&tArkamys_AutomaticGainControl, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPArkamys_AutomaticGainControl::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPArkamys_AutomaticGainControl::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAudioManagerDPArkamys_AutomaticGainControl::tGetData() {
   vUpdate();
   return tArkamys_AutomaticGainControl;
};
tS32 dp_tclAudioManagerDPArkamys_AutomaticGainControl::s32GetData(tBool& tArkamys_AutomaticGainControlParam) { 
   vUpdate();
   tArkamys_AutomaticGainControlParam = tArkamys_AutomaticGainControl;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPArkamys_AutomaticGainControl::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Arkamys_AutomaticGainControl", (tS32)0xc35cf536L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPArkamys_AutomaticGainControl::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPArkamys_AutomaticGainControl::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPArkamys_AutomaticGainControl::s32SetData(tBool &tArkamys_AutomaticGainControlParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_AutomaticGainControl,(tVoid*)&tArkamys_AutomaticGainControlParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_AutomaticGainControlParam' in function 'dp_tclAudioManagerDPArkamys_AutomaticGainControl::vSetData(tBool)' could be made const reference
tS32 dp_tclAudioManagerDPArkamys_AutomaticGainControl::s32SetData(const tBool &tArkamys_AutomaticGainControlParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_AutomaticGainControl,(tVoid*)&tArkamys_AutomaticGainControlParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_AutomaticGainControlParam' in function 'dp_tclAudioManagerDPArkamys_AutomaticGainControl::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPArkamys_AutomaticGainControl::u8GetData(tBool& tArkamys_AutomaticGainControlParam) {  
   vUpdate();
   tArkamys_AutomaticGainControlParam = tArkamys_AutomaticGainControl;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPArkamys_AutomaticGainControl::vSetData(tBool &tArkamys_AutomaticGainControlParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_AutomaticGainControl,(tVoid*)&tArkamys_AutomaticGainControlParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tArkamys_AutomaticGainControlParam' in function 'dp_tclAudioManagerDPArkamys_AutomaticGainControl::vSetData(tBool)' could be made const reference
tVoid dp_tclAudioManagerDPArkamys_AutomaticGainControl::vSetData(const tBool &tArkamys_AutomaticGainControlParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_AutomaticGainControl,(tVoid*)&tArkamys_AutomaticGainControlParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tArkamys_AutomaticGainControlParam' in function 'dp_tclAudioManagerDPArkamys_AutomaticGainControl::vSetData(tBool)' could be made const reference
tU8   dp_tclAudioManagerDPArkamys_AutomaticGainControl::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPArkamys_AutomaticGainControl::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_AutomaticGainControl", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPArkamys_AutomaticGainControl::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Arkamys_AutomaticGainControl", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPArkamys_AutomaticGainControl::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Arkamys_AutomaticGainControl", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Arkamys_AutomaticGainControl has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Center_GainPerStep"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPCenter_GainPerStep::dp_tclAudioManagerDPCenter_GainPerStep(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCenter_GainPerStep,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPCenter_GainPerStep::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Center_GainPerStep",(tS32) 0xc215d3fe);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCenter_GainPerStep = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPCenter_GainPerStep::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Center_GainPerStep", (tS32)0xc215d3fe);
   (tVoid)myDpElem.bFillData((tVoid*)&tCenter_GainPerStep, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPCenter_GainPerStep::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPCenter_GainPerStep::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPCenter_GainPerStep::tGetData() {
   vUpdate();
   return tCenter_GainPerStep;
};
tS32 dp_tclAudioManagerDPCenter_GainPerStep::s32GetData(tU8& tCenter_GainPerStepParam) { 
   vUpdate();
   tCenter_GainPerStepParam = tCenter_GainPerStep;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPCenter_GainPerStep::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Center_GainPerStep", (tS32)0xc215d3fe);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPCenter_GainPerStep::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPCenter_GainPerStep::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPCenter_GainPerStep::s32SetData(tU8 &tCenter_GainPerStepParam) {
   //init parameter
   (tVoid)memcpy(&tCenter_GainPerStep,(tVoid*)&tCenter_GainPerStepParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenter_GainPerStepParam' in function 'dp_tclAudioManagerDPCenter_GainPerStep::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPCenter_GainPerStep::s32SetData(const tU8 &tCenter_GainPerStepParam) {
   //init parameter
   (tVoid)memcpy(&tCenter_GainPerStep,(tVoid*)&tCenter_GainPerStepParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenter_GainPerStepParam' in function 'dp_tclAudioManagerDPCenter_GainPerStep::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPCenter_GainPerStep::u8GetData(tU8& tCenter_GainPerStepParam) {  
   vUpdate();
   tCenter_GainPerStepParam = tCenter_GainPerStep;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPCenter_GainPerStep::vSetData(tU8 &tCenter_GainPerStepParam) { 
   //init parameter
   (tVoid)memcpy(&tCenter_GainPerStep,(tVoid*)&tCenter_GainPerStepParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCenter_GainPerStepParam' in function 'dp_tclAudioManagerDPCenter_GainPerStep::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPCenter_GainPerStep::vSetData(const tU8 &tCenter_GainPerStepParam) { 
   //init parameter
   (tVoid)memcpy(&tCenter_GainPerStep,(tVoid*)&tCenter_GainPerStepParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCenter_GainPerStepParam' in function 'dp_tclAudioManagerDPCenter_GainPerStep::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPCenter_GainPerStep::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPCenter_GainPerStep::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Center_GainPerStep", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPCenter_GainPerStep::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "Center_GainPerStep", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPCenter_GainPerStep::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Center_GainPerStep", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element Center_GainPerStep has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SubWoofer_GainPerStep"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPSubWoofer_GainPerStep::dp_tclAudioManagerDPSubWoofer_GainPerStep(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSubWoofer_GainPerStep,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPSubWoofer_GainPerStep::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SubWoofer_GainPerStep",(tS32) 0x8f2df91);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSubWoofer_GainPerStep = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPSubWoofer_GainPerStep::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SubWoofer_GainPerStep", (tS32)0x8f2df91);
   (tVoid)myDpElem.bFillData((tVoid*)&tSubWoofer_GainPerStep, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPSubWoofer_GainPerStep::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPSubWoofer_GainPerStep::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPSubWoofer_GainPerStep::tGetData() {
   vUpdate();
   return tSubWoofer_GainPerStep;
};
tS32 dp_tclAudioManagerDPSubWoofer_GainPerStep::s32GetData(tU8& tSubWoofer_GainPerStepParam) { 
   vUpdate();
   tSubWoofer_GainPerStepParam = tSubWoofer_GainPerStep;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPSubWoofer_GainPerStep::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SubWoofer_GainPerStep", (tS32)0x8f2df91);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPSubWoofer_GainPerStep::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPSubWoofer_GainPerStep::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPSubWoofer_GainPerStep::s32SetData(tU8 &tSubWoofer_GainPerStepParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer_GainPerStep,(tVoid*)&tSubWoofer_GainPerStepParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWoofer_GainPerStepParam' in function 'dp_tclAudioManagerDPSubWoofer_GainPerStep::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPSubWoofer_GainPerStep::s32SetData(const tU8 &tSubWoofer_GainPerStepParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer_GainPerStep,(tVoid*)&tSubWoofer_GainPerStepParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWoofer_GainPerStepParam' in function 'dp_tclAudioManagerDPSubWoofer_GainPerStep::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPSubWoofer_GainPerStep::u8GetData(tU8& tSubWoofer_GainPerStepParam) {  
   vUpdate();
   tSubWoofer_GainPerStepParam = tSubWoofer_GainPerStep;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPSubWoofer_GainPerStep::vSetData(tU8 &tSubWoofer_GainPerStepParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer_GainPerStep,(tVoid*)&tSubWoofer_GainPerStepParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSubWoofer_GainPerStepParam' in function 'dp_tclAudioManagerDPSubWoofer_GainPerStep::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPSubWoofer_GainPerStep::vSetData(const tU8 &tSubWoofer_GainPerStepParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer_GainPerStep,(tVoid*)&tSubWoofer_GainPerStepParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSubWoofer_GainPerStepParam' in function 'dp_tclAudioManagerDPSubWoofer_GainPerStep::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPSubWoofer_GainPerStep::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPSubWoofer_GainPerStep::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SubWoofer_GainPerStep", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSubWoofer_GainPerStep::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "SubWoofer_GainPerStep", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPSubWoofer_GainPerStep::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SubWoofer_GainPerStep", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element SubWoofer_GainPerStep has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioPilotMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPAudioPilotMode::dp_tclAudioManagerDPAudioPilotMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAudioPilotMode,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPAudioPilotMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AudioPilotMode",(tS32) 0x8f80bfa3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tAudioPilotMode = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPAudioPilotMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AudioPilotMode", (tS32)0x8f80bfa3);
   (tVoid)myDpElem.bFillData((tVoid*)&tAudioPilotMode, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPAudioPilotMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPAudioPilotMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAudioManagerDPAudioPilotMode::tGetData() {
   vUpdate();
   return tAudioPilotMode;
};
tS32 dp_tclAudioManagerDPAudioPilotMode::s32GetData(tBool& tAudioPilotModeParam) { 
   vUpdate();
   tAudioPilotModeParam = tAudioPilotMode;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPAudioPilotMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AudioPilotMode", (tS32)0x8f80bfa3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPAudioPilotMode::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPAudioPilotMode::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPAudioPilotMode::s32SetData(tBool &tAudioPilotModeParam) {
   //init parameter
   (tVoid)memcpy(&tAudioPilotMode,(tVoid*)&tAudioPilotModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioPilotModeParam' in function 'dp_tclAudioManagerDPAudioPilotMode::vSetData(tBool)' could be made const reference
tS32 dp_tclAudioManagerDPAudioPilotMode::s32SetData(const tBool &tAudioPilotModeParam) {
   //init parameter
   (tVoid)memcpy(&tAudioPilotMode,(tVoid*)&tAudioPilotModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioPilotModeParam' in function 'dp_tclAudioManagerDPAudioPilotMode::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPAudioPilotMode::u8GetData(tBool& tAudioPilotModeParam) {  
   vUpdate();
   tAudioPilotModeParam = tAudioPilotMode;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPAudioPilotMode::vSetData(tBool &tAudioPilotModeParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioPilotMode,(tVoid*)&tAudioPilotModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAudioPilotModeParam' in function 'dp_tclAudioManagerDPAudioPilotMode::vSetData(tBool)' could be made const reference
tVoid dp_tclAudioManagerDPAudioPilotMode::vSetData(const tBool &tAudioPilotModeParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioPilotMode,(tVoid*)&tAudioPilotModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAudioPilotModeParam' in function 'dp_tclAudioManagerDPAudioPilotMode::vSetData(tBool)' could be made const reference
tU8   dp_tclAudioManagerDPAudioPilotMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPAudioPilotMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "AudioPilotMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAudioPilotMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "AudioPilotMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAudioPilotMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioPilotMode", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element AudioPilotMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioPilotIntensity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerDPAudioPilotIntensity::dp_tclAudioManagerDPAudioPilotIntensity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAudioPilotIntensity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerDPAudioPilotIntensity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AudioPilotIntensity",(tS32) 0xbe8f6a51);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAudioPilotIntensity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerDPAudioPilotIntensity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AudioPilotIntensity", (tS32)0xbe8f6a51);
   (tVoid)myDpElem.bFillData((tVoid*)&tAudioPilotIntensity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerDPAudioPilotIntensity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerDPAudioPilotIntensity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerDPAudioPilotIntensity::tGetData() {
   vUpdate();
   return tAudioPilotIntensity;
};
tS32 dp_tclAudioManagerDPAudioPilotIntensity::s32GetData(tU8& tAudioPilotIntensityParam) { 
   vUpdate();
   tAudioPilotIntensityParam = tAudioPilotIntensity;
   return _s32Status;
}
tS32 dp_tclAudioManagerDPAudioPilotIntensity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AudioPilotIntensity", (tS32)0xbe8f6a51);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerDPAudioPilotIntensity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerDPAudioPilotIntensity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerDPAudioPilotIntensity::s32SetData(tU8 &tAudioPilotIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tAudioPilotIntensity,(tVoid*)&tAudioPilotIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioPilotIntensityParam' in function 'dp_tclAudioManagerDPAudioPilotIntensity::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerDPAudioPilotIntensity::s32SetData(const tU8 &tAudioPilotIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tAudioPilotIntensity,(tVoid*)&tAudioPilotIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioPilotIntensityParam' in function 'dp_tclAudioManagerDPAudioPilotIntensity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerDPAudioPilotIntensity::u8GetData(tU8& tAudioPilotIntensityParam) {  
   vUpdate();
   tAudioPilotIntensityParam = tAudioPilotIntensity;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerDPAudioPilotIntensity::vSetData(tU8 &tAudioPilotIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioPilotIntensity,(tVoid*)&tAudioPilotIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAudioPilotIntensityParam' in function 'dp_tclAudioManagerDPAudioPilotIntensity::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerDPAudioPilotIntensity::vSetData(const tU8 &tAudioPilotIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioPilotIntensity,(tVoid*)&tAudioPilotIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAudioPilotIntensityParam' in function 'dp_tclAudioManagerDPAudioPilotIntensity::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerDPAudioPilotIntensity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerDPAudioPilotIntensity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "AudioPilotIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAudioPilotIntensity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERDP, "AudioPilotIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerDPAudioPilotIntensity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioPilotIntensity", DP_U32_POOL_ID_AUDIOMANAGERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERDP);
   }
   else
   {
      fprintf(stdout,"Element AudioPilotIntensity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
