
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tcltestPool.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "testAcc0466Imm"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tcltestPooltestAcc0466Imm::dp_tcltestPooltestAcc0466Imm(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0466;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&ttestAcc0466Imm,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tcltestPooltestAcc0466Imm::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("testAcc0466Imm",(tS32) 0x52758cfa);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         ttestAcc0466Imm = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tcltestPooltestAcc0466Imm::vStore(tVoid) {
   dp_tclBaseElement myDpElem("testAcc0466Imm", (tS32)0x52758cfa);
   (tVoid)myDpElem.bFillData((tVoid*)&ttestAcc0466Imm, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tcltestPooltestAcc0466Imm::s32GetStatus() const {return _s32Status;};
tU8   dp_tcltestPooltestAcc0466Imm::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tcltestPooltestAcc0466Imm::tGetData() {
   vUpdate();
   return ttestAcc0466Imm;
};
tS32 dp_tcltestPooltestAcc0466Imm::s32GetData(tU32& ttestAcc0466ImmParam) { 
   vUpdate();
   ttestAcc0466ImmParam = ttestAcc0466Imm;
   return _s32Status;
}
tS32 dp_tcltestPooltestAcc0466Imm::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("testAcc0466Imm", (tS32)0x52758cfa);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tcltestPooltestAcc0466Imm::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tcltestPooltestAcc0466Imm::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tcltestPooltestAcc0466Imm::s32SetData(tU32 &ttestAcc0466ImmParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0466Imm,(tVoid*)&ttestAcc0466ImmParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0466ImmParam' in function 'dp_tcltestPooltestAcc0466Imm::vSetData(tU32)' could be made const reference
tS32 dp_tcltestPooltestAcc0466Imm::s32SetData(const tU32 &ttestAcc0466ImmParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0466Imm,(tVoid*)&ttestAcc0466ImmParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0466ImmParam' in function 'dp_tcltestPooltestAcc0466Imm::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tcltestPooltestAcc0466Imm::u8GetData(tU32& ttestAcc0466ImmParam) {  
   vUpdate();
   ttestAcc0466ImmParam = ttestAcc0466Imm;
   return _u8DataStatus;
}
tVoid dp_tcltestPooltestAcc0466Imm::vSetData(tU32 &ttestAcc0466ImmParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0466Imm,(tVoid*)&ttestAcc0466ImmParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0466ImmParam' in function 'dp_tcltestPooltestAcc0466Imm::vSetData(tU32)' could be made const reference
tVoid dp_tcltestPooltestAcc0466Imm::vSetData(const tU32 &ttestAcc0466ImmParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0466Imm,(tVoid*)&ttestAcc0466ImmParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0466ImmParam' in function 'dp_tcltestPooltestAcc0466Imm::vSetData(tU32)' could be made const reference
tU8   dp_tcltestPooltestAcc0466Imm::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tcltestPooltestAcc0466Imm::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0466Imm", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0466Imm::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0466Imm", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0466Imm::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: testAcc0466Imm", DP_U32_POOL_ID_TESTPOOL);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TESTPOOL);
   }
   else
   {
      fprintf(stdout,"Element testAcc0466Imm has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "testAcc0066ImmStr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tcltestPooltestAcc0066ImmStr::dp_tcltestPooltestAcc0066ImmStr(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0066;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tcltestPooltestAcc0066ImmStr::s32SetData(tString &ttestAcc0066ImmStrParam) {
   tU32 u32Len = (tU32)strlen(ttestAcc0066ImmStrParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("testAcc0066ImmStr", (tS32)0x434e095f);
      (tVoid)myDpElem.bFillData((tVoid*)ttestAcc0066ImmStrParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tcltestPooltestAcc0066ImmStr::s32SetData(const tString &ttestAcc0066ImmStrParam) {
   tU32 u32Len = (tU32)strlen(ttestAcc0066ImmStrParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("testAcc0066ImmStr", (tS32)0x434e095f);
      (tVoid)myDpElem.bFillData((tVoid*)ttestAcc0066ImmStrParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tcltestPooltestAcc0066ImmStr::s32GetData(tString &ttestAcc0066ImmStrParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("testAcc0066ImmStr", (tS32)0x434e095f);
   (tVoid)memset(ttestAcc0066ImmStrParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)ttestAcc0066ImmStrParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tcltestPooltestAcc0066ImmStr::s32GetData(const tString &ttestAcc0066ImmStrParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("testAcc0066ImmStr", (tS32)0x434e095f);
   (tVoid)memset(ttestAcc0066ImmStrParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)ttestAcc0066ImmStrParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tcltestPooltestAcc0066ImmStr::s32GetStatus() const {return _s32Status;};
   tU8   dp_tcltestPooltestAcc0066ImmStr::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tcltestPooltestAcc0066ImmStr::u32GetData(tString &ttestAcc0066ImmStrParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(ttestAcc0066ImmStrParam, u32StringBufLen);
   };
    tU32  dp_tcltestPooltestAcc0066ImmStr::u32GetData(const tString &ttestAcc0066ImmStrParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(ttestAcc0066ImmStrParam, u32StringBufLen);
   };
   tVoid dp_tcltestPooltestAcc0066ImmStr::vSetData(tString &ttestAcc0066ImmStrParam){(tVoid)s32SetData(ttestAcc0066ImmStrParam);};
   tVoid dp_tcltestPooltestAcc0066ImmStr::vSetData(const tString &ttestAcc0066ImmStrParam){(tVoid)s32SetData(ttestAcc0066ImmStrParam);};
   
   //notification handling not over processes only for application
   tBool dp_tcltestPooltestAcc0066ImmStr::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0066ImmStr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tcltestPooltestAcc0066ImmStr::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0066ImmStr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tcltestPooltestAcc0066ImmStr::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: testAcc0066ImmStr", DP_U32_POOL_ID_TESTPOOL);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_TESTPOOL);
		}
		else
		{
			fprintf(stdout,"Element testAcc0066ImmStr has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "testAcc0046ImmStr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tcltestPooltestAcc0046ImmStr::dp_tcltestPooltestAcc0046ImmStr(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0046;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tcltestPooltestAcc0046ImmStr::s32SetData(tString &ttestAcc0046ImmStrParam) {
   tU32 u32Len = (tU32)strlen(ttestAcc0046ImmStrParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("testAcc0046ImmStr", (tS32)0x434ba705);
      (tVoid)myDpElem.bFillData((tVoid*)ttestAcc0046ImmStrParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tcltestPooltestAcc0046ImmStr::s32SetData(const tString &ttestAcc0046ImmStrParam) {
   tU32 u32Len = (tU32)strlen(ttestAcc0046ImmStrParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("testAcc0046ImmStr", (tS32)0x434ba705);
      (tVoid)myDpElem.bFillData((tVoid*)ttestAcc0046ImmStrParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tcltestPooltestAcc0046ImmStr::s32GetData(tString &ttestAcc0046ImmStrParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("testAcc0046ImmStr", (tS32)0x434ba705);
   (tVoid)memset(ttestAcc0046ImmStrParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)ttestAcc0046ImmStrParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tcltestPooltestAcc0046ImmStr::s32GetData(const tString &ttestAcc0046ImmStrParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("testAcc0046ImmStr", (tS32)0x434ba705);
   (tVoid)memset(ttestAcc0046ImmStrParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)ttestAcc0046ImmStrParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tcltestPooltestAcc0046ImmStr::s32GetStatus() const {return _s32Status;};
   tU8   dp_tcltestPooltestAcc0046ImmStr::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tcltestPooltestAcc0046ImmStr::u32GetData(tString &ttestAcc0046ImmStrParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(ttestAcc0046ImmStrParam, u32StringBufLen);
   };
    tU32  dp_tcltestPooltestAcc0046ImmStr::u32GetData(const tString &ttestAcc0046ImmStrParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(ttestAcc0046ImmStrParam, u32StringBufLen);
   };
   tVoid dp_tcltestPooltestAcc0046ImmStr::vSetData(tString &ttestAcc0046ImmStrParam){(tVoid)s32SetData(ttestAcc0046ImmStrParam);};
   tVoid dp_tcltestPooltestAcc0046ImmStr::vSetData(const tString &ttestAcc0046ImmStrParam){(tVoid)s32SetData(ttestAcc0046ImmStrParam);};
   
   //notification handling not over processes only for application
   tBool dp_tcltestPooltestAcc0046ImmStr::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046ImmStr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tcltestPooltestAcc0046ImmStr::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046ImmStr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tcltestPooltestAcc0046ImmStr::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: testAcc0046ImmStr", DP_U32_POOL_ID_TESTPOOL);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_TESTPOOL);
		}
		else
		{
			fprintf(stdout,"Element testAcc0046ImmStr has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "testAcc0006ShutArray"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tcltestPooltestAcc0006ShutArray::dp_tcltestPooltestAcc0006ShutArray(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tcltestPooltestAcc0006ShutArray::s32SetData( tU32* ttestAcc0006ShutArrayParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("testAcc0006ShutArray", (tS32)0xd9d53290);
   (tVoid)myDpElem.bFillData((tVoid*)ttestAcc0006ShutArrayParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tcltestPooltestAcc0006ShutArray::s32GetData(tU32* ttestAcc0006ShutArrayParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("testAcc0006ShutArray", (tS32)0xd9d53290);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)ttestAcc0006ShutArrayParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tcltestPooltestAcc0006ShutArray::s32GetStatus() const {return _s32Status;};
   tU8   dp_tcltestPooltestAcc0006ShutArray::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tcltestPooltestAcc0006ShutArray::u16GetData(tU32* ttestAcc0006ShutArrayParam, tU32 u32ArraySize){
       return (tU16) s32GetData(ttestAcc0006ShutArrayParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tcltestPooltestAcc0006ShutArray::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0006ShutArray", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tcltestPooltestAcc0006ShutArray::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0006ShutArray", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tcltestPooltestAcc0006ShutArray::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: testAcc0006ShutArray", DP_U32_POOL_ID_TESTPOOL);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_TESTPOOL);
		}
		else
		{
			fprintf(stdout,"Element testAcc0006ShutArray has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "testAcc0046Shutdown"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tcltestPooltestAcc0046Shutdown::dp_tcltestPooltestAcc0046Shutdown(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0046;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&ttestAcc0046Shutdown,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tcltestPooltestAcc0046Shutdown::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("testAcc0046Shutdown",(tS32) 0x926eb6f1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         ttestAcc0046Shutdown = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tcltestPooltestAcc0046Shutdown::vStore(tVoid) {
   dp_tclBaseElement myDpElem("testAcc0046Shutdown", (tS32)0x926eb6f1);
   (tVoid)myDpElem.bFillData((tVoid*)&ttestAcc0046Shutdown, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tcltestPooltestAcc0046Shutdown::s32GetStatus() const {return _s32Status;};
tU8   dp_tcltestPooltestAcc0046Shutdown::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tcltestPooltestAcc0046Shutdown::tGetData() {
   vUpdate();
   return ttestAcc0046Shutdown;
};
tS32 dp_tcltestPooltestAcc0046Shutdown::s32GetData(tU32& ttestAcc0046ShutdownParam) { 
   vUpdate();
   ttestAcc0046ShutdownParam = ttestAcc0046Shutdown;
   return _s32Status;
}
tS32 dp_tcltestPooltestAcc0046Shutdown::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("testAcc0046Shutdown", (tS32)0x926eb6f1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tcltestPooltestAcc0046Shutdown::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tcltestPooltestAcc0046Shutdown::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tcltestPooltestAcc0046Shutdown::s32SetData(tU32 &ttestAcc0046ShutdownParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Shutdown,(tVoid*)&ttestAcc0046ShutdownParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0046ShutdownParam' in function 'dp_tcltestPooltestAcc0046Shutdown::vSetData(tU32)' could be made const reference
tS32 dp_tcltestPooltestAcc0046Shutdown::s32SetData(const tU32 &ttestAcc0046ShutdownParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Shutdown,(tVoid*)&ttestAcc0046ShutdownParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0046ShutdownParam' in function 'dp_tcltestPooltestAcc0046Shutdown::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tcltestPooltestAcc0046Shutdown::u8GetData(tU32& ttestAcc0046ShutdownParam) {  
   vUpdate();
   ttestAcc0046ShutdownParam = ttestAcc0046Shutdown;
   return _u8DataStatus;
}
tVoid dp_tcltestPooltestAcc0046Shutdown::vSetData(tU32 &ttestAcc0046ShutdownParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Shutdown,(tVoid*)&ttestAcc0046ShutdownParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0046ShutdownParam' in function 'dp_tcltestPooltestAcc0046Shutdown::vSetData(tU32)' could be made const reference
tVoid dp_tcltestPooltestAcc0046Shutdown::vSetData(const tU32 &ttestAcc0046ShutdownParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Shutdown,(tVoid*)&ttestAcc0046ShutdownParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0046ShutdownParam' in function 'dp_tcltestPooltestAcc0046Shutdown::vSetData(tU32)' could be made const reference
tU8   dp_tcltestPooltestAcc0046Shutdown::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tcltestPooltestAcc0046Shutdown::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046Shutdown", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0046Shutdown::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046Shutdown", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0046Shutdown::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: testAcc0046Shutdown", DP_U32_POOL_ID_TESTPOOL);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TESTPOOL);
   }
   else
   {
      fprintf(stdout,"Element testAcc0046Shutdown has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "testAcc0046Cyclic"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tcltestPooltestAcc0046Cyclic::dp_tcltestPooltestAcc0046Cyclic(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0046;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&ttestAcc0046Cyclic,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tcltestPooltestAcc0046Cyclic::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("testAcc0046Cyclic",(tS32) 0x434b785c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         ttestAcc0046Cyclic = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tcltestPooltestAcc0046Cyclic::vStore(tVoid) {
   dp_tclBaseElement myDpElem("testAcc0046Cyclic", (tS32)0x434b785c);
   (tVoid)myDpElem.bFillData((tVoid*)&ttestAcc0046Cyclic, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tcltestPooltestAcc0046Cyclic::s32GetStatus() const {return _s32Status;};
tU8   dp_tcltestPooltestAcc0046Cyclic::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tcltestPooltestAcc0046Cyclic::tGetData() {
   vUpdate();
   return ttestAcc0046Cyclic;
};
tS32 dp_tcltestPooltestAcc0046Cyclic::s32GetData(tU32& ttestAcc0046CyclicParam) { 
   vUpdate();
   ttestAcc0046CyclicParam = ttestAcc0046Cyclic;
   return _s32Status;
}
tS32 dp_tcltestPooltestAcc0046Cyclic::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("testAcc0046Cyclic", (tS32)0x434b785c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tcltestPooltestAcc0046Cyclic::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tcltestPooltestAcc0046Cyclic::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tcltestPooltestAcc0046Cyclic::s32SetData(tU32 &ttestAcc0046CyclicParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Cyclic,(tVoid*)&ttestAcc0046CyclicParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0046CyclicParam' in function 'dp_tcltestPooltestAcc0046Cyclic::vSetData(tU32)' could be made const reference
tS32 dp_tcltestPooltestAcc0046Cyclic::s32SetData(const tU32 &ttestAcc0046CyclicParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Cyclic,(tVoid*)&ttestAcc0046CyclicParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0046CyclicParam' in function 'dp_tcltestPooltestAcc0046Cyclic::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tcltestPooltestAcc0046Cyclic::u8GetData(tU32& ttestAcc0046CyclicParam) {  
   vUpdate();
   ttestAcc0046CyclicParam = ttestAcc0046Cyclic;
   return _u8DataStatus;
}
tVoid dp_tcltestPooltestAcc0046Cyclic::vSetData(tU32 &ttestAcc0046CyclicParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Cyclic,(tVoid*)&ttestAcc0046CyclicParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0046CyclicParam' in function 'dp_tcltestPooltestAcc0046Cyclic::vSetData(tU32)' could be made const reference
tVoid dp_tcltestPooltestAcc0046Cyclic::vSetData(const tU32 &ttestAcc0046CyclicParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Cyclic,(tVoid*)&ttestAcc0046CyclicParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0046CyclicParam' in function 'dp_tcltestPooltestAcc0046Cyclic::vSetData(tU32)' could be made const reference
tU8   dp_tcltestPooltestAcc0046Cyclic::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tcltestPooltestAcc0046Cyclic::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046Cyclic", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0046Cyclic::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046Cyclic", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0046Cyclic::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: testAcc0046Cyclic", DP_U32_POOL_ID_TESTPOOL);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TESTPOOL);
   }
   else
   {
      fprintf(stdout,"Element testAcc0046Cyclic has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "testAcc0046Delayed"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tcltestPooltestAcc0046Delayed::dp_tcltestPooltestAcc0046Delayed(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0046;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&ttestAcc0046Delayed,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tcltestPooltestAcc0046Delayed::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("testAcc0046Delayed",(tS32) 0x5078b549);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         ttestAcc0046Delayed = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tcltestPooltestAcc0046Delayed::vStore(tVoid) {
   dp_tclBaseElement myDpElem("testAcc0046Delayed", (tS32)0x5078b549);
   (tVoid)myDpElem.bFillData((tVoid*)&ttestAcc0046Delayed, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tcltestPooltestAcc0046Delayed::s32GetStatus() const {return _s32Status;};
tU8   dp_tcltestPooltestAcc0046Delayed::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tcltestPooltestAcc0046Delayed::tGetData() {
   vUpdate();
   return ttestAcc0046Delayed;
};
tS32 dp_tcltestPooltestAcc0046Delayed::s32GetData(tU32& ttestAcc0046DelayedParam) { 
   vUpdate();
   ttestAcc0046DelayedParam = ttestAcc0046Delayed;
   return _s32Status;
}
tS32 dp_tcltestPooltestAcc0046Delayed::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("testAcc0046Delayed", (tS32)0x5078b549);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tcltestPooltestAcc0046Delayed::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tcltestPooltestAcc0046Delayed::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tcltestPooltestAcc0046Delayed::s32SetData(tU32 &ttestAcc0046DelayedParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Delayed,(tVoid*)&ttestAcc0046DelayedParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0046DelayedParam' in function 'dp_tcltestPooltestAcc0046Delayed::vSetData(tU32)' could be made const reference
tS32 dp_tcltestPooltestAcc0046Delayed::s32SetData(const tU32 &ttestAcc0046DelayedParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Delayed,(tVoid*)&ttestAcc0046DelayedParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0046DelayedParam' in function 'dp_tcltestPooltestAcc0046Delayed::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tcltestPooltestAcc0046Delayed::u8GetData(tU32& ttestAcc0046DelayedParam) {  
   vUpdate();
   ttestAcc0046DelayedParam = ttestAcc0046Delayed;
   return _u8DataStatus;
}
tVoid dp_tcltestPooltestAcc0046Delayed::vSetData(tU32 &ttestAcc0046DelayedParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Delayed,(tVoid*)&ttestAcc0046DelayedParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0046DelayedParam' in function 'dp_tcltestPooltestAcc0046Delayed::vSetData(tU32)' could be made const reference
tVoid dp_tcltestPooltestAcc0046Delayed::vSetData(const tU32 &ttestAcc0046DelayedParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Delayed,(tVoid*)&ttestAcc0046DelayedParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0046DelayedParam' in function 'dp_tcltestPooltestAcc0046Delayed::vSetData(tU32)' could be made const reference
tU8   dp_tcltestPooltestAcc0046Delayed::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tcltestPooltestAcc0046Delayed::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046Delayed", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0046Delayed::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046Delayed", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0046Delayed::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: testAcc0046Delayed", DP_U32_POOL_ID_TESTPOOL);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TESTPOOL);
   }
   else
   {
      fprintf(stdout,"Element testAcc0046Delayed has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "testAcc0046Force"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tcltestPooltestAcc0046Force::dp_tcltestPooltestAcc0046Force(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0046;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&ttestAcc0046Force,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tcltestPooltestAcc0046Force::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("testAcc0046Force",(tS32) 0xd75821c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         ttestAcc0046Force = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tcltestPooltestAcc0046Force::vStore(tVoid) {
   dp_tclBaseElement myDpElem("testAcc0046Force", (tS32)0xd75821c);
   (tVoid)myDpElem.bFillData((tVoid*)&ttestAcc0046Force, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tcltestPooltestAcc0046Force::s32GetStatus() const {return _s32Status;};
tU8   dp_tcltestPooltestAcc0046Force::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tcltestPooltestAcc0046Force::tGetData() {
   vUpdate();
   return ttestAcc0046Force;
};
tS32 dp_tcltestPooltestAcc0046Force::s32GetData(tU32& ttestAcc0046ForceParam) { 
   vUpdate();
   ttestAcc0046ForceParam = ttestAcc0046Force;
   return _s32Status;
}
tS32 dp_tcltestPooltestAcc0046Force::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("testAcc0046Force", (tS32)0xd75821c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TESTPOOL, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tcltestPooltestAcc0046Force::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tcltestPooltestAcc0046Force::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tcltestPooltestAcc0046Force::s32SetData(tU32 &ttestAcc0046ForceParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Force,(tVoid*)&ttestAcc0046ForceParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0046ForceParam' in function 'dp_tcltestPooltestAcc0046Force::vSetData(tU32)' could be made const reference
tS32 dp_tcltestPooltestAcc0046Force::s32SetData(const tU32 &ttestAcc0046ForceParam) {
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Force,(tVoid*)&ttestAcc0046ForceParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'ttestAcc0046ForceParam' in function 'dp_tcltestPooltestAcc0046Force::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tcltestPooltestAcc0046Force::u8GetData(tU32& ttestAcc0046ForceParam) {  
   vUpdate();
   ttestAcc0046ForceParam = ttestAcc0046Force;
   return _u8DataStatus;
}
tVoid dp_tcltestPooltestAcc0046Force::vSetData(tU32 &ttestAcc0046ForceParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Force,(tVoid*)&ttestAcc0046ForceParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0046ForceParam' in function 'dp_tcltestPooltestAcc0046Force::vSetData(tU32)' could be made const reference
tVoid dp_tcltestPooltestAcc0046Force::vSetData(const tU32 &ttestAcc0046ForceParam) { 
   //init parameter
   (tVoid)memcpy(&ttestAcc0046Force,(tVoid*)&ttestAcc0046ForceParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'ttestAcc0046ForceParam' in function 'dp_tcltestPooltestAcc0046Force::vSetData(tU32)' could be made const reference
tU8   dp_tcltestPooltestAcc0046Force::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tcltestPooltestAcc0046Force::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046Force", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0046Force::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TESTPOOL, "testAcc0046Force", pFunc, u32Event, _u16AccessId);
}
tBool dp_tcltestPooltestAcc0046Force::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: testAcc0046Force", DP_U32_POOL_ID_TESTPOOL);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TESTPOOL);
   }
   else
   {
      fprintf(stdout,"Element testAcc0046Force has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
