
#ifndef KDSPROD
#define KDSPROD



//##########################################################
//#######  AesSecurityKey  (Key: 0x1215)          
//##########################################################
#define DP_U16_KDSADR_AESSECURITYKEY                                             0x1215

#define DP_U8_KDSLEN_AESSECURITYKEY_COMPLETE                                     16



class dp_tclKdsAesSecurityKey{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_AESSECURITYKEY_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsAesSecurityKey();
   virtual ~dp_tclKdsAesSecurityKey() {};
   
   
   tU8 u8DataValid() const;
   tU8 u8GetAesSecurityKey(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  DimmingCalibrationParameterSet  (Key: 0x0D09)          
//##########################################################
#define DP_U16_KDSADR_DIMMINGCALIBRATIONPARAMETERSET                                             0x0D09

#define DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_COMPLETE                                     10

#define DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_KEYBLED0CALIBRATIONVALUE                     2
#define DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_KEYBLED1CALIBRATIONVALUE                     2
#define DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_KEYBLED2CALIBRATIONVALUE                     2
#define DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_KEYBLED3CALIBRATIONVALUE                     2
#define DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_KEYBLED4CALIBRATIONVALUE                     2


class dp_tclKdsDimmingCalibrationParameterSet{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsDimmingCalibrationParameterSet();
   virtual ~dp_tclKdsDimmingCalibrationParameterSet() {};
   
   tU8 u8GetKEYBLED0CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetKEYBLED1CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetKEYBLED2CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetKEYBLED3CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetKEYBLED4CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetDimmingCalibrationParameterSet(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  ECUSerialNumber  (Key: 0x0106)          
//##########################################################
#define DP_U16_KDSADR_ECUSERIALNUMBER                                             0x0106

#define DP_U8_KDSLEN_ECUSERIALNUMBER_COMPLETE                                     7



class dp_tclKdsECUSerialNumber{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_ECUSERIALNUMBER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsECUSerialNumber();
   virtual ~dp_tclKdsECUSerialNumber() {};
   
   
   tU8 u8DataValid() const;
   tU8 u8GetECUSerialNumber(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  NavUnitID  (Key: 0x2010)          
//##########################################################
#define DP_U16_KDSADR_NAVUNITID                                             0x2010

#define DP_U8_KDSLEN_NAVUNITID_COMPLETE                                     8



class dp_tclKdsNavUnitID{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_NAVUNITID_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsNavUnitID();
   virtual ~dp_tclKdsNavUnitID() {};
   
   
   tU8 u8DataValid() const;
   tU8 u8GetNavUnitID(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  Vin  (Key: 0xA1C8)          
//##########################################################
#define DP_U16_KDSADR_VIN                                             0xA1C8

#define DP_U8_KDSLEN_VIN_COMPLETE                                     17



class dp_tclKdsVin{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_VIN_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsVin();
   virtual ~dp_tclKdsVin() {};
   
   
   tU8 u8DataValid() const;
   tU8 u8GetVin(tU8* pu8Data, tU16 u16BufLen);
};


#endif
