/**
 * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
 *               The reproduction, distribution and utilization of this file as well as the
 *               communication of its contents to others without express authorization is prohibited.
 *               Offenders will be held liable for the payment of damages.
 *               All rights reserved in the event of the grant of a patent, utility model or design.
 * @brief        class dp_tclDpPersMemAccess
 * @addtogroup   Datapool persistent
 * @{
 */
#ifndef _DP_PERS_MEM_ACC
#define _DP_PERS_MEM_ACC

/************************************************************************
|defines and macros (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|typedefs and struct defs (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|class definition
|-----------------------------------------------------------------------*/
class dp_tclDpPersMemAccess 
{   
public:
   dp_tclDpPersMemAccess();
   virtual ~dp_tclDpPersMemAccess();
  
   virtual tS32  s32GetDataStreamName(tU16 u16Pool, const tChar* strName,tChar* strReferenceName);	
   virtual tS32  s32GetPersDataSize(tCString pSourceFilename,eDpLocation eLocation);
   virtual tS32  s32ImportPersData(tCString pSourceFilename, tU8 **pu8Data,eDpLocation eLocation,tU32 u32Version);	
   virtual tBool bWriteFfsData(tCString pSourceFilename,tU8 *pu8MyData,tU32 u32Size,eDpLocation eLocation,tU32 u32Version,tBool bfSync=TRUE);  	   
   virtual tBool bCalcHashForFile(tCString pSourceFilename, tU32 *pu32MyData,eDpLocation eLocation,tU32 u32Version);
   virtual tBool bGenHash(tU8* pData, tU32 u32DataLen, tU32 *pu32MyData);
   virtual void  vSynchronizePersDataWithBackup(void);
   virtual tS32  s32DeletePersData(tCString pSourceFilename,eDpLocation eLocation); 
   virtual tS32 s32DeleteOldPool(tCString pSourceFilename,eDpLocation eLocation);
};
#endif
//EOF
