#ifndef _DP_ENDUSER
#define _DP_ENDUSER

#include <semaphore.h>

#define SYSTEM_S_IMPORT_INTERFACE_LIST
#include "stl_pif.h"

#define TRACE_S_IMPORT_INTERFACE_TYPES
#include "trace_if.h"

// length of end user file extension
#define DP_END_USER_FILE_LEN_EXT   8

#ifdef DP_U32_POOL_ID_DPENDUSERMODE  //is only possible if pool for user mode exist
//access ID
#define DP_ACCESS_ID_END_USER_APP            CCA_C_U16_APP_FC_USERMANAGER 

// max user bank
#define DP_END_USER_USED_MAX                           255
#define DP_END_USER_NOT_STORED_FEATURE_DISABLED        0xffff                

class dp_tclDpEndUser
{
private:
   // *****************************************************************************
   // ********   static class variable 
   // *****************************************************************************  
   static dp_tclDpEndUser* _poInstance;

protected:
   #ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::map<tS32, dp_tclBaseElement> TListDatapoolElements;
   #else
   typedef std::map<tS32, dp_tclBaseElement> TListDatapoolElements;
   #endif

   typedef struct tDpShmEndUser
   {
      sem_t  semShmEndUser;                            //semaphore for access shared memory
      tBool  bLoad;                                    //load data from file
      /* value get from pool for the end user */
      tU8    u8EndUser;                                //default    0: end user 0	 
	    tU8    u8EndUserUsedMax;                         //max number of used end user	 
	    tU8    u8EndUserUsed[DP_END_USER_USED_MAX];      //array for used end user      
	    tU8    u8EndUserBank[DP_END_USER_USED_MAX];      //current bank for the user
	    tU8    u8EndUserBankUsedMax;                     //max number of used end user bank
	    tU8    u8EndUserBankUsed[DP_END_USER_USED_MAX];  //array for used end user banks 
      /* value get from file datapool-default.conf  
         if value >  DP_END_USER_USED_MAX all end user could be stored
         if value <= DP_END_USER_USED_MAX this end user could not be stored */
      tU16   u16EndUserConfigNotStore;                                                                     
   }tDpShmEndUser;
 
   // *****************************************************************************
   // ********   internal member variable 
   // *****************************************************************************               
   dp_tclDpPersMemAccess* _poPersMemAccessHdl;                        //vInitInstance
   tDpShmEndUser*		      _ptDPShmEndUser;		                        //vInitInstance   
 
public:
   // *****************************************************************************
   // ********   initialization part 
   // *****************************************************************************   
   dp_tclDpEndUser(); 
   virtual ~dp_tclDpEndUser(); 

   static dp_tclDpEndUser* pGetInstance();//  singleton method
   virtual void  vInitInstance(dp_tclDpPersMemAccess* poPersMem);

   // *****************************************************************************
   // ********   access function
   // ***************************************************************************** 
   //access for end user
   virtual tS32     s32GetEndUser(tU8& u8EndUser);
   virtual tS32     s32SetEndUser(tU8 u8EndUser,tU16 u16AccessId);
   virtual tS32     s32GetElementFromFile(tU8 Pu8EndUser,tU32 Pu32PoolId, const tChar* VcPoolName,eDpLocation PeLocation,tU32 Pu32Version,dp_tclBaseElement* PpDpElement, tU16 Pu16AccessId);
   virtual tS32     s32CopyEndUserDataStream(tU8 Pu8EndUserFrom,tU8 Pu8EndUserTo,const tChar* VcPoolName,eDpLocation PeLocation,tU32 Pu32Version);
   virtual tBool    bCheckEndUserShouldStore(tChar* PcPoolName,tU8 Pu8Bank);
   //access for bank
   virtual tS32     s32GetBank(tU8& Pu8Bank);
   virtual tS32     s32SetBank(tU8 Pu8Bank);
   virtual tS32     s32SetBankUsed(tU8 Pu8Bank);
   //default handling
   virtual void     vSetEndUserModeToDefault(void);
   virtual void     vSetBankForEndUserToDefault(tU8 u8EndUser);
   virtual tBool    bPerformDefSetEndUserPool(TListDatapoolElements* PptDpElementList,tU8 u8EndUser,tU32 u32DefSetType,tChar* cPoolName, eDpLocation PeLocation,tU32 Pu32Version);
   virtual tBool    bPerformDefSetEndUserBank(TListDatapoolElements* PptDpElementList,tU8 u8EndUserOrBank,tU32 u32DefSetType,tChar* cPoolName, eDpLocation PeLocation,tU32 Pu32Version);
   //function for get extansion
   virtual void     vAddEndUserBankExt(tU8 Pu8Bank,tChar* VstrWithBankExt);
   virtual void     vAddCurrentEndUserExt(tChar* VstrWithUserExt); 
   virtual void     vAddExt(tU8 Pu8Value,tChar* VstrStringWithExt);  
   virtual void     vGetFileNameWithoutExt(tChar* VstrStringWithExt,tChar* VstrStringWithoutExt);  
private:
   //function for default
   virtual tS32     s32SetEndUserPoolToDefault(TListDatapoolElements* PptDpElementList,tU8 u8EndUser,tChar* cPoolName, eDpLocation PeLocation,tU32 Pu32Version);
   virtual tS32     s32SetEndUserBankToDefault(TListDatapoolElements* PptDpElementList,tU8 Pu8EndUser,tU8 Pu8Bank,tChar* cPoolName, eDpLocation PeLocation,tU32 Pu32Version);
   virtual tBool    bCheckElementsInFileForDefSetModeSecure(TListDatapoolElements* PptDpElementList,tCString pSourceFilename, eDpLocation PeLocation,tU32 Pu32Version);
   //function for shared memory info
   virtual void     vSetEndUserInfoInSharedMemToDefault(void);   
   virtual void     vLoadEndUserInfoToShm(void);
   virtual void     vStoreEndUserInfoFromShm(void);  
   virtual void     vTraceOutEndUserInfo(void);
   virtual tU8      u8GetGreatestEndUser(void);
   //function for read from configuration file
   virtual char*    strFileReadConfigLine(const char* PstrConfigStr);
public:
   /*only for oedt test*/
   #ifdef DP_U32_POOL_ID_PDDDPTESTENDUSER
   tVoid            vEnableReloadEndUserSharedMemory(tVoid);
   #endif
};
#endif
#endif

//EOF
