/******************************************************************************
* FILE:         db.h
* PROJECT:      
* SW-COMPONENT: datapool
*------------------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 24.10.11  | CM-AI/VW32 kollai  | initial version
*
*******************************************************************************/
#ifndef _DP_ELEMENT_CTXT
#define _DP_ELEMENT_CTXT 

typedef struct{
   tVoid* pData; 
   tU32 u32Len;   
}dpCtxtElemWrite;

typedef struct{
   tVoid** pData; 
   tU32* pu32Len;   
}dpCtxtElemRead;

class dp_tclStreamCtxt {
public:
  // --Konstruktor
  dp_tclStreamCtxt(tU8* const pu8Start);

  // --Destruktor
  virtual ~dp_tclStreamCtxt() {} //lint !e1540 (freeing ptrs is prohibited, zeroing is unneccessary)

  // --Zugriff auf bestimmte Positionen des Kontextes
  tU8* pu8GetStartPosition() const { return pu8StartPosition; }
  tU8* pu8GetEndPosition() const { return pu8EndPosition; }
  tU8* pu8GetPosition() const { return pu8Position; }
  // --(Freie) Gre 
  tU32 u32GetSize() const { return (pu8EndPosition-pu8StartPosition)>0?(tU32)(pu8EndPosition-pu8StartPosition):0; }
  tU32 u32GetFilledSize() const { return (pu8Position-pu8StartPosition)>0?(tU32)(pu8Position-pu8StartPosition):0; }
  tU32 u32GetFreeSize() const { return (pu8EndPosition-pu8Position)>0?(tU32)(pu8EndPosition-pu8Position):0; }
  tBool bCheckPlace(tU32 u32CheckSize) const { 
     return ((pu8Position + u32CheckSize)<pu8EndPosition) ? (tBool)TRUE : (tBool) FALSE; }

  // --Bereits voll?
  tBool bIsFull() const { return pu8Position<pu8EndPosition ? (tBool)FALSE : (tBool)TRUE; }

  // Gltigkeit des Kontextes
  tBool bIsValid() const { return bContextIsValid; }
  tVoid Invalidate() { bContextIsValid = FALSE; }
  
protected:
  tU8* const pu8StartPosition;
  tU8* pu8EndPosition; // --Eine Position hinter dem letzten Zeichen
  tPU8 pu8Position;
  
private:
  tBool bContextIsValid;
  dp_tclStreamCtxt(); //lint !e1704 no default construction allowed!
};

// --Basisklasse fr Ausgabekontext
class dp_tclOutStreamCtxt : public dp_tclStreamCtxt {
public:
  // --Konstruktor
  dp_tclOutStreamCtxt(tU8* const pu8Start, tU32 u32Len);

  // --Destruktor
  virtual ~dp_tclOutStreamCtxt() {}

  // --Methoden zum Schreiben von einzelnen Werten
  dp_tclOutStreamCtxt& oWrite(tU8 u8Value);
  dp_tclOutStreamCtxt& oWrite(tU16 u16Value);
  dp_tclOutStreamCtxt& oWrite(tU32 u32Value);
  dp_tclOutStreamCtxt& oWrite(tS32 s32Value);
  dp_tclOutStreamCtxt& oWrite(tString strValue);

  dp_tclOutStreamCtxt& oWrite(dpCtxtElemWrite* pRef);

  // --Operatoren zum Schreiben von einzelnen Werten
  dp_tclOutStreamCtxt& operator<<(tU8 u8Value);
  dp_tclOutStreamCtxt& operator<<(tU16 u16Value);
  dp_tclOutStreamCtxt& operator<<(tU32 u32Value);
  dp_tclOutStreamCtxt& operator<<(tS32 s32Value);
  dp_tclOutStreamCtxt& operator<<(tString strValue);

  dp_tclOutStreamCtxt& operator<<(dpCtxtElemWrite* pRef);

  tU32 u32WriteAt(tVoid* pData, tU32 u32Len);

private:
  dp_tclOutStreamCtxt(); //lint !e1704 no default construction allowed!
};

// --Basisklasse fr Eingabekontext
class dp_tclInStreamCtxt : public dp_tclStreamCtxt {
 public:

  // --Konstruktor
// #pragma message("default major version for InContext!")
  dp_tclInStreamCtxt(tU8* const pu8Start);

  // --Destruktor
  virtual ~dp_tclInStreamCtxt() {}

  // --Methoden zum Lesen von einzelnen Werten
  dp_tclInStreamCtxt& oRead(tU8& u8Value);
  dp_tclInStreamCtxt& oRead(tU16& u16Value);
  dp_tclInStreamCtxt& oRead(tU32& u32Value);
  dp_tclInStreamCtxt& oRead(tS32& s32Value);
  dp_tclInStreamCtxt& oRead(tString strValue);
  dp_tclInStreamCtxt& oRead(dpCtxtElemRead* pRef);

  // --Operatoren zum Lesen von einzelnen Werten
  dp_tclInStreamCtxt& operator>>(tU8& u8Value);
  dp_tclInStreamCtxt& operator>>(tU16& u16Value);
  dp_tclInStreamCtxt& operator>>(tU32& u32Value);
  dp_tclInStreamCtxt& operator>>(tS32& s32Value);
  dp_tclInStreamCtxt& operator>>(tString strValue);

  dp_tclInStreamCtxt& operator>>(dpCtxtElemRead* pRef);

  tU32 u32ReadAt(tVoid* pData, tU32 u32Len);

private:
  dp_tclInStreamCtxt(); //lint !e1704 no default construction allowed!
};

#endif //_DP_ELEMENT_CTXT
//EOF

