/******************************************************************************
* FILE:         db.h
* PROJECT:      
* SW-COMPONENT: datapool
*------------------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 24.10.11  | CM-AI/VW32 kollai  | initial version
*
*******************************************************************************/
#ifndef _DP_BASE_ELEMENT 
#define _DP_BASE_ELEMENT 

#include "../dpIfGlob.h"
#include "dpElementContext.h"

#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_LIST
#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_U8_ACCESS_PRIVATE       0
#define DP_U8_ACCESS_READ_ONLY     1
#define DP_U8_ACCESS_FULL          2

#define DP_TYPE_U8        0          
#define DP_TYPE_U16       1          
#define DP_TYPE_U32       2          
#define DP_TYPE_STRUCT    3          
#define DP_TYPE_STRING    4          

#define DP_DEFSET_CHANGEABLE 0x80000000

typedef tS32 (*DP_tps32ElementConfCallback) (tU8, tU8, tU8*, tU32, tU8**, tU32*); //version old, version new, data found, data len, 
typedef tVoid (*DP_tpvDataUpdateCallback) (tU32);

class dp_tclBaseElement {
public:
   typedef enum {
      eDpElementTypeKds,
      eDpElementTypeRegistry,
      eDpElementTypePersistent,
      eDpElementTypeRuntime
   }EDpElementTypes;

   typedef enum {
      eDpStoringTypeNone,
      eDpStoringTypeImmediately,
      eDpStoringTypeShutdown,
      eDpStoringTypeDelayed,
      eDpStoringTypeCyclic,
      eDpStoringTypeForce
   }EDpStoringTypes;

   typedef enum {
      eDpDefSetNone,
      eDpDefSetProduction,
      eDpDefSetCustomer,
      eDpDefSetUser
   }EDpDefSetTypes;

   typedef enum 
   {
      eDpElemLoaded = 0,
      eDpElemInit,
      eDpElemSet
   }EDpElemState;

   typedef struct 
   {
      DP_tpvDataUpdateCallback pCallback;
      tU32  u32Event;
   } TFuncNotEntry;

protected:
   typedef struct TDpElementProperty{
      tU8  u8Version;
      tU16 u16AccessType;
      tBool bVarSize;
      EDpElementTypes tElemType;
      EDpStoringTypes tStoringType;
      tU32 u32StoringIntervall;
      tU32 u32NextStoreTime;
      tBool bValidated;
      tBool bRestore;
      EDpDefSetTypes tDefsetType;
      EDpElemState tElemState;
      tBool bExport2Registry;
      tU8  u8VarType;
      tU32  u32DefSetMode;
   } TDpElementProperty;


   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   typedef struct 
   {
     #ifdef SYSTEM_S_USE_BPSTL
	   bpstl::string strConfigElement;
     bpstl::string strConfigItem;
     #else
	   std::string strConfigElement;
     std::string strConfigItem;
     #endif
     tBool bNormalAssertIfElemNotExist;
   }TDpInitBankKdsAccess;

   #ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::map< tU8, TDpInitBankKdsAccess > TDpInitBankKdsAccessList;
   #else
   typedef std::map< tU8, TDpInitBankKdsAccess > TDpInitBankKdsAccessList;
   #endif
   TDpInitBankKdsAccessList _oInitBankKdsAccessList;
   #endif   

#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::list<TFuncNotEntry> TNotCallbackList;
#else
   typedef std::list<TFuncNotEntry> TNotCallbackList;
#endif
   TNotCallbackList* _pCallbackList;

   tBool _bNotify;
   tS32  _s32Hash;

   TDpElementProperty _tProperty;
   tChar _strElementName[DP_MAX_LEN_NAME_ELEMENT];

   tU8*  _pDataBuffer;
   tU32 _u32DataLength;
   tU32 _u32DefDataLength;
   tU32 _u32RdAccessCount;
   tU32 _u32WrAccessCount;

   tU8*  _pDefaultDataBuffer;

   DP_tps32ElementConfCallback _pConfCallBack;

    tS32 s32CalcHash(tChar* str);
public:

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
   virtual dp_tclOutStreamCtxt& oWrite(dp_tclOutStreamCtxt& rfoOut);
   virtual dp_tclInStreamCtxt& oRead(dp_tclInStreamCtxt& rfoIn);
#endif
   
   tVoid vChangeProperties(tBool bVarSize, tU16 u16AccessType, EDpElementTypes tElemType, EDpStoringTypes tStoringType, tU8 u8VarType, tU32 u32DefSetMode) {
      _tProperty.u16AccessType = u16AccessType;
      _tProperty.tElemType = tElemType;
      _tProperty.tStoringType = tStoringType;
      _tProperty.bVarSize = bVarSize;
      _tProperty.u8VarType = u8VarType;
      _tProperty.u32DefSetMode = u32DefSetMode;
      return;
   }

   tU32 u32GetStreamLength() const;
   tU32 u32GetDataLength() const {return _u32DataLength;};
   tU32 u32GetDataLengthDefault() const {return _u32DefDataLength;};
   const tChar* pcGetElementName() const {return _strElementName;};
   tS32 s32GetHash() const {return _s32Hash;};
   EDpElementTypes eGetElementType() const {return _tProperty.tElemType;};
   EDpElemState eGetElementState() const {return _tProperty.tElemState;};
   tVoid vSetElementState( EDpElemState eState) {_tProperty.tElemState = eState;};

   EDpStoringTypes eGetStoringType() const {return _tProperty.tStoringType;};
   tU32 u32GetStoringIntervall() const {return _tProperty.u32StoringIntervall;};

   tBool bExport2Registry() const {return _tProperty.bExport2Registry;};
   tBool bIsElementValidated() const {return _tProperty.bValidated;};
   tVoid vValidateElement(tBool bValid=TRUE) {_tProperty.bValidated = bValid;};
   tBool bConversionEnabled() const {return (_pConfCallBack != NULL);};

   tVoid vSetVersion(tU8 u8Version) {_tProperty.u8Version = u8Version;};

   tU8   u8GetVersion() const {return _tProperty.u8Version;};
   tU16  u16GetAccessType() const {return _tProperty.u16AccessType;};
   tU8   u8GetVarType() const {return _tProperty.u8VarType;};
   tU32  u32GetDefSetMode() const {return _tProperty.u32DefSetMode;};
   tBool bGetVarSize() const {return _tProperty.bVarSize;};
   
   tVoid vIncrementRdAccessCount() {_u32RdAccessCount++;};
   tU32 u32GetRdAccessCount() const {return _u32RdAccessCount;};
   tU32 u32GetWrAccessCount() const {return _u32WrAccessCount;};

   tVoid vSetNextStoreTime(tU32 u32Time) {_tProperty.u32NextStoreTime = u32Time;};
   tU32 u32GetNextStoreTime() const {return _tProperty.u32NextStoreTime;};

   tVoid vSetConvertCallback(DP_tps32ElementConfCallback pConvFunc) {_pConfCallBack = pConvFunc;};
   tS32 s32ConvertElement(dp_tclBaseElement* pElemSrc);

   tBool bFillData(tVoid* pStreamStart, tU32 u32StreamLength);
   tVoid vFillElementProperty(dp_tclBaseElement* pElemSrc);
  
   tBool bSetDefaultData(tVoid* pStreamStart, tU32 u32StreamLength);
   tBool bRestoreDefaultData();

   #ifdef DP_U32_POOL_ID_DPENDUSERMODE
   tBool bAddInitBankKdsAccessToList(tU16 u8Bank,tCString strConfigElement,tCString strConfigItem,tBool bNormalAssertIfElemNotExist);
   tBool bGetInitBankKdsValueFromList(tU16 u8Bank, tU8* pau8Data, tU16 u16Len);
   #endif

   tBool bAddNotification(TFuncNotEntry tEntry);
   tBool bRemoveNotification(TFuncNotEntry tEntry);

   tVoid vSendNotification();

   tBool bIsNotification() const {return _bNotify;};

   tVoid* pvGetData(){return (tVoid*)_pDataBuffer;};
   tVoid* pvGetDataDefault(){return (tVoid*)_pDefaultDataBuffer;};

   dp_tclBaseElement();                                                  //create empty element
   dp_tclBaseElement(const dp_tclBaseElement& oDpElem);                  //copy constructor
   dp_tclBaseElement(const tChar* pcElementName, tS32 s32Hash = 0);      //constructor for read element
   dp_tclBaseElement(
      const tChar* pcElementName, 
      tU8  u8Version,
      tU16 u16ElementLength,
      tBool bVarSize = FALSE,
      tU16 u16AccessType = DP_U8_ACCESS_PRIVATE, 
      EDpElementTypes tElemType = eDpElementTypePersistent, 
      EDpStoringTypes tStoringType = eDpStoringTypeImmediately, 
      tU32 u32StoringIntervall = 0,
      tU32 u32DefSetMode = eDpDefSetUser);                               //constructor for init undef element
   dp_tclBaseElement(
      const tChar* pcElementName, 
      tU8  u8Version,
      tS32 s32Hash,
      tU16 u16ElementLength = 0,
      tBool bVarSize = FALSE,
      tU16 u16AccessType = DP_U8_ACCESS_PRIVATE, 
      EDpElementTypes tElemType = eDpElementTypeRuntime, 
      EDpStoringTypes tStoringType = eDpStoringTypeNone, 
      tU32 u32StoringIntervall = 0,
      tBool bExport2Reg = FALSE,
      tU8 u8VarType = DP_TYPE_STRUCT,
      tU32 u32DefSetMode = 0);                                           //constructor to create new


   dp_tclBaseElement& operator=  (const dp_tclBaseElement &oDpElem);
   tVoid vCopyElement(const dp_tclBaseElement &oDpElem);

   virtual ~dp_tclBaseElement();

};

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
dp_tclOutStreamCtxt& operator<<(dp_tclOutStreamCtxt& oOutContext, dp_tclBaseElement& oMyRef);
dp_tclInStreamCtxt& operator>>(dp_tclInStreamCtxt& oInContext, dp_tclBaseElement& oMyRef);
#endif

#endif //_DP_BASE_ELEMENT
//EOF

