#ifndef _DPBASE
#define _DPBASE

#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_LIST
#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define TRACE_S_IMPORT_INTERFACE_TYPES
#include "trace_if.h"

#define DP_S_IMPORT_INTERFACE_DPMASTER
#define DP_S_IMPORT_INTERFACE_DPELEM
#include "dp_if.h"

#define DP_U8_NOTHING_TO_STORE_TIME    0xffffffff

#define DP_U8_STORE_POOL_INTERVAL_TIME 20000
#define DP_U8_STORE_ELEMENT_DELAY_TIME 10000

#define DP_TRACE_CLASS              (tU16)(TR_COMP_DATAPOOL + 0x04)

#define DP_U32_EVENT_STORE_FINISHED              0x00000001
#define DP_U32_EVENT_TRACE_FINISHED              0x00000002
#define DP_U32_EVENT_HISTORY_FINISHED            0x00000004
#define DP_U32_EVENT_LOCKED_FINISHED             0x00000008
#define DP_U32_EVENT_UNLOCKED_FINISHED           0x00000010
#define DP_U32_EVENT_DEFSET_FINISHED             0x00000020
#define DP_U32_EVENT_BUSY                        0x00000040
#define DP_U32_EVENT_TIMEOUT                     0x00000080
#define DP_U32_EVENT_ERR_TYPE                    0x00000100
#define DP_U32_EVENT_ERR_ALREADY_LOCKED          0x00000200
#define DP_U32_EVENT_HASH_FINISHED               0x00000400
#define DP_U32_EVENT_UPDATE_POOL_FINISHED        0x00000800
#define DP_U32_EVENT_SHM_ELEMENT_CREATED         0x00001000
#define DP_U32_EVENT_SHM_ELEMENT_DELETED         0x00002000
#define DP_U32_EVENT_BANK_ACTION_FINISHED        0x00004000
#define DP_U32_EVENT_STOP_WAIT_THREAD_DONE       0x00008000
#define DP_U32_EVENT_END_USER_COPY_FINISHED      0x00010000

#define DP_U32_EVENT_SYNC_DELAY  4000
#define DP_U32_CHECK_POOL_DELAY  2000
#define DP_U32_WAIT_TIMEOUT_SHARED_DATA    4000

#define DP_U32_FILE_VERSION      0x0001

#define DP_U16_SUBPOOL_CODING_RANGE  0xff00

#define DP_U16_DP_INTERN_CONFIGPOOL  DP_U32_POOL_ID_DPINTERNDATA

#define DP_U16_ACCESS_WR_OWNER_0002   0x0002
#define DP_U16_ACCESS_WR_OTHER_0220   0x0220
#define DP_U16_ACCESS_RD_OWNER_0004   0x0004
#define DP_U16_ACCESS_RD_OTHER_0440   0x0440
#define DP_U16_ACCESS_RD_EVERYONE_0400 0x0400 

#define DP_U8_NO_BANK_ACTION     0xff

#define TRACE_DP(TraceId, Level, cStr, pcBuffer) \
{ if (et_bIsTraceActive((tU16)DP_TRACE_CLASS, (tU16)Level) == TRUE) \
   et_vTraceBinary((tU16)DP_TRACE_CLASS, (tU16)Level,   ET_EN_T8 _ (tU8)FILE_NUMBER _ ET_EN_T16 _ (tU16)__LINE__ _ ET_EN_T16 _ (tU16)TraceId _ pcBuffer); \
}

#define DP_NULL_POINTER_CHECK(poClass) \
if (poClass == NULL) {\
FATAL_M_ASSERT_ALWAYS();\
return;\
}

class dp_tclDpBase
{
public:
   typedef enum
   {
      eDpElemInit,
      eDpElemRead,
      eDpElemWrite,
      eDpElemTrace,
      eDpElemVersionChange,
      eDpElemVersionConversion,
      eDpElemLoad
   }EDpElementTrace;

   typedef enum
   {
      eDPEndUserBankLoad,
      eDPEndUserBankSave
   }eDpEndUserBankAction;

protected:
// ****************************************************************************
// ********   internal member variable 
// ****************************************************************************
#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::map<tU32, DP_tpvInitPoolCallback> TListInitPoolCallback;
#else
   typedef std::map<tU32, DP_tpvInitPoolCallback> TListInitPoolCallback;
#endif
   TListInitPoolCallback _olistInitPoolCallbacks;

#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::map<tS32, dp_tclBaseElement> TListDatapoolElements;
#else
   typedef std::map<tS32, dp_tclBaseElement> TListDatapoolElements;
#endif

   typedef struct TDpHistoryProperty
   {
#ifdef SYSTEM_S_USE_BPSTL
      bpstl::string strElemName;
#else
      std::string strElemName;
#endif
      tU32 u32Timestamp;
   }TDpHistoryProperty;
#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::map<tS32, TDpHistoryProperty> TElementChangeMap;
#else
   typedef std::map<tS32, TDpHistoryProperty> TElementChangeMap;
#endif

   typedef struct TDpPoolProperty
   {
      tChar strFileName[DP_MAX_LEN_FILE];
      TListDatapoolElements tDpElementList;
      tBool bWaiting4Store;
      tU32 u32NextStoreTime;
      tU32 u32LastStoreTime;
      tBool bDelayedElementActive;
      TElementChangeMap tElemChangeMap;
      tU32 u32Handle;
      tBool bDefSet;
      tBool bElemChanged;
      eDpLocation eLocation;
      tU32 u32PoolVersion;
      eDpModeEndUser eModeEndUser;
      tU8 u8EndUser;
   }TDpPoolProperty;

#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::map<tU32, TDpPoolProperty> TDatapool;
#else
   typedef std::map<tU32, TDpPoolProperty> TDatapool;
#endif
   TDatapool oDatapool;

#ifdef DP_FEATURE_UNDEF_ELEMENT
#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::map<tU32, tDpUndefPoolProperty> TDpUndefPoolProperty;
#else
   typedef std::map<tU32, tDpUndefPoolProperty> TDpUndefPoolProperty;
#endif

   TDpUndefPoolProperty oDpUndefPoolProperty;
#endif

   tU32 _u32LockMode;

   typedef struct TDpPoolHistoryEntry
   {
      tU32 u32TimeStamp;
#ifdef SYSTEM_S_USE_BPSTL
      bpstl::string strFileName;
#else
      std::string strFileName;
#endif
      tU32 u32PoolId;
      tU32 u32BytesWritten;
      TElementChangeMap tElemChangeMap;
   } TDpPoolHistoryEntry;

#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::list<TDpPoolHistoryEntry> TDpPoolHistoryList;
#else
   typedef std::list<TDpPoolHistoryEntry> TDpPoolHistoryList;
#endif
   TDpPoolHistoryList oHistoryList;

   typedef struct TDpListSubPool
   {
      tBool bInitilazied;
      tBool bStored;
      tU32 u32SubPool;
   }TDpListSubPool;

#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::list<TDpListSubPool> TDpPoolSubPoolList;
   typedef bpstl::list<tU32> TDpPoolSubPoolClearList;
#else
   typedef std::list<TDpListSubPool> TDpPoolSubPoolList;
   typedef std::list<tU32> TDpPoolSubPoolClearList;
#endif
   TDpPoolSubPoolList _tListSubPools;
   tBool              _bSubListLoad;

   tChar _szMyProcSpecName[DP_MAX_LEN_NAME_PROCESS];
   tChar _szMyProcResourceName[DP_MAX_LEN_NAME_RESOURCE];

#ifdef SYSTEM_S_USE_BPSTL
   bpstl::list<tS32>_oListTraceElements;
#else
   std::list<tS32>_oListTraceElements;
#endif
   tBool              _bListTraceElementsLoad;

   tU32 _tCurentHash[DP_MASTER_HASH_COUNT];

   OSAL_tMQueueHandle     _hMessageQueueHandle;
   OSAL_tMQueueHandle     _hMasterQueueHandle;

   OSAL_tEventHandle      _hEvSync;
   tU32                   _u32EvWaitForMask;

   OSAL_tSemHandle        _hDpSemSrvIf;
   OSAL_tSemHandle        _hDpAccess;

   dp_tclDpPersMemAccess* _poPersMem;
#ifndef DP_FEATURE_UNDEF_ELEMENT
   typedef struct
   {
      tU32    u32PoolID;
      tChar   strPoolName[DP_MAX_LEN_NAME_UNDEFINED_POOLS];
   }tDpUndefClearPool;

#ifdef SYSTEM_S_USE_BPSTL
   typedef bpstl::list<tDpUndefClearPool> tDpUndefClearPoolList;
#else
   typedef std::list<tDpUndefClearPool> tDpUndefClearPoolList;
#endif
   tDpUndefClearPoolList   pDpUndefClearPoolList;
#endif

// ****************************************************************************
// ********   init part 
// ****************************************************************************
public:
   virtual tVoid vInitDp(tU32 u32PoolId, const tChar* cPoolName, tU32 u32PoolVersion, eDpLocation PeLocation, tU8 u8Bank = DP_U8_NO_BANK_ACTION, eDpModeEndUser PeModeEndUser = eDpModeEndUserNo, tBool bDefset = TRUE);
protected:
   virtual tBool bRegisterMaster();

// ****************************************************************************
// ********   element handling 
// ****************************************************************************
public:
   virtual tVoid vInitElement(tU32 u32PoolId, dp_tclBaseElement* tDpElement, dp_tclBaseElement::EDpElemState tElemState = dp_tclBaseElement::eDpElemInit);
   virtual tVoid vInitUnknownCodingElements(tU32 u32PoolId);
protected:
#ifdef DP_FEATURE_UNDEF_ELEMENT
   virtual tVoid vInitUndef(tU32 u32PoolId);
   virtual tVoid vInitUndefElements(tU32 u32PoolId);
   virtual tS32  s32DeleteElement(tDpUndefPoolProperty*  PptPoolProperty, dp_tclBaseElement* PpDpElem);
#endif
   virtual tBool bSetElementToDefault(dp_tclBaseElement* pDpElement);

// ****************************************************************************
// ********   storage handling 
// ****************************************************************************
   virtual tVoid vImportPersData(tU32 u32PoolId, tChar* cPoolName, eDpLocation PeLocation, tU32 u32Version);
   virtual tBool bExportPersData(tU32 u32PoolId, tChar* cPoolName, eDpLocation PeLocation, tU32 u32Version, tBool bfSync = TRUE, tU8 Pu8Bank = DP_U8_NO_BANK_ACTION);

   virtual tVoid vImportSubPoolList();
   virtual tVoid vExportSubPoolList(tU32 u32PoolId);
   virtual tVoid vRemoveAndExportSubPoolList(tU32 u32PoolId);
   virtual tVoid vRemovePoolData(tU32 u32PoolId);
#ifndef DP_FEATURE_UNDEF_ELEMENT
   virtual tVoid vLoadUndefClearPoolList();
#endif
   virtual tVoid vRemovePersistentPool(tU32 u32PoolId, tChar* PcPoolName, eDpLocation eDpLocation);

// ****************************************************************************
// ********   Thread handling 
// ****************************************************************************
   static tVoid   vDpMainThread(tVoid *pvArg);
   OSAL_tThreadID _hThreadId;
   tBool          _bTerminate;

   virtual tBool bPostMasterMessage(dp_tclDatapoolMaster::TDpPoolMsg* pMsg);
   virtual tBool bPostOwnMessage(dp_tclDatapoolMaster::TDpPoolMsg* pMsg);
   virtual tBool bPostMessageToProcessLocatedData(tChar* PpstrProcessNameElementLocated, dp_tclDatapoolMaster::TDpPoolMsg* pMsg);

   virtual void  vWaitDeleteExistingEvents(tU32 u32Mask);
   virtual tS32  s32WaitSync(tU32 u32Mask, tU32 u32Timeout = DP_U32_EVENT_SYNC_DELAY);

   virtual tBool bMessageHandler(dp_tclDatapoolMaster::TDpPoolMsg* pMsg);
   virtual tVoid vTimerHandling(tVoid);

// ****************************************************************************
// ********    methods triggered by master 
// ****************************************************************************
   virtual tVoid vPerformDefSet(tU32 u32DefSetType, tU8 Pu8EndUserOrBank);
#ifdef DP_FEATURE_UNDEF_ELEMENT
   virtual tBool bPerformDefSetUndefPool(tU32 u32PoolId);
#endif
   virtual tVoid vCalcPoolHashes();
   virtual tVoid vStoreNow();
   virtual tVoid vElementChanged(const tChar* strName);
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   virtual tVoid vPerformBankAction(tU8 Pu8Bank, eDpEndUserBankAction PeTypeAction);
   virtual tVoid vPerformCopyEndUser(tU8 Pu8EndUserFrom, tU8 Pu8EndUserTo);
#endif

// ****************************************************************************
// ********    methods for trace
// ****************************************************************************
   virtual tVoid vTracePoolHistory();
   virtual tVoid vTracePoolElement(tVoid);
   virtual tVoid vTracePoolElement(tU32 u32PoolId);
   virtual tVoid vTracePoolElement(const tChar* strName);

   virtual tBool bIsTracingEnabled(dp_tclBaseElement* tDpElement) const;
   virtual tVoid vTraceElement(dp_tclBaseElement* tDpElement, EDpElementTrace eTraceType = eDpElemTrace) const;

// ****************************************************************************
// ********    methods for shared data
// ****************************************************************************
#ifdef DP_FEATURE_UNDEF_ELEMENT
   virtual tS32    s32SharedUndefElementAccess(tDpUndefPoolProperty*  PptPoolProperty, const tChar* PpstrElementName, tBool, tU8* Ppu8Buffer, tS32 Ps32Size);
   virtual tS32    s32SharedUndefElementDelete(tDpUndefPoolProperty*  PptPoolProperty, const tChar* PpstrElementName);
   virtual tBool   bSharedOwnUndefElementCreate(const tChar* PpstrPoolName, const tChar* PpstrElementName);
   virtual void    vSharedOwnUndefElementDestroy(const tChar* PpstrPoolName, const tChar* PpstrElementName);
   virtual tS32    s32SharedOwnUndefElementDelete(const tChar* PpstrPoolName, const tChar* PpstrElementName);
#endif

public:
// ****************************************************************************
// ********   initailzation part 
// ****************************************************************************
   dp_tclDpBase();
   virtual ~dp_tclDpBase();

   virtual tVoid vInitInstance(dp_tclDpPersMemAccess* poPersMem);

   virtual tBool bUnregisterMaster(void);
   virtual tBool bStopThreadWait(void);
#ifdef DP_DATAPOOL_UNIT_TEST
   virtual tVoid vResetUnitTest(char* PcSimProcessName);
#endif
   tVoid   vSetPoolInitCallback(DP_tpvInitPoolCallback pInitCallback, tU32 u32PoolId);
// ****************************************************************************
// ********   element handling 
// ****************************************************************************
   virtual tS32  s32SetElement(tU32 u32PoolId, dp_tclBaseElement* tDpElement, tU16 u16AccessId = 0xffff);
   virtual tS32  s32GetElement(tU32 u32PoolId, dp_tclBaseElement* pDpElement, tU16 u16AccessId = 0xffff);

   virtual tS32  s32SetElement(dp_tclBaseElement* tDpElement, tU16 u16AccessId = 0xffff);
   virtual tS32  s32GetElement(dp_tclBaseElement* pDpElement, tU16 u16AccessId = 0xffff);

#ifdef DP_FEATURE_UNDEF_ELEMENT
   virtual tS32  s32InitUndefElement(const tChar* cUserName, const tChar* cPoolName, eDpLocation peLocation, dp_tclBaseElement* pDpElement);
   virtual tS32	 s32SetUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName, tU8* pu8WriteBuffer, tS32 s32Size);
   virtual tS32	 s32GetUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName, tU8* pu8ReadBuffer, tS32 s32Size);
   virtual tS32  s32DeleteUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName);
#endif

// ****************************************************************************
// ********    methods triggered by user (synchronous via master)
// ****************************************************************************
   virtual tVoid vEnableElementForTrace(const tChar* strName);
   virtual tS32  s32StoreNowSync(tU32 u32AccessId, tU32 u32Timeout);
   virtual tS32  s32SetDefault(tU32 u32AccessId, tU32 u32DefType, tU8 Pu8EndUserOrBank, tU32 u32Timeout);
   virtual tS32  s32SetConfig(tU32 u32PoolId, tU32 u32AccessId, tU32 u32Timeout);

   virtual tS32  s32Lock(tU32 u32AccessId, tU32 u32LockType, tU32 u32Timeout);
   virtual tS32  s32Unlock(tU32 u32AccessId, tU32 u32Timeout);

   virtual tS32  s32CalcHash(tU32* pu32Data, tU32 u32DataLen, tU32 u32AccessId, tU32 u32Timeout);

#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   virtual tS32  s32EndUserBank(tU8 Pu8Bank, tU16 Pu16AccessId, eDpEndUserBankAction PeTypeAction, tU32 Pu32Timeout);
   virtual tS32  s32CopyEndUser(tU8 u8EndUserFrom, tU8 u8EndUserTo, tU16 Pu16AccessId, tU32 Pu32Timeout);
#endif

// ****************************************************************************
// ********    methods triggered by user (asynchronous via master -> fire and return)
// ****************************************************************************
   virtual tVoid vHistoryTrace();
   virtual tVoid vTracePool(tU32 u32PoolId);
   virtual tVoid vTraceElementByName(const tChar* strName);
   virtual tBool bReloadPool(tU32 u32PoolId);

// ****************************************************************************
// ********    methods triggered by user (intern)
// ****************************************************************************
   virtual tBool bAddNotification(tU32 u32PoolId, const tChar* strElementName, tVoid* pvCallback, tU32 u32Event, tU16 u16AccessId = 0xffff);
   virtual tVoid vRemoveNotification(tU32 u32PoolId, const tChar* strElementName, tVoid* pvCallback, tU32 u32Event, tU16 u16AccessId = 0xffff);

   virtual tS32  s32StorePoolNow(tU32 u32PoolId, tU32 u32AccessId);

// ****************************************************************************
// ********    methods for trace
// ****************************************************************************
   virtual tVoid vSetTraceConfiguration(tVoid);

private:
   virtual tS32  s32CheckPoolInit(tU32 u32PoolId);
   virtual tVoid vCheckSubPoolInit(tBool VbDefSet);
#ifdef DP_U32_POOL_ID_DPENDUSERMODE
   virtual tS32  s32CheckPoolInitEndUser(tU32 u32PoolId);
#endif
   virtual tBool bInitPool(tU32 u32PoolId, tU8 u8Bank = DP_U8_NO_BANK_ACTION);
   virtual tBool bSetInitCallbackCore(tU32 u32PoolId);
   virtual tVoid vAddInitCallbacktoList(DP_tpvInitPoolCallback pInitCallback, tU32 u32PoolId)
   {
      _olistInitPoolCallbacks[u32PoolId] = pInitCallback;
   }
};
#endif

//EOF
