#ifndef CMB_FIVISITOR_HEADER
#define CMB_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class cmb_fi_tclOutput {
public:
   cmb_fi_tclOutput();
   virtual ~cmb_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class cmb_fi_tclFileOutput : public cmb_fi_tclOutput 
{
public:
   cmb_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   cmb_fi_tclFileOutput(); //lint !e1704
   cmb_fi_tclFileOutput& operator=(const cmb_fi_tclFileOutput& coRef);
   cmb_fi_tclFileOutput(const cmb_fi_tclFileOutput& coRef); //lint !e1704
};

class cmb_fi_tclMemOutput : public cmb_fi_tclOutput
{
public:
   cmb_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~cmb_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   cmb_fi_tclMemOutput(); //lint !e1704
   cmb_fi_tclMemOutput(const cmb_fi_tclMemOutput& coRef); //lint !e1704
   cmb_fi_tclMemOutput& operator=(const cmb_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL cmb_fi_tclVisitorBase {
public:

   // --Konstruktor
   cmb_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~cmb_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(cmb_fi_tclU8& oU8);
   virtual tVoid vVisitS8(cmb_fi_tclS8& oS8);
   virtual tVoid vVisitU16(cmb_fi_tclU16& oU16);
   virtual tVoid vVisitS16(cmb_fi_tclS16& oS16);
   virtual tVoid vVisitU24(cmb_fi_tclU24& oU24);
   virtual tVoid vVisitS24(cmb_fi_tclS24& oS24);
   virtual tVoid vVisitU32(cmb_fi_tclU32& oU32);
   virtual tVoid vVisitS32(cmb_fi_tclS32& oS32);
   virtual tVoid vVisitU64(cmb_fi_tclU64& oU64);
   virtual tVoid vVisitS64(cmb_fi_tclS64& oS64);
   virtual tVoid vVisitF32(cmb_fi_tclF32& oF32);
   virtual tVoid vVisitF64(cmb_fi_tclF64& oF64);
   virtual tVoid vVisitBool(cmb_fi_tclBool& oBool);
   virtual tVoid vVisitString(cmb_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(cmb_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(cmb_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(cmb_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_e8_AudioChannelAdvice(cmb_fi_tcl_e8_AudioChannelAdvice& oe8_AudioChannelAdvice);

   virtual tVoid vVisit_e8_VoiceCategory(cmb_fi_tcl_e8_VoiceCategory& oe8_VoiceCategory);

   virtual tVoid vVisit_e8_CatStatus(cmb_fi_tcl_e8_CatStatus& oe8_CatStatus);

   virtual tVoid vVisit_AudioChannelAdvice(cmb_fi_tcl_AudioChannelAdvice& oAudioChannelAdvice);

   virtual tVoid vVisit_b8_AudioOutputLocation(cmb_fi_tcl_b8_AudioOutputLocation& ob8_AudioOutputLocation);

   virtual tVoid vVisit_b8_AudioFormat(cmb_fi_tcl_b8_AudioFormat& ob8_AudioFormat);

   virtual tVoid vVisit_InstancesPerCategory(cmb_fi_tcl_InstancesPerCategory& oInstancesPerCategory);

   virtual tVoid vVisit_InstancesPerCategoryList(cmb_fi_tcl_InstancesPerCategoryList& oInstancesPerCategoryList);

   virtual tVoid vVisit_b16_RequestAddInfo(cmb_fi_tcl_b16_RequestAddInfo& ob16_RequestAddInfo);

   virtual tVoid vVisit_ChannelRequestStatus(cmb_fi_tcl_ChannelRequestStatus& oChannelRequestStatus);

   virtual tVoid vVisit_ChannelRequestStatusList(cmb_fi_tcl_ChannelRequestStatusList& oChannelRequestStatusList);

   virtual tVoid vVisit_e8_OdometerStatus(cmb_fi_tcl_e8_OdometerStatus& oe8_OdometerStatus);

   virtual tVoid vVisit_e8_OdometerDirection(cmb_fi_tcl_e8_OdometerDirection& oe8_OdometerDirection);

   virtual tVoid vVisit_e8_GyroError(cmb_fi_tcl_e8_GyroError& oe8_GyroError);

   virtual tVoid vVisit_e8_GpsManufacturer(cmb_fi_tcl_e8_GpsManufacturer& oe8_GpsManufacturer);

   virtual tVoid vVisit_e8_GpsHardwareVersion(cmb_fi_tcl_e8_GpsHardwareVersion& oe8_GpsHardwareVersion);

   virtual tVoid vVisit_e8_GpsAntennaStatus(cmb_fi_tcl_e8_GpsAntennaStatus& oe8_GpsAntennaStatus);

   virtual tVoid vVisit_e8_GpsFrontEndStatus(cmb_fi_tcl_e8_GpsFrontEndStatus& oe8_GpsFrontEndStatus);

   virtual tVoid vVisit_e8_GpsFrontEndDataPattern(cmb_fi_tcl_e8_GpsFrontEndDataPattern& oe8_GpsFrontEndDataPattern);

   virtual tVoid vVisit_b8_GpsFixStatus(cmb_fi_tcl_b8_GpsFixStatus& ob8_GpsFixStatus);

   virtual tVoid vVisit_b8_GnssSatSys(cmb_fi_tcl_b8_GnssSatSys& ob8_GnssSatSys);

   virtual tVoid vVisit_CovarianceMatrixUpperTriangle(cmb_fi_tcl_CovarianceMatrixUpperTriangle& oCovarianceMatrixUpperTriangle);

   virtual tVoid vVisit_OdometerData(cmb_fi_tcl_OdometerData& oOdometerData);

   virtual tVoid vVisit_e16_GyroStatus(cmb_fi_tcl_e16_GyroStatus& oe16_GyroStatus);

   virtual tVoid vVisit_e16_AccStatus(cmb_fi_tcl_e16_AccStatus& oe16_AccStatus);

   virtual tVoid vVisit_GyroData(cmb_fi_tcl_GyroData& oGyroData);

   virtual tVoid vVisit_b16_GpsChannelStatus(cmb_fi_tcl_b16_GpsChannelStatus& ob16_GpsChannelStatus);

   virtual tVoid vVisit_GpsTestAdditionalData(cmb_fi_tcl_GpsTestAdditionalData& oGpsTestAdditionalData);

   virtual tVoid vVisit_GpsBigConstData(cmb_fi_tcl_GpsBigConstData& oGpsBigConstData);

   virtual tVoid vVisit_b32_GpsValidFlags(cmb_fi_tcl_b32_GpsValidFlags& ob32_GpsValidFlags);

   virtual tVoid vVisit_GpsExtBigConstData(cmb_fi_tcl_GpsExtBigConstData& oGpsExtBigConstData);

   virtual tVoid vVisit_b32_MapMatchingHint(cmb_fi_tcl_b32_MapMatchingHint& ob32_MapMatchingHint);

   virtual tVoid vVisit_GpsBigVarData(cmb_fi_tcl_GpsBigVarData& oGpsBigVarData);

   virtual tVoid vVisit_GpsBigdata(cmb_fi_tcl_GpsBigdata& oGpsBigdata);

   virtual tVoid vVisit_GpsExtBigData(cmb_fi_tcl_GpsExtBigData& oGpsExtBigData);

   virtual tVoid vVisit_GpsCommunicationProtocol(cmb_fi_tcl_GpsCommunicationProtocol& oGpsCommunicationProtocol);

   virtual tVoid vVisit_SetData(cmb_fi_tcl_SetData& oSetData);

   virtual tVoid vVisit_TestModeData(cmb_fi_tcl_TestModeData& oTestModeData);

   virtual tVoid vVisit_XoCompensation(cmb_fi_tcl_XoCompensation& oXoCompensation);

   virtual tVoid vVisit_VectorLLA(cmb_fi_tcl_VectorLLA& oVectorLLA);

   virtual tVoid vVisit_VectorNEU(cmb_fi_tcl_VectorNEU& oVectorNEU);

   virtual tVoid vVisit_CovarianceMatrixDiag(cmb_fi_tcl_CovarianceMatrixDiag& oCovarianceMatrixDiag);

   virtual tVoid vVisit_GpsHints(cmb_fi_tcl_GpsHints& oGpsHints);

   virtual tVoid vVisit_GpsExtHints(cmb_fi_tcl_GpsExtHints& oGpsExtHints);

   virtual tVoid vVisit_GpsTightCouplingChannelData(cmb_fi_tcl_GpsTightCouplingChannelData& oGpsTightCouplingChannelData);

   virtual tVoid vVisit_GpsTightCouplingCommonData(cmb_fi_tcl_GpsTightCouplingCommonData& oGpsTightCouplingCommonData);

   virtual tVoid vVisit_GpsTightCouplingData(cmb_fi_tcl_GpsTightCouplingData& oGpsTightCouplingData);

   virtual tVoid vVisit_e8_AbsStatus(cmb_fi_tcl_e8_AbsStatus& oe8_AbsStatus);

   virtual tVoid vVisit_e8_AbsDirection(cmb_fi_tcl_e8_AbsDirection& oe8_AbsDirection);

   virtual tVoid vVisit_AbsData(cmb_fi_tcl_AbsData& oAbsData);

   virtual tVoid vVisit_e8_SteeringStatus(cmb_fi_tcl_e8_SteeringStatus& oe8_SteeringStatus);

   virtual tVoid vVisit_SteeringData(cmb_fi_tcl_SteeringData& oSteeringData);

   virtual tVoid vVisit_e8_OdometerRangeStatus(cmb_fi_tcl_e8_OdometerRangeStatus& oe8_OdometerRangeStatus);

   virtual tVoid vVisit_GpsExtTestmodeStart(cmb_fi_tcl_GpsExtTestmodeStart& oGpsExtTestmodeStart);

   virtual tVoid vVisit_GpsExtTestmodeResult(cmb_fi_tcl_GpsExtTestmodeResult& oGpsExtTestmodeResult);

   virtual tVoid vVisit_e8_DefSetGroups(cmb_fi_tcl_e8_DefSetGroups& oe8_DefSetGroups);

   virtual tVoid vVisit_e8_DefSetMode(cmb_fi_tcl_e8_DefSetMode& oe8_DefSetMode);

   virtual tVoid vVisit_SensorHwInfo(cmb_fi_tcl_SensorHwInfo& oSensorHwInfo);

   virtual tVoid vVisit_3dMountAngles(cmb_fi_tcl_3dMountAngles& o3dMountAngles);

   virtual tVoid vVisit_3dGyroHwInfo(cmb_fi_tcl_3dGyroHwInfo& o3dGyroHwInfo);

   virtual tVoid vVisit_3dAccHwInfo(cmb_fi_tcl_3dAccHwInfo& o3dAccHwInfo);

   virtual tVoid vVisit_3dGyroData(cmb_fi_tcl_3dGyroData& o3dGyroData);

   virtual tVoid vVisit_3dAccData(cmb_fi_tcl_3dAccData& o3dAccData);

   virtual tVoid vVisit_TimeDate(cmb_fi_tcl_TimeDate& oTimeDate);

   virtual tVoid vVisit_e8_timeMode(cmb_fi_tcl_e8_timeMode& oe8_timeMode);

   virtual tVoid vVisit_Reserved(cmb_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_s16_PerThousand(cmb_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_s32_Pascal(cmb_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_u8_Percent(cmb_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s32_Centimeter(cmb_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s16_CentiDegree(cmb_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_KmPerHour(cmb_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_u16_RPM(cmb_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s16_CentimeterSecond(cmb_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Meter(cmb_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(cmb_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(cmb_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Inch(cmb_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Kilogram(cmb_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(cmb_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_u16_MilliSecond(cmb_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(cmb_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_s32_Longitude(cmb_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(cmb_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(cmb_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_s16_MilesPerHour(cmb_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s32_Pound(cmb_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_DeciKelvin(cmb_fi_tcl_s16_DeciKelvin& os16_DeciKelvin);

   virtual tVoid vVisit_s16_CentiDegreeSecond(cmb_fi_tcl_s16_CentiDegreeSecond& os16_CentiDegreeSecond);

   virtual tVoid vVisit_u32_MilliLux(cmb_fi_tcl_u32_MilliLux& ou32_MilliLux);

   virtual tVoid vVisit_u32_Microliter(cmb_fi_tcl_u32_Microliter& ou32_Microliter);

   virtual tVoid vVisit_s16_CentimeterSquareSecond(cmb_fi_tcl_s16_CentimeterSquareSecond& os16_CentimeterSquareSecond);

   virtual tVoid vVisit_s16_CurvatureValue(cmb_fi_tcl_s16_CurvatureValue& os16_CurvatureValue);

   virtual tVoid vVisit_s32_CurvatureChange(cmb_fi_tcl_s32_CurvatureChange& os32_CurvatureChange);

   virtual tVoid vVisit_e16_BaseTrafficSign(cmb_fi_tcl_e16_BaseTrafficSign& oe16_BaseTrafficSign);

   virtual tVoid vVisit_e8_BaseTrafficSignCategory(cmb_fi_tcl_e8_BaseTrafficSignCategory& oe8_BaseTrafficSignCategory);

   virtual tVoid vVisit_e8_SpeedSign(cmb_fi_tcl_e8_SpeedSign& oe8_SpeedSign);

   virtual tVoid vVisit_e16_WarningSign(cmb_fi_tcl_e16_WarningSign& oe16_WarningSign);

   virtual tVoid vVisit_e16_RegulatorySign(cmb_fi_tcl_e16_RegulatorySign& oe16_RegulatorySign);

   virtual tVoid vVisit_e16_AdditionalTrafficSign(cmb_fi_tcl_e16_AdditionalTrafficSign& oe16_AdditionalTrafficSign);

   virtual tVoid vVisit_TimeDependentString(cmb_fi_tcl_TimeDependentString& oTimeDependentString);

   virtual tVoid vVisit_b8_LaneDependentValidity(cmb_fi_tcl_b8_LaneDependentValidity& ob8_LaneDependentValidity);

   virtual tVoid vVisit_e8_TrafficSignQuantifier(cmb_fi_tcl_e8_TrafficSignQuantifier& oe8_TrafficSignQuantifier);

   virtual tVoid vVisit_AdditionalTrafficSign(cmb_fi_tcl_AdditionalTrafficSign& oAdditionalTrafficSign);

   virtual tVoid vVisit_TrafficSignElement(cmb_fi_tcl_TrafficSignElement& oTrafficSignElement);

   virtual tVoid vVisit_VeSe_WheelSlip(cmb_fi_tcl_VeSe_WheelSlip& oVeSe_WheelSlip);

   virtual tVoid vVisit_VeSe_WheelBrakePressure(cmb_fi_tcl_VeSe_WheelBrakePressure& oVeSe_WheelBrakePressure);

   virtual tVoid vVisit_VeSe_WheelAirPressure(cmb_fi_tcl_VeSe_WheelAirPressure& oVeSe_WheelAirPressure);

   virtual tVoid vVisit_e8_VeSe_Activation(cmb_fi_tcl_e8_VeSe_Activation& oe8_VeSe_Activation);

   virtual tVoid vVisit_e8_VeSe_DoorType(cmb_fi_tcl_e8_VeSe_DoorType& oe8_VeSe_DoorType);

   virtual tVoid vVisit_e8_VeSe_WindowType(cmb_fi_tcl_e8_VeSe_WindowType& oe8_VeSe_WindowType);

   virtual tVoid vVisit_e8_VeSe_LineColor(cmb_fi_tcl_e8_VeSe_LineColor& oe8_VeSe_LineColor);

   virtual tVoid vVisit_VeSe_DoorStatus(cmb_fi_tcl_VeSe_DoorStatus& oVeSe_DoorStatus);

   virtual tVoid vVisit_VeSe_WindowStatus(cmb_fi_tcl_VeSe_WindowStatus& oVeSe_WindowStatus);

   virtual tVoid vVisit_e8_VeSe_SeatOccupation(cmb_fi_tcl_e8_VeSe_SeatOccupation& oe8_VeSe_SeatOccupation);

   virtual tVoid vVisit_e8_VeSe_DirectionIndicator(cmb_fi_tcl_e8_VeSe_DirectionIndicator& oe8_VeSe_DirectionIndicator);

   virtual tVoid vVisit_e8_VeSe_GearNum(cmb_fi_tcl_e8_VeSe_GearNum& oe8_VeSe_GearNum);

   virtual tVoid vVisit_b8_VeSe_GearBoxState(cmb_fi_tcl_b8_VeSe_GearBoxState& ob8_VeSe_GearBoxState);

   virtual tVoid vVisit_e8_VeSe_CCType(cmb_fi_tcl_e8_VeSe_CCType& oe8_VeSe_CCType);

   virtual tVoid vVisit_e8_VeSe_CCState(cmb_fi_tcl_e8_VeSe_CCState& oe8_VeSe_CCState);

   virtual tVoid vVisit_e8_VeSe_Ignition(cmb_fi_tcl_e8_VeSe_Ignition& oe8_VeSe_Ignition);

   virtual tVoid vVisit_b32_VeSe_BrakeControlMode(cmb_fi_tcl_b32_VeSe_BrakeControlMode& ob32_VeSe_BrakeControlMode);

   virtual tVoid vVisit_b16_VeSe_CentralLocking(cmb_fi_tcl_b16_VeSe_CentralLocking& ob16_VeSe_CentralLocking);

   virtual tVoid vVisit_e8_VeSe_RotationIrregularity(cmb_fi_tcl_e8_VeSe_RotationIrregularity& oe8_VeSe_RotationIrregularity);

   virtual tVoid vVisit_e8_VeSe_OverrunFuelShutoff(cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff& oe8_VeSe_OverrunFuelShutoff);

   virtual tVoid vVisit_e8_VeSe_ConverterClutch(cmb_fi_tcl_e8_VeSe_ConverterClutch& oe8_VeSe_ConverterClutch);

   virtual tVoid vVisit_e8_VeSe_GearboxSportSwitch(cmb_fi_tcl_e8_VeSe_GearboxSportSwitch& oe8_VeSe_GearboxSportSwitch);

   virtual tVoid vVisit_e8_VeSe_HeadLights(cmb_fi_tcl_e8_VeSe_HeadLights& oe8_VeSe_HeadLights);

   virtual tVoid vVisit_VeSe_SeatStatus(cmb_fi_tcl_VeSe_SeatStatus& oVeSe_SeatStatus);

   virtual tVoid vVisit_e8_VeSe_VehicleDrivingCondition(cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition& oe8_VeSe_VehicleDrivingCondition);

   virtual tVoid vVisit_e8_VeSe_KeyValidity(cmb_fi_tcl_e8_VeSe_KeyValidity& oe8_VeSe_KeyValidity);

   virtual tVoid vVisit_e8_VeSe_KeyType(cmb_fi_tcl_e8_VeSe_KeyType& oe8_VeSe_KeyType);

   virtual tVoid vVisit_b16_VeSe_KeyLocation(cmb_fi_tcl_b16_VeSe_KeyLocation& ob16_VeSe_KeyLocation);

   virtual tVoid vVisit_b16_VeSe_EngineStatus(cmb_fi_tcl_b16_VeSe_EngineStatus& ob16_VeSe_EngineStatus);

   virtual tVoid vVisit_e8_VeSe_ReductionRPM(cmb_fi_tcl_e8_VeSe_ReductionRPM& oe8_VeSe_ReductionRPM);

   virtual tVoid vVisit_b16_VeSe_ActiveSeats(cmb_fi_tcl_b16_VeSe_ActiveSeats& ob16_VeSe_ActiveSeats);

   virtual tVoid vVisit_e8_VeSe_SideIndicator(cmb_fi_tcl_e8_VeSe_SideIndicator& oe8_VeSe_SideIndicator);

   virtual tVoid vVisit_VeSe_LineInfo(cmb_fi_tcl_VeSe_LineInfo& oVeSe_LineInfo);

   virtual tVoid vVisit_e8_VeSe_ObjectType(cmb_fi_tcl_e8_VeSe_ObjectType& oe8_VeSe_ObjectType);

   virtual tVoid vVisit_s16_VeSe_Torque(cmb_fi_tcl_s16_VeSe_Torque& os16_VeSe_Torque);

   virtual tVoid vVisit_VeSe_DetectedObject(cmb_fi_tcl_VeSe_DetectedObject& oVeSe_DetectedObject);

   virtual tVoid vVisit_VeSe_TSClassificationQuality(cmb_fi_tcl_VeSe_TSClassificationQuality& oVeSe_TSClassificationQuality);

   virtual tVoid vVisit_VeSe_TSQuality(cmb_fi_tcl_VeSe_TSQuality& oVeSe_TSQuality);

   virtual tVoid vVisit_VeSe_DetectedTrafficSign(cmb_fi_tcl_VeSe_DetectedTrafficSign& oVeSe_DetectedTrafficSign);

   virtual tVoid vVisit_s32_Ws(cmb_fi_tcl_s32_Ws& os32_Ws);

   virtual tVoid vVisit_u32_Ws(cmb_fi_tcl_u32_Ws& ou32_Ws);

   virtual tVoid vVisit_u16_W(cmb_fi_tcl_u16_W& ou16_W);

   virtual tVoid vVisit_s32_MilliVolt(cmb_fi_tcl_s32_MilliVolt& os32_MilliVolt);

   virtual tVoid vVisit_s32_MilliAmpere(cmb_fi_tcl_s32_MilliAmpere& os32_MilliAmpere);

   virtual tVoid vVisit_u16_min(cmb_fi_tcl_u16_min& ou16_min);

   virtual tVoid vVisit_e8_EOperationMode(cmb_fi_tcl_e8_EOperationMode& oe8_EOperationMode);

   virtual tVoid vVisit_b8_CouplingMode(cmb_fi_tcl_b8_CouplingMode& ob8_CouplingMode);

   virtual tVoid vVisit_EnergyConsumption(cmb_fi_tcl_EnergyConsumption& oEnergyConsumption);

   virtual tVoid vVisit_PowerDemandAtSpeed(cmb_fi_tcl_PowerDemandAtSpeed& oPowerDemandAtSpeed);

   virtual tVoid vVisit_ElectricalMachine(cmb_fi_tcl_ElectricalMachine& oElectricalMachine);

   virtual tVoid vVisit_e8_VeSe_K0Status(cmb_fi_tcl_e8_VeSe_K0Status& oe8_VeSe_K0Status);

   virtual tVoid vVisit_VeSe_VoltageParams(cmb_fi_tcl_VeSe_VoltageParams& oVeSe_VoltageParams);

   virtual tVoid vVisit_VeSe_CurrentParams(cmb_fi_tcl_VeSe_CurrentParams& oVeSe_CurrentParams);

   virtual tVoid vVisit_b16_VeSe_Environment(cmb_fi_tcl_b16_VeSe_Environment& ob16_VeSe_Environment);

   virtual tVoid vVisit_VeSe_IPPCPlusData(cmb_fi_tcl_VeSe_IPPCPlusData& oVeSe_IPPCPlusData);

   virtual tVoid vVisit_u8_SD_PackageID(cmb_fi_tcl_u8_SD_PackageID& ou8_SD_PackageID);

   virtual tVoid vVisit_SD_Package(cmb_fi_tcl_SD_Package& oSD_Package);

   virtual tVoid vVisit_e8_DownloadStatus(cmb_fi_tcl_e8_DownloadStatus& oe8_DownloadStatus);

   virtual tVoid vVisit_SD_PackageLoadStatus(cmb_fi_tcl_SD_PackageLoadStatus& oSD_PackageLoadStatus);

   virtual tVoid vVisit_e8_SD_Damage(cmb_fi_tcl_e8_SD_Damage& oe8_SD_Damage);

   virtual tVoid vVisit_e8_SD_Format(cmb_fi_tcl_e8_SD_Format& oe8_SD_Format);

   virtual tVoid vVisit_e8_SpeechCategory(cmb_fi_tcl_e8_SpeechCategory& oe8_SpeechCategory);

   virtual tVoid vVisit_b16_CategoryAddInfo(cmb_fi_tcl_b16_CategoryAddInfo& ob16_CategoryAddInfo);

   virtual tVoid vVisit_e8_SpeechSequence(cmb_fi_tcl_e8_SpeechSequence& oe8_SpeechSequence);

   virtual tVoid vVisit_SD_Phrase(cmb_fi_tcl_SD_Phrase& oSD_Phrase);

   virtual tVoid vVisit_SD_Sentence(cmb_fi_tcl_SD_Sentence& oSD_Sentence);

   virtual tVoid vVisit_SD_SentenceAndParam(cmb_fi_tcl_SD_SentenceAndParam& oSD_SentenceAndParam);

   virtual tVoid vVisit_u16_SD_SampleFrequency(cmb_fi_tcl_u16_SD_SampleFrequency& ou16_SD_SampleFrequency);

   virtual tVoid vVisit_SD_Settings(cmb_fi_tcl_SD_Settings& oSD_Settings);

   virtual tVoid vVisit_u8_SD_Size(cmb_fi_tcl_u8_SD_Size& ou8_SD_Size);

   virtual tVoid vVisit_SD_Reference(cmb_fi_tcl_SD_Reference& oSD_Reference);

   virtual tVoid vVisit_e8_StopVOPriority(cmb_fi_tcl_e8_StopVOPriority& oe8_StopVOPriority);

   virtual tVoid vVisit_b8_PhraseStatus(cmb_fi_tcl_b8_PhraseStatus& ob8_PhraseStatus);

   virtual tVoid vVisit_TTSPhraseInfo(cmb_fi_tcl_TTSPhraseInfo& oTTSPhraseInfo);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
