/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CMB_VOICEFITYPES_HEADER
#define CMB_VOICEFITYPES_HEADER


class cmb_voicefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for CMB_Voice_FI message types

fi_tclMessageBase* cmb_voicefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class cmb_voicefi_tclMsgBaseMessage : public cmb_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   cmb_voicefi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class cmb_voicefi_tclMsgSpeechDownloadMethodStart : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDownloadMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDownloadMethodStart& operator=(const cmb_voicefi_tclMsgSpeechDownloadMethodStart& coRef);
   cmb_voicefi_tclMsgSpeechDownloadMethodStart(const cmb_voicefi_tclMsgSpeechDownloadMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_SD_Package, std::allocator<cmb_fi_tcl_SD_Package> > SpeechData;
   virtual ~cmb_voicefi_tclMsgSpeechDownloadMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDownloadMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDownloadMethodResult : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDownloadMethodResult();

   virtual ~cmb_voicefi_tclMsgSpeechDownloadMethodResult();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDownloadMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataContentsMethodStart : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataContentsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataContentsMethodStart& operator=(const cmb_voicefi_tclMsgSpeechDataContentsMethodStart& coRef);
   cmb_voicefi_tclMsgSpeechDataContentsMethodStart(const cmb_voicefi_tclMsgSpeechDataContentsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_u8_SD_PackageID SD_Package;
   tU32 StartAddress;
   tU32 NoOfBytes;
   virtual ~cmb_voicefi_tclMsgSpeechDataContentsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataContentsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataContentsMethodResult : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataContentsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataContentsMethodResult& operator=(const cmb_voicefi_tclMsgSpeechDataContentsMethodResult& coRef);
   cmb_voicefi_tclMsgSpeechDataContentsMethodResult(const cmb_voicefi_tclMsgSpeechDataContentsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > SD_Contents;
   virtual ~cmb_voicefi_tclMsgSpeechDataContentsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataContentsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart& operator=(const cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart& coRef);
   cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart(const cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_u8_SD_PackageID, std::allocator<cmb_fi_tcl_u8_SD_PackageID> > CheckPackages;
   virtual ~cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult();

   virtual ~cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgPrepareTTSMethodStart : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgPrepareTTSMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgPrepareTTSMethodStart& operator=(const cmb_voicefi_tclMsgPrepareTTSMethodStart& coRef);
   cmb_voicefi_tclMsgPrepareTTSMethodStart(const cmb_voicefi_tclMsgPrepareTTSMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tclString TextAndTags;
   tU32 Expiry;
   tBool HasDict;
   virtual ~cmb_voicefi_tclMsgPrepareTTSMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgPrepareTTSMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgPrepareTTSMethodResult : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgPrepareTTSMethodResult();

   virtual ~cmb_voicefi_tclMsgPrepareTTSMethodResult();

   inline tBool operator==(const cmb_voicefi_tclMsgPrepareTTSMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeakSentenceMethodStart : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeakSentenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeakSentenceMethodStart& operator=(const cmb_voicefi_tclMsgSpeakSentenceMethodStart& coRef);
   cmb_voicefi_tclMsgSpeakSentenceMethodStart(const cmb_voicefi_tclMsgSpeakSentenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_SD_Sentence Sentence;
   virtual ~cmb_voicefi_tclMsgSpeakSentenceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeakSentenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeakSentenceMethodResult : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeakSentenceMethodResult();

   virtual ~cmb_voicefi_tclMsgSpeakSentenceMethodResult();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeakSentenceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart& operator=(const cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart& coRef);
   cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart(const cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_SpeechCategory Category;
   cmb_fi_tcl_SD_Sentence Sentence;
   tU32 Timeout;
   cmb_fi_tcl_b16_CategoryAddInfo RequestAddInfo;
   virtual ~cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult();

   virtual ~cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart& operator=(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart& coRef);
   cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_SpeechSequence SpeechSequence;
   std::vector<cmb_fi_tcl_SD_SentenceAndParam, std::allocator<cmb_fi_tcl_SD_SentenceAndParam> > SentenceList;
   virtual ~cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult& operator=(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult& coRef);
   cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Index;
   virtual ~cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeakStopMethodStart : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeakStopMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeakStopMethodStart& operator=(const cmb_voicefi_tclMsgSpeakStopMethodStart& coRef);
   cmb_voicefi_tclMsgSpeakStopMethodStart(const cmb_voicefi_tclMsgSpeakStopMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_StopVOPriority e8StopVOPriority;
   virtual ~cmb_voicefi_tclMsgSpeakStopMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeakStopMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeakStopMethodResult : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeakStopMethodResult();

   virtual ~cmb_voicefi_tclMsgSpeakStopMethodResult();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeakStopMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDownloadStatusGet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDownloadStatusGet();

   virtual ~cmb_voicefi_tclMsgSpeechDownloadStatusGet();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDownloadStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDownloadStatusUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDownloadStatusUpReg();

   virtual ~cmb_voicefi_tclMsgSpeechDownloadStatusUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDownloadStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg();

   virtual ~cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDownloadStatusStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDownloadStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDownloadStatusStatus& operator=(const cmb_voicefi_tclMsgSpeechDownloadStatusStatus& coRef);
   cmb_voicefi_tclMsgSpeechDownloadStatusStatus(const cmb_voicefi_tclMsgSpeechDownloadStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_SD_PackageLoadStatus, std::allocator<cmb_fi_tcl_SD_PackageLoadStatus> > AvailablePackage;
   virtual ~cmb_voicefi_tclMsgSpeechDownloadStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDownloadStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataIntegrityGet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataIntegrityGet();

   virtual ~cmb_voicefi_tclMsgSpeechDataIntegrityGet();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDataIntegrityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataIntegrityUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataIntegrityUpReg();

   virtual ~cmb_voicefi_tclMsgSpeechDataIntegrityUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDataIntegrityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg();

   virtual ~cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataIntegrityStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataIntegrityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataIntegrityStatus& operator=(const cmb_voicefi_tclMsgSpeechDataIntegrityStatus& coRef);
   cmb_voicefi_tclMsgSpeechDataIntegrityStatus(const cmb_voicefi_tclMsgSpeechDataIntegrityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_SD_Damage SD_Damage;
   std::vector<cmb_fi_tcl_u8_SD_PackageID, std::allocator<cmb_fi_tcl_u8_SD_PackageID> > SD_DamagedPackages;
   virtual ~cmb_voicefi_tclMsgSpeechDataIntegrityStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataIntegrityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataMemoryGet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataMemoryGet();

   virtual ~cmb_voicefi_tclMsgSpeechDataMemoryGet();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDataMemoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataMemoryStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataMemoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataMemoryStatus& operator=(const cmb_voicefi_tclMsgSpeechDataMemoryStatus& coRef);
   cmb_voicefi_tclMsgSpeechDataMemoryStatus(const cmb_voicefi_tclMsgSpeechDataMemoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SD_MB_Size;
   tU16 SD_KB_Size;
   virtual ~cmb_voicefi_tclMsgSpeechDataMemoryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataMemoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataFormatGet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataFormatGet();

   virtual ~cmb_voicefi_tclMsgSpeechDataFormatGet();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDataFormatGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataFormatStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataFormatStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataFormatStatus& operator=(const cmb_voicefi_tclMsgSpeechDataFormatStatus& coRef);
   cmb_voicefi_tclMsgSpeechDataFormatStatus(const cmb_voicefi_tclMsgSpeechDataFormatStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_e8_SD_Format, std::allocator<cmb_fi_tcl_e8_SD_Format> > SD_Format;
   virtual ~cmb_voicefi_tclMsgSpeechDataFormatStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataFormatStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataCustomerGet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataCustomerGet();

   virtual ~cmb_voicefi_tclMsgSpeechDataCustomerGet();

   inline tBool operator==(const cmb_voicefi_tclMsgSpeechDataCustomerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataCustomerStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataCustomerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataCustomerStatus& operator=(const cmb_voicefi_tclMsgSpeechDataCustomerStatus& coRef);
   cmb_voicefi_tclMsgSpeechDataCustomerStatus(const cmb_voicefi_tclMsgSpeechDataCustomerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SD_CustomerID;
   tU32 SD_PlatformID;
   virtual ~cmb_voicefi_tclMsgSpeechDataCustomerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataCustomerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseInfoGet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseInfoGet();

   virtual ~cmb_voicefi_tclMsgTTSPhraseInfoGet();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSPhraseInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseInfoSet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseInfoSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgTTSPhraseInfoSet& operator=(const cmb_voicefi_tclMsgTTSPhraseInfoSet& coRef);
   cmb_voicefi_tclMsgTTSPhraseInfoSet(const cmb_voicefi_tclMsgTTSPhraseInfoSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > PhrasesToKeep_v3;
   std::vector<cmb_fi_tcl_SD_Phrase, std::allocator<cmb_fi_tcl_SD_Phrase> > PhrasesToKeep;
   virtual ~cmb_voicefi_tclMsgTTSPhraseInfoSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgTTSPhraseInfoSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseInfoUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseInfoUpReg();

   virtual ~cmb_voicefi_tclMsgTTSPhraseInfoUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSPhraseInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg();

   virtual ~cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseInfoStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgTTSPhraseInfoStatus& operator=(const cmb_voicefi_tclMsgTTSPhraseInfoStatus& coRef);
   cmb_voicefi_tclMsgTTSPhraseInfoStatus(const cmb_voicefi_tclMsgTTSPhraseInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_TTSPhraseInfo, std::allocator<cmb_fi_tcl_TTSPhraseInfo> > Phrases;
   virtual ~cmb_voicefi_tclMsgTTSPhraseInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgTTSPhraseInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseMemoryGet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseMemoryGet();

   virtual ~cmb_voicefi_tclMsgTTSPhraseMemoryGet();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSPhraseMemoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseMemoryUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseMemoryUpReg();

   virtual ~cmb_voicefi_tclMsgTTSPhraseMemoryUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSPhraseMemoryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg();

   virtual ~cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSPhraseMemoryStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSPhraseMemoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgTTSPhraseMemoryStatus& operator=(const cmb_voicefi_tclMsgTTSPhraseMemoryStatus& coRef);
   cmb_voicefi_tclMsgTTSPhraseMemoryStatus(const cmb_voicefi_tclMsgTTSPhraseMemoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Total;
   tU32 Missing;
   virtual ~cmb_voicefi_tclMsgTTSPhraseMemoryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgTTSPhraseMemoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSVoiceGet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSVoiceGet();

   virtual ~cmb_voicefi_tclMsgTTSVoiceGet();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSVoiceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSVoiceUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSVoiceUpReg();

   virtual ~cmb_voicefi_tclMsgTTSVoiceUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSVoiceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSVoiceRelUpReg : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSVoiceRelUpReg();

   virtual ~cmb_voicefi_tclMsgTTSVoiceRelUpReg();

   inline tBool operator==(const cmb_voicefi_tclMsgTTSVoiceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgTTSVoiceStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgTTSVoiceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgTTSVoiceStatus& operator=(const cmb_voicefi_tclMsgTTSVoiceStatus& coRef);
   cmb_voicefi_tclMsgTTSVoiceStatus(const cmb_voicefi_tclMsgTTSVoiceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 LanguageCode;
   tU16 CountryCode;
   std::vector<tU8, std::allocator<tU8> > Name;
   tU8 Gender;
   virtual ~cmb_voicefi_tclMsgTTSVoiceStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgTTSVoiceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataSettingsSet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataSettingsSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataSettingsSet& operator=(const cmb_voicefi_tclMsgSpeechDataSettingsSet& coRef);
   cmb_voicefi_tclMsgSpeechDataSettingsSet(const cmb_voicefi_tclMsgSpeechDataSettingsSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_SD_Settings SD_Settings;
   virtual ~cmb_voicefi_tclMsgSpeechDataSettingsSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataSettingsSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataSettingsStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataSettingsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataSettingsStatus& operator=(const cmb_voicefi_tclMsgSpeechDataSettingsStatus& coRef);
   cmb_voicefi_tclMsgSpeechDataSettingsStatus(const cmb_voicefi_tclMsgSpeechDataSettingsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_SD_Settings SD_Settings;
   virtual ~cmb_voicefi_tclMsgSpeechDataSettingsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataSettingsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataReferenceSet : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataReferenceSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataReferenceSet& operator=(const cmb_voicefi_tclMsgSpeechDataReferenceSet& coRef);
   cmb_voicefi_tclMsgSpeechDataReferenceSet(const cmb_voicefi_tclMsgSpeechDataReferenceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_SD_Reference SD_Reference;
   virtual ~cmb_voicefi_tclMsgSpeechDataReferenceSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataReferenceSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_voicefi_tclMsgSpeechDataReferenceStatus : public cmb_voicefi_tclMsgBaseMessage
{
public:

   cmb_voicefi_tclMsgSpeechDataReferenceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_voicefi_tclMsgSpeechDataReferenceStatus& operator=(const cmb_voicefi_tclMsgSpeechDataReferenceStatus& coRef);
   cmb_voicefi_tclMsgSpeechDataReferenceStatus(const cmb_voicefi_tclMsgSpeechDataReferenceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~cmb_voicefi_tclMsgSpeechDataReferenceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_voicefi_tclMsgSpeechDataReferenceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
