/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_CMB_VOICEFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_VOICEFI_FUNCTIONIDS
#define CMB_FI_S_IMPORT_INTERFACE_CMB_VOICEFI_SERVICEINFO
#include "cmb_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for CMB_Voice_FI message types

fi_tclMessageBase* cmb_voicefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADMETHODSTART:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDownloadMethodStart;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADMETHODRESULT:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDownloadMethodResult;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODSTART:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataContentsMethodStart;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODRESULT:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataContentsMethodResult;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACRCCHECKMETHODSTART:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACRCCHECKMETHODRESULT:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult;

      case cmb_voicefi_tclToken::EN_MSG_PREPARETTSMETHODSTART:
         return OSAL_NEW cmb_voicefi_tclMsgPrepareTTSMethodStart;

      case cmb_voicefi_tclToken::EN_MSG_PREPARETTSMETHODRESULT:
         return OSAL_NEW cmb_voicefi_tclMsgPrepareTTSMethodResult;

      case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART:
         return OSAL_NEW cmb_voicefi_tclMsgSpeakSentenceMethodStart;

      case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT:
         return OSAL_NEW cmb_voicefi_tclMsgSpeakSentenceMethodResult;

      case cmb_voicefi_tclToken::EN_MSG_SPEAKCATEGORIZEDSENTENCEMETHODSTART:
         return OSAL_NEW cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart;

      case cmb_voicefi_tclToken::EN_MSG_SPEAKCATEGORIZEDSENTENCEMETHODRESULT:
         return OSAL_NEW cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult;

      case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCESELECTMETHODSTART:
         return OSAL_NEW cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart;

      case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCESELECTMETHODRESULT:
         return OSAL_NEW cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult;

      case cmb_voicefi_tclToken::EN_MSG_SPEAKSTOPMETHODSTART:
         return OSAL_NEW cmb_voicefi_tclMsgSpeakStopMethodStart;

      case cmb_voicefi_tclToken::EN_MSG_SPEAKSTOPMETHODRESULT:
         return OSAL_NEW cmb_voicefi_tclMsgSpeakStopMethodResult;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSGET:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDownloadStatusGet;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDownloadStatusUpReg;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSRELUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSSTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDownloadStatusStatus;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYGET:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataIntegrityGet;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataIntegrityUpReg;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYRELUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYSTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataIntegrityStatus;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAMEMORYGET:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataMemoryGet;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAMEMORYSTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataMemoryStatus;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAFORMATGET:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataFormatGet;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAFORMATSTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataFormatStatus;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACUSTOMERGET:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataCustomerGet;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACUSTOMERSTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataCustomerStatus;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOGET:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseInfoGet;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOSET:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseInfoSet;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseInfoUpReg;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFORELUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOSTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseInfoStatus;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYGET:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseMemoryGet;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseMemoryUpReg;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYRELUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg;

      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYSTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgTTSPhraseMemoryStatus;

      case cmb_voicefi_tclToken::EN_MSG_TTSVOICEGET:
         return OSAL_NEW cmb_voicefi_tclMsgTTSVoiceGet;

      case cmb_voicefi_tclToken::EN_MSG_TTSVOICEUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgTTSVoiceUpReg;

      case cmb_voicefi_tclToken::EN_MSG_TTSVOICERELUPREG:
         return OSAL_NEW cmb_voicefi_tclMsgTTSVoiceRelUpReg;

      case cmb_voicefi_tclToken::EN_MSG_TTSVOICESTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgTTSVoiceStatus;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATASETTINGSSET:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataSettingsSet;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATASETTINGSSTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataSettingsStatus;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAREFERENCESET:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataReferenceSet;

      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAREFERENCESTATUS:
         return OSAL_NEW cmb_voicefi_tclMsgSpeechDataReferenceStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all cmb_voicefifi messages

// common functions

tU16 cmb_voicefi_tclMsgBaseMessage::u16GetServiceID() const
{
   return CMB_VOICEFI_C_U16_SERVICE_ID;
}

tU16 cmb_voicefi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 cmb_voicefi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& cmb_voicefi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& cmb_voicefi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 cmb_voicefi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& cmb_voicefi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& cmb_voicefi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDownloadMethodStart::cmb_voicefi_tclMsgSpeechDownloadMethodStart(const cmb_voicefi_tclMsgSpeechDownloadMethodStart& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SpeechData = coRef.SpeechData;
}
cmb_voicefi_tclMsgSpeechDownloadMethodStart& cmb_voicefi_tclMsgSpeechDownloadMethodStart::operator=(const cmb_voicefi_tclMsgSpeechDownloadMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SpeechData = coRef.SpeechData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeechDownloadMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SpeechData.size(); ++u32Idx)
         SpeechData[u32Idx].vDestroy();
   SpeechData.clear();
   }
}

cmb_voicefi_tclMsgSpeechDownloadMethodStart::cmb_voicefi_tclMsgSpeechDownloadMethodStart()

 {}

tS32 cmb_voicefi_tclMsgSpeechDownloadMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADMETHODSTART;
}


cmb_voicefi_tclMsgSpeechDownloadMethodStart::~cmb_voicefi_tclMsgSpeechDownloadMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeechDownloadMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SpeechData.size(); ++u32ListIdx)
      u32DynamicSize += SpeechData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDownloadMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpeechData.size(); ++u32Idx)
      {
         SpeechData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SpeechData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SpeechData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDownloadMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SpeechData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SpeechData.size(); ++u32Idx)
         (tVoid) (oOut << SpeechData[u32Idx]);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDownloadMethodStart::operator==(const cmb_voicefi_tclMsgSpeechDownloadMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SpeechData.size() == roRef.SpeechData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeechData.size()); ++u32Idx)
            bResult = bResult && (SpeechData[u32Idx] == roRef.SpeechData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeechDownloadMethodResult::cmb_voicefi_tclMsgSpeechDownloadMethodResult()
 {}

tS32 cmb_voicefi_tclMsgSpeechDownloadMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADMETHODRESULT;
}


cmb_voicefi_tclMsgSpeechDownloadMethodResult::~cmb_voicefi_tclMsgSpeechDownloadMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataContentsMethodStart::cmb_voicefi_tclMsgSpeechDataContentsMethodStart(const cmb_voicefi_tclMsgSpeechDataContentsMethodStart& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_Package = coRef.SD_Package;
   StartAddress = coRef.StartAddress;
   NoOfBytes = coRef.NoOfBytes;
}
cmb_voicefi_tclMsgSpeechDataContentsMethodStart& cmb_voicefi_tclMsgSpeechDataContentsMethodStart::operator=(const cmb_voicefi_tclMsgSpeechDataContentsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SD_Package = coRef.SD_Package;
   StartAddress = coRef.StartAddress;
   NoOfBytes = coRef.NoOfBytes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeechDataContentsMethodStart::cmb_voicefi_tclMsgSpeechDataContentsMethodStart()
:SD_Package()
,StartAddress(0)
,NoOfBytes(0)
 {}

tS32 cmb_voicefi_tclMsgSpeechDataContentsMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODSTART;
}


cmb_voicefi_tclMsgSpeechDataContentsMethodStart::~cmb_voicefi_tclMsgSpeechDataContentsMethodStart()
{}

tU32 cmb_voicefi_tclMsgSpeechDataContentsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataContentsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_Package);
   (tVoid) (oIn >> StartAddress);
   (tVoid) (oIn >> NoOfBytes);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataContentsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_Package);
   (tVoid) (oOut << StartAddress);
   (tVoid) (oOut << NoOfBytes);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataContentsMethodStart::operator==(const cmb_voicefi_tclMsgSpeechDataContentsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_Package == roRef.SD_Package);
   bResult = bResult && (StartAddress == roRef.StartAddress);
   bResult = bResult && (NoOfBytes == roRef.NoOfBytes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataContentsMethodResult::cmb_voicefi_tclMsgSpeechDataContentsMethodResult(const cmb_voicefi_tclMsgSpeechDataContentsMethodResult& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_Contents = coRef.SD_Contents;
}
cmb_voicefi_tclMsgSpeechDataContentsMethodResult& cmb_voicefi_tclMsgSpeechDataContentsMethodResult::operator=(const cmb_voicefi_tclMsgSpeechDataContentsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SD_Contents = coRef.SD_Contents;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeechDataContentsMethodResult::vDestroy()
{
   {
   SD_Contents.clear();
   }
}

cmb_voicefi_tclMsgSpeechDataContentsMethodResult::cmb_voicefi_tclMsgSpeechDataContentsMethodResult()

 {}

tS32 cmb_voicefi_tclMsgSpeechDataContentsMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODRESULT;
}


cmb_voicefi_tclMsgSpeechDataContentsMethodResult::~cmb_voicefi_tclMsgSpeechDataContentsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeechDataContentsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SD_Contents.size()*1);
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataContentsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      SD_Contents.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SD_Contents[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataContentsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SD_Contents.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SD_Contents.size(); ++u32Idx)
         (tVoid) (oOut << SD_Contents[u32Idx]);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataContentsMethodResult::operator==(const cmb_voicefi_tclMsgSpeechDataContentsMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SD_Contents.size() == roRef.SD_Contents.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SD_Contents.size()); ++u32Idx)
            bResult = bResult && (SD_Contents[u32Idx] == roRef.SD_Contents[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart(const cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   CheckPackages = coRef.CheckPackages;
}
cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart& cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::operator=(const cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CheckPackages = coRef.CheckPackages;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::vDestroy()
{
   {
   CheckPackages.clear();
   }
}

cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart()

 {}

tS32 cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATACRCCHECKMETHODSTART;
}


cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::~cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(CheckPackages.size()*1);
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      CheckPackages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CheckPackages[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CheckPackages.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CheckPackages.size(); ++u32Idx)
         (tVoid) (oOut << CheckPackages[u32Idx]);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart::operator==(const cmb_voicefi_tclMsgSpeechDataCRCCheckMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CheckPackages.size() == roRef.CheckPackages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CheckPackages.size()); ++u32Idx)
            bResult = bResult && (CheckPackages[u32Idx] == roRef.CheckPackages[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult::cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATACRCCHECKMETHODRESULT;
}


cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult::~cmb_voicefi_tclMsgSpeechDataCRCCheckMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgPrepareTTSMethodStart::cmb_voicefi_tclMsgPrepareTTSMethodStart(const cmb_voicefi_tclMsgPrepareTTSMethodStart& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   Expiry = coRef.Expiry;
   HasDict = coRef.HasDict;
}
cmb_voicefi_tclMsgPrepareTTSMethodStart& cmb_voicefi_tclMsgPrepareTTSMethodStart::operator=(const cmb_voicefi_tclMsgPrepareTTSMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   Expiry = coRef.Expiry;
   HasDict = coRef.HasDict;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgPrepareTTSMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

cmb_voicefi_tclMsgPrepareTTSMethodStart::cmb_voicefi_tclMsgPrepareTTSMethodStart()
:TextAndTags()
,Expiry(0)
,HasDict(0)
 {}

tS32 cmb_voicefi_tclMsgPrepareTTSMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_PREPARETTSMETHODSTART;
}


cmb_voicefi_tclMsgPrepareTTSMethodStart::~cmb_voicefi_tclMsgPrepareTTSMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgPrepareTTSMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_voicefi_tclMsgPrepareTTSMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> Expiry);
   (tVoid) (oIn >> HasDict);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgPrepareTTSMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << Expiry);
   (tVoid) (oOut << HasDict);
   return oOut;
}

tBool cmb_voicefi_tclMsgPrepareTTSMethodStart::operator==(const cmb_voicefi_tclMsgPrepareTTSMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (Expiry == roRef.Expiry);
   bResult = bResult && (HasDict == roRef.HasDict);
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgPrepareTTSMethodResult::cmb_voicefi_tclMsgPrepareTTSMethodResult()
 {}

tS32 cmb_voicefi_tclMsgPrepareTTSMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_PREPARETTSMETHODRESULT;
}


cmb_voicefi_tclMsgPrepareTTSMethodResult::~cmb_voicefi_tclMsgPrepareTTSMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeakSentenceMethodStart::cmb_voicefi_tclMsgSpeakSentenceMethodStart(const cmb_voicefi_tclMsgSpeakSentenceMethodStart& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   Sentence = coRef.Sentence;
}
cmb_voicefi_tclMsgSpeakSentenceMethodStart& cmb_voicefi_tclMsgSpeakSentenceMethodStart::operator=(const cmb_voicefi_tclMsgSpeakSentenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Sentence = coRef.Sentence;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeakSentenceMethodStart::vDestroy()
{
   Sentence.vDestroy(); 
}

cmb_voicefi_tclMsgSpeakSentenceMethodStart::cmb_voicefi_tclMsgSpeakSentenceMethodStart()
:Sentence()
 {}

tS32 cmb_voicefi_tclMsgSpeakSentenceMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART;
}


cmb_voicefi_tclMsgSpeakSentenceMethodStart::~cmb_voicefi_tclMsgSpeakSentenceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeakSentenceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Sentence.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_voicefi_tclMsgSpeakSentenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Sentence);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeakSentenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Sentence);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeakSentenceMethodStart::operator==(const cmb_voicefi_tclMsgSpeakSentenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Sentence == roRef.Sentence);
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeakSentenceMethodResult::cmb_voicefi_tclMsgSpeakSentenceMethodResult()
 {}

tS32 cmb_voicefi_tclMsgSpeakSentenceMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT;
}


cmb_voicefi_tclMsgSpeakSentenceMethodResult::~cmb_voicefi_tclMsgSpeakSentenceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart(const cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   Category = coRef.Category;
   Sentence = coRef.Sentence;
   Timeout = coRef.Timeout;
   RequestAddInfo = coRef.RequestAddInfo;
}
cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart& cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::operator=(const cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Category = coRef.Category;
   Sentence = coRef.Sentence;
   Timeout = coRef.Timeout;
   RequestAddInfo = coRef.RequestAddInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::vDestroy()
{
   Sentence.vDestroy(); 
}

cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart()
:Category()
,Sentence()
,Timeout(0)
,RequestAddInfo()
 {}

tS32 cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEAKCATEGORIZEDSENTENCEMETHODSTART;
}


cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::~cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+Sentence.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Category);
   (tVoid) (oIn >> Sentence);
   (tVoid) (oIn >> Timeout);
   (tVoid) (oIn >> RequestAddInfo);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Category);
   (tVoid) (oOut << Sentence);
   (tVoid) (oOut << Timeout);
   (tVoid) (oOut << RequestAddInfo);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart::operator==(const cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Category == roRef.Category);
   bResult = bResult && (Sentence == roRef.Sentence);
   bResult = bResult && (Timeout == roRef.Timeout);
   bResult = bResult && (RequestAddInfo == roRef.RequestAddInfo);
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult::cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult()
 {}

tS32 cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEAKCATEGORIZEDSENTENCEMETHODRESULT;
}


cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult::~cmb_voicefi_tclMsgSpeakCategorizedSentenceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SpeechSequence = coRef.SpeechSequence;
   SentenceList = coRef.SentenceList;
}
cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart& cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::operator=(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SpeechSequence = coRef.SpeechSequence;
   SentenceList = coRef.SentenceList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SentenceList.size(); ++u32Idx)
         SentenceList[u32Idx].vDestroy();
   SentenceList.clear();
   }
}

cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart()
:SpeechSequence()

 {}

tS32 cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCESELECTMETHODSTART;
}


cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::~cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SentenceList.size(); ++u32ListIdx)
      u32DynamicSize += SentenceList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeechSequence);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SentenceList.size(); ++u32Idx)
      {
         SentenceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SentenceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SentenceList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeechSequence);
   (tVoid) (oOut << (tU32)SentenceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SentenceList.size(); ++u32Idx)
         (tVoid) (oOut << SentenceList[u32Idx]);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart::operator==(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeechSequence == roRef.SpeechSequence);
      bResult = bResult && (SentenceList.size() == roRef.SentenceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SentenceList.size()); ++u32Idx)
            bResult = bResult && (SentenceList[u32Idx] == roRef.SentenceList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   Index = coRef.Index;
}
cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult& cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::operator=(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Index = coRef.Index;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult()
:Index(0)
 {}

tS32 cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCESELECTMETHODRESULT;
}


cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::~cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult()
{}

tU32 cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Index);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Index);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult::operator==(const cmb_voicefi_tclMsgSpeakSentenceSelectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Index == roRef.Index);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeakStopMethodStart::cmb_voicefi_tclMsgSpeakStopMethodStart(const cmb_voicefi_tclMsgSpeakStopMethodStart& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   e8StopVOPriority = coRef.e8StopVOPriority;
}
cmb_voicefi_tclMsgSpeakStopMethodStart& cmb_voicefi_tclMsgSpeakStopMethodStart::operator=(const cmb_voicefi_tclMsgSpeakStopMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8StopVOPriority = coRef.e8StopVOPriority;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeakStopMethodStart::cmb_voicefi_tclMsgSpeakStopMethodStart()
:e8StopVOPriority()
 {}

tS32 cmb_voicefi_tclMsgSpeakStopMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEAKSTOPMETHODSTART;
}


cmb_voicefi_tclMsgSpeakStopMethodStart::~cmb_voicefi_tclMsgSpeakStopMethodStart()
{}

tU32 cmb_voicefi_tclMsgSpeakStopMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeakStopMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8StopVOPriority);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeakStopMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8StopVOPriority);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeakStopMethodStart::operator==(const cmb_voicefi_tclMsgSpeakStopMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8StopVOPriority == roRef.e8StopVOPriority);
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeakStopMethodResult::cmb_voicefi_tclMsgSpeakStopMethodResult()
 {}

tS32 cmb_voicefi_tclMsgSpeakStopMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEAKSTOPMETHODRESULT;
}


cmb_voicefi_tclMsgSpeakStopMethodResult::~cmb_voicefi_tclMsgSpeakStopMethodResult()
{}

//=============================================================================

cmb_voicefi_tclMsgSpeechDownloadStatusGet::cmb_voicefi_tclMsgSpeechDownloadStatusGet()
 {}

tS32 cmb_voicefi_tclMsgSpeechDownloadStatusGet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSGET;
}


cmb_voicefi_tclMsgSpeechDownloadStatusGet::~cmb_voicefi_tclMsgSpeechDownloadStatusGet()
{}

//=============================================================================

cmb_voicefi_tclMsgSpeechDownloadStatusUpReg::cmb_voicefi_tclMsgSpeechDownloadStatusUpReg()
 {}

tS32 cmb_voicefi_tclMsgSpeechDownloadStatusUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSUPREG;
}


cmb_voicefi_tclMsgSpeechDownloadStatusUpReg::~cmb_voicefi_tclMsgSpeechDownloadStatusUpReg()
{}

//=============================================================================

cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg::cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg()
 {}

tS32 cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSRELUPREG;
}


cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg::~cmb_voicefi_tclMsgSpeechDownloadStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDownloadStatusStatus::cmb_voicefi_tclMsgSpeechDownloadStatusStatus(const cmb_voicefi_tclMsgSpeechDownloadStatusStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   AvailablePackage = coRef.AvailablePackage;
}
cmb_voicefi_tclMsgSpeechDownloadStatusStatus& cmb_voicefi_tclMsgSpeechDownloadStatusStatus::operator=(const cmb_voicefi_tclMsgSpeechDownloadStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailablePackage = coRef.AvailablePackage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeechDownloadStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailablePackage.size(); ++u32Idx)
         AvailablePackage[u32Idx].vDestroy();
   AvailablePackage.clear();
   }
}

cmb_voicefi_tclMsgSpeechDownloadStatusStatus::cmb_voicefi_tclMsgSpeechDownloadStatusStatus()

 {}

tS32 cmb_voicefi_tclMsgSpeechDownloadStatusStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSSTATUS;
}


cmb_voicefi_tclMsgSpeechDownloadStatusStatus::~cmb_voicefi_tclMsgSpeechDownloadStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeechDownloadStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(AvailablePackage.size()*2);
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDownloadStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailablePackage.size(); ++u32Idx)
      {
         AvailablePackage[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailablePackage.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailablePackage[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDownloadStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailablePackage.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailablePackage.size(); ++u32Idx)
         (tVoid) (oOut << AvailablePackage[u32Idx]);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDownloadStatusStatus::operator==(const cmb_voicefi_tclMsgSpeechDownloadStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailablePackage.size() == roRef.AvailablePackage.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailablePackage.size()); ++u32Idx)
            bResult = bResult && (AvailablePackage[u32Idx] == roRef.AvailablePackage[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeechDataIntegrityGet::cmb_voicefi_tclMsgSpeechDataIntegrityGet()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataIntegrityGet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYGET;
}


cmb_voicefi_tclMsgSpeechDataIntegrityGet::~cmb_voicefi_tclMsgSpeechDataIntegrityGet()
{}

//=============================================================================

cmb_voicefi_tclMsgSpeechDataIntegrityUpReg::cmb_voicefi_tclMsgSpeechDataIntegrityUpReg()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataIntegrityUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYUPREG;
}


cmb_voicefi_tclMsgSpeechDataIntegrityUpReg::~cmb_voicefi_tclMsgSpeechDataIntegrityUpReg()
{}

//=============================================================================

cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg::cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYRELUPREG;
}


cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg::~cmb_voicefi_tclMsgSpeechDataIntegrityRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataIntegrityStatus::cmb_voicefi_tclMsgSpeechDataIntegrityStatus(const cmb_voicefi_tclMsgSpeechDataIntegrityStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_Damage = coRef.SD_Damage;
   SD_DamagedPackages = coRef.SD_DamagedPackages;
}
cmb_voicefi_tclMsgSpeechDataIntegrityStatus& cmb_voicefi_tclMsgSpeechDataIntegrityStatus::operator=(const cmb_voicefi_tclMsgSpeechDataIntegrityStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_Damage = coRef.SD_Damage;
   SD_DamagedPackages = coRef.SD_DamagedPackages;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeechDataIntegrityStatus::vDestroy()
{
   {
   SD_DamagedPackages.clear();
   }
}

cmb_voicefi_tclMsgSpeechDataIntegrityStatus::cmb_voicefi_tclMsgSpeechDataIntegrityStatus()
:SD_Damage()

 {}

tS32 cmb_voicefi_tclMsgSpeechDataIntegrityStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYSTATUS;
}


cmb_voicefi_tclMsgSpeechDataIntegrityStatus::~cmb_voicefi_tclMsgSpeechDataIntegrityStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeechDataIntegrityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(SD_DamagedPackages.size()*1);
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataIntegrityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_Damage);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      SD_DamagedPackages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SD_DamagedPackages[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataIntegrityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_Damage);
   (tVoid) (oOut << (tU32)SD_DamagedPackages.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SD_DamagedPackages.size(); ++u32Idx)
         (tVoid) (oOut << SD_DamagedPackages[u32Idx]);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataIntegrityStatus::operator==(const cmb_voicefi_tclMsgSpeechDataIntegrityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_Damage == roRef.SD_Damage);
      bResult = bResult && (SD_DamagedPackages.size() == roRef.SD_DamagedPackages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SD_DamagedPackages.size()); ++u32Idx)
            bResult = bResult && (SD_DamagedPackages[u32Idx] == roRef.SD_DamagedPackages[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeechDataMemoryGet::cmb_voicefi_tclMsgSpeechDataMemoryGet()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataMemoryGet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAMEMORYGET;
}


cmb_voicefi_tclMsgSpeechDataMemoryGet::~cmb_voicefi_tclMsgSpeechDataMemoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataMemoryStatus::cmb_voicefi_tclMsgSpeechDataMemoryStatus(const cmb_voicefi_tclMsgSpeechDataMemoryStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_MB_Size = coRef.SD_MB_Size;
   SD_KB_Size = coRef.SD_KB_Size;
}
cmb_voicefi_tclMsgSpeechDataMemoryStatus& cmb_voicefi_tclMsgSpeechDataMemoryStatus::operator=(const cmb_voicefi_tclMsgSpeechDataMemoryStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_MB_Size = coRef.SD_MB_Size;
   SD_KB_Size = coRef.SD_KB_Size;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeechDataMemoryStatus::cmb_voicefi_tclMsgSpeechDataMemoryStatus()
:SD_MB_Size(0)
,SD_KB_Size(0)
 {}

tS32 cmb_voicefi_tclMsgSpeechDataMemoryStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAMEMORYSTATUS;
}


cmb_voicefi_tclMsgSpeechDataMemoryStatus::~cmb_voicefi_tclMsgSpeechDataMemoryStatus()
{}

tU32 cmb_voicefi_tclMsgSpeechDataMemoryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 3)
   {
      u32DynamicSize += 1;
   }
   if (4 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+0;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataMemoryStatus::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 3)
   {
      (tVoid) (oIn >> SD_MB_Size);
   }
   if (4 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> SD_KB_Size);
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataMemoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 3)
   {
      (tVoid) (oOut << SD_MB_Size);
   }
   if (4 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << SD_KB_Size);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataMemoryStatus::operator==(const cmb_voicefi_tclMsgSpeechDataMemoryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_MB_Size == roRef.SD_MB_Size);
   bResult = bResult && (SD_KB_Size == roRef.SD_KB_Size);
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeechDataFormatGet::cmb_voicefi_tclMsgSpeechDataFormatGet()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataFormatGet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAFORMATGET;
}


cmb_voicefi_tclMsgSpeechDataFormatGet::~cmb_voicefi_tclMsgSpeechDataFormatGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataFormatStatus::cmb_voicefi_tclMsgSpeechDataFormatStatus(const cmb_voicefi_tclMsgSpeechDataFormatStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_Format = coRef.SD_Format;
}
cmb_voicefi_tclMsgSpeechDataFormatStatus& cmb_voicefi_tclMsgSpeechDataFormatStatus::operator=(const cmb_voicefi_tclMsgSpeechDataFormatStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_Format = coRef.SD_Format;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgSpeechDataFormatStatus::vDestroy()
{
   {
   SD_Format.clear();
   }
}

cmb_voicefi_tclMsgSpeechDataFormatStatus::cmb_voicefi_tclMsgSpeechDataFormatStatus()

 {}

tS32 cmb_voicefi_tclMsgSpeechDataFormatStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAFORMATSTATUS;
}


cmb_voicefi_tclMsgSpeechDataFormatStatus::~cmb_voicefi_tclMsgSpeechDataFormatStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgSpeechDataFormatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SD_Format.size()*1);
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataFormatStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      SD_Format.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SD_Format[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataFormatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SD_Format.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SD_Format.size(); ++u32Idx)
         (tVoid) (oOut << SD_Format[u32Idx]);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataFormatStatus::operator==(const cmb_voicefi_tclMsgSpeechDataFormatStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SD_Format.size() == roRef.SD_Format.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SD_Format.size()); ++u32Idx)
            bResult = bResult && (SD_Format[u32Idx] == roRef.SD_Format[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgSpeechDataCustomerGet::cmb_voicefi_tclMsgSpeechDataCustomerGet()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataCustomerGet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATACUSTOMERGET;
}


cmb_voicefi_tclMsgSpeechDataCustomerGet::~cmb_voicefi_tclMsgSpeechDataCustomerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataCustomerStatus::cmb_voicefi_tclMsgSpeechDataCustomerStatus(const cmb_voicefi_tclMsgSpeechDataCustomerStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_CustomerID = coRef.SD_CustomerID;
   SD_PlatformID = coRef.SD_PlatformID;
}
cmb_voicefi_tclMsgSpeechDataCustomerStatus& cmb_voicefi_tclMsgSpeechDataCustomerStatus::operator=(const cmb_voicefi_tclMsgSpeechDataCustomerStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_CustomerID = coRef.SD_CustomerID;
   SD_PlatformID = coRef.SD_PlatformID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeechDataCustomerStatus::cmb_voicefi_tclMsgSpeechDataCustomerStatus()
:SD_CustomerID(0)
,SD_PlatformID(0)
 {}

tS32 cmb_voicefi_tclMsgSpeechDataCustomerStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATACUSTOMERSTATUS;
}


cmb_voicefi_tclMsgSpeechDataCustomerStatus::~cmb_voicefi_tclMsgSpeechDataCustomerStatus()
{}

tU32 cmb_voicefi_tclMsgSpeechDataCustomerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataCustomerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_CustomerID);
   (tVoid) (oIn >> SD_PlatformID);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataCustomerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_CustomerID);
   (tVoid) (oOut << SD_PlatformID);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataCustomerStatus::operator==(const cmb_voicefi_tclMsgSpeechDataCustomerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_CustomerID == roRef.SD_CustomerID);
   bResult = bResult && (SD_PlatformID == roRef.SD_PlatformID);
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgTTSPhraseInfoGet::cmb_voicefi_tclMsgTTSPhraseInfoGet()
 {}

tS32 cmb_voicefi_tclMsgTTSPhraseInfoGet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOGET;
}


cmb_voicefi_tclMsgTTSPhraseInfoGet::~cmb_voicefi_tclMsgTTSPhraseInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgTTSPhraseInfoSet::cmb_voicefi_tclMsgTTSPhraseInfoSet(const cmb_voicefi_tclMsgTTSPhraseInfoSet& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   PhrasesToKeep_v3 = coRef.PhrasesToKeep_v3;
   PhrasesToKeep = coRef.PhrasesToKeep;
}
cmb_voicefi_tclMsgTTSPhraseInfoSet& cmb_voicefi_tclMsgTTSPhraseInfoSet::operator=(const cmb_voicefi_tclMsgTTSPhraseInfoSet& coRef)
{
   if (this == &coRef) return *this;
   PhrasesToKeep_v3 = coRef.PhrasesToKeep_v3;
   PhrasesToKeep = coRef.PhrasesToKeep;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgTTSPhraseInfoSet::vDestroy()
{
   {
   PhrasesToKeep_v3.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < PhrasesToKeep.size(); ++u32Idx)
         PhrasesToKeep[u32Idx].vDestroy();
   PhrasesToKeep.clear();
   }
}

cmb_voicefi_tclMsgTTSPhraseInfoSet::cmb_voicefi_tclMsgTTSPhraseInfoSet()


 {}

tS32 cmb_voicefi_tclMsgTTSPhraseInfoSet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOSET;
}


cmb_voicefi_tclMsgTTSPhraseInfoSet::~cmb_voicefi_tclMsgTTSPhraseInfoSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgTTSPhraseInfoSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 3)
   {
      u32DynamicSize += 4;
      u32DynamicSize += static_cast<tU32>(PhrasesToKeep_v3.size()*2);
   }
   if (4 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += static_cast<tU32>(PhrasesToKeep.size()*3);
   }
   return u32DynamicSize+0;
}

fi_tclInContext& cmb_voicefi_tclMsgTTSPhraseInfoSet::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 3)
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         (tVoid) (oIn >> u32Length);
         PhrasesToKeep_v3.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            (tVoid) (oIn >> PhrasesToKeep_v3[u32Idx]);
         }
      }
   }
   if (4 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < PhrasesToKeep.size(); ++u32Idx)
         {
            PhrasesToKeep[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         (tVoid) (oIn >> u32Length);
         PhrasesToKeep.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            (tVoid) (oIn >> PhrasesToKeep[u32Idx]);
         }
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgTTSPhraseInfoSet::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 3)
   {
      (tVoid) (oOut << (tU32)PhrasesToKeep_v3.size());
      {
         for (tU32 u32Idx = 0; u32Idx < PhrasesToKeep_v3.size(); ++u32Idx)
            (tVoid) (oOut << PhrasesToKeep_v3[u32Idx]);
      }
   }
   if (4 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << (tU32)PhrasesToKeep.size());
      {
         for (tU32 u32Idx = 0; u32Idx < PhrasesToKeep.size(); ++u32Idx)
            (tVoid) (oOut << PhrasesToKeep[u32Idx]);
      }
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgTTSPhraseInfoSet::operator==(const cmb_voicefi_tclMsgTTSPhraseInfoSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PhrasesToKeep_v3.size() == roRef.PhrasesToKeep_v3.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhrasesToKeep_v3.size()); ++u32Idx)
            bResult = bResult && (PhrasesToKeep_v3[u32Idx] == roRef.PhrasesToKeep_v3[u32Idx]);
      }
      bResult = bResult && (PhrasesToKeep.size() == roRef.PhrasesToKeep.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhrasesToKeep.size()); ++u32Idx)
            bResult = bResult && (PhrasesToKeep[u32Idx] == roRef.PhrasesToKeep[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgTTSPhraseInfoUpReg::cmb_voicefi_tclMsgTTSPhraseInfoUpReg()
 {}

tS32 cmb_voicefi_tclMsgTTSPhraseInfoUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOUPREG;
}


cmb_voicefi_tclMsgTTSPhraseInfoUpReg::~cmb_voicefi_tclMsgTTSPhraseInfoUpReg()
{}

//=============================================================================

cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg::cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg()
 {}

tS32 cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFORELUPREG;
}


cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg::~cmb_voicefi_tclMsgTTSPhraseInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgTTSPhraseInfoStatus::cmb_voicefi_tclMsgTTSPhraseInfoStatus(const cmb_voicefi_tclMsgTTSPhraseInfoStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   Phrases = coRef.Phrases;
}
cmb_voicefi_tclMsgTTSPhraseInfoStatus& cmb_voicefi_tclMsgTTSPhraseInfoStatus::operator=(const cmb_voicefi_tclMsgTTSPhraseInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   Phrases = coRef.Phrases;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgTTSPhraseInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
         Phrases[u32Idx].vDestroy();
   Phrases.clear();
   }
}

cmb_voicefi_tclMsgTTSPhraseInfoStatus::cmb_voicefi_tclMsgTTSPhraseInfoStatus()

 {}

tS32 cmb_voicefi_tclMsgTTSPhraseInfoStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOSTATUS;
}


cmb_voicefi_tclMsgTTSPhraseInfoStatus::~cmb_voicefi_tclMsgTTSPhraseInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgTTSPhraseInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Phrases.size(); ++u32ListIdx)
      u32DynamicSize += Phrases[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& cmb_voicefi_tclMsgTTSPhraseInfoStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
      {
         Phrases[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Phrases.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Phrases[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgTTSPhraseInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Phrases.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
         (tVoid) (oOut << Phrases[u32Idx]);
   }
   return oOut;
}

tBool cmb_voicefi_tclMsgTTSPhraseInfoStatus::operator==(const cmb_voicefi_tclMsgTTSPhraseInfoStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Phrases.size() == roRef.Phrases.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Phrases.size()); ++u32Idx)
            bResult = bResult && (Phrases[u32Idx] == roRef.Phrases[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgTTSPhraseMemoryGet::cmb_voicefi_tclMsgTTSPhraseMemoryGet()
 {}

tS32 cmb_voicefi_tclMsgTTSPhraseMemoryGet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYGET;
}


cmb_voicefi_tclMsgTTSPhraseMemoryGet::~cmb_voicefi_tclMsgTTSPhraseMemoryGet()
{}

//=============================================================================

cmb_voicefi_tclMsgTTSPhraseMemoryUpReg::cmb_voicefi_tclMsgTTSPhraseMemoryUpReg()
 {}

tS32 cmb_voicefi_tclMsgTTSPhraseMemoryUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYUPREG;
}


cmb_voicefi_tclMsgTTSPhraseMemoryUpReg::~cmb_voicefi_tclMsgTTSPhraseMemoryUpReg()
{}

//=============================================================================

cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg::cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg()
 {}

tS32 cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYRELUPREG;
}


cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg::~cmb_voicefi_tclMsgTTSPhraseMemoryRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgTTSPhraseMemoryStatus::cmb_voicefi_tclMsgTTSPhraseMemoryStatus(const cmb_voicefi_tclMsgTTSPhraseMemoryStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   Total = coRef.Total;
   Missing = coRef.Missing;
}
cmb_voicefi_tclMsgTTSPhraseMemoryStatus& cmb_voicefi_tclMsgTTSPhraseMemoryStatus::operator=(const cmb_voicefi_tclMsgTTSPhraseMemoryStatus& coRef)
{
   if (this == &coRef) return *this;
   Total = coRef.Total;
   Missing = coRef.Missing;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgTTSPhraseMemoryStatus::cmb_voicefi_tclMsgTTSPhraseMemoryStatus()
:Total(0)
,Missing(0)
 {}

tS32 cmb_voicefi_tclMsgTTSPhraseMemoryStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYSTATUS;
}


cmb_voicefi_tclMsgTTSPhraseMemoryStatus::~cmb_voicefi_tclMsgTTSPhraseMemoryStatus()
{}

tU32 cmb_voicefi_tclMsgTTSPhraseMemoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_voicefi_tclMsgTTSPhraseMemoryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Total);
   (tVoid) (oIn >> Missing);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgTTSPhraseMemoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Total);
   (tVoid) (oOut << Missing);
   return oOut;
}

tBool cmb_voicefi_tclMsgTTSPhraseMemoryStatus::operator==(const cmb_voicefi_tclMsgTTSPhraseMemoryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Total == roRef.Total);
   bResult = bResult && (Missing == roRef.Missing);
   return bResult;
}

//=============================================================================

cmb_voicefi_tclMsgTTSVoiceGet::cmb_voicefi_tclMsgTTSVoiceGet()
 {}

tS32 cmb_voicefi_tclMsgTTSVoiceGet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSVOICEGET;
}


cmb_voicefi_tclMsgTTSVoiceGet::~cmb_voicefi_tclMsgTTSVoiceGet()
{}

//=============================================================================

cmb_voicefi_tclMsgTTSVoiceUpReg::cmb_voicefi_tclMsgTTSVoiceUpReg()
 {}

tS32 cmb_voicefi_tclMsgTTSVoiceUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSVOICEUPREG;
}


cmb_voicefi_tclMsgTTSVoiceUpReg::~cmb_voicefi_tclMsgTTSVoiceUpReg()
{}

//=============================================================================

cmb_voicefi_tclMsgTTSVoiceRelUpReg::cmb_voicefi_tclMsgTTSVoiceRelUpReg()
 {}

tS32 cmb_voicefi_tclMsgTTSVoiceRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSVOICERELUPREG;
}


cmb_voicefi_tclMsgTTSVoiceRelUpReg::~cmb_voicefi_tclMsgTTSVoiceRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgTTSVoiceStatus::cmb_voicefi_tclMsgTTSVoiceStatus(const cmb_voicefi_tclMsgTTSVoiceStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   LanguageCode = coRef.LanguageCode;
   CountryCode = coRef.CountryCode;
   Name = coRef.Name;
   Gender = coRef.Gender;
}
cmb_voicefi_tclMsgTTSVoiceStatus& cmb_voicefi_tclMsgTTSVoiceStatus::operator=(const cmb_voicefi_tclMsgTTSVoiceStatus& coRef)
{
   if (this == &coRef) return *this;
   LanguageCode = coRef.LanguageCode;
   CountryCode = coRef.CountryCode;
   Name = coRef.Name;
   Gender = coRef.Gender;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_voicefi_tclMsgTTSVoiceStatus::vDestroy()
{
   {
   Name.clear();
   }
}

cmb_voicefi_tclMsgTTSVoiceStatus::cmb_voicefi_tclMsgTTSVoiceStatus()
:LanguageCode(0)
,CountryCode(0)

,Gender(0)
 {}

tS32 cmb_voicefi_tclMsgTTSVoiceStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_TTSVOICESTATUS;
}


cmb_voicefi_tclMsgTTSVoiceStatus::~cmb_voicefi_tclMsgTTSVoiceStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_voicefi_tclMsgTTSVoiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+ static_cast<tU32>(Name.size()*1);
}

fi_tclInContext& cmb_voicefi_tclMsgTTSVoiceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageCode);
   (tVoid) (oIn >> CountryCode);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Name.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Name[u32Idx]);
      }
   }
   (tVoid) (oIn >> Gender);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgTTSVoiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageCode);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << (tU32)Name.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Name.size(); ++u32Idx)
         (tVoid) (oOut << Name[u32Idx]);
   }
   (tVoid) (oOut << Gender);
   return oOut;
}

tBool cmb_voicefi_tclMsgTTSVoiceStatus::operator==(const cmb_voicefi_tclMsgTTSVoiceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageCode == roRef.LanguageCode);
   bResult = bResult && (CountryCode == roRef.CountryCode);
      bResult = bResult && (Name.size() == roRef.Name.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Name.size()); ++u32Idx)
            bResult = bResult && (Name[u32Idx] == roRef.Name[u32Idx]);
      }
   bResult = bResult && (Gender == roRef.Gender);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataSettingsSet::cmb_voicefi_tclMsgSpeechDataSettingsSet(const cmb_voicefi_tclMsgSpeechDataSettingsSet& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_Settings = coRef.SD_Settings;
}
cmb_voicefi_tclMsgSpeechDataSettingsSet& cmb_voicefi_tclMsgSpeechDataSettingsSet::operator=(const cmb_voicefi_tclMsgSpeechDataSettingsSet& coRef)
{
   if (this == &coRef) return *this;
   SD_Settings = coRef.SD_Settings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeechDataSettingsSet::cmb_voicefi_tclMsgSpeechDataSettingsSet()
:SD_Settings()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataSettingsSet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATASETTINGSSET;
}


cmb_voicefi_tclMsgSpeechDataSettingsSet::~cmb_voicefi_tclMsgSpeechDataSettingsSet()
{}

tU32 cmb_voicefi_tclMsgSpeechDataSettingsSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataSettingsSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_Settings);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataSettingsSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_Settings);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataSettingsSet::operator==(const cmb_voicefi_tclMsgSpeechDataSettingsSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_Settings == roRef.SD_Settings);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataSettingsStatus::cmb_voicefi_tclMsgSpeechDataSettingsStatus(const cmb_voicefi_tclMsgSpeechDataSettingsStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_Settings = coRef.SD_Settings;
}
cmb_voicefi_tclMsgSpeechDataSettingsStatus& cmb_voicefi_tclMsgSpeechDataSettingsStatus::operator=(const cmb_voicefi_tclMsgSpeechDataSettingsStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_Settings = coRef.SD_Settings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeechDataSettingsStatus::cmb_voicefi_tclMsgSpeechDataSettingsStatus()
:SD_Settings()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataSettingsStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATASETTINGSSTATUS;
}


cmb_voicefi_tclMsgSpeechDataSettingsStatus::~cmb_voicefi_tclMsgSpeechDataSettingsStatus()
{}

tU32 cmb_voicefi_tclMsgSpeechDataSettingsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataSettingsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_Settings);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataSettingsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_Settings);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataSettingsStatus::operator==(const cmb_voicefi_tclMsgSpeechDataSettingsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_Settings == roRef.SD_Settings);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataReferenceSet::cmb_voicefi_tclMsgSpeechDataReferenceSet(const cmb_voicefi_tclMsgSpeechDataReferenceSet& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   SD_Reference = coRef.SD_Reference;
}
cmb_voicefi_tclMsgSpeechDataReferenceSet& cmb_voicefi_tclMsgSpeechDataReferenceSet::operator=(const cmb_voicefi_tclMsgSpeechDataReferenceSet& coRef)
{
   if (this == &coRef) return *this;
   SD_Reference = coRef.SD_Reference;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeechDataReferenceSet::cmb_voicefi_tclMsgSpeechDataReferenceSet()
:SD_Reference()
 {}

tS32 cmb_voicefi_tclMsgSpeechDataReferenceSet::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAREFERENCESET;
}


cmb_voicefi_tclMsgSpeechDataReferenceSet::~cmb_voicefi_tclMsgSpeechDataReferenceSet()
{}

tU32 cmb_voicefi_tclMsgSpeechDataReferenceSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataReferenceSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_Reference);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataReferenceSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_Reference);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataReferenceSet::operator==(const cmb_voicefi_tclMsgSpeechDataReferenceSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_Reference == roRef.SD_Reference);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_voicefi_tclMsgSpeechDataReferenceStatus::cmb_voicefi_tclMsgSpeechDataReferenceStatus(const cmb_voicefi_tclMsgSpeechDataReferenceStatus& coRef)
   : cmb_voicefi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
cmb_voicefi_tclMsgSpeechDataReferenceStatus& cmb_voicefi_tclMsgSpeechDataReferenceStatus::operator=(const cmb_voicefi_tclMsgSpeechDataReferenceStatus& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_voicefi_tclMsgSpeechDataReferenceStatus::cmb_voicefi_tclMsgSpeechDataReferenceStatus()
:bSuccess(0)
 {}

tS32 cmb_voicefi_tclMsgSpeechDataReferenceStatus::s32GetTypeId() const
{
   return (tS32) cmb_voicefi_tclToken::EN_MSG_SPEECHDATAREFERENCESTATUS;
}


cmb_voicefi_tclMsgSpeechDataReferenceStatus::~cmb_voicefi_tclMsgSpeechDataReferenceStatus()
{}

tU32 cmb_voicefi_tclMsgSpeechDataReferenceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_voicefi_tclMsgSpeechDataReferenceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& cmb_voicefi_tclMsgSpeechDataReferenceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool cmb_voicefi_tclMsgSpeechDataReferenceStatus::operator==(const cmb_voicefi_tclMsgSpeechDataReferenceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

