/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_FUNCTIONIDS
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_SERVICEINFO
#include "cmb_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for CMB_Sensor_FI message types

fi_tclMessageBase* cmb_sensorfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case cmb_sensorfi_tclToken::EN_MSG_CALCODOMETERCALIBRATIONMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_CALCODOMETERCALIBRATIONMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_SETDEFAULTGYROPARAMETERFORGYROTYPEMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_SETDEFAULTGYROPARAMETERFORGYROTYPEMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTESTMODEMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTestmodeMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTESTMODEMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTestmodeMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_GYROSELFTESTMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroSelftestMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_GYROSELFTESTMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroSelftestMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgSavePersistentMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgSavePersistentMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_GPSSETHINTSMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsSetHintsMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_GPSSETHINTSMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsSetHintsMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_GPSSETEXTHINTSMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_GPSSETEXTHINTSMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDTESTMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDTESTMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgUpdateDiagLogMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgUpdateDiagLogMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_GPSEXTTESTMODEMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_GPSEXTTESTMODEMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgFactorySettingsMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgFactorySettingsMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_DEACTIVATEGPSENCODERMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_DEACTIVATEGPSENCODERMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODSTART:
         return OSAL_NEW cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart;

      case cmb_sensorfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODRESULT:
         return OSAL_NEW cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_INITGET:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerData_InitGet;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_INITSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerData_InitStatus;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerData_UpdateGet;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerData_UpdateUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_UPDATERELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_UPDATESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerData_UpdateStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYRODATA_INITGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroData_InitGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYRODATA_INITSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroData_InitStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYRODATA_UPDATEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroData_UpdateGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYRODATA_UPDATEUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroData_UpdateUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYRODATA_UPDATERELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYRODATA_UPDATESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroData_UpdateStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDATAUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsDataUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDATARELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsDataRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDATA_VALIDCONTENTGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsData_ValidContentGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDATA_VALIDCONTENTSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsData_ValidContentStatus;

      case cmb_sensorfi_tclToken::EN_MSG_TYREWIDTHGET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreWidthGet;

      case cmb_sensorfi_tclToken::EN_MSG_TYREWIDTHSET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreWidthSet;

      case cmb_sensorfi_tclToken::EN_MSG_TYREWIDTHSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreWidthStatus;

      case cmb_sensorfi_tclToken::EN_MSG_TYREHEIGHTWIDTHRATIOGET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreHeightWidthRatioGet;

      case cmb_sensorfi_tclToken::EN_MSG_TYREHEIGHTWIDTHRATIOSET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreHeightWidthRatioSet;

      case cmb_sensorfi_tclToken::EN_MSG_TYREHEIGHTWIDTHRATIOSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus;

      case cmb_sensorfi_tclToken::EN_MSG_RIMDIAMETERGET:
         return OSAL_NEW cmb_sensorfi_tclMsgRimDiameterGet;

      case cmb_sensorfi_tclToken::EN_MSG_RIMDIAMETERSET:
         return OSAL_NEW cmb_sensorfi_tclMsgRimDiameterSet;

      case cmb_sensorfi_tclToken::EN_MSG_RIMDIAMETERSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgRimDiameterStatus;

      case cmb_sensorfi_tclToken::EN_MSG_TYRECONDITIONGET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreConditionGet;

      case cmb_sensorfi_tclToken::EN_MSG_TYRECONDITIONSET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreConditionSet;

      case cmb_sensorfi_tclToken::EN_MSG_TYRECONDITIONSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreConditionStatus;

      case cmb_sensorfi_tclToken::EN_MSG_TYRECIRCUMFERENCEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreCircumferenceGet;

      case cmb_sensorfi_tclToken::EN_MSG_TYRECIRCUMFERENCESET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreCircumferenceSet;

      case cmb_sensorfi_tclToken::EN_MSG_TYRECIRCUMFERENCESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreCircumferenceStatus;

      case cmb_sensorfi_tclToken::EN_MSG_PULSESPERTYRECIRCUMFERENCEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet;

      case cmb_sensorfi_tclToken::EN_MSG_PULSESPERTYRECIRCUMFERENCESET:
         return OSAL_NEW cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet;

      case cmb_sensorfi_tclToken::EN_MSG_PULSESPERTYRECIRCUMFERENCESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus;

      case cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgDistanceCalibrationValueGet;

      case cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUESET:
         return OSAL_NEW cmb_sensorfi_tclMsgDistanceCalibrationValueSet;

      case cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUEUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUERELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgDistanceCalibrationValueStatus;

      case cmb_sensorfi_tclToken::EN_MSG_TYREEXPANSIONVALUEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreExpansionValueGet;

      case cmb_sensorfi_tclToken::EN_MSG_TYREEXPANSIONVALUESET:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreExpansionValueSet;

      case cmb_sensorfi_tclToken::EN_MSG_TYREEXPANSIONVALUESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgTyreExpansionValueStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYROMANUFACTURERGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroManufacturerGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROMANUFACTURERSET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroManufacturerSet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROMANUFACTURERSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroManufacturerStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYROTYPEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroTypeGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROTYPESET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroTypeSet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROTYPESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroTypeStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroOffsetGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETSET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroOffsetSet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroOffsetUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroOffsetRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroOffsetStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroScalefactorGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORSET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroScalefactorSet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroScalefactorUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroScalefactorRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroScalefactorStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSCOMMUNICATIONPROTOCOLGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsCommunicationProtocolGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSCOMMUNICATIONPROTOCOLSET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsCommunicationProtocolSet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSCOMMUNICATIONPROTOCOLSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTEMPERATUREGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTemperatureGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTEMPERATUREUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTemperatureUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTEMPERATURERELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTemperatureRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTEMPERATURESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTemperatureStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFILTERMODEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFilterModeGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFILTERMODESET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFilterModeSet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFILTERMODESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFilterModeStatus;

      case cmb_sensorfi_tclToken::EN_MSG_XOCOMPENSATIONGET:
         return OSAL_NEW cmb_sensorfi_tclMsgXoCompensationGet;

      case cmb_sensorfi_tclToken::EN_MSG_XOCOMPENSATIONSET:
         return OSAL_NEW cmb_sensorfi_tclMsgXoCompensationSet;

      case cmb_sensorfi_tclToken::EN_MSG_XOCOMPENSATIONSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgXoCompensationStatus;

      case cmb_sensorfi_tclToken::EN_MSG_ANTENNACURRENTGET:
         return OSAL_NEW cmb_sensorfi_tclMsgAntennaCurrentGet;

      case cmb_sensorfi_tclToken::EN_MSG_ANTENNACURRENTUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgAntennaCurrentUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ANTENNACURRENTRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgAntennaCurrentRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ANTENNACURRENTSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgAntennaCurrentStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYROADCBITRANGEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroADCBitRangeGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROADCBITRANGESET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroADCBitRangeSet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROADCBITRANGESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroADCBitRangeStatus;

      case cmb_sensorfi_tclToken::EN_MSG_OSALTIMEEVENTGET:
         return OSAL_NEW cmb_sensorfi_tclMsgOsalTimeEventGet;

      case cmb_sensorfi_tclToken::EN_MSG_OSALTIMEEVENTUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgOsalTimeEventUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_OSALTIMEEVENTRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgOsalTimeEventRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_OSALTIMEEVENTSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgOsalTimeEventStatus;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerUsageGet;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGESET:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerUsageSet;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGEUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerUsageUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGERELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerUsageRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerUsageStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSEXTDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsExtDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSEXTDATAUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsExtDataUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSEXTDATARELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsExtDataRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSEXTDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsExtDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFrontEndGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFrontEndUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFrontEndRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsFrontEndStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSOSCILLATORGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsOscillatorGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSOSCILLATORUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsOscillatorUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSOSCILLATORRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsOscillatorRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSOSCILLATORSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsOscillatorStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYROERRORGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroErrorGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROERRORUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroErrorUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYROERRORRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroErrorRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYROERRORSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroErrorStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTESTADDITIONALDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTestAdditionalDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTESTADDITIONALDATAUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTESTADDITIONALDATARELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTESTADDITIONALDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTIGHTCOUPLINGDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTightCouplingDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTIGHTCOUPLINGDATAUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTIGHTCOUPLINGDATARELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSTIGHTCOUPLINGDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsTightCouplingDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_ABSDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgAbsDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_ABSDATAUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgAbsDataUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ABSDATARELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgAbsDataRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ABSDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgAbsDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_STEERINGDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgSteeringDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_STEERINGDATAUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgSteeringDataUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_STEERINGDATARELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgSteeringDataRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_STEERINGDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgSteeringDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERRANGEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerRangeGet;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERRANGESET:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerRangeSet;

      case cmb_sensorfi_tclToken::EN_MSG_ODOMETERRANGESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgOdometerRangeStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYRODIAGDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroDiagDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYRODIAGDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroDiagDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDIAGPOSITIONGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsDiagPositionGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDIAGPOSITIONSET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsDiagPositionSet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSDIAGPOSITIONSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsDiagPositionStatus;

      case cmb_sensorfi_tclToken::EN_MSG_DRIVEDIRECTIONGET:
         return OSAL_NEW cmb_sensorfi_tclMsgDriveDirectionGet;

      case cmb_sensorfi_tclToken::EN_MSG_DRIVEDIRECTIONUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgDriveDirectionUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_DRIVEDIRECTIONRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgDriveDirectionRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_DRIVEDIRECTIONSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgDriveDirectionStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GALASPEEDGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGalaSpeedGet;

      case cmb_sensorfi_tclToken::EN_MSG_GALASPEEDUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGalaSpeedUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GALASPEEDRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGalaSpeedRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GALASPEEDSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGalaSpeedStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GPSNOISELEVELTIMEPOSVALIDITYGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet;

      case cmb_sensorfi_tclToken::EN_MSG_GPSNOISELEVELTIMEPOSVALIDITYUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSNOISELEVELTIMEPOSVALIDITYRELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GPSNOISELEVELTIMEPOSVALIDITYSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYRO3DDIAGDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyro3dDiagDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYRO3DDIAGDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyro3dDiagDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_ACC3DDIAGDATAGET:
         return OSAL_NEW cmb_sensorfi_tclMsgAcc3dDiagDataGet;

      case cmb_sensorfi_tclToken::EN_MSG_ACC3DDIAGDATASTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgAcc3dDiagDataStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyro3dData_UpdateGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYRO3DDATA_UPDATERELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYRO3DDATA_UPDATESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyro3dData_UpdateStatus;

      case cmb_sensorfi_tclToken::EN_MSG_ACC3DDATA_UPDATEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgAcc3dData_UpdateGet;

      case cmb_sensorfi_tclToken::EN_MSG_ACC3DDATA_UPDATEUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ACC3DDATA_UPDATERELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_ACC3DDATA_UPDATESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgAcc3dData_UpdateStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GYROTEMPERATUREGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroTemperatureGet;

      case cmb_sensorfi_tclToken::EN_MSG_GYROTEMPERATUREUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroTemperatureUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYROTEMPERATURERELUPREG:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroTemperatureRelUpReg;

      case cmb_sensorfi_tclToken::EN_MSG_GYROTEMPERATURESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGyroTemperatureStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GNSSSATSYSTEMGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGnssSatSystemGet;

      case cmb_sensorfi_tclToken::EN_MSG_GNSSSATSYSTEMSET:
         return OSAL_NEW cmb_sensorfi_tclMsgGnssSatSystemSet;

      case cmb_sensorfi_tclToken::EN_MSG_GNSSSATSYSTEMSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGnssSatSystemStatus;

      case cmb_sensorfi_tclToken::EN_MSG_GNSSWNEPOCHGET:
         return OSAL_NEW cmb_sensorfi_tclMsgGnssWnEpochGet;

      case cmb_sensorfi_tclToken::EN_MSG_GNSSWNEPOCHSET:
         return OSAL_NEW cmb_sensorfi_tclMsgGnssWnEpochSet;

      case cmb_sensorfi_tclToken::EN_MSG_GNSSWNEPOCHSTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgGnssWnEpochStatus;

      case cmb_sensorfi_tclToken::EN_MSG_TIMEMODEGET:
         return OSAL_NEW cmb_sensorfi_tclMsgTimeModeGet;

      case cmb_sensorfi_tclToken::EN_MSG_TIMEMODESET:
         return OSAL_NEW cmb_sensorfi_tclMsgTimeModeSet;

      case cmb_sensorfi_tclToken::EN_MSG_TIMEMODESTATUS:
         return OSAL_NEW cmb_sensorfi_tclMsgTimeModeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all cmb_sensorfifi messages

// common functions

tU16 cmb_sensorfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return CMB_SENSORFI_C_U16_SERVICE_ID;
}

tU16 cmb_sensorfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 cmb_sensorfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& cmb_sensorfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& cmb_sensorfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 cmb_sensorfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& cmb_sensorfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& cmb_sensorfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart(const cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   UseTyreValue = coRef.UseTyreValue;
}
cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart& cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::operator=(const cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UseTyreValue = coRef.UseTyreValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart()
:UseTyreValue(0)
 {}

tS32 cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_CALCODOMETERCALIBRATIONMETHODSTART;
}


cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::~cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart()
{}

tU32 cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UseTyreValue);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UseTyreValue);
   return oOut;
}

tBool cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart::operator==(const cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UseTyreValue == roRef.UseTyreValue);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult::cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult()
 {}

tS32 cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_CALCODOMETERCALIBRATIONMETHODRESULT;
}


cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult::~cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult()
{}

//=============================================================================

cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart::cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart()
 {}

tS32 cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_SETDEFAULTGYROPARAMETERFORGYROTYPEMETHODSTART;
}


cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart::~cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult(const cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult& cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::operator=(const cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult()
:bSuccess(0)
 {}

tS32 cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_SETDEFAULTGYROPARAMETERFORGYROTYPEMETHODRESULT;
}


cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::~cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult()
{}

tU32 cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult::operator==(const cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsTestmodeMethodStart::cmb_sensorfi_tclMsgGpsTestmodeMethodStart(const cmb_sensorfi_tclMsgGpsTestmodeMethodStart& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   SetData = coRef.SetData;
}
cmb_sensorfi_tclMsgGpsTestmodeMethodStart& cmb_sensorfi_tclMsgGpsTestmodeMethodStart::operator=(const cmb_sensorfi_tclMsgGpsTestmodeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SetData = coRef.SetData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsTestmodeMethodStart::cmb_sensorfi_tclMsgGpsTestmodeMethodStart()
:SetData()
 {}

tS32 cmb_sensorfi_tclMsgGpsTestmodeMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTESTMODEMETHODSTART;
}


cmb_sensorfi_tclMsgGpsTestmodeMethodStart::~cmb_sensorfi_tclMsgGpsTestmodeMethodStart()
{}

tU32 cmb_sensorfi_tclMsgGpsTestmodeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsTestmodeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetData);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsTestmodeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetData);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsTestmodeMethodStart::operator==(const cmb_sensorfi_tclMsgGpsTestmodeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetData == roRef.SetData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsTestmodeMethodResult::cmb_sensorfi_tclMsgGpsTestmodeMethodResult(const cmb_sensorfi_tclMsgGpsTestmodeMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TestModeData = coRef.TestModeData;
}
cmb_sensorfi_tclMsgGpsTestmodeMethodResult& cmb_sensorfi_tclMsgGpsTestmodeMethodResult::operator=(const cmb_sensorfi_tclMsgGpsTestmodeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TestModeData = coRef.TestModeData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsTestmodeMethodResult::cmb_sensorfi_tclMsgGpsTestmodeMethodResult()
:TestModeData()
 {}

tS32 cmb_sensorfi_tclMsgGpsTestmodeMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTESTMODEMETHODRESULT;
}


cmb_sensorfi_tclMsgGpsTestmodeMethodResult::~cmb_sensorfi_tclMsgGpsTestmodeMethodResult()
{}

tU32 cmb_sensorfi_tclMsgGpsTestmodeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 31;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsTestmodeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestModeData);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsTestmodeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestModeData);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsTestmodeMethodResult::operator==(const cmb_sensorfi_tclMsgGpsTestmodeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestModeData == roRef.TestModeData);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroSelftestMethodStart::cmb_sensorfi_tclMsgGyroSelftestMethodStart()
 {}

tS32 cmb_sensorfi_tclMsgGyroSelftestMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROSELFTESTMETHODSTART;
}


cmb_sensorfi_tclMsgGyroSelftestMethodStart::~cmb_sensorfi_tclMsgGyroSelftestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroSelftestMethodResult::cmb_sensorfi_tclMsgGyroSelftestMethodResult(const cmb_sensorfi_tclMsgGyroSelftestMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
cmb_sensorfi_tclMsgGyroSelftestMethodResult& cmb_sensorfi_tclMsgGyroSelftestMethodResult::operator=(const cmb_sensorfi_tclMsgGyroSelftestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroSelftestMethodResult::cmb_sensorfi_tclMsgGyroSelftestMethodResult()
:bSuccess(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroSelftestMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROSELFTESTMETHODRESULT;
}


cmb_sensorfi_tclMsgGyroSelftestMethodResult::~cmb_sensorfi_tclMsgGyroSelftestMethodResult()
{}

tU32 cmb_sensorfi_tclMsgGyroSelftestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroSelftestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroSelftestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroSelftestMethodResult::operator==(const cmb_sensorfi_tclMsgGyroSelftestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgSavePersistentMethodStart::cmb_sensorfi_tclMsgSavePersistentMethodStart()
 {}

tS32 cmb_sensorfi_tclMsgSavePersistentMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODSTART;
}


cmb_sensorfi_tclMsgSavePersistentMethodStart::~cmb_sensorfi_tclMsgSavePersistentMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgSavePersistentMethodResult::cmb_sensorfi_tclMsgSavePersistentMethodResult(const cmb_sensorfi_tclMsgSavePersistentMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
cmb_sensorfi_tclMsgSavePersistentMethodResult& cmb_sensorfi_tclMsgSavePersistentMethodResult::operator=(const cmb_sensorfi_tclMsgSavePersistentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgSavePersistentMethodResult::cmb_sensorfi_tclMsgSavePersistentMethodResult()
:bSuccess(0)
 {}

tS32 cmb_sensorfi_tclMsgSavePersistentMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODRESULT;
}


cmb_sensorfi_tclMsgSavePersistentMethodResult::~cmb_sensorfi_tclMsgSavePersistentMethodResult()
{}

tU32 cmb_sensorfi_tclMsgSavePersistentMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgSavePersistentMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgSavePersistentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool cmb_sensorfi_tclMsgSavePersistentMethodResult::operator==(const cmb_sensorfi_tclMsgSavePersistentMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsSetHintsMethodStart::cmb_sensorfi_tclMsgGpsSetHintsMethodStart(const cmb_sensorfi_tclMsgGpsSetHintsMethodStart& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Hint = coRef.Hint;
}
cmb_sensorfi_tclMsgGpsSetHintsMethodStart& cmb_sensorfi_tclMsgGpsSetHintsMethodStart::operator=(const cmb_sensorfi_tclMsgGpsSetHintsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Hint = coRef.Hint;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsSetHintsMethodStart::cmb_sensorfi_tclMsgGpsSetHintsMethodStart()
:Hint()
 {}

tS32 cmb_sensorfi_tclMsgGpsSetHintsMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSSETHINTSMETHODSTART;
}


cmb_sensorfi_tclMsgGpsSetHintsMethodStart::~cmb_sensorfi_tclMsgGpsSetHintsMethodStart()
{}

tU32 cmb_sensorfi_tclMsgGpsSetHintsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 100;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsSetHintsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Hint);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsSetHintsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Hint);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsSetHintsMethodStart::operator==(const cmb_sensorfi_tclMsgGpsSetHintsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Hint == roRef.Hint);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsSetHintsMethodResult::cmb_sensorfi_tclMsgGpsSetHintsMethodResult()
 {}

tS32 cmb_sensorfi_tclMsgGpsSetHintsMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSSETHINTSMETHODRESULT;
}


cmb_sensorfi_tclMsgGpsSetHintsMethodResult::~cmb_sensorfi_tclMsgGpsSetHintsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart(const cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Hint = coRef.Hint;
}
cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart& cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::operator=(const cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Hint = coRef.Hint;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart()
:Hint()
 {}

tS32 cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSSETEXTHINTSMETHODSTART;
}


cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::~cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart()
{}

tU32 cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 132;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Hint);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Hint);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart::operator==(const cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Hint == roRef.Hint);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult::cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult()
 {}

tS32 cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSSETEXTHINTSMETHODRESULT;
}


cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult::~cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   DataPattern = coRef.DataPattern;
}
cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart& cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::operator=(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DataPattern = coRef.DataPattern;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart()
:DataPattern()
 {}

tS32 cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDTESTMETHODSTART;
}


cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::~cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart()
{}

tU32 cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataPattern);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataPattern);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart::operator==(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataPattern == roRef.DataPattern);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   PinToggle = coRef.PinToggle;
}
cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult& cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::operator=(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PinToggle = coRef.PinToggle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult()
:PinToggle(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDTESTMETHODRESULT;
}


cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::~cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult()
{}

tU32 cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PinToggle);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PinToggle);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult::operator==(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PinToggle == roRef.PinToggle);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgUpdateDiagLogMethodStart::cmb_sensorfi_tclMsgUpdateDiagLogMethodStart()
 {}

tS32 cmb_sensorfi_tclMsgUpdateDiagLogMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODSTART;
}


cmb_sensorfi_tclMsgUpdateDiagLogMethodStart::~cmb_sensorfi_tclMsgUpdateDiagLogMethodStart()
{}

//=============================================================================

cmb_sensorfi_tclMsgUpdateDiagLogMethodResult::cmb_sensorfi_tclMsgUpdateDiagLogMethodResult()
 {}

tS32 cmb_sensorfi_tclMsgUpdateDiagLogMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODRESULT;
}


cmb_sensorfi_tclMsgUpdateDiagLogMethodResult::~cmb_sensorfi_tclMsgUpdateDiagLogMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Start = coRef.Start;
}
cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart& cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::operator=(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Start = coRef.Start;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart()
:Start()
 {}

tS32 cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSEXTTESTMODEMETHODSTART;
}


cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::~cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart()
{}

tU32 cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Start);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Start);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart::operator==(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Start == roRef.Start);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult& cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::operator=(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::vDestroy()
{
   Result.vDestroy(); 
}

cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult()
:Result()
 {}

tS32 cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSEXTTESTMODEMETHODRESULT;
}


cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::~cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Result.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult::operator==(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgFactorySettingsMethodStart::cmb_sensorfi_tclMsgFactorySettingsMethodStart()
 {}

tS32 cmb_sensorfi_tclMsgFactorySettingsMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODSTART;
}


cmb_sensorfi_tclMsgFactorySettingsMethodStart::~cmb_sensorfi_tclMsgFactorySettingsMethodStart()
{}

//=============================================================================

cmb_sensorfi_tclMsgFactorySettingsMethodResult::cmb_sensorfi_tclMsgFactorySettingsMethodResult()
 {}

tS32 cmb_sensorfi_tclMsgFactorySettingsMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODRESULT;
}


cmb_sensorfi_tclMsgFactorySettingsMethodResult::~cmb_sensorfi_tclMsgFactorySettingsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart(const cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Deactivate = coRef.Deactivate;
}
cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart& cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::operator=(const cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Deactivate = coRef.Deactivate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart()
:Deactivate(0)
 {}

tS32 cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DEACTIVATEGPSENCODERMETHODSTART;
}


cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::~cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart()
{}

tU32 cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Deactivate);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Deactivate);
   return oOut;
}

tBool cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart::operator==(const cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Deactivate == roRef.Deactivate);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult::cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult()
 {}

tS32 cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DEACTIVATEGPSENCODERMETHODRESULT;
}


cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult::~cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   DefSetGroup = coRef.DefSetGroup;
   DefSetMode = coRef.DefSetMode;
}
cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart& cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::operator=(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetGroup = coRef.DefSetGroup;
   DefSetMode = coRef.DefSetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart()
:DefSetGroup()
,DefSetMode()
 {}

tS32 cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODSTART;
}


cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::~cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart()
{}

tU32 cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetGroup);
   (tVoid) (oIn >> DefSetMode);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetGroup);
   (tVoid) (oOut << DefSetMode);
   return oOut;
}

tBool cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart::operator==(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetGroup == roRef.DefSetGroup);
   bResult = bResult && (DefSetMode == roRef.DefSetMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   DefSetGroup = coRef.DefSetGroup;
   DefSetMode = coRef.DefSetMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
}
cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult& cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::operator=(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetGroup = coRef.DefSetGroup;
   DefSetMode = coRef.DefSetMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult()
:DefSetGroup()
,DefSetMode()
,DefSetStateSuccessful(0)
 {}

tS32 cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODRESULT;
}


cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::~cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult()
{}

tU32 cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetGroup);
   (tVoid) (oIn >> DefSetMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetGroup);
   (tVoid) (oOut << DefSetMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   return oOut;
}

tBool cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult::operator==(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetGroup == roRef.DefSetGroup);
   bResult = bResult && (DefSetMode == roRef.DefSetMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart::cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart()
 {}

tS32 cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODSTART;
}


cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart::~cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult(const cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Gyro3dHwInfo = coRef.Gyro3dHwInfo;
}
cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult& cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::operator=(const cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Gyro3dHwInfo = coRef.Gyro3dHwInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult()
:Gyro3dHwInfo()
 {}

tS32 cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODRESULT;
}


cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::~cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult()
{}

tU32 cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 217;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Gyro3dHwInfo);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Gyro3dHwInfo);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult::operator==(const cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Gyro3dHwInfo == roRef.Gyro3dHwInfo);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart::cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart()
 {}

tS32 cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODSTART;
}


cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart::~cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult(const cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Acc3dHwInfo = coRef.Acc3dHwInfo;
}
cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult& cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::operator=(const cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Acc3dHwInfo = coRef.Acc3dHwInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult()
:Acc3dHwInfo()
 {}

tS32 cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODRESULT;
}


cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::~cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult()
{}

tU32 cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 217;
}

fi_tclInContext& cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Acc3dHwInfo);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Acc3dHwInfo);
   return oOut;
}

tBool cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult::operator==(const cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Acc3dHwInfo == roRef.Acc3dHwInfo);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgOdometerData_InitGet::cmb_sensorfi_tclMsgOdometerData_InitGet()
 {}

tS32 cmb_sensorfi_tclMsgOdometerData_InitGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_INITGET;
}


cmb_sensorfi_tclMsgOdometerData_InitGet::~cmb_sensorfi_tclMsgOdometerData_InitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgOdometerData_InitStatus::cmb_sensorfi_tclMsgOdometerData_InitStatus(const cmb_sensorfi_tclMsgOdometerData_InitStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   OdometerData_Init = coRef.OdometerData_Init;
   DistanceCalibrationValue = coRef.DistanceCalibrationValue;
   TyreExpansionValue = coRef.TyreExpansionValue;
   OdometerMsg_SendPeriod = coRef.OdometerMsg_SendPeriod;
}
cmb_sensorfi_tclMsgOdometerData_InitStatus& cmb_sensorfi_tclMsgOdometerData_InitStatus::operator=(const cmb_sensorfi_tclMsgOdometerData_InitStatus& coRef)
{
   if (this == &coRef) return *this;
   OdometerData_Init = coRef.OdometerData_Init;
   DistanceCalibrationValue = coRef.DistanceCalibrationValue;
   TyreExpansionValue = coRef.TyreExpansionValue;
   OdometerMsg_SendPeriod = coRef.OdometerMsg_SendPeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgOdometerData_InitStatus::cmb_sensorfi_tclMsgOdometerData_InitStatus()
:OdometerData_Init()
,DistanceCalibrationValue(0)
,TyreExpansionValue(0)
,OdometerMsg_SendPeriod(0)
 {}

tS32 cmb_sensorfi_tclMsgOdometerData_InitStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_INITSTATUS;
}


cmb_sensorfi_tclMsgOdometerData_InitStatus::~cmb_sensorfi_tclMsgOdometerData_InitStatus()
{}

tU32 cmb_sensorfi_tclMsgOdometerData_InitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& cmb_sensorfi_tclMsgOdometerData_InitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OdometerData_Init);
   (tVoid) (oIn >> DistanceCalibrationValue);
   (tVoid) (oIn >> TyreExpansionValue);
   (tVoid) (oIn >> OdometerMsg_SendPeriod);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgOdometerData_InitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OdometerData_Init);
   (tVoid) (oOut << DistanceCalibrationValue);
   (tVoid) (oOut << TyreExpansionValue);
   (tVoid) (oOut << OdometerMsg_SendPeriod);
   return oOut;
}

tBool cmb_sensorfi_tclMsgOdometerData_InitStatus::operator==(const cmb_sensorfi_tclMsgOdometerData_InitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OdometerData_Init == roRef.OdometerData_Init);
   bResult = bResult && (DistanceCalibrationValue == roRef.DistanceCalibrationValue);
   bResult = bResult && (TyreExpansionValue == roRef.TyreExpansionValue);
   bResult = bResult && (OdometerMsg_SendPeriod == roRef.OdometerMsg_SendPeriod);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgOdometerData_UpdateGet::cmb_sensorfi_tclMsgOdometerData_UpdateGet()
 {}

tS32 cmb_sensorfi_tclMsgOdometerData_UpdateGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEGET;
}


cmb_sensorfi_tclMsgOdometerData_UpdateGet::~cmb_sensorfi_tclMsgOdometerData_UpdateGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgOdometerData_UpdateUpReg::cmb_sensorfi_tclMsgOdometerData_UpdateUpReg()
 {}

tS32 cmb_sensorfi_tclMsgOdometerData_UpdateUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEUPREG;
}


cmb_sensorfi_tclMsgOdometerData_UpdateUpReg::~cmb_sensorfi_tclMsgOdometerData_UpdateUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg::cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_UPDATERELUPREG;
}


cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg::~cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgOdometerData_UpdateStatus::cmb_sensorfi_tclMsgOdometerData_UpdateStatus(const cmb_sensorfi_tclMsgOdometerData_UpdateStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   OdometerData = coRef.OdometerData;
   FirstOdomValueIsInitial = coRef.FirstOdomValueIsInitial;
}
cmb_sensorfi_tclMsgOdometerData_UpdateStatus& cmb_sensorfi_tclMsgOdometerData_UpdateStatus::operator=(const cmb_sensorfi_tclMsgOdometerData_UpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   OdometerData = coRef.OdometerData;
   FirstOdomValueIsInitial = coRef.FirstOdomValueIsInitial;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgOdometerData_UpdateStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OdometerData.size(); ++u32Idx)
         OdometerData[u32Idx].vDestroy();
   OdometerData.clear();
   }
}

cmb_sensorfi_tclMsgOdometerData_UpdateStatus::cmb_sensorfi_tclMsgOdometerData_UpdateStatus()

:FirstOdomValueIsInitial(0)
 {}

tS32 cmb_sensorfi_tclMsgOdometerData_UpdateStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERDATA_UPDATESTATUS;
}


cmb_sensorfi_tclMsgOdometerData_UpdateStatus::~cmb_sensorfi_tclMsgOdometerData_UpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgOdometerData_UpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(OdometerData.size()*8);
}

fi_tclInContext& cmb_sensorfi_tclMsgOdometerData_UpdateStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OdometerData.size(); ++u32Idx)
      {
         OdometerData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OdometerData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OdometerData[u32Idx]);
      }
   }
   (tVoid) (oIn >> FirstOdomValueIsInitial);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgOdometerData_UpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)OdometerData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OdometerData.size(); ++u32Idx)
         (tVoid) (oOut << OdometerData[u32Idx]);
   }
   (tVoid) (oOut << FirstOdomValueIsInitial);
   return oOut;
}

tBool cmb_sensorfi_tclMsgOdometerData_UpdateStatus::operator==(const cmb_sensorfi_tclMsgOdometerData_UpdateStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (OdometerData.size() == roRef.OdometerData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OdometerData.size()); ++u32Idx)
            bResult = bResult && (OdometerData[u32Idx] == roRef.OdometerData[u32Idx]);
      }
   bResult = bResult && (FirstOdomValueIsInitial == roRef.FirstOdomValueIsInitial);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroData_InitGet::cmb_sensorfi_tclMsgGyroData_InitGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroData_InitGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRODATA_INITGET;
}


cmb_sensorfi_tclMsgGyroData_InitGet::~cmb_sensorfi_tclMsgGyroData_InitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroData_InitStatus::cmb_sensorfi_tclMsgGyroData_InitStatus(const cmb_sensorfi_tclMsgGyroData_InitStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroData_Init = coRef.GyroData_Init;
   GyroOffset = coRef.GyroOffset;
   GyroScalefactor = coRef.GyroScalefactor;
   GyroMsg_SendPeriod = coRef.GyroMsg_SendPeriod;
}
cmb_sensorfi_tclMsgGyroData_InitStatus& cmb_sensorfi_tclMsgGyroData_InitStatus::operator=(const cmb_sensorfi_tclMsgGyroData_InitStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroData_Init = coRef.GyroData_Init;
   GyroOffset = coRef.GyroOffset;
   GyroScalefactor = coRef.GyroScalefactor;
   GyroMsg_SendPeriod = coRef.GyroMsg_SendPeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroData_InitStatus::cmb_sensorfi_tclMsgGyroData_InitStatus()
:GyroData_Init()
,GyroOffset(0)
,GyroScalefactor(0)
,GyroMsg_SendPeriod(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroData_InitStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRODATA_INITSTATUS;
}


cmb_sensorfi_tclMsgGyroData_InitStatus::~cmb_sensorfi_tclMsgGyroData_InitStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroData_InitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroData_InitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroData_Init);
   (tVoid) (oIn >> GyroOffset);
   (tVoid) (oIn >> GyroScalefactor);
   (tVoid) (oIn >> GyroMsg_SendPeriod);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroData_InitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroData_Init);
   (tVoid) (oOut << GyroOffset);
   (tVoid) (oOut << GyroScalefactor);
   (tVoid) (oOut << GyroMsg_SendPeriod);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroData_InitStatus::operator==(const cmb_sensorfi_tclMsgGyroData_InitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroData_Init == roRef.GyroData_Init);
   bResult = bResult && (GyroOffset == roRef.GyroOffset);
   bResult = bResult && (GyroScalefactor == roRef.GyroScalefactor);
   bResult = bResult && (GyroMsg_SendPeriod == roRef.GyroMsg_SendPeriod);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroData_UpdateGet::cmb_sensorfi_tclMsgGyroData_UpdateGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroData_UpdateGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRODATA_UPDATEGET;
}


cmb_sensorfi_tclMsgGyroData_UpdateGet::~cmb_sensorfi_tclMsgGyroData_UpdateGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyroData_UpdateUpReg::cmb_sensorfi_tclMsgGyroData_UpdateUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroData_UpdateUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRODATA_UPDATEUPREG;
}


cmb_sensorfi_tclMsgGyroData_UpdateUpReg::~cmb_sensorfi_tclMsgGyroData_UpdateUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg::cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRODATA_UPDATERELUPREG;
}


cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg::~cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroData_UpdateStatus::cmb_sensorfi_tclMsgGyroData_UpdateStatus(const cmb_sensorfi_tclMsgGyroData_UpdateStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroData = coRef.GyroData;
}
cmb_sensorfi_tclMsgGyroData_UpdateStatus& cmb_sensorfi_tclMsgGyroData_UpdateStatus::operator=(const cmb_sensorfi_tclMsgGyroData_UpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroData = coRef.GyroData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGyroData_UpdateStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < GyroData.size(); ++u32Idx)
         GyroData[u32Idx].vDestroy();
   GyroData.clear();
   }
}

cmb_sensorfi_tclMsgGyroData_UpdateStatus::cmb_sensorfi_tclMsgGyroData_UpdateStatus()

 {}

tS32 cmb_sensorfi_tclMsgGyroData_UpdateStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRODATA_UPDATESTATUS;
}


cmb_sensorfi_tclMsgGyroData_UpdateStatus::~cmb_sensorfi_tclMsgGyroData_UpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGyroData_UpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(GyroData.size()*10);
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroData_UpdateStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GyroData.size(); ++u32Idx)
      {
         GyroData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      GyroData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GyroData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroData_UpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)GyroData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GyroData.size(); ++u32Idx)
         (tVoid) (oOut << GyroData[u32Idx]);
   }
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroData_UpdateStatus::operator==(const cmb_sensorfi_tclMsgGyroData_UpdateStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (GyroData.size() == roRef.GyroData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GyroData.size()); ++u32Idx)
            bResult = bResult && (GyroData[u32Idx] == roRef.GyroData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsDataGet::cmb_sensorfi_tclMsgGpsDataGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDATAGET;
}


cmb_sensorfi_tclMsgGpsDataGet::~cmb_sensorfi_tclMsgGpsDataGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsDataUpReg::cmb_sensorfi_tclMsgGpsDataUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsDataUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDATAUPREG;
}


cmb_sensorfi_tclMsgGpsDataUpReg::~cmb_sensorfi_tclMsgGpsDataUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsDataRelUpReg::cmb_sensorfi_tclMsgGpsDataRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsDataRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDATARELUPREG;
}


cmb_sensorfi_tclMsgGpsDataRelUpReg::~cmb_sensorfi_tclMsgGpsDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsDataStatus::cmb_sensorfi_tclMsgGpsDataStatus(const cmb_sensorfi_tclMsgGpsDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsData = coRef.GpsData;
}
cmb_sensorfi_tclMsgGpsDataStatus& cmb_sensorfi_tclMsgGpsDataStatus::operator=(const cmb_sensorfi_tclMsgGpsDataStatus& coRef)
{
   if (this == &coRef) return *this;
   GpsData = coRef.GpsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGpsDataStatus::vDestroy()
{
   GpsData.vDestroy(); 
}

cmb_sensorfi_tclMsgGpsDataStatus::cmb_sensorfi_tclMsgGpsDataStatus()
:GpsData()
 {}

tS32 cmb_sensorfi_tclMsgGpsDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDATASTATUS;
}


cmb_sensorfi_tclMsgGpsDataStatus::~cmb_sensorfi_tclMsgGpsDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGpsDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+GpsData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GpsData);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GpsData);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsDataStatus::operator==(const cmb_sensorfi_tclMsgGpsDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GpsData == roRef.GpsData);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsData_ValidContentGet::cmb_sensorfi_tclMsgGpsData_ValidContentGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsData_ValidContentGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDATA_VALIDCONTENTGET;
}


cmb_sensorfi_tclMsgGpsData_ValidContentGet::~cmb_sensorfi_tclMsgGpsData_ValidContentGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsData_ValidContentStatus::cmb_sensorfi_tclMsgGpsData_ValidContentStatus(const cmb_sensorfi_tclMsgGpsData_ValidContentStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsDataValid = coRef.GpsDataValid;
}
cmb_sensorfi_tclMsgGpsData_ValidContentStatus& cmb_sensorfi_tclMsgGpsData_ValidContentStatus::operator=(const cmb_sensorfi_tclMsgGpsData_ValidContentStatus& coRef)
{
   if (this == &coRef) return *this;
   GpsDataValid = coRef.GpsDataValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGpsData_ValidContentStatus::vDestroy()
{
   GpsDataValid.vDestroy(); 
}

cmb_sensorfi_tclMsgGpsData_ValidContentStatus::cmb_sensorfi_tclMsgGpsData_ValidContentStatus()
:GpsDataValid()
 {}

tS32 cmb_sensorfi_tclMsgGpsData_ValidContentStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDATA_VALIDCONTENTSTATUS;
}


cmb_sensorfi_tclMsgGpsData_ValidContentStatus::~cmb_sensorfi_tclMsgGpsData_ValidContentStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGpsData_ValidContentStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+GpsDataValid.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsData_ValidContentStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GpsDataValid);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsData_ValidContentStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GpsDataValid);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsData_ValidContentStatus::operator==(const cmb_sensorfi_tclMsgGpsData_ValidContentStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GpsDataValid == roRef.GpsDataValid);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgTyreWidthGet::cmb_sensorfi_tclMsgTyreWidthGet()
 {}

tS32 cmb_sensorfi_tclMsgTyreWidthGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREWIDTHGET;
}


cmb_sensorfi_tclMsgTyreWidthGet::~cmb_sensorfi_tclMsgTyreWidthGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreWidthSet::cmb_sensorfi_tclMsgTyreWidthSet(const cmb_sensorfi_tclMsgTyreWidthSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreWidth = coRef.TyreWidth;
}
cmb_sensorfi_tclMsgTyreWidthSet& cmb_sensorfi_tclMsgTyreWidthSet::operator=(const cmb_sensorfi_tclMsgTyreWidthSet& coRef)
{
   if (this == &coRef) return *this;
   TyreWidth = coRef.TyreWidth;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreWidthSet::cmb_sensorfi_tclMsgTyreWidthSet()
:TyreWidth(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreWidthSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREWIDTHSET;
}


cmb_sensorfi_tclMsgTyreWidthSet::~cmb_sensorfi_tclMsgTyreWidthSet()
{}

tU32 cmb_sensorfi_tclMsgTyreWidthSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreWidthSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreWidth);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreWidthSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreWidth);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreWidthSet::operator==(const cmb_sensorfi_tclMsgTyreWidthSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreWidth == roRef.TyreWidth);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreWidthStatus::cmb_sensorfi_tclMsgTyreWidthStatus(const cmb_sensorfi_tclMsgTyreWidthStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreWidth = coRef.TyreWidth;
}
cmb_sensorfi_tclMsgTyreWidthStatus& cmb_sensorfi_tclMsgTyreWidthStatus::operator=(const cmb_sensorfi_tclMsgTyreWidthStatus& coRef)
{
   if (this == &coRef) return *this;
   TyreWidth = coRef.TyreWidth;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreWidthStatus::cmb_sensorfi_tclMsgTyreWidthStatus()
:TyreWidth(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreWidthStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREWIDTHSTATUS;
}


cmb_sensorfi_tclMsgTyreWidthStatus::~cmb_sensorfi_tclMsgTyreWidthStatus()
{}

tU32 cmb_sensorfi_tclMsgTyreWidthStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreWidthStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreWidth);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreWidthStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreWidth);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreWidthStatus::operator==(const cmb_sensorfi_tclMsgTyreWidthStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreWidth == roRef.TyreWidth);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgTyreHeightWidthRatioGet::cmb_sensorfi_tclMsgTyreHeightWidthRatioGet()
 {}

tS32 cmb_sensorfi_tclMsgTyreHeightWidthRatioGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREHEIGHTWIDTHRATIOGET;
}


cmb_sensorfi_tclMsgTyreHeightWidthRatioGet::~cmb_sensorfi_tclMsgTyreHeightWidthRatioGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::cmb_sensorfi_tclMsgTyreHeightWidthRatioSet(const cmb_sensorfi_tclMsgTyreHeightWidthRatioSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreHeightWidthRatio = coRef.TyreHeightWidthRatio;
}
cmb_sensorfi_tclMsgTyreHeightWidthRatioSet& cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::operator=(const cmb_sensorfi_tclMsgTyreHeightWidthRatioSet& coRef)
{
   if (this == &coRef) return *this;
   TyreHeightWidthRatio = coRef.TyreHeightWidthRatio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::cmb_sensorfi_tclMsgTyreHeightWidthRatioSet()
:TyreHeightWidthRatio(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREHEIGHTWIDTHRATIOSET;
}


cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::~cmb_sensorfi_tclMsgTyreHeightWidthRatioSet()
{}

tU32 cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreHeightWidthRatio);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreHeightWidthRatio);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreHeightWidthRatioSet::operator==(const cmb_sensorfi_tclMsgTyreHeightWidthRatioSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreHeightWidthRatio == roRef.TyreHeightWidthRatio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus(const cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreHeightWidthRatio = coRef.TyreHeightWidthRatio;
}
cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus& cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::operator=(const cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus& coRef)
{
   if (this == &coRef) return *this;
   TyreHeightWidthRatio = coRef.TyreHeightWidthRatio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus()
:TyreHeightWidthRatio(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREHEIGHTWIDTHRATIOSTATUS;
}


cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::~cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus()
{}

tU32 cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreHeightWidthRatio);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreHeightWidthRatio);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus::operator==(const cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreHeightWidthRatio == roRef.TyreHeightWidthRatio);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgRimDiameterGet::cmb_sensorfi_tclMsgRimDiameterGet()
 {}

tS32 cmb_sensorfi_tclMsgRimDiameterGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_RIMDIAMETERGET;
}


cmb_sensorfi_tclMsgRimDiameterGet::~cmb_sensorfi_tclMsgRimDiameterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgRimDiameterSet::cmb_sensorfi_tclMsgRimDiameterSet(const cmb_sensorfi_tclMsgRimDiameterSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   RimDiameter = coRef.RimDiameter;
}
cmb_sensorfi_tclMsgRimDiameterSet& cmb_sensorfi_tclMsgRimDiameterSet::operator=(const cmb_sensorfi_tclMsgRimDiameterSet& coRef)
{
   if (this == &coRef) return *this;
   RimDiameter = coRef.RimDiameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgRimDiameterSet::cmb_sensorfi_tclMsgRimDiameterSet()
:RimDiameter(0)
 {}

tS32 cmb_sensorfi_tclMsgRimDiameterSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_RIMDIAMETERSET;
}


cmb_sensorfi_tclMsgRimDiameterSet::~cmb_sensorfi_tclMsgRimDiameterSet()
{}

tU32 cmb_sensorfi_tclMsgRimDiameterSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgRimDiameterSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RimDiameter);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgRimDiameterSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RimDiameter);
   return oOut;
}

tBool cmb_sensorfi_tclMsgRimDiameterSet::operator==(const cmb_sensorfi_tclMsgRimDiameterSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RimDiameter == roRef.RimDiameter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgRimDiameterStatus::cmb_sensorfi_tclMsgRimDiameterStatus(const cmb_sensorfi_tclMsgRimDiameterStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   RimDiameter = coRef.RimDiameter;
}
cmb_sensorfi_tclMsgRimDiameterStatus& cmb_sensorfi_tclMsgRimDiameterStatus::operator=(const cmb_sensorfi_tclMsgRimDiameterStatus& coRef)
{
   if (this == &coRef) return *this;
   RimDiameter = coRef.RimDiameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgRimDiameterStatus::cmb_sensorfi_tclMsgRimDiameterStatus()
:RimDiameter(0)
 {}

tS32 cmb_sensorfi_tclMsgRimDiameterStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_RIMDIAMETERSTATUS;
}


cmb_sensorfi_tclMsgRimDiameterStatus::~cmb_sensorfi_tclMsgRimDiameterStatus()
{}

tU32 cmb_sensorfi_tclMsgRimDiameterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgRimDiameterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RimDiameter);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgRimDiameterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RimDiameter);
   return oOut;
}

tBool cmb_sensorfi_tclMsgRimDiameterStatus::operator==(const cmb_sensorfi_tclMsgRimDiameterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RimDiameter == roRef.RimDiameter);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgTyreConditionGet::cmb_sensorfi_tclMsgTyreConditionGet()
 {}

tS32 cmb_sensorfi_tclMsgTyreConditionGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYRECONDITIONGET;
}


cmb_sensorfi_tclMsgTyreConditionGet::~cmb_sensorfi_tclMsgTyreConditionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreConditionSet::cmb_sensorfi_tclMsgTyreConditionSet(const cmb_sensorfi_tclMsgTyreConditionSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreCondition = coRef.TyreCondition;
}
cmb_sensorfi_tclMsgTyreConditionSet& cmb_sensorfi_tclMsgTyreConditionSet::operator=(const cmb_sensorfi_tclMsgTyreConditionSet& coRef)
{
   if (this == &coRef) return *this;
   TyreCondition = coRef.TyreCondition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreConditionSet::cmb_sensorfi_tclMsgTyreConditionSet()
:TyreCondition(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreConditionSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYRECONDITIONSET;
}


cmb_sensorfi_tclMsgTyreConditionSet::~cmb_sensorfi_tclMsgTyreConditionSet()
{}

tU32 cmb_sensorfi_tclMsgTyreConditionSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreConditionSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreCondition);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreConditionSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreCondition);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreConditionSet::operator==(const cmb_sensorfi_tclMsgTyreConditionSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreCondition == roRef.TyreCondition);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreConditionStatus::cmb_sensorfi_tclMsgTyreConditionStatus(const cmb_sensorfi_tclMsgTyreConditionStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreCondition = coRef.TyreCondition;
}
cmb_sensorfi_tclMsgTyreConditionStatus& cmb_sensorfi_tclMsgTyreConditionStatus::operator=(const cmb_sensorfi_tclMsgTyreConditionStatus& coRef)
{
   if (this == &coRef) return *this;
   TyreCondition = coRef.TyreCondition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreConditionStatus::cmb_sensorfi_tclMsgTyreConditionStatus()
:TyreCondition(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreConditionStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYRECONDITIONSTATUS;
}


cmb_sensorfi_tclMsgTyreConditionStatus::~cmb_sensorfi_tclMsgTyreConditionStatus()
{}

tU32 cmb_sensorfi_tclMsgTyreConditionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreConditionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreCondition);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreConditionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreCondition);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreConditionStatus::operator==(const cmb_sensorfi_tclMsgTyreConditionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreCondition == roRef.TyreCondition);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgTyreCircumferenceGet::cmb_sensorfi_tclMsgTyreCircumferenceGet()
 {}

tS32 cmb_sensorfi_tclMsgTyreCircumferenceGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYRECIRCUMFERENCEGET;
}


cmb_sensorfi_tclMsgTyreCircumferenceGet::~cmb_sensorfi_tclMsgTyreCircumferenceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreCircumferenceSet::cmb_sensorfi_tclMsgTyreCircumferenceSet(const cmb_sensorfi_tclMsgTyreCircumferenceSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreCircumference = coRef.TyreCircumference;
}
cmb_sensorfi_tclMsgTyreCircumferenceSet& cmb_sensorfi_tclMsgTyreCircumferenceSet::operator=(const cmb_sensorfi_tclMsgTyreCircumferenceSet& coRef)
{
   if (this == &coRef) return *this;
   TyreCircumference = coRef.TyreCircumference;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreCircumferenceSet::cmb_sensorfi_tclMsgTyreCircumferenceSet()
:TyreCircumference(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreCircumferenceSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYRECIRCUMFERENCESET;
}


cmb_sensorfi_tclMsgTyreCircumferenceSet::~cmb_sensorfi_tclMsgTyreCircumferenceSet()
{}

tU32 cmb_sensorfi_tclMsgTyreCircumferenceSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreCircumferenceSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreCircumference);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreCircumferenceSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreCircumference);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreCircumferenceSet::operator==(const cmb_sensorfi_tclMsgTyreCircumferenceSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreCircumference == roRef.TyreCircumference);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreCircumferenceStatus::cmb_sensorfi_tclMsgTyreCircumferenceStatus(const cmb_sensorfi_tclMsgTyreCircumferenceStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreCircumference = coRef.TyreCircumference;
}
cmb_sensorfi_tclMsgTyreCircumferenceStatus& cmb_sensorfi_tclMsgTyreCircumferenceStatus::operator=(const cmb_sensorfi_tclMsgTyreCircumferenceStatus& coRef)
{
   if (this == &coRef) return *this;
   TyreCircumference = coRef.TyreCircumference;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreCircumferenceStatus::cmb_sensorfi_tclMsgTyreCircumferenceStatus()
:TyreCircumference(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreCircumferenceStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYRECIRCUMFERENCESTATUS;
}


cmb_sensorfi_tclMsgTyreCircumferenceStatus::~cmb_sensorfi_tclMsgTyreCircumferenceStatus()
{}

tU32 cmb_sensorfi_tclMsgTyreCircumferenceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreCircumferenceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreCircumference);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreCircumferenceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreCircumference);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreCircumferenceStatus::operator==(const cmb_sensorfi_tclMsgTyreCircumferenceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreCircumference == roRef.TyreCircumference);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet::cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet()
 {}

tS32 cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_PULSESPERTYRECIRCUMFERENCEGET;
}


cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet::~cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   PulsesPerTyreCircumference = coRef.PulsesPerTyreCircumference;
}
cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet& cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::operator=(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet& coRef)
{
   if (this == &coRef) return *this;
   PulsesPerTyreCircumference = coRef.PulsesPerTyreCircumference;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet()
:PulsesPerTyreCircumference(0)
 {}

tS32 cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_PULSESPERTYRECIRCUMFERENCESET;
}


cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::~cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet()
{}

tU32 cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PulsesPerTyreCircumference);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PulsesPerTyreCircumference);
   return oOut;
}

tBool cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet::operator==(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PulsesPerTyreCircumference == roRef.PulsesPerTyreCircumference);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   PulsesPerTyreCircumference = coRef.PulsesPerTyreCircumference;
}
cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus& cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::operator=(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus& coRef)
{
   if (this == &coRef) return *this;
   PulsesPerTyreCircumference = coRef.PulsesPerTyreCircumference;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus()
:PulsesPerTyreCircumference(0)
 {}

tS32 cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_PULSESPERTYRECIRCUMFERENCESTATUS;
}


cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::~cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus()
{}

tU32 cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PulsesPerTyreCircumference);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PulsesPerTyreCircumference);
   return oOut;
}

tBool cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus::operator==(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PulsesPerTyreCircumference == roRef.PulsesPerTyreCircumference);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgDistanceCalibrationValueGet::cmb_sensorfi_tclMsgDistanceCalibrationValueGet()
 {}

tS32 cmb_sensorfi_tclMsgDistanceCalibrationValueGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUEGET;
}


cmb_sensorfi_tclMsgDistanceCalibrationValueGet::~cmb_sensorfi_tclMsgDistanceCalibrationValueGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgDistanceCalibrationValueSet::cmb_sensorfi_tclMsgDistanceCalibrationValueSet(const cmb_sensorfi_tclMsgDistanceCalibrationValueSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   DistanceCalibrationValue = coRef.DistanceCalibrationValue;
}
cmb_sensorfi_tclMsgDistanceCalibrationValueSet& cmb_sensorfi_tclMsgDistanceCalibrationValueSet::operator=(const cmb_sensorfi_tclMsgDistanceCalibrationValueSet& coRef)
{
   if (this == &coRef) return *this;
   DistanceCalibrationValue = coRef.DistanceCalibrationValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgDistanceCalibrationValueSet::cmb_sensorfi_tclMsgDistanceCalibrationValueSet()
:DistanceCalibrationValue(0)
 {}

tS32 cmb_sensorfi_tclMsgDistanceCalibrationValueSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUESET;
}


cmb_sensorfi_tclMsgDistanceCalibrationValueSet::~cmb_sensorfi_tclMsgDistanceCalibrationValueSet()
{}

tU32 cmb_sensorfi_tclMsgDistanceCalibrationValueSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgDistanceCalibrationValueSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DistanceCalibrationValue);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgDistanceCalibrationValueSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DistanceCalibrationValue);
   return oOut;
}

tBool cmb_sensorfi_tclMsgDistanceCalibrationValueSet::operator==(const cmb_sensorfi_tclMsgDistanceCalibrationValueSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DistanceCalibrationValue == roRef.DistanceCalibrationValue);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg::cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg()
 {}

tS32 cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUEUPREG;
}


cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg::~cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg::cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUERELUPREG;
}


cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg::~cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::cmb_sensorfi_tclMsgDistanceCalibrationValueStatus(const cmb_sensorfi_tclMsgDistanceCalibrationValueStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   DistanceCalibrationValue = coRef.DistanceCalibrationValue;
}
cmb_sensorfi_tclMsgDistanceCalibrationValueStatus& cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::operator=(const cmb_sensorfi_tclMsgDistanceCalibrationValueStatus& coRef)
{
   if (this == &coRef) return *this;
   DistanceCalibrationValue = coRef.DistanceCalibrationValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::cmb_sensorfi_tclMsgDistanceCalibrationValueStatus()
:DistanceCalibrationValue(0)
 {}

tS32 cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DISTANCECALIBRATIONVALUESTATUS;
}


cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::~cmb_sensorfi_tclMsgDistanceCalibrationValueStatus()
{}

tU32 cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DistanceCalibrationValue);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DistanceCalibrationValue);
   return oOut;
}

tBool cmb_sensorfi_tclMsgDistanceCalibrationValueStatus::operator==(const cmb_sensorfi_tclMsgDistanceCalibrationValueStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DistanceCalibrationValue == roRef.DistanceCalibrationValue);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgTyreExpansionValueGet::cmb_sensorfi_tclMsgTyreExpansionValueGet()
 {}

tS32 cmb_sensorfi_tclMsgTyreExpansionValueGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREEXPANSIONVALUEGET;
}


cmb_sensorfi_tclMsgTyreExpansionValueGet::~cmb_sensorfi_tclMsgTyreExpansionValueGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreExpansionValueSet::cmb_sensorfi_tclMsgTyreExpansionValueSet(const cmb_sensorfi_tclMsgTyreExpansionValueSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreExpansionValue = coRef.TyreExpansionValue;
   TyreQuadExpansionValue = coRef.TyreQuadExpansionValue;
}
cmb_sensorfi_tclMsgTyreExpansionValueSet& cmb_sensorfi_tclMsgTyreExpansionValueSet::operator=(const cmb_sensorfi_tclMsgTyreExpansionValueSet& coRef)
{
   if (this == &coRef) return *this;
   TyreExpansionValue = coRef.TyreExpansionValue;
   TyreQuadExpansionValue = coRef.TyreQuadExpansionValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreExpansionValueSet::cmb_sensorfi_tclMsgTyreExpansionValueSet()
:TyreExpansionValue(0)
,TyreQuadExpansionValue(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreExpansionValueSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREEXPANSIONVALUESET;
}


cmb_sensorfi_tclMsgTyreExpansionValueSet::~cmb_sensorfi_tclMsgTyreExpansionValueSet()
{}

tU32 cmb_sensorfi_tclMsgTyreExpansionValueSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreExpansionValueSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreExpansionValue);
   (tVoid) (oIn >> TyreQuadExpansionValue);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreExpansionValueSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreExpansionValue);
   (tVoid) (oOut << TyreQuadExpansionValue);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreExpansionValueSet::operator==(const cmb_sensorfi_tclMsgTyreExpansionValueSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreExpansionValue == roRef.TyreExpansionValue);
   bResult = bResult && (TyreQuadExpansionValue == roRef.TyreQuadExpansionValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTyreExpansionValueStatus::cmb_sensorfi_tclMsgTyreExpansionValueStatus(const cmb_sensorfi_tclMsgTyreExpansionValueStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TyreExpansionValue = coRef.TyreExpansionValue;
   TyreQuadExpansionValue = coRef.TyreQuadExpansionValue;
}
cmb_sensorfi_tclMsgTyreExpansionValueStatus& cmb_sensorfi_tclMsgTyreExpansionValueStatus::operator=(const cmb_sensorfi_tclMsgTyreExpansionValueStatus& coRef)
{
   if (this == &coRef) return *this;
   TyreExpansionValue = coRef.TyreExpansionValue;
   TyreQuadExpansionValue = coRef.TyreQuadExpansionValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTyreExpansionValueStatus::cmb_sensorfi_tclMsgTyreExpansionValueStatus()
:TyreExpansionValue(0)
,TyreQuadExpansionValue(0)
 {}

tS32 cmb_sensorfi_tclMsgTyreExpansionValueStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TYREEXPANSIONVALUESTATUS;
}


cmb_sensorfi_tclMsgTyreExpansionValueStatus::~cmb_sensorfi_tclMsgTyreExpansionValueStatus()
{}

tU32 cmb_sensorfi_tclMsgTyreExpansionValueStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_sensorfi_tclMsgTyreExpansionValueStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TyreExpansionValue);
   (tVoid) (oIn >> TyreQuadExpansionValue);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTyreExpansionValueStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TyreExpansionValue);
   (tVoid) (oOut << TyreQuadExpansionValue);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTyreExpansionValueStatus::operator==(const cmb_sensorfi_tclMsgTyreExpansionValueStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TyreExpansionValue == roRef.TyreExpansionValue);
   bResult = bResult && (TyreQuadExpansionValue == roRef.TyreQuadExpansionValue);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroManufacturerGet::cmb_sensorfi_tclMsgGyroManufacturerGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroManufacturerGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROMANUFACTURERGET;
}


cmb_sensorfi_tclMsgGyroManufacturerGet::~cmb_sensorfi_tclMsgGyroManufacturerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroManufacturerSet::cmb_sensorfi_tclMsgGyroManufacturerSet(const cmb_sensorfi_tclMsgGyroManufacturerSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroManufacturer = coRef.GyroManufacturer;
}
cmb_sensorfi_tclMsgGyroManufacturerSet& cmb_sensorfi_tclMsgGyroManufacturerSet::operator=(const cmb_sensorfi_tclMsgGyroManufacturerSet& coRef)
{
   if (this == &coRef) return *this;
   GyroManufacturer = coRef.GyroManufacturer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroManufacturerSet::cmb_sensorfi_tclMsgGyroManufacturerSet()
:GyroManufacturer(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroManufacturerSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROMANUFACTURERSET;
}


cmb_sensorfi_tclMsgGyroManufacturerSet::~cmb_sensorfi_tclMsgGyroManufacturerSet()
{}

tU32 cmb_sensorfi_tclMsgGyroManufacturerSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroManufacturerSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroManufacturer);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroManufacturerSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroManufacturer);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroManufacturerSet::operator==(const cmb_sensorfi_tclMsgGyroManufacturerSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroManufacturer == roRef.GyroManufacturer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroManufacturerStatus::cmb_sensorfi_tclMsgGyroManufacturerStatus(const cmb_sensorfi_tclMsgGyroManufacturerStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroManufacturer = coRef.GyroManufacturer;
}
cmb_sensorfi_tclMsgGyroManufacturerStatus& cmb_sensorfi_tclMsgGyroManufacturerStatus::operator=(const cmb_sensorfi_tclMsgGyroManufacturerStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroManufacturer = coRef.GyroManufacturer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroManufacturerStatus::cmb_sensorfi_tclMsgGyroManufacturerStatus()
:GyroManufacturer(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroManufacturerStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROMANUFACTURERSTATUS;
}


cmb_sensorfi_tclMsgGyroManufacturerStatus::~cmb_sensorfi_tclMsgGyroManufacturerStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroManufacturerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroManufacturerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroManufacturer);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroManufacturerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroManufacturer);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroManufacturerStatus::operator==(const cmb_sensorfi_tclMsgGyroManufacturerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroManufacturer == roRef.GyroManufacturer);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroTypeGet::cmb_sensorfi_tclMsgGyroTypeGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroTypeGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROTYPEGET;
}


cmb_sensorfi_tclMsgGyroTypeGet::~cmb_sensorfi_tclMsgGyroTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroTypeSet::cmb_sensorfi_tclMsgGyroTypeSet(const cmb_sensorfi_tclMsgGyroTypeSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroType = coRef.GyroType;
}
cmb_sensorfi_tclMsgGyroTypeSet& cmb_sensorfi_tclMsgGyroTypeSet::operator=(const cmb_sensorfi_tclMsgGyroTypeSet& coRef)
{
   if (this == &coRef) return *this;
   GyroType = coRef.GyroType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroTypeSet::cmb_sensorfi_tclMsgGyroTypeSet()
:GyroType(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroTypeSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROTYPESET;
}


cmb_sensorfi_tclMsgGyroTypeSet::~cmb_sensorfi_tclMsgGyroTypeSet()
{}

tU32 cmb_sensorfi_tclMsgGyroTypeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroTypeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroType);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroTypeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroType);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroTypeSet::operator==(const cmb_sensorfi_tclMsgGyroTypeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroType == roRef.GyroType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroTypeStatus::cmb_sensorfi_tclMsgGyroTypeStatus(const cmb_sensorfi_tclMsgGyroTypeStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroType = coRef.GyroType;
}
cmb_sensorfi_tclMsgGyroTypeStatus& cmb_sensorfi_tclMsgGyroTypeStatus::operator=(const cmb_sensorfi_tclMsgGyroTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroType = coRef.GyroType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroTypeStatus::cmb_sensorfi_tclMsgGyroTypeStatus()
:GyroType(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroTypeStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROTYPESTATUS;
}


cmb_sensorfi_tclMsgGyroTypeStatus::~cmb_sensorfi_tclMsgGyroTypeStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroType);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroType);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroTypeStatus::operator==(const cmb_sensorfi_tclMsgGyroTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroType == roRef.GyroType);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroOffsetGet::cmb_sensorfi_tclMsgGyroOffsetGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroOffsetGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETGET;
}


cmb_sensorfi_tclMsgGyroOffsetGet::~cmb_sensorfi_tclMsgGyroOffsetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroOffsetSet::cmb_sensorfi_tclMsgGyroOffsetSet(const cmb_sensorfi_tclMsgGyroOffsetSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroOffset = coRef.GyroOffset;
}
cmb_sensorfi_tclMsgGyroOffsetSet& cmb_sensorfi_tclMsgGyroOffsetSet::operator=(const cmb_sensorfi_tclMsgGyroOffsetSet& coRef)
{
   if (this == &coRef) return *this;
   GyroOffset = coRef.GyroOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroOffsetSet::cmb_sensorfi_tclMsgGyroOffsetSet()
:GyroOffset(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroOffsetSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETSET;
}


cmb_sensorfi_tclMsgGyroOffsetSet::~cmb_sensorfi_tclMsgGyroOffsetSet()
{}

tU32 cmb_sensorfi_tclMsgGyroOffsetSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroOffsetSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroOffset);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroOffsetSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroOffset);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroOffsetSet::operator==(const cmb_sensorfi_tclMsgGyroOffsetSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroOffset == roRef.GyroOffset);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroOffsetUpReg::cmb_sensorfi_tclMsgGyroOffsetUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroOffsetUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETUPREG;
}


cmb_sensorfi_tclMsgGyroOffsetUpReg::~cmb_sensorfi_tclMsgGyroOffsetUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyroOffsetRelUpReg::cmb_sensorfi_tclMsgGyroOffsetRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroOffsetRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETRELUPREG;
}


cmb_sensorfi_tclMsgGyroOffsetRelUpReg::~cmb_sensorfi_tclMsgGyroOffsetRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroOffsetStatus::cmb_sensorfi_tclMsgGyroOffsetStatus(const cmb_sensorfi_tclMsgGyroOffsetStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroOffset = coRef.GyroOffset;
}
cmb_sensorfi_tclMsgGyroOffsetStatus& cmb_sensorfi_tclMsgGyroOffsetStatus::operator=(const cmb_sensorfi_tclMsgGyroOffsetStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroOffset = coRef.GyroOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroOffsetStatus::cmb_sensorfi_tclMsgGyroOffsetStatus()
:GyroOffset(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroOffsetStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROOFFSETSTATUS;
}


cmb_sensorfi_tclMsgGyroOffsetStatus::~cmb_sensorfi_tclMsgGyroOffsetStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroOffsetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroOffsetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroOffset);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroOffsetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroOffset);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroOffsetStatus::operator==(const cmb_sensorfi_tclMsgGyroOffsetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroOffset == roRef.GyroOffset);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroScalefactorGet::cmb_sensorfi_tclMsgGyroScalefactorGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroScalefactorGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORGET;
}


cmb_sensorfi_tclMsgGyroScalefactorGet::~cmb_sensorfi_tclMsgGyroScalefactorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroScalefactorSet::cmb_sensorfi_tclMsgGyroScalefactorSet(const cmb_sensorfi_tclMsgGyroScalefactorSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroScalefactor = coRef.GyroScalefactor;
}
cmb_sensorfi_tclMsgGyroScalefactorSet& cmb_sensorfi_tclMsgGyroScalefactorSet::operator=(const cmb_sensorfi_tclMsgGyroScalefactorSet& coRef)
{
   if (this == &coRef) return *this;
   GyroScalefactor = coRef.GyroScalefactor;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroScalefactorSet::cmb_sensorfi_tclMsgGyroScalefactorSet()
:GyroScalefactor(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroScalefactorSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORSET;
}


cmb_sensorfi_tclMsgGyroScalefactorSet::~cmb_sensorfi_tclMsgGyroScalefactorSet()
{}

tU32 cmb_sensorfi_tclMsgGyroScalefactorSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroScalefactorSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroScalefactor);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroScalefactorSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroScalefactor);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroScalefactorSet::operator==(const cmb_sensorfi_tclMsgGyroScalefactorSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroScalefactor == roRef.GyroScalefactor);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroScalefactorUpReg::cmb_sensorfi_tclMsgGyroScalefactorUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroScalefactorUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORUPREG;
}


cmb_sensorfi_tclMsgGyroScalefactorUpReg::~cmb_sensorfi_tclMsgGyroScalefactorUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyroScalefactorRelUpReg::cmb_sensorfi_tclMsgGyroScalefactorRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroScalefactorRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORRELUPREG;
}


cmb_sensorfi_tclMsgGyroScalefactorRelUpReg::~cmb_sensorfi_tclMsgGyroScalefactorRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroScalefactorStatus::cmb_sensorfi_tclMsgGyroScalefactorStatus(const cmb_sensorfi_tclMsgGyroScalefactorStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroScalefactor = coRef.GyroScalefactor;
}
cmb_sensorfi_tclMsgGyroScalefactorStatus& cmb_sensorfi_tclMsgGyroScalefactorStatus::operator=(const cmb_sensorfi_tclMsgGyroScalefactorStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroScalefactor = coRef.GyroScalefactor;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroScalefactorStatus::cmb_sensorfi_tclMsgGyroScalefactorStatus()
:GyroScalefactor(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroScalefactorStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROSCALEFACTORSTATUS;
}


cmb_sensorfi_tclMsgGyroScalefactorStatus::~cmb_sensorfi_tclMsgGyroScalefactorStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroScalefactorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroScalefactorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroScalefactor);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroScalefactorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroScalefactor);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroScalefactorStatus::operator==(const cmb_sensorfi_tclMsgGyroScalefactorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroScalefactor == roRef.GyroScalefactor);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsCommunicationProtocolGet::cmb_sensorfi_tclMsgGpsCommunicationProtocolGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsCommunicationProtocolGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSCOMMUNICATIONPROTOCOLGET;
}


cmb_sensorfi_tclMsgGpsCommunicationProtocolGet::~cmb_sensorfi_tclMsgGpsCommunicationProtocolGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::cmb_sensorfi_tclMsgGpsCommunicationProtocolSet(const cmb_sensorfi_tclMsgGpsCommunicationProtocolSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsCommunicationProtocol = coRef.GpsCommunicationProtocol;
}
cmb_sensorfi_tclMsgGpsCommunicationProtocolSet& cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::operator=(const cmb_sensorfi_tclMsgGpsCommunicationProtocolSet& coRef)
{
   if (this == &coRef) return *this;
   GpsCommunicationProtocol = coRef.GpsCommunicationProtocol;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < GpsCommunicationProtocol.size(); ++u32Idx)
         GpsCommunicationProtocol[u32Idx].vDestroy();
   GpsCommunicationProtocol.clear();
   }
}

cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::cmb_sensorfi_tclMsgGpsCommunicationProtocolSet()

 {}

tS32 cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSCOMMUNICATIONPROTOCOLSET;
}


cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::~cmb_sensorfi_tclMsgGpsCommunicationProtocolSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(GpsCommunicationProtocol.size()*4);
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GpsCommunicationProtocol.size(); ++u32Idx)
      {
         GpsCommunicationProtocol[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      GpsCommunicationProtocol.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GpsCommunicationProtocol[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)GpsCommunicationProtocol.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GpsCommunicationProtocol.size(); ++u32Idx)
         (tVoid) (oOut << GpsCommunicationProtocol[u32Idx]);
   }
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsCommunicationProtocolSet::operator==(const cmb_sensorfi_tclMsgGpsCommunicationProtocolSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (GpsCommunicationProtocol.size() == roRef.GpsCommunicationProtocol.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GpsCommunicationProtocol.size()); ++u32Idx)
            bResult = bResult && (GpsCommunicationProtocol[u32Idx] == roRef.GpsCommunicationProtocol[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus(const cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsCommunicationProtocol = coRef.GpsCommunicationProtocol;
}
cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus& cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::operator=(const cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus& coRef)
{
   if (this == &coRef) return *this;
   GpsCommunicationProtocol = coRef.GpsCommunicationProtocol;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < GpsCommunicationProtocol.size(); ++u32Idx)
         GpsCommunicationProtocol[u32Idx].vDestroy();
   GpsCommunicationProtocol.clear();
   }
}

cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus()

 {}

tS32 cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSCOMMUNICATIONPROTOCOLSTATUS;
}


cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::~cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(GpsCommunicationProtocol.size()*4);
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GpsCommunicationProtocol.size(); ++u32Idx)
      {
         GpsCommunicationProtocol[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      GpsCommunicationProtocol.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GpsCommunicationProtocol[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)GpsCommunicationProtocol.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GpsCommunicationProtocol.size(); ++u32Idx)
         (tVoid) (oOut << GpsCommunicationProtocol[u32Idx]);
   }
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus::operator==(const cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (GpsCommunicationProtocol.size() == roRef.GpsCommunicationProtocol.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GpsCommunicationProtocol.size()); ++u32Idx)
            bResult = bResult && (GpsCommunicationProtocol[u32Idx] == roRef.GpsCommunicationProtocol[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsTemperatureGet::cmb_sensorfi_tclMsgGpsTemperatureGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsTemperatureGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTEMPERATUREGET;
}


cmb_sensorfi_tclMsgGpsTemperatureGet::~cmb_sensorfi_tclMsgGpsTemperatureGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsTemperatureUpReg::cmb_sensorfi_tclMsgGpsTemperatureUpReg(const cmb_sensorfi_tclMsgGpsTemperatureUpReg& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsTemperatureSendPeriod = coRef.GpsTemperatureSendPeriod;
}
cmb_sensorfi_tclMsgGpsTemperatureUpReg& cmb_sensorfi_tclMsgGpsTemperatureUpReg::operator=(const cmb_sensorfi_tclMsgGpsTemperatureUpReg& coRef)
{
   if (this == &coRef) return *this;
   GpsTemperatureSendPeriod = coRef.GpsTemperatureSendPeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsTemperatureUpReg::cmb_sensorfi_tclMsgGpsTemperatureUpReg()
:GpsTemperatureSendPeriod(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsTemperatureUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTEMPERATUREUPREG;
}


cmb_sensorfi_tclMsgGpsTemperatureUpReg::~cmb_sensorfi_tclMsgGpsTemperatureUpReg()
{}

tU32 cmb_sensorfi_tclMsgGpsTemperatureUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsTemperatureUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GpsTemperatureSendPeriod);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsTemperatureUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GpsTemperatureSendPeriod);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsTemperatureUpReg::operator==(const cmb_sensorfi_tclMsgGpsTemperatureUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GpsTemperatureSendPeriod == roRef.GpsTemperatureSendPeriod);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsTemperatureRelUpReg::cmb_sensorfi_tclMsgGpsTemperatureRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsTemperatureRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTEMPERATURERELUPREG;
}


cmb_sensorfi_tclMsgGpsTemperatureRelUpReg::~cmb_sensorfi_tclMsgGpsTemperatureRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsTemperatureStatus::cmb_sensorfi_tclMsgGpsTemperatureStatus(const cmb_sensorfi_tclMsgGpsTemperatureStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsTemperature = coRef.GpsTemperature;
}
cmb_sensorfi_tclMsgGpsTemperatureStatus& cmb_sensorfi_tclMsgGpsTemperatureStatus::operator=(const cmb_sensorfi_tclMsgGpsTemperatureStatus& coRef)
{
   if (this == &coRef) return *this;
   GpsTemperature = coRef.GpsTemperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsTemperatureStatus::cmb_sensorfi_tclMsgGpsTemperatureStatus()
:GpsTemperature(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsTemperatureStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTEMPERATURESTATUS;
}


cmb_sensorfi_tclMsgGpsTemperatureStatus::~cmb_sensorfi_tclMsgGpsTemperatureStatus()
{}

tU32 cmb_sensorfi_tclMsgGpsTemperatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsTemperatureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GpsTemperature);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsTemperatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GpsTemperature);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsTemperatureStatus::operator==(const cmb_sensorfi_tclMsgGpsTemperatureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GpsTemperature == roRef.GpsTemperature);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsFilterModeGet::cmb_sensorfi_tclMsgGpsFilterModeGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsFilterModeGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFILTERMODEGET;
}


cmb_sensorfi_tclMsgGpsFilterModeGet::~cmb_sensorfi_tclMsgGpsFilterModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsFilterModeSet::cmb_sensorfi_tclMsgGpsFilterModeSet(const cmb_sensorfi_tclMsgGpsFilterModeSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsFilterMode = coRef.GpsFilterMode;
}
cmb_sensorfi_tclMsgGpsFilterModeSet& cmb_sensorfi_tclMsgGpsFilterModeSet::operator=(const cmb_sensorfi_tclMsgGpsFilterModeSet& coRef)
{
   if (this == &coRef) return *this;
   GpsFilterMode = coRef.GpsFilterMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsFilterModeSet::cmb_sensorfi_tclMsgGpsFilterModeSet()
:GpsFilterMode(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsFilterModeSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFILTERMODESET;
}


cmb_sensorfi_tclMsgGpsFilterModeSet::~cmb_sensorfi_tclMsgGpsFilterModeSet()
{}

tU32 cmb_sensorfi_tclMsgGpsFilterModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsFilterModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GpsFilterMode);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsFilterModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GpsFilterMode);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsFilterModeSet::operator==(const cmb_sensorfi_tclMsgGpsFilterModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GpsFilterMode == roRef.GpsFilterMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsFilterModeStatus::cmb_sensorfi_tclMsgGpsFilterModeStatus(const cmb_sensorfi_tclMsgGpsFilterModeStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsFilterMode = coRef.GpsFilterMode;
}
cmb_sensorfi_tclMsgGpsFilterModeStatus& cmb_sensorfi_tclMsgGpsFilterModeStatus::operator=(const cmb_sensorfi_tclMsgGpsFilterModeStatus& coRef)
{
   if (this == &coRef) return *this;
   GpsFilterMode = coRef.GpsFilterMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsFilterModeStatus::cmb_sensorfi_tclMsgGpsFilterModeStatus()
:GpsFilterMode(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsFilterModeStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFILTERMODESTATUS;
}


cmb_sensorfi_tclMsgGpsFilterModeStatus::~cmb_sensorfi_tclMsgGpsFilterModeStatus()
{}

tU32 cmb_sensorfi_tclMsgGpsFilterModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsFilterModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GpsFilterMode);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsFilterModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GpsFilterMode);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsFilterModeStatus::operator==(const cmb_sensorfi_tclMsgGpsFilterModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GpsFilterMode == roRef.GpsFilterMode);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgXoCompensationGet::cmb_sensorfi_tclMsgXoCompensationGet()
 {}

tS32 cmb_sensorfi_tclMsgXoCompensationGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_XOCOMPENSATIONGET;
}


cmb_sensorfi_tclMsgXoCompensationGet::~cmb_sensorfi_tclMsgXoCompensationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgXoCompensationSet::cmb_sensorfi_tclMsgXoCompensationSet(const cmb_sensorfi_tclMsgXoCompensationSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   XoData = coRef.XoData;
}
cmb_sensorfi_tclMsgXoCompensationSet& cmb_sensorfi_tclMsgXoCompensationSet::operator=(const cmb_sensorfi_tclMsgXoCompensationSet& coRef)
{
   if (this == &coRef) return *this;
   XoData = coRef.XoData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgXoCompensationSet::cmb_sensorfi_tclMsgXoCompensationSet()
:XoData()
 {}

tS32 cmb_sensorfi_tclMsgXoCompensationSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_XOCOMPENSATIONSET;
}


cmb_sensorfi_tclMsgXoCompensationSet::~cmb_sensorfi_tclMsgXoCompensationSet()
{}

tU32 cmb_sensorfi_tclMsgXoCompensationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 26;
}

fi_tclInContext& cmb_sensorfi_tclMsgXoCompensationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> XoData);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgXoCompensationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << XoData);
   return oOut;
}

tBool cmb_sensorfi_tclMsgXoCompensationSet::operator==(const cmb_sensorfi_tclMsgXoCompensationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (XoData == roRef.XoData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgXoCompensationStatus::cmb_sensorfi_tclMsgXoCompensationStatus(const cmb_sensorfi_tclMsgXoCompensationStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   XoData = coRef.XoData;
}
cmb_sensorfi_tclMsgXoCompensationStatus& cmb_sensorfi_tclMsgXoCompensationStatus::operator=(const cmb_sensorfi_tclMsgXoCompensationStatus& coRef)
{
   if (this == &coRef) return *this;
   XoData = coRef.XoData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgXoCompensationStatus::cmb_sensorfi_tclMsgXoCompensationStatus()
:XoData()
 {}

tS32 cmb_sensorfi_tclMsgXoCompensationStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_XOCOMPENSATIONSTATUS;
}


cmb_sensorfi_tclMsgXoCompensationStatus::~cmb_sensorfi_tclMsgXoCompensationStatus()
{}

tU32 cmb_sensorfi_tclMsgXoCompensationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 26;
}

fi_tclInContext& cmb_sensorfi_tclMsgXoCompensationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> XoData);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgXoCompensationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << XoData);
   return oOut;
}

tBool cmb_sensorfi_tclMsgXoCompensationStatus::operator==(const cmb_sensorfi_tclMsgXoCompensationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (XoData == roRef.XoData);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgAntennaCurrentGet::cmb_sensorfi_tclMsgAntennaCurrentGet()
 {}

tS32 cmb_sensorfi_tclMsgAntennaCurrentGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ANTENNACURRENTGET;
}


cmb_sensorfi_tclMsgAntennaCurrentGet::~cmb_sensorfi_tclMsgAntennaCurrentGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgAntennaCurrentUpReg::cmb_sensorfi_tclMsgAntennaCurrentUpReg()
 {}

tS32 cmb_sensorfi_tclMsgAntennaCurrentUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ANTENNACURRENTUPREG;
}


cmb_sensorfi_tclMsgAntennaCurrentUpReg::~cmb_sensorfi_tclMsgAntennaCurrentUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgAntennaCurrentRelUpReg::cmb_sensorfi_tclMsgAntennaCurrentRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgAntennaCurrentRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ANTENNACURRENTRELUPREG;
}


cmb_sensorfi_tclMsgAntennaCurrentRelUpReg::~cmb_sensorfi_tclMsgAntennaCurrentRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgAntennaCurrentStatus::cmb_sensorfi_tclMsgAntennaCurrentStatus(const cmb_sensorfi_tclMsgAntennaCurrentStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   AntennaCurrent = coRef.AntennaCurrent;
}
cmb_sensorfi_tclMsgAntennaCurrentStatus& cmb_sensorfi_tclMsgAntennaCurrentStatus::operator=(const cmb_sensorfi_tclMsgAntennaCurrentStatus& coRef)
{
   if (this == &coRef) return *this;
   AntennaCurrent = coRef.AntennaCurrent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgAntennaCurrentStatus::cmb_sensorfi_tclMsgAntennaCurrentStatus()
:AntennaCurrent(0)
 {}

tS32 cmb_sensorfi_tclMsgAntennaCurrentStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ANTENNACURRENTSTATUS;
}


cmb_sensorfi_tclMsgAntennaCurrentStatus::~cmb_sensorfi_tclMsgAntennaCurrentStatus()
{}

tU32 cmb_sensorfi_tclMsgAntennaCurrentStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgAntennaCurrentStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AntennaCurrent);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgAntennaCurrentStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AntennaCurrent);
   return oOut;
}

tBool cmb_sensorfi_tclMsgAntennaCurrentStatus::operator==(const cmb_sensorfi_tclMsgAntennaCurrentStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AntennaCurrent == roRef.AntennaCurrent);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroADCBitRangeGet::cmb_sensorfi_tclMsgGyroADCBitRangeGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroADCBitRangeGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROADCBITRANGEGET;
}


cmb_sensorfi_tclMsgGyroADCBitRangeGet::~cmb_sensorfi_tclMsgGyroADCBitRangeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroADCBitRangeSet::cmb_sensorfi_tclMsgGyroADCBitRangeSet(const cmb_sensorfi_tclMsgGyroADCBitRangeSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroADCBitMinValue = coRef.GyroADCBitMinValue;
   GyroADCBitMaxValue = coRef.GyroADCBitMaxValue;
}
cmb_sensorfi_tclMsgGyroADCBitRangeSet& cmb_sensorfi_tclMsgGyroADCBitRangeSet::operator=(const cmb_sensorfi_tclMsgGyroADCBitRangeSet& coRef)
{
   if (this == &coRef) return *this;
   GyroADCBitMinValue = coRef.GyroADCBitMinValue;
   GyroADCBitMaxValue = coRef.GyroADCBitMaxValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroADCBitRangeSet::cmb_sensorfi_tclMsgGyroADCBitRangeSet()
:GyroADCBitMinValue(0)
,GyroADCBitMaxValue(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroADCBitRangeSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROADCBITRANGESET;
}


cmb_sensorfi_tclMsgGyroADCBitRangeSet::~cmb_sensorfi_tclMsgGyroADCBitRangeSet()
{}

tU32 cmb_sensorfi_tclMsgGyroADCBitRangeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroADCBitRangeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroADCBitMinValue);
   (tVoid) (oIn >> GyroADCBitMaxValue);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroADCBitRangeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroADCBitMinValue);
   (tVoid) (oOut << GyroADCBitMaxValue);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroADCBitRangeSet::operator==(const cmb_sensorfi_tclMsgGyroADCBitRangeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroADCBitMinValue == roRef.GyroADCBitMinValue);
   bResult = bResult && (GyroADCBitMaxValue == roRef.GyroADCBitMaxValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroADCBitRangeStatus::cmb_sensorfi_tclMsgGyroADCBitRangeStatus(const cmb_sensorfi_tclMsgGyroADCBitRangeStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroADCBitMinValue = coRef.GyroADCBitMinValue;
   GyroADCBitMaxValue = coRef.GyroADCBitMaxValue;
}
cmb_sensorfi_tclMsgGyroADCBitRangeStatus& cmb_sensorfi_tclMsgGyroADCBitRangeStatus::operator=(const cmb_sensorfi_tclMsgGyroADCBitRangeStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroADCBitMinValue = coRef.GyroADCBitMinValue;
   GyroADCBitMaxValue = coRef.GyroADCBitMaxValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroADCBitRangeStatus::cmb_sensorfi_tclMsgGyroADCBitRangeStatus()
:GyroADCBitMinValue(0)
,GyroADCBitMaxValue(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroADCBitRangeStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROADCBITRANGESTATUS;
}


cmb_sensorfi_tclMsgGyroADCBitRangeStatus::~cmb_sensorfi_tclMsgGyroADCBitRangeStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroADCBitRangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroADCBitRangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroADCBitMinValue);
   (tVoid) (oIn >> GyroADCBitMaxValue);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroADCBitRangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroADCBitMinValue);
   (tVoid) (oOut << GyroADCBitMaxValue);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroADCBitRangeStatus::operator==(const cmb_sensorfi_tclMsgGyroADCBitRangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroADCBitMinValue == roRef.GyroADCBitMinValue);
   bResult = bResult && (GyroADCBitMaxValue == roRef.GyroADCBitMaxValue);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgOsalTimeEventGet::cmb_sensorfi_tclMsgOsalTimeEventGet()
 {}

tS32 cmb_sensorfi_tclMsgOsalTimeEventGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_OSALTIMEEVENTGET;
}


cmb_sensorfi_tclMsgOsalTimeEventGet::~cmb_sensorfi_tclMsgOsalTimeEventGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgOsalTimeEventUpReg::cmb_sensorfi_tclMsgOsalTimeEventUpReg()
 {}

tS32 cmb_sensorfi_tclMsgOsalTimeEventUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_OSALTIMEEVENTUPREG;
}


cmb_sensorfi_tclMsgOsalTimeEventUpReg::~cmb_sensorfi_tclMsgOsalTimeEventUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgOsalTimeEventRelUpReg::cmb_sensorfi_tclMsgOsalTimeEventRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgOsalTimeEventRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_OSALTIMEEVENTRELUPREG;
}


cmb_sensorfi_tclMsgOsalTimeEventRelUpReg::~cmb_sensorfi_tclMsgOsalTimeEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgOsalTimeEventStatus::cmb_sensorfi_tclMsgOsalTimeEventStatus(const cmb_sensorfi_tclMsgOsalTimeEventStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   foo = coRef.foo;
}
cmb_sensorfi_tclMsgOsalTimeEventStatus& cmb_sensorfi_tclMsgOsalTimeEventStatus::operator=(const cmb_sensorfi_tclMsgOsalTimeEventStatus& coRef)
{
   if (this == &coRef) return *this;
   foo = coRef.foo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgOsalTimeEventStatus::cmb_sensorfi_tclMsgOsalTimeEventStatus()
:foo(0)
 {}

tS32 cmb_sensorfi_tclMsgOsalTimeEventStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_OSALTIMEEVENTSTATUS;
}


cmb_sensorfi_tclMsgOsalTimeEventStatus::~cmb_sensorfi_tclMsgOsalTimeEventStatus()
{}

tU32 cmb_sensorfi_tclMsgOsalTimeEventStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgOsalTimeEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> foo);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgOsalTimeEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << foo);
   return oOut;
}

tBool cmb_sensorfi_tclMsgOsalTimeEventStatus::operator==(const cmb_sensorfi_tclMsgOsalTimeEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (foo == roRef.foo);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgOdometerUsageGet::cmb_sensorfi_tclMsgOdometerUsageGet()
 {}

tS32 cmb_sensorfi_tclMsgOdometerUsageGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGEGET;
}


cmb_sensorfi_tclMsgOdometerUsageGet::~cmb_sensorfi_tclMsgOdometerUsageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgOdometerUsageSet::cmb_sensorfi_tclMsgOdometerUsageSet(const cmb_sensorfi_tclMsgOdometerUsageSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   foo = coRef.foo;
}
cmb_sensorfi_tclMsgOdometerUsageSet& cmb_sensorfi_tclMsgOdometerUsageSet::operator=(const cmb_sensorfi_tclMsgOdometerUsageSet& coRef)
{
   if (this == &coRef) return *this;
   foo = coRef.foo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgOdometerUsageSet::cmb_sensorfi_tclMsgOdometerUsageSet()
:foo(0)
 {}

tS32 cmb_sensorfi_tclMsgOdometerUsageSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGESET;
}


cmb_sensorfi_tclMsgOdometerUsageSet::~cmb_sensorfi_tclMsgOdometerUsageSet()
{}

tU32 cmb_sensorfi_tclMsgOdometerUsageSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgOdometerUsageSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> foo);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgOdometerUsageSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << foo);
   return oOut;
}

tBool cmb_sensorfi_tclMsgOdometerUsageSet::operator==(const cmb_sensorfi_tclMsgOdometerUsageSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (foo == roRef.foo);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgOdometerUsageUpReg::cmb_sensorfi_tclMsgOdometerUsageUpReg()
 {}

tS32 cmb_sensorfi_tclMsgOdometerUsageUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGEUPREG;
}


cmb_sensorfi_tclMsgOdometerUsageUpReg::~cmb_sensorfi_tclMsgOdometerUsageUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgOdometerUsageRelUpReg::cmb_sensorfi_tclMsgOdometerUsageRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgOdometerUsageRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGERELUPREG;
}


cmb_sensorfi_tclMsgOdometerUsageRelUpReg::~cmb_sensorfi_tclMsgOdometerUsageRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgOdometerUsageStatus::cmb_sensorfi_tclMsgOdometerUsageStatus(const cmb_sensorfi_tclMsgOdometerUsageStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   foo = coRef.foo;
}
cmb_sensorfi_tclMsgOdometerUsageStatus& cmb_sensorfi_tclMsgOdometerUsageStatus::operator=(const cmb_sensorfi_tclMsgOdometerUsageStatus& coRef)
{
   if (this == &coRef) return *this;
   foo = coRef.foo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgOdometerUsageStatus::cmb_sensorfi_tclMsgOdometerUsageStatus()
:foo(0)
 {}

tS32 cmb_sensorfi_tclMsgOdometerUsageStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERUSAGESTATUS;
}


cmb_sensorfi_tclMsgOdometerUsageStatus::~cmb_sensorfi_tclMsgOdometerUsageStatus()
{}

tU32 cmb_sensorfi_tclMsgOdometerUsageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgOdometerUsageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> foo);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgOdometerUsageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << foo);
   return oOut;
}

tBool cmb_sensorfi_tclMsgOdometerUsageStatus::operator==(const cmb_sensorfi_tclMsgOdometerUsageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (foo == roRef.foo);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsExtDataGet::cmb_sensorfi_tclMsgGpsExtDataGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsExtDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSEXTDATAGET;
}


cmb_sensorfi_tclMsgGpsExtDataGet::~cmb_sensorfi_tclMsgGpsExtDataGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsExtDataUpReg::cmb_sensorfi_tclMsgGpsExtDataUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsExtDataUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSEXTDATAUPREG;
}


cmb_sensorfi_tclMsgGpsExtDataUpReg::~cmb_sensorfi_tclMsgGpsExtDataUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsExtDataRelUpReg::cmb_sensorfi_tclMsgGpsExtDataRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsExtDataRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSEXTDATARELUPREG;
}


cmb_sensorfi_tclMsgGpsExtDataRelUpReg::~cmb_sensorfi_tclMsgGpsExtDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsExtDataStatus::cmb_sensorfi_tclMsgGpsExtDataStatus(const cmb_sensorfi_tclMsgGpsExtDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GpsData = coRef.GpsData;
}
cmb_sensorfi_tclMsgGpsExtDataStatus& cmb_sensorfi_tclMsgGpsExtDataStatus::operator=(const cmb_sensorfi_tclMsgGpsExtDataStatus& coRef)
{
   if (this == &coRef) return *this;
   GpsData = coRef.GpsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGpsExtDataStatus::vDestroy()
{
   GpsData.vDestroy(); 
}

cmb_sensorfi_tclMsgGpsExtDataStatus::cmb_sensorfi_tclMsgGpsExtDataStatus()
:GpsData()
 {}

tS32 cmb_sensorfi_tclMsgGpsExtDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSEXTDATASTATUS;
}


cmb_sensorfi_tclMsgGpsExtDataStatus::~cmb_sensorfi_tclMsgGpsExtDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGpsExtDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+GpsData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsExtDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GpsData);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsExtDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GpsData);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsExtDataStatus::operator==(const cmb_sensorfi_tclMsgGpsExtDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GpsData == roRef.GpsData);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsFrontEndGet::cmb_sensorfi_tclMsgGpsFrontEndGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsFrontEndGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDGET;
}


cmb_sensorfi_tclMsgGpsFrontEndGet::~cmb_sensorfi_tclMsgGpsFrontEndGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsFrontEndUpReg::cmb_sensorfi_tclMsgGpsFrontEndUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsFrontEndUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDUPREG;
}


cmb_sensorfi_tclMsgGpsFrontEndUpReg::~cmb_sensorfi_tclMsgGpsFrontEndUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsFrontEndRelUpReg::cmb_sensorfi_tclMsgGpsFrontEndRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsFrontEndRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDRELUPREG;
}


cmb_sensorfi_tclMsgGpsFrontEndRelUpReg::~cmb_sensorfi_tclMsgGpsFrontEndRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsFrontEndStatus::cmb_sensorfi_tclMsgGpsFrontEndStatus(const cmb_sensorfi_tclMsgGpsFrontEndStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   FrontEndStatus = coRef.FrontEndStatus;
   PinToggle = coRef.PinToggle;
}
cmb_sensorfi_tclMsgGpsFrontEndStatus& cmb_sensorfi_tclMsgGpsFrontEndStatus::operator=(const cmb_sensorfi_tclMsgGpsFrontEndStatus& coRef)
{
   if (this == &coRef) return *this;
   FrontEndStatus = coRef.FrontEndStatus;
   PinToggle = coRef.PinToggle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsFrontEndStatus::cmb_sensorfi_tclMsgGpsFrontEndStatus()
:FrontEndStatus()
,PinToggle(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsFrontEndStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSFRONTENDSTATUS;
}


cmb_sensorfi_tclMsgGpsFrontEndStatus::~cmb_sensorfi_tclMsgGpsFrontEndStatus()
{}

tU32 cmb_sensorfi_tclMsgGpsFrontEndStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsFrontEndStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FrontEndStatus);
   (tVoid) (oIn >> PinToggle);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsFrontEndStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FrontEndStatus);
   (tVoid) (oOut << PinToggle);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsFrontEndStatus::operator==(const cmb_sensorfi_tclMsgGpsFrontEndStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FrontEndStatus == roRef.FrontEndStatus);
   bResult = bResult && (PinToggle == roRef.PinToggle);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsOscillatorGet::cmb_sensorfi_tclMsgGpsOscillatorGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsOscillatorGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSOSCILLATORGET;
}


cmb_sensorfi_tclMsgGpsOscillatorGet::~cmb_sensorfi_tclMsgGpsOscillatorGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsOscillatorUpReg::cmb_sensorfi_tclMsgGpsOscillatorUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsOscillatorUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSOSCILLATORUPREG;
}


cmb_sensorfi_tclMsgGpsOscillatorUpReg::~cmb_sensorfi_tclMsgGpsOscillatorUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsOscillatorRelUpReg::cmb_sensorfi_tclMsgGpsOscillatorRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsOscillatorRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSOSCILLATORRELUPREG;
}


cmb_sensorfi_tclMsgGpsOscillatorRelUpReg::~cmb_sensorfi_tclMsgGpsOscillatorRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsOscillatorStatus::cmb_sensorfi_tclMsgGpsOscillatorStatus(const cmb_sensorfi_tclMsgGpsOscillatorStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   OscillatorFrequency = coRef.OscillatorFrequency;
   TempCompOffset = coRef.TempCompOffset;
   CalcOffset = coRef.CalcOffset;
   IFOffset = coRef.IFOffset;
}
cmb_sensorfi_tclMsgGpsOscillatorStatus& cmb_sensorfi_tclMsgGpsOscillatorStatus::operator=(const cmb_sensorfi_tclMsgGpsOscillatorStatus& coRef)
{
   if (this == &coRef) return *this;
   OscillatorFrequency = coRef.OscillatorFrequency;
   TempCompOffset = coRef.TempCompOffset;
   CalcOffset = coRef.CalcOffset;
   IFOffset = coRef.IFOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsOscillatorStatus::cmb_sensorfi_tclMsgGpsOscillatorStatus()
:OscillatorFrequency(0)
,TempCompOffset(0)
,CalcOffset(0)
,IFOffset(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsOscillatorStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSOSCILLATORSTATUS;
}


cmb_sensorfi_tclMsgGpsOscillatorStatus::~cmb_sensorfi_tclMsgGpsOscillatorStatus()
{}

tU32 cmb_sensorfi_tclMsgGpsOscillatorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsOscillatorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OscillatorFrequency);
   (tVoid) (oIn >> TempCompOffset);
   (tVoid) (oIn >> CalcOffset);
   (tVoid) (oIn >> IFOffset);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsOscillatorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OscillatorFrequency);
   (tVoid) (oOut << TempCompOffset);
   (tVoid) (oOut << CalcOffset);
   (tVoid) (oOut << IFOffset);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsOscillatorStatus::operator==(const cmb_sensorfi_tclMsgGpsOscillatorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OscillatorFrequency == roRef.OscillatorFrequency);
   bResult = bResult && (TempCompOffset == roRef.TempCompOffset);
   bResult = bResult && (CalcOffset == roRef.CalcOffset);
   bResult = bResult && (IFOffset == roRef.IFOffset);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroErrorGet::cmb_sensorfi_tclMsgGyroErrorGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroErrorGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROERRORGET;
}


cmb_sensorfi_tclMsgGyroErrorGet::~cmb_sensorfi_tclMsgGyroErrorGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyroErrorUpReg::cmb_sensorfi_tclMsgGyroErrorUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroErrorUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROERRORUPREG;
}


cmb_sensorfi_tclMsgGyroErrorUpReg::~cmb_sensorfi_tclMsgGyroErrorUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyroErrorRelUpReg::cmb_sensorfi_tclMsgGyroErrorRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroErrorRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROERRORRELUPREG;
}


cmb_sensorfi_tclMsgGyroErrorRelUpReg::~cmb_sensorfi_tclMsgGyroErrorRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroErrorStatus::cmb_sensorfi_tclMsgGyroErrorStatus(const cmb_sensorfi_tclMsgGyroErrorStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   ErrorState = coRef.ErrorState;
}
cmb_sensorfi_tclMsgGyroErrorStatus& cmb_sensorfi_tclMsgGyroErrorStatus::operator=(const cmb_sensorfi_tclMsgGyroErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   ErrorState = coRef.ErrorState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroErrorStatus::cmb_sensorfi_tclMsgGyroErrorStatus()
:ErrorState()
 {}

tS32 cmb_sensorfi_tclMsgGyroErrorStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROERRORSTATUS;
}


cmb_sensorfi_tclMsgGyroErrorStatus::~cmb_sensorfi_tclMsgGyroErrorStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ErrorState);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ErrorState);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroErrorStatus::operator==(const cmb_sensorfi_tclMsgGyroErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ErrorState == roRef.ErrorState);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsTestAdditionalDataGet::cmb_sensorfi_tclMsgGpsTestAdditionalDataGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsTestAdditionalDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTESTADDITIONALDATAGET;
}


cmb_sensorfi_tclMsgGpsTestAdditionalDataGet::~cmb_sensorfi_tclMsgGpsTestAdditionalDataGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg::cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTESTADDITIONALDATAUPREG;
}


cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg::~cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg::cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTESTADDITIONALDATARELUPREG;
}


cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg::~cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus(const cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
}
cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus& cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::operator=(const cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus()
:Data()
 {}

tS32 cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTESTADDITIONALDATASTATUS;
}


cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::~cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus()
{}

tU32 cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus::operator==(const cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsTightCouplingDataGet::cmb_sensorfi_tclMsgGpsTightCouplingDataGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsTightCouplingDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTIGHTCOUPLINGDATAGET;
}


cmb_sensorfi_tclMsgGpsTightCouplingDataGet::~cmb_sensorfi_tclMsgGpsTightCouplingDataGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg::cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTIGHTCOUPLINGDATAUPREG;
}


cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg::~cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg::cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTIGHTCOUPLINGDATARELUPREG;
}


cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg::~cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::cmb_sensorfi_tclMsgGpsTightCouplingDataStatus(const cmb_sensorfi_tclMsgGpsTightCouplingDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
}
cmb_sensorfi_tclMsgGpsTightCouplingDataStatus& cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::operator=(const cmb_sensorfi_tclMsgGpsTightCouplingDataStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::vDestroy()
{
   Data.vDestroy(); 
}

cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::cmb_sensorfi_tclMsgGpsTightCouplingDataStatus()
:Data()
 {}

tS32 cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSTIGHTCOUPLINGDATASTATUS;
}


cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::~cmb_sensorfi_tclMsgGpsTightCouplingDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Data.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsTightCouplingDataStatus::operator==(const cmb_sensorfi_tclMsgGpsTightCouplingDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgAbsDataGet::cmb_sensorfi_tclMsgAbsDataGet()
 {}

tS32 cmb_sensorfi_tclMsgAbsDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ABSDATAGET;
}


cmb_sensorfi_tclMsgAbsDataGet::~cmb_sensorfi_tclMsgAbsDataGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgAbsDataUpReg::cmb_sensorfi_tclMsgAbsDataUpReg()
 {}

tS32 cmb_sensorfi_tclMsgAbsDataUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ABSDATAUPREG;
}


cmb_sensorfi_tclMsgAbsDataUpReg::~cmb_sensorfi_tclMsgAbsDataUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgAbsDataRelUpReg::cmb_sensorfi_tclMsgAbsDataRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgAbsDataRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ABSDATARELUPREG;
}


cmb_sensorfi_tclMsgAbsDataRelUpReg::~cmb_sensorfi_tclMsgAbsDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgAbsDataStatus::cmb_sensorfi_tclMsgAbsDataStatus(const cmb_sensorfi_tclMsgAbsDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   AbsData = coRef.AbsData;
}
cmb_sensorfi_tclMsgAbsDataStatus& cmb_sensorfi_tclMsgAbsDataStatus::operator=(const cmb_sensorfi_tclMsgAbsDataStatus& coRef)
{
   if (this == &coRef) return *this;
   AbsData = coRef.AbsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgAbsDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AbsData.size(); ++u32Idx)
         AbsData[u32Idx].vDestroy();
   AbsData.clear();
   }
}

cmb_sensorfi_tclMsgAbsDataStatus::cmb_sensorfi_tclMsgAbsDataStatus()

 {}

tS32 cmb_sensorfi_tclMsgAbsDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ABSDATASTATUS;
}


cmb_sensorfi_tclMsgAbsDataStatus::~cmb_sensorfi_tclMsgAbsDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgAbsDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(AbsData.size()*20);
}

fi_tclInContext& cmb_sensorfi_tclMsgAbsDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AbsData.size(); ++u32Idx)
      {
         AbsData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AbsData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AbsData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgAbsDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AbsData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AbsData.size(); ++u32Idx)
         (tVoid) (oOut << AbsData[u32Idx]);
   }
   return oOut;
}

tBool cmb_sensorfi_tclMsgAbsDataStatus::operator==(const cmb_sensorfi_tclMsgAbsDataStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AbsData.size() == roRef.AbsData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AbsData.size()); ++u32Idx)
            bResult = bResult && (AbsData[u32Idx] == roRef.AbsData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgSteeringDataGet::cmb_sensorfi_tclMsgSteeringDataGet()
 {}

tS32 cmb_sensorfi_tclMsgSteeringDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_STEERINGDATAGET;
}


cmb_sensorfi_tclMsgSteeringDataGet::~cmb_sensorfi_tclMsgSteeringDataGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgSteeringDataUpReg::cmb_sensorfi_tclMsgSteeringDataUpReg()
 {}

tS32 cmb_sensorfi_tclMsgSteeringDataUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_STEERINGDATAUPREG;
}


cmb_sensorfi_tclMsgSteeringDataUpReg::~cmb_sensorfi_tclMsgSteeringDataUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgSteeringDataRelUpReg::cmb_sensorfi_tclMsgSteeringDataRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgSteeringDataRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_STEERINGDATARELUPREG;
}


cmb_sensorfi_tclMsgSteeringDataRelUpReg::~cmb_sensorfi_tclMsgSteeringDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgSteeringDataStatus::cmb_sensorfi_tclMsgSteeringDataStatus(const cmb_sensorfi_tclMsgSteeringDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   SteeringData = coRef.SteeringData;
}
cmb_sensorfi_tclMsgSteeringDataStatus& cmb_sensorfi_tclMsgSteeringDataStatus::operator=(const cmb_sensorfi_tclMsgSteeringDataStatus& coRef)
{
   if (this == &coRef) return *this;
   SteeringData = coRef.SteeringData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgSteeringDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SteeringData.size(); ++u32Idx)
         SteeringData[u32Idx].vDestroy();
   SteeringData.clear();
   }
}

cmb_sensorfi_tclMsgSteeringDataStatus::cmb_sensorfi_tclMsgSteeringDataStatus()

 {}

tS32 cmb_sensorfi_tclMsgSteeringDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_STEERINGDATASTATUS;
}


cmb_sensorfi_tclMsgSteeringDataStatus::~cmb_sensorfi_tclMsgSteeringDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgSteeringDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SteeringData.size()*14);
}

fi_tclInContext& cmb_sensorfi_tclMsgSteeringDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SteeringData.size(); ++u32Idx)
      {
         SteeringData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SteeringData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SteeringData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgSteeringDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SteeringData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SteeringData.size(); ++u32Idx)
         (tVoid) (oOut << SteeringData[u32Idx]);
   }
   return oOut;
}

tBool cmb_sensorfi_tclMsgSteeringDataStatus::operator==(const cmb_sensorfi_tclMsgSteeringDataStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SteeringData.size() == roRef.SteeringData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SteeringData.size()); ++u32Idx)
            bResult = bResult && (SteeringData[u32Idx] == roRef.SteeringData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgOdometerRangeGet::cmb_sensorfi_tclMsgOdometerRangeGet()
 {}

tS32 cmb_sensorfi_tclMsgOdometerRangeGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERRANGEGET;
}


cmb_sensorfi_tclMsgOdometerRangeGet::~cmb_sensorfi_tclMsgOdometerRangeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgOdometerRangeSet::cmb_sensorfi_tclMsgOdometerRangeSet(const cmb_sensorfi_tclMsgOdometerRangeSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   PulsesPerMeterMin = coRef.PulsesPerMeterMin;
   PulsesPerMeterMax = coRef.PulsesPerMeterMax;
   OdometerRangeStatus = coRef.OdometerRangeStatus;
}
cmb_sensorfi_tclMsgOdometerRangeSet& cmb_sensorfi_tclMsgOdometerRangeSet::operator=(const cmb_sensorfi_tclMsgOdometerRangeSet& coRef)
{
   if (this == &coRef) return *this;
   PulsesPerMeterMin = coRef.PulsesPerMeterMin;
   PulsesPerMeterMax = coRef.PulsesPerMeterMax;
   OdometerRangeStatus = coRef.OdometerRangeStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgOdometerRangeSet::cmb_sensorfi_tclMsgOdometerRangeSet()
:PulsesPerMeterMin(0)
,PulsesPerMeterMax(0)
,OdometerRangeStatus()
 {}

tS32 cmb_sensorfi_tclMsgOdometerRangeSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERRANGESET;
}


cmb_sensorfi_tclMsgOdometerRangeSet::~cmb_sensorfi_tclMsgOdometerRangeSet()
{}

tU32 cmb_sensorfi_tclMsgOdometerRangeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cmb_sensorfi_tclMsgOdometerRangeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PulsesPerMeterMin);
   (tVoid) (oIn >> PulsesPerMeterMax);
   (tVoid) (oIn >> OdometerRangeStatus);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgOdometerRangeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PulsesPerMeterMin);
   (tVoid) (oOut << PulsesPerMeterMax);
   (tVoid) (oOut << OdometerRangeStatus);
   return oOut;
}

tBool cmb_sensorfi_tclMsgOdometerRangeSet::operator==(const cmb_sensorfi_tclMsgOdometerRangeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PulsesPerMeterMin == roRef.PulsesPerMeterMin);
   bResult = bResult && (PulsesPerMeterMax == roRef.PulsesPerMeterMax);
   bResult = bResult && (OdometerRangeStatus == roRef.OdometerRangeStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgOdometerRangeStatus::cmb_sensorfi_tclMsgOdometerRangeStatus(const cmb_sensorfi_tclMsgOdometerRangeStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   PulsesPerMeterMin = coRef.PulsesPerMeterMin;
   PulsesPerMeterMax = coRef.PulsesPerMeterMax;
   OdometerRangeStatus = coRef.OdometerRangeStatus;
}
cmb_sensorfi_tclMsgOdometerRangeStatus& cmb_sensorfi_tclMsgOdometerRangeStatus::operator=(const cmb_sensorfi_tclMsgOdometerRangeStatus& coRef)
{
   if (this == &coRef) return *this;
   PulsesPerMeterMin = coRef.PulsesPerMeterMin;
   PulsesPerMeterMax = coRef.PulsesPerMeterMax;
   OdometerRangeStatus = coRef.OdometerRangeStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgOdometerRangeStatus::cmb_sensorfi_tclMsgOdometerRangeStatus()
:PulsesPerMeterMin(0)
,PulsesPerMeterMax(0)
,OdometerRangeStatus()
 {}

tS32 cmb_sensorfi_tclMsgOdometerRangeStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ODOMETERRANGESTATUS;
}


cmb_sensorfi_tclMsgOdometerRangeStatus::~cmb_sensorfi_tclMsgOdometerRangeStatus()
{}

tU32 cmb_sensorfi_tclMsgOdometerRangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cmb_sensorfi_tclMsgOdometerRangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PulsesPerMeterMin);
   (tVoid) (oIn >> PulsesPerMeterMax);
   (tVoid) (oIn >> OdometerRangeStatus);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgOdometerRangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PulsesPerMeterMin);
   (tVoid) (oOut << PulsesPerMeterMax);
   (tVoid) (oOut << OdometerRangeStatus);
   return oOut;
}

tBool cmb_sensorfi_tclMsgOdometerRangeStatus::operator==(const cmb_sensorfi_tclMsgOdometerRangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PulsesPerMeterMin == roRef.PulsesPerMeterMin);
   bResult = bResult && (PulsesPerMeterMax == roRef.PulsesPerMeterMax);
   bResult = bResult && (OdometerRangeStatus == roRef.OdometerRangeStatus);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroDiagDataGet::cmb_sensorfi_tclMsgGyroDiagDataGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroDiagDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRODIAGDATAGET;
}


cmb_sensorfi_tclMsgGyroDiagDataGet::~cmb_sensorfi_tclMsgGyroDiagDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroDiagDataStatus::cmb_sensorfi_tclMsgGyroDiagDataStatus(const cmb_sensorfi_tclMsgGyroDiagDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroVdd = coRef.GyroVdd;
   GyroValue = coRef.GyroValue;
}
cmb_sensorfi_tclMsgGyroDiagDataStatus& cmb_sensorfi_tclMsgGyroDiagDataStatus::operator=(const cmb_sensorfi_tclMsgGyroDiagDataStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroVdd = coRef.GyroVdd;
   GyroValue = coRef.GyroValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroDiagDataStatus::cmb_sensorfi_tclMsgGyroDiagDataStatus()
:GyroVdd(0)
,GyroValue(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroDiagDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRODIAGDATASTATUS;
}


cmb_sensorfi_tclMsgGyroDiagDataStatus::~cmb_sensorfi_tclMsgGyroDiagDataStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroDiagDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroDiagDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroVdd);
   (tVoid) (oIn >> GyroValue);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroDiagDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroVdd);
   (tVoid) (oOut << GyroValue);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroDiagDataStatus::operator==(const cmb_sensorfi_tclMsgGyroDiagDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroVdd == roRef.GyroVdd);
   bResult = bResult && (GyroValue == roRef.GyroValue);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsDiagPositionGet::cmb_sensorfi_tclMsgGpsDiagPositionGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsDiagPositionGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDIAGPOSITIONGET;
}


cmb_sensorfi_tclMsgGpsDiagPositionGet::~cmb_sensorfi_tclMsgGpsDiagPositionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsDiagPositionSet::cmb_sensorfi_tclMsgGpsDiagPositionSet(const cmb_sensorfi_tclMsgGpsDiagPositionSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   LatDeg = coRef.LatDeg;
   LatMin = coRef.LatMin;
   LatSec = coRef.LatSec;
   LongDeg = coRef.LongDeg;
   LongMin = coRef.LongMin;
   LongSec = coRef.LongSec;
   Altitude = coRef.Altitude;
}
cmb_sensorfi_tclMsgGpsDiagPositionSet& cmb_sensorfi_tclMsgGpsDiagPositionSet::operator=(const cmb_sensorfi_tclMsgGpsDiagPositionSet& coRef)
{
   if (this == &coRef) return *this;
   LatDeg = coRef.LatDeg;
   LatMin = coRef.LatMin;
   LatSec = coRef.LatSec;
   LongDeg = coRef.LongDeg;
   LongMin = coRef.LongMin;
   LongSec = coRef.LongSec;
   Altitude = coRef.Altitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsDiagPositionSet::cmb_sensorfi_tclMsgGpsDiagPositionSet()
:LatDeg(0)
,LatMin(0)
,LatSec(0)
,LongDeg(0)
,LongMin(0)
,LongSec(0)
,Altitude(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsDiagPositionSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDIAGPOSITIONSET;
}


cmb_sensorfi_tclMsgGpsDiagPositionSet::~cmb_sensorfi_tclMsgGpsDiagPositionSet()
{}

tU32 cmb_sensorfi_tclMsgGpsDiagPositionSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsDiagPositionSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LatDeg);
   (tVoid) (oIn >> LatMin);
   (tVoid) (oIn >> LatSec);
   (tVoid) (oIn >> LongDeg);
   (tVoid) (oIn >> LongMin);
   (tVoid) (oIn >> LongSec);
   (tVoid) (oIn >> Altitude);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsDiagPositionSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LatDeg);
   (tVoid) (oOut << LatMin);
   (tVoid) (oOut << LatSec);
   (tVoid) (oOut << LongDeg);
   (tVoid) (oOut << LongMin);
   (tVoid) (oOut << LongSec);
   (tVoid) (oOut << Altitude);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsDiagPositionSet::operator==(const cmb_sensorfi_tclMsgGpsDiagPositionSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LatDeg == roRef.LatDeg);
   bResult = bResult && (LatMin == roRef.LatMin);
   bResult = bResult && (LatSec == roRef.LatSec);
   bResult = bResult && (LongDeg == roRef.LongDeg);
   bResult = bResult && (LongMin == roRef.LongMin);
   bResult = bResult && (LongSec == roRef.LongSec);
   bResult = bResult && (Altitude == roRef.Altitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsDiagPositionStatus::cmb_sensorfi_tclMsgGpsDiagPositionStatus(const cmb_sensorfi_tclMsgGpsDiagPositionStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   LatDeg = coRef.LatDeg;
   LatMin = coRef.LatMin;
   LatSec = coRef.LatSec;
   LongDeg = coRef.LongDeg;
   LongMin = coRef.LongMin;
   LongSec = coRef.LongSec;
   Altitude = coRef.Altitude;
}
cmb_sensorfi_tclMsgGpsDiagPositionStatus& cmb_sensorfi_tclMsgGpsDiagPositionStatus::operator=(const cmb_sensorfi_tclMsgGpsDiagPositionStatus& coRef)
{
   if (this == &coRef) return *this;
   LatDeg = coRef.LatDeg;
   LatMin = coRef.LatMin;
   LatSec = coRef.LatSec;
   LongDeg = coRef.LongDeg;
   LongMin = coRef.LongMin;
   LongSec = coRef.LongSec;
   Altitude = coRef.Altitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsDiagPositionStatus::cmb_sensorfi_tclMsgGpsDiagPositionStatus()
:LatDeg(0)
,LatMin(0)
,LatSec(0)
,LongDeg(0)
,LongMin(0)
,LongSec(0)
,Altitude(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsDiagPositionStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSDIAGPOSITIONSTATUS;
}


cmb_sensorfi_tclMsgGpsDiagPositionStatus::~cmb_sensorfi_tclMsgGpsDiagPositionStatus()
{}

tU32 cmb_sensorfi_tclMsgGpsDiagPositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsDiagPositionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LatDeg);
   (tVoid) (oIn >> LatMin);
   (tVoid) (oIn >> LatSec);
   (tVoid) (oIn >> LongDeg);
   (tVoid) (oIn >> LongMin);
   (tVoid) (oIn >> LongSec);
   (tVoid) (oIn >> Altitude);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsDiagPositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LatDeg);
   (tVoid) (oOut << LatMin);
   (tVoid) (oOut << LatSec);
   (tVoid) (oOut << LongDeg);
   (tVoid) (oOut << LongMin);
   (tVoid) (oOut << LongSec);
   (tVoid) (oOut << Altitude);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsDiagPositionStatus::operator==(const cmb_sensorfi_tclMsgGpsDiagPositionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LatDeg == roRef.LatDeg);
   bResult = bResult && (LatMin == roRef.LatMin);
   bResult = bResult && (LatSec == roRef.LatSec);
   bResult = bResult && (LongDeg == roRef.LongDeg);
   bResult = bResult && (LongMin == roRef.LongMin);
   bResult = bResult && (LongSec == roRef.LongSec);
   bResult = bResult && (Altitude == roRef.Altitude);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgDriveDirectionGet::cmb_sensorfi_tclMsgDriveDirectionGet()
 {}

tS32 cmb_sensorfi_tclMsgDriveDirectionGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DRIVEDIRECTIONGET;
}


cmb_sensorfi_tclMsgDriveDirectionGet::~cmb_sensorfi_tclMsgDriveDirectionGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgDriveDirectionUpReg::cmb_sensorfi_tclMsgDriveDirectionUpReg()
 {}

tS32 cmb_sensorfi_tclMsgDriveDirectionUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DRIVEDIRECTIONUPREG;
}


cmb_sensorfi_tclMsgDriveDirectionUpReg::~cmb_sensorfi_tclMsgDriveDirectionUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgDriveDirectionRelUpReg::cmb_sensorfi_tclMsgDriveDirectionRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgDriveDirectionRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DRIVEDIRECTIONRELUPREG;
}


cmb_sensorfi_tclMsgDriveDirectionRelUpReg::~cmb_sensorfi_tclMsgDriveDirectionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgDriveDirectionStatus::cmb_sensorfi_tclMsgDriveDirectionStatus(const cmb_sensorfi_tclMsgDriveDirectionStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Direction = coRef.Direction;
}
cmb_sensorfi_tclMsgDriveDirectionStatus& cmb_sensorfi_tclMsgDriveDirectionStatus::operator=(const cmb_sensorfi_tclMsgDriveDirectionStatus& coRef)
{
   if (this == &coRef) return *this;
   Direction = coRef.Direction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgDriveDirectionStatus::cmb_sensorfi_tclMsgDriveDirectionStatus()
:Direction()
 {}

tS32 cmb_sensorfi_tclMsgDriveDirectionStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_DRIVEDIRECTIONSTATUS;
}


cmb_sensorfi_tclMsgDriveDirectionStatus::~cmb_sensorfi_tclMsgDriveDirectionStatus()
{}

tU32 cmb_sensorfi_tclMsgDriveDirectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgDriveDirectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Direction);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgDriveDirectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Direction);
   return oOut;
}

tBool cmb_sensorfi_tclMsgDriveDirectionStatus::operator==(const cmb_sensorfi_tclMsgDriveDirectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Direction == roRef.Direction);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGalaSpeedGet::cmb_sensorfi_tclMsgGalaSpeedGet()
 {}

tS32 cmb_sensorfi_tclMsgGalaSpeedGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GALASPEEDGET;
}


cmb_sensorfi_tclMsgGalaSpeedGet::~cmb_sensorfi_tclMsgGalaSpeedGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGalaSpeedUpReg::cmb_sensorfi_tclMsgGalaSpeedUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGalaSpeedUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GALASPEEDUPREG;
}


cmb_sensorfi_tclMsgGalaSpeedUpReg::~cmb_sensorfi_tclMsgGalaSpeedUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGalaSpeedRelUpReg::cmb_sensorfi_tclMsgGalaSpeedRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGalaSpeedRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GALASPEEDRELUPREG;
}


cmb_sensorfi_tclMsgGalaSpeedRelUpReg::~cmb_sensorfi_tclMsgGalaSpeedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGalaSpeedStatus::cmb_sensorfi_tclMsgGalaSpeedStatus(const cmb_sensorfi_tclMsgGalaSpeedStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Speed = coRef.Speed;
}
cmb_sensorfi_tclMsgGalaSpeedStatus& cmb_sensorfi_tclMsgGalaSpeedStatus::operator=(const cmb_sensorfi_tclMsgGalaSpeedStatus& coRef)
{
   if (this == &coRef) return *this;
   Speed = coRef.Speed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGalaSpeedStatus::cmb_sensorfi_tclMsgGalaSpeedStatus()
:Speed(0)
 {}

tS32 cmb_sensorfi_tclMsgGalaSpeedStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GALASPEEDSTATUS;
}


cmb_sensorfi_tclMsgGalaSpeedStatus::~cmb_sensorfi_tclMsgGalaSpeedStatus()
{}

tU32 cmb_sensorfi_tclMsgGalaSpeedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgGalaSpeedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Speed);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGalaSpeedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Speed);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGalaSpeedStatus::operator==(const cmb_sensorfi_tclMsgGalaSpeedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Speed == roRef.Speed);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet::cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet()
 {}

tS32 cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSNOISELEVELTIMEPOSVALIDITYGET;
}


cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet::~cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg::cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSNOISELEVELTIMEPOSVALIDITYUPREG;
}


cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg::~cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg::cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSNOISELEVELTIMEPOSVALIDITYRELUPREG;
}


cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg::~cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   NoiseLevel = coRef.NoiseLevel;
   TimePosValid = coRef.TimePosValid;
}
cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus& cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::operator=(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus& coRef)
{
   if (this == &coRef) return *this;
   NoiseLevel = coRef.NoiseLevel;
   TimePosValid = coRef.TimePosValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus()
:NoiseLevel(0)
,TimePosValid(0)
 {}

tS32 cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GPSNOISELEVELTIMEPOSVALIDITYSTATUS;
}


cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::~cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus()
{}

tU32 cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NoiseLevel);
   (tVoid) (oIn >> TimePosValid);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NoiseLevel);
   (tVoid) (oOut << TimePosValid);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus::operator==(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NoiseLevel == roRef.NoiseLevel);
   bResult = bResult && (TimePosValid == roRef.TimePosValid);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyro3dDiagDataGet::cmb_sensorfi_tclMsgGyro3dDiagDataGet()
 {}

tS32 cmb_sensorfi_tclMsgGyro3dDiagDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRO3DDIAGDATAGET;
}


cmb_sensorfi_tclMsgGyro3dDiagDataGet::~cmb_sensorfi_tclMsgGyro3dDiagDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyro3dDiagDataStatus::cmb_sensorfi_tclMsgGyro3dDiagDataStatus(const cmb_sensorfi_tclMsgGyro3dDiagDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   r_axis = coRef.r_axis;
   s_axis = coRef.s_axis;
   t_axis = coRef.t_axis;
}
cmb_sensorfi_tclMsgGyro3dDiagDataStatus& cmb_sensorfi_tclMsgGyro3dDiagDataStatus::operator=(const cmb_sensorfi_tclMsgGyro3dDiagDataStatus& coRef)
{
   if (this == &coRef) return *this;
   r_axis = coRef.r_axis;
   s_axis = coRef.s_axis;
   t_axis = coRef.t_axis;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyro3dDiagDataStatus::cmb_sensorfi_tclMsgGyro3dDiagDataStatus()
:r_axis(0)
,s_axis(0)
,t_axis(0)
 {}

tS32 cmb_sensorfi_tclMsgGyro3dDiagDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRO3DDIAGDATASTATUS;
}


cmb_sensorfi_tclMsgGyro3dDiagDataStatus::~cmb_sensorfi_tclMsgGyro3dDiagDataStatus()
{}

tU32 cmb_sensorfi_tclMsgGyro3dDiagDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyro3dDiagDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> r_axis);
   (tVoid) (oIn >> s_axis);
   (tVoid) (oIn >> t_axis);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyro3dDiagDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << r_axis);
   (tVoid) (oOut << s_axis);
   (tVoid) (oOut << t_axis);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyro3dDiagDataStatus::operator==(const cmb_sensorfi_tclMsgGyro3dDiagDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (r_axis == roRef.r_axis);
   bResult = bResult && (s_axis == roRef.s_axis);
   bResult = bResult && (t_axis == roRef.t_axis);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgAcc3dDiagDataGet::cmb_sensorfi_tclMsgAcc3dDiagDataGet()
 {}

tS32 cmb_sensorfi_tclMsgAcc3dDiagDataGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ACC3DDIAGDATAGET;
}


cmb_sensorfi_tclMsgAcc3dDiagDataGet::~cmb_sensorfi_tclMsgAcc3dDiagDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgAcc3dDiagDataStatus::cmb_sensorfi_tclMsgAcc3dDiagDataStatus(const cmb_sensorfi_tclMsgAcc3dDiagDataStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   x_axis = coRef.x_axis;
   y_axis = coRef.y_axis;
   z_axis = coRef.z_axis;
}
cmb_sensorfi_tclMsgAcc3dDiagDataStatus& cmb_sensorfi_tclMsgAcc3dDiagDataStatus::operator=(const cmb_sensorfi_tclMsgAcc3dDiagDataStatus& coRef)
{
   if (this == &coRef) return *this;
   x_axis = coRef.x_axis;
   y_axis = coRef.y_axis;
   z_axis = coRef.z_axis;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgAcc3dDiagDataStatus::cmb_sensorfi_tclMsgAcc3dDiagDataStatus()
:x_axis(0)
,y_axis(0)
,z_axis(0)
 {}

tS32 cmb_sensorfi_tclMsgAcc3dDiagDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ACC3DDIAGDATASTATUS;
}


cmb_sensorfi_tclMsgAcc3dDiagDataStatus::~cmb_sensorfi_tclMsgAcc3dDiagDataStatus()
{}

tU32 cmb_sensorfi_tclMsgAcc3dDiagDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cmb_sensorfi_tclMsgAcc3dDiagDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> x_axis);
   (tVoid) (oIn >> y_axis);
   (tVoid) (oIn >> z_axis);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgAcc3dDiagDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << x_axis);
   (tVoid) (oOut << y_axis);
   (tVoid) (oOut << z_axis);
   return oOut;
}

tBool cmb_sensorfi_tclMsgAcc3dDiagDataStatus::operator==(const cmb_sensorfi_tclMsgAcc3dDiagDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (x_axis == roRef.x_axis);
   bResult = bResult && (y_axis == roRef.y_axis);
   bResult = bResult && (z_axis == roRef.z_axis);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyro3dData_UpdateGet::cmb_sensorfi_tclMsgGyro3dData_UpdateGet()
 {}

tS32 cmb_sensorfi_tclMsgGyro3dData_UpdateGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEGET;
}


cmb_sensorfi_tclMsgGyro3dData_UpdateGet::~cmb_sensorfi_tclMsgGyro3dData_UpdateGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg::cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEUPREG;
}


cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg::~cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg::cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRO3DDATA_UPDATERELUPREG;
}


cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg::~cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::cmb_sensorfi_tclMsgGyro3dData_UpdateStatus(const cmb_sensorfi_tclMsgGyro3dData_UpdateStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Gyro3dData = coRef.Gyro3dData;
}
cmb_sensorfi_tclMsgGyro3dData_UpdateStatus& cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::operator=(const cmb_sensorfi_tclMsgGyro3dData_UpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   Gyro3dData = coRef.Gyro3dData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Gyro3dData.size(); ++u32Idx)
         Gyro3dData[u32Idx].vDestroy();
   Gyro3dData.clear();
   }
}

cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::cmb_sensorfi_tclMsgGyro3dData_UpdateStatus()

 {}

tS32 cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYRO3DDATA_UPDATESTATUS;
}


cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::~cmb_sensorfi_tclMsgGyro3dData_UpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Gyro3dData.size()*22);
}

fi_tclInContext& cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Gyro3dData.size(); ++u32Idx)
      {
         Gyro3dData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Gyro3dData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Gyro3dData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Gyro3dData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Gyro3dData.size(); ++u32Idx)
         (tVoid) (oOut << Gyro3dData[u32Idx]);
   }
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyro3dData_UpdateStatus::operator==(const cmb_sensorfi_tclMsgGyro3dData_UpdateStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Gyro3dData.size() == roRef.Gyro3dData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Gyro3dData.size()); ++u32Idx)
            bResult = bResult && (Gyro3dData[u32Idx] == roRef.Gyro3dData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgAcc3dData_UpdateGet::cmb_sensorfi_tclMsgAcc3dData_UpdateGet()
 {}

tS32 cmb_sensorfi_tclMsgAcc3dData_UpdateGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ACC3DDATA_UPDATEGET;
}


cmb_sensorfi_tclMsgAcc3dData_UpdateGet::~cmb_sensorfi_tclMsgAcc3dData_UpdateGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg::cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg()
 {}

tS32 cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ACC3DDATA_UPDATEUPREG;
}


cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg::~cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg::cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ACC3DDATA_UPDATERELUPREG;
}


cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg::~cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::cmb_sensorfi_tclMsgAcc3dData_UpdateStatus(const cmb_sensorfi_tclMsgAcc3dData_UpdateStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   Acc3dData = coRef.Acc3dData;
}
cmb_sensorfi_tclMsgAcc3dData_UpdateStatus& cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::operator=(const cmb_sensorfi_tclMsgAcc3dData_UpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   Acc3dData = coRef.Acc3dData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Acc3dData.size(); ++u32Idx)
         Acc3dData[u32Idx].vDestroy();
   Acc3dData.clear();
   }
}

cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::cmb_sensorfi_tclMsgAcc3dData_UpdateStatus()

 {}

tS32 cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_ACC3DDATA_UPDATESTATUS;
}


cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::~cmb_sensorfi_tclMsgAcc3dData_UpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Acc3dData.size()*22);
}

fi_tclInContext& cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Acc3dData.size(); ++u32Idx)
      {
         Acc3dData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Acc3dData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Acc3dData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Acc3dData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Acc3dData.size(); ++u32Idx)
         (tVoid) (oOut << Acc3dData[u32Idx]);
   }
   return oOut;
}

tBool cmb_sensorfi_tclMsgAcc3dData_UpdateStatus::operator==(const cmb_sensorfi_tclMsgAcc3dData_UpdateStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Acc3dData.size() == roRef.Acc3dData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Acc3dData.size()); ++u32Idx)
            bResult = bResult && (Acc3dData[u32Idx] == roRef.Acc3dData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGyroTemperatureGet::cmb_sensorfi_tclMsgGyroTemperatureGet()
 {}

tS32 cmb_sensorfi_tclMsgGyroTemperatureGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROTEMPERATUREGET;
}


cmb_sensorfi_tclMsgGyroTemperatureGet::~cmb_sensorfi_tclMsgGyroTemperatureGet()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyroTemperatureUpReg::cmb_sensorfi_tclMsgGyroTemperatureUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroTemperatureUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROTEMPERATUREUPREG;
}


cmb_sensorfi_tclMsgGyroTemperatureUpReg::~cmb_sensorfi_tclMsgGyroTemperatureUpReg()
{}

//=============================================================================

cmb_sensorfi_tclMsgGyroTemperatureRelUpReg::cmb_sensorfi_tclMsgGyroTemperatureRelUpReg()
 {}

tS32 cmb_sensorfi_tclMsgGyroTemperatureRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROTEMPERATURERELUPREG;
}


cmb_sensorfi_tclMsgGyroTemperatureRelUpReg::~cmb_sensorfi_tclMsgGyroTemperatureRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGyroTemperatureStatus::cmb_sensorfi_tclMsgGyroTemperatureStatus(const cmb_sensorfi_tclMsgGyroTemperatureStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   GyroTemperature = coRef.GyroTemperature;
}
cmb_sensorfi_tclMsgGyroTemperatureStatus& cmb_sensorfi_tclMsgGyroTemperatureStatus::operator=(const cmb_sensorfi_tclMsgGyroTemperatureStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroTemperature = coRef.GyroTemperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGyroTemperatureStatus::cmb_sensorfi_tclMsgGyroTemperatureStatus()
:GyroTemperature(0)
 {}

tS32 cmb_sensorfi_tclMsgGyroTemperatureStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GYROTEMPERATURESTATUS;
}


cmb_sensorfi_tclMsgGyroTemperatureStatus::~cmb_sensorfi_tclMsgGyroTemperatureStatus()
{}

tU32 cmb_sensorfi_tclMsgGyroTemperatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_sensorfi_tclMsgGyroTemperatureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroTemperature);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGyroTemperatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroTemperature);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGyroTemperatureStatus::operator==(const cmb_sensorfi_tclMsgGyroTemperatureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroTemperature == roRef.GyroTemperature);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGnssSatSystemGet::cmb_sensorfi_tclMsgGnssSatSystemGet()
 {}

tS32 cmb_sensorfi_tclMsgGnssSatSystemGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GNSSSATSYSTEMGET;
}


cmb_sensorfi_tclMsgGnssSatSystemGet::~cmb_sensorfi_tclMsgGnssSatSystemGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGnssSatSystemSet::cmb_sensorfi_tclMsgGnssSatSystemSet(const cmb_sensorfi_tclMsgGnssSatSystemSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TargetGnssSatSys = coRef.TargetGnssSatSys;
}
cmb_sensorfi_tclMsgGnssSatSystemSet& cmb_sensorfi_tclMsgGnssSatSystemSet::operator=(const cmb_sensorfi_tclMsgGnssSatSystemSet& coRef)
{
   if (this == &coRef) return *this;
   TargetGnssSatSys = coRef.TargetGnssSatSys;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGnssSatSystemSet::cmb_sensorfi_tclMsgGnssSatSystemSet()
:TargetGnssSatSys()
 {}

tS32 cmb_sensorfi_tclMsgGnssSatSystemSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GNSSSATSYSTEMSET;
}


cmb_sensorfi_tclMsgGnssSatSystemSet::~cmb_sensorfi_tclMsgGnssSatSystemSet()
{}

tU32 cmb_sensorfi_tclMsgGnssSatSystemSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGnssSatSystemSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TargetGnssSatSys);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGnssSatSystemSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TargetGnssSatSys);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGnssSatSystemSet::operator==(const cmb_sensorfi_tclMsgGnssSatSystemSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TargetGnssSatSys == roRef.TargetGnssSatSys);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGnssSatSystemStatus::cmb_sensorfi_tclMsgGnssSatSystemStatus(const cmb_sensorfi_tclMsgGnssSatSystemStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   ActualGnssSatSys = coRef.ActualGnssSatSys;
}
cmb_sensorfi_tclMsgGnssSatSystemStatus& cmb_sensorfi_tclMsgGnssSatSystemStatus::operator=(const cmb_sensorfi_tclMsgGnssSatSystemStatus& coRef)
{
   if (this == &coRef) return *this;
   ActualGnssSatSys = coRef.ActualGnssSatSys;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGnssSatSystemStatus::cmb_sensorfi_tclMsgGnssSatSystemStatus()
:ActualGnssSatSys()
 {}

tS32 cmb_sensorfi_tclMsgGnssSatSystemStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GNSSSATSYSTEMSTATUS;
}


cmb_sensorfi_tclMsgGnssSatSystemStatus::~cmb_sensorfi_tclMsgGnssSatSystemStatus()
{}

tU32 cmb_sensorfi_tclMsgGnssSatSystemStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgGnssSatSystemStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActualGnssSatSys);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGnssSatSystemStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActualGnssSatSys);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGnssSatSystemStatus::operator==(const cmb_sensorfi_tclMsgGnssSatSystemStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActualGnssSatSys == roRef.ActualGnssSatSys);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgGnssWnEpochGet::cmb_sensorfi_tclMsgGnssWnEpochGet()
 {}

tS32 cmb_sensorfi_tclMsgGnssWnEpochGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GNSSWNEPOCHGET;
}


cmb_sensorfi_tclMsgGnssWnEpochGet::~cmb_sensorfi_tclMsgGnssWnEpochGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGnssWnEpochSet::cmb_sensorfi_tclMsgGnssWnEpochSet(const cmb_sensorfi_tclMsgGnssWnEpochSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   TargetWnDate = coRef.TargetWnDate;
}
cmb_sensorfi_tclMsgGnssWnEpochSet& cmb_sensorfi_tclMsgGnssWnEpochSet::operator=(const cmb_sensorfi_tclMsgGnssWnEpochSet& coRef)
{
   if (this == &coRef) return *this;
   TargetWnDate = coRef.TargetWnDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGnssWnEpochSet::cmb_sensorfi_tclMsgGnssWnEpochSet()
:TargetWnDate()
 {}

tS32 cmb_sensorfi_tclMsgGnssWnEpochSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GNSSWNEPOCHSET;
}


cmb_sensorfi_tclMsgGnssWnEpochSet::~cmb_sensorfi_tclMsgGnssWnEpochSet()
{}

tU32 cmb_sensorfi_tclMsgGnssWnEpochSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_sensorfi_tclMsgGnssWnEpochSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TargetWnDate);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGnssWnEpochSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TargetWnDate);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGnssWnEpochSet::operator==(const cmb_sensorfi_tclMsgGnssWnEpochSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TargetWnDate == roRef.TargetWnDate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgGnssWnEpochStatus::cmb_sensorfi_tclMsgGnssWnEpochStatus(const cmb_sensorfi_tclMsgGnssWnEpochStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   ActualWnDate = coRef.ActualWnDate;
}
cmb_sensorfi_tclMsgGnssWnEpochStatus& cmb_sensorfi_tclMsgGnssWnEpochStatus::operator=(const cmb_sensorfi_tclMsgGnssWnEpochStatus& coRef)
{
   if (this == &coRef) return *this;
   ActualWnDate = coRef.ActualWnDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgGnssWnEpochStatus::cmb_sensorfi_tclMsgGnssWnEpochStatus()
:ActualWnDate()
 {}

tS32 cmb_sensorfi_tclMsgGnssWnEpochStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_GNSSWNEPOCHSTATUS;
}


cmb_sensorfi_tclMsgGnssWnEpochStatus::~cmb_sensorfi_tclMsgGnssWnEpochStatus()
{}

tU32 cmb_sensorfi_tclMsgGnssWnEpochStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_sensorfi_tclMsgGnssWnEpochStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActualWnDate);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgGnssWnEpochStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActualWnDate);
   return oOut;
}

tBool cmb_sensorfi_tclMsgGnssWnEpochStatus::operator==(const cmb_sensorfi_tclMsgGnssWnEpochStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActualWnDate == roRef.ActualWnDate);
   return bResult;
}

//=============================================================================

cmb_sensorfi_tclMsgTimeModeGet::cmb_sensorfi_tclMsgTimeModeGet()
 {}

tS32 cmb_sensorfi_tclMsgTimeModeGet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TIMEMODEGET;
}


cmb_sensorfi_tclMsgTimeModeGet::~cmb_sensorfi_tclMsgTimeModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTimeModeSet::cmb_sensorfi_tclMsgTimeModeSet(const cmb_sensorfi_tclMsgTimeModeSet& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   targetTimeMode = coRef.targetTimeMode;
   targetTimeDate = coRef.targetTimeDate;
}
cmb_sensorfi_tclMsgTimeModeSet& cmb_sensorfi_tclMsgTimeModeSet::operator=(const cmb_sensorfi_tclMsgTimeModeSet& coRef)
{
   if (this == &coRef) return *this;
   targetTimeMode = coRef.targetTimeMode;
   targetTimeDate = coRef.targetTimeDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTimeModeSet::cmb_sensorfi_tclMsgTimeModeSet()
:targetTimeMode()
,targetTimeDate()
 {}

tS32 cmb_sensorfi_tclMsgTimeModeSet::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TIMEMODESET;
}


cmb_sensorfi_tclMsgTimeModeSet::~cmb_sensorfi_tclMsgTimeModeSet()
{}

tU32 cmb_sensorfi_tclMsgTimeModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cmb_sensorfi_tclMsgTimeModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> targetTimeMode);
   (tVoid) (oIn >> targetTimeDate);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTimeModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << targetTimeMode);
   (tVoid) (oOut << targetTimeDate);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTimeModeSet::operator==(const cmb_sensorfi_tclMsgTimeModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (targetTimeMode == roRef.targetTimeMode);
   bResult = bResult && (targetTimeDate == roRef.targetTimeDate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_sensorfi_tclMsgTimeModeStatus::cmb_sensorfi_tclMsgTimeModeStatus(const cmb_sensorfi_tclMsgTimeModeStatus& coRef)
   : cmb_sensorfi_tclMsgBaseMessage(coRef)
{
   actualTimeMode = coRef.actualTimeMode;
}
cmb_sensorfi_tclMsgTimeModeStatus& cmb_sensorfi_tclMsgTimeModeStatus::operator=(const cmb_sensorfi_tclMsgTimeModeStatus& coRef)
{
   if (this == &coRef) return *this;
   actualTimeMode = coRef.actualTimeMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_sensorfi_tclMsgTimeModeStatus::cmb_sensorfi_tclMsgTimeModeStatus()
:actualTimeMode()
 {}

tS32 cmb_sensorfi_tclMsgTimeModeStatus::s32GetTypeId() const
{
   return (tS32) cmb_sensorfi_tclToken::EN_MSG_TIMEMODESTATUS;
}


cmb_sensorfi_tclMsgTimeModeStatus::~cmb_sensorfi_tclMsgTimeModeStatus()
{}

tU32 cmb_sensorfi_tclMsgTimeModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_sensorfi_tclMsgTimeModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> actualTimeMode);
   return oIn;
}

fi_tclOutContext& cmb_sensorfi_tclMsgTimeModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << actualTimeMode);
   return oOut;
}

tBool cmb_sensorfi_tclMsgTimeModeStatus::operator==(const cmb_sensorfi_tclMsgTimeModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (actualTimeMode == roRef.actualTimeMode);
   return bResult;
}

