#ifndef CLOCK_FIVISITOR_HEADER
#define CLOCK_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class clock_fi_tclOutput {
public:
   clock_fi_tclOutput();
   virtual ~clock_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class clock_fi_tclFileOutput : public clock_fi_tclOutput 
{
public:
   clock_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   clock_fi_tclFileOutput(); //lint !e1704
   clock_fi_tclFileOutput& operator=(const clock_fi_tclFileOutput& coRef);
   clock_fi_tclFileOutput(const clock_fi_tclFileOutput& coRef); //lint !e1704
};

class clock_fi_tclMemOutput : public clock_fi_tclOutput
{
public:
   clock_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~clock_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   clock_fi_tclMemOutput(); //lint !e1704
   clock_fi_tclMemOutput(const clock_fi_tclMemOutput& coRef); //lint !e1704
   clock_fi_tclMemOutput& operator=(const clock_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL clock_fi_tclVisitorBase {
public:

   // --Konstruktor
   clock_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~clock_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(clock_fi_tclU8& oU8);
   virtual tVoid vVisitS8(clock_fi_tclS8& oS8);
   virtual tVoid vVisitU16(clock_fi_tclU16& oU16);
   virtual tVoid vVisitS16(clock_fi_tclS16& oS16);
   virtual tVoid vVisitU24(clock_fi_tclU24& oU24);
   virtual tVoid vVisitS24(clock_fi_tclS24& oS24);
   virtual tVoid vVisitU32(clock_fi_tclU32& oU32);
   virtual tVoid vVisitS32(clock_fi_tclS32& oS32);
   virtual tVoid vVisitU64(clock_fi_tclU64& oU64);
   virtual tVoid vVisitS64(clock_fi_tclS64& oS64);
   virtual tVoid vVisitF32(clock_fi_tclF32& oF32);
   virtual tVoid vVisitF64(clock_fi_tclF64& oF64);
   virtual tVoid vVisitBool(clock_fi_tclBool& oBool);
   virtual tVoid vVisitString(clock_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(clock_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(clock_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(clock_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(clock_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(clock_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(clock_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(clock_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(clock_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(clock_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(clock_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(clock_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(clock_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(clock_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(clock_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(clock_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(clock_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(clock_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(clock_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(clock_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(clock_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(clock_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(clock_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(clock_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(clock_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(clock_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(clock_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(clock_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(clock_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(clock_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(clock_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(clock_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(clock_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(clock_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(clock_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(clock_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(clock_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(clock_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(clock_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(clock_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(clock_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(clock_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(clock_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(clock_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(clock_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(clock_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(clock_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(clock_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(clock_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(clock_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_DefSetMode(clock_fi_tcl_e8_DefSetMode& oe8_DefSetMode);

   virtual tVoid vVisit_e8_DefSetServiceStatus(clock_fi_tcl_e8_DefSetServiceStatus& oe8_DefSetServiceStatus);

   virtual tVoid vVisit_e8_DefSetGroups(clock_fi_tcl_e8_DefSetGroups& oe8_DefSetGroups);

   virtual tVoid vVisit_e8_RCtrlSource(clock_fi_tcl_e8_RCtrlSource& oe8_RCtrlSource);

   virtual tVoid vVisit_e8_RCtrlCommand(clock_fi_tcl_e8_RCtrlCommand& oe8_RCtrlCommand);

   virtual tVoid vVisit_e8_RCtrlSignal(clock_fi_tcl_e8_RCtrlSignal& oe8_RCtrlSignal);

   virtual tVoid vVisit_e8_MCanUnitType(clock_fi_tcl_e8_MCanUnitType& oe8_MCanUnitType);

   virtual tVoid vVisit_e8_UnitType(clock_fi_tcl_e8_UnitType& oe8_UnitType);

   virtual tVoid vVisit_SWC_UnitConnectionStatus(clock_fi_tcl_SWC_UnitConnectionStatus& oSWC_UnitConnectionStatus);

   virtual tVoid vVisit_VdClock_VersionInfo(clock_fi_tcl_VdClock_VersionInfo& oVdClock_VersionInfo);

   virtual tVoid vVisit_VdClock_UnitVersion(clock_fi_tcl_VdClock_UnitVersion& oVdClock_UnitVersion);

   virtual tVoid vVisitDCLK_TEN_ClockSourceStatus(clock_fi_tclDCLK_TEN_ClockSourceStatus& oCLK_TEN_ClockSourceStatus);

   virtual tVoid vVisitDCLK_TEN_DateFormat(clock_fi_tclDCLK_TEN_DateFormat& oCLK_TEN_DateFormat);

   virtual tVoid vVisitDCLK_TEN_DST_Setting(clock_fi_tclDCLK_TEN_DST_Setting& oCLK_TEN_DST_Setting);

   virtual tVoid vVisitDCLK_TEN_FormatSourceStatus(clock_fi_tclDCLK_TEN_FormatSourceStatus& oCLK_TEN_FormatSourceStatus);

   virtual tVoid vVisitDCLK_TEN_GPS_EPOCH(clock_fi_tclDCLK_TEN_GPS_EPOCH& oCLK_TEN_GPS_EPOCH);

   virtual tVoid vVisitDCLK_TEN_GPSRTCTIMESTATE(clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE& oCLK_TEN_GPSRTCTIMESTATE);

   virtual tVoid vVisitDCLK_TEN_NewDateFormat(clock_fi_tclDCLK_TEN_NewDateFormat& oCLK_TEN_NewDateFormat);

   virtual tVoid vVisitDCLK_TEN_SyncMode(clock_fi_tclDCLK_TEN_SyncMode& oCLK_TEN_SyncMode);

   virtual tVoid vVisitDCLK_TEN_TimeDateStatus(clock_fi_tclDCLK_TEN_TimeDateStatus& oCLK_TEN_TimeDateStatus);

   virtual tVoid vVisitDCLK_TEN_TimeFormat(clock_fi_tclDCLK_TEN_TimeFormat& oCLK_TEN_TimeFormat);

   virtual tVoid vVisitDCLK_TEN_TIMEZONE_Setting(clock_fi_tclDCLK_TEN_TIMEZONE_Setting& oCLK_TEN_TIMEZONE_Setting);

   virtual tVoid vVisitDCLK_TEN_HUD_ActivationSettings(clock_fi_tclDCLK_TEN_HUD_ActivationSettings& oCLK_TEN_HUD_ActivationSettings);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
