/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CLOCK_MAINFITYPES_HEADER
#define CLOCK_MAINFITYPES_HEADER


class clock_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for clock_main_fi message types

fi_tclMessageBase* clock_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class clock_mainfi_tclMsgBaseMessage : public clock_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   clock_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart();

   virtual ~clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart();

   inline tBool operator==(const clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult& operator=(const clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult& coRef);
   clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult(const clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<clock_fi_tclString, std::allocator<clock_fi_tclString> > aszDescriptions;
   std::vector<tU16, std::allocator<tU16> > u16Indexes;
   virtual ~clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGetTimeDateFromValueMethodStart : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGetTimeDateFromValueMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& operator=(const clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& coRef);
   clock_mainfi_tclMsgGetTimeDateFromValueMethodStart(const clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32TimeDateValue;
   tU8 u8SourceDomain;
   tU8 u8TargetDomain;
   virtual ~clock_mainfi_tclMsgGetTimeDateFromValueMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGetTimeDateFromValueMethodResult : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGetTimeDateFromValueMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGetTimeDateFromValueMethodResult& operator=(const clock_mainfi_tclMsgGetTimeDateFromValueMethodResult& coRef);
   clock_mainfi_tclMsgGetTimeDateFromValueMethodResult(const clock_mainfi_tclMsgGetTimeDateFromValueMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   virtual ~clock_mainfi_tclMsgGetTimeDateFromValueMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGetTimeDateFromValueMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGetDaysPerMonthMethodStart : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGetDaysPerMonthMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGetDaysPerMonthMethodStart& operator=(const clock_mainfi_tclMsgGetDaysPerMonthMethodStart& coRef);
   clock_mainfi_tclMsgGetDaysPerMonthMethodStart(const clock_mainfi_tclMsgGetDaysPerMonthMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   virtual ~clock_mainfi_tclMsgGetDaysPerMonthMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGetDaysPerMonthMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGetDaysPerMonthMethodResult : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGetDaysPerMonthMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGetDaysPerMonthMethodResult& operator=(const clock_mainfi_tclMsgGetDaysPerMonthMethodResult& coRef);
   clock_mainfi_tclMsgGetDaysPerMonthMethodResult(const clock_mainfi_tclMsgGetDaysPerMonthMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumberOfDays;
   virtual ~clock_mainfi_tclMsgGetDaysPerMonthMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGetDaysPerMonthMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& operator=(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& coRef);
   clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tcl_e8_DefSetGroups DefSetStateGroup;
   clock_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& operator=(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& coRef);
   clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tcl_e8_DefSetGroups DefSetStateGroup;
   clock_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool Status;
   virtual ~clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgResetHistoryMethodStart : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgResetHistoryMethodStart();

   virtual ~clock_mainfi_tclMsgResetHistoryMethodStart();

   inline tBool operator==(const clock_mainfi_tclMsgResetHistoryMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgResetHistoryMethodResult : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgResetHistoryMethodResult();

   virtual ~clock_mainfi_tclMsgResetHistoryMethodResult();

   inline tBool operator==(const clock_mainfi_tclMsgResetHistoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgVersionInfoMethodStart : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgVersionInfoMethodStart();

   virtual ~clock_mainfi_tclMsgVersionInfoMethodStart();

   inline tBool operator==(const clock_mainfi_tclMsgVersionInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgVersionInfoMethodResult : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgVersionInfoMethodResult();

   virtual ~clock_mainfi_tclMsgVersionInfoMethodResult();

   inline tBool operator==(const clock_mainfi_tclMsgVersionInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZoneGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZoneGet();

   virtual ~clock_mainfi_tclMsgTimeZoneGet();

   inline tBool operator==(const clock_mainfi_tclMsgTimeZoneGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZoneSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZoneSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgTimeZoneSet& operator=(const clock_mainfi_tclMsgTimeZoneSet& coRef);
   clock_mainfi_tclMsgTimeZoneSet(const clock_mainfi_tclMsgTimeZoneSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Index;
   virtual ~clock_mainfi_tclMsgTimeZoneSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgTimeZoneSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZoneUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZoneUpReg();

   virtual ~clock_mainfi_tclMsgTimeZoneUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgTimeZoneUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZoneRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZoneRelUpReg();

   virtual ~clock_mainfi_tclMsgTimeZoneRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgTimeZoneRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZoneStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZoneStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgTimeZoneStatus& operator=(const clock_mainfi_tclMsgTimeZoneStatus& coRef);
   clock_mainfi_tclMsgTimeZoneStatus(const clock_mainfi_tclMsgTimeZoneStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Index;
   clock_fi_tclString szDescription;
   virtual ~clock_mainfi_tclMsgTimeZoneStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgTimeZoneStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDaylightSavingTimeGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDaylightSavingTimeGet();

   virtual ~clock_mainfi_tclMsgDaylightSavingTimeGet();

   inline tBool operator==(const clock_mainfi_tclMsgDaylightSavingTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDaylightSavingTimeSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDaylightSavingTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgDaylightSavingTimeSet& operator=(const clock_mainfi_tclMsgDaylightSavingTimeSet& coRef);
   clock_mainfi_tclMsgDaylightSavingTimeSet(const clock_mainfi_tclMsgDaylightSavingTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_DST_Setting enDST_Setting;
   virtual ~clock_mainfi_tclMsgDaylightSavingTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgDaylightSavingTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDaylightSavingTimeUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDaylightSavingTimeUpReg();

   virtual ~clock_mainfi_tclMsgDaylightSavingTimeUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgDaylightSavingTimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDaylightSavingTimeRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDaylightSavingTimeRelUpReg();

   virtual ~clock_mainfi_tclMsgDaylightSavingTimeRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgDaylightSavingTimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDaylightSavingTimeStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDaylightSavingTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgDaylightSavingTimeStatus& operator=(const clock_mainfi_tclMsgDaylightSavingTimeStatus& coRef);
   clock_mainfi_tclMsgDaylightSavingTimeStatus(const clock_mainfi_tclMsgDaylightSavingTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDST_Status;
   tBool bDST_AutoAdjust;
   clock_fi_tclDCLK_TEN_DST_Setting enDST_Status;
   virtual ~clock_mainfi_tclMsgDaylightSavingTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgDaylightSavingTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_AutoSyncGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_AutoSyncGet();

   virtual ~clock_mainfi_tclMsgGPS_AutoSyncGet();

   inline tBool operator==(const clock_mainfi_tclMsgGPS_AutoSyncGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_AutoSyncSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_AutoSyncSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGPS_AutoSyncSet& operator=(const clock_mainfi_tclMsgGPS_AutoSyncSet& coRef);
   clock_mainfi_tclMsgGPS_AutoSyncSet(const clock_mainfi_tclMsgGPS_AutoSyncSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnabled;
   tBool bPositionBased;
   virtual ~clock_mainfi_tclMsgGPS_AutoSyncSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGPS_AutoSyncSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_AutoSyncUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_AutoSyncUpReg();

   virtual ~clock_mainfi_tclMsgGPS_AutoSyncUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgGPS_AutoSyncUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_AutoSyncRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_AutoSyncRelUpReg();

   virtual ~clock_mainfi_tclMsgGPS_AutoSyncRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgGPS_AutoSyncRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_AutoSyncStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_AutoSyncStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGPS_AutoSyncStatus& operator=(const clock_mainfi_tclMsgGPS_AutoSyncStatus& coRef);
   clock_mainfi_tclMsgGPS_AutoSyncStatus(const clock_mainfi_tclMsgGPS_AutoSyncStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnabled;
   tBool bPositionBased;
   virtual ~clock_mainfi_tclMsgGPS_AutoSyncStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGPS_AutoSyncStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSyncModeGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSyncModeGet();

   virtual ~clock_mainfi_tclMsgSyncModeGet();

   inline tBool operator==(const clock_mainfi_tclMsgSyncModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSyncModeSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSyncModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgSyncModeSet& operator=(const clock_mainfi_tclMsgSyncModeSet& coRef);
   clock_mainfi_tclMsgSyncModeSet(const clock_mainfi_tclMsgSyncModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_SyncMode enMode;
   virtual ~clock_mainfi_tclMsgSyncModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgSyncModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSyncModeUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSyncModeUpReg();

   virtual ~clock_mainfi_tclMsgSyncModeUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgSyncModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSyncModeRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSyncModeRelUpReg();

   virtual ~clock_mainfi_tclMsgSyncModeRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgSyncModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSyncModeStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSyncModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgSyncModeStatus& operator=(const clock_mainfi_tclMsgSyncModeStatus& coRef);
   clock_mainfi_tclMsgSyncModeStatus(const clock_mainfi_tclMsgSyncModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_SyncMode enMode;
   virtual ~clock_mainfi_tclMsgSyncModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgSyncModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_WeekEpochGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_WeekEpochGet();

   virtual ~clock_mainfi_tclMsgGPS_WeekEpochGet();

   inline tBool operator==(const clock_mainfi_tclMsgGPS_WeekEpochGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_WeekEpochSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_WeekEpochSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGPS_WeekEpochSet& operator=(const clock_mainfi_tclMsgGPS_WeekEpochSet& coRef);
   clock_mainfi_tclMsgGPS_WeekEpochSet(const clock_mainfi_tclMsgGPS_WeekEpochSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch;
   virtual ~clock_mainfi_tclMsgGPS_WeekEpochSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGPS_WeekEpochSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_WeekEpochUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_WeekEpochUpReg();

   virtual ~clock_mainfi_tclMsgGPS_WeekEpochUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgGPS_WeekEpochUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_WeekEpochRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_WeekEpochRelUpReg();

   virtual ~clock_mainfi_tclMsgGPS_WeekEpochRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgGPS_WeekEpochRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgGPS_WeekEpochStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgGPS_WeekEpochStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgGPS_WeekEpochStatus& operator=(const clock_mainfi_tclMsgGPS_WeekEpochStatus& coRef);
   clock_mainfi_tclMsgGPS_WeekEpochStatus(const clock_mainfi_tclMsgGPS_WeekEpochStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch;
   virtual ~clock_mainfi_tclMsgGPS_WeekEpochStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgGPS_WeekEpochStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeOffsetUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeOffsetUpReg();

   virtual ~clock_mainfi_tclMsgLocalTimeOffsetUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgLocalTimeOffsetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeOffsetRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeOffsetRelUpReg();

   virtual ~clock_mainfi_tclMsgLocalTimeOffsetRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgLocalTimeOffsetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeOffsetGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeOffsetGet();

   virtual ~clock_mainfi_tclMsgLocalTimeOffsetGet();

   inline tBool operator==(const clock_mainfi_tclMsgLocalTimeOffsetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeOffsetStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeOffsetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgLocalTimeOffsetStatus& operator=(const clock_mainfi_tclMsgLocalTimeOffsetStatus& coRef);
   clock_mainfi_tclMsgLocalTimeOffsetStatus(const clock_mainfi_tclMsgLocalTimeOffsetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS64 s64Offset_ScalarValue;
   tBool bIsOffsetPostive;
   tS16 s16Offset_Year;
   tU8 u8Offset_Month;
   tU8 u8Offset_Day;
   tU8 u8Offset_Hour;
   tU8 u8Offset_Minute;
   tU8 u8Offset_Second;
   tU32 u32UTCTimeDate_ScalarValue;
   tS16 s16UTCTimeDate_Year;
   tU8 u8UTCTimeDate_Month;
   tU8 u8UTCTimeDate_Day;
   tU8 u8UTCTimeDate_Hour;
   tU8 u8UTCTimeDate_Minute;
   tU8 u8UTCTimeDate_Second;
   tU8 u8UTCTimeDate_Weekday;
   clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState;
   virtual ~clock_mainfi_tclMsgLocalTimeOffsetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgLocalTimeOffsetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeOffsetSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeOffsetSet();

   virtual ~clock_mainfi_tclMsgLocalTimeOffsetSet();

   inline tBool operator==(const clock_mainfi_tclMsgLocalTimeOffsetSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDateUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDateUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgLocalTimeDateUpReg& operator=(const clock_mainfi_tclMsgLocalTimeDateUpReg& coRef);
   clock_mainfi_tclMsgLocalTimeDateUpReg(const clock_mainfi_tclMsgLocalTimeDateUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8UpdatePeriod;
   virtual ~clock_mainfi_tclMsgLocalTimeDateUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgLocalTimeDateUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDateRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDateRelUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgLocalTimeDateRelUpReg& operator=(const clock_mainfi_tclMsgLocalTimeDateRelUpReg& coRef);
   clock_mainfi_tclMsgLocalTimeDateRelUpReg(const clock_mainfi_tclMsgLocalTimeDateRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8UpdatePeriod;
   virtual ~clock_mainfi_tclMsgLocalTimeDateRelUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgLocalTimeDateRelUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDateGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDateGet();

   virtual ~clock_mainfi_tclMsgLocalTimeDateGet();

   inline tBool operator==(const clock_mainfi_tclMsgLocalTimeDateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDateStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgLocalTimeDateStatus& operator=(const clock_mainfi_tclMsgLocalTimeDateStatus& coRef);
   clock_mainfi_tclMsgLocalTimeDateStatus(const clock_mainfi_tclMsgLocalTimeDateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tU8 u8TimeDateStatus;
   tU32 u32TimeDateValue;
   virtual ~clock_mainfi_tclMsgLocalTimeDateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgLocalTimeDateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDateSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgLocalTimeDateSet& operator=(const clock_mainfi_tclMsgLocalTimeDateSet& coRef);
   clock_mainfi_tclMsgLocalTimeDateSet(const clock_mainfi_tclMsgLocalTimeDateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tU8 u8ChangeMask;
   virtual ~clock_mainfi_tclMsgLocalTimeDateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgLocalTimeDateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeFormatUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeFormatUpReg();

   virtual ~clock_mainfi_tclMsgTimeFormatUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgTimeFormatUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeFormatRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeFormatRelUpReg();

   virtual ~clock_mainfi_tclMsgTimeFormatRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgTimeFormatRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeFormatGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeFormatGet();

   virtual ~clock_mainfi_tclMsgTimeFormatGet();

   inline tBool operator==(const clock_mainfi_tclMsgTimeFormatGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeFormatStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeFormatStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgTimeFormatStatus& operator=(const clock_mainfi_tclMsgTimeFormatStatus& coRef);
   clock_mainfi_tclMsgTimeFormatStatus(const clock_mainfi_tclMsgTimeFormatStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat;
   virtual ~clock_mainfi_tclMsgTimeFormatStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgTimeFormatStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeFormatSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeFormatSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgTimeFormatSet& operator=(const clock_mainfi_tclMsgTimeFormatSet& coRef);
   clock_mainfi_tclMsgTimeFormatSet(const clock_mainfi_tclMsgTimeFormatSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat;
   virtual ~clock_mainfi_tclMsgTimeFormatSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgTimeFormatSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDateFormatUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDateFormatUpReg();

   virtual ~clock_mainfi_tclMsgDateFormatUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgDateFormatUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDateFormatRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDateFormatRelUpReg();

   virtual ~clock_mainfi_tclMsgDateFormatRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgDateFormatRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDateFormatGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDateFormatGet();

   virtual ~clock_mainfi_tclMsgDateFormatGet();

   inline tBool operator==(const clock_mainfi_tclMsgDateFormatGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDateFormatStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDateFormatStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgDateFormatStatus& operator=(const clock_mainfi_tclMsgDateFormatStatus& coRef);
   clock_mainfi_tclMsgDateFormatStatus(const clock_mainfi_tclMsgDateFormatStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_DateFormat enDateFormat;
   virtual ~clock_mainfi_tclMsgDateFormatStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgDateFormatStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDateFormatSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDateFormatSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgDateFormatSet& operator=(const clock_mainfi_tclMsgDateFormatSet& coRef);
   clock_mainfi_tclMsgDateFormatSet(const clock_mainfi_tclMsgDateFormatSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_DateFormat enDateFormat;
   virtual ~clock_mainfi_tclMsgDateFormatSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgDateFormatSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgClockSourceStatusUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgClockSourceStatusUpReg();

   virtual ~clock_mainfi_tclMsgClockSourceStatusUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgClockSourceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgClockSourceStatusRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgClockSourceStatusRelUpReg();

   virtual ~clock_mainfi_tclMsgClockSourceStatusRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgClockSourceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgClockSourceStatusGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgClockSourceStatusGet();

   virtual ~clock_mainfi_tclMsgClockSourceStatusGet();

   inline tBool operator==(const clock_mainfi_tclMsgClockSourceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgClockSourceStatusStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgClockSourceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgClockSourceStatusStatus& operator=(const clock_mainfi_tclMsgClockSourceStatusStatus& coRef);
   clock_mainfi_tclMsgClockSourceStatusStatus(const clock_mainfi_tclMsgClockSourceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_ClockSourceStatus enSourcesValid;
   virtual ~clock_mainfi_tclMsgClockSourceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgClockSourceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgFormatSourceStatusUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgFormatSourceStatusUpReg();

   virtual ~clock_mainfi_tclMsgFormatSourceStatusUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgFormatSourceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgFormatSourceStatusRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgFormatSourceStatusRelUpReg();

   virtual ~clock_mainfi_tclMsgFormatSourceStatusRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgFormatSourceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgFormatSourceStatusGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgFormatSourceStatusGet();

   virtual ~clock_mainfi_tclMsgFormatSourceStatusGet();

   inline tBool operator==(const clock_mainfi_tclMsgFormatSourceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgFormatSourceStatusStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgFormatSourceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgFormatSourceStatusStatus& operator=(const clock_mainfi_tclMsgFormatSourceStatusStatus& coRef);
   clock_mainfi_tclMsgFormatSourceStatusStatus(const clock_mainfi_tclMsgFormatSourceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_FormatSourceStatus enFormatSourceStatus;
   virtual ~clock_mainfi_tclMsgFormatSourceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgFormatSourceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg();

   virtual ~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg();

   virtual ~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet();

   virtual ~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet();

   inline tBool operator==(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& operator=(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& coRef);
   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tU8 u8TimeDateStatus;
   tU32 u32TimeDateValue;
   virtual ~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet& operator=(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet& coRef);
   clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tU8 u8ChangeMask;
   virtual ~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgRegion_TimeZoneGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgRegion_TimeZoneGet();

   virtual ~clock_mainfi_tclMsgRegion_TimeZoneGet();

   inline tBool operator==(const clock_mainfi_tclMsgRegion_TimeZoneGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgRegion_TimeZoneSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgRegion_TimeZoneSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgRegion_TimeZoneSet& operator=(const clock_mainfi_tclMsgRegion_TimeZoneSet& coRef);
   clock_mainfi_tclMsgRegion_TimeZoneSet(const clock_mainfi_tclMsgRegion_TimeZoneSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings;
   virtual ~clock_mainfi_tclMsgRegion_TimeZoneSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgRegion_TimeZoneSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgRegion_TimeZoneUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgRegion_TimeZoneUpReg();

   virtual ~clock_mainfi_tclMsgRegion_TimeZoneUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgRegion_TimeZoneUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgRegion_TimeZoneRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgRegion_TimeZoneRelUpReg();

   virtual ~clock_mainfi_tclMsgRegion_TimeZoneRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgRegion_TimeZoneRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgRegion_TimeZoneStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgRegion_TimeZoneStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgRegion_TimeZoneStatus& operator=(const clock_mainfi_tclMsgRegion_TimeZoneStatus& coRef);
   clock_mainfi_tclMsgRegion_TimeZoneStatus(const clock_mainfi_tclMsgRegion_TimeZoneStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status;
   clock_fi_tclString szDescription;
   virtual ~clock_mainfi_tclMsgRegion_TimeZoneStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgRegion_TimeZoneStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg();

   virtual ~clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg();

   virtual ~clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgAuto_TimeZoneOffsetGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgAuto_TimeZoneOffsetGet();

   virtual ~clock_mainfi_tclMsgAuto_TimeZoneOffsetGet();

   inline tBool operator==(const clock_mainfi_tclMsgAuto_TimeZoneOffsetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& operator=(const clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& coRef);
   clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus(const clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 s8Offset_Hour;
   tS8 s8Offset_Minute;
   virtual ~clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgAuto_TimeZoneOffsetSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgAuto_TimeZoneOffsetSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgAuto_TimeZoneOffsetSet& operator=(const clock_mainfi_tclMsgAuto_TimeZoneOffsetSet& coRef);
   clock_mainfi_tclMsgAuto_TimeZoneOffsetSet(const clock_mainfi_tclMsgAuto_TimeZoneOffsetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 s8Offset_Hour;
   tS8 s8Offset_Minute;
   virtual ~clock_mainfi_tclMsgAuto_TimeZoneOffsetSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgAuto_TimeZoneOffsetSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgNewDateFormatUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgNewDateFormatUpReg();

   virtual ~clock_mainfi_tclMsgNewDateFormatUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgNewDateFormatUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgNewDateFormatRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgNewDateFormatRelUpReg();

   virtual ~clock_mainfi_tclMsgNewDateFormatRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgNewDateFormatRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgNewDateFormatGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgNewDateFormatGet();

   virtual ~clock_mainfi_tclMsgNewDateFormatGet();

   inline tBool operator==(const clock_mainfi_tclMsgNewDateFormatGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgNewDateFormatStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgNewDateFormatStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgNewDateFormatStatus& operator=(const clock_mainfi_tclMsgNewDateFormatStatus& coRef);
   clock_mainfi_tclMsgNewDateFormatStatus(const clock_mainfi_tclMsgNewDateFormatStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat;
   virtual ~clock_mainfi_tclMsgNewDateFormatStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgNewDateFormatStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgNewDateFormatSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgNewDateFormatSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgNewDateFormatSet& operator=(const clock_mainfi_tclMsgNewDateFormatSet& coRef);
   clock_mainfi_tclMsgNewDateFormatSet(const clock_mainfi_tclMsgNewDateFormatSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat;
   virtual ~clock_mainfi_tclMsgNewDateFormatSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgNewDateFormatSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgConnectionUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgConnectionUpReg();

   virtual ~clock_mainfi_tclMsgConnectionUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgConnectionRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgConnectionRelUpReg();

   virtual ~clock_mainfi_tclMsgConnectionRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgConnectionGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgConnectionGet();

   virtual ~clock_mainfi_tclMsgConnectionGet();

   inline tBool operator==(const clock_mainfi_tclMsgConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgConnectionStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgConnectionStatus& operator=(const clock_mainfi_tclMsgConnectionStatus& coRef);
   clock_mainfi_tclMsgConnectionStatus(const clock_mainfi_tclMsgConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tcl_SWC_UnitConnectionStatus SWCUnitConnectionStatus;
   virtual ~clock_mainfi_tclMsgConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg();

   virtual ~clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg();

   virtual ~clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet();

   virtual ~clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet();

   inline tBool operator==(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& operator=(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& coRef);
   clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bTimeZone_DSTAvailabilityForRegion;
   virtual ~clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHardwareVersionUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHardwareVersionUpReg();

   virtual ~clock_mainfi_tclMsgHardwareVersionUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgHardwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHardwareVersionRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHardwareVersionRelUpReg();

   virtual ~clock_mainfi_tclMsgHardwareVersionRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgHardwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHardwareVersionGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHardwareVersionGet();

   virtual ~clock_mainfi_tclMsgHardwareVersionGet();

   inline tBool operator==(const clock_mainfi_tclMsgHardwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHardwareVersionStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHardwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgHardwareVersionStatus& operator=(const clock_mainfi_tclMsgHardwareVersionStatus& coRef);
   clock_mainfi_tclMsgHardwareVersionStatus(const clock_mainfi_tclMsgHardwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arHardwareVersionList;
   virtual ~clock_mainfi_tclMsgHardwareVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgHardwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSoftwareVersionUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSoftwareVersionUpReg();

   virtual ~clock_mainfi_tclMsgSoftwareVersionUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgSoftwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSoftwareVersionRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSoftwareVersionRelUpReg();

   virtual ~clock_mainfi_tclMsgSoftwareVersionRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgSoftwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSoftwareVersionGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSoftwareVersionGet();

   virtual ~clock_mainfi_tclMsgSoftwareVersionGet();

   inline tBool operator==(const clock_mainfi_tclMsgSoftwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgSoftwareVersionStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgSoftwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgSoftwareVersionStatus& operator=(const clock_mainfi_tclMsgSoftwareVersionStatus& coRef);
   clock_mainfi_tclMsgSoftwareVersionStatus(const clock_mainfi_tclMsgSoftwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arSoftwareVersionList;
   virtual ~clock_mainfi_tclMsgSoftwareVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgSoftwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDebugMode_TimeDateUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDebugMode_TimeDateUpReg();

   virtual ~clock_mainfi_tclMsgDebugMode_TimeDateUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgDebugMode_TimeDateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg();

   virtual ~clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDebugMode_TimeDateGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDebugMode_TimeDateGet();

   virtual ~clock_mainfi_tclMsgDebugMode_TimeDateGet();

   inline tBool operator==(const clock_mainfi_tclMsgDebugMode_TimeDateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDebugMode_TimeDateStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDebugMode_TimeDateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgDebugMode_TimeDateStatus& operator=(const clock_mainfi_tclMsgDebugMode_TimeDateStatus& coRef);
   clock_mainfi_tclMsgDebugMode_TimeDateStatus(const clock_mainfi_tclMsgDebugMode_TimeDateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tBool bdebugMode;
   virtual ~clock_mainfi_tclMsgDebugMode_TimeDateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgDebugMode_TimeDateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgDebugMode_TimeDateSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgDebugMode_TimeDateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgDebugMode_TimeDateSet& operator=(const clock_mainfi_tclMsgDebugMode_TimeDateSet& coRef);
   clock_mainfi_tclMsgDebugMode_TimeDateSet(const clock_mainfi_tclMsgDebugMode_TimeDateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tBool bdebugMode;
   tU8 u8ChangeMask;
   virtual ~clock_mainfi_tclMsgDebugMode_TimeDateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgDebugMode_TimeDateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg();

   virtual ~clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg();

   virtual ~clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgUTC_TimeDateUpdateGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgUTC_TimeDateUpdateGet();

   virtual ~clock_mainfi_tclMsgUTC_TimeDateUpdateGet();

   inline tBool operator==(const clock_mainfi_tclMsgUTC_TimeDateUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgUTC_TimeDateUpdateStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgUTC_TimeDateUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& operator=(const clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& coRef);
   clock_mainfi_tclMsgUTC_TimeDateUpdateStatus(const clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   tBool bTimeValidity;
   virtual ~clock_mainfi_tclMsgUTC_TimeDateUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_ActivationGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_ActivationGet();

   virtual ~clock_mainfi_tclMsgHUD_ActivationGet();

   inline tBool operator==(const clock_mainfi_tclMsgHUD_ActivationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_ActivationSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_ActivationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgHUD_ActivationSet& operator=(const clock_mainfi_tclMsgHUD_ActivationSet& coRef);
   clock_mainfi_tclMsgHUD_ActivationSet(const clock_mainfi_tclMsgHUD_ActivationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   clock_fi_tclDCLK_TEN_HUD_ActivationSettings enHUD_Setting;
   virtual ~clock_mainfi_tclMsgHUD_ActivationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgHUD_ActivationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_ActivationUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_ActivationUpReg();

   virtual ~clock_mainfi_tclMsgHUD_ActivationUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgHUD_ActivationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_ActivationRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_ActivationRelUpReg();

   virtual ~clock_mainfi_tclMsgHUD_ActivationRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgHUD_ActivationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_ActivationStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_ActivationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgHUD_ActivationStatus& operator=(const clock_mainfi_tclMsgHUD_ActivationStatus& coRef);
   clock_mainfi_tclMsgHUD_ActivationStatus(const clock_mainfi_tclMsgHUD_ActivationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bHUD_Status;
   virtual ~clock_mainfi_tclMsgHUD_ActivationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgHUD_ActivationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_PostitionUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_PostitionUpReg();

   virtual ~clock_mainfi_tclMsgHUD_PostitionUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgHUD_PostitionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_PostitionRelUpReg : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_PostitionRelUpReg();

   virtual ~clock_mainfi_tclMsgHUD_PostitionRelUpReg();

   inline tBool operator==(const clock_mainfi_tclMsgHUD_PostitionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_PostitionGet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_PostitionGet();

   virtual ~clock_mainfi_tclMsgHUD_PostitionGet();

   inline tBool operator==(const clock_mainfi_tclMsgHUD_PostitionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_PostitionStatus : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_PostitionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgHUD_PostitionStatus& operator=(const clock_mainfi_tclMsgHUD_PostitionStatus& coRef);
   clock_mainfi_tclMsgHUD_PostitionStatus(const clock_mainfi_tclMsgHUD_PostitionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Up_Position;
   tU8 u8Down_Position;
   virtual ~clock_mainfi_tclMsgHUD_PostitionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgHUD_PostitionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class clock_mainfi_tclMsgHUD_PostitionSet : public clock_mainfi_tclMsgBaseMessage
{
public:

   clock_mainfi_tclMsgHUD_PostitionSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   clock_mainfi_tclMsgHUD_PostitionSet& operator=(const clock_mainfi_tclMsgHUD_PostitionSet& coRef);
   clock_mainfi_tclMsgHUD_PostitionSet(const clock_mainfi_tclMsgHUD_PostitionSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Up_Position;
   tU8 u8Down_Position;
   virtual ~clock_mainfi_tclMsgHUD_PostitionSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const clock_mainfi_tclMsgHUD_PostitionSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
