#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_STDVISITORS
#include "clock_fi_if.h"

tBool clock_mainfi_tclDescription::bInitMessage(clock_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case clock_mainfi_tclToken::EN_LAST_TOKEN:
   case clock_mainfi_tclToken::EN_LIST:
   case clock_mainfi_tclToken::EN_END_OF_STRUCT:
   case clock_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case clock_mainfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODRESULT:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U16,clock_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_LIST,clock_mainfi_tclSemanticDomain::EN_MSG_U16INDEXES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_STRING,clock_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_LIST,clock_mainfi_tclSemanticDomain::EN_MSG_ASZDESCRIPTIONS)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODSTART:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8TARGETDOMAIN)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SOURCEDOMAIN)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U32,clock_mainfi_tclSemanticDomain::EN_MSG_U32TIMEDATEVALUE)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODRESULT:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODSTART:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODRESULT:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8NUMBEROFDAYS)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_E8_DEFSETMODE,clock_mainfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_E8_DEFSETGROUPS,clock_mainfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_E8_DEFSETMODE,clock_mainfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_E8_DEFSETGROUPS,clock_mainfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_TIMEZONESET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U16,clock_mainfi_tclSemanticDomain::EN_MSG_U16INDEX)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_TIMEZONESTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_STRING,clock_mainfi_tclSemanticDomain::EN_MSG_SZDESCRIPTION)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U16,clock_mainfi_tclSemanticDomain::EN_MSG_U16INDEX)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_DST_SETTING,clock_mainfi_tclSemanticDomain::EN_MSG_ENDST_SETTING)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_DST_SETTING,clock_mainfi_tclSemanticDomain::EN_MSG_ENDST_STATUS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BDST_AUTOADJUST)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BDST_STATUS)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCSET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BPOSITIONBASED)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BENABLED)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BPOSITIONBASED)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BENABLED)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_SYNCMODESET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_SYNCMODE,clock_mainfi_tclSemanticDomain::EN_MSG_ENMODE)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_SYNCMODESTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_SYNCMODE,clock_mainfi_tclSemanticDomain::EN_MSG_ENMODE)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHSET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_GPS_EPOCH,clock_mainfi_tclSemanticDomain::EN_MSG_GPSEPOCH)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_GPS_EPOCH,clock_mainfi_tclSemanticDomain::EN_MSG_GPSEPOCH)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_GPSRTCTIMESTATE,clock_mainfi_tclSemanticDomain::EN_MSG_ENGPSRTCTIMESTATE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_SECOND)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_MINUTE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_HOUR)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16UTCTIMEDATE_YEAR)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U32,clock_mainfi_tclSemanticDomain::EN_MSG_U32UTCTIMEDATE_SCALARVALUE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8OFFSET_SECOND)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8OFFSET_MINUTE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8OFFSET_HOUR)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8OFFSET_DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8OFFSET_MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16OFFSET_YEAR)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BISOFFSETPOSTIVE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S64,clock_mainfi_tclSemanticDomain::EN_MSG_S64OFFSET_SCALARVALUE)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATEUPREG:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UPDATEPERIOD)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATERELUPREG:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UPDATEPERIOD)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATESTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U32,clock_mainfi_tclSemanticDomain::EN_MSG_U32TIMEDATEVALUE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8TIMEDATESTATUS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATESET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8CHANGEMASK)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_TIMEFORMATSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_TIMEFORMAT,clock_mainfi_tclSemanticDomain::EN_MSG_ENTIMEFORMAT)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_TIMEFORMATSET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_TIMEFORMAT,clock_mainfi_tclSemanticDomain::EN_MSG_ENTIMEFORMAT)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_DATEFORMATSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_DATEFORMAT,clock_mainfi_tclSemanticDomain::EN_MSG_ENDATEFORMAT)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_DATEFORMATSET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_DATEFORMAT,clock_mainfi_tclSemanticDomain::EN_MSG_ENDATEFORMAT)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_CLOCKSOURCESTATUS,clock_mainfi_tclSemanticDomain::EN_MSG_ENSOURCESVALID)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_FORMATSOURCESTATUS,clock_mainfi_tclSemanticDomain::EN_MSG_ENFORMATSOURCESTATUS)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATESTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U32,clock_mainfi_tclSemanticDomain::EN_MSG_U32TIMEDATEVALUE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8TIMEDATESTATUS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATESET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8CHANGEMASK)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONESET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_TIMEZONE_SETTING,clock_mainfi_tclSemanticDomain::EN_MSG_ENTIMEZONE_SETTINGS)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONESTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_STRING,clock_mainfi_tclSemanticDomain::EN_MSG_SZDESCRIPTION)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_TIMEZONE_SETTING,clock_mainfi_tclSemanticDomain::EN_MSG_ENTIMEZONE_STATUS)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S8,clock_mainfi_tclSemanticDomain::EN_MSG_S8OFFSET_MINUTE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S8,clock_mainfi_tclSemanticDomain::EN_MSG_S8OFFSET_HOUR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETSET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S8,clock_mainfi_tclSemanticDomain::EN_MSG_S8OFFSET_MINUTE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S8,clock_mainfi_tclSemanticDomain::EN_MSG_S8OFFSET_HOUR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_NEWDATEFORMAT,clock_mainfi_tclSemanticDomain::EN_MSG_ENDATEFORMAT)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATSET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_NEWDATEFORMAT,clock_mainfi_tclSemanticDomain::EN_MSG_ENDATEFORMAT)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_CONNECTIONSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_SWC_UNITCONNECTIONSTATUS,clock_mainfi_tclSemanticDomain::EN_MSG_SWCUNITCONNECTIONSTATUS)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BTIMEZONE_DSTAVAILABILITYFORREGION)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_VDCLOCK_UNITVERSION,clock_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_LIST,clock_mainfi_tclSemanticDomain::EN_MSG_ARHARDWAREVERSIONLIST)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_VDCLOCK_UNITVERSION,clock_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_LIST,clock_mainfi_tclSemanticDomain::EN_MSG_ARSOFTWAREVERSIONLIST)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATESTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BDEBUGMODE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATESET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8CHANGEMASK)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BDEBUGMODE)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATESTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BTIMEVALIDITY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_S16,clock_mainfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONSET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_CLK_TEN_HUD_ACTIVATIONSETTINGS,clock_mainfi_tclSemanticDomain::EN_MSG_ENHUD_SETTING)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_MSG_BHUD_STATUS)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONSTATUS:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DOWN_POSITION)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UP_POSITION)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONSET:
   {
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8DOWN_POSITION)) && bResult;
      bResult = oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_MSG_U8UP_POSITION)) && bResult;
   } break;
   case clock_mainfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODSTART:
   case clock_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART:
   case clock_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT:
   case clock_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODSTART:
   case clock_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODRESULT:
   case clock_mainfi_tclToken::EN_MSG_TIMEZONEGET:
   case clock_mainfi_tclToken::EN_MSG_TIMEZONEUPREG:
   case clock_mainfi_tclToken::EN_MSG_TIMEZONERELUPREG:
   case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEGET:
   case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEUPREG:
   case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMERELUPREG:
   case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCGET:
   case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCUPREG:
   case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_SYNCMODEGET:
   case clock_mainfi_tclToken::EN_MSG_SYNCMODEUPREG:
   case clock_mainfi_tclToken::EN_MSG_SYNCMODERELUPREG:
   case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHGET:
   case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHUPREG:
   case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETUPREG:
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETGET:
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETSET:
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATEGET:
   case clock_mainfi_tclToken::EN_MSG_TIMEFORMATUPREG:
   case clock_mainfi_tclToken::EN_MSG_TIMEFORMATRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_TIMEFORMATGET:
   case clock_mainfi_tclToken::EN_MSG_DATEFORMATUPREG:
   case clock_mainfi_tclToken::EN_MSG_DATEFORMATRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_DATEFORMATGET:
   case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSUPREG:
   case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSGET:
   case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSUPREG:
   case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSGET:
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATEUPREG:
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATERELUPREG:
   case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATEGET:
   case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONEGET:
   case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONEUPREG:
   case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONERELUPREG:
   case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETUPREG:
   case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETGET:
   case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATUPREG:
   case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATGET:
   case clock_mainfi_tclToken::EN_MSG_CONNECTIONUPREG:
   case clock_mainfi_tclToken::EN_MSG_CONNECTIONRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_CONNECTIONGET:
   case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYUPREG:
   case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYGET:
   case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG:
   case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONGET:
   case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG:
   case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONGET:
   case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATEUPREG:
   case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATERELUPREG:
   case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATEGET:
   case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATEUPREG:
   case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATERELUPREG:
   case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATEGET:
   case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONGET:
   case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONUPREG:
   case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONUPREG:
   case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONRELUPREG:
   case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONGET:
   case clock_mainfi_tclToken::EN_BINCONTAINER:
   case clock_mainfi_tclToken::EN_E8_DEFSETMODE:
   case clock_mainfi_tclToken::EN_E8_DEFSETGROUPS:
   case clock_mainfi_tclToken::EN_E8_MCANUNITTYPE:
   case clock_mainfi_tclToken::EN_E8_UNITTYPE:
   case clock_mainfi_tclToken::EN_SWC_UNITCONNECTIONSTATUS:
   case clock_mainfi_tclToken::EN_VDCLOCK_VERSIONINFO:
   case clock_mainfi_tclToken::EN_VDCLOCK_UNITVERSION:
   case clock_mainfi_tclToken::EN_CLK_TEN_CLOCKSOURCESTATUS:
   case clock_mainfi_tclToken::EN_CLK_TEN_DATEFORMAT:
   case clock_mainfi_tclToken::EN_CLK_TEN_DST_SETTING:
   case clock_mainfi_tclToken::EN_CLK_TEN_FORMATSOURCESTATUS:
   case clock_mainfi_tclToken::EN_CLK_TEN_GPS_EPOCH:
   case clock_mainfi_tclToken::EN_CLK_TEN_GPSRTCTIMESTATE:
   case clock_mainfi_tclToken::EN_CLK_TEN_NEWDATEFORMAT:
   case clock_mainfi_tclToken::EN_CLK_TEN_SYNCMODE:
   case clock_mainfi_tclToken::EN_CLK_TEN_TIMEFORMAT:
   case clock_mainfi_tclToken::EN_CLK_TEN_TIMEZONE_SETTING:
   case clock_mainfi_tclToken::EN_CLK_TEN_HUD_ACTIVATIONSETTINGS:
   case clock_mainfi_tclToken::EN_U8:   
   case clock_mainfi_tclToken::EN_S8:   
   case clock_mainfi_tclToken::EN_U16:   
   case clock_mainfi_tclToken::EN_S16:   
   case clock_mainfi_tclToken::EN_U24:   
   case clock_mainfi_tclToken::EN_S24:   
   case clock_mainfi_tclToken::EN_U32:   
   case clock_mainfi_tclToken::EN_S32:   
   case clock_mainfi_tclToken::EN_U64:   
   case clock_mainfi_tclToken::EN_S64:   
   case clock_mainfi_tclToken::EN_F32:   
   case clock_mainfi_tclToken::EN_F64:   
   case clock_mainfi_tclToken::EN_BOOL:   
   case clock_mainfi_tclToken::EN_STRING:   
   case clock_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(enMsgToken,clock_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool clock_mainfi_tclDescription::bDoIt(clock_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool clock_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      clock_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      clock_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      clock_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == clock_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(clock_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case clock_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == clock_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_LIST: 
      {
         clock_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            clock_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            clock_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case clock_mainfi_tclToken::EN_U8: 
      {
         clock_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case clock_mainfi_tclToken::EN_U16: 
      {
         clock_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_U24: 
      {
         clock_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_U32: 
      {
         clock_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_U64: 
      {
         clock_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_S8: 
      {
         clock_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_S16: 
      {
         clock_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_S24: 
      {
         clock_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_S32: 
      {
         clock_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_S64: 
      {
         clock_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_F32: 
      {
         clock_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_F64: 
      {
         clock_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_BOOL: 
      {
         clock_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_STRING: 
      {
         clock_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         clock_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case clock_mainfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODSTART:
      case clock_mainfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODRESULT:
      case clock_mainfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODSTART:
      case clock_mainfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODRESULT:
      case clock_mainfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODSTART:
      case clock_mainfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODRESULT:
      case clock_mainfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODSTART:
      case clock_mainfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODRESULT:
      case clock_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART:
      case clock_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT:
      case clock_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODSTART:
      case clock_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODRESULT:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONEGET:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONESET:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONEUPREG:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONERELUPREG:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONESTATUS:
      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEGET:
      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESET:
      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEUPREG:
      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMERELUPREG:
      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESTATUS:
      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCGET:
      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCSET:
      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCUPREG:
      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCSTATUS:
      case clock_mainfi_tclToken::EN_MSG_SYNCMODEGET:
      case clock_mainfi_tclToken::EN_MSG_SYNCMODESET:
      case clock_mainfi_tclToken::EN_MSG_SYNCMODEUPREG:
      case clock_mainfi_tclToken::EN_MSG_SYNCMODERELUPREG:
      case clock_mainfi_tclToken::EN_MSG_SYNCMODESTATUS:
      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHGET:
      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHSET:
      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHUPREG:
      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHSTATUS:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETUPREG:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETGET:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETSTATUS:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETSET:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATEUPREG:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATERELUPREG:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATEGET:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATESTATUS:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATESET:
      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATUPREG:
      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATGET:
      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATSTATUS:
      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATSET:
      case clock_mainfi_tclToken::EN_MSG_DATEFORMATUPREG:
      case clock_mainfi_tclToken::EN_MSG_DATEFORMATRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_DATEFORMATGET:
      case clock_mainfi_tclToken::EN_MSG_DATEFORMATSTATUS:
      case clock_mainfi_tclToken::EN_MSG_DATEFORMATSET:
      case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSUPREG:
      case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSGET:
      case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSSTATUS:
      case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSUPREG:
      case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSGET:
      case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSSTATUS:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATEUPREG:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATERELUPREG:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATEGET:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATESTATUS:
      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATESET:
      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONEGET:
      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONESET:
      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONEUPREG:
      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONERELUPREG:
      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONESTATUS:
      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETUPREG:
      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETGET:
      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETSTATUS:
      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETSET:
      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATUPREG:
      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATGET:
      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATSTATUS:
      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATSET:
      case clock_mainfi_tclToken::EN_MSG_CONNECTIONUPREG:
      case clock_mainfi_tclToken::EN_MSG_CONNECTIONRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_CONNECTIONGET:
      case clock_mainfi_tclToken::EN_MSG_CONNECTIONSTATUS:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYUPREG:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYGET:
      case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYSTATUS:
      case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG:
      case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONGET:
      case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS:
      case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG:
      case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONGET:
      case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS:
      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATEUPREG:
      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATERELUPREG:
      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATEGET:
      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATESTATUS:
      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATESET:
      case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATEUPREG:
      case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATERELUPREG:
      case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATEGET:
      case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATESTATUS:
      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONGET:
      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONSET:
      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONUPREG:
      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONSTATUS:
      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONUPREG:
      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONRELUPREG:
      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONGET:
      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONSTATUS:
      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONSET:
         (tVoid) bInitMessage(enToken);
         break;
      case clock_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_END_OF_STRUCT,clock_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_LIST,clock_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         clock_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case clock_mainfi_tclToken::EN_E8_DEFSETMODE:
      {
         clock_fi_tcl_e8_DefSetMode o_e8_DefSetMode;
         if (!bDoIt(o_e8_DefSetMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_E8_DEFSETGROUPS:
      {
         clock_fi_tcl_e8_DefSetGroups o_e8_DefSetGroups;
         if (!bDoIt(o_e8_DefSetGroups))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_E8_MCANUNITTYPE:
      {
         clock_fi_tcl_e8_MCanUnitType o_e8_MCanUnitType;
         if (!bDoIt(o_e8_MCanUnitType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_E8_UNITTYPE:
      {
         clock_fi_tcl_e8_UnitType o_e8_UnitType;
         if (!bDoIt(o_e8_UnitType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_SWC_UNITCONNECTIONSTATUS:
      {
      if (poVisitor->bDoExpand_SWC_UnitConnectionStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_END_OF_STRUCT,clock_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_U8MUTESTATE));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_U8ABSENCESTATE));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_BOOL,clock_mainfi_tclSemanticDomain::EN_BCONNECTED));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_E8_UNITTYPE,clock_mainfi_tclSemanticDomain::EN_E8UNITTYPE));
      }
      else
      {
         clock_fi_tcl_SWC_UnitConnectionStatus o_SWC_UnitConnectionStatus;
         if (!bDoIt(o_SWC_UnitConnectionStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SWC_UnitConnectionStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SWC_UnitConnectionStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case clock_mainfi_tclToken::EN_VDCLOCK_VERSIONINFO:
      {
      if (poVisitor->bDoExpand_VdClock_VersionInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_END_OF_STRUCT,clock_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_U8UPPER));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_U8MID));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_U8,clock_mainfi_tclSemanticDomain::EN_U8LOWER));
      }
      else
      {
         clock_fi_tcl_VdClock_VersionInfo o_VdClock_VersionInfo;
         if (!bDoIt(o_VdClock_VersionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VdClock_VersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VdClock_VersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case clock_mainfi_tclToken::EN_VDCLOCK_UNITVERSION:
      {
      if (poVisitor->bDoExpand_VdClock_UnitVersion(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_END_OF_STRUCT,clock_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_VDCLOCK_VERSIONINFO,clock_mainfi_tclSemanticDomain::EN_RVERSION));
         (tVoid) oPath.bGoDown(clock_mainfi_tclKnot(clock_mainfi_tclToken::EN_E8_MCANUNITTYPE,clock_mainfi_tclSemanticDomain::EN_E8UNITTYPE));
      }
      else
      {
         clock_fi_tcl_VdClock_UnitVersion o_VdClock_UnitVersion;
         if (!bDoIt(o_VdClock_UnitVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VdClock_UnitVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VdClock_UnitVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_CLOCKSOURCESTATUS:
      {
         clock_fi_tclDCLK_TEN_ClockSourceStatus oDCLK_TEN_ClockSourceStatus;
         if (!bDoIt(oDCLK_TEN_ClockSourceStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_DATEFORMAT:
      {
         clock_fi_tclDCLK_TEN_DateFormat oDCLK_TEN_DateFormat;
         if (!bDoIt(oDCLK_TEN_DateFormat))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_DST_SETTING:
      {
         clock_fi_tclDCLK_TEN_DST_Setting oDCLK_TEN_DST_Setting;
         if (!bDoIt(oDCLK_TEN_DST_Setting))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_FORMATSOURCESTATUS:
      {
         clock_fi_tclDCLK_TEN_FormatSourceStatus oDCLK_TEN_FormatSourceStatus;
         if (!bDoIt(oDCLK_TEN_FormatSourceStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_GPS_EPOCH:
      {
         clock_fi_tclDCLK_TEN_GPS_EPOCH oDCLK_TEN_GPS_EPOCH;
         if (!bDoIt(oDCLK_TEN_GPS_EPOCH))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_GPSRTCTIMESTATE:
      {
         clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE oDCLK_TEN_GPSRTCTIMESTATE;
         if (!bDoIt(oDCLK_TEN_GPSRTCTIMESTATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_NEWDATEFORMAT:
      {
         clock_fi_tclDCLK_TEN_NewDateFormat oDCLK_TEN_NewDateFormat;
         if (!bDoIt(oDCLK_TEN_NewDateFormat))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_SYNCMODE:
      {
         clock_fi_tclDCLK_TEN_SyncMode oDCLK_TEN_SyncMode;
         if (!bDoIt(oDCLK_TEN_SyncMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_TIMEFORMAT:
      {
         clock_fi_tclDCLK_TEN_TimeFormat oDCLK_TEN_TimeFormat;
         if (!bDoIt(oDCLK_TEN_TimeFormat))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_TIMEZONE_SETTING:
      {
         clock_fi_tclDCLK_TEN_TIMEZONE_Setting oDCLK_TEN_TIMEZONE_Setting;
         if (!bDoIt(oDCLK_TEN_TIMEZONE_Setting))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_CLK_TEN_HUD_ACTIVATIONSETTINGS:
      {
         clock_fi_tclDCLK_TEN_HUD_ActivationSettings oDCLK_TEN_HUD_ActivationSettings;
         if (!bDoIt(oDCLK_TEN_HUD_ActivationSettings))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case clock_mainfi_tclToken::EN_UNKNOWN:
      case clock_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

