/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define CFC_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "cfc_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 cfc_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 cfc_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 cfc_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 cfc_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 cfc_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 cfc_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 cfc_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 cfc_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 cfc_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 cfc_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 cfc_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& cfc_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 cfc_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& cfc_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 cfc_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid cfc_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tclString::~cfc_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

cfc_fi_tclString& cfc_fi_tclString::operator=(const cfc_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

cfc_fi_tclString::cfc_fi_tclString(const cfc_fi_tclString& coRef):cfc_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& cfc_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool cfc_fi_tclString::operator==(const cfc_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 cfc_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
cfc_fi_tclString& cfc_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
cfc_fi_tclString::cfc_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool cfc_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

cfc_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

cfc_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool cfc_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar cfc_FI_C_U8_NULLCHAR = '\0';

tChar* cfc_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* cfc_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* cfc_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& cfc_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return cfc_FI_C_U8_NULLCHAR;
}

tChar& cfc_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return cfc_FI_C_U8_NULLCHAR;
}

tChar& cfc_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return cfc_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool cfc_fi_tclString::bSet(const cfc_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool cfc_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString cfc_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& cfc_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool cfc_fi_tclList::operator==(const cfc_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 cfc_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cfc_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid cfc_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tclMultiLanguageString::~cfc_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

cfc_fi_tclMultiLanguageString& cfc_fi_tclMultiLanguageString::operator=(const cfc_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

cfc_fi_tclMultiLanguageString::cfc_fi_tclMultiLanguageString(const cfc_fi_tclMultiLanguageString& coRef):cfc_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& cfc_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool cfc_fi_tclMultiLanguageString::operator==(const cfc_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 cfc_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
cfc_fi_tclMultiLanguageString& cfc_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
cfc_fi_tclMultiLanguageString::cfc_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool cfc_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

cfc_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

cfc_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool cfc_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* cfc_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* cfc_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* cfc_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& cfc_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return cfc_FI_C_U8_NULLCHAR;
}

tChar& cfc_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return cfc_FI_C_U8_NULLCHAR;
}

tChar& cfc_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return cfc_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool cfc_fi_tclMultiLanguageString::bSet(const cfc_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool cfc_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString cfc_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_BinContainer::cfc_fi_tcl_BinContainer(const cfc_fi_tcl_BinContainer& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
cfc_fi_tcl_BinContainer& cfc_fi_tcl_BinContainer::operator=(const cfc_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

cfc_fi_tcl_BinContainer::cfc_fi_tcl_BinContainer()

 {}

tS32 cfc_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_BINCONTAINER;
}


cfc_fi_tcl_BinContainer::~cfc_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& cfc_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool cfc_fi_tcl_BinContainer::operator==(const cfc_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_fi_tcl_Reserved::cfc_fi_tcl_Reserved()
 {}

tS32 cfc_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_RESERVED;
}


cfc_fi_tcl_Reserved::~cfc_fi_tcl_Reserved()
{}

tU32 cfc_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& cfc_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_u8_Percent::cfc_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 cfc_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_U8_PERCENT;
}


cfc_fi_tcl_u8_Percent::~cfc_fi_tcl_u8_Percent()
{}

tU32 cfc_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cfc_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_PerThousand::cfc_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


cfc_fi_tcl_s16_PerThousand::~cfc_fi_tcl_s16_PerThousand()
{}

tU32 cfc_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_u16_IndexInReferenceList::cfc_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cfc_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


cfc_fi_tcl_u16_IndexInReferenceList::~cfc_fi_tcl_u16_IndexInReferenceList()
{}

tU32 cfc_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cfc_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_u16_ErrorCode::cfc_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cfc_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_U16_ERRORCODE;
}


cfc_fi_tcl_u16_ErrorCode::~cfc_fi_tcl_u16_ErrorCode()
{}

tU32 cfc_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cfc_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_u16_RPM::cfc_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cfc_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_U16_RPM;
}


cfc_fi_tcl_u16_RPM::~cfc_fi_tcl_u16_RPM()
{}

tU32 cfc_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cfc_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Kilogram::cfc_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_KILOGRAM;
}


cfc_fi_tcl_s32_Kilogram::~cfc_fi_tcl_s32_Kilogram()
{}

tU32 cfc_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Pound::cfc_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_POUND;
}


cfc_fi_tcl_s32_Pound::~cfc_fi_tcl_s32_Pound()
{}

tU32 cfc_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_Meter::cfc_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_METER;
}


cfc_fi_tcl_s16_Meter::~cfc_fi_tcl_s16_Meter()
{}

tU32 cfc_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Meter::cfc_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_METER;
}


cfc_fi_tcl_s32_Meter::~cfc_fi_tcl_s32_Meter()
{}

tU32 cfc_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Yards::cfc_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_YARDS;
}


cfc_fi_tcl_s32_Yards::~cfc_fi_tcl_s32_Yards()
{}

tU32 cfc_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Foot::cfc_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_FOOT;
}


cfc_fi_tcl_s32_Foot::~cfc_fi_tcl_s32_Foot()
{}

tU32 cfc_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Centimeter::cfc_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_CENTIMETER;
}


cfc_fi_tcl_s32_Centimeter::~cfc_fi_tcl_s32_Centimeter()
{}

tU32 cfc_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Inch::cfc_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_INCH;
}


cfc_fi_tcl_s32_Inch::~cfc_fi_tcl_s32_Inch()
{}

tU32 cfc_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Millimeter::cfc_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_MILLIMETER;
}


cfc_fi_tcl_s32_Millimeter::~cfc_fi_tcl_s32_Millimeter()
{}

tU32 cfc_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Microliter::cfc_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_MICROLITER;
}


cfc_fi_tcl_s32_Microliter::~cfc_fi_tcl_s32_Microliter()
{}

tU32 cfc_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Second::cfc_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_SECOND;
}


cfc_fi_tcl_s32_Second::~cfc_fi_tcl_s32_Second()
{}

tU32 cfc_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_u16_MilliSecond::cfc_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cfc_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_U16_MILLISECOND;
}


cfc_fi_tcl_u16_MilliSecond::~cfc_fi_tcl_u16_MilliSecond()
{}

tU32 cfc_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cfc_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_MilliSecond::cfc_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_MILLISECOND;
}


cfc_fi_tcl_s32_MilliSecond::~cfc_fi_tcl_s32_MilliSecond()
{}

tU32 cfc_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_POSIXTime::cfc_fi_tcl_POSIXTime(const cfc_fi_tcl_POSIXTime& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
cfc_fi_tcl_POSIXTime& cfc_fi_tcl_POSIXTime::operator=(const cfc_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_POSIXTime::cfc_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 cfc_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_POSIXTIME;
}


cfc_fi_tcl_POSIXTime::~cfc_fi_tcl_POSIXTime()
{}

tU32 cfc_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool cfc_fi_tcl_POSIXTime::operator==(const cfc_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_DST_State::cfc_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 cfc_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_DST_STATE;
}


cfc_fi_tcl_e8_DST_State::~cfc_fi_tcl_e8_DST_State()
{}

tU32 cfc_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_TimeZoneElement::cfc_fi_tcl_TimeZoneElement(const cfc_fi_tcl_TimeZoneElement& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
cfc_fi_tcl_TimeZoneElement& cfc_fi_tcl_TimeZoneElement::operator=(const cfc_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

cfc_fi_tcl_TimeZoneElement::cfc_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 cfc_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


cfc_fi_tcl_TimeZoneElement::~cfc_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& cfc_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool cfc_fi_tcl_TimeZoneElement::operator==(const cfc_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_KmPerHour::cfc_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_KMPERHOUR;
}


cfc_fi_tcl_s16_KmPerHour::~cfc_fi_tcl_s16_KmPerHour()
{}

tU32 cfc_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_MilesPerHour::cfc_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


cfc_fi_tcl_s16_MilesPerHour::~cfc_fi_tcl_s16_MilesPerHour()
{}

tU32 cfc_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_Knot::cfc_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_KNOT;
}


cfc_fi_tcl_s16_Knot::~cfc_fi_tcl_s16_Knot()
{}

tU32 cfc_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_CentimeterSecond::cfc_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


cfc_fi_tcl_s16_CentimeterSecond::~cfc_fi_tcl_s16_CentimeterSecond()
{}

tU32 cfc_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_Kelvin::cfc_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_KELVIN;
}


cfc_fi_tcl_s16_Kelvin::~cfc_fi_tcl_s16_Kelvin()
{}

tU32 cfc_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_Fahrenheit::cfc_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


cfc_fi_tcl_s16_Fahrenheit::~cfc_fi_tcl_s16_Fahrenheit()
{}

tU32 cfc_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Pascal::cfc_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_PASCAL;
}


cfc_fi_tcl_s32_Pascal::~cfc_fi_tcl_s32_Pascal()
{}

tU32 cfc_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Watt::cfc_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_WATT;
}


cfc_fi_tcl_s32_Watt::~cfc_fi_tcl_s32_Watt()
{}

tU32 cfc_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_FIVersion::cfc_fi_tcl_FIVersion(const cfc_fi_tcl_FIVersion& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
cfc_fi_tcl_FIVersion& cfc_fi_tcl_FIVersion::operator=(const cfc_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_FIVersion::cfc_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 cfc_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_FIVERSION;
}


cfc_fi_tcl_FIVersion::~cfc_fi_tcl_FIVersion()
{}

tU32 cfc_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& cfc_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool cfc_fi_tcl_FIVersion::operator==(const cfc_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Longitude::cfc_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_LONGITUDE;
}


cfc_fi_tcl_s32_Longitude::~cfc_fi_tcl_s32_Longitude()
{}

tU32 cfc_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s32_Latitude::cfc_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cfc_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S32_LATITUDE;
}


cfc_fi_tcl_s32_Latitude::~cfc_fi_tcl_s32_Latitude()
{}

tU32 cfc_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cfc_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_PositionWGS84::cfc_fi_tcl_PositionWGS84(const cfc_fi_tcl_PositionWGS84& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
cfc_fi_tcl_PositionWGS84& cfc_fi_tcl_PositionWGS84::operator=(const cfc_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_PositionWGS84::cfc_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 cfc_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_POSITIONWGS84;
}


cfc_fi_tcl_PositionWGS84::~cfc_fi_tcl_PositionWGS84()
{}

tU32 cfc_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cfc_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool cfc_fi_tcl_PositionWGS84::operator==(const cfc_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_RectangleWGS84::cfc_fi_tcl_RectangleWGS84(const cfc_fi_tcl_RectangleWGS84& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
cfc_fi_tcl_RectangleWGS84& cfc_fi_tcl_RectangleWGS84::operator=(const cfc_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_RectangleWGS84::cfc_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 cfc_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_RECTANGLEWGS84;
}


cfc_fi_tcl_RectangleWGS84::~cfc_fi_tcl_RectangleWGS84()
{}

tU32 cfc_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& cfc_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool cfc_fi_tcl_RectangleWGS84::operator==(const cfc_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e16_ISOCountryCode::cfc_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 cfc_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


cfc_fi_tcl_e16_ISOCountryCode::~cfc_fi_tcl_e16_ISOCountryCode()
{}

tU32 cfc_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e16_ISOLanguageCode::cfc_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 cfc_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


cfc_fi_tcl_e16_ISOLanguageCode::~cfc_fi_tcl_e16_ISOLanguageCode()
{}

tU32 cfc_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_LanguageID::cfc_fi_tcl_LanguageID(const cfc_fi_tcl_LanguageID& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
cfc_fi_tcl_LanguageID& cfc_fi_tcl_LanguageID::operator=(const cfc_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_LanguageID::cfc_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 cfc_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_LANGUAGEID;
}


cfc_fi_tcl_LanguageID::~cfc_fi_tcl_LanguageID()
{}

tU32 cfc_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool cfc_fi_tcl_LanguageID::operator==(const cfc_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_u8_DirectionAbsolute::cfc_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 cfc_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


cfc_fi_tcl_u8_DirectionAbsolute::~cfc_fi_tcl_u8_DirectionAbsolute()
{}

tU32 cfc_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cfc_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_u8_DirectionRelative::cfc_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 cfc_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


cfc_fi_tcl_u8_DirectionRelative::~cfc_fi_tcl_u8_DirectionRelative()
{}

tU32 cfc_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cfc_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_CentiDegree::cfc_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


cfc_fi_tcl_s16_CentiDegree::~cfc_fi_tcl_s16_CentiDegree()
{}

tU32 cfc_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_Degree::cfc_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_DEGREE;
}


cfc_fi_tcl_s16_Degree::~cfc_fi_tcl_s16_Degree()
{}

tU32 cfc_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree::cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree::~cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_s16_DirectionRelative_CentiDegree::cfc_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cfc_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


cfc_fi_tcl_s16_DirectionRelative_CentiDegree::~cfc_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 cfc_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cfc_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_FuelType::cfc_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 cfc_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_FUELTYPE;
}


cfc_fi_tcl_e8_FuelType::~cfc_fi_tcl_e8_FuelType()
{}

tU32 cfc_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_DistTimeFuel::cfc_fi_tcl_DistTimeFuel(const cfc_fi_tcl_DistTimeFuel& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
cfc_fi_tcl_DistTimeFuel& cfc_fi_tcl_DistTimeFuel::operator=(const cfc_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_DistTimeFuel::cfc_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 cfc_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_DISTTIMEFUEL;
}


cfc_fi_tcl_DistTimeFuel::~cfc_fi_tcl_DistTimeFuel()
{}

tU32 cfc_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cfc_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool cfc_fi_tcl_DistTimeFuel::operator==(const cfc_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tclTimeDate::cfc_fi_tclTimeDate(const cfc_fi_tclTimeDate& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
}
cfc_fi_tclTimeDate& cfc_fi_tclTimeDate::operator=(const cfc_fi_tclTimeDate& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tclTimeDate::cfc_fi_tclTimeDate()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hour(0)
,u8Minute(0)
,u8Second(0)
 {}

tS32 cfc_fi_tclTimeDate::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_IMEDATE;
}


cfc_fi_tclTimeDate::~cfc_fi_tclTimeDate()
{}

tU32 cfc_fi_tclTimeDate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& cfc_fi_tclTimeDate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hour);
   (tVoid) (oIn >> u8Minute);
   (tVoid) (oIn >> u8Second);
   return oIn;
}

fi_tclOutContext& cfc_fi_tclTimeDate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hour);
   (tVoid) (oOut << u8Minute);
   (tVoid) (oOut << u8Second);
   return oOut;
}

tBool cfc_fi_tclTimeDate::operator==(const cfc_fi_tclTimeDate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hour == roRef.u8Hour);
   bResult = bResult && (u8Minute == roRef.u8Minute);
   bResult = bResult && (u8Second == roRef.u8Second);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_b32_SubState0::cfc_fi_tcl_b32_SubState0():u32Value(0)
{}

tS32 cfc_fi_tcl_b32_SubState0::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_B32_SUBSTATE0;
}


cfc_fi_tcl_b32_SubState0::~cfc_fi_tcl_b32_SubState0()
{}

tU32 cfc_fi_tcl_b32_SubState0::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_b32_SubState0::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cfc_fi_tcl_b32_SubState0::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_b32_SubState1::cfc_fi_tcl_b32_SubState1():u32Value(0)
{}

tS32 cfc_fi_tcl_b32_SubState1::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_B32_SUBSTATE1;
}


cfc_fi_tcl_b32_SubState1::~cfc_fi_tcl_b32_SubState1()
{}

tU32 cfc_fi_tcl_b32_SubState1::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_b32_SubState1::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cfc_fi_tcl_b32_SubState1::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_b32_SubState2::cfc_fi_tcl_b32_SubState2():u32Value(0)
{}

tS32 cfc_fi_tcl_b32_SubState2::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_B32_SUBSTATE2;
}


cfc_fi_tcl_b32_SubState2::~cfc_fi_tcl_b32_SubState2()
{}

tU32 cfc_fi_tcl_b32_SubState2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_b32_SubState2::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cfc_fi_tcl_b32_SubState2::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_SubStateType::cfc_fi_tcl_SPM_e32_SubStateType():enType(FI_EN_SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS) {}

tS32 cfc_fi_tcl_SPM_e32_SubStateType::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_SUBSTATETYPE;
}


cfc_fi_tcl_SPM_e32_SubStateType::~cfc_fi_tcl_SPM_e32_SubStateType()
{}

tU32 cfc_fi_tcl_SPM_e32_SubStateType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_SubStateType::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_SubStateType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_OnOffReason::cfc_fi_tcl_SPM_e32_OnOffReason():enType(FI_EN_SPM_SUBSTATE_TIPPER_ON) {}

tS32 cfc_fi_tcl_SPM_e32_OnOffReason::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_ONOFFREASON;
}


cfc_fi_tcl_SPM_e32_OnOffReason::~cfc_fi_tcl_SPM_e32_OnOffReason()
{}

tU32 cfc_fi_tcl_SPM_e32_OnOffReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_OnOffReason::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_OnOffReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_SYSTEM_STATES::cfc_fi_tcl_SPM_e32_SYSTEM_STATES():enType(FI_EN_SPM_SYSTEM_BACKGROUND) {}

tS32 cfc_fi_tcl_SPM_e32_SYSTEM_STATES::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_SYSTEM_STATES;
}


cfc_fi_tcl_SPM_e32_SYSTEM_STATES::~cfc_fi_tcl_SPM_e32_SYSTEM_STATES()
{}

tU32 cfc_fi_tcl_SPM_e32_SYSTEM_STATES::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_SYSTEM_STATES::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_SYSTEM_STATES::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR():enType(FI_EN_SPM_U32_SYSPWR_NORMAL) {}

tS32 cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_SYSPWR_BEHAVIOUR;
}


cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::~cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR()
{}

tU32 cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_HMI_STATE::cfc_fi_tcl_SPM_e32_HMI_STATE():enType(FI_EN_SPM_U32_HMISTATE_SHOW_OFF) {}

tS32 cfc_fi_tcl_SPM_e32_HMI_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_HMI_STATE;
}


cfc_fi_tcl_SPM_e32_HMI_STATE::~cfc_fi_tcl_SPM_e32_HMI_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_HMI_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_HMI_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_HMI_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_DIM_STATE::cfc_fi_tcl_SPM_e32_DIM_STATE():enType(FI_EN_SPM_U32_DIMSTATE) {}

tS32 cfc_fi_tcl_SPM_e32_DIM_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_DIM_STATE;
}


cfc_fi_tcl_SPM_e32_DIM_STATE::~cfc_fi_tcl_SPM_e32_DIM_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_DIM_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_DIM_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_DIM_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_b32_DIM_STATE::cfc_fi_tcl_SPM_b32_DIM_STATE():u32Value(0)
{}

tS32 cfc_fi_tcl_SPM_b32_DIM_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_B32_DIM_STATE;
}


cfc_fi_tcl_SPM_b32_DIM_STATE::~cfc_fi_tcl_SPM_b32_DIM_STATE()
{}

tU32 cfc_fi_tcl_SPM_b32_DIM_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_b32_DIM_STATE::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cfc_fi_tcl_SPM_b32_DIM_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_MMGR_STATE::cfc_fi_tcl_SPM_e32_MMGR_STATE():enType(FI_EN_SPM_U32_MMGRSTATE_BACKGRD_ACTIVITY) {}

tS32 cfc_fi_tcl_SPM_e32_MMGR_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_MMGR_STATE;
}


cfc_fi_tcl_SPM_e32_MMGR_STATE::~cfc_fi_tcl_SPM_e32_MMGR_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_MMGR_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_MMGR_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_MMGR_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_AUDIO_STATE::cfc_fi_tcl_SPM_e32_AUDIO_STATE():enType(FI_EN_SPM_U32_AUDIOSTATE_OFF) {}

tS32 cfc_fi_tcl_SPM_e32_AUDIO_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_AUDIO_STATE;
}


cfc_fi_tcl_SPM_e32_AUDIO_STATE::~cfc_fi_tcl_SPM_e32_AUDIO_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_AUDIO_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_AUDIO_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_AUDIO_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_AUDIO_SOURCE::cfc_fi_tcl_SPM_e32_AUDIO_SOURCE():enType(FI_EN_SPM_U32_AUDIOSRC_NONE) {}

tS32 cfc_fi_tcl_SPM_e32_AUDIO_SOURCE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_AUDIO_SOURCE;
}


cfc_fi_tcl_SPM_e32_AUDIO_SOURCE::~cfc_fi_tcl_SPM_e32_AUDIO_SOURCE()
{}

tU32 cfc_fi_tcl_SPM_e32_AUDIO_SOURCE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_AUDIO_SOURCE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_AUDIO_SOURCE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_CD_EJECT_STATE::cfc_fi_tcl_SPM_e32_CD_EJECT_STATE():enType(FI_EN_SPM_U32_CD_EJECT_INACTIVE) {}

tS32 cfc_fi_tcl_SPM_e32_CD_EJECT_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_CD_EJECT_STATE;
}


cfc_fi_tcl_SPM_e32_CD_EJECT_STATE::~cfc_fi_tcl_SPM_e32_CD_EJECT_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_CD_EJECT_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_CD_EJECT_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_CD_EJECT_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_CD_INSERT_STATE::cfc_fi_tcl_SPM_e32_CD_INSERT_STATE():enType(FI_EN_SPM_U32_CD_INSERT_INACTIVE) {}

tS32 cfc_fi_tcl_SPM_e32_CD_INSERT_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_CD_INSERT_STATE;
}


cfc_fi_tcl_SPM_e32_CD_INSERT_STATE::~cfc_fi_tcl_SPM_e32_CD_INSERT_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_CD_INSERT_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_CD_INSERT_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_CD_INSERT_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_SYS_STATE::cfc_fi_tcl_SPM_e32_SYS_STATE():enType(FI_EN_SPM_U32_SYSSTATE_SLEEP) {}

tS32 cfc_fi_tcl_SPM_e32_SYS_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_SYS_STATE;
}


cfc_fi_tcl_SPM_e32_SYS_STATE::~cfc_fi_tcl_SPM_e32_SYS_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_SYS_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_SYS_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_SYS_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_MOST_EVENT::cfc_fi_tcl_SPM_e32_MOST_EVENT():enType(FI_EN_SPM_U32_MOST_EVENT_NO_EVENT) {}

tS32 cfc_fi_tcl_SPM_e32_MOST_EVENT::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_MOST_EVENT;
}


cfc_fi_tcl_SPM_e32_MOST_EVENT::~cfc_fi_tcl_SPM_e32_MOST_EVENT()
{}

tU32 cfc_fi_tcl_SPM_e32_MOST_EVENT::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_MOST_EVENT::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_MOST_EVENT::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE::cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE():enType(FI_EN_SPM_U32_MOST_CONFIG_STATE_UNAVAILABLE) {}

tS32 cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_MOST_CONFIG_STATE;
}


cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE::~cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_TLA_STATE::cfc_fi_tcl_SPM_e32_TLA_STATE():enType(FI_EN_SPM_U32_TLA_STATE_UNAVAILABLE) {}

tS32 cfc_fi_tcl_SPM_e32_TLA_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_TLA_STATE;
}


cfc_fi_tcl_SPM_e32_TLA_STATE::~cfc_fi_tcl_SPM_e32_TLA_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_TLA_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_TLA_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_TLA_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_PROCESSOR_STATE::cfc_fi_tcl_SPM_e32_PROCESSOR_STATE():enType(FI_EN_SPM_U32_PROC_STATE_NORMAL) {}

tS32 cfc_fi_tcl_SPM_e32_PROCESSOR_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_PROCESSOR_STATE;
}


cfc_fi_tcl_SPM_e32_PROCESSOR_STATE::~cfc_fi_tcl_SPM_e32_PROCESSOR_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_PROCESSOR_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_PROCESSOR_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_PROCESSOR_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_STARTUP_STATE::cfc_fi_tcl_SPM_e32_STARTUP_STATE():enType(FI_EN_SPM_U32_STARTUP_STATE_INIT) {}

tS32 cfc_fi_tcl_SPM_e32_STARTUP_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_STARTUP_STATE;
}


cfc_fi_tcl_SPM_e32_STARTUP_STATE::~cfc_fi_tcl_SPM_e32_STARTUP_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_STARTUP_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_STARTUP_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_STARTUP_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_RESTART_TYPE::cfc_fi_tcl_SPM_e32_RESTART_TYPE():enType(FI_EN_SPM_U32_RESTART_ECU) {}

tS32 cfc_fi_tcl_SPM_e32_RESTART_TYPE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_RESTART_TYPE;
}


cfc_fi_tcl_SPM_e32_RESTART_TYPE::~cfc_fi_tcl_SPM_e32_RESTART_TYPE()
{}

tU32 cfc_fi_tcl_SPM_e32_RESTART_TYPE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_RESTART_TYPE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_RESTART_TYPE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_CODE_REQUEST::cfc_fi_tcl_SPM_e32_CODE_REQUEST():enType(FI_EN_SPM_U32_CODE_IDLE) {}

tS32 cfc_fi_tcl_SPM_e32_CODE_REQUEST::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_CODE_REQUEST;
}


cfc_fi_tcl_SPM_e32_CODE_REQUEST::~cfc_fi_tcl_SPM_e32_CODE_REQUEST()
{}

tU32 cfc_fi_tcl_SPM_e32_CODE_REQUEST::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_CODE_REQUEST::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_CODE_REQUEST::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST::cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST():enType(FI_EN_SPM_U32_PHONE_ABORT_IDLE) {}

tS32 cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_PHONE_ABORT_REQUEST;
}


cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST::~cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST()
{}

tU32 cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_WAKEUP_REASON::cfc_fi_tcl_SPM_e32_WAKEUP_REASON():enType(FI_EN_SPM_U32_WAKEUP_INVALID) {}

tS32 cfc_fi_tcl_SPM_e32_WAKEUP_REASON::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_WAKEUP_REASON;
}


cfc_fi_tcl_SPM_e32_WAKEUP_REASON::~cfc_fi_tcl_SPM_e32_WAKEUP_REASON()
{}

tU32 cfc_fi_tcl_SPM_e32_WAKEUP_REASON::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_WAKEUP_REASON::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_WAKEUP_REASON::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_SWITCHON_REASON::cfc_fi_tcl_SPM_e32_SWITCHON_REASON():enType(FI_EN_SPM_U32_ACCESSORY) {}

tS32 cfc_fi_tcl_SPM_e32_SWITCHON_REASON::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_SWITCHON_REASON;
}


cfc_fi_tcl_SPM_e32_SWITCHON_REASON::~cfc_fi_tcl_SPM_e32_SWITCHON_REASON()
{}

tU32 cfc_fi_tcl_SPM_e32_SWITCHON_REASON::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_SWITCHON_REASON::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_SWITCHON_REASON::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE():enType(FI_EN_SPM_U32_EJECT_RELEASED) {}

tS32 cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_MEDIA_EJECT_STATE;
}


cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::~cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_KEY_STATE::cfc_fi_tcl_SPM_e32_KEY_STATE():enType(FI_EN_SPM_U32_RELEASED) {}

tS32 cfc_fi_tcl_SPM_e32_KEY_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_KEY_STATE;
}


cfc_fi_tcl_SPM_e32_KEY_STATE::~cfc_fi_tcl_SPM_e32_KEY_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_KEY_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_KEY_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_KEY_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_STARTUP_REASON::cfc_fi_tcl_SPM_e32_STARTUP_REASON():enType(FI_EN_SPM_U32_STARTUP_ON_EJECT) {}

tS32 cfc_fi_tcl_SPM_e32_STARTUP_REASON::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_STARTUP_REASON;
}


cfc_fi_tcl_SPM_e32_STARTUP_REASON::~cfc_fi_tcl_SPM_e32_STARTUP_REASON()
{}

tU32 cfc_fi_tcl_SPM_e32_STARTUP_REASON::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_STARTUP_REASON::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_STARTUP_REASON::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE::cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE():enType(FI_EN_SPM_U32_PHONEMUTE_INACTIVE) {}

tS32 cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_PHONE_MUTE_STATE;
}


cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE::~cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_LcmResetReason::cfc_fi_tcl_e8_LcmResetReason():enType(FI_EN_SPM_EHMI_APP_ERROR) {}

tS32 cfc_fi_tcl_e8_LcmResetReason::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_LCMRESETREASON;
}


cfc_fi_tcl_e8_LcmResetReason::~cfc_fi_tcl_e8_LcmResetReason()
{}

tU32 cfc_fi_tcl_e8_LcmResetReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_LcmResetReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_LcmResetReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_CVM_EVENT::cfc_fi_tcl_SPM_e32_CVM_EVENT():enType(FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START) {}

tS32 cfc_fi_tcl_SPM_e32_CVM_EVENT::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_CVM_EVENT;
}


cfc_fi_tcl_SPM_e32_CVM_EVENT::~cfc_fi_tcl_SPM_e32_CVM_EVENT()
{}

tU32 cfc_fi_tcl_SPM_e32_CVM_EVENT::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_CVM_EVENT::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_CVM_EVENT::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT::cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT():enType(FI_EN_SPM_U32_CALIBRATED_CVM_CRITICAL_LOW_VOLTAGE_START) {}

tS32 cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_CALIBRATED_CVM_EVENT;
}


cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT::~cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT()
{}

tU32 cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_SYSPWRMODE::cfc_fi_tcl_SPM_e32_SYSPWRMODE():enType(FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED) {}

tS32 cfc_fi_tcl_SPM_e32_SYSPWRMODE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_SYSPWRMODE;
}


cfc_fi_tcl_SPM_e32_SYSPWRMODE::~cfc_fi_tcl_SPM_e32_SYSPWRMODE()
{}

tU32 cfc_fi_tcl_SPM_e32_SYSPWRMODE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_SYSPWRMODE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_SYSPWRMODE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON():enType(FI_EN_SPM_U8_WAKEUP_INVALID) {}

tS32 cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON;
}


cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::~cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON()
{}

tU32 cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_SPM_MonitoringMode::cfc_fi_tcl_e8_SPM_MonitoringMode():enType(FI_EN_SPM_U8_MONITORING_OFF) {}

tS32 cfc_fi_tcl_e8_SPM_MonitoringMode::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_SPM_MONITORINGMODE;
}


cfc_fi_tcl_e8_SPM_MonitoringMode::~cfc_fi_tcl_e8_SPM_MonitoringMode()
{}

tU32 cfc_fi_tcl_e8_SPM_MonitoringMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_SPM_MonitoringMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_SPM_MonitoringMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_SPM_SupervisionControl::cfc_fi_tcl_e8_SPM_SupervisionControl():enType(FI_EN_SPM_U8_SUPERVISION_DEFAULT) {}

tS32 cfc_fi_tcl_e8_SPM_SupervisionControl::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_SPM_SUPERVISIONCONTROL;
}


cfc_fi_tcl_e8_SPM_SupervisionControl::~cfc_fi_tcl_e8_SPM_SupervisionControl()
{}

tU32 cfc_fi_tcl_e8_SPM_SupervisionControl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_SPM_SupervisionControl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_SPM_SupervisionControl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_TestRoutineParameter::cfc_fi_tcl_SPM_TestRoutineParameter(const cfc_fi_tcl_SPM_TestRoutineParameter& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   WriteToRM = coRef.WriteToRM;
   MonitoringMode = coRef.MonitoringMode;
   SupervisionControl = coRef.SupervisionControl;
}
cfc_fi_tcl_SPM_TestRoutineParameter& cfc_fi_tcl_SPM_TestRoutineParameter::operator=(const cfc_fi_tcl_SPM_TestRoutineParameter& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   WriteToRM = coRef.WriteToRM;
   MonitoringMode = coRef.MonitoringMode;
   SupervisionControl = coRef.SupervisionControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_TestRoutineParameter::cfc_fi_tcl_SPM_TestRoutineParameter()
:TroubleCode(0)
,WriteToRM(0)
,MonitoringMode()
,SupervisionControl()
 {}

tS32 cfc_fi_tcl_SPM_TestRoutineParameter::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_TESTROUTINEPARAMETER;
}


cfc_fi_tcl_SPM_TestRoutineParameter::~cfc_fi_tcl_SPM_TestRoutineParameter()
{}

tU32 cfc_fi_tcl_SPM_TestRoutineParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cfc_fi_tcl_SPM_TestRoutineParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> WriteToRM);
   (tVoid) (oIn >> MonitoringMode);
   (tVoid) (oIn >> SupervisionControl);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_TestRoutineParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << WriteToRM);
   (tVoid) (oOut << MonitoringMode);
   (tVoid) (oOut << SupervisionControl);
   return oOut;
}

tBool cfc_fi_tcl_SPM_TestRoutineParameter::operator==(const cfc_fi_tcl_SPM_TestRoutineParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (WriteToRM == roRef.WriteToRM);
   bResult = bResult && (MonitoringMode == roRef.MonitoringMode);
   bResult = bResult && (SupervisionControl == roRef.SupervisionControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_TestRoutineParameterList::cfc_fi_tcl_SPM_TestRoutineParameterList(const cfc_fi_tcl_SPM_TestRoutineParameterList& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   TestRoutineParameterList = coRef.TestRoutineParameterList;
}
cfc_fi_tcl_SPM_TestRoutineParameterList& cfc_fi_tcl_SPM_TestRoutineParameterList::operator=(const cfc_fi_tcl_SPM_TestRoutineParameterList& coRef)
{
   if (this == &coRef) return *this;
   TestRoutineParameterList = coRef.TestRoutineParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_SPM_TestRoutineParameterList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
         TestRoutineParameterList[u32Idx].vDestroy();
   TestRoutineParameterList.clear();
   }
}

cfc_fi_tcl_SPM_TestRoutineParameterList::cfc_fi_tcl_SPM_TestRoutineParameterList()

 {}

tS32 cfc_fi_tcl_SPM_TestRoutineParameterList::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_TESTROUTINEPARAMETERLIST;
}


cfc_fi_tcl_SPM_TestRoutineParameterList::~cfc_fi_tcl_SPM_TestRoutineParameterList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_SPM_TestRoutineParameterList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TestRoutineParameterList.size()*5);
}

fi_tclInContext& cfc_fi_tcl_SPM_TestRoutineParameterList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
      {
         TestRoutineParameterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TestRoutineParameterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TestRoutineParameterList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_TestRoutineParameterList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TestRoutineParameterList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
         (tVoid) (oOut << TestRoutineParameterList[u32Idx]);
   }
   return oOut;
}

tBool cfc_fi_tcl_SPM_TestRoutineParameterList::operator==(const cfc_fi_tcl_SPM_TestRoutineParameterList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TestRoutineParameterList.size() == roRef.TestRoutineParameterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TestRoutineParameterList.size()); ++u32Idx)
            bResult = bResult && (TestRoutineParameterList[u32Idx] == roRef.TestRoutineParameterList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_SPM_TestResult::cfc_fi_tcl_e8_SPM_TestResult():enType(FI_EN_PASSED) {}

tS32 cfc_fi_tcl_e8_SPM_TestResult::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_SPM_TESTRESULT;
}


cfc_fi_tcl_e8_SPM_TestResult::~cfc_fi_tcl_e8_SPM_TestResult()
{}

tU32 cfc_fi_tcl_e8_SPM_TestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_SPM_TestResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_SPM_TestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_TestResult::cfc_fi_tcl_SPM_TestResult(const cfc_fi_tcl_SPM_TestResult& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   Result = coRef.Result;
}
cfc_fi_tcl_SPM_TestResult& cfc_fi_tcl_SPM_TestResult::operator=(const cfc_fi_tcl_SPM_TestResult& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_TestResult::cfc_fi_tcl_SPM_TestResult()
:TroubleCode(0)
,Result()
 {}

tS32 cfc_fi_tcl_SPM_TestResult::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_TESTRESULT;
}


cfc_fi_tcl_SPM_TestResult::~cfc_fi_tcl_SPM_TestResult()
{}

tU32 cfc_fi_tcl_SPM_TestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& cfc_fi_tcl_SPM_TestResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_TestResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << Result);
   return oOut;
}

tBool cfc_fi_tcl_SPM_TestResult::operator==(const cfc_fi_tcl_SPM_TestResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_TestResultList::cfc_fi_tcl_SPM_TestResultList(const cfc_fi_tcl_SPM_TestResultList& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   TestResultList = coRef.TestResultList;
}
cfc_fi_tcl_SPM_TestResultList& cfc_fi_tcl_SPM_TestResultList::operator=(const cfc_fi_tcl_SPM_TestResultList& coRef)
{
   if (this == &coRef) return *this;
   TestResultList = coRef.TestResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_SPM_TestResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
         TestResultList[u32Idx].vDestroy();
   TestResultList.clear();
   }
}

cfc_fi_tcl_SPM_TestResultList::cfc_fi_tcl_SPM_TestResultList()

 {}

tS32 cfc_fi_tcl_SPM_TestResultList::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_TESTRESULTLIST;
}


cfc_fi_tcl_SPM_TestResultList::~cfc_fi_tcl_SPM_TestResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_SPM_TestResultList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TestResultList.size()*3);
}

fi_tclInContext& cfc_fi_tcl_SPM_TestResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
      {
         TestResultList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TestResultList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TestResultList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_TestResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TestResultList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
         (tVoid) (oOut << TestResultList[u32Idx]);
   }
   return oOut;
}

tBool cfc_fi_tcl_SPM_TestResultList::operator==(const cfc_fi_tcl_SPM_TestResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TestResultList.size() == roRef.TestResultList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TestResultList.size()); ++u32Idx)
            bResult = bResult && (TestResultList[u32Idx] == roRef.TestResultList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_TransPortMode::cfc_fi_tcl_SPM_TransPortMode(const cfc_fi_tcl_SPM_TransPortMode& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   YEAR = coRef.YEAR;
   MONTH = coRef.MONTH;
   DAY = coRef.DAY;
   HOUR = coRef.HOUR;
   MINUTE = coRef.MINUTE;
}
cfc_fi_tcl_SPM_TransPortMode& cfc_fi_tcl_SPM_TransPortMode::operator=(const cfc_fi_tcl_SPM_TransPortMode& coRef)
{
   if (this == &coRef) return *this;
   YEAR = coRef.YEAR;
   MONTH = coRef.MONTH;
   DAY = coRef.DAY;
   HOUR = coRef.HOUR;
   MINUTE = coRef.MINUTE;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_TransPortMode::cfc_fi_tcl_SPM_TransPortMode()
:YEAR(0)
,MONTH(0)
,DAY(0)
,HOUR(0)
,MINUTE(0)
 {}

tS32 cfc_fi_tcl_SPM_TransPortMode::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_TRANSPORTMODE;
}


cfc_fi_tcl_SPM_TransPortMode::~cfc_fi_tcl_SPM_TransPortMode()
{}

tU32 cfc_fi_tcl_SPM_TransPortMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& cfc_fi_tcl_SPM_TransPortMode::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> YEAR);
   (tVoid) (oIn >> MONTH);
   (tVoid) (oIn >> DAY);
   (tVoid) (oIn >> HOUR);
   (tVoid) (oIn >> MINUTE);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_TransPortMode::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << YEAR);
   (tVoid) (oOut << MONTH);
   (tVoid) (oOut << DAY);
   (tVoid) (oOut << HOUR);
   (tVoid) (oOut << MINUTE);
   return oOut;
}

tBool cfc_fi_tcl_SPM_TransPortMode::operator==(const cfc_fi_tcl_SPM_TransPortMode& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (YEAR == roRef.YEAR);
   bResult = bResult && (MONTH == roRef.MONTH);
   bResult = bResult && (DAY == roRef.DAY);
   bResult = bResult && (HOUR == roRef.HOUR);
   bResult = bResult && (MINUTE == roRef.MINUTE);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_TransPortModeList::cfc_fi_tcl_SPM_TransPortModeList(const cfc_fi_tcl_SPM_TransPortModeList& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   TransPortModeList = coRef.TransPortModeList;
}
cfc_fi_tcl_SPM_TransPortModeList& cfc_fi_tcl_SPM_TransPortModeList::operator=(const cfc_fi_tcl_SPM_TransPortModeList& coRef)
{
   if (this == &coRef) return *this;
   TransPortModeList = coRef.TransPortModeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_SPM_TransPortModeList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TransPortModeList.size(); ++u32Idx)
         TransPortModeList[u32Idx].vDestroy();
   TransPortModeList.clear();
   }
}

cfc_fi_tcl_SPM_TransPortModeList::cfc_fi_tcl_SPM_TransPortModeList()

 {}

tS32 cfc_fi_tcl_SPM_TransPortModeList::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_TRANSPORTMODELIST;
}


cfc_fi_tcl_SPM_TransPortModeList::~cfc_fi_tcl_SPM_TransPortModeList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_SPM_TransPortModeList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TransPortModeList.size()*20);
}

fi_tclInContext& cfc_fi_tcl_SPM_TransPortModeList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TransPortModeList.size(); ++u32Idx)
      {
         TransPortModeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TransPortModeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TransPortModeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_TransPortModeList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TransPortModeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TransPortModeList.size(); ++u32Idx)
         (tVoid) (oOut << TransPortModeList[u32Idx]);
   }
   return oOut;
}

tBool cfc_fi_tcl_SPM_TransPortModeList::operator==(const cfc_fi_tcl_SPM_TransPortModeList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TransPortModeList.size() == roRef.TransPortModeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TransPortModeList.size()); ++u32Idx)
            bResult = bResult && (TransPortModeList[u32Idx] == roRef.TransPortModeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE::cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE():enType(FI_EN_SPM_U8_PERSONALIZATION_PROGRESS_NONE) {}

tS32 cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_PERSONALIZATION_PROGRESS_STATE;
}


cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE::~cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE()
{}

tU32 cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_StateModes::cfc_fi_tcl_e8_StateModes():enType(FI_EN_SPM_E8_SYSMODEDOWNLOAD) {}

tS32 cfc_fi_tcl_e8_StateModes::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_STATEMODES;
}


cfc_fi_tcl_e8_StateModes::~cfc_fi_tcl_e8_StateModes()
{}

tU32 cfc_fi_tcl_e8_StateModes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_StateModes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_StateModes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_StateEntryType::cfc_fi_tcl_e8_StateEntryType():enType(FI_EN_SPM_E8_HISTORYENTRYWAKEUP) {}

tS32 cfc_fi_tcl_e8_StateEntryType::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_STATEENTRYTYPE;
}


cfc_fi_tcl_e8_StateEntryType::~cfc_fi_tcl_e8_StateEntryType()
{}

tU32 cfc_fi_tcl_e8_StateEntryType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_StateEntryType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_StateEntryType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SubStateEntry::cfc_fi_tcl_SubStateEntry(const cfc_fi_tcl_SubStateEntry& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   tSubStateMask0 = coRef.tSubStateMask0;
   tSubStateData0 = coRef.tSubStateData0;
   tSubStateMask1 = coRef.tSubStateMask1;
   tSubStateData1 = coRef.tSubStateData1;
   tSubStateMask2 = coRef.tSubStateMask2;
   tSubStateData2 = coRef.tSubStateData2;
}
cfc_fi_tcl_SubStateEntry& cfc_fi_tcl_SubStateEntry::operator=(const cfc_fi_tcl_SubStateEntry& coRef)
{
   if (this == &coRef) return *this;
   tSubStateMask0 = coRef.tSubStateMask0;
   tSubStateData0 = coRef.tSubStateData0;
   tSubStateMask1 = coRef.tSubStateMask1;
   tSubStateData1 = coRef.tSubStateData1;
   tSubStateMask2 = coRef.tSubStateMask2;
   tSubStateData2 = coRef.tSubStateData2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SubStateEntry::cfc_fi_tcl_SubStateEntry()
:tSubStateMask0()
,tSubStateData0()
,tSubStateMask1()
,tSubStateData1()
,tSubStateMask2()
,tSubStateData2()
 {}

tS32 cfc_fi_tcl_SubStateEntry::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SUBSTATEENTRY;
}


cfc_fi_tcl_SubStateEntry::~cfc_fi_tcl_SubStateEntry()
{}

tU32 cfc_fi_tcl_SubStateEntry::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 24;
}

fi_tclInContext& cfc_fi_tcl_SubStateEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSubStateMask0);
   (tVoid) (oIn >> tSubStateData0);
   (tVoid) (oIn >> tSubStateMask1);
   (tVoid) (oIn >> tSubStateData1);
   (tVoid) (oIn >> tSubStateMask2);
   (tVoid) (oIn >> tSubStateData2);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SubStateEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSubStateMask0);
   (tVoid) (oOut << tSubStateData0);
   (tVoid) (oOut << tSubStateMask1);
   (tVoid) (oOut << tSubStateData1);
   (tVoid) (oOut << tSubStateMask2);
   (tVoid) (oOut << tSubStateData2);
   return oOut;
}

tBool cfc_fi_tcl_SubStateEntry::operator==(const cfc_fi_tcl_SubStateEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSubStateMask0 == roRef.tSubStateMask0);
   bResult = bResult && (tSubStateData0 == roRef.tSubStateData0);
   bResult = bResult && (tSubStateMask1 == roRef.tSubStateMask1);
   bResult = bResult && (tSubStateData1 == roRef.tSubStateData1);
   bResult = bResult && (tSubStateMask2 == roRef.tSubStateMask2);
   bResult = bResult && (tSubStateData2 == roRef.tSubStateData2);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_ProcessState::cfc_fi_tcl_e8_ProcessState():enType(FI_EN_SPM_E8_PROCESSTOSTART) {}

tS32 cfc_fi_tcl_e8_ProcessState::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_PROCESSSTATE;
}


cfc_fi_tcl_e8_ProcessState::~cfc_fi_tcl_e8_ProcessState()
{}

tU32 cfc_fi_tcl_e8_ProcessState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_ProcessState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_ProcessState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_ProcessElement::cfc_fi_tcl_ProcessElement(const cfc_fi_tcl_ProcessElement& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   tProcessName = coRef.tProcessName;
   eProcState = coRef.eProcState;
}
cfc_fi_tcl_ProcessElement& cfc_fi_tcl_ProcessElement::operator=(const cfc_fi_tcl_ProcessElement& coRef)
{
   if (this == &coRef) return *this;
   tProcessName = coRef.tProcessName;
   eProcState = coRef.eProcState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_ProcessElement::vDestroy()
{
   tProcessName.vDestroy();
}

cfc_fi_tcl_ProcessElement::cfc_fi_tcl_ProcessElement()
:tProcessName()
,eProcState()
 {}

tS32 cfc_fi_tcl_ProcessElement::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_PROCESSELEMENT;
}


cfc_fi_tcl_ProcessElement::~cfc_fi_tcl_ProcessElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_ProcessElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+tProcessName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_fi_tcl_ProcessElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tProcessName);
   (tVoid) (oIn >> eProcState);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_ProcessElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tProcessName);
   (tVoid) (oOut << eProcState);
   return oOut;
}

tBool cfc_fi_tcl_ProcessElement::operator==(const cfc_fi_tcl_ProcessElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tProcessName == roRef.tProcessName);
   bResult = bResult && (eProcState == roRef.eProcState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_ProcessInfo::cfc_fi_tcl_SPM_ProcessInfo(const cfc_fi_tcl_SPM_ProcessInfo& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   tProcesses = coRef.tProcesses;
}
cfc_fi_tcl_SPM_ProcessInfo& cfc_fi_tcl_SPM_ProcessInfo::operator=(const cfc_fi_tcl_SPM_ProcessInfo& coRef)
{
   if (this == &coRef) return *this;
   tProcesses = coRef.tProcesses;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_SPM_ProcessInfo::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tProcesses.size(); ++u32Idx)
         tProcesses[u32Idx].vDestroy();
   tProcesses.clear();
   }
}

cfc_fi_tcl_SPM_ProcessInfo::cfc_fi_tcl_SPM_ProcessInfo()

 {}

tS32 cfc_fi_tcl_SPM_ProcessInfo::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_PROCESSINFO;
}


cfc_fi_tcl_SPM_ProcessInfo::~cfc_fi_tcl_SPM_ProcessInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_SPM_ProcessInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tProcesses.size(); ++u32ListIdx)
      u32DynamicSize += tProcesses[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& cfc_fi_tcl_SPM_ProcessInfo::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tProcesses.size(); ++u32Idx)
      {
         tProcesses[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tProcesses.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tProcesses[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_ProcessInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tProcesses.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tProcesses.size(); ++u32Idx)
         (tVoid) (oOut << tProcesses[u32Idx]);
   }
   return oOut;
}

tBool cfc_fi_tcl_SPM_ProcessInfo::operator==(const cfc_fi_tcl_SPM_ProcessInfo& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tProcesses.size() == roRef.tProcesses.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tProcesses.size()); ++u32Idx)
            bResult = bResult && (tProcesses[u32Idx] == roRef.tProcesses[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_Vin::cfc_fi_tcl_SPM_Vin(const cfc_fi_tcl_SPM_Vin& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   Vin = coRef.Vin;
}
cfc_fi_tcl_SPM_Vin& cfc_fi_tcl_SPM_Vin::operator=(const cfc_fi_tcl_SPM_Vin& coRef)
{
   if (this == &coRef) return *this;
   Vin = coRef.Vin;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_SPM_Vin::vDestroy()
{
   {
   Vin.clear();
   }
}

cfc_fi_tcl_SPM_Vin::cfc_fi_tcl_SPM_Vin()

 {}

tS32 cfc_fi_tcl_SPM_Vin::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_VIN;
}


cfc_fi_tcl_SPM_Vin::~cfc_fi_tcl_SPM_Vin()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_SPM_Vin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Vin.size()*1);
}

fi_tclInContext& cfc_fi_tcl_SPM_Vin::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Vin.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Vin[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_Vin::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Vin.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Vin.size(); ++u32Idx)
         (tVoid) (oOut << Vin[u32Idx]);
   }
   return oOut;
}

tBool cfc_fi_tcl_SPM_Vin::operator==(const cfc_fi_tcl_SPM_Vin& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Vin.size() == roRef.Vin.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Vin.size()); ++u32Idx)
            bResult = bResult && (Vin[u32Idx] == roRef.Vin[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SPM_VinHistory::cfc_fi_tcl_SPM_VinHistory(const cfc_fi_tcl_SPM_VinHistory& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   VinHistory = coRef.VinHistory;
}
cfc_fi_tcl_SPM_VinHistory& cfc_fi_tcl_SPM_VinHistory::operator=(const cfc_fi_tcl_SPM_VinHistory& coRef)
{
   if (this == &coRef) return *this;
   VinHistory = coRef.VinHistory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_fi_tcl_SPM_VinHistory::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < VinHistory.size(); ++u32Idx)
         VinHistory[u32Idx].vDestroy();
   VinHistory.clear();
   }
}

cfc_fi_tcl_SPM_VinHistory::cfc_fi_tcl_SPM_VinHistory()

 {}

tS32 cfc_fi_tcl_SPM_VinHistory::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_VINHISTORY;
}


cfc_fi_tcl_SPM_VinHistory::~cfc_fi_tcl_SPM_VinHistory()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_fi_tcl_SPM_VinHistory::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < VinHistory.size(); ++u32ListIdx)
      u32DynamicSize += VinHistory[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& cfc_fi_tcl_SPM_VinHistory::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VinHistory.size(); ++u32Idx)
      {
         VinHistory[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      VinHistory.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> VinHistory[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_VinHistory::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)VinHistory.size());
   {
      for (tU32 u32Idx = 0; u32Idx < VinHistory.size(); ++u32Idx)
         (tVoid) (oOut << VinHistory[u32Idx]);
   }
   return oOut;
}

tBool cfc_fi_tcl_SPM_VinHistory::operator==(const cfc_fi_tcl_SPM_VinHistory& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (VinHistory.size() == roRef.VinHistory.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VinHistory.size()); ++u32Idx)
            bResult = bResult && (VinHistory[u32Idx] == roRef.VinHistory[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_ResetElement::cfc_fi_tcl_ResetElement(const cfc_fi_tcl_ResetElement& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   tResetDate = coRef.tResetDate;
   eReset = coRef.eReset;
}
cfc_fi_tcl_ResetElement& cfc_fi_tcl_ResetElement::operator=(const cfc_fi_tcl_ResetElement& coRef)
{
   if (this == &coRef) return *this;
   tResetDate = coRef.tResetDate;
   eReset = coRef.eReset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_ResetElement::cfc_fi_tcl_ResetElement()
:tResetDate()
,eReset()
 {}

tS32 cfc_fi_tcl_ResetElement::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_RESETELEMENT;
}


cfc_fi_tcl_ResetElement::~cfc_fi_tcl_ResetElement()
{}

tU32 cfc_fi_tcl_ResetElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cfc_fi_tcl_ResetElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tResetDate);
   (tVoid) (oIn >> eReset);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_ResetElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tResetDate);
   (tVoid) (oOut << eReset);
   return oOut;
}

tBool cfc_fi_tcl_ResetElement::operator==(const cfc_fi_tcl_ResetElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tResetDate == roRef.tResetDate);
   bResult = bResult && (eReset == roRef.eReset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_WakeupElement::cfc_fi_tcl_WakeupElement(const cfc_fi_tcl_WakeupElement& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   tWakeupDate = coRef.tWakeupDate;
   eWakeupReason = coRef.eWakeupReason;
}
cfc_fi_tcl_WakeupElement& cfc_fi_tcl_WakeupElement::operator=(const cfc_fi_tcl_WakeupElement& coRef)
{
   if (this == &coRef) return *this;
   tWakeupDate = coRef.tWakeupDate;
   eWakeupReason = coRef.eWakeupReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_WakeupElement::cfc_fi_tcl_WakeupElement()
:tWakeupDate()
,eWakeupReason()
 {}

tS32 cfc_fi_tcl_WakeupElement::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_WAKEUPELEMENT;
}


cfc_fi_tcl_WakeupElement::~cfc_fi_tcl_WakeupElement()
{}

tU32 cfc_fi_tcl_WakeupElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_fi_tcl_WakeupElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tWakeupDate);
   (tVoid) (oIn >> eWakeupReason);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_WakeupElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tWakeupDate);
   (tVoid) (oOut << eWakeupReason);
   return oOut;
}

tBool cfc_fi_tcl_WakeupElement::operator==(const cfc_fi_tcl_WakeupElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tWakeupDate == roRef.tWakeupDate);
   bResult = bResult && (eWakeupReason == roRef.eWakeupReason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_StateChangeElement::cfc_fi_tcl_StateChangeElement(const cfc_fi_tcl_StateChangeElement& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   tWakeupDate = coRef.tWakeupDate;
   tSysState = coRef.tSysState;
   tElemType = coRef.tElemType;
   tWakeup = coRef.tWakeup;
   tReset = coRef.tReset;
   tSubStates = coRef.tSubStates;
}
cfc_fi_tcl_StateChangeElement& cfc_fi_tcl_StateChangeElement::operator=(const cfc_fi_tcl_StateChangeElement& coRef)
{
   if (this == &coRef) return *this;
   tWakeupDate = coRef.tWakeupDate;
   tSysState = coRef.tSysState;
   tElemType = coRef.tElemType;
   tWakeup = coRef.tWakeup;
   tReset = coRef.tReset;
   tSubStates = coRef.tSubStates;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_StateChangeElement::cfc_fi_tcl_StateChangeElement()
:tWakeupDate()
,tSysState()
,tElemType()
,tWakeup()
,tReset()
,tSubStates()
 {}

tS32 cfc_fi_tcl_StateChangeElement::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_STATECHANGEELEMENT;
}


cfc_fi_tcl_StateChangeElement::~cfc_fi_tcl_StateChangeElement()
{}

tU32 cfc_fi_tcl_StateChangeElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 41;
}

fi_tclInContext& cfc_fi_tcl_StateChangeElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tWakeupDate);
   (tVoid) (oIn >> tSysState);
   (tVoid) (oIn >> tElemType);
   (tVoid) (oIn >> tWakeup);
   (tVoid) (oIn >> tReset);
   (tVoid) (oIn >> tSubStates);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_StateChangeElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tWakeupDate);
   (tVoid) (oOut << tSysState);
   (tVoid) (oOut << tElemType);
   (tVoid) (oOut << tWakeup);
   (tVoid) (oOut << tReset);
   (tVoid) (oOut << tSubStates);
   return oOut;
}

tBool cfc_fi_tcl_StateChangeElement::operator==(const cfc_fi_tcl_StateChangeElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tWakeupDate == roRef.tWakeupDate);
   bResult = bResult && (tSysState == roRef.tSysState);
   bResult = bResult && (tElemType == roRef.tElemType);
   bResult = bResult && (tWakeup == roRef.tWakeup);
   bResult = bResult && (tReset == roRef.tReset);
   bResult = bResult && (tSubStates == roRef.tSubStates);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_SwitchOnElement::cfc_fi_tcl_SwitchOnElement(const cfc_fi_tcl_SwitchOnElement& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   tSwitchOnDate = coRef.tSwitchOnDate;
   eSwitchOnReason = coRef.eSwitchOnReason;
}
cfc_fi_tcl_SwitchOnElement& cfc_fi_tcl_SwitchOnElement::operator=(const cfc_fi_tcl_SwitchOnElement& coRef)
{
   if (this == &coRef) return *this;
   tSwitchOnDate = coRef.tSwitchOnDate;
   eSwitchOnReason = coRef.eSwitchOnReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SwitchOnElement::cfc_fi_tcl_SwitchOnElement()
:tSwitchOnDate()
,eSwitchOnReason()
 {}

tS32 cfc_fi_tcl_SwitchOnElement::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SWITCHONELEMENT;
}


cfc_fi_tcl_SwitchOnElement::~cfc_fi_tcl_SwitchOnElement()
{}

tU32 cfc_fi_tcl_SwitchOnElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_fi_tcl_SwitchOnElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSwitchOnDate);
   (tVoid) (oIn >> eSwitchOnReason);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SwitchOnElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSwitchOnDate);
   (tVoid) (oOut << eSwitchOnReason);
   return oOut;
}

tBool cfc_fi_tcl_SwitchOnElement::operator==(const cfc_fi_tcl_SwitchOnElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSwitchOnDate == roRef.tSwitchOnDate);
   bResult = bResult && (eSwitchOnReason == roRef.eSwitchOnReason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_e32_START_PROC_TYPE::cfc_fi_tcl_SPM_e32_START_PROC_TYPE():enType(FI_EN_SPM_U32_START_PROC_TYPE_OSAL_SPAWN) {}

tS32 cfc_fi_tcl_SPM_e32_START_PROC_TYPE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_E32_START_PROC_TYPE;
}


cfc_fi_tcl_SPM_e32_START_PROC_TYPE::~cfc_fi_tcl_SPM_e32_START_PROC_TYPE()
{}

tU32 cfc_fi_tcl_SPM_e32_START_PROC_TYPE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_e32_START_PROC_TYPE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_SPM_e32_START_PROC_TYPE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE::cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE():u32Value(0)
{}

tS32 cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_SPM_B32_SYSPWRSAVEMODE;
}


cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE::~cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE()
{}

tU32 cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_Vehicle_Data_U8_ACC_Status::cfc_fi_tcl_Vehicle_Data_U8_ACC_Status():enType(FI_EN_ACC_OFF) {}

tS32 cfc_fi_tcl_Vehicle_Data_U8_ACC_Status::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_VEHICLE_DATA_U8_ACC_STATUS;
}


cfc_fi_tcl_Vehicle_Data_U8_ACC_Status::~cfc_fi_tcl_Vehicle_Data_U8_ACC_Status()
{}

tU32 cfc_fi_tcl_Vehicle_Data_U8_ACC_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_Vehicle_Data_U8_ACC_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_Vehicle_Data_U8_ACC_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity::cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity():enType(FI_EN_NO_CRASH) {}

tS32 cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_VEHICLE_DATA_U8_CRASH_INTENSITY;
}


cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity::~cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity()
{}

tU32 cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status::cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status():enType(FI_EN_VALID_INFO) {}

tS32 cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_VEHICLE_DATA_U8_OIL_INFO_STATUS;
}


cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status::~cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status()
{}

tU32 cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code::cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code():enType(FI_EN_NO_KEY) {}

tS32 cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_VEHICLE_DATA_U8_MFL_KEY_CODE;
}


cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code::~cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code()
{}

tU32 cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode::cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode():enType(FI_EN_NO_EVENT) {}

tS32 cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_VEHICLE_DATA_U8_MFL_EVENTCODE;
}


cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode::~cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode()
{}

tU32 cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_fi_tcl_Car_ViewOptions::cfc_fi_tcl_Car_ViewOptions(const cfc_fi_tcl_Car_ViewOptions& coRef)
   : cfc_fi_tclVisitableTypeBase(coRef)
{
   state = coRef.state;
   reason = coRef.reason;
}
cfc_fi_tcl_Car_ViewOptions& cfc_fi_tcl_Car_ViewOptions::operator=(const cfc_fi_tcl_Car_ViewOptions& coRef)
{
   if (this == &coRef) return *this;
   state = coRef.state;
   reason = coRef.reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_Car_ViewOptions::cfc_fi_tcl_Car_ViewOptions()
:state(0)
,reason(0)
 {}

tS32 cfc_fi_tcl_Car_ViewOptions::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_CAR_VIEWOPTIONS;
}


cfc_fi_tcl_Car_ViewOptions::~cfc_fi_tcl_Car_ViewOptions()
{}

tU32 cfc_fi_tcl_Car_ViewOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cfc_fi_tcl_Car_ViewOptions::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> state);
   (tVoid) (oIn >> reason);
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_Car_ViewOptions::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << state);
   (tVoid) (oOut << reason);
   return oOut;
}

tBool cfc_fi_tcl_Car_ViewOptions::operator==(const cfc_fi_tcl_Car_ViewOptions& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (state == roRef.state);
   bResult = bResult && (reason == roRef.reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_DefSetMode::cfc_fi_tcl_e8_DefSetMode():enType(FI_EN_DEFSET_SRC_NOT_DEF) {}

tS32 cfc_fi_tcl_e8_DefSetMode::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_DEFSETMODE;
}


cfc_fi_tcl_e8_DefSetMode::~cfc_fi_tcl_e8_DefSetMode()
{}

tU32 cfc_fi_tcl_e8_DefSetMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_DefSetMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_DefSetMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_fi_tcl_e8_DefSetServiceStatus::cfc_fi_tcl_e8_DefSetServiceStatus():enType(FI_EN_DEFSET_STATE_UNDEFINED) {}

tS32 cfc_fi_tcl_e8_DefSetServiceStatus::s32GetTypeId() const
{
   return (tS32) cfc_typesfi_tclToken::EN_E8_DEFSETSERVICESTATUS;
}


cfc_fi_tcl_e8_DefSetServiceStatus::~cfc_fi_tcl_e8_DefSetServiceStatus()
{}

tU32 cfc_fi_tcl_e8_DefSetServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_fi_tcl_e8_DefSetServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cfc_fi_tcl_e8_DefSetServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

