#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_TYPES
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_SERVICEINFO
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_TYPES
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_SERVICEINFO
#include "cfc_fi_if.h"

#include "alltypefactory.h"

fi_tclTypeBase* cfc_fi_poGetFIObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   fi_tclMessageBase* poType
   = cfc_fi_poGetMessageBaseObject(u16ServiceId, u16FunctionId, u8Opcode);
   if (poType)
      return &poType->rfoGetTypeBase();
   else
      return OSAL_NULL;
}

fi_tclMessageBase* cfc_fi_poGetMessageBaseObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   switch(u16ServiceId)
   {
      case CFC_SPMFI_C_U16_SERVICE_ID:
         return cfc_spmfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case CFC_VEHICLEFI_C_U16_SERVICE_ID:
         return cfc_vehiclefi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      default: 
         return OSAL_NULL;
   }
}

