#ifndef CFC_FIVISITOR_HEADER
#define CFC_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class cfc_fi_tclOutput {
public:
   cfc_fi_tclOutput();
   virtual ~cfc_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class cfc_fi_tclFileOutput : public cfc_fi_tclOutput 
{
public:
   cfc_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   cfc_fi_tclFileOutput(); //lint !e1704
   cfc_fi_tclFileOutput& operator=(const cfc_fi_tclFileOutput& coRef);
   cfc_fi_tclFileOutput(const cfc_fi_tclFileOutput& coRef); //lint !e1704
};

class cfc_fi_tclMemOutput : public cfc_fi_tclOutput
{
public:
   cfc_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~cfc_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   cfc_fi_tclMemOutput(); //lint !e1704
   cfc_fi_tclMemOutput(const cfc_fi_tclMemOutput& coRef); //lint !e1704
   cfc_fi_tclMemOutput& operator=(const cfc_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL cfc_fi_tclVisitorBase {
public:

   // --Konstruktor
   cfc_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~cfc_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(cfc_fi_tclU8& oU8);
   virtual tVoid vVisitS8(cfc_fi_tclS8& oS8);
   virtual tVoid vVisitU16(cfc_fi_tclU16& oU16);
   virtual tVoid vVisitS16(cfc_fi_tclS16& oS16);
   virtual tVoid vVisitU24(cfc_fi_tclU24& oU24);
   virtual tVoid vVisitS24(cfc_fi_tclS24& oS24);
   virtual tVoid vVisitU32(cfc_fi_tclU32& oU32);
   virtual tVoid vVisitS32(cfc_fi_tclS32& oS32);
   virtual tVoid vVisitU64(cfc_fi_tclU64& oU64);
   virtual tVoid vVisitS64(cfc_fi_tclS64& oS64);
   virtual tVoid vVisitF32(cfc_fi_tclF32& oF32);
   virtual tVoid vVisitF64(cfc_fi_tclF64& oF64);
   virtual tVoid vVisitBool(cfc_fi_tclBool& oBool);
   virtual tVoid vVisitString(cfc_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(cfc_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(cfc_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(cfc_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(cfc_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(cfc_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(cfc_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(cfc_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(cfc_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(cfc_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(cfc_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(cfc_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(cfc_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(cfc_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(cfc_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(cfc_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(cfc_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(cfc_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(cfc_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(cfc_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(cfc_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(cfc_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(cfc_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(cfc_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(cfc_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(cfc_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(cfc_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(cfc_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(cfc_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(cfc_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(cfc_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(cfc_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(cfc_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(cfc_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(cfc_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(cfc_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(cfc_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(cfc_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(cfc_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(cfc_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(cfc_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(cfc_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(cfc_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(cfc_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(cfc_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(cfc_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(cfc_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(cfc_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(cfc_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisitTimeDate(cfc_fi_tclTimeDate& oimeDate);

   virtual tVoid vVisit_b32_SubState0(cfc_fi_tcl_b32_SubState0& ob32_SubState0);

   virtual tVoid vVisit_b32_SubState1(cfc_fi_tcl_b32_SubState1& ob32_SubState1);

   virtual tVoid vVisit_b32_SubState2(cfc_fi_tcl_b32_SubState2& ob32_SubState2);

   virtual tVoid vVisit_SPM_e32_SubStateType(cfc_fi_tcl_SPM_e32_SubStateType& oSPM_e32_SubStateType);

   virtual tVoid vVisit_SPM_e32_OnOffReason(cfc_fi_tcl_SPM_e32_OnOffReason& oSPM_e32_OnOffReason);

   virtual tVoid vVisit_SPM_e32_SYSTEM_STATES(cfc_fi_tcl_SPM_e32_SYSTEM_STATES& oSPM_e32_SYSTEM_STATES);

   virtual tVoid vVisit_SPM_e32_SYSPWR_BEHAVIOUR(cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR& oSPM_e32_SYSPWR_BEHAVIOUR);

   virtual tVoid vVisit_SPM_e32_HMI_STATE(cfc_fi_tcl_SPM_e32_HMI_STATE& oSPM_e32_HMI_STATE);

   virtual tVoid vVisit_SPM_e32_DIM_STATE(cfc_fi_tcl_SPM_e32_DIM_STATE& oSPM_e32_DIM_STATE);

   virtual tVoid vVisit_SPM_b32_DIM_STATE(cfc_fi_tcl_SPM_b32_DIM_STATE& oSPM_b32_DIM_STATE);

   virtual tVoid vVisit_SPM_e32_MMGR_STATE(cfc_fi_tcl_SPM_e32_MMGR_STATE& oSPM_e32_MMGR_STATE);

   virtual tVoid vVisit_SPM_e32_AUDIO_STATE(cfc_fi_tcl_SPM_e32_AUDIO_STATE& oSPM_e32_AUDIO_STATE);

   virtual tVoid vVisit_SPM_e32_AUDIO_SOURCE(cfc_fi_tcl_SPM_e32_AUDIO_SOURCE& oSPM_e32_AUDIO_SOURCE);

   virtual tVoid vVisit_SPM_e32_CD_EJECT_STATE(cfc_fi_tcl_SPM_e32_CD_EJECT_STATE& oSPM_e32_CD_EJECT_STATE);

   virtual tVoid vVisit_SPM_e32_CD_INSERT_STATE(cfc_fi_tcl_SPM_e32_CD_INSERT_STATE& oSPM_e32_CD_INSERT_STATE);

   virtual tVoid vVisit_SPM_e32_SYS_STATE(cfc_fi_tcl_SPM_e32_SYS_STATE& oSPM_e32_SYS_STATE);

   virtual tVoid vVisit_SPM_e32_MOST_EVENT(cfc_fi_tcl_SPM_e32_MOST_EVENT& oSPM_e32_MOST_EVENT);

   virtual tVoid vVisit_SPM_e32_MOST_CONFIG_STATE(cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE& oSPM_e32_MOST_CONFIG_STATE);

   virtual tVoid vVisit_SPM_e32_TLA_STATE(cfc_fi_tcl_SPM_e32_TLA_STATE& oSPM_e32_TLA_STATE);

   virtual tVoid vVisit_SPM_e32_PROCESSOR_STATE(cfc_fi_tcl_SPM_e32_PROCESSOR_STATE& oSPM_e32_PROCESSOR_STATE);

   virtual tVoid vVisit_SPM_e32_STARTUP_STATE(cfc_fi_tcl_SPM_e32_STARTUP_STATE& oSPM_e32_STARTUP_STATE);

   virtual tVoid vVisit_SPM_e32_RESTART_TYPE(cfc_fi_tcl_SPM_e32_RESTART_TYPE& oSPM_e32_RESTART_TYPE);

   virtual tVoid vVisit_SPM_e32_CODE_REQUEST(cfc_fi_tcl_SPM_e32_CODE_REQUEST& oSPM_e32_CODE_REQUEST);

   virtual tVoid vVisit_SPM_e32_PHONE_ABORT_REQUEST(cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST& oSPM_e32_PHONE_ABORT_REQUEST);

   virtual tVoid vVisit_SPM_e32_WAKEUP_REASON(cfc_fi_tcl_SPM_e32_WAKEUP_REASON& oSPM_e32_WAKEUP_REASON);

   virtual tVoid vVisit_SPM_e32_SWITCHON_REASON(cfc_fi_tcl_SPM_e32_SWITCHON_REASON& oSPM_e32_SWITCHON_REASON);

   virtual tVoid vVisit_SPM_e32_MEDIA_EJECT_STATE(cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE& oSPM_e32_MEDIA_EJECT_STATE);

   virtual tVoid vVisit_SPM_e32_KEY_STATE(cfc_fi_tcl_SPM_e32_KEY_STATE& oSPM_e32_KEY_STATE);

   virtual tVoid vVisit_SPM_e32_STARTUP_REASON(cfc_fi_tcl_SPM_e32_STARTUP_REASON& oSPM_e32_STARTUP_REASON);

   virtual tVoid vVisit_SPM_e32_PHONE_MUTE_STATE(cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE& oSPM_e32_PHONE_MUTE_STATE);

   virtual tVoid vVisit_e8_LcmResetReason(cfc_fi_tcl_e8_LcmResetReason& oe8_LcmResetReason);

   virtual tVoid vVisit_SPM_e32_CVM_EVENT(cfc_fi_tcl_SPM_e32_CVM_EVENT& oSPM_e32_CVM_EVENT);

   virtual tVoid vVisit_SPM_e32_CALIBRATED_CVM_EVENT(cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT& oSPM_e32_CALIBRATED_CVM_EVENT);

   virtual tVoid vVisit_SPM_e32_SYSPWRMODE(cfc_fi_tcl_SPM_e32_SYSPWRMODE& oSPM_e32_SYSPWRMODE);

   virtual tVoid vVisit_SPM_e8_WAKEUP_LIST_REASON(cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON& oSPM_e8_WAKEUP_LIST_REASON);

   virtual tVoid vVisit_e8_SPM_MonitoringMode(cfc_fi_tcl_e8_SPM_MonitoringMode& oe8_SPM_MonitoringMode);

   virtual tVoid vVisit_e8_SPM_SupervisionControl(cfc_fi_tcl_e8_SPM_SupervisionControl& oe8_SPM_SupervisionControl);

   virtual tVoid vVisit_SPM_TestRoutineParameter(cfc_fi_tcl_SPM_TestRoutineParameter& oSPM_TestRoutineParameter);

   virtual tVoid vVisit_SPM_TestRoutineParameterList(cfc_fi_tcl_SPM_TestRoutineParameterList& oSPM_TestRoutineParameterList);

   virtual tVoid vVisit_e8_SPM_TestResult(cfc_fi_tcl_e8_SPM_TestResult& oe8_SPM_TestResult);

   virtual tVoid vVisit_SPM_TestResult(cfc_fi_tcl_SPM_TestResult& oSPM_TestResult);

   virtual tVoid vVisit_SPM_TestResultList(cfc_fi_tcl_SPM_TestResultList& oSPM_TestResultList);

   virtual tVoid vVisit_SPM_TransPortMode(cfc_fi_tcl_SPM_TransPortMode& oSPM_TransPortMode);

   virtual tVoid vVisit_SPM_TransPortModeList(cfc_fi_tcl_SPM_TransPortModeList& oSPM_TransPortModeList);

   virtual tVoid vVisit_SPM_e32_PERSONALIZATION_PROGRESS_STATE(cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE& oSPM_e32_PERSONALIZATION_PROGRESS_STATE);

   virtual tVoid vVisit_e8_StateModes(cfc_fi_tcl_e8_StateModes& oe8_StateModes);

   virtual tVoid vVisit_e8_StateEntryType(cfc_fi_tcl_e8_StateEntryType& oe8_StateEntryType);

   virtual tVoid vVisit_SubStateEntry(cfc_fi_tcl_SubStateEntry& oSubStateEntry);

   virtual tVoid vVisit_e8_ProcessState(cfc_fi_tcl_e8_ProcessState& oe8_ProcessState);

   virtual tVoid vVisit_ProcessElement(cfc_fi_tcl_ProcessElement& oProcessElement);

   virtual tVoid vVisit_SPM_ProcessInfo(cfc_fi_tcl_SPM_ProcessInfo& oSPM_ProcessInfo);

   virtual tVoid vVisit_SPM_Vin(cfc_fi_tcl_SPM_Vin& oSPM_Vin);

   virtual tVoid vVisit_SPM_VinHistory(cfc_fi_tcl_SPM_VinHistory& oSPM_VinHistory);

   virtual tVoid vVisit_ResetElement(cfc_fi_tcl_ResetElement& oResetElement);

   virtual tVoid vVisit_WakeupElement(cfc_fi_tcl_WakeupElement& oWakeupElement);

   virtual tVoid vVisit_StateChangeElement(cfc_fi_tcl_StateChangeElement& oStateChangeElement);

   virtual tVoid vVisit_SwitchOnElement(cfc_fi_tcl_SwitchOnElement& oSwitchOnElement);

   virtual tVoid vVisit_SPM_e32_START_PROC_TYPE(cfc_fi_tcl_SPM_e32_START_PROC_TYPE& oSPM_e32_START_PROC_TYPE);

   virtual tVoid vVisit_SPM_b32_SYSPWRSAVEMODE(cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE& oSPM_b32_SYSPWRSAVEMODE);

   virtual tVoid vVisit_Vehicle_Data_U8_ACC_Status(cfc_fi_tcl_Vehicle_Data_U8_ACC_Status& oVehicle_Data_U8_ACC_Status);

   virtual tVoid vVisit_Vehicle_Data_U8_Crash_Intensity(cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity& oVehicle_Data_U8_Crash_Intensity);

   virtual tVoid vVisit_Vehicle_Data_U8_Oil_Info_Status(cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status& oVehicle_Data_U8_Oil_Info_Status);

   virtual tVoid vVisit_Vehicle_Data_U8_MFL_Key_Code(cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code& oVehicle_Data_U8_MFL_Key_Code);

   virtual tVoid vVisit_Vehicle_Data_U8_MFL_EventCode(cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode& oVehicle_Data_U8_MFL_EventCode);

   virtual tVoid vVisit_Car_ViewOptions(cfc_fi_tcl_Car_ViewOptions& oCar_ViewOptions);

   virtual tVoid vVisit_e8_DefSetMode(cfc_fi_tcl_e8_DefSetMode& oe8_DefSetMode);

   virtual tVoid vVisit_e8_DefSetServiceStatus(cfc_fi_tcl_e8_DefSetServiceStatus& oe8_DefSetServiceStatus);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
