/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CFC_ALLFITYPES_HEADER
#define CFC_ALLFITYPES_HEADER

#include <vector>

class cfc_fi_tclVisitorBase;

const tU16 CFC_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 CFC_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 CFC_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class cfc_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  cfc_fi_tclTypeBase() {}
  virtual ~cfc_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& /*oVisitor*/) {}
};

class cfc_fi_tclVisitableTypeBase :public cfc_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& /*oVisitor*/) {}
};

class cfc_fi_tclU8 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_U8;}
};

class cfc_fi_tclS8 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_S8;}
};

class cfc_fi_tclU16 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_U16;}
};

class cfc_fi_tclS16 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_S16;}
};

class cfc_fi_tclU24 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_U24;}
};

class cfc_fi_tclS24 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_S24;}
};

class cfc_fi_tclU32 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_U32;}
};

class cfc_fi_tclS32 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_S32;}
};

class cfc_fi_tclU64 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_U64;}
};

class cfc_fi_tclS64 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_S64;}
};

class cfc_fi_tclF32 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_F32;}
};

class cfc_fi_tclF64 : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_F64;}
};

class cfc_fi_tclBool : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const cfc_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_BOOL;}
};

class cfc_fi_tclString : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tclString(const cfc_fi_tclString& coRef);
   cfc_fi_tclString& operator=(const cfc_fi_tclString& coRef);
   virtual ~cfc_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const cfc_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   cfc_fi_tclString& operator=(tCString coszString); // ADDED
   cfc_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const cfc_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class cfc_fi_tclList : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const cfc_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_LIST;}
};

class cfc_fi_tclMultiLanguageString : public cfc_fi_tclVisitableTypeBase
{
public:
   cfc_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tclMultiLanguageString(const cfc_fi_tclMultiLanguageString& coRef);
   cfc_fi_tclMultiLanguageString& operator=(const cfc_fi_tclMultiLanguageString& coRef);
   virtual ~cfc_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const cfc_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(cfc_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   cfc_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   cfc_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return cfc_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const cfc_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class cfc_fi_tcl_BinContainer;
class cfc_fi_tcl_Reserved;
class cfc_fi_tcl_u8_Percent;
class cfc_fi_tcl_s16_PerThousand;
class cfc_fi_tcl_u16_IndexInReferenceList;
class cfc_fi_tcl_u16_ErrorCode;
class cfc_fi_tcl_u16_RPM;
class cfc_fi_tcl_s32_Kilogram;
class cfc_fi_tcl_s32_Pound;
class cfc_fi_tcl_s16_Meter;
class cfc_fi_tcl_s32_Meter;
class cfc_fi_tcl_s32_Yards;
class cfc_fi_tcl_s32_Foot;
class cfc_fi_tcl_s32_Centimeter;
class cfc_fi_tcl_s32_Inch;
class cfc_fi_tcl_s32_Millimeter;
class cfc_fi_tcl_s32_Microliter;
class cfc_fi_tcl_s32_Second;
class cfc_fi_tcl_u16_MilliSecond;
class cfc_fi_tcl_s32_MilliSecond;
class cfc_fi_tcl_POSIXTime;
class cfc_fi_tcl_e8_DST_State;
class cfc_fi_tcl_TimeZoneElement;
class cfc_fi_tcl_s16_KmPerHour;
class cfc_fi_tcl_s16_MilesPerHour;
class cfc_fi_tcl_s16_Knot;
class cfc_fi_tcl_s16_CentimeterSecond;
class cfc_fi_tcl_s16_Kelvin;
class cfc_fi_tcl_s16_Fahrenheit;
class cfc_fi_tcl_s32_Pascal;
class cfc_fi_tcl_s32_Watt;
class cfc_fi_tcl_FIVersion;
class cfc_fi_tcl_s32_Longitude;
class cfc_fi_tcl_s32_Latitude;
class cfc_fi_tcl_PositionWGS84;
class cfc_fi_tcl_RectangleWGS84;
class cfc_fi_tcl_e16_ISOCountryCode;
class cfc_fi_tcl_e16_ISOLanguageCode;
class cfc_fi_tcl_LanguageID;
class cfc_fi_tcl_u8_DirectionAbsolute;
class cfc_fi_tcl_u8_DirectionRelative;
class cfc_fi_tcl_s16_CentiDegree;
class cfc_fi_tcl_s16_Degree;
class cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class cfc_fi_tcl_s16_DirectionRelative_CentiDegree;
class cfc_fi_tcl_e8_FuelType;
class cfc_fi_tcl_DistTimeFuel;
class cfc_fi_tclTimeDate;
class cfc_fi_tcl_b32_SubState0;
class cfc_fi_tcl_b32_SubState1;
class cfc_fi_tcl_b32_SubState2;
class cfc_fi_tcl_SPM_e32_SubStateType;
class cfc_fi_tcl_SPM_e32_OnOffReason;
class cfc_fi_tcl_SPM_e32_SYSTEM_STATES;
class cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR;
class cfc_fi_tcl_SPM_e32_HMI_STATE;
class cfc_fi_tcl_SPM_e32_DIM_STATE;
class cfc_fi_tcl_SPM_b32_DIM_STATE;
class cfc_fi_tcl_SPM_e32_MMGR_STATE;
class cfc_fi_tcl_SPM_e32_AUDIO_STATE;
class cfc_fi_tcl_SPM_e32_AUDIO_SOURCE;
class cfc_fi_tcl_SPM_e32_CD_EJECT_STATE;
class cfc_fi_tcl_SPM_e32_CD_INSERT_STATE;
class cfc_fi_tcl_SPM_e32_SYS_STATE;
class cfc_fi_tcl_SPM_e32_MOST_EVENT;
class cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE;
class cfc_fi_tcl_SPM_e32_TLA_STATE;
class cfc_fi_tcl_SPM_e32_PROCESSOR_STATE;
class cfc_fi_tcl_SPM_e32_STARTUP_STATE;
class cfc_fi_tcl_SPM_e32_RESTART_TYPE;
class cfc_fi_tcl_SPM_e32_CODE_REQUEST;
class cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST;
class cfc_fi_tcl_SPM_e32_WAKEUP_REASON;
class cfc_fi_tcl_SPM_e32_SWITCHON_REASON;
class cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE;
class cfc_fi_tcl_SPM_e32_KEY_STATE;
class cfc_fi_tcl_SPM_e32_STARTUP_REASON;
class cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE;
class cfc_fi_tcl_e8_LcmResetReason;
class cfc_fi_tcl_SPM_e32_CVM_EVENT;
class cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT;
class cfc_fi_tcl_SPM_e32_SYSPWRMODE;
class cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON;
class cfc_fi_tcl_e8_SPM_MonitoringMode;
class cfc_fi_tcl_e8_SPM_SupervisionControl;
class cfc_fi_tcl_SPM_TestRoutineParameter;
class cfc_fi_tcl_SPM_TestRoutineParameterList;
class cfc_fi_tcl_e8_SPM_TestResult;
class cfc_fi_tcl_SPM_TestResult;
class cfc_fi_tcl_SPM_TestResultList;
class cfc_fi_tcl_SPM_TransPortMode;
class cfc_fi_tcl_SPM_TransPortModeList;
class cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE;
class cfc_fi_tcl_e8_StateModes;
class cfc_fi_tcl_e8_StateEntryType;
class cfc_fi_tcl_SubStateEntry;
class cfc_fi_tcl_e8_ProcessState;
class cfc_fi_tcl_ProcessElement;
class cfc_fi_tcl_SPM_ProcessInfo;
class cfc_fi_tcl_SPM_Vin;
class cfc_fi_tcl_SPM_VinHistory;
class cfc_fi_tcl_ResetElement;
class cfc_fi_tcl_WakeupElement;
class cfc_fi_tcl_StateChangeElement;
class cfc_fi_tcl_SwitchOnElement;
class cfc_fi_tcl_SPM_e32_START_PROC_TYPE;
class cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE;
class cfc_fi_tcl_Vehicle_Data_U8_ACC_Status;
class cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity;
class cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status;
class cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code;
class cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode;
class cfc_fi_tcl_Car_ViewOptions;
class cfc_fi_tcl_e8_DefSetMode;
class cfc_fi_tcl_e8_DefSetServiceStatus;
class cfc_fi_tcl_BinContainer : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_BinContainer& operator=(const cfc_fi_tcl_BinContainer& coRef);
   cfc_fi_tcl_BinContainer(const cfc_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~cfc_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_Reserved : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_Reserved();

   virtual ~cfc_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_u8_Percent : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~cfc_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_PerThousand : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_u16_IndexInReferenceList : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~cfc_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_u16_ErrorCode : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~cfc_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_u16_RPM : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~cfc_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Kilogram : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Pound : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_Meter : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Meter : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Yards : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Foot : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Centimeter : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Inch : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Millimeter : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Microliter : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Second : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_u16_MilliSecond : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~cfc_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_MilliSecond : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_POSIXTime : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_POSIXTime& operator=(const cfc_fi_tcl_POSIXTime& coRef);
   cfc_fi_tcl_POSIXTime(const cfc_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~cfc_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_DST_State : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_DST_State();
   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   cfc_fi_tcl_e8_DST_State(cfc_fi_tcl_e8_DST_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_TimeZoneElement : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_TimeZoneElement& operator=(const cfc_fi_tcl_TimeZoneElement& coRef);
   cfc_fi_tcl_TimeZoneElement(const cfc_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclMultiLanguageString Abbreviation_StandardTime;
   cfc_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   cfc_fi_tcl_s32_Second TimeZoneDifference;
   cfc_fi_tcl_e8_DST_State DST_State;
   cfc_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~cfc_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_KmPerHour : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_MilesPerHour : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_Knot : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_CentimeterSecond : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_Kelvin : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_Fahrenheit : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Pascal : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Watt : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_FIVersion : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_FIVersion& operator=(const cfc_fi_tcl_FIVersion& coRef);
   cfc_fi_tcl_FIVersion(const cfc_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~cfc_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Longitude : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s32_Latitude : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~cfc_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_PositionWGS84 : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_PositionWGS84& operator=(const cfc_fi_tcl_PositionWGS84& coRef);
   cfc_fi_tcl_PositionWGS84(const cfc_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_s32_Longitude Longitude;
   cfc_fi_tcl_s32_Latitude Latitude;
   virtual ~cfc_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_RectangleWGS84 : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_RectangleWGS84& operator=(const cfc_fi_tcl_RectangleWGS84& coRef);
   cfc_fi_tcl_RectangleWGS84(const cfc_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_s32_Longitude LongitudeMin;
   cfc_fi_tcl_s32_Latitude LatitudeMin;
   cfc_fi_tcl_s32_Longitude LongitudeMax;
   cfc_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~cfc_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e16_ISOCountryCode : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e16_ISOCountryCode();
   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   cfc_fi_tcl_e16_ISOCountryCode(cfc_fi_tcl_e16_ISOCountryCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e16_ISOLanguageCode : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e16_ISOLanguageCode();
   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   cfc_fi_tcl_e16_ISOLanguageCode(cfc_fi_tcl_e16_ISOLanguageCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_LanguageID : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_LanguageID& operator=(const cfc_fi_tcl_LanguageID& coRef);
   cfc_fi_tcl_LanguageID(const cfc_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   cfc_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~cfc_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_u8_DirectionAbsolute : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~cfc_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_u8_DirectionRelative : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~cfc_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_CentiDegree : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_Degree : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_s16_DirectionRelative_CentiDegree : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~cfc_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_FuelType : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_FuelType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   cfc_fi_tcl_e8_FuelType(cfc_fi_tcl_e8_FuelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_DistTimeFuel : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_DistTimeFuel& operator=(const cfc_fi_tcl_DistTimeFuel& coRef);
   cfc_fi_tcl_DistTimeFuel(const cfc_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_s32_Meter Distance;
   cfc_fi_tcl_s32_Second Time;
   cfc_fi_tcl_s32_Microliter Fuel;
   virtual ~cfc_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tclTimeDate : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tclTimeDate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tclTimeDate& operator=(const cfc_fi_tclTimeDate& coRef);
   cfc_fi_tclTimeDate(const cfc_fi_tclTimeDate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hour;
   tU8 u8Minute;
   tU8 u8Second;
   virtual ~cfc_fi_tclTimeDate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tclTimeDate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_b32_SubState0 : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_b32_SubState0();

   enum {
      FI_C_U32_BIT_SPM_E32_SET_SD_CARD_ACCESS = 0x1UL,
      FI_C_U32_BIT_SPM_E32_EMERGENCY_OFF = 0x2UL,
      FI_C_U32_BIT_SPM_E32_FAST_SHUTDOWN = 0x4UL,
      FI_C_U32_BIT_SPM_E32_DIMMING = 0x8UL,
      FI_C_U32_BIT_SPM_E32_DOWNLOAD = 0x10UL,
      FI_C_U32_BIT_SPM_E32_DIAG_ACTIVITY = 0x20UL,
      FI_C_U32_BIT_SPM_E32_DIAGNOSIS = 0x40UL,
      FI_C_U32_BIT_SPM_E32_PHONE = 0x80UL,
      FI_C_U32_BIT_SPM_E32_ACCESSORY = 0x100UL,
      FI_C_U32_BIT_SPM_E32_IGNITION = 0x200UL,
      FI_C_U32_BIT_SPM_E32_TRANSPORTMODE = 0x400UL,
      FI_C_U32_BIT_SPM_E32_DOOROPEN = 0x800UL,
      FI_C_U32_BIT_SPM_E32_LOCK = 0x1000UL,
      FI_C_U32_BIT_SPM_E32_TRIGGER_FORCE_ON = 0x2000UL,
      FI_C_U32_BIT_SPM_E32_CLIMATE_INFO = 0x4000UL,
      FI_C_U32_BIT_SPM_E32_PARK_DISTANCE_CTRL = 0x8000UL,
      FI_C_U32_BIT_SPM_E32_FACTORY_MODE = 0x10000UL,
      FI_C_U32_BIT_SPM_E32_CD_INSERT = 0x20000UL,
      FI_C_U32_BIT_SPM_E32_SD_INSERT = 0x40000UL,
      FI_C_U32_BIT_SPM_E32_EJECT = 0x80000UL,
      FI_C_U32_BIT_SPM_E32_ON_TIPPER = 0x100000UL,
      FI_C_U32_BIT_SPM_E32_SOFTTOP_OPEN = 0x200000UL,
      FI_C_U32_BIT_SPM_E32_AIRBAG_DEPLOYED = 0x400000UL,
      FI_C_U32_BIT_SPM_E32_KEY_PRESENT = 0x800000UL,
      FI_C_U32_BIT_SPM_E32_NETWORK_ACTIVITY = 0x1000000UL,
      FI_C_U32_BIT_SPM_E32_OFF_TIPPER = 0x2000000UL,
      FI_C_U32_BIT_SPM_E32_OFF_LASTSTATE_CYCLE = 0x4000000UL,
      FI_C_U32_BIT_SPM_E32_DIAG_REQUEST = 0x8000000UL,
      FI_C_U32_BIT_SPM_E32_BACKLIGHT = 0x10000000UL,
      FI_C_U32_BIT_SPM_E32_HIGH_VOLTAGE = 0x20000000UL,
      FI_C_U32_BIT_SPM_E32_RCV_CONNECTED = 0x40000000UL,
      FI_C_U32_BIT_SPM_E32_OFF_LEARN = 0x80000000UL
   };
   tBool bSPM_e32_SET_SD_CARD_ACCESS() const {return (u32Value & FI_C_U32_BIT_SPM_E32_SET_SD_CARD_ACCESS) != 0; }
   tVoid vSetSPM_e32_SET_SD_CARD_ACCESS(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_SET_SD_CARD_ACCESS):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_SET_SD_CARD_ACCESS)); }
   tBool bSPM_e32_EMERGENCY_OFF() const {return (u32Value & FI_C_U32_BIT_SPM_E32_EMERGENCY_OFF) != 0; }
   tVoid vSetSPM_e32_EMERGENCY_OFF(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_EMERGENCY_OFF):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_EMERGENCY_OFF)); }
   tBool bSPM_e32_FAST_SHUTDOWN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_FAST_SHUTDOWN) != 0; }
   tVoid vSetSPM_e32_FAST_SHUTDOWN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_FAST_SHUTDOWN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_FAST_SHUTDOWN)); }
   tBool bSPM_e32_DIMMING() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DIMMING) != 0; }
   tVoid vSetSPM_e32_DIMMING(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DIMMING):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DIMMING)); }
   tBool bSPM_e32_DOWNLOAD() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DOWNLOAD) != 0; }
   tVoid vSetSPM_e32_DOWNLOAD(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DOWNLOAD):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DOWNLOAD)); }
   tBool bSPM_e32_DIAG_ACTIVITY() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DIAG_ACTIVITY) != 0; }
   tVoid vSetSPM_e32_DIAG_ACTIVITY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DIAG_ACTIVITY):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DIAG_ACTIVITY)); }
   tBool bSPM_e32_DIAGNOSIS() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DIAGNOSIS) != 0; }
   tVoid vSetSPM_e32_DIAGNOSIS(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DIAGNOSIS):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DIAGNOSIS)); }
   tBool bSPM_e32_PHONE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_PHONE) != 0; }
   tVoid vSetSPM_e32_PHONE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_PHONE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_PHONE)); }
   tBool bSPM_e32_ACCESSORY() const {return (u32Value & FI_C_U32_BIT_SPM_E32_ACCESSORY) != 0; }
   tVoid vSetSPM_e32_ACCESSORY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_ACCESSORY):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_ACCESSORY)); }
   tBool bSPM_e32_IGNITION() const {return (u32Value & FI_C_U32_BIT_SPM_E32_IGNITION) != 0; }
   tVoid vSetSPM_e32_IGNITION(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_IGNITION):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_IGNITION)); }
   tBool bSPM_e32_TRANSPORTMODE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_TRANSPORTMODE) != 0; }
   tVoid vSetSPM_e32_TRANSPORTMODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_TRANSPORTMODE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_TRANSPORTMODE)); }
   tBool bSPM_e32_DOOROPEN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DOOROPEN) != 0; }
   tVoid vSetSPM_e32_DOOROPEN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DOOROPEN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DOOROPEN)); }
   tBool bSPM_e32_LOCK() const {return (u32Value & FI_C_U32_BIT_SPM_E32_LOCK) != 0; }
   tVoid vSetSPM_e32_LOCK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_LOCK):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_LOCK)); }
   tBool bSPM_e32_TRIGGER_FORCE_ON() const {return (u32Value & FI_C_U32_BIT_SPM_E32_TRIGGER_FORCE_ON) != 0; }
   tVoid vSetSPM_e32_TRIGGER_FORCE_ON(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_TRIGGER_FORCE_ON):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_TRIGGER_FORCE_ON)); }
   tBool bSPM_e32_CLIMATE_INFO() const {return (u32Value & FI_C_U32_BIT_SPM_E32_CLIMATE_INFO) != 0; }
   tVoid vSetSPM_e32_CLIMATE_INFO(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_CLIMATE_INFO):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_CLIMATE_INFO)); }
   tBool bSPM_e32_PARK_DISTANCE_CTRL() const {return (u32Value & FI_C_U32_BIT_SPM_E32_PARK_DISTANCE_CTRL) != 0; }
   tVoid vSetSPM_e32_PARK_DISTANCE_CTRL(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_PARK_DISTANCE_CTRL):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_PARK_DISTANCE_CTRL)); }
   tBool bSPM_e32_FACTORY_MODE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_FACTORY_MODE) != 0; }
   tVoid vSetSPM_e32_FACTORY_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_FACTORY_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_FACTORY_MODE)); }
   tBool bSPM_e32_CD_INSERT() const {return (u32Value & FI_C_U32_BIT_SPM_E32_CD_INSERT) != 0; }
   tVoid vSetSPM_e32_CD_INSERT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_CD_INSERT):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_CD_INSERT)); }
   tBool bSPM_e32_SD_INSERT() const {return (u32Value & FI_C_U32_BIT_SPM_E32_SD_INSERT) != 0; }
   tVoid vSetSPM_e32_SD_INSERT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_SD_INSERT):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_SD_INSERT)); }
   tBool bSPM_e32_EJECT() const {return (u32Value & FI_C_U32_BIT_SPM_E32_EJECT) != 0; }
   tVoid vSetSPM_e32_EJECT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_EJECT):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_EJECT)); }
   tBool bSPM_e32_ON_TIPPER() const {return (u32Value & FI_C_U32_BIT_SPM_E32_ON_TIPPER) != 0; }
   tVoid vSetSPM_e32_ON_TIPPER(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_ON_TIPPER):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_ON_TIPPER)); }
   tBool bSPM_e32_SOFTTOP_OPEN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_SOFTTOP_OPEN) != 0; }
   tVoid vSetSPM_e32_SOFTTOP_OPEN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_SOFTTOP_OPEN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_SOFTTOP_OPEN)); }
   tBool bSPM_e32_AIRBAG_DEPLOYED() const {return (u32Value & FI_C_U32_BIT_SPM_E32_AIRBAG_DEPLOYED) != 0; }
   tVoid vSetSPM_e32_AIRBAG_DEPLOYED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_AIRBAG_DEPLOYED):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_AIRBAG_DEPLOYED)); }
   tBool bSPM_e32_KEY_PRESENT() const {return (u32Value & FI_C_U32_BIT_SPM_E32_KEY_PRESENT) != 0; }
   tVoid vSetSPM_e32_KEY_PRESENT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_KEY_PRESENT):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_KEY_PRESENT)); }
   tBool bSPM_e32_NETWORK_ACTIVITY() const {return (u32Value & FI_C_U32_BIT_SPM_E32_NETWORK_ACTIVITY) != 0; }
   tVoid vSetSPM_e32_NETWORK_ACTIVITY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_NETWORK_ACTIVITY):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_NETWORK_ACTIVITY)); }
   tBool bSPM_e32_OFF_TIPPER() const {return (u32Value & FI_C_U32_BIT_SPM_E32_OFF_TIPPER) != 0; }
   tVoid vSetSPM_e32_OFF_TIPPER(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_OFF_TIPPER):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_OFF_TIPPER)); }
   tBool bSPM_e32_OFF_LASTSTATE_CYCLE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_OFF_LASTSTATE_CYCLE) != 0; }
   tVoid vSetSPM_e32_OFF_LASTSTATE_CYCLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_OFF_LASTSTATE_CYCLE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_OFF_LASTSTATE_CYCLE)); }
   tBool bSPM_e32_DIAG_REQUEST() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DIAG_REQUEST) != 0; }
   tVoid vSetSPM_e32_DIAG_REQUEST(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DIAG_REQUEST):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DIAG_REQUEST)); }
   tBool bSPM_e32_BACKLIGHT() const {return (u32Value & FI_C_U32_BIT_SPM_E32_BACKLIGHT) != 0; }
   tVoid vSetSPM_e32_BACKLIGHT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_BACKLIGHT):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_BACKLIGHT)); }
   tBool bSPM_e32_HIGH_VOLTAGE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_HIGH_VOLTAGE) != 0; }
   tVoid vSetSPM_e32_HIGH_VOLTAGE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_HIGH_VOLTAGE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_HIGH_VOLTAGE)); }
   tBool bSPM_e32_RCV_CONNECTED() const {return (u32Value & FI_C_U32_BIT_SPM_E32_RCV_CONNECTED) != 0; }
   tVoid vSetSPM_e32_RCV_CONNECTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_RCV_CONNECTED):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_RCV_CONNECTED)); }
   tBool bSPM_e32_OFF_LEARN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_OFF_LEARN) != 0; }
   tVoid vSetSPM_e32_OFF_LEARN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_OFF_LEARN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_OFF_LEARN)); }
   struct rBitValues {
      tBool SPM_e32_SET_SD_CARD_ACCESS:1;
      tBool SPM_e32_EMERGENCY_OFF:1;
      tBool SPM_e32_FAST_SHUTDOWN:1;
      tBool SPM_e32_DIMMING:1;
      tBool SPM_e32_DOWNLOAD:1;
      tBool SPM_e32_DIAG_ACTIVITY:1;
      tBool SPM_e32_DIAGNOSIS:1;
      tBool SPM_e32_PHONE:1;
      tBool SPM_e32_ACCESSORY:1;
      tBool SPM_e32_IGNITION:1;
      tBool SPM_e32_TRANSPORTMODE:1;
      tBool SPM_e32_DOOROPEN:1;
      tBool SPM_e32_LOCK:1;
      tBool SPM_e32_TRIGGER_FORCE_ON:1;
      tBool SPM_e32_CLIMATE_INFO:1;
      tBool SPM_e32_PARK_DISTANCE_CTRL:1;
      tBool SPM_e32_FACTORY_MODE:1;
      tBool SPM_e32_CD_INSERT:1;
      tBool SPM_e32_SD_INSERT:1;
      tBool SPM_e32_EJECT:1;
      tBool SPM_e32_ON_TIPPER:1;
      tBool SPM_e32_SOFTTOP_OPEN:1;
      tBool SPM_e32_AIRBAG_DEPLOYED:1;
      tBool SPM_e32_KEY_PRESENT:1;
      tBool SPM_e32_NETWORK_ACTIVITY:1;
      tBool SPM_e32_OFF_TIPPER:1;
      tBool SPM_e32_OFF_LASTSTATE_CYCLE:1;
      tBool SPM_e32_DIAG_REQUEST:1;
      tBool SPM_e32_BACKLIGHT:1;
      tBool SPM_e32_HIGH_VOLTAGE:1;
      tBool SPM_e32_RCV_CONNECTED:1;
      tBool SPM_e32_OFF_LEARN:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~cfc_fi_tcl_b32_SubState0();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_b32_SubState0& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_b32_SubState1 : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_b32_SubState1();

   enum {
      FI_C_U32_BIT_SPM_E32_HEARTBEAT = 0x1UL,
      FI_C_U32_BIT_SPM_E32_DATA_ACCESS_READY = 0x2UL,
      FI_C_U32_BIT_SPM_E32_MOST_RING_ACTIVE = 0x4UL,
      FI_C_U32_BIT_SPM_E32_CONFIG_OK = 0x8UL,
      FI_C_U32_BIT_SPM_E32_LIMP_HOME_REQ = 0x10UL,
      FI_C_U32_BIT_SPM_E32_INFO_MGR_OK = 0x20UL,
      FI_C_U32_BIT_SPM_E32_TELEMATIC_ACTIVE = 0x40UL,
      FI_C_U32_BIT_SPM_E32_APPL_ACTIVATED = 0x80UL,
      FI_C_U32_BIT_SPM_E32_ACCESSORY_ACTIVE = 0x100UL,
      FI_C_U32_BIT_SPM_E32_POWER_STATUS_SHUTDOWN = 0x200UL,
      FI_C_U32_BIT_SPM_E32_NWM_STATE_NORMAL = 0x400UL,
      FI_C_U32_BIT_SPM_E32_IGNITION_TIMEOUT = 0x800UL,
      FI_C_U32_BIT_SPM_E32_IGNITION_INVALID = 0x1000UL,
      FI_C_U32_BIT_SPM_E32_FIRST_PIC_DRAWN = 0x2000UL,
      FI_C_U32_BIT_SPM_E32_OVERTEMP = 0x4000UL,
      FI_C_U32_BIT_SPM_E32_LOCK_ACTIVITY = 0x8000UL,
      FI_C_U32_BIT_SPM_E32_SYSSTATE_CHECK = 0x10000UL,
      FI_C_U32_BIT_SPM_E32_CR_TEMPERATURE = 0x20000UL,
      FI_C_U32_BIT_SPM_E32_PUSH_TO_TALK = 0x40000UL,
      FI_C_U32_BIT_SPM_E32_ROUTEGUIDANCE_ACTIVE = 0x80000UL,
      FI_C_U32_BIT_SPM_E32_HW_IGNITION = 0x100000UL,
      FI_C_U32_BIT_SPM_E32_CAN_WAKEUP = 0x200000UL,
      FI_C_U32_BIT_SPM_E32_DOWNLOAD_PERMISSION = 0x400000UL,
      FI_C_U32_BIT_SPM_E32_IGNITION_LOGIC = 0x800000UL,
      FI_C_U32_BIT_SPM_E32_LOW_VOLTAGE = 0x1000000UL,
      FI_C_U32_BIT_SPM_E32_STATE_DEBOUNCE = 0x2000000UL,
      FI_C_U32_BIT_SPM_E32_NETWORK_FAILURE = 0x4000000UL,
      FI_C_U32_BIT_SPM_E32_STATE_TO = 0x8000000UL,
      FI_C_U32_BIT_SPM_E32_LOW_VOLTAGE_TO = 0x10000000UL,
      FI_C_U32_BIT_SPM_E32_AUTOMATIC = 0x20000000UL,
      FI_C_U32_BIT_SPM_E32_CODE_REQUEST = 0x40000000UL,
      FI_C_U32_BIT_SPM_E32_SLV_SHUTDOWN_ACK = 0x80000000UL
   };
   tBool bSPM_e32_HEARTBEAT() const {return (u32Value & FI_C_U32_BIT_SPM_E32_HEARTBEAT) != 0; }
   tVoid vSetSPM_e32_HEARTBEAT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_HEARTBEAT):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_HEARTBEAT)); }
   tBool bSPM_e32_DATA_ACCESS_READY() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DATA_ACCESS_READY) != 0; }
   tVoid vSetSPM_e32_DATA_ACCESS_READY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DATA_ACCESS_READY):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DATA_ACCESS_READY)); }
   tBool bSPM_e32_MOST_RING_ACTIVE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_MOST_RING_ACTIVE) != 0; }
   tVoid vSetSPM_e32_MOST_RING_ACTIVE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_MOST_RING_ACTIVE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_MOST_RING_ACTIVE)); }
   tBool bSPM_e32_CONFIG_OK() const {return (u32Value & FI_C_U32_BIT_SPM_E32_CONFIG_OK) != 0; }
   tVoid vSetSPM_e32_CONFIG_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_CONFIG_OK):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_CONFIG_OK)); }
   tBool bSPM_e32_LIMP_HOME_REQ() const {return (u32Value & FI_C_U32_BIT_SPM_E32_LIMP_HOME_REQ) != 0; }
   tVoid vSetSPM_e32_LIMP_HOME_REQ(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_LIMP_HOME_REQ):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_LIMP_HOME_REQ)); }
   tBool bSPM_e32_INFO_MGR_OK() const {return (u32Value & FI_C_U32_BIT_SPM_E32_INFO_MGR_OK) != 0; }
   tVoid vSetSPM_e32_INFO_MGR_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_INFO_MGR_OK):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_INFO_MGR_OK)); }
   tBool bSPM_e32_TELEMATIC_ACTIVE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_TELEMATIC_ACTIVE) != 0; }
   tVoid vSetSPM_e32_TELEMATIC_ACTIVE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_TELEMATIC_ACTIVE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_TELEMATIC_ACTIVE)); }
   tBool bSPM_e32_APPL_ACTIVATED() const {return (u32Value & FI_C_U32_BIT_SPM_E32_APPL_ACTIVATED) != 0; }
   tVoid vSetSPM_e32_APPL_ACTIVATED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_APPL_ACTIVATED):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_APPL_ACTIVATED)); }
   tBool bSPM_e32_ACCESSORY_ACTIVE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_ACCESSORY_ACTIVE) != 0; }
   tVoid vSetSPM_e32_ACCESSORY_ACTIVE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_ACCESSORY_ACTIVE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_ACCESSORY_ACTIVE)); }
   tBool bSPM_e32_POWER_STATUS_SHUTDOWN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_POWER_STATUS_SHUTDOWN) != 0; }
   tVoid vSetSPM_e32_POWER_STATUS_SHUTDOWN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_POWER_STATUS_SHUTDOWN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_POWER_STATUS_SHUTDOWN)); }
   tBool bSPM_e32_NWM_STATE_NORMAL() const {return (u32Value & FI_C_U32_BIT_SPM_E32_NWM_STATE_NORMAL) != 0; }
   tVoid vSetSPM_e32_NWM_STATE_NORMAL(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_NWM_STATE_NORMAL):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_NWM_STATE_NORMAL)); }
   tBool bSPM_e32_IGNITION_TIMEOUT() const {return (u32Value & FI_C_U32_BIT_SPM_E32_IGNITION_TIMEOUT) != 0; }
   tVoid vSetSPM_e32_IGNITION_TIMEOUT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_IGNITION_TIMEOUT):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_IGNITION_TIMEOUT)); }
   tBool bSPM_e32_IGNITION_INVALID() const {return (u32Value & FI_C_U32_BIT_SPM_E32_IGNITION_INVALID) != 0; }
   tVoid vSetSPM_e32_IGNITION_INVALID(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_IGNITION_INVALID):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_IGNITION_INVALID)); }
   tBool bSPM_e32_FIRST_PIC_DRAWN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_FIRST_PIC_DRAWN) != 0; }
   tVoid vSetSPM_e32_FIRST_PIC_DRAWN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_FIRST_PIC_DRAWN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_FIRST_PIC_DRAWN)); }
   tBool bSPM_e32_OVERTEMP() const {return (u32Value & FI_C_U32_BIT_SPM_E32_OVERTEMP) != 0; }
   tVoid vSetSPM_e32_OVERTEMP(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_OVERTEMP):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_OVERTEMP)); }
   tBool bSPM_e32_LOCK_ACTIVITY() const {return (u32Value & FI_C_U32_BIT_SPM_E32_LOCK_ACTIVITY) != 0; }
   tVoid vSetSPM_e32_LOCK_ACTIVITY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_LOCK_ACTIVITY):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_LOCK_ACTIVITY)); }
   tBool bSPM_e32_SYSSTATE_CHECK() const {return (u32Value & FI_C_U32_BIT_SPM_E32_SYSSTATE_CHECK) != 0; }
   tVoid vSetSPM_e32_SYSSTATE_CHECK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_SYSSTATE_CHECK):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_SYSSTATE_CHECK)); }
   tBool bSPM_e32_CR_TEMPERATURE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_CR_TEMPERATURE) != 0; }
   tVoid vSetSPM_e32_CR_TEMPERATURE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_CR_TEMPERATURE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_CR_TEMPERATURE)); }
   tBool bSPM_e32_PUSH_TO_TALK() const {return (u32Value & FI_C_U32_BIT_SPM_E32_PUSH_TO_TALK) != 0; }
   tVoid vSetSPM_e32_PUSH_TO_TALK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_PUSH_TO_TALK):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_PUSH_TO_TALK)); }
   tBool bSPM_e32_ROUTEGUIDANCE_ACTIVE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_ROUTEGUIDANCE_ACTIVE) != 0; }
   tVoid vSetSPM_e32_ROUTEGUIDANCE_ACTIVE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_ROUTEGUIDANCE_ACTIVE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_ROUTEGUIDANCE_ACTIVE)); }
   tBool bSPM_e32_HW_IGNITION() const {return (u32Value & FI_C_U32_BIT_SPM_E32_HW_IGNITION) != 0; }
   tVoid vSetSPM_e32_HW_IGNITION(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_HW_IGNITION):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_HW_IGNITION)); }
   tBool bSPM_e32_CAN_WAKEUP() const {return (u32Value & FI_C_U32_BIT_SPM_E32_CAN_WAKEUP) != 0; }
   tVoid vSetSPM_e32_CAN_WAKEUP(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_CAN_WAKEUP):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_CAN_WAKEUP)); }
   tBool bSPM_e32_DOWNLOAD_PERMISSION() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DOWNLOAD_PERMISSION) != 0; }
   tVoid vSetSPM_e32_DOWNLOAD_PERMISSION(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DOWNLOAD_PERMISSION):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DOWNLOAD_PERMISSION)); }
   tBool bSPM_e32_IGNITION_LOGIC() const {return (u32Value & FI_C_U32_BIT_SPM_E32_IGNITION_LOGIC) != 0; }
   tVoid vSetSPM_e32_IGNITION_LOGIC(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_IGNITION_LOGIC):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_IGNITION_LOGIC)); }
   tBool bSPM_e32_LOW_VOLTAGE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_LOW_VOLTAGE) != 0; }
   tVoid vSetSPM_e32_LOW_VOLTAGE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_LOW_VOLTAGE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_LOW_VOLTAGE)); }
   tBool bSPM_e32_STATE_DEBOUNCE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_STATE_DEBOUNCE) != 0; }
   tVoid vSetSPM_e32_STATE_DEBOUNCE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_STATE_DEBOUNCE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_STATE_DEBOUNCE)); }
   tBool bSPM_e32_NETWORK_FAILURE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_NETWORK_FAILURE) != 0; }
   tVoid vSetSPM_e32_NETWORK_FAILURE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_NETWORK_FAILURE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_NETWORK_FAILURE)); }
   tBool bSPM_e32_STATE_TO() const {return (u32Value & FI_C_U32_BIT_SPM_E32_STATE_TO) != 0; }
   tVoid vSetSPM_e32_STATE_TO(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_STATE_TO):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_STATE_TO)); }
   tBool bSPM_e32_LOW_VOLTAGE_TO() const {return (u32Value & FI_C_U32_BIT_SPM_E32_LOW_VOLTAGE_TO) != 0; }
   tVoid vSetSPM_e32_LOW_VOLTAGE_TO(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_LOW_VOLTAGE_TO):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_LOW_VOLTAGE_TO)); }
   tBool bSPM_e32_AUTOMATIC() const {return (u32Value & FI_C_U32_BIT_SPM_E32_AUTOMATIC) != 0; }
   tVoid vSetSPM_e32_AUTOMATIC(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_AUTOMATIC):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_AUTOMATIC)); }
   tBool bSPM_e32_CODE_REQUEST() const {return (u32Value & FI_C_U32_BIT_SPM_E32_CODE_REQUEST) != 0; }
   tVoid vSetSPM_e32_CODE_REQUEST(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_CODE_REQUEST):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_CODE_REQUEST)); }
   tBool bSPM_e32_SLV_SHUTDOWN_ACK() const {return (u32Value & FI_C_U32_BIT_SPM_E32_SLV_SHUTDOWN_ACK) != 0; }
   tVoid vSetSPM_e32_SLV_SHUTDOWN_ACK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_SLV_SHUTDOWN_ACK):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_SLV_SHUTDOWN_ACK)); }
   struct rBitValues {
      tBool SPM_e32_HEARTBEAT:1;
      tBool SPM_e32_DATA_ACCESS_READY:1;
      tBool SPM_e32_MOST_RING_ACTIVE:1;
      tBool SPM_e32_CONFIG_OK:1;
      tBool SPM_e32_LIMP_HOME_REQ:1;
      tBool SPM_e32_INFO_MGR_OK:1;
      tBool SPM_e32_TELEMATIC_ACTIVE:1;
      tBool SPM_e32_APPL_ACTIVATED:1;
      tBool SPM_e32_ACCESSORY_ACTIVE:1;
      tBool SPM_e32_POWER_STATUS_SHUTDOWN:1;
      tBool SPM_e32_NWM_STATE_NORMAL:1;
      tBool SPM_e32_IGNITION_TIMEOUT:1;
      tBool SPM_e32_IGNITION_INVALID:1;
      tBool SPM_e32_FIRST_PIC_DRAWN:1;
      tBool SPM_e32_OVERTEMP:1;
      tBool SPM_e32_LOCK_ACTIVITY:1;
      tBool SPM_e32_SYSSTATE_CHECK:1;
      tBool SPM_e32_CR_TEMPERATURE:1;
      tBool SPM_e32_PUSH_TO_TALK:1;
      tBool SPM_e32_ROUTEGUIDANCE_ACTIVE:1;
      tBool SPM_e32_HW_IGNITION:1;
      tBool SPM_e32_CAN_WAKEUP:1;
      tBool SPM_e32_DOWNLOAD_PERMISSION:1;
      tBool SPM_e32_IGNITION_LOGIC:1;
      tBool SPM_e32_LOW_VOLTAGE:1;
      tBool SPM_e32_STATE_DEBOUNCE:1;
      tBool SPM_e32_NETWORK_FAILURE:1;
      tBool SPM_e32_STATE_TO:1;
      tBool SPM_e32_LOW_VOLTAGE_TO:1;
      tBool SPM_e32_AUTOMATIC:1;
      tBool SPM_e32_CODE_REQUEST:1;
      tBool SPM_e32_SLV_SHUTDOWN_ACK:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~cfc_fi_tcl_b32_SubState1();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_b32_SubState1& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_b32_SubState2 : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_b32_SubState2();

   enum {
      FI_C_U32_BIT_SPM_E32_FRIENDLY_USER = 0x1UL,
      FI_C_U32_BIT_SPM_E32_NISSAN_CMF1 = 0x2UL,
      FI_C_U32_BIT_SPM_E32_PREPARE_SHUTDOWN = 0x4UL,
      FI_C_U32_BIT_SPM_E32_SHUTDOWN = 0x8UL,
      FI_C_U32_BIT_SPM_E32_HKEY_PRESSED = 0x10UL,
      FI_C_U32_BIT_SPM_E32_CD_INSERT_CLAMPS = 0x20UL,
      FI_C_U32_BIT_SPM_E32_CRITICAL_LOW_VOLTAGE = 0x40UL,
      FI_C_U32_BIT_SPM_E32_ENDURING_LOW_VOLTAGE = 0x80UL,
      FI_C_U32_BIT_SPM_E32_DIAG_FAST_SHUTDOWN = 0x100UL
   };
   tBool bSPM_e32_FRIENDLY_USER() const {return (u32Value & FI_C_U32_BIT_SPM_E32_FRIENDLY_USER) != 0; }
   tVoid vSetSPM_e32_FRIENDLY_USER(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_FRIENDLY_USER):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_FRIENDLY_USER)); }
   tBool bSPM_e32_NISSAN_CMF1() const {return (u32Value & FI_C_U32_BIT_SPM_E32_NISSAN_CMF1) != 0; }
   tVoid vSetSPM_e32_NISSAN_CMF1(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_NISSAN_CMF1):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_NISSAN_CMF1)); }
   tBool bSPM_e32_PREPARE_SHUTDOWN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_PREPARE_SHUTDOWN) != 0; }
   tVoid vSetSPM_e32_PREPARE_SHUTDOWN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_PREPARE_SHUTDOWN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_PREPARE_SHUTDOWN)); }
   tBool bSPM_e32_SHUTDOWN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_SHUTDOWN) != 0; }
   tVoid vSetSPM_e32_SHUTDOWN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_SHUTDOWN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_SHUTDOWN)); }
   tBool bSPM_e32_HKEY_PRESSED() const {return (u32Value & FI_C_U32_BIT_SPM_E32_HKEY_PRESSED) != 0; }
   tVoid vSetSPM_e32_HKEY_PRESSED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_HKEY_PRESSED):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_HKEY_PRESSED)); }
   tBool bSPM_e32_CD_INSERT_CLAMPS() const {return (u32Value & FI_C_U32_BIT_SPM_E32_CD_INSERT_CLAMPS) != 0; }
   tVoid vSetSPM_e32_CD_INSERT_CLAMPS(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_CD_INSERT_CLAMPS):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_CD_INSERT_CLAMPS)); }
   tBool bSPM_e32_CRITICAL_LOW_VOLTAGE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_CRITICAL_LOW_VOLTAGE) != 0; }
   tVoid vSetSPM_e32_CRITICAL_LOW_VOLTAGE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_CRITICAL_LOW_VOLTAGE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_CRITICAL_LOW_VOLTAGE)); }
   tBool bSPM_e32_ENDURING_LOW_VOLTAGE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_ENDURING_LOW_VOLTAGE) != 0; }
   tVoid vSetSPM_e32_ENDURING_LOW_VOLTAGE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_ENDURING_LOW_VOLTAGE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_ENDURING_LOW_VOLTAGE)); }
   tBool bSPM_e32_DIAG_FAST_SHUTDOWN() const {return (u32Value & FI_C_U32_BIT_SPM_E32_DIAG_FAST_SHUTDOWN) != 0; }
   tVoid vSetSPM_e32_DIAG_FAST_SHUTDOWN(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_DIAG_FAST_SHUTDOWN):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_DIAG_FAST_SHUTDOWN)); }
   struct rBitValues {
      tBool SPM_e32_FRIENDLY_USER:1;
      tBool SPM_e32_NISSAN_CMF1:1;
      tBool SPM_e32_PREPARE_SHUTDOWN:1;
      tBool SPM_e32_SHUTDOWN:1;
      tBool SPM_e32_HKEY_PRESSED:1;
      tBool SPM_e32_CD_INSERT_CLAMPS:1;
      tBool SPM_e32_CRITICAL_LOW_VOLTAGE:1;
      tBool SPM_e32_ENDURING_LOW_VOLTAGE:1;
      tBool SPM_e32_DIAG_FAST_SHUTDOWN:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~cfc_fi_tcl_b32_SubState2();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_b32_SubState2& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_SubStateType : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_SubStateType();
   enum tenType {
      FI_EN_SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS = 0UL,
      FI_EN_SPM_U32_SUBSTATE_EMERGENCY_OFF = 1UL,
      FI_EN_SPM_U32_SUBSTATE_FAST_SHUTDOWN = 2UL,
      FI_EN_SPM_U32_SUBSTATE_DIMMING = 3UL,
      FI_EN_SPM_U32_SUBSTATE_DOWNLOAD = 4UL,
      FI_EN_SPM_U32_SUBSTATE_DIAG_ACTIVITY = 5UL,
      FI_EN_SPM_U32_SUBSTATE_DIAGNOSIS = 6UL,
      FI_EN_SPM_U32_SUBSTATE_PHONE = 7UL,
      FI_EN_SPM_U32_SUBSTATE_S_CONTACT = 8UL,
      FI_EN_SPM_U32_SUBSTATE_IGNITION = 9UL,
      FI_EN_SPM_U32_SUBSTATE_TRANSPORTMODE = 10UL,
      FI_EN_SPM_U32_SUBSTATE_DOOROPEN = 11UL,
      FI_EN_SPM_U32_SUBSTATE_LOCK = 12UL,
      FI_EN_SPM_U32_SUBSTATE_TRIGGER_FORCE_ON = 13UL,
      FI_EN_SPM_U32_SUBSTATE_CLIMATE_INFO = 14UL,
      FI_EN_SPM_U32_SUBSTATE_PARK_DISTANCE_CTRL = 15UL,
      FI_EN_SPM_U32_SUBSTATE_FACTORY_MODE = 16UL,
      FI_EN_SPM_U32_SUBSTATE_CD_INSERT = 17UL,
      FI_EN_SPM_U32_SUBSTATE_SD_INSERT = 18UL,
      FI_EN_SPM_U32_SUBSTATE_EJECT = 19UL,
      FI_EN_SPM_U32_SUBSTATE_ON_TIPPER = 20UL,
      FI_EN_SPM_U32_SUBSTATE_SOFTTOP_OPEN = 21UL,
      FI_EN_SPM_U32_SUBSTATE_AIRBAG_DEPLOYED = 22UL,
      FI_EN_SPM_U32_SUBSTATE_KEY_PRESENT = 23UL,
      FI_EN_SPM_U32_SUBSTATE_NETWORK_ACTIVITY = 24UL,
      FI_EN_SPM_U32_SUBSTATE_OFF_TIPPER = 25UL,
      FI_EN_SPM_U32_SUBSTATE_OFF_LASTSTATE_CYCLE = 26UL,
      FI_EN_SPM_U32_SUBSTATE_DIAG_REQUEST = 27UL,
      FI_EN_SPM_U32_SUBSTATE_BACKLIGHT = 28UL,
      FI_EN_SPM_U32_SUBSTATE_HIGH_VOLTAGE = 29UL,
      FI_EN_SPM_U32_SUBSTATE_RCV_CONNECTED = 30UL,
      FI_EN_SPM_U32_SUBSTATE_OFF_LEARN = 31UL,
      FI_EN_SPM_U32_SUBSTATE_HEARTBEAT = 32UL,
      FI_EN_SPM_U32_SUBSTATE_DATA_ACCESS_READY = 33UL,
      FI_EN_SPM_U32_SUBSTATE_MOST_RING_ACTIVE = 34UL,
      FI_EN_SPM_U32_SUBSTATE_CONFIG_OK = 35UL,
      FI_EN_SPM_U32_SUBSTATE_LIMP_HOME_REQ = 36UL,
      FI_EN_SPM_U32_SUBSTATE_INFO_MGR_OK = 37UL,
      FI_EN_SPM_U32_SUBSTATE_TELEMATIC_ACTIVE = 38UL,
      FI_EN_SPM_U32_SUBSTATE_APPL_ACTIVATED = 39UL,
      FI_EN_SPM_U32_SUBSTATE_ACCESSORY_ACTIVE = 40UL,
      FI_EN_SPM_U32_SUBSTATE_POWER_STATUS_SHUTDOWN = 41UL,
      FI_EN_SPM_U32_SUBSTATE_NWM_STATE_NORMAL = 42UL,
      FI_EN_SPM_U32_SUBSTATE_IGNITION_TIMEOUT = 43UL,
      FI_EN_SPM_U32_SUBSTATE_IGNITION_INVALID = 44UL,
      FI_EN_SPM_U32_SUBSTATE_FIRST_PIC_DRAWN = 45UL,
      FI_EN_SPM_U32_SUBSTATE_OVERTEMP = 46UL,
      FI_EN_SPM_U32_SUBSTATE_LOCK_ACTIVITY = 47UL,
      FI_EN_SPM_U32_SUBSTATE_SYSSTATE_CHECK = 48UL,
      FI_EN_SPM_U32_SUBSTATE_CR_TEMPERATURE = 49UL,
      FI_EN_SPM_U32_SUBSTATE_PUSH_TO_TALK = 50UL,
      FI_EN_SPM_U32_SUBSTATE_ROUTEGUIDANCE_ACTIVE = 51UL,
      FI_EN_SPM_U32_SUBSTATE_HW_IGNITION = 52UL,
      FI_EN_SPM_U32_SUBSTATE_CAN_WAKEUP = 53UL,
      FI_EN_SPM_U32_SUBSTATE_DOWNLOAD_PERMISSION = 54UL,
      FI_EN_SPM_U32_SUBSTATE_IGNITION_LOGIC = 55UL,
      FI_EN_SPM_U32_SUBSTATE_LOW_VOLTAGE = 56UL,
      FI_EN_SPM_U32_SUBSTATE_STATE_DEBOUNCE = 57UL,
      FI_EN_SPM_U32_SUBSTATE_NETWORK_FAILURE = 58UL,
      FI_EN_SPM_U32_SUBSTATE_STATE_TO = 59UL,
      FI_EN_SPM_U32_SUBSTATE_LOW_VOLTAGE_TO = 60UL,
      FI_EN_SPM_U32_SUBSTATE_AUTOMATIC = 61UL,
      FI_EN_SPM_U32_SUBSTATE_CODE_REQUEST = 62UL,
      FI_EN_SPM_U32_SUBSTATE_SYNC_SHUTDOWN_ACK = 63UL,
      FI_EN_SPM_U32_SUBSTATE_FRIENDLY_USER = 64UL,
      FI_EN_SPM_U32_SUBSTATE_NISSAN_CMF1 = 65UL,
      FI_EN_SPM_U32_SUBSTATE_PREPARE_SHUTDOWN = 66UL,
      FI_EN_SPM_U32_SUBSTATE_SHUTDOWN = 67UL,
      FI_EN_SPM_U32_SUBSTATE_HKEY_PRESSED = 68UL,
      FI_EN_SPM_U32_SUBSTATE_CD_INSERT_CLAMPS = 69UL,
      FI_EN_SPM_U32_SUBSTATE_CRITICAL_LOW_VOLTAGE = 70UL,
      FI_EN_SPM_U32_SUBSTATE_ENDURING_LOW_VOLTAGE = 71UL,
      FI_EN_SPM_U32_SUBSTATE_DIAG_FAST_SHUTDOWN = 72UL,
      FI_EN_SPM_U32_SUBSTATE_USING_ACCESSORY = 73UL,
      FI_EN_SPM_U32_SUBSTATE_BACKGROUND_IMM_OFF = 74UL,
      FI_EN_SPM_U32_SUBSTATE_ROLLER_RIG_MODE = 75UL,
      FI_EN_SPM_U32_SUBSTATE_REMOTE_ON_ACTIVE = 76UL,
      FI_EN_SPM_U32_SUBSTATE_ENDURING_CR_VOLTAGE = 77UL,
      FI_EN_SPM_U32_SUBSTATE_NORMAL_VOLT = 78UL,
      FI_EN_SPM_U32_SUBSTATE_Q_CRITICAL = 79UL,
      FI_EN_SPM_U32_SUBSTATE_TRIGGER_RESET = 80UL,
      FI_EN_SPM_U32_SUBSTATE_CAR_WAKEUP = 81UL,
      FI_EN_SPM_U32_SUBSTATE_PHONE_CONNECTED = 82UL,
      FI_EN_SPM_U32_SUBSTATE_CUSTOMER_DOWNLOAD = 83UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_SubStateType(cfc_fi_tcl_SPM_e32_SubStateType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_SubStateType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_SubStateType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_OnOffReason : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_OnOffReason();
   enum tenType {
      FI_EN_SPM_SUBSTATE_TIPPER_ON = 1UL,
      FI_EN_SPM_SUBSTATE_NO_DIAG = 2UL,
      FI_EN_SPM_SUBSTATE_DIAG = 2147483650UL,
      FI_EN_SPM_SUBSTATE_NO_DOWNLOAD = 4UL,
      FI_EN_SPM_SUBSTATE_DOWNLOAD = 2147483652UL,
      FI_EN_SPM_SUBSTATE_NO_TRANSPORT_MODE = 8UL,
      FI_EN_SPM_SUBSTATE_TRANSPORT_MODE = 2147483656UL,
      FI_EN_SPM_SUBSTATE_NO_IGNITION = 16UL,
      FI_EN_SPM_SUBSTATE_IGNITION = 2147483664UL,
      FI_EN_SPM_SUBSTATE_NO_S_CONTACT = 32UL,
      FI_EN_SPM_SUBSTATE_S_CONTACT = 2147483680UL,
      FI_EN_SPM_SUBSTATE_NO_DIAGNOSTICS_ACTIVITY = 64UL,
      FI_EN_SPM_SUBSTATE_DIAGNOSTICS_ACTIVITY = 2147483712UL,
      FI_EN_SPM_SUBSTATE_NO_PHONE = 128UL,
      FI_EN_SPM_SUBSTATE_PHONE = 2147483776UL,
      FI_EN_SPM_SUBSTATE_NO_NETWORK_ACTIVITY = 256UL,
      FI_EN_SPM_SUBSTATE_NETWORK_ACTIVITY = 2147483904UL,
      FI_EN_SPM_SUBSTATE_CD_INSERT = 512UL,
      FI_EN_SPM_SUBSTATE_NO_DIM = 1024UL,
      FI_EN_SPM_SUBSTATE_DIM = 2147484672UL,
      FI_EN_SPM_SUBSTATE_CAN_BUS_WAKEUP = 2048UL,
      FI_EN_SPM_SUBSTATE_DOWNLOAD_PERMISSION = 4096UL,
      FI_EN_SPM_SUBSTATE_EJECT_KEY_DETECTED = 8192UL,
      FI_EN_SPM_SUBSTATE_DRIVER_DOOR = 16384UL,
      FI_EN_SPM_SUBSTATE_NO_UNDER_VOLTAGE = 32768UL,
      FI_EN_SPM_SUBSTATE_UNDER_VOLTAGE = 2147516416UL,
      FI_EN_SPM_SUBSTATE_EMERGENCY_OFF = 65536UL,
      FI_EN_SPM_SUBSTATE_1H_LOGIC_TIMEOUT = 131072UL,
      FI_EN_SPM_SUBSTATE_FAST_SHUTDOWN = 1048576UL,
      FI_EN_SPM_SUBSTATE_HW_IGNITION = 2097152UL,
      FI_EN_SPM_SUBSTATE_PHONE_MUTE = 4194304UL,
      FI_EN_SPM_SUBSTATE_MAUS_ACTIVITY = 8388608UL,
      FI_EN_SPM_SUBSTATE_PUSH_TO_TALK = 33554432UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_OnOffReason(cfc_fi_tcl_SPM_e32_OnOffReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_OnOffReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_OnOffReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_SYSTEM_STATES : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_SYSTEM_STATES();
   enum tenType {
      FI_EN_SPM_SYSTEM_BACKGROUND = 5UL,
      FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN = 16UL,
      FI_EN_SPM_SYSTEM_SHUTDOWN = 17UL,
      FI_EN_SPM_SYSTEM_SUSPEND = 0UL,
      FI_EN_SPM_SYSTEM_STANDBY = 1UL,
      FI_EN_SPM_SYSTEM_OFF = 2UL,
      FI_EN_SPM_SYSTEM_DOWNLOAD = 3UL,
      FI_EN_SPM_SYSTEM_ON = 4UL,
      FI_EN_SPM_SYSTEM_DOOR_OPEN = 6UL,
      FI_EN_SPM_SYSTEM_IGNITION = 7UL,
      FI_EN_SPM_SYSTEM_DIAGNOSIS = 8UL,
      FI_EN_SPM_SYSTEM_STATE_PROFILE = 9UL,
      FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1 = 32UL,
      FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2 = 33UL,
      FI_EN_SPM_SYSTEM_MMI_STANDBY = 34UL,
      FI_EN_SPM_SYSTEM_MMI_ON = 35UL,
      FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED = 36UL,
      FI_EN_SPM_SYSTEM_MMI_ON_DIAG = 37UL,
      FI_EN_SPM_SYSTEM_MMI_ON_TEL = 38UL,
      FI_EN_SPM_SYSTEM_MMI_ON_SWDL = 39UL,
      FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL = 40UL,
      FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE = 41UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_SYSTEM_STATES(cfc_fi_tcl_SPM_e32_SYSTEM_STATES::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_SYSTEM_STATES();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_SYSTEM_STATES& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR();
   enum tenType {
      FI_EN_SPM_U32_SYSPWR_NORMAL = 0UL,
      FI_EN_SPM_U32_SYSPWR_BATTERY_LOW_SHUTDOWN = 1UL,
      FI_EN_SPM_U32_SYSPWR_BATTERY_LOW_WARNING = 2UL,
      FI_EN_SPM_U32_SYSPWR_PHONE_HANDOVER_WARN = 3UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR(cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_HMI_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_HMI_STATE();
   enum tenType {
      FI_EN_SPM_U32_HMISTATE_SHOW_OFF = 1UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_HMI = 2UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_CLOCK = 3UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_GOODBYE = 4UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_PHONE = 5UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_CLIMATE_CLOCK = 6UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE = 7UL,
      FI_EN_SPM_U32_HMISTATE_ANIMATION = 8UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_ON_INFO_WARN = 9UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_OFF_PHONE = 10UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_OFF_OPS = 11UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_OFF_CLIMATE = 12UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_ON_INFO_OFF = 13UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_OFF_DIAG = 14UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_INFOTAINMENT_OFF = 15UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_CLOCK_OVERTEMP = 16UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_CLIMATE_CLOCK_OVERTEMP = 17UL,
      FI_EN_SPM_U32_HMISTATE_SECURE_GREEN = 18UL,
      FI_EN_SPM_U32_HMISTATE_SECURE_YELLOW = 19UL,
      FI_EN_SPM_U32_HMISTATE_SECURE_RED = 20UL,
      FI_EN_SPM_U32_HMISTATE_SECURE_WAIT = 21UL,
      FI_EN_SPM_U32_HMISTATE_SLEEP_SCREEN = 22UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_STANDBY_RESTRICTED = 23UL,
      FI_EN_SPM_U32_HMISTATE_SHOW_STANDBY = 24UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_HMI_STATE(cfc_fi_tcl_SPM_e32_HMI_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_HMI_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_HMI_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_DIM_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_DIM_STATE();
   enum tenType {
      FI_EN_SPM_U32_DIMSTATE = 1UL,
      FI_EN_SPM_U32_DIMSTATE_CLIMATE = 2UL,
      FI_EN_SPM_U32_DIMSTATE_BACKLIGHT = 4UL,
      FI_EN_SPM_U32_DIMSTATE_HOUR_MODE = 8UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_DIM_STATE(cfc_fi_tcl_SPM_e32_DIM_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_DIM_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_DIM_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_b32_DIM_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_b32_DIM_STATE();

   enum {
      FI_C_U32_BIT_SPM_U32_DIMMINGSTATE = 0x1UL,
      FI_C_U32_BIT_SPM_U32_DIMSMINGTATE_CLIMATE = 0x2UL,
      FI_C_U32_BIT_SPM_U32_DIMMINGSTATE_BACKLIGHT = 0x4UL,
      FI_C_U32_BIT_SPM_U32_DIMMINGSTATE_HOUR_MODE = 0x8UL
   };
   tBool bSPM_U32_DIMMINGSTATE() const {return (u32Value & FI_C_U32_BIT_SPM_U32_DIMMINGSTATE) != 0; }
   tVoid vSetSPM_U32_DIMMINGSTATE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_U32_DIMMINGSTATE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_U32_DIMMINGSTATE)); }
   tBool bSPM_U32_DIMSMINGTATE_CLIMATE() const {return (u32Value & FI_C_U32_BIT_SPM_U32_DIMSMINGTATE_CLIMATE) != 0; }
   tVoid vSetSPM_U32_DIMSMINGTATE_CLIMATE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_U32_DIMSMINGTATE_CLIMATE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_U32_DIMSMINGTATE_CLIMATE)); }
   tBool bSPM_U32_DIMMINGSTATE_BACKLIGHT() const {return (u32Value & FI_C_U32_BIT_SPM_U32_DIMMINGSTATE_BACKLIGHT) != 0; }
   tVoid vSetSPM_U32_DIMMINGSTATE_BACKLIGHT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_U32_DIMMINGSTATE_BACKLIGHT):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_U32_DIMMINGSTATE_BACKLIGHT)); }
   tBool bSPM_U32_DIMMINGSTATE_HOUR_MODE() const {return (u32Value & FI_C_U32_BIT_SPM_U32_DIMMINGSTATE_HOUR_MODE) != 0; }
   tVoid vSetSPM_U32_DIMMINGSTATE_HOUR_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_U32_DIMMINGSTATE_HOUR_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_U32_DIMMINGSTATE_HOUR_MODE)); }
   struct rBitValues {
      tBool SPM_U32_DIMMINGSTATE:1;
      tBool SPM_U32_DIMSMINGTATE_CLIMATE:1;
      tBool SPM_U32_DIMMINGSTATE_BACKLIGHT:1;
      tBool SPM_U32_DIMMINGSTATE_HOUR_MODE:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~cfc_fi_tcl_SPM_b32_DIM_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_b32_DIM_STATE& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_MMGR_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_MMGR_STATE();
   enum tenType {
      FI_EN_SPM_U32_MMGRSTATE_BACKGRD_ACTIVITY = 1UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_MMGR_STATE(cfc_fi_tcl_SPM_e32_MMGR_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_MMGR_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_MMGR_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_AUDIO_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_AUDIO_STATE();
   enum tenType {
      FI_EN_SPM_U32_AUDIOSTATE_OFF = 0UL,
      FI_EN_SPM_U32_AUDIOSTATE_ON = 1UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_AUDIO_STATE(cfc_fi_tcl_SPM_e32_AUDIO_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_AUDIO_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_AUDIO_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_AUDIO_SOURCE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_AUDIO_SOURCE();
   enum tenType {
      FI_EN_SPM_U32_AUDIOSRC_NONE = 0UL,
      FI_EN_SPM_U32_AUDIOSRC_RADIO_FM1 = 1UL,
      FI_EN_SPM_U32_AUDIOSRC_RADIO_FM2 = 2UL,
      FI_EN_SPM_U32_AUDIOSRC_RADIO_AM = 3UL,
      FI_EN_SPM_U32_AUDIOSRC_RADIO_DAB = 4UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_CDCOMP = 5UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_SD = 6UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_BTAUDIO = 7UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_MDI = 10UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_AUXPLATE = 12UL,
      FI_EN_SPM_U32_AUDIOSRC_RADIO_TA = 13UL,
      FI_EN_SPM_U32_AUDIOSRC_NAVISPEECH = 14UL,
      FI_EN_SPM_U32_AUDIOSRC_TELEPHONE = 15UL,
      FI_EN_SPM_U32_AUDIOSRC_TELEPHONE_MUTE = 16UL,
      FI_EN_SPM_U32_AUDIOSRC_OPS_PDC = 19UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_CDDA = 20UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_CDC = 21UL,
      FI_EN_SPM_U32_AUDIOSRC_ENTERTAINMENT_MUTE = 22UL,
      FI_EN_SPM_U32_AUDIOSRC_DIAGNOSIS_MUTE = 23UL,
      FI_EN_SPM_U32_AUDIOSRC_SYSTEM_MUTE = 24UL,
      FI_EN_SPM_U32_AUDIOSRC_CLUSTER_MUTE = 25UL,
      FI_EN_SPM_U32_AUDIOSRC_PIN_MUTE = 26UL,
      FI_EN_SPM_U32_AUDIOSRC_LIMITED_SYSTEM_MUTE = 27UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_IPOD = 28UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_USB = 29UL,
      FI_EN_SPM_U32_AUDIOSRC_RADIO_XM = 30UL,
      FI_EN_SPM_U32_AUDIOSRC_NAVIINFO = 31UL,
      FI_EN_SPM_U32_AUDIOSRC_AUDIO_OFF_MUTE = 32UL,
      FI_EN_SPM_U32_AUDIOSRC_SDS = 33UL,
      FI_EN_SPM_U32_AUDIOSRC_DOV = 34UL,
      FI_EN_SPM_U32_AUDIOSRC_DOV_TEST = 35UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_PANODRA = 36UL,
      FI_EN_SPM_U32_AUDIOSRC_SDS_SMS = 37UL,
      FI_EN_SPM_U32_AUDIOSRC_RADIO_DAB_TA = 38UL,
      FI_EN_SPM_U32_AUDIOSRC_RADIO_DABSERVICEFOLLOWING = 39UL,
      FI_EN_SPM_U32_AUDIOSRC_SPI_BT_AUDIO = 40UL,
      FI_EN_SPM_U32_AUDIOSRC_SPI_USB = 41UL,
      FI_EN_SPM_U32_AUDIOSRC_SPI_VR_USB = 42UL,
      FI_EN_SPM_U32_AUDIOSRC_SPI_VR_BT_AUDIO = 43UL,
      FI_EN_SPM_U32_AUDIOSRC_SPI_TTS = 44UL,
      FI_EN_SPM_U32_AUDIOSRC_MEDIA_DB_PLAYER = 45UL,
      FI_EN_SPM_U32_AUDIOSRC_CUE = 46UL,
      FI_EN_SPM_U32_AUDIOSRC_VOLTAGE_MUTE = 47UL,
      FI_EN_SPM_U32_AUDIOSRC_AUD_DEV__NOT_AVAIL = 48UL,
      FI_EN_SPM_U32_AUDIOSRC_MIC_LOOPBACK = 49UL,
      FI_EN_SPM_U32_AUDIOSRC_IPA_MUTE = 50UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_AUDIO_SOURCE(cfc_fi_tcl_SPM_e32_AUDIO_SOURCE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_AUDIO_SOURCE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_AUDIO_SOURCE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_CD_EJECT_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_CD_EJECT_STATE();
   enum tenType {
      FI_EN_SPM_U32_CD_EJECT_INACTIVE = 0UL,
      FI_EN_SPM_U32_CD_EJECT_TRIGGER = 1UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_CD_EJECT_STATE(cfc_fi_tcl_SPM_e32_CD_EJECT_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_CD_EJECT_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_CD_EJECT_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_CD_INSERT_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_CD_INSERT_STATE();
   enum tenType {
      FI_EN_SPM_U32_CD_INSERT_INACTIVE = 0UL,
      FI_EN_SPM_U32_CD_INSERT_ACTIVE = 1UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_CD_INSERT_STATE(cfc_fi_tcl_SPM_e32_CD_INSERT_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_CD_INSERT_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_CD_INSERT_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_SYS_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_SYS_STATE();
   enum tenType {
      FI_EN_SPM_U32_SYSSTATE_SLEEP = 0UL,
      FI_EN_SPM_U32_SYSSTATE_COMM_ENABLED = 1UL,
      FI_EN_SPM_U32_SYSSTATE_INACTIVE = 2UL,
      FI_EN_SPM_U32_SYSSTATE_FULL_OPERATION = 3UL,
      FI_EN_SPM_U32_SYSSTATE_THEFTLOCKED = 4UL,
      FI_EN_SPM_U32_SYSSTATE_NO_CALIBRATION = 5UL,
      FI_EN_SPM_U32_SYSSTATE_NOVIN_MODE = 6UL,
      FI_EN_SPM_U32_SYSSTATE_VALET_MODE = 7UL,
      FI_EN_SPM_U32_SYSSTATE_LOCAL_PHONE = 8UL,
      FI_EN_SPM_U32_SYSSTATE_LOCAL_INFORMATION = 9UL,
      FI_EN_SPM_U32_SYSSTATE_LOCAL_EJECT = 10UL,
      FI_EN_SPM_U32_SYSSTATE_LOCAL_INFOTAINMENT = 11UL,
      FI_EN_SPM_U32_SYSSTATE_CRANK = 12UL,
      FI_EN_SPM_U32_SYSSTATE_REMOTE_PROGRAMMING = 13UL,
      FI_EN_SPM_U32_SYSSTATE_SEAT_BELT_RESTRICTIONS = 14UL,
      FI_EN_SPM_U32_SYSSTATE_SHOW_BATTERY_SAVER = 15UL,
      FI_EN_SPM_U32_SYSSTATE_LOCAL_VALET = 16UL,
      FI_EN_SPM_U32_SYSSTATE_SYSTEM_INIT = 17UL,
      FI_EN_SPM_U32_SYSSTATE_STARTUP_ANIMATION = 18UL,
      FI_EN_SPM_U32_SYSSTATE_SHOW_OFF = 128UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_SYS_STATE(cfc_fi_tcl_SPM_e32_SYS_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_SYS_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_SYS_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_MOST_EVENT : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_MOST_EVENT();
   enum tenType {
      FI_EN_SPM_U32_MOST_EVENT_NO_EVENT = 0UL,
      FI_EN_SPM_U32_MOST_EVENT_NET_ON = 1UL,
      FI_EN_SPM_U32_MOST_EVENT_NET_OFF = 2UL,
      FI_EN_SPM_U32_MOST_EVENT_UNLOCK = 3UL,
      FI_EN_SPM_U32_MOST_EVENT_LOCK_STABLE = 4UL,
      FI_EN_SPM_U32_MOST_EVENT_SHUTDOWN_EXECUTE = 5UL,
      FI_EN_SPM_U32_MOST_EVENT_CONFIG_STATE = 6UL,
      FI_EN_SPM_U32_MOST_EVENT_RING_OFF = 7UL,
      FI_EN_SPM_U32_MOST_EVENT_RING_ON = 8UL,
      FI_EN_SPM_U32_MOST_EVENT_TLA_STATE = 9UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_MOST_EVENT(cfc_fi_tcl_SPM_e32_MOST_EVENT::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_MOST_EVENT();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_MOST_EVENT& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE();
   enum tenType {
      FI_EN_SPM_U32_MOST_CONFIG_STATE_UNAVAILABLE = 0UL,
      FI_EN_SPM_U32_MOST_CONFIG_STATE_NOT_OK = 1UL,
      FI_EN_SPM_U32_MOST_CONFIG_STATE_OK = 2UL,
      FI_EN_SPM_U32_MOST_CONFIG_STATE_INVALID = 3UL,
      FI_EN_SPM_U32_MOST_CONFIG_STATE_NEW = 4UL,
      FI_EN_SPM_U32_MOST_CONFIG_STATE_NEW_EXT = 5UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE(cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_TLA_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_TLA_STATE();
   enum tenType {
      FI_EN_SPM_U32_TLA_STATE_UNAVAILABLE = 0UL,
      FI_EN_SPM_U32_TLA_STATE_DISCONNECTED = 1UL,
      FI_EN_SPM_U32_TLA_STATE_CONNECTED = 2UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_TLA_STATE(cfc_fi_tcl_SPM_e32_TLA_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_TLA_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_TLA_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_PROCESSOR_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_PROCESSOR_STATE();
   enum tenType {
      FI_EN_SPM_U32_PROC_STATE_NORMAL = 0UL,
      FI_EN_SPM_U32_PROC_STATE_DNL = 1UL,
      FI_EN_SPM_U32_PROC_STATE_TM = 2UL,
      FI_EN_SPM_U32_PROC_STATE_STANDBY = 3UL,
      FI_EN_SPM_U32_PROC_STATE_DOWN = 255UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_PROCESSOR_STATE(cfc_fi_tcl_SPM_e32_PROCESSOR_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_PROCESSOR_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_PROCESSOR_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_STARTUP_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_STARTUP_STATE();
   enum tenType {
      FI_EN_SPM_U32_STARTUP_STATE_INIT = 0UL,
      FI_EN_SPM_U32_STARTUP_STATE_BASE = 1UL,
      FI_EN_SPM_U32_STARTUP_STATE_VD = 2UL,
      FI_EN_SPM_U32_STARTUP_STATE_FC = 4UL,
      FI_EN_SPM_U32_STARTUP_STATE_NAVI = 8UL,
      FI_EN_SPM_U32_STARTUP_STATE_SDS = 16UL,
      FI_EN_SPM_U32_STARTUP_STATE_HMI = 32UL,
      FI_EN_SPM_U32_STARTUP_STATE_MM = 64UL,
      FI_EN_SPM_U32_STARTUP_STATE_MAP = 128UL,
      FI_EN_SPM_U32_STARTUP_STATE_TUNER = 256UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_STARTUP_STATE(cfc_fi_tcl_SPM_e32_STARTUP_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_STARTUP_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_STARTUP_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_RESTART_TYPE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_RESTART_TYPE();
   enum tenType {
      FI_EN_SPM_U32_RESTART_ECU = 0UL,
      FI_EN_SPM_U32_RESTART_WDT = 1UL,
      FI_EN_SPM_U32_RESTART_ECU_FAST = 2UL,
      FI_EN_SPM_U32_RESTART_DOWNLOAD_ERROR = 3UL,
      FI_EN_SPM_U32_RESTART_DOWNLOAD_FINISHED = 4UL,
      FI_EN_SPM_U32_RESTART_ECU_WITH_SYNC = 5UL,
      FI_EN_SPM_U32_RESTART_DOWNLOAD_ABORTED = 6UL,
      FI_EN_SPM_U32_RESTART_ECU_ALTSW_TESTMANAGER = 7UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_RESTART_TYPE(cfc_fi_tcl_SPM_e32_RESTART_TYPE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_RESTART_TYPE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_RESTART_TYPE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_CODE_REQUEST : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_CODE_REQUEST();
   enum tenType {
      FI_EN_SPM_U32_CODE_IDLE = 0UL,
      FI_EN_SPM_U32_CODE_REQUESTED = 1UL,
      FI_EN_SPM_U32_CODE_PROCESSED = 2UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_CODE_REQUEST(cfc_fi_tcl_SPM_e32_CODE_REQUEST::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_CODE_REQUEST();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_CODE_REQUEST& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST();
   enum tenType {
      FI_EN_SPM_U32_PHONE_ABORT_IDLE = 0UL,
      FI_EN_SPM_U32_PHONE_ABORT_REQUESTED = 1UL,
      FI_EN_SPM_U32_PHONE_ABORT_REJECTED = 2UL,
      FI_EN_SPM_U32_PHONE_ABORT_ACCEPTED = 3UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST(cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_WAKEUP_REASON : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_WAKEUP_REASON();
   enum tenType {
      FI_EN_SPM_U32_WAKEUP_INVALID = 0UL,
      FI_EN_SPM_U32_WAKEUP_CAN = 1UL,
      FI_EN_SPM_U32_WAKEUP_EJECT = 2UL,
      FI_EN_SPM_U32_WAKEUP_INSERT = 3UL,
      FI_EN_SPM_U32_WAKEUP_IGNITION = 4UL,
      FI_EN_SPM_U32_WAKEUP_RTC = 5UL,
      FI_EN_SPM_U32_WAKEUP_POWER_ON = 6UL,
      FI_EN_SPM_U32_WAKEUP_ON_TIPPER = 7UL,
      FI_EN_SPM_U32_WAKEUP_COPRO_REQ = 8UL,
      FI_EN_SPM_U32_WAKEUP_MAUS_BUS = 9UL,
      FI_EN_SPM_U32_WAKEUP_DOOR_OPEN = 10UL,
      FI_EN_SPM_U32_SDCARD_INSERT = 11UL,
      FI_EN_SPM_U32_WAKEUP_PHONE_MUTE = 12UL,
      FI_EN_SPM_U32_WAKEUP_ACCESSORY = 13UL,
      FI_EN_SPM_U32_WAKEUP_RESET = 255UL,
      FI_EN_SPM_U32_WAKEUP_RESTART = 4294967295UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_WAKEUP_REASON(cfc_fi_tcl_SPM_e32_WAKEUP_REASON::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_WAKEUP_REASON();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_WAKEUP_REASON& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_SWITCHON_REASON : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_SWITCHON_REASON();
   enum tenType {
      FI_EN_SPM_U32_ACCESSORY = 0UL,
      FI_EN_SPM_U32_DIAG = 1UL,
      FI_EN_SPM_U32_DOWNLOAD = 2UL,
      FI_EN_SPM_U32_PHONE = 3UL,
      FI_EN_SPM_U32_TIPPER = 4UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_SWITCHON_REASON(cfc_fi_tcl_SPM_e32_SWITCHON_REASON::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_SWITCHON_REASON();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_SWITCHON_REASON& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE();
   enum tenType {
      FI_EN_SPM_U32_EJECT_RELEASED = 0UL,
      FI_EN_SPM_U32_EJECT_PRESSED = 2UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE(cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_KEY_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_KEY_STATE();
   enum tenType {
      FI_EN_SPM_U32_RELEASED = 0UL,
      FI_EN_SPM_U32_PRESSED = 1UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_KEY_STATE(cfc_fi_tcl_SPM_e32_KEY_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_KEY_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_KEY_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_STARTUP_REASON : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_STARTUP_REASON();
   enum tenType {
      FI_EN_SPM_U32_STARTUP_ON_EJECT = 1UL,
      FI_EN_SPM_U32_STARTUP_ON_INSERT = 2UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_STARTUP_REASON(cfc_fi_tcl_SPM_e32_STARTUP_REASON::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_STARTUP_REASON();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_STARTUP_REASON& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE();
   enum tenType {
      FI_EN_SPM_U32_PHONEMUTE_INACTIVE = 0UL,
      FI_EN_SPM_U32_PHONEMUTE_ACTIVE = 1UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE(cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_LcmResetReason : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_LcmResetReason();
   enum tenType {
      FI_EN_SPM_EHMI_APP_ERROR = 0UL,
      FI_EN_SPM_EHMI_ECU = 1UL,
      FI_EN_SPM_EHMI_USER = 2UL,
      FI_EN_SPM_EHMI_DOWNLOAD = 3UL,
      FI_EN_SPM_EHMI_DOWNLOAD_ERROR = 4UL,
      FI_EN_SPM_EHMI_SOFTWARE = 5UL,
      FI_EN_SPM_EHMI_UNKNOWN = 6UL,
      FI_EN_SPM_EHMI_OVERTEMPERATURE = 7UL,
      FI_EN_SPM_EHMI_LCM_INTERN = 8UL,
      FI_EN_SPM_EHMI_POWER_ON_RESET = 60UL,
      FI_EN_SPM_EHMI_POWER_LOSS = 61UL,
      FI_EN_SPM_EHMI_POWER_OFF = 62UL,
      FI_EN_SPM_EHMI_SCC = 63UL,
      FI_EN_SPM_EHMI_WARMSTART = 99UL,
      FI_EN_SPM_ESCC_HW_WATCHDOG = 100UL,
      FI_EN_SPM_ESCC_POWER_ON = 101UL,
      FI_EN_SPM_ESCC_COLDSTART = 102UL,
      FI_EN_SPM_ESCC_APPMODE_CHANGE = 103UL,
      FI_EN_SPM_ESCC_DURING_LPW = 104UL,
      FI_EN_SPM_ESCC_DURING_PLL_OSZ = 105UL,
      FI_EN_SPM_ESCC_DURING_SW = 106UL,
      FI_EN_SPM_ESCC_WARMSTART = 107UL
   };
   tenType enType;

   cfc_fi_tcl_e8_LcmResetReason(cfc_fi_tcl_e8_LcmResetReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_LcmResetReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_LcmResetReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_CVM_EVENT : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_CVM_EVENT();
   enum tenType {
      FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START = 0UL,
      FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END = 1UL,
      FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START = 2UL,
      FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END = 3UL,
      FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START = 4UL,
      FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END = 5UL,
      FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START = 6UL,
      FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END = 7UL,
      FI_EN_SPM_U32_CVM_NO_EVENT = 15UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_CVM_EVENT(cfc_fi_tcl_SPM_e32_CVM_EVENT::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_CVM_EVENT();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_CVM_EVENT& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT();
   enum tenType {
      FI_EN_SPM_U32_CALIBRATED_CVM_CRITICAL_LOW_VOLTAGE_START = 0UL,
      FI_EN_SPM_U32_CALIBRATED_CVM_CRITICAL_LOW_VOLTAGE_END = 1UL,
      FI_EN_SPM_U32_CALIBRATED_CVM_LOW_VOLTAGE_START = 2UL,
      FI_EN_SPM_U32_CALIBRATED_CVM_LOW_VOLTAGE_END = 3UL,
      FI_EN_SPM_U32_CALIBRATED_CVM_HIGH_VOLTAGE_START = 4UL,
      FI_EN_SPM_U32_CALIBRATED_CVM_HIGH_VOLTAGE_END = 5UL,
      FI_EN_SPM_U32_CALIBRATED_CVM_CRITICAL_HIGH_VOLTAGE_START = 6UL,
      FI_EN_SPM_U32_CALIBRATED_CVM_CRITICAL_HIGH_VOLTAGE_END = 7UL,
      FI_EN_SPM_U32_CALIBRATED_CVM_NO_EVENT = 15UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT(cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_SYSPWRMODE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_SYSPWRMODE();
   enum tenType {
      FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED = 0UL,
      FI_EN_SPM_U32_SYSPWRMODE_OFF = 1UL,
      FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY = 2UL,
      FI_EN_SPM_U32_SYSPWRMODE_RUN = 3UL,
      FI_EN_SPM_U32_SYSPWRMODE_CRANK = 4UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_SYSPWRMODE(cfc_fi_tcl_SPM_e32_SYSPWRMODE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_SYSPWRMODE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_SYSPWRMODE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON();
   enum tenType {
      FI_EN_SPM_U8_WAKEUP_INVALID = 0UL,
      FI_EN_SPM_U8_WAKEUP_CAN = 1UL,
      FI_EN_SPM_U8_WAKEUP_EJECT = 2UL,
      FI_EN_SPM_U8_WAKEUP_INSERT = 3UL,
      FI_EN_SPM_U8_WAKEUP_IGNITION = 4UL,
      FI_EN_SPM_U8_WAKEUP_RTC = 5UL,
      FI_EN_SPM_U8_WAKEUP_POWER_ON = 6UL,
      FI_EN_SPM_U8_WAKEUP_ON_TIPPER = 7UL,
      FI_EN_SPM_U8_WAKEUP_COPRO_REQ = 8UL,
      FI_EN_SPM_U8_WAKEUP_MAUS_BUS = 9UL,
      FI_EN_SPM_U8_WAKEUP_DOOR_OPEN = 10UL,
      FI_EN_SPM_U8_SDCARD_INSERT = 11UL,
      FI_EN_SPM_U8_WAKEUP_PHONE_MUTE = 12UL,
      FI_EN_SPM_U8_WAKEUP_DIMMING = 13UL,
      FI_EN_SPM_U8_WAKEUP_MOST = 14UL,
      FI_EN_SPM_U8_WAKEUP_RESTART = 255UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON(cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_SPM_MonitoringMode : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_SPM_MonitoringMode();
   enum tenType {
      FI_EN_SPM_U8_MONITORING_OFF = 0UL,
      FI_EN_SPM_U8_MONITORING_CONTINUOUS = 1UL,
      FI_EN_SPM_U8_MONITORING_SINGLE = 2UL,
      FI_EN_SPM_U8_MONITORING_DEFAULTMODE = 3UL,
      FI_EN_SPM_U8_MONITORING_PREVIOUSMODE = 4UL
   };
   tenType enType;

   cfc_fi_tcl_e8_SPM_MonitoringMode(cfc_fi_tcl_e8_SPM_MonitoringMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_SPM_MonitoringMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_SPM_MonitoringMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_SPM_SupervisionControl : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_SPM_SupervisionControl();
   enum tenType {
      FI_EN_SPM_U8_SUPERVISION_DEFAULT = 0UL,
      FI_EN_SPM_U8_SUPERVISION_OFF = 1UL,
      FI_EN_SPM_U8_SUPERVISION_ON = 2UL
   };
   tenType enType;

   cfc_fi_tcl_e8_SPM_SupervisionControl(cfc_fi_tcl_e8_SPM_SupervisionControl::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_SPM_SupervisionControl();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_SPM_SupervisionControl& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_TestRoutineParameter : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_TestRoutineParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_TestRoutineParameter& operator=(const cfc_fi_tcl_SPM_TestRoutineParameter& coRef);
   cfc_fi_tcl_SPM_TestRoutineParameter(const cfc_fi_tcl_SPM_TestRoutineParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TroubleCode;
   tBool WriteToRM;
   cfc_fi_tcl_e8_SPM_MonitoringMode MonitoringMode;
   cfc_fi_tcl_e8_SPM_SupervisionControl SupervisionControl;
   virtual ~cfc_fi_tcl_SPM_TestRoutineParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_TestRoutineParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_TestRoutineParameterList : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_TestRoutineParameterList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_TestRoutineParameterList& operator=(const cfc_fi_tcl_SPM_TestRoutineParameterList& coRef);
   cfc_fi_tcl_SPM_TestRoutineParameterList(const cfc_fi_tcl_SPM_TestRoutineParameterList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_SPM_TestRoutineParameter, std::allocator<cfc_fi_tcl_SPM_TestRoutineParameter> > TestRoutineParameterList;
   virtual ~cfc_fi_tcl_SPM_TestRoutineParameterList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_TestRoutineParameterList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_SPM_TestResult : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_SPM_TestResult();
   enum tenType {
      FI_EN_PASSED = 0UL,
      FI_EN_FAILED = 1UL,
      FI_EN_NORESULT = 2UL,
      FI_EN_PASSEDDIAGNOSTIC = 3UL,
      FI_EN_FAILEDDIAGNOSTIC = 4UL,
      FI_EN_NORESULTDIAGNOSTIC = 5UL,
      FI_EN_DISABLE = 6UL,
      FI_EN_ENABLE = 7UL
   };
   tenType enType;

   cfc_fi_tcl_e8_SPM_TestResult(cfc_fi_tcl_e8_SPM_TestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_SPM_TestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_SPM_TestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_TestResult : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_TestResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_TestResult& operator=(const cfc_fi_tcl_SPM_TestResult& coRef);
   cfc_fi_tcl_SPM_TestResult(const cfc_fi_tcl_SPM_TestResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TroubleCode;
   cfc_fi_tcl_e8_SPM_TestResult Result;
   virtual ~cfc_fi_tcl_SPM_TestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_TestResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_TestResultList : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_TestResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_TestResultList& operator=(const cfc_fi_tcl_SPM_TestResultList& coRef);
   cfc_fi_tcl_SPM_TestResultList(const cfc_fi_tcl_SPM_TestResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_SPM_TestResult, std::allocator<cfc_fi_tcl_SPM_TestResult> > TestResultList;
   virtual ~cfc_fi_tcl_SPM_TestResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_TestResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_TransPortMode : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_TransPortMode();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_TransPortMode& operator=(const cfc_fi_tcl_SPM_TransPortMode& coRef);
   cfc_fi_tcl_SPM_TransPortMode(const cfc_fi_tcl_SPM_TransPortMode& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 YEAR;
   tU32 MONTH;
   tU32 DAY;
   tU32 HOUR;
   tU32 MINUTE;
   virtual ~cfc_fi_tcl_SPM_TransPortMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_TransPortMode& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_TransPortModeList : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_TransPortModeList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_TransPortModeList& operator=(const cfc_fi_tcl_SPM_TransPortModeList& coRef);
   cfc_fi_tcl_SPM_TransPortModeList(const cfc_fi_tcl_SPM_TransPortModeList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_SPM_TransPortMode, std::allocator<cfc_fi_tcl_SPM_TransPortMode> > TransPortModeList;
   virtual ~cfc_fi_tcl_SPM_TransPortModeList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_TransPortModeList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE();
   enum tenType {
      FI_EN_SPM_U8_PERSONALIZATION_PROGRESS_NONE = 0UL,
      FI_EN_SPM_U8_PERSONALIZATION_PROGRESS_STARTED = 1UL,
      FI_EN_SPM_U8_PERSONALIZATION_PROGRESS_ALL_APPS_IN_RR = 2UL,
      FI_EN_SPM_U8_PERSONALIZATION_PROGRESS_FINISHED = 3UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE(cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_StateModes : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_StateModes();
   enum tenType {
      FI_EN_SPM_E8_SYSMODEDOWNLOAD = 0UL,
      FI_EN_SPM_E8_SYSMODEDIAG = 1UL,
      FI_EN_SPM_E8_SYSMODEDOWNLOADEXIT = 2UL,
      FI_EN_SPM_E8_SYSMODESUSTOMERDOWNLOADSTART = 3UL,
      FI_EN_SPM_E8_SYSMODESUSTOMERDOWNLOADEXIT = 4UL
   };
   tenType enType;

   cfc_fi_tcl_e8_StateModes(cfc_fi_tcl_e8_StateModes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_StateModes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_StateModes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_StateEntryType : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_StateEntryType();
   enum tenType {
      FI_EN_SPM_E8_HISTORYENTRYWAKEUP = 0UL,
      FI_EN_SPM_E8_HISTORYENTRYSUBSTATE = 1UL,
      FI_EN_SPM_E8_HISTORYENTRYRESET = 2UL
   };
   tenType enType;

   cfc_fi_tcl_e8_StateEntryType(cfc_fi_tcl_e8_StateEntryType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_StateEntryType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_StateEntryType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SubStateEntry : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SubStateEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SubStateEntry& operator=(const cfc_fi_tcl_SubStateEntry& coRef);
   cfc_fi_tcl_SubStateEntry(const cfc_fi_tcl_SubStateEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_b32_SubState0 tSubStateMask0;
   cfc_fi_tcl_b32_SubState0 tSubStateData0;
   cfc_fi_tcl_b32_SubState1 tSubStateMask1;
   cfc_fi_tcl_b32_SubState1 tSubStateData1;
   cfc_fi_tcl_b32_SubState2 tSubStateMask2;
   cfc_fi_tcl_b32_SubState2 tSubStateData2;
   virtual ~cfc_fi_tcl_SubStateEntry();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SubStateEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_ProcessState : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_ProcessState();
   enum tenType {
      FI_EN_SPM_E8_PROCESSTOSTART = 0UL,
      FI_EN_SPM_E8_PROCESSRUNNING = 1UL,
      FI_EN_SPM_E8_PROCESSDOWN = 2UL
   };
   tenType enType;

   cfc_fi_tcl_e8_ProcessState(cfc_fi_tcl_e8_ProcessState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_ProcessState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_ProcessState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_ProcessElement : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_ProcessElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_ProcessElement& operator=(const cfc_fi_tcl_ProcessElement& coRef);
   cfc_fi_tcl_ProcessElement(const cfc_fi_tcl_ProcessElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclString tProcessName;
   cfc_fi_tcl_e8_ProcessState eProcState;
   virtual ~cfc_fi_tcl_ProcessElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_ProcessElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_ProcessInfo : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_ProcessInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_ProcessInfo& operator=(const cfc_fi_tcl_SPM_ProcessInfo& coRef);
   cfc_fi_tcl_SPM_ProcessInfo(const cfc_fi_tcl_SPM_ProcessInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_ProcessElement, std::allocator<cfc_fi_tcl_ProcessElement> > tProcesses;
   virtual ~cfc_fi_tcl_SPM_ProcessInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_ProcessInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_Vin : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_Vin();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_Vin& operator=(const cfc_fi_tcl_SPM_Vin& coRef);
   cfc_fi_tcl_SPM_Vin(const cfc_fi_tcl_SPM_Vin& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > Vin;
   virtual ~cfc_fi_tcl_SPM_Vin();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_Vin& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_VinHistory : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_VinHistory();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SPM_VinHistory& operator=(const cfc_fi_tcl_SPM_VinHistory& coRef);
   cfc_fi_tcl_SPM_VinHistory(const cfc_fi_tcl_SPM_VinHistory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_SPM_Vin, std::allocator<cfc_fi_tcl_SPM_Vin> > VinHistory;
   virtual ~cfc_fi_tcl_SPM_VinHistory();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SPM_VinHistory& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_ResetElement : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_ResetElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_ResetElement& operator=(const cfc_fi_tcl_ResetElement& coRef);
   cfc_fi_tcl_ResetElement(const cfc_fi_tcl_ResetElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclTimeDate tResetDate;
   cfc_fi_tcl_e8_LcmResetReason eReset;
   virtual ~cfc_fi_tcl_ResetElement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_ResetElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_WakeupElement : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_WakeupElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_WakeupElement& operator=(const cfc_fi_tcl_WakeupElement& coRef);
   cfc_fi_tcl_WakeupElement(const cfc_fi_tcl_WakeupElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclTimeDate tWakeupDate;
   cfc_fi_tcl_SPM_e32_WAKEUP_REASON eWakeupReason;
   virtual ~cfc_fi_tcl_WakeupElement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_WakeupElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_StateChangeElement : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_StateChangeElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_StateChangeElement& operator=(const cfc_fi_tcl_StateChangeElement& coRef);
   cfc_fi_tcl_StateChangeElement(const cfc_fi_tcl_StateChangeElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclTimeDate tWakeupDate;
   cfc_fi_tcl_SPM_e32_SYSTEM_STATES tSysState;
   cfc_fi_tcl_e8_StateEntryType tElemType;
   cfc_fi_tcl_SPM_e32_WAKEUP_REASON tWakeup;
   cfc_fi_tcl_e8_LcmResetReason tReset;
   cfc_fi_tcl_SubStateEntry tSubStates;
   virtual ~cfc_fi_tcl_StateChangeElement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_StateChangeElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SwitchOnElement : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SwitchOnElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_SwitchOnElement& operator=(const cfc_fi_tcl_SwitchOnElement& coRef);
   cfc_fi_tcl_SwitchOnElement(const cfc_fi_tcl_SwitchOnElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclTimeDate tSwitchOnDate;
   cfc_fi_tcl_SPM_e32_SubStateType eSwitchOnReason;
   virtual ~cfc_fi_tcl_SwitchOnElement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_SwitchOnElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_e32_START_PROC_TYPE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_e32_START_PROC_TYPE();
   enum tenType {
      FI_EN_SPM_U32_START_PROC_TYPE_OSAL_SPAWN = 0UL,
      FI_EN_SPM_U32_START_PROC_TYPE_NATIVE_SPAWN = 1UL,
      FI_EN_SPM_U32_START_PROC_TYPE_SCRIPT = 2UL,
      FI_EN_SPM_U32_START_PROC_TYPE_ADD_SUPERVISION = 3UL,
      FI_EN_SPM_U32_START_PROC_TYPE_SYSTEMD = 4UL
   };
   tenType enType;

   cfc_fi_tcl_SPM_e32_START_PROC_TYPE(cfc_fi_tcl_SPM_e32_START_PROC_TYPE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_SPM_e32_START_PROC_TYPE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_e32_START_PROC_TYPE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE();

   enum {
      FI_C_U32_BIT_SPM_E32_TRANSPORTMODE = 0x1UL,
      FI_C_U32_BIT_SPM_E32_ROLLER = 0x2UL,
      FI_C_U32_BIT_SPM_E32_FACTORY = 0x4UL,
      FI_C_U32_BIT_SPM_E32_QCRITICAL = 0x8UL
   };
   tBool bSPM_e32_TRANSPORTMODE() const {return (u32Value & FI_C_U32_BIT_SPM_E32_TRANSPORTMODE) != 0; }
   tVoid vSetSPM_e32_TRANSPORTMODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_TRANSPORTMODE):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_TRANSPORTMODE)); }
   tBool bSPM_e32_ROLLER() const {return (u32Value & FI_C_U32_BIT_SPM_E32_ROLLER) != 0; }
   tVoid vSetSPM_e32_ROLLER(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_ROLLER):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_ROLLER)); }
   tBool bSPM_e32_FACTORY() const {return (u32Value & FI_C_U32_BIT_SPM_E32_FACTORY) != 0; }
   tVoid vSetSPM_e32_FACTORY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_FACTORY):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_FACTORY)); }
   tBool bSPM_e32_QCRITICAL() const {return (u32Value & FI_C_U32_BIT_SPM_E32_QCRITICAL) != 0; }
   tVoid vSetSPM_e32_QCRITICAL(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SPM_E32_QCRITICAL):(u32Value & ~(tU32)FI_C_U32_BIT_SPM_E32_QCRITICAL)); }
   struct rBitValues {
      tBool SPM_e32_TRANSPORTMODE:1;
      tBool SPM_e32_ROLLER:1;
      tBool SPM_e32_FACTORY:1;
      tBool SPM_e32_QCRITICAL:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_Vehicle_Data_U8_ACC_Status : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_Vehicle_Data_U8_ACC_Status();
   enum tenType {
      FI_EN_ACC_OFF = 0UL,
      FI_EN_ACC_INIT = 1UL,
      FI_EN_ACC_PASSIVE = 2UL,
      FI_EN_ACC_ACTIVE = 3UL,
      FI_EN_ACC_IN_THE_BACKGROUND = 4UL,
      FI_EN_ACC_SHUTDOWN = 5UL,
      FI_EN_ACC_REV_FROM = 6UL,
      FI_EN_ACC_IRREV_FROM = 7UL
   };
   tenType enType;

   cfc_fi_tcl_Vehicle_Data_U8_ACC_Status(cfc_fi_tcl_Vehicle_Data_U8_ACC_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_Vehicle_Data_U8_ACC_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_Vehicle_Data_U8_ACC_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity();
   enum tenType {
      FI_EN_NO_CRASH = 0UL,
      FI_EN_INTENSITY_1 = 1UL,
      FI_EN_INTENSITY_2_ONLY_ACTUATOR = 2UL,
      FI_EN_INTENSITY_2_ONLY_COLARADO = 3UL,
      FI_EN_INTENSITY_3_ALT_VW_AUDI = 4UL,
      FI_EN_INTENSITY_3_ALT_PAG = 5UL,
      FI_EN_INTENSITY_3 = 7UL
   };
   tenType enType;

   cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity(cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status();
   enum tenType {
      FI_EN_VALID_INFO = 0UL,
      FI_EN_SENSOR_DEFECT = 1UL,
      FI_EN_CAR_LEVEL = 2UL,
      FI_EN_MOTOR_ON = 3UL
   };
   tenType enType;

   cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status(cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code();
   enum tenType {
      FI_EN_NO_KEY = 0UL,
      FI_EN_CONTEXT_MENU = 1UL,
      FI_EN_MENU_UP = 2UL,
      FI_EN_MENU_DOWN = 3UL,
      FI_EN_UP = 4UL,
      FI_EN_DOWN = 5UL,
      FI_EN_UP__DOWN_THUMBWHEEL = 6UL,
      FI_EN_OK__THUMBWHEEL_BUTTON = 7UL,
      FI_EN_CANCEL__ESCAPE = 8UL,
      FI_EN_MAIN_MENU = 9UL,
      FI_EN_SIDE_MENU_LEFT = 10UL,
      FI_EN_SIDE_MENU_RIGHT = 11UL,
      FI_EN_FAS_MENU = 12UL,
      FI_EN_VOLUME_UP = 16UL,
      FI_EN_VOLUME_DOWN = 17UL,
      FI_EN_VOLUME_UP__DOWN_THUMBWHEEL = 18UL,
      FI_EN_VOLUME_THUMBWHEEL_BUTTON = 19UL,
      FI_EN_AUDIO_SOURCE = 20UL,
      FI_EN_ARROW_A_UP__RIGHT = 21UL,
      FI_EN_ARROW_A_DOWN__LEFT = 22UL,
      FI_EN_ARROW_B_UP__RIGHT = 23UL,
      FI_EN_ARROW_B_DOWN__LEFT = 24UL,
      FI_EN_PTT__PUSHTOTALK = 25UL,
      FI_EN_PTT_CANCEL = 26UL,
      FI_EN_ROUTE_INFO = 27UL,
      FI_EN_HOOK = 28UL,
      FI_EN_HANG_UP = 29UL,
      FI_EN_OFF_HOOK = 30UL,
      FI_EN_LIGHT_ON__OFF = 31UL,
      FI_EN_MUTE = 32UL,
      FI_EN_JOKER1 = 33UL,
      FI_EN_JOKER2 = 34UL,
      FI_EN_VIEW = 35UL,
      FI_EN_MAP = 100UL,
      FI_EN_MAP_BOOST = 101UL,
      FI_EN_TURN_SIGNAL_LEFT = 102UL,
      FI_EN_TURN_SIGNAL_RIGHT = 103UL,
      FI_EN_TURN_SIGNAL_OFF = 104UL,
      FI_EN_FLASHLIGHT = 105UL,
      FI_EN_HIGHBEAM = 106UL,
      FI_EN_WASHER_BUTTON = 107UL,
      FI_EN_WIPER_BUTTON_LEFT = 108UL,
      FI_EN_WIPER_BUTTON_RIGHT = 109UL,
      FI_EN_WIPER_BUTTON_CANCEL = 110UL,
      FI_EN_EXHAUST_SOUND = 111UL,
      FI_EN_DRIVE_SELECT_BUTTON = 112UL,
      FI_EN_SPORT_BUTTON = 113UL,
      FI_EN_ESP_DRIFT_SELECTION_THUMBWHEEL = 114UL,
      FI_EN_STARTUP_RESET = 240UL,
      FI_EN_INITIALIZATION = 241UL
   };
   tenType enType;

   cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code(cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode();
   enum tenType {
      FI_EN_NO_EVENT = 0UL,
      FI_EN_TICK_UP_1 = 1UL,
      FI_EN_TICK_UP_2 = 2UL,
      FI_EN_TICK_UP_3 = 3UL,
      FI_EN_TICK_UP_4 = 4UL,
      FI_EN_TICK_UP_5 = 5UL,
      FI_EN_TICK_UP_6 = 6UL,
      FI_EN_TICK_UP_7 = 7UL,
      FI_EN_TICK_DOWN_7 = 9UL,
      FI_EN_TICK_DOWN_6 = 10UL,
      FI_EN_TICK_DOWN_5 = 11UL,
      FI_EN_TICK_DOWN_4 = 12UL,
      FI_EN_TICK_DOWN_3 = 13UL,
      FI_EN_TICK_DOWN_2 = 14UL,
      FI_EN_TICK_DOWN_1 = 15UL
   };
   tenType enType;

   cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode(cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_Car_ViewOptions : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_Car_ViewOptions();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_fi_tcl_Car_ViewOptions& operator=(const cfc_fi_tcl_Car_ViewOptions& coRef);
   cfc_fi_tcl_Car_ViewOptions(const cfc_fi_tcl_Car_ViewOptions& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 state;
   tS32 reason;
   virtual ~cfc_fi_tcl_Car_ViewOptions();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_fi_tcl_Car_ViewOptions& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_DefSetMode : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_DefSetMode();
   enum tenType {
      FI_EN_DEFSET_SRC_NOT_DEF = 255UL,
      FI_EN_DEFSET_SRC_SET_USER = 0UL,
      FI_EN_DEFSET_SRC_SET_TEF = 1UL,
      FI_EN_DEFSET_SRC_UPREG = 2UL,
      FI_EN_DEFSET_SRC_RELUPREG = 3UL,
      FI_EN_DEFSET_SRC_GET = 4UL,
      FI_EN_DEFSET_SRC_SET_OEM = 5UL
   };
   tenType enType;

   cfc_fi_tcl_e8_DefSetMode(cfc_fi_tcl_e8_DefSetMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_DefSetMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_DefSetMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

class cfc_fi_tcl_e8_DefSetServiceStatus : public cfc_fi_tclVisitableTypeBase
{
public:

   cfc_fi_tcl_e8_DefSetServiceStatus();
   enum tenType {
      FI_EN_DEFSET_STATE_UNDEFINED = 255UL,
      FI_EN_DEFSET_STATE_CONFIRMED = 0UL,
      FI_EN_DEFSET_STATE_FAILED = 1UL
   };
   tenType enType;

   cfc_fi_tcl_e8_DefSetServiceStatus(cfc_fi_tcl_e8_DefSetServiceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~cfc_fi_tcl_e8_DefSetServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const cfc_fi_tcl_e8_DefSetServiceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(cfc_fi_tclVisitorBase& rfoVisitor);
};

#endif
