/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_TYPES
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_FUNCTIONIDS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_SERVICEINFO
#include "cfc_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for CFC_VEHICLE_FI message types

fi_tclMessageBase* cfc_vehiclefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case cfc_vehiclefi_tclToken::EN_MSG_IGNITIONUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgIgnitionUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_IGNITIONRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgIgnitionRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_IGNITIONGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgIgnitionGet;

      case cfc_vehiclefi_tclToken::EN_MSG_IGNITIONSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgIgnitionStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_KEY_INSERTIONUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgKey_InsertionUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_KEY_INSERTIONRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgKey_InsertionRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_KEY_INSERTIONGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgKey_InsertionGet;

      case cfc_vehiclefi_tclToken::EN_MSG_KEY_INSERTIONSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgKey_InsertionStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_DISPLAYUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_DISPLAYRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_DISPLAYGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_DISPLAYSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ILLUMINATION_CAN_DAY_NIGHTUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ILLUMINATION_CAN_DAY_NIGHTRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ILLUMINATION_CAN_DAY_NIGHTGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ILLUMINATION_CAN_DAY_NIGHTSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_ILLUMINATION_CAN_SENSORUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_ILLUMINATION_CAN_SENSORRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_ILLUMINATION_CAN_SENSORGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_ILLUMINATION_CAN_SENSORSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ERROR_FORGET_COUNTERUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgError_Forget_CounterUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ERROR_FORGET_COUNTERRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ERROR_FORGET_COUNTERGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgError_Forget_CounterGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ERROR_FORGET_COUNTERSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgError_Forget_CounterStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_MILEAGEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_MileageUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_MILEAGERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_MILEAGEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_MileageGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_MILEAGESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_MileageStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_DATEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_DateUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_DATERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_DateRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_DATEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_DateGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_DATESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_DateStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_TIMEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_TimeUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_TIMERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_TIMEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_TimeGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_TIMESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_TimeStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ACC_STATUSUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgACC_StatusUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ACC_STATUSRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgACC_StatusRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ACC_STATUSGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgACC_StatusGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ACC_STATUSSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgACC_StatusStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CRANKING_REQUESTUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCranking_RequestUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CRANKING_REQUESTRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCranking_RequestRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CRANKING_REQUESTGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCranking_RequestGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CRANKING_REQUESTSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCranking_RequestStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_REVERSEGEARUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgReverseGearUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_REVERSEGEARRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgReverseGearRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_REVERSEGEARGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgReverseGearGet;

      case cfc_vehiclefi_tclToken::EN_MSG_REVERSEGEARSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgReverseGearStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CRANKINGUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCrankingUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CRANKINGRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCrankingRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CRANKINGGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCrankingGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CRANKINGSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCrankingStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_KICKDOWNUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_KICKDOWNRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_KICKDOWNGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgAccelerator_KickdownGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_KICKDOWNSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgAccelerator_KickdownStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEEDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeedUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEEDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeedRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEEDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeedGet;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEEDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeedStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_INDICATORUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgIndicatorUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_INDICATORRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgIndicatorRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_INDICATORGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgIndicatorGet;

      case cfc_vehiclefi_tclToken::EN_MSG_INDICATORSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgIndicatorStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_REMOTE_START_OPERATIONUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_REMOTE_START_OPERATIONRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_REMOTE_START_OPERATIONGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgRemote_Start_OperationGet;

      case cfc_vehiclefi_tclToken::EN_MSG_REMOTE_START_OPERATIONSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgRemote_Start_OperationStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_CRASH_INTENSITYUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_CRASH_INTENSITYRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_CRASH_INTENSITYGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_CRASH_INTENSITYSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ANZEIGE_AKTIVUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ANZEIGE_AKTIVRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ANZEIGE_AKTIVGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ANZEIGE_AKTIVSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_MIN_WARNINGUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_MIN_WARNINGRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_MIN_WARNINGGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet;

      case cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_MIN_WARNINGSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSTANDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_OelstandUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSTANDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSTANDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_OelstandGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSTANDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_OelstandStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSYSTEM_AKTIVUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSYSTEM_AKTIVRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSYSTEM_AKTIVGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSYSTEM_AKTIVSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BETRIEBSWARMUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BETRIEBSWARMRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BETRIEBSWARMGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_betriebswarmGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BETRIEBSWARMSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_betriebswarmStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_UEBERFUELL_WARNUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_UEBERFUELL_WARNRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_UEBERFUELL_WARNGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_UEBERFUELL_WARNSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_INFO_VALIDITYUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_INFO_VALIDITYRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_INFO_VALIDITYGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_INFO_VALIDITYSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELMENGEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_OelmengeUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELMENGERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELMENGEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_OelmengeGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OELMENGESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_OelmengeStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_LEVEL_AVAILABLEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_LEVEL_AVAILABLERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_LEVEL_AVAILABLEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_LEVEL_AVAILABLESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_UNTERFUELL_WARNINGUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_UNTERFUELL_WARNINGRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_UNTERFUELL_WARNINGGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet;

      case cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_UNTERFUELL_WARNINGSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_VEHICLE_LOCKEDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_VEHICLE_LOCKEDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_VEHICLE_LOCKEDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_VEHICLE_LOCKEDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_DOOR_STATEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Door_StateUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_DOOR_STATERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_DOOR_STATEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Door_StateGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_DOOR_STATESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Door_StateStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ROOF_STATEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ROOF_STATERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ROOF_STATEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Roof_StateGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ROOF_STATESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Roof_StateStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_TRUNKUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_TrunkUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_TRUNKRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_TRUNKGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_TrunkGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_TRUNKSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_TrunkStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEED_QUALITYUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeed_QualityUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEED_QUALITYRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEED_QUALITYGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeed_QualityGet;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEED_QUALITYSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeed_QualityStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_LONGITUDINAL_ACCELERATIONUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_LONGITUDINAL_ACCELERATIONRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_LONGITUDINAL_ACCELERATIONGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet;

      case cfc_vehiclefi_tclToken::EN_MSG_LONGITUDINAL_ACCELERATIONSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_GierrateUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_GierrateGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_GierrateStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATE_SIGNUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATE_SIGNRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATE_SIGNGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATE_SIGNSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_MOTOR_LAEUFTUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_MOTOR_LAEUFTRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_MOTOR_LAEUFTGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_MOTOR_LAEUFTSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_BRAKE_SWITCHUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrake_SwitchUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BRAKE_SWITCHRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BRAKE_SWITCHGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrake_SwitchGet;

      case cfc_vehiclefi_tclToken::EN_MSG_BRAKE_SWITCHSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrake_SwitchStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CLUTCHUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgClutchUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CLUTCHRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgClutchRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CLUTCHGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgClutchGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CLUTCHSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgClutchStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_KEY_CODEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_KEY_CODERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_KEY_CODEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_Key_CodeGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_KEY_CODESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_Key_CodeStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_EVENT_CODEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_EVENT_CODERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_EVENT_CODEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_Event_CodeGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_EVENT_CODESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_Event_CodeStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_TYPEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_TypeUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_TYPERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_TypeRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_TYPEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_TypeGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MFL_TYPESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMFL_TypeStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_BATTERYUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBatteryUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BATTERYRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBatteryRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BATTERYGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgBatteryGet;

      case cfc_vehiclefi_tclToken::EN_MSG_BATTERYSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgBatteryStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_STROMSPARMODUSUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_STROMSPARMODUSRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_STROMSPARMODUSGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_StromsparmodusGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_STROMSPARMODUSSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgWheel_AngleUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgWheel_AngleRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgWheel_AngleGet;

      case cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgWheel_AngleStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLE_SIGNUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLE_SIGNRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLE_SIGNGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgWheel_Angle_SignGet;

      case cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLE_SIGNSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgWheel_Angle_SignStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ACOUSTIC_PARKINGSYSTEM_ACTIVITYUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ACOUSTIC_PARKINGSYSTEM_ACTIVITYRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ACOUSTIC_PARKINGSYSTEM_ACTIVITYGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ACOUSTIC_PARKINGSYSTEM_ACTIVITYSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_NWDFUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgNWDFUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_NWDFRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgNWDFRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_NWDFGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgNWDFGet;

      case cfc_vehiclefi_tclToken::EN_MSG_NWDFSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgNWDFStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_QRS_MODEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgQRS_ModeUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_QRS_MODERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgQRS_ModeRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_QRS_MODEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgQRS_ModeGet;

      case cfc_vehiclefi_tclToken::EN_MSG_QRS_MODESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgQRS_ModeStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ECO_CHARISMA_TASTEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ECO_CHARISMA_TASTERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ECO_CHARISMA_TASTEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_ECO_CHARISMA_TASTESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_AMPLIFIER_MUTEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_AMPLIFIER_MUTERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_AMPLIFIER_MUTEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_AMPLIFIER_MUTESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BLINKERUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_BlinkerUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BLINKERRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BLINKERGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_BlinkerGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BLINKERSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_BlinkerStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CAN_UNITUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCAN_UnitUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CAN_UNITRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCAN_UnitRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CAN_UNITGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCAN_UnitGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CAN_UNITSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCAN_UnitStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_LANGUAGEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgLanguageUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_LANGUAGERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgLanguageRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_LANGUAGEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgLanguageGet;

      case cfc_vehiclefi_tclToken::EN_MSG_LANGUAGESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgLanguageStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MOTOR_RPMUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMotor_RPMUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MOTOR_RPMRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMotor_RPMRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MOTOR_RPMGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMotor_RPMGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MOTOR_RPMSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMotor_RPMStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BRAKE_PRESSUREUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BRAKE_PRESSURERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BRAKE_PRESSUREGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Brake_PressureGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BRAKE_PRESSURESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_CURRENT_TORQUEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_CURRENT_TORQUERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_CURRENT_TORQUEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Current_TorqueGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_CURRENT_TORQUESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_POSITIONUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgAccelerator_PositionUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_POSITIONRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_POSITIONGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgAccelerator_PositionGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_POSITIONSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgAccelerator_PositionStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_GEARBOX_OIL_TEMPERATUREUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_GEARBOX_OIL_TEMPERATURERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_GEARBOX_OIL_TEMPERATUREGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet;

      case cfc_vehiclefi_tclToken::EN_MSG_GEARBOX_OIL_TEMPERATURESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_KLIMA_POWER_CONSUMPTIONUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_KLIMA_POWER_CONSUMPTIONRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_KLIMA_POWER_CONSUMPTIONGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgKlima_Power_consumptionGet;

      case cfc_vehiclefi_tclToken::EN_MSG_KLIMA_POWER_CONSUMPTIONSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_FUELWARNING_SECONDARYUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_FUELWARNING_SECONDARYRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_FUELWARNING_SECONDARYGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet;

      case cfc_vehiclefi_tclToken::EN_MSG_FUELWARNING_SECONDARYSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_BATTERY_VOLTAGEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_BATTERY_VOLTAGERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_BATTERY_VOLTAGEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_BATTERY_VOLTAGESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_SWITCHESUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_SWITCHESRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_SWITCHESGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_SWITCHESSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ENGINE_STATUSUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgEngine_StatusUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ENGINE_STATUSRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgEngine_StatusRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ENGINE_STATUSGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgEngine_StatusGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ENGINE_STATUSSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgEngine_StatusStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BOOST_PRESSUREUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BOOST_PRESSURERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BOOST_PRESSUREGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Boost_PressureGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_BOOST_PRESSURESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_RELATIVE_BOOST_PRESSUREUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_RELATIVE_BOOST_PRESSURERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_RELATIVE_BOOST_PRESSUREGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_RELATIVE_BOOST_PRESSURESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_GEAR_INFOUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgGear_InfoUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_GEAR_INFORELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgGear_InfoRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_GEAR_INFOGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgGear_InfoGet;

      case cfc_vehiclefi_tclToken::EN_MSG_GEAR_INFOSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgGear_InfoStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_SWITCH_SENSITIVITY_AVAILABLEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_SWITCH_SENSITIVITY_AVAILABLERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_SWITCH_SENSITIVITY_AVAILABLEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet;

      case cfc_vehiclefi_tclToken::EN_MSG_SWITCH_SENSITIVITY_AVAILABLESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_ENGINE_SPEEDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgEngine_SpeedUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ENGINE_SPEEDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_ENGINE_SPEEDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgEngine_SpeedGet;

      case cfc_vehiclefi_tclToken::EN_MSG_ENGINE_SPEEDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgEngine_SpeedStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_MEDIUM_TIRE_CIRCUMFERENCEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_MEDIUM_TIRE_CIRCUMFERENCERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_MEDIUM_TIRE_CIRCUMFERENCEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_MEDIUM_TIRE_CIRCUMFERENCESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_OUTSIDE_TEMPERATUREUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_OUTSIDE_TEMPERATURERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_OUTSIDE_TEMPERATUREGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_OUTSIDE_TEMPERATURESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_TACHO_SPEEDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgTacho_SpeedUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_TACHO_SPEEDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_TACHO_SPEEDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgTacho_SpeedGet;

      case cfc_vehiclefi_tclToken::EN_MSG_TACHO_SPEEDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgTacho_SpeedStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEED_IN_KOMBIUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEED_IN_KOMBIRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEED_IN_KOMBIGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeed_In_KombiGet;

      case cfc_vehiclefi_tclToken::EN_MSG_SPEED_IN_KOMBISTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgSpeed_In_KombiStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_CAR_TYPEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_CAR_TYPERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_CAR_TYPEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Car_TypeGet;

      case cfc_vehiclefi_tclToken::EN_MSG_PQ_CAR_TYPESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgPQ_Car_TypeStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_VINUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgVINUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_VINRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgVINRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_VINGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgVINGet;

      case cfc_vehiclefi_tclToken::EN_MSG_VINSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgVINStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_COUNTRYUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCountryUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_COUNTRYRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCountryRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_COUNTRYGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCountryGet;

      case cfc_vehiclefi_tclToken::EN_MSG_COUNTRYSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCountryStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_KEY_INFOUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_KEY_INFORELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_KEY_INFOGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Key_InfoGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MQB_KEY_INFOSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMQB_Key_InfoStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_USER_PROFILEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgUser_ProfileUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_USER_PROFILERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgUser_ProfileRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_USER_PROFILEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgUser_ProfileGet;

      case cfc_vehiclefi_tclToken::EN_MSG_USER_PROFILESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgUser_ProfileStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_TRANSMISSION_TYPEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgTransmission_TypeUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_TRANSMISSION_TYPERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_TRANSMISSION_TYPEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgTransmission_TypeGet;

      case cfc_vehiclefi_tclToken::EN_MSG_TRANSMISSION_TYPESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgTransmission_TypeStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_VARIANTUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgVariantUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_VARIANTRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgVariantRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_VARIANTGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgVariantGet;

      case cfc_vehiclefi_tclToken::EN_MSG_VARIANTSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgVariantStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_COASTING_ISACTIVEUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_COASTING_ISACTIVERELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_COASTING_ISACTIVEGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCoasting_IsActiveGet;

      case cfc_vehiclefi_tclToken::EN_MSG_COASTING_ISACTIVESTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCoasting_IsActiveStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_OUTPUT_POWERUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_OUTPUT_POWERRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_OUTPUT_POWERGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_Output_PowerGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CURRENT_OUTPUT_POWERSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_VEHICLESTANDSTILLUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgVehicleStandStillUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_VEHICLESTANDSTILLRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_VEHICLESTANDSTILLGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgVehicleStandStillGet;

      case cfc_vehiclefi_tclToken::EN_MSG_VEHICLESTANDSTILLSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgVehicleStandStillStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_TV_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_TV_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_TV_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgTV_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_TV_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_CAR_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CAR_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_CAR_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgCar_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_CAR_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_HDD_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_HDD_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_HDD_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_HDD_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERSLIDES_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERSLIDES_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERSLIDES_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERSLIDES_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERBORDBOOK_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERBORDBOOK_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERBORDBOOK_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERBORDBOOK_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERTRAVELAGENT_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERTRAVELAGENT_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERTRAVELAGENT_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERTRAVELAGENT_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERWEB_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERWEB_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERWEB_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_BROWSERWEB_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_BWS_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BWS_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BWS_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_BWS_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_RADIOTEXT_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_RADIOTEXT_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_RADIOTEXT_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_RADIOTEXT_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_BTBONDING_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BTBONDING_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_BTBONDING_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_BTBONDING_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_DESTINATIONINPUT_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_DESTINATIONINPUT_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_DESTINATIONINPUT_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_DESTINATIONINPUT_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus;

      case cfc_vehiclefi_tclToken::EN_MSG_MESSAGING_VELOCITYTHRESHOLDUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MESSAGING_VELOCITYTHRESHOLDRELUPREG:
         return OSAL_NEW cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg;

      case cfc_vehiclefi_tclToken::EN_MSG_MESSAGING_VELOCITYTHRESHOLDGET:
         return OSAL_NEW cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet;

      case cfc_vehiclefi_tclToken::EN_MSG_MESSAGING_VELOCITYTHRESHOLDSTATUS:
         return OSAL_NEW cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all cfc_vehiclefifi messages

// common functions

tU16 cfc_vehiclefi_tclMsgBaseMessage::u16GetServiceID() const
{
   return CFC_VEHICLEFI_C_U16_SERVICE_ID;
}

tU16 cfc_vehiclefi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 cfc_vehiclefi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& cfc_vehiclefi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& cfc_vehiclefi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 cfc_vehiclefi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

cfc_vehiclefi_tclMsgIgnitionUpReg::cfc_vehiclefi_tclMsgIgnitionUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgIgnitionUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_IGNITIONUPREG;
}


cfc_vehiclefi_tclMsgIgnitionUpReg::~cfc_vehiclefi_tclMsgIgnitionUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgIgnitionRelUpReg::cfc_vehiclefi_tclMsgIgnitionRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgIgnitionRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_IGNITIONRELUPREG;
}


cfc_vehiclefi_tclMsgIgnitionRelUpReg::~cfc_vehiclefi_tclMsgIgnitionRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgIgnitionGet::cfc_vehiclefi_tclMsgIgnitionGet()
 {}

tS32 cfc_vehiclefi_tclMsgIgnitionGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_IGNITIONGET;
}


cfc_vehiclefi_tclMsgIgnitionGet::~cfc_vehiclefi_tclMsgIgnitionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgIgnitionStatus::cfc_vehiclefi_tclMsgIgnitionStatus(const cfc_vehiclefi_tclMsgIgnitionStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   IgnitionStatus = coRef.IgnitionStatus;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgIgnitionStatus& cfc_vehiclefi_tclMsgIgnitionStatus::operator=(const cfc_vehiclefi_tclMsgIgnitionStatus& coRef)
{
   if (this == &coRef) return *this;
   IgnitionStatus = coRef.IgnitionStatus;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgIgnitionStatus::cfc_vehiclefi_tclMsgIgnitionStatus()
:IgnitionStatus(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgIgnitionStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_IGNITIONSTATUS;
}


cfc_vehiclefi_tclMsgIgnitionStatus::~cfc_vehiclefi_tclMsgIgnitionStatus()
{}

tU32 cfc_vehiclefi_tclMsgIgnitionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgIgnitionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IgnitionStatus);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgIgnitionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IgnitionStatus);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgIgnitionStatus::operator==(const cfc_vehiclefi_tclMsgIgnitionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IgnitionStatus == roRef.IgnitionStatus);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgKey_InsertionUpReg::cfc_vehiclefi_tclMsgKey_InsertionUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgKey_InsertionUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_KEY_INSERTIONUPREG;
}


cfc_vehiclefi_tclMsgKey_InsertionUpReg::~cfc_vehiclefi_tclMsgKey_InsertionUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgKey_InsertionRelUpReg::cfc_vehiclefi_tclMsgKey_InsertionRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgKey_InsertionRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_KEY_INSERTIONRELUPREG;
}


cfc_vehiclefi_tclMsgKey_InsertionRelUpReg::~cfc_vehiclefi_tclMsgKey_InsertionRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgKey_InsertionGet::cfc_vehiclefi_tclMsgKey_InsertionGet()
 {}

tS32 cfc_vehiclefi_tclMsgKey_InsertionGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_KEY_INSERTIONGET;
}


cfc_vehiclefi_tclMsgKey_InsertionGet::~cfc_vehiclefi_tclMsgKey_InsertionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgKey_InsertionStatus::cfc_vehiclefi_tclMsgKey_InsertionStatus(const cfc_vehiclefi_tclMsgKey_InsertionStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   KeyInsertionState = coRef.KeyInsertionState;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgKey_InsertionStatus& cfc_vehiclefi_tclMsgKey_InsertionStatus::operator=(const cfc_vehiclefi_tclMsgKey_InsertionStatus& coRef)
{
   if (this == &coRef) return *this;
   KeyInsertionState = coRef.KeyInsertionState;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgKey_InsertionStatus::cfc_vehiclefi_tclMsgKey_InsertionStatus()
:KeyInsertionState(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgKey_InsertionStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_KEY_INSERTIONSTATUS;
}


cfc_vehiclefi_tclMsgKey_InsertionStatus::~cfc_vehiclefi_tclMsgKey_InsertionStatus()
{}

tU32 cfc_vehiclefi_tclMsgKey_InsertionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgKey_InsertionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyInsertionState);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgKey_InsertionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyInsertionState);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgKey_InsertionStatus::operator==(const cfc_vehiclefi_tclMsgKey_InsertionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyInsertionState == roRef.KeyInsertionState);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg::cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_DISPLAYUPREG;
}


cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg::~cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg::cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_DISPLAYRELUPREG;
}


cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg::~cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet::cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet()
 {}

tS32 cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_DISPLAYGET;
}


cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet::~cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   IlluminationValue = coRef.IlluminationValue;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus& cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::operator=(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus& coRef)
{
   if (this == &coRef) return *this;
   IlluminationValue = coRef.IlluminationValue;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus()
:IlluminationValue(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_DISPLAYSTATUS;
}


cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::~cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus()
{}

tU32 cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IlluminationValue);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IlluminationValue);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus::operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IlluminationValue == roRef.IlluminationValue);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg::cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ILLUMINATION_CAN_DAY_NIGHTUPREG;
}


cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg::~cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg::cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ILLUMINATION_CAN_DAY_NIGHTRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg::~cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet::cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ILLUMINATION_CAN_DAY_NIGHTGET;
}


cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet::~cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Illumination_CAN_Day_Night = coRef.Illumination_CAN_Day_Night;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus& cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus& coRef)
{
   if (this == &coRef) return *this;
   Illumination_CAN_Day_Night = coRef.Illumination_CAN_Day_Night;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus()
:Illumination_CAN_Day_Night(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ILLUMINATION_CAN_DAY_NIGHTSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::~cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Illumination_CAN_Day_Night);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Illumination_CAN_Day_Night);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Illumination_CAN_Day_Night == roRef.Illumination_CAN_Day_Night);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg::cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_ILLUMINATION_CAN_SENSORUPREG;
}


cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg::~cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg::cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_ILLUMINATION_CAN_SENSORRELUPREG;
}


cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg::~cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet::cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_ILLUMINATION_CAN_SENSORGET;
}


cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet::~cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   IlluminationValue = coRef.IlluminationValue;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus& cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::operator=(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus& coRef)
{
   if (this == &coRef) return *this;
   IlluminationValue = coRef.IlluminationValue;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus()
:IlluminationValue(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_ILLUMINATION_CAN_SENSORSTATUS;
}


cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::~cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus()
{}

tU32 cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IlluminationValue);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IlluminationValue);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus::operator==(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IlluminationValue == roRef.IlluminationValue);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgError_Forget_CounterUpReg::cfc_vehiclefi_tclMsgError_Forget_CounterUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgError_Forget_CounterUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ERROR_FORGET_COUNTERUPREG;
}


cfc_vehiclefi_tclMsgError_Forget_CounterUpReg::~cfc_vehiclefi_tclMsgError_Forget_CounterUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg::cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ERROR_FORGET_COUNTERRELUPREG;
}


cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg::~cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgError_Forget_CounterGet::cfc_vehiclefi_tclMsgError_Forget_CounterGet()
 {}

tS32 cfc_vehiclefi_tclMsgError_Forget_CounterGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ERROR_FORGET_COUNTERGET;
}


cfc_vehiclefi_tclMsgError_Forget_CounterGet::~cfc_vehiclefi_tclMsgError_Forget_CounterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgError_Forget_CounterStatus::cfc_vehiclefi_tclMsgError_Forget_CounterStatus(const cfc_vehiclefi_tclMsgError_Forget_CounterStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   CounterValue = coRef.CounterValue;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgError_Forget_CounterStatus& cfc_vehiclefi_tclMsgError_Forget_CounterStatus::operator=(const cfc_vehiclefi_tclMsgError_Forget_CounterStatus& coRef)
{
   if (this == &coRef) return *this;
   CounterValue = coRef.CounterValue;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgError_Forget_CounterStatus::cfc_vehiclefi_tclMsgError_Forget_CounterStatus()
:CounterValue(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgError_Forget_CounterStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ERROR_FORGET_COUNTERSTATUS;
}


cfc_vehiclefi_tclMsgError_Forget_CounterStatus::~cfc_vehiclefi_tclMsgError_Forget_CounterStatus()
{}

tU32 cfc_vehiclefi_tclMsgError_Forget_CounterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgError_Forget_CounterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CounterValue);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgError_Forget_CounterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CounterValue);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgError_Forget_CounterStatus::operator==(const cfc_vehiclefi_tclMsgError_Forget_CounterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CounterValue == roRef.CounterValue);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_MileageUpReg::cfc_vehiclefi_tclMsgCurrent_MileageUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_MileageUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_MILEAGEUPREG;
}


cfc_vehiclefi_tclMsgCurrent_MileageUpReg::~cfc_vehiclefi_tclMsgCurrent_MileageUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg::cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_MILEAGERELUPREG;
}


cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg::~cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_MileageGet::cfc_vehiclefi_tclMsgCurrent_MileageGet()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_MileageGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_MILEAGEGET;
}


cfc_vehiclefi_tclMsgCurrent_MileageGet::~cfc_vehiclefi_tclMsgCurrent_MileageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCurrent_MileageStatus::cfc_vehiclefi_tclMsgCurrent_MileageStatus(const cfc_vehiclefi_tclMsgCurrent_MileageStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCurrent_MileageStatus& cfc_vehiclefi_tclMsgCurrent_MileageStatus::operator=(const cfc_vehiclefi_tclMsgCurrent_MileageStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCurrent_MileageStatus::cfc_vehiclefi_tclMsgCurrent_MileageStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_MileageStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_MILEAGESTATUS;
}


cfc_vehiclefi_tclMsgCurrent_MileageStatus::~cfc_vehiclefi_tclMsgCurrent_MileageStatus()
{}

tU32 cfc_vehiclefi_tclMsgCurrent_MileageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCurrent_MileageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCurrent_MileageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCurrent_MileageStatus::operator==(const cfc_vehiclefi_tclMsgCurrent_MileageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_DateUpReg::cfc_vehiclefi_tclMsgCurrent_DateUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_DateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_DATEUPREG;
}


cfc_vehiclefi_tclMsgCurrent_DateUpReg::~cfc_vehiclefi_tclMsgCurrent_DateUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_DateRelUpReg::cfc_vehiclefi_tclMsgCurrent_DateRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_DateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_DATERELUPREG;
}


cfc_vehiclefi_tclMsgCurrent_DateRelUpReg::~cfc_vehiclefi_tclMsgCurrent_DateRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_DateGet::cfc_vehiclefi_tclMsgCurrent_DateGet()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_DateGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_DATEGET;
}


cfc_vehiclefi_tclMsgCurrent_DateGet::~cfc_vehiclefi_tclMsgCurrent_DateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCurrent_DateStatus::cfc_vehiclefi_tclMsgCurrent_DateStatus(const cfc_vehiclefi_tclMsgCurrent_DateStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCurrent_DateStatus& cfc_vehiclefi_tclMsgCurrent_DateStatus::operator=(const cfc_vehiclefi_tclMsgCurrent_DateStatus& coRef)
{
   if (this == &coRef) return *this;
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCurrent_DateStatus::cfc_vehiclefi_tclMsgCurrent_DateStatus()
:Year(0)
,Month(0)
,Day(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_DateStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_DATESTATUS;
}


cfc_vehiclefi_tclMsgCurrent_DateStatus::~cfc_vehiclefi_tclMsgCurrent_DateStatus()
{}

tU32 cfc_vehiclefi_tclMsgCurrent_DateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCurrent_DateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Year);
   (tVoid) (oIn >> Month);
   (tVoid) (oIn >> Day);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCurrent_DateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Year);
   (tVoid) (oOut << Month);
   (tVoid) (oOut << Day);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCurrent_DateStatus::operator==(const cfc_vehiclefi_tclMsgCurrent_DateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Year == roRef.Year);
   bResult = bResult && (Month == roRef.Month);
   bResult = bResult && (Day == roRef.Day);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_TimeUpReg::cfc_vehiclefi_tclMsgCurrent_TimeUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_TimeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_TIMEUPREG;
}


cfc_vehiclefi_tclMsgCurrent_TimeUpReg::~cfc_vehiclefi_tclMsgCurrent_TimeUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg::cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_TIMERELUPREG;
}


cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg::~cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_TimeGet::cfc_vehiclefi_tclMsgCurrent_TimeGet()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_TimeGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_TIMEGET;
}


cfc_vehiclefi_tclMsgCurrent_TimeGet::~cfc_vehiclefi_tclMsgCurrent_TimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCurrent_TimeStatus::cfc_vehiclefi_tclMsgCurrent_TimeStatus(const cfc_vehiclefi_tclMsgCurrent_TimeStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Hour = coRef.Hour;
   Minutes = coRef.Minutes;
   Seconds = coRef.Seconds;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCurrent_TimeStatus& cfc_vehiclefi_tclMsgCurrent_TimeStatus::operator=(const cfc_vehiclefi_tclMsgCurrent_TimeStatus& coRef)
{
   if (this == &coRef) return *this;
   Hour = coRef.Hour;
   Minutes = coRef.Minutes;
   Seconds = coRef.Seconds;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCurrent_TimeStatus::cfc_vehiclefi_tclMsgCurrent_TimeStatus()
:Hour(0)
,Minutes(0)
,Seconds(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_TimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_TIMESTATUS;
}


cfc_vehiclefi_tclMsgCurrent_TimeStatus::~cfc_vehiclefi_tclMsgCurrent_TimeStatus()
{}

tU32 cfc_vehiclefi_tclMsgCurrent_TimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCurrent_TimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Hour);
   (tVoid) (oIn >> Minutes);
   (tVoid) (oIn >> Seconds);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCurrent_TimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Hour);
   (tVoid) (oOut << Minutes);
   (tVoid) (oOut << Seconds);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCurrent_TimeStatus::operator==(const cfc_vehiclefi_tclMsgCurrent_TimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Hour == roRef.Hour);
   bResult = bResult && (Minutes == roRef.Minutes);
   bResult = bResult && (Seconds == roRef.Seconds);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgACC_StatusUpReg::cfc_vehiclefi_tclMsgACC_StatusUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgACC_StatusUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACC_STATUSUPREG;
}


cfc_vehiclefi_tclMsgACC_StatusUpReg::~cfc_vehiclefi_tclMsgACC_StatusUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgACC_StatusRelUpReg::cfc_vehiclefi_tclMsgACC_StatusRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgACC_StatusRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACC_STATUSRELUPREG;
}


cfc_vehiclefi_tclMsgACC_StatusRelUpReg::~cfc_vehiclefi_tclMsgACC_StatusRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgACC_StatusGet::cfc_vehiclefi_tclMsgACC_StatusGet()
 {}

tS32 cfc_vehiclefi_tclMsgACC_StatusGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACC_STATUSGET;
}


cfc_vehiclefi_tclMsgACC_StatusGet::~cfc_vehiclefi_tclMsgACC_StatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgACC_StatusStatus::cfc_vehiclefi_tclMsgACC_StatusStatus(const cfc_vehiclefi_tclMsgACC_StatusStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgACC_StatusStatus& cfc_vehiclefi_tclMsgACC_StatusStatus::operator=(const cfc_vehiclefi_tclMsgACC_StatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgACC_StatusStatus::cfc_vehiclefi_tclMsgACC_StatusStatus()
:Status()
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgACC_StatusStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACC_STATUSSTATUS;
}


cfc_vehiclefi_tclMsgACC_StatusStatus::~cfc_vehiclefi_tclMsgACC_StatusStatus()
{}

tU32 cfc_vehiclefi_tclMsgACC_StatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgACC_StatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgACC_StatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgACC_StatusStatus::operator==(const cfc_vehiclefi_tclMsgACC_StatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCranking_RequestUpReg::cfc_vehiclefi_tclMsgCranking_RequestUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCranking_RequestUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CRANKING_REQUESTUPREG;
}


cfc_vehiclefi_tclMsgCranking_RequestUpReg::~cfc_vehiclefi_tclMsgCranking_RequestUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCranking_RequestRelUpReg::cfc_vehiclefi_tclMsgCranking_RequestRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCranking_RequestRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CRANKING_REQUESTRELUPREG;
}


cfc_vehiclefi_tclMsgCranking_RequestRelUpReg::~cfc_vehiclefi_tclMsgCranking_RequestRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCranking_RequestGet::cfc_vehiclefi_tclMsgCranking_RequestGet()
 {}

tS32 cfc_vehiclefi_tclMsgCranking_RequestGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CRANKING_REQUESTGET;
}


cfc_vehiclefi_tclMsgCranking_RequestGet::~cfc_vehiclefi_tclMsgCranking_RequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCranking_RequestStatus::cfc_vehiclefi_tclMsgCranking_RequestStatus(const cfc_vehiclefi_tclMsgCranking_RequestStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   RequestState = coRef.RequestState;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCranking_RequestStatus& cfc_vehiclefi_tclMsgCranking_RequestStatus::operator=(const cfc_vehiclefi_tclMsgCranking_RequestStatus& coRef)
{
   if (this == &coRef) return *this;
   RequestState = coRef.RequestState;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCranking_RequestStatus::cfc_vehiclefi_tclMsgCranking_RequestStatus()
:RequestState(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCranking_RequestStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CRANKING_REQUESTSTATUS;
}


cfc_vehiclefi_tclMsgCranking_RequestStatus::~cfc_vehiclefi_tclMsgCranking_RequestStatus()
{}

tU32 cfc_vehiclefi_tclMsgCranking_RequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCranking_RequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestState);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCranking_RequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestState);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCranking_RequestStatus::operator==(const cfc_vehiclefi_tclMsgCranking_RequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestState == roRef.RequestState);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgReverseGearUpReg::cfc_vehiclefi_tclMsgReverseGearUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgReverseGearUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_REVERSEGEARUPREG;
}


cfc_vehiclefi_tclMsgReverseGearUpReg::~cfc_vehiclefi_tclMsgReverseGearUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgReverseGearRelUpReg::cfc_vehiclefi_tclMsgReverseGearRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgReverseGearRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_REVERSEGEARRELUPREG;
}


cfc_vehiclefi_tclMsgReverseGearRelUpReg::~cfc_vehiclefi_tclMsgReverseGearRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgReverseGearGet::cfc_vehiclefi_tclMsgReverseGearGet()
 {}

tS32 cfc_vehiclefi_tclMsgReverseGearGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_REVERSEGEARGET;
}


cfc_vehiclefi_tclMsgReverseGearGet::~cfc_vehiclefi_tclMsgReverseGearGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgReverseGearStatus::cfc_vehiclefi_tclMsgReverseGearStatus(const cfc_vehiclefi_tclMsgReverseGearStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgReverseGearStatus& cfc_vehiclefi_tclMsgReverseGearStatus::operator=(const cfc_vehiclefi_tclMsgReverseGearStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgReverseGearStatus::cfc_vehiclefi_tclMsgReverseGearStatus()
:Status(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgReverseGearStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_REVERSEGEARSTATUS;
}


cfc_vehiclefi_tclMsgReverseGearStatus::~cfc_vehiclefi_tclMsgReverseGearStatus()
{}

tU32 cfc_vehiclefi_tclMsgReverseGearStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgReverseGearStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgReverseGearStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgReverseGearStatus::operator==(const cfc_vehiclefi_tclMsgReverseGearStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCrankingUpReg::cfc_vehiclefi_tclMsgCrankingUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCrankingUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CRANKINGUPREG;
}


cfc_vehiclefi_tclMsgCrankingUpReg::~cfc_vehiclefi_tclMsgCrankingUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCrankingRelUpReg::cfc_vehiclefi_tclMsgCrankingRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCrankingRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CRANKINGRELUPREG;
}


cfc_vehiclefi_tclMsgCrankingRelUpReg::~cfc_vehiclefi_tclMsgCrankingRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCrankingGet::cfc_vehiclefi_tclMsgCrankingGet()
 {}

tS32 cfc_vehiclefi_tclMsgCrankingGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CRANKINGGET;
}


cfc_vehiclefi_tclMsgCrankingGet::~cfc_vehiclefi_tclMsgCrankingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCrankingStatus::cfc_vehiclefi_tclMsgCrankingStatus(const cfc_vehiclefi_tclMsgCrankingStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCrankingStatus& cfc_vehiclefi_tclMsgCrankingStatus::operator=(const cfc_vehiclefi_tclMsgCrankingStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCrankingStatus::cfc_vehiclefi_tclMsgCrankingStatus()
:Status(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCrankingStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CRANKINGSTATUS;
}


cfc_vehiclefi_tclMsgCrankingStatus::~cfc_vehiclefi_tclMsgCrankingStatus()
{}

tU32 cfc_vehiclefi_tclMsgCrankingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCrankingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCrankingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCrankingStatus::operator==(const cfc_vehiclefi_tclMsgCrankingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg::cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_KICKDOWNUPREG;
}


cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg::~cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg::cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_KICKDOWNRELUPREG;
}


cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg::~cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgAccelerator_KickdownGet::cfc_vehiclefi_tclMsgAccelerator_KickdownGet()
 {}

tS32 cfc_vehiclefi_tclMsgAccelerator_KickdownGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_KICKDOWNGET;
}


cfc_vehiclefi_tclMsgAccelerator_KickdownGet::~cfc_vehiclefi_tclMsgAccelerator_KickdownGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::cfc_vehiclefi_tclMsgAccelerator_KickdownStatus(const cfc_vehiclefi_tclMsgAccelerator_KickdownStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgAccelerator_KickdownStatus& cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::operator=(const cfc_vehiclefi_tclMsgAccelerator_KickdownStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::cfc_vehiclefi_tclMsgAccelerator_KickdownStatus()
:Status(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_KICKDOWNSTATUS;
}


cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::~cfc_vehiclefi_tclMsgAccelerator_KickdownStatus()
{}

tU32 cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgAccelerator_KickdownStatus::operator==(const cfc_vehiclefi_tclMsgAccelerator_KickdownStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgSpeedUpReg::cfc_vehiclefi_tclMsgSpeedUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgSpeedUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEEDUPREG;
}


cfc_vehiclefi_tclMsgSpeedUpReg::~cfc_vehiclefi_tclMsgSpeedUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgSpeedRelUpReg::cfc_vehiclefi_tclMsgSpeedRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgSpeedRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEEDRELUPREG;
}


cfc_vehiclefi_tclMsgSpeedRelUpReg::~cfc_vehiclefi_tclMsgSpeedRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgSpeedGet::cfc_vehiclefi_tclMsgSpeedGet()
 {}

tS32 cfc_vehiclefi_tclMsgSpeedGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEEDGET;
}


cfc_vehiclefi_tclMsgSpeedGet::~cfc_vehiclefi_tclMsgSpeedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgSpeedStatus::cfc_vehiclefi_tclMsgSpeedStatus(const cfc_vehiclefi_tclMsgSpeedStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Speed = coRef.Speed;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgSpeedStatus& cfc_vehiclefi_tclMsgSpeedStatus::operator=(const cfc_vehiclefi_tclMsgSpeedStatus& coRef)
{
   if (this == &coRef) return *this;
   Speed = coRef.Speed;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgSpeedStatus::cfc_vehiclefi_tclMsgSpeedStatus()
:Speed(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgSpeedStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEEDSTATUS;
}


cfc_vehiclefi_tclMsgSpeedStatus::~cfc_vehiclefi_tclMsgSpeedStatus()
{}

tU32 cfc_vehiclefi_tclMsgSpeedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgSpeedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Speed);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgSpeedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Speed);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgSpeedStatus::operator==(const cfc_vehiclefi_tclMsgSpeedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Speed == roRef.Speed);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgIndicatorUpReg::cfc_vehiclefi_tclMsgIndicatorUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgIndicatorUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_INDICATORUPREG;
}


cfc_vehiclefi_tclMsgIndicatorUpReg::~cfc_vehiclefi_tclMsgIndicatorUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgIndicatorRelUpReg::cfc_vehiclefi_tclMsgIndicatorRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgIndicatorRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_INDICATORRELUPREG;
}


cfc_vehiclefi_tclMsgIndicatorRelUpReg::~cfc_vehiclefi_tclMsgIndicatorRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgIndicatorGet::cfc_vehiclefi_tclMsgIndicatorGet()
 {}

tS32 cfc_vehiclefi_tclMsgIndicatorGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_INDICATORGET;
}


cfc_vehiclefi_tclMsgIndicatorGet::~cfc_vehiclefi_tclMsgIndicatorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgIndicatorStatus::cfc_vehiclefi_tclMsgIndicatorStatus(const cfc_vehiclefi_tclMsgIndicatorStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Right_Status = coRef.Right_Status;
   Left_Status = coRef.Left_Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgIndicatorStatus& cfc_vehiclefi_tclMsgIndicatorStatus::operator=(const cfc_vehiclefi_tclMsgIndicatorStatus& coRef)
{
   if (this == &coRef) return *this;
   Right_Status = coRef.Right_Status;
   Left_Status = coRef.Left_Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgIndicatorStatus::cfc_vehiclefi_tclMsgIndicatorStatus()
:Right_Status(0)
,Left_Status(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgIndicatorStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_INDICATORSTATUS;
}


cfc_vehiclefi_tclMsgIndicatorStatus::~cfc_vehiclefi_tclMsgIndicatorStatus()
{}

tU32 cfc_vehiclefi_tclMsgIndicatorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgIndicatorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Right_Status);
   (tVoid) (oIn >> Left_Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgIndicatorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Right_Status);
   (tVoid) (oOut << Left_Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgIndicatorStatus::operator==(const cfc_vehiclefi_tclMsgIndicatorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Right_Status == roRef.Right_Status);
   bResult = bResult && (Left_Status == roRef.Left_Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg::cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_REMOTE_START_OPERATIONUPREG;
}


cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg::~cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg::cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_REMOTE_START_OPERATIONRELUPREG;
}


cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg::~cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgRemote_Start_OperationGet::cfc_vehiclefi_tclMsgRemote_Start_OperationGet()
 {}

tS32 cfc_vehiclefi_tclMsgRemote_Start_OperationGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_REMOTE_START_OPERATIONGET;
}


cfc_vehiclefi_tclMsgRemote_Start_OperationGet::~cfc_vehiclefi_tclMsgRemote_Start_OperationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::cfc_vehiclefi_tclMsgRemote_Start_OperationStatus(const cfc_vehiclefi_tclMsgRemote_Start_OperationStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgRemote_Start_OperationStatus& cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::operator=(const cfc_vehiclefi_tclMsgRemote_Start_OperationStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::cfc_vehiclefi_tclMsgRemote_Start_OperationStatus()
:Status(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_REMOTE_START_OPERATIONSTATUS;
}


cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::~cfc_vehiclefi_tclMsgRemote_Start_OperationStatus()
{}

tU32 cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgRemote_Start_OperationStatus::operator==(const cfc_vehiclefi_tclMsgRemote_Start_OperationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg::cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_CRASH_INTENSITYUPREG;
}


cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg::~cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg::cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_CRASH_INTENSITYRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg::~cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet::cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_CRASH_INTENSITYGET;
}


cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet::~cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus& cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus()
:Status()
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_CRASH_INTENSITYSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::~cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg::cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ANZEIGE_AKTIVUPREG;
}


cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg::~cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg::cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ANZEIGE_AKTIVRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg::~cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet::cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ANZEIGE_AKTIVGET;
}


cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet::~cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus& cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus()
:Status(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ANZEIGE_AKTIVSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::~cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg::cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_MIN_WARNINGUPREG;
}


cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg::~cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg::cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_MIN_WARNINGRELUPREG;
}


cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg::~cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet::cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet()
 {}

tS32 cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_MIN_WARNINGGET;
}


cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet::~cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Warning = coRef.Warning;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus& cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::operator=(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus& coRef)
{
   if (this == &coRef) return *this;
   Warning = coRef.Warning;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus()
:Warning(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_MIN_WARNINGSTATUS;
}


cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::~cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus()
{}

tU32 cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Warning);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Warning);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus::operator==(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Warning == roRef.Warning);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_OelstandUpReg::cfc_vehiclefi_tclMsgMQB_OelstandUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_OelstandUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSTANDUPREG;
}


cfc_vehiclefi_tclMsgMQB_OelstandUpReg::~cfc_vehiclefi_tclMsgMQB_OelstandUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg::cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSTANDRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg::~cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_OelstandGet::cfc_vehiclefi_tclMsgMQB_OelstandGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_OelstandGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSTANDGET;
}


cfc_vehiclefi_tclMsgMQB_OelstandGet::~cfc_vehiclefi_tclMsgMQB_OelstandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_OelstandStatus::cfc_vehiclefi_tclMsgMQB_OelstandStatus(const cfc_vehiclefi_tclMsgMQB_OelstandStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Level = coRef.Level;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_OelstandStatus& cfc_vehiclefi_tclMsgMQB_OelstandStatus::operator=(const cfc_vehiclefi_tclMsgMQB_OelstandStatus& coRef)
{
   if (this == &coRef) return *this;
   Level = coRef.Level;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_OelstandStatus::cfc_vehiclefi_tclMsgMQB_OelstandStatus()
:Level(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_OelstandStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSTANDSTATUS;
}


cfc_vehiclefi_tclMsgMQB_OelstandStatus::~cfc_vehiclefi_tclMsgMQB_OelstandStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_OelstandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_OelstandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Level);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_OelstandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Level);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_OelstandStatus::operator==(const cfc_vehiclefi_tclMsgMQB_OelstandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Level == roRef.Level);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg::cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSYSTEM_AKTIVUPREG;
}


cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg::~cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg::cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSYSTEM_AKTIVRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg::~cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet::cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSYSTEM_AKTIVGET;
}


cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet::~cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus& cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus()
:State(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELSYSTEM_AKTIVSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::~cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg::cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BETRIEBSWARMUPREG;
}


cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg::~cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg::cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BETRIEBSWARMRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg::~cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_betriebswarmGet::cfc_vehiclefi_tclMsgMQB_betriebswarmGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_betriebswarmGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BETRIEBSWARMGET;
}


cfc_vehiclefi_tclMsgMQB_betriebswarmGet::~cfc_vehiclefi_tclMsgMQB_betriebswarmGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::cfc_vehiclefi_tclMsgMQB_betriebswarmStatus(const cfc_vehiclefi_tclMsgMQB_betriebswarmStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_betriebswarmStatus& cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::operator=(const cfc_vehiclefi_tclMsgMQB_betriebswarmStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::cfc_vehiclefi_tclMsgMQB_betriebswarmStatus()
:State(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BETRIEBSWARMSTATUS;
}


cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::~cfc_vehiclefi_tclMsgMQB_betriebswarmStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_betriebswarmStatus::operator==(const cfc_vehiclefi_tclMsgMQB_betriebswarmStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg::cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_UEBERFUELL_WARNUPREG;
}


cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg::~cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg::cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_UEBERFUELL_WARNRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg::~cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet::cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_UEBERFUELL_WARNGET;
}


cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet::~cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Warning = coRef.Warning;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus& cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus& coRef)
{
   if (this == &coRef) return *this;
   Warning = coRef.Warning;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus()
:Warning(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_UEBERFUELL_WARNSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::~cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Warning);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Warning);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Warning == roRef.Warning);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg::cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_INFO_VALIDITYUPREG;
}


cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg::~cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg::cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_INFO_VALIDITYRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg::~cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet::cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_INFO_VALIDITYGET;
}


cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet::~cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus& cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus()
:State()
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_INFO_VALIDITYSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::~cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_OelmengeUpReg::cfc_vehiclefi_tclMsgMQB_OelmengeUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_OelmengeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELMENGEUPREG;
}


cfc_vehiclefi_tclMsgMQB_OelmengeUpReg::~cfc_vehiclefi_tclMsgMQB_OelmengeUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg::cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELMENGERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg::~cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_OelmengeGet::cfc_vehiclefi_tclMsgMQB_OelmengeGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_OelmengeGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELMENGEGET;
}


cfc_vehiclefi_tclMsgMQB_OelmengeGet::~cfc_vehiclefi_tclMsgMQB_OelmengeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_OelmengeStatus::cfc_vehiclefi_tclMsgMQB_OelmengeStatus(const cfc_vehiclefi_tclMsgMQB_OelmengeStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_OelmengeStatus& cfc_vehiclefi_tclMsgMQB_OelmengeStatus::operator=(const cfc_vehiclefi_tclMsgMQB_OelmengeStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_OelmengeStatus::cfc_vehiclefi_tclMsgMQB_OelmengeStatus()
:State(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_OelmengeStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OELMENGESTATUS;
}


cfc_vehiclefi_tclMsgMQB_OelmengeStatus::~cfc_vehiclefi_tclMsgMQB_OelmengeStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_OelmengeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_OelmengeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_OelmengeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_OelmengeStatus::operator==(const cfc_vehiclefi_tclMsgMQB_OelmengeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg::cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_LEVEL_AVAILABLEUPREG;
}


cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg::~cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg::cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_LEVEL_AVAILABLERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg::~cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet::cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_LEVEL_AVAILABLEGET;
}


cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet::~cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Available = coRef.Available;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus& cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   Available = coRef.Available;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus()
:Available(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_OIL_LEVEL_AVAILABLESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::~cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Available);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Available);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Available == roRef.Available);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg::cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_UNTERFUELL_WARNINGUPREG;
}


cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg::~cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg::cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_UNTERFUELL_WARNINGRELUPREG;
}


cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg::~cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet::cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet()
 {}

tS32 cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_UNTERFUELL_WARNINGGET;
}


cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet::~cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Warning = coRef.Warning;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus& cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::operator=(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus& coRef)
{
   if (this == &coRef) return *this;
   Warning = coRef.Warning;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus()
:Warning(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_OIL_LEVEL_UNTERFUELL_WARNINGSTATUS;
}


cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::~cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus()
{}

tU32 cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Warning);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Warning);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus::operator==(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Warning == roRef.Warning);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg::cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_VEHICLE_LOCKEDUPREG;
}


cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg::~cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg::cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_VEHICLE_LOCKEDRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg::~cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet::cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_VEHICLE_LOCKEDGET;
}


cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet::~cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Locked = coRef.Locked;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus& cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus& coRef)
{
   if (this == &coRef) return *this;
   Locked = coRef.Locked;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus()
:Locked(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_VEHICLE_LOCKEDSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::~cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Locked);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Locked);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Locked == roRef.Locked);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Door_StateUpReg::cfc_vehiclefi_tclMsgMQB_Door_StateUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Door_StateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_DOOR_STATEUPREG;
}


cfc_vehiclefi_tclMsgMQB_Door_StateUpReg::~cfc_vehiclefi_tclMsgMQB_Door_StateUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg::cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_DOOR_STATERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg::~cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Door_StateGet::cfc_vehiclefi_tclMsgMQB_Door_StateGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Door_StateGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_DOOR_STATEGET;
}


cfc_vehiclefi_tclMsgMQB_Door_StateGet::~cfc_vehiclefi_tclMsgMQB_Door_StateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Door_StateStatus::cfc_vehiclefi_tclMsgMQB_Door_StateStatus(const cfc_vehiclefi_tclMsgMQB_Door_StateStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   MQB_ZV_HFS_offen = coRef.MQB_ZV_HFS_offen;
   MQB_ZV_HBFS_offen = coRef.MQB_ZV_HBFS_offen;
   MQB_ZV_BT_offen = coRef.MQB_ZV_BT_offen;
   MQB_ZV_FT_offen = coRef.MQB_ZV_FT_offen;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Door_StateStatus& cfc_vehiclefi_tclMsgMQB_Door_StateStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Door_StateStatus& coRef)
{
   if (this == &coRef) return *this;
   MQB_ZV_HFS_offen = coRef.MQB_ZV_HFS_offen;
   MQB_ZV_HBFS_offen = coRef.MQB_ZV_HBFS_offen;
   MQB_ZV_BT_offen = coRef.MQB_ZV_BT_offen;
   MQB_ZV_FT_offen = coRef.MQB_ZV_FT_offen;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Door_StateStatus::cfc_vehiclefi_tclMsgMQB_Door_StateStatus()
:MQB_ZV_HFS_offen(0)
,MQB_ZV_HBFS_offen(0)
,MQB_ZV_BT_offen(0)
,MQB_ZV_FT_offen(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Door_StateStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_DOOR_STATESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Door_StateStatus::~cfc_vehiclefi_tclMsgMQB_Door_StateStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Door_StateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Door_StateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MQB_ZV_HFS_offen);
   (tVoid) (oIn >> MQB_ZV_HBFS_offen);
   (tVoid) (oIn >> MQB_ZV_BT_offen);
   (tVoid) (oIn >> MQB_ZV_FT_offen);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Door_StateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MQB_ZV_HFS_offen);
   (tVoid) (oOut << MQB_ZV_HBFS_offen);
   (tVoid) (oOut << MQB_ZV_BT_offen);
   (tVoid) (oOut << MQB_ZV_FT_offen);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Door_StateStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Door_StateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MQB_ZV_HFS_offen == roRef.MQB_ZV_HFS_offen);
   bResult = bResult && (MQB_ZV_HBFS_offen == roRef.MQB_ZV_HBFS_offen);
   bResult = bResult && (MQB_ZV_BT_offen == roRef.MQB_ZV_BT_offen);
   bResult = bResult && (MQB_ZV_FT_offen == roRef.MQB_ZV_FT_offen);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg::cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ROOF_STATEUPREG;
}


cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg::~cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg::cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ROOF_STATERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg::~cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Roof_StateGet::cfc_vehiclefi_tclMsgMQB_Roof_StateGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Roof_StateGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ROOF_STATEGET;
}


cfc_vehiclefi_tclMsgMQB_Roof_StateGet::~cfc_vehiclefi_tclMsgMQB_Roof_StateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::cfc_vehiclefi_tclMsgMQB_Roof_StateStatus(const cfc_vehiclefi_tclMsgMQB_Roof_StateStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   MQB_VS_VD_offen_ver = coRef.MQB_VS_VD_offen_ver;
   MQB_VS_VD_zu_ver = coRef.MQB_VS_VD_zu_ver;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Roof_StateStatus& cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Roof_StateStatus& coRef)
{
   if (this == &coRef) return *this;
   MQB_VS_VD_offen_ver = coRef.MQB_VS_VD_offen_ver;
   MQB_VS_VD_zu_ver = coRef.MQB_VS_VD_zu_ver;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::cfc_vehiclefi_tclMsgMQB_Roof_StateStatus()
:MQB_VS_VD_offen_ver(0)
,MQB_VS_VD_zu_ver(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ROOF_STATESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::~cfc_vehiclefi_tclMsgMQB_Roof_StateStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MQB_VS_VD_offen_ver);
   (tVoid) (oIn >> MQB_VS_VD_zu_ver);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MQB_VS_VD_offen_ver);
   (tVoid) (oOut << MQB_VS_VD_zu_ver);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Roof_StateStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Roof_StateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MQB_VS_VD_offen_ver == roRef.MQB_VS_VD_offen_ver);
   bResult = bResult && (MQB_VS_VD_zu_ver == roRef.MQB_VS_VD_zu_ver);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_TrunkUpReg::cfc_vehiclefi_tclMsgMQB_TrunkUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_TrunkUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_TRUNKUPREG;
}


cfc_vehiclefi_tclMsgMQB_TrunkUpReg::~cfc_vehiclefi_tclMsgMQB_TrunkUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg::cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_TRUNKRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg::~cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_TrunkGet::cfc_vehiclefi_tclMsgMQB_TrunkGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_TrunkGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_TRUNKGET;
}


cfc_vehiclefi_tclMsgMQB_TrunkGet::~cfc_vehiclefi_tclMsgMQB_TrunkGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_TrunkStatus::cfc_vehiclefi_tclMsgMQB_TrunkStatus(const cfc_vehiclefi_tclMsgMQB_TrunkStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Trunk = coRef.Trunk;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_TrunkStatus& cfc_vehiclefi_tclMsgMQB_TrunkStatus::operator=(const cfc_vehiclefi_tclMsgMQB_TrunkStatus& coRef)
{
   if (this == &coRef) return *this;
   Trunk = coRef.Trunk;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_TrunkStatus::cfc_vehiclefi_tclMsgMQB_TrunkStatus()
:Trunk(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_TrunkStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_TRUNKSTATUS;
}


cfc_vehiclefi_tclMsgMQB_TrunkStatus::~cfc_vehiclefi_tclMsgMQB_TrunkStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_TrunkStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_TrunkStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Trunk);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_TrunkStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Trunk);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_TrunkStatus::operator==(const cfc_vehiclefi_tclMsgMQB_TrunkStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Trunk == roRef.Trunk);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgSpeed_QualityUpReg::cfc_vehiclefi_tclMsgSpeed_QualityUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgSpeed_QualityUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEED_QUALITYUPREG;
}


cfc_vehiclefi_tclMsgSpeed_QualityUpReg::~cfc_vehiclefi_tclMsgSpeed_QualityUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg::cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEED_QUALITYRELUPREG;
}


cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg::~cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgSpeed_QualityGet::cfc_vehiclefi_tclMsgSpeed_QualityGet()
 {}

tS32 cfc_vehiclefi_tclMsgSpeed_QualityGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEED_QUALITYGET;
}


cfc_vehiclefi_tclMsgSpeed_QualityGet::~cfc_vehiclefi_tclMsgSpeed_QualityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgSpeed_QualityStatus::cfc_vehiclefi_tclMsgSpeed_QualityStatus(const cfc_vehiclefi_tclMsgSpeed_QualityStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Quality = coRef.Quality;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgSpeed_QualityStatus& cfc_vehiclefi_tclMsgSpeed_QualityStatus::operator=(const cfc_vehiclefi_tclMsgSpeed_QualityStatus& coRef)
{
   if (this == &coRef) return *this;
   Quality = coRef.Quality;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgSpeed_QualityStatus::cfc_vehiclefi_tclMsgSpeed_QualityStatus()
:Quality(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgSpeed_QualityStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEED_QUALITYSTATUS;
}


cfc_vehiclefi_tclMsgSpeed_QualityStatus::~cfc_vehiclefi_tclMsgSpeed_QualityStatus()
{}

tU32 cfc_vehiclefi_tclMsgSpeed_QualityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgSpeed_QualityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Quality);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgSpeed_QualityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Quality);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgSpeed_QualityStatus::operator==(const cfc_vehiclefi_tclMsgSpeed_QualityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Quality == roRef.Quality);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg::cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_LONGITUDINAL_ACCELERATIONUPREG;
}


cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg::~cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg::cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_LONGITUDINAL_ACCELERATIONRELUPREG;
}


cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg::~cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet::cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet()
 {}

tS32 cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_LONGITUDINAL_ACCELERATIONGET;
}


cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet::~cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus& cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::operator=(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_LONGITUDINAL_ACCELERATIONSTATUS;
}


cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::~cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus()
{}

tU32 cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus::operator==(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_GierrateUpReg::cfc_vehiclefi_tclMsgMQB_GierrateUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_GierrateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATEUPREG;
}


cfc_vehiclefi_tclMsgMQB_GierrateUpReg::~cfc_vehiclefi_tclMsgMQB_GierrateUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg::cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg::~cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_GierrateGet::cfc_vehiclefi_tclMsgMQB_GierrateGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_GierrateGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATEGET;
}


cfc_vehiclefi_tclMsgMQB_GierrateGet::~cfc_vehiclefi_tclMsgMQB_GierrateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_GierrateStatus::cfc_vehiclefi_tclMsgMQB_GierrateStatus(const cfc_vehiclefi_tclMsgMQB_GierrateStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_GierrateStatus& cfc_vehiclefi_tclMsgMQB_GierrateStatus::operator=(const cfc_vehiclefi_tclMsgMQB_GierrateStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_GierrateStatus::cfc_vehiclefi_tclMsgMQB_GierrateStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_GierrateStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATESTATUS;
}


cfc_vehiclefi_tclMsgMQB_GierrateStatus::~cfc_vehiclefi_tclMsgMQB_GierrateStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_GierrateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_GierrateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_GierrateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_GierrateStatus::operator==(const cfc_vehiclefi_tclMsgMQB_GierrateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg::cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATE_SIGNUPREG;
}


cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg::~cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg::cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATE_SIGNRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg::~cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet::cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATE_SIGNGET;
}


cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet::~cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Sign = coRef.Sign;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus& cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus& coRef)
{
   if (this == &coRef) return *this;
   Sign = coRef.Sign;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus()
:Sign(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_GIERRATE_SIGNSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::~cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Sign);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Sign);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Sign == roRef.Sign);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg::cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_MOTOR_LAEUFTUPREG;
}


cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg::~cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg::cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_MOTOR_LAEUFTRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg::~cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet::cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_MOTOR_LAEUFTGET;
}


cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet::~cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus& cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_MOTOR_LAEUFTSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::~cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgBrake_SwitchUpReg::cfc_vehiclefi_tclMsgBrake_SwitchUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrake_SwitchUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BRAKE_SWITCHUPREG;
}


cfc_vehiclefi_tclMsgBrake_SwitchUpReg::~cfc_vehiclefi_tclMsgBrake_SwitchUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg::cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BRAKE_SWITCHRELUPREG;
}


cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg::~cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrake_SwitchGet::cfc_vehiclefi_tclMsgBrake_SwitchGet()
 {}

tS32 cfc_vehiclefi_tclMsgBrake_SwitchGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BRAKE_SWITCHGET;
}


cfc_vehiclefi_tclMsgBrake_SwitchGet::~cfc_vehiclefi_tclMsgBrake_SwitchGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgBrake_SwitchStatus::cfc_vehiclefi_tclMsgBrake_SwitchStatus(const cfc_vehiclefi_tclMsgBrake_SwitchStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgBrake_SwitchStatus& cfc_vehiclefi_tclMsgBrake_SwitchStatus::operator=(const cfc_vehiclefi_tclMsgBrake_SwitchStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgBrake_SwitchStatus::cfc_vehiclefi_tclMsgBrake_SwitchStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgBrake_SwitchStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BRAKE_SWITCHSTATUS;
}


cfc_vehiclefi_tclMsgBrake_SwitchStatus::~cfc_vehiclefi_tclMsgBrake_SwitchStatus()
{}

tU32 cfc_vehiclefi_tclMsgBrake_SwitchStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBrake_SwitchStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBrake_SwitchStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgBrake_SwitchStatus::operator==(const cfc_vehiclefi_tclMsgBrake_SwitchStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgClutchUpReg::cfc_vehiclefi_tclMsgClutchUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgClutchUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CLUTCHUPREG;
}


cfc_vehiclefi_tclMsgClutchUpReg::~cfc_vehiclefi_tclMsgClutchUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgClutchRelUpReg::cfc_vehiclefi_tclMsgClutchRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgClutchRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CLUTCHRELUPREG;
}


cfc_vehiclefi_tclMsgClutchRelUpReg::~cfc_vehiclefi_tclMsgClutchRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgClutchGet::cfc_vehiclefi_tclMsgClutchGet()
 {}

tS32 cfc_vehiclefi_tclMsgClutchGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CLUTCHGET;
}


cfc_vehiclefi_tclMsgClutchGet::~cfc_vehiclefi_tclMsgClutchGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgClutchStatus::cfc_vehiclefi_tclMsgClutchStatus(const cfc_vehiclefi_tclMsgClutchStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgClutchStatus& cfc_vehiclefi_tclMsgClutchStatus::operator=(const cfc_vehiclefi_tclMsgClutchStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgClutchStatus::cfc_vehiclefi_tclMsgClutchStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgClutchStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CLUTCHSTATUS;
}


cfc_vehiclefi_tclMsgClutchStatus::~cfc_vehiclefi_tclMsgClutchStatus()
{}

tU32 cfc_vehiclefi_tclMsgClutchStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgClutchStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgClutchStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgClutchStatus::operator==(const cfc_vehiclefi_tclMsgClutchStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg::cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_KEY_CODEUPREG;
}


cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg::~cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg::cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_KEY_CODERELUPREG;
}


cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg::~cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_Key_CodeGet::cfc_vehiclefi_tclMsgMFL_Key_CodeGet()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_Key_CodeGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_KEY_CODEGET;
}


cfc_vehiclefi_tclMsgMFL_Key_CodeGet::~cfc_vehiclefi_tclMsgMFL_Key_CodeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::cfc_vehiclefi_tclMsgMFL_Key_CodeStatus(const cfc_vehiclefi_tclMsgMFL_Key_CodeStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   MFL_Tastencode_1 = coRef.MFL_Tastencode_1;
   MFL_Tastencode_2 = coRef.MFL_Tastencode_2;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMFL_Key_CodeStatus& cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::operator=(const cfc_vehiclefi_tclMsgMFL_Key_CodeStatus& coRef)
{
   if (this == &coRef) return *this;
   MFL_Tastencode_1 = coRef.MFL_Tastencode_1;
   MFL_Tastencode_2 = coRef.MFL_Tastencode_2;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::cfc_vehiclefi_tclMsgMFL_Key_CodeStatus()
:MFL_Tastencode_1()
,MFL_Tastencode_2()
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_KEY_CODESTATUS;
}


cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::~cfc_vehiclefi_tclMsgMFL_Key_CodeStatus()
{}

tU32 cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MFL_Tastencode_1);
   (tVoid) (oIn >> MFL_Tastencode_2);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MFL_Tastencode_1);
   (tVoid) (oOut << MFL_Tastencode_2);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMFL_Key_CodeStatus::operator==(const cfc_vehiclefi_tclMsgMFL_Key_CodeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MFL_Tastencode_1 == roRef.MFL_Tastencode_1);
   bResult = bResult && (MFL_Tastencode_2 == roRef.MFL_Tastencode_2);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg::cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_EVENT_CODEUPREG;
}


cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg::~cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg::cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_EVENT_CODERELUPREG;
}


cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg::~cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_Event_CodeGet::cfc_vehiclefi_tclMsgMFL_Event_CodeGet()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_Event_CodeGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_EVENT_CODEGET;
}


cfc_vehiclefi_tclMsgMFL_Event_CodeGet::~cfc_vehiclefi_tclMsgMFL_Event_CodeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::cfc_vehiclefi_tclMsgMFL_Event_CodeStatus(const cfc_vehiclefi_tclMsgMFL_Event_CodeStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   MFL_Eventcode_1 = coRef.MFL_Eventcode_1;
   MFL_Eventcode_2 = coRef.MFL_Eventcode_2;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMFL_Event_CodeStatus& cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::operator=(const cfc_vehiclefi_tclMsgMFL_Event_CodeStatus& coRef)
{
   if (this == &coRef) return *this;
   MFL_Eventcode_1 = coRef.MFL_Eventcode_1;
   MFL_Eventcode_2 = coRef.MFL_Eventcode_2;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::cfc_vehiclefi_tclMsgMFL_Event_CodeStatus()
:MFL_Eventcode_1()
,MFL_Eventcode_2()
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_EVENT_CODESTATUS;
}


cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::~cfc_vehiclefi_tclMsgMFL_Event_CodeStatus()
{}

tU32 cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MFL_Eventcode_1);
   (tVoid) (oIn >> MFL_Eventcode_2);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MFL_Eventcode_1);
   (tVoid) (oOut << MFL_Eventcode_2);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMFL_Event_CodeStatus::operator==(const cfc_vehiclefi_tclMsgMFL_Event_CodeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MFL_Eventcode_1 == roRef.MFL_Eventcode_1);
   bResult = bResult && (MFL_Eventcode_2 == roRef.MFL_Eventcode_2);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_TypeUpReg::cfc_vehiclefi_tclMsgMFL_TypeUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_TypeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_TYPEUPREG;
}


cfc_vehiclefi_tclMsgMFL_TypeUpReg::~cfc_vehiclefi_tclMsgMFL_TypeUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_TypeRelUpReg::cfc_vehiclefi_tclMsgMFL_TypeRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_TypeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_TYPERELUPREG;
}


cfc_vehiclefi_tclMsgMFL_TypeRelUpReg::~cfc_vehiclefi_tclMsgMFL_TypeRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMFL_TypeGet::cfc_vehiclefi_tclMsgMFL_TypeGet()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_TypeGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_TYPEGET;
}


cfc_vehiclefi_tclMsgMFL_TypeGet::~cfc_vehiclefi_tclMsgMFL_TypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMFL_TypeStatus::cfc_vehiclefi_tclMsgMFL_TypeStatus(const cfc_vehiclefi_tclMsgMFL_TypeStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   MFL_Marke = coRef.MFL_Marke;
   MFL_Variante = coRef.MFL_Variante;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMFL_TypeStatus& cfc_vehiclefi_tclMsgMFL_TypeStatus::operator=(const cfc_vehiclefi_tclMsgMFL_TypeStatus& coRef)
{
   if (this == &coRef) return *this;
   MFL_Marke = coRef.MFL_Marke;
   MFL_Variante = coRef.MFL_Variante;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMFL_TypeStatus::cfc_vehiclefi_tclMsgMFL_TypeStatus()
:MFL_Marke(0)
,MFL_Variante(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMFL_TypeStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MFL_TYPESTATUS;
}


cfc_vehiclefi_tclMsgMFL_TypeStatus::~cfc_vehiclefi_tclMsgMFL_TypeStatus()
{}

tU32 cfc_vehiclefi_tclMsgMFL_TypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMFL_TypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MFL_Marke);
   (tVoid) (oIn >> MFL_Variante);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMFL_TypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MFL_Marke);
   (tVoid) (oOut << MFL_Variante);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMFL_TypeStatus::operator==(const cfc_vehiclefi_tclMsgMFL_TypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MFL_Marke == roRef.MFL_Marke);
   bResult = bResult && (MFL_Variante == roRef.MFL_Variante);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgBatteryUpReg::cfc_vehiclefi_tclMsgBatteryUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBatteryUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BATTERYUPREG;
}


cfc_vehiclefi_tclMsgBatteryUpReg::~cfc_vehiclefi_tclMsgBatteryUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBatteryRelUpReg::cfc_vehiclefi_tclMsgBatteryRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBatteryRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BATTERYRELUPREG;
}


cfc_vehiclefi_tclMsgBatteryRelUpReg::~cfc_vehiclefi_tclMsgBatteryRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBatteryGet::cfc_vehiclefi_tclMsgBatteryGet()
 {}

tS32 cfc_vehiclefi_tclMsgBatteryGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BATTERYGET;
}


cfc_vehiclefi_tclMsgBatteryGet::~cfc_vehiclefi_tclMsgBatteryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgBatteryStatus::cfc_vehiclefi_tclMsgBatteryStatus(const cfc_vehiclefi_tclMsgBatteryStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Abschaltstufen = coRef.Abschaltstufen;
   MMI_Vorwarnung = coRef.MMI_Vorwarnung;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgBatteryStatus& cfc_vehiclefi_tclMsgBatteryStatus::operator=(const cfc_vehiclefi_tclMsgBatteryStatus& coRef)
{
   if (this == &coRef) return *this;
   Abschaltstufen = coRef.Abschaltstufen;
   MMI_Vorwarnung = coRef.MMI_Vorwarnung;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgBatteryStatus::cfc_vehiclefi_tclMsgBatteryStatus()
:Abschaltstufen(0)
,MMI_Vorwarnung(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgBatteryStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BATTERYSTATUS;
}


cfc_vehiclefi_tclMsgBatteryStatus::~cfc_vehiclefi_tclMsgBatteryStatus()
{}

tU32 cfc_vehiclefi_tclMsgBatteryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBatteryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abschaltstufen);
   (tVoid) (oIn >> MMI_Vorwarnung);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBatteryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abschaltstufen);
   (tVoid) (oOut << MMI_Vorwarnung);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgBatteryStatus::operator==(const cfc_vehiclefi_tclMsgBatteryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abschaltstufen == roRef.Abschaltstufen);
   bResult = bResult && (MMI_Vorwarnung == roRef.MMI_Vorwarnung);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg::cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_STROMSPARMODUSUPREG;
}


cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg::~cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg::cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_STROMSPARMODUSRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg::~cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_StromsparmodusGet::cfc_vehiclefi_tclMsgMQB_StromsparmodusGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_StromsparmodusGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_STROMSPARMODUSGET;
}


cfc_vehiclefi_tclMsgMQB_StromsparmodusGet::~cfc_vehiclefi_tclMsgMQB_StromsparmodusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus(const cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Stromsparmodus = coRef.Stromsparmodus;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus& cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::operator=(const cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus& coRef)
{
   if (this == &coRef) return *this;
   Stromsparmodus = coRef.Stromsparmodus;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus()
:Stromsparmodus(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_STROMSPARMODUSSTATUS;
}


cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::~cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Stromsparmodus);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Stromsparmodus);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus::operator==(const cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Stromsparmodus == roRef.Stromsparmodus);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgWheel_AngleUpReg::cfc_vehiclefi_tclMsgWheel_AngleUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgWheel_AngleUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLEUPREG;
}


cfc_vehiclefi_tclMsgWheel_AngleUpReg::~cfc_vehiclefi_tclMsgWheel_AngleUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgWheel_AngleRelUpReg::cfc_vehiclefi_tclMsgWheel_AngleRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgWheel_AngleRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLERELUPREG;
}


cfc_vehiclefi_tclMsgWheel_AngleRelUpReg::~cfc_vehiclefi_tclMsgWheel_AngleRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgWheel_AngleGet::cfc_vehiclefi_tclMsgWheel_AngleGet()
 {}

tS32 cfc_vehiclefi_tclMsgWheel_AngleGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLEGET;
}


cfc_vehiclefi_tclMsgWheel_AngleGet::~cfc_vehiclefi_tclMsgWheel_AngleGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgWheel_AngleStatus::cfc_vehiclefi_tclMsgWheel_AngleStatus(const cfc_vehiclefi_tclMsgWheel_AngleStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgWheel_AngleStatus& cfc_vehiclefi_tclMsgWheel_AngleStatus::operator=(const cfc_vehiclefi_tclMsgWheel_AngleStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgWheel_AngleStatus::cfc_vehiclefi_tclMsgWheel_AngleStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgWheel_AngleStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLESTATUS;
}


cfc_vehiclefi_tclMsgWheel_AngleStatus::~cfc_vehiclefi_tclMsgWheel_AngleStatus()
{}

tU32 cfc_vehiclefi_tclMsgWheel_AngleStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgWheel_AngleStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgWheel_AngleStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgWheel_AngleStatus::operator==(const cfc_vehiclefi_tclMsgWheel_AngleStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg::cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLE_SIGNUPREG;
}


cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg::~cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg::cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLE_SIGNRELUPREG;
}


cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg::~cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgWheel_Angle_SignGet::cfc_vehiclefi_tclMsgWheel_Angle_SignGet()
 {}

tS32 cfc_vehiclefi_tclMsgWheel_Angle_SignGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLE_SIGNGET;
}


cfc_vehiclefi_tclMsgWheel_Angle_SignGet::~cfc_vehiclefi_tclMsgWheel_Angle_SignGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::cfc_vehiclefi_tclMsgWheel_Angle_SignStatus(const cfc_vehiclefi_tclMsgWheel_Angle_SignStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Sign = coRef.Sign;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgWheel_Angle_SignStatus& cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::operator=(const cfc_vehiclefi_tclMsgWheel_Angle_SignStatus& coRef)
{
   if (this == &coRef) return *this;
   Sign = coRef.Sign;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::cfc_vehiclefi_tclMsgWheel_Angle_SignStatus()
:Sign(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_WHEEL_ANGLE_SIGNSTATUS;
}


cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::~cfc_vehiclefi_tclMsgWheel_Angle_SignStatus()
{}

tU32 cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Sign);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Sign);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgWheel_Angle_SignStatus::operator==(const cfc_vehiclefi_tclMsgWheel_Angle_SignStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Sign == roRef.Sign);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg::cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACOUSTIC_PARKINGSYSTEM_ACTIVITYUPREG;
}


cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg::~cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg::cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACOUSTIC_PARKINGSYSTEM_ACTIVITYRELUPREG;
}


cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg::~cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet::cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet()
 {}

tS32 cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACOUSTIC_PARKINGSYSTEM_ACTIVITYGET;
}


cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet::~cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus& cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::operator=(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACOUSTIC_PARKINGSYSTEM_ACTIVITYSTATUS;
}


cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::~cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus()
{}

tU32 cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus::operator==(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgNWDFUpReg::cfc_vehiclefi_tclMsgNWDFUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgNWDFUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_NWDFUPREG;
}


cfc_vehiclefi_tclMsgNWDFUpReg::~cfc_vehiclefi_tclMsgNWDFUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgNWDFRelUpReg::cfc_vehiclefi_tclMsgNWDFRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgNWDFRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_NWDFRELUPREG;
}


cfc_vehiclefi_tclMsgNWDFRelUpReg::~cfc_vehiclefi_tclMsgNWDFRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgNWDFGet::cfc_vehiclefi_tclMsgNWDFGet()
 {}

tS32 cfc_vehiclefi_tclMsgNWDFGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_NWDFGET;
}


cfc_vehiclefi_tclMsgNWDFGet::~cfc_vehiclefi_tclMsgNWDFGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgNWDFStatus::cfc_vehiclefi_tclMsgNWDFStatus(const cfc_vehiclefi_tclMsgNWDFStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgNWDFStatus& cfc_vehiclefi_tclMsgNWDFStatus::operator=(const cfc_vehiclefi_tclMsgNWDFStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgNWDFStatus::cfc_vehiclefi_tclMsgNWDFStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgNWDFStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_NWDFSTATUS;
}


cfc_vehiclefi_tclMsgNWDFStatus::~cfc_vehiclefi_tclMsgNWDFStatus()
{}

tU32 cfc_vehiclefi_tclMsgNWDFStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgNWDFStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgNWDFStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgNWDFStatus::operator==(const cfc_vehiclefi_tclMsgNWDFStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgQRS_ModeUpReg::cfc_vehiclefi_tclMsgQRS_ModeUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgQRS_ModeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_QRS_MODEUPREG;
}


cfc_vehiclefi_tclMsgQRS_ModeUpReg::~cfc_vehiclefi_tclMsgQRS_ModeUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgQRS_ModeRelUpReg::cfc_vehiclefi_tclMsgQRS_ModeRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgQRS_ModeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_QRS_MODERELUPREG;
}


cfc_vehiclefi_tclMsgQRS_ModeRelUpReg::~cfc_vehiclefi_tclMsgQRS_ModeRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgQRS_ModeGet::cfc_vehiclefi_tclMsgQRS_ModeGet()
 {}

tS32 cfc_vehiclefi_tclMsgQRS_ModeGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_QRS_MODEGET;
}


cfc_vehiclefi_tclMsgQRS_ModeGet::~cfc_vehiclefi_tclMsgQRS_ModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgQRS_ModeStatus::cfc_vehiclefi_tclMsgQRS_ModeStatus(const cfc_vehiclefi_tclMsgQRS_ModeStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgQRS_ModeStatus& cfc_vehiclefi_tclMsgQRS_ModeStatus::operator=(const cfc_vehiclefi_tclMsgQRS_ModeStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgQRS_ModeStatus::cfc_vehiclefi_tclMsgQRS_ModeStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgQRS_ModeStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_QRS_MODESTATUS;
}


cfc_vehiclefi_tclMsgQRS_ModeStatus::~cfc_vehiclefi_tclMsgQRS_ModeStatus()
{}

tU32 cfc_vehiclefi_tclMsgQRS_ModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgQRS_ModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgQRS_ModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgQRS_ModeStatus::operator==(const cfc_vehiclefi_tclMsgQRS_ModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg::cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ECO_CHARISMA_TASTEUPREG;
}


cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg::~cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg::cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ECO_CHARISMA_TASTERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg::~cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet::cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ECO_CHARISMA_TASTEGET;
}


cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet::~cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus& cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_ECO_CHARISMA_TASTESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::~cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg::cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_AMPLIFIER_MUTEUPREG;
}


cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg::~cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg::cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_AMPLIFIER_MUTERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg::~cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet::cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_AMPLIFIER_MUTEGET;
}


cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet::~cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus& cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus()
:State(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_AMPLIFIER_MUTESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::~cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_BlinkerUpReg::cfc_vehiclefi_tclMsgMQB_BlinkerUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_BlinkerUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BLINKERUPREG;
}


cfc_vehiclefi_tclMsgMQB_BlinkerUpReg::~cfc_vehiclefi_tclMsgMQB_BlinkerUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg::cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BLINKERRELUPREG;
}


cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg::~cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_BlinkerGet::cfc_vehiclefi_tclMsgMQB_BlinkerGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_BlinkerGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BLINKERGET;
}


cfc_vehiclefi_tclMsgMQB_BlinkerGet::~cfc_vehiclefi_tclMsgMQB_BlinkerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_BlinkerStatus::cfc_vehiclefi_tclMsgMQB_BlinkerStatus(const cfc_vehiclefi_tclMsgMQB_BlinkerStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Left_State = coRef.Left_State;
   Right_State = coRef.Right_State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_BlinkerStatus& cfc_vehiclefi_tclMsgMQB_BlinkerStatus::operator=(const cfc_vehiclefi_tclMsgMQB_BlinkerStatus& coRef)
{
   if (this == &coRef) return *this;
   Left_State = coRef.Left_State;
   Right_State = coRef.Right_State;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_BlinkerStatus::cfc_vehiclefi_tclMsgMQB_BlinkerStatus()
:Left_State(0)
,Right_State(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_BlinkerStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BLINKERSTATUS;
}


cfc_vehiclefi_tclMsgMQB_BlinkerStatus::~cfc_vehiclefi_tclMsgMQB_BlinkerStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_BlinkerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_BlinkerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Left_State);
   (tVoid) (oIn >> Right_State);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_BlinkerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Left_State);
   (tVoid) (oOut << Right_State);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_BlinkerStatus::operator==(const cfc_vehiclefi_tclMsgMQB_BlinkerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Left_State == roRef.Left_State);
   bResult = bResult && (Right_State == roRef.Right_State);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCAN_UnitUpReg::cfc_vehiclefi_tclMsgCAN_UnitUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCAN_UnitUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CAN_UNITUPREG;
}


cfc_vehiclefi_tclMsgCAN_UnitUpReg::~cfc_vehiclefi_tclMsgCAN_UnitUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCAN_UnitRelUpReg::cfc_vehiclefi_tclMsgCAN_UnitRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCAN_UnitRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CAN_UNITRELUPREG;
}


cfc_vehiclefi_tclMsgCAN_UnitRelUpReg::~cfc_vehiclefi_tclMsgCAN_UnitRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCAN_UnitGet::cfc_vehiclefi_tclMsgCAN_UnitGet()
 {}

tS32 cfc_vehiclefi_tclMsgCAN_UnitGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CAN_UNITGET;
}


cfc_vehiclefi_tclMsgCAN_UnitGet::~cfc_vehiclefi_tclMsgCAN_UnitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCAN_UnitStatus::cfc_vehiclefi_tclMsgCAN_UnitStatus(const cfc_vehiclefi_tclMsgCAN_UnitStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Date = coRef.Date;
   PQ_Distance = coRef.PQ_Distance;
   MQB_Pressure = coRef.MQB_Pressure;
   Temperature = coRef.Temperature;
   Hour = coRef.Hour;
   Consumption_Display = coRef.Consumption_Display;
   MQB_Speed = coRef.MQB_Speed;
   Volume = coRef.Volume;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCAN_UnitStatus& cfc_vehiclefi_tclMsgCAN_UnitStatus::operator=(const cfc_vehiclefi_tclMsgCAN_UnitStatus& coRef)
{
   if (this == &coRef) return *this;
   Date = coRef.Date;
   PQ_Distance = coRef.PQ_Distance;
   MQB_Pressure = coRef.MQB_Pressure;
   Temperature = coRef.Temperature;
   Hour = coRef.Hour;
   Consumption_Display = coRef.Consumption_Display;
   MQB_Speed = coRef.MQB_Speed;
   Volume = coRef.Volume;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCAN_UnitStatus::cfc_vehiclefi_tclMsgCAN_UnitStatus()
:Date(0)
,PQ_Distance(0)
,MQB_Pressure(0)
,Temperature(0)
,Hour(0)
,Consumption_Display(0)
,MQB_Speed(0)
,Volume(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCAN_UnitStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CAN_UNITSTATUS;
}


cfc_vehiclefi_tclMsgCAN_UnitStatus::~cfc_vehiclefi_tclMsgCAN_UnitStatus()
{}

tU32 cfc_vehiclefi_tclMsgCAN_UnitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCAN_UnitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Date);
   (tVoid) (oIn >> PQ_Distance);
   (tVoid) (oIn >> MQB_Pressure);
   (tVoid) (oIn >> Temperature);
   (tVoid) (oIn >> Hour);
   (tVoid) (oIn >> Consumption_Display);
   (tVoid) (oIn >> MQB_Speed);
   (tVoid) (oIn >> Volume);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCAN_UnitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Date);
   (tVoid) (oOut << PQ_Distance);
   (tVoid) (oOut << MQB_Pressure);
   (tVoid) (oOut << Temperature);
   (tVoid) (oOut << Hour);
   (tVoid) (oOut << Consumption_Display);
   (tVoid) (oOut << MQB_Speed);
   (tVoid) (oOut << Volume);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCAN_UnitStatus::operator==(const cfc_vehiclefi_tclMsgCAN_UnitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Date == roRef.Date);
   bResult = bResult && (PQ_Distance == roRef.PQ_Distance);
   bResult = bResult && (MQB_Pressure == roRef.MQB_Pressure);
   bResult = bResult && (Temperature == roRef.Temperature);
   bResult = bResult && (Hour == roRef.Hour);
   bResult = bResult && (Consumption_Display == roRef.Consumption_Display);
   bResult = bResult && (MQB_Speed == roRef.MQB_Speed);
   bResult = bResult && (Volume == roRef.Volume);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgLanguageUpReg::cfc_vehiclefi_tclMsgLanguageUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgLanguageUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_LANGUAGEUPREG;
}


cfc_vehiclefi_tclMsgLanguageUpReg::~cfc_vehiclefi_tclMsgLanguageUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgLanguageRelUpReg::cfc_vehiclefi_tclMsgLanguageRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgLanguageRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_LANGUAGERELUPREG;
}


cfc_vehiclefi_tclMsgLanguageRelUpReg::~cfc_vehiclefi_tclMsgLanguageRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgLanguageGet::cfc_vehiclefi_tclMsgLanguageGet()
 {}

tS32 cfc_vehiclefi_tclMsgLanguageGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_LANGUAGEGET;
}


cfc_vehiclefi_tclMsgLanguageGet::~cfc_vehiclefi_tclMsgLanguageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgLanguageStatus::cfc_vehiclefi_tclMsgLanguageStatus(const cfc_vehiclefi_tclMsgLanguageStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgLanguageStatus& cfc_vehiclefi_tclMsgLanguageStatus::operator=(const cfc_vehiclefi_tclMsgLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgLanguageStatus::cfc_vehiclefi_tclMsgLanguageStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgLanguageStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_LANGUAGESTATUS;
}


cfc_vehiclefi_tclMsgLanguageStatus::~cfc_vehiclefi_tclMsgLanguageStatus()
{}

tU32 cfc_vehiclefi_tclMsgLanguageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgLanguageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgLanguageStatus::operator==(const cfc_vehiclefi_tclMsgLanguageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMotor_RPMUpReg::cfc_vehiclefi_tclMsgMotor_RPMUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMotor_RPMUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MOTOR_RPMUPREG;
}


cfc_vehiclefi_tclMsgMotor_RPMUpReg::~cfc_vehiclefi_tclMsgMotor_RPMUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMotor_RPMRelUpReg::cfc_vehiclefi_tclMsgMotor_RPMRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMotor_RPMRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MOTOR_RPMRELUPREG;
}


cfc_vehiclefi_tclMsgMotor_RPMRelUpReg::~cfc_vehiclefi_tclMsgMotor_RPMRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMotor_RPMGet::cfc_vehiclefi_tclMsgMotor_RPMGet()
 {}

tS32 cfc_vehiclefi_tclMsgMotor_RPMGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MOTOR_RPMGET;
}


cfc_vehiclefi_tclMsgMotor_RPMGet::~cfc_vehiclefi_tclMsgMotor_RPMGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMotor_RPMStatus::cfc_vehiclefi_tclMsgMotor_RPMStatus(const cfc_vehiclefi_tclMsgMotor_RPMStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   RPM = coRef.RPM;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMotor_RPMStatus& cfc_vehiclefi_tclMsgMotor_RPMStatus::operator=(const cfc_vehiclefi_tclMsgMotor_RPMStatus& coRef)
{
   if (this == &coRef) return *this;
   RPM = coRef.RPM;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMotor_RPMStatus::cfc_vehiclefi_tclMsgMotor_RPMStatus()
:RPM(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMotor_RPMStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MOTOR_RPMSTATUS;
}


cfc_vehiclefi_tclMsgMotor_RPMStatus::~cfc_vehiclefi_tclMsgMotor_RPMStatus()
{}

tU32 cfc_vehiclefi_tclMsgMotor_RPMStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMotor_RPMStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RPM);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMotor_RPMStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RPM);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMotor_RPMStatus::operator==(const cfc_vehiclefi_tclMsgMotor_RPMStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RPM == roRef.RPM);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg::cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BRAKE_PRESSUREUPREG;
}


cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg::~cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg::cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BRAKE_PRESSURERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg::~cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Brake_PressureGet::cfc_vehiclefi_tclMsgMQB_Brake_PressureGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Brake_PressureGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BRAKE_PRESSUREGET;
}


cfc_vehiclefi_tclMsgMQB_Brake_PressureGet::~cfc_vehiclefi_tclMsgMQB_Brake_PressureGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus(const cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus& cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BRAKE_PRESSURESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::~cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg::cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_CURRENT_TORQUEUPREG;
}


cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg::~cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg::cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_CURRENT_TORQUERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg::~cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Current_TorqueGet::cfc_vehiclefi_tclMsgMQB_Current_TorqueGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Current_TorqueGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_CURRENT_TORQUEGET;
}


cfc_vehiclefi_tclMsgMQB_Current_TorqueGet::~cfc_vehiclefi_tclMsgMQB_Current_TorqueGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus(const cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus& cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_CURRENT_TORQUESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::~cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgAccelerator_PositionUpReg::cfc_vehiclefi_tclMsgAccelerator_PositionUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgAccelerator_PositionUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_POSITIONUPREG;
}


cfc_vehiclefi_tclMsgAccelerator_PositionUpReg::~cfc_vehiclefi_tclMsgAccelerator_PositionUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg::cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_POSITIONRELUPREG;
}


cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg::~cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgAccelerator_PositionGet::cfc_vehiclefi_tclMsgAccelerator_PositionGet()
 {}

tS32 cfc_vehiclefi_tclMsgAccelerator_PositionGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_POSITIONGET;
}


cfc_vehiclefi_tclMsgAccelerator_PositionGet::~cfc_vehiclefi_tclMsgAccelerator_PositionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgAccelerator_PositionStatus::cfc_vehiclefi_tclMsgAccelerator_PositionStatus(const cfc_vehiclefi_tclMsgAccelerator_PositionStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgAccelerator_PositionStatus& cfc_vehiclefi_tclMsgAccelerator_PositionStatus::operator=(const cfc_vehiclefi_tclMsgAccelerator_PositionStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgAccelerator_PositionStatus::cfc_vehiclefi_tclMsgAccelerator_PositionStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgAccelerator_PositionStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ACCELERATOR_POSITIONSTATUS;
}


cfc_vehiclefi_tclMsgAccelerator_PositionStatus::~cfc_vehiclefi_tclMsgAccelerator_PositionStatus()
{}

tU32 cfc_vehiclefi_tclMsgAccelerator_PositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgAccelerator_PositionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgAccelerator_PositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgAccelerator_PositionStatus::operator==(const cfc_vehiclefi_tclMsgAccelerator_PositionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg::cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_GEARBOX_OIL_TEMPERATUREUPREG;
}


cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg::~cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg::cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_GEARBOX_OIL_TEMPERATURERELUPREG;
}


cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg::~cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet::cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet()
 {}

tS32 cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_GEARBOX_OIL_TEMPERATUREGET;
}


cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet::~cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus& cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::operator=(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_GEARBOX_OIL_TEMPERATURESTATUS;
}


cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::~cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus()
{}

tU32 cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus::operator==(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg::cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_KLIMA_POWER_CONSUMPTIONUPREG;
}


cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg::~cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg::cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_KLIMA_POWER_CONSUMPTIONRELUPREG;
}


cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg::~cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgKlima_Power_consumptionGet::cfc_vehiclefi_tclMsgKlima_Power_consumptionGet()
 {}

tS32 cfc_vehiclefi_tclMsgKlima_Power_consumptionGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_KLIMA_POWER_CONSUMPTIONGET;
}


cfc_vehiclefi_tclMsgKlima_Power_consumptionGet::~cfc_vehiclefi_tclMsgKlima_Power_consumptionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus(const cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Power = coRef.Power;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus& cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::operator=(const cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus& coRef)
{
   if (this == &coRef) return *this;
   Power = coRef.Power;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus()
:Power(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_KLIMA_POWER_CONSUMPTIONSTATUS;
}


cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::~cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus()
{}

tU32 cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Power);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Power);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus::operator==(const cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Power == roRef.Power);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg::cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_FUELWARNING_SECONDARYUPREG;
}


cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg::~cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg::cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_FUELWARNING_SECONDARYRELUPREG;
}


cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg::~cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet::cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet()
 {}

tS32 cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_FUELWARNING_SECONDARYGET;
}


cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet::~cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Power = coRef.Power;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus& cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::operator=(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus& coRef)
{
   if (this == &coRef) return *this;
   Power = coRef.Power;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus()
:Power(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_FUELWARNING_SECONDARYSTATUS;
}


cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::~cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus()
{}

tU32 cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Power);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Power);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus::operator==(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Power == roRef.Power);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg::cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_BATTERY_VOLTAGEUPREG;
}


cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg::~cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg::cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_BATTERY_VOLTAGERELUPREG;
}


cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg::~cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet::cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_BATTERY_VOLTAGEGET;
}


cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet::~cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus& cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::operator=(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_BATTERY_VOLTAGESTATUS;
}


cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::~cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus()
{}

tU32 cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus::operator==(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg::cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_SWITCHESUPREG;
}


cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg::~cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg::cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_SWITCHESRELUPREG;
}


cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg::~cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet::cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet()
 {}

tS32 cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_SWITCHESGET;
}


cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet::~cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   IlluminationValue = coRef.IlluminationValue;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus& cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::operator=(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus& coRef)
{
   if (this == &coRef) return *this;
   IlluminationValue = coRef.IlluminationValue;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus()
:IlluminationValue(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ILLUMINATION_CAN_SWITCHESSTATUS;
}


cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::~cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus()
{}

tU32 cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IlluminationValue);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IlluminationValue);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus::operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IlluminationValue == roRef.IlluminationValue);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgEngine_StatusUpReg::cfc_vehiclefi_tclMsgEngine_StatusUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgEngine_StatusUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ENGINE_STATUSUPREG;
}


cfc_vehiclefi_tclMsgEngine_StatusUpReg::~cfc_vehiclefi_tclMsgEngine_StatusUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgEngine_StatusRelUpReg::cfc_vehiclefi_tclMsgEngine_StatusRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgEngine_StatusRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ENGINE_STATUSRELUPREG;
}


cfc_vehiclefi_tclMsgEngine_StatusRelUpReg::~cfc_vehiclefi_tclMsgEngine_StatusRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgEngine_StatusGet::cfc_vehiclefi_tclMsgEngine_StatusGet()
 {}

tS32 cfc_vehiclefi_tclMsgEngine_StatusGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ENGINE_STATUSGET;
}


cfc_vehiclefi_tclMsgEngine_StatusGet::~cfc_vehiclefi_tclMsgEngine_StatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgEngine_StatusStatus::cfc_vehiclefi_tclMsgEngine_StatusStatus(const cfc_vehiclefi_tclMsgEngine_StatusStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgEngine_StatusStatus& cfc_vehiclefi_tclMsgEngine_StatusStatus::operator=(const cfc_vehiclefi_tclMsgEngine_StatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgEngine_StatusStatus::cfc_vehiclefi_tclMsgEngine_StatusStatus()
:Status(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgEngine_StatusStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ENGINE_STATUSSTATUS;
}


cfc_vehiclefi_tclMsgEngine_StatusStatus::~cfc_vehiclefi_tclMsgEngine_StatusStatus()
{}

tU32 cfc_vehiclefi_tclMsgEngine_StatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgEngine_StatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgEngine_StatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgEngine_StatusStatus::operator==(const cfc_vehiclefi_tclMsgEngine_StatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg::cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BOOST_PRESSUREUPREG;
}


cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg::~cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg::cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BOOST_PRESSURERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg::~cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Boost_PressureGet::cfc_vehiclefi_tclMsgMQB_Boost_PressureGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Boost_PressureGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BOOST_PRESSUREGET;
}


cfc_vehiclefi_tclMsgMQB_Boost_PressureGet::~cfc_vehiclefi_tclMsgMQB_Boost_PressureGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus(const cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Absolute = coRef.Absolute;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus& cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus& coRef)
{
   if (this == &coRef) return *this;
   Absolute = coRef.Absolute;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus()
:Absolute(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_BOOST_PRESSURESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::~cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Absolute);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Absolute);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Absolute == roRef.Absolute);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg::cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_RELATIVE_BOOST_PRESSUREUPREG;
}


cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg::~cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg::cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_RELATIVE_BOOST_PRESSURERELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg::~cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet::cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_RELATIVE_BOOST_PRESSUREGET;
}


cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet::~cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Relative = coRef.Relative;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus& cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus& coRef)
{
   if (this == &coRef) return *this;
   Relative = coRef.Relative;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus()
:Relative(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_RELATIVE_BOOST_PRESSURESTATUS;
}


cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::~cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Relative);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Relative);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Relative == roRef.Relative);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgGear_InfoUpReg::cfc_vehiclefi_tclMsgGear_InfoUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgGear_InfoUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_GEAR_INFOUPREG;
}


cfc_vehiclefi_tclMsgGear_InfoUpReg::~cfc_vehiclefi_tclMsgGear_InfoUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgGear_InfoRelUpReg::cfc_vehiclefi_tclMsgGear_InfoRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgGear_InfoRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_GEAR_INFORELUPREG;
}


cfc_vehiclefi_tclMsgGear_InfoRelUpReg::~cfc_vehiclefi_tclMsgGear_InfoRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgGear_InfoGet::cfc_vehiclefi_tclMsgGear_InfoGet()
 {}

tS32 cfc_vehiclefi_tclMsgGear_InfoGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_GEAR_INFOGET;
}


cfc_vehiclefi_tclMsgGear_InfoGet::~cfc_vehiclefi_tclMsgGear_InfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgGear_InfoStatus::cfc_vehiclefi_tclMsgGear_InfoStatus(const cfc_vehiclefi_tclMsgGear_InfoStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Current = coRef.Current;
   Ideal = coRef.Ideal;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgGear_InfoStatus& cfc_vehiclefi_tclMsgGear_InfoStatus::operator=(const cfc_vehiclefi_tclMsgGear_InfoStatus& coRef)
{
   if (this == &coRef) return *this;
   Current = coRef.Current;
   Ideal = coRef.Ideal;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgGear_InfoStatus::cfc_vehiclefi_tclMsgGear_InfoStatus()
:Current(0)
,Ideal(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgGear_InfoStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_GEAR_INFOSTATUS;
}


cfc_vehiclefi_tclMsgGear_InfoStatus::~cfc_vehiclefi_tclMsgGear_InfoStatus()
{}

tU32 cfc_vehiclefi_tclMsgGear_InfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgGear_InfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Current);
   (tVoid) (oIn >> Ideal);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgGear_InfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Current);
   (tVoid) (oOut << Ideal);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgGear_InfoStatus::operator==(const cfc_vehiclefi_tclMsgGear_InfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Current == roRef.Current);
   bResult = bResult && (Ideal == roRef.Ideal);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg::cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SWITCH_SENSITIVITY_AVAILABLEUPREG;
}


cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg::~cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg::cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SWITCH_SENSITIVITY_AVAILABLERELUPREG;
}


cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg::~cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet::cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet()
 {}

tS32 cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SWITCH_SENSITIVITY_AVAILABLEGET;
}


cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet::~cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus& cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::operator=(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SWITCH_SENSITIVITY_AVAILABLESTATUS;
}


cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::~cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus()
{}

tU32 cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus::operator==(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgEngine_SpeedUpReg::cfc_vehiclefi_tclMsgEngine_SpeedUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgEngine_SpeedUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ENGINE_SPEEDUPREG;
}


cfc_vehiclefi_tclMsgEngine_SpeedUpReg::~cfc_vehiclefi_tclMsgEngine_SpeedUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg::cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ENGINE_SPEEDRELUPREG;
}


cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg::~cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgEngine_SpeedGet::cfc_vehiclefi_tclMsgEngine_SpeedGet()
 {}

tS32 cfc_vehiclefi_tclMsgEngine_SpeedGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ENGINE_SPEEDGET;
}


cfc_vehiclefi_tclMsgEngine_SpeedGet::~cfc_vehiclefi_tclMsgEngine_SpeedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgEngine_SpeedStatus::cfc_vehiclefi_tclMsgEngine_SpeedStatus(const cfc_vehiclefi_tclMsgEngine_SpeedStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgEngine_SpeedStatus& cfc_vehiclefi_tclMsgEngine_SpeedStatus::operator=(const cfc_vehiclefi_tclMsgEngine_SpeedStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgEngine_SpeedStatus::cfc_vehiclefi_tclMsgEngine_SpeedStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgEngine_SpeedStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_ENGINE_SPEEDSTATUS;
}


cfc_vehiclefi_tclMsgEngine_SpeedStatus::~cfc_vehiclefi_tclMsgEngine_SpeedStatus()
{}

tU32 cfc_vehiclefi_tclMsgEngine_SpeedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgEngine_SpeedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgEngine_SpeedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgEngine_SpeedStatus::operator==(const cfc_vehiclefi_tclMsgEngine_SpeedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg::cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_MEDIUM_TIRE_CIRCUMFERENCEUPREG;
}


cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg::~cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg::cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_MEDIUM_TIRE_CIRCUMFERENCERELUPREG;
}


cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg::~cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet::cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_MEDIUM_TIRE_CIRCUMFERENCEGET;
}


cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet::~cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus& cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::operator=(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_MEDIUM_TIRE_CIRCUMFERENCESTATUS;
}


cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::~cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus()
{}

tU32 cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus::operator==(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg::cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_OUTSIDE_TEMPERATUREUPREG;
}


cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg::~cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg::cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_OUTSIDE_TEMPERATURERELUPREG;
}


cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg::~cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet::cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_OUTSIDE_TEMPERATUREGET;
}


cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet::~cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus& cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::operator=(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_OUTSIDE_TEMPERATURESTATUS;
}


cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::~cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus()
{}

tU32 cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus::operator==(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgTacho_SpeedUpReg::cfc_vehiclefi_tclMsgTacho_SpeedUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgTacho_SpeedUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TACHO_SPEEDUPREG;
}


cfc_vehiclefi_tclMsgTacho_SpeedUpReg::~cfc_vehiclefi_tclMsgTacho_SpeedUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg::cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TACHO_SPEEDRELUPREG;
}


cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg::~cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgTacho_SpeedGet::cfc_vehiclefi_tclMsgTacho_SpeedGet()
 {}

tS32 cfc_vehiclefi_tclMsgTacho_SpeedGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TACHO_SPEEDGET;
}


cfc_vehiclefi_tclMsgTacho_SpeedGet::~cfc_vehiclefi_tclMsgTacho_SpeedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgTacho_SpeedStatus::cfc_vehiclefi_tclMsgTacho_SpeedStatus(const cfc_vehiclefi_tclMsgTacho_SpeedStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgTacho_SpeedStatus& cfc_vehiclefi_tclMsgTacho_SpeedStatus::operator=(const cfc_vehiclefi_tclMsgTacho_SpeedStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgTacho_SpeedStatus::cfc_vehiclefi_tclMsgTacho_SpeedStatus()
:Value(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgTacho_SpeedStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TACHO_SPEEDSTATUS;
}


cfc_vehiclefi_tclMsgTacho_SpeedStatus::~cfc_vehiclefi_tclMsgTacho_SpeedStatus()
{}

tU32 cfc_vehiclefi_tclMsgTacho_SpeedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgTacho_SpeedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgTacho_SpeedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgTacho_SpeedStatus::operator==(const cfc_vehiclefi_tclMsgTacho_SpeedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg::cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEED_IN_KOMBIUPREG;
}


cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg::~cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg::cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEED_IN_KOMBIRELUPREG;
}


cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg::~cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgSpeed_In_KombiGet::cfc_vehiclefi_tclMsgSpeed_In_KombiGet()
 {}

tS32 cfc_vehiclefi_tclMsgSpeed_In_KombiGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEED_IN_KOMBIGET;
}


cfc_vehiclefi_tclMsgSpeed_In_KombiGet::~cfc_vehiclefi_tclMsgSpeed_In_KombiGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::cfc_vehiclefi_tclMsgSpeed_In_KombiStatus(const cfc_vehiclefi_tclMsgSpeed_In_KombiStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
   Unit = coRef.Unit;
   Source = coRef.Source;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgSpeed_In_KombiStatus& cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::operator=(const cfc_vehiclefi_tclMsgSpeed_In_KombiStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   Unit = coRef.Unit;
   Source = coRef.Source;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::cfc_vehiclefi_tclMsgSpeed_In_KombiStatus()
:Value(0)
,Unit(0)
,Source(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_SPEED_IN_KOMBISTATUS;
}


cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::~cfc_vehiclefi_tclMsgSpeed_In_KombiStatus()
{}

tU32 cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> Unit);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   (tVoid) (oOut << Unit);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgSpeed_In_KombiStatus::operator==(const cfc_vehiclefi_tclMsgSpeed_In_KombiStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (Unit == roRef.Unit);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg::cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_CAR_TYPEUPREG;
}


cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg::~cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg::cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_CAR_TYPERELUPREG;
}


cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg::~cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgPQ_Car_TypeGet::cfc_vehiclefi_tclMsgPQ_Car_TypeGet()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Car_TypeGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_CAR_TYPEGET;
}


cfc_vehiclefi_tclMsgPQ_Car_TypeGet::~cfc_vehiclefi_tclMsgPQ_Car_TypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::cfc_vehiclefi_tclMsgPQ_Car_TypeStatus(const cfc_vehiclefi_tclMsgPQ_Car_TypeStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Klasse = coRef.Klasse;
   Marke = coRef.Marke;
   Derivation = coRef.Derivation;
   Generation = coRef.Generation;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgPQ_Car_TypeStatus& cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::operator=(const cfc_vehiclefi_tclMsgPQ_Car_TypeStatus& coRef)
{
   if (this == &coRef) return *this;
   Klasse = coRef.Klasse;
   Marke = coRef.Marke;
   Derivation = coRef.Derivation;
   Generation = coRef.Generation;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::cfc_vehiclefi_tclMsgPQ_Car_TypeStatus()
:Klasse(0)
,Marke(0)
,Derivation(0)
,Generation(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_PQ_CAR_TYPESTATUS;
}


cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::~cfc_vehiclefi_tclMsgPQ_Car_TypeStatus()
{}

tU32 cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Klasse);
   (tVoid) (oIn >> Marke);
   (tVoid) (oIn >> Derivation);
   (tVoid) (oIn >> Generation);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Klasse);
   (tVoid) (oOut << Marke);
   (tVoid) (oOut << Derivation);
   (tVoid) (oOut << Generation);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgPQ_Car_TypeStatus::operator==(const cfc_vehiclefi_tclMsgPQ_Car_TypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Klasse == roRef.Klasse);
   bResult = bResult && (Marke == roRef.Marke);
   bResult = bResult && (Derivation == roRef.Derivation);
   bResult = bResult && (Generation == roRef.Generation);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgVINUpReg::cfc_vehiclefi_tclMsgVINUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgVINUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VINUPREG;
}


cfc_vehiclefi_tclMsgVINUpReg::~cfc_vehiclefi_tclMsgVINUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgVINRelUpReg::cfc_vehiclefi_tclMsgVINRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgVINRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VINRELUPREG;
}


cfc_vehiclefi_tclMsgVINRelUpReg::~cfc_vehiclefi_tclMsgVINRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgVINGet::cfc_vehiclefi_tclMsgVINGet()
 {}

tS32 cfc_vehiclefi_tclMsgVINGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VINGET;
}


cfc_vehiclefi_tclMsgVINGet::~cfc_vehiclefi_tclMsgVINGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgVINStatus::cfc_vehiclefi_tclMsgVINStatus(const cfc_vehiclefi_tclMsgVINStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgVINStatus& cfc_vehiclefi_tclMsgVINStatus::operator=(const cfc_vehiclefi_tclMsgVINStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_vehiclefi_tclMsgVINStatus::vDestroy()
{
   Data.vDestroy();
   ViewOptions.vDestroy(); 
}

cfc_vehiclefi_tclMsgVINStatus::cfc_vehiclefi_tclMsgVINStatus()
:Data()
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgVINStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VINSTATUS;
}


cfc_vehiclefi_tclMsgVINStatus::~cfc_vehiclefi_tclMsgVINStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_vehiclefi_tclMsgVINStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+Data.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_vehiclefi_tclMsgVINStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgVINStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgVINStatus::operator==(const cfc_vehiclefi_tclMsgVINStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCountryUpReg::cfc_vehiclefi_tclMsgCountryUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCountryUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_COUNTRYUPREG;
}


cfc_vehiclefi_tclMsgCountryUpReg::~cfc_vehiclefi_tclMsgCountryUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCountryRelUpReg::cfc_vehiclefi_tclMsgCountryRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCountryRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_COUNTRYRELUPREG;
}


cfc_vehiclefi_tclMsgCountryRelUpReg::~cfc_vehiclefi_tclMsgCountryRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCountryGet::cfc_vehiclefi_tclMsgCountryGet()
 {}

tS32 cfc_vehiclefi_tclMsgCountryGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_COUNTRYGET;
}


cfc_vehiclefi_tclMsgCountryGet::~cfc_vehiclefi_tclMsgCountryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCountryStatus::cfc_vehiclefi_tclMsgCountryStatus(const cfc_vehiclefi_tclMsgCountryStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCountryStatus& cfc_vehiclefi_tclMsgCountryStatus::operator=(const cfc_vehiclefi_tclMsgCountryStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCountryStatus::cfc_vehiclefi_tclMsgCountryStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCountryStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_COUNTRYSTATUS;
}


cfc_vehiclefi_tclMsgCountryStatus::~cfc_vehiclefi_tclMsgCountryStatus()
{}

tU32 cfc_vehiclefi_tclMsgCountryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCountryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCountryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCountryStatus::operator==(const cfc_vehiclefi_tclMsgCountryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg::cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_KEY_INFOUPREG;
}


cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg::~cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg::cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_KEY_INFORELUPREG;
}


cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg::~cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMQB_Key_InfoGet::cfc_vehiclefi_tclMsgMQB_Key_InfoGet()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Key_InfoGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_KEY_INFOGET;
}


cfc_vehiclefi_tclMsgMQB_Key_InfoGet::~cfc_vehiclefi_tclMsgMQB_Key_InfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::cfc_vehiclefi_tclMsgMQB_Key_InfoStatus(const cfc_vehiclefi_tclMsgMQB_Key_InfoStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Recommended_Position = coRef.Recommended_Position;
   Current_Position = coRef.Current_Position;
   Key_Number = coRef.Key_Number;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgMQB_Key_InfoStatus& cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::operator=(const cfc_vehiclefi_tclMsgMQB_Key_InfoStatus& coRef)
{
   if (this == &coRef) return *this;
   Recommended_Position = coRef.Recommended_Position;
   Current_Position = coRef.Current_Position;
   Key_Number = coRef.Key_Number;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::cfc_vehiclefi_tclMsgMQB_Key_InfoStatus()
:Recommended_Position(0)
,Current_Position(0)
,Key_Number(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MQB_KEY_INFOSTATUS;
}


cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::~cfc_vehiclefi_tclMsgMQB_Key_InfoStatus()
{}

tU32 cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Recommended_Position);
   (tVoid) (oIn >> Current_Position);
   (tVoid) (oIn >> Key_Number);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Recommended_Position);
   (tVoid) (oOut << Current_Position);
   (tVoid) (oOut << Key_Number);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMQB_Key_InfoStatus::operator==(const cfc_vehiclefi_tclMsgMQB_Key_InfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Recommended_Position == roRef.Recommended_Position);
   bResult = bResult && (Current_Position == roRef.Current_Position);
   bResult = bResult && (Key_Number == roRef.Key_Number);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgUser_ProfileUpReg::cfc_vehiclefi_tclMsgUser_ProfileUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgUser_ProfileUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_USER_PROFILEUPREG;
}


cfc_vehiclefi_tclMsgUser_ProfileUpReg::~cfc_vehiclefi_tclMsgUser_ProfileUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgUser_ProfileRelUpReg::cfc_vehiclefi_tclMsgUser_ProfileRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgUser_ProfileRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_USER_PROFILERELUPREG;
}


cfc_vehiclefi_tclMsgUser_ProfileRelUpReg::~cfc_vehiclefi_tclMsgUser_ProfileRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgUser_ProfileGet::cfc_vehiclefi_tclMsgUser_ProfileGet()
 {}

tS32 cfc_vehiclefi_tclMsgUser_ProfileGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_USER_PROFILEGET;
}


cfc_vehiclefi_tclMsgUser_ProfileGet::~cfc_vehiclefi_tclMsgUser_ProfileGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgUser_ProfileStatus::cfc_vehiclefi_tclMsgUser_ProfileStatus(const cfc_vehiclefi_tclMsgUser_ProfileStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   User_Number = coRef.User_Number;
   User_Control_Item = coRef.User_Control_Item;
   User_Control_Item_Parameter = coRef.User_Control_Item_Parameter;
   User_Status = coRef.User_Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgUser_ProfileStatus& cfc_vehiclefi_tclMsgUser_ProfileStatus::operator=(const cfc_vehiclefi_tclMsgUser_ProfileStatus& coRef)
{
   if (this == &coRef) return *this;
   User_Number = coRef.User_Number;
   User_Control_Item = coRef.User_Control_Item;
   User_Control_Item_Parameter = coRef.User_Control_Item_Parameter;
   User_Status = coRef.User_Status;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgUser_ProfileStatus::cfc_vehiclefi_tclMsgUser_ProfileStatus()
:User_Number(0)
,User_Control_Item(0)
,User_Control_Item_Parameter(0)
,User_Status(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgUser_ProfileStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_USER_PROFILESTATUS;
}


cfc_vehiclefi_tclMsgUser_ProfileStatus::~cfc_vehiclefi_tclMsgUser_ProfileStatus()
{}

tU32 cfc_vehiclefi_tclMsgUser_ProfileStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& cfc_vehiclefi_tclMsgUser_ProfileStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> User_Number);
   (tVoid) (oIn >> User_Control_Item);
   (tVoid) (oIn >> User_Control_Item_Parameter);
   (tVoid) (oIn >> User_Status);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgUser_ProfileStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << User_Number);
   (tVoid) (oOut << User_Control_Item);
   (tVoid) (oOut << User_Control_Item_Parameter);
   (tVoid) (oOut << User_Status);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgUser_ProfileStatus::operator==(const cfc_vehiclefi_tclMsgUser_ProfileStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (User_Number == roRef.User_Number);
   bResult = bResult && (User_Control_Item == roRef.User_Control_Item);
   bResult = bResult && (User_Control_Item_Parameter == roRef.User_Control_Item_Parameter);
   bResult = bResult && (User_Status == roRef.User_Status);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgTransmission_TypeUpReg::cfc_vehiclefi_tclMsgTransmission_TypeUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgTransmission_TypeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TRANSMISSION_TYPEUPREG;
}


cfc_vehiclefi_tclMsgTransmission_TypeUpReg::~cfc_vehiclefi_tclMsgTransmission_TypeUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg::cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TRANSMISSION_TYPERELUPREG;
}


cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg::~cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgTransmission_TypeGet::cfc_vehiclefi_tclMsgTransmission_TypeGet()
 {}

tS32 cfc_vehiclefi_tclMsgTransmission_TypeGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TRANSMISSION_TYPEGET;
}


cfc_vehiclefi_tclMsgTransmission_TypeGet::~cfc_vehiclefi_tclMsgTransmission_TypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgTransmission_TypeStatus::cfc_vehiclefi_tclMsgTransmission_TypeStatus(const cfc_vehiclefi_tclMsgTransmission_TypeStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgTransmission_TypeStatus& cfc_vehiclefi_tclMsgTransmission_TypeStatus::operator=(const cfc_vehiclefi_tclMsgTransmission_TypeStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgTransmission_TypeStatus::cfc_vehiclefi_tclMsgTransmission_TypeStatus()
:Data(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgTransmission_TypeStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TRANSMISSION_TYPESTATUS;
}


cfc_vehiclefi_tclMsgTransmission_TypeStatus::~cfc_vehiclefi_tclMsgTransmission_TypeStatus()
{}

tU32 cfc_vehiclefi_tclMsgTransmission_TypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cfc_vehiclefi_tclMsgTransmission_TypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgTransmission_TypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgTransmission_TypeStatus::operator==(const cfc_vehiclefi_tclMsgTransmission_TypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgVariantUpReg::cfc_vehiclefi_tclMsgVariantUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgVariantUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VARIANTUPREG;
}


cfc_vehiclefi_tclMsgVariantUpReg::~cfc_vehiclefi_tclMsgVariantUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgVariantRelUpReg::cfc_vehiclefi_tclMsgVariantRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgVariantRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VARIANTRELUPREG;
}


cfc_vehiclefi_tclMsgVariantRelUpReg::~cfc_vehiclefi_tclMsgVariantRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgVariantGet::cfc_vehiclefi_tclMsgVariantGet()
 {}

tS32 cfc_vehiclefi_tclMsgVariantGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VARIANTGET;
}


cfc_vehiclefi_tclMsgVariantGet::~cfc_vehiclefi_tclMsgVariantGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgVariantStatus::cfc_vehiclefi_tclMsgVariantStatus(const cfc_vehiclefi_tclMsgVariantStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgVariantStatus& cfc_vehiclefi_tclMsgVariantStatus::operator=(const cfc_vehiclefi_tclMsgVariantStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgVariantStatus::cfc_vehiclefi_tclMsgVariantStatus()
:Data(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgVariantStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VARIANTSTATUS;
}


cfc_vehiclefi_tclMsgVariantStatus::~cfc_vehiclefi_tclMsgVariantStatus()
{}

tU32 cfc_vehiclefi_tclMsgVariantStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cfc_vehiclefi_tclMsgVariantStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgVariantStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgVariantStatus::operator==(const cfc_vehiclefi_tclMsgVariantStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg::cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_COASTING_ISACTIVEUPREG;
}


cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg::~cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg::cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_COASTING_ISACTIVERELUPREG;
}


cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg::~cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCoasting_IsActiveGet::cfc_vehiclefi_tclMsgCoasting_IsActiveGet()
 {}

tS32 cfc_vehiclefi_tclMsgCoasting_IsActiveGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_COASTING_ISACTIVEGET;
}


cfc_vehiclefi_tclMsgCoasting_IsActiveGet::~cfc_vehiclefi_tclMsgCoasting_IsActiveGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::cfc_vehiclefi_tclMsgCoasting_IsActiveStatus(const cfc_vehiclefi_tclMsgCoasting_IsActiveStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCoasting_IsActiveStatus& cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::operator=(const cfc_vehiclefi_tclMsgCoasting_IsActiveStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::cfc_vehiclefi_tclMsgCoasting_IsActiveStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_COASTING_ISACTIVESTATUS;
}


cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::~cfc_vehiclefi_tclMsgCoasting_IsActiveStatus()
{}

tU32 cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCoasting_IsActiveStatus::operator==(const cfc_vehiclefi_tclMsgCoasting_IsActiveStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg::cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_OUTPUT_POWERUPREG;
}


cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg::~cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg::cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_OUTPUT_POWERRELUPREG;
}


cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg::~cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCurrent_Output_PowerGet::cfc_vehiclefi_tclMsgCurrent_Output_PowerGet()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_Output_PowerGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_OUTPUT_POWERGET;
}


cfc_vehiclefi_tclMsgCurrent_Output_PowerGet::~cfc_vehiclefi_tclMsgCurrent_Output_PowerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus(const cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
}
cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus& cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::operator=(const cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   SignalState = coRef.SignalState;
   ViewOptions = coRef.ViewOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus()
:Data(0)
,SignalState(0)
,ViewOptions()
 {}

tS32 cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CURRENT_OUTPUT_POWERSTATUS;
}


cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::~cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus()
{}

tU32 cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   (tVoid) (oIn >> SignalState);
   (tVoid) (oIn >> ViewOptions);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   (tVoid) (oOut << SignalState);
   (tVoid) (oOut << ViewOptions);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus::operator==(const cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   bResult = bResult && (SignalState == roRef.SignalState);
   bResult = bResult && (ViewOptions == roRef.ViewOptions);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgVehicleStandStillUpReg::cfc_vehiclefi_tclMsgVehicleStandStillUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgVehicleStandStillUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VEHICLESTANDSTILLUPREG;
}


cfc_vehiclefi_tclMsgVehicleStandStillUpReg::~cfc_vehiclefi_tclMsgVehicleStandStillUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg::cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VEHICLESTANDSTILLRELUPREG;
}


cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg::~cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgVehicleStandStillGet::cfc_vehiclefi_tclMsgVehicleStandStillGet()
 {}

tS32 cfc_vehiclefi_tclMsgVehicleStandStillGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VEHICLESTANDSTILLGET;
}


cfc_vehiclefi_tclMsgVehicleStandStillGet::~cfc_vehiclefi_tclMsgVehicleStandStillGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgVehicleStandStillStatus::cfc_vehiclefi_tclMsgVehicleStandStillStatus(const cfc_vehiclefi_tclMsgVehicleStandStillStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Data = coRef.Data;
}
cfc_vehiclefi_tclMsgVehicleStandStillStatus& cfc_vehiclefi_tclMsgVehicleStandStillStatus::operator=(const cfc_vehiclefi_tclMsgVehicleStandStillStatus& coRef)
{
   if (this == &coRef) return *this;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgVehicleStandStillStatus::cfc_vehiclefi_tclMsgVehicleStandStillStatus()
:Data(0)
 {}

tS32 cfc_vehiclefi_tclMsgVehicleStandStillStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_VEHICLESTANDSTILLSTATUS;
}


cfc_vehiclefi_tclMsgVehicleStandStillStatus::~cfc_vehiclefi_tclMsgVehicleStandStillStatus()
{}

tU32 cfc_vehiclefi_tclMsgVehicleStandStillStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgVehicleStandStillStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Data);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgVehicleStandStillStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Data);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgVehicleStandStillStatus::operator==(const cfc_vehiclefi_tclMsgVehicleStandStillStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Data == roRef.Data);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TV_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TV_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgTV_VelocityThresholdGet::cfc_vehiclefi_tclMsgTV_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgTV_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TV_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgTV_VelocityThresholdGet::~cfc_vehiclefi_tclMsgTV_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus& cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_TV_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CAR_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CAR_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgCar_VelocityThresholdGet::cfc_vehiclefi_tclMsgCar_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgCar_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CAR_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgCar_VelocityThresholdGet::~cfc_vehiclefi_tclMsgCar_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus& cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_CAR_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_HDD_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_HDD_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet::cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_HDD_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet::~cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus& cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_HDD_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERSLIDES_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERSLIDES_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet::cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERSLIDES_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet::~cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus& cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERSLIDES_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERBORDBOOK_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERBORDBOOK_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet::cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERBORDBOOK_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet::~cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus& cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERBORDBOOK_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERTRAVELAGENT_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERTRAVELAGENT_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet::cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERTRAVELAGENT_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet::~cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus& cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERTRAVELAGENT_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERWEB_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERWEB_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet::cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERWEB_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet::~cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus& cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BROWSERWEB_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BWS_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BWS_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet::cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BWS_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet::~cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus& cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BWS_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_RADIOTEXT_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_RADIOTEXT_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet::cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_RADIOTEXT_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet::~cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus& cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_RADIOTEXT_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BTBONDING_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BTBONDING_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet::cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BTBONDING_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet::~cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus& cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_BTBONDING_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_DESTINATIONINPUT_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_DESTINATIONINPUT_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet::cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_DESTINATIONINPUT_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet::~cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus& cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_DESTINATIONINPUT_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

//=============================================================================

cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg::cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MESSAGING_VELOCITYTHRESHOLDUPREG;
}


cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg::~cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg::cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg()
 {}

tS32 cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MESSAGING_VELOCITYTHRESHOLDRELUPREG;
}


cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg::~cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg()
{}

//=============================================================================

cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet::cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet()
 {}

tS32 cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MESSAGING_VELOCITYTHRESHOLDGET;
}


cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet::~cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus& coRef)
   : cfc_vehiclefi_tclMsgBaseMessage(coRef)
{
   Exceeded = coRef.Exceeded;
}
cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus& cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::operator=(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus& coRef)
{
   if (this == &coRef) return *this;
   Exceeded = coRef.Exceeded;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus()
:Exceeded(0)
 {}

tS32 cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::s32GetTypeId() const
{
   return (tS32) cfc_vehiclefi_tclToken::EN_MSG_MESSAGING_VELOCITYTHRESHOLDSTATUS;
}


cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::~cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus()
{}

tU32 cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Exceeded);
   return oIn;
}

fi_tclOutContext& cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Exceeded);
   return oOut;
}

tBool cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus::operator==(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Exceeded == roRef.Exceeded);
   return bResult;
}

