/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CFC_SPMFITYPES_HEADER
#define CFC_SPMFITYPES_HEADER


class cfc_spmfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for CFC_SPM_FI message types

fi_tclMessageBase* cfc_spmfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class cfc_spmfi_tclMsgBaseMessage : public cfc_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   cfc_spmfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class cfc_spmfi_tclMsgSystemModeMethodStart : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSystemModeMethodStart& operator=(const cfc_spmfi_tclMsgSystemModeMethodStart& coRef);
   cfc_spmfi_tclMsgSystemModeMethodStart(const cfc_spmfi_tclMsgSystemModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_e8_StateModes eSystemMode;
   virtual ~cfc_spmfi_tclMsgSystemModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSystemModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemModeMethodResult : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSystemModeMethodResult& operator=(const cfc_spmfi_tclMsgSystemModeMethodResult& coRef);
   cfc_spmfi_tclMsgSystemModeMethodResult(const cfc_spmfi_tclMsgSystemModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~cfc_spmfi_tclMsgSystemModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSystemModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStartProcessMethodStart : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStartProcessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgStartProcessMethodStart& operator=(const cfc_spmfi_tclMsgStartProcessMethodStart& coRef);
   cfc_spmfi_tclMsgStartProcessMethodStart(const cfc_spmfi_tclMsgStartProcessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclString strLocation;
   tU32 u32Prio;
   tU32 u32Affinity;
   tU32 u32AffinityEnd;
   tU32 u32NiceLevel;
   tU32 u32NiceLevelEnd;
   cfc_fi_tcl_SPM_e32_START_PROC_TYPE u32Type;
   tU32 u32Info;
   virtual ~cfc_spmfi_tclMsgStartProcessMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgStartProcessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStartProcessMethodResult : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStartProcessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgStartProcessMethodResult& operator=(const cfc_spmfi_tclMsgStartProcessMethodResult& coRef);
   cfc_spmfi_tclMsgStartProcessMethodResult(const cfc_spmfi_tclMsgStartProcessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   cfc_fi_tclString strLocation;
   tU32 u32ProcId;
   tU32 u32SpawnDuration;
   virtual ~cfc_spmfi_tclMsgStartProcessMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgStartProcessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEntertainDeMuteMethodStart : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEntertainDeMuteMethodStart();

   virtual ~cfc_spmfi_tclMsgEntertainDeMuteMethodStart();

   inline tBool operator==(const cfc_spmfi_tclMsgEntertainDeMuteMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEntertainDeMuteMethodResult : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEntertainDeMuteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgEntertainDeMuteMethodResult& operator=(const cfc_spmfi_tclMsgEntertainDeMuteMethodResult& coRef);
   cfc_spmfi_tclMsgEntertainDeMuteMethodResult(const cfc_spmfi_tclMsgEntertainDeMuteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~cfc_spmfi_tclMsgEntertainDeMuteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgEntertainDeMuteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgAudioSourceChangeMethodStart : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgAudioSourceChangeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgAudioSourceChangeMethodStart& operator=(const cfc_spmfi_tclMsgAudioSourceChangeMethodStart& coRef);
   cfc_spmfi_tclMsgAudioSourceChangeMethodStart(const cfc_spmfi_tclMsgAudioSourceChangeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_AUDIO_SOURCE eAudioSrc;
   virtual ~cfc_spmfi_tclMsgAudioSourceChangeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgAudioSourceChangeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgAudioSourceChangeMethodResult : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgAudioSourceChangeMethodResult();

   virtual ~cfc_spmfi_tclMsgAudioSourceChangeMethodResult();

   inline tBool operator==(const cfc_spmfi_tclMsgAudioSourceChangeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFactorySettingMethodStart : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFactorySettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgFactorySettingMethodStart& operator=(const cfc_spmfi_tclMsgFactorySettingMethodStart& coRef);
   cfc_spmfi_tclMsgFactorySettingMethodStart(const cfc_spmfi_tclMsgFactorySettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   cfc_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~cfc_spmfi_tclMsgFactorySettingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgFactorySettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFactorySettingMethodResult : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFactorySettingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgFactorySettingMethodResult& operator=(const cfc_spmfi_tclMsgFactorySettingMethodResult& coRef);
   cfc_spmfi_tclMsgFactorySettingMethodResult(const cfc_spmfi_tclMsgFactorySettingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   cfc_fi_tcl_e8_DefSetServiceStatus DefSetServiceStatus;
   virtual ~cfc_spmfi_tclMsgFactorySettingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgFactorySettingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDiagConfigurationMethodStart : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDiagConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDiagConfigurationMethodStart& operator=(const cfc_spmfi_tclMsgDiagConfigurationMethodStart& coRef);
   cfc_spmfi_tclMsgDiagConfigurationMethodStart(const cfc_spmfi_tclMsgDiagConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   cfc_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~cfc_spmfi_tclMsgDiagConfigurationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDiagConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDiagConfigurationMethodResult : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDiagConfigurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDiagConfigurationMethodResult& operator=(const cfc_spmfi_tclMsgDiagConfigurationMethodResult& coRef);
   cfc_spmfi_tclMsgDiagConfigurationMethodResult(const cfc_spmfi_tclMsgDiagConfigurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   cfc_fi_tcl_e8_DefSetServiceStatus DefSetServiceStatus;
   virtual ~cfc_spmfi_tclMsgDiagConfigurationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDiagConfigurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPerformTestMethodStart : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPerformTestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPerformTestMethodStart& operator=(const cfc_spmfi_tclMsgPerformTestMethodStart& coRef);
   cfc_spmfi_tclMsgPerformTestMethodStart(const cfc_spmfi_tclMsgPerformTestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_TestRoutineParameterList TestRoutineParameterList;
   virtual ~cfc_spmfi_tclMsgPerformTestMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPerformTestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPerformTestMethodResult : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPerformTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPerformTestMethodResult& operator=(const cfc_spmfi_tclMsgPerformTestMethodResult& coRef);
   cfc_spmfi_tclMsgPerformTestMethodResult(const cfc_spmfi_tclMsgPerformTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_TestResultList TestResultList;
   virtual ~cfc_spmfi_tclMsgPerformTestMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPerformTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemStateUpReg();

   virtual ~cfc_spmfi_tclMsgSystemStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSystemStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgSystemStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSystemStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemStateGet();

   virtual ~cfc_spmfi_tclMsgSystemStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSystemStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSystemStateStatus& operator=(const cfc_spmfi_tclMsgSystemStateStatus& coRef);
   cfc_spmfi_tclMsgSystemStateStatus(const cfc_spmfi_tclMsgSystemStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_SYSTEM_STATES SystemState;
   virtual ~cfc_spmfi_tclMsgSystemStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSystemStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnOffReasonSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnOffReasonSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgOnOffReasonSet& operator=(const cfc_spmfi_tclMsgOnOffReasonSet& coRef);
   cfc_spmfi_tclMsgOnOffReasonSet(const cfc_spmfi_tclMsgOnOffReasonSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_OnOffReason OnOffReason;
   virtual ~cfc_spmfi_tclMsgOnOffReasonSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgOnOffReasonSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnOffReasonGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnOffReasonGet();

   virtual ~cfc_spmfi_tclMsgOnOffReasonGet();

   inline tBool operator==(const cfc_spmfi_tclMsgOnOffReasonGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnOffReasonStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnOffReasonStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgOnOffReasonStatus& operator=(const cfc_spmfi_tclMsgOnOffReasonStatus& coRef);
   cfc_spmfi_tclMsgOnOffReasonStatus(const cfc_spmfi_tclMsgOnOffReasonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_OnOffReason OnOffReason;
   virtual ~cfc_spmfi_tclMsgOnOffReasonStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgOnOffReasonStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnOffReasonUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnOffReasonUpReg();

   virtual ~cfc_spmfi_tclMsgOnOffReasonUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgOnOffReasonUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnOffReasonRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnOffReasonRelUpReg();

   virtual ~cfc_spmfi_tclMsgOnOffReasonRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgOnOffReasonRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSubStatesSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSubStatesSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSubStatesSet& operator=(const cfc_spmfi_tclMsgSubStatesSet& coRef);
   cfc_spmfi_tclMsgSubStatesSet(const cfc_spmfi_tclMsgSubStatesSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_SubStateType SubStateType;
   tBool SubStateData;
   virtual ~cfc_spmfi_tclMsgSubStatesSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSubStatesSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSubStatesGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSubStatesGet();

   virtual ~cfc_spmfi_tclMsgSubStatesGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSubStatesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSubStatesStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSubStatesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSubStatesStatus& operator=(const cfc_spmfi_tclMsgSubStatesStatus& coRef);
   cfc_spmfi_tclMsgSubStatesStatus(const cfc_spmfi_tclMsgSubStatesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SubState;
   tU32 HwSubState;
   tU32 InternSubState;
   virtual ~cfc_spmfi_tclMsgSubStatesStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSubStatesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSubStatesUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSubStatesUpReg();

   virtual ~cfc_spmfi_tclMsgSubStatesUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSubStatesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSubStatesRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSubStatesRelUpReg();

   virtual ~cfc_spmfi_tclMsgSubStatesRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSubStatesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStartupStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStartupStateUpReg();

   virtual ~cfc_spmfi_tclMsgStartupStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgStartupStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStartupStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStartupStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgStartupStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgStartupStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStartupStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStartupStateGet();

   virtual ~cfc_spmfi_tclMsgStartupStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgStartupStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStartupStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStartupStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgStartupStateStatus& operator=(const cfc_spmfi_tclMsgStartupStateStatus& coRef);
   cfc_spmfi_tclMsgStartupStateStatus(const cfc_spmfi_tclMsgStartupStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_STARTUP_STATE StartupState;
   virtual ~cfc_spmfi_tclMsgStartupStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgStartupStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgProcessListUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgProcessListUpReg();

   virtual ~cfc_spmfi_tclMsgProcessListUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgProcessListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgProcessListRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgProcessListRelUpReg();

   virtual ~cfc_spmfi_tclMsgProcessListRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgProcessListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgProcessListGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgProcessListGet();

   virtual ~cfc_spmfi_tclMsgProcessListGet();

   inline tBool operator==(const cfc_spmfi_tclMsgProcessListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgProcessListStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgProcessListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgProcessListStatus& operator=(const cfc_spmfi_tclMsgProcessListStatus& coRef);
   cfc_spmfi_tclMsgProcessListStatus(const cfc_spmfi_tclMsgProcessListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_ProcessInfo tProcesses;
   virtual ~cfc_spmfi_tclMsgProcessListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgProcessListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgWakeupReasonGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgWakeupReasonGet();

   virtual ~cfc_spmfi_tclMsgWakeupReasonGet();

   inline tBool operator==(const cfc_spmfi_tclMsgWakeupReasonGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgWakeupReasonStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgWakeupReasonStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgWakeupReasonStatus& operator=(const cfc_spmfi_tclMsgWakeupReasonStatus& coRef);
   cfc_spmfi_tclMsgWakeupReasonStatus(const cfc_spmfi_tclMsgWakeupReasonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_WAKEUP_REASON WakeupReason;
   virtual ~cfc_spmfi_tclMsgWakeupReasonStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgWakeupReasonStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStartupReasonGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStartupReasonGet();

   virtual ~cfc_spmfi_tclMsgStartupReasonGet();

   inline tBool operator==(const cfc_spmfi_tclMsgStartupReasonGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStartupReasonStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStartupReasonStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgStartupReasonStatus& operator=(const cfc_spmfi_tclMsgStartupReasonStatus& coRef);
   cfc_spmfi_tclMsgStartupReasonStatus(const cfc_spmfi_tclMsgStartupReasonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_STARTUP_REASON StartupReason;
   virtual ~cfc_spmfi_tclMsgStartupReasonStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgStartupReasonStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgConnectToBatteryGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgConnectToBatteryGet();

   virtual ~cfc_spmfi_tclMsgConnectToBatteryGet();

   inline tBool operator==(const cfc_spmfi_tclMsgConnectToBatteryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgConnectToBatteryStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgConnectToBatteryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgConnectToBatteryStatus& operator=(const cfc_spmfi_tclMsgConnectToBatteryStatus& coRef);
   cfc_spmfi_tclMsgConnectToBatteryStatus(const cfc_spmfi_tclMsgConnectToBatteryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ConnectToBatteryState;
   tU8 ConnectToBatteryCount;
   virtual ~cfc_spmfi_tclMsgConnectToBatteryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgConnectToBatteryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCvmEventUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCvmEventUpReg();

   virtual ~cfc_spmfi_tclMsgCvmEventUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCvmEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCvmEventRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCvmEventRelUpReg();

   virtual ~cfc_spmfi_tclMsgCvmEventRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCvmEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCvmEventGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCvmEventGet();

   virtual ~cfc_spmfi_tclMsgCvmEventGet();

   inline tBool operator==(const cfc_spmfi_tclMsgCvmEventGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCvmEventStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCvmEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgCvmEventStatus& operator=(const cfc_spmfi_tclMsgCvmEventStatus& coRef);
   cfc_spmfi_tclMsgCvmEventStatus(const cfc_spmfi_tclMsgCvmEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_CVM_EVENT CvmEvent;
   virtual ~cfc_spmfi_tclMsgCvmEventStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgCvmEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgUBatSenseGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgUBatSenseGet();

   virtual ~cfc_spmfi_tclMsgUBatSenseGet();

   inline tBool operator==(const cfc_spmfi_tclMsgUBatSenseGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgUBatSenseStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgUBatSenseStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgUBatSenseStatus& operator=(const cfc_spmfi_tclMsgUBatSenseStatus& coRef);
   cfc_spmfi_tclMsgUBatSenseStatus(const cfc_spmfi_tclMsgUBatSenseStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 UBatSense;
   virtual ~cfc_spmfi_tclMsgUBatSenseStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgUBatSenseStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCalibratedCvmEventUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCalibratedCvmEventUpReg();

   virtual ~cfc_spmfi_tclMsgCalibratedCvmEventUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCalibratedCvmEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg();

   virtual ~cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCalibratedCvmEventGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCalibratedCvmEventGet();

   virtual ~cfc_spmfi_tclMsgCalibratedCvmEventGet();

   inline tBool operator==(const cfc_spmfi_tclMsgCalibratedCvmEventGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCalibratedCvmEventStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCalibratedCvmEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgCalibratedCvmEventStatus& operator=(const cfc_spmfi_tclMsgCalibratedCvmEventStatus& coRef);
   cfc_spmfi_tclMsgCalibratedCvmEventStatus(const cfc_spmfi_tclMsgCalibratedCvmEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT CvmEvent;
   virtual ~cfc_spmfi_tclMsgCalibratedCvmEventStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgCalibratedCvmEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgIgnitionCyclesUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgIgnitionCyclesUpReg();

   virtual ~cfc_spmfi_tclMsgIgnitionCyclesUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgIgnitionCyclesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgIgnitionCyclesRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgIgnitionCyclesRelUpReg();

   virtual ~cfc_spmfi_tclMsgIgnitionCyclesRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgIgnitionCyclesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgIgnitionCyclesGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgIgnitionCyclesGet();

   virtual ~cfc_spmfi_tclMsgIgnitionCyclesGet();

   inline tBool operator==(const cfc_spmfi_tclMsgIgnitionCyclesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgIgnitionCyclesStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgIgnitionCyclesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgIgnitionCyclesStatus& operator=(const cfc_spmfi_tclMsgIgnitionCyclesStatus& coRef);
   cfc_spmfi_tclMsgIgnitionCyclesStatus(const cfc_spmfi_tclMsgIgnitionCyclesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 IgnitionCycle;
   virtual ~cfc_spmfi_tclMsgIgnitionCyclesStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgIgnitionCyclesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysPwrModeUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysPwrModeUpReg();

   virtual ~cfc_spmfi_tclMsgSysPwrModeUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSysPwrModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysPwrModeRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysPwrModeRelUpReg();

   virtual ~cfc_spmfi_tclMsgSysPwrModeRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSysPwrModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysPwrModeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysPwrModeGet();

   virtual ~cfc_spmfi_tclMsgSysPwrModeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSysPwrModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysPwrModeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysPwrModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSysPwrModeStatus& operator=(const cfc_spmfi_tclMsgSysPwrModeStatus& coRef);
   cfc_spmfi_tclMsgSysPwrModeStatus(const cfc_spmfi_tclMsgSysPwrModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode;
   virtual ~cfc_spmfi_tclMsgSysPwrModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSysPwrModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysPwrSaveModeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysPwrSaveModeGet();

   virtual ~cfc_spmfi_tclMsgSysPwrSaveModeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSysPwrSaveModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysPwrSaveModeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysPwrSaveModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSysPwrSaveModeStatus& operator=(const cfc_spmfi_tclMsgSysPwrSaveModeStatus& coRef);
   cfc_spmfi_tclMsgSysPwrSaveModeStatus(const cfc_spmfi_tclMsgSysPwrSaveModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE SysPwrSaveMode;
   virtual ~cfc_spmfi_tclMsgSysPwrSaveModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSysPwrSaveModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRVCStateSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRVCStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgRVCStateSet& operator=(const cfc_spmfi_tclMsgRVCStateSet& coRef);
   cfc_spmfi_tclMsgRVCStateSet(const cfc_spmfi_tclMsgRVCStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   virtual ~cfc_spmfi_tclMsgRVCStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgRVCStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRVCStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRVCStateGet();

   virtual ~cfc_spmfi_tclMsgRVCStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgRVCStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRVCStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRVCStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgRVCStateStatus& operator=(const cfc_spmfi_tclMsgRVCStateStatus& coRef);
   cfc_spmfi_tclMsgRVCStateStatus(const cfc_spmfi_tclMsgRVCStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   virtual ~cfc_spmfi_tclMsgRVCStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgRVCStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgLifesignUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgLifesignUpReg();

   virtual ~cfc_spmfi_tclMsgLifesignUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgLifesignUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgLifesignRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgLifesignRelUpReg();

   virtual ~cfc_spmfi_tclMsgLifesignRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgLifesignRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgLifesignGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgLifesignGet();

   virtual ~cfc_spmfi_tclMsgLifesignGet();

   inline tBool operator==(const cfc_spmfi_tclMsgLifesignGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgLifesignStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgLifesignStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgLifesignStatus& operator=(const cfc_spmfi_tclMsgLifesignStatus& coRef);
   cfc_spmfi_tclMsgLifesignStatus(const cfc_spmfi_tclMsgLifesignStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Lifesign;
   virtual ~cfc_spmfi_tclMsgLifesignStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgLifesignStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgHmiStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgHmiStateUpReg();

   virtual ~cfc_spmfi_tclMsgHmiStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgHmiStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgHmiStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgHmiStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgHmiStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgHmiStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgHmiStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgHmiStateGet();

   virtual ~cfc_spmfi_tclMsgHmiStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgHmiStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgHmiStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgHmiStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgHmiStateStatus& operator=(const cfc_spmfi_tclMsgHmiStateStatus& coRef);
   cfc_spmfi_tclMsgHmiStateStatus(const cfc_spmfi_tclMsgHmiStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_HMI_STATE HmiState;
   virtual ~cfc_spmfi_tclMsgHmiStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgHmiStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemPowerBehaviourUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemPowerBehaviourUpReg();

   virtual ~cfc_spmfi_tclMsgSystemPowerBehaviourUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSystemPowerBehaviourUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg();

   virtual ~cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemPowerBehaviourGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemPowerBehaviourGet();

   virtual ~cfc_spmfi_tclMsgSystemPowerBehaviourGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSystemPowerBehaviourGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemPowerBehaviourStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemPowerBehaviourStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSystemPowerBehaviourStatus& operator=(const cfc_spmfi_tclMsgSystemPowerBehaviourStatus& coRef);
   cfc_spmfi_tclMsgSystemPowerBehaviourStatus(const cfc_spmfi_tclMsgSystemPowerBehaviourStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR eSystemPowerBehaviour;
   virtual ~cfc_spmfi_tclMsgSystemPowerBehaviourStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSystemPowerBehaviourStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEntertainMuteUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEntertainMuteUpReg();

   virtual ~cfc_spmfi_tclMsgEntertainMuteUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgEntertainMuteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEntertainMuteRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEntertainMuteRelUpReg();

   virtual ~cfc_spmfi_tclMsgEntertainMuteRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgEntertainMuteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEntertainMuteGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEntertainMuteGet();

   virtual ~cfc_spmfi_tclMsgEntertainMuteGet();

   inline tBool operator==(const cfc_spmfi_tclMsgEntertainMuteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEntertainMuteStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEntertainMuteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgEntertainMuteStatus& operator=(const cfc_spmfi_tclMsgEntertainMuteStatus& coRef);
   cfc_spmfi_tclMsgEntertainMuteStatus(const cfc_spmfi_tclMsgEntertainMuteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMuteState;
   virtual ~cfc_spmfi_tclMsgEntertainMuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgEntertainMuteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg();

   virtual ~cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg();

   virtual ~cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet();

   virtual ~cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet& operator=(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet& coRef);
   cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Time;
   virtual ~cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus& operator=(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus& coRef);
   cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Time;
   virtual ~cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDimStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDimStateUpReg();

   virtual ~cfc_spmfi_tclMsgDimStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgDimStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDimStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDimStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgDimStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgDimStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDimStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDimStateGet();

   virtual ~cfc_spmfi_tclMsgDimStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgDimStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDimStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDimStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDimStateStatus& operator=(const cfc_spmfi_tclMsgDimStateStatus& coRef);
   cfc_spmfi_tclMsgDimStateStatus(const cfc_spmfi_tclMsgDimStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_DIM_STATE DimState;
   virtual ~cfc_spmfi_tclMsgDimStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDimStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDimmingStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDimmingStateUpReg();

   virtual ~cfc_spmfi_tclMsgDimmingStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgDimmingStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDimmingStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDimmingStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgDimmingStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgDimmingStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDimmingStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDimmingStateGet();

   virtual ~cfc_spmfi_tclMsgDimmingStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgDimmingStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDimmingStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDimmingStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDimmingStateStatus& operator=(const cfc_spmfi_tclMsgDimmingStateStatus& coRef);
   cfc_spmfi_tclMsgDimmingStateStatus(const cfc_spmfi_tclMsgDimmingStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_b32_DIM_STATE DimState;
   virtual ~cfc_spmfi_tclMsgDimmingStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDimmingStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMmgrStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMmgrStateUpReg();

   virtual ~cfc_spmfi_tclMsgMmgrStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgMmgrStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMmgrStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMmgrStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgMmgrStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgMmgrStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMmgrStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMmgrStateGet();

   virtual ~cfc_spmfi_tclMsgMmgrStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgMmgrStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMmgrStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMmgrStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgMmgrStateStatus& operator=(const cfc_spmfi_tclMsgMmgrStateStatus& coRef);
   cfc_spmfi_tclMsgMmgrStateStatus(const cfc_spmfi_tclMsgMmgrStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_MMGR_STATE MmgrState;
   virtual ~cfc_spmfi_tclMsgMmgrStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgMmgrStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgAudioStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgAudioStateUpReg();

   virtual ~cfc_spmfi_tclMsgAudioStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgAudioStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgAudioStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgAudioStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgAudioStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgAudioStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgAudioStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgAudioStateGet();

   virtual ~cfc_spmfi_tclMsgAudioStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgAudioStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgAudioStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgAudioStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgAudioStateStatus& operator=(const cfc_spmfi_tclMsgAudioStateStatus& coRef);
   cfc_spmfi_tclMsgAudioStateStatus(const cfc_spmfi_tclMsgAudioStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_AUDIO_STATE AudioState;
   virtual ~cfc_spmfi_tclMsgAudioStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgAudioStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysStateUpReg();

   virtual ~cfc_spmfi_tclMsgSysStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSysStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgSysStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgSysStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysStateGet();

   virtual ~cfc_spmfi_tclMsgSysStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSysStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSysStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSysStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSysStateStatus& operator=(const cfc_spmfi_tclMsgSysStateStatus& coRef);
   cfc_spmfi_tclMsgSysStateStatus(const cfc_spmfi_tclMsgSysStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_SYS_STATE SysState;
   virtual ~cfc_spmfi_tclMsgSysStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSysStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMostStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMostStateUpReg();

   virtual ~cfc_spmfi_tclMsgMostStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgMostStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMostStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMostStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgMostStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgMostStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMostStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMostStateGet();

   virtual ~cfc_spmfi_tclMsgMostStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgMostStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMostStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMostStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgMostStateStatus& operator=(const cfc_spmfi_tclMsgMostStateStatus& coRef);
   cfc_spmfi_tclMsgMostStateStatus(const cfc_spmfi_tclMsgMostStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_MOST_EVENT MostEvent;
   cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE MostConfigurationState;
   tU32 FirstReceiveTime;
   cfc_fi_tcl_SPM_e32_TLA_STATE TLAState;
   tBool OvertemperatureMostOff;
   virtual ~cfc_spmfi_tclMsgMostStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgMostStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMostVersionGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMostVersionGet();

   virtual ~cfc_spmfi_tclMsgMostVersionGet();

   inline tBool operator==(const cfc_spmfi_tclMsgMostVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMostVersionStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMostVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgMostVersionStatus& operator=(const cfc_spmfi_tclMsgMostVersionStatus& coRef);
   cfc_spmfi_tclMsgMostVersionStatus(const cfc_spmfi_tclMsgMostVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclString MostVersion;
   virtual ~cfc_spmfi_tclMsgMostVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgMostVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStandbyTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStandbyTimeGet();

   virtual ~cfc_spmfi_tclMsgStandbyTimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgStandbyTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStandbyTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStandbyTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgStandbyTimeSet& operator=(const cfc_spmfi_tclMsgStandbyTimeSet& coRef);
   cfc_spmfi_tclMsgStandbyTimeSet(const cfc_spmfi_tclMsgStandbyTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 StandbyTime;
   virtual ~cfc_spmfi_tclMsgStandbyTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgStandbyTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStandbyTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStandbyTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgStandbyTimeStatus& operator=(const cfc_spmfi_tclMsgStandbyTimeStatus& coRef);
   cfc_spmfi_tclMsgStandbyTimeStatus(const cfc_spmfi_tclMsgStandbyTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 StandbyTime;
   virtual ~cfc_spmfi_tclMsgStandbyTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgStandbyTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPersitentStandbyTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPersitentStandbyTimeGet();

   virtual ~cfc_spmfi_tclMsgPersitentStandbyTimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgPersitentStandbyTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPersitentStandbyTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPersitentStandbyTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPersitentStandbyTimeSet& operator=(const cfc_spmfi_tclMsgPersitentStandbyTimeSet& coRef);
   cfc_spmfi_tclMsgPersitentStandbyTimeSet(const cfc_spmfi_tclMsgPersitentStandbyTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PersitentStandbyTime;
   virtual ~cfc_spmfi_tclMsgPersitentStandbyTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPersitentStandbyTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPersitentStandbyTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPersitentStandbyTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPersitentStandbyTimeStatus& operator=(const cfc_spmfi_tclMsgPersitentStandbyTimeStatus& coRef);
   cfc_spmfi_tclMsgPersitentStandbyTimeStatus(const cfc_spmfi_tclMsgPersitentStandbyTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PersitentStandbyTime;
   virtual ~cfc_spmfi_tclMsgPersitentStandbyTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPersitentStandbyTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSuspendTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSuspendTimeGet();

   virtual ~cfc_spmfi_tclMsgSuspendTimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSuspendTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSuspendTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSuspendTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSuspendTimeSet& operator=(const cfc_spmfi_tclMsgSuspendTimeSet& coRef);
   cfc_spmfi_tclMsgSuspendTimeSet(const cfc_spmfi_tclMsgSuspendTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SuspendTime;
   virtual ~cfc_spmfi_tclMsgSuspendTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSuspendTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSuspendTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSuspendTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSuspendTimeStatus& operator=(const cfc_spmfi_tclMsgSuspendTimeStatus& coRef);
   cfc_spmfi_tclMsgSuspendTimeStatus(const cfc_spmfi_tclMsgSuspendTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SuspendTime;
   virtual ~cfc_spmfi_tclMsgSuspendTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSuspendTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgIgnitionOffTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgIgnitionOffTimeGet();

   virtual ~cfc_spmfi_tclMsgIgnitionOffTimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgIgnitionOffTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgIgnitionOffTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgIgnitionOffTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgIgnitionOffTimeSet& operator=(const cfc_spmfi_tclMsgIgnitionOffTimeSet& coRef);
   cfc_spmfi_tclMsgIgnitionOffTimeSet(const cfc_spmfi_tclMsgIgnitionOffTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 IgnitionOffTime;
   virtual ~cfc_spmfi_tclMsgIgnitionOffTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgIgnitionOffTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgIgnitionOffTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgIgnitionOffTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgIgnitionOffTimeStatus& operator=(const cfc_spmfi_tclMsgIgnitionOffTimeStatus& coRef);
   cfc_spmfi_tclMsgIgnitionOffTimeStatus(const cfc_spmfi_tclMsgIgnitionOffTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 IgnitionOffTime;
   virtual ~cfc_spmfi_tclMsgIgnitionOffTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgIgnitionOffTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDoorOpenTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDoorOpenTimeGet();

   virtual ~cfc_spmfi_tclMsgDoorOpenTimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgDoorOpenTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDoorOpenTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDoorOpenTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDoorOpenTimeSet& operator=(const cfc_spmfi_tclMsgDoorOpenTimeSet& coRef);
   cfc_spmfi_tclMsgDoorOpenTimeSet(const cfc_spmfi_tclMsgDoorOpenTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DoorOpenTime;
   virtual ~cfc_spmfi_tclMsgDoorOpenTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDoorOpenTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDoorOpenTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDoorOpenTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDoorOpenTimeStatus& operator=(const cfc_spmfi_tclMsgDoorOpenTimeStatus& coRef);
   cfc_spmfi_tclMsgDoorOpenTimeStatus(const cfc_spmfi_tclMsgDoorOpenTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DoorOpenTime;
   virtual ~cfc_spmfi_tclMsgDoorOpenTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDoorOpenTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgClockDisplayTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgClockDisplayTimeGet();

   virtual ~cfc_spmfi_tclMsgClockDisplayTimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgClockDisplayTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgClockDisplayTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgClockDisplayTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgClockDisplayTimeSet& operator=(const cfc_spmfi_tclMsgClockDisplayTimeSet& coRef);
   cfc_spmfi_tclMsgClockDisplayTimeSet(const cfc_spmfi_tclMsgClockDisplayTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ClockDisplayTime;
   virtual ~cfc_spmfi_tclMsgClockDisplayTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgClockDisplayTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgClockDisplayTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgClockDisplayTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgClockDisplayTimeStatus& operator=(const cfc_spmfi_tclMsgClockDisplayTimeStatus& coRef);
   cfc_spmfi_tclMsgClockDisplayTimeStatus(const cfc_spmfi_tclMsgClockDisplayTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ClockDisplayTime;
   virtual ~cfc_spmfi_tclMsgClockDisplayTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgClockDisplayTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemStateTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemStateTimeGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSystemStateTimeGet& operator=(const cfc_spmfi_tclMsgSystemStateTimeGet& coRef);
   cfc_spmfi_tclMsgSystemStateTimeGet(const cfc_spmfi_tclMsgSystemStateTimeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_SYSTEM_STATES tSystemState;
   virtual ~cfc_spmfi_tclMsgSystemStateTimeGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSystemStateTimeGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemStateTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemStateTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSystemStateTimeSet& operator=(const cfc_spmfi_tclMsgSystemStateTimeSet& coRef);
   cfc_spmfi_tclMsgSystemStateTimeSet(const cfc_spmfi_tclMsgSystemStateTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_SYSTEM_STATES tSystemState;
   tU32 tStateTimerValue;
   virtual ~cfc_spmfi_tclMsgSystemStateTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSystemStateTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSystemStateTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSystemStateTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSystemStateTimeStatus& operator=(const cfc_spmfi_tclMsgSystemStateTimeStatus& coRef);
   cfc_spmfi_tclMsgSystemStateTimeStatus(const cfc_spmfi_tclMsgSystemStateTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_SYSTEM_STATES tSystemState;
   tU32 tStateTimerValue;
   virtual ~cfc_spmfi_tclMsgSystemStateTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSystemStateTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFgsStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFgsStateUpReg();

   virtual ~cfc_spmfi_tclMsgFgsStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgFgsStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFgsStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFgsStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgFgsStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgFgsStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFgsStateSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFgsStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgFgsStateSet& operator=(const cfc_spmfi_tclMsgFgsStateSet& coRef);
   cfc_spmfi_tclMsgFgsStateSet(const cfc_spmfi_tclMsgFgsStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PROCESSOR_STATE FgsState;
   virtual ~cfc_spmfi_tclMsgFgsStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgFgsStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFgsStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFgsStateGet();

   virtual ~cfc_spmfi_tclMsgFgsStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgFgsStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFgsStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFgsStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgFgsStateStatus& operator=(const cfc_spmfi_tclMsgFgsStateStatus& coRef);
   cfc_spmfi_tclMsgFgsStateStatus(const cfc_spmfi_tclMsgFgsStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PROCESSOR_STATE FgsState;
   virtual ~cfc_spmfi_tclMsgFgsStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgFgsStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCoproStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCoproStateUpReg();

   virtual ~cfc_spmfi_tclMsgCoproStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCoproStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCoproStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCoproStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgCoproStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCoproStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCoproStateSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCoproStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgCoproStateSet& operator=(const cfc_spmfi_tclMsgCoproStateSet& coRef);
   cfc_spmfi_tclMsgCoproStateSet(const cfc_spmfi_tclMsgCoproStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PROCESSOR_STATE CoproState;
   virtual ~cfc_spmfi_tclMsgCoproStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgCoproStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCoproStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCoproStateGet();

   virtual ~cfc_spmfi_tclMsgCoproStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgCoproStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCoproStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCoproStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgCoproStateStatus& operator=(const cfc_spmfi_tclMsgCoproStateStatus& coRef);
   cfc_spmfi_tclMsgCoproStateStatus(const cfc_spmfi_tclMsgCoproStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PROCESSOR_STATE CoproState;
   virtual ~cfc_spmfi_tclMsgCoproStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgCoproStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDabStateSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDabStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDabStateSet& operator=(const cfc_spmfi_tclMsgDabStateSet& coRef);
   cfc_spmfi_tclMsgDabStateSet(const cfc_spmfi_tclMsgDabStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PROCESSOR_STATE DabState;
   virtual ~cfc_spmfi_tclMsgDabStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDabStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDabStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDabStateGet();

   virtual ~cfc_spmfi_tclMsgDabStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgDabStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDabStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDabStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDabStateStatus& operator=(const cfc_spmfi_tclMsgDabStateStatus& coRef);
   cfc_spmfi_tclMsgDabStateStatus(const cfc_spmfi_tclMsgDabStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PROCESSOR_STATE DabState;
   virtual ~cfc_spmfi_tclMsgDabStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDabStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEjectStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEjectStateUpReg();

   virtual ~cfc_spmfi_tclMsgEjectStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgEjectStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEjectStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEjectStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgEjectStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgEjectStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEjectStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEjectStateGet();

   virtual ~cfc_spmfi_tclMsgEjectStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgEjectStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgEjectStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgEjectStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgEjectStateStatus& operator=(const cfc_spmfi_tclMsgEjectStateStatus& coRef);
   cfc_spmfi_tclMsgEjectStateStatus(const cfc_spmfi_tclMsgEjectStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_CD_EJECT_STATE EjectState;
   virtual ~cfc_spmfi_tclMsgEjectStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgEjectStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgInsertStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgInsertStateUpReg();

   virtual ~cfc_spmfi_tclMsgInsertStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgInsertStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgInsertStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgInsertStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgInsertStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgInsertStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgInsertStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgInsertStateGet();

   virtual ~cfc_spmfi_tclMsgInsertStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgInsertStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgInsertStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgInsertStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgInsertStateStatus& operator=(const cfc_spmfi_tclMsgInsertStateStatus& coRef);
   cfc_spmfi_tclMsgInsertStateStatus(const cfc_spmfi_tclMsgInsertStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_CD_INSERT_STATE InsertState;
   virtual ~cfc_spmfi_tclMsgInsertStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgInsertStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMediaEjectStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMediaEjectStateUpReg();

   virtual ~cfc_spmfi_tclMsgMediaEjectStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgMediaEjectStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMediaEjectStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMediaEjectStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgMediaEjectStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgMediaEjectStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMediaEjectStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMediaEjectStateGet();

   virtual ~cfc_spmfi_tclMsgMediaEjectStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgMediaEjectStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgMediaEjectStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgMediaEjectStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgMediaEjectStateStatus& operator=(const cfc_spmfi_tclMsgMediaEjectStateStatus& coRef);
   cfc_spmfi_tclMsgMediaEjectStateStatus(const cfc_spmfi_tclMsgMediaEjectStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE MediaEjectState;
   virtual ~cfc_spmfi_tclMsgMediaEjectStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgMediaEjectStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneMuteStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneMuteStateUpReg();

   virtual ~cfc_spmfi_tclMsgPhoneMuteStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneMuteStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneMuteStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneMuteStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgPhoneMuteStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneMuteStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneMuteStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneMuteStateGet();

   virtual ~cfc_spmfi_tclMsgPhoneMuteStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneMuteStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneMuteStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneMuteStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPhoneMuteStateStatus& operator=(const cfc_spmfi_tclMsgPhoneMuteStateStatus& coRef);
   cfc_spmfi_tclMsgPhoneMuteStateStatus(const cfc_spmfi_tclMsgPhoneMuteStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE PhoneMuteState;
   virtual ~cfc_spmfi_tclMsgPhoneMuteStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPhoneMuteStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRmtEnableStateSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRmtEnableStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgRmtEnableStateSet& operator=(const cfc_spmfi_tclMsgRmtEnableStateSet& coRef);
   cfc_spmfi_tclMsgRmtEnableStateSet(const cfc_spmfi_tclMsgRmtEnableStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RmtEnableState;
   virtual ~cfc_spmfi_tclMsgRmtEnableStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgRmtEnableStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRmtEnableStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRmtEnableStateGet();

   virtual ~cfc_spmfi_tclMsgRmtEnableStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgRmtEnableStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRmtEnableStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRmtEnableStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgRmtEnableStateStatus& operator=(const cfc_spmfi_tclMsgRmtEnableStateStatus& coRef);
   cfc_spmfi_tclMsgRmtEnableStateStatus(const cfc_spmfi_tclMsgRmtEnableStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RmtEnableState;
   virtual ~cfc_spmfi_tclMsgRmtEnableStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgRmtEnableStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnTipperStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnTipperStateUpReg();

   virtual ~cfc_spmfi_tclMsgOnTipperStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgOnTipperStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnTipperStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnTipperStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgOnTipperStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgOnTipperStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnTipperStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnTipperStateGet();

   virtual ~cfc_spmfi_tclMsgOnTipperStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgOnTipperStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgOnTipperStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgOnTipperStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgOnTipperStateStatus& operator=(const cfc_spmfi_tclMsgOnTipperStateStatus& coRef);
   cfc_spmfi_tclMsgOnTipperStateStatus(const cfc_spmfi_tclMsgOnTipperStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_KEY_STATE OnTipperState;
   virtual ~cfc_spmfi_tclMsgOnTipperStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgOnTipperStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCodeRequestStateUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCodeRequestStateUpReg();

   virtual ~cfc_spmfi_tclMsgCodeRequestStateUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCodeRequestStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCodeRequestStateRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCodeRequestStateRelUpReg();

   virtual ~cfc_spmfi_tclMsgCodeRequestStateRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCodeRequestStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCodeRequestStateSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCodeRequestStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgCodeRequestStateSet& operator=(const cfc_spmfi_tclMsgCodeRequestStateSet& coRef);
   cfc_spmfi_tclMsgCodeRequestStateSet(const cfc_spmfi_tclMsgCodeRequestStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_CODE_REQUEST CodeRequestState;
   virtual ~cfc_spmfi_tclMsgCodeRequestStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgCodeRequestStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCodeRequestStateGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCodeRequestStateGet();

   virtual ~cfc_spmfi_tclMsgCodeRequestStateGet();

   inline tBool operator==(const cfc_spmfi_tclMsgCodeRequestStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCodeRequestStateStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCodeRequestStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgCodeRequestStateStatus& operator=(const cfc_spmfi_tclMsgCodeRequestStateStatus& coRef);
   cfc_spmfi_tclMsgCodeRequestStateStatus(const cfc_spmfi_tclMsgCodeRequestStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_CODE_REQUEST CodeRequestState;
   virtual ~cfc_spmfi_tclMsgCodeRequestStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgCodeRequestStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneAbortUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneAbortUpReg();

   virtual ~cfc_spmfi_tclMsgPhoneAbortUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneAbortUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneAbortRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneAbortRelUpReg();

   virtual ~cfc_spmfi_tclMsgPhoneAbortRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneAbortRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneAbortSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneAbortSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPhoneAbortSet& operator=(const cfc_spmfi_tclMsgPhoneAbortSet& coRef);
   cfc_spmfi_tclMsgPhoneAbortSet(const cfc_spmfi_tclMsgPhoneAbortSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST PhoneAbort;
   virtual ~cfc_spmfi_tclMsgPhoneAbortSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPhoneAbortSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneAbortGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneAbortGet();

   virtual ~cfc_spmfi_tclMsgPhoneAbortGet();

   inline tBool operator==(const cfc_spmfi_tclMsgPhoneAbortGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPhoneAbortStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPhoneAbortStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPhoneAbortStatus& operator=(const cfc_spmfi_tclMsgPhoneAbortStatus& coRef);
   cfc_spmfi_tclMsgPhoneAbortStatus(const cfc_spmfi_tclMsgPhoneAbortStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST PhoneAbort;
   virtual ~cfc_spmfi_tclMsgPhoneAbortStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPhoneAbortStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDisplaySizeUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDisplaySizeUpReg();

   virtual ~cfc_spmfi_tclMsgDisplaySizeUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgDisplaySizeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDisplaySizeRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDisplaySizeRelUpReg();

   virtual ~cfc_spmfi_tclMsgDisplaySizeRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgDisplaySizeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDisplaySizeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDisplaySizeGet();

   virtual ~cfc_spmfi_tclMsgDisplaySizeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgDisplaySizeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDisplaySizeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDisplaySizeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDisplaySizeStatus& operator=(const cfc_spmfi_tclMsgDisplaySizeStatus& coRef);
   cfc_spmfi_tclMsgDisplaySizeStatus(const cfc_spmfi_tclMsgDisplaySizeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Width;
   tU16 u16Height;
   virtual ~cfc_spmfi_tclMsgDisplaySizeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDisplaySizeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRestartUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRestartUpReg();

   virtual ~cfc_spmfi_tclMsgRestartUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgRestartUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRestartRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRestartRelUpReg();

   virtual ~cfc_spmfi_tclMsgRestartRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgRestartRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRestartSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRestartSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgRestartSet& operator=(const cfc_spmfi_tclMsgRestartSet& coRef);
   cfc_spmfi_tclMsgRestartSet(const cfc_spmfi_tclMsgRestartSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_RESTART_TYPE Restart;
   virtual ~cfc_spmfi_tclMsgRestartSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgRestartSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRestartGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRestartGet();

   virtual ~cfc_spmfi_tclMsgRestartGet();

   inline tBool operator==(const cfc_spmfi_tclMsgRestartGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgRestartStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgRestartStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgRestartStatus& operator=(const cfc_spmfi_tclMsgRestartStatus& coRef);
   cfc_spmfi_tclMsgRestartStatus(const cfc_spmfi_tclMsgRestartStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_RESTART_TYPE Restart;
   virtual ~cfc_spmfi_tclMsgRestartStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgRestartStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDevicePowerOnTimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDevicePowerOnTimeGet();

   virtual ~cfc_spmfi_tclMsgDevicePowerOnTimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgDevicePowerOnTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDevicePowerOnTimeSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDevicePowerOnTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDevicePowerOnTimeSet& operator=(const cfc_spmfi_tclMsgDevicePowerOnTimeSet& coRef);
   cfc_spmfi_tclMsgDevicePowerOnTimeSet(const cfc_spmfi_tclMsgDevicePowerOnTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DevicePowerOnTime;
   virtual ~cfc_spmfi_tclMsgDevicePowerOnTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDevicePowerOnTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgDevicePowerOnTimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgDevicePowerOnTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgDevicePowerOnTimeStatus& operator=(const cfc_spmfi_tclMsgDevicePowerOnTimeStatus& coRef);
   cfc_spmfi_tclMsgDevicePowerOnTimeStatus(const cfc_spmfi_tclMsgDevicePowerOnTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DevicePowerOnTime;
   virtual ~cfc_spmfi_tclMsgDevicePowerOnTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgDevicePowerOnTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgLastSystemRuntimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgLastSystemRuntimeGet();

   virtual ~cfc_spmfi_tclMsgLastSystemRuntimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgLastSystemRuntimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgLastSystemRuntimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgLastSystemRuntimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgLastSystemRuntimeStatus& operator=(const cfc_spmfi_tclMsgLastSystemRuntimeStatus& coRef);
   cfc_spmfi_tclMsgLastSystemRuntimeStatus(const cfc_spmfi_tclMsgLastSystemRuntimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32RunTime;
   virtual ~cfc_spmfi_tclMsgLastSystemRuntimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgLastSystemRuntimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCurrentSystemRuntimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCurrentSystemRuntimeGet();

   virtual ~cfc_spmfi_tclMsgCurrentSystemRuntimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgCurrentSystemRuntimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCurrentSystemRuntimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCurrentSystemRuntimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgCurrentSystemRuntimeStatus& operator=(const cfc_spmfi_tclMsgCurrentSystemRuntimeStatus& coRef);
   cfc_spmfi_tclMsgCurrentSystemRuntimeStatus(const cfc_spmfi_tclMsgCurrentSystemRuntimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32RunTime;
   virtual ~cfc_spmfi_tclMsgCurrentSystemRuntimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgCurrentSystemRuntimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFactorySettingStatusUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFactorySettingStatusUpReg();

   virtual ~cfc_spmfi_tclMsgFactorySettingStatusUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgFactorySettingStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFactorySettingStatusRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFactorySettingStatusRelUpReg();

   virtual ~cfc_spmfi_tclMsgFactorySettingStatusRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgFactorySettingStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFactorySettingStatusGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFactorySettingStatusGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgFactorySettingStatusGet& operator=(const cfc_spmfi_tclMsgFactorySettingStatusGet& coRef);
   cfc_spmfi_tclMsgFactorySettingStatusGet(const cfc_spmfi_tclMsgFactorySettingStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   cfc_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~cfc_spmfi_tclMsgFactorySettingStatusGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgFactorySettingStatusGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFactorySettingStatusSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFactorySettingStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgFactorySettingStatusSet& operator=(const cfc_spmfi_tclMsgFactorySettingStatusSet& coRef);
   cfc_spmfi_tclMsgFactorySettingStatusSet(const cfc_spmfi_tclMsgFactorySettingStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   cfc_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~cfc_spmfi_tclMsgFactorySettingStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgFactorySettingStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgFactorySettingStatusStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgFactorySettingStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgFactorySettingStatusStatus& operator=(const cfc_spmfi_tclMsgFactorySettingStatusStatus& coRef);
   cfc_spmfi_tclMsgFactorySettingStatusStatus(const cfc_spmfi_tclMsgFactorySettingStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   cfc_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~cfc_spmfi_tclMsgFactorySettingStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgFactorySettingStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityCommErrorGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityCommErrorGet();

   virtual ~cfc_spmfi_tclMsgSecurityCommErrorGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSecurityCommErrorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityCommErrorStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityCommErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSecurityCommErrorStatus& operator=(const cfc_spmfi_tclMsgSecurityCommErrorStatus& coRef);
   cfc_spmfi_tclMsgSecurityCommErrorStatus(const cfc_spmfi_tclMsgSecurityCommErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 CommErrorCount;
   virtual ~cfc_spmfi_tclMsgSecurityCommErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSecurityCommErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityMoreThan10VinGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityMoreThan10VinGet();

   virtual ~cfc_spmfi_tclMsgSecurityMoreThan10VinGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSecurityMoreThan10VinGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityMoreThan10VinStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityMoreThan10VinStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSecurityMoreThan10VinStatus& operator=(const cfc_spmfi_tclMsgSecurityMoreThan10VinStatus& coRef);
   cfc_spmfi_tclMsgSecurityMoreThan10VinStatus(const cfc_spmfi_tclMsgSecurityMoreThan10VinStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MoreThan10VinCount;
   virtual ~cfc_spmfi_tclMsgSecurityMoreThan10VinStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSecurityMoreThan10VinStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityInvalidVinGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityInvalidVinGet();

   virtual ~cfc_spmfi_tclMsgSecurityInvalidVinGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSecurityInvalidVinGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityInvalidVinStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityInvalidVinStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSecurityInvalidVinStatus& operator=(const cfc_spmfi_tclMsgSecurityInvalidVinStatus& coRef);
   cfc_spmfi_tclMsgSecurityInvalidVinStatus(const cfc_spmfi_tclMsgSecurityInvalidVinStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 InvalidVinCount;
   virtual ~cfc_spmfi_tclMsgSecurityInvalidVinStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSecurityInvalidVinStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityCurrentVinGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityCurrentVinGet();

   virtual ~cfc_spmfi_tclMsgSecurityCurrentVinGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSecurityCurrentVinGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityCurrentVinStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityCurrentVinStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSecurityCurrentVinStatus& operator=(const cfc_spmfi_tclMsgSecurityCurrentVinStatus& coRef);
   cfc_spmfi_tclMsgSecurityCurrentVinStatus(const cfc_spmfi_tclMsgSecurityCurrentVinStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_Vin CurrentVin;
   virtual ~cfc_spmfi_tclMsgSecurityCurrentVinStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSecurityCurrentVinStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityVinHistoryGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityVinHistoryGet();

   virtual ~cfc_spmfi_tclMsgSecurityVinHistoryGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSecurityVinHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSecurityVinHistoryStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSecurityVinHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSecurityVinHistoryStatus& operator=(const cfc_spmfi_tclMsgSecurityVinHistoryStatus& coRef);
   cfc_spmfi_tclMsgSecurityVinHistoryStatus(const cfc_spmfi_tclMsgSecurityVinHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_VinHistory VinHistory;
   virtual ~cfc_spmfi_tclMsgSecurityVinHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSecurityVinHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetListSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgResetListSet& operator=(const cfc_spmfi_tclMsgResetListSet& coRef);
   cfc_spmfi_tclMsgResetListSet(const cfc_spmfi_tclMsgResetListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ResetResetList;
   virtual ~cfc_spmfi_tclMsgResetListSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgResetListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetListGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetListGet();

   virtual ~cfc_spmfi_tclMsgResetListGet();

   inline tBool operator==(const cfc_spmfi_tclMsgResetListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetListStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgResetListStatus& operator=(const cfc_spmfi_tclMsgResetListStatus& coRef);
   cfc_spmfi_tclMsgResetListStatus(const cfc_spmfi_tclMsgResetListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_e8_LcmResetReason LastResetReason;
   tU8 DateHour;
   tU8 DateMinute;
   tU8 DateDay;
   tU8 DateMonth;
   tU16 DateYear;
   tU8 CoproResetByHmi;
   tU8 CoproResetByUndervoltage;
   tU8 HmiResetByCoproStartup;
   tU8 HmiResetByCoproRun;
   tU8 HmiResetByCoproShutdown;
   tU8 HmiResetByHmiWdg;
   tU8 HmiResetByHmiApp;
   tU8 HmiResetByHmiException;
   tU8 HmiResetByHmiExtern;
   tU8 HmiResetByHmiDownload;
   tU8 HmiResetByHmiDiag;
   tU8 FgsResetByHmi;
   virtual ~cfc_spmfi_tclMsgResetListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgResetListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetCounterSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetCounterSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgResetCounterSet& operator=(const cfc_spmfi_tclMsgResetCounterSet& coRef);
   cfc_spmfi_tclMsgResetCounterSet(const cfc_spmfi_tclMsgResetCounterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ResetCounter;
   virtual ~cfc_spmfi_tclMsgResetCounterSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgResetCounterSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetCounterGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetCounterGet();

   virtual ~cfc_spmfi_tclMsgResetCounterGet();

   inline tBool operator==(const cfc_spmfi_tclMsgResetCounterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetCounterUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetCounterUpReg();

   virtual ~cfc_spmfi_tclMsgResetCounterUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgResetCounterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetCounterRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetCounterRelUpReg();

   virtual ~cfc_spmfi_tclMsgResetCounterRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgResetCounterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetCounterStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetCounterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgResetCounterStatus& operator=(const cfc_spmfi_tclMsgResetCounterStatus& coRef);
   cfc_spmfi_tclMsgResetCounterStatus(const cfc_spmfi_tclMsgResetCounterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclTimeDate tLastResetDate;
   cfc_fi_tcl_e8_LcmResetReason tLastResetReason;
   tU32 u32ApApplicationError;
   tU32 u32ApSoftware;
   tU32 u32ApEcuReset;
   tU32 u32ApDownload;
   tU32 u32ApDownloadError;
   tU32 u32ApOvertemperature;
   tU32 u32ApUser;
   tU32 u32ApLcmIntern;
   tU32 u32ApWarmstartCount;
   tU32 u32ApPowerOnCount;
   tU32 u32ApPowerLossCount;
   tU32 u32ApPowerOffCount;
   tU32 u32ApSccCount;
   tU32 u32ApUnknownCount;
   tU32 u32SccHwWdtCount;
   tU32 u32SccPowerOnCount;
   tU32 u32SccColdstartCount;
   tU32 u32SccAppmodeChangeCount;
   tU32 u32SccDuringLpwCount;
   tU32 u32SccDuringPllOszCount;
   tU32 u32SccDuringSWCount;
   tU32 u32SccWarmstartCount;
   virtual ~cfc_spmfi_tclMsgResetCounterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgResetCounterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgWakeupListSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgWakeupListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgWakeupListSet& operator=(const cfc_spmfi_tclMsgWakeupListSet& coRef);
   cfc_spmfi_tclMsgWakeupListSet(const cfc_spmfi_tclMsgWakeupListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 WakeupList;
   virtual ~cfc_spmfi_tclMsgWakeupListSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgWakeupListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgWakeupListGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgWakeupListGet();

   virtual ~cfc_spmfi_tclMsgWakeupListGet();

   inline tBool operator==(const cfc_spmfi_tclMsgWakeupListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgWakeupListStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgWakeupListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgWakeupListStatus& operator=(const cfc_spmfi_tclMsgWakeupListStatus& coRef);
   cfc_spmfi_tclMsgWakeupListStatus(const cfc_spmfi_tclMsgWakeupListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason1;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason2;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason3;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason4;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason5;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason6;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason7;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason8;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason9;
   cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason10;
   virtual ~cfc_spmfi_tclMsgWakeupListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgWakeupListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgTransportModeListSet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgTransportModeListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgTransportModeListSet& operator=(const cfc_spmfi_tclMsgTransportModeListSet& coRef);
   cfc_spmfi_tclMsgTransportModeListSet(const cfc_spmfi_tclMsgTransportModeListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TransPortList;
   virtual ~cfc_spmfi_tclMsgTransportModeListSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgTransportModeListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgTransportModeListGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgTransportModeListGet();

   virtual ~cfc_spmfi_tclMsgTransportModeListGet();

   inline tBool operator==(const cfc_spmfi_tclMsgTransportModeListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgTransportModeListStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgTransportModeListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgTransportModeListStatus& operator=(const cfc_spmfi_tclMsgTransportModeListStatus& coRef);
   cfc_spmfi_tclMsgTransportModeListStatus(const cfc_spmfi_tclMsgTransportModeListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_TransPortModeList TransportModeList;
   virtual ~cfc_spmfi_tclMsgTransportModeListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgTransportModeListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetHistorySet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetHistorySet();

   virtual ~cfc_spmfi_tclMsgResetHistorySet();

   inline tBool operator==(const cfc_spmfi_tclMsgResetHistorySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetHistoryGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetHistoryGet();

   virtual ~cfc_spmfi_tclMsgResetHistoryGet();

   inline tBool operator==(const cfc_spmfi_tclMsgResetHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgResetHistoryStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgResetHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgResetHistoryStatus& operator=(const cfc_spmfi_tclMsgResetHistoryStatus& coRef);
   cfc_spmfi_tclMsgResetHistoryStatus(const cfc_spmfi_tclMsgResetHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_ResetElement, std::allocator<cfc_fi_tcl_ResetElement> > tResetList;
   virtual ~cfc_spmfi_tclMsgResetHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgResetHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgWakeupHistorySet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgWakeupHistorySet();

   virtual ~cfc_spmfi_tclMsgWakeupHistorySet();

   inline tBool operator==(const cfc_spmfi_tclMsgWakeupHistorySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgWakeupHistoryGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgWakeupHistoryGet();

   virtual ~cfc_spmfi_tclMsgWakeupHistoryGet();

   inline tBool operator==(const cfc_spmfi_tclMsgWakeupHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgWakeupHistoryStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgWakeupHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgWakeupHistoryStatus& operator=(const cfc_spmfi_tclMsgWakeupHistoryStatus& coRef);
   cfc_spmfi_tclMsgWakeupHistoryStatus(const cfc_spmfi_tclMsgWakeupHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_WakeupElement, std::allocator<cfc_fi_tcl_WakeupElement> > tWakeupList;
   virtual ~cfc_spmfi_tclMsgWakeupHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgWakeupHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStateHistorySet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStateHistorySet();

   virtual ~cfc_spmfi_tclMsgStateHistorySet();

   inline tBool operator==(const cfc_spmfi_tclMsgStateHistorySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStateHistoryGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStateHistoryGet();

   virtual ~cfc_spmfi_tclMsgStateHistoryGet();

   inline tBool operator==(const cfc_spmfi_tclMsgStateHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgStateHistoryStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgStateHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgStateHistoryStatus& operator=(const cfc_spmfi_tclMsgStateHistoryStatus& coRef);
   cfc_spmfi_tclMsgStateHistoryStatus(const cfc_spmfi_tclMsgStateHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_StateChangeElement, std::allocator<cfc_fi_tcl_StateChangeElement> > tStateList;
   virtual ~cfc_spmfi_tclMsgStateHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgStateHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory01Set : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory01Set();

   virtual ~cfc_spmfi_tclMsgErrStateHistory01Set();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory01Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory01Get : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory01Get();

   virtual ~cfc_spmfi_tclMsgErrStateHistory01Get();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory01Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory01Status : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory01Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgErrStateHistory01Status& operator=(const cfc_spmfi_tclMsgErrStateHistory01Status& coRef);
   cfc_spmfi_tclMsgErrStateHistory01Status(const cfc_spmfi_tclMsgErrStateHistory01Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_StateChangeElement, std::allocator<cfc_fi_tcl_StateChangeElement> > tStateList;
   virtual ~cfc_spmfi_tclMsgErrStateHistory01Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgErrStateHistory01Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory02Set : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory02Set();

   virtual ~cfc_spmfi_tclMsgErrStateHistory02Set();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory02Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory02Get : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory02Get();

   virtual ~cfc_spmfi_tclMsgErrStateHistory02Get();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory02Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory02Status : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory02Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgErrStateHistory02Status& operator=(const cfc_spmfi_tclMsgErrStateHistory02Status& coRef);
   cfc_spmfi_tclMsgErrStateHistory02Status(const cfc_spmfi_tclMsgErrStateHistory02Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_StateChangeElement, std::allocator<cfc_fi_tcl_StateChangeElement> > tStateList;
   virtual ~cfc_spmfi_tclMsgErrStateHistory02Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgErrStateHistory02Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory03Set : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory03Set();

   virtual ~cfc_spmfi_tclMsgErrStateHistory03Set();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory03Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory03Get : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory03Get();

   virtual ~cfc_spmfi_tclMsgErrStateHistory03Get();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory03Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory03Status : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory03Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgErrStateHistory03Status& operator=(const cfc_spmfi_tclMsgErrStateHistory03Status& coRef);
   cfc_spmfi_tclMsgErrStateHistory03Status(const cfc_spmfi_tclMsgErrStateHistory03Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_StateChangeElement, std::allocator<cfc_fi_tcl_StateChangeElement> > tStateList;
   virtual ~cfc_spmfi_tclMsgErrStateHistory03Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgErrStateHistory03Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory04Set : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory04Set();

   virtual ~cfc_spmfi_tclMsgErrStateHistory04Set();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory04Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory04Get : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory04Get();

   virtual ~cfc_spmfi_tclMsgErrStateHistory04Get();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory04Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory04Status : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory04Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgErrStateHistory04Status& operator=(const cfc_spmfi_tclMsgErrStateHistory04Status& coRef);
   cfc_spmfi_tclMsgErrStateHistory04Status(const cfc_spmfi_tclMsgErrStateHistory04Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_StateChangeElement, std::allocator<cfc_fi_tcl_StateChangeElement> > tStateList;
   virtual ~cfc_spmfi_tclMsgErrStateHistory04Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgErrStateHistory04Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory05Set : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory05Set();

   virtual ~cfc_spmfi_tclMsgErrStateHistory05Set();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory05Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory05Get : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory05Get();

   virtual ~cfc_spmfi_tclMsgErrStateHistory05Get();

   inline tBool operator==(const cfc_spmfi_tclMsgErrStateHistory05Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgErrStateHistory05Status : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgErrStateHistory05Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgErrStateHistory05Status& operator=(const cfc_spmfi_tclMsgErrStateHistory05Status& coRef);
   cfc_spmfi_tclMsgErrStateHistory05Status(const cfc_spmfi_tclMsgErrStateHistory05Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_StateChangeElement, std::allocator<cfc_fi_tcl_StateChangeElement> > tStateList;
   virtual ~cfc_spmfi_tclMsgErrStateHistory05Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgErrStateHistory05Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSwitchOnHistorySet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSwitchOnHistorySet();

   virtual ~cfc_spmfi_tclMsgSwitchOnHistorySet();

   inline tBool operator==(const cfc_spmfi_tclMsgSwitchOnHistorySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSwitchOnHistoryGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSwitchOnHistoryGet();

   virtual ~cfc_spmfi_tclMsgSwitchOnHistoryGet();

   inline tBool operator==(const cfc_spmfi_tclMsgSwitchOnHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgSwitchOnHistoryStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgSwitchOnHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgSwitchOnHistoryStatus& operator=(const cfc_spmfi_tclMsgSwitchOnHistoryStatus& coRef);
   cfc_spmfi_tclMsgSwitchOnHistoryStatus(const cfc_spmfi_tclMsgSwitchOnHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cfc_fi_tcl_SwitchOnElement, std::allocator<cfc_fi_tcl_SwitchOnElement> > tSwitchOnList;
   virtual ~cfc_spmfi_tclMsgSwitchOnHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgSwitchOnHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgVehicleTypeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgVehicleTypeGet();

   virtual ~cfc_spmfi_tclMsgVehicleTypeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgVehicleTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgVehicleTypeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgVehicleTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgVehicleTypeStatus& operator=(const cfc_spmfi_tclMsgVehicleTypeStatus& coRef);
   cfc_spmfi_tclMsgVehicleTypeStatus(const cfc_spmfi_tclMsgVehicleTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 VehicleType;
   virtual ~cfc_spmfi_tclMsgVehicleTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgVehicleTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCsmSignalsGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCsmSignalsGet();

   virtual ~cfc_spmfi_tclMsgCsmSignalsGet();

   inline tBool operator==(const cfc_spmfi_tclMsgCsmSignalsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCsmSignalsStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCsmSignalsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgCsmSignalsStatus& operator=(const cfc_spmfi_tclMsgCsmSignalsStatus& coRef);
   cfc_spmfi_tclMsgCsmSignalsStatus(const cfc_spmfi_tclMsgCsmSignalsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 CsmSignalIgnition;
   tU32 CsmSignalVehicleType;
   tU32 CsmSignalDoorState;
   tU32 CsmSignalLockState;
   tU32 CsmSignalPassengerDoorState;
   tU32 CsmSignalLockStateValid;
   tU32 CsmSignalHmiState;
   virtual ~cfc_spmfi_tclMsgCsmSignalsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgCsmSignalsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCsmSignalsUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCsmSignalsUpReg();

   virtual ~cfc_spmfi_tclMsgCsmSignalsUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCsmSignalsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgCsmSignalsRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgCsmSignalsRelUpReg();

   virtual ~cfc_spmfi_tclMsgCsmSignalsRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgCsmSignalsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgHwSignalsGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgHwSignalsGet();

   virtual ~cfc_spmfi_tclMsgHwSignalsGet();

   inline tBool operator==(const cfc_spmfi_tclMsgHwSignalsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgHwSignalsStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgHwSignalsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgHwSignalsStatus& operator=(const cfc_spmfi_tclMsgHwSignalsStatus& coRef);
   cfc_spmfi_tclMsgHwSignalsStatus(const cfc_spmfi_tclMsgHwSignalsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 HwSignalsIgnition;
   virtual ~cfc_spmfi_tclMsgHwSignalsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgHwSignalsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPersonalizationEnabledUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPersonalizationEnabledUpReg();

   virtual ~cfc_spmfi_tclMsgPersonalizationEnabledUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgPersonalizationEnabledUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg();

   virtual ~cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPersonalizationEnabledGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPersonalizationEnabledGet();

   virtual ~cfc_spmfi_tclMsgPersonalizationEnabledGet();

   inline tBool operator==(const cfc_spmfi_tclMsgPersonalizationEnabledGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgPersonalizationEnabledStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgPersonalizationEnabledStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgPersonalizationEnabledStatus& operator=(const cfc_spmfi_tclMsgPersonalizationEnabledStatus& coRef);
   cfc_spmfi_tclMsgPersonalizationEnabledStatus(const cfc_spmfi_tclMsgPersonalizationEnabledStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool PersonalizationState;
   virtual ~cfc_spmfi_tclMsgPersonalizationEnabledStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgPersonalizationEnabledStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg();

   virtual ~cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg();

   virtual ~cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg();

   inline tBool operator==(const cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgProfileChangeAtRuntimeGet : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgProfileChangeAtRuntimeGet();

   virtual ~cfc_spmfi_tclMsgProfileChangeAtRuntimeGet();

   inline tBool operator==(const cfc_spmfi_tclMsgProfileChangeAtRuntimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus : public cfc_spmfi_tclMsgBaseMessage
{
public:

   cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus& operator=(const cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus& coRef);
   cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus(const cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE ProfileChangeStatus;
   virtual ~cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
