#ifndef __CFC_SPMFIDEBUGVISITOR_H__
#define __CFC_SPMFIDEBUGVISITOR_H__

class MY_DECL cfc_spmfi_tclPrintVisitor : public cfc_spmfi_tclVisitorBase {

private:
   /* default constructor */ cfc_spmfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   cfc_spmfi_tclPrintVisitor(cfc_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(cfc_fi_tclU8& oU8);
   virtual tVoid vVisitS8(cfc_fi_tclS8& oS8);
   virtual tVoid vVisitU16(cfc_fi_tclU16& oU16);
   virtual tVoid vVisitS16(cfc_fi_tclS16& oS16);
   virtual tVoid vVisitU24(cfc_fi_tclU24& oU24);
   virtual tVoid vVisitS24(cfc_fi_tclS24& oS24);
   virtual tVoid vVisitU32(cfc_fi_tclU32& oU32);
   virtual tVoid vVisitS32(cfc_fi_tclS32& oS32);
   virtual tVoid vVisitU64(cfc_fi_tclU64& oU64);
   virtual tVoid vVisitS64(cfc_fi_tclS64& oS64);
   virtual tVoid vVisitBool(cfc_fi_tclBool& oBool);
   virtual tVoid vVisitString(cfc_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(cfc_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(cfc_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpandTimeDate(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_SubState0(cfc_fi_tcl_b32_SubState0& o_b32_SubState0);
   virtual tVoid vVisit_b32_SubState1(cfc_fi_tcl_b32_SubState1& o_b32_SubState1);
   virtual tVoid vVisit_b32_SubState2(cfc_fi_tcl_b32_SubState2& o_b32_SubState2);
   virtual tVoid vVisit_SPM_e32_SubStateType(cfc_fi_tcl_SPM_e32_SubStateType& o_SPM_e32_SubStateType);
   virtual tVoid vVisit_SPM_e32_OnOffReason(cfc_fi_tcl_SPM_e32_OnOffReason& o_SPM_e32_OnOffReason);
   virtual tVoid vVisit_SPM_e32_SYSTEM_STATES(cfc_fi_tcl_SPM_e32_SYSTEM_STATES& o_SPM_e32_SYSTEM_STATES);
   virtual tVoid vVisit_SPM_e32_SYSPWR_BEHAVIOUR(cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR& o_SPM_e32_SYSPWR_BEHAVIOUR);
   virtual tVoid vVisit_SPM_e32_HMI_STATE(cfc_fi_tcl_SPM_e32_HMI_STATE& o_SPM_e32_HMI_STATE);
   virtual tVoid vVisit_SPM_e32_DIM_STATE(cfc_fi_tcl_SPM_e32_DIM_STATE& o_SPM_e32_DIM_STATE);
   virtual tVoid vVisit_SPM_b32_DIM_STATE(cfc_fi_tcl_SPM_b32_DIM_STATE& o_SPM_b32_DIM_STATE);
   virtual tVoid vVisit_SPM_e32_MMGR_STATE(cfc_fi_tcl_SPM_e32_MMGR_STATE& o_SPM_e32_MMGR_STATE);
   virtual tVoid vVisit_SPM_e32_AUDIO_STATE(cfc_fi_tcl_SPM_e32_AUDIO_STATE& o_SPM_e32_AUDIO_STATE);
   virtual tVoid vVisit_SPM_e32_AUDIO_SOURCE(cfc_fi_tcl_SPM_e32_AUDIO_SOURCE& o_SPM_e32_AUDIO_SOURCE);
   virtual tVoid vVisit_SPM_e32_CD_EJECT_STATE(cfc_fi_tcl_SPM_e32_CD_EJECT_STATE& o_SPM_e32_CD_EJECT_STATE);
   virtual tVoid vVisit_SPM_e32_CD_INSERT_STATE(cfc_fi_tcl_SPM_e32_CD_INSERT_STATE& o_SPM_e32_CD_INSERT_STATE);
   virtual tVoid vVisit_SPM_e32_SYS_STATE(cfc_fi_tcl_SPM_e32_SYS_STATE& o_SPM_e32_SYS_STATE);
   virtual tVoid vVisit_SPM_e32_MOST_EVENT(cfc_fi_tcl_SPM_e32_MOST_EVENT& o_SPM_e32_MOST_EVENT);
   virtual tVoid vVisit_SPM_e32_MOST_CONFIG_STATE(cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE& o_SPM_e32_MOST_CONFIG_STATE);
   virtual tVoid vVisit_SPM_e32_TLA_STATE(cfc_fi_tcl_SPM_e32_TLA_STATE& o_SPM_e32_TLA_STATE);
   virtual tVoid vVisit_SPM_e32_PROCESSOR_STATE(cfc_fi_tcl_SPM_e32_PROCESSOR_STATE& o_SPM_e32_PROCESSOR_STATE);
   virtual tVoid vVisit_SPM_e32_STARTUP_STATE(cfc_fi_tcl_SPM_e32_STARTUP_STATE& o_SPM_e32_STARTUP_STATE);
   virtual tVoid vVisit_SPM_e32_RESTART_TYPE(cfc_fi_tcl_SPM_e32_RESTART_TYPE& o_SPM_e32_RESTART_TYPE);
   virtual tVoid vVisit_SPM_e32_CODE_REQUEST(cfc_fi_tcl_SPM_e32_CODE_REQUEST& o_SPM_e32_CODE_REQUEST);
   virtual tVoid vVisit_SPM_e32_PHONE_ABORT_REQUEST(cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST& o_SPM_e32_PHONE_ABORT_REQUEST);
   virtual tVoid vVisit_SPM_e32_WAKEUP_REASON(cfc_fi_tcl_SPM_e32_WAKEUP_REASON& o_SPM_e32_WAKEUP_REASON);
   virtual tVoid vVisit_SPM_e32_MEDIA_EJECT_STATE(cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE& o_SPM_e32_MEDIA_EJECT_STATE);
   virtual tVoid vVisit_SPM_e32_KEY_STATE(cfc_fi_tcl_SPM_e32_KEY_STATE& o_SPM_e32_KEY_STATE);
   virtual tVoid vVisit_SPM_e32_STARTUP_REASON(cfc_fi_tcl_SPM_e32_STARTUP_REASON& o_SPM_e32_STARTUP_REASON);
   virtual tVoid vVisit_SPM_e32_PHONE_MUTE_STATE(cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE& o_SPM_e32_PHONE_MUTE_STATE);
   virtual tVoid vVisit_e8_LcmResetReason(cfc_fi_tcl_e8_LcmResetReason& o_e8_LcmResetReason);
   virtual tVoid vVisit_SPM_e32_CVM_EVENT(cfc_fi_tcl_SPM_e32_CVM_EVENT& o_SPM_e32_CVM_EVENT);
   virtual tVoid vVisit_SPM_e32_CALIBRATED_CVM_EVENT(cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT& o_SPM_e32_CALIBRATED_CVM_EVENT);
   virtual tVoid vVisit_SPM_e32_SYSPWRMODE(cfc_fi_tcl_SPM_e32_SYSPWRMODE& o_SPM_e32_SYSPWRMODE);
   virtual tVoid vVisit_SPM_e8_WAKEUP_LIST_REASON(cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON& o_SPM_e8_WAKEUP_LIST_REASON);
   virtual tVoid vVisit_e8_SPM_MonitoringMode(cfc_fi_tcl_e8_SPM_MonitoringMode& o_e8_SPM_MonitoringMode);
   virtual tVoid vVisit_e8_SPM_SupervisionControl(cfc_fi_tcl_e8_SPM_SupervisionControl& o_e8_SPM_SupervisionControl);
   virtual tBool bDoExpand_SPM_TestRoutineParameter(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_TestRoutineParameterList(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SPM_TestResult(cfc_fi_tcl_e8_SPM_TestResult& o_e8_SPM_TestResult);
   virtual tBool bDoExpand_SPM_TestResult(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_TestResultList(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_TransPortMode(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_TransPortModeList(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_SPM_e32_PERSONALIZATION_PROGRESS_STATE(cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE& o_SPM_e32_PERSONALIZATION_PROGRESS_STATE);
   virtual tVoid vVisit_e8_StateModes(cfc_fi_tcl_e8_StateModes& o_e8_StateModes);
   virtual tVoid vVisit_e8_StateEntryType(cfc_fi_tcl_e8_StateEntryType& o_e8_StateEntryType);
   virtual tBool bDoExpand_SubStateEntry(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ProcessState(cfc_fi_tcl_e8_ProcessState& o_e8_ProcessState);
   virtual tBool bDoExpand_ProcessElement(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_ProcessInfo(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_Vin(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_VinHistory(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ResetElement(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WakeupElement(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateChangeElement(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SwitchOnElement(cfc_spmfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_SPM_e32_START_PROC_TYPE(cfc_fi_tcl_SPM_e32_START_PROC_TYPE& o_SPM_e32_START_PROC_TYPE);
   virtual tVoid vVisit_SPM_b32_SYSPWRSAVEMODE(cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE& o_SPM_b32_SYSPWRSAVEMODE);
   virtual tVoid vVisit_e8_DefSetMode(cfc_fi_tcl_e8_DefSetMode& o_e8_DefSetMode);
   virtual tVoid vVisit_e8_DefSetServiceStatus(cfc_fi_tcl_e8_DefSetServiceStatus& o_e8_DefSetServiceStatus);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   cfc_fi_tclOutput* poOutput;
};


class MY_DECL cfc_spmfi_tclRandomInitVisitor : public cfc_spmfi_tclVisitorBase {
public:

   cfc_spmfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(cfc_fi_tclU8& oU8);
   virtual tVoid vVisitS8(cfc_fi_tclS8& oS8);
   virtual tVoid vVisitU16(cfc_fi_tclU16& oU16);
   virtual tVoid vVisitS16(cfc_fi_tclS16& oS16);
   virtual tVoid vVisitU24(cfc_fi_tclU24& oU24);
   virtual tVoid vVisitS24(cfc_fi_tclS24& oS24);
   virtual tVoid vVisitU32(cfc_fi_tclU32& oU32);
   virtual tVoid vVisitS32(cfc_fi_tclS32& oS32);
   virtual tVoid vVisitU64(cfc_fi_tclU64& oU64);
   virtual tVoid vVisitS64(cfc_fi_tclS64& oS64);
   virtual tVoid vVisitBool(cfc_fi_tclBool& oBool);
   virtual tVoid vVisitString(cfc_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(cfc_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(cfc_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_b32_SubState0(cfc_fi_tcl_b32_SubState0& o_b32_SubState0);
   virtual tVoid vVisit_b32_SubState1(cfc_fi_tcl_b32_SubState1& o_b32_SubState1);
   virtual tVoid vVisit_b32_SubState2(cfc_fi_tcl_b32_SubState2& o_b32_SubState2);
   virtual tVoid vVisit_SPM_e32_SubStateType(cfc_fi_tcl_SPM_e32_SubStateType& o_SPM_e32_SubStateType);
   virtual tVoid vVisit_SPM_e32_OnOffReason(cfc_fi_tcl_SPM_e32_OnOffReason& o_SPM_e32_OnOffReason);
   virtual tVoid vVisit_SPM_e32_SYSTEM_STATES(cfc_fi_tcl_SPM_e32_SYSTEM_STATES& o_SPM_e32_SYSTEM_STATES);
   virtual tVoid vVisit_SPM_e32_SYSPWR_BEHAVIOUR(cfc_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR& o_SPM_e32_SYSPWR_BEHAVIOUR);
   virtual tVoid vVisit_SPM_e32_HMI_STATE(cfc_fi_tcl_SPM_e32_HMI_STATE& o_SPM_e32_HMI_STATE);
   virtual tVoid vVisit_SPM_e32_DIM_STATE(cfc_fi_tcl_SPM_e32_DIM_STATE& o_SPM_e32_DIM_STATE);
   virtual tVoid vVisit_SPM_b32_DIM_STATE(cfc_fi_tcl_SPM_b32_DIM_STATE& o_SPM_b32_DIM_STATE);
   virtual tVoid vVisit_SPM_e32_MMGR_STATE(cfc_fi_tcl_SPM_e32_MMGR_STATE& o_SPM_e32_MMGR_STATE);
   virtual tVoid vVisit_SPM_e32_AUDIO_STATE(cfc_fi_tcl_SPM_e32_AUDIO_STATE& o_SPM_e32_AUDIO_STATE);
   virtual tVoid vVisit_SPM_e32_AUDIO_SOURCE(cfc_fi_tcl_SPM_e32_AUDIO_SOURCE& o_SPM_e32_AUDIO_SOURCE);
   virtual tVoid vVisit_SPM_e32_CD_EJECT_STATE(cfc_fi_tcl_SPM_e32_CD_EJECT_STATE& o_SPM_e32_CD_EJECT_STATE);
   virtual tVoid vVisit_SPM_e32_CD_INSERT_STATE(cfc_fi_tcl_SPM_e32_CD_INSERT_STATE& o_SPM_e32_CD_INSERT_STATE);
   virtual tVoid vVisit_SPM_e32_SYS_STATE(cfc_fi_tcl_SPM_e32_SYS_STATE& o_SPM_e32_SYS_STATE);
   virtual tVoid vVisit_SPM_e32_MOST_EVENT(cfc_fi_tcl_SPM_e32_MOST_EVENT& o_SPM_e32_MOST_EVENT);
   virtual tVoid vVisit_SPM_e32_MOST_CONFIG_STATE(cfc_fi_tcl_SPM_e32_MOST_CONFIG_STATE& o_SPM_e32_MOST_CONFIG_STATE);
   virtual tVoid vVisit_SPM_e32_TLA_STATE(cfc_fi_tcl_SPM_e32_TLA_STATE& o_SPM_e32_TLA_STATE);
   virtual tVoid vVisit_SPM_e32_PROCESSOR_STATE(cfc_fi_tcl_SPM_e32_PROCESSOR_STATE& o_SPM_e32_PROCESSOR_STATE);
   virtual tVoid vVisit_SPM_e32_STARTUP_STATE(cfc_fi_tcl_SPM_e32_STARTUP_STATE& o_SPM_e32_STARTUP_STATE);
   virtual tVoid vVisit_SPM_e32_RESTART_TYPE(cfc_fi_tcl_SPM_e32_RESTART_TYPE& o_SPM_e32_RESTART_TYPE);
   virtual tVoid vVisit_SPM_e32_CODE_REQUEST(cfc_fi_tcl_SPM_e32_CODE_REQUEST& o_SPM_e32_CODE_REQUEST);
   virtual tVoid vVisit_SPM_e32_PHONE_ABORT_REQUEST(cfc_fi_tcl_SPM_e32_PHONE_ABORT_REQUEST& o_SPM_e32_PHONE_ABORT_REQUEST);
   virtual tVoid vVisit_SPM_e32_WAKEUP_REASON(cfc_fi_tcl_SPM_e32_WAKEUP_REASON& o_SPM_e32_WAKEUP_REASON);
   virtual tVoid vVisit_SPM_e32_MEDIA_EJECT_STATE(cfc_fi_tcl_SPM_e32_MEDIA_EJECT_STATE& o_SPM_e32_MEDIA_EJECT_STATE);
   virtual tVoid vVisit_SPM_e32_KEY_STATE(cfc_fi_tcl_SPM_e32_KEY_STATE& o_SPM_e32_KEY_STATE);
   virtual tVoid vVisit_SPM_e32_STARTUP_REASON(cfc_fi_tcl_SPM_e32_STARTUP_REASON& o_SPM_e32_STARTUP_REASON);
   virtual tVoid vVisit_SPM_e32_PHONE_MUTE_STATE(cfc_fi_tcl_SPM_e32_PHONE_MUTE_STATE& o_SPM_e32_PHONE_MUTE_STATE);
   virtual tVoid vVisit_e8_LcmResetReason(cfc_fi_tcl_e8_LcmResetReason& o_e8_LcmResetReason);
   virtual tVoid vVisit_SPM_e32_CVM_EVENT(cfc_fi_tcl_SPM_e32_CVM_EVENT& o_SPM_e32_CVM_EVENT);
   virtual tVoid vVisit_SPM_e32_CALIBRATED_CVM_EVENT(cfc_fi_tcl_SPM_e32_CALIBRATED_CVM_EVENT& o_SPM_e32_CALIBRATED_CVM_EVENT);
   virtual tVoid vVisit_SPM_e32_SYSPWRMODE(cfc_fi_tcl_SPM_e32_SYSPWRMODE& o_SPM_e32_SYSPWRMODE);
   virtual tVoid vVisit_SPM_e8_WAKEUP_LIST_REASON(cfc_fi_tcl_SPM_e8_WAKEUP_LIST_REASON& o_SPM_e8_WAKEUP_LIST_REASON);
   virtual tVoid vVisit_e8_SPM_MonitoringMode(cfc_fi_tcl_e8_SPM_MonitoringMode& o_e8_SPM_MonitoringMode);
   virtual tVoid vVisit_e8_SPM_SupervisionControl(cfc_fi_tcl_e8_SPM_SupervisionControl& o_e8_SPM_SupervisionControl);
   virtual tVoid vVisit_e8_SPM_TestResult(cfc_fi_tcl_e8_SPM_TestResult& o_e8_SPM_TestResult);
   virtual tVoid vVisit_SPM_e32_PERSONALIZATION_PROGRESS_STATE(cfc_fi_tcl_SPM_e32_PERSONALIZATION_PROGRESS_STATE& o_SPM_e32_PERSONALIZATION_PROGRESS_STATE);
   virtual tVoid vVisit_e8_StateModes(cfc_fi_tcl_e8_StateModes& o_e8_StateModes);
   virtual tVoid vVisit_e8_StateEntryType(cfc_fi_tcl_e8_StateEntryType& o_e8_StateEntryType);
   virtual tVoid vVisit_e8_ProcessState(cfc_fi_tcl_e8_ProcessState& o_e8_ProcessState);
   virtual tVoid vVisit_SPM_e32_START_PROC_TYPE(cfc_fi_tcl_SPM_e32_START_PROC_TYPE& o_SPM_e32_START_PROC_TYPE);
   virtual tVoid vVisit_SPM_b32_SYSPWRSAVEMODE(cfc_fi_tcl_SPM_b32_SYSPWRSAVEMODE& o_SPM_b32_SYSPWRSAVEMODE);
   virtual tVoid vVisit_e8_DefSetMode(cfc_fi_tcl_e8_DefSetMode& o_e8_DefSetMode);
   virtual tVoid vVisit_e8_DefSetServiceStatus(cfc_fi_tcl_e8_DefSetServiceStatus& o_e8_DefSetServiceStatus);
	tU32 u32ListSize;
};

#endif
