/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef AUX_MAINFITYPES_HEADER
#define AUX_MAINFITYPES_HEADER


class aux_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for aux_main_fi message types

fi_tclMessageBase* aux_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class aux_mainfi_tclMsgBaseMessage : public aux_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   aux_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class aux_mainfi_tclMsgAvailibilityUpReg : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgAvailibilityUpReg();

   virtual ~aux_mainfi_tclMsgAvailibilityUpReg();

   inline tBool operator==(const aux_mainfi_tclMsgAvailibilityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class aux_mainfi_tclMsgAvailibilityRelUpReg : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgAvailibilityRelUpReg();

   virtual ~aux_mainfi_tclMsgAvailibilityRelUpReg();

   inline tBool operator==(const aux_mainfi_tclMsgAvailibilityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class aux_mainfi_tclMsgAvailibilitySet : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgAvailibilitySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   aux_mainfi_tclMsgAvailibilitySet& operator=(const aux_mainfi_tclMsgAvailibilitySet& coRef);
   aux_mainfi_tclMsgAvailibilitySet(const aux_mainfi_tclMsgAvailibilitySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 enAUXNumber;
   aux_fi_tcl_e8_AUXAvailabilityState enAUXAvailState;
   virtual ~aux_mainfi_tclMsgAvailibilitySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const aux_mainfi_tclMsgAvailibilitySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class aux_mainfi_tclMsgAvailibilityGet : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgAvailibilityGet();

   virtual ~aux_mainfi_tclMsgAvailibilityGet();

   inline tBool operator==(const aux_mainfi_tclMsgAvailibilityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class aux_mainfi_tclMsgAvailibilityStatus : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgAvailibilityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   aux_mainfi_tclMsgAvailibilityStatus& operator=(const aux_mainfi_tclMsgAvailibilityStatus& coRef);
   aux_mainfi_tclMsgAvailibilityStatus(const aux_mainfi_tclMsgAvailibilityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   aux_fi_tcl_AUX_States oStates;
   virtual ~aux_mainfi_tclMsgAvailibilityStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const aux_mainfi_tclMsgAvailibilityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class aux_mainfi_tclMsgConnectionStateUpReg : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgConnectionStateUpReg();

   virtual ~aux_mainfi_tclMsgConnectionStateUpReg();

   inline tBool operator==(const aux_mainfi_tclMsgConnectionStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class aux_mainfi_tclMsgConnectionStateRelUpReg : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgConnectionStateRelUpReg();

   virtual ~aux_mainfi_tclMsgConnectionStateRelUpReg();

   inline tBool operator==(const aux_mainfi_tclMsgConnectionStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class aux_mainfi_tclMsgConnectionStateGet : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgConnectionStateGet();

   virtual ~aux_mainfi_tclMsgConnectionStateGet();

   inline tBool operator==(const aux_mainfi_tclMsgConnectionStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class aux_mainfi_tclMsgConnectionStateStatus : public aux_mainfi_tclMsgBaseMessage
{
public:

   aux_mainfi_tclMsgConnectionStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   aux_mainfi_tclMsgConnectionStateStatus& operator=(const aux_mainfi_tclMsgConnectionStateStatus& coRef);
   aux_mainfi_tclMsgConnectionStateStatus(const aux_mainfi_tclMsgConnectionStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   aux_fi_tcl_AUX_States oStates;
   virtual ~aux_mainfi_tclMsgConnectionStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const aux_mainfi_tclMsgConnectionStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
