#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_STDVISITORS
#include "aux_fi_if.h"

tBool aux_mainfi_tclDescription::bInitMessage(aux_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case aux_mainfi_tclToken::EN_LAST_TOKEN:
   case aux_mainfi_tclToken::EN_LIST:
   case aux_mainfi_tclToken::EN_END_OF_STRUCT:
   case aux_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYSET:
   {
      bResult = oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_E8_AUXAVAILABILITYSTATE,aux_mainfi_tclSemanticDomain::EN_MSG_ENAUXAVAILSTATE)) && bResult;
      bResult = oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_U8,aux_mainfi_tclSemanticDomain::EN_MSG_ENAUXNUMBER)) && bResult;
   } break;
   case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYSTATUS:
   {
      bResult = oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_AUX_STATES,aux_mainfi_tclSemanticDomain::EN_MSG_OSTATES)) && bResult;
   } break;
   case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATESTATUS:
   {
      bResult = oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_AUX_STATES,aux_mainfi_tclSemanticDomain::EN_MSG_OSTATES)) && bResult;
   } break;
   case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYUPREG:
   case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYRELUPREG:
   case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYGET:
   case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATEUPREG:
   case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATERELUPREG:
   case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATEGET:
   case aux_mainfi_tclToken::EN_BINCONTAINER:
   case aux_mainfi_tclToken::EN_E8_AUXAVAILABILITYSTATE:
   case aux_mainfi_tclToken::EN_E8_AUXCONNECTIONSTATE:
   case aux_mainfi_tclToken::EN_E8_AUXSWITCHSTATE:
   case aux_mainfi_tclToken::EN_AUX_STATE:
   case aux_mainfi_tclToken::EN_AUX_STATES:
   case aux_mainfi_tclToken::EN_U8:   
   case aux_mainfi_tclToken::EN_S8:   
   case aux_mainfi_tclToken::EN_U16:   
   case aux_mainfi_tclToken::EN_S16:   
   case aux_mainfi_tclToken::EN_U24:   
   case aux_mainfi_tclToken::EN_S24:   
   case aux_mainfi_tclToken::EN_U32:   
   case aux_mainfi_tclToken::EN_S32:   
   case aux_mainfi_tclToken::EN_U64:   
   case aux_mainfi_tclToken::EN_S64:   
   case aux_mainfi_tclToken::EN_F32:   
   case aux_mainfi_tclToken::EN_F64:   
   case aux_mainfi_tclToken::EN_BOOL:   
   case aux_mainfi_tclToken::EN_STRING:   
   case aux_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(enMsgToken,aux_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool aux_mainfi_tclDescription::bDoIt(aux_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool aux_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      aux_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      aux_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      aux_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == aux_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(aux_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case aux_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == aux_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_LIST: 
      {
         aux_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            aux_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            aux_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case aux_mainfi_tclToken::EN_U8: 
      {
         aux_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case aux_mainfi_tclToken::EN_U16: 
      {
         aux_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_U24: 
      {
         aux_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_U32: 
      {
         aux_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_U64: 
      {
         aux_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_S8: 
      {
         aux_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_S16: 
      {
         aux_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_S24: 
      {
         aux_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_S32: 
      {
         aux_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_S64: 
      {
         aux_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_F32: 
      {
         aux_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_F64: 
      {
         aux_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_BOOL: 
      {
         aux_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_STRING: 
      {
         aux_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         aux_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYUPREG:
      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYRELUPREG:
      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYSET:
      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYGET:
      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYSTATUS:
      case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATEUPREG:
      case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATERELUPREG:
      case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATEGET:
      case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case aux_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_END_OF_STRUCT,aux_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_U8,aux_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_LIST,aux_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         aux_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case aux_mainfi_tclToken::EN_E8_AUXAVAILABILITYSTATE:
      {
         aux_fi_tcl_e8_AUXAvailabilityState o_e8_AUXAvailabilityState;
         if (!bDoIt(o_e8_AUXAvailabilityState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_E8_AUXCONNECTIONSTATE:
      {
         aux_fi_tcl_e8_AUXConnectionState o_e8_AUXConnectionState;
         if (!bDoIt(o_e8_AUXConnectionState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_E8_AUXSWITCHSTATE:
      {
         aux_fi_tcl_e8_AUXSwitchState o_e8_AUXSwitchState;
         if (!bDoIt(o_e8_AUXSwitchState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case aux_mainfi_tclToken::EN_AUX_STATE:
      {
      if (poVisitor->bDoExpand_AUX_State(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_END_OF_STRUCT,aux_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_E8_AUXCONNECTIONSTATE,aux_mainfi_tclSemanticDomain::EN_EAUXCONSTATE));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_E8_AUXSWITCHSTATE,aux_mainfi_tclSemanticDomain::EN_EAUXSWITCHSTATE));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_E8_AUXAVAILABILITYSTATE,aux_mainfi_tclSemanticDomain::EN_EAUXAVAILSTATE));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_U8,aux_mainfi_tclSemanticDomain::EN_U8AUXNUMBER));
      }
      else
      {
         aux_fi_tcl_AUX_State o_AUX_State;
         if (!bDoIt(o_AUX_State))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AUX_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AUX_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case aux_mainfi_tclToken::EN_AUX_STATES:
      {
      if (poVisitor->bDoExpand_AUX_States(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_END_OF_STRUCT,aux_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_AUX_STATE,aux_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_LIST,aux_mainfi_tclSemanticDomain::EN_OITEMS));
         (tVoid) oPath.bGoDown(aux_mainfi_tclKnot(aux_mainfi_tclToken::EN_U8,aux_mainfi_tclSemanticDomain::EN_U8COUNT));
      }
      else
      {
         aux_fi_tcl_AUX_States o_AUX_States;
         if (!bDoIt(o_AUX_States))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AUX_States.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AUX_States.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case aux_mainfi_tclToken::EN_UNKNOWN:
      case aux_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

