/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "swuhmi/swuhmiapp.h"
#include "swuhmi/swuhmicomponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "swuhmiapp" isn't clear, then there should be a description here.
 */

namespace swuhmi {

DEFINE_LOGGER_AND_LEVEL (_logger, "/swuhmi/swuhmiapp", Info);

/* static */ const char* swuhmiapp::swuhmiclient = "swuhmiclient";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool Swuhmiapp_enabledASFSignalHandler = false;

void importSwuhmiapp() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach Swuhmiapp, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'ThreadHmiClient'

    ::asf::core::ComponentContainerSharedPtr ThreadHmiClient(new ::asf::core::ComponentContainer("ThreadHmiClient", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ThreadHmiClient);

        // Component 'swuhmicomponent swuhmiclient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::swuhmi::swuhmicomponent > > swuhmiclientFactory(new ::asf::core::ComponentFactory< ::swuhmi::swuhmicomponent >);
        ::asf::core::ComponentDescriptionSharedPtr swuhmiclientDescription(new ::asf::core::ComponentDescription(1, "swuhmiclient", /* immediate = */ true, /* threadBridge = */ false, swuhmiclientFactory));
        ThreadHmiClient->addComponentDescription(swuhmiclientDescription);

            // Port 'fcSwUpdatePort'

            ::asf::core::RequiredPort& swuhmiclient_fcSwUpdatePort = swuhmiclientDescription->addRequiredPort (::asf::core::RequiredPort ("fcswupdatesrv.FcSwUpdateSrv", "fcSwUpdatePort"));
            (void)swuhmiclient_fcSwUpdatePort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& fcSwUpdateService = dbusConnector_->importByName (::std::string("fcswupdate.FcSwUpdateApp"), ::std::string("/org/bosch/cm/ai_sw_update/fcSwUpdateService"));
    fcSwUpdateService.setServiceName("fcswupdatesrv.FcSwUpdateSrv");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (swuhmiclient_fcSwUpdatePort, fcSwUpdateService);


    LOG_INFO_STATIC("Starting application 'swuhmiapp' version 0.1.0");

    app->start();
}

int executeSwuhmiapp(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("swuhmi", "swuhmiapp");
    } else {
        ::asf::core::Logger::setupLogging ("swuhmi", "swuhmiapp", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", Swuhmiapp_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("swuhmi", "swuhmiapp", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create swuhmiapp");

    app->enableExceptionHandler(true);

    importSwuhmiapp();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace swuhmi

int main(int argc, char* argv[]) {
    ::swuhmi::Swuhmiapp_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::swuhmi::executeSwuhmiapp(argc, argv);
}

