/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "ai_sw_update/common/lcm/imp/SwuLcmApplication.h"
#include "ai_sw_update/common/lcm/imp/SwuLcmComponent.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "SwuLcmApplication" isn't clear, then there should be a description here.
 */

namespace ai_sw_update {
namespace common {
namespace lcm {
namespace imp {

DEFINE_LOGGER_AND_LEVEL (_logger, "/ai_sw_update/common/lcm/imp/SwuLcmApplication", Info);

/* static */ const char* SwuLcmApplication::swuLcmComponent = "swuLcmComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool SwuLcmApplication_enabledASFSignalHandler = false;

void importSwuLcmApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach SwuLcmApplication, because no Application is instantiated");

    // Thread 'Thread1'

    ::asf::core::ComponentContainerSharedPtr Thread1(new ::asf::core::ComponentContainer("Thread1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Thread1);

        // Component 'SwuLcmComponent swuLcmComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::ai_sw_update::common::lcm::imp::SwuLcmComponent > > swuLcmComponentFactory(new ::asf::core::ComponentFactory< ::ai_sw_update::common::lcm::imp::SwuLcmComponent >);
        ::asf::core::ComponentDescriptionSharedPtr swuLcmComponentDescription(new ::asf::core::ComponentDescription(1, "swuLcmComponent", /* immediate = */ true, /* threadBridge = */ false, swuLcmComponentFactory));
        Thread1->addComponentDescription(swuLcmComponentDescription);

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& swuLcmComponent_ConsumerPort = swuLcmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)swuLcmComponent_ConsumerPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& swuLcmComponent_LifeCycleConsumerPort = swuLcmComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)swuLcmComponent_LifeCycleConsumerPort; // prevent unused variable warning

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (swuLcmComponent_ConsumerPort, LcmConsumer);

    // Expression

    dbusSystemConnector_->exportByName (swuLcmComponent_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/SwuLcmApplication"));


    LOG_INFO_STATIC("Starting application 'SwuLcmApplication' version 0.1.0");

    app->start();
}

int executeSwuLcmApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("ai_sw_update.common.lcm.imp", "SwuLcmApplication");
    } else {
        ::asf::core::Logger::setupLogging ("ai_sw_update.common.lcm.imp", "SwuLcmApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", SwuLcmApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("ai_sw_update.common.lcm.imp", "SwuLcmApplication", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create SwuLcmApplication");

    app->enableExceptionHandler(true);

    importSwuLcmApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace imp
} // namespace lcm
} // namespace common
} // namespace ai_sw_update

int main(int argc, char* argv[]) {
    ::ai_sw_update::common::lcm::imp::SwuLcmApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::ai_sw_update::common::lcm::imp::executeSwuLcmApplication(argc, argv);
}

