/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "ai_sw_update/common/core/imp/SWUCoreService.h"
#include "ai_sw_update/common/core/imp/SWUCoreServiceDBus.h"
#include "ai_sw_update/common/core/imp/SWUCoreServiceJson.h"
#include "ai_sw_update/common/core/imp/SWUCoreServiceProxy.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace ai_sw_update {
namespace common {
namespace core {
namespace imp {
namespace SWUCoreService {

DEFINE_CLASS_LOGGER("/ai_sw_update/common/core/imp/ai_sw_update/common/core/imp/SWUCoreService", SWUCoreServiceProxy);

class SWUCoreServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SWUCoreServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SWUCoreServiceProxy >& proxyShared = ::boost::static_pointer_cast< SWUCoreServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_StartInstallResponse:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartInstallResponseSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartInstallResponse", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<StartInstallResponseSignal> payload = ::boost::static_pointer_cast<StartInstallResponseSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((StartInstallResponseCallbackIF*) _callback)->onStartInstallResponseSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Progress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProgressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Progress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProgressError> payload = ::boost::static_pointer_cast<ProgressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProgressCallbackIF*) _callback)->onProgressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProgressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Progress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProgressUpdate> payload = ::boost::static_pointer_cast<ProgressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProgressCallbackIF*) _callback)->onProgressUpdate(proxyShared, payload);
                        proxyShared->_progress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UsbFound:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UsbFoundError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UsbFound", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UsbFoundError> payload = ::boost::static_pointer_cast<UsbFoundError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UsbFoundCallbackIF*) _callback)->onUsbFoundError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UsbFoundUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UsbFound", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UsbFoundUpdate> payload = ::boost::static_pointer_cast<UsbFoundUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UsbFoundCallbackIF*) _callback)->onUsbFoundUpdate(proxyShared, payload);
                        proxyShared->_usbFound = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DisplayText:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayTextError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DisplayText", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayTextError> payload = ::boost::static_pointer_cast<DisplayTextError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DisplayTextCallbackIF*) _callback)->onDisplayTextError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayTextUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DisplayText", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayTextUpdate> payload = ::boost::static_pointer_cast<DisplayTextUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DisplayTextCallbackIF*) _callback)->onDisplayTextUpdate(proxyShared, payload);
                        proxyShared->_displayText = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UpdateStates:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateStatesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateStates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateStatesError> payload = ::boost::static_pointer_cast<UpdateStatesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UpdateStatesCallbackIF*) _callback)->onUpdateStatesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateStatesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateStates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateStatesUpdate> payload = ::boost::static_pointer_cast<UpdateStatesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UpdateStatesCallbackIF*) _callback)->onUpdateStatesUpdate(proxyShared, payload);
                        proxyShared->_updateStates = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DisplayBgImage:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayBgImageError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DisplayBgImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayBgImageError> payload = ::boost::static_pointer_cast<DisplayBgImageError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DisplayBgImageCallbackIF*) _callback)->onDisplayBgImageError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayBgImageUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DisplayBgImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayBgImageUpdate> payload = ::boost::static_pointer_cast<DisplayBgImageUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DisplayBgImageCallbackIF*) _callback)->onDisplayBgImageUpdate(proxyShared, payload);
                        proxyShared->_displayBgImage = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_EnterUpdateSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EnterUpdateSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EnterUpdateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnterUpdateSessionError> payload = ::boost::static_pointer_cast<EnterUpdateSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EnterUpdateSessionCallbackIF*) _callback)->onEnterUpdateSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnterUpdateSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EnterUpdateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnterUpdateSessionResponse> payload = ::boost::static_pointer_cast<EnterUpdateSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EnterUpdateSessionCallbackIF*) _callback)->onEnterUpdateSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ExitUpdateSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ExitUpdateSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ExitUpdateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExitUpdateSessionError> payload = ::boost::static_pointer_cast<ExitUpdateSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ExitUpdateSessionCallbackIF*) _callback)->onExitUpdateSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExitUpdateSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ExitUpdateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExitUpdateSessionResponse> payload = ::boost::static_pointer_cast<ExitUpdateSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ExitUpdateSessionCallbackIF*) _callback)->onExitUpdateSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AbortInstall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AbortInstallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbortInstall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AbortInstallError> payload = ::boost::static_pointer_cast<AbortInstallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AbortInstallCallbackIF*) _callback)->onAbortInstallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AbortInstallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbortInstall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AbortInstallResponse> payload = ::boost::static_pointer_cast<AbortInstallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AbortInstallCallbackIF*) _callback)->onAbortInstallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestRecoveryDownload:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestRecoveryDownloadError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestRecoveryDownload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestRecoveryDownloadError> payload = ::boost::static_pointer_cast<RequestRecoveryDownloadError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestRecoveryDownloadCallbackIF*) _callback)->onRequestRecoveryDownloadError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestRecoveryDownloadResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestRecoveryDownload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestRecoveryDownloadResponse> payload = ::boost::static_pointer_cast<RequestRecoveryDownloadResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestRecoveryDownloadCallbackIF*) _callback)->onRequestRecoveryDownloadResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetIsoPath:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetIsoPathError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetIsoPath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetIsoPathError> payload = ::boost::static_pointer_cast<SetIsoPathError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetIsoPathCallbackIF*) _callback)->onSetIsoPathError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetIsoPathResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetIsoPath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetIsoPathResponse> payload = ::boost::static_pointer_cast<SetIsoPathResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetIsoPathCallbackIF*) _callback)->onSetIsoPathResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartInstall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartInstallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartInstall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartInstallError> payload = ::boost::static_pointer_cast<StartInstallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartInstallCallbackIF*) _callback)->onStartInstallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartInstallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartInstall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartInstallResponse> payload = ::boost::static_pointer_cast<StartInstallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartInstallCallbackIF*) _callback)->onStartInstallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ConfigUpdateSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ConfigUpdateSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ConfigUpdateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConfigUpdateSessionError> payload = ::boost::static_pointer_cast<ConfigUpdateSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ConfigUpdateSessionCallbackIF*) _callback)->onConfigUpdateSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfigUpdateSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ConfigUpdateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConfigUpdateSessionResponse> payload = ::boost::static_pointer_cast<ConfigUpdateSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ConfigUpdateSessionCallbackIF*) _callback)->onConfigUpdateSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_StartInstallResponse: {
                ::boost::shared_ptr< StartInstallResponseError > payload = ::boost::shared_ptr< StartInstallResponseError >
                (new StartInstallResponseError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartInstallResponse", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartInstallResponseCallbackIF*) _callback)->onStartInstallResponseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Progress: {
                ::boost::shared_ptr< ProgressError > payload = ::boost::shared_ptr< ProgressError >
                (new ProgressError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Progress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProgressCallbackIF*) _callback)->onProgressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UsbFound: {
                ::boost::shared_ptr< UsbFoundError > payload = ::boost::shared_ptr< UsbFoundError >
                (new UsbFoundError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UsbFound", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UsbFoundCallbackIF*) _callback)->onUsbFoundError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DisplayText: {
                ::boost::shared_ptr< DisplayTextError > payload = ::boost::shared_ptr< DisplayTextError >
                (new DisplayTextError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DisplayText", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisplayTextCallbackIF*) _callback)->onDisplayTextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateStates: {
                ::boost::shared_ptr< UpdateStatesError > payload = ::boost::shared_ptr< UpdateStatesError >
                (new UpdateStatesError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateStates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateStatesCallbackIF*) _callback)->onUpdateStatesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DisplayBgImage: {
                ::boost::shared_ptr< DisplayBgImageError > payload = ::boost::shared_ptr< DisplayBgImageError >
                (new DisplayBgImageError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DisplayBgImage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisplayBgImageCallbackIF*) _callback)->onDisplayBgImageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EnterUpdateSession: {
                ::boost::shared_ptr< EnterUpdateSessionError > payload = ::boost::shared_ptr< EnterUpdateSessionError >
                (new EnterUpdateSessionError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EnterUpdateSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EnterUpdateSessionCallbackIF*) _callback)->onEnterUpdateSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExitUpdateSession: {
                ::boost::shared_ptr< ExitUpdateSessionError > payload = ::boost::shared_ptr< ExitUpdateSessionError >
                (new ExitUpdateSessionError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExitUpdateSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExitUpdateSessionCallbackIF*) _callback)->onExitUpdateSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AbortInstall: {
                ::boost::shared_ptr< AbortInstallError > payload = ::boost::shared_ptr< AbortInstallError >
                (new AbortInstallError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AbortInstall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AbortInstallCallbackIF*) _callback)->onAbortInstallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestRecoveryDownload: {
                ::boost::shared_ptr< RequestRecoveryDownloadError > payload = ::boost::shared_ptr< RequestRecoveryDownloadError >
                (new RequestRecoveryDownloadError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestRecoveryDownload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestRecoveryDownloadCallbackIF*) _callback)->onRequestRecoveryDownloadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetIsoPath: {
                ::boost::shared_ptr< SetIsoPathError > payload = ::boost::shared_ptr< SetIsoPathError >
                (new SetIsoPathError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetIsoPath", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetIsoPathCallbackIF*) _callback)->onSetIsoPathError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartInstall: {
                ::boost::shared_ptr< StartInstallError > payload = ::boost::shared_ptr< StartInstallError >
                (new StartInstallError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartInstall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartInstallCallbackIF*) _callback)->onStartInstallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConfigUpdateSession: {
                ::boost::shared_ptr< ConfigUpdateSessionError > payload = ::boost::shared_ptr< ConfigUpdateSessionError >
                (new ConfigUpdateSessionError(DBUS_ERROR_NO_SERVER, "The DBus service SWUCoreService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConfigUpdateSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SWUCoreServiceProxy> proxyShared = ::boost::static_pointer_cast<SWUCoreServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConfigUpdateSessionCallbackIF*) _callback)->onConfigUpdateSessionError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SWUCoreServiceProxyCallback::_logger (SWUCoreServiceProxy::_logger);

SWUCoreServiceProxy::SWUCoreServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "ai_sw_update.common.core.imp.SWUCoreService", serviceAvailable, _logger) {
}

SWUCoreServiceProxy::~SWUCoreServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SWUCoreServiceProxy > SWUCoreServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SWUCoreServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SWUCoreServiceProxy > proxyNew(new SWUCoreServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t SWUCoreServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SWUCoreServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SWUCoreServiceProxy::clearAllProperties ()
{
    _progress = ::asf::core::nullable< ProgressUpdate >();
    _usbFound = ::asf::core::nullable< UsbFoundUpdate >();
    _displayText = ::asf::core::nullable< DisplayTextUpdate >();
    _updateStates = ::asf::core::nullable< UpdateStatesUpdate >();
    _displayBgImage = ::asf::core::nullable< DisplayBgImageUpdate >();
}

void SWUCoreServiceProxy::sendDeregisterAll () const
{
    sendProgressDeregisterAll();
    sendUsbFoundDeregisterAll();
    sendDisplayTextDeregisterAll();
    sendUpdateStatesDeregisterAll();
    sendDisplayBgImageDeregisterAll();
    sendStartInstallResponseDeregisterAll();
}

act_t SWUCoreServiceProxy::sendStartInstallResponseRegister(StartInstallResponseCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "StartInstallResponse");
    act_t act = addSignalCallback(ID_StartInstallResponse, "StartInstallResponse", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StartInstallResponse", &cb, act);
    return act;
}

bool SWUCoreServiceProxy::sendStartInstallResponseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StartInstallResponse", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StartInstallResponse", act, static_cast<int>(rv));
    return rv;
}

void SWUCoreServiceProxy::sendStartInstallResponseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StartInstallResponse");
    _dbusProxyDelegate->deregisterSignalCallback("StartInstallResponse", 0, _dbusDaemonProxy.get(), false);
}

act_t SWUCoreServiceProxy::sendProgressRegister(ProgressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Progress, "Progress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Progress", &cb, act);
    return act;
}

bool SWUCoreServiceProxy::sendProgressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Progress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Progress", act, static_cast<int>(rv));
    return rv;
}

act_t SWUCoreServiceProxy::sendProgressGet(ProgressCallbackIF& cb) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_Progress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Progress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Progress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SWUCoreServiceProxy::sendProgressSet(const trProgress& progress) {
    ProgressSet parameter(progress);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Progress");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Progress", propertyContent);
}

act_t SWUCoreServiceProxy::sendProgressSet(ProgressCallbackIF& cb, const trProgress& progress) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_Progress, &cb);
    ProgressSet parameter(progress);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Progress", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Progress", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trProgress& SWUCoreServiceProxy::getProgress() const {
    return _progress.get().getProgress();
}

bool SWUCoreServiceProxy::hasProgress() const {
    return _progress.hasValue();
}

void SWUCoreServiceProxy::sendProgressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Progress");
    _dbusProxyDelegate->deregisterSignalCallback("Progress", 0, _dbusDaemonProxy.get(), true);
}

act_t SWUCoreServiceProxy::sendUsbFoundRegister(UsbFoundCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UsbFound, "UsbFound", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UsbFound", &cb, act);
    return act;
}

bool SWUCoreServiceProxy::sendUsbFoundDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UsbFound", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UsbFound", act, static_cast<int>(rv));
    return rv;
}

act_t SWUCoreServiceProxy::sendUsbFoundGet(UsbFoundCallbackIF& cb) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_UsbFound, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UsbFound", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UsbFound", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SWUCoreServiceProxy::sendUsbFoundSet(const trUsbFound& usbFound) {
    UsbFoundSet parameter(usbFound);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UsbFound");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UsbFound", propertyContent);
}

act_t SWUCoreServiceProxy::sendUsbFoundSet(UsbFoundCallbackIF& cb, const trUsbFound& usbFound) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_UsbFound, &cb);
    UsbFoundSet parameter(usbFound);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UsbFound", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UsbFound", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trUsbFound& SWUCoreServiceProxy::getUsbFound() const {
    return _usbFound.get().getUsbFound();
}

bool SWUCoreServiceProxy::hasUsbFound() const {
    return _usbFound.hasValue();
}

void SWUCoreServiceProxy::sendUsbFoundDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UsbFound");
    _dbusProxyDelegate->deregisterSignalCallback("UsbFound", 0, _dbusDaemonProxy.get(), true);
}

act_t SWUCoreServiceProxy::sendDisplayTextRegister(DisplayTextCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DisplayText, "DisplayText", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DisplayText", &cb, act);
    return act;
}

bool SWUCoreServiceProxy::sendDisplayTextDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DisplayText", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DisplayText", act, static_cast<int>(rv));
    return rv;
}

act_t SWUCoreServiceProxy::sendDisplayTextGet(DisplayTextCallbackIF& cb) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_DisplayText, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DisplayText", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DisplayText", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SWUCoreServiceProxy::sendDisplayTextSet(const trDisplayText& displayText) {
    DisplayTextSet parameter(displayText);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "DisplayText");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DisplayText", propertyContent);
}

act_t SWUCoreServiceProxy::sendDisplayTextSet(DisplayTextCallbackIF& cb, const trDisplayText& displayText) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_DisplayText, &cb);
    DisplayTextSet parameter(displayText);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "DisplayText", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DisplayText", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trDisplayText& SWUCoreServiceProxy::getDisplayText() const {
    return _displayText.get().getDisplayText();
}

bool SWUCoreServiceProxy::hasDisplayText() const {
    return _displayText.hasValue();
}

void SWUCoreServiceProxy::sendDisplayTextDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DisplayText");
    _dbusProxyDelegate->deregisterSignalCallback("DisplayText", 0, _dbusDaemonProxy.get(), true);
}

act_t SWUCoreServiceProxy::sendUpdateStatesRegister(UpdateStatesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UpdateStates, "UpdateStates", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UpdateStates", &cb, act);
    return act;
}

bool SWUCoreServiceProxy::sendUpdateStatesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UpdateStates", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UpdateStates", act, static_cast<int>(rv));
    return rv;
}

act_t SWUCoreServiceProxy::sendUpdateStatesGet(UpdateStatesCallbackIF& cb) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_UpdateStates, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UpdateStates", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UpdateStates", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SWUCoreServiceProxy::sendUpdateStatesSet(const trUpdateStates& updateStates) {
    UpdateStatesSet parameter(updateStates);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UpdateStates");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateStates", propertyContent);
}

act_t SWUCoreServiceProxy::sendUpdateStatesSet(UpdateStatesCallbackIF& cb, const trUpdateStates& updateStates) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_UpdateStates, &cb);
    UpdateStatesSet parameter(updateStates);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UpdateStates", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateStates", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trUpdateStates& SWUCoreServiceProxy::getUpdateStates() const {
    return _updateStates.get().getUpdateStates();
}

bool SWUCoreServiceProxy::hasUpdateStates() const {
    return _updateStates.hasValue();
}

void SWUCoreServiceProxy::sendUpdateStatesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UpdateStates");
    _dbusProxyDelegate->deregisterSignalCallback("UpdateStates", 0, _dbusDaemonProxy.get(), true);
}

act_t SWUCoreServiceProxy::sendDisplayBgImageRegister(DisplayBgImageCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DisplayBgImage, "DisplayBgImage", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DisplayBgImage", &cb, act);
    return act;
}

bool SWUCoreServiceProxy::sendDisplayBgImageDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DisplayBgImage", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DisplayBgImage", act, static_cast<int>(rv));
    return rv;
}

act_t SWUCoreServiceProxy::sendDisplayBgImageGet(DisplayBgImageCallbackIF& cb) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_DisplayBgImage, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DisplayBgImage", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DisplayBgImage", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SWUCoreServiceProxy::sendDisplayBgImageSet(const trDisplayBgImage& displayBgImage) {
    DisplayBgImageSet parameter(displayBgImage);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "DisplayBgImage");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DisplayBgImage", propertyContent);
}

act_t SWUCoreServiceProxy::sendDisplayBgImageSet(DisplayBgImageCallbackIF& cb, const trDisplayBgImage& displayBgImage) {
    SWUCoreServiceProxyCallback* callback = new SWUCoreServiceProxyCallback(ID_DisplayBgImage, &cb);
    DisplayBgImageSet parameter(displayBgImage);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "DisplayBgImage", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DisplayBgImage", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trDisplayBgImage& SWUCoreServiceProxy::getDisplayBgImage() const {
    return _displayBgImage.get().getDisplayBgImage();
}

bool SWUCoreServiceProxy::hasDisplayBgImage() const {
    return _displayBgImage.hasValue();
}

void SWUCoreServiceProxy::sendDisplayBgImageDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DisplayBgImage");
    _dbusProxyDelegate->deregisterSignalCallback("DisplayBgImage", 0, _dbusDaemonProxy.get(), true);
}

act_t SWUCoreServiceProxy::sendEnterUpdateSessionRequest(EnterUpdateSessionCallbackIF& cb) const {
    EnterUpdateSessionRequest* payload = new EnterUpdateSessionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "EnterUpdateSession", EnterUpdateSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_EnterUpdateSession, dbusMessage.getUniqueSerial(), "EnterUpdateSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EnterUpdateSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SWUCoreServiceProxy::sendExitUpdateSessionRequest(ExitUpdateSessionCallbackIF& cb) const {
    ExitUpdateSessionRequest* payload = new ExitUpdateSessionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ExitUpdateSession", ExitUpdateSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_ExitUpdateSession, dbusMessage.getUniqueSerial(), "ExitUpdateSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ExitUpdateSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SWUCoreServiceProxy::sendAbortInstallRequest(AbortInstallCallbackIF& cb, const ::std::string& inModId) const {
    AbortInstallRequest* payload = new AbortInstallRequest();
    CHECK_ALLOCATION(payload);
    payload->setInModId(inModId);
    DBUS_MESSAGE_CALL(dbusMessage, "AbortInstall", AbortInstallRequest, payload, true)
    act_t act = addMethodCallback(ID_AbortInstall, dbusMessage.getUniqueSerial(), "AbortInstall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AbortInstall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SWUCoreServiceProxy::sendRequestRecoveryDownloadRequest(RequestRecoveryDownloadCallbackIF& cb) const {
    RequestRecoveryDownloadRequest* payload = new RequestRecoveryDownloadRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestRecoveryDownload", RequestRecoveryDownloadRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestRecoveryDownload, dbusMessage.getUniqueSerial(), "RequestRecoveryDownload", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestRecoveryDownload", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SWUCoreServiceProxy::sendSetIsoPathRequest(SetIsoPathCallbackIF& cb, const ::std::string& inIsoPath, const trCkSum& rCkSum) const {
    SetIsoPathRequest* payload = new SetIsoPathRequest();
    CHECK_ALLOCATION(payload);
    payload->setInIsoPath(inIsoPath);
    payload->setRCkSum(rCkSum);
    DBUS_MESSAGE_CALL(dbusMessage, "SetIsoPath", SetIsoPathRequest, payload, true)
    act_t act = addMethodCallback(ID_SetIsoPath, dbusMessage.getUniqueSerial(), "SetIsoPath", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetIsoPath", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SWUCoreServiceProxy::sendStartInstallRequest(StartInstallCallbackIF& cb, const ::std::string& inModId, const ::std::string& toolsContainer, const ::std::string& usbLogPath, const trCkSum& toolsCksum, const ::std::string& dataFile, const trCkSum& dataFileDataCksum, const trKeyValuePairs& keyValuePairs) const {
    StartInstallRequest* payload = new StartInstallRequest();
    CHECK_ALLOCATION(payload);
    payload->setInModId(inModId);
    payload->setToolsContainer(toolsContainer);
    payload->setUsbLogPath(usbLogPath);
    payload->setToolsCksum(toolsCksum);
    payload->setDataFile(dataFile);
    payload->setDataFileDataCksum(dataFileDataCksum);
    payload->setKeyValuePairs(keyValuePairs);
    DBUS_MESSAGE_CALL(dbusMessage, "StartInstall", StartInstallRequest, payload, true)
    act_t act = addMethodCallback(ID_StartInstall, dbusMessage.getUniqueSerial(), "StartInstall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartInstall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SWUCoreServiceProxy::sendConfigUpdateSessionRequest(ConfigUpdateSessionCallbackIF& cb, const ::std::vector< ::std::string >& modIds) const {
    ConfigUpdateSessionRequest* payload = new ConfigUpdateSessionRequest();
    CHECK_ALLOCATION(payload);
    payload->setModIds(modIds);
    DBUS_MESSAGE_CALL(dbusMessage, "ConfigUpdateSession", ConfigUpdateSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_ConfigUpdateSession, dbusMessage.getUniqueSerial(), "ConfigUpdateSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ConfigUpdateSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SWUCoreService
} // namespace imp
} // namespace core
} // namespace common
} // namespace ai_sw_update
