/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "ai_sw_update/common/core/imp/SWUCoreApplication.h"
#include "ai_sw_update/common/core/imp/SWUCoreComponent.h"
#include "ai_sw_update/common/core/imp/SWULCMComponent.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "SWUCoreApplication" isn't clear, then there should be a description here.
 */

namespace ai_sw_update {
namespace common {
namespace core {
namespace imp {

DEFINE_LOGGER_AND_LEVEL (_logger, "/ai_sw_update/common/core/imp/SWUCoreApplication", Info);

/* static */ const char* SWUCoreApplication::swuLCM = "swuLCM";
/* static */ const char* SWUCoreApplication::swuCore = "swuCore";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool SWUCoreApplication_enabledASFSignalHandler = false;

void importSWUCoreApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach SWUCoreApplication, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'ThreadSWULCM'

    ::asf::core::ComponentContainerSharedPtr ThreadSWULCM(new ::asf::core::ComponentContainer("ThreadSWULCM", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ThreadSWULCM);

        // Component 'SWULCMComponent swuLCM'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::ai_sw_update::common::core::imp::SWULCMComponent > > swuLCMFactory(new ::asf::core::ComponentFactory< ::ai_sw_update::common::core::imp::SWULCMComponent >);
        ::asf::core::ComponentDescriptionSharedPtr swuLCMDescription(new ::asf::core::ComponentDescription(1, "swuLCM", /* immediate = */ true, /* threadBridge = */ false, swuLCMFactory));
        ThreadSWULCM->addComponentDescription(swuLCMDescription);

    // Thread 'ThreadSWUCore'

    ::asf::core::ComponentContainerSharedPtr ThreadSWUCore(new ::asf::core::ComponentContainer("ThreadSWUCore", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ThreadSWUCore);

        // Component 'SWUCoreComponent swuCore'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::ai_sw_update::common::core::imp::SWUCoreComponent > > swuCoreFactory(new ::asf::core::ComponentFactory< ::ai_sw_update::common::core::imp::SWUCoreComponent >);
        ::asf::core::ComponentDescriptionSharedPtr swuCoreDescription(new ::asf::core::ComponentDescription(2, "swuCore", /* immediate = */ true, /* threadBridge = */ false, swuCoreFactory));
        ThreadSWUCore->addComponentDescription(swuCoreDescription);

            // Port 'SWUCoreServicePort'

            ::asf::core::ProvidedPort& swuCore_SWUCoreServicePort = swuCoreDescription->addProvidedPort (::asf::core::ProvidedPort ("ai_sw_update.common.core.imp.SWUCoreService", "SWUCoreServicePort", false, false));
            (void)swuCore_SWUCoreServicePort; // prevent unused variable warning

    // Expression

    dbusConnector_->exportByName (swuCore_SWUCoreServicePort, ::std::string("/org/bosch/cm/ai_sw_update/SWUCoreService"));


    LOG_INFO_STATIC("Starting application 'SWUCoreApplication' version 0.1.0");

    app->start();
}

int executeSWUCoreApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("ai_sw_update.common.core.imp", "SWUCoreApplication");
    } else {
        ::asf::core::Logger::setupLogging ("ai_sw_update.common.core.imp", "SWUCoreApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", SWUCoreApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("ai_sw_update.common.core.imp", "SWUCoreApplication", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create SWUCoreApplication");

    app->enableExceptionHandler(true);

    importSWUCoreApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace imp
} // namespace core
} // namespace common
} // namespace ai_sw_update

int main(int argc, char* argv[]) {
    ::ai_sw_update::common::core::imp::SWUCoreApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::ai_sw_update::common::core::imp::executeSWUCoreApplication(argc, argv);
}

