/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "location_fi_types.h"
#include "location_fi_typesConst.h"
#include "sensor_location_fiCca.h"
#include "sensor_location_fiJson.h"
#include "sensor_location_fiProxy.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sensor_location_fi {

/*static*/ ::asf::core::Logger Sensor_location_fiProxy::_logger ("/sensor_location_fi/Sensor_location_fiProxy");


class Sensor_location_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sensor_location_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sensor_location_fiProxy> proxy = ::boost::static_pointer_cast<Sensor_location_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_SavePersistent: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::SavePersistentResult);
                                setActAndLogResult(message, "SavePersistent", reinterpret_cast<act_t>(this), _logger);
                                ((SavePersistentCallbackIF*) _callback)->onSavePersistentResult (proxy, ::boost::static_pointer_cast<SavePersistentResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::SavePersistentError);
                                setActAndLogError(message, "SavePersistent", reinterpret_cast<act_t>(this), _logger);
                                ((SavePersistentCallbackIF*) _callback)->onSavePersistentError (proxy, ::boost::static_pointer_cast<SavePersistentError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UpdateDiagLog: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::UpdateDiagLogResult);
                                setActAndLogResult(message, "UpdateDiagLog", reinterpret_cast<act_t>(this), _logger);
                                ((UpdateDiagLogCallbackIF*) _callback)->onUpdateDiagLogResult (proxy, ::boost::static_pointer_cast<UpdateDiagLogResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::UpdateDiagLogError);
                                setActAndLogError(message, "UpdateDiagLog", reinterpret_cast<act_t>(this), _logger);
                                ((UpdateDiagLogCallbackIF*) _callback)->onUpdateDiagLogError (proxy, ::boost::static_pointer_cast<UpdateDiagLogError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FactorySettings: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::FactorySettingsResult);
                                setActAndLogResult(message, "FactorySettings", reinterpret_cast<act_t>(this), _logger);
                                ((FactorySettingsCallbackIF*) _callback)->onFactorySettingsResult (proxy, ::boost::static_pointer_cast<FactorySettingsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::FactorySettingsError);
                                setActAndLogError(message, "FactorySettings", reinterpret_cast<act_t>(this), _logger);
                                ((FactorySettingsCallbackIF*) _callback)->onFactorySettingsError (proxy, ::boost::static_pointer_cast<FactorySettingsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UpdateFactorySettings: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::UpdateFactorySettingsResult);
                                setActAndLogResult(message, "UpdateFactorySettings", reinterpret_cast<act_t>(this), _logger);
                                ((UpdateFactorySettingsCallbackIF*) _callback)->onUpdateFactorySettingsResult (proxy, ::boost::static_pointer_cast<UpdateFactorySettingsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::UpdateFactorySettingsError);
                                setActAndLogError(message, "UpdateFactorySettings", reinterpret_cast<act_t>(this), _logger);
                                ((UpdateFactorySettingsCallbackIF*) _callback)->onUpdateFactorySettingsError (proxy, ::boost::static_pointer_cast<UpdateFactorySettingsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Gyro3dGetHwInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::Gyro3dGetHwInfoResult);
                                setActAndLogResult(message, "Gyro3dGetHwInfo", reinterpret_cast<act_t>(this), _logger);
                                ((Gyro3dGetHwInfoCallbackIF*) _callback)->onGyro3dGetHwInfoResult (proxy, ::boost::static_pointer_cast<Gyro3dGetHwInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::Gyro3dGetHwInfoError);
                                setActAndLogError(message, "Gyro3dGetHwInfo", reinterpret_cast<act_t>(this), _logger);
                                ((Gyro3dGetHwInfoCallbackIF*) _callback)->onGyro3dGetHwInfoError (proxy, ::boost::static_pointer_cast<Gyro3dGetHwInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Acc3dGetHwInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::Acc3dGetHwInfoResult);
                                setActAndLogResult(message, "Acc3dGetHwInfo", reinterpret_cast<act_t>(this), _logger);
                                ((Acc3dGetHwInfoCallbackIF*) _callback)->onAcc3dGetHwInfoResult (proxy, ::boost::static_pointer_cast<Acc3dGetHwInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::Acc3dGetHwInfoError);
                                setActAndLogError(message, "Acc3dGetHwInfo", reinterpret_cast<act_t>(this), _logger);
                                ((Acc3dGetHwInfoCallbackIF*) _callback)->onAcc3dGetHwInfoError (proxy, ::boost::static_pointer_cast<Acc3dGetHwInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GyroSelfTest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GyroSelfTestResult);
                                setActAndLogResult(message, "GyroSelfTest", reinterpret_cast<act_t>(this), _logger);
                                ((GyroSelfTestCallbackIF*) _callback)->onGyroSelfTestResult (proxy, ::boost::static_pointer_cast<GyroSelfTestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GyroSelfTestError);
                                setActAndLogError(message, "GyroSelfTest", reinterpret_cast<act_t>(this), _logger);
                                ((GyroSelfTestCallbackIF*) _callback)->onGyroSelfTestError (proxy, ::boost::static_pointer_cast<GyroSelfTestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AccSelfTest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::AccSelfTestResult);
                                setActAndLogResult(message, "AccSelfTest", reinterpret_cast<act_t>(this), _logger);
                                ((AccSelfTestCallbackIF*) _callback)->onAccSelfTestResult (proxy, ::boost::static_pointer_cast<AccSelfTestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::AccSelfTestError);
                                setActAndLogError(message, "AccSelfTest", reinterpret_cast<act_t>(this), _logger);
                                ((AccSelfTestCallbackIF*) _callback)->onAccSelfTestError (proxy, ::boost::static_pointer_cast<AccSelfTestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_OdometerData_Update: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::OdometerData_UpdateStatus);
                                setActAndLogStatus(message, "OdometerData_Update", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<OdometerData_UpdateStatus> payload = ::boost::static_pointer_cast<OdometerData_UpdateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< OdometerData_UpdateStatus >& refNullableStatus = proxy->_odometerData_Update;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((OdometerData_UpdateCallbackIF*) _callback)->onOdometerData_UpdateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((OdometerData_UpdateCallbackIF*) _callback)->onOdometerData_UpdateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::OdometerData_UpdateError);
                                setActAndLogError(message, "OdometerData_Update", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((OdometerData_UpdateCallbackIF*) _callback)->onOdometerData_UpdateError(proxy, ::boost::static_pointer_cast<OdometerData_UpdateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AbsData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::AbsDataStatus);
                                setActAndLogStatus(message, "AbsData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AbsDataStatus> payload = ::boost::static_pointer_cast<AbsDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AbsDataStatus >& refNullableStatus = proxy->_absData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AbsDataCallbackIF*) _callback)->onAbsDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AbsDataCallbackIF*) _callback)->onAbsDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::AbsDataError);
                                setActAndLogError(message, "AbsData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AbsDataCallbackIF*) _callback)->onAbsDataError(proxy, ::boost::static_pointer_cast<AbsDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Gyro3dData_Update: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::Gyro3dData_UpdateStatus);
                                setActAndLogStatus(message, "Gyro3dData_Update", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Gyro3dData_UpdateStatus> payload = ::boost::static_pointer_cast<Gyro3dData_UpdateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Gyro3dData_UpdateStatus >& refNullableStatus = proxy->_gyro3dData_Update;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Gyro3dData_UpdateCallbackIF*) _callback)->onGyro3dData_UpdateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Gyro3dData_UpdateCallbackIF*) _callback)->onGyro3dData_UpdateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::Gyro3dData_UpdateError);
                                setActAndLogError(message, "Gyro3dData_Update", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Gyro3dData_UpdateCallbackIF*) _callback)->onGyro3dData_UpdateError(proxy, ::boost::static_pointer_cast<Gyro3dData_UpdateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Acc3dData_Update: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::Acc3dData_UpdateStatus);
                                setActAndLogStatus(message, "Acc3dData_Update", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Acc3dData_UpdateStatus> payload = ::boost::static_pointer_cast<Acc3dData_UpdateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Acc3dData_UpdateStatus >& refNullableStatus = proxy->_acc3dData_Update;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Acc3dData_UpdateCallbackIF*) _callback)->onAcc3dData_UpdateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Acc3dData_UpdateCallbackIF*) _callback)->onAcc3dData_UpdateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::Acc3dData_UpdateError);
                                setActAndLogError(message, "Acc3dData_Update", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Acc3dData_UpdateCallbackIF*) _callback)->onAcc3dData_UpdateError(proxy, ::boost::static_pointer_cast<Acc3dData_UpdateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GyroTemperature: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GyroTemperatureStatus);
                                setActAndLogStatus(message, "GyroTemperature", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GyroTemperatureStatus> payload = ::boost::static_pointer_cast<GyroTemperatureStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GyroTemperatureStatus >& refNullableStatus = proxy->_gyroTemperature;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GyroTemperatureCallbackIF*) _callback)->onGyroTemperatureStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((GyroTemperatureCallbackIF*) _callback)->onGyroTemperatureStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GyroTemperatureError);
                                setActAndLogError(message, "GyroTemperature", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((GyroTemperatureCallbackIF*) _callback)->onGyroTemperatureError(proxy, ::boost::static_pointer_cast<GyroTemperatureError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GnssSatSystem: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GnssSatSystemStatus);
                                setActAndLogStatus(message, "GnssSatSystem", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GnssSatSystemStatus> payload = ::boost::static_pointer_cast<GnssSatSystemStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GnssSatSystemStatus >& refNullableStatus = proxy->_gnssSatSystem;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GnssSatSystemCallbackIF*) _callback)->onGnssSatSystemStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GnssSatSystemCallbackIF*) _callback)->onGnssSatSystemStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GnssSatSystemError);
                                setActAndLogError(message, "GnssSatSystem", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GnssSatSystemCallbackIF*) _callback)->onGnssSatSystemError(proxy, ::boost::static_pointer_cast<GnssSatSystemError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GnssWnEpoch: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GnssWnEpochStatus);
                                setActAndLogStatus(message, "GnssWnEpoch", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GnssWnEpochStatus> payload = ::boost::static_pointer_cast<GnssWnEpochStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GnssWnEpochStatus >& refNullableStatus = proxy->_gnssWnEpoch;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GnssWnEpochCallbackIF*) _callback)->onGnssWnEpochStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GnssWnEpochCallbackIF*) _callback)->onGnssWnEpochStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GnssWnEpochError);
                                setActAndLogError(message, "GnssWnEpoch", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GnssWnEpochCallbackIF*) _callback)->onGnssWnEpochError(proxy, ::boost::static_pointer_cast<GnssWnEpochError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GnssConfigData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GnssConfigDataStatus);
                                setActAndLogStatus(message, "GnssConfigData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GnssConfigDataStatus> payload = ::boost::static_pointer_cast<GnssConfigDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GnssConfigDataStatus >& refNullableStatus = proxy->_gnssConfigData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GnssConfigDataCallbackIF*) _callback)->onGnssConfigDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((GnssConfigDataCallbackIF*) _callback)->onGnssConfigDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GnssConfigDataError);
                                setActAndLogError(message, "GnssConfigData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((GnssConfigDataCallbackIF*) _callback)->onGnssConfigDataError(proxy, ::boost::static_pointer_cast<GnssConfigDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GnssData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GnssDataStatus);
                                setActAndLogStatus(message, "GnssData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GnssDataStatus> payload = ::boost::static_pointer_cast<GnssDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GnssDataStatus >& refNullableStatus = proxy->_gnssData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GnssDataCallbackIF*) _callback)->onGnssDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((GnssDataCallbackIF*) _callback)->onGnssDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::GnssDataError);
                                setActAndLogError(message, "GnssData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((GnssDataCallbackIF*) _callback)->onGnssDataError(proxy, ::boost::static_pointer_cast<GnssDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AllSensorData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::AllSensorDataStatus);
                                setActAndLogStatus(message, "AllSensorData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AllSensorDataStatus> payload = ::boost::static_pointer_cast<AllSensorDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AllSensorDataStatus >& refNullableStatus = proxy->_allSensorData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AllSensorDataCallbackIF*) _callback)->onAllSensorDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::AllSensorDataError);
                                setActAndLogError(message, "AllSensorData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AllSensorDataCallbackIF*) _callback)->onAllSensorDataError(proxy, ::boost::static_pointer_cast<AllSensorDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VdsVersionInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::VdsVersionInfoStatus);
                                setActAndLogStatus(message, "VdsVersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VdsVersionInfoStatus> payload = ::boost::static_pointer_cast<VdsVersionInfoStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VdsVersionInfoStatus >& refNullableStatus = proxy->_vdsVersionInfo;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VdsVersionInfoCallbackIF*) _callback)->onVdsVersionInfoStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VdsVersionInfoCallbackIF*) _callback)->onVdsVersionInfoStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::VdsVersionInfoError);
                                setActAndLogError(message, "VdsVersionInfo", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VdsVersionInfoCallbackIF*) _callback)->onVdsVersionInfoError(proxy, ::boost::static_pointer_cast<VdsVersionInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AccTemperature: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::AccTemperatureStatus);
                                setActAndLogStatus(message, "AccTemperature", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AccTemperatureStatus> payload = ::boost::static_pointer_cast<AccTemperatureStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AccTemperatureStatus >& refNullableStatus = proxy->_accTemperature;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AccTemperatureCallbackIF*) _callback)->onAccTemperatureStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AccTemperatureCallbackIF*) _callback)->onAccTemperatureStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::AccTemperatureError);
                                setActAndLogError(message, "AccTemperature", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AccTemperatureCallbackIF*) _callback)->onAccTemperatureError(proxy, ::boost::static_pointer_cast<AccTemperatureError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DiagGnssSatSystem: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::DiagGnssSatSystemStatus);
                                setActAndLogStatus(message, "DiagGnssSatSystem", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DiagGnssSatSystemStatus> payload = ::boost::static_pointer_cast<DiagGnssSatSystemStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DiagGnssSatSystemStatus >& refNullableStatus = proxy->_diagGnssSatSystem;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DiagGnssSatSystemCallbackIF*) _callback)->onDiagGnssSatSystemStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DiagGnssSatSystemCallbackIF*) _callback)->onDiagGnssSatSystemStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sensor_location_fi::DiagGnssSatSystemError);
                                setActAndLogError(message, "DiagGnssSatSystem", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DiagGnssSatSystemCallbackIF*) _callback)->onDiagGnssSatSystemError(proxy, ::boost::static_pointer_cast<DiagGnssSatSystemError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sensor_location_fiProxy> proxy = ::boost::static_pointer_cast<Sensor_location_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_SavePersistent: {
                ::boost::shared_ptr< SavePersistentError > payload (new SavePersistentError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SavePersistent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SavePersistentCallbackIF*) _callback)->onSavePersistentError (proxy, payload);
                return true;
            }
            case FID_UpdateDiagLog: {
                ::boost::shared_ptr< UpdateDiagLogError > payload (new UpdateDiagLogError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateDiagLog", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((UpdateDiagLogCallbackIF*) _callback)->onUpdateDiagLogError (proxy, payload);
                return true;
            }
            case FID_FactorySettings: {
                ::boost::shared_ptr< FactorySettingsError > payload (new FactorySettingsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FactorySettings", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((FactorySettingsCallbackIF*) _callback)->onFactorySettingsError (proxy, payload);
                return true;
            }
            case FID_UpdateFactorySettings: {
                ::boost::shared_ptr< UpdateFactorySettingsError > payload (new UpdateFactorySettingsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateFactorySettings", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((UpdateFactorySettingsCallbackIF*) _callback)->onUpdateFactorySettingsError (proxy, payload);
                return true;
            }
            case FID_Gyro3dGetHwInfo: {
                ::boost::shared_ptr< Gyro3dGetHwInfoError > payload (new Gyro3dGetHwInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Gyro3dGetHwInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((Gyro3dGetHwInfoCallbackIF*) _callback)->onGyro3dGetHwInfoError (proxy, payload);
                return true;
            }
            case FID_Acc3dGetHwInfo: {
                ::boost::shared_ptr< Acc3dGetHwInfoError > payload (new Acc3dGetHwInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Acc3dGetHwInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((Acc3dGetHwInfoCallbackIF*) _callback)->onAcc3dGetHwInfoError (proxy, payload);
                return true;
            }
            case FID_GyroSelfTest: {
                ::boost::shared_ptr< GyroSelfTestError > payload (new GyroSelfTestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GyroSelfTest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GyroSelfTestCallbackIF*) _callback)->onGyroSelfTestError (proxy, payload);
                return true;
            }
            case FID_AccSelfTest: {
                ::boost::shared_ptr< AccSelfTestError > payload (new AccSelfTestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AccSelfTest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AccSelfTestCallbackIF*) _callback)->onAccSelfTestError (proxy, payload);
                return true;
            }
            case FID_OdometerData_Update: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< OdometerData_UpdateError > payload (new OdometerData_UpdateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "OdometerData_Update", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((OdometerData_UpdateCallbackIF*) _callback)->onOdometerData_UpdateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AbsData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AbsDataError > payload (new AbsDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbsData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AbsDataCallbackIF*) _callback)->onAbsDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Gyro3dData_Update: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< Gyro3dData_UpdateError > payload (new Gyro3dData_UpdateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Gyro3dData_Update", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Gyro3dData_UpdateCallbackIF*) _callback)->onGyro3dData_UpdateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Acc3dData_Update: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< Acc3dData_UpdateError > payload (new Acc3dData_UpdateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Acc3dData_Update", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Acc3dData_UpdateCallbackIF*) _callback)->onAcc3dData_UpdateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GyroTemperature: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< GyroTemperatureError > payload (new GyroTemperatureError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GyroTemperature", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GyroTemperatureCallbackIF*) _callback)->onGyroTemperatureError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GnssSatSystem: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< GnssSatSystemError > payload (new GnssSatSystemError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GnssSatSystem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GnssSatSystemCallbackIF*) _callback)->onGnssSatSystemError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GnssWnEpoch: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< GnssWnEpochError > payload (new GnssWnEpochError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GnssWnEpoch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GnssWnEpochCallbackIF*) _callback)->onGnssWnEpochError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GnssConfigData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< GnssConfigDataError > payload (new GnssConfigDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GnssConfigData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GnssConfigDataCallbackIF*) _callback)->onGnssConfigDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GnssData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< GnssDataError > payload (new GnssDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GnssData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GnssDataCallbackIF*) _callback)->onGnssDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AllSensorData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AllSensorDataError > payload (new AllSensorDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AllSensorData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AllSensorDataCallbackIF*) _callback)->onAllSensorDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VdsVersionInfo: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< VdsVersionInfoError > payload (new VdsVersionInfoError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VdsVersionInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VdsVersionInfoCallbackIF*) _callback)->onVdsVersionInfoError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AccTemperature: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AccTemperatureError > payload (new AccTemperatureError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AccTemperature", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AccTemperatureCallbackIF*) _callback)->onAccTemperatureError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DiagGnssSatSystem: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DiagGnssSatSystemError > payload (new DiagGnssSatSystemError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiagGnssSatSystem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DiagGnssSatSystemCallbackIF*) _callback)->onDiagGnssSatSystemError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sensor_location_fiProxyCallback::_logger (Sensor_location_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sensor_location_fiProxy > Sensor_location_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sensor_location_fiProxy >  proxyNew(new Sensor_location_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sensor_location_fiProxy > Sensor_location_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sensor_location_fiProxy >  proxyNew(new Sensor_location_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sensor_location_fiProxy > Sensor_location_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sensor_location_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sensor_location_fiProxy >  proxyNew(new Sensor_location_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sensor_location_fiProxy::Sensor_location_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sensor_location_fiProxy::~Sensor_location_fiProxy()
{
    LOG_INFO ("Entering ~Sensor_location_fiProxy");
    sendRelUpRegAll ();
}

act_t Sensor_location_fiProxy::sendSavePersistentStart(SavePersistentCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SavePersistent);
        ::boost::shared_ptr< SavePersistentStart > payload (new SavePersistentStart());
        CCA_MESSAGE(ccaMessage,header,SavePersistentStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SavePersistent", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SavePersistent);
        ::boost::shared_ptr< SavePersistentError > payload (new SavePersistentError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SavePersistentError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SavePersistent", &cb);
    }
}

act_t Sensor_location_fiProxy::sendUpdateDiagLogStart(UpdateDiagLogCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_UpdateDiagLog);
        ::boost::shared_ptr< UpdateDiagLogStart > payload (new UpdateDiagLogStart());
        CCA_MESSAGE(ccaMessage,header,UpdateDiagLogStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "UpdateDiagLog", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UpdateDiagLog);
        ::boost::shared_ptr< UpdateDiagLogError > payload (new UpdateDiagLogError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UpdateDiagLogError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "UpdateDiagLog", &cb);
    }
}

act_t Sensor_location_fiProxy::sendFactorySettingsStart(FactorySettingsCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_FactorySettings);
        ::boost::shared_ptr< FactorySettingsStart > payload (new FactorySettingsStart());
        CCA_MESSAGE(ccaMessage,header,FactorySettingsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "FactorySettings", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FactorySettings);
        ::boost::shared_ptr< FactorySettingsError > payload (new FactorySettingsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FactorySettingsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "FactorySettings", &cb);
    }
}

act_t Sensor_location_fiProxy::sendUpdateFactorySettingsStart(UpdateFactorySettingsCallbackIF& cb, ::location_fi_types::T_e8_DefSetGroups defSetGroup, ::location_fi_types::T_e8_DefSetMode defSetMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_UpdateFactorySettings);
        ::boost::shared_ptr< UpdateFactorySettingsStart > payload (new UpdateFactorySettingsStart());
        payload->setDefSetGroup(defSetGroup);
        payload->setDefSetMode(defSetMode);
        CCA_MESSAGE(ccaMessage,header,UpdateFactorySettingsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "UpdateFactorySettings", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UpdateFactorySettings);
        ::boost::shared_ptr< UpdateFactorySettingsError > payload (new UpdateFactorySettingsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UpdateFactorySettingsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "UpdateFactorySettings", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGyro3dGetHwInfoStart(Gyro3dGetHwInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Gyro3dGetHwInfo);
        ::boost::shared_ptr< Gyro3dGetHwInfoStart > payload (new Gyro3dGetHwInfoStart());
        CCA_MESSAGE(ccaMessage,header,Gyro3dGetHwInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Gyro3dGetHwInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Gyro3dGetHwInfo);
        ::boost::shared_ptr< Gyro3dGetHwInfoError > payload (new Gyro3dGetHwInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Gyro3dGetHwInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Gyro3dGetHwInfo", &cb);
    }
}

act_t Sensor_location_fiProxy::sendAcc3dGetHwInfoStart(Acc3dGetHwInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Acc3dGetHwInfo);
        ::boost::shared_ptr< Acc3dGetHwInfoStart > payload (new Acc3dGetHwInfoStart());
        CCA_MESSAGE(ccaMessage,header,Acc3dGetHwInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Acc3dGetHwInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Acc3dGetHwInfo);
        ::boost::shared_ptr< Acc3dGetHwInfoError > payload (new Acc3dGetHwInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Acc3dGetHwInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Acc3dGetHwInfo", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGyroSelfTestStart(GyroSelfTestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GyroSelfTest);
        ::boost::shared_ptr< GyroSelfTestStart > payload (new GyroSelfTestStart());
        CCA_MESSAGE(ccaMessage,header,GyroSelfTestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GyroSelfTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GyroSelfTest);
        ::boost::shared_ptr< GyroSelfTestError > payload (new GyroSelfTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GyroSelfTestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GyroSelfTest", &cb);
    }
}

act_t Sensor_location_fiProxy::sendAccSelfTestStart(AccSelfTestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AccSelfTest);
        ::boost::shared_ptr< AccSelfTestStart > payload (new AccSelfTestStart());
        CCA_MESSAGE(ccaMessage,header,AccSelfTestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AccSelfTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AccSelfTest);
        ::boost::shared_ptr< AccSelfTestError > payload (new AccSelfTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AccSelfTestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AccSelfTest", &cb);
    }
}

act_t Sensor_location_fiProxy::sendOdometerData_UpdateUpReg(OdometerData_UpdateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_OdometerData_Update);
        ::boost::shared_ptr< OdometerData_UpdateUpReg > payload (new OdometerData_UpdateUpReg());
        CCA_MESSAGE(ccaMessage,header,OdometerData_UpdateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< OdometerData_UpdateRelUpReg > payloadRelUpRegHeap (new OdometerData_UpdateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_OdometerData_Update, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::OdometerData_UpdateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_OdometerData_Update, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "OdometerData_Update", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "OdometerData_Update", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasOdometerData_Update()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_OdometerData_Update, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< OdometerData_UpdateStatus > payloadLoopback (new OdometerData_UpdateStatus(getOdometerData_Update()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,OdometerData_UpdateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OdometerData_Update);
        ::boost::shared_ptr< OdometerData_UpdateError > payload (new OdometerData_UpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OdometerData_UpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "OdometerData_Update", &cb);
    }
}

bool Sensor_location_fiProxy::sendOdometerData_UpdateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_OdometerData_Update,"OdometerData_Update");
}

void Sensor_location_fiProxy::sendOdometerData_UpdateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_OdometerData_Update);
}

const OdometerData_UpdateStatus& Sensor_location_fiProxy::getOdometerData_Update() const {
    return _odometerData_Update.get();
}

bool Sensor_location_fiProxy::hasOdometerData_Update() const {
    return _odometerData_Update.hasValue();
}

act_t Sensor_location_fiProxy::sendOdometerData_UpdateGet(OdometerData_UpdateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_OdometerData_Update);
        ::boost::shared_ptr< OdometerData_UpdateGet > payload (new OdometerData_UpdateGet());
        CCA_MESSAGE(ccaMessage,header,OdometerData_UpdateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "OdometerData_Update", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OdometerData_Update);
        ::boost::shared_ptr< OdometerData_UpdateError > payload (new OdometerData_UpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OdometerData_UpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "OdometerData_Update", &cb);
    }
}

act_t Sensor_location_fiProxy::sendAbsDataUpReg(AbsDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AbsData);
        ::boost::shared_ptr< AbsDataUpReg > payload (new AbsDataUpReg());
        CCA_MESSAGE(ccaMessage,header,AbsDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AbsDataRelUpReg > payloadRelUpRegHeap (new AbsDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AbsData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::AbsDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AbsData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AbsData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AbsData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAbsData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AbsData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AbsDataStatus > payloadLoopback (new AbsDataStatus(getAbsData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AbsDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AbsData);
        ::boost::shared_ptr< AbsDataError > payload (new AbsDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AbsDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AbsData", &cb);
    }
}

bool Sensor_location_fiProxy::sendAbsDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AbsData,"AbsData");
}

void Sensor_location_fiProxy::sendAbsDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AbsData);
}

const AbsDataStatus& Sensor_location_fiProxy::getAbsData() const {
    return _absData.get();
}

bool Sensor_location_fiProxy::hasAbsData() const {
    return _absData.hasValue();
}

act_t Sensor_location_fiProxy::sendAbsDataGet(AbsDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AbsData);
        ::boost::shared_ptr< AbsDataGet > payload (new AbsDataGet());
        CCA_MESSAGE(ccaMessage,header,AbsDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AbsData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AbsData);
        ::boost::shared_ptr< AbsDataError > payload (new AbsDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AbsDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AbsData", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGyro3dData_UpdateUpReg(Gyro3dData_UpdateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Gyro3dData_Update);
        ::boost::shared_ptr< Gyro3dData_UpdateUpReg > payload (new Gyro3dData_UpdateUpReg());
        CCA_MESSAGE(ccaMessage,header,Gyro3dData_UpdateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Gyro3dData_UpdateRelUpReg > payloadRelUpRegHeap (new Gyro3dData_UpdateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Gyro3dData_Update, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::Gyro3dData_UpdateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Gyro3dData_Update, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Gyro3dData_Update", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Gyro3dData_Update", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGyro3dData_Update()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Gyro3dData_Update, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Gyro3dData_UpdateStatus > payloadLoopback (new Gyro3dData_UpdateStatus(getGyro3dData_Update()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Gyro3dData_UpdateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Gyro3dData_Update);
        ::boost::shared_ptr< Gyro3dData_UpdateError > payload (new Gyro3dData_UpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Gyro3dData_UpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Gyro3dData_Update", &cb);
    }
}

bool Sensor_location_fiProxy::sendGyro3dData_UpdateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Gyro3dData_Update,"Gyro3dData_Update");
}

void Sensor_location_fiProxy::sendGyro3dData_UpdateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Gyro3dData_Update);
}

const Gyro3dData_UpdateStatus& Sensor_location_fiProxy::getGyro3dData_Update() const {
    return _gyro3dData_Update.get();
}

bool Sensor_location_fiProxy::hasGyro3dData_Update() const {
    return _gyro3dData_Update.hasValue();
}

act_t Sensor_location_fiProxy::sendGyro3dData_UpdateGet(Gyro3dData_UpdateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Gyro3dData_Update);
        ::boost::shared_ptr< Gyro3dData_UpdateGet > payload (new Gyro3dData_UpdateGet());
        CCA_MESSAGE(ccaMessage,header,Gyro3dData_UpdateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Gyro3dData_Update", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Gyro3dData_Update);
        ::boost::shared_ptr< Gyro3dData_UpdateError > payload (new Gyro3dData_UpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Gyro3dData_UpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Gyro3dData_Update", &cb);
    }
}

act_t Sensor_location_fiProxy::sendAcc3dData_UpdateUpReg(Acc3dData_UpdateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Acc3dData_Update);
        ::boost::shared_ptr< Acc3dData_UpdateUpReg > payload (new Acc3dData_UpdateUpReg());
        CCA_MESSAGE(ccaMessage,header,Acc3dData_UpdateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Acc3dData_UpdateRelUpReg > payloadRelUpRegHeap (new Acc3dData_UpdateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Acc3dData_Update, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::Acc3dData_UpdateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Acc3dData_Update, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Acc3dData_Update", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Acc3dData_Update", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAcc3dData_Update()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Acc3dData_Update, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Acc3dData_UpdateStatus > payloadLoopback (new Acc3dData_UpdateStatus(getAcc3dData_Update()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Acc3dData_UpdateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Acc3dData_Update);
        ::boost::shared_ptr< Acc3dData_UpdateError > payload (new Acc3dData_UpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Acc3dData_UpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Acc3dData_Update", &cb);
    }
}

bool Sensor_location_fiProxy::sendAcc3dData_UpdateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Acc3dData_Update,"Acc3dData_Update");
}

void Sensor_location_fiProxy::sendAcc3dData_UpdateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Acc3dData_Update);
}

const Acc3dData_UpdateStatus& Sensor_location_fiProxy::getAcc3dData_Update() const {
    return _acc3dData_Update.get();
}

bool Sensor_location_fiProxy::hasAcc3dData_Update() const {
    return _acc3dData_Update.hasValue();
}

act_t Sensor_location_fiProxy::sendAcc3dData_UpdateGet(Acc3dData_UpdateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Acc3dData_Update);
        ::boost::shared_ptr< Acc3dData_UpdateGet > payload (new Acc3dData_UpdateGet());
        CCA_MESSAGE(ccaMessage,header,Acc3dData_UpdateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Acc3dData_Update", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Acc3dData_Update);
        ::boost::shared_ptr< Acc3dData_UpdateError > payload (new Acc3dData_UpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Acc3dData_UpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Acc3dData_Update", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGyroTemperatureUpReg(GyroTemperatureCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GyroTemperature);
        ::boost::shared_ptr< GyroTemperatureUpReg > payload (new GyroTemperatureUpReg());
        CCA_MESSAGE(ccaMessage,header,GyroTemperatureUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GyroTemperatureRelUpReg > payloadRelUpRegHeap (new GyroTemperatureRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GyroTemperature, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::GyroTemperatureRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GyroTemperature, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GyroTemperature", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GyroTemperature", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGyroTemperature()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GyroTemperature, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GyroTemperatureStatus > payloadLoopback (new GyroTemperatureStatus(getGyroTemperature()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GyroTemperatureStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GyroTemperature);
        ::boost::shared_ptr< GyroTemperatureError > payload (new GyroTemperatureError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GyroTemperatureError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GyroTemperature", &cb);
    }
}

bool Sensor_location_fiProxy::sendGyroTemperatureRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GyroTemperature,"GyroTemperature");
}

void Sensor_location_fiProxy::sendGyroTemperatureRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GyroTemperature);
}

const GyroTemperatureStatus& Sensor_location_fiProxy::getGyroTemperature() const {
    return _gyroTemperature.get();
}

bool Sensor_location_fiProxy::hasGyroTemperature() const {
    return _gyroTemperature.hasValue();
}

act_t Sensor_location_fiProxy::sendGyroTemperatureGet(GyroTemperatureCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_GyroTemperature);
        ::boost::shared_ptr< GyroTemperatureGet > payload (new GyroTemperatureGet());
        CCA_MESSAGE(ccaMessage,header,GyroTemperatureGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "GyroTemperature", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GyroTemperature);
        ::boost::shared_ptr< GyroTemperatureError > payload (new GyroTemperatureError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GyroTemperatureError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "GyroTemperature", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGnssSatSystemUpReg(GnssSatSystemCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GnssSatSystem);
        ::boost::shared_ptr< GnssSatSystemUpReg > payload (new GnssSatSystemUpReg());
        CCA_MESSAGE(ccaMessage,header,GnssSatSystemUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GnssSatSystemRelUpReg > payloadRelUpRegHeap (new GnssSatSystemRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GnssSatSystem, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::GnssSatSystemRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GnssSatSystem, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GnssSatSystem", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GnssSatSystem", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGnssSatSystem()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GnssSatSystem, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GnssSatSystemStatus > payloadLoopback (new GnssSatSystemStatus(getGnssSatSystem()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GnssSatSystemStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssSatSystem);
        ::boost::shared_ptr< GnssSatSystemError > payload (new GnssSatSystemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssSatSystemError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GnssSatSystem", &cb);
    }
}

bool Sensor_location_fiProxy::sendGnssSatSystemRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GnssSatSystem,"GnssSatSystem");
}

void Sensor_location_fiProxy::sendGnssSatSystemRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GnssSatSystem);
}

const GnssSatSystemStatus& Sensor_location_fiProxy::getGnssSatSystem() const {
    return _gnssSatSystem.get();
}

bool Sensor_location_fiProxy::hasGnssSatSystem() const {
    return _gnssSatSystem.hasValue();
}

act_t Sensor_location_fiProxy::sendGnssSatSystemGet(GnssSatSystemCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_GnssSatSystem);
        ::boost::shared_ptr< GnssSatSystemGet > payload (new GnssSatSystemGet());
        CCA_MESSAGE(ccaMessage,header,GnssSatSystemGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "GnssSatSystem", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssSatSystem);
        ::boost::shared_ptr< GnssSatSystemError > payload (new GnssSatSystemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssSatSystemError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "GnssSatSystem", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGnssSatSystemSet(GnssSatSystemCallbackIF& cb, const ::location_fi_types::T_b8_GnssSatSys& targetGnssSatSys) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_GnssSatSystem);
        ::boost::shared_ptr< GnssSatSystemSet > payload (new GnssSatSystemSet());
        payload->setTargetGnssSatSys(targetGnssSatSys);
        CCA_MESSAGE(ccaMessage,header,GnssSatSystemSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "GnssSatSystem", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssSatSystem);
        ::boost::shared_ptr< GnssSatSystemError > payload (new GnssSatSystemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssSatSystemError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "GnssSatSystem", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGnssWnEpochUpReg(GnssWnEpochCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GnssWnEpoch);
        ::boost::shared_ptr< GnssWnEpochUpReg > payload (new GnssWnEpochUpReg());
        CCA_MESSAGE(ccaMessage,header,GnssWnEpochUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GnssWnEpochRelUpReg > payloadRelUpRegHeap (new GnssWnEpochRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GnssWnEpoch, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::GnssWnEpochRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GnssWnEpoch, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GnssWnEpoch", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GnssWnEpoch", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGnssWnEpoch()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GnssWnEpoch, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GnssWnEpochStatus > payloadLoopback (new GnssWnEpochStatus(getGnssWnEpoch()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GnssWnEpochStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssWnEpoch);
        ::boost::shared_ptr< GnssWnEpochError > payload (new GnssWnEpochError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssWnEpochError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GnssWnEpoch", &cb);
    }
}

bool Sensor_location_fiProxy::sendGnssWnEpochRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GnssWnEpoch,"GnssWnEpoch");
}

void Sensor_location_fiProxy::sendGnssWnEpochRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GnssWnEpoch);
}

const GnssWnEpochStatus& Sensor_location_fiProxy::getGnssWnEpoch() const {
    return _gnssWnEpoch.get();
}

bool Sensor_location_fiProxy::hasGnssWnEpoch() const {
    return _gnssWnEpoch.hasValue();
}

act_t Sensor_location_fiProxy::sendGnssWnEpochGet(GnssWnEpochCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_GnssWnEpoch);
        ::boost::shared_ptr< GnssWnEpochGet > payload (new GnssWnEpochGet());
        CCA_MESSAGE(ccaMessage,header,GnssWnEpochGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "GnssWnEpoch", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssWnEpoch);
        ::boost::shared_ptr< GnssWnEpochError > payload (new GnssWnEpochError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssWnEpochError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "GnssWnEpoch", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGnssWnEpochSet(GnssWnEpochCallbackIF& cb, const ::location_fi_types::T_TimeDate& targetWnDate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_GnssWnEpoch);
        ::boost::shared_ptr< GnssWnEpochSet > payload (new GnssWnEpochSet());
        payload->setTargetWnDate(targetWnDate);
        CCA_MESSAGE(ccaMessage,header,GnssWnEpochSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "GnssWnEpoch", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssWnEpoch);
        ::boost::shared_ptr< GnssWnEpochError > payload (new GnssWnEpochError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssWnEpochError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "GnssWnEpoch", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGnssConfigDataUpReg(GnssConfigDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GnssConfigData);
        ::boost::shared_ptr< GnssConfigDataUpReg > payload (new GnssConfigDataUpReg());
        CCA_MESSAGE(ccaMessage,header,GnssConfigDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GnssConfigDataRelUpReg > payloadRelUpRegHeap (new GnssConfigDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GnssConfigData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::GnssConfigDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GnssConfigData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GnssConfigData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GnssConfigData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGnssConfigData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GnssConfigData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GnssConfigDataStatus > payloadLoopback (new GnssConfigDataStatus(getGnssConfigData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GnssConfigDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssConfigData);
        ::boost::shared_ptr< GnssConfigDataError > payload (new GnssConfigDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssConfigDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GnssConfigData", &cb);
    }
}

bool Sensor_location_fiProxy::sendGnssConfigDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GnssConfigData,"GnssConfigData");
}

void Sensor_location_fiProxy::sendGnssConfigDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GnssConfigData);
}

const GnssConfigDataStatus& Sensor_location_fiProxy::getGnssConfigData() const {
    return _gnssConfigData.get();
}

bool Sensor_location_fiProxy::hasGnssConfigData() const {
    return _gnssConfigData.hasValue();
}

act_t Sensor_location_fiProxy::sendGnssConfigDataGet(GnssConfigDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_GnssConfigData);
        ::boost::shared_ptr< GnssConfigDataGet > payload (new GnssConfigDataGet());
        CCA_MESSAGE(ccaMessage,header,GnssConfigDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "GnssConfigData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssConfigData);
        ::boost::shared_ptr< GnssConfigDataError > payload (new GnssConfigDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssConfigDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "GnssConfigData", &cb);
    }
}

act_t Sensor_location_fiProxy::sendGnssDataUpReg(GnssDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GnssData);
        ::boost::shared_ptr< GnssDataUpReg > payload (new GnssDataUpReg());
        CCA_MESSAGE(ccaMessage,header,GnssDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GnssDataRelUpReg > payloadRelUpRegHeap (new GnssDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GnssData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::GnssDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GnssData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GnssData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GnssData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGnssData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GnssData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GnssDataStatus > payloadLoopback (new GnssDataStatus(getGnssData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GnssDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssData);
        ::boost::shared_ptr< GnssDataError > payload (new GnssDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GnssData", &cb);
    }
}

bool Sensor_location_fiProxy::sendGnssDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GnssData,"GnssData");
}

void Sensor_location_fiProxy::sendGnssDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GnssData);
}

const GnssDataStatus& Sensor_location_fiProxy::getGnssData() const {
    return _gnssData.get();
}

bool Sensor_location_fiProxy::hasGnssData() const {
    return _gnssData.hasValue();
}

act_t Sensor_location_fiProxy::sendGnssDataGet(GnssDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_GnssData);
        ::boost::shared_ptr< GnssDataGet > payload (new GnssDataGet());
        CCA_MESSAGE(ccaMessage,header,GnssDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "GnssData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GnssData);
        ::boost::shared_ptr< GnssDataError > payload (new GnssDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GnssDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "GnssData", &cb);
    }
}

act_t Sensor_location_fiProxy::sendAllSensorDataUpReg(AllSensorDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AllSensorData);
        ::boost::shared_ptr< AllSensorDataUpReg > payload (new AllSensorDataUpReg());
        CCA_MESSAGE(ccaMessage,header,AllSensorDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AllSensorDataRelUpReg > payloadRelUpRegHeap (new AllSensorDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AllSensorData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::AllSensorDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AllSensorData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AllSensorData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AllSensorData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAllSensorData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AllSensorData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AllSensorDataStatus > payloadLoopback (new AllSensorDataStatus(getAllSensorData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AllSensorDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AllSensorData);
        ::boost::shared_ptr< AllSensorDataError > payload (new AllSensorDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AllSensorDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AllSensorData", &cb);
    }
}

bool Sensor_location_fiProxy::sendAllSensorDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AllSensorData,"AllSensorData");
}

void Sensor_location_fiProxy::sendAllSensorDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AllSensorData);
}

const AllSensorDataStatus& Sensor_location_fiProxy::getAllSensorData() const {
    return _allSensorData.get();
}

bool Sensor_location_fiProxy::hasAllSensorData() const {
    return _allSensorData.hasValue();
}

act_t Sensor_location_fiProxy::sendVdsVersionInfoUpReg(VdsVersionInfoCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_VdsVersionInfo);
        ::boost::shared_ptr< VdsVersionInfoUpReg > payload (new VdsVersionInfoUpReg());
        CCA_MESSAGE(ccaMessage,header,VdsVersionInfoUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VdsVersionInfoRelUpReg > payloadRelUpRegHeap (new VdsVersionInfoRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_VdsVersionInfo, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::VdsVersionInfoRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_VdsVersionInfo, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "VdsVersionInfo", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "VdsVersionInfo", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVdsVersionInfo()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_VdsVersionInfo, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VdsVersionInfoStatus > payloadLoopback (new VdsVersionInfoStatus(getVdsVersionInfo()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VdsVersionInfoStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VdsVersionInfo);
        ::boost::shared_ptr< VdsVersionInfoError > payload (new VdsVersionInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VdsVersionInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "VdsVersionInfo", &cb);
    }
}

bool Sensor_location_fiProxy::sendVdsVersionInfoRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_VdsVersionInfo,"VdsVersionInfo");
}

void Sensor_location_fiProxy::sendVdsVersionInfoRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_VdsVersionInfo);
}

const VdsVersionInfoStatus& Sensor_location_fiProxy::getVdsVersionInfo() const {
    return _vdsVersionInfo.get();
}

bool Sensor_location_fiProxy::hasVdsVersionInfo() const {
    return _vdsVersionInfo.hasValue();
}

act_t Sensor_location_fiProxy::sendVdsVersionInfoGet(VdsVersionInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_VdsVersionInfo);
        ::boost::shared_ptr< VdsVersionInfoGet > payload (new VdsVersionInfoGet());
        CCA_MESSAGE(ccaMessage,header,VdsVersionInfoGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "VdsVersionInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VdsVersionInfo);
        ::boost::shared_ptr< VdsVersionInfoError > payload (new VdsVersionInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VdsVersionInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "VdsVersionInfo", &cb);
    }
}

act_t Sensor_location_fiProxy::sendAccTemperatureUpReg(AccTemperatureCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AccTemperature);
        ::boost::shared_ptr< AccTemperatureUpReg > payload (new AccTemperatureUpReg());
        CCA_MESSAGE(ccaMessage,header,AccTemperatureUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AccTemperatureRelUpReg > payloadRelUpRegHeap (new AccTemperatureRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AccTemperature, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::AccTemperatureRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AccTemperature, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AccTemperature", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AccTemperature", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAccTemperature()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AccTemperature, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AccTemperatureStatus > payloadLoopback (new AccTemperatureStatus(getAccTemperature()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AccTemperatureStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AccTemperature);
        ::boost::shared_ptr< AccTemperatureError > payload (new AccTemperatureError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AccTemperatureError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AccTemperature", &cb);
    }
}

bool Sensor_location_fiProxy::sendAccTemperatureRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AccTemperature,"AccTemperature");
}

void Sensor_location_fiProxy::sendAccTemperatureRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AccTemperature);
}

const AccTemperatureStatus& Sensor_location_fiProxy::getAccTemperature() const {
    return _accTemperature.get();
}

bool Sensor_location_fiProxy::hasAccTemperature() const {
    return _accTemperature.hasValue();
}

act_t Sensor_location_fiProxy::sendAccTemperatureGet(AccTemperatureCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AccTemperature);
        ::boost::shared_ptr< AccTemperatureGet > payload (new AccTemperatureGet());
        CCA_MESSAGE(ccaMessage,header,AccTemperatureGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AccTemperature", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AccTemperature);
        ::boost::shared_ptr< AccTemperatureError > payload (new AccTemperatureError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AccTemperatureError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AccTemperature", &cb);
    }
}

act_t Sensor_location_fiProxy::sendDiagGnssSatSystemUpReg(DiagGnssSatSystemCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DiagGnssSatSystem);
        ::boost::shared_ptr< DiagGnssSatSystemUpReg > payload (new DiagGnssSatSystemUpReg());
        CCA_MESSAGE(ccaMessage,header,DiagGnssSatSystemUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DiagGnssSatSystemRelUpReg > payloadRelUpRegHeap (new DiagGnssSatSystemRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DiagGnssSatSystem, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sensor_location_fi::DiagGnssSatSystemRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DiagGnssSatSystem, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DiagGnssSatSystem", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DiagGnssSatSystem", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDiagGnssSatSystem()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DiagGnssSatSystem, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DiagGnssSatSystemStatus > payloadLoopback (new DiagGnssSatSystemStatus(getDiagGnssSatSystem()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DiagGnssSatSystemStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagGnssSatSystem);
        ::boost::shared_ptr< DiagGnssSatSystemError > payload (new DiagGnssSatSystemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagGnssSatSystemError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DiagGnssSatSystem", &cb);
    }
}

bool Sensor_location_fiProxy::sendDiagGnssSatSystemRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DiagGnssSatSystem,"DiagGnssSatSystem");
}

void Sensor_location_fiProxy::sendDiagGnssSatSystemRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DiagGnssSatSystem);
}

const DiagGnssSatSystemStatus& Sensor_location_fiProxy::getDiagGnssSatSystem() const {
    return _diagGnssSatSystem.get();
}

bool Sensor_location_fiProxy::hasDiagGnssSatSystem() const {
    return _diagGnssSatSystem.hasValue();
}

act_t Sensor_location_fiProxy::sendDiagGnssSatSystemGet(DiagGnssSatSystemCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DiagGnssSatSystem);
        ::boost::shared_ptr< DiagGnssSatSystemGet > payload (new DiagGnssSatSystemGet());
        CCA_MESSAGE(ccaMessage,header,DiagGnssSatSystemGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DiagGnssSatSystem", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagGnssSatSystem);
        ::boost::shared_ptr< DiagGnssSatSystemError > payload (new DiagGnssSatSystemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagGnssSatSystemError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DiagGnssSatSystem", &cb);
    }
}

act_t Sensor_location_fiProxy::sendDiagGnssSatSystemSet(DiagGnssSatSystemCallbackIF& cb, const ::location_fi_types::T_b8_GnssSatSys& targetGnssSatSys) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DiagGnssSatSystem);
        ::boost::shared_ptr< DiagGnssSatSystemSet > payload (new DiagGnssSatSystemSet());
        payload->setTargetGnssSatSys(targetGnssSatSys);
        CCA_MESSAGE(ccaMessage,header,DiagGnssSatSystemSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DiagGnssSatSystem", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagGnssSatSystem);
        ::boost::shared_ptr< DiagGnssSatSystemError > payload (new DiagGnssSatSystemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagGnssSatSystemError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DiagGnssSatSystem", &cb);
    }
}


void Sensor_location_fiProxy::clearAllProperties ()
{
    _odometerData_Update = ::asf::core::nullable<OdometerData_UpdateStatus>();
    _absData = ::asf::core::nullable<AbsDataStatus>();
    _gyro3dData_Update = ::asf::core::nullable<Gyro3dData_UpdateStatus>();
    _acc3dData_Update = ::asf::core::nullable<Acc3dData_UpdateStatus>();
    _gyroTemperature = ::asf::core::nullable<GyroTemperatureStatus>();
    _gnssSatSystem = ::asf::core::nullable<GnssSatSystemStatus>();
    _gnssWnEpoch = ::asf::core::nullable<GnssWnEpochStatus>();
    _gnssConfigData = ::asf::core::nullable<GnssConfigDataStatus>();
    _gnssData = ::asf::core::nullable<GnssDataStatus>();
    _allSensorData = ::asf::core::nullable<AllSensorDataStatus>();
    _vdsVersionInfo = ::asf::core::nullable<VdsVersionInfoStatus>();
    _accTemperature = ::asf::core::nullable<AccTemperatureStatus>();
    _diagGnssSatSystem = ::asf::core::nullable<DiagGnssSatSystemStatus>();
}

void Sensor_location_fiProxy::sendRelUpRegAll()
{
    sendOdometerData_UpdateRelUpRegAll();
    sendAbsDataRelUpRegAll();
    sendGyro3dData_UpdateRelUpRegAll();
    sendAcc3dData_UpdateRelUpRegAll();
    sendGyroTemperatureRelUpRegAll();
    sendGnssSatSystemRelUpRegAll();
    sendGnssWnEpochRelUpRegAll();
    sendGnssConfigDataRelUpRegAll();
    sendGnssDataRelUpRegAll();
    sendAllSensorDataRelUpRegAll();
    sendVdsVersionInfoRelUpRegAll();
    sendAccTemperatureRelUpRegAll();
    sendDiagGnssSatSystemRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sensor_location_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sensor_location_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sensor_location_fi
