#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SENSOR_LOCATION_FI_H
#define SENSOR_LOCATION_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "location_fi_types.h"
#include "location_fi_typesConst.h"
#include "sensor_location_fiConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'sensor_location_fi'
 *
 * Fullname: VD_Sensor Functional Interface
 *
 * Version: v1.2.1
 *
 * Author: Kai Fischer, Andreas Vogel, Joachim Frieï¿½
 *
 * Date: $Date: 06.06.2018$
 *
 * Department:
 *       CM-AI/ECO1
 *
 * Title: SensorFI
 *
 * <b>Description of 'sensor_location_fi':</b>
 *
 * This document serves as an reference for the functional
 * interface of the VD_Sensor (SensorFI).
 */

namespace sensor_location_fi {

static const int SERVICE_ID = 176;

static const int FID_OdometerData_Update = 2;

static const int FID_AbsData = 48;

static const int FID_Gyro3dData_Update = 65;

static const int FID_Acc3dData_Update = 67;

static const int FID_GyroTemperature = 68;

static const int FID_GnssSatSystem = 69;

static const int FID_GnssWnEpoch = 70;

static const int FID_GnssConfigData = 72;

static const int FID_GnssData = 73;

static const int FID_AllSensorData = 75;

static const int FID_VdsVersionInfo = 76;

static const int FID_AccTemperature = 79;

static const int FID_DiagGnssSatSystem = 80;

static const int FID_SavePersistent = 37;

static const int FID_UpdateDiagLog = 47;

static const int FID_FactorySettings = 54;

static const int FID_UpdateFactorySettings = 58;

static const int FID_Gyro3dGetHwInfo = 64;

static const int FID_Acc3dGetHwInfo = 66;

static const int FID_GyroSelfTest = 77;

static const int FID_AccSelfTest = 78;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 2;

static const int VERSION_PATCH = 1;

// forward declarations
class OdometerData_UpdateStatus;

class AbsDataStatus;

class Gyro3dData_UpdateStatus;

class Acc3dData_UpdateStatus;

class GyroTemperatureStatus;

class GyroTemperatureError;

class GnssSatSystemStatus;

class GnssSatSystemSet;

class GnssWnEpochStatus;

class GnssWnEpochSet;

class GnssConfigDataStatus;

class GnssDataStatus;

class AllSensorDataStatus;

class VdsVersionInfoStatus;

class AccTemperatureStatus;

class AccTemperatureError;

class DiagGnssSatSystemStatus;

class DiagGnssSatSystemSet;

class SavePersistentResult;

class SavePersistentError;

class UpdateFactorySettingsStart;

class UpdateFactorySettingsResult;

class Gyro3dGetHwInfoResult;

class Acc3dGetHwInfoResult;

class GyroSelfTestResult;

class GyroSelfTestError;

class AccSelfTestResult;

class AccSelfTestError;

// type definitions
/**
 * The get message of the property "OdometerData_Update"
 * <p>(periodical) odometer-data-messages with a block of odometer values.</p>
 * <p>Attention: starting with version 5.0 the beahavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OdometerData_UpdateGet;

/**
 * The upreg message of the property "OdometerData_Update"
 * <p>(periodical) odometer-data-messages with a block of odometer values.</p>
 * <p>Attention: starting with version 5.0 the beahavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OdometerData_UpdateUpReg;

/**
 * The relUpReg message of the property "OdometerData_Update"
 * <p>(periodical) odometer-data-messages with a block of odometer values.</p>
 * <p>Attention: starting with version 5.0 the beahavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OdometerData_UpdateRelUpReg;

/**
 * The error message of 'OdometerData_Update'
 */
typedef ::asf::cca::CcaTypes::DefaultError OdometerData_UpdateError;

/**
 * The get message of the property "AbsData"
 * <p>Periodically updated ABS data property. Contains a block of ABS
 * data records.</p>
 * <p>Attention: starting with version 5.0 the behavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbsDataGet;

/**
 * The upreg message of the property "AbsData"
 * <p>Periodically updated ABS data property. Contains a block of ABS
 * data records.</p>
 * <p>Attention: starting with version 5.0 the behavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbsDataUpReg;

/**
 * The relUpReg message of the property "AbsData"
 * <p>Periodically updated ABS data property. Contains a block of ABS
 * data records.</p>
 * <p>Attention: starting with version 5.0 the behavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbsDataRelUpReg;

/**
 * The error message of 'AbsData'
 */
typedef ::asf::cca::CcaTypes::DefaultError AbsDataError;

/**
 * The get message of the property "Gyro3dData_Update"
 * List with new 3d-gyro samples.
 * <p>Attention: starting with version 5.0 the behavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Gyro3dData_UpdateGet;

/**
 * The upreg message of the property "Gyro3dData_Update"
 * List with new 3d-gyro samples.
 * <p>Attention: starting with version 5.0 the behavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Gyro3dData_UpdateUpReg;

/**
 * The relUpReg message of the property "Gyro3dData_Update"
 * List with new 3d-gyro samples.
 * <p>Attention: starting with version 5.0 the behavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Gyro3dData_UpdateRelUpReg;

/**
 * The error message of 'Gyro3dData_Update'
 */
typedef ::asf::cca::CcaTypes::DefaultError Gyro3dData_UpdateError;

/**
 * The get message of the property "Acc3dData_Update"
 * List with new 3d-acc sample.
 * <p>Attention: starting with version 5.0 the beahavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Acc3dData_UpdateGet;

/**
 * The upreg message of the property "Acc3dData_Update"
 * List with new 3d-acc sample.
 * <p>Attention: starting with version 5.0 the beahavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Acc3dData_UpdateUpReg;

/**
 * The relUpReg message of the property "Acc3dData_Update"
 * List with new 3d-acc sample.
 * <p>Attention: starting with version 5.0 the beahavior of this property
 * changed. It delivers actual data only.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Acc3dData_UpdateRelUpReg;

/**
 * The error message of 'Acc3dData_Update'
 */
typedef ::asf::cca::CcaTypes::DefaultError Acc3dData_UpdateError;

/**
 * The get message of the property "GyroTemperature"
 * Current temperature measured in or close to the gyro sensor. [K]
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GyroTemperatureGet;

/**
 * The upreg message of the property "GyroTemperature"
 * Current temperature measured in or close to the gyro sensor. [K]
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GyroTemperatureUpReg;

/**
 * The relUpReg message of the property "GyroTemperature"
 * Current temperature measured in or close to the gyro sensor. [K]
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GyroTemperatureRelUpReg;

/**
 * The get message of the property "GnssSatSystem"
 * There are different global navigation satellite systems (GNSS)
 * available. Depending on the characteristics of the applied GNSS
 * receiver and antenna, it's possible to activate multiple systems at a
 * time or choose another system e.g. GLONASS instead of GPS. The
 * activated constellation may be persisted depending on projects
 * configuration.
 * Get the GNSS satellite systems actually used.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssSatSystemGet;

/**
 * The upreg message of the property "GnssSatSystem"
 * There are different global navigation satellite systems (GNSS)
 * available. Depending on the characteristics of the applied GNSS
 * receiver and antenna, it's possible to activate multiple systems at a
 * time or choose another system e.g. GLONASS instead of GPS. The
 * activated constellation may be persisted depending on projects
 * configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssSatSystemUpReg;

/**
 * The relUpReg message of the property "GnssSatSystem"
 * There are different global navigation satellite systems (GNSS)
 * available. Depending on the characteristics of the applied GNSS
 * receiver and antenna, it's possible to activate multiple systems at a
 * time or choose another system e.g. GLONASS instead of GPS. The
 * activated constellation may be persisted depending on projects
 * configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssSatSystemRelUpReg;

/**
 * The error message of 'GnssSatSystem'
 */
typedef ::asf::cca::CcaTypes::DefaultError GnssSatSystemError;

/**
 * The get message of the property "GnssWnEpoch"
 * This property allows to adjust the GPS Epoch. GPS determines the
 * actual year from the weeknumber counter. This counter is a 10bit
 * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
 * general GPS has no means to determine which 20 year block (epoch) is
 * the actual one. In order to select the apropiate epoch, the "set" method
 * is called with a date (day, month and year) from the desired epoch. By
 * setting this date the epoch is [date..date+1024 weeks]
 * Get the actual GPS epoch time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssWnEpochGet;

/**
 * The upreg message of the property "GnssWnEpoch"
 * This property allows to adjust the GPS Epoch. GPS determines the
 * actual year from the weeknumber counter. This counter is a 10bit
 * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
 * general GPS has no means to determine which 20 year block (epoch) is
 * the actual one. In order to select the apropiate epoch, the "set" method
 * is called with a date (day, month and year) from the desired epoch. By
 * setting this date the epoch is [date..date+1024 weeks]
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssWnEpochUpReg;

/**
 * The relUpReg message of the property "GnssWnEpoch"
 * This property allows to adjust the GPS Epoch. GPS determines the
 * actual year from the weeknumber counter. This counter is a 10bit
 * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
 * general GPS has no means to determine which 20 year block (epoch) is
 * the actual one. In order to select the apropiate epoch, the "set" method
 * is called with a date (day, month and year) from the desired epoch. By
 * setting this date the epoch is [date..date+1024 weeks]
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssWnEpochRelUpReg;

/**
 * The error message of 'GnssWnEpoch'
 */
typedef ::asf::cca::CcaTypes::DefaultError GnssWnEpochError;

/**
 * The get message of the property "GnssConfigData"
 * Configuration data of the GNSS receiver
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssConfigDataGet;

/**
 * The upreg message of the property "GnssConfigData"
 * Configuration data of the GNSS receiver
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssConfigDataUpReg;

/**
 * The relUpReg message of the property "GnssConfigData"
 * Configuration data of the GNSS receiver
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssConfigDataRelUpReg;

/**
 * The error message of 'GnssConfigData'
 */
typedef ::asf::cca::CcaTypes::DefaultError GnssConfigDataError;

/**
 * The get message of the property "GnssData"
 * periodical GNSS-data-message
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssDataGet;

/**
 * The upreg message of the property "GnssData"
 * periodical GNSS-data-message
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssDataUpReg;

/**
 * The relUpReg message of the property "GnssData"
 * periodical GNSS-data-message
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GnssDataRelUpReg;

/**
 * The error message of 'GnssData'
 */
typedef ::asf::cca::CcaTypes::DefaultError GnssDataError;

/**
 * The upreg message of the property "AllSensorData"
 * periodical update of all sensor data that are relevant for the
 * position calculation (Ortung). This includes GNSS, odometer, 3D-Gyro
 * and 3D-Acc data. There is no more need to register for the different
 * sensor data separatly. In normal operation every second one of these
 * data blocks get transmitted. In contrast to the dedicated properties
 * for each sensor the "AllSensorData" delivers on UpReg next to the
 * actual data set all available datasets from the buffers.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AllSensorDataUpReg;

/**
 * The relUpReg message of the property "AllSensorData"
 * periodical update of all sensor data that are relevant for the
 * position calculation (Ortung). This includes GNSS, odometer, 3D-Gyro
 * and 3D-Acc data. There is no more need to register for the different
 * sensor data separatly. In normal operation every second one of these
 * data blocks get transmitted. In contrast to the dedicated properties
 * for each sensor the "AllSensorData" delivers on UpReg next to the
 * actual data set all available datasets from the buffers.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AllSensorDataRelUpReg;

/**
 * The error message of 'AllSensorData'
 */
typedef ::asf::cca::CcaTypes::DefaultError AllSensorDataError;

/**
 * The get message of the property "VdsVersionInfo"
 * Gives some information about the Vd_Sensor verion used and about the
 * target it is running on.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VdsVersionInfoGet;

/**
 * The upreg message of the property "VdsVersionInfo"
 * Gives some information about the Vd_Sensor verion used and about the
 * target it is running on.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VdsVersionInfoUpReg;

/**
 * The relUpReg message of the property "VdsVersionInfo"
 * Gives some information about the Vd_Sensor verion used and about the
 * target it is running on.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VdsVersionInfoRelUpReg;

/**
 * The error message of 'VdsVersionInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError VdsVersionInfoError;

/**
 * The get message of the property "AccTemperature"
 * Current temperature measured in or close to the acceleration sensor. [K]
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AccTemperatureGet;

/**
 * The upreg message of the property "AccTemperature"
 * Current temperature measured in or close to the acceleration sensor. [K]
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AccTemperatureUpReg;

/**
 * The relUpReg message of the property "AccTemperature"
 * Current temperature measured in or close to the acceleration sensor. [K]
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AccTemperatureRelUpReg;

/**
 * The get message of the property "DiagGnssSatSystem"
 * This property is similar to the "GnssSatSystem" property. The main
 * difference is that the changes are not persisted and lost after reboot.
 * This is needed e.g. by diagnosis to test the different satellite
 * systems without spoiling the default/factory configuration.
 * Get the GNSS satellite systems actually used.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagGnssSatSystemGet;

/**
 * The upreg message of the property "DiagGnssSatSystem"
 * This property is similar to the "GnssSatSystem" property. The main
 * difference is that the changes are not persisted and lost after reboot.
 * This is needed e.g. by diagnosis to test the different satellite
 * systems without spoiling the default/factory configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagGnssSatSystemUpReg;

/**
 * The relUpReg message of the property "DiagGnssSatSystem"
 * This property is similar to the "GnssSatSystem" property. The main
 * difference is that the changes are not persisted and lost after reboot.
 * This is needed e.g. by diagnosis to test the different satellite
 * systems without spoiling the default/factory configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagGnssSatSystemRelUpReg;

/**
 * The error message of 'DiagGnssSatSystem'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagGnssSatSystemError;

/**
 * The start message of the method "SavePersistent"
 * Causes VD Sensor to save all persistent data to persistent memory
 * immediately. (Normally, this is done when the CCA application state
 * changes.)
 *
 * Rationale: Some OEM customers require settings made in diagnostic mode
 * to be saved persistently immediately.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SavePersistentStart;

/**
 * The abort error message of the method "SavePersistent"
 * Causes VD Sensor to save all persistent data to persistent memory
 * immediately. (Normally, this is done when the CCA application state
 * changes.)
 *
 * Rationale: Some OEM customers require settings made in diagnostic mode
 * to be saved persistently immediately.
 */
typedef ::asf::cca::CcaTypes::DefaultError SavePersistentAbortError;

/**
 * The start message of the method "UpdateDiagLog"
 * Force VD Sensor to send the current error states to VD Diaglog.  The
 * state of both active and inactive error conditions are sent.  This
 * method is meant to be used after the error memory has been reset to
 * reenter the currently active errors.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateDiagLogStart;

/**
 * The result message of the method "UpdateDiagLog"
 * Force VD Sensor to send the current error states to VD Diaglog.  The
 * state of both active and inactive error conditions are sent.  This
 * method is meant to be used after the error memory has been reset to
 * reenter the currently active errors.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateDiagLogResult;

/**
 * The abort error message of the method "UpdateDiagLog"
 * Force VD Sensor to send the current error states to VD Diaglog.  The
 * state of both active and inactive error conditions are sent.  This
 * method is meant to be used after the error memory has been reset to
 * reenter the currently active errors.
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateDiagLogAbortError;

/**
 * The error message of 'UpdateDiagLog'
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateDiagLogError;

/**
 * The start message of the method "FactorySettings"
 * Restore factory settings. This method deletes any persistently stored
 * sensor calibration data and forces a GNSS cold start.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FactorySettingsStart;

/**
 * The result message of the method "FactorySettings"
 * Restore factory settings. This method deletes any persistently stored
 * sensor calibration data and forces a GNSS cold start.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FactorySettingsResult;

/**
 * The abort error message of the method "FactorySettings"
 * Restore factory settings. This method deletes any persistently stored
 * sensor calibration data and forces a GNSS cold start.
 */
typedef ::asf::cca::CcaTypes::DefaultError FactorySettingsAbortError;

/**
 * The error message of 'FactorySettings'
 */
typedef ::asf::cca::CcaTypes::DefaultError FactorySettingsError;

/**
 * The abort error message of the method "UpdateFactorySettings"
 * Restore parts of factory settings. The method updates some parameter
 * for configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateFactorySettingsAbortError;

/**
 * The error message of 'UpdateFactorySettings'
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateFactorySettingsError;

/**
 * The start message of the method "Gyro3dGetHwInfo"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Gyro3dGetHwInfoStart;

/**
 * The abort error message of the method "Gyro3dGetHwInfo"
 */
typedef ::asf::cca::CcaTypes::DefaultError Gyro3dGetHwInfoAbortError;

/**
 * The error message of 'Gyro3dGetHwInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError Gyro3dGetHwInfoError;

/**
 * The start message of the method "Acc3dGetHwInfo"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Acc3dGetHwInfoStart;

/**
 * The abort error message of the method "Acc3dGetHwInfo"
 */
typedef ::asf::cca::CcaTypes::DefaultError Acc3dGetHwInfoAbortError;

/**
 * The error message of 'Acc3dGetHwInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError Acc3dGetHwInfoError;

/**
 * The start message of the method "GyroSelfTest"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GyroSelfTestStart;

/**
 * The abort error message of the method "GyroSelfTest"
 */
typedef ::asf::cca::CcaTypes::DefaultError GyroSelfTestAbortError;

/**
 * The start message of the method "AccSelfTest"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AccSelfTestStart;

/**
 * The abort error message of the method "AccSelfTest"
 */
typedef ::asf::cca::CcaTypes::DefaultError AccSelfTestAbortError;


/**
 * The status message of the property "OdometerData_Update"
 * <p>(periodical) odometer-data-messages with a block of odometer values.</p>
 * <p>Attention: starting with version 5.0 the beahavior of this property
 * changed. It delivers actual data only.</p>
 */
class OdometerData_UpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OdometerData_UpdateStatus ();

    /**
     * Copy constructor
     */
    inline  OdometerData_UpdateStatus (const OdometerData_UpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  OdometerData_UpdateStatus (const ::std::vector< ::location_fi_types::T_OdometerData >& OdometerData_, bool FirstOdomValueIsInitial_);

    /**
     * Destructor
     */
    inline virtual  ~OdometerData_UpdateStatus();

    /**
     * Assignment operator
     */
    inline OdometerData_UpdateStatus& operator = (const OdometerData_UpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OdometerData_UpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OdometerData_UpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OdometerData_UpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OdometerData_UpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OdometerData"

    static const int kOdometerData = 0;

    /**
     * Clears the field "OdometerData".
     *
     * The field will be set to its default value. The hasOdometerData()
     * method will return false.
     */
    inline void clearOdometerData();

    /**
     * Checks whether the field "OdometerData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOdometerData()). Otherwise it will return false.
     */
    inline bool hasOdometerData () const;

    /**
     * Returns the value of the member "OdometerData".
     *
     * OdometerData
     *
     * @return The value of the field "OdometerData"
     */
    inline const ::std::vector< ::location_fi_types::T_OdometerData >& getOdometerData () const;

    /**
     * Retrieves the value of the field "OdometerData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OdometerData".
     */
    inline ::std::vector< ::location_fi_types::T_OdometerData >& getOdometerDataMutable ();

    /**
     * Sets the value of the member "OdometerData".
     *
     * OdometerData
     *
     * @param OdometerData The value which will be set
     */
    inline void setOdometerData (const ::std::vector< ::location_fi_types::T_OdometerData >& OdometerData_);

    // API of field "FirstOdomValueIsInitial"

    static const int kFirstOdomValueIsInitial = 1;

    /**
     * Clears the field "FirstOdomValueIsInitial".
     *
     * The field will be set to its default value. The hasFirstOdomValueIsInitial()
     * method will return false.
     */
    inline void clearFirstOdomValueIsInitial();

    /**
     * Checks whether the field "FirstOdomValueIsInitial" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFirstOdomValueIsInitial()). Otherwise it will return false.
     */
    inline bool hasFirstOdomValueIsInitial () const;

    /**
     * Returns the value of the member "FirstOdomValueIsInitial".
     *
     * if flag is true, first odom-value in list is initial-value
     *
     * @return The value of the field "FirstOdomValueIsInitial"
     */
    inline bool getFirstOdomValueIsInitial () const;

    /**
     * Sets the value of the member "FirstOdomValueIsInitial".
     *
     * if flag is true, first odom-value in list is initial-value
     *
     * @param FirstOdomValueIsInitial The value which will be set
     */
    inline void setFirstOdomValueIsInitial (bool FirstOdomValueIsInitial_);

    static const OdometerData_UpdateStatus &getDefaultInstance();

private:

    static const ::std::vector< ::location_fi_types::T_OdometerData >& getT_OdometerDataList_DefaultInstance ();

    inline void set_has_OdometerData ();

    inline void clear_has_OdometerData ();

    inline void set_has_FirstOdomValueIsInitial ();

    inline void clear_has_FirstOdomValueIsInitial ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::location_fi_types::T_OdometerData > _OdometerData;

    bool _FirstOdomValueIsInitial;

};

/**
 * The status message of the property "AbsData"
 * <p>Periodically updated ABS data property. Contains a block of ABS
 * data records.</p>
 * <p>Attention: starting with version 5.0 the behavior of this property
 * changed. It delivers actual data only.</p>
 */
class AbsDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AbsDataStatus ();

    /**
     * Copy constructor
     */
    inline  AbsDataStatus (const AbsDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AbsDataStatus (const ::std::vector< ::location_fi_types::T_AbsData >& AbsData_);

    /**
     * Destructor
     */
    inline virtual  ~AbsDataStatus();

    /**
     * Assignment operator
     */
    inline AbsDataStatus& operator = (const AbsDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbsDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbsDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbsDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbsDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AbsData"

    static const int kAbsData = 0;

    /**
     * Clears the field "AbsData".
     *
     * The field will be set to its default value. The hasAbsData()
     * method will return false.
     */
    inline void clearAbsData();

    /**
     * Checks whether the field "AbsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbsData()). Otherwise it will return false.
     */
    inline bool hasAbsData () const;

    /**
     * Returns the value of the member "AbsData".
     *
     * ABS data with time stamps.
     *
     * @return The value of the field "AbsData"
     */
    inline const ::std::vector< ::location_fi_types::T_AbsData >& getAbsData () const;

    /**
     * Retrieves the value of the field "AbsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AbsData".
     */
    inline ::std::vector< ::location_fi_types::T_AbsData >& getAbsDataMutable ();

    /**
     * Sets the value of the member "AbsData".
     *
     * ABS data with time stamps.
     *
     * @param AbsData The value which will be set
     */
    inline void setAbsData (const ::std::vector< ::location_fi_types::T_AbsData >& AbsData_);

    static const AbsDataStatus &getDefaultInstance();

private:

    static const ::std::vector< ::location_fi_types::T_AbsData >& getT_AbsDataList_DefaultInstance ();

    inline void set_has_AbsData ();

    inline void clear_has_AbsData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::location_fi_types::T_AbsData > _AbsData;

};

/**
 * The status message of the property "Gyro3dData_Update"
 * List with new 3d-gyro samples.
 * <p>Attention: starting with version 5.0 the behavior of this property
 * changed. It delivers actual data only.</p>
 */
class Gyro3dData_UpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Gyro3dData_UpdateStatus ();

    /**
     * Copy constructor
     */
    inline  Gyro3dData_UpdateStatus (const Gyro3dData_UpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Gyro3dData_UpdateStatus (const ::std::vector< ::location_fi_types::T_3dGyroData >& Gyro3dData_);

    /**
     * Destructor
     */
    inline virtual  ~Gyro3dData_UpdateStatus();

    /**
     * Assignment operator
     */
    inline Gyro3dData_UpdateStatus& operator = (const Gyro3dData_UpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Gyro3dData_UpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Gyro3dData_UpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Gyro3dData_UpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Gyro3dData_UpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Gyro3dData"

    static const int kGyro3dData = 0;

    /**
     * Clears the field "Gyro3dData".
     *
     * The field will be set to its default value. The hasGyro3dData()
     * method will return false.
     */
    inline void clearGyro3dData();

    /**
     * Checks whether the field "Gyro3dData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGyro3dData()). Otherwise it will return false.
     */
    inline bool hasGyro3dData () const;

    /**
     * Returns the value of the member "Gyro3dData".
     *
     * List with most recent 3d-gyro samples
     * incl. timestamp
     *
     * @return The value of the field "Gyro3dData"
     */
    inline const ::std::vector< ::location_fi_types::T_3dGyroData >& getGyro3dData () const;

    /**
     * Retrieves the value of the field "Gyro3dData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Gyro3dData".
     */
    inline ::std::vector< ::location_fi_types::T_3dGyroData >& getGyro3dDataMutable ();

    /**
     * Sets the value of the member "Gyro3dData".
     *
     * List with most recent 3d-gyro samples
     * incl. timestamp
     *
     * @param Gyro3dData The value which will be set
     */
    inline void setGyro3dData (const ::std::vector< ::location_fi_types::T_3dGyroData >& Gyro3dData_);

    static const Gyro3dData_UpdateStatus &getDefaultInstance();

private:

    static const ::std::vector< ::location_fi_types::T_3dGyroData >& getT_3dGyroDataList_DefaultInstance ();

    inline void set_has_Gyro3dData ();

    inline void clear_has_Gyro3dData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::location_fi_types::T_3dGyroData > _Gyro3dData;

};

/**
 * The status message of the property "Acc3dData_Update"
 * List with new 3d-acc sample.
 * <p>Attention: starting with version 5.0 the beahavior of this property
 * changed. It delivers actual data only.</p>
 */
class Acc3dData_UpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Acc3dData_UpdateStatus ();

    /**
     * Copy constructor
     */
    inline  Acc3dData_UpdateStatus (const Acc3dData_UpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Acc3dData_UpdateStatus (const ::std::vector< ::location_fi_types::T_3dAccData >& Acc3dData_);

    /**
     * Destructor
     */
    inline virtual  ~Acc3dData_UpdateStatus();

    /**
     * Assignment operator
     */
    inline Acc3dData_UpdateStatus& operator = (const Acc3dData_UpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Acc3dData_UpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Acc3dData_UpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Acc3dData_UpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Acc3dData_UpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Acc3dData"

    static const int kAcc3dData = 0;

    /**
     * Clears the field "Acc3dData".
     *
     * The field will be set to its default value. The hasAcc3dData()
     * method will return false.
     */
    inline void clearAcc3dData();

    /**
     * Checks whether the field "Acc3dData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAcc3dData()). Otherwise it will return false.
     */
    inline bool hasAcc3dData () const;

    /**
     * Returns the value of the member "Acc3dData".
     *
     * List with most recent 3d-acc samples
     * incl. timestamp
     *
     * @return The value of the field "Acc3dData"
     */
    inline const ::std::vector< ::location_fi_types::T_3dAccData >& getAcc3dData () const;

    /**
     * Retrieves the value of the field "Acc3dData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Acc3dData".
     */
    inline ::std::vector< ::location_fi_types::T_3dAccData >& getAcc3dDataMutable ();

    /**
     * Sets the value of the member "Acc3dData".
     *
     * List with most recent 3d-acc samples
     * incl. timestamp
     *
     * @param Acc3dData The value which will be set
     */
    inline void setAcc3dData (const ::std::vector< ::location_fi_types::T_3dAccData >& Acc3dData_);

    static const Acc3dData_UpdateStatus &getDefaultInstance();

private:

    static const ::std::vector< ::location_fi_types::T_3dAccData >& getT_3dAccDataList_DefaultInstance ();

    inline void set_has_Acc3dData ();

    inline void clear_has_Acc3dData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::location_fi_types::T_3dAccData > _Acc3dData;

};

/**
 * The status message of the property "GyroTemperature"
 * Current temperature measured in or close to the gyro sensor. [K]
 */
class GyroTemperatureStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GyroTemperatureStatus ();

    /**
     * Copy constructor
     */
    inline  GyroTemperatureStatus (const GyroTemperatureStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GyroTemperatureStatus (float GyroTemperature_);

    /**
     * Destructor
     */
    inline virtual  ~GyroTemperatureStatus();

    /**
     * Assignment operator
     */
    inline GyroTemperatureStatus& operator = (const GyroTemperatureStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GyroTemperatureStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GyroTemperatureStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GyroTemperatureStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GyroTemperatureStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GyroTemperature"

    static const int kGyroTemperature = 0;

    /**
     * Clears the field "GyroTemperature".
     *
     * The field will be set to its default value. The hasGyroTemperature()
     * method will return false.
     */
    inline void clearGyroTemperature();

    /**
     * Checks whether the field "GyroTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGyroTemperature()). Otherwise it will return false.
     */
    inline bool hasGyroTemperature () const;

    /**
     * Returns the value of the member "GyroTemperature".
     *
     *
     *
     * @return The value of the field "GyroTemperature"
     */
    inline float getGyroTemperature () const;

    /**
     * Sets the value of the member "GyroTemperature".
     *
     *
     *
     * @param GyroTemperature The value which will be set
     */
    inline void setGyroTemperature (float GyroTemperature_);

    static const GyroTemperatureStatus &getDefaultInstance();

private:

    inline void set_has_GyroTemperature ();

    inline void clear_has_GyroTemperature ();

    uint32 _has_bits_[ (1 + 31) / 32];

    float _GyroTemperature;

};

/**
 * The error message of 'GyroTemperature'
 */
class GyroTemperatureError  : public ::asf::core::Payload {
public:

    enum GyroTemperatureErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GyroTemperatureError ();

   /**
     * Copy constructor
     */
    inline  GyroTemperatureError (const GyroTemperatureError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GyroTemperatureError();

    /**
     * Assigns a new value to this object.
     */
    inline GyroTemperatureError& operator = (const GyroTemperatureError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GyroTemperatureError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GyroTemperatureError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GyroTemperatureError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GyroTemperatureError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GyroTemperatureError::GyroTemperatureErrorField getField () const;

    inline void setField(GyroTemperatureError::GyroTemperatureErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GyroTemperatureErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GyroTemperatureErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline GyroTemperatureErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GyroTemperatureErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (GyroTemperatureErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GyroTemperatureError &getDefaultInstance();

private:

    inline void cloneData (const GyroTemperatureError& rhs);

    inline void deleteData ();

    GyroTemperatureErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "GnssSatSystem"
 * There are different global navigation satellite systems (GNSS)
 * available. Depending on the characteristics of the applied GNSS
 * receiver and antenna, it's possible to activate multiple systems at a
 * time or choose another system e.g. GLONASS instead of GPS. The
 * activated constellation may be persisted depending on projects
 * configuration.
 */
class GnssSatSystemStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GnssSatSystemStatus ();

    /**
     * Copy constructor
     */
    inline  GnssSatSystemStatus (const GnssSatSystemStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GnssSatSystemStatus (const ::location_fi_types::T_b8_GnssSatSys& ActualGnssSatSys_);

    /**
     * Destructor
     */
    inline virtual  ~GnssSatSystemStatus();

    /**
     * Assignment operator
     */
    inline GnssSatSystemStatus& operator = (const GnssSatSystemStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GnssSatSystemStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GnssSatSystemStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GnssSatSystemStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GnssSatSystemStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActualGnssSatSys"

    static const int kActualGnssSatSys = 0;

    /**
     * Clears the field "ActualGnssSatSys".
     *
     * The field will be set to its default value. The hasActualGnssSatSys()
     * method will return false.
     */
    inline void clearActualGnssSatSys();

    /**
     * Checks whether the field "ActualGnssSatSys" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActualGnssSatSys()). Otherwise it will return false.
     */
    inline bool hasActualGnssSatSys () const;

    /**
     * Returns the value of the member "ActualGnssSatSys".
     *
     *
     *
     * @return The value of the field "ActualGnssSatSys"
     */
    inline const ::location_fi_types::T_b8_GnssSatSys& getActualGnssSatSys () const;

    /**
     * Retrieves the value of the field "ActualGnssSatSys" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActualGnssSatSys".
     */
    inline ::location_fi_types::T_b8_GnssSatSys& getActualGnssSatSysMutable ();

    /**
     * Sets the value of the member "ActualGnssSatSys".
     *
     *
     *
     * @param ActualGnssSatSys The value which will be set
     */
    inline void setActualGnssSatSys (const ::location_fi_types::T_b8_GnssSatSys& ActualGnssSatSys_);

    static const GnssSatSystemStatus &getDefaultInstance();

private:

    inline void set_has_ActualGnssSatSys ();

    inline void clear_has_ActualGnssSatSys ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_b8_GnssSatSys _ActualGnssSatSys;

};

/**
 * The set message of the property "GnssSatSystem"
 * There are different global navigation satellite systems (GNSS)
 * available. Depending on the characteristics of the applied GNSS
 * receiver and antenna, it's possible to activate multiple systems at a
 * time or choose another system e.g. GLONASS instead of GPS. The
 * activated constellation may be persisted depending on projects
 * configuration.
 * Set the GNSS satellite Systems to use.
 */
class GnssSatSystemSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GnssSatSystemSet ();

    /**
     * Copy constructor
     */
    inline  GnssSatSystemSet (const GnssSatSystemSet &rhs);

    /**
     * All fields constructor
     */
    inline  GnssSatSystemSet (const ::location_fi_types::T_b8_GnssSatSys& TargetGnssSatSys_);

    /**
     * Destructor
     */
    inline virtual  ~GnssSatSystemSet();

    /**
     * Assignment operator
     */
    inline GnssSatSystemSet& operator = (const GnssSatSystemSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GnssSatSystemSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GnssSatSystemSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GnssSatSystemSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GnssSatSystemSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TargetGnssSatSys"

    static const int kTargetGnssSatSys = 0;

    /**
     * Clears the field "TargetGnssSatSys".
     *
     * The field will be set to its default value. The hasTargetGnssSatSys()
     * method will return false.
     */
    inline void clearTargetGnssSatSys();

    /**
     * Checks whether the field "TargetGnssSatSys" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetGnssSatSys()). Otherwise it will return false.
     */
    inline bool hasTargetGnssSatSys () const;

    /**
     * Returns the value of the member "TargetGnssSatSys".
     *
     * If the meaning of "TargetGnssSatSys" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TargetGnssSatSys"
     */
    inline const ::location_fi_types::T_b8_GnssSatSys& getTargetGnssSatSys () const;

    /**
     * Retrieves the value of the field "TargetGnssSatSys" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TargetGnssSatSys".
     */
    inline ::location_fi_types::T_b8_GnssSatSys& getTargetGnssSatSysMutable ();

    /**
     * Sets the value of the member "TargetGnssSatSys".
     *
     * If the meaning of "TargetGnssSatSys" isn't clear, then there should be a description here.
     *
     * @param TargetGnssSatSys The value which will be set
     */
    inline void setTargetGnssSatSys (const ::location_fi_types::T_b8_GnssSatSys& TargetGnssSatSys_);

    static const GnssSatSystemSet &getDefaultInstance();

private:

    inline void set_has_TargetGnssSatSys ();

    inline void clear_has_TargetGnssSatSys ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_b8_GnssSatSys _TargetGnssSatSys;

};

/**
 * The status message of the property "GnssWnEpoch"
 * This property allows to adjust the GPS Epoch. GPS determines the
 * actual year from the weeknumber counter. This counter is a 10bit
 * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
 * general GPS has no means to determine which 20 year block (epoch) is
 * the actual one. In order to select the apropiate epoch, the "set" method
 * is called with a date (day, month and year) from the desired epoch. By
 * setting this date the epoch is [date..date+1024 weeks]
 * actual date/time according to the selected epoch.
 */
class GnssWnEpochStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GnssWnEpochStatus ();

    /**
     * Copy constructor
     */
    inline  GnssWnEpochStatus (const GnssWnEpochStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GnssWnEpochStatus (const ::location_fi_types::T_TimeDate& ActualWnDate_);

    /**
     * Destructor
     */
    inline virtual  ~GnssWnEpochStatus();

    /**
     * Assignment operator
     */
    inline GnssWnEpochStatus& operator = (const GnssWnEpochStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GnssWnEpochStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GnssWnEpochStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GnssWnEpochStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GnssWnEpochStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActualWnDate"

    static const int kActualWnDate = 0;

    /**
     * Clears the field "ActualWnDate".
     *
     * The field will be set to its default value. The hasActualWnDate()
     * method will return false.
     */
    inline void clearActualWnDate();

    /**
     * Checks whether the field "ActualWnDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActualWnDate()). Otherwise it will return false.
     */
    inline bool hasActualWnDate () const;

    /**
     * Returns the value of the member "ActualWnDate".
     *
     * actual date with respect to the activated GPS epoch.
     *
     * @return The value of the field "ActualWnDate"
     */
    inline const ::location_fi_types::T_TimeDate& getActualWnDate () const;

    /**
     * Retrieves the value of the field "ActualWnDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActualWnDate".
     */
    inline ::location_fi_types::T_TimeDate& getActualWnDateMutable ();

    /**
     * Sets the value of the member "ActualWnDate".
     *
     * actual date with respect to the activated GPS epoch.
     *
     * @param ActualWnDate The value which will be set
     */
    inline void setActualWnDate (const ::location_fi_types::T_TimeDate& ActualWnDate_);

    static const GnssWnEpochStatus &getDefaultInstance();

private:

    inline void set_has_ActualWnDate ();

    inline void clear_has_ActualWnDate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_TimeDate _ActualWnDate;

};

/**
 * The set message of the property "GnssWnEpoch"
 * This property allows to adjust the GPS Epoch. GPS determines the
 * actual year from the weeknumber counter. This counter is a 10bit
 * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
 * general GPS has no means to determine which 20 year block (epoch) is
 * the actual one. In order to select the apropiate epoch, the "set" method
 * is called with a date (day, month and year) from the desired epoch. By
 * setting this date the epoch is [date..date+1024 weeks]
 */
class GnssWnEpochSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GnssWnEpochSet ();

    /**
     * Copy constructor
     */
    inline  GnssWnEpochSet (const GnssWnEpochSet &rhs);

    /**
     * All fields constructor
     */
    inline  GnssWnEpochSet (const ::location_fi_types::T_TimeDate& TargetWnDate_);

    /**
     * Destructor
     */
    inline virtual  ~GnssWnEpochSet();

    /**
     * Assignment operator
     */
    inline GnssWnEpochSet& operator = (const GnssWnEpochSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GnssWnEpochSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GnssWnEpochSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GnssWnEpochSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GnssWnEpochSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TargetWnDate"

    static const int kTargetWnDate = 0;

    /**
     * Clears the field "TargetWnDate".
     *
     * The field will be set to its default value. The hasTargetWnDate()
     * method will return false.
     */
    inline void clearTargetWnDate();

    /**
     * Checks whether the field "TargetWnDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetWnDate()). Otherwise it will return false.
     */
    inline bool hasTargetWnDate () const;

    /**
     * Returns the value of the member "TargetWnDate".
     *
     * Set the GPS epoch according to TargetWnDate. Only day, month and
     * year of the T_TimeDate structure have to be filled. The hour,
     * minute, second and millisecond elements of that structure are
     * ignored
     *
     * @return The value of the field "TargetWnDate"
     */
    inline const ::location_fi_types::T_TimeDate& getTargetWnDate () const;

    /**
     * Retrieves the value of the field "TargetWnDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TargetWnDate".
     */
    inline ::location_fi_types::T_TimeDate& getTargetWnDateMutable ();

    /**
     * Sets the value of the member "TargetWnDate".
     *
     * Set the GPS epoch according to TargetWnDate. Only day, month and
     * year of the T_TimeDate structure have to be filled. The hour,
     * minute, second and millisecond elements of that structure are
     * ignored
     *
     * @param TargetWnDate The value which will be set
     */
    inline void setTargetWnDate (const ::location_fi_types::T_TimeDate& TargetWnDate_);

    static const GnssWnEpochSet &getDefaultInstance();

private:

    inline void set_has_TargetWnDate ();

    inline void clear_has_TargetWnDate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_TimeDate _TargetWnDate;

};

/**
 * The status message of the property "GnssConfigData"
 * Configuration data of the GNSS receiver
 */
class GnssConfigDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GnssConfigDataStatus ();

    /**
     * Copy constructor
     */
    inline  GnssConfigDataStatus (const GnssConfigDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GnssConfigDataStatus (const ::location_fi_types::T_GnssConfigData& GnssConfigData_);

    /**
     * Destructor
     */
    inline virtual  ~GnssConfigDataStatus();

    /**
     * Assignment operator
     */
    inline GnssConfigDataStatus& operator = (const GnssConfigDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GnssConfigDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GnssConfigDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GnssConfigDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GnssConfigDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GnssConfigData"

    static const int kGnssConfigData = 0;

    /**
     * Clears the field "GnssConfigData".
     *
     * The field will be set to its default value. The hasGnssConfigData()
     * method will return false.
     */
    inline void clearGnssConfigData();

    /**
     * Checks whether the field "GnssConfigData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssConfigData()). Otherwise it will return false.
     */
    inline bool hasGnssConfigData () const;

    /**
     * Returns the value of the member "GnssConfigData".
     *
     *
     *
     * @return The value of the field "GnssConfigData"
     */
    inline const ::location_fi_types::T_GnssConfigData& getGnssConfigData () const;

    /**
     * Retrieves the value of the field "GnssConfigData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GnssConfigData".
     */
    inline ::location_fi_types::T_GnssConfigData& getGnssConfigDataMutable ();

    /**
     * Sets the value of the member "GnssConfigData".
     *
     *
     *
     * @param GnssConfigData The value which will be set
     */
    inline void setGnssConfigData (const ::location_fi_types::T_GnssConfigData& GnssConfigData_);

    static const GnssConfigDataStatus &getDefaultInstance();

private:

    inline void set_has_GnssConfigData ();

    inline void clear_has_GnssConfigData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_GnssConfigData _GnssConfigData;

};

/**
 * The status message of the property "GnssData"
 * periodical GNSS-data-message
 */
class GnssDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GnssDataStatus ();

    /**
     * Copy constructor
     */
    inline  GnssDataStatus (const GnssDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GnssDataStatus (const ::location_fi_types::T_GnssData& GnssData_);

    /**
     * Destructor
     */
    inline virtual  ~GnssDataStatus();

    /**
     * Assignment operator
     */
    inline GnssDataStatus& operator = (const GnssDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GnssDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GnssDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GnssDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GnssDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GnssData"

    static const int kGnssData = 0;

    /**
     * Clears the field "GnssData".
     *
     * The field will be set to its default value. The hasGnssData()
     * method will return false.
     */
    inline void clearGnssData();

    /**
     * Checks whether the field "GnssData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssData()). Otherwise it will return false.
     */
    inline bool hasGnssData () const;

    /**
     * Returns the value of the member "GnssData".
     *
     *
     *
     * @return The value of the field "GnssData"
     */
    inline const ::location_fi_types::T_GnssData& getGnssData () const;

    /**
     * Retrieves the value of the field "GnssData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GnssData".
     */
    inline ::location_fi_types::T_GnssData& getGnssDataMutable ();

    /**
     * Sets the value of the member "GnssData".
     *
     *
     *
     * @param GnssData The value which will be set
     */
    inline void setGnssData (const ::location_fi_types::T_GnssData& GnssData_);

    static const GnssDataStatus &getDefaultInstance();

private:

    inline void set_has_GnssData ();

    inline void clear_has_GnssData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_GnssData _GnssData;

};

/**
 * The status message of the property "AllSensorData"
 * periodical update of all sensor data that are relevant for the
 * position calculation (Ortung). This includes GNSS, odometer, 3D-Gyro
 * and 3D-Acc data. There is no more need to register for the different
 * sensor data separatly. In normal operation every second one of these
 * data blocks get transmitted. In contrast to the dedicated properties
 * for each sensor the "AllSensorData" delivers on UpReg next to the
 * actual data set all available datasets from the buffers.
 */
class AllSensorDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllSensorDataStatus ();

    /**
     * Copy constructor
     */
    inline  AllSensorDataStatus (const AllSensorDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AllSensorDataStatus (const ::location_fi_types::T_AllSensorData& SensorDataBlock_);

    /**
     * Destructor
     */
    inline virtual  ~AllSensorDataStatus();

    /**
     * Assignment operator
     */
    inline AllSensorDataStatus& operator = (const AllSensorDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllSensorDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllSensorDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllSensorDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllSensorDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SensorDataBlock"

    static const int kSensorDataBlock = 0;

    /**
     * Clears the field "SensorDataBlock".
     *
     * The field will be set to its default value. The hasSensorDataBlock()
     * method will return false.
     */
    inline void clearSensorDataBlock();

    /**
     * Checks whether the field "SensorDataBlock" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSensorDataBlock()). Otherwise it will return false.
     */
    inline bool hasSensorDataBlock () const;

    /**
     * Returns the value of the member "SensorDataBlock".
     *
     * Big chunk of sensor data.
     *
     * @return The value of the field "SensorDataBlock"
     */
    inline const ::location_fi_types::T_AllSensorData& getSensorDataBlock () const;

    /**
     * Retrieves the value of the field "SensorDataBlock" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SensorDataBlock".
     */
    inline ::location_fi_types::T_AllSensorData& getSensorDataBlockMutable ();

    /**
     * Sets the value of the member "SensorDataBlock".
     *
     * Big chunk of sensor data.
     *
     * @param SensorDataBlock The value which will be set
     */
    inline void setSensorDataBlock (const ::location_fi_types::T_AllSensorData& SensorDataBlock_);

    static const AllSensorDataStatus &getDefaultInstance();

private:

    inline void set_has_SensorDataBlock ();

    inline void clear_has_SensorDataBlock ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_AllSensorData _SensorDataBlock;

};

/**
 * The status message of the property "VdsVersionInfo"
 * Gives some information about the Vd_Sensor verion used and about the
 * target it is running on.
 */
class VdsVersionInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VdsVersionInfoStatus ();

    /**
     * Copy constructor
     */
    inline  VdsVersionInfoStatus (const VdsVersionInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VdsVersionInfoStatus (const ::location_fi_types::T_VdsVersionInfo& VdsVersion_);

    /**
     * Destructor
     */
    inline virtual  ~VdsVersionInfoStatus();

    /**
     * Assignment operator
     */
    inline VdsVersionInfoStatus& operator = (const VdsVersionInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VdsVersionInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VdsVersionInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VdsVersionInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VdsVersionInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VdsVersion"

    static const int kVdsVersion = 0;

    /**
     * Clears the field "VdsVersion".
     *
     * The field will be set to its default value. The hasVdsVersion()
     * method will return false.
     */
    inline void clearVdsVersion();

    /**
     * Checks whether the field "VdsVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVdsVersion()). Otherwise it will return false.
     */
    inline bool hasVdsVersion () const;

    /**
     * Returns the value of the member "VdsVersion".
     *
     *
     *
     * @return The value of the field "VdsVersion"
     */
    inline const ::location_fi_types::T_VdsVersionInfo& getVdsVersion () const;

    /**
     * Retrieves the value of the field "VdsVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VdsVersion".
     */
    inline ::location_fi_types::T_VdsVersionInfo& getVdsVersionMutable ();

    /**
     * Sets the value of the member "VdsVersion".
     *
     *
     *
     * @param VdsVersion The value which will be set
     */
    inline void setVdsVersion (const ::location_fi_types::T_VdsVersionInfo& VdsVersion_);

    static const VdsVersionInfoStatus &getDefaultInstance();

private:

    inline void set_has_VdsVersion ();

    inline void clear_has_VdsVersion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_VdsVersionInfo _VdsVersion;

};

/**
 * The status message of the property "AccTemperature"
 * Current temperature measured in or close to the acceleration sensor. [K]
 */
class AccTemperatureStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccTemperatureStatus ();

    /**
     * Copy constructor
     */
    inline  AccTemperatureStatus (const AccTemperatureStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AccTemperatureStatus (float AccTemperature_);

    /**
     * Destructor
     */
    inline virtual  ~AccTemperatureStatus();

    /**
     * Assignment operator
     */
    inline AccTemperatureStatus& operator = (const AccTemperatureStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccTemperatureStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccTemperatureStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccTemperatureStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccTemperatureStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AccTemperature"

    static const int kAccTemperature = 0;

    /**
     * Clears the field "AccTemperature".
     *
     * The field will be set to its default value. The hasAccTemperature()
     * method will return false.
     */
    inline void clearAccTemperature();

    /**
     * Checks whether the field "AccTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccTemperature()). Otherwise it will return false.
     */
    inline bool hasAccTemperature () const;

    /**
     * Returns the value of the member "AccTemperature".
     *
     *
     *
     * @return The value of the field "AccTemperature"
     */
    inline float getAccTemperature () const;

    /**
     * Sets the value of the member "AccTemperature".
     *
     *
     *
     * @param AccTemperature The value which will be set
     */
    inline void setAccTemperature (float AccTemperature_);

    static const AccTemperatureStatus &getDefaultInstance();

private:

    inline void set_has_AccTemperature ();

    inline void clear_has_AccTemperature ();

    uint32 _has_bits_[ (1 + 31) / 32];

    float _AccTemperature;

};

/**
 * The error message of 'AccTemperature'
 */
class AccTemperatureError  : public ::asf::core::Payload {
public:

    enum AccTemperatureErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AccTemperatureError ();

   /**
     * Copy constructor
     */
    inline  AccTemperatureError (const AccTemperatureError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AccTemperatureError();

    /**
     * Assigns a new value to this object.
     */
    inline AccTemperatureError& operator = (const AccTemperatureError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccTemperatureError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccTemperatureError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccTemperatureError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccTemperatureError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AccTemperatureError::AccTemperatureErrorField getField () const;

    inline void setField(AccTemperatureError::AccTemperatureErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AccTemperatureErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AccTemperatureErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline AccTemperatureErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AccTemperatureErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (AccTemperatureErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AccTemperatureError &getDefaultInstance();

private:

    inline void cloneData (const AccTemperatureError& rhs);

    inline void deleteData ();

    AccTemperatureErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DiagGnssSatSystem"
 * This property is similar to the "GnssSatSystem" property. The main
 * difference is that the changes are not persisted and lost after reboot.
 * This is needed e.g. by diagnosis to test the different satellite
 * systems without spoiling the default/factory configuration.
 */
class DiagGnssSatSystemStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagGnssSatSystemStatus ();

    /**
     * Copy constructor
     */
    inline  DiagGnssSatSystemStatus (const DiagGnssSatSystemStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiagGnssSatSystemStatus (const ::location_fi_types::T_b8_GnssSatSys& ActualGnssSatSys_);

    /**
     * Destructor
     */
    inline virtual  ~DiagGnssSatSystemStatus();

    /**
     * Assignment operator
     */
    inline DiagGnssSatSystemStatus& operator = (const DiagGnssSatSystemStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagGnssSatSystemStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagGnssSatSystemStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagGnssSatSystemStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagGnssSatSystemStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActualGnssSatSys"

    static const int kActualGnssSatSys = 0;

    /**
     * Clears the field "ActualGnssSatSys".
     *
     * The field will be set to its default value. The hasActualGnssSatSys()
     * method will return false.
     */
    inline void clearActualGnssSatSys();

    /**
     * Checks whether the field "ActualGnssSatSys" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActualGnssSatSys()). Otherwise it will return false.
     */
    inline bool hasActualGnssSatSys () const;

    /**
     * Returns the value of the member "ActualGnssSatSys".
     *
     *
     *
     * @return The value of the field "ActualGnssSatSys"
     */
    inline const ::location_fi_types::T_b8_GnssSatSys& getActualGnssSatSys () const;

    /**
     * Retrieves the value of the field "ActualGnssSatSys" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActualGnssSatSys".
     */
    inline ::location_fi_types::T_b8_GnssSatSys& getActualGnssSatSysMutable ();

    /**
     * Sets the value of the member "ActualGnssSatSys".
     *
     *
     *
     * @param ActualGnssSatSys The value which will be set
     */
    inline void setActualGnssSatSys (const ::location_fi_types::T_b8_GnssSatSys& ActualGnssSatSys_);

    static const DiagGnssSatSystemStatus &getDefaultInstance();

private:

    inline void set_has_ActualGnssSatSys ();

    inline void clear_has_ActualGnssSatSys ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_b8_GnssSatSys _ActualGnssSatSys;

};

/**
 * The set message of the property "DiagGnssSatSystem"
 * This property is similar to the "GnssSatSystem" property. The main
 * difference is that the changes are not persisted and lost after reboot.
 * This is needed e.g. by diagnosis to test the different satellite
 * systems without spoiling the default/factory configuration.
 * Set the GNSS satellite Systems to use.
 */
class DiagGnssSatSystemSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagGnssSatSystemSet ();

    /**
     * Copy constructor
     */
    inline  DiagGnssSatSystemSet (const DiagGnssSatSystemSet &rhs);

    /**
     * All fields constructor
     */
    inline  DiagGnssSatSystemSet (const ::location_fi_types::T_b8_GnssSatSys& TargetGnssSatSys_);

    /**
     * Destructor
     */
    inline virtual  ~DiagGnssSatSystemSet();

    /**
     * Assignment operator
     */
    inline DiagGnssSatSystemSet& operator = (const DiagGnssSatSystemSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagGnssSatSystemSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagGnssSatSystemSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagGnssSatSystemSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagGnssSatSystemSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TargetGnssSatSys"

    static const int kTargetGnssSatSys = 0;

    /**
     * Clears the field "TargetGnssSatSys".
     *
     * The field will be set to its default value. The hasTargetGnssSatSys()
     * method will return false.
     */
    inline void clearTargetGnssSatSys();

    /**
     * Checks whether the field "TargetGnssSatSys" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetGnssSatSys()). Otherwise it will return false.
     */
    inline bool hasTargetGnssSatSys () const;

    /**
     * Returns the value of the member "TargetGnssSatSys".
     *
     * If the meaning of "TargetGnssSatSys" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TargetGnssSatSys"
     */
    inline const ::location_fi_types::T_b8_GnssSatSys& getTargetGnssSatSys () const;

    /**
     * Retrieves the value of the field "TargetGnssSatSys" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TargetGnssSatSys".
     */
    inline ::location_fi_types::T_b8_GnssSatSys& getTargetGnssSatSysMutable ();

    /**
     * Sets the value of the member "TargetGnssSatSys".
     *
     * If the meaning of "TargetGnssSatSys" isn't clear, then there should be a description here.
     *
     * @param TargetGnssSatSys The value which will be set
     */
    inline void setTargetGnssSatSys (const ::location_fi_types::T_b8_GnssSatSys& TargetGnssSatSys_);

    static const DiagGnssSatSystemSet &getDefaultInstance();

private:

    inline void set_has_TargetGnssSatSys ();

    inline void clear_has_TargetGnssSatSys ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_b8_GnssSatSys _TargetGnssSatSys;

};

/**
 * The result message of the method "SavePersistent"
 * Causes VD Sensor to save all persistent data to persistent memory
 * immediately. (Normally, this is done when the CCA application state
 * changes.)
 *
 * Rationale: Some OEM customers require settings made in diagnostic mode
 * to be saved persistently immediately.
 */
class SavePersistentResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SavePersistentResult ();

    /**
     * Copy constructor
     */
    inline  SavePersistentResult (const SavePersistentResult &rhs);

    /**
     * All fields constructor
     */
    inline  SavePersistentResult (bool bSuccess_);

    /**
     * Destructor
     */
    inline virtual  ~SavePersistentResult();

    /**
     * Assignment operator
     */
    inline SavePersistentResult& operator = (const SavePersistentResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SavePersistentResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SavePersistentResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SavePersistentResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SavePersistentResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSuccess"

    static const int kBSuccess = 0;

    /**
     * Clears the field "bSuccess".
     *
     * The field will be set to its default value. The hasBSuccess()
     * method will return false.
     */
    inline void clearBSuccess();

    /**
     * Checks whether the field "bSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSuccess()). Otherwise it will return false.
     */
    inline bool hasBSuccess () const;

    /**
     * Returns the value of the member "bSuccess".
     *
     * TRUE if the persistent data could be saved to the flash file
     * system.
     *
     * @return The value of the field "bSuccess"
     */
    inline bool getBSuccess () const;

    /**
     * Sets the value of the member "bSuccess".
     *
     * TRUE if the persistent data could be saved to the flash file
     * system.
     *
     * @param bSuccess The value which will be set
     */
    inline void setBSuccess (bool bSuccess_);

    static const SavePersistentResult &getDefaultInstance();

private:

    inline void set_has_bSuccess ();

    inline void clear_has_bSuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSuccess;

};

/**
 * The error message of 'SavePersistent'
 */
class SavePersistentError  : public ::asf::core::Payload {
public:

    enum SavePersistentErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SavePersistentError ();

   /**
     * Copy constructor
     */
    inline  SavePersistentError (const SavePersistentError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SavePersistentError();

    /**
     * Assigns a new value to this object.
     */
    inline SavePersistentError& operator = (const SavePersistentError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SavePersistentError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SavePersistentError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SavePersistentError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SavePersistentError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SavePersistentError::SavePersistentErrorField getField () const;

    inline void setField(SavePersistentError::SavePersistentErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SavePersistentErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SavePersistentErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline SavePersistentErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SavePersistentErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (SavePersistentErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SavePersistentError &getDefaultInstance();

private:

    inline void cloneData (const SavePersistentError& rhs);

    inline void deleteData ();

    SavePersistentErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "UpdateFactorySettings"
 * Restore parts of factory settings. The method updates some parameter
 * for configuration.
 */
class UpdateFactorySettingsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateFactorySettingsStart ();

    /**
     * Copy constructor
     */
    inline  UpdateFactorySettingsStart (const UpdateFactorySettingsStart &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateFactorySettingsStart (::location_fi_types::T_e8_DefSetGroups DefSetGroup_, ::location_fi_types::T_e8_DefSetMode DefSetMode_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateFactorySettingsStart();

    /**
     * Assignment operator
     */
    inline UpdateFactorySettingsStart& operator = (const UpdateFactorySettingsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateFactorySettingsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateFactorySettingsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateFactorySettingsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateFactorySettingsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetGroup"

    static const int kDefSetGroup = 0;

    /**
     * Clears the field "DefSetGroup".
     *
     * The field will be set to its default value. The hasDefSetGroup()
     * method will return false.
     */
    inline void clearDefSetGroup();

    /**
     * Checks whether the field "DefSetGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetGroup () const;

    /**
     * Returns the value of the member "DefSetGroup".
     *
     * Group ID: e.g. DEFSET_GROUP_MAINTENANCE.
     *
     * @return The value of the field "DefSetGroup"
     */
    inline ::location_fi_types::T_e8_DefSetGroups getDefSetGroup () const;

    /**
     * Sets the value of the member "DefSetGroup".
     *
     * Group ID: e.g. DEFSET_GROUP_MAINTENANCE.
     *
     * @param DefSetGroup The value which will be set
     */
    inline void setDefSetGroup (::location_fi_types::T_e8_DefSetGroups DefSetGroup_);

    // API of field "DefSetMode"

    static const int kDefSetMode = 1;

    /**
     * Clears the field "DefSetMode".
     *
     * The field will be set to its default value. The hasDefSetMode()
     * method will return false.
     */
    inline void clearDefSetMode();

    /**
     * Checks whether the field "DefSetMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetMode()). Otherwise it will return false.
     */
    inline bool hasDefSetMode () const;

    /**
     * Returns the value of the member "DefSetMode".
     *
     * Mode: e.g. DEFSET_SRC_CODING.
     *
     * @return The value of the field "DefSetMode"
     */
    inline ::location_fi_types::T_e8_DefSetMode getDefSetMode () const;

    /**
     * Sets the value of the member "DefSetMode".
     *
     * Mode: e.g. DEFSET_SRC_CODING.
     *
     * @param DefSetMode The value which will be set
     */
    inline void setDefSetMode (::location_fi_types::T_e8_DefSetMode DefSetMode_);

    static const UpdateFactorySettingsStart &getDefaultInstance();

private:

    inline void set_has_DefSetGroup ();

    inline void clear_has_DefSetGroup ();

    inline void set_has_DefSetMode ();

    inline void clear_has_DefSetMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::location_fi_types::T_e8_DefSetGroups _DefSetGroup;

    ::location_fi_types::T_e8_DefSetMode _DefSetMode;

};

/**
 * The result message of the method "UpdateFactorySettings"
 * Restore parts of factory settings. The method updates some parameter
 * for configuration.
 */
class UpdateFactorySettingsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateFactorySettingsResult ();

    /**
     * Copy constructor
     */
    inline  UpdateFactorySettingsResult (const UpdateFactorySettingsResult &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateFactorySettingsResult (::location_fi_types::T_e8_DefSetGroups DefSetGroup_, ::location_fi_types::T_e8_DefSetMode DefSetMode_, bool DefSetStateSuccessful_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateFactorySettingsResult();

    /**
     * Assignment operator
     */
    inline UpdateFactorySettingsResult& operator = (const UpdateFactorySettingsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateFactorySettingsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateFactorySettingsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateFactorySettingsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateFactorySettingsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetGroup"

    static const int kDefSetGroup = 0;

    /**
     * Clears the field "DefSetGroup".
     *
     * The field will be set to its default value. The hasDefSetGroup()
     * method will return false.
     */
    inline void clearDefSetGroup();

    /**
     * Checks whether the field "DefSetGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetGroup () const;

    /**
     * Returns the value of the member "DefSetGroup".
     *
     * Group ID: e.g. DEFSET_GROUP_MAINTENANCE.
     *
     * @return The value of the field "DefSetGroup"
     */
    inline ::location_fi_types::T_e8_DefSetGroups getDefSetGroup () const;

    /**
     * Sets the value of the member "DefSetGroup".
     *
     * Group ID: e.g. DEFSET_GROUP_MAINTENANCE.
     *
     * @param DefSetGroup The value which will be set
     */
    inline void setDefSetGroup (::location_fi_types::T_e8_DefSetGroups DefSetGroup_);

    // API of field "DefSetMode"

    static const int kDefSetMode = 1;

    /**
     * Clears the field "DefSetMode".
     *
     * The field will be set to its default value. The hasDefSetMode()
     * method will return false.
     */
    inline void clearDefSetMode();

    /**
     * Checks whether the field "DefSetMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetMode()). Otherwise it will return false.
     */
    inline bool hasDefSetMode () const;

    /**
     * Returns the value of the member "DefSetMode".
     *
     * Mode: e.g. DEFSET_SRC_CODING.
     *
     * @return The value of the field "DefSetMode"
     */
    inline ::location_fi_types::T_e8_DefSetMode getDefSetMode () const;

    /**
     * Sets the value of the member "DefSetMode".
     *
     * Mode: e.g. DEFSET_SRC_CODING.
     *
     * @param DefSetMode The value which will be set
     */
    inline void setDefSetMode (::location_fi_types::T_e8_DefSetMode DefSetMode_);

    // API of field "DefSetStateSuccessful"

    static const int kDefSetStateSuccessful = 2;

    /**
     * Clears the field "DefSetStateSuccessful".
     *
     * The field will be set to its default value. The hasDefSetStateSuccessful()
     * method will return false.
     */
    inline void clearDefSetStateSuccessful();

    /**
     * Checks whether the field "DefSetStateSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateSuccessful()). Otherwise it will return false.
     */
    inline bool hasDefSetStateSuccessful () const;

    /**
     * Returns the value of the member "DefSetStateSuccessful".
     *
     * TRUE or FALSE
     *
     * @return The value of the field "DefSetStateSuccessful"
     */
    inline bool getDefSetStateSuccessful () const;

    /**
     * Sets the value of the member "DefSetStateSuccessful".
     *
     * TRUE or FALSE
     *
     * @param DefSetStateSuccessful The value which will be set
     */
    inline void setDefSetStateSuccessful (bool DefSetStateSuccessful_);

    static const UpdateFactorySettingsResult &getDefaultInstance();

private:

    inline void set_has_DefSetGroup ();

    inline void clear_has_DefSetGroup ();

    inline void set_has_DefSetMode ();

    inline void clear_has_DefSetMode ();

    inline void set_has_DefSetStateSuccessful ();

    inline void clear_has_DefSetStateSuccessful ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::location_fi_types::T_e8_DefSetGroups _DefSetGroup;

    ::location_fi_types::T_e8_DefSetMode _DefSetMode;

    bool _DefSetStateSuccessful;

};

/**
 * The result message of the method "Gyro3dGetHwInfo"
 */
class Gyro3dGetHwInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Gyro3dGetHwInfoResult ();

    /**
     * Copy constructor
     */
    inline  Gyro3dGetHwInfoResult (const Gyro3dGetHwInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  Gyro3dGetHwInfoResult (const ::location_fi_types::T_3dGyroHwInfo& Gyro3dHwInfo_);

    /**
     * Destructor
     */
    inline virtual  ~Gyro3dGetHwInfoResult();

    /**
     * Assignment operator
     */
    inline Gyro3dGetHwInfoResult& operator = (const Gyro3dGetHwInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Gyro3dGetHwInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Gyro3dGetHwInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Gyro3dGetHwInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Gyro3dGetHwInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Gyro3dHwInfo"

    static const int kGyro3dHwInfo = 0;

    /**
     * Clears the field "Gyro3dHwInfo".
     *
     * The field will be set to its default value. The hasGyro3dHwInfo()
     * method will return false.
     */
    inline void clearGyro3dHwInfo();

    /**
     * Checks whether the field "Gyro3dHwInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGyro3dHwInfo()). Otherwise it will return false.
     */
    inline bool hasGyro3dHwInfo () const;

    /**
     * Returns the value of the member "Gyro3dHwInfo".
     *
     * HW characteristic of the used gyro sensors.
     *
     * @return The value of the field "Gyro3dHwInfo"
     */
    inline const ::location_fi_types::T_3dGyroHwInfo& getGyro3dHwInfo () const;

    /**
     * Retrieves the value of the field "Gyro3dHwInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Gyro3dHwInfo".
     */
    inline ::location_fi_types::T_3dGyroHwInfo& getGyro3dHwInfoMutable ();

    /**
     * Sets the value of the member "Gyro3dHwInfo".
     *
     * HW characteristic of the used gyro sensors.
     *
     * @param Gyro3dHwInfo The value which will be set
     */
    inline void setGyro3dHwInfo (const ::location_fi_types::T_3dGyroHwInfo& Gyro3dHwInfo_);

    static const Gyro3dGetHwInfoResult &getDefaultInstance();

private:

    inline void set_has_Gyro3dHwInfo ();

    inline void clear_has_Gyro3dHwInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_3dGyroHwInfo _Gyro3dHwInfo;

};

/**
 * The result message of the method "Acc3dGetHwInfo"
 */
class Acc3dGetHwInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Acc3dGetHwInfoResult ();

    /**
     * Copy constructor
     */
    inline  Acc3dGetHwInfoResult (const Acc3dGetHwInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  Acc3dGetHwInfoResult (const ::location_fi_types::T_3dAccHwInfo& Acc3dHwInfo_);

    /**
     * Destructor
     */
    inline virtual  ~Acc3dGetHwInfoResult();

    /**
     * Assignment operator
     */
    inline Acc3dGetHwInfoResult& operator = (const Acc3dGetHwInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Acc3dGetHwInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Acc3dGetHwInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Acc3dGetHwInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Acc3dGetHwInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Acc3dHwInfo"

    static const int kAcc3dHwInfo = 0;

    /**
     * Clears the field "Acc3dHwInfo".
     *
     * The field will be set to its default value. The hasAcc3dHwInfo()
     * method will return false.
     */
    inline void clearAcc3dHwInfo();

    /**
     * Checks whether the field "Acc3dHwInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAcc3dHwInfo()). Otherwise it will return false.
     */
    inline bool hasAcc3dHwInfo () const;

    /**
     * Returns the value of the member "Acc3dHwInfo".
     *
     * HW characteristic of the used acc sensors.
     *
     * @return The value of the field "Acc3dHwInfo"
     */
    inline const ::location_fi_types::T_3dAccHwInfo& getAcc3dHwInfo () const;

    /**
     * Retrieves the value of the field "Acc3dHwInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Acc3dHwInfo".
     */
    inline ::location_fi_types::T_3dAccHwInfo& getAcc3dHwInfoMutable ();

    /**
     * Sets the value of the member "Acc3dHwInfo".
     *
     * HW characteristic of the used acc sensors.
     *
     * @param Acc3dHwInfo The value which will be set
     */
    inline void setAcc3dHwInfo (const ::location_fi_types::T_3dAccHwInfo& Acc3dHwInfo_);

    static const Acc3dGetHwInfoResult &getDefaultInstance();

private:

    inline void set_has_Acc3dHwInfo ();

    inline void clear_has_Acc3dHwInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::location_fi_types::T_3dAccHwInfo _Acc3dHwInfo;

};

/**
 * The result message of the method "GyroSelfTest"
 */
class GyroSelfTestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GyroSelfTestResult ();

    /**
     * Copy constructor
     */
    inline  GyroSelfTestResult (const GyroSelfTestResult &rhs);

    /**
     * All fields constructor
     */
    inline  GyroSelfTestResult (bool bSuccess_);

    /**
     * Destructor
     */
    inline virtual  ~GyroSelfTestResult();

    /**
     * Assignment operator
     */
    inline GyroSelfTestResult& operator = (const GyroSelfTestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GyroSelfTestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GyroSelfTestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GyroSelfTestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GyroSelfTestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSuccess"

    static const int kBSuccess = 0;

    /**
     * Clears the field "bSuccess".
     *
     * The field will be set to its default value. The hasBSuccess()
     * method will return false.
     */
    inline void clearBSuccess();

    /**
     * Checks whether the field "bSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSuccess()). Otherwise it will return false.
     */
    inline bool hasBSuccess () const;

    /**
     * Returns the value of the member "bSuccess".
     *
     * TRUE: The device is working properly (self test passed).
     * FALSE: The device is not working properly (self test failed).
     *
     * @return The value of the field "bSuccess"
     */
    inline bool getBSuccess () const;

    /**
     * Sets the value of the member "bSuccess".
     *
     * TRUE: The device is working properly (self test passed).
     * FALSE: The device is not working properly (self test failed).
     *
     * @param bSuccess The value which will be set
     */
    inline void setBSuccess (bool bSuccess_);

    static const GyroSelfTestResult &getDefaultInstance();

private:

    inline void set_has_bSuccess ();

    inline void clear_has_bSuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSuccess;

};

/**
 * The error message of 'GyroSelfTest'
 */
class GyroSelfTestError  : public ::asf::core::Payload {
public:

    enum GyroSelfTestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GyroSelfTestError ();

   /**
     * Copy constructor
     */
    inline  GyroSelfTestError (const GyroSelfTestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GyroSelfTestError();

    /**
     * Assigns a new value to this object.
     */
    inline GyroSelfTestError& operator = (const GyroSelfTestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GyroSelfTestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GyroSelfTestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GyroSelfTestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GyroSelfTestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GyroSelfTestError::GyroSelfTestErrorField getField () const;

    inline void setField(GyroSelfTestError::GyroSelfTestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GyroSelfTestErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GyroSelfTestErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline GyroSelfTestErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GyroSelfTestErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (GyroSelfTestErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GyroSelfTestError &getDefaultInstance();

private:

    inline void cloneData (const GyroSelfTestError& rhs);

    inline void deleteData ();

    GyroSelfTestErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "AccSelfTest"
 */
class AccSelfTestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccSelfTestResult ();

    /**
     * Copy constructor
     */
    inline  AccSelfTestResult (const AccSelfTestResult &rhs);

    /**
     * All fields constructor
     */
    inline  AccSelfTestResult (bool bSuccess_);

    /**
     * Destructor
     */
    inline virtual  ~AccSelfTestResult();

    /**
     * Assignment operator
     */
    inline AccSelfTestResult& operator = (const AccSelfTestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccSelfTestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccSelfTestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccSelfTestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccSelfTestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSuccess"

    static const int kBSuccess = 0;

    /**
     * Clears the field "bSuccess".
     *
     * The field will be set to its default value. The hasBSuccess()
     * method will return false.
     */
    inline void clearBSuccess();

    /**
     * Checks whether the field "bSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSuccess()). Otherwise it will return false.
     */
    inline bool hasBSuccess () const;

    /**
     * Returns the value of the member "bSuccess".
     *
     * TRUE: The device is working properly (self test passed).
     * FALSE: The device is not working properly (self test failed).
     *
     * @return The value of the field "bSuccess"
     */
    inline bool getBSuccess () const;

    /**
     * Sets the value of the member "bSuccess".
     *
     * TRUE: The device is working properly (self test passed).
     * FALSE: The device is not working properly (self test failed).
     *
     * @param bSuccess The value which will be set
     */
    inline void setBSuccess (bool bSuccess_);

    static const AccSelfTestResult &getDefaultInstance();

private:

    inline void set_has_bSuccess ();

    inline void clear_has_bSuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSuccess;

};

/**
 * The error message of 'AccSelfTest'
 */
class AccSelfTestError  : public ::asf::core::Payload {
public:

    enum AccSelfTestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AccSelfTestError ();

   /**
     * Copy constructor
     */
    inline  AccSelfTestError (const AccSelfTestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AccSelfTestError();

    /**
     * Assigns a new value to this object.
     */
    inline AccSelfTestError& operator = (const AccSelfTestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccSelfTestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccSelfTestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccSelfTestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccSelfTestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AccSelfTestError::AccSelfTestErrorField getField () const;

    inline void setField(AccSelfTestError::AccSelfTestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AccSelfTestErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AccSelfTestErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline AccSelfTestErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AccSelfTestErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (AccSelfTestErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AccSelfTestError &getDefaultInstance();

private:

    inline void cloneData (const AccSelfTestError& rhs);

    inline void deleteData ();

    AccSelfTestErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

inline  OdometerData_UpdateStatus::OdometerData_UpdateStatus ()  :
    _OdometerData (),
    _FirstOdomValueIsInitial (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OdometerData_UpdateStatus::OdometerData_UpdateStatus (const OdometerData_UpdateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _OdometerData (),
    _FirstOdomValueIsInitial (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OdometerData_UpdateStatus::OdometerData_UpdateStatus (const ::std::vector< ::location_fi_types::T_OdometerData >& OdometerData_, bool FirstOdomValueIsInitial_)  :
    _OdometerData (OdometerData_),
    _FirstOdomValueIsInitial (FirstOdomValueIsInitial_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OdometerData_UpdateStatus::~OdometerData_UpdateStatus() {
}

inline OdometerData_UpdateStatus& OdometerData_UpdateStatus::operator = (const OdometerData_UpdateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOdometerData()) {
            setOdometerData(rhs.getOdometerData());
        } else {
            clearOdometerData();
        }
        if (rhs.hasFirstOdomValueIsInitial()) {
            setFirstOdomValueIsInitial(rhs.getFirstOdomValueIsInitial());
        } else {
            clearFirstOdomValueIsInitial();
        }
    }
    return *this;
}

inline bool OdometerData_UpdateStatus::operator == (const OdometerData_UpdateStatus& rhs) const {
    return (((!hasOdometerData() && !rhs.hasOdometerData()) || getOdometerData() == rhs.getOdometerData()) &&
        ((!hasFirstOdomValueIsInitial() && !rhs.hasFirstOdomValueIsInitial()) || getFirstOdomValueIsInitial() == rhs.getFirstOdomValueIsInitial()));
}

inline bool OdometerData_UpdateStatus::operator != (const OdometerData_UpdateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool OdometerData_UpdateStatus::operator < (const OdometerData_UpdateStatus& rhs) const {
    if (hasOdometerData() || rhs.hasOdometerData()) {
        if (getOdometerData() < rhs.getOdometerData()) return true;
        if (getOdometerData() > rhs.getOdometerData()) return false;
    }
    if (hasFirstOdomValueIsInitial() || rhs.hasFirstOdomValueIsInitial()) {
        if (getFirstOdomValueIsInitial() < rhs.getFirstOdomValueIsInitial()) return true;
        if (getFirstOdomValueIsInitial() > rhs.getFirstOdomValueIsInitial()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OdometerData_UpdateStatus::clone() {
    return new OdometerData_UpdateStatus(*this);
}

inline bool OdometerData_UpdateStatus::operator > (const OdometerData_UpdateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OdometerData_UpdateStatus::clear() {
    clearOdometerData();
    clearFirstOdomValueIsInitial();
}

inline void OdometerData_UpdateStatus::clearOdometerData() {
    if (hasOdometerData()) {
         clear_has_OdometerData();
        _OdometerData.clear();
     }
}

inline bool OdometerData_UpdateStatus::hasOdometerData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::location_fi_types::T_OdometerData >& OdometerData_UpdateStatus::getOdometerData () const {
    return _OdometerData;
}

inline ::std::vector< ::location_fi_types::T_OdometerData >& OdometerData_UpdateStatus::getOdometerDataMutable () {
    set_has_OdometerData();
    return _OdometerData;
}

inline void OdometerData_UpdateStatus::setOdometerData (const ::std::vector< ::location_fi_types::T_OdometerData >& OdometerData_) {
    set_has_OdometerData();
    this->_OdometerData = OdometerData_;
}

inline void OdometerData_UpdateStatus::clearFirstOdomValueIsInitial() {
    if (hasFirstOdomValueIsInitial()) {
         clear_has_FirstOdomValueIsInitial();
        _FirstOdomValueIsInitial = false;
     }
}

inline bool OdometerData_UpdateStatus::hasFirstOdomValueIsInitial () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool OdometerData_UpdateStatus::getFirstOdomValueIsInitial () const {
    return _FirstOdomValueIsInitial;
}

inline void OdometerData_UpdateStatus::setFirstOdomValueIsInitial (bool FirstOdomValueIsInitial_) {
    set_has_FirstOdomValueIsInitial();
    this->_FirstOdomValueIsInitial = FirstOdomValueIsInitial_;
}

inline void OdometerData_UpdateStatus::set_has_OdometerData () {
    _has_bits_[0] |= 1u << 0;
}

inline void OdometerData_UpdateStatus::clear_has_OdometerData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OdometerData_UpdateStatus::set_has_FirstOdomValueIsInitial () {
    _has_bits_[0] |= 1u << 1;
}

inline void OdometerData_UpdateStatus::clear_has_FirstOdomValueIsInitial () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AbsDataStatus::AbsDataStatus ()  :
    _AbsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbsDataStatus::AbsDataStatus (const AbsDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _AbsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbsDataStatus::AbsDataStatus (const ::std::vector< ::location_fi_types::T_AbsData >& AbsData_)  :
    _AbsData (AbsData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbsDataStatus::~AbsDataStatus() {
}

inline AbsDataStatus& AbsDataStatus::operator = (const AbsDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAbsData()) {
            setAbsData(rhs.getAbsData());
        } else {
            clearAbsData();
        }
    }
    return *this;
}

inline bool AbsDataStatus::operator == (const AbsDataStatus& rhs) const {
    return (((!hasAbsData() && !rhs.hasAbsData()) || getAbsData() == rhs.getAbsData()));
}

inline bool AbsDataStatus::operator != (const AbsDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AbsDataStatus::operator < (const AbsDataStatus& rhs) const {
    if (hasAbsData() || rhs.hasAbsData()) {
        if (getAbsData() < rhs.getAbsData()) return true;
        if (getAbsData() > rhs.getAbsData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AbsDataStatus::clone() {
    return new AbsDataStatus(*this);
}

inline bool AbsDataStatus::operator > (const AbsDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbsDataStatus::clear() {
    clearAbsData();
}

inline void AbsDataStatus::clearAbsData() {
    if (hasAbsData()) {
         clear_has_AbsData();
        _AbsData.clear();
     }
}

inline bool AbsDataStatus::hasAbsData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::location_fi_types::T_AbsData >& AbsDataStatus::getAbsData () const {
    return _AbsData;
}

inline ::std::vector< ::location_fi_types::T_AbsData >& AbsDataStatus::getAbsDataMutable () {
    set_has_AbsData();
    return _AbsData;
}

inline void AbsDataStatus::setAbsData (const ::std::vector< ::location_fi_types::T_AbsData >& AbsData_) {
    set_has_AbsData();
    this->_AbsData = AbsData_;
}

inline void AbsDataStatus::set_has_AbsData () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbsDataStatus::clear_has_AbsData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Gyro3dData_UpdateStatus::Gyro3dData_UpdateStatus ()  :
    _Gyro3dData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Gyro3dData_UpdateStatus::Gyro3dData_UpdateStatus (const Gyro3dData_UpdateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Gyro3dData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Gyro3dData_UpdateStatus::Gyro3dData_UpdateStatus (const ::std::vector< ::location_fi_types::T_3dGyroData >& Gyro3dData_)  :
    _Gyro3dData (Gyro3dData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Gyro3dData_UpdateStatus::~Gyro3dData_UpdateStatus() {
}

inline Gyro3dData_UpdateStatus& Gyro3dData_UpdateStatus::operator = (const Gyro3dData_UpdateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGyro3dData()) {
            setGyro3dData(rhs.getGyro3dData());
        } else {
            clearGyro3dData();
        }
    }
    return *this;
}

inline bool Gyro3dData_UpdateStatus::operator == (const Gyro3dData_UpdateStatus& rhs) const {
    return (((!hasGyro3dData() && !rhs.hasGyro3dData()) || getGyro3dData() == rhs.getGyro3dData()));
}

inline bool Gyro3dData_UpdateStatus::operator != (const Gyro3dData_UpdateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Gyro3dData_UpdateStatus::operator < (const Gyro3dData_UpdateStatus& rhs) const {
    if (hasGyro3dData() || rhs.hasGyro3dData()) {
        if (getGyro3dData() < rhs.getGyro3dData()) return true;
        if (getGyro3dData() > rhs.getGyro3dData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Gyro3dData_UpdateStatus::clone() {
    return new Gyro3dData_UpdateStatus(*this);
}

inline bool Gyro3dData_UpdateStatus::operator > (const Gyro3dData_UpdateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Gyro3dData_UpdateStatus::clear() {
    clearGyro3dData();
}

inline void Gyro3dData_UpdateStatus::clearGyro3dData() {
    if (hasGyro3dData()) {
         clear_has_Gyro3dData();
        _Gyro3dData.clear();
     }
}

inline bool Gyro3dData_UpdateStatus::hasGyro3dData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::location_fi_types::T_3dGyroData >& Gyro3dData_UpdateStatus::getGyro3dData () const {
    return _Gyro3dData;
}

inline ::std::vector< ::location_fi_types::T_3dGyroData >& Gyro3dData_UpdateStatus::getGyro3dDataMutable () {
    set_has_Gyro3dData();
    return _Gyro3dData;
}

inline void Gyro3dData_UpdateStatus::setGyro3dData (const ::std::vector< ::location_fi_types::T_3dGyroData >& Gyro3dData_) {
    set_has_Gyro3dData();
    this->_Gyro3dData = Gyro3dData_;
}

inline void Gyro3dData_UpdateStatus::set_has_Gyro3dData () {
    _has_bits_[0] |= 1u << 0;
}

inline void Gyro3dData_UpdateStatus::clear_has_Gyro3dData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Acc3dData_UpdateStatus::Acc3dData_UpdateStatus ()  :
    _Acc3dData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Acc3dData_UpdateStatus::Acc3dData_UpdateStatus (const Acc3dData_UpdateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Acc3dData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Acc3dData_UpdateStatus::Acc3dData_UpdateStatus (const ::std::vector< ::location_fi_types::T_3dAccData >& Acc3dData_)  :
    _Acc3dData (Acc3dData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Acc3dData_UpdateStatus::~Acc3dData_UpdateStatus() {
}

inline Acc3dData_UpdateStatus& Acc3dData_UpdateStatus::operator = (const Acc3dData_UpdateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAcc3dData()) {
            setAcc3dData(rhs.getAcc3dData());
        } else {
            clearAcc3dData();
        }
    }
    return *this;
}

inline bool Acc3dData_UpdateStatus::operator == (const Acc3dData_UpdateStatus& rhs) const {
    return (((!hasAcc3dData() && !rhs.hasAcc3dData()) || getAcc3dData() == rhs.getAcc3dData()));
}

inline bool Acc3dData_UpdateStatus::operator != (const Acc3dData_UpdateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Acc3dData_UpdateStatus::operator < (const Acc3dData_UpdateStatus& rhs) const {
    if (hasAcc3dData() || rhs.hasAcc3dData()) {
        if (getAcc3dData() < rhs.getAcc3dData()) return true;
        if (getAcc3dData() > rhs.getAcc3dData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Acc3dData_UpdateStatus::clone() {
    return new Acc3dData_UpdateStatus(*this);
}

inline bool Acc3dData_UpdateStatus::operator > (const Acc3dData_UpdateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Acc3dData_UpdateStatus::clear() {
    clearAcc3dData();
}

inline void Acc3dData_UpdateStatus::clearAcc3dData() {
    if (hasAcc3dData()) {
         clear_has_Acc3dData();
        _Acc3dData.clear();
     }
}

inline bool Acc3dData_UpdateStatus::hasAcc3dData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::location_fi_types::T_3dAccData >& Acc3dData_UpdateStatus::getAcc3dData () const {
    return _Acc3dData;
}

inline ::std::vector< ::location_fi_types::T_3dAccData >& Acc3dData_UpdateStatus::getAcc3dDataMutable () {
    set_has_Acc3dData();
    return _Acc3dData;
}

inline void Acc3dData_UpdateStatus::setAcc3dData (const ::std::vector< ::location_fi_types::T_3dAccData >& Acc3dData_) {
    set_has_Acc3dData();
    this->_Acc3dData = Acc3dData_;
}

inline void Acc3dData_UpdateStatus::set_has_Acc3dData () {
    _has_bits_[0] |= 1u << 0;
}

inline void Acc3dData_UpdateStatus::clear_has_Acc3dData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GyroTemperatureStatus::GyroTemperatureStatus ()  :
    _GyroTemperature (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GyroTemperatureStatus::GyroTemperatureStatus (const GyroTemperatureStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _GyroTemperature (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GyroTemperatureStatus::GyroTemperatureStatus (float GyroTemperature_)  :
    _GyroTemperature (GyroTemperature_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GyroTemperatureStatus::~GyroTemperatureStatus() {
}

inline GyroTemperatureStatus& GyroTemperatureStatus::operator = (const GyroTemperatureStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGyroTemperature()) {
            setGyroTemperature(rhs.getGyroTemperature());
        } else {
            clearGyroTemperature();
        }
    }
    return *this;
}

inline bool GyroTemperatureStatus::operator == (const GyroTemperatureStatus& rhs) const {
    return (((!hasGyroTemperature() && !rhs.hasGyroTemperature()) || getGyroTemperature() == rhs.getGyroTemperature()));
}

inline bool GyroTemperatureStatus::operator != (const GyroTemperatureStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GyroTemperatureStatus::operator < (const GyroTemperatureStatus& rhs) const {
    if (hasGyroTemperature() || rhs.hasGyroTemperature()) {
        if (getGyroTemperature() < rhs.getGyroTemperature()) return true;
        if (getGyroTemperature() > rhs.getGyroTemperature()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GyroTemperatureStatus::clone() {
    return new GyroTemperatureStatus(*this);
}

inline bool GyroTemperatureStatus::operator > (const GyroTemperatureStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GyroTemperatureStatus::clear() {
    clearGyroTemperature();
}

inline void GyroTemperatureStatus::clearGyroTemperature() {
    if (hasGyroTemperature()) {
         clear_has_GyroTemperature();
        _GyroTemperature = 0.0f;
     }
}

inline bool GyroTemperatureStatus::hasGyroTemperature () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline float GyroTemperatureStatus::getGyroTemperature () const {
    return _GyroTemperature;
}

inline void GyroTemperatureStatus::setGyroTemperature (float GyroTemperature_) {
    set_has_GyroTemperature();
    this->_GyroTemperature = GyroTemperature_;
}

inline void GyroTemperatureStatus::set_has_GyroTemperature () {
    _has_bits_[0] |= 1u << 0;
}

inline void GyroTemperatureStatus::clear_has_GyroTemperature () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GyroTemperatureError::GyroTemperatureError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::GyroTemperatureErrorCode__Unspecified;
}

inline  GyroTemperatureError::GyroTemperatureError (const GyroTemperatureError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::GyroTemperatureErrorCode__Unspecified;
    *this = rhs;
}

inline  GyroTemperatureError::~GyroTemperatureError() {
    deleteData ();
}

inline GyroTemperatureError& GyroTemperatureError::operator = (const GyroTemperatureError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GyroTemperatureError::operator == (const GyroTemperatureError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GyroTemperatureError::operator != (const GyroTemperatureError& rhs) const {
    return ! (*this == rhs);
}

inline bool GyroTemperatureError::operator < (const GyroTemperatureError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GyroTemperatureError::operator > (const GyroTemperatureError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GyroTemperatureError::GyroTemperatureErrorField GyroTemperatureError::getField () const {
    return __field;
}

inline void GyroTemperatureError::setField(GyroTemperatureError::GyroTemperatureErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::sensor_location_fi::GyroTemperatureErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GyroTemperatureError::clone() {
    return new GyroTemperatureError(*this);
}

inline bool GyroTemperatureError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline GyroTemperatureErrorCode GyroTemperatureError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GyroTemperatureError", getField());
    }
    return (GyroTemperatureErrorCode) _data.ccaErrorCode_;
}

inline void GyroTemperatureError::setCcaErrorCode (GyroTemperatureErrorCode value) {
    #ifndef NDEBUG
    if (!(GyroTemperatureErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "GyroTemperatureErrorCode", "ccaErrorCode", "GyroTemperatureError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool GyroTemperatureError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GyroTemperatureError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GyroTemperatureError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GyroTemperatureError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GyroTemperatureError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GyroTemperatureError::cloneData (const GyroTemperatureError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GyroTemperatureError::deleteData () {
}

inline  GnssSatSystemStatus::GnssSatSystemStatus ()  :
    _ActualGnssSatSys ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GnssSatSystemStatus::GnssSatSystemStatus (const GnssSatSystemStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ActualGnssSatSys ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GnssSatSystemStatus::GnssSatSystemStatus (const ::location_fi_types::T_b8_GnssSatSys& ActualGnssSatSys_)  :
    _ActualGnssSatSys (ActualGnssSatSys_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GnssSatSystemStatus::~GnssSatSystemStatus() {
}

inline GnssSatSystemStatus& GnssSatSystemStatus::operator = (const GnssSatSystemStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActualGnssSatSys()) {
            setActualGnssSatSys(rhs.getActualGnssSatSys());
        } else {
            clearActualGnssSatSys();
        }
    }
    return *this;
}

inline bool GnssSatSystemStatus::operator == (const GnssSatSystemStatus& rhs) const {
    return (((!hasActualGnssSatSys() && !rhs.hasActualGnssSatSys()) || getActualGnssSatSys() == rhs.getActualGnssSatSys()));
}

inline bool GnssSatSystemStatus::operator != (const GnssSatSystemStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GnssSatSystemStatus::operator < (const GnssSatSystemStatus& rhs) const {
    if (hasActualGnssSatSys() || rhs.hasActualGnssSatSys()) {
        if (getActualGnssSatSys() < rhs.getActualGnssSatSys()) return true;
        if (getActualGnssSatSys() > rhs.getActualGnssSatSys()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GnssSatSystemStatus::clone() {
    return new GnssSatSystemStatus(*this);
}

inline bool GnssSatSystemStatus::operator > (const GnssSatSystemStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GnssSatSystemStatus::clear() {
    clearActualGnssSatSys();
}

inline void GnssSatSystemStatus::clearActualGnssSatSys() {
    if (hasActualGnssSatSys()) {
         clear_has_ActualGnssSatSys();
        _ActualGnssSatSys = ::location_fi_types::T_b8_GnssSatSys ();
     }
}

inline bool GnssSatSystemStatus::hasActualGnssSatSys () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_b8_GnssSatSys& GnssSatSystemStatus::getActualGnssSatSys () const {
    return _ActualGnssSatSys;
}

inline ::location_fi_types::T_b8_GnssSatSys& GnssSatSystemStatus::getActualGnssSatSysMutable () {
    set_has_ActualGnssSatSys();
    return _ActualGnssSatSys;
}

inline void GnssSatSystemStatus::setActualGnssSatSys (const ::location_fi_types::T_b8_GnssSatSys& ActualGnssSatSys_) {
    set_has_ActualGnssSatSys();
    this->_ActualGnssSatSys = ActualGnssSatSys_;
}

inline void GnssSatSystemStatus::set_has_ActualGnssSatSys () {
    _has_bits_[0] |= 1u << 0;
}

inline void GnssSatSystemStatus::clear_has_ActualGnssSatSys () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GnssSatSystemSet::GnssSatSystemSet ()  :
    _TargetGnssSatSys ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GnssSatSystemSet::GnssSatSystemSet (const GnssSatSystemSet &rhs)  :
    ::asf::core::Payload(rhs),
    _TargetGnssSatSys ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GnssSatSystemSet::GnssSatSystemSet (const ::location_fi_types::T_b8_GnssSatSys& TargetGnssSatSys_)  :
    _TargetGnssSatSys (TargetGnssSatSys_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GnssSatSystemSet::~GnssSatSystemSet() {
}

inline GnssSatSystemSet& GnssSatSystemSet::operator = (const GnssSatSystemSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTargetGnssSatSys()) {
            setTargetGnssSatSys(rhs.getTargetGnssSatSys());
        } else {
            clearTargetGnssSatSys();
        }
    }
    return *this;
}

inline bool GnssSatSystemSet::operator == (const GnssSatSystemSet& rhs) const {
    return (((!hasTargetGnssSatSys() && !rhs.hasTargetGnssSatSys()) || getTargetGnssSatSys() == rhs.getTargetGnssSatSys()));
}

inline bool GnssSatSystemSet::operator != (const GnssSatSystemSet& rhs) const {
    return ! (*this == rhs);
}

inline bool GnssSatSystemSet::operator < (const GnssSatSystemSet& rhs) const {
    if (hasTargetGnssSatSys() || rhs.hasTargetGnssSatSys()) {
        if (getTargetGnssSatSys() < rhs.getTargetGnssSatSys()) return true;
        if (getTargetGnssSatSys() > rhs.getTargetGnssSatSys()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GnssSatSystemSet::clone() {
    return new GnssSatSystemSet(*this);
}

inline bool GnssSatSystemSet::operator > (const GnssSatSystemSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GnssSatSystemSet::clear() {
    clearTargetGnssSatSys();
}

inline void GnssSatSystemSet::clearTargetGnssSatSys() {
    if (hasTargetGnssSatSys()) {
         clear_has_TargetGnssSatSys();
        _TargetGnssSatSys = ::location_fi_types::T_b8_GnssSatSys ();
     }
}

inline bool GnssSatSystemSet::hasTargetGnssSatSys () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_b8_GnssSatSys& GnssSatSystemSet::getTargetGnssSatSys () const {
    return _TargetGnssSatSys;
}

inline ::location_fi_types::T_b8_GnssSatSys& GnssSatSystemSet::getTargetGnssSatSysMutable () {
    set_has_TargetGnssSatSys();
    return _TargetGnssSatSys;
}

inline void GnssSatSystemSet::setTargetGnssSatSys (const ::location_fi_types::T_b8_GnssSatSys& TargetGnssSatSys_) {
    set_has_TargetGnssSatSys();
    this->_TargetGnssSatSys = TargetGnssSatSys_;
}

inline void GnssSatSystemSet::set_has_TargetGnssSatSys () {
    _has_bits_[0] |= 1u << 0;
}

inline void GnssSatSystemSet::clear_has_TargetGnssSatSys () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GnssWnEpochStatus::GnssWnEpochStatus ()  :
    _ActualWnDate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GnssWnEpochStatus::GnssWnEpochStatus (const GnssWnEpochStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ActualWnDate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GnssWnEpochStatus::GnssWnEpochStatus (const ::location_fi_types::T_TimeDate& ActualWnDate_)  :
    _ActualWnDate (ActualWnDate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GnssWnEpochStatus::~GnssWnEpochStatus() {
}

inline GnssWnEpochStatus& GnssWnEpochStatus::operator = (const GnssWnEpochStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActualWnDate()) {
            setActualWnDate(rhs.getActualWnDate());
        } else {
            clearActualWnDate();
        }
    }
    return *this;
}

inline bool GnssWnEpochStatus::operator == (const GnssWnEpochStatus& rhs) const {
    return (((!hasActualWnDate() && !rhs.hasActualWnDate()) || getActualWnDate() == rhs.getActualWnDate()));
}

inline bool GnssWnEpochStatus::operator != (const GnssWnEpochStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GnssWnEpochStatus::operator < (const GnssWnEpochStatus& rhs) const {
    if (hasActualWnDate() || rhs.hasActualWnDate()) {
        if (getActualWnDate() < rhs.getActualWnDate()) return true;
        if (getActualWnDate() > rhs.getActualWnDate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GnssWnEpochStatus::clone() {
    return new GnssWnEpochStatus(*this);
}

inline bool GnssWnEpochStatus::operator > (const GnssWnEpochStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GnssWnEpochStatus::clear() {
    clearActualWnDate();
}

inline void GnssWnEpochStatus::clearActualWnDate() {
    if (hasActualWnDate()) {
         clear_has_ActualWnDate();
        _ActualWnDate.clear();
     }
}

inline bool GnssWnEpochStatus::hasActualWnDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_TimeDate& GnssWnEpochStatus::getActualWnDate () const {
    return _ActualWnDate;
}

inline ::location_fi_types::T_TimeDate& GnssWnEpochStatus::getActualWnDateMutable () {
    set_has_ActualWnDate();
    return _ActualWnDate;
}

inline void GnssWnEpochStatus::setActualWnDate (const ::location_fi_types::T_TimeDate& ActualWnDate_) {
    set_has_ActualWnDate();
    this->_ActualWnDate = ActualWnDate_;
}

inline void GnssWnEpochStatus::set_has_ActualWnDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void GnssWnEpochStatus::clear_has_ActualWnDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GnssWnEpochSet::GnssWnEpochSet ()  :
    _TargetWnDate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GnssWnEpochSet::GnssWnEpochSet (const GnssWnEpochSet &rhs)  :
    ::asf::core::Payload(rhs),
    _TargetWnDate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GnssWnEpochSet::GnssWnEpochSet (const ::location_fi_types::T_TimeDate& TargetWnDate_)  :
    _TargetWnDate (TargetWnDate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GnssWnEpochSet::~GnssWnEpochSet() {
}

inline GnssWnEpochSet& GnssWnEpochSet::operator = (const GnssWnEpochSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTargetWnDate()) {
            setTargetWnDate(rhs.getTargetWnDate());
        } else {
            clearTargetWnDate();
        }
    }
    return *this;
}

inline bool GnssWnEpochSet::operator == (const GnssWnEpochSet& rhs) const {
    return (((!hasTargetWnDate() && !rhs.hasTargetWnDate()) || getTargetWnDate() == rhs.getTargetWnDate()));
}

inline bool GnssWnEpochSet::operator != (const GnssWnEpochSet& rhs) const {
    return ! (*this == rhs);
}

inline bool GnssWnEpochSet::operator < (const GnssWnEpochSet& rhs) const {
    if (hasTargetWnDate() || rhs.hasTargetWnDate()) {
        if (getTargetWnDate() < rhs.getTargetWnDate()) return true;
        if (getTargetWnDate() > rhs.getTargetWnDate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GnssWnEpochSet::clone() {
    return new GnssWnEpochSet(*this);
}

inline bool GnssWnEpochSet::operator > (const GnssWnEpochSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GnssWnEpochSet::clear() {
    clearTargetWnDate();
}

inline void GnssWnEpochSet::clearTargetWnDate() {
    if (hasTargetWnDate()) {
         clear_has_TargetWnDate();
        _TargetWnDate.clear();
     }
}

inline bool GnssWnEpochSet::hasTargetWnDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_TimeDate& GnssWnEpochSet::getTargetWnDate () const {
    return _TargetWnDate;
}

inline ::location_fi_types::T_TimeDate& GnssWnEpochSet::getTargetWnDateMutable () {
    set_has_TargetWnDate();
    return _TargetWnDate;
}

inline void GnssWnEpochSet::setTargetWnDate (const ::location_fi_types::T_TimeDate& TargetWnDate_) {
    set_has_TargetWnDate();
    this->_TargetWnDate = TargetWnDate_;
}

inline void GnssWnEpochSet::set_has_TargetWnDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void GnssWnEpochSet::clear_has_TargetWnDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GnssConfigDataStatus::GnssConfigDataStatus ()  :
    _GnssConfigData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GnssConfigDataStatus::GnssConfigDataStatus (const GnssConfigDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _GnssConfigData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GnssConfigDataStatus::GnssConfigDataStatus (const ::location_fi_types::T_GnssConfigData& GnssConfigData_)  :
    _GnssConfigData (GnssConfigData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GnssConfigDataStatus::~GnssConfigDataStatus() {
}

inline GnssConfigDataStatus& GnssConfigDataStatus::operator = (const GnssConfigDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGnssConfigData()) {
            setGnssConfigData(rhs.getGnssConfigData());
        } else {
            clearGnssConfigData();
        }
    }
    return *this;
}

inline bool GnssConfigDataStatus::operator == (const GnssConfigDataStatus& rhs) const {
    return (((!hasGnssConfigData() && !rhs.hasGnssConfigData()) || getGnssConfigData() == rhs.getGnssConfigData()));
}

inline bool GnssConfigDataStatus::operator != (const GnssConfigDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GnssConfigDataStatus::operator < (const GnssConfigDataStatus& rhs) const {
    if (hasGnssConfigData() || rhs.hasGnssConfigData()) {
        if (getGnssConfigData() < rhs.getGnssConfigData()) return true;
        if (getGnssConfigData() > rhs.getGnssConfigData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GnssConfigDataStatus::clone() {
    return new GnssConfigDataStatus(*this);
}

inline bool GnssConfigDataStatus::operator > (const GnssConfigDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GnssConfigDataStatus::clear() {
    clearGnssConfigData();
}

inline void GnssConfigDataStatus::clearGnssConfigData() {
    if (hasGnssConfigData()) {
         clear_has_GnssConfigData();
        _GnssConfigData.clear();
     }
}

inline bool GnssConfigDataStatus::hasGnssConfigData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_GnssConfigData& GnssConfigDataStatus::getGnssConfigData () const {
    return _GnssConfigData;
}

inline ::location_fi_types::T_GnssConfigData& GnssConfigDataStatus::getGnssConfigDataMutable () {
    set_has_GnssConfigData();
    return _GnssConfigData;
}

inline void GnssConfigDataStatus::setGnssConfigData (const ::location_fi_types::T_GnssConfigData& GnssConfigData_) {
    set_has_GnssConfigData();
    this->_GnssConfigData = GnssConfigData_;
}

inline void GnssConfigDataStatus::set_has_GnssConfigData () {
    _has_bits_[0] |= 1u << 0;
}

inline void GnssConfigDataStatus::clear_has_GnssConfigData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GnssDataStatus::GnssDataStatus ()  :
    _GnssData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GnssDataStatus::GnssDataStatus (const GnssDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _GnssData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GnssDataStatus::GnssDataStatus (const ::location_fi_types::T_GnssData& GnssData_)  :
    _GnssData (GnssData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GnssDataStatus::~GnssDataStatus() {
}

inline GnssDataStatus& GnssDataStatus::operator = (const GnssDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGnssData()) {
            setGnssData(rhs.getGnssData());
        } else {
            clearGnssData();
        }
    }
    return *this;
}

inline bool GnssDataStatus::operator == (const GnssDataStatus& rhs) const {
    return (((!hasGnssData() && !rhs.hasGnssData()) || getGnssData() == rhs.getGnssData()));
}

inline bool GnssDataStatus::operator != (const GnssDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GnssDataStatus::operator < (const GnssDataStatus& rhs) const {
    if (hasGnssData() || rhs.hasGnssData()) {
        if (getGnssData() < rhs.getGnssData()) return true;
        if (getGnssData() > rhs.getGnssData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GnssDataStatus::clone() {
    return new GnssDataStatus(*this);
}

inline bool GnssDataStatus::operator > (const GnssDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GnssDataStatus::clear() {
    clearGnssData();
}

inline void GnssDataStatus::clearGnssData() {
    if (hasGnssData()) {
         clear_has_GnssData();
        _GnssData.clear();
     }
}

inline bool GnssDataStatus::hasGnssData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_GnssData& GnssDataStatus::getGnssData () const {
    return _GnssData;
}

inline ::location_fi_types::T_GnssData& GnssDataStatus::getGnssDataMutable () {
    set_has_GnssData();
    return _GnssData;
}

inline void GnssDataStatus::setGnssData (const ::location_fi_types::T_GnssData& GnssData_) {
    set_has_GnssData();
    this->_GnssData = GnssData_;
}

inline void GnssDataStatus::set_has_GnssData () {
    _has_bits_[0] |= 1u << 0;
}

inline void GnssDataStatus::clear_has_GnssData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AllSensorDataStatus::AllSensorDataStatus ()  :
    _SensorDataBlock ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AllSensorDataStatus::AllSensorDataStatus (const AllSensorDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SensorDataBlock ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AllSensorDataStatus::AllSensorDataStatus (const ::location_fi_types::T_AllSensorData& SensorDataBlock_)  :
    _SensorDataBlock (SensorDataBlock_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AllSensorDataStatus::~AllSensorDataStatus() {
}

inline AllSensorDataStatus& AllSensorDataStatus::operator = (const AllSensorDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSensorDataBlock()) {
            setSensorDataBlock(rhs.getSensorDataBlock());
        } else {
            clearSensorDataBlock();
        }
    }
    return *this;
}

inline bool AllSensorDataStatus::operator == (const AllSensorDataStatus& rhs) const {
    return (((!hasSensorDataBlock() && !rhs.hasSensorDataBlock()) || getSensorDataBlock() == rhs.getSensorDataBlock()));
}

inline bool AllSensorDataStatus::operator != (const AllSensorDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AllSensorDataStatus::operator < (const AllSensorDataStatus& rhs) const {
    if (hasSensorDataBlock() || rhs.hasSensorDataBlock()) {
        if (getSensorDataBlock() < rhs.getSensorDataBlock()) return true;
        if (getSensorDataBlock() > rhs.getSensorDataBlock()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AllSensorDataStatus::clone() {
    return new AllSensorDataStatus(*this);
}

inline bool AllSensorDataStatus::operator > (const AllSensorDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AllSensorDataStatus::clear() {
    clearSensorDataBlock();
}

inline void AllSensorDataStatus::clearSensorDataBlock() {
    if (hasSensorDataBlock()) {
         clear_has_SensorDataBlock();
        _SensorDataBlock.clear();
     }
}

inline bool AllSensorDataStatus::hasSensorDataBlock () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_AllSensorData& AllSensorDataStatus::getSensorDataBlock () const {
    return _SensorDataBlock;
}

inline ::location_fi_types::T_AllSensorData& AllSensorDataStatus::getSensorDataBlockMutable () {
    set_has_SensorDataBlock();
    return _SensorDataBlock;
}

inline void AllSensorDataStatus::setSensorDataBlock (const ::location_fi_types::T_AllSensorData& SensorDataBlock_) {
    set_has_SensorDataBlock();
    this->_SensorDataBlock = SensorDataBlock_;
}

inline void AllSensorDataStatus::set_has_SensorDataBlock () {
    _has_bits_[0] |= 1u << 0;
}

inline void AllSensorDataStatus::clear_has_SensorDataBlock () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VdsVersionInfoStatus::VdsVersionInfoStatus ()  :
    _VdsVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VdsVersionInfoStatus::VdsVersionInfoStatus (const VdsVersionInfoStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _VdsVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VdsVersionInfoStatus::VdsVersionInfoStatus (const ::location_fi_types::T_VdsVersionInfo& VdsVersion_)  :
    _VdsVersion (VdsVersion_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VdsVersionInfoStatus::~VdsVersionInfoStatus() {
}

inline VdsVersionInfoStatus& VdsVersionInfoStatus::operator = (const VdsVersionInfoStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVdsVersion()) {
            setVdsVersion(rhs.getVdsVersion());
        } else {
            clearVdsVersion();
        }
    }
    return *this;
}

inline bool VdsVersionInfoStatus::operator == (const VdsVersionInfoStatus& rhs) const {
    return (((!hasVdsVersion() && !rhs.hasVdsVersion()) || getVdsVersion() == rhs.getVdsVersion()));
}

inline bool VdsVersionInfoStatus::operator != (const VdsVersionInfoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool VdsVersionInfoStatus::operator < (const VdsVersionInfoStatus& rhs) const {
    if (hasVdsVersion() || rhs.hasVdsVersion()) {
        if (getVdsVersion() < rhs.getVdsVersion()) return true;
        if (getVdsVersion() > rhs.getVdsVersion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VdsVersionInfoStatus::clone() {
    return new VdsVersionInfoStatus(*this);
}

inline bool VdsVersionInfoStatus::operator > (const VdsVersionInfoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VdsVersionInfoStatus::clear() {
    clearVdsVersion();
}

inline void VdsVersionInfoStatus::clearVdsVersion() {
    if (hasVdsVersion()) {
         clear_has_VdsVersion();
        _VdsVersion.clear();
     }
}

inline bool VdsVersionInfoStatus::hasVdsVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_VdsVersionInfo& VdsVersionInfoStatus::getVdsVersion () const {
    return _VdsVersion;
}

inline ::location_fi_types::T_VdsVersionInfo& VdsVersionInfoStatus::getVdsVersionMutable () {
    set_has_VdsVersion();
    return _VdsVersion;
}

inline void VdsVersionInfoStatus::setVdsVersion (const ::location_fi_types::T_VdsVersionInfo& VdsVersion_) {
    set_has_VdsVersion();
    this->_VdsVersion = VdsVersion_;
}

inline void VdsVersionInfoStatus::set_has_VdsVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void VdsVersionInfoStatus::clear_has_VdsVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AccTemperatureStatus::AccTemperatureStatus ()  :
    _AccTemperature (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AccTemperatureStatus::AccTemperatureStatus (const AccTemperatureStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _AccTemperature (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AccTemperatureStatus::AccTemperatureStatus (float AccTemperature_)  :
    _AccTemperature (AccTemperature_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AccTemperatureStatus::~AccTemperatureStatus() {
}

inline AccTemperatureStatus& AccTemperatureStatus::operator = (const AccTemperatureStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAccTemperature()) {
            setAccTemperature(rhs.getAccTemperature());
        } else {
            clearAccTemperature();
        }
    }
    return *this;
}

inline bool AccTemperatureStatus::operator == (const AccTemperatureStatus& rhs) const {
    return (((!hasAccTemperature() && !rhs.hasAccTemperature()) || getAccTemperature() == rhs.getAccTemperature()));
}

inline bool AccTemperatureStatus::operator != (const AccTemperatureStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AccTemperatureStatus::operator < (const AccTemperatureStatus& rhs) const {
    if (hasAccTemperature() || rhs.hasAccTemperature()) {
        if (getAccTemperature() < rhs.getAccTemperature()) return true;
        if (getAccTemperature() > rhs.getAccTemperature()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AccTemperatureStatus::clone() {
    return new AccTemperatureStatus(*this);
}

inline bool AccTemperatureStatus::operator > (const AccTemperatureStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AccTemperatureStatus::clear() {
    clearAccTemperature();
}

inline void AccTemperatureStatus::clearAccTemperature() {
    if (hasAccTemperature()) {
         clear_has_AccTemperature();
        _AccTemperature = 0.0f;
     }
}

inline bool AccTemperatureStatus::hasAccTemperature () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline float AccTemperatureStatus::getAccTemperature () const {
    return _AccTemperature;
}

inline void AccTemperatureStatus::setAccTemperature (float AccTemperature_) {
    set_has_AccTemperature();
    this->_AccTemperature = AccTemperature_;
}

inline void AccTemperatureStatus::set_has_AccTemperature () {
    _has_bits_[0] |= 1u << 0;
}

inline void AccTemperatureStatus::clear_has_AccTemperature () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AccTemperatureError::AccTemperatureError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::AccTemperatureErrorCode__Unspecified;
}

inline  AccTemperatureError::AccTemperatureError (const AccTemperatureError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::AccTemperatureErrorCode__Unspecified;
    *this = rhs;
}

inline  AccTemperatureError::~AccTemperatureError() {
    deleteData ();
}

inline AccTemperatureError& AccTemperatureError::operator = (const AccTemperatureError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AccTemperatureError::operator == (const AccTemperatureError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AccTemperatureError::operator != (const AccTemperatureError& rhs) const {
    return ! (*this == rhs);
}

inline bool AccTemperatureError::operator < (const AccTemperatureError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AccTemperatureError::operator > (const AccTemperatureError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AccTemperatureError::AccTemperatureErrorField AccTemperatureError::getField () const {
    return __field;
}

inline void AccTemperatureError::setField(AccTemperatureError::AccTemperatureErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::sensor_location_fi::AccTemperatureErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AccTemperatureError::clone() {
    return new AccTemperatureError(*this);
}

inline bool AccTemperatureError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline AccTemperatureErrorCode AccTemperatureError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AccTemperatureError", getField());
    }
    return (AccTemperatureErrorCode) _data.ccaErrorCode_;
}

inline void AccTemperatureError::setCcaErrorCode (AccTemperatureErrorCode value) {
    #ifndef NDEBUG
    if (!(AccTemperatureErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "AccTemperatureErrorCode", "ccaErrorCode", "AccTemperatureError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool AccTemperatureError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AccTemperatureError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AccTemperatureError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AccTemperatureError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AccTemperatureError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AccTemperatureError::cloneData (const AccTemperatureError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AccTemperatureError::deleteData () {
}

inline  DiagGnssSatSystemStatus::DiagGnssSatSystemStatus ()  :
    _ActualGnssSatSys ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagGnssSatSystemStatus::DiagGnssSatSystemStatus (const DiagGnssSatSystemStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ActualGnssSatSys ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagGnssSatSystemStatus::DiagGnssSatSystemStatus (const ::location_fi_types::T_b8_GnssSatSys& ActualGnssSatSys_)  :
    _ActualGnssSatSys (ActualGnssSatSys_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagGnssSatSystemStatus::~DiagGnssSatSystemStatus() {
}

inline DiagGnssSatSystemStatus& DiagGnssSatSystemStatus::operator = (const DiagGnssSatSystemStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActualGnssSatSys()) {
            setActualGnssSatSys(rhs.getActualGnssSatSys());
        } else {
            clearActualGnssSatSys();
        }
    }
    return *this;
}

inline bool DiagGnssSatSystemStatus::operator == (const DiagGnssSatSystemStatus& rhs) const {
    return (((!hasActualGnssSatSys() && !rhs.hasActualGnssSatSys()) || getActualGnssSatSys() == rhs.getActualGnssSatSys()));
}

inline bool DiagGnssSatSystemStatus::operator != (const DiagGnssSatSystemStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagGnssSatSystemStatus::operator < (const DiagGnssSatSystemStatus& rhs) const {
    if (hasActualGnssSatSys() || rhs.hasActualGnssSatSys()) {
        if (getActualGnssSatSys() < rhs.getActualGnssSatSys()) return true;
        if (getActualGnssSatSys() > rhs.getActualGnssSatSys()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagGnssSatSystemStatus::clone() {
    return new DiagGnssSatSystemStatus(*this);
}

inline bool DiagGnssSatSystemStatus::operator > (const DiagGnssSatSystemStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagGnssSatSystemStatus::clear() {
    clearActualGnssSatSys();
}

inline void DiagGnssSatSystemStatus::clearActualGnssSatSys() {
    if (hasActualGnssSatSys()) {
         clear_has_ActualGnssSatSys();
        _ActualGnssSatSys = ::location_fi_types::T_b8_GnssSatSys ();
     }
}

inline bool DiagGnssSatSystemStatus::hasActualGnssSatSys () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_b8_GnssSatSys& DiagGnssSatSystemStatus::getActualGnssSatSys () const {
    return _ActualGnssSatSys;
}

inline ::location_fi_types::T_b8_GnssSatSys& DiagGnssSatSystemStatus::getActualGnssSatSysMutable () {
    set_has_ActualGnssSatSys();
    return _ActualGnssSatSys;
}

inline void DiagGnssSatSystemStatus::setActualGnssSatSys (const ::location_fi_types::T_b8_GnssSatSys& ActualGnssSatSys_) {
    set_has_ActualGnssSatSys();
    this->_ActualGnssSatSys = ActualGnssSatSys_;
}

inline void DiagGnssSatSystemStatus::set_has_ActualGnssSatSys () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagGnssSatSystemStatus::clear_has_ActualGnssSatSys () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiagGnssSatSystemSet::DiagGnssSatSystemSet ()  :
    _TargetGnssSatSys ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagGnssSatSystemSet::DiagGnssSatSystemSet (const DiagGnssSatSystemSet &rhs)  :
    ::asf::core::Payload(rhs),
    _TargetGnssSatSys ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagGnssSatSystemSet::DiagGnssSatSystemSet (const ::location_fi_types::T_b8_GnssSatSys& TargetGnssSatSys_)  :
    _TargetGnssSatSys (TargetGnssSatSys_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagGnssSatSystemSet::~DiagGnssSatSystemSet() {
}

inline DiagGnssSatSystemSet& DiagGnssSatSystemSet::operator = (const DiagGnssSatSystemSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTargetGnssSatSys()) {
            setTargetGnssSatSys(rhs.getTargetGnssSatSys());
        } else {
            clearTargetGnssSatSys();
        }
    }
    return *this;
}

inline bool DiagGnssSatSystemSet::operator == (const DiagGnssSatSystemSet& rhs) const {
    return (((!hasTargetGnssSatSys() && !rhs.hasTargetGnssSatSys()) || getTargetGnssSatSys() == rhs.getTargetGnssSatSys()));
}

inline bool DiagGnssSatSystemSet::operator != (const DiagGnssSatSystemSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagGnssSatSystemSet::operator < (const DiagGnssSatSystemSet& rhs) const {
    if (hasTargetGnssSatSys() || rhs.hasTargetGnssSatSys()) {
        if (getTargetGnssSatSys() < rhs.getTargetGnssSatSys()) return true;
        if (getTargetGnssSatSys() > rhs.getTargetGnssSatSys()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagGnssSatSystemSet::clone() {
    return new DiagGnssSatSystemSet(*this);
}

inline bool DiagGnssSatSystemSet::operator > (const DiagGnssSatSystemSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagGnssSatSystemSet::clear() {
    clearTargetGnssSatSys();
}

inline void DiagGnssSatSystemSet::clearTargetGnssSatSys() {
    if (hasTargetGnssSatSys()) {
         clear_has_TargetGnssSatSys();
        _TargetGnssSatSys = ::location_fi_types::T_b8_GnssSatSys ();
     }
}

inline bool DiagGnssSatSystemSet::hasTargetGnssSatSys () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_b8_GnssSatSys& DiagGnssSatSystemSet::getTargetGnssSatSys () const {
    return _TargetGnssSatSys;
}

inline ::location_fi_types::T_b8_GnssSatSys& DiagGnssSatSystemSet::getTargetGnssSatSysMutable () {
    set_has_TargetGnssSatSys();
    return _TargetGnssSatSys;
}

inline void DiagGnssSatSystemSet::setTargetGnssSatSys (const ::location_fi_types::T_b8_GnssSatSys& TargetGnssSatSys_) {
    set_has_TargetGnssSatSys();
    this->_TargetGnssSatSys = TargetGnssSatSys_;
}

inline void DiagGnssSatSystemSet::set_has_TargetGnssSatSys () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagGnssSatSystemSet::clear_has_TargetGnssSatSys () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SavePersistentResult::SavePersistentResult ()  :
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SavePersistentResult::SavePersistentResult (const SavePersistentResult &rhs)  :
    ::asf::core::Payload(rhs),
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SavePersistentResult::SavePersistentResult (bool bSuccess_)  :
    _bSuccess (bSuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SavePersistentResult::~SavePersistentResult() {
}

inline SavePersistentResult& SavePersistentResult::operator = (const SavePersistentResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSuccess()) {
            setBSuccess(rhs.getBSuccess());
        } else {
            clearBSuccess();
        }
    }
    return *this;
}

inline bool SavePersistentResult::operator == (const SavePersistentResult& rhs) const {
    return (((!hasBSuccess() && !rhs.hasBSuccess()) || getBSuccess() == rhs.getBSuccess()));
}

inline bool SavePersistentResult::operator != (const SavePersistentResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SavePersistentResult::operator < (const SavePersistentResult& rhs) const {
    if (hasBSuccess() || rhs.hasBSuccess()) {
        if (getBSuccess() < rhs.getBSuccess()) return true;
        if (getBSuccess() > rhs.getBSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SavePersistentResult::clone() {
    return new SavePersistentResult(*this);
}

inline bool SavePersistentResult::operator > (const SavePersistentResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SavePersistentResult::clear() {
    clearBSuccess();
}

inline void SavePersistentResult::clearBSuccess() {
    if (hasBSuccess()) {
         clear_has_bSuccess();
        _bSuccess = false;
     }
}

inline bool SavePersistentResult::hasBSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SavePersistentResult::getBSuccess () const {
    return _bSuccess;
}

inline void SavePersistentResult::setBSuccess (bool bSuccess_) {
    set_has_bSuccess();
    this->_bSuccess = bSuccess_;
}

inline void SavePersistentResult::set_has_bSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void SavePersistentResult::clear_has_bSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SavePersistentError::SavePersistentError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::SavePersistentErrorCode__Unspecified;
}

inline  SavePersistentError::SavePersistentError (const SavePersistentError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::SavePersistentErrorCode__Unspecified;
    *this = rhs;
}

inline  SavePersistentError::~SavePersistentError() {
    deleteData ();
}

inline SavePersistentError& SavePersistentError::operator = (const SavePersistentError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SavePersistentError::operator == (const SavePersistentError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SavePersistentError::operator != (const SavePersistentError& rhs) const {
    return ! (*this == rhs);
}

inline bool SavePersistentError::operator < (const SavePersistentError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SavePersistentError::operator > (const SavePersistentError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SavePersistentError::SavePersistentErrorField SavePersistentError::getField () const {
    return __field;
}

inline void SavePersistentError::setField(SavePersistentError::SavePersistentErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::sensor_location_fi::SavePersistentErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SavePersistentError::clone() {
    return new SavePersistentError(*this);
}

inline bool SavePersistentError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline SavePersistentErrorCode SavePersistentError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SavePersistentError", getField());
    }
    return (SavePersistentErrorCode) _data.ccaErrorCode_;
}

inline void SavePersistentError::setCcaErrorCode (SavePersistentErrorCode value) {
    #ifndef NDEBUG
    if (!(SavePersistentErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SavePersistentErrorCode", "ccaErrorCode", "SavePersistentError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool SavePersistentError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SavePersistentError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SavePersistentError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SavePersistentError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SavePersistentError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SavePersistentError::cloneData (const SavePersistentError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SavePersistentError::deleteData () {
}

inline  UpdateFactorySettingsStart::UpdateFactorySettingsStart ()  :
    _DefSetGroup (::location_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_MAINTENANCE),
    _DefSetMode (::location_fi_types::T_e8_DefSetMode__DEFSET_SRC_CODING)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateFactorySettingsStart::UpdateFactorySettingsStart (const UpdateFactorySettingsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetGroup (::location_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_MAINTENANCE),
    _DefSetMode (::location_fi_types::T_e8_DefSetMode__DEFSET_SRC_CODING)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateFactorySettingsStart::UpdateFactorySettingsStart (::location_fi_types::T_e8_DefSetGroups DefSetGroup_, ::location_fi_types::T_e8_DefSetMode DefSetMode_)  :
    _DefSetGroup (DefSetGroup_),
    _DefSetMode (DefSetMode_)
{
    #ifndef NDEBUG
    if (!(::location_fi_types::T_e8_DefSetGroups_IsValid(DefSetGroup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetGroup_, "T_e8_DefSetGroups", "DefSetGroup", "UpdateFactorySettingsStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::location_fi_types::T_e8_DefSetMode_IsValid(DefSetMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetMode_, "T_e8_DefSetMode", "DefSetMode", "UpdateFactorySettingsStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateFactorySettingsStart::~UpdateFactorySettingsStart() {
}

inline UpdateFactorySettingsStart& UpdateFactorySettingsStart::operator = (const UpdateFactorySettingsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetGroup()) {
            setDefSetGroup(rhs.getDefSetGroup());
        } else {
            clearDefSetGroup();
        }
        if (rhs.hasDefSetMode()) {
            setDefSetMode(rhs.getDefSetMode());
        } else {
            clearDefSetMode();
        }
    }
    return *this;
}

inline bool UpdateFactorySettingsStart::operator == (const UpdateFactorySettingsStart& rhs) const {
    return (((!hasDefSetGroup() && !rhs.hasDefSetGroup()) || getDefSetGroup() == rhs.getDefSetGroup()) &&
        ((!hasDefSetMode() && !rhs.hasDefSetMode()) || getDefSetMode() == rhs.getDefSetMode()));
}

inline bool UpdateFactorySettingsStart::operator != (const UpdateFactorySettingsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateFactorySettingsStart::operator < (const UpdateFactorySettingsStart& rhs) const {
    if (hasDefSetGroup() || rhs.hasDefSetGroup()) {
        if ((uint32)getDefSetGroup() < (uint32)rhs.getDefSetGroup()) return true;
        if ((uint32)getDefSetGroup() > (uint32)rhs.getDefSetGroup()) return false;
    }
    if (hasDefSetMode() || rhs.hasDefSetMode()) {
        if ((uint32)getDefSetMode() < (uint32)rhs.getDefSetMode()) return true;
        if ((uint32)getDefSetMode() > (uint32)rhs.getDefSetMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateFactorySettingsStart::clone() {
    return new UpdateFactorySettingsStart(*this);
}

inline bool UpdateFactorySettingsStart::operator > (const UpdateFactorySettingsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateFactorySettingsStart::clear() {
    clearDefSetGroup();
    clearDefSetMode();
}

inline void UpdateFactorySettingsStart::clearDefSetGroup() {
    if (hasDefSetGroup()) {
         clear_has_DefSetGroup();
        _DefSetGroup = ::location_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_MAINTENANCE;
     }
}

inline bool UpdateFactorySettingsStart::hasDefSetGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::location_fi_types::T_e8_DefSetGroups UpdateFactorySettingsStart::getDefSetGroup () const {
    return _DefSetGroup;
}

inline void UpdateFactorySettingsStart::setDefSetGroup (::location_fi_types::T_e8_DefSetGroups DefSetGroup_) {
    #ifndef NDEBUG
    if (!(::location_fi_types::T_e8_DefSetGroups_IsValid(DefSetGroup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetGroup_, "T_e8_DefSetGroups", "DefSetGroup", "UpdateFactorySettingsStart");
    }
    #endif
    set_has_DefSetGroup();
    this->_DefSetGroup = DefSetGroup_;
}

inline void UpdateFactorySettingsStart::clearDefSetMode() {
    if (hasDefSetMode()) {
         clear_has_DefSetMode();
        _DefSetMode = ::location_fi_types::T_e8_DefSetMode__DEFSET_SRC_CODING;
     }
}

inline bool UpdateFactorySettingsStart::hasDefSetMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::location_fi_types::T_e8_DefSetMode UpdateFactorySettingsStart::getDefSetMode () const {
    return _DefSetMode;
}

inline void UpdateFactorySettingsStart::setDefSetMode (::location_fi_types::T_e8_DefSetMode DefSetMode_) {
    #ifndef NDEBUG
    if (!(::location_fi_types::T_e8_DefSetMode_IsValid(DefSetMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetMode_, "T_e8_DefSetMode", "DefSetMode", "UpdateFactorySettingsStart");
    }
    #endif
    set_has_DefSetMode();
    this->_DefSetMode = DefSetMode_;
}

inline void UpdateFactorySettingsStart::set_has_DefSetGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateFactorySettingsStart::clear_has_DefSetGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateFactorySettingsStart::set_has_DefSetMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateFactorySettingsStart::clear_has_DefSetMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdateFactorySettingsResult::UpdateFactorySettingsResult ()  :
    _DefSetGroup (::location_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_MAINTENANCE),
    _DefSetMode (::location_fi_types::T_e8_DefSetMode__DEFSET_SRC_CODING),
    _DefSetStateSuccessful (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateFactorySettingsResult::UpdateFactorySettingsResult (const UpdateFactorySettingsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetGroup (::location_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_MAINTENANCE),
    _DefSetMode (::location_fi_types::T_e8_DefSetMode__DEFSET_SRC_CODING),
    _DefSetStateSuccessful (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateFactorySettingsResult::UpdateFactorySettingsResult (::location_fi_types::T_e8_DefSetGroups DefSetGroup_, ::location_fi_types::T_e8_DefSetMode DefSetMode_, bool DefSetStateSuccessful_)  :
    _DefSetGroup (DefSetGroup_),
    _DefSetMode (DefSetMode_),
    _DefSetStateSuccessful (DefSetStateSuccessful_)
{
    #ifndef NDEBUG
    if (!(::location_fi_types::T_e8_DefSetGroups_IsValid(DefSetGroup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetGroup_, "T_e8_DefSetGroups", "DefSetGroup", "UpdateFactorySettingsResult");
    }
    #endif
    #ifndef NDEBUG
    if (!(::location_fi_types::T_e8_DefSetMode_IsValid(DefSetMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetMode_, "T_e8_DefSetMode", "DefSetMode", "UpdateFactorySettingsResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateFactorySettingsResult::~UpdateFactorySettingsResult() {
}

inline UpdateFactorySettingsResult& UpdateFactorySettingsResult::operator = (const UpdateFactorySettingsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetGroup()) {
            setDefSetGroup(rhs.getDefSetGroup());
        } else {
            clearDefSetGroup();
        }
        if (rhs.hasDefSetMode()) {
            setDefSetMode(rhs.getDefSetMode());
        } else {
            clearDefSetMode();
        }
        if (rhs.hasDefSetStateSuccessful()) {
            setDefSetStateSuccessful(rhs.getDefSetStateSuccessful());
        } else {
            clearDefSetStateSuccessful();
        }
    }
    return *this;
}

inline bool UpdateFactorySettingsResult::operator == (const UpdateFactorySettingsResult& rhs) const {
    return (((!hasDefSetGroup() && !rhs.hasDefSetGroup()) || getDefSetGroup() == rhs.getDefSetGroup()) &&
        ((!hasDefSetMode() && !rhs.hasDefSetMode()) || getDefSetMode() == rhs.getDefSetMode()) &&
        ((!hasDefSetStateSuccessful() && !rhs.hasDefSetStateSuccessful()) || getDefSetStateSuccessful() == rhs.getDefSetStateSuccessful()));
}

inline bool UpdateFactorySettingsResult::operator != (const UpdateFactorySettingsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateFactorySettingsResult::operator < (const UpdateFactorySettingsResult& rhs) const {
    if (hasDefSetGroup() || rhs.hasDefSetGroup()) {
        if ((uint32)getDefSetGroup() < (uint32)rhs.getDefSetGroup()) return true;
        if ((uint32)getDefSetGroup() > (uint32)rhs.getDefSetGroup()) return false;
    }
    if (hasDefSetMode() || rhs.hasDefSetMode()) {
        if ((uint32)getDefSetMode() < (uint32)rhs.getDefSetMode()) return true;
        if ((uint32)getDefSetMode() > (uint32)rhs.getDefSetMode()) return false;
    }
    if (hasDefSetStateSuccessful() || rhs.hasDefSetStateSuccessful()) {
        if (getDefSetStateSuccessful() < rhs.getDefSetStateSuccessful()) return true;
        if (getDefSetStateSuccessful() > rhs.getDefSetStateSuccessful()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateFactorySettingsResult::clone() {
    return new UpdateFactorySettingsResult(*this);
}

inline bool UpdateFactorySettingsResult::operator > (const UpdateFactorySettingsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateFactorySettingsResult::clear() {
    clearDefSetGroup();
    clearDefSetMode();
    clearDefSetStateSuccessful();
}

inline void UpdateFactorySettingsResult::clearDefSetGroup() {
    if (hasDefSetGroup()) {
         clear_has_DefSetGroup();
        _DefSetGroup = ::location_fi_types::T_e8_DefSetGroups__DEFSET_GROUP_MAINTENANCE;
     }
}

inline bool UpdateFactorySettingsResult::hasDefSetGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::location_fi_types::T_e8_DefSetGroups UpdateFactorySettingsResult::getDefSetGroup () const {
    return _DefSetGroup;
}

inline void UpdateFactorySettingsResult::setDefSetGroup (::location_fi_types::T_e8_DefSetGroups DefSetGroup_) {
    #ifndef NDEBUG
    if (!(::location_fi_types::T_e8_DefSetGroups_IsValid(DefSetGroup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetGroup_, "T_e8_DefSetGroups", "DefSetGroup", "UpdateFactorySettingsResult");
    }
    #endif
    set_has_DefSetGroup();
    this->_DefSetGroup = DefSetGroup_;
}

inline void UpdateFactorySettingsResult::clearDefSetMode() {
    if (hasDefSetMode()) {
         clear_has_DefSetMode();
        _DefSetMode = ::location_fi_types::T_e8_DefSetMode__DEFSET_SRC_CODING;
     }
}

inline bool UpdateFactorySettingsResult::hasDefSetMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::location_fi_types::T_e8_DefSetMode UpdateFactorySettingsResult::getDefSetMode () const {
    return _DefSetMode;
}

inline void UpdateFactorySettingsResult::setDefSetMode (::location_fi_types::T_e8_DefSetMode DefSetMode_) {
    #ifndef NDEBUG
    if (!(::location_fi_types::T_e8_DefSetMode_IsValid(DefSetMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetMode_, "T_e8_DefSetMode", "DefSetMode", "UpdateFactorySettingsResult");
    }
    #endif
    set_has_DefSetMode();
    this->_DefSetMode = DefSetMode_;
}

inline void UpdateFactorySettingsResult::clearDefSetStateSuccessful() {
    if (hasDefSetStateSuccessful()) {
         clear_has_DefSetStateSuccessful();
        _DefSetStateSuccessful = false;
     }
}

inline bool UpdateFactorySettingsResult::hasDefSetStateSuccessful () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool UpdateFactorySettingsResult::getDefSetStateSuccessful () const {
    return _DefSetStateSuccessful;
}

inline void UpdateFactorySettingsResult::setDefSetStateSuccessful (bool DefSetStateSuccessful_) {
    set_has_DefSetStateSuccessful();
    this->_DefSetStateSuccessful = DefSetStateSuccessful_;
}

inline void UpdateFactorySettingsResult::set_has_DefSetGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateFactorySettingsResult::clear_has_DefSetGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateFactorySettingsResult::set_has_DefSetMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateFactorySettingsResult::clear_has_DefSetMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UpdateFactorySettingsResult::set_has_DefSetStateSuccessful () {
    _has_bits_[0] |= 1u << 2;
}

inline void UpdateFactorySettingsResult::clear_has_DefSetStateSuccessful () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Gyro3dGetHwInfoResult::Gyro3dGetHwInfoResult ()  :
    _Gyro3dHwInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Gyro3dGetHwInfoResult::Gyro3dGetHwInfoResult (const Gyro3dGetHwInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Gyro3dHwInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Gyro3dGetHwInfoResult::Gyro3dGetHwInfoResult (const ::location_fi_types::T_3dGyroHwInfo& Gyro3dHwInfo_)  :
    _Gyro3dHwInfo (Gyro3dHwInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Gyro3dGetHwInfoResult::~Gyro3dGetHwInfoResult() {
}

inline Gyro3dGetHwInfoResult& Gyro3dGetHwInfoResult::operator = (const Gyro3dGetHwInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGyro3dHwInfo()) {
            setGyro3dHwInfo(rhs.getGyro3dHwInfo());
        } else {
            clearGyro3dHwInfo();
        }
    }
    return *this;
}

inline bool Gyro3dGetHwInfoResult::operator == (const Gyro3dGetHwInfoResult& rhs) const {
    return (((!hasGyro3dHwInfo() && !rhs.hasGyro3dHwInfo()) || getGyro3dHwInfo() == rhs.getGyro3dHwInfo()));
}

inline bool Gyro3dGetHwInfoResult::operator != (const Gyro3dGetHwInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool Gyro3dGetHwInfoResult::operator < (const Gyro3dGetHwInfoResult& rhs) const {
    if (hasGyro3dHwInfo() || rhs.hasGyro3dHwInfo()) {
        if (getGyro3dHwInfo() < rhs.getGyro3dHwInfo()) return true;
        if (getGyro3dHwInfo() > rhs.getGyro3dHwInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Gyro3dGetHwInfoResult::clone() {
    return new Gyro3dGetHwInfoResult(*this);
}

inline bool Gyro3dGetHwInfoResult::operator > (const Gyro3dGetHwInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Gyro3dGetHwInfoResult::clear() {
    clearGyro3dHwInfo();
}

inline void Gyro3dGetHwInfoResult::clearGyro3dHwInfo() {
    if (hasGyro3dHwInfo()) {
         clear_has_Gyro3dHwInfo();
        _Gyro3dHwInfo.clear();
     }
}

inline bool Gyro3dGetHwInfoResult::hasGyro3dHwInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_3dGyroHwInfo& Gyro3dGetHwInfoResult::getGyro3dHwInfo () const {
    return _Gyro3dHwInfo;
}

inline ::location_fi_types::T_3dGyroHwInfo& Gyro3dGetHwInfoResult::getGyro3dHwInfoMutable () {
    set_has_Gyro3dHwInfo();
    return _Gyro3dHwInfo;
}

inline void Gyro3dGetHwInfoResult::setGyro3dHwInfo (const ::location_fi_types::T_3dGyroHwInfo& Gyro3dHwInfo_) {
    set_has_Gyro3dHwInfo();
    this->_Gyro3dHwInfo = Gyro3dHwInfo_;
}

inline void Gyro3dGetHwInfoResult::set_has_Gyro3dHwInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void Gyro3dGetHwInfoResult::clear_has_Gyro3dHwInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Acc3dGetHwInfoResult::Acc3dGetHwInfoResult ()  :
    _Acc3dHwInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Acc3dGetHwInfoResult::Acc3dGetHwInfoResult (const Acc3dGetHwInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Acc3dHwInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Acc3dGetHwInfoResult::Acc3dGetHwInfoResult (const ::location_fi_types::T_3dAccHwInfo& Acc3dHwInfo_)  :
    _Acc3dHwInfo (Acc3dHwInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Acc3dGetHwInfoResult::~Acc3dGetHwInfoResult() {
}

inline Acc3dGetHwInfoResult& Acc3dGetHwInfoResult::operator = (const Acc3dGetHwInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAcc3dHwInfo()) {
            setAcc3dHwInfo(rhs.getAcc3dHwInfo());
        } else {
            clearAcc3dHwInfo();
        }
    }
    return *this;
}

inline bool Acc3dGetHwInfoResult::operator == (const Acc3dGetHwInfoResult& rhs) const {
    return (((!hasAcc3dHwInfo() && !rhs.hasAcc3dHwInfo()) || getAcc3dHwInfo() == rhs.getAcc3dHwInfo()));
}

inline bool Acc3dGetHwInfoResult::operator != (const Acc3dGetHwInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool Acc3dGetHwInfoResult::operator < (const Acc3dGetHwInfoResult& rhs) const {
    if (hasAcc3dHwInfo() || rhs.hasAcc3dHwInfo()) {
        if (getAcc3dHwInfo() < rhs.getAcc3dHwInfo()) return true;
        if (getAcc3dHwInfo() > rhs.getAcc3dHwInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Acc3dGetHwInfoResult::clone() {
    return new Acc3dGetHwInfoResult(*this);
}

inline bool Acc3dGetHwInfoResult::operator > (const Acc3dGetHwInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Acc3dGetHwInfoResult::clear() {
    clearAcc3dHwInfo();
}

inline void Acc3dGetHwInfoResult::clearAcc3dHwInfo() {
    if (hasAcc3dHwInfo()) {
         clear_has_Acc3dHwInfo();
        _Acc3dHwInfo.clear();
     }
}

inline bool Acc3dGetHwInfoResult::hasAcc3dHwInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::location_fi_types::T_3dAccHwInfo& Acc3dGetHwInfoResult::getAcc3dHwInfo () const {
    return _Acc3dHwInfo;
}

inline ::location_fi_types::T_3dAccHwInfo& Acc3dGetHwInfoResult::getAcc3dHwInfoMutable () {
    set_has_Acc3dHwInfo();
    return _Acc3dHwInfo;
}

inline void Acc3dGetHwInfoResult::setAcc3dHwInfo (const ::location_fi_types::T_3dAccHwInfo& Acc3dHwInfo_) {
    set_has_Acc3dHwInfo();
    this->_Acc3dHwInfo = Acc3dHwInfo_;
}

inline void Acc3dGetHwInfoResult::set_has_Acc3dHwInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void Acc3dGetHwInfoResult::clear_has_Acc3dHwInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GyroSelfTestResult::GyroSelfTestResult ()  :
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GyroSelfTestResult::GyroSelfTestResult (const GyroSelfTestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GyroSelfTestResult::GyroSelfTestResult (bool bSuccess_)  :
    _bSuccess (bSuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GyroSelfTestResult::~GyroSelfTestResult() {
}

inline GyroSelfTestResult& GyroSelfTestResult::operator = (const GyroSelfTestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSuccess()) {
            setBSuccess(rhs.getBSuccess());
        } else {
            clearBSuccess();
        }
    }
    return *this;
}

inline bool GyroSelfTestResult::operator == (const GyroSelfTestResult& rhs) const {
    return (((!hasBSuccess() && !rhs.hasBSuccess()) || getBSuccess() == rhs.getBSuccess()));
}

inline bool GyroSelfTestResult::operator != (const GyroSelfTestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GyroSelfTestResult::operator < (const GyroSelfTestResult& rhs) const {
    if (hasBSuccess() || rhs.hasBSuccess()) {
        if (getBSuccess() < rhs.getBSuccess()) return true;
        if (getBSuccess() > rhs.getBSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GyroSelfTestResult::clone() {
    return new GyroSelfTestResult(*this);
}

inline bool GyroSelfTestResult::operator > (const GyroSelfTestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GyroSelfTestResult::clear() {
    clearBSuccess();
}

inline void GyroSelfTestResult::clearBSuccess() {
    if (hasBSuccess()) {
         clear_has_bSuccess();
        _bSuccess = false;
     }
}

inline bool GyroSelfTestResult::hasBSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool GyroSelfTestResult::getBSuccess () const {
    return _bSuccess;
}

inline void GyroSelfTestResult::setBSuccess (bool bSuccess_) {
    set_has_bSuccess();
    this->_bSuccess = bSuccess_;
}

inline void GyroSelfTestResult::set_has_bSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void GyroSelfTestResult::clear_has_bSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GyroSelfTestError::GyroSelfTestError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::GyroSelfTestErrorCode__Unspecified;
}

inline  GyroSelfTestError::GyroSelfTestError (const GyroSelfTestError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::GyroSelfTestErrorCode__Unspecified;
    *this = rhs;
}

inline  GyroSelfTestError::~GyroSelfTestError() {
    deleteData ();
}

inline GyroSelfTestError& GyroSelfTestError::operator = (const GyroSelfTestError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GyroSelfTestError::operator == (const GyroSelfTestError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GyroSelfTestError::operator != (const GyroSelfTestError& rhs) const {
    return ! (*this == rhs);
}

inline bool GyroSelfTestError::operator < (const GyroSelfTestError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GyroSelfTestError::operator > (const GyroSelfTestError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GyroSelfTestError::GyroSelfTestErrorField GyroSelfTestError::getField () const {
    return __field;
}

inline void GyroSelfTestError::setField(GyroSelfTestError::GyroSelfTestErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::sensor_location_fi::GyroSelfTestErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GyroSelfTestError::clone() {
    return new GyroSelfTestError(*this);
}

inline bool GyroSelfTestError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline GyroSelfTestErrorCode GyroSelfTestError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GyroSelfTestError", getField());
    }
    return (GyroSelfTestErrorCode) _data.ccaErrorCode_;
}

inline void GyroSelfTestError::setCcaErrorCode (GyroSelfTestErrorCode value) {
    #ifndef NDEBUG
    if (!(GyroSelfTestErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "GyroSelfTestErrorCode", "ccaErrorCode", "GyroSelfTestError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool GyroSelfTestError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GyroSelfTestError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GyroSelfTestError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GyroSelfTestError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GyroSelfTestError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GyroSelfTestError::cloneData (const GyroSelfTestError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GyroSelfTestError::deleteData () {
}

inline  AccSelfTestResult::AccSelfTestResult ()  :
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AccSelfTestResult::AccSelfTestResult (const AccSelfTestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AccSelfTestResult::AccSelfTestResult (bool bSuccess_)  :
    _bSuccess (bSuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AccSelfTestResult::~AccSelfTestResult() {
}

inline AccSelfTestResult& AccSelfTestResult::operator = (const AccSelfTestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSuccess()) {
            setBSuccess(rhs.getBSuccess());
        } else {
            clearBSuccess();
        }
    }
    return *this;
}

inline bool AccSelfTestResult::operator == (const AccSelfTestResult& rhs) const {
    return (((!hasBSuccess() && !rhs.hasBSuccess()) || getBSuccess() == rhs.getBSuccess()));
}

inline bool AccSelfTestResult::operator != (const AccSelfTestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AccSelfTestResult::operator < (const AccSelfTestResult& rhs) const {
    if (hasBSuccess() || rhs.hasBSuccess()) {
        if (getBSuccess() < rhs.getBSuccess()) return true;
        if (getBSuccess() > rhs.getBSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AccSelfTestResult::clone() {
    return new AccSelfTestResult(*this);
}

inline bool AccSelfTestResult::operator > (const AccSelfTestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AccSelfTestResult::clear() {
    clearBSuccess();
}

inline void AccSelfTestResult::clearBSuccess() {
    if (hasBSuccess()) {
         clear_has_bSuccess();
        _bSuccess = false;
     }
}

inline bool AccSelfTestResult::hasBSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AccSelfTestResult::getBSuccess () const {
    return _bSuccess;
}

inline void AccSelfTestResult::setBSuccess (bool bSuccess_) {
    set_has_bSuccess();
    this->_bSuccess = bSuccess_;
}

inline void AccSelfTestResult::set_has_bSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void AccSelfTestResult::clear_has_bSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AccSelfTestError::AccSelfTestError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::AccSelfTestErrorCode__Unspecified;
}

inline  AccSelfTestError::AccSelfTestError (const AccSelfTestError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::sensor_location_fi::AccSelfTestErrorCode__Unspecified;
    *this = rhs;
}

inline  AccSelfTestError::~AccSelfTestError() {
    deleteData ();
}

inline AccSelfTestError& AccSelfTestError::operator = (const AccSelfTestError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AccSelfTestError::operator == (const AccSelfTestError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AccSelfTestError::operator != (const AccSelfTestError& rhs) const {
    return ! (*this == rhs);
}

inline bool AccSelfTestError::operator < (const AccSelfTestError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AccSelfTestError::operator > (const AccSelfTestError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AccSelfTestError::AccSelfTestErrorField AccSelfTestError::getField () const {
    return __field;
}

inline void AccSelfTestError::setField(AccSelfTestError::AccSelfTestErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::sensor_location_fi::AccSelfTestErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AccSelfTestError::clone() {
    return new AccSelfTestError(*this);
}

inline bool AccSelfTestError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline AccSelfTestErrorCode AccSelfTestError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AccSelfTestError", getField());
    }
    return (AccSelfTestErrorCode) _data.ccaErrorCode_;
}

inline void AccSelfTestError::setCcaErrorCode (AccSelfTestErrorCode value) {
    #ifndef NDEBUG
    if (!(AccSelfTestErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "AccSelfTestErrorCode", "ccaErrorCode", "AccSelfTestError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool AccSelfTestError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AccSelfTestError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AccSelfTestError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AccSelfTestError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AccSelfTestError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AccSelfTestError::cloneData (const AccSelfTestError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AccSelfTestError::deleteData () {
}

} // namespace sensor_location_fi

#endif // SENSOR_LOCATION_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
