/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "location_fi_types.h"
#include "location_fi_typesConst.h"
#include "location_fi_typesJson.h"
#include "location_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_VdsVersionInfo"

void serializeJson (const ::location_fi_types::T_VdsVersionInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVdsVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "vdsVersion" , 10);
        const char *s = value.getVdsVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBoardVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "boardVersion" , 12);
        const char *s = value.getBoardVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_VdsVersionInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_OdometerData"

void serializeJson (const ::location_fi_types::T_OdometerData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "Timestamp" , 9);
        yajl_gen_integer(g, (long long)value.getTimestamp());
    }
    if (!isSparse || value.hasOdometerCount()) {
        yajl_gen_string(g, (const unsigned char*)  "OdometerCount" , 13);
        yajl_gen_integer(g, (long long)value.getOdometerCount());
    }
    if (!isSparse || value.hasOdometerStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "OdometerStatus" , 14);
        const char* s = ::location_fi_types::T_e8_OdometerStatus_Name(value.getOdometerStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOdometerStatus());
    }
    if (!isSparse || value.hasOdometerCount_Direction()) {
        yajl_gen_string(g, (const unsigned char*)  "OdometerCount_Direction" , 23);
        const char* s = ::location_fi_types::T_e8_OdometerDirection_Name(value.getOdometerCount_Direction());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOdometerCount_Direction());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_OdometerData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AbsData"

void serializeJson (const ::location_fi_types::T_AbsData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAbsTimeStamp()) {
        yajl_gen_string(g, (const unsigned char*)  "AbsTimeStamp" , 12);
        yajl_gen_integer(g, (long long)value.getAbsTimeStamp());
    }
    if (!isSparse || value.hasWheelCounterFrontLeft()) {
        yajl_gen_string(g, (const unsigned char*)  "WheelCounterFrontLeft" , 21);
        yajl_gen_integer(g, (long long)value.getWheelCounterFrontLeft());
    }
    if (!isSparse || value.hasWheelCounterFrontRight()) {
        yajl_gen_string(g, (const unsigned char*)  "WheelCounterFrontRight" , 22);
        yajl_gen_integer(g, (long long)value.getWheelCounterFrontRight());
    }
    if (!isSparse || value.hasWheelCounterRearLeft()) {
        yajl_gen_string(g, (const unsigned char*)  "WheelCounterRearLeft" , 20);
        yajl_gen_integer(g, (long long)value.getWheelCounterRearLeft());
    }
    if (!isSparse || value.hasWheelCounterRearRight()) {
        yajl_gen_string(g, (const unsigned char*)  "WheelCounterRearRight" , 21);
        yajl_gen_integer(g, (long long)value.getWheelCounterRearRight());
    }
    if (!isSparse || value.hasStatusFrontLeft()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusFrontLeft" , 15);
        const char* s = ::location_fi_types::T_e8_AbsStatus_Name(value.getStatusFrontLeft());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusFrontLeft());
    }
    if (!isSparse || value.hasStatusFrontRight()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusFrontRight" , 16);
        const char* s = ::location_fi_types::T_e8_AbsStatus_Name(value.getStatusFrontRight());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusFrontRight());
    }
    if (!isSparse || value.hasStatusRearLeft()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusRearLeft" , 14);
        const char* s = ::location_fi_types::T_e8_AbsStatus_Name(value.getStatusRearLeft());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusRearLeft());
    }
    if (!isSparse || value.hasStatusRearRight()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusRearRight" , 15);
        const char* s = ::location_fi_types::T_e8_AbsStatus_Name(value.getStatusRearRight());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatusRearRight());
    }
    if (!isSparse || value.hasDirectionFrontLeft()) {
        yajl_gen_string(g, (const unsigned char*)  "DirectionFrontLeft" , 18);
        const char* s = ::location_fi_types::T_e8_AbsDirection_Name(value.getDirectionFrontLeft());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDirectionFrontLeft());
    }
    if (!isSparse || value.hasDirectionFrontRight()) {
        yajl_gen_string(g, (const unsigned char*)  "DirectionFrontRight" , 19);
        const char* s = ::location_fi_types::T_e8_AbsDirection_Name(value.getDirectionFrontRight());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDirectionFrontRight());
    }
    if (!isSparse || value.hasDirectionRearLeft()) {
        yajl_gen_string(g, (const unsigned char*)  "DirectionRearLeft" , 17);
        const char* s = ::location_fi_types::T_e8_AbsDirection_Name(value.getDirectionRearLeft());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDirectionRearLeft());
    }
    if (!isSparse || value.hasDirectionRearRight()) {
        yajl_gen_string(g, (const unsigned char*)  "DirectionRearRight" , 18);
        const char* s = ::location_fi_types::T_e8_AbsDirection_Name(value.getDirectionRearRight());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDirectionRearRight());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_AbsData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SensorHwInfo"

void serializeJson (const ::location_fi_types::T_SensorHwInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAdcRangeMin()) {
        yajl_gen_string(g, (const unsigned char*)  "AdcRangeMin" , 11);
        yajl_gen_integer(g, (long long)value.getAdcRangeMin());
    }
    if (!isSparse || value.hasAdcRangeMax()) {
        yajl_gen_string(g, (const unsigned char*)  "AdcRangeMax" , 11);
        yajl_gen_integer(g, (long long)value.getAdcRangeMax());
    }
    if (!isSparse || value.hasSampleMin()) {
        yajl_gen_string(g, (const unsigned char*)  "SampleMin" , 9);
        yajl_gen_integer(g, (long long)value.getSampleMin());
    }
    if (!isSparse || value.hasSampleMax()) {
        yajl_gen_string(g, (const unsigned char*)  "SampleMax" , 9);
        yajl_gen_integer(g, (long long)value.getSampleMax());
    }
    if (!isSparse || value.hasMinNoiseValue()) {
        yajl_gen_string(g, (const unsigned char*)  "MinNoiseValue" , 13);
        yajl_gen_double(g, (double)value.getMinNoiseValue());
    }
    if (!isSparse || value.hasEstimOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "EstimOffset" , 11);
        yajl_gen_double(g, (double)value.getEstimOffset());
    }
    if (!isSparse || value.hasMinOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "MinOffset" , 9);
        yajl_gen_double(g, (double)value.getMinOffset());
    }
    if (!isSparse || value.hasMaxOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxOffset" , 9);
        yajl_gen_double(g, (double)value.getMaxOffset());
    }
    if (!isSparse || value.hasDriftOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "DriftOffset" , 11);
        yajl_gen_double(g, (double)value.getDriftOffset());
    }
    if (!isSparse || value.hasMaxUnsteadOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxUnsteadOffset" , 16);
        yajl_gen_double(g, (double)value.getMaxUnsteadOffset());
    }
    if (!isSparse || value.hasBestCalibOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "BestCalibOffset" , 15);
        yajl_gen_double(g, (double)value.getBestCalibOffset());
    }
    if (!isSparse || value.hasEstimScaleFactor()) {
        yajl_gen_string(g, (const unsigned char*)  "EstimScaleFactor" , 16);
        yajl_gen_double(g, (double)value.getEstimScaleFactor());
    }
    if (!isSparse || value.hasMinScaleFactor()) {
        yajl_gen_string(g, (const unsigned char*)  "MinScaleFactor" , 14);
        yajl_gen_double(g, (double)value.getMinScaleFactor());
    }
    if (!isSparse || value.hasMaxScaleFactor()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxScaleFactor" , 14);
        yajl_gen_double(g, (double)value.getMaxScaleFactor());
    }
    if (!isSparse || value.hasDriftScaleFactor()) {
        yajl_gen_string(g, (const unsigned char*)  "DriftScaleFactor" , 16);
        yajl_gen_double(g, (double)value.getDriftScaleFactor());
    }
    if (!isSparse || value.hasMaxUnsteadScaleFactor()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxUnsteadScaleFactor" , 21);
        yajl_gen_double(g, (double)value.getMaxUnsteadScaleFactor());
    }
    if (!isSparse || value.hasBestCalibScaleFactor()) {
        yajl_gen_string(g, (const unsigned char*)  "BestCalibScaleFactor" , 20);
        yajl_gen_double(g, (double)value.getBestCalibScaleFactor());
    }
    if (!isSparse || value.hasDriftOffsetTime()) {
        yajl_gen_string(g, (const unsigned char*)  "DriftOffsetTime" , 15);
        yajl_gen_double(g, (double)value.getDriftOffsetTime());
    }
    if (!isSparse || value.hasDriftScaleFactorTime()) {
        yajl_gen_string(g, (const unsigned char*)  "DriftScaleFactorTime" , 20);
        yajl_gen_double(g, (double)value.getDriftScaleFactorTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_SensorHwInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_3dMountAngles"

void serializeJson (const ::location_fi_types::T_3dMountAngles& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAngRX()) {
        yajl_gen_string(g, (const unsigned char*)  "AngRX" , 5);
        yajl_gen_integer(g, (long long)value.getAngRX());
    }
    if (!isSparse || value.hasAngRY()) {
        yajl_gen_string(g, (const unsigned char*)  "AngRY" , 5);
        yajl_gen_integer(g, (long long)value.getAngRY());
    }
    if (!isSparse || value.hasAngRZ()) {
        yajl_gen_string(g, (const unsigned char*)  "AngRZ" , 5);
        yajl_gen_integer(g, (long long)value.getAngRZ());
    }
    if (!isSparse || value.hasAngSX()) {
        yajl_gen_string(g, (const unsigned char*)  "AngSX" , 5);
        yajl_gen_integer(g, (long long)value.getAngSX());
    }
    if (!isSparse || value.hasAngSY()) {
        yajl_gen_string(g, (const unsigned char*)  "AngSY" , 5);
        yajl_gen_integer(g, (long long)value.getAngSY());
    }
    if (!isSparse || value.hasAngSZ()) {
        yajl_gen_string(g, (const unsigned char*)  "AngSZ" , 5);
        yajl_gen_integer(g, (long long)value.getAngSZ());
    }
    if (!isSparse || value.hasAngTX()) {
        yajl_gen_string(g, (const unsigned char*)  "AngTX" , 5);
        yajl_gen_integer(g, (long long)value.getAngTX());
    }
    if (!isSparse || value.hasAngTY()) {
        yajl_gen_string(g, (const unsigned char*)  "AngTY" , 5);
        yajl_gen_integer(g, (long long)value.getAngTY());
    }
    if (!isSparse || value.hasAngTZ()) {
        yajl_gen_string(g, (const unsigned char*)  "AngTZ" , 5);
        yajl_gen_integer(g, (long long)value.getAngTZ());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_3dMountAngles& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_3dGyroHwInfo"

void serializeJson (const ::location_fi_types::T_3dGyroHwInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSampleRate()) {
        yajl_gen_string(g, (const unsigned char*)  "SampleRate" , 10);
        yajl_gen_integer(g, (long long)value.getSampleRate());
    }
    if (!isSparse || value.hasMountAngles()) {
        yajl_gen_string(g, (const unsigned char*)  "MountAngles" , 11);
        serializeJson(value.getMountAngles(), g, options);
    }
    if (!isSparse || value.hasRAxes()) {
        yajl_gen_string(g, (const unsigned char*)  "RAxes" , 5);
        serializeJson(value.getRAxes(), g, options);
    }
    if (!isSparse || value.hasSAxes()) {
        yajl_gen_string(g, (const unsigned char*)  "SAxes" , 5);
        serializeJson(value.getSAxes(), g, options);
    }
    if (!isSparse || value.hasTAxes()) {
        yajl_gen_string(g, (const unsigned char*)  "TAxes" , 5);
        serializeJson(value.getTAxes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_3dGyroHwInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_3dAccHwInfo"

void serializeJson (const ::location_fi_types::T_3dAccHwInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSampleRate()) {
        yajl_gen_string(g, (const unsigned char*)  "SampleRate" , 10);
        yajl_gen_integer(g, (long long)value.getSampleRate());
    }
    if (!isSparse || value.hasMountAngles()) {
        yajl_gen_string(g, (const unsigned char*)  "MountAngles" , 11);
        serializeJson(value.getMountAngles(), g, options);
    }
    if (!isSparse || value.hasRAxes()) {
        yajl_gen_string(g, (const unsigned char*)  "RAxes" , 5);
        serializeJson(value.getRAxes(), g, options);
    }
    if (!isSparse || value.hasSAxes()) {
        yajl_gen_string(g, (const unsigned char*)  "SAxes" , 5);
        serializeJson(value.getSAxes(), g, options);
    }
    if (!isSparse || value.hasTAxes()) {
        yajl_gen_string(g, (const unsigned char*)  "TAxes" , 5);
        serializeJson(value.getTAxes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_3dAccHwInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_3dGyroData"

void serializeJson (const ::location_fi_types::T_3dGyroData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTimeStamp3dGyro()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeStamp3dGyro" , 15);
        yajl_gen_integer(g, (long long)value.getTimeStamp3dGyro());
    }
    if (!isSparse || value.hasRVal()) {
        yajl_gen_string(g, (const unsigned char*)  "RVal" , 4);
        yajl_gen_integer(g, (long long)value.getRVal());
    }
    if (!isSparse || value.hasSVal()) {
        yajl_gen_string(g, (const unsigned char*)  "SVal" , 4);
        yajl_gen_integer(g, (long long)value.getSVal());
    }
    if (!isSparse || value.hasTVal()) {
        yajl_gen_string(g, (const unsigned char*)  "TVal" , 4);
        yajl_gen_integer(g, (long long)value.getTVal());
    }
    if (!isSparse || value.hasRStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "RStatus" , 7);
        const char* s = ::location_fi_types::T_e16_GyroStatus_Name(value.getRStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRStatus());
    }
    if (!isSparse || value.hasSStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SStatus" , 7);
        const char* s = ::location_fi_types::T_e16_GyroStatus_Name(value.getSStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSStatus());
    }
    if (!isSparse || value.hasTStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "TStatus" , 7);
        const char* s = ::location_fi_types::T_e16_GyroStatus_Name(value.getTStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_3dGyroData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_3dAccData"

void serializeJson (const ::location_fi_types::T_3dAccData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTimeStamp3dAcc()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeStamp3dAcc" , 14);
        yajl_gen_integer(g, (long long)value.getTimeStamp3dAcc());
    }
    if (!isSparse || value.hasRVal()) {
        yajl_gen_string(g, (const unsigned char*)  "RVal" , 4);
        yajl_gen_integer(g, (long long)value.getRVal());
    }
    if (!isSparse || value.hasSVal()) {
        yajl_gen_string(g, (const unsigned char*)  "SVal" , 4);
        yajl_gen_integer(g, (long long)value.getSVal());
    }
    if (!isSparse || value.hasTVal()) {
        yajl_gen_string(g, (const unsigned char*)  "TVal" , 4);
        yajl_gen_integer(g, (long long)value.getTVal());
    }
    if (!isSparse || value.hasRStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "RStatus" , 7);
        const char* s = ::location_fi_types::T_e16_AccStatus_Name(value.getRStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRStatus());
    }
    if (!isSparse || value.hasSStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SStatus" , 7);
        const char* s = ::location_fi_types::T_e16_AccStatus_Name(value.getSStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSStatus());
    }
    if (!isSparse || value.hasTStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "TStatus" , 7);
        const char* s = ::location_fi_types::T_e16_AccStatus_Name(value.getTStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_3dAccData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_GnssSatSys"

void serializeJson (const ::location_fi_types::T_b8_GnssSatSys& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getGNSS_SATSYS_GPS()) {
        yajl_gen_string(g, (const unsigned char*)  "GNSS_SATSYS_GPS" , 15);
        yajl_gen_bool(g, (bool)value.getGNSS_SATSYS_GPS());
    }
    if (value.getGNSS_SATSYS_GLONASS()) {
        yajl_gen_string(g, (const unsigned char*)  "GNSS_SATSYS_GLONASS" , 19);
        yajl_gen_bool(g, (bool)value.getGNSS_SATSYS_GLONASS());
    }
    if (value.getGNSS_SATSYS_GALILEO()) {
        yajl_gen_string(g, (const unsigned char*)  "GNSS_SATSYS_GALILEO" , 19);
        yajl_gen_bool(g, (bool)value.getGNSS_SATSYS_GALILEO());
    }
    if (value.getGNSS_SATSYS_COMPASS()) {
        yajl_gen_string(g, (const unsigned char*)  "GNSS_SATSYS_COMPASS" , 19);
        yajl_gen_bool(g, (bool)value.getGNSS_SATSYS_COMPASS());
    }
    if (value.getGNSS_SATSYS_SBAS()) {
        yajl_gen_string(g, (const unsigned char*)  "GNSS_SATSYS_SBAS" , 16);
        yajl_gen_bool(g, (bool)value.getGNSS_SATSYS_SBAS());
    }
    if (value.getGNSS_SATSYS_QZSS()) {
        yajl_gen_string(g, (const unsigned char*)  "GNSS_SATSYS_QZSS" , 16);
        yajl_gen_bool(g, (bool)value.getGNSS_SATSYS_QZSS());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_b8_GnssSatSys& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_GnssSatStatus"

void serializeJson (const ::location_fi_types::T_b8_GnssSatStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getSAT_HEALTHY()) {
        yajl_gen_string(g, (const unsigned char*)  "SAT_HEALTHY" , 11);
        yajl_gen_bool(g, (bool)value.getSAT_HEALTHY());
    }
    if (value.getSAT_ALMANAC_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "SAT_ALMANAC_AVAILABLE" , 21);
        yajl_gen_bool(g, (bool)value.getSAT_ALMANAC_AVAILABLE());
    }
    if (value.getSAT_EPHEMERIS_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "SAT_EPHEMERIS_AVAILABLE" , 23);
        yajl_gen_bool(g, (bool)value.getSAT_EPHEMERIS_AVAILABLE());
    }
    if (value.getSAT_DGPS_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "SAT_DGPS_AVAILABLE" , 18);
        yajl_gen_bool(g, (bool)value.getSAT_DGPS_AVAILABLE());
    }
    if (value.getSAT_TRACKED()) {
        yajl_gen_string(g, (const unsigned char*)  "SAT_TRACKED" , 11);
        yajl_gen_bool(g, (bool)value.getSAT_TRACKED());
    }
    if (value.getSAT_USED_FOR_POSCALC()) {
        yajl_gen_string(g, (const unsigned char*)  "SAT_USED_FOR_POSCALC" , 20);
        yajl_gen_bool(g, (bool)value.getSAT_USED_FOR_POSCALC());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_b8_GnssSatStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GnssConfigData"

void serializeJson (const ::location_fi_types::T_GnssConfigData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGnssHardwareType()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssHardwareType" , 16);
        const char* s = ::location_fi_types::T_e8_GnssHw_Name(value.getGnssHardwareType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGnssHardwareType());
    }
    if (!isSparse || value.hasGnssReceiverFirmwareVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssReceiverFirmwareVersion" , 27);
        yajl_gen_integer(g, (long long)value.getGnssReceiverFirmwareVersion());
    }
    if (!isSparse || value.hasGnssReceiverFirmwareCrc()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssReceiverFirmwareCrc" , 23);
        yajl_gen_integer(g, (long long)value.getGnssReceiverFirmwareCrc());
    }
    if (!isSparse || value.hasNumberOfChannels()) {
        yajl_gen_string(g, (const unsigned char*)  "NumberOfChannels" , 16);
        yajl_gen_integer(g, (long long)value.getNumberOfChannels());
    }
    if (!isSparse || value.hasUsedSatStatusBits()) {
        yajl_gen_string(g, (const unsigned char*)  "UsedSatStatusBits" , 17);
        serializeJson(value.getUsedSatStatusBits(), g, options);
    }
    if (!isSparse || value.hasUpdateFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateFrequency" , 15);
        yajl_gen_integer(g, (long long)value.getUpdateFrequency());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_GnssConfigData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GnssStatus"

void serializeJson (const ::location_fi_types::T_GnssStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGnssQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssQuality" , 11);
        const char* s = ::location_fi_types::T_e8_GnssQuality_Name(value.getGnssQuality());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGnssQuality());
    }
    if (!isSparse || value.hasGnssMode()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssMode" , 8);
        const char* s = ::location_fi_types::T_e8_GnssMode_Name(value.getGnssMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGnssMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_GnssStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CovarianceMatrixUpperTriangle"

void serializeJson (const ::location_fi_types::T_CovarianceMatrixUpperTriangle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasElem0()) {
        yajl_gen_string(g, (const unsigned char*)  "Elem0" , 5);
        yajl_gen_double(g, (double)value.getElem0());
    }
    if (!isSparse || value.hasElem4()) {
        yajl_gen_string(g, (const unsigned char*)  "Elem4" , 5);
        yajl_gen_double(g, (double)value.getElem4());
    }
    if (!isSparse || value.hasElem5()) {
        yajl_gen_string(g, (const unsigned char*)  "Elem5" , 5);
        yajl_gen_double(g, (double)value.getElem5());
    }
    if (!isSparse || value.hasElem8()) {
        yajl_gen_string(g, (const unsigned char*)  "Elem8" , 5);
        yajl_gen_double(g, (double)value.getElem8());
    }
    if (!isSparse || value.hasElem9()) {
        yajl_gen_string(g, (const unsigned char*)  "Elem9" , 5);
        yajl_gen_double(g, (double)value.getElem9());
    }
    if (!isSparse || value.hasElem10()) {
        yajl_gen_string(g, (const unsigned char*)  "Elem10" , 6);
        yajl_gen_double(g, (double)value.getElem10());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_CovarianceMatrixUpperTriangle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GnssPvtData"

void serializeJson (const ::location_fi_types::T_GnssPvtData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUtcTimeDate()) {
        yajl_gen_string(g, (const unsigned char*)  "UtcTimeDate" , 11);
        serializeJson(value.getUtcTimeDate(), g, options);
    }
    if (!isSparse || value.hasLatitude()) {
        yajl_gen_string(g, (const unsigned char*)  "Latitude" , 8);
        yajl_gen_double(g, (double)value.getLatitude());
    }
    if (!isSparse || value.hasLongitude()) {
        yajl_gen_string(g, (const unsigned char*)  "Longitude" , 9);
        yajl_gen_double(g, (double)value.getLongitude());
    }
    if (!isSparse || value.hasAltitudeWGS84()) {
        yajl_gen_string(g, (const unsigned char*)  "AltitudeWGS84" , 13);
        yajl_gen_double(g, (double)value.getAltitudeWGS84());
    }
    if (!isSparse || value.hasGeoidalSeparation()) {
        yajl_gen_string(g, (const unsigned char*)  "GeoidalSeparation" , 17);
        yajl_gen_double(g, (double)value.getGeoidalSeparation());
    }
    if (!isSparse || value.hasVelocityNorth()) {
        yajl_gen_string(g, (const unsigned char*)  "VelocityNorth" , 13);
        yajl_gen_double(g, (double)value.getVelocityNorth());
    }
    if (!isSparse || value.hasVelocityEast()) {
        yajl_gen_string(g, (const unsigned char*)  "VelocityEast" , 12);
        yajl_gen_double(g, (double)value.getVelocityEast());
    }
    if (!isSparse || value.hasVelocityUp()) {
        yajl_gen_string(g, (const unsigned char*)  "VelocityUp" , 10);
        yajl_gen_double(g, (double)value.getVelocityUp());
    }
    if (!isSparse || value.hasPositionCovarianceMatrix()) {
        yajl_gen_string(g, (const unsigned char*)  "PositionCovarianceMatrix" , 24);
        serializeJson(value.getPositionCovarianceMatrix(), g, options);
    }
    if (!isSparse || value.hasVelocityCovarianceMatrix()) {
        yajl_gen_string(g, (const unsigned char*)  "VelocityCovarianceMatrix" , 24);
        serializeJson(value.getVelocityCovarianceMatrix(), g, options);
    }
    if (!isSparse || value.hasGnssStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssStatus" , 10);
        serializeJson(value.getGnssStatus(), g, options);
    }
    if (!isSparse || value.hasGDOP()) {
        yajl_gen_string(g, (const unsigned char*)  "GDOP" , 4);
        yajl_gen_double(g, (double)value.getGDOP());
    }
    if (!isSparse || value.hasPDOP()) {
        yajl_gen_string(g, (const unsigned char*)  "PDOP" , 4);
        yajl_gen_double(g, (double)value.getPDOP());
    }
    if (!isSparse || value.hasHDOP()) {
        yajl_gen_string(g, (const unsigned char*)  "HDOP" , 4);
        yajl_gen_double(g, (double)value.getHDOP());
    }
    if (!isSparse || value.hasTDOP()) {
        yajl_gen_string(g, (const unsigned char*)  "TDOP" , 4);
        yajl_gen_double(g, (double)value.getTDOP());
    }
    if (!isSparse || value.hasVDOP()) {
        yajl_gen_string(g, (const unsigned char*)  "VDOP" , 4);
        yajl_gen_double(g, (double)value.getVDOP());
    }
    if (!isSparse || value.hasSatSysUsed()) {
        yajl_gen_string(g, (const unsigned char*)  "SatSysUsed" , 10);
        serializeJson(value.getSatSysUsed(), g, options);
    }
    if (!isSparse || value.hasSatellitesVisible()) {
        yajl_gen_string(g, (const unsigned char*)  "SatellitesVisible" , 17);
        yajl_gen_integer(g, (long long)value.getSatellitesVisible());
    }
    if (!isSparse || value.hasSatellitesReceived()) {
        yajl_gen_string(g, (const unsigned char*)  "SatellitesReceived" , 18);
        yajl_gen_integer(g, (long long)value.getSatellitesReceived());
    }
    if (!isSparse || value.hasSatellitesUsed()) {
        yajl_gen_string(g, (const unsigned char*)  "SatellitesUsed" , 14);
        yajl_gen_integer(g, (long long)value.getSatellitesUsed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_GnssPvtData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TimeDate"

void serializeJson (const ::location_fi_types::T_TimeDate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTd_year()) {
        yajl_gen_string(g, (const unsigned char*)  "td_year" , 7);
        yajl_gen_integer(g, (long long)value.getTd_year());
    }
    if (!isSparse || value.hasTd_month()) {
        yajl_gen_string(g, (const unsigned char*)  "td_month" , 8);
        yajl_gen_integer(g, (long long)value.getTd_month());
    }
    if (!isSparse || value.hasTd_day()) {
        yajl_gen_string(g, (const unsigned char*)  "td_day" , 6);
        yajl_gen_integer(g, (long long)value.getTd_day());
    }
    if (!isSparse || value.hasTd_hour()) {
        yajl_gen_string(g, (const unsigned char*)  "td_hour" , 7);
        yajl_gen_integer(g, (long long)value.getTd_hour());
    }
    if (!isSparse || value.hasTd_minute()) {
        yajl_gen_string(g, (const unsigned char*)  "td_minute" , 9);
        yajl_gen_integer(g, (long long)value.getTd_minute());
    }
    if (!isSparse || value.hasTd_second()) {
        yajl_gen_string(g, (const unsigned char*)  "td_second" , 9);
        yajl_gen_integer(g, (long long)value.getTd_second());
    }
    if (!isSparse || value.hasTd_milliSeconds()) {
        yajl_gen_string(g, (const unsigned char*)  "td_milliSeconds" , 15);
        yajl_gen_integer(g, (long long)value.getTd_milliSeconds());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_TimeDate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GnssChanData"

void serializeJson (const ::location_fi_types::T_GnssChanData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSvId()) {
        yajl_gen_string(g, (const unsigned char*)  "SvId" , 4);
        yajl_gen_integer(g, (long long)value.getSvId());
    }
    if (!isSparse || value.hasSatStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SatStatus" , 9);
        serializeJson(value.getSatStatus(), g, options);
    }
    if (!isSparse || value.hasAzimuth()) {
        yajl_gen_string(g, (const unsigned char*)  "Azimuth" , 7);
        yajl_gen_double(g, (double)value.getAzimuth());
    }
    if (!isSparse || value.hasElevation()) {
        yajl_gen_string(g, (const unsigned char*)  "Elevation" , 9);
        yajl_gen_double(g, (double)value.getElevation());
    }
    if (!isSparse || value.hasCarrierToNoiseRatio()) {
        yajl_gen_string(g, (const unsigned char*)  "CarrierToNoiseRatio" , 19);
        yajl_gen_integer(g, (long long)value.getCarrierToNoiseRatio());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_GnssChanData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GnssData"

void serializeJson (const ::location_fi_types::T_GnssData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "Timestamp" , 9);
        yajl_gen_integer(g, (long long)value.getTimestamp());
    }
    if (!isSparse || value.hasGnssPvtData()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssPvtData" , 11);
        serializeJson(value.getGnssPvtData(), g, options);
    }
    if (!isSparse || value.hasGnssChanDataList()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssChanDataList" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::location_fi_types::T_GnssChanData >& o1 = value.getGnssChanDataList();
        {
            ::std::vector< ::location_fi_types::T_GnssChanData >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_GnssData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AllSensorData"

void serializeJson (const ::location_fi_types::T_AllSensorData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGnssUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "GnssUpdate" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::location_fi_types::T_GnssData >& o3 = value.getGnssUpdate();
        {
            ::std::vector< ::location_fi_types::T_GnssData >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasOdometerUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "OdometerUpdate" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::location_fi_types::T_OdometerData >& o5 = value.getOdometerUpdate();
        {
            ::std::vector< ::location_fi_types::T_OdometerData >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasAbsUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "AbsUpdate" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::location_fi_types::T_AbsData >& o7 = value.getAbsUpdate();
        {
            ::std::vector< ::location_fi_types::T_AbsData >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasGyroUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "GyroUpdate" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::location_fi_types::T_3dGyroData >& o9 = value.getGyroUpdate();
        {
            ::std::vector< ::location_fi_types::T_3dGyroData >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasGyroTemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "GyroTemperature" , 15);
        yajl_gen_double(g, (double)value.getGyroTemperature());
    }
    if (!isSparse || value.hasAccUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "AccUpdate" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::location_fi_types::T_3dAccData >& o11 = value.getAccUpdate();
        {
            ::std::vector< ::location_fi_types::T_3dAccData >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasAccTemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "AccTemperature" , 14);
        yajl_gen_double(g, (double)value.getAccTemperature());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::location_fi_types::T_AllSensorData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_VdsVersionInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_OdometerData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_AbsData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_SensorHwInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_3dMountAngles& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_3dGyroHwInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_3dAccHwInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_3dGyroData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_3dAccData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_b8_GnssSatSys& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_b8_GnssSatStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_GnssConfigData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_GnssStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_CovarianceMatrixUpperTriangle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_GnssPvtData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_TimeDate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_GnssChanData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_GnssData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types
using namespace ::asf::stream::json;

namespace location_fi_types {

std::ostream& operator<<(std::ostream& o, const ::location_fi_types::T_AllSensorData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace location_fi_types

