/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "location_fi_types.h"
#include "location_fi_typesCca.h"
#include "location_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::location_fi_types::T_VdsVersionInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getVdsVersion();
    out << in.getBoardVersion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_VdsVersionInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o0;
    in >> o0;
    out.setVdsVersion(o0);
    ::std::string o1;
    in >> o1;
    out.setBoardVersion(o1);
}

void serializeCca(const ::location_fi_types::T_OdometerData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTimestamp();
    out << in.getOdometerCount();
    out << (uint8) in.getOdometerStatus();
    out << (uint8) in.getOdometerCount_Direction();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_OdometerData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o2;
    in >> o2;
    out.setTimestamp(o2);
    uint16 o3;
    in >> o3;
    out.setOdometerCount(o3);
    uint8 o4;
    in >> o4;
    out.setOdometerStatus((::location_fi_types::T_e8_OdometerStatus)o4);
    uint8 o5;
    in >> o5;
    out.setOdometerCount_Direction((::location_fi_types::T_e8_OdometerDirection)o5);
}

void serializeCca(const ::location_fi_types::T_AbsData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAbsTimeStamp();
    out << in.getWheelCounterFrontLeft();
    out << in.getWheelCounterFrontRight();
    out << in.getWheelCounterRearLeft();
    out << in.getWheelCounterRearRight();
    out << (uint8) in.getStatusFrontLeft();
    out << (uint8) in.getStatusFrontRight();
    out << (uint8) in.getStatusRearLeft();
    out << (uint8) in.getStatusRearRight();
    out << (uint8) in.getDirectionFrontLeft();
    out << (uint8) in.getDirectionFrontRight();
    out << (uint8) in.getDirectionRearLeft();
    out << (uint8) in.getDirectionRearRight();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_AbsData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o6;
    in >> o6;
    out.setAbsTimeStamp(o6);
    uint16 o7;
    in >> o7;
    out.setWheelCounterFrontLeft(o7);
    uint16 o8;
    in >> o8;
    out.setWheelCounterFrontRight(o8);
    uint16 o9;
    in >> o9;
    out.setWheelCounterRearLeft(o9);
    uint16 o10;
    in >> o10;
    out.setWheelCounterRearRight(o10);
    uint8 o11;
    in >> o11;
    out.setStatusFrontLeft((::location_fi_types::T_e8_AbsStatus)o11);
    uint8 o12;
    in >> o12;
    out.setStatusFrontRight((::location_fi_types::T_e8_AbsStatus)o12);
    uint8 o13;
    in >> o13;
    out.setStatusRearLeft((::location_fi_types::T_e8_AbsStatus)o13);
    uint8 o14;
    in >> o14;
    out.setStatusRearRight((::location_fi_types::T_e8_AbsStatus)o14);
    uint8 o15;
    in >> o15;
    out.setDirectionFrontLeft((::location_fi_types::T_e8_AbsDirection)o15);
    uint8 o16;
    in >> o16;
    out.setDirectionFrontRight((::location_fi_types::T_e8_AbsDirection)o16);
    uint8 o17;
    in >> o17;
    out.setDirectionRearLeft((::location_fi_types::T_e8_AbsDirection)o17);
    uint8 o18;
    in >> o18;
    out.setDirectionRearRight((::location_fi_types::T_e8_AbsDirection)o18);
}

void serializeCca(const ::location_fi_types::T_SensorHwInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAdcRangeMin();
    out << in.getAdcRangeMax();
    out << in.getSampleMin();
    out << in.getSampleMax();
    out << in.getMinNoiseValue();
    out << in.getEstimOffset();
    out << in.getMinOffset();
    out << in.getMaxOffset();
    out << in.getDriftOffset();
    out << in.getMaxUnsteadOffset();
    out << in.getBestCalibOffset();
    out << in.getEstimScaleFactor();
    out << in.getMinScaleFactor();
    out << in.getMaxScaleFactor();
    out << in.getDriftScaleFactor();
    out << in.getMaxUnsteadScaleFactor();
    out << in.getBestCalibScaleFactor();
    out << in.getDriftOffsetTime();
    out << in.getDriftScaleFactorTime();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_SensorHwInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o19;
    in >> o19;
    out.setAdcRangeMin(o19);
    uint32 o20;
    in >> o20;
    out.setAdcRangeMax(o20);
    uint32 o21;
    in >> o21;
    out.setSampleMin(o21);
    uint32 o22;
    in >> o22;
    out.setSampleMax(o22);
    float o23;
    in >> o23;
    out.setMinNoiseValue(o23);
    float o24;
    in >> o24;
    out.setEstimOffset(o24);
    float o25;
    in >> o25;
    out.setMinOffset(o25);
    float o26;
    in >> o26;
    out.setMaxOffset(o26);
    float o27;
    in >> o27;
    out.setDriftOffset(o27);
    float o28;
    in >> o28;
    out.setMaxUnsteadOffset(o28);
    float o29;
    in >> o29;
    out.setBestCalibOffset(o29);
    float o30;
    in >> o30;
    out.setEstimScaleFactor(o30);
    float o31;
    in >> o31;
    out.setMinScaleFactor(o31);
    float o32;
    in >> o32;
    out.setMaxScaleFactor(o32);
    float o33;
    in >> o33;
    out.setDriftScaleFactor(o33);
    float o34;
    in >> o34;
    out.setMaxUnsteadScaleFactor(o34);
    float o35;
    in >> o35;
    out.setBestCalibScaleFactor(o35);
    float o36;
    in >> o36;
    out.setDriftOffsetTime(o36);
    float o37;
    in >> o37;
    out.setDriftScaleFactorTime(o37);
}

void serializeCca(const ::location_fi_types::T_3dMountAngles& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAngRX();
    out << in.getAngRY();
    out << in.getAngRZ();
    out << in.getAngSX();
    out << in.getAngSY();
    out << in.getAngSZ();
    out << in.getAngTX();
    out << in.getAngTY();
    out << in.getAngTZ();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_3dMountAngles& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o38;
    in >> o38;
    out.setAngRX(o38);
    uint8 o39;
    in >> o39;
    out.setAngRY(o39);
    uint8 o40;
    in >> o40;
    out.setAngRZ(o40);
    uint8 o41;
    in >> o41;
    out.setAngSX(o41);
    uint8 o42;
    in >> o42;
    out.setAngSY(o42);
    uint8 o43;
    in >> o43;
    out.setAngSZ(o43);
    uint8 o44;
    in >> o44;
    out.setAngTX(o44);
    uint8 o45;
    in >> o45;
    out.setAngTY(o45);
    uint8 o46;
    in >> o46;
    out.setAngTZ(o46);
}

void serializeCca(const ::location_fi_types::T_3dGyroHwInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSampleRate();
    serializeCca(in.getMountAngles(), out, majorVersion);
    serializeCca(in.getRAxes(), out, majorVersion);
    serializeCca(in.getSAxes(), out, majorVersion);
    serializeCca(in.getTAxes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_3dGyroHwInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o47;
    in >> o47;
    out.setSampleRate(o47);
    deserializeCca(in, out.getMountAnglesMutable(), majorVersion);
    deserializeCca(in, out.getRAxesMutable(), majorVersion);
    deserializeCca(in, out.getSAxesMutable(), majorVersion);
    deserializeCca(in, out.getTAxesMutable(), majorVersion);
}

void serializeCca(const ::location_fi_types::T_3dAccHwInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSampleRate();
    serializeCca(in.getMountAngles(), out, majorVersion);
    serializeCca(in.getRAxes(), out, majorVersion);
    serializeCca(in.getSAxes(), out, majorVersion);
    serializeCca(in.getTAxes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_3dAccHwInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o48;
    in >> o48;
    out.setSampleRate(o48);
    deserializeCca(in, out.getMountAnglesMutable(), majorVersion);
    deserializeCca(in, out.getRAxesMutable(), majorVersion);
    deserializeCca(in, out.getSAxesMutable(), majorVersion);
    deserializeCca(in, out.getTAxesMutable(), majorVersion);
}

void serializeCca(const ::location_fi_types::T_3dGyroData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTimeStamp3dGyro();
    out << in.getRVal();
    out << in.getSVal();
    out << in.getTVal();
    out << (uint16) in.getRStatus();
    out << (uint16) in.getSStatus();
    out << (uint16) in.getTStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_3dGyroData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o49;
    in >> o49;
    out.setTimeStamp3dGyro(o49);
    uint32 o50;
    in >> o50;
    out.setRVal(o50);
    uint32 o51;
    in >> o51;
    out.setSVal(o51);
    uint32 o52;
    in >> o52;
    out.setTVal(o52);
    uint16 o53;
    in >> o53;
    out.setRStatus((::location_fi_types::T_e16_GyroStatus)o53);
    uint16 o54;
    in >> o54;
    out.setSStatus((::location_fi_types::T_e16_GyroStatus)o54);
    uint16 o55;
    in >> o55;
    out.setTStatus((::location_fi_types::T_e16_GyroStatus)o55);
}

void serializeCca(const ::location_fi_types::T_3dAccData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTimeStamp3dAcc();
    out << in.getRVal();
    out << in.getSVal();
    out << in.getTVal();
    out << (uint16) in.getRStatus();
    out << (uint16) in.getSStatus();
    out << (uint16) in.getTStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_3dAccData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o56;
    in >> o56;
    out.setTimeStamp3dAcc(o56);
    uint32 o57;
    in >> o57;
    out.setRVal(o57);
    uint32 o58;
    in >> o58;
    out.setSVal(o58);
    uint32 o59;
    in >> o59;
    out.setTVal(o59);
    uint16 o60;
    in >> o60;
    out.setRStatus((::location_fi_types::T_e16_AccStatus)o60);
    uint16 o61;
    in >> o61;
    out.setSStatus((::location_fi_types::T_e16_AccStatus)o61);
    uint16 o62;
    in >> o62;
    out.setTStatus((::location_fi_types::T_e16_AccStatus)o62);
}

void serializeCca(const ::location_fi_types::T_b8_GnssSatSys& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getGNSS_SATSYS_GPS()) {
        bitmask |= (1 << 0);
    }
    if (in.getGNSS_SATSYS_GLONASS()) {
        bitmask |= (1 << 1);
    }
    if (in.getGNSS_SATSYS_GALILEO()) {
        bitmask |= (1 << 2);
    }
    if (in.getGNSS_SATSYS_COMPASS()) {
        bitmask |= (1 << 3);
    }
    if (in.getGNSS_SATSYS_SBAS()) {
        bitmask |= (1 << 4);
    }
    if (in.getGNSS_SATSYS_QZSS()) {
        bitmask |= (1 << 5);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_b8_GnssSatSys& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o63;
    in >> o63;
    uint8 bitmask(o63);

    if (bitmask & (1 << 0)) {
        out.setGNSS_SATSYS_GPS (true);
    }
    if (bitmask & (1 << 1)) {
        out.setGNSS_SATSYS_GLONASS (true);
    }
    if (bitmask & (1 << 2)) {
        out.setGNSS_SATSYS_GALILEO (true);
    }
    if (bitmask & (1 << 3)) {
        out.setGNSS_SATSYS_COMPASS (true);
    }
    if (bitmask & (1 << 4)) {
        out.setGNSS_SATSYS_SBAS (true);
    }
    if (bitmask & (1 << 5)) {
        out.setGNSS_SATSYS_QZSS (true);
    }
}

void serializeCca(const ::location_fi_types::T_b8_GnssSatStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getSAT_HEALTHY()) {
        bitmask |= (1 << 0);
    }
    if (in.getSAT_ALMANAC_AVAILABLE()) {
        bitmask |= (1 << 1);
    }
    if (in.getSAT_EPHEMERIS_AVAILABLE()) {
        bitmask |= (1 << 2);
    }
    if (in.getSAT_DGPS_AVAILABLE()) {
        bitmask |= (1 << 3);
    }
    if (in.getSAT_TRACKED()) {
        bitmask |= (1 << 4);
    }
    if (in.getSAT_USED_FOR_POSCALC()) {
        bitmask |= (1 << 5);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_b8_GnssSatStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o64;
    in >> o64;
    uint8 bitmask(o64);

    if (bitmask & (1 << 0)) {
        out.setSAT_HEALTHY (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSAT_ALMANAC_AVAILABLE (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSAT_EPHEMERIS_AVAILABLE (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSAT_DGPS_AVAILABLE (true);
    }
    if (bitmask & (1 << 4)) {
        out.setSAT_TRACKED (true);
    }
    if (bitmask & (1 << 5)) {
        out.setSAT_USED_FOR_POSCALC (true);
    }
}

void serializeCca(const ::location_fi_types::T_GnssConfigData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getGnssHardwareType();
    out << in.getGnssReceiverFirmwareVersion();
    out << in.getGnssReceiverFirmwareCrc();
    out << in.getNumberOfChannels();
    serializeCca(in.getUsedSatStatusBits(), out, majorVersion);
    out << in.getUpdateFrequency();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_GnssConfigData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o65;
    in >> o65;
    out.setGnssHardwareType((::location_fi_types::T_e8_GnssHw)o65);
    uint32 o66;
    in >> o66;
    out.setGnssReceiverFirmwareVersion(o66);
    uint32 o67;
    in >> o67;
    out.setGnssReceiverFirmwareCrc(o67);
    uint16 o68;
    in >> o68;
    out.setNumberOfChannels(o68);
    deserializeCca(in, out.getUsedSatStatusBitsMutable(), majorVersion);
    uint8 o69;
    in >> o69;
    out.setUpdateFrequency(o69);
}

void serializeCca(const ::location_fi_types::T_GnssStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getGnssQuality();
    out << (uint8) in.getGnssMode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_GnssStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o70;
    in >> o70;
    out.setGnssQuality((::location_fi_types::T_e8_GnssQuality)o70);
    uint8 o71;
    in >> o71;
    out.setGnssMode((::location_fi_types::T_e8_GnssMode)o71);
}

void serializeCca(const ::location_fi_types::T_CovarianceMatrixUpperTriangle& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getElem0();
    out << in.getElem4();
    out << in.getElem5();
    out << in.getElem8();
    out << in.getElem9();
    out << in.getElem10();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_CovarianceMatrixUpperTriangle& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    float o72;
    in >> o72;
    out.setElem0(o72);
    float o73;
    in >> o73;
    out.setElem4(o73);
    float o74;
    in >> o74;
    out.setElem5(o74);
    float o75;
    in >> o75;
    out.setElem8(o75);
    float o76;
    in >> o76;
    out.setElem9(o76);
    float o77;
    in >> o77;
    out.setElem10(o77);
}

void serializeCca(const ::location_fi_types::T_GnssPvtData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getUtcTimeDate(), out, majorVersion);
    out << in.getLatitude();
    out << in.getLongitude();
    out << in.getAltitudeWGS84();
    out << in.getGeoidalSeparation();
    out << in.getVelocityNorth();
    out << in.getVelocityEast();
    out << in.getVelocityUp();
    serializeCca(in.getPositionCovarianceMatrix(), out, majorVersion);
    serializeCca(in.getVelocityCovarianceMatrix(), out, majorVersion);
    serializeCca(in.getGnssStatus(), out, majorVersion);
    out << in.getGDOP();
    out << in.getPDOP();
    out << in.getHDOP();
    out << in.getTDOP();
    out << in.getVDOP();
    serializeCca(in.getSatSysUsed(), out, majorVersion);
    out << in.getSatellitesVisible();
    out << in.getSatellitesReceived();
    out << in.getSatellitesUsed();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_GnssPvtData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getUtcTimeDateMutable(), majorVersion);
    double o78;
    in >> o78;
    out.setLatitude(o78);
    double o79;
    in >> o79;
    out.setLongitude(o79);
    float o80;
    in >> o80;
    out.setAltitudeWGS84(o80);
    float o81;
    in >> o81;
    out.setGeoidalSeparation(o81);
    float o82;
    in >> o82;
    out.setVelocityNorth(o82);
    float o83;
    in >> o83;
    out.setVelocityEast(o83);
    float o84;
    in >> o84;
    out.setVelocityUp(o84);
    deserializeCca(in, out.getPositionCovarianceMatrixMutable(), majorVersion);
    deserializeCca(in, out.getVelocityCovarianceMatrixMutable(), majorVersion);
    deserializeCca(in, out.getGnssStatusMutable(), majorVersion);
    float o85;
    in >> o85;
    out.setGDOP(o85);
    float o86;
    in >> o86;
    out.setPDOP(o86);
    float o87;
    in >> o87;
    out.setHDOP(o87);
    float o88;
    in >> o88;
    out.setTDOP(o88);
    float o89;
    in >> o89;
    out.setVDOP(o89);
    deserializeCca(in, out.getSatSysUsedMutable(), majorVersion);
    uint16 o90;
    in >> o90;
    out.setSatellitesVisible(o90);
    uint16 o91;
    in >> o91;
    out.setSatellitesReceived(o91);
    uint16 o92;
    in >> o92;
    out.setSatellitesUsed(o92);
}

void serializeCca(const ::location_fi_types::T_GnssChanData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSvId();
    serializeCca(in.getSatStatus(), out, majorVersion);
    out << in.getAzimuth();
    out << in.getElevation();
    out << in.getCarrierToNoiseRatio();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_GnssChanData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o93;
    in >> o93;
    out.setSvId(o93);
    deserializeCca(in, out.getSatStatusMutable(), majorVersion);
    float o94;
    in >> o94;
    out.setAzimuth(o94);
    float o95;
    in >> o95;
    out.setElevation(o95);
    uint8 o96;
    in >> o96;
    out.setCarrierToNoiseRatio(o96);
}

void serializeCca(const ::location_fi_types::T_GnssData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTimestamp();
    serializeCca(in.getGnssPvtData(), out, majorVersion);
    {
        uint32 o97 = static_cast<uint32>(in.getGnssChanDataList().size());
        out << o97;
        ::std::vector< ::location_fi_types::T_GnssChanData >::const_iterator o98;
        for (o98 = in.getGnssChanDataList().begin(); o98 != in.getGnssChanDataList().end(); ++o98) {
            serializeCca((*o98), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_GnssData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o99;
    in >> o99;
    out.setTimestamp(o99);
    deserializeCca(in, out.getGnssPvtDataMutable(), majorVersion);
    {
        uint32 o100;
        in >> o100;
        out.getGnssChanDataListMutable().clear ();
        out.getGnssChanDataListMutable().reserve (o100);
        for (uint32 o101 = 0; o101 < o100; o101++) {
            ::location_fi_types::T_GnssChanData o102;
            deserializeCca(in, o102, majorVersion);
            out.getGnssChanDataListMutable().push_back (o102);
        }
    }
}

void serializeCca(const ::location_fi_types::T_TimeDate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTd_year();
    out << in.getTd_month();
    out << in.getTd_day();
    out << in.getTd_hour();
    out << in.getTd_minute();
    out << in.getTd_second();
    out << in.getTd_milliSeconds();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_TimeDate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o103;
    in >> o103;
    out.setTd_year(o103);
    uint8 o104;
    in >> o104;
    out.setTd_month(o104);
    uint8 o105;
    in >> o105;
    out.setTd_day(o105);
    uint8 o106;
    in >> o106;
    out.setTd_hour(o106);
    uint8 o107;
    in >> o107;
    out.setTd_minute(o107);
    uint8 o108;
    in >> o108;
    out.setTd_second(o108);
    uint16 o109;
    in >> o109;
    out.setTd_milliSeconds(o109);
}

void serializeCca(const ::location_fi_types::T_AllSensorData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o110 = static_cast<uint32>(in.getGnssUpdate().size());
        out << o110;
        ::std::vector< ::location_fi_types::T_GnssData >::const_iterator o111;
        for (o111 = in.getGnssUpdate().begin(); o111 != in.getGnssUpdate().end(); ++o111) {
            serializeCca((*o111), out, majorVersion);
        }
    }
    {
        uint32 o112 = static_cast<uint32>(in.getOdometerUpdate().size());
        out << o112;
        ::std::vector< ::location_fi_types::T_OdometerData >::const_iterator o113;
        for (o113 = in.getOdometerUpdate().begin(); o113 != in.getOdometerUpdate().end(); ++o113) {
            serializeCca((*o113), out, majorVersion);
        }
    }
    {
        uint32 o114 = static_cast<uint32>(in.getAbsUpdate().size());
        out << o114;
        ::std::vector< ::location_fi_types::T_AbsData >::const_iterator o115;
        for (o115 = in.getAbsUpdate().begin(); o115 != in.getAbsUpdate().end(); ++o115) {
            serializeCca((*o115), out, majorVersion);
        }
    }
    {
        uint32 o116 = static_cast<uint32>(in.getGyroUpdate().size());
        out << o116;
        ::std::vector< ::location_fi_types::T_3dGyroData >::const_iterator o117;
        for (o117 = in.getGyroUpdate().begin(); o117 != in.getGyroUpdate().end(); ++o117) {
            serializeCca((*o117), out, majorVersion);
        }
    }
    out << in.getGyroTemperature();
    {
        uint32 o118 = static_cast<uint32>(in.getAccUpdate().size());
        out << o118;
        ::std::vector< ::location_fi_types::T_3dAccData >::const_iterator o119;
        for (o119 = in.getAccUpdate().begin(); o119 != in.getAccUpdate().end(); ++o119) {
            serializeCca((*o119), out, majorVersion);
        }
    }
    out << in.getAccTemperature();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::location_fi_types::T_AllSensorData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o120;
        in >> o120;
        out.getGnssUpdateMutable().clear ();
        out.getGnssUpdateMutable().reserve (o120);
        for (uint32 o121 = 0; o121 < o120; o121++) {
            ::location_fi_types::T_GnssData o122;
            deserializeCca(in, o122, majorVersion);
            out.getGnssUpdateMutable().push_back (o122);
        }
    }
    {
        uint32 o123;
        in >> o123;
        out.getOdometerUpdateMutable().clear ();
        out.getOdometerUpdateMutable().reserve (o123);
        for (uint32 o124 = 0; o124 < o123; o124++) {
            ::location_fi_types::T_OdometerData o125;
            deserializeCca(in, o125, majorVersion);
            out.getOdometerUpdateMutable().push_back (o125);
        }
    }
    {
        uint32 o126;
        in >> o126;
        out.getAbsUpdateMutable().clear ();
        out.getAbsUpdateMutable().reserve (o126);
        for (uint32 o127 = 0; o127 < o126; o127++) {
            ::location_fi_types::T_AbsData o128;
            deserializeCca(in, o128, majorVersion);
            out.getAbsUpdateMutable().push_back (o128);
        }
    }
    {
        uint32 o129;
        in >> o129;
        out.getGyroUpdateMutable().clear ();
        out.getGyroUpdateMutable().reserve (o129);
        for (uint32 o130 = 0; o130 < o129; o130++) {
            ::location_fi_types::T_3dGyroData o131;
            deserializeCca(in, o131, majorVersion);
            out.getGyroUpdateMutable().push_back (o131);
        }
    }
    float o132;
    in >> o132;
    out.setGyroTemperature(o132);
    {
        uint32 o133;
        in >> o133;
        out.getAccUpdateMutable().clear ();
        out.getAccUpdateMutable().reserve (o133);
        for (uint32 o134 = 0; o134 < o133; o134++) {
            ::location_fi_types::T_3dAccData o135;
            deserializeCca(in, o135, majorVersion);
            out.getAccUpdateMutable().push_back (o135);
        }
    }
    float o136;
    in >> o136;
    out.setAccTemperature(o136);
}

