/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "ScreenBroker/Service/ScreenBroker.h"
#include "ScreenBroker/Service/ScreenBrokerService.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "ScreenBroker" isn't clear, then there should be a description here.
 */

namespace ScreenBroker {
namespace Service {

DEFINE_LOGGER_AND_LEVEL (_logger, "/ScreenBroker/Service/ScreenBroker", Info);

/* static */ const char* ScreenBroker::sbcore = "sbcore";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool ScreenBroker_enabledASFSignalHandler = false;

void importScreenBroker() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach ScreenBroker, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'thScreenbrokercore'

    ::asf::core::ComponentContainerSharedPtr ThScreenbrokercore(new ::asf::core::ComponentContainer("thScreenbrokercore", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ThScreenbrokercore);

        // Component 'ScreenBrokerService sbcore'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::ScreenBroker::Service::ScreenBrokerService > > sbcoreFactory(new ::asf::core::ComponentFactory< ::ScreenBroker::Service::ScreenBrokerService >);
        ::asf::core::ComponentDescriptionSharedPtr sbcoreDescription(new ::asf::core::ComponentDescription(1, "sbcore", /* immediate = */ true, /* threadBridge = */ false, sbcoreFactory));
        ThScreenbrokercore->addComponentDescription(sbcoreDescription);

            // Port 'SBServicePort_o'

            ::asf::core::ProvidedPort& sbcore_SBServicePort_o = sbcoreDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort_o", false, false));
            (void)sbcore_SBServicePort_o; // prevent unused variable warning

    // Expression

    dbusSessionConnector_->exportByName (sbcore_SBServicePort_o, ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));


    LOG_INFO_STATIC("Starting application 'ScreenBroker' version 1.0.0");

    app->start();
}

int executeScreenBroker(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("ScreenBroker.Service", "ScreenBroker");
    } else {
        ::asf::core::Logger::setupLogging ("ScreenBroker.Service", "ScreenBroker", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", ScreenBroker_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("ScreenBroker.Service", "ScreenBroker", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create ScreenBroker");

    app->enableExceptionHandler(true);

    importScreenBroker();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Service
} // namespace ScreenBroker

int main(int argc, char* argv[]) {
    ::ScreenBroker::Service::ScreenBroker_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::ScreenBroker::Service::executeScreenBroker(argc, argv);
}

