/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/ProcConfigManager.h"
#include "asf/cfgmgr_ASFAppClient.h"
#include "asf/cfgmgr_ASFAppServer.h"
#include "asf/cfgmgr_ASFOtaClient.h"
#include "asf/cfgmgr_ASFStartUp.h"
#include "asf/cfgmgr_DiagnosisClient.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusExportedPort.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "ProcConfigManager" isn't clear, then there should be a description here.
 */

namespace asf {

DEFINE_LOGGER_AND_LEVEL (_logger, "/asf/ProcConfigManager", Info);

/* static */ const char* ProcConfigManager::startUp = "startUp";
/* static */ const char* ProcConfigManager::cfgmgrServer = "cfgmgrServer";
/* static */ const char* ProcConfigManager::cfgmgrClient = "cfgmgrClient";
/* static */ const char* ProcConfigManager::cfgmgrOtaClient = "cfgmgrOtaClient";
/* static */ const char* ProcConfigManager::cfgmgrDiagClient = "cfgmgrDiagClient";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool ProcConfigManager_enabledASFSignalHandler = false;

void importProcConfigManager() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach ProcConfigManager, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSesConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSesConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSesConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSesConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSesConnector_(new ::asf::dbus::DBusConnector(*app, dbusSesConnector));
    app->addStarter(dbusSesConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSysConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSysConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSysConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSysConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSysConnector_(new ::asf::dbus::DBusConnector(*app, dbusSysConnector));
    app->addStarter(dbusSysConnector_);

    // Thread 'T1'

    ::asf::core::ComponentContainerSharedPtr T1(new ::asf::core::ComponentContainer("T1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (T1);

        // Component 'cfgmgr_ASFStartUp startUp'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::cfgmgr_ASFStartUp > > startUpFactory(new ::asf::core::ComponentFactory< ::asf::cfgmgr_ASFStartUp >);
        ::asf::core::ComponentDescriptionSharedPtr startUpDescription(new ::asf::core::ComponentDescription(1, "startUp", /* immediate = */ true, /* threadBridge = */ false, startUpFactory));
        T1->addComponentDescription(startUpDescription);

        // Component 'cfgmgr_ASFAppServer cfgmgrServer'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::cfgmgr_ASFAppServer > > cfgmgrServerFactory(new ::asf::core::ComponentFactory< ::asf::cfgmgr_ASFAppServer >);
        ::asf::core::ComponentDescriptionSharedPtr cfgmgrServerDescription(new ::asf::core::ComponentDescription(2, "cfgmgrServer", /* immediate = */ true, /* threadBridge = */ false, cfgmgrServerFactory));
        T1->addComponentDescription(cfgmgrServerDescription);

            // Port 'configPort'

            ::asf::core::ProvidedPort& cfgmgrServer_configPort = cfgmgrServerDescription->addProvidedPort (::asf::core::ProvidedPort ("de.bosch.cm.ConfigManager.ConfigManagement", "configPort", false, false));
            (void)cfgmgrServer_configPort; // prevent unused variable warning

            // Port 'configDataPort'

            ::asf::core::RequiredPort& cfgmgrServer_configDataPort = cfgmgrServerDescription->addRequiredPort (::asf::core::RequiredPort ("de.bosch.cm.ConfigManager.ConfigData", "configDataPort", /* wired at runtime */ true));
            (void)cfgmgrServer_configDataPort; // prevent unused variable warning

        // Component 'cfgmgr_ASFAppClient cfgmgrClient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::cfgmgr_ASFAppClient > > cfgmgrClientFactory(new ::asf::core::ComponentFactory< ::asf::cfgmgr_ASFAppClient >);
        ::asf::core::ComponentDescriptionSharedPtr cfgmgrClientDescription(new ::asf::core::ComponentDescription(3, "cfgmgrClient", /* immediate = */ true, /* threadBridge = */ false, cfgmgrClientFactory));
        T1->addComponentDescription(cfgmgrClientDescription);

            // Port 'configDataPort'

            ::asf::core::RequiredPort& cfgmgrClient_configDataPort = cfgmgrClientDescription->addRequiredPort (::asf::core::RequiredPort ("de.bosch.cm.ConfigManager.ConfigData", "configDataPort", /* wired at runtime */ true));
            (void)cfgmgrClient_configDataPort; // prevent unused variable warning

        // Component 'cfgmgr_ASFOtaClient cfgmgrOtaClient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::cfgmgr_ASFOtaClient > > cfgmgrOtaClientFactory(new ::asf::core::ComponentFactory< ::asf::cfgmgr_ASFOtaClient >);
        ::asf::core::ComponentDescriptionSharedPtr cfgmgrOtaClientDescription(new ::asf::core::ComponentDescription(4, "cfgmgrOtaClient", /* immediate = */ true, /* threadBridge = */ false, cfgmgrOtaClientFactory));
        T1->addComponentDescription(cfgmgrOtaClientDescription);

            // Port 'fcOtaDescmoEcuSrvPort'

            ::asf::core::RequiredPort& cfgmgrOtaClient_fcOtaDescmoEcuSrvPort = cfgmgrOtaClientDescription->addRequiredPort (::asf::core::RequiredPort ("fcota_descmo_ecu_srv.FcOtaDescmoEcuSrv", "fcOtaDescmoEcuSrvPort"));
            (void)cfgmgrOtaClient_fcOtaDescmoEcuSrvPort; // prevent unused variable warning

        // Component 'cfgmgr_DiagnosisClient cfgmgrDiagClient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::cfgmgr_DiagnosisClient > > cfgmgrDiagClientFactory(new ::asf::core::ComponentFactory< ::asf::cfgmgr_DiagnosisClient >);
        ::asf::core::ComponentDescriptionSharedPtr cfgmgrDiagClientDescription(new ::asf::core::ComponentDescription(5, "cfgmgrDiagClient", /* immediate = */ true, /* threadBridge = */ false, cfgmgrDiagClientFactory));
        T1->addComponentDescription(cfgmgrDiagClientDescription);

            // Port 'cfgmgrSystemSettingPort'

            ::asf::core::ProvidedPort& cfgmgrDiagClient_cfgmgrSystemSettingPort = cfgmgrDiagClientDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "cfgmgrSystemSettingPort", false, false));
            (void)cfgmgrDiagClient_cfgmgrSystemSettingPort; // prevent unused variable warning

    // Expression

    dbusSesConnector_->exportByName (cfgmgrServer_configPort, ::std::string("/de/bosch/cm/ConfigManager/ConfigManagement"));

    // Expression

    ::asf::dbus::DBusImportedPort& OtaClientInterface = dbusSysConnector_->importByName (::std::string("fcota.FcOtaApp"), ::std::string("/org/bosch/cm/ai_ota/fcOtaDescmoEcuSrv"));
    OtaClientInterface.setServiceName("fcota_descmo_ecu_srv.FcOtaDescmoEcuSrv");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cfgmgrOtaClient_fcOtaDescmoEcuSrvPort, OtaClientInterface);

    // Expression

    ::asf::dbus::DBusExportedPort& cfgmgr_DiagnosisClient = dbusSesConnector_->exportByName (cfgmgrDiagClient_cfgmgrSystemSettingPort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1"));
    cfgmgr_DiagnosisClient.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");


    LOG_INFO_STATIC("Starting application 'ProcConfigManager' version 1.0.0");

    app->start();
}

int executeProcConfigManager(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("asf", "ProcConfigManager");
    } else {
        ::asf::core::Logger::setupLogging ("asf", "ProcConfigManager", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", ProcConfigManager_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("asf", "ProcConfigManager", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create ProcConfigManager");

    app->enableExceptionHandler(true);

    importProcConfigManager();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace asf

int main(int argc, char* argv[]) {
    ::asf::ProcConfigManager_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::asf::executeProcConfigManager(argc, argv);
}

