#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_SHARED_FI_TYPES_H
#define MPLAY_SHARED_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "mplay_shared_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * Types mplay_shared_fi_types
 */

namespace mplay_shared_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_e8_CDInfo;


/**
 * CD Info for CD devices
 */
class T_e8_CDInfo {
public:

    /**
     * Default constructor
     */
    inline  T_e8_CDInfo ();

    /**
     * Copy constructor
     */
    inline  T_e8_CDInfo (const T_e8_CDInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_e8_CDInfo (const ::std::string& DriveVersion_, T_e8DeviceState e8DeviceState_);

    /**
     * Destructor
     */
    inline  ~T_e8_CDInfo();

    /**
     * Assignment operator
     */
    inline T_e8_CDInfo& operator = (const T_e8_CDInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_e8_CDInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_e8_CDInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_e8_CDInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_e8_CDInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DriveVersion"

    static const int kDriveVersion = 0;

    /**
     * Clears the field "DriveVersion".
     *
     * The field will be set to its default value. The hasDriveVersion()
     * method will return false.
     */
    inline void clearDriveVersion();

    /**
     * Checks whether the field "DriveVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriveVersion()). Otherwise it will return false.
     */
    inline bool hasDriveVersion () const;

    /**
     * Returns the value of the member "DriveVersion".
     *
     * If the meaning of "DriveVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DriveVersion"
     */
    inline const ::std::string& getDriveVersion () const;

    /**
     * Retrieves the value of the field "DriveVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DriveVersion".
     */
    inline ::std::string& getDriveVersionMutable ();

    /**
     * Sets the value of the member "DriveVersion".
     *
     * If the meaning of "DriveVersion" isn't clear, then there should be a description here.
     *
     * @param DriveVersion The value which will be set
     */
    inline void setDriveVersion (const ::std::string& DriveVersion_);

    /**
     * Sets the value of the member "DriveVersion".
     *
     * If the meaning of "DriveVersion" isn't clear, then there should be a description here.
     *
     * @param DriveVersion The value which will be set
     */
    inline void setDriveVersion (const char* DriveVersion_);

    /**
     * Sets the value of the member "DriveVersion".
     *
     * If the meaning of "DriveVersion" isn't clear, then there should be a description here.
     *
     * @param DriveVersion The value which will be set
     */
    inline void setDriveVersion (const char* value, size_t size);

    // API of field "e8DeviceState"

    static const int kE8DeviceState = 1;

    /**
     * Clears the field "e8DeviceState".
     *
     * The field will be set to its default value. The hasE8DeviceState()
     * method will return false.
     */
    inline void clearE8DeviceState();

    /**
     * Checks whether the field "e8DeviceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceState()). Otherwise it will return false.
     */
    inline bool hasE8DeviceState () const;

    /**
     * Returns the value of the member "e8DeviceState".
     *
     * If the meaning of "e8DeviceState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8DeviceState"
     */
    inline T_e8DeviceState getE8DeviceState () const;

    /**
     * Sets the value of the member "e8DeviceState".
     *
     * If the meaning of "e8DeviceState" isn't clear, then there should be a description here.
     *
     * @param e8DeviceState The value which will be set
     */
    inline void setE8DeviceState (T_e8DeviceState e8DeviceState_);

    static const T_e8_CDInfo &getDefaultInstance();

private:

    inline void set_has_DriveVersion ();

    inline void clear_has_DriveVersion ();

    inline void set_has_e8DeviceState ();

    inline void clear_has_e8DeviceState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DriveVersion;

    T_e8DeviceState _e8DeviceState;

};

inline  T_e8_CDInfo::T_e8_CDInfo ()  :
    _DriveVersion (),
    _e8DeviceState (::mplay_shared_fi_types::T_e8DeviceState__MMGR_DEVICE_NOT_READY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_e8_CDInfo::T_e8_CDInfo (const T_e8_CDInfo &rhs)  :
    _DriveVersion (),
    _e8DeviceState (::mplay_shared_fi_types::T_e8DeviceState__MMGR_DEVICE_NOT_READY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_e8_CDInfo::T_e8_CDInfo (const ::std::string& DriveVersion_, T_e8DeviceState e8DeviceState_)  :
    _DriveVersion (DriveVersion_),
    _e8DeviceState (e8DeviceState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DriveVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8DeviceState_IsValid(e8DeviceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceState_, "T_e8DeviceState", "e8DeviceState", "T_e8_CDInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_e8_CDInfo::~T_e8_CDInfo() {
}

inline T_e8_CDInfo& T_e8_CDInfo::operator = (const T_e8_CDInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDriveVersion()) {
            setDriveVersion(rhs.getDriveVersion());
        } else {
            clearDriveVersion();
        }
        if (rhs.hasE8DeviceState()) {
            setE8DeviceState(rhs.getE8DeviceState());
        } else {
            clearE8DeviceState();
        }
    }
    return *this;
}

inline bool T_e8_CDInfo::operator == (const T_e8_CDInfo& rhs) const {
    return (((!hasDriveVersion() && !rhs.hasDriveVersion()) || getDriveVersion() == rhs.getDriveVersion()) &&
        ((!hasE8DeviceState() && !rhs.hasE8DeviceState()) || getE8DeviceState() == rhs.getE8DeviceState()));
}

inline bool T_e8_CDInfo::operator != (const T_e8_CDInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_e8_CDInfo::operator < (const T_e8_CDInfo& rhs) const {
    if (hasDriveVersion() || rhs.hasDriveVersion()) {
        if (getDriveVersion() < rhs.getDriveVersion()) return true;
        if (getDriveVersion() > rhs.getDriveVersion()) return false;
    }
    if (hasE8DeviceState() || rhs.hasE8DeviceState()) {
        if ((uint32)getE8DeviceState() < (uint32)rhs.getE8DeviceState()) return true;
        if ((uint32)getE8DeviceState() > (uint32)rhs.getE8DeviceState()) return false;
    }
    return false;
}

inline bool T_e8_CDInfo::operator > (const T_e8_CDInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_e8_CDInfo::clear() {
    clearDriveVersion();
    clearE8DeviceState();
}

inline void T_e8_CDInfo::clearDriveVersion() {
    if (hasDriveVersion()) {
         clear_has_DriveVersion();
        _DriveVersion.clear();
     }
}

inline bool T_e8_CDInfo::hasDriveVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_e8_CDInfo::getDriveVersion () const {
    return _DriveVersion;
}

inline ::std::string& T_e8_CDInfo::getDriveVersionMutable () {
    set_has_DriveVersion();
    return _DriveVersion;
}

inline void T_e8_CDInfo::setDriveVersion (const ::std::string& DriveVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DriveVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DriveVersion();
    this->_DriveVersion = DriveVersion_;
}

inline void T_e8_CDInfo::setDriveVersion (const char* DriveVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DriveVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DriveVersion();
    this->_DriveVersion.assign(DriveVersion_);
}

inline void T_e8_CDInfo::setDriveVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DriveVersion();
    this->_DriveVersion.assign(value, size);
}

inline void T_e8_CDInfo::clearE8DeviceState() {
    if (hasE8DeviceState()) {
         clear_has_e8DeviceState();
        _e8DeviceState = ::mplay_shared_fi_types::T_e8DeviceState__MMGR_DEVICE_NOT_READY;
     }
}

inline bool T_e8_CDInfo::hasE8DeviceState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8DeviceState T_e8_CDInfo::getE8DeviceState () const {
    return _e8DeviceState;
}

inline void T_e8_CDInfo::setE8DeviceState (T_e8DeviceState e8DeviceState_) {
    #ifndef NDEBUG
    if (!(T_e8DeviceState_IsValid(e8DeviceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceState_, "T_e8DeviceState", "e8DeviceState", "T_e8_CDInfo");
    }
    #endif
    set_has_e8DeviceState();
    this->_e8DeviceState = e8DeviceState_;
}

inline void T_e8_CDInfo::set_has_DriveVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_e8_CDInfo::clear_has_DriveVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_e8_CDInfo::set_has_e8DeviceState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_e8_CDInfo::clear_has_e8DeviceState () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace mplay_shared_fi_types

#endif // MPLAY_SHARED_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
