/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "MPlay_fi_types.h"
#include "MPlay_fi_typesConst.h"
#include "MPlay_fi_typesJsonPrivate.h"
#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "mplay_MediaPlayer_FI.h"
#include "mplay_MediaPlayer_FIJson.h"
#include "mplay_shared_fi_typesConst.h"
#include "mplay_shared_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "MediaPlayerListChangeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::MediaPlayerListChangeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasE8Change()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Change" , 8);
        const char* s = ::MPlay_fi_types::T_e8_MPlayChange_Name(value.getE8Change());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Change());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasOItems()) {
        yajl_gen_string(g, (const unsigned char*)  "oItems" , 6);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o1 = value.getOItems();
        {
            ::std::vector< uint32 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::MediaPlayerListChangeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NowPlayingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::NowPlayingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasE8NowPlayingState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8NowPlayingState" , 17);
        const char* s = ::MPlay_fi_types::T_e8_MPlayNowPlayingState_Name(value.getE8NowPlayingState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8NowPlayingState());
    }
    if (!isSparse || value.hasU32Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Position" , 11);
        yajl_gen_integer(g, (long long)value.getU32Position());
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasOMediaObject()) {
        yajl_gen_string(g, (const unsigned char*)  "oMediaObject" , 12);
        serializeJson(value.getOMediaObject(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::NowPlayingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlaytimeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::PlaytimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ElapsedPlaytime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ElapsedPlaytime" , 18);
        yajl_gen_integer(g, (long long)value.getU32ElapsedPlaytime());
    }
    if (!isSparse || value.hasU32TotalPlaytime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalPlaytime" , 16);
        yajl_gen_integer(g, (long long)value.getU32TotalPlaytime());
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlaytimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlaybackStateStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8State" , 7);
        const char* s = ::MPlay_fi_types::T_e8_MPlayState_Name(value.getE8State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlaybackModeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Mode" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayMode_Name(value.getE8Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Mode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlaybackModeSet"

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackModeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Mode" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayMode_Name(value.getE8Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Mode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackModeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RepeatModeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::RepeatModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Repeat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Repeat" , 8);
        const char* s = ::MPlay_fi_types::T_e8_MPlayRepeat_Name(value.getE8Repeat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Repeat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RepeatModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RepeatModeSet"

void serializeJson (const ::mplay_MediaPlayer_FI::RepeatModeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Repeat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Repeat" , 8);
        const char* s = ::MPlay_fi_types::T_e8_MPlayRepeat_Name(value.getE8Repeat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Repeat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RepeatModeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IndexingStateStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::IndexingStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOIndexingStateResult()) {
        yajl_gen_string(g, (const unsigned char*)  "oIndexingStateResult" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayIndexingStateResultItem >& o3 = value.getOIndexingStateResult();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayIndexingStateResultItem >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::IndexingStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MediaPlayerDeviceConnectionsStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasODeviceInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "oDeviceInfo" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayDeviceInfoItem >& o5 = value.getODeviceInfo();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayDeviceInfoItem >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveMediaDeviceStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::ActiveMediaDeviceStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasBDeviceActiveSource()) {
        yajl_gen_string(g, (const unsigned char*)  "bDeviceActiveSource" , 19);
        yajl_gen_bool(g, (bool)value.getBDeviceActiveSource());
    }
    if (!isSparse || value.hasBScanSupported()) {
        yajl_gen_string(g, (const unsigned char*)  "bScanSupported" , 14);
        yajl_gen_bool(g, (bool)value.getBScanSupported());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ActiveMediaDeviceStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveMediaDeviceSet"

void serializeJson (const ::mplay_MediaPlayer_FI::ActiveMediaDeviceSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasBDeviceActiveSource()) {
        yajl_gen_string(g, (const unsigned char*)  "bDeviceActiveSource" , 19);
        yajl_gen_bool(g, (bool)value.getBDeviceActiveSource());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ActiveMediaDeviceSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MyMediaSupportedStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::MyMediaSupportedStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBMyMediaSupportedFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "bMyMediaSupportedFlag" , 21);
        yajl_gen_bool(g, (bool)value.getBMyMediaSupportedFlag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::MyMediaSupportedStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentFolderPathStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::CurrentFolderPathStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSCurrentFolderPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sCurrentFolderPath" , 18);
        const char *s = value.getSCurrentFolderPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasTag()) {
        yajl_gen_string(g, (const unsigned char*)  "Tag" , 3);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTag(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CurrentFolderPathStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ScanModeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::ScanModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBScanMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bScanMode" , 9);
        yajl_gen_bool(g, (bool)value.getBScanMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ScanModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ScanModeSet"

void serializeJson (const ::mplay_MediaPlayer_FI::ScanModeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBScanMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bScanMode" , 9);
        yajl_gen_bool(g, (bool)value.getBScanMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ScanModeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiscErrorStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DiscErrorStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBIsError()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsError" , 8);
        yajl_gen_bool(g, (bool)value.getBIsError());
    }
    if (!isSparse || value.hasE8DiscError()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DiscError" , 11);
        const char* s = ::MPlay_fi_types::T_e8_MDiscError_Name(value.getE8DiscError());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DiscError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DiscErrorStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiscMechanicalInfoStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DiscMechanicalInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DiscMechanicalInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DiscMechanicalInfo" , 20);
        const char* s = ::MPlay_fi_types::T_e8_MDiscMechanicalInfo_Name(value.getE8DiscMechanicalInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DiscMechanicalInfo());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DiscMechanicalInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CMSkipAvailableStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::CMSkipAvailableStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBCMSkipAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bCMSkipAvailable" , 16);
        yajl_gen_bool(g, (bool)value.getBCMSkipAvailable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CMSkipAvailableStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DirectSelectAvailableStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DirectSelectAvailableStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBDirectSelectAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDirectSelectAvailable" , 22);
        yajl_gen_bool(g, (bool)value.getBDirectSelectAvailable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DirectSelectAvailableStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDAngleInfoStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDAngleInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8CurrentAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CurrentAngle" , 14);
        const char* s = ::MPlay_fi_types::T_e8_MAngle_Name(value.getE8CurrentAngle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CurrentAngle());
    }
    if (!isSparse || value.hasE8TotalAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TotalAngle" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MAngle_Name(value.getE8TotalAngle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TotalAngle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDAngleInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDSubtitleInfoStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDSubtitleInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSubtitleState()) {
        yajl_gen_string(g, (const unsigned char*)  "subtitleState" , 13);
        yajl_gen_bool(g, (bool)value.getSubtitleState());
    }
    if (!isSparse || value.hasU8CurrentSubtitle()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CurrentSubtitle" , 17);
        yajl_gen_integer(g, (long long)value.getU8CurrentSubtitle());
    }
    if (!isSparse || value.hasU8TotalSubtitle()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TotalSubtitle" , 15);
        yajl_gen_integer(g, (long long)value.getU8TotalSubtitle());
    }
    if (!isSparse || value.hasU16SubtitleLang()) {
        yajl_gen_string(g, (const unsigned char*)  "u16SubtitleLang" , 15);
        yajl_gen_integer(g, (long long)value.getU16SubtitleLang());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDSubtitleInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDAudioChannelInfoStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDAudioChannelInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8totalChannels()) {
        yajl_gen_string(g, (const unsigned char*)  "e8totalChannels" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MTotalChannel_Name(value.getE8totalChannels());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8totalChannels());
    }
    if (!isSparse || value.hasBSubWooferAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bSubWooferAvailable" , 19);
        yajl_gen_bool(g, (bool)value.getBSubWooferAvailable());
    }
    if (!isSparse || value.hasE8CurrentAssignment()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CurrentAssignment" , 19);
        const char* s = ::MPlay_fi_types::T_e8_MChannelAssignment_Name(value.getE8CurrentAssignment());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CurrentAssignment());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDAudioChannelInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDCurrentAudioInfoStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDCurrentAudioInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SoundFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SoundFormat" , 13);
        const char* s = ::MPlay_fi_types::T_e8_MSoundFormat_Name(value.getE8SoundFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SoundFormat());
    }
    if (!isSparse || value.hasE8VCDAudioOutput()) {
        yajl_gen_string(g, (const unsigned char*)  "e8VCDAudioOutput" , 16);
        const char* s = ::MPlay_fi_types::T_e8_MVCDAudioMode_Name(value.getE8VCDAudioOutput());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8VCDAudioOutput());
    }
    if (!isSparse || value.hasE8DVDAudioChannel()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DVDAudioChannel" , 17);
        const char* s = ::MPlay_fi_types::T_e8_MAudioOutputNumber_Name(value.getE8DVDAudioChannel());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DVDAudioChannel());
    }
    if (!isSparse || value.hasE8DVDTotalAudio()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DVDTotalAudio" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MAudioOutputNumber_Name(value.getE8DVDTotalAudio());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DVDTotalAudio());
    }
    if (!isSparse || value.hasU16DVDAudioLang()) {
        yajl_gen_string(g, (const unsigned char*)  "u16DVDAudioLang" , 15);
        yajl_gen_integer(g, (long long)value.getU16DVDAudioLang());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDCurrentAudioInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisplayModeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DisplayModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DisplayMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DisplayMode" , 13);
        const char* s = ::MPlay_fi_types::T_e8_MDisplayMode_Name(value.getE8DisplayMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DisplayMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DisplayModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisplayModeSet"

void serializeJson (const ::mplay_MediaPlayer_FI::DisplayModeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DisplayMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DisplayMode" , 13);
        const char* s = ::MPlay_fi_types::T_e8_MDisplayMode_Name(value.getE8DisplayMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DisplayMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DisplayModeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDPlayerLangSettingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDPlayerLangSettingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLangSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "langSetting" , 11);
        serializeJson(value.getLangSetting(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDPlayerLangSettingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDPlayerLangSettingSet"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDPlayerLangSettingSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLangSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "langSetting" , 11);
        serializeJson(value.getLangSetting(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDPlayerLangSettingSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AngleMarkSettingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::AngleMarkSettingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBAngleMark()) {
        yajl_gen_string(g, (const unsigned char*)  "bAngleMark" , 10);
        yajl_gen_bool(g, (bool)value.getBAngleMark());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::AngleMarkSettingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AngleMarkSettingSet"

void serializeJson (const ::mplay_MediaPlayer_FI::AngleMarkSettingSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBAngleMark()) {
        yajl_gen_string(g, (const unsigned char*)  "bAngleMark" , 10);
        yajl_gen_bool(g, (bool)value.getBAngleMark());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::AngleMarkSettingSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlayStatusSettingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::PlayStatusSettingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBPlayStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "bPlayStatus" , 11);
        yajl_gen_bool(g, (bool)value.getBPlayStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlayStatusSettingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlayStatusSettingSet"

void serializeJson (const ::mplay_MediaPlayer_FI::PlayStatusSettingSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBPlayStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "bPlayStatus" , 11);
        yajl_gen_bool(g, (bool)value.getBPlayStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlayStatusSettingSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DRCSettingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DRCSettingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DRCSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DRCSetting" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MDRCSetting_Name(value.getE8DRCSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DRCSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DRCSettingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DRCSettingSet"

void serializeJson (const ::mplay_MediaPlayer_FI::DRCSettingSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DRCSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DRCSetting" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MDRCSetting_Name(value.getE8DRCSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DRCSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DRCSettingSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDCommandStatusStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDCommandStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8CommandStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CommandStatus" , 15);
        const char* s = ::MPlay_fi_types::T_e8_DVDCommandStatus_Name(value.getE8CommandStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CommandStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDCommandStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AutoRippingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::AutoRippingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBAutoRipping()) {
        yajl_gen_string(g, (const unsigned char*)  "bAutoRipping" , 12);
        yajl_gen_bool(g, (bool)value.getBAutoRipping());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::AutoRippingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AutoRippingSet"

void serializeJson (const ::mplay_MediaPlayer_FI::AutoRippingSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBAutoRipping()) {
        yajl_gen_string(g, (const unsigned char*)  "bAutoRipping" , 12);
        yajl_gen_bool(g, (bool)value.getBAutoRipping());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::AutoRippingSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GracenoteLookupModeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::GracenoteLookupModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBLookupMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bLookupMode" , 11);
        yajl_gen_bool(g, (bool)value.getBLookupMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GracenoteLookupModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GracenoteLookupModeSet"

void serializeJson (const ::mplay_MediaPlayer_FI::GracenoteLookupModeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBLookupMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bLookupMode" , 11);
        yajl_gen_bool(g, (bool)value.getBLookupMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GracenoteLookupModeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GracenoteVersionStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::GracenoteVersionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "sVersion" , 8);
        const char *s = value.getSVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GracenoteVersionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RippingErrorsStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::RippingErrorsStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasORippingErrors()) {
        yajl_gen_string(g, (const unsigned char*)  "oRippingErrors" , 14);
        const char* s = ::MPlay_fi_types::T_MPlayRippingErrors_Name(value.getORippingErrors());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getORippingErrors());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RippingErrorsStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResolveGracenoteAmbuiguitiesStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::ResolveGracenoteAmbuiguitiesStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSTOC()) {
        yajl_gen_string(g, (const unsigned char*)  "sTOC" , 4);
        const char *s = value.getSTOC().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOAlbums()) {
        yajl_gen_string(g, (const unsigned char*)  "oAlbums" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o7 = value.getOAlbums();
        {
            ::std::vector< ::std::string >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                const char *s = (*o6).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ResolveGracenoteAmbuiguitiesStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDMenuPlaybackOngoingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDMenuPlaybackOngoingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBDVDMenuPlaybackOngoing()) {
        yajl_gen_string(g, (const unsigned char*)  "bDVDMenuPlaybackOngoing" , 23);
        yajl_gen_bool(g, (bool)value.getBDVDMenuPlaybackOngoing());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDMenuPlaybackOngoingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DVDDriveInfoStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DVDDriveInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DVDDiscType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DVDDiscType" , 13);
        const char* s = ::MPlay_fi_types::T_e8_MDVDDiscType_Name(value.getE8DVDDiscType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DVDDiscType());
    }
    if (!isSparse || value.hasE8DVDDriveMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DVDDriveMode" , 14);
        const char* s = ::MPlay_fi_types::T_e8_MDVDDriveMode_Name(value.getE8DVDDriveMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DVDDriveMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DVDDriveInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RippingStateStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::RippingStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasORippingStateResult()) {
        yajl_gen_string(g, (const unsigned char*)  "oRippingStateResult" , 19);
        serializeJson(value.getORippingStateResult(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RippingStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RippingEncodingQualityStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::RippingEncodingQualityStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8EncodingQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "e8EncodingQuality" , 17);
        const char* s = ::MPlay_fi_types::T_e8_MPlayEncodingQuality_Name(value.getE8EncodingQuality());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8EncodingQuality());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RippingEncodingQualityStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RippingEncodingQualitySet"

void serializeJson (const ::mplay_MediaPlayer_FI::RippingEncodingQualitySet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8EncodingQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "e8EncodingQuality" , 17);
        const char* s = ::MPlay_fi_types::T_e8_MPlayEncodingQuality_Name(value.getE8EncodingQuality());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8EncodingQuality());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RippingEncodingQualitySet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GNMetadataExtractionStatusStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::GNMetadataExtractionStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8GNmetadataExtractionResult()) {
        yajl_gen_string(g, (const unsigned char*)  "e8GNmetadataExtractionResult" , 28);
        const char* s = ::MPlay_fi_types::T_e8_MPlayGNmetadataExtractionResult_Name(value.getE8GNmetadataExtractionResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8GNmetadataExtractionResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GNMetadataExtractionStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LanguageStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::LanguageStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Language()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Language" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayLanguage_Name(value.getE8Language());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Language());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::LanguageStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LanguageSet"

void serializeJson (const ::mplay_MediaPlayer_FI::LanguageSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Language()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Language" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayLanguage_Name(value.getE8Language());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Language());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::LanguageSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlaybackRepeatModeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackRepeatModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Mode" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayMode_Name(value.getE8Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Mode());
    }
    if (!isSparse || value.hasE8Repeat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Repeat" , 8);
        const char* s = ::MPlay_fi_types::T_e8_MPlayRepeat_Name(value.getE8Repeat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Repeat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackRepeatModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlaybackRepeatModeSet"

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackRepeatModeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Mode" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayMode_Name(value.getE8Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Mode());
    }
    if (!isSparse || value.hasE8Repeat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Repeat" , 8);
        const char* s = ::MPlay_fi_types::T_e8_MPlayRepeat_Name(value.getE8Repeat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Repeat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackRepeatModeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SlideshowTimeStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::SlideshowTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Time()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Time" , 7);
        yajl_gen_integer(g, (long long)value.getU32Time());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SlideshowTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SlideshowTimeSet"

void serializeJson (const ::mplay_MediaPlayer_FI::SlideshowTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Time()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Time" , 7);
        yajl_gen_integer(g, (long long)value.getU32Time());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SlideshowTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NowShowingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::NowShowingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasE8NowPlayingState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8NowPlayingState" , 17);
        const char* s = ::MPlay_fi_types::T_e8_MPlayNowPlayingState_Name(value.getE8NowPlayingState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8NowPlayingState());
    }
    if (!isSparse || value.hasU32Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Position" , 11);
        yajl_gen_integer(g, (long long)value.getU32Position());
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasOMediaObject()) {
        yajl_gen_string(g, (const unsigned char*)  "oMediaObject" , 12);
        serializeJson(value.getOMediaObject(), g, options);
    }
    if (!isSparse || value.hasSNextFile()) {
        yajl_gen_string(g, (const unsigned char*)  "sNextFile" , 9);
        const char *s = value.getSNextFile().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::NowShowingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SlideshowStateStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::SlideshowStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8State" , 7);
        const char* s = ::MPlay_fi_types::T_e8_MPlayState_Name(value.getE8State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SlideshowStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MediaPlayerOpticalDiscSlotStateStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::MediaPlayerOpticalDiscSlotStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8State" , 7);
        const char* s = ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType_Name(value.getE8State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::MediaPlayerOpticalDiscSlotStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MediaPlayerOpticalDiscCDInfoStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::MediaPlayerOpticalDiscCDInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCDInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "CDInfo" , 6);
        serializeJson(value.getCDInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::MediaPlayerOpticalDiscCDInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPodCommunicationErrorStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::IPodCommunicationErrorStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasE8iPodCommunicationError()) {
        yajl_gen_string(g, (const unsigned char*)  "e8iPodCommunicationError" , 24);
        const char* s = ::MPlay_fi_types::T_e8_MPlayiPodCommunicationError_Name(value.getE8iPodCommunicationError());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8iPodCommunicationError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::IPodCommunicationErrorStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceStreamingInfoStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::DeviceStreamingInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8StreamingInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "e8StreamingInfo" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MPlayStreamingInfo_Name(value.getE8StreamingInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8StreamingInfo());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU8DeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceType" , 12);
        yajl_gen_integer(g, (long long)value.getU8DeviceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeviceStreamingInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoBrightnessStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoBrightnessStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8VideoBrightness()) {
        yajl_gen_string(g, (const unsigned char*)  "u8VideoBrightness" , 17);
        yajl_gen_integer(g, (long long)value.getU8VideoBrightness());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoBrightnessStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoBrightnessSet"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoBrightnessSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8VideoBrightness()) {
        yajl_gen_string(g, (const unsigned char*)  "u8VideoBrightness" , 17);
        yajl_gen_integer(g, (long long)value.getU8VideoBrightness());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoBrightnessSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoHueStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoHueStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16VideoHue()) {
        yajl_gen_string(g, (const unsigned char*)  "s16VideoHue" , 11);
        yajl_gen_integer(g, (long long)value.getS16VideoHue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoHueStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoHueSet"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoHueSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16VideoHue()) {
        yajl_gen_string(g, (const unsigned char*)  "s16VideoHue" , 11);
        yajl_gen_integer(g, (long long)value.getS16VideoHue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoHueSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoSaturationStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoSaturationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8VideoSaturation()) {
        yajl_gen_string(g, (const unsigned char*)  "u8VideoSaturation" , 17);
        yajl_gen_integer(g, (long long)value.getU8VideoSaturation());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoSaturationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoSaturationSet"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoSaturationSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8VideoSaturation()) {
        yajl_gen_string(g, (const unsigned char*)  "u8VideoSaturation" , 17);
        yajl_gen_integer(g, (long long)value.getU8VideoSaturation());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoSaturationSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoContrastStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoContrastStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8VideoContrast()) {
        yajl_gen_string(g, (const unsigned char*)  "u8VideoContrast" , 15);
        yajl_gen_integer(g, (long long)value.getU8VideoContrast());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoContrastStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoContrastSet"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoContrastSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8VideoContrast()) {
        yajl_gen_string(g, (const unsigned char*)  "u8VideoContrast" , 15);
        yajl_gen_integer(g, (long long)value.getU8VideoContrast());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoContrastSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoBrightnessOffsetStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoBrightnessOffsetStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16VideoBrightnessOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "s16VideoBrightnessOffset" , 24);
        yajl_gen_integer(g, (long long)value.getS16VideoBrightnessOffset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoBrightnessOffsetStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoBrightnessOffsetSet"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoBrightnessOffsetSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16VideoBrightnessOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "s16VideoBrightnessOffset" , 24);
        yajl_gen_integer(g, (long long)value.getS16VideoBrightnessOffset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoBrightnessOffsetSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoHueOffsetStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoHueOffsetStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16VideoHueOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "s16VideoHueOffset" , 17);
        yajl_gen_integer(g, (long long)value.getS16VideoHueOffset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoHueOffsetStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoHueOffsetSet"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoHueOffsetSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16VideoHueOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "s16VideoHueOffset" , 17);
        yajl_gen_integer(g, (long long)value.getS16VideoHueOffset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoHueOffsetSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoSaturationOffsetStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoSaturationOffsetStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8VideoSaturationOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "u8VideoSaturationOffset" , 23);
        yajl_gen_integer(g, (long long)value.getU8VideoSaturationOffset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoSaturationOffsetStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoSaturationOffsetSet"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoSaturationOffsetSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8VideoSaturationOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "u8VideoSaturationOffset" , 23);
        yajl_gen_integer(g, (long long)value.getU8VideoSaturationOffset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoSaturationOffsetSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoScalingStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoScalingStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEVideoScaling()) {
        yajl_gen_string(g, (const unsigned char*)  "eVideoScaling" , 13);
        const char* s = ::MPlay_fi_types::T_VideoScalingType_Name(value.getEVideoScaling());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEVideoScaling());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoScalingStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoScalingSet"

void serializeJson (const ::mplay_MediaPlayer_FI::VideoScalingSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEVideoScaling()) {
        yajl_gen_string(g, (const unsigned char*)  "eVideoScaling" , 13);
        const char* s = ::MPlay_fi_types::T_VideoScalingType_Name(value.getEVideoScaling());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEVideoScaling());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::VideoScalingSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdatePlaybackSpeedStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::UpdatePlaybackSpeedStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8PlaybackSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlaybackSpeed" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MPlaybackSpeed_Name(value.getE8PlaybackSpeed());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlaybackSpeed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::UpdatePlaybackSpeedStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserFavoritesChangedStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::UserFavoritesChangedStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListChangeType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListChangeType" , 16);
        const char* s = ::MPlay_fi_types::T_e8_MPlayChange_Name(value.getE8ListChangeType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListChangeType());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU32NumItems()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumItems" , 11);
        yajl_gen_integer(g, (long long)value.getU32NumItems());
    }
    if (!isSparse || value.hasOChangedFavorites()) {
        yajl_gen_string(g, (const unsigned char*)  "oChangedFavorites" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< uint64 >& o9 = value.getOChangedFavorites();
        {
            ::std::vector< uint64 >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                char buffer[21];
                ::asf::stream::json::ulltoa ((uint64_t)(*o8), buffer);
                yajl_gen_number(g, buffer, strlen (buffer));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::UserFavoritesChangedStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FolderBrowseStructureClearedStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::FolderBrowseStructureClearedStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::FolderBrowseStructureClearedStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadyToPlayStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::ReadyToPlayStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSDeviceSerialNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceSerialNumber" , 19);
        const char *s = value.getSDeviceSerialNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBPlayingStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "bPlayingStatus" , 14);
        yajl_gen_bool(g, (bool)value.getBPlayingStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ReadyToPlayStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BluetoothAudioDeviceStatusStatus"

void serializeJson (const ::mplay_MediaPlayer_FI::BluetoothAudioDeviceStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBAudioDeviceStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "bAudioDeviceStatus" , 18);
        yajl_gen_bool(g, (bool)value.getBAudioDeviceStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::BluetoothAudioDeviceStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerQuickPlayListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayListType_Name(value.getE8ListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListType());
    }
    if (!isSparse || value.hasU32FilterTag1()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag1" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag1());
    }
    if (!isSparse || value.hasU32FilterTag2()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag2" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag2());
    }
    if (!isSparse || value.hasU32FilterTag3()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag3" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag3());
    }
    if (!isSparse || value.hasU32FilterTag4()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag4" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag4());
    }
    if (!isSparse || value.hasBAutoPlay()) {
        yajl_gen_string(g, (const unsigned char*)  "bAutoPlay" , 9);
        yajl_gen_bool(g, (bool)value.getBAutoPlay());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerQuickPlayListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerIndexedListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayListType_Name(value.getE8ListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListType());
    }
    if (!isSparse || value.hasU32FilterTag1()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag1" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag1());
    }
    if (!isSparse || value.hasU32FilterTag2()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag2" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag2());
    }
    if (!isSparse || value.hasU32FilterTag3()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag3" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag3());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU8UserID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UserID" , 8);
        yajl_gen_integer(g, (long long)value.getU8UserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerIndexedListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerIndexedListSliceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32WindowStart()) {
        yajl_gen_string(g, (const unsigned char*)  "u32WindowStart" , 14);
        yajl_gen_integer(g, (long long)value.getU32WindowStart());
    }
    if (!isSparse || value.hasU16WindowSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u16WindowSize" , 13);
        yajl_gen_integer(g, (long long)value.getU16WindowSize());
    }
    if (!isSparse || value.hasDeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceTag" , 9);
        yajl_gen_integer(g, (long long)value.getDeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerIndexedListSliceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOMediaObjects()) {
        yajl_gen_string(g, (const unsigned char*)  "oMediaObjects" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayMediaObjectsItem >& o11 = value.getOMediaObjects();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayMediaObjectsItem >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReleaseMediaPlayerListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::ReleaseMediaPlayerListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ReleaseMediaPlayerListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestPlaybackActionStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestPlaybackActionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Action()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Action" , 8);
        const char* s = ::MPlay_fi_types::T_e8_MPlayAction_Name(value.getE8Action());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Action());
    }
    if (!isSparse || value.hasU8NextPrevSkipCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NextPrevSkipCount" , 19);
        yajl_gen_integer(g, (long long)value.getU8NextPrevSkipCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestPlaybackActionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SeekToStart"

void serializeJson (const ::mplay_MediaPlayer_FI::SeekToStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32PlaypointPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PlaypointPosition" , 20);
        yajl_gen_integer(g, (long long)value.getU32PlaypointPosition());
    }
    if (!isSparse || value.hasE8PlaypointFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlaypointFormat" , 17);
        const char* s = ::MPlay_fi_types::T_e8_MPlayPlaypointFormat_Name(value.getE8PlaypointFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlaypointFormat());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SeekToStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetMediaObjectAlbumArtStart"

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSAlbumArt()) {
        yajl_gen_string(g, (const unsigned char*)  "sAlbumArt" , 9);
        const char *s = value.getSAlbumArt().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32SizeX()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SizeX" , 8);
        yajl_gen_integer(g, (long long)value.getU32SizeX());
    }
    if (!isSparse || value.hasU32SizeY()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SizeY" , 8);
        yajl_gen_integer(g, (long long)value.getU32SizeY());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetMediaObjectAlbumArtResult"

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOImageData()) {
        yajl_gen_string(g, (const unsigned char*)  "oImageData" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o13 = value.getOImageData();
        {
            ::std::vector< uint8 >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                yajl_gen_integer(g, (long long)(*o12));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SearchKeyboardMediaPlayerListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::SearchKeyboardMediaPlayerListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SearchKeyboardMediaPlayerListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SearchKeyboardMediaPlayerListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::SearchKeyboardMediaPlayerListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasOSearchKeyboardList()) {
        yajl_gen_string(g, (const unsigned char*)  "oSearchKeyboardList" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlaySearchKeyboardListItem >& o15 = value.getOSearchKeyboardList();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlaySearchKeyboardListItem >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SearchKeyboardMediaPlayerListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerListSearchStringStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandleOfParent()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandleOfParent" , 21);
        yajl_gen_integer(g, (long long)value.getU32ListHandleOfParent());
    }
    if (!isSparse || value.hasU32ListHandleOfReplaceableList()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandleOfReplaceableList" , 30);
        yajl_gen_integer(g, (long long)value.getU32ListHandleOfReplaceableList());
    }
    if (!isSparse || value.hasSSearchString()) {
        yajl_gen_string(g, (const unsigned char*)  "sSearchString" , 13);
        const char *s = value.getSSearchString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerListSearchStringAbort"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringAbort& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringAbort& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerListSearchStringResultFirst"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultFirst& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultFirst& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerListSearchStringResultMiddle"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultMiddle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultMiddle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerListSearchStringResultLast"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultLast& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultLast& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetMediaObjectStart"

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasE8CategoryType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CategoryType" , 14);
        const char* s = ::MPlay_fi_types::T_e8_MPlayCategoryType_Name(value.getE8CategoryType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CategoryType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetMediaObjectResult"

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOMediaObject()) {
        yajl_gen_string(g, (const unsigned char*)  "oMediaObject" , 12);
        serializeJson(value.getOMediaObject(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerFileListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPath" , 5);
        const char *s = value.getSPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasE8MPlayFileTypeSelection()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MPlayFileTypeSelection" , 24);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileTypeSelection_Name(value.getE8MPlayFileTypeSelection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MPlayFileTypeSelection());
    }
    if (!isSparse || value.hasTag()) {
        yajl_gen_string(g, (const unsigned char*)  "Tag" , 3);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTag(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerFileListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU32TotalNumFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumFiles" , 16);
        yajl_gen_integer(g, (long long)value.getU32TotalNumFiles());
    }
    if (!isSparse || value.hasU32TotalNumFolders()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumFolders" , 18);
        yajl_gen_integer(g, (long long)value.getU32TotalNumFolders());
    }
    if (!isSparse || value.hasU32TotalNumMediaObjects()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumMediaObjects" , 23);
        yajl_gen_integer(g, (long long)value.getU32TotalNumMediaObjects());
    }
    if (!isSparse || value.hasU32TotalNumPlaylists()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumPlaylists" , 20);
        yajl_gen_integer(g, (long long)value.getU32TotalNumPlaylists());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerFileListSliceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32WindowStart()) {
        yajl_gen_string(g, (const unsigned char*)  "u32WindowStart" , 14);
        yajl_gen_integer(g, (long long)value.getU32WindowStart());
    }
    if (!isSparse || value.hasU16WindowSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u16WindowSize" , 13);
        yajl_gen_integer(g, (long long)value.getU16WindowSize());
    }
    if (!isSparse || value.hasDeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceTag" , 9);
        yajl_gen_integer(g, (long long)value.getDeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerFileListSliceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOFileList()) {
        yajl_gen_string(g, (const unsigned char*)  "oFileList" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayFileListItem >& o17 = value.getOFileList();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayFileListItem >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerPlaylistListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "sFilename" , 9);
        const char *s = value.getSFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTag()) {
        yajl_gen_string(g, (const unsigned char*)  "Tag" , 3);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTag(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasDeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceTag" , 9);
        yajl_gen_integer(g, (long long)value.getDeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerPlaylistListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerPlaylistListSliceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerPlaylistListSliceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32WindowStart()) {
        yajl_gen_string(g, (const unsigned char*)  "u32WindowStart" , 14);
        yajl_gen_integer(g, (long long)value.getU32WindowStart());
    }
    if (!isSparse || value.hasU16WindowSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u16WindowSize" , 13);
        yajl_gen_integer(g, (long long)value.getU16WindowSize());
    }
    if (!isSparse || value.hasDeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceTag" , 9);
        yajl_gen_integer(g, (long long)value.getDeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerPlaylistListSliceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerPlaylistListSliceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerPlaylistListSliceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOFileList()) {
        yajl_gen_string(g, (const unsigned char*)  "oFileList" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayFileListItem >& o19 = value.getOFileList();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayFileListItem >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                serializeJson((*o18), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerPlaylistListSliceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerQuickPlayListSliceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerQuickPlayListSliceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32WindowStart()) {
        yajl_gen_string(g, (const unsigned char*)  "u32WindowStart" , 14);
        yajl_gen_integer(g, (long long)value.getU32WindowStart());
    }
    if (!isSparse || value.hasU16WindowSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u16WindowSize" , 13);
        yajl_gen_integer(g, (long long)value.getU16WindowSize());
    }
    if (!isSparse || value.hasDeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceTag" , 9);
        yajl_gen_integer(g, (long long)value.getDeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerQuickPlayListSliceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerQuickPlayListSliceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerQuickPlayListSliceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOMediaObjects()) {
        yajl_gen_string(g, (const unsigned char*)  "oMediaObjects" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayMediaObjectsItem >& o21 = value.getOMediaObjects();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayMediaObjectsItem >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                serializeJson((*o20), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerQuickPlayListSliceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetMediaObjectAlbumArtInfoStart"

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSAlbumArt()) {
        yajl_gen_string(g, (const unsigned char*)  "sAlbumArt" , 9);
        const char *s = value.getSAlbumArt().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32SizeX()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SizeX" , 8);
        yajl_gen_integer(g, (long long)value.getU32SizeX());
    }
    if (!isSparse || value.hasU32SizeY()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SizeY" , 8);
        yajl_gen_integer(g, (long long)value.getU32SizeY());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetMediaObjectAlbumArtInfoResult"

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSMIMEImageSubtype()) {
        yajl_gen_string(g, (const unsigned char*)  "sMIMEImageSubtype" , 17);
        const char *s = value.getSMIMEImageSubtype().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32PhotoSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PhotoSize" , 12);
        yajl_gen_integer(g, (long long)value.getU32PhotoSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlayMediaPlayerObjectStart"

void serializeJson (const ::mplay_MediaPlayer_FI::PlayMediaPlayerObjectStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasBAutoPlay()) {
        yajl_gen_string(g, (const unsigned char*)  "bAutoPlay" , 9);
        yajl_gen_bool(g, (bool)value.getBAutoPlay());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlayMediaPlayerObjectStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlayMediaPlayerObjectResult"

void serializeJson (const ::mplay_MediaPlayer_FI::PlayMediaPlayerObjectResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlayMediaPlayerObjectResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlayItemFromListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::PlayItemFromListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32StartIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "u32StartIndex" , 13);
        yajl_gen_integer(g, (long long)value.getU32StartIndex());
    }
    if (!isSparse || value.hasU32StartOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "u32StartOffset" , 14);
        yajl_gen_integer(g, (long long)value.getU32StartOffset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlayItemFromListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlayItemFromListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::PlayItemFromListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlayItemFromListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UmountStart"

void serializeJson (const ::mplay_MediaPlayer_FI::UmountStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::UmountStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UmountResult"

void serializeJson (const ::mplay_MediaPlayer_FI::UmountResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasE8UmountResult()) {
        yajl_gen_string(g, (const unsigned char*)  "e8UmountResult" , 14);
        const char* s = ::MPlay_fi_types::T_e8_MPlayUmountResult_Name(value.getE8UmountResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8UmountResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::UmountResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReindexingStart"

void serializeJson (const ::mplay_MediaPlayer_FI::ReindexingStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ReindexingStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagnosisPlaySongStart"

void serializeJson (const ::mplay_MediaPlayer_FI::DiagnosisPlaySongStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceType" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceType_Name(value.getE8DeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceType());
    }
    if (!isSparse || value.hasSFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "sFilename" , 9);
        const char *s = value.getSFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DiagnosisPlaySongStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestListDetailsStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestListDetailsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestListDetailsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestListDetailsResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestListDetailsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayListType_Name(value.getE8ListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListType());
    }
    if (!isSparse || value.hasU32ParentListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ParentListHandle" , 19);
        yajl_gen_integer(g, (long long)value.getU32ParentListHandle());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU32Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Position" , 11);
        yajl_gen_integer(g, (long long)value.getU32Position());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestListDetailsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestListInformationStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestListInformationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestListInformationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestListInformationResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestListInformationResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayListType_Name(value.getE8ListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListType());
    }
    if (!isSparse || value.hasU32ParentListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ParentListHandle" , 19);
        yajl_gen_integer(g, (long long)value.getU32ParentListHandle());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU32Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Position" , 11);
        yajl_gen_integer(g, (long long)value.getU32Position());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasSPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPath" , 5);
        const char *s = value.getSPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestListInformationResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TransferTagsToDeviceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::TransferTagsToDeviceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasOTagTransfer()) {
        yajl_gen_string(g, (const unsigned char*)  "oTagTransfer" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayTagTransferItem_2 >& o23 = value.getOTagTransfer();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayTagTransferItem_2 >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                serializeJson((*o22), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::TransferTagsToDeviceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TransferTagsToDeviceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::TransferTagsToDeviceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasE8TagTransferStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TagTransferStatus" , 19);
        const char* s = ::MPlay_fi_types::T_e8_MPlayTagTransferStatus_Name(value.getE8TagTransferStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TagTransferStatus());
    }
    if (!isSparse || value.hasOUntransferredTagStream()) {
        yajl_gen_string(g, (const unsigned char*)  "oUntransferredTagStream" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayUntransferredTagStreamItem >& o25 = value.getOUntransferredTagStream();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayUntransferredTagStreamItem >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                serializeJson((*o24), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::TransferTagsToDeviceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlayItemFromListByTagStart"

void serializeJson (const ::mplay_MediaPlayer_FI::PlayItemFromListByTagStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlayItemFromListByTagStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlaybackSpeedSetStart"

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackSpeedSetStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8PlaybackDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlaybackDirection" , 19);
        const char* s = ::MPlay_fi_types::T_e8_MPlaybackDirection_Name(value.getE8PlaybackDirection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlaybackDirection());
    }
    if (!isSparse || value.hasE8PlaybackSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlaybackSpeed" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MPlaybackSpeed_Name(value.getE8PlaybackSpeed());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlaybackSpeed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackSpeedSetStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PlaybackSpeedSetResult"

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackSpeedSetResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8PlaybackDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlaybackDirection" , 19);
        const char* s = ::MPlay_fi_types::T_e8_MPlaybackDirection_Name(value.getE8PlaybackDirection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlaybackDirection());
    }
    if (!isSparse || value.hasE8PlaybackSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlaybackSpeed" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MPlaybackSpeed_Name(value.getE8PlaybackSpeed());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlaybackSpeed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::PlaybackSpeedSetResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearLastModePauseStart"

void serializeJson (const ::mplay_MediaPlayer_FI::ClearLastModePauseStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ClearLastModePauseStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDiscOperationStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestDiscOperationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DiscOperation()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DiscOperation" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MDiscOperation_Name(value.getE8DiscOperation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DiscOperation());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestDiscOperationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestVCDAudioChannelStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestVCDAudioChannelStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SelectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SelectionType" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MGeneralSelectionType_Name(value.getE8SelectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SelectionType());
    }
    if (!isSparse || value.hasE8AudioMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AudioMode" , 11);
        const char* s = ::MPlay_fi_types::T_e8_MVCDAudioMode_Name(value.getE8AudioMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AudioMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestVCDAudioChannelStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDVDAudioChannelStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestDVDAudioChannelStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SelectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SelectionType" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MGeneralSelectionType_Name(value.getE8SelectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SelectionType());
    }
    if (!isSparse || value.hasE8AudioNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AudioNumber" , 13);
        const char* s = ::MPlay_fi_types::T_e8_MAudioOutputNumber_Name(value.getE8AudioNumber());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AudioNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestDVDAudioChannelStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendNavigationKeyStart"

void serializeJson (const ::mplay_MediaPlayer_FI::SendNavigationKeyStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Action()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Action" , 8);
        const char* s = ::MPlay_fi_types::T_e8_MNavigationKey_Name(value.getE8Action());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Action());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SendNavigationKeyStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendTouchCommandStart"

void serializeJson (const ::mplay_MediaPlayer_FI::SendTouchCommandStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8TouchAction()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TouchAction" , 13);
        const char* s = ::MPlay_fi_types::T_e8_MTouchAction_Name(value.getE8TouchAction());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TouchAction());
    }
    if (!isSparse || value.hasU16Xcoordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Xcoordinate" , 14);
        yajl_gen_integer(g, (long long)value.getU16Xcoordinate());
    }
    if (!isSparse || value.hasU16Ycoordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Ycoordinate" , 14);
        yajl_gen_integer(g, (long long)value.getU16Ycoordinate());
    }
    if (!isSparse || value.hasU16MaxXcoordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "u16MaxXcoordinate" , 17);
        yajl_gen_integer(g, (long long)value.getU16MaxXcoordinate());
    }
    if (!isSparse || value.hasU16MaxYcoordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "u16MaxYcoordinate" , 17);
        yajl_gen_integer(g, (long long)value.getU16MaxYcoordinate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SendTouchCommandStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDirectSearchStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestDirectSearchStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTitleNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "TitleNumber" , 11);
        yajl_gen_integer(g, (long long)value.getTitleNumber());
    }
    if (!isSparse || value.hasChapterNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "ChapterNumber" , 13);
        yajl_gen_integer(g, (long long)value.getChapterNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestDirectSearchStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestAngleChangeStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestAngleChangeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SelectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SelectionType" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MGeneralSelectionType_Name(value.getE8SelectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SelectionType());
    }
    if (!isSparse || value.hasE8Angle()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Angle" , 7);
        const char* s = ::MPlay_fi_types::T_e8_MAngle_Name(value.getE8Angle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Angle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestAngleChangeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMenuPlayBackControlStart"

void serializeJson (const ::mplay_MediaPlayer_FI::SetMenuPlayBackControlStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8MenuControlData()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MenuControlData" , 17);
        const char* s = ::MPlay_fi_types::T_e8_MMenuControlData_Name(value.getE8MenuControlData());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MenuControlData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SetMenuPlayBackControlStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectDirectNumberStart"

void serializeJson (const ::mplay_MediaPlayer_FI::SelectDirectNumberStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Number" , 9);
        yajl_gen_integer(g, (long long)value.getU32Number());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SelectDirectNumberStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestTitleSearchStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestTitleSearchStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32SearchNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SearchNumber" , 15);
        yajl_gen_integer(g, (long long)value.getU32SearchNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestTitleSearchStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestSubtitleChangeStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestSubtitleChangeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSubtitleSwitchState()) {
        yajl_gen_string(g, (const unsigned char*)  "subtitleSwitchState" , 19);
        yajl_gen_bool(g, (bool)value.getSubtitleSwitchState());
    }
    if (!isSparse || value.hasE8SelectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SelectionType" , 15);
        const char* s = ::MPlay_fi_types::T_e8_MSubtitleSelectionType_Name(value.getE8SelectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SelectionType());
    }
    if (!isSparse || value.hasU8SubtitleSelection()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SubtitleSelection" , 19);
        yajl_gen_integer(g, (long long)value.getU8SubtitleSelection());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestSubtitleChangeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestCMSkipStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestCMSkipStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8CMSkipValue()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CMSkipValue" , 13);
        const char* s = ::MPlay_fi_types::T_e8_MCMSkipValue_Name(value.getE8CMSkipValue());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CMSkipValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestCMSkipStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDVDTemperatureResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestDVDTemperatureResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16Temperature()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Temperature" , 14);
        yajl_gen_integer(g, (long long)value.getU16Temperature());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestDVDTemperatureResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReorderInternalPlaylistStart"

void serializeJson (const ::mplay_MediaPlayer_FI::ReorderInternalPlaylistStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPlaylistPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPlaylistPath" , 13);
        const char *s = value.getSPlaylistPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32OldPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "u32OldPosition" , 14);
        yajl_gen_integer(g, (long long)value.getU32OldPosition());
    }
    if (!isSparse || value.hasU32NewPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NewPosition" , 14);
        yajl_gen_integer(g, (long long)value.getU32NewPosition());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ReorderInternalPlaylistStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReorderInternalPlaylistResult"

void serializeJson (const ::mplay_MediaPlayer_FI::ReorderInternalPlaylistResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayInternalPlaylistTaskResult_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ReorderInternalPlaylistResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteMediaContentByFilterTagsStart"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByFilterTagsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayListType_Name(value.getE8ListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListType());
    }
    if (!isSparse || value.hasU32FilterTag1()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag1" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag1());
    }
    if (!isSparse || value.hasU32FilterTag2()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag2" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag2());
    }
    if (!isSparse || value.hasU32FilterTag3()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag3" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag3());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByFilterTagsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteMediaContentByFilterTagsResult"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByFilterTagsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32NumberOfFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumberOfFiles" , 16);
        yajl_gen_integer(g, (long long)value.getU32NumberOfFiles());
    }
    if (!isSparse || value.hasU32Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Status" , 9);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeleteMediaContentTaskResult_Name(value.getU32Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU32Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByFilterTagsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteMediaContentByMediaObjectTagsStart"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByMediaObjectTagsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOMediaObjectTags()) {
        yajl_gen_string(g, (const unsigned char*)  "oMediaObjectTags" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o27 = value.getOMediaObjectTags();
        {
            ::std::vector< uint32 >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                yajl_gen_integer(g, (long long)(*o26));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByMediaObjectTagsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteMediaContentByMediaObjectTagsResult"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByMediaObjectTagsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32NumberOfFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumberOfFiles" , 16);
        yajl_gen_integer(g, (long long)value.getU32NumberOfFiles());
    }
    if (!isSparse || value.hasU32Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Status" , 9);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeleteMediaContentTaskResult_Name(value.getU32Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU32Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByMediaObjectTagsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteMediaContentByUrlsStart"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByUrlsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOMPlayMediaObjectUrls()) {
        yajl_gen_string(g, (const unsigned char*)  "oMPlayMediaObjectUrls" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o29 = value.getOMPlayMediaObjectUrls();
        {
            ::std::vector< ::std::string >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                const char *s = (*o28).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByUrlsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteMediaContentByUrlsResult"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByUrlsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32NumberOfFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumberOfFiles" , 16);
        yajl_gen_integer(g, (long long)value.getU32NumberOfFiles());
    }
    if (!isSparse || value.hasU32Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Status" , 9);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeleteMediaContentTaskResult_Name(value.getU32Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU32Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteMediaContentByUrlsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EditMetaDataByMediaObjectTagStart"

void serializeJson (const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectTagStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasSTagGenre()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagGenre" , 9);
        const char *s = value.getSTagGenre().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagAlbum" , 9);
        const char *s = value.getSTagAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagArtist()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagArtist" , 10);
        const char *s = value.getSTagArtist().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagTitle" , 9);
        const char *s = value.getSTagTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagComposer()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagComposer" , 12);
        const char *s = value.getSTagComposer().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16TagYear()) {
        yajl_gen_string(g, (const unsigned char*)  "u16TagYear" , 10);
        yajl_gen_integer(g, (long long)value.getU16TagYear());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasSTagYomiTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagYomiTitle" , 13);
        const char *s = value.getSTagYomiTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagYomiArtist()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagYomiArtist" , 14);
        const char *s = value.getSTagYomiArtist().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagYomiAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagYomiAlbum" , 13);
        const char *s = value.getSTagYomiAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectTagStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EditMetaDataByMediaObjectTagResult"

void serializeJson (const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectTagResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Status" , 9);
        const char* s = ::MPlay_fi_types::T_e8_MPlayEditMetaDataTaskResult_Name(value.getU32Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU32Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectTagResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EditMetaDataByMediaObjectUrlStart"

void serializeJson (const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectUrlStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSMediaObjectUrl()) {
        yajl_gen_string(g, (const unsigned char*)  "sMediaObjectUrl" , 15);
        const char *s = value.getSMediaObjectUrl().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagGenre()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagGenre" , 9);
        const char *s = value.getSTagGenre().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagAlbum" , 9);
        const char *s = value.getSTagAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagArtist()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagArtist" , 10);
        const char *s = value.getSTagArtist().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagTitle" , 9);
        const char *s = value.getSTagTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagComposer()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagComposer" , 12);
        const char *s = value.getSTagComposer().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16TagYear()) {
        yajl_gen_string(g, (const unsigned char*)  "u16TagYear" , 10);
        yajl_gen_integer(g, (long long)value.getU16TagYear());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasSTagYomiTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagYomiTitle" , 13);
        const char *s = value.getSTagYomiTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagYomiArtist()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagYomiArtist" , 14);
        const char *s = value.getSTagYomiArtist().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagYomiAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagYomiAlbum" , 13);
        const char *s = value.getSTagYomiAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectUrlStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EditMetaDataByMediaObjectUrlResult"

void serializeJson (const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectUrlResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Status" , 9);
        const char* s = ::MPlay_fi_types::T_e8_MPlayEditMetaDataTaskResult_Name(value.getU32Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU32Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectUrlResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ExtractGracenoteMetadataStart"

void serializeJson (const ::mplay_MediaPlayer_FI::ExtractGracenoteMetadataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSAlbumTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sAlbumTitle" , 11);
        const char *s = value.getSAlbumTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBMultipleAlbumSelection()) {
        yajl_gen_string(g, (const unsigned char*)  "bMultipleAlbumSelection" , 23);
        yajl_gen_bool(g, (bool)value.getBMultipleAlbumSelection());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::ExtractGracenoteMetadataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateInternalFileNamePlaylistStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateInternalFileNamePlaylistStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSName()) {
        yajl_gen_string(g, (const unsigned char*)  "sName" , 5);
        const char *s = value.getSName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateInternalFileNamePlaylistStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateInternalFileNamePlaylistResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateInternalFileNamePlaylistResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPlaylistPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPlaylistPath" , 13);
        const char *s = value.getSPlaylistPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayInternalPlaylistTaskResult_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateInternalFileNamePlaylistResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddFilenameToInternalPlaylistStart"

void serializeJson (const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPlaylistPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPlaylistPath" , 13);
        const char *s = value.getSPlaylistPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasOMPlayMediaObjectUrls()) {
        yajl_gen_string(g, (const unsigned char*)  "oMPlayMediaObjectUrls" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o31 = value.getOMPlayMediaObjectUrls();
        {
            ::std::vector< ::std::string >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                const char *s = (*o30).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasOMPlayPlayListPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "oMPlayPlayListPosition" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o33 = value.getOMPlayPlayListPosition();
        {
            ::std::vector< uint32 >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                yajl_gen_integer(g, (long long)(*o32));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddFilenameToInternalPlaylistResult"

void serializeJson (const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayInternalPlaylistTaskResult_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteEntryFromPlaylistStart"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteEntryFromPlaylistStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPlaylistPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPlaylistPath" , 13);
        const char *s = value.getSPlaylistPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasOMPlayPlayListPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "oMPlayPlayListPosition" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o35 = value.getOMPlayPlayListPosition();
        {
            ::std::vector< uint32 >::const_iterator o34;
            for (o34 = o35.begin(); o34 != o35.end(); ++o34) {
                yajl_gen_integer(g, (long long)(*o34));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteEntryFromPlaylistStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteEntryFromPlaylistResult"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteEntryFromPlaylistResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayInternalPlaylistTaskResult_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteEntryFromPlaylistResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RenameInternalPlaylistStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RenameInternalPlaylistStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPlaylistPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPlaylistPath" , 13);
        const char *s = value.getSPlaylistPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSNewName()) {
        yajl_gen_string(g, (const unsigned char*)  "sNewName" , 8);
        const char *s = value.getSNewName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RenameInternalPlaylistStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RenameInternalPlaylistResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RenameInternalPlaylistResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayInternalPlaylistTaskResult_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RenameInternalPlaylistResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteInternalPlaylistStart"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteInternalPlaylistStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPlaylistPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPlaylistPath" , 13);
        const char *s = value.getSPlaylistPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteInternalPlaylistStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteInternalPlaylistResult"

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteInternalPlaylistResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayInternalPlaylistTaskResult_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeleteInternalPlaylistResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerInternalPlaylistListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerInternalPlaylistListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerInternalPlaylistListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerInternalPlaylistListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerInternalPlaylistListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerInternalPlaylistListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerInternalPlaylistListSliceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerInternalPlaylistListSliceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32WindowStart()) {
        yajl_gen_string(g, (const unsigned char*)  "u32WindowStart" , 14);
        yajl_gen_integer(g, (long long)value.getU32WindowStart());
    }
    if (!isSparse || value.hasU16WindowSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u16WindowSize" , 13);
        yajl_gen_integer(g, (long long)value.getU16WindowSize());
    }
    if (!isSparse || value.hasDeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceTag" , 9);
        yajl_gen_integer(g, (long long)value.getDeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerInternalPlaylistListSliceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerInternalPlaylistListSliceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerInternalPlaylistListSliceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOMediaObjects()) {
        yajl_gen_string(g, (const unsigned char*)  "oMediaObjects" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayMediaObjectsItem >& o37 = value.getOMediaObjects();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayMediaObjectsItem >::const_iterator o36;
            for (o36 = o37.begin(); o36 != o37.end(); ++o36) {
                serializeJson((*o36), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerInternalPlaylistListSliceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetListPositionOfObjectStart"

void serializeJson (const ::mplay_MediaPlayer_FI::GetListPositionOfObjectStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GetListPositionOfObjectStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetListPositionOfObjectResult"

void serializeJson (const ::mplay_MediaPlayer_FI::GetListPositionOfObjectResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Position" , 11);
        yajl_gen_integer(g, (long long)value.getU32Position());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::GetListPositionOfObjectResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerFileListExtStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListExtStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "sFilename" , 9);
        const char *s = value.getSFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasE8MPlayFileTypeSelection()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MPlayFileTypeSelection" , 24);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileTypeSelection_Name(value.getE8MPlayFileTypeSelection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MPlayFileTypeSelection());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListExtStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerFileListExtResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListExtResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU32TotalNumFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumFiles" , 16);
        yajl_gen_integer(g, (long long)value.getU32TotalNumFiles());
    }
    if (!isSparse || value.hasU32TotalNumFolders()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumFolders" , 18);
        yajl_gen_integer(g, (long long)value.getU32TotalNumFolders());
    }
    if (!isSparse || value.hasU32Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Position" , 11);
        yajl_gen_integer(g, (long long)value.getU32Position());
    }
    if (!isSparse || value.hasU32TotalNumMediaObjects()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumMediaObjects" , 23);
        yajl_gen_integer(g, (long long)value.getU32TotalNumMediaObjects());
    }
    if (!isSparse || value.hasU32TotalNumPlaylists()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumPlaylists" , 20);
        yajl_gen_integer(g, (long long)value.getU32TotalNumPlaylists());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListExtResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartSlideshowStart"

void serializeJson (const ::mplay_MediaPlayer_FI::StartSlideshowStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::StartSlideshowStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestSlideshowActionStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestSlideshowActionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Action()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Action" , 8);
        const char* s = ::MPlay_fi_types::T_e8_MPlayAction_Name(value.getE8Action());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Action());
    }
    if (!isSparse || value.hasU8NextPrevSkipCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NextPrevSkipCount" , 19);
        yajl_gen_integer(g, (long long)value.getU8NextPrevSkipCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestSlideshowActionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "QuicksearchStart"

void serializeJson (const ::mplay_MediaPlayer_FI::QuicksearchStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Position" , 11);
        yajl_gen_integer(g, (long long)value.getU32Position());
    }
    if (!isSparse || value.hasSSearchChar()) {
        yajl_gen_string(g, (const unsigned char*)  "sSearchChar" , 11);
        serializeJson(value.getSSearchChar(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::QuicksearchStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "QuicksearchResult"

void serializeJson (const ::mplay_MediaPlayer_FI::QuicksearchResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Position()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Position" , 11);
        yajl_gen_integer(g, (long long)value.getU32Position());
    }
    if (!isSparse || value.hasOSearchResult()) {
        yajl_gen_string(g, (const unsigned char*)  "oSearchResult" , 13);
        const char* s = ::MPlay_fi_types::T_e8_QuickSearchResult_Name(value.getOSearchResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOSearchResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::QuicksearchResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EjectOpticalDiscStart"

void serializeJson (const ::mplay_MediaPlayer_FI::EjectOpticalDiscStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasECmdParam()) {
        yajl_gen_string(g, (const unsigned char*)  "eCmdParam" , 9);
        const char* s = ::mplay_shared_fi_types::T_e8_EjectParmType_Name(value.getECmdParam());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getECmdParam());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::EjectOpticalDiscStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EjectOpticalDiscResult"

void serializeJson (const ::mplay_MediaPlayer_FI::EjectOpticalDiscResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasServiceStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceStatus" , 13);
        const char* s = ::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult_Name(value.getServiceStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getServiceStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::EjectOpticalDiscResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerIndexedImageFolderListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedImageFolderListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayListType_Name(value.getE8ListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListType());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasSPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPath" , 5);
        const char *s = value.getSPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedImageFolderListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerIndexedImageFolderListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedImageFolderListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedImageFolderListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerIndexedImageFolderListSliceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedImageFolderListSliceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32WindowStart()) {
        yajl_gen_string(g, (const unsigned char*)  "u32WindowStart" , 14);
        yajl_gen_integer(g, (long long)value.getU32WindowStart());
    }
    if (!isSparse || value.hasU16WindowSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u16WindowSize" , 13);
        yajl_gen_integer(g, (long long)value.getU16WindowSize());
    }
    if (!isSparse || value.hasDeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceTag" , 9);
        yajl_gen_integer(g, (long long)value.getDeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedImageFolderListSliceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerIndexedImageFolderListSliceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedImageFolderListSliceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOImageObjects()) {
        yajl_gen_string(g, (const unsigned char*)  "oImageObjects" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_MPlayImageObjectItem >& o39 = value.getOImageObjects();
        {
            ::std::vector< ::MPlay_fi_types::T_MPlayImageObjectItem >::const_iterator o38;
            for (o38 = o39.begin(); o38 != o39.end(); ++o38) {
                serializeJson((*o38), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedImageFolderListSliceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerCDListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerCDListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPath" , 5);
        const char *s = value.getSPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasE8MPlayFileTypeSelection()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MPlayFileTypeSelection" , 24);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileTypeSelection_Name(value.getE8MPlayFileTypeSelection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MPlayFileTypeSelection());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerCDListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerCDListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerCDListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU32TotalNumFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumFiles" , 16);
        yajl_gen_integer(g, (long long)value.getU32TotalNumFiles());
    }
    if (!isSparse || value.hasU32TotalNumFolders()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumFolders" , 18);
        yajl_gen_integer(g, (long long)value.getU32TotalNumFolders());
    }
    if (!isSparse || value.hasU32TotalNumMediaObjects()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumMediaObjects" , 23);
        yajl_gen_integer(g, (long long)value.getU32TotalNumMediaObjects());
    }
    if (!isSparse || value.hasU32TotalNumPlaylists()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumPlaylists" , 20);
        yajl_gen_integer(g, (long long)value.getU32TotalNumPlaylists());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerCDListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerFolderInfoStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerFolderInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPath" , 5);
        const char *s = value.getSPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasE8MPlayFileTypeSelection()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MPlayFileTypeSelection" , 24);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileTypeSelection_Name(value.getE8MPlayFileTypeSelection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MPlayFileTypeSelection());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerFolderInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerFolderInfoResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerFolderInfoResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasSPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPath" , 5);
        const char *s = value.getSPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU64TotalSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u64TotalSize" , 12);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getU64TotalSize(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasU32TotalNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalNumber" , 14);
        yajl_gen_integer(g, (long long)value.getU32TotalNumber());
    }
    if (!isSparse || value.hasU64ProtectedSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u64ProtectedSize" , 16);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getU64ProtectedSize(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasU32ProtectedNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ProtectedNumber" , 18);
        yajl_gen_integer(g, (long long)value.getU32ProtectedNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerFolderInfoResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFilePermissionByMediaObjectTagsStart"

void serializeJson (const ::mplay_MediaPlayer_FI::SetFilePermissionByMediaObjectTagsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOFilePermissionObjectTags()) {
        yajl_gen_string(g, (const unsigned char*)  "oFilePermissionObjectTags" , 25);
        yajl_gen_array_open(g);
        const ::std::vector< ::MPlay_fi_types::T_PermissionByTag >& o41 = value.getOFilePermissionObjectTags();
        {
            ::std::vector< ::MPlay_fi_types::T_PermissionByTag >::const_iterator o40;
            for (o40 = o41.begin(); o40 != o41.end(); ++o40) {
                serializeJson((*o40), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SetFilePermissionByMediaObjectTagsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFilePermissionByMediaObjectTagsResult"

void serializeJson (const ::mplay_MediaPlayer_FI::SetFilePermissionByMediaObjectTagsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32NumberOfFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumberOfFiles" , 16);
        yajl_gen_integer(g, (long long)value.getU32NumberOfFiles());
    }
    if (!isSparse || value.hasU32Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Status" , 9);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeleteMediaContentTaskResult_Name(value.getU32Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU32Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SetFilePermissionByMediaObjectTagsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddFilenameToInternalPlaylistByTagsStart"

void serializeJson (const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistByTagsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPlaylistPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPlaylistPath" , 13);
        const char *s = value.getSPlaylistPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8ListType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayListType_Name(value.getE8ListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListType());
    }
    if (!isSparse || value.hasU32FilterTag1()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag1" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag1());
    }
    if (!isSparse || value.hasU32FilterTag2()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag2" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag2());
    }
    if (!isSparse || value.hasU32FilterTag3()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FilterTag3" , 13);
        yajl_gen_integer(g, (long long)value.getU32FilterTag3());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistByTagsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddFilenameToInternalPlaylistByTagsResult"

void serializeJson (const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistByTagsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::MPlay_fi_types::T_e8_MPlayInternalPlaylistTaskResult_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistByTagsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StorePersonalizedFavoriteStart"

void serializeJson (const ::mplay_MediaPlayer_FI::StorePersonalizedFavoriteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ObjectID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ObjectID" , 11);
        yajl_gen_integer(g, (long long)value.getU32ObjectID());
    }
    if (!isSparse || value.hasU8UserID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UserID" , 8);
        yajl_gen_integer(g, (long long)value.getU8UserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::StorePersonalizedFavoriteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StorePersonalizedFavoriteResult"

void serializeJson (const ::mplay_MediaPlayer_FI::StorePersonalizedFavoriteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU64FavoriteID()) {
        yajl_gen_string(g, (const unsigned char*)  "u64FavoriteID" , 13);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getU64FavoriteID(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::StorePersonalizedFavoriteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeletePersonalizedFavoriteStart"

void serializeJson (const ::mplay_MediaPlayer_FI::DeletePersonalizedFavoriteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ObjectID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ObjectID" , 11);
        yajl_gen_integer(g, (long long)value.getU32ObjectID());
    }
    if (!isSparse || value.hasU8UserID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UserID" , 8);
        yajl_gen_integer(g, (long long)value.getU8UserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeletePersonalizedFavoriteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeletePersonalizedFavoriteResult"

void serializeJson (const ::mplay_MediaPlayer_FI::DeletePersonalizedFavoriteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ObjectID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ObjectID" , 11);
        yajl_gen_integer(g, (long long)value.getU32ObjectID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::DeletePersonalizedFavoriteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerGlobalSearchListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerGlobalSearchListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandleOfParent()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandleOfParent" , 21);
        yajl_gen_integer(g, (long long)value.getU32ListHandleOfParent());
    }
    if (!isSparse || value.hasU32ListHandleOfReplaceableList()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandleOfReplaceableList" , 30);
        yajl_gen_integer(g, (long long)value.getU32ListHandleOfReplaceableList());
    }
    if (!isSparse || value.hasSSearchString()) {
        yajl_gen_string(g, (const unsigned char*)  "sSearchString" , 13);
        const char *s = value.getSSearchString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasSearchType()) {
        yajl_gen_string(g, (const unsigned char*)  "searchType" , 10);
        const char* s = ::MPlay_fi_types::T_MPlaySearchType_Name(value.getSearchType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSearchType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerGlobalSearchListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerGlobalSearchListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerGlobalSearchListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ListHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListHandle" , 13);
        yajl_gen_integer(g, (long long)value.getU32ListHandle());
    }
    if (!isSparse || value.hasU32ListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ListSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32ListSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerGlobalSearchListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerAlbumArtListStart"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerAlbumArtListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListID()) {
        yajl_gen_string(g, (const unsigned char*)  "listID" , 6);
        yajl_gen_integer(g, (long long)value.getListID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerAlbumArtListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateMediaPlayerAlbumArtListResult"

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerAlbumArtListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAlbumArtListID()) {
        yajl_gen_string(g, (const unsigned char*)  "albumArtListID" , 14);
        yajl_gen_integer(g, (long long)value.getAlbumArtListID());
    }
    if (!isSparse || value.hasListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "listSize" , 8);
        yajl_gen_integer(g, (long long)value.getListSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::CreateMediaPlayerAlbumArtListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerAlbumArtListSliceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerAlbumArtListSliceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAlbumArtListID()) {
        yajl_gen_string(g, (const unsigned char*)  "albumArtListID" , 14);
        yajl_gen_integer(g, (long long)value.getAlbumArtListID());
    }
    if (!isSparse || value.hasIndicesType()) {
        yajl_gen_string(g, (const unsigned char*)  "indicesType" , 11);
        const char* s = ::MPlay_fi_types::T_IndicesType_Name(value.getIndicesType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getIndicesType());
    }
    if (!isSparse || value.hasOIndices()) {
        yajl_gen_string(g, (const unsigned char*)  "oIndices" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o43 = value.getOIndices();
        {
            ::std::vector< uint32 >::const_iterator o42;
            for (o42 = o43.begin(); o42 != o43.end(); ++o42) {
                yajl_gen_integer(g, (long long)(*o42));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerAlbumArtListSliceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestMediaPlayerAlbumArtListSliceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerAlbumArtListSliceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOAlbumartUrls()) {
        yajl_gen_string(g, (const unsigned char*)  "oAlbumartUrls" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o45 = value.getOAlbumartUrls();
        {
            ::std::vector< ::std::string >::const_iterator o44;
            for (o44 = o45.begin(); o44 != o45.end(); ++o44) {
                const char *s = (*o44).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestMediaPlayerAlbumArtListSliceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendAppleHIDCommandStart"

void serializeJson (const ::mplay_MediaPlayer_FI::SendAppleHIDCommandStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEHIDCommand()) {
        yajl_gen_string(g, (const unsigned char*)  "eHIDCommand" , 11);
        const char* s = ::MPlay_fi_types::T_e_MPlayHIDCommand_Name(value.getEHIDCommand());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEHIDCommand());
    }
    if (!isSparse || value.hasEKeyEvent()) {
        yajl_gen_string(g, (const unsigned char*)  "eKeyEvent" , 9);
        const char* s = ::MPlay_fi_types::T_e_MPlayKeyEvent_Name(value.getEKeyEvent());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEKeyEvent());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SendAppleHIDCommandStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendAppleHIDCommandResult"

void serializeJson (const ::mplay_MediaPlayer_FI::SendAppleHIDCommandResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::SendAppleHIDCommandResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestBluetoothAudioDeviceStart"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestBluetoothAudioDeviceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBRequestAction()) {
        yajl_gen_string(g, (const unsigned char*)  "bRequestAction" , 14);
        yajl_gen_bool(g, (bool)value.getBRequestAction());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestBluetoothAudioDeviceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestBluetoothAudioDeviceResult"

void serializeJson (const ::mplay_MediaPlayer_FI::RequestBluetoothAudioDeviceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBRequestStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "bRequestStatus" , 14);
        yajl_gen_bool(g, (bool)value.getBRequestStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_MediaPlayer_FI::RequestBluetoothAudioDeviceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::MediaPlayerListChangeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::NowPlayingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlaytimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlaybackStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlaybackModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlaybackModeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RepeatModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RepeatModeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::IndexingStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ActiveMediaDeviceStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ActiveMediaDeviceSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::MyMediaSupportedStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CurrentFolderPathStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ScanModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ScanModeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DiscErrorStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DiscMechanicalInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CMSkipAvailableStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DirectSelectAvailableStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDAngleInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDSubtitleInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDAudioChannelInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDCurrentAudioInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DisplayModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DisplayModeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDPlayerLangSettingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDPlayerLangSettingSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::AngleMarkSettingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::AngleMarkSettingSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlayStatusSettingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlayStatusSettingSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DRCSettingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DRCSettingSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDCommandStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::AutoRippingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::AutoRippingSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GracenoteLookupModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GracenoteLookupModeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GracenoteVersionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RippingErrorsStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ResolveGracenoteAmbuiguitiesStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDMenuPlaybackOngoingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DVDDriveInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RippingStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RippingEncodingQualityStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RippingEncodingQualitySet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GNMetadataExtractionStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::LanguageStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::LanguageSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlaybackRepeatModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlaybackRepeatModeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SlideshowTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SlideshowTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::NowShowingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SlideshowStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::MediaPlayerOpticalDiscSlotStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::MediaPlayerOpticalDiscCDInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::IPodCommunicationErrorStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeviceStreamingInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoBrightnessStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoBrightnessSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoHueStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoHueSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoSaturationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoSaturationSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoContrastStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoContrastSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoBrightnessOffsetStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoBrightnessOffsetSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoHueOffsetStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoHueOffsetSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoSaturationOffsetStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoSaturationOffsetSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoScalingStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::VideoScalingSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::UpdatePlaybackSpeedStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::UserFavoritesChangedStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::FolderBrowseStructureClearedStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ReadyToPlayStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::BluetoothAudioDeviceStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ReleaseMediaPlayerListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestPlaybackActionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SeekToStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SearchKeyboardMediaPlayerListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SearchKeyboardMediaPlayerListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringAbort& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultFirst& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultMiddle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerListSearchStringResultLast& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GetMediaObjectStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GetMediaObjectResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerPlaylistListSliceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerPlaylistListSliceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerQuickPlayListSliceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerQuickPlayListSliceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlayMediaPlayerObjectStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlayMediaPlayerObjectResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlayItemFromListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlayItemFromListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::UmountStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::UmountResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ReindexingStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DiagnosisPlaySongStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestListDetailsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestListDetailsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestListInformationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestListInformationResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::TransferTagsToDeviceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::TransferTagsToDeviceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlayItemFromListByTagStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlaybackSpeedSetStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::PlaybackSpeedSetResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ClearLastModePauseStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestDiscOperationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestVCDAudioChannelStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestDVDAudioChannelStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SendNavigationKeyStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SendTouchCommandStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestDirectSearchStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestAngleChangeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SetMenuPlayBackControlStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SelectDirectNumberStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestTitleSearchStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestSubtitleChangeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestCMSkipStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestDVDTemperatureResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ReorderInternalPlaylistStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ReorderInternalPlaylistResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteMediaContentByFilterTagsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteMediaContentByFilterTagsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteMediaContentByMediaObjectTagsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteMediaContentByMediaObjectTagsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteMediaContentByUrlsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteMediaContentByUrlsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectTagStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectTagResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectUrlStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::EditMetaDataByMediaObjectUrlResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::ExtractGracenoteMetadataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateInternalFileNamePlaylistStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateInternalFileNamePlaylistResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteEntryFromPlaylistStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteEntryFromPlaylistResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RenameInternalPlaylistStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RenameInternalPlaylistResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteInternalPlaylistStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeleteInternalPlaylistResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerInternalPlaylistListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerInternalPlaylistListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerInternalPlaylistListSliceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerInternalPlaylistListSliceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GetListPositionOfObjectStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::GetListPositionOfObjectResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListExtStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListExtResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::StartSlideshowStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestSlideshowActionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::QuicksearchStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::QuicksearchResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::EjectOpticalDiscStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::EjectOpticalDiscResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedImageFolderListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedImageFolderListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedImageFolderListSliceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedImageFolderListSliceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerCDListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerCDListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerFolderInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerFolderInfoResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SetFilePermissionByMediaObjectTagsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SetFilePermissionByMediaObjectTagsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistByTagsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::AddFilenameToInternalPlaylistByTagsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::StorePersonalizedFavoriteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::StorePersonalizedFavoriteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeletePersonalizedFavoriteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::DeletePersonalizedFavoriteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerGlobalSearchListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerGlobalSearchListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerAlbumArtListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::CreateMediaPlayerAlbumArtListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerAlbumArtListSliceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestMediaPlayerAlbumArtListSliceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SendAppleHIDCommandStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::SendAppleHIDCommandResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestBluetoothAudioDeviceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI
using namespace ::asf::stream::json;

namespace mplay_MediaPlayer_FI {

std::ostream& operator<<(std::ostream& o, const ::mplay_MediaPlayer_FI::RequestBluetoothAudioDeviceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_MediaPlayer_FI

