/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "mplay_devicemanager_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types mplay_devicemanager_fi_types
 */

using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi_types {

bool T_e8_DeviceConnectStatus_Parse (const char *str, size_t length, T_e8_DeviceConnectStatus &value)
{
    static stringEntry entries[] = {
        {15,"USB_DEV_WARNING", 1U},
        {17,"USB_DEV_CONNECTED", 2U},
        {17,"USB_DEV_UNDEFINED", 0U},
        {22,"USB_DEV_REMOVED_BY_USR", 3U},
        {24,"USB_DEV_UNAVAIL_OVERTEMP", 7U},
        {26,"USB_DEV_UNAVAIL_HW_MALFUNC", 5U},
        {27,"USB_DEV_UNAVAIL_BAT_LOWVOLT", 4U},
        {36,"USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_DeviceConnectStatus_Name (T_e8_DeviceConnectStatus value)
{
    static const char* enumerationLiterals[] = {
        "USB_DEV_UNDEFINED",
        "USB_DEV_WARNING",
        "USB_DEV_CONNECTED",
        "USB_DEV_REMOVED_BY_USR",
        "USB_DEV_UNAVAIL_BAT_LOWVOLT",
        "USB_DEV_UNAVAIL_HW_MALFUNC",
        "USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT",
        "USB_DEV_UNAVAIL_OVERTEMP",
    };

    if (T_e8_DeviceConnectStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceConnectStatus_IsValid (T_e8_DeviceConnectStatus value)
{
    switch (value) {
    case T_e8_DeviceConnectStatus__USB_DEV_CONNECTED:
    case T_e8_DeviceConnectStatus__USB_DEV_REMOVED_BY_USR:
    case T_e8_DeviceConnectStatus__USB_DEV_UNAVAIL_BAT_LOWVOLT:
    case T_e8_DeviceConnectStatus__USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT:
    case T_e8_DeviceConnectStatus__USB_DEV_UNAVAIL_HW_MALFUNC:
    case T_e8_DeviceConnectStatus__USB_DEV_UNAVAIL_OVERTEMP:
    case T_e8_DeviceConnectStatus__USB_DEV_UNDEFINED:
    case T_e8_DeviceConnectStatus__USB_DEV_WARNING:
        return true;
    default:
        return false;
    }
}

bool T_e8_Device_Parse (const char *str, size_t length, T_e8_Device &value)
{
    static stringEntry entries[] = {
        {7,"DTY_BTA", 13U},
        {7,"DTY_HUB", 11U},
        {7,"DTY_MTP", 5U},
        {7,"DTY_USB", 1U},
        {8,"DTY_CDDA", 14U},
        {8,"DTY_IPAD", 8U},
        {8,"DTY_IPOD", 3U},
        {9,"DTY_CDROM", 7U},
        {10,"DTY_IPHONE", 4U},
        {10,"DTY_MSZUNE", 6U},
        {10,"DTY_SDCARD", 2U},
        {11,"DTY_UNKNOWN", 0U},
        {13,"DTY_DVD_DRIVE", 15U},
        {14,"DTY_DIGITALAUX", 12U},
        {17,"DTY_NOT_SUPPORTED", 10U},
        {19,"DTY_SDCARD_INTERNAL", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 16, (unsigned int&) value);
}

const char* T_e8_Device_Name (T_e8_Device value)
{
    static const char* enumerationLiterals[] = {
        "DTY_UNKNOWN",
        "DTY_USB",
        "DTY_SDCARD",
        "DTY_IPOD",
        "DTY_IPHONE",
        "DTY_MTP",
        "DTY_MSZUNE",
        "DTY_CDROM",
        "DTY_IPAD",
        "DTY_SDCARD_INTERNAL",
        "DTY_NOT_SUPPORTED",
        "DTY_HUB",
        "DTY_DIGITALAUX",
        "DTY_BTA",
        "DTY_CDDA",
        "DTY_DVD_DRIVE",
    };

    if (T_e8_Device_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Device_IsValid (T_e8_Device value)
{
    switch (value) {
    case T_e8_Device__DTY_BTA:
    case T_e8_Device__DTY_CDDA:
    case T_e8_Device__DTY_CDROM:
    case T_e8_Device__DTY_DIGITALAUX:
    case T_e8_Device__DTY_DVD_DRIVE:
    case T_e8_Device__DTY_HUB:
    case T_e8_Device__DTY_IPAD:
    case T_e8_Device__DTY_IPHONE:
    case T_e8_Device__DTY_IPOD:
    case T_e8_Device__DTY_MSZUNE:
    case T_e8_Device__DTY_MTP:
    case T_e8_Device__DTY_NOT_SUPPORTED:
    case T_e8_Device__DTY_SDCARD_INTERNAL:
    case T_e8_Device__DTY_SDCARD:
    case T_e8_Device__DTY_UNKNOWN:
    case T_e8_Device__DTY_USB:
        return true;
    default:
        return false;
    }
}

bool T_e8_DVM_DeviceSpeedUsb_Parse (const char *str, size_t length, T_e8_DVM_DeviceSpeedUsb &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {8,"HI_SPEED", 3U},
        {9,"LOW_SPEED", 1U},
        {10,"FULL_SPEED", 2U},
        {11,"SUPER_SPEED", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_DVM_DeviceSpeedUsb_Name (T_e8_DVM_DeviceSpeedUsb value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "LOW_SPEED",
        "FULL_SPEED",
        "HI_SPEED",
        "SUPER_SPEED",
    };

    if (T_e8_DVM_DeviceSpeedUsb_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DVM_DeviceSpeedUsb_IsValid (T_e8_DVM_DeviceSpeedUsb value)
{
    switch (value) {
    case T_e8_DVM_DeviceSpeedUsb__FULL_SPEED:
    case T_e8_DVM_DeviceSpeedUsb__HI_SPEED:
    case T_e8_DVM_DeviceSpeedUsb__LOW_SPEED:
    case T_e8_DVM_DeviceSpeedUsb__SUPER_SPEED:
    case T_e8_DVM_DeviceSpeedUsb__UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_DVM_UnsupportedReason_Parse (const char *str, size_t length, T_e8_DVM_UnsupportedReason &value)
{
    static stringEntry entries[] = {
        {2,"OK", 0U},
        {16,"NOTMOUNTEDDEVICE", 1U},
        {17,"NOTSUPPORTEDBYDVM", 3U},
        {20,"HUBBUTNOTCUSTOMERHUB", 4U},
        {23,"DISABLEDINCONFIGURATION", 2U},
        {30,"MULTIPART_UNSUPPORTEDPARTITION", 6U},
        {30,"POSSIBLYSUPPORTEDBYOTHERCLIENT", 5U},
        {36,"APPLEDEVICENOTCONNECTEDONCUSTOMERHUB", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_DVM_UnsupportedReason_Name (T_e8_DVM_UnsupportedReason value)
{
    static const char* enumerationLiterals[] = {
        "OK",
        "NotMountedDevice",
        "DisabledInConfiguration",
        "NotSupportedByDVM",
        "HubButNotCustomerHub",
        "PossiblySupportedByOtherClient",
        "Multipart_UnSupportedPartition",
        "AppleDeviceNotConnectedOnCustomerHub",
    };

    if (T_e8_DVM_UnsupportedReason_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DVM_UnsupportedReason_IsValid (T_e8_DVM_UnsupportedReason value)
{
    switch (value) {
    case T_e8_DVM_UnsupportedReason__DisabledInConfiguration:
    case T_e8_DVM_UnsupportedReason__HubButNotCustomerHub:
    case T_e8_DVM_UnsupportedReason__NotMountedDevice:
    case T_e8_DVM_UnsupportedReason__NotSupportedByDVM:
    case T_e8_DVM_UnsupportedReason__OK:
    case T_e8_DVM_UnsupportedReason__PossiblySupportedByOtherClient:
    case T_e8_DVM_UnsupportedReason__Multipart_UnSupportedPartition:
    case T_e8_DVM_UnsupportedReason__AppleDeviceNotConnectedOnCustomerHub:
        return true;
    default:
        return false;
    }
}

bool T_e8_FileSystem_Parse (const char *str, size_t length, T_e8_FileSystem &value)
{
    static stringEntry entries[] = {
        {8,"FSTY_FAT", 1U},
        {8,"FSTY_HFS", 4U},
        {8,"FSTY_UDF", 7U},
        {9,"FSTY_EXT4", 3U},
        {9,"FSTY_NTFS", 2U},
        {10,"FSTY_EXFAT", 5U},
        {12,"FSTY_ISO9660", 6U},
        {12,"FSTY_UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_FileSystem_Name (T_e8_FileSystem value)
{
    static const char* enumerationLiterals[] = {
        "FSTY_UNKNOWN",
        "FSTY_FAT",
        "FSTY_NTFS",
        "FSTY_EXT4",
        "FSTY_HFS",
        "FSTY_EXFAT",
        "FSTY_ISO9660",
        "FSTY_UDF",
    };

    if (T_e8_FileSystem_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_FileSystem_IsValid (T_e8_FileSystem value)
{
    switch (value) {
    case T_e8_FileSystem__FSTY_EXFAT:
    case T_e8_FileSystem__FSTY_EXT4:
    case T_e8_FileSystem__FSTY_FAT:
    case T_e8_FileSystem__FSTY_HFS:
    case T_e8_FileSystem__FSTY_ISO9660:
    case T_e8_FileSystem__FSTY_NTFS:
    case T_e8_FileSystem__FSTY_UDF:
    case T_e8_FileSystem__FSTY_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_DVM_MediaState_Parse (const char *str, size_t length, T_e8_DVM_MediaState &value)
{
    static stringEntry entries[] = {
        {11,"MEDIA_READY", 1U},
        {15,"MEDIA_NOT_READY", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DVM_MediaState_Name (T_e8_DVM_MediaState value)
{
    static const char* enumerationLiterals[] = {
        "MEDIA_NOT_READY",
        "MEDIA_READY",
    };

    if (T_e8_DVM_MediaState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DVM_MediaState_IsValid (T_e8_DVM_MediaState value)
{
    switch (value) {
    case T_e8_DVM_MediaState__MEDIA_NOT_READY:
    case T_e8_DVM_MediaState__MEDIA_READY:
        return true;
    default:
        return false;
    }
}

bool T_e8_DVM_MediaType_Parse (const char *str, size_t length, T_e8_DVM_MediaType &value)
{
    static stringEntry entries[] = {
        {10,"DATA_MEDIA", 4U},
        {13,"MEDIA_EJECTED", 1U},
        {13,"UNKNOWN_MEDIA", 16U},
        {15,"INCORRECT_MEDIA", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DVM_MediaType_Name (T_e8_DVM_MediaType value)
{
    static const char* enumerationLiterals[] = {
        "MEDIA_EJECTED",
        "INCORRECT_MEDIA",
        "DATA_MEDIA",
        "UNKNOWN_MEDIA",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        4U,
        16U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DVM_MediaType_IsValid (T_e8_DVM_MediaType value)
{
    switch (value) {
    case T_e8_DVM_MediaType__DATA_MEDIA:
    case T_e8_DVM_MediaType__INCORRECT_MEDIA:
    case T_e8_DVM_MediaType__MEDIA_EJECTED:
    case T_e8_DVM_MediaType__UNKNOWN_MEDIA:
        return true;
    default:
        return false;
    }
}

bool T_e8_PowerStatus_Parse (const char *str, size_t length, T_e8_PowerStatus &value)
{
    static stringEntry entries[] = {
        {17,"POWER_STATUS_INIT", 0U},
        {26,"POWER_STATUS_NOT_AVAILABLE", 3U},
        {31,"POWER_STATUS_OVERCURRENT_ACTIVE", 2U},
        {33,"POWER_STATUS_OVERCURRENT_INACTIVE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_PowerStatus_Name (T_e8_PowerStatus value)
{
    static const char* enumerationLiterals[] = {
        "POWER_STATUS_INIT",
        "POWER_STATUS_OVERCURRENT_INACTIVE",
        "POWER_STATUS_OVERCURRENT_ACTIVE",
        "POWER_STATUS_NOT_AVAILABLE",
    };

    if (T_e8_PowerStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_PowerStatus_IsValid (T_e8_PowerStatus value)
{
    switch (value) {
    case T_e8_PowerStatus__POWER_STATUS_INIT:
    case T_e8_PowerStatus__POWER_STATUS_NOT_AVAILABLE:
    case T_e8_PowerStatus__POWER_STATUS_OVERCURRENT_ACTIVE:
    case T_e8_PowerStatus__POWER_STATUS_OVERCURRENT_INACTIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_SettingsMode_Parse (const char *str, size_t length, T_e8_SettingsMode &value)
{
    static stringEntry entries[] = {
        {7,"DEFAULT", 2U},
        {9,"PERMANENT", 1U},
        {9,"TEMPORARY", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_SettingsMode_Name (T_e8_SettingsMode value)
{
    static const char* enumerationLiterals[] = {
        "Temporary",
        "Permanent",
        "Default",
    };

    if (T_e8_SettingsMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_SettingsMode_IsValid (T_e8_SettingsMode value)
{
    switch (value) {
    case T_e8_SettingsMode__Default:
    case T_e8_SettingsMode__Permanent:
    case T_e8_SettingsMode__Temporary:
        return true;
    default:
        return false;
    }
}

bool T_e8_MDVDDiscType_Parse (const char *str, size_t length, T_e8_MDVDDiscType &value)
{
    static stringEntry entries[] = {
        {11,"E8DISC_DATA", 1U},
        {15,"E8NON_DISC_DATA", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_MDVDDiscType_Name (T_e8_MDVDDiscType value)
{
    static const char* enumerationLiterals[] = {
        "e8NON_DISC_DATA",
        "e8DISC_DATA",
    };

    if (T_e8_MDVDDiscType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_MDVDDiscType_IsValid (T_e8_MDVDDiscType value)
{
    switch (value) {
    case T_e8_MDVDDiscType__e8NON_DISC_DATA:
    case T_e8_MDVDDiscType__e8DISC_DATA:
        return true;
    default:
        return false;
    }
}

bool T_e8_MDVDDriveMode_Parse (const char *str, size_t length, T_e8_MDVDDriveMode &value)
{
    static stringEntry entries[] = {
        {14,"E8BACKEND_MODE", 1U},
        {14,"E8INVALID_MODE", 255U},
        {19,"E8MASS_STORAGE_MODE", 0U},
        {28,"E8TRANSITION_TO_BACKEND_MODE", 17U},
        {33,"E8TRANSITION_TO_MASS_STORAGE_MODE", 16U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_MDVDDriveMode_Name (T_e8_MDVDDriveMode value)
{
    static const char* enumerationLiterals[] = {
        "e8MASS_STORAGE_MODE",
        "e8BACKEND_MODE",
        "e8TRANSITION_TO_MASS_STORAGE_MODE",
        "e8TRANSITION_TO_BACKEND_MODE",
        "e8INVALID_MODE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        16U,
        17U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_MDVDDriveMode_IsValid (T_e8_MDVDDriveMode value)
{
    switch (value) {
    case T_e8_MDVDDriveMode__e8MASS_STORAGE_MODE:
    case T_e8_MDVDDriveMode__e8TRANSITION_TO_MASS_STORAGE_MODE:
    case T_e8_MDVDDriveMode__e8BACKEND_MODE:
    case T_e8_MDVDDriveMode__e8TRANSITION_TO_BACKEND_MODE:
    case T_e8_MDVDDriveMode__e8INVALID_MODE:
        return true;
    default:
        return false;
    }
}

} // namespace mplay_devicemanager_fi_types
