#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_DEVICEMANAGER_FI_TYPES_H
#define MPLAY_DEVICEMANAGER_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "mplay_devicemanager_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types mplay_devicemanager_fi_types
 */

namespace mplay_devicemanager_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_DevManager_DeviceProperty;

class T_DevManager_PortStates;

class T_DevManager_SDCardInfo;

// type definitions
/**
 * If the meaning of "T_DevManager_DevInfoStr" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_DevManager_DeviceProperty > T_DevManager_DevInfoStr;

/**
 * If the meaning of "T_DVM_CardIdentifierRegister" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_DVM_CardIdentifierRegister;


/**
 * Type of the device connected
 */
class T_DevManager_DeviceProperty {
public:

    /**
     * Default constructor
     */
    inline  T_DevManager_DeviceProperty ();

    /**
     * Copy constructor
     */
    inline  T_DevManager_DeviceProperty (const T_DevManager_DeviceProperty &rhs);

    /**
     * All fields constructor
     */
    inline  T_DevManager_DeviceProperty (T_e8_DeviceConnectStatus DeviceConnectStatus_, T_e8_Device DeviceType_, T_e8_DVM_DeviceSpeedUsb DeviceSpeedUsb_, T_e8_DVM_UnsupportedReason UnsupportedReason_, T_e8_FileSystem FileSystemType_, const ::std::string& AccessoryName2_, const ::std::string& AccessoryName_, const ::std::string& DeviceName_, const ::std::string& DeviceSerialNo_, const ::std::string& DeviceVersion_, const ::std::string& Manufacturer_, const ::std::string& MountPoint_, const ::std::string& USBPortNo_, uint16 ProductID_, uint16 VendorID_, uint64 FreeSize_kB_, uint64 TotalSize_kB_, uint64 TotalSize_, uint64 UsedSize_kB_, uint8 BaseClassCodeUsb_, uint8 ParitionNum_, uint8 ProtocolUsb_, uint8 SubClassCodeUsb_, const ::std::string& DevicePath_, const ::std::string& DeviceNode_);

    /**
     * Destructor
     */
    inline  ~T_DevManager_DeviceProperty();

    /**
     * Assignment operator
     */
    inline T_DevManager_DeviceProperty& operator = (const T_DevManager_DeviceProperty& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DevManager_DeviceProperty& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DevManager_DeviceProperty& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DevManager_DeviceProperty& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DevManager_DeviceProperty& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceConnectStatus"

    static const int kDeviceConnectStatus = 0;

    /**
     * Clears the field "DeviceConnectStatus".
     *
     * The field will be set to its default value. The hasDeviceConnectStatus()
     * method will return false.
     */
    inline void clearDeviceConnectStatus();

    /**
     * Checks whether the field "DeviceConnectStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectStatus()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectStatus () const;

    /**
     * Returns the value of the member "DeviceConnectStatus".
     *
     * The connect status of device e.g. plugged in but disabled due to low volt or connected to be usable etc.
     *
     * @return The value of the field "DeviceConnectStatus"
     */
    inline T_e8_DeviceConnectStatus getDeviceConnectStatus () const;

    /**
     * Sets the value of the member "DeviceConnectStatus".
     *
     * The connect status of device e.g. plugged in but disabled due to low volt or connected to be usable etc.
     *
     * @param DeviceConnectStatus The value which will be set
     */
    inline void setDeviceConnectStatus (T_e8_DeviceConnectStatus DeviceConnectStatus_);

    // API of field "DeviceType"

    static const int kDeviceType = 1;

    /**
     * Clears the field "DeviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "DeviceType".
     *
     * Type of device connected
     *
     * @return The value of the field "DeviceType"
     */
    inline T_e8_Device getDeviceType () const;

    /**
     * Sets the value of the member "DeviceType".
     *
     * Type of device connected
     *
     * @param DeviceType The value which will be set
     */
    inline void setDeviceType (T_e8_Device DeviceType_);

    // API of field "DeviceSpeedUsb"

    static const int kDeviceSpeedUsb = 2;

    /**
     * Clears the field "DeviceSpeedUsb".
     *
     * The field will be set to its default value. The hasDeviceSpeedUsb()
     * method will return false.
     */
    inline void clearDeviceSpeedUsb();

    /**
     * Checks whether the field "DeviceSpeedUsb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceSpeedUsb()). Otherwise it will return false.
     */
    inline bool hasDeviceSpeedUsb () const;

    /**
     * Returns the value of the member "DeviceSpeedUsb".
     *
     * usb speed of device
     *
     * @return The value of the field "DeviceSpeedUsb"
     */
    inline T_e8_DVM_DeviceSpeedUsb getDeviceSpeedUsb () const;

    /**
     * Sets the value of the member "DeviceSpeedUsb".
     *
     * usb speed of device
     *
     * @param DeviceSpeedUsb The value which will be set
     */
    inline void setDeviceSpeedUsb (T_e8_DVM_DeviceSpeedUsb DeviceSpeedUsb_);

    // API of field "UnsupportedReason"

    static const int kUnsupportedReason = 3;

    /**
     * Clears the field "UnsupportedReason".
     *
     * The field will be set to its default value. The hasUnsupportedReason()
     * method will return false.
     */
    inline void clearUnsupportedReason();

    /**
     * Checks whether the field "UnsupportedReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnsupportedReason()). Otherwise it will return false.
     */
    inline bool hasUnsupportedReason () const;

    /**
     * Returns the value of the member "UnsupportedReason".
     *
     * Tells why the connected device is not supported. If the device is supported the default value of the enum will be send.
     *
     * @return The value of the field "UnsupportedReason"
     */
    inline T_e8_DVM_UnsupportedReason getUnsupportedReason () const;

    /**
     * Sets the value of the member "UnsupportedReason".
     *
     * Tells why the connected device is not supported. If the device is supported the default value of the enum will be send.
     *
     * @param UnsupportedReason The value which will be set
     */
    inline void setUnsupportedReason (T_e8_DVM_UnsupportedReason UnsupportedReason_);

    // API of field "FileSystemType"

    static const int kFileSystemType = 4;

    /**
     * Clears the field "FileSystemType".
     *
     * The field will be set to its default value. The hasFileSystemType()
     * method will return false.
     */
    inline void clearFileSystemType();

    /**
     * Checks whether the field "FileSystemType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFileSystemType()). Otherwise it will return false.
     */
    inline bool hasFileSystemType () const;

    /**
     * Returns the value of the member "FileSystemType".
     *
     * Type of filesystem used for this partition
     *
     * @return The value of the field "FileSystemType"
     */
    inline T_e8_FileSystem getFileSystemType () const;

    /**
     * Sets the value of the member "FileSystemType".
     *
     * Type of filesystem used for this partition
     *
     * @param FileSystemType The value which will be set
     */
    inline void setFileSystemType (T_e8_FileSystem FileSystemType_);

    // API of field "AccessoryName2"

    static const int kAccessoryName2 = 5;

    /**
     * Clears the field "AccessoryName2".
     *
     * The field will be set to its default value. The hasAccessoryName2()
     * method will return false.
     */
    inline void clearAccessoryName2();

    /**
     * Checks whether the field "AccessoryName2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccessoryName2()). Otherwise it will return false.
     */
    inline bool hasAccessoryName2 () const;

    /**
     * Returns the value of the member "AccessoryName2".
     *
     * Store the original Serial ID of the device.This info will be used to identify all the partitions of multi partition mass storage device(Such as USB pen drive,SD card,Internal SD card) belongs to same device. Hint: if you are seeing in the vector of device property having many items with the same "AccessoryName2" information, this means that all of the devices are belonging to the same multi partition stick.
     *
     * @return The value of the field "AccessoryName2"
     */
    inline const ::std::string& getAccessoryName2 () const;

    /**
     * Retrieves the value of the field "AccessoryName2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AccessoryName2".
     */
    inline ::std::string& getAccessoryName2Mutable ();

    /**
     * Sets the value of the member "AccessoryName2".
     *
     * Store the original Serial ID of the device.This info will be used to identify all the partitions of multi partition mass storage device(Such as USB pen drive,SD card,Internal SD card) belongs to same device. Hint: if you are seeing in the vector of device property having many items with the same "AccessoryName2" information, this means that all of the devices are belonging to the same multi partition stick.
     *
     * @param AccessoryName2 The value which will be set
     */
    inline void setAccessoryName2 (const ::std::string& AccessoryName2_);

    /**
     * Sets the value of the member "AccessoryName2".
     *
     * Store the original Serial ID of the device.This info will be used to identify all the partitions of multi partition mass storage device(Such as USB pen drive,SD card,Internal SD card) belongs to same device. Hint: if you are seeing in the vector of device property having many items with the same "AccessoryName2" information, this means that all of the devices are belonging to the same multi partition stick.
     *
     * @param AccessoryName2 The value which will be set
     */
    inline void setAccessoryName2 (const char* AccessoryName2_);

    /**
     * Sets the value of the member "AccessoryName2".
     *
     * Store the original Serial ID of the device.This info will be used to identify all the partitions of multi partition mass storage device(Such as USB pen drive,SD card,Internal SD card) belongs to same device. Hint: if you are seeing in the vector of device property having many items with the same "AccessoryName2" information, this means that all of the devices are belonging to the same multi partition stick.
     *
     * @param AccessoryName2 The value which will be set
     */
    inline void setAccessoryName2 (const char* value, size_t size);

    // API of field "AccessoryName"

    static const int kAccessoryName = 6;

    /**
     * Clears the field "AccessoryName".
     *
     * The field will be set to its default value. The hasAccessoryName()
     * method will return false.
     */
    inline void clearAccessoryName();

    /**
     * Checks whether the field "AccessoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccessoryName()). Otherwise it will return false.
     */
    inline bool hasAccessoryName () const;

    /**
     * Returns the value of the member "AccessoryName".
     *
     * Additional name information e.g. alsa device name
     *
     * @return The value of the field "AccessoryName"
     */
    inline const ::std::string& getAccessoryName () const;

    /**
     * Retrieves the value of the field "AccessoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AccessoryName".
     */
    inline ::std::string& getAccessoryNameMutable ();

    /**
     * Sets the value of the member "AccessoryName".
     *
     * Additional name information e.g. alsa device name
     *
     * @param AccessoryName The value which will be set
     */
    inline void setAccessoryName (const ::std::string& AccessoryName_);

    /**
     * Sets the value of the member "AccessoryName".
     *
     * Additional name information e.g. alsa device name
     *
     * @param AccessoryName The value which will be set
     */
    inline void setAccessoryName (const char* AccessoryName_);

    /**
     * Sets the value of the member "AccessoryName".
     *
     * Additional name information e.g. alsa device name
     *
     * @param AccessoryName The value which will be set
     */
    inline void setAccessoryName (const char* value, size_t size);

    // API of field "DeviceName"

    static const int kDeviceName = 7;

    /**
     * Clears the field "DeviceName".
     *
     * The field will be set to its default value. The hasDeviceName()
     * method will return false.
     */
    inline void clearDeviceName();

    /**
     * Checks whether the field "DeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceName()). Otherwise it will return false.
     */
    inline bool hasDeviceName () const;

    /**
     * Returns the value of the member "DeviceName".
     *
     * The friendly name of the device inserted or removed from the system
     *
     * @return The value of the field "DeviceName"
     */
    inline const ::std::string& getDeviceName () const;

    /**
     * Retrieves the value of the field "DeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceName".
     */
    inline ::std::string& getDeviceNameMutable ();

    /**
     * Sets the value of the member "DeviceName".
     *
     * The friendly name of the device inserted or removed from the system
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const ::std::string& DeviceName_);

    /**
     * Sets the value of the member "DeviceName".
     *
     * The friendly name of the device inserted or removed from the system
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const char* DeviceName_);

    /**
     * Sets the value of the member "DeviceName".
     *
     * The friendly name of the device inserted or removed from the system
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const char* value, size_t size);

    // API of field "DeviceSerialNo"

    static const int kDeviceSerialNo = 8;

    /**
     * Clears the field "DeviceSerialNo".
     *
     * The field will be set to its default value. The hasDeviceSerialNo()
     * method will return false.
     */
    inline void clearDeviceSerialNo();

    /**
     * Checks whether the field "DeviceSerialNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceSerialNo()). Otherwise it will return false.
     */
    inline bool hasDeviceSerialNo () const;

    /**
     * Returns the value of the member "DeviceSerialNo".
     *
     * Serial number of the device connected.
     *
     * @return The value of the field "DeviceSerialNo"
     */
    inline const ::std::string& getDeviceSerialNo () const;

    /**
     * Retrieves the value of the field "DeviceSerialNo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceSerialNo".
     */
    inline ::std::string& getDeviceSerialNoMutable ();

    /**
     * Sets the value of the member "DeviceSerialNo".
     *
     * Serial number of the device connected.
     *
     * @param DeviceSerialNo The value which will be set
     */
    inline void setDeviceSerialNo (const ::std::string& DeviceSerialNo_);

    /**
     * Sets the value of the member "DeviceSerialNo".
     *
     * Serial number of the device connected.
     *
     * @param DeviceSerialNo The value which will be set
     */
    inline void setDeviceSerialNo (const char* DeviceSerialNo_);

    /**
     * Sets the value of the member "DeviceSerialNo".
     *
     * Serial number of the device connected.
     *
     * @param DeviceSerialNo The value which will be set
     */
    inline void setDeviceSerialNo (const char* value, size_t size);

    // API of field "DeviceVersion"

    static const int kDeviceVersion = 9;

    /**
     * Clears the field "DeviceVersion".
     *
     * The field will be set to its default value. The hasDeviceVersion()
     * method will return false.
     */
    inline void clearDeviceVersion();

    /**
     * Checks whether the field "DeviceVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceVersion()). Otherwise it will return false.
     */
    inline bool hasDeviceVersion () const;

    /**
     * Returns the value of the member "DeviceVersion".
     *
     * The version of the device inserted or removed from the system
     *
     * @return The value of the field "DeviceVersion"
     */
    inline const ::std::string& getDeviceVersion () const;

    /**
     * Retrieves the value of the field "DeviceVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceVersion".
     */
    inline ::std::string& getDeviceVersionMutable ();

    /**
     * Sets the value of the member "DeviceVersion".
     *
     * The version of the device inserted or removed from the system
     *
     * @param DeviceVersion The value which will be set
     */
    inline void setDeviceVersion (const ::std::string& DeviceVersion_);

    /**
     * Sets the value of the member "DeviceVersion".
     *
     * The version of the device inserted or removed from the system
     *
     * @param DeviceVersion The value which will be set
     */
    inline void setDeviceVersion (const char* DeviceVersion_);

    /**
     * Sets the value of the member "DeviceVersion".
     *
     * The version of the device inserted or removed from the system
     *
     * @param DeviceVersion The value which will be set
     */
    inline void setDeviceVersion (const char* value, size_t size);

    // API of field "Manufacturer"

    static const int kManufacturer = 10;

    /**
     * Clears the field "Manufacturer".
     *
     * The field will be set to its default value. The hasManufacturer()
     * method will return false.
     */
    inline void clearManufacturer();

    /**
     * Checks whether the field "Manufacturer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManufacturer()). Otherwise it will return false.
     */
    inline bool hasManufacturer () const;

    /**
     * Returns the value of the member "Manufacturer".
     *
     * Manufacturer of the device.
     *
     * @return The value of the field "Manufacturer"
     */
    inline const ::std::string& getManufacturer () const;

    /**
     * Retrieves the value of the field "Manufacturer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Manufacturer".
     */
    inline ::std::string& getManufacturerMutable ();

    /**
     * Sets the value of the member "Manufacturer".
     *
     * Manufacturer of the device.
     *
     * @param Manufacturer The value which will be set
     */
    inline void setManufacturer (const ::std::string& Manufacturer_);

    /**
     * Sets the value of the member "Manufacturer".
     *
     * Manufacturer of the device.
     *
     * @param Manufacturer The value which will be set
     */
    inline void setManufacturer (const char* Manufacturer_);

    /**
     * Sets the value of the member "Manufacturer".
     *
     * Manufacturer of the device.
     *
     * @param Manufacturer The value which will be set
     */
    inline void setManufacturer (const char* value, size_t size);

    // API of field "MountPoint"

    static const int kMountPoint = 11;

    /**
     * Clears the field "MountPoint".
     *
     * The field will be set to its default value. The hasMountPoint()
     * method will return false.
     */
    inline void clearMountPoint();

    /**
     * Checks whether the field "MountPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMountPoint()). Otherwise it will return false.
     */
    inline bool hasMountPoint () const;

    /**
     * Returns the value of the member "MountPoint".
     *
     * The path where the device has been mounted in the system
     *
     * @return The value of the field "MountPoint"
     */
    inline const ::std::string& getMountPoint () const;

    /**
     * Retrieves the value of the field "MountPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MountPoint".
     */
    inline ::std::string& getMountPointMutable ();

    /**
     * Sets the value of the member "MountPoint".
     *
     * The path where the device has been mounted in the system
     *
     * @param MountPoint The value which will be set
     */
    inline void setMountPoint (const ::std::string& MountPoint_);

    /**
     * Sets the value of the member "MountPoint".
     *
     * The path where the device has been mounted in the system
     *
     * @param MountPoint The value which will be set
     */
    inline void setMountPoint (const char* MountPoint_);

    /**
     * Sets the value of the member "MountPoint".
     *
     * The path where the device has been mounted in the system
     *
     * @param MountPoint The value which will be set
     */
    inline void setMountPoint (const char* value, size_t size);

    // API of field "USBPortNo"

    static const int kUSBPortNo = 12;

    /**
     * Clears the field "USBPortNo".
     *
     * The field will be set to its default value. The hasUSBPortNo()
     * method will return false.
     */
    inline void clearUSBPortNo();

    /**
     * Checks whether the field "USBPortNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBPortNo()). Otherwise it will return false.
     */
    inline bool hasUSBPortNo () const;

    /**
     * Returns the value of the member "USBPortNo".
     *
     * USB port number the device is connected to.
     *
     * @return The value of the field "USBPortNo"
     */
    inline const ::std::string& getUSBPortNo () const;

    /**
     * Retrieves the value of the field "USBPortNo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "USBPortNo".
     */
    inline ::std::string& getUSBPortNoMutable ();

    /**
     * Sets the value of the member "USBPortNo".
     *
     * USB port number the device is connected to.
     *
     * @param USBPortNo The value which will be set
     */
    inline void setUSBPortNo (const ::std::string& USBPortNo_);

    /**
     * Sets the value of the member "USBPortNo".
     *
     * USB port number the device is connected to.
     *
     * @param USBPortNo The value which will be set
     */
    inline void setUSBPortNo (const char* USBPortNo_);

    /**
     * Sets the value of the member "USBPortNo".
     *
     * USB port number the device is connected to.
     *
     * @param USBPortNo The value which will be set
     */
    inline void setUSBPortNo (const char* value, size_t size);

    // API of field "ProductID"

    static const int kProductID = 13;

    /**
     * Clears the field "ProductID".
     *
     * The field will be set to its default value. The hasProductID()
     * method will return false.
     */
    inline void clearProductID();

    /**
     * Checks whether the field "ProductID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductID()). Otherwise it will return false.
     */
    inline bool hasProductID () const;

    /**
     * Returns the value of the member "ProductID".
     *
     * Product ID of the device.
     *
     * @return The value of the field "ProductID"
     */
    inline uint16 getProductID () const;

    /**
     * Sets the value of the member "ProductID".
     *
     * Product ID of the device.
     *
     * @param ProductID The value which will be set
     */
    inline void setProductID (uint16 ProductID_);

    // API of field "VendorID"

    static const int kVendorID = 14;

    /**
     * Clears the field "VendorID".
     *
     * The field will be set to its default value. The hasVendorID()
     * method will return false.
     */
    inline void clearVendorID();

    /**
     * Checks whether the field "VendorID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVendorID()). Otherwise it will return false.
     */
    inline bool hasVendorID () const;

    /**
     * Returns the value of the member "VendorID".
     *
     * Vendor ID of the device.
     *
     * @return The value of the field "VendorID"
     */
    inline uint16 getVendorID () const;

    /**
     * Sets the value of the member "VendorID".
     *
     * Vendor ID of the device.
     *
     * @param VendorID The value which will be set
     */
    inline void setVendorID (uint16 VendorID_);

    // API of field "FreeSize_kB"

    static const int kFreeSize_kB = 15;

    /**
     * Clears the field "FreeSize_kB".
     *
     * The field will be set to its default value. The hasFreeSize_kB()
     * method will return false.
     */
    inline void clearFreeSize_kB();

    /**
     * Checks whether the field "FreeSize_kB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFreeSize_kB()). Otherwise it will return false.
     */
    inline bool hasFreeSize_kB () const;

    /**
     * Returns the value of the member "FreeSize_kB".
     *
     * free size in kB
     *
     * @return The value of the field "FreeSize_kB"
     */
    inline uint64 getFreeSize_kB () const;

    /**
     * Sets the value of the member "FreeSize_kB".
     *
     * free size in kB
     *
     * @param FreeSize_kB The value which will be set
     */
    inline void setFreeSize_kB (uint64 FreeSize_kB_);

    // API of field "TotalSize_kB"

    static const int kTotalSize_kB = 16;

    /**
     * Clears the field "TotalSize_kB".
     *
     * The field will be set to its default value. The hasTotalSize_kB()
     * method will return false.
     */
    inline void clearTotalSize_kB();

    /**
     * Checks whether the field "TotalSize_kB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalSize_kB()). Otherwise it will return false.
     */
    inline bool hasTotalSize_kB () const;

    /**
     * Returns the value of the member "TotalSize_kB".
     *
     * total size in kB
     *
     * @return The value of the field "TotalSize_kB"
     */
    inline uint64 getTotalSize_kB () const;

    /**
     * Sets the value of the member "TotalSize_kB".
     *
     * total size in kB
     *
     * @param TotalSize_kB The value which will be set
     */
    inline void setTotalSize_kB (uint64 TotalSize_kB_);

    // API of field "TotalSize"

    static const int kTotalSize = 17;

    /**
     * Clears the field "TotalSize".
     *
     * The field will be set to its default value. The hasTotalSize()
     * method will return false.
     */
    inline void clearTotalSize();

    /**
     * Checks whether the field "TotalSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalSize()). Otherwise it will return false.
     */
    inline bool hasTotalSize () const;

    /**
     * Returns the value of the member "TotalSize".
     *
     * Total size of the USB device in byte.
     *
     * @return The value of the field "TotalSize"
     */
    inline uint64 getTotalSize () const;

    /**
     * Sets the value of the member "TotalSize".
     *
     * Total size of the USB device in byte.
     *
     * @param TotalSize The value which will be set
     */
    inline void setTotalSize (uint64 TotalSize_);

    // API of field "UsedSize_kB"

    static const int kUsedSize_kB = 18;

    /**
     * Clears the field "UsedSize_kB".
     *
     * The field will be set to its default value. The hasUsedSize_kB()
     * method will return false.
     */
    inline void clearUsedSize_kB();

    /**
     * Checks whether the field "UsedSize_kB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUsedSize_kB()). Otherwise it will return false.
     */
    inline bool hasUsedSize_kB () const;

    /**
     * Returns the value of the member "UsedSize_kB".
     *
     * used size in kB
     *
     * @return The value of the field "UsedSize_kB"
     */
    inline uint64 getUsedSize_kB () const;

    /**
     * Sets the value of the member "UsedSize_kB".
     *
     * used size in kB
     *
     * @param UsedSize_kB The value which will be set
     */
    inline void setUsedSize_kB (uint64 UsedSize_kB_);

    // API of field "BaseClassCodeUsb"

    static const int kBaseClassCodeUsb = 19;

    /**
     * Clears the field "BaseClassCodeUsb".
     *
     * The field will be set to its default value. The hasBaseClassCodeUsb()
     * method will return false.
     */
    inline void clearBaseClassCodeUsb();

    /**
     * Checks whether the field "BaseClassCodeUsb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBaseClassCodeUsb()). Otherwise it will return false.
     */
    inline bool hasBaseClassCodeUsb () const;

    /**
     * Returns the value of the member "BaseClassCodeUsb".
     *
     * usb base class device
     *
     * @return The value of the field "BaseClassCodeUsb"
     */
    inline uint8 getBaseClassCodeUsb () const;

    /**
     * Sets the value of the member "BaseClassCodeUsb".
     *
     * usb base class device
     *
     * @param BaseClassCodeUsb The value which will be set
     */
    inline void setBaseClassCodeUsb (uint8 BaseClassCodeUsb_);

    // API of field "ParitionNum"

    static const int kParitionNum = 20;

    /**
     * Clears the field "ParitionNum".
     *
     * The field will be set to its default value. The hasParitionNum()
     * method will return false.
     */
    inline void clearParitionNum();

    /**
     * Checks whether the field "ParitionNum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParitionNum()). Otherwise it will return false.
     */
    inline bool hasParitionNum () const;

    /**
     * Returns the value of the member "ParitionNum".
     *
     * partition number. E.g. an USB device has different partitions for each parition anotification will be done
     *
     * @return The value of the field "ParitionNum"
     */
    inline uint8 getParitionNum () const;

    /**
     * Sets the value of the member "ParitionNum".
     *
     * partition number. E.g. an USB device has different partitions for each parition anotification will be done
     *
     * @param ParitionNum The value which will be set
     */
    inline void setParitionNum (uint8 ParitionNum_);

    // API of field "ProtocolUsb"

    static const int kProtocolUsb = 21;

    /**
     * Clears the field "ProtocolUsb".
     *
     * The field will be set to its default value. The hasProtocolUsb()
     * method will return false.
     */
    inline void clearProtocolUsb();

    /**
     * Checks whether the field "ProtocolUsb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProtocolUsb()). Otherwise it will return false.
     */
    inline bool hasProtocolUsb () const;

    /**
     * Returns the value of the member "ProtocolUsb".
     *
     * usb protocol like usb1.0, usb2.0
     *
     * @return The value of the field "ProtocolUsb"
     */
    inline uint8 getProtocolUsb () const;

    /**
     * Sets the value of the member "ProtocolUsb".
     *
     * usb protocol like usb1.0, usb2.0
     *
     * @param ProtocolUsb The value which will be set
     */
    inline void setProtocolUsb (uint8 ProtocolUsb_);

    // API of field "SubClassCodeUsb"

    static const int kSubClassCodeUsb = 22;

    /**
     * Clears the field "SubClassCodeUsb".
     *
     * The field will be set to its default value. The hasSubClassCodeUsb()
     * method will return false.
     */
    inline void clearSubClassCodeUsb();

    /**
     * Checks whether the field "SubClassCodeUsb" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubClassCodeUsb()). Otherwise it will return false.
     */
    inline bool hasSubClassCodeUsb () const;

    /**
     * Returns the value of the member "SubClassCodeUsb".
     *
     * usb base class device
     *
     * @return The value of the field "SubClassCodeUsb"
     */
    inline uint8 getSubClassCodeUsb () const;

    /**
     * Sets the value of the member "SubClassCodeUsb".
     *
     * usb base class device
     *
     * @param SubClassCodeUsb The value which will be set
     */
    inline void setSubClassCodeUsb (uint8 SubClassCodeUsb_);

    // API of field "DevicePath"

    static const int kDevicePath = 23;

    /**
     * Clears the field "DevicePath".
     *
     * The field will be set to its default value. The hasDevicePath()
     * method will return false.
     */
    inline void clearDevicePath();

    /**
     * Checks whether the field "DevicePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevicePath()). Otherwise it will return false.
     */
    inline bool hasDevicePath () const;

    /**
     * Returns the value of the member "DevicePath".
     *
     * DevicePath of the device connected(syspath)
     *
     * @return The value of the field "DevicePath"
     */
    inline const ::std::string& getDevicePath () const;

    /**
     * Retrieves the value of the field "DevicePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DevicePath".
     */
    inline ::std::string& getDevicePathMutable ();

    /**
     * Sets the value of the member "DevicePath".
     *
     * DevicePath of the device connected(syspath)
     *
     * @param DevicePath The value which will be set
     */
    inline void setDevicePath (const ::std::string& DevicePath_);

    /**
     * Sets the value of the member "DevicePath".
     *
     * DevicePath of the device connected(syspath)
     *
     * @param DevicePath The value which will be set
     */
    inline void setDevicePath (const char* DevicePath_);

    /**
     * Sets the value of the member "DevicePath".
     *
     * DevicePath of the device connected(syspath)
     *
     * @param DevicePath The value which will be set
     */
    inline void setDevicePath (const char* value, size_t size);

    // API of field "DeviceNode"

    static const int kDeviceNode = 24;

    /**
     * Clears the field "DeviceNode".
     *
     * The field will be set to its default value. The hasDeviceNode()
     * method will return false.
     */
    inline void clearDeviceNode();

    /**
     * Checks whether the field "DeviceNode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceNode()). Otherwise it will return false.
     */
    inline bool hasDeviceNode () const;

    /**
     * Returns the value of the member "DeviceNode".
     *
     * DeviceNode of the device connected
     *
     * @return The value of the field "DeviceNode"
     */
    inline const ::std::string& getDeviceNode () const;

    /**
     * Retrieves the value of the field "DeviceNode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceNode".
     */
    inline ::std::string& getDeviceNodeMutable ();

    /**
     * Sets the value of the member "DeviceNode".
     *
     * DeviceNode of the device connected
     *
     * @param DeviceNode The value which will be set
     */
    inline void setDeviceNode (const ::std::string& DeviceNode_);

    /**
     * Sets the value of the member "DeviceNode".
     *
     * DeviceNode of the device connected
     *
     * @param DeviceNode The value which will be set
     */
    inline void setDeviceNode (const char* DeviceNode_);

    /**
     * Sets the value of the member "DeviceNode".
     *
     * DeviceNode of the device connected
     *
     * @param DeviceNode The value which will be set
     */
    inline void setDeviceNode (const char* value, size_t size);

    static const T_DevManager_DeviceProperty &getDefaultInstance();

private:

    inline void set_has_DeviceConnectStatus ();

    inline void clear_has_DeviceConnectStatus ();

    inline void set_has_DeviceType ();

    inline void clear_has_DeviceType ();

    inline void set_has_DeviceSpeedUsb ();

    inline void clear_has_DeviceSpeedUsb ();

    inline void set_has_UnsupportedReason ();

    inline void clear_has_UnsupportedReason ();

    inline void set_has_FileSystemType ();

    inline void clear_has_FileSystemType ();

    inline void set_has_AccessoryName2 ();

    inline void clear_has_AccessoryName2 ();

    inline void set_has_AccessoryName ();

    inline void clear_has_AccessoryName ();

    inline void set_has_DeviceName ();

    inline void clear_has_DeviceName ();

    inline void set_has_DeviceSerialNo ();

    inline void clear_has_DeviceSerialNo ();

    inline void set_has_DeviceVersion ();

    inline void clear_has_DeviceVersion ();

    inline void set_has_Manufacturer ();

    inline void clear_has_Manufacturer ();

    inline void set_has_MountPoint ();

    inline void clear_has_MountPoint ();

    inline void set_has_USBPortNo ();

    inline void clear_has_USBPortNo ();

    inline void set_has_ProductID ();

    inline void clear_has_ProductID ();

    inline void set_has_VendorID ();

    inline void clear_has_VendorID ();

    inline void set_has_FreeSize_kB ();

    inline void clear_has_FreeSize_kB ();

    inline void set_has_TotalSize_kB ();

    inline void clear_has_TotalSize_kB ();

    inline void set_has_TotalSize ();

    inline void clear_has_TotalSize ();

    inline void set_has_UsedSize_kB ();

    inline void clear_has_UsedSize_kB ();

    inline void set_has_BaseClassCodeUsb ();

    inline void clear_has_BaseClassCodeUsb ();

    inline void set_has_ParitionNum ();

    inline void clear_has_ParitionNum ();

    inline void set_has_ProtocolUsb ();

    inline void clear_has_ProtocolUsb ();

    inline void set_has_SubClassCodeUsb ();

    inline void clear_has_SubClassCodeUsb ();

    inline void set_has_DevicePath ();

    inline void clear_has_DevicePath ();

    inline void set_has_DeviceNode ();

    inline void clear_has_DeviceNode ();

    uint32 _has_bits_[ (25 + 31) / 32];

    T_e8_DeviceConnectStatus _DeviceConnectStatus;

    T_e8_Device _DeviceType;

    T_e8_DVM_DeviceSpeedUsb _DeviceSpeedUsb;

    T_e8_DVM_UnsupportedReason _UnsupportedReason;

    T_e8_FileSystem _FileSystemType;

    ::std::string _AccessoryName2;

    ::std::string _AccessoryName;

    ::std::string _DeviceName;

    ::std::string _DeviceSerialNo;

    ::std::string _DeviceVersion;

    ::std::string _Manufacturer;

    ::std::string _MountPoint;

    ::std::string _USBPortNo;

    uint16 _ProductID;

    uint16 _VendorID;

    uint64 _FreeSize_kB;

    uint64 _TotalSize_kB;

    uint64 _TotalSize;

    uint64 _UsedSize_kB;

    uint8 _BaseClassCodeUsb;

    uint8 _ParitionNum;

    uint8 _ProtocolUsb;

    uint8 _SubClassCodeUsb;

    ::std::string _DevicePath;

    ::std::string _DeviceNode;

};

/**
 * Contains information about physical usb ports.
 */
class T_DevManager_PortStates {
public:

    /**
     * Default constructor
     */
    inline  T_DevManager_PortStates ();

    /**
     * Copy constructor
     */
    inline  T_DevManager_PortStates (const T_DevManager_PortStates &rhs);

    /**
     * All fields constructor
     */
    inline  T_DevManager_PortStates (bool ElectricalFailure_, bool HubConnected_, bool OpenCircuit_, bool OverCurrent_, bool UnderVoltage_, bool USBPortConfiguredUsed_, bool USBPowerON_, uint8 USBPortNo_);

    /**
     * Destructor
     */
    inline  ~T_DevManager_PortStates();

    /**
     * Assignment operator
     */
    inline T_DevManager_PortStates& operator = (const T_DevManager_PortStates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DevManager_PortStates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DevManager_PortStates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DevManager_PortStates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DevManager_PortStates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ElectricalFailure"

    static const int kElectricalFailure = 0;

    /**
     * Clears the field "ElectricalFailure".
     *
     * The field will be set to its default value. The hasElectricalFailure()
     * method will return false.
     */
    inline void clearElectricalFailure();

    /**
     * Checks whether the field "ElectricalFailure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElectricalFailure()). Otherwise it will return false.
     */
    inline bool hasElectricalFailure () const;

    /**
     * Returns the value of the member "ElectricalFailure".
     *
     * Is electrical failure at Usb port
     *
     * @return The value of the field "ElectricalFailure"
     */
    inline bool getElectricalFailure () const;

    /**
     * Sets the value of the member "ElectricalFailure".
     *
     * Is electrical failure at Usb port
     *
     * @param ElectricalFailure The value which will be set
     */
    inline void setElectricalFailure (bool ElectricalFailure_);

    // API of field "HubConnected"

    static const int kHubConnected = 1;

    /**
     * Clears the field "HubConnected".
     *
     * The field will be set to its default value. The hasHubConnected()
     * method will return false.
     */
    inline void clearHubConnected();

    /**
     * Checks whether the field "HubConnected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHubConnected()). Otherwise it will return false.
     */
    inline bool hasHubConnected () const;

    /**
     * Returns the value of the member "HubConnected".
     *
     * Shows if HUB should be connected. E.g. customer uses build-in-HUB and thus has enabled this in configuration
     *
     * @return The value of the field "HubConnected"
     */
    inline bool getHubConnected () const;

    /**
     * Sets the value of the member "HubConnected".
     *
     * Shows if HUB should be connected. E.g. customer uses build-in-HUB and thus has enabled this in configuration
     *
     * @param HubConnected The value which will be set
     */
    inline void setHubConnected (bool HubConnected_);

    // API of field "OpenCircuit"

    static const int kOpenCircuit = 2;

    /**
     * Clears the field "OpenCircuit".
     *
     * The field will be set to its default value. The hasOpenCircuit()
     * method will return false.
     */
    inline void clearOpenCircuit();

    /**
     * Checks whether the field "OpenCircuit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOpenCircuit()). Otherwise it will return false.
     */
    inline bool hasOpenCircuit () const;

    /**
     * Returns the value of the member "OpenCircuit".
     *
     * if customer is using a build-in-HUB (i.e. depends on 'HubConnected') on a port VD_DeviceManager checks if open circuit. if customer is using a BTA(Box Telematic Automatic) or TCU device on a port VD_DeviceManager checks if open circuit. Alternative in Discussion: Voltage controlled USB ports. I.e. voltage output measurable at USBport (user port e.g. including cable).
     *
     * @return The value of the field "OpenCircuit"
     */
    inline bool getOpenCircuit () const;

    /**
     * Sets the value of the member "OpenCircuit".
     *
     * if customer is using a build-in-HUB (i.e. depends on 'HubConnected') on a port VD_DeviceManager checks if open circuit. if customer is using a BTA(Box Telematic Automatic) or TCU device on a port VD_DeviceManager checks if open circuit. Alternative in Discussion: Voltage controlled USB ports. I.e. voltage output measurable at USBport (user port e.g. including cable).
     *
     * @param OpenCircuit The value which will be set
     */
    inline void setOpenCircuit (bool OpenCircuit_);

    // API of field "OverCurrent"

    static const int kOverCurrent = 3;

    /**
     * Clears the field "OverCurrent".
     *
     * The field will be set to its default value. The hasOverCurrent()
     * method will return false.
     */
    inline void clearOverCurrent();

    /**
     * Checks whether the field "OverCurrent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOverCurrent()). Otherwise it will return false.
     */
    inline bool hasOverCurrent () const;

    /**
     * Returns the value of the member "OverCurrent".
     *
     * Is over current at Usb port (depricated replaced by ElectricalFailure)
     *
     * @return The value of the field "OverCurrent"
     */
    inline bool getOverCurrent () const;

    /**
     * Sets the value of the member "OverCurrent".
     *
     * Is over current at Usb port (depricated replaced by ElectricalFailure)
     *
     * @param OverCurrent The value which will be set
     */
    inline void setOverCurrent (bool OverCurrent_);

    // API of field "UnderVoltage"

    static const int kUnderVoltage = 4;

    /**
     * Clears the field "UnderVoltage".
     *
     * The field will be set to its default value. The hasUnderVoltage()
     * method will return false.
     */
    inline void clearUnderVoltage();

    /**
     * Checks whether the field "UnderVoltage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnderVoltage()). Otherwise it will return false.
     */
    inline bool hasUnderVoltage () const;

    /**
     * Returns the value of the member "UnderVoltage".
     *
     * Is under voltage at this port
     *
     * @return The value of the field "UnderVoltage"
     */
    inline bool getUnderVoltage () const;

    /**
     * Sets the value of the member "UnderVoltage".
     *
     * Is under voltage at this port
     *
     * @param UnderVoltage The value which will be set
     */
    inline void setUnderVoltage (bool UnderVoltage_);

    // API of field "USBPortConfiguredUsed"

    static const int kUSBPortConfiguredUsed = 5;

    /**
     * Clears the field "USBPortConfiguredUsed".
     *
     * The field will be set to its default value. The hasUSBPortConfiguredUsed()
     * method will return false.
     */
    inline void clearUSBPortConfiguredUsed();

    /**
     * Checks whether the field "USBPortConfiguredUsed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBPortConfiguredUsed()). Otherwise it will return false.
     */
    inline bool hasUSBPortConfiguredUsed () const;

    /**
     * Returns the value of the member "USBPortConfiguredUsed".
     *
     * if USB Port is configured to be used
     *
     * @return The value of the field "USBPortConfiguredUsed"
     */
    inline bool getUSBPortConfiguredUsed () const;

    /**
     * Sets the value of the member "USBPortConfiguredUsed".
     *
     * if USB Port is configured to be used
     *
     * @param USBPortConfiguredUsed The value which will be set
     */
    inline void setUSBPortConfiguredUsed (bool USBPortConfiguredUsed_);

    // API of field "USBPowerON"

    static const int kUSBPowerON = 6;

    /**
     * Clears the field "USBPowerON".
     *
     * The field will be set to its default value. The hasUSBPowerON()
     * method will return false.
     */
    inline void clearUSBPowerON();

    /**
     * Checks whether the field "USBPowerON" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBPowerON()). Otherwise it will return false.
     */
    inline bool hasUSBPowerON () const;

    /**
     * Returns the value of the member "USBPowerON".
     *
     * if Power is ON at USB port
     *
     * @return The value of the field "USBPowerON"
     */
    inline bool getUSBPowerON () const;

    /**
     * Sets the value of the member "USBPowerON".
     *
     * if Power is ON at USB port
     *
     * @param USBPowerON The value which will be set
     */
    inline void setUSBPowerON (bool USBPowerON_);

    // API of field "USBPortNo"

    static const int kUSBPortNo = 7;

    /**
     * Clears the field "USBPortNo".
     *
     * The field will be set to its default value. The hasUSBPortNo()
     * method will return false.
     */
    inline void clearUSBPortNo();

    /**
     * Checks whether the field "USBPortNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBPortNo()). Otherwise it will return false.
     */
    inline bool hasUSBPortNo () const;

    /**
     * Returns the value of the member "USBPortNo".
     *
     * USB port number the device is connected to. First port has Port no. = 1 (not 0)
     *
     * @return The value of the field "USBPortNo"
     */
    inline uint8 getUSBPortNo () const;

    /**
     * Sets the value of the member "USBPortNo".
     *
     * USB port number the device is connected to. First port has Port no. = 1 (not 0)
     *
     * @param USBPortNo The value which will be set
     */
    inline void setUSBPortNo (uint8 USBPortNo_);

    static const T_DevManager_PortStates &getDefaultInstance();

private:

    inline void set_has_ElectricalFailure ();

    inline void clear_has_ElectricalFailure ();

    inline void set_has_HubConnected ();

    inline void clear_has_HubConnected ();

    inline void set_has_OpenCircuit ();

    inline void clear_has_OpenCircuit ();

    inline void set_has_OverCurrent ();

    inline void clear_has_OverCurrent ();

    inline void set_has_UnderVoltage ();

    inline void clear_has_UnderVoltage ();

    inline void set_has_USBPortConfiguredUsed ();

    inline void clear_has_USBPortConfiguredUsed ();

    inline void set_has_USBPowerON ();

    inline void clear_has_USBPowerON ();

    inline void set_has_USBPortNo ();

    inline void clear_has_USBPortNo ();

    uint32 _has_bits_[ (8 + 31) / 32];

    bool _ElectricalFailure;

    bool _HubConnected;

    bool _OpenCircuit;

    bool _OverCurrent;

    bool _UnderVoltage;

    bool _USBPortConfiguredUsed;

    bool _USBPowerON;

    uint8 _USBPortNo;

};

/**
 * Gives all available information for a SD Card
 */
class T_DevManager_SDCardInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DevManager_SDCardInfo ();

    /**
     * Copy constructor
     */
    inline  T_DevManager_SDCardInfo (const T_DevManager_SDCardInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DevManager_SDCardInfo (const T_DVM_CardIdentifierRegister& CardIdentifierRegister_, T_e8_DVM_MediaState SDCardState_, T_e8_DVM_MediaType SDCardMedia_, T_e8_PowerStatus PowerStatus_, bool HW_WriteProtected_, bool Mounted_, bool SW_WriteProtected_, const ::std::string& MountPoint_, uint32 DeviceSerialNo_, uint64 TotalSize_, uint8 DevManufactureId_, uint8 DevSpecVersion_, uint8 SDCardSlot_);

    /**
     * Destructor
     */
    inline  ~T_DevManager_SDCardInfo();

    /**
     * Assignment operator
     */
    inline T_DevManager_SDCardInfo& operator = (const T_DevManager_SDCardInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DevManager_SDCardInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DevManager_SDCardInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DevManager_SDCardInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DevManager_SDCardInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CardIdentifierRegister"

    static const int kCardIdentifierRegister = 0;

    /**
     * Clears the field "CardIdentifierRegister".
     *
     * The field will be set to its default value. The hasCardIdentifierRegister()
     * method will return false.
     */
    inline void clearCardIdentifierRegister();

    /**
     * Checks whether the field "CardIdentifierRegister" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCardIdentifierRegister()). Otherwise it will return false.
     */
    inline bool hasCardIdentifierRegister () const;

    /**
     * Returns the value of the member "CardIdentifierRegister".
     *
     * List of tU8 (an Array of 16 tU8) for CID(Card Identifier).
     *
     * @return The value of the field "CardIdentifierRegister"
     */
    inline const T_DVM_CardIdentifierRegister& getCardIdentifierRegister () const;

    /**
     * Retrieves the value of the field "CardIdentifierRegister" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CardIdentifierRegister".
     */
    inline T_DVM_CardIdentifierRegister& getCardIdentifierRegisterMutable ();

    /**
     * Sets the value of the member "CardIdentifierRegister".
     *
     * List of tU8 (an Array of 16 tU8) for CID(Card Identifier).
     *
     * @param CardIdentifierRegister The value which will be set
     */
    inline void setCardIdentifierRegister (const T_DVM_CardIdentifierRegister& CardIdentifierRegister_);

    // API of field "SDCardState"

    static const int kSDCardState = 1;

    /**
     * Clears the field "SDCardState".
     *
     * The field will be set to its default value. The hasSDCardState()
     * method will return false.
     */
    inline void clearSDCardState();

    /**
     * Checks whether the field "SDCardState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDCardState()). Otherwise it will return false.
     */
    inline bool hasSDCardState () const;

    /**
     * Returns the value of the member "SDCardState".
     *
     * Media state of the SD Card device. Could be MEDIA_READY or MEDIA_NOT_REDAY. If a SD Card is inserted the state is MEDIA_READY. Else: the inserted SD Card is incorrect.
     *
     * @return The value of the field "SDCardState"
     */
    inline T_e8_DVM_MediaState getSDCardState () const;

    /**
     * Sets the value of the member "SDCardState".
     *
     * Media state of the SD Card device. Could be MEDIA_READY or MEDIA_NOT_REDAY. If a SD Card is inserted the state is MEDIA_READY. Else: the inserted SD Card is incorrect.
     *
     * @param SDCardState The value which will be set
     */
    inline void setSDCardState (T_e8_DVM_MediaState SDCardState_);

    // API of field "SDCardMedia"

    static const int kSDCardMedia = 2;

    /**
     * Clears the field "SDCardMedia".
     *
     * The field will be set to its default value. The hasSDCardMedia()
     * method will return false.
     */
    inline void clearSDCardMedia();

    /**
     * Checks whether the field "SDCardMedia" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDCardMedia()). Otherwise it will return false.
     */
    inline bool hasSDCardMedia () const;

    /**
     * Returns the value of the member "SDCardMedia".
     *
     * Media type of the SD Card device. Could be MEDIA_EJECTED, INCORRECT_MEDIA, DATA_MEDIA, UNKNOWN_MEDIA.
     *
     * @return The value of the field "SDCardMedia"
     */
    inline T_e8_DVM_MediaType getSDCardMedia () const;

    /**
     * Sets the value of the member "SDCardMedia".
     *
     * Media type of the SD Card device. Could be MEDIA_EJECTED, INCORRECT_MEDIA, DATA_MEDIA, UNKNOWN_MEDIA.
     *
     * @param SDCardMedia The value which will be set
     */
    inline void setSDCardMedia (T_e8_DVM_MediaType SDCardMedia_);

    // API of field "PowerStatus"

    static const int kPowerStatus = 3;

    /**
     * Clears the field "PowerStatus".
     *
     * The field will be set to its default value. The hasPowerStatus()
     * method will return false.
     */
    inline void clearPowerStatus();

    /**
     * Checks whether the field "PowerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerStatus()). Otherwise it will return false.
     */
    inline bool hasPowerStatus () const;

    /**
     * Returns the value of the member "PowerStatus".
     *
     * Power status of SD Card power supply.
     *
     * @return The value of the field "PowerStatus"
     */
    inline T_e8_PowerStatus getPowerStatus () const;

    /**
     * Sets the value of the member "PowerStatus".
     *
     * Power status of SD Card power supply.
     *
     * @param PowerStatus The value which will be set
     */
    inline void setPowerStatus (T_e8_PowerStatus PowerStatus_);

    // API of field "HW_WriteProtected"

    static const int kHW_WriteProtected = 4;

    /**
     * Clears the field "HW_WriteProtected".
     *
     * The field will be set to its default value. The hasHW_WriteProtected()
     * method will return false.
     */
    inline void clearHW_WriteProtected();

    /**
     * Checks whether the field "HW_WriteProtected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHW_WriteProtected()). Otherwise it will return false.
     */
    inline bool hasHW_WriteProtected () const;

    /**
     * Returns the value of the member "HW_WriteProtected".
     *
     * Gives the HardWare Write Protection Status of the device.
     *
     * @return The value of the field "HW_WriteProtected"
     */
    inline bool getHW_WriteProtected () const;

    /**
     * Sets the value of the member "HW_WriteProtected".
     *
     * Gives the HardWare Write Protection Status of the device.
     *
     * @param HW_WriteProtected The value which will be set
     */
    inline void setHW_WriteProtected (bool HW_WriteProtected_);

    // API of field "Mounted"

    static const int kMounted = 5;

    /**
     * Clears the field "Mounted".
     *
     * The field will be set to its default value. The hasMounted()
     * method will return false.
     */
    inline void clearMounted();

    /**
     * Checks whether the field "Mounted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMounted()). Otherwise it will return false.
     */
    inline bool hasMounted () const;

    /**
     * Returns the value of the member "Mounted".
     *
     * Gives the mount state of the device.
     * <p>TRUE : Mounted , FALSE : Not Mounted</p>
     *
     * @return The value of the field "Mounted"
     */
    inline bool getMounted () const;

    /**
     * Sets the value of the member "Mounted".
     *
     * Gives the mount state of the device.
     * <p>TRUE : Mounted , FALSE : Not Mounted</p>
     *
     * @param Mounted The value which will be set
     */
    inline void setMounted (bool Mounted_);

    // API of field "SW_WriteProtected"

    static const int kSW_WriteProtected = 6;

    /**
     * Clears the field "SW_WriteProtected".
     *
     * The field will be set to its default value. The hasSW_WriteProtected()
     * method will return false.
     */
    inline void clearSW_WriteProtected();

    /**
     * Checks whether the field "SW_WriteProtected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSW_WriteProtected()). Otherwise it will return false.
     */
    inline bool hasSW_WriteProtected () const;

    /**
     * Returns the value of the member "SW_WriteProtected".
     *
     * Gives the Software Write Protection Status of the device.
     *
     * @return The value of the field "SW_WriteProtected"
     */
    inline bool getSW_WriteProtected () const;

    /**
     * Sets the value of the member "SW_WriteProtected".
     *
     * Gives the Software Write Protection Status of the device.
     *
     * @param SW_WriteProtected The value which will be set
     */
    inline void setSW_WriteProtected (bool SW_WriteProtected_);

    // API of field "MountPoint"

    static const int kMountPoint = 7;

    /**
     * Clears the field "MountPoint".
     *
     * The field will be set to its default value. The hasMountPoint()
     * method will return false.
     */
    inline void clearMountPoint();

    /**
     * Checks whether the field "MountPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMountPoint()). Otherwise it will return false.
     */
    inline bool hasMountPoint () const;

    /**
     * Returns the value of the member "MountPoint".
     *
     * The path where the device has been mounted in the system.
     * <p>Normaly /dev/card for the first card.</p>
     *
     * @return The value of the field "MountPoint"
     */
    inline const ::std::string& getMountPoint () const;

    /**
     * Retrieves the value of the field "MountPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MountPoint".
     */
    inline ::std::string& getMountPointMutable ();

    /**
     * Sets the value of the member "MountPoint".
     *
     * The path where the device has been mounted in the system.
     * <p>Normaly /dev/card for the first card.</p>
     *
     * @param MountPoint The value which will be set
     */
    inline void setMountPoint (const ::std::string& MountPoint_);

    /**
     * Sets the value of the member "MountPoint".
     *
     * The path where the device has been mounted in the system.
     * <p>Normaly /dev/card for the first card.</p>
     *
     * @param MountPoint The value which will be set
     */
    inline void setMountPoint (const char* MountPoint_);

    /**
     * Sets the value of the member "MountPoint".
     *
     * The path where the device has been mounted in the system.
     * <p>Normaly /dev/card for the first card.</p>
     *
     * @param MountPoint The value which will be set
     */
    inline void setMountPoint (const char* value, size_t size);

    // API of field "DeviceSerialNo"

    static const int kDeviceSerialNo = 8;

    /**
     * Clears the field "DeviceSerialNo".
     *
     * The field will be set to its default value. The hasDeviceSerialNo()
     * method will return false.
     */
    inline void clearDeviceSerialNo();

    /**
     * Checks whether the field "DeviceSerialNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceSerialNo()). Otherwise it will return false.
     */
    inline bool hasDeviceSerialNo () const;

    /**
     * Returns the value of the member "DeviceSerialNo".
     *
     * <p>0xFFFF FFFF if device not available.</p>
     * <p>Device Serial Number.</p>
     *
     * @return The value of the field "DeviceSerialNo"
     */
    inline uint32 getDeviceSerialNo () const;

    /**
     * Sets the value of the member "DeviceSerialNo".
     *
     * <p>0xFFFF FFFF if device not available.</p>
     * <p>Device Serial Number.</p>
     *
     * @param DeviceSerialNo The value which will be set
     */
    inline void setDeviceSerialNo (uint32 DeviceSerialNo_);

    // API of field "TotalSize"

    static const int kTotalSize = 9;

    /**
     * Clears the field "TotalSize".
     *
     * The field will be set to its default value. The hasTotalSize()
     * method will return false.
     */
    inline void clearTotalSize();

    /**
     * Checks whether the field "TotalSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalSize()). Otherwise it will return false.
     */
    inline bool hasTotalSize () const;

    /**
     * Returns the value of the member "TotalSize".
     *
     * <p>0xFFFF FFFF FFFF FFFF if the device not available.</p>
     * <p>Total size of the SD Card. Taken from the SD Card register. The available size could be different.</p>
     *
     * @return The value of the field "TotalSize"
     */
    inline uint64 getTotalSize () const;

    /**
     * Sets the value of the member "TotalSize".
     *
     * <p>0xFFFF FFFF FFFF FFFF if the device not available.</p>
     * <p>Total size of the SD Card. Taken from the SD Card register. The available size could be different.</p>
     *
     * @param TotalSize The value which will be set
     */
    inline void setTotalSize (uint64 TotalSize_);

    // API of field "DevManufactureId"

    static const int kDevManufactureId = 10;

    /**
     * Clears the field "DevManufactureId".
     *
     * The field will be set to its default value. The hasDevManufactureId()
     * method will return false.
     */
    inline void clearDevManufactureId();

    /**
     * Checks whether the field "DevManufactureId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevManufactureId()). Otherwise it will return false.
     */
    inline bool hasDevManufactureId () const;

    /**
     * Returns the value of the member "DevManufactureId".
     *
     * <p>0xFF if device not available.</p>
     * <p>Device ManufactureId.</p>
     *
     * @return The value of the field "DevManufactureId"
     */
    inline uint8 getDevManufactureId () const;

    /**
     * Sets the value of the member "DevManufactureId".
     *
     * <p>0xFF if device not available.</p>
     * <p>Device ManufactureId.</p>
     *
     * @param DevManufactureId The value which will be set
     */
    inline void setDevManufactureId (uint8 DevManufactureId_);

    // API of field "DevSpecVersion"

    static const int kDevSpecVersion = 11;

    /**
     * Clears the field "DevSpecVersion".
     *
     * The field will be set to its default value. The hasDevSpecVersion()
     * method will return false.
     */
    inline void clearDevSpecVersion();

    /**
     * Checks whether the field "DevSpecVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevSpecVersion()). Otherwise it will return false.
     */
    inline bool hasDevSpecVersion () const;

    /**
     * Returns the value of the member "DevSpecVersion".
     *
     * Gives Device Specification version.
     * <p>0 : 1.0 - 1.2</p>
     * <p>0xFF corresponds to the error case (card not recognized).</p>
     * <p>1 : 1.4</p>
     * <p>128 : 1.0 - 1.01</p>
     * <p>129 : 1.10</p>
     * <p>130 : 2.0</p>
     * <p>2 : 2.0 to 2.2</p>
     * <p>3 : 3.1</p>
     * <p>MMC:</p>
     * <p>SDCard:</p>
     *
     * @return The value of the field "DevSpecVersion"
     */
    inline uint8 getDevSpecVersion () const;

    /**
     * Sets the value of the member "DevSpecVersion".
     *
     * Gives Device Specification version.
     * <p>0 : 1.0 - 1.2</p>
     * <p>0xFF corresponds to the error case (card not recognized).</p>
     * <p>1 : 1.4</p>
     * <p>128 : 1.0 - 1.01</p>
     * <p>129 : 1.10</p>
     * <p>130 : 2.0</p>
     * <p>2 : 2.0 to 2.2</p>
     * <p>3 : 3.1</p>
     * <p>MMC:</p>
     * <p>SDCard:</p>
     *
     * @param DevSpecVersion The value which will be set
     */
    inline void setDevSpecVersion (uint8 DevSpecVersion_);

    // API of field "SDCardSlot"

    static const int kSDCardSlot = 12;

    /**
     * Clears the field "SDCardSlot".
     *
     * The field will be set to its default value. The hasSDCardSlot()
     * method will return false.
     */
    inline void clearSDCardSlot();

    /**
     * Checks whether the field "SDCardSlot" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDCardSlot()). Otherwise it will return false.
     */
    inline bool hasSDCardSlot () const;

    /**
     * Returns the value of the member "SDCardSlot".
     *
     * SD Card slot number. Starting with 1 for Navigation SD Card.
     *
     * @return The value of the field "SDCardSlot"
     */
    inline uint8 getSDCardSlot () const;

    /**
     * Sets the value of the member "SDCardSlot".
     *
     * SD Card slot number. Starting with 1 for Navigation SD Card.
     *
     * @param SDCardSlot The value which will be set
     */
    inline void setSDCardSlot (uint8 SDCardSlot_);

    static const T_DevManager_SDCardInfo &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_CardIdentifierRegister ();

    inline void clear_has_CardIdentifierRegister ();

    inline void set_has_SDCardState ();

    inline void clear_has_SDCardState ();

    inline void set_has_SDCardMedia ();

    inline void clear_has_SDCardMedia ();

    inline void set_has_PowerStatus ();

    inline void clear_has_PowerStatus ();

    inline void set_has_HW_WriteProtected ();

    inline void clear_has_HW_WriteProtected ();

    inline void set_has_Mounted ();

    inline void clear_has_Mounted ();

    inline void set_has_SW_WriteProtected ();

    inline void clear_has_SW_WriteProtected ();

    inline void set_has_MountPoint ();

    inline void clear_has_MountPoint ();

    inline void set_has_DeviceSerialNo ();

    inline void clear_has_DeviceSerialNo ();

    inline void set_has_TotalSize ();

    inline void clear_has_TotalSize ();

    inline void set_has_DevManufactureId ();

    inline void clear_has_DevManufactureId ();

    inline void set_has_DevSpecVersion ();

    inline void clear_has_DevSpecVersion ();

    inline void set_has_SDCardSlot ();

    inline void clear_has_SDCardSlot ();

    uint32 _has_bits_[ (13 + 31) / 32];

    T_DVM_CardIdentifierRegister _CardIdentifierRegister;

    T_e8_DVM_MediaState _SDCardState;

    T_e8_DVM_MediaType _SDCardMedia;

    T_e8_PowerStatus _PowerStatus;

    bool _HW_WriteProtected;

    bool _Mounted;

    bool _SW_WriteProtected;

    ::std::string _MountPoint;

    uint32 _DeviceSerialNo;

    uint64 _TotalSize;

    uint8 _DevManufactureId;

    uint8 _DevSpecVersion;

    uint8 _SDCardSlot;

};

inline  T_DevManager_DeviceProperty::T_DevManager_DeviceProperty ()  :
    _DeviceConnectStatus (::mplay_devicemanager_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED),
    _DeviceType (::mplay_devicemanager_fi_types::T_e8_Device__DTY_BTA),
    _DeviceSpeedUsb (::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb__FULL_SPEED),
    _UnsupportedReason (::mplay_devicemanager_fi_types::T_e8_DVM_UnsupportedReason__DisabledInConfiguration),
    _FileSystemType (::mplay_devicemanager_fi_types::T_e8_FileSystem__FSTY_EXFAT),
    _AccessoryName2 (),
    _AccessoryName (),
    _DeviceName (),
    _DeviceSerialNo (),
    _DeviceVersion (),
    _Manufacturer (),
    _MountPoint (),
    _USBPortNo (),
    _ProductID (0u),
    _VendorID (0u),
    _FreeSize_kB (0u),
    _TotalSize_kB (0u),
    _TotalSize (0u),
    _UsedSize_kB (0u),
    _BaseClassCodeUsb (0u),
    _ParitionNum (0u),
    _ProtocolUsb (0u),
    _SubClassCodeUsb (0u),
    _DevicePath (),
    _DeviceNode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DevManager_DeviceProperty::T_DevManager_DeviceProperty (const T_DevManager_DeviceProperty &rhs)  :
    _DeviceConnectStatus (::mplay_devicemanager_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED),
    _DeviceType (::mplay_devicemanager_fi_types::T_e8_Device__DTY_BTA),
    _DeviceSpeedUsb (::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb__FULL_SPEED),
    _UnsupportedReason (::mplay_devicemanager_fi_types::T_e8_DVM_UnsupportedReason__DisabledInConfiguration),
    _FileSystemType (::mplay_devicemanager_fi_types::T_e8_FileSystem__FSTY_EXFAT),
    _AccessoryName2 (),
    _AccessoryName (),
    _DeviceName (),
    _DeviceSerialNo (),
    _DeviceVersion (),
    _Manufacturer (),
    _MountPoint (),
    _USBPortNo (),
    _ProductID (0u),
    _VendorID (0u),
    _FreeSize_kB (0u),
    _TotalSize_kB (0u),
    _TotalSize (0u),
    _UsedSize_kB (0u),
    _BaseClassCodeUsb (0u),
    _ParitionNum (0u),
    _ProtocolUsb (0u),
    _SubClassCodeUsb (0u),
    _DevicePath (),
    _DeviceNode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DevManager_DeviceProperty::T_DevManager_DeviceProperty (T_e8_DeviceConnectStatus DeviceConnectStatus_, T_e8_Device DeviceType_, T_e8_DVM_DeviceSpeedUsb DeviceSpeedUsb_, T_e8_DVM_UnsupportedReason UnsupportedReason_, T_e8_FileSystem FileSystemType_, const ::std::string& AccessoryName2_, const ::std::string& AccessoryName_, const ::std::string& DeviceName_, const ::std::string& DeviceSerialNo_, const ::std::string& DeviceVersion_, const ::std::string& Manufacturer_, const ::std::string& MountPoint_, const ::std::string& USBPortNo_, uint16 ProductID_, uint16 VendorID_, uint64 FreeSize_kB_, uint64 TotalSize_kB_, uint64 TotalSize_, uint64 UsedSize_kB_, uint8 BaseClassCodeUsb_, uint8 ParitionNum_, uint8 ProtocolUsb_, uint8 SubClassCodeUsb_, const ::std::string& DevicePath_, const ::std::string& DeviceNode_)  :
    _DeviceConnectStatus (DeviceConnectStatus_),
    _DeviceType (DeviceType_),
    _DeviceSpeedUsb (DeviceSpeedUsb_),
    _UnsupportedReason (UnsupportedReason_),
    _FileSystemType (FileSystemType_),
    _AccessoryName2 (AccessoryName2_),
    _AccessoryName (AccessoryName_),
    _DeviceName (DeviceName_),
    _DeviceSerialNo (DeviceSerialNo_),
    _DeviceVersion (DeviceVersion_),
    _Manufacturer (Manufacturer_),
    _MountPoint (MountPoint_),
    _USBPortNo (USBPortNo_),
    _ProductID (ProductID_),
    _VendorID (VendorID_),
    _FreeSize_kB (FreeSize_kB_),
    _TotalSize_kB (TotalSize_kB_),
    _TotalSize (TotalSize_),
    _UsedSize_kB (UsedSize_kB_),
    _BaseClassCodeUsb (BaseClassCodeUsb_),
    _ParitionNum (ParitionNum_),
    _ProtocolUsb (ProtocolUsb_),
    _SubClassCodeUsb (SubClassCodeUsb_),
    _DevicePath (DevicePath_),
    _DeviceNode (DeviceNode_)
{
    #ifndef NDEBUG
    if (!(T_e8_DeviceConnectStatus_IsValid(DeviceConnectStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceConnectStatus_, "T_e8_DeviceConnectStatus", "DeviceConnectStatus", "T_DevManager_DeviceProperty");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Device_IsValid(DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceType_, "T_e8_Device", "DeviceType", "T_DevManager_DeviceProperty");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DVM_DeviceSpeedUsb_IsValid(DeviceSpeedUsb_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceSpeedUsb_, "T_e8_DVM_DeviceSpeedUsb", "DeviceSpeedUsb", "T_DevManager_DeviceProperty");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DVM_UnsupportedReason_IsValid(UnsupportedReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", UnsupportedReason_, "T_e8_DVM_UnsupportedReason", "UnsupportedReason", "T_DevManager_DeviceProperty");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_FileSystem_IsValid(FileSystemType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FileSystemType_, "T_e8_FileSystem", "FileSystemType", "T_DevManager_DeviceProperty");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AccessoryName2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AccessoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceSerialNo_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Manufacturer_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (USBPortNo_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DevicePath_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceNode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DevManager_DeviceProperty::~T_DevManager_DeviceProperty() {
}

inline T_DevManager_DeviceProperty& T_DevManager_DeviceProperty::operator = (const T_DevManager_DeviceProperty& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceConnectStatus()) {
            setDeviceConnectStatus(rhs.getDeviceConnectStatus());
        } else {
            clearDeviceConnectStatus();
        }
        if (rhs.hasDeviceType()) {
            setDeviceType(rhs.getDeviceType());
        } else {
            clearDeviceType();
        }
        if (rhs.hasDeviceSpeedUsb()) {
            setDeviceSpeedUsb(rhs.getDeviceSpeedUsb());
        } else {
            clearDeviceSpeedUsb();
        }
        if (rhs.hasUnsupportedReason()) {
            setUnsupportedReason(rhs.getUnsupportedReason());
        } else {
            clearUnsupportedReason();
        }
        if (rhs.hasFileSystemType()) {
            setFileSystemType(rhs.getFileSystemType());
        } else {
            clearFileSystemType();
        }
        if (rhs.hasAccessoryName2()) {
            setAccessoryName2(rhs.getAccessoryName2());
        } else {
            clearAccessoryName2();
        }
        if (rhs.hasAccessoryName()) {
            setAccessoryName(rhs.getAccessoryName());
        } else {
            clearAccessoryName();
        }
        if (rhs.hasDeviceName()) {
            setDeviceName(rhs.getDeviceName());
        } else {
            clearDeviceName();
        }
        if (rhs.hasDeviceSerialNo()) {
            setDeviceSerialNo(rhs.getDeviceSerialNo());
        } else {
            clearDeviceSerialNo();
        }
        if (rhs.hasDeviceVersion()) {
            setDeviceVersion(rhs.getDeviceVersion());
        } else {
            clearDeviceVersion();
        }
        if (rhs.hasManufacturer()) {
            setManufacturer(rhs.getManufacturer());
        } else {
            clearManufacturer();
        }
        if (rhs.hasMountPoint()) {
            setMountPoint(rhs.getMountPoint());
        } else {
            clearMountPoint();
        }
        if (rhs.hasUSBPortNo()) {
            setUSBPortNo(rhs.getUSBPortNo());
        } else {
            clearUSBPortNo();
        }
        if (rhs.hasProductID()) {
            setProductID(rhs.getProductID());
        } else {
            clearProductID();
        }
        if (rhs.hasVendorID()) {
            setVendorID(rhs.getVendorID());
        } else {
            clearVendorID();
        }
        if (rhs.hasFreeSize_kB()) {
            setFreeSize_kB(rhs.getFreeSize_kB());
        } else {
            clearFreeSize_kB();
        }
        if (rhs.hasTotalSize_kB()) {
            setTotalSize_kB(rhs.getTotalSize_kB());
        } else {
            clearTotalSize_kB();
        }
        if (rhs.hasTotalSize()) {
            setTotalSize(rhs.getTotalSize());
        } else {
            clearTotalSize();
        }
        if (rhs.hasUsedSize_kB()) {
            setUsedSize_kB(rhs.getUsedSize_kB());
        } else {
            clearUsedSize_kB();
        }
        if (rhs.hasBaseClassCodeUsb()) {
            setBaseClassCodeUsb(rhs.getBaseClassCodeUsb());
        } else {
            clearBaseClassCodeUsb();
        }
        if (rhs.hasParitionNum()) {
            setParitionNum(rhs.getParitionNum());
        } else {
            clearParitionNum();
        }
        if (rhs.hasProtocolUsb()) {
            setProtocolUsb(rhs.getProtocolUsb());
        } else {
            clearProtocolUsb();
        }
        if (rhs.hasSubClassCodeUsb()) {
            setSubClassCodeUsb(rhs.getSubClassCodeUsb());
        } else {
            clearSubClassCodeUsb();
        }
        if (rhs.hasDevicePath()) {
            setDevicePath(rhs.getDevicePath());
        } else {
            clearDevicePath();
        }
        if (rhs.hasDeviceNode()) {
            setDeviceNode(rhs.getDeviceNode());
        } else {
            clearDeviceNode();
        }
    }
    return *this;
}

inline bool T_DevManager_DeviceProperty::operator == (const T_DevManager_DeviceProperty& rhs) const {
    return (((!hasDeviceConnectStatus() && !rhs.hasDeviceConnectStatus()) || getDeviceConnectStatus() == rhs.getDeviceConnectStatus()) &&
        ((!hasDeviceType() && !rhs.hasDeviceType()) || getDeviceType() == rhs.getDeviceType()) &&
        ((!hasDeviceSpeedUsb() && !rhs.hasDeviceSpeedUsb()) || getDeviceSpeedUsb() == rhs.getDeviceSpeedUsb()) &&
        ((!hasUnsupportedReason() && !rhs.hasUnsupportedReason()) || getUnsupportedReason() == rhs.getUnsupportedReason()) &&
        ((!hasFileSystemType() && !rhs.hasFileSystemType()) || getFileSystemType() == rhs.getFileSystemType()) &&
        ((!hasAccessoryName2() && !rhs.hasAccessoryName2()) || getAccessoryName2() == rhs.getAccessoryName2()) &&
        ((!hasAccessoryName() && !rhs.hasAccessoryName()) || getAccessoryName() == rhs.getAccessoryName()) &&
        ((!hasDeviceName() && !rhs.hasDeviceName()) || getDeviceName() == rhs.getDeviceName()) &&
        ((!hasDeviceSerialNo() && !rhs.hasDeviceSerialNo()) || getDeviceSerialNo() == rhs.getDeviceSerialNo()) &&
        ((!hasDeviceVersion() && !rhs.hasDeviceVersion()) || getDeviceVersion() == rhs.getDeviceVersion()) &&
        ((!hasManufacturer() && !rhs.hasManufacturer()) || getManufacturer() == rhs.getManufacturer()) &&
        ((!hasMountPoint() && !rhs.hasMountPoint()) || getMountPoint() == rhs.getMountPoint()) &&
        ((!hasUSBPortNo() && !rhs.hasUSBPortNo()) || getUSBPortNo() == rhs.getUSBPortNo()) &&
        ((!hasProductID() && !rhs.hasProductID()) || getProductID() == rhs.getProductID()) &&
        ((!hasVendorID() && !rhs.hasVendorID()) || getVendorID() == rhs.getVendorID()) &&
        ((!hasFreeSize_kB() && !rhs.hasFreeSize_kB()) || getFreeSize_kB() == rhs.getFreeSize_kB()) &&
        ((!hasTotalSize_kB() && !rhs.hasTotalSize_kB()) || getTotalSize_kB() == rhs.getTotalSize_kB()) &&
        ((!hasTotalSize() && !rhs.hasTotalSize()) || getTotalSize() == rhs.getTotalSize()) &&
        ((!hasUsedSize_kB() && !rhs.hasUsedSize_kB()) || getUsedSize_kB() == rhs.getUsedSize_kB()) &&
        ((!hasBaseClassCodeUsb() && !rhs.hasBaseClassCodeUsb()) || getBaseClassCodeUsb() == rhs.getBaseClassCodeUsb()) &&
        ((!hasParitionNum() && !rhs.hasParitionNum()) || getParitionNum() == rhs.getParitionNum()) &&
        ((!hasProtocolUsb() && !rhs.hasProtocolUsb()) || getProtocolUsb() == rhs.getProtocolUsb()) &&
        ((!hasSubClassCodeUsb() && !rhs.hasSubClassCodeUsb()) || getSubClassCodeUsb() == rhs.getSubClassCodeUsb()) &&
        ((!hasDevicePath() && !rhs.hasDevicePath()) || getDevicePath() == rhs.getDevicePath()) &&
        ((!hasDeviceNode() && !rhs.hasDeviceNode()) || getDeviceNode() == rhs.getDeviceNode()));
}

inline bool T_DevManager_DeviceProperty::operator != (const T_DevManager_DeviceProperty& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DevManager_DeviceProperty::operator < (const T_DevManager_DeviceProperty& rhs) const {
    if (hasDeviceConnectStatus() || rhs.hasDeviceConnectStatus()) {
        if ((uint32)getDeviceConnectStatus() < (uint32)rhs.getDeviceConnectStatus()) return true;
        if ((uint32)getDeviceConnectStatus() > (uint32)rhs.getDeviceConnectStatus()) return false;
    }
    if (hasDeviceType() || rhs.hasDeviceType()) {
        if ((uint32)getDeviceType() < (uint32)rhs.getDeviceType()) return true;
        if ((uint32)getDeviceType() > (uint32)rhs.getDeviceType()) return false;
    }
    if (hasDeviceSpeedUsb() || rhs.hasDeviceSpeedUsb()) {
        if ((uint32)getDeviceSpeedUsb() < (uint32)rhs.getDeviceSpeedUsb()) return true;
        if ((uint32)getDeviceSpeedUsb() > (uint32)rhs.getDeviceSpeedUsb()) return false;
    }
    if (hasUnsupportedReason() || rhs.hasUnsupportedReason()) {
        if ((uint32)getUnsupportedReason() < (uint32)rhs.getUnsupportedReason()) return true;
        if ((uint32)getUnsupportedReason() > (uint32)rhs.getUnsupportedReason()) return false;
    }
    if (hasFileSystemType() || rhs.hasFileSystemType()) {
        if ((uint32)getFileSystemType() < (uint32)rhs.getFileSystemType()) return true;
        if ((uint32)getFileSystemType() > (uint32)rhs.getFileSystemType()) return false;
    }
    if (hasAccessoryName2() || rhs.hasAccessoryName2()) {
        if (getAccessoryName2() < rhs.getAccessoryName2()) return true;
        if (getAccessoryName2() > rhs.getAccessoryName2()) return false;
    }
    if (hasAccessoryName() || rhs.hasAccessoryName()) {
        if (getAccessoryName() < rhs.getAccessoryName()) return true;
        if (getAccessoryName() > rhs.getAccessoryName()) return false;
    }
    if (hasDeviceName() || rhs.hasDeviceName()) {
        if (getDeviceName() < rhs.getDeviceName()) return true;
        if (getDeviceName() > rhs.getDeviceName()) return false;
    }
    if (hasDeviceSerialNo() || rhs.hasDeviceSerialNo()) {
        if (getDeviceSerialNo() < rhs.getDeviceSerialNo()) return true;
        if (getDeviceSerialNo() > rhs.getDeviceSerialNo()) return false;
    }
    if (hasDeviceVersion() || rhs.hasDeviceVersion()) {
        if (getDeviceVersion() < rhs.getDeviceVersion()) return true;
        if (getDeviceVersion() > rhs.getDeviceVersion()) return false;
    }
    if (hasManufacturer() || rhs.hasManufacturer()) {
        if (getManufacturer() < rhs.getManufacturer()) return true;
        if (getManufacturer() > rhs.getManufacturer()) return false;
    }
    if (hasMountPoint() || rhs.hasMountPoint()) {
        if (getMountPoint() < rhs.getMountPoint()) return true;
        if (getMountPoint() > rhs.getMountPoint()) return false;
    }
    if (hasUSBPortNo() || rhs.hasUSBPortNo()) {
        if (getUSBPortNo() < rhs.getUSBPortNo()) return true;
        if (getUSBPortNo() > rhs.getUSBPortNo()) return false;
    }
    if (hasProductID() || rhs.hasProductID()) {
        if (getProductID() < rhs.getProductID()) return true;
        if (getProductID() > rhs.getProductID()) return false;
    }
    if (hasVendorID() || rhs.hasVendorID()) {
        if (getVendorID() < rhs.getVendorID()) return true;
        if (getVendorID() > rhs.getVendorID()) return false;
    }
    if (hasFreeSize_kB() || rhs.hasFreeSize_kB()) {
        if (getFreeSize_kB() < rhs.getFreeSize_kB()) return true;
        if (getFreeSize_kB() > rhs.getFreeSize_kB()) return false;
    }
    if (hasTotalSize_kB() || rhs.hasTotalSize_kB()) {
        if (getTotalSize_kB() < rhs.getTotalSize_kB()) return true;
        if (getTotalSize_kB() > rhs.getTotalSize_kB()) return false;
    }
    if (hasTotalSize() || rhs.hasTotalSize()) {
        if (getTotalSize() < rhs.getTotalSize()) return true;
        if (getTotalSize() > rhs.getTotalSize()) return false;
    }
    if (hasUsedSize_kB() || rhs.hasUsedSize_kB()) {
        if (getUsedSize_kB() < rhs.getUsedSize_kB()) return true;
        if (getUsedSize_kB() > rhs.getUsedSize_kB()) return false;
    }
    if (hasBaseClassCodeUsb() || rhs.hasBaseClassCodeUsb()) {
        if (getBaseClassCodeUsb() < rhs.getBaseClassCodeUsb()) return true;
        if (getBaseClassCodeUsb() > rhs.getBaseClassCodeUsb()) return false;
    }
    if (hasParitionNum() || rhs.hasParitionNum()) {
        if (getParitionNum() < rhs.getParitionNum()) return true;
        if (getParitionNum() > rhs.getParitionNum()) return false;
    }
    if (hasProtocolUsb() || rhs.hasProtocolUsb()) {
        if (getProtocolUsb() < rhs.getProtocolUsb()) return true;
        if (getProtocolUsb() > rhs.getProtocolUsb()) return false;
    }
    if (hasSubClassCodeUsb() || rhs.hasSubClassCodeUsb()) {
        if (getSubClassCodeUsb() < rhs.getSubClassCodeUsb()) return true;
        if (getSubClassCodeUsb() > rhs.getSubClassCodeUsb()) return false;
    }
    if (hasDevicePath() || rhs.hasDevicePath()) {
        if (getDevicePath() < rhs.getDevicePath()) return true;
        if (getDevicePath() > rhs.getDevicePath()) return false;
    }
    if (hasDeviceNode() || rhs.hasDeviceNode()) {
        if (getDeviceNode() < rhs.getDeviceNode()) return true;
        if (getDeviceNode() > rhs.getDeviceNode()) return false;
    }
    return false;
}

inline bool T_DevManager_DeviceProperty::operator > (const T_DevManager_DeviceProperty& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DevManager_DeviceProperty::clear() {
    clearDeviceConnectStatus();
    clearDeviceType();
    clearDeviceSpeedUsb();
    clearUnsupportedReason();
    clearFileSystemType();
    clearAccessoryName2();
    clearAccessoryName();
    clearDeviceName();
    clearDeviceSerialNo();
    clearDeviceVersion();
    clearManufacturer();
    clearMountPoint();
    clearUSBPortNo();
    clearProductID();
    clearVendorID();
    clearFreeSize_kB();
    clearTotalSize_kB();
    clearTotalSize();
    clearUsedSize_kB();
    clearBaseClassCodeUsb();
    clearParitionNum();
    clearProtocolUsb();
    clearSubClassCodeUsb();
    clearDevicePath();
    clearDeviceNode();
}

inline void T_DevManager_DeviceProperty::clearDeviceConnectStatus() {
    if (hasDeviceConnectStatus()) {
         clear_has_DeviceConnectStatus();
        _DeviceConnectStatus = ::mplay_devicemanager_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED;
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceConnectStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_DeviceConnectStatus T_DevManager_DeviceProperty::getDeviceConnectStatus () const {
    return _DeviceConnectStatus;
}

inline void T_DevManager_DeviceProperty::setDeviceConnectStatus (T_e8_DeviceConnectStatus DeviceConnectStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceConnectStatus_IsValid(DeviceConnectStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceConnectStatus_, "T_e8_DeviceConnectStatus", "DeviceConnectStatus", "T_DevManager_DeviceProperty");
    }
    #endif
    set_has_DeviceConnectStatus();
    this->_DeviceConnectStatus = DeviceConnectStatus_;
}

inline void T_DevManager_DeviceProperty::clearDeviceType() {
    if (hasDeviceType()) {
         clear_has_DeviceType();
        _DeviceType = ::mplay_devicemanager_fi_types::T_e8_Device__DTY_BTA;
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Device T_DevManager_DeviceProperty::getDeviceType () const {
    return _DeviceType;
}

inline void T_DevManager_DeviceProperty::setDeviceType (T_e8_Device DeviceType_) {
    #ifndef NDEBUG
    if (!(T_e8_Device_IsValid(DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceType_, "T_e8_Device", "DeviceType", "T_DevManager_DeviceProperty");
    }
    #endif
    set_has_DeviceType();
    this->_DeviceType = DeviceType_;
}

inline void T_DevManager_DeviceProperty::clearDeviceSpeedUsb() {
    if (hasDeviceSpeedUsb()) {
         clear_has_DeviceSpeedUsb();
        _DeviceSpeedUsb = ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb__FULL_SPEED;
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceSpeedUsb () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_DVM_DeviceSpeedUsb T_DevManager_DeviceProperty::getDeviceSpeedUsb () const {
    return _DeviceSpeedUsb;
}

inline void T_DevManager_DeviceProperty::setDeviceSpeedUsb (T_e8_DVM_DeviceSpeedUsb DeviceSpeedUsb_) {
    #ifndef NDEBUG
    if (!(T_e8_DVM_DeviceSpeedUsb_IsValid(DeviceSpeedUsb_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceSpeedUsb_, "T_e8_DVM_DeviceSpeedUsb", "DeviceSpeedUsb", "T_DevManager_DeviceProperty");
    }
    #endif
    set_has_DeviceSpeedUsb();
    this->_DeviceSpeedUsb = DeviceSpeedUsb_;
}

inline void T_DevManager_DeviceProperty::clearUnsupportedReason() {
    if (hasUnsupportedReason()) {
         clear_has_UnsupportedReason();
        _UnsupportedReason = ::mplay_devicemanager_fi_types::T_e8_DVM_UnsupportedReason__DisabledInConfiguration;
     }
}

inline bool T_DevManager_DeviceProperty::hasUnsupportedReason () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_DVM_UnsupportedReason T_DevManager_DeviceProperty::getUnsupportedReason () const {
    return _UnsupportedReason;
}

inline void T_DevManager_DeviceProperty::setUnsupportedReason (T_e8_DVM_UnsupportedReason UnsupportedReason_) {
    #ifndef NDEBUG
    if (!(T_e8_DVM_UnsupportedReason_IsValid(UnsupportedReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", UnsupportedReason_, "T_e8_DVM_UnsupportedReason", "UnsupportedReason", "T_DevManager_DeviceProperty");
    }
    #endif
    set_has_UnsupportedReason();
    this->_UnsupportedReason = UnsupportedReason_;
}

inline void T_DevManager_DeviceProperty::clearFileSystemType() {
    if (hasFileSystemType()) {
         clear_has_FileSystemType();
        _FileSystemType = ::mplay_devicemanager_fi_types::T_e8_FileSystem__FSTY_EXFAT;
     }
}

inline bool T_DevManager_DeviceProperty::hasFileSystemType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_FileSystem T_DevManager_DeviceProperty::getFileSystemType () const {
    return _FileSystemType;
}

inline void T_DevManager_DeviceProperty::setFileSystemType (T_e8_FileSystem FileSystemType_) {
    #ifndef NDEBUG
    if (!(T_e8_FileSystem_IsValid(FileSystemType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FileSystemType_, "T_e8_FileSystem", "FileSystemType", "T_DevManager_DeviceProperty");
    }
    #endif
    set_has_FileSystemType();
    this->_FileSystemType = FileSystemType_;
}

inline void T_DevManager_DeviceProperty::clearAccessoryName2() {
    if (hasAccessoryName2()) {
         clear_has_AccessoryName2();
        _AccessoryName2.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasAccessoryName2 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getAccessoryName2 () const {
    return _AccessoryName2;
}

inline ::std::string& T_DevManager_DeviceProperty::getAccessoryName2Mutable () {
    set_has_AccessoryName2();
    return _AccessoryName2;
}

inline void T_DevManager_DeviceProperty::setAccessoryName2 (const ::std::string& AccessoryName2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AccessoryName2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AccessoryName2();
    this->_AccessoryName2 = AccessoryName2_;
}

inline void T_DevManager_DeviceProperty::setAccessoryName2 (const char* AccessoryName2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AccessoryName2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AccessoryName2();
    this->_AccessoryName2.assign(AccessoryName2_);
}

inline void T_DevManager_DeviceProperty::setAccessoryName2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AccessoryName2();
    this->_AccessoryName2.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearAccessoryName() {
    if (hasAccessoryName()) {
         clear_has_AccessoryName();
        _AccessoryName.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasAccessoryName () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getAccessoryName () const {
    return _AccessoryName;
}

inline ::std::string& T_DevManager_DeviceProperty::getAccessoryNameMutable () {
    set_has_AccessoryName();
    return _AccessoryName;
}

inline void T_DevManager_DeviceProperty::setAccessoryName (const ::std::string& AccessoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AccessoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AccessoryName();
    this->_AccessoryName = AccessoryName_;
}

inline void T_DevManager_DeviceProperty::setAccessoryName (const char* AccessoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AccessoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AccessoryName();
    this->_AccessoryName.assign(AccessoryName_);
}

inline void T_DevManager_DeviceProperty::setAccessoryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AccessoryName();
    this->_AccessoryName.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearDeviceName() {
    if (hasDeviceName()) {
         clear_has_DeviceName();
        _DeviceName.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getDeviceName () const {
    return _DeviceName;
}

inline ::std::string& T_DevManager_DeviceProperty::getDeviceNameMutable () {
    set_has_DeviceName();
    return _DeviceName;
}

inline void T_DevManager_DeviceProperty::setDeviceName (const ::std::string& DeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName = DeviceName_;
}

inline void T_DevManager_DeviceProperty::setDeviceName (const char* DeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName.assign(DeviceName_);
}

inline void T_DevManager_DeviceProperty::setDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearDeviceSerialNo() {
    if (hasDeviceSerialNo()) {
         clear_has_DeviceSerialNo();
        _DeviceSerialNo.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceSerialNo () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getDeviceSerialNo () const {
    return _DeviceSerialNo;
}

inline ::std::string& T_DevManager_DeviceProperty::getDeviceSerialNoMutable () {
    set_has_DeviceSerialNo();
    return _DeviceSerialNo;
}

inline void T_DevManager_DeviceProperty::setDeviceSerialNo (const ::std::string& DeviceSerialNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceSerialNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceSerialNo();
    this->_DeviceSerialNo = DeviceSerialNo_;
}

inline void T_DevManager_DeviceProperty::setDeviceSerialNo (const char* DeviceSerialNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceSerialNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceSerialNo();
    this->_DeviceSerialNo.assign(DeviceSerialNo_);
}

inline void T_DevManager_DeviceProperty::setDeviceSerialNo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceSerialNo();
    this->_DeviceSerialNo.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearDeviceVersion() {
    if (hasDeviceVersion()) {
         clear_has_DeviceVersion();
        _DeviceVersion.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceVersion () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getDeviceVersion () const {
    return _DeviceVersion;
}

inline ::std::string& T_DevManager_DeviceProperty::getDeviceVersionMutable () {
    set_has_DeviceVersion();
    return _DeviceVersion;
}

inline void T_DevManager_DeviceProperty::setDeviceVersion (const ::std::string& DeviceVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceVersion();
    this->_DeviceVersion = DeviceVersion_;
}

inline void T_DevManager_DeviceProperty::setDeviceVersion (const char* DeviceVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceVersion();
    this->_DeviceVersion.assign(DeviceVersion_);
}

inline void T_DevManager_DeviceProperty::setDeviceVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceVersion();
    this->_DeviceVersion.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearManufacturer() {
    if (hasManufacturer()) {
         clear_has_Manufacturer();
        _Manufacturer.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasManufacturer () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getManufacturer () const {
    return _Manufacturer;
}

inline ::std::string& T_DevManager_DeviceProperty::getManufacturerMutable () {
    set_has_Manufacturer();
    return _Manufacturer;
}

inline void T_DevManager_DeviceProperty::setManufacturer (const ::std::string& Manufacturer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Manufacturer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Manufacturer();
    this->_Manufacturer = Manufacturer_;
}

inline void T_DevManager_DeviceProperty::setManufacturer (const char* Manufacturer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Manufacturer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Manufacturer();
    this->_Manufacturer.assign(Manufacturer_);
}

inline void T_DevManager_DeviceProperty::setManufacturer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Manufacturer();
    this->_Manufacturer.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearMountPoint() {
    if (hasMountPoint()) {
         clear_has_MountPoint();
        _MountPoint.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasMountPoint () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getMountPoint () const {
    return _MountPoint;
}

inline ::std::string& T_DevManager_DeviceProperty::getMountPointMutable () {
    set_has_MountPoint();
    return _MountPoint;
}

inline void T_DevManager_DeviceProperty::setMountPoint (const ::std::string& MountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MountPoint();
    this->_MountPoint = MountPoint_;
}

inline void T_DevManager_DeviceProperty::setMountPoint (const char* MountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MountPoint();
    this->_MountPoint.assign(MountPoint_);
}

inline void T_DevManager_DeviceProperty::setMountPoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MountPoint();
    this->_MountPoint.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearUSBPortNo() {
    if (hasUSBPortNo()) {
         clear_has_USBPortNo();
        _USBPortNo.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasUSBPortNo () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getUSBPortNo () const {
    return _USBPortNo;
}

inline ::std::string& T_DevManager_DeviceProperty::getUSBPortNoMutable () {
    set_has_USBPortNo();
    return _USBPortNo;
}

inline void T_DevManager_DeviceProperty::setUSBPortNo (const ::std::string& USBPortNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (USBPortNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_USBPortNo();
    this->_USBPortNo = USBPortNo_;
}

inline void T_DevManager_DeviceProperty::setUSBPortNo (const char* USBPortNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (USBPortNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_USBPortNo();
    this->_USBPortNo.assign(USBPortNo_);
}

inline void T_DevManager_DeviceProperty::setUSBPortNo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_USBPortNo();
    this->_USBPortNo.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearProductID() {
    if (hasProductID()) {
         clear_has_ProductID();
        _ProductID = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasProductID () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint16 T_DevManager_DeviceProperty::getProductID () const {
    return _ProductID;
}

inline void T_DevManager_DeviceProperty::setProductID (uint16 ProductID_) {
    set_has_ProductID();
    this->_ProductID = ProductID_;
}

inline void T_DevManager_DeviceProperty::clearVendorID() {
    if (hasVendorID()) {
         clear_has_VendorID();
        _VendorID = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasVendorID () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint16 T_DevManager_DeviceProperty::getVendorID () const {
    return _VendorID;
}

inline void T_DevManager_DeviceProperty::setVendorID (uint16 VendorID_) {
    set_has_VendorID();
    this->_VendorID = VendorID_;
}

inline void T_DevManager_DeviceProperty::clearFreeSize_kB() {
    if (hasFreeSize_kB()) {
         clear_has_FreeSize_kB();
        _FreeSize_kB = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasFreeSize_kB () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint64 T_DevManager_DeviceProperty::getFreeSize_kB () const {
    return _FreeSize_kB;
}

inline void T_DevManager_DeviceProperty::setFreeSize_kB (uint64 FreeSize_kB_) {
    set_has_FreeSize_kB();
    this->_FreeSize_kB = FreeSize_kB_;
}

inline void T_DevManager_DeviceProperty::clearTotalSize_kB() {
    if (hasTotalSize_kB()) {
         clear_has_TotalSize_kB();
        _TotalSize_kB = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasTotalSize_kB () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint64 T_DevManager_DeviceProperty::getTotalSize_kB () const {
    return _TotalSize_kB;
}

inline void T_DevManager_DeviceProperty::setTotalSize_kB (uint64 TotalSize_kB_) {
    set_has_TotalSize_kB();
    this->_TotalSize_kB = TotalSize_kB_;
}

inline void T_DevManager_DeviceProperty::clearTotalSize() {
    if (hasTotalSize()) {
         clear_has_TotalSize();
        _TotalSize = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasTotalSize () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint64 T_DevManager_DeviceProperty::getTotalSize () const {
    return _TotalSize;
}

inline void T_DevManager_DeviceProperty::setTotalSize (uint64 TotalSize_) {
    set_has_TotalSize();
    this->_TotalSize = TotalSize_;
}

inline void T_DevManager_DeviceProperty::clearUsedSize_kB() {
    if (hasUsedSize_kB()) {
         clear_has_UsedSize_kB();
        _UsedSize_kB = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasUsedSize_kB () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint64 T_DevManager_DeviceProperty::getUsedSize_kB () const {
    return _UsedSize_kB;
}

inline void T_DevManager_DeviceProperty::setUsedSize_kB (uint64 UsedSize_kB_) {
    set_has_UsedSize_kB();
    this->_UsedSize_kB = UsedSize_kB_;
}

inline void T_DevManager_DeviceProperty::clearBaseClassCodeUsb() {
    if (hasBaseClassCodeUsb()) {
         clear_has_BaseClassCodeUsb();
        _BaseClassCodeUsb = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasBaseClassCodeUsb () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint8 T_DevManager_DeviceProperty::getBaseClassCodeUsb () const {
    return _BaseClassCodeUsb;
}

inline void T_DevManager_DeviceProperty::setBaseClassCodeUsb (uint8 BaseClassCodeUsb_) {
    set_has_BaseClassCodeUsb();
    this->_BaseClassCodeUsb = BaseClassCodeUsb_;
}

inline void T_DevManager_DeviceProperty::clearParitionNum() {
    if (hasParitionNum()) {
         clear_has_ParitionNum();
        _ParitionNum = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasParitionNum () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint8 T_DevManager_DeviceProperty::getParitionNum () const {
    return _ParitionNum;
}

inline void T_DevManager_DeviceProperty::setParitionNum (uint8 ParitionNum_) {
    set_has_ParitionNum();
    this->_ParitionNum = ParitionNum_;
}

inline void T_DevManager_DeviceProperty::clearProtocolUsb() {
    if (hasProtocolUsb()) {
         clear_has_ProtocolUsb();
        _ProtocolUsb = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasProtocolUsb () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint8 T_DevManager_DeviceProperty::getProtocolUsb () const {
    return _ProtocolUsb;
}

inline void T_DevManager_DeviceProperty::setProtocolUsb (uint8 ProtocolUsb_) {
    set_has_ProtocolUsb();
    this->_ProtocolUsb = ProtocolUsb_;
}

inline void T_DevManager_DeviceProperty::clearSubClassCodeUsb() {
    if (hasSubClassCodeUsb()) {
         clear_has_SubClassCodeUsb();
        _SubClassCodeUsb = 0u;
     }
}

inline bool T_DevManager_DeviceProperty::hasSubClassCodeUsb () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline uint8 T_DevManager_DeviceProperty::getSubClassCodeUsb () const {
    return _SubClassCodeUsb;
}

inline void T_DevManager_DeviceProperty::setSubClassCodeUsb (uint8 SubClassCodeUsb_) {
    set_has_SubClassCodeUsb();
    this->_SubClassCodeUsb = SubClassCodeUsb_;
}

inline void T_DevManager_DeviceProperty::clearDevicePath() {
    if (hasDevicePath()) {
         clear_has_DevicePath();
        _DevicePath.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasDevicePath () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getDevicePath () const {
    return _DevicePath;
}

inline ::std::string& T_DevManager_DeviceProperty::getDevicePathMutable () {
    set_has_DevicePath();
    return _DevicePath;
}

inline void T_DevManager_DeviceProperty::setDevicePath (const ::std::string& DevicePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DevicePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DevicePath();
    this->_DevicePath = DevicePath_;
}

inline void T_DevManager_DeviceProperty::setDevicePath (const char* DevicePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DevicePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DevicePath();
    this->_DevicePath.assign(DevicePath_);
}

inline void T_DevManager_DeviceProperty::setDevicePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DevicePath();
    this->_DevicePath.assign(value, size);
}

inline void T_DevManager_DeviceProperty::clearDeviceNode() {
    if (hasDeviceNode()) {
         clear_has_DeviceNode();
        _DeviceNode.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceNode () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getDeviceNode () const {
    return _DeviceNode;
}

inline ::std::string& T_DevManager_DeviceProperty::getDeviceNodeMutable () {
    set_has_DeviceNode();
    return _DeviceNode;
}

inline void T_DevManager_DeviceProperty::setDeviceNode (const ::std::string& DeviceNode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceNode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceNode();
    this->_DeviceNode = DeviceNode_;
}

inline void T_DevManager_DeviceProperty::setDeviceNode (const char* DeviceNode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceNode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceNode();
    this->_DeviceNode.assign(DeviceNode_);
}

inline void T_DevManager_DeviceProperty::setDeviceNode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceNode();
    this->_DeviceNode.assign(value, size);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceConnectStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceConnectStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceSpeedUsb () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceSpeedUsb () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DevManager_DeviceProperty::set_has_UnsupportedReason () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DevManager_DeviceProperty::clear_has_UnsupportedReason () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DevManager_DeviceProperty::set_has_FileSystemType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DevManager_DeviceProperty::clear_has_FileSystemType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DevManager_DeviceProperty::set_has_AccessoryName2 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DevManager_DeviceProperty::clear_has_AccessoryName2 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DevManager_DeviceProperty::set_has_AccessoryName () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DevManager_DeviceProperty::clear_has_AccessoryName () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceName () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceSerialNo () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceSerialNo () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceVersion () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceVersion () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DevManager_DeviceProperty::set_has_Manufacturer () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DevManager_DeviceProperty::clear_has_Manufacturer () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DevManager_DeviceProperty::set_has_MountPoint () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DevManager_DeviceProperty::clear_has_MountPoint () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_DevManager_DeviceProperty::set_has_USBPortNo () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_DevManager_DeviceProperty::clear_has_USBPortNo () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_DevManager_DeviceProperty::set_has_ProductID () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_DevManager_DeviceProperty::clear_has_ProductID () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_DevManager_DeviceProperty::set_has_VendorID () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_DevManager_DeviceProperty::clear_has_VendorID () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_DevManager_DeviceProperty::set_has_FreeSize_kB () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_DevManager_DeviceProperty::clear_has_FreeSize_kB () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_DevManager_DeviceProperty::set_has_TotalSize_kB () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_DevManager_DeviceProperty::clear_has_TotalSize_kB () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_DevManager_DeviceProperty::set_has_TotalSize () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_DevManager_DeviceProperty::clear_has_TotalSize () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_DevManager_DeviceProperty::set_has_UsedSize_kB () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_DevManager_DeviceProperty::clear_has_UsedSize_kB () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_DevManager_DeviceProperty::set_has_BaseClassCodeUsb () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_DevManager_DeviceProperty::clear_has_BaseClassCodeUsb () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_DevManager_DeviceProperty::set_has_ParitionNum () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_DevManager_DeviceProperty::clear_has_ParitionNum () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_DevManager_DeviceProperty::set_has_ProtocolUsb () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_DevManager_DeviceProperty::clear_has_ProtocolUsb () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_DevManager_DeviceProperty::set_has_SubClassCodeUsb () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_DevManager_DeviceProperty::clear_has_SubClassCodeUsb () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_DevManager_DeviceProperty::set_has_DevicePath () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_DevManager_DeviceProperty::clear_has_DevicePath () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceNode () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceNode () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline  T_DevManager_PortStates::T_DevManager_PortStates ()  :
    _ElectricalFailure (false),
    _HubConnected (false),
    _OpenCircuit (false),
    _OverCurrent (false),
    _UnderVoltage (false),
    _USBPortConfiguredUsed (false),
    _USBPowerON (false),
    _USBPortNo (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DevManager_PortStates::T_DevManager_PortStates (const T_DevManager_PortStates &rhs)  :
    _ElectricalFailure (false),
    _HubConnected (false),
    _OpenCircuit (false),
    _OverCurrent (false),
    _UnderVoltage (false),
    _USBPortConfiguredUsed (false),
    _USBPowerON (false),
    _USBPortNo (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DevManager_PortStates::T_DevManager_PortStates (bool ElectricalFailure_, bool HubConnected_, bool OpenCircuit_, bool OverCurrent_, bool UnderVoltage_, bool USBPortConfiguredUsed_, bool USBPowerON_, uint8 USBPortNo_)  :
    _ElectricalFailure (ElectricalFailure_),
    _HubConnected (HubConnected_),
    _OpenCircuit (OpenCircuit_),
    _OverCurrent (OverCurrent_),
    _UnderVoltage (UnderVoltage_),
    _USBPortConfiguredUsed (USBPortConfiguredUsed_),
    _USBPowerON (USBPowerON_),
    _USBPortNo (USBPortNo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DevManager_PortStates::~T_DevManager_PortStates() {
}

inline T_DevManager_PortStates& T_DevManager_PortStates::operator = (const T_DevManager_PortStates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElectricalFailure()) {
            setElectricalFailure(rhs.getElectricalFailure());
        } else {
            clearElectricalFailure();
        }
        if (rhs.hasHubConnected()) {
            setHubConnected(rhs.getHubConnected());
        } else {
            clearHubConnected();
        }
        if (rhs.hasOpenCircuit()) {
            setOpenCircuit(rhs.getOpenCircuit());
        } else {
            clearOpenCircuit();
        }
        if (rhs.hasOverCurrent()) {
            setOverCurrent(rhs.getOverCurrent());
        } else {
            clearOverCurrent();
        }
        if (rhs.hasUnderVoltage()) {
            setUnderVoltage(rhs.getUnderVoltage());
        } else {
            clearUnderVoltage();
        }
        if (rhs.hasUSBPortConfiguredUsed()) {
            setUSBPortConfiguredUsed(rhs.getUSBPortConfiguredUsed());
        } else {
            clearUSBPortConfiguredUsed();
        }
        if (rhs.hasUSBPowerON()) {
            setUSBPowerON(rhs.getUSBPowerON());
        } else {
            clearUSBPowerON();
        }
        if (rhs.hasUSBPortNo()) {
            setUSBPortNo(rhs.getUSBPortNo());
        } else {
            clearUSBPortNo();
        }
    }
    return *this;
}

inline bool T_DevManager_PortStates::operator == (const T_DevManager_PortStates& rhs) const {
    return (((!hasElectricalFailure() && !rhs.hasElectricalFailure()) || getElectricalFailure() == rhs.getElectricalFailure()) &&
        ((!hasHubConnected() && !rhs.hasHubConnected()) || getHubConnected() == rhs.getHubConnected()) &&
        ((!hasOpenCircuit() && !rhs.hasOpenCircuit()) || getOpenCircuit() == rhs.getOpenCircuit()) &&
        ((!hasOverCurrent() && !rhs.hasOverCurrent()) || getOverCurrent() == rhs.getOverCurrent()) &&
        ((!hasUnderVoltage() && !rhs.hasUnderVoltage()) || getUnderVoltage() == rhs.getUnderVoltage()) &&
        ((!hasUSBPortConfiguredUsed() && !rhs.hasUSBPortConfiguredUsed()) || getUSBPortConfiguredUsed() == rhs.getUSBPortConfiguredUsed()) &&
        ((!hasUSBPowerON() && !rhs.hasUSBPowerON()) || getUSBPowerON() == rhs.getUSBPowerON()) &&
        ((!hasUSBPortNo() && !rhs.hasUSBPortNo()) || getUSBPortNo() == rhs.getUSBPortNo()));
}

inline bool T_DevManager_PortStates::operator != (const T_DevManager_PortStates& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DevManager_PortStates::operator < (const T_DevManager_PortStates& rhs) const {
    if (hasElectricalFailure() || rhs.hasElectricalFailure()) {
        if (getElectricalFailure() < rhs.getElectricalFailure()) return true;
        if (getElectricalFailure() > rhs.getElectricalFailure()) return false;
    }
    if (hasHubConnected() || rhs.hasHubConnected()) {
        if (getHubConnected() < rhs.getHubConnected()) return true;
        if (getHubConnected() > rhs.getHubConnected()) return false;
    }
    if (hasOpenCircuit() || rhs.hasOpenCircuit()) {
        if (getOpenCircuit() < rhs.getOpenCircuit()) return true;
        if (getOpenCircuit() > rhs.getOpenCircuit()) return false;
    }
    if (hasOverCurrent() || rhs.hasOverCurrent()) {
        if (getOverCurrent() < rhs.getOverCurrent()) return true;
        if (getOverCurrent() > rhs.getOverCurrent()) return false;
    }
    if (hasUnderVoltage() || rhs.hasUnderVoltage()) {
        if (getUnderVoltage() < rhs.getUnderVoltage()) return true;
        if (getUnderVoltage() > rhs.getUnderVoltage()) return false;
    }
    if (hasUSBPortConfiguredUsed() || rhs.hasUSBPortConfiguredUsed()) {
        if (getUSBPortConfiguredUsed() < rhs.getUSBPortConfiguredUsed()) return true;
        if (getUSBPortConfiguredUsed() > rhs.getUSBPortConfiguredUsed()) return false;
    }
    if (hasUSBPowerON() || rhs.hasUSBPowerON()) {
        if (getUSBPowerON() < rhs.getUSBPowerON()) return true;
        if (getUSBPowerON() > rhs.getUSBPowerON()) return false;
    }
    if (hasUSBPortNo() || rhs.hasUSBPortNo()) {
        if (getUSBPortNo() < rhs.getUSBPortNo()) return true;
        if (getUSBPortNo() > rhs.getUSBPortNo()) return false;
    }
    return false;
}

inline bool T_DevManager_PortStates::operator > (const T_DevManager_PortStates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DevManager_PortStates::clear() {
    clearElectricalFailure();
    clearHubConnected();
    clearOpenCircuit();
    clearOverCurrent();
    clearUnderVoltage();
    clearUSBPortConfiguredUsed();
    clearUSBPowerON();
    clearUSBPortNo();
}

inline void T_DevManager_PortStates::clearElectricalFailure() {
    if (hasElectricalFailure()) {
         clear_has_ElectricalFailure();
        _ElectricalFailure = false;
     }
}

inline bool T_DevManager_PortStates::hasElectricalFailure () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_DevManager_PortStates::getElectricalFailure () const {
    return _ElectricalFailure;
}

inline void T_DevManager_PortStates::setElectricalFailure (bool ElectricalFailure_) {
    set_has_ElectricalFailure();
    this->_ElectricalFailure = ElectricalFailure_;
}

inline void T_DevManager_PortStates::clearHubConnected() {
    if (hasHubConnected()) {
         clear_has_HubConnected();
        _HubConnected = false;
     }
}

inline bool T_DevManager_PortStates::hasHubConnected () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_DevManager_PortStates::getHubConnected () const {
    return _HubConnected;
}

inline void T_DevManager_PortStates::setHubConnected (bool HubConnected_) {
    set_has_HubConnected();
    this->_HubConnected = HubConnected_;
}

inline void T_DevManager_PortStates::clearOpenCircuit() {
    if (hasOpenCircuit()) {
         clear_has_OpenCircuit();
        _OpenCircuit = false;
     }
}

inline bool T_DevManager_PortStates::hasOpenCircuit () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_DevManager_PortStates::getOpenCircuit () const {
    return _OpenCircuit;
}

inline void T_DevManager_PortStates::setOpenCircuit (bool OpenCircuit_) {
    set_has_OpenCircuit();
    this->_OpenCircuit = OpenCircuit_;
}

inline void T_DevManager_PortStates::clearOverCurrent() {
    if (hasOverCurrent()) {
         clear_has_OverCurrent();
        _OverCurrent = false;
     }
}

inline bool T_DevManager_PortStates::hasOverCurrent () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_DevManager_PortStates::getOverCurrent () const {
    return _OverCurrent;
}

inline void T_DevManager_PortStates::setOverCurrent (bool OverCurrent_) {
    set_has_OverCurrent();
    this->_OverCurrent = OverCurrent_;
}

inline void T_DevManager_PortStates::clearUnderVoltage() {
    if (hasUnderVoltage()) {
         clear_has_UnderVoltage();
        _UnderVoltage = false;
     }
}

inline bool T_DevManager_PortStates::hasUnderVoltage () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_DevManager_PortStates::getUnderVoltage () const {
    return _UnderVoltage;
}

inline void T_DevManager_PortStates::setUnderVoltage (bool UnderVoltage_) {
    set_has_UnderVoltage();
    this->_UnderVoltage = UnderVoltage_;
}

inline void T_DevManager_PortStates::clearUSBPortConfiguredUsed() {
    if (hasUSBPortConfiguredUsed()) {
         clear_has_USBPortConfiguredUsed();
        _USBPortConfiguredUsed = false;
     }
}

inline bool T_DevManager_PortStates::hasUSBPortConfiguredUsed () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_DevManager_PortStates::getUSBPortConfiguredUsed () const {
    return _USBPortConfiguredUsed;
}

inline void T_DevManager_PortStates::setUSBPortConfiguredUsed (bool USBPortConfiguredUsed_) {
    set_has_USBPortConfiguredUsed();
    this->_USBPortConfiguredUsed = USBPortConfiguredUsed_;
}

inline void T_DevManager_PortStates::clearUSBPowerON() {
    if (hasUSBPowerON()) {
         clear_has_USBPowerON();
        _USBPowerON = false;
     }
}

inline bool T_DevManager_PortStates::hasUSBPowerON () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_DevManager_PortStates::getUSBPowerON () const {
    return _USBPowerON;
}

inline void T_DevManager_PortStates::setUSBPowerON (bool USBPowerON_) {
    set_has_USBPowerON();
    this->_USBPowerON = USBPowerON_;
}

inline void T_DevManager_PortStates::clearUSBPortNo() {
    if (hasUSBPortNo()) {
         clear_has_USBPortNo();
        _USBPortNo = 0u;
     }
}

inline bool T_DevManager_PortStates::hasUSBPortNo () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_DevManager_PortStates::getUSBPortNo () const {
    return _USBPortNo;
}

inline void T_DevManager_PortStates::setUSBPortNo (uint8 USBPortNo_) {
    set_has_USBPortNo();
    this->_USBPortNo = USBPortNo_;
}

inline void T_DevManager_PortStates::set_has_ElectricalFailure () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DevManager_PortStates::clear_has_ElectricalFailure () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DevManager_PortStates::set_has_HubConnected () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DevManager_PortStates::clear_has_HubConnected () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DevManager_PortStates::set_has_OpenCircuit () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DevManager_PortStates::clear_has_OpenCircuit () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DevManager_PortStates::set_has_OverCurrent () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DevManager_PortStates::clear_has_OverCurrent () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DevManager_PortStates::set_has_UnderVoltage () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DevManager_PortStates::clear_has_UnderVoltage () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DevManager_PortStates::set_has_USBPortConfiguredUsed () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DevManager_PortStates::clear_has_USBPortConfiguredUsed () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DevManager_PortStates::set_has_USBPowerON () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DevManager_PortStates::clear_has_USBPowerON () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DevManager_PortStates::set_has_USBPortNo () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DevManager_PortStates::clear_has_USBPortNo () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_DevManager_SDCardInfo::T_DevManager_SDCardInfo ()  :
    _CardIdentifierRegister (),
    _SDCardState (::mplay_devicemanager_fi_types::T_e8_DVM_MediaState__MEDIA_NOT_READY),
    _SDCardMedia (::mplay_devicemanager_fi_types::T_e8_DVM_MediaType__DATA_MEDIA),
    _PowerStatus (::mplay_devicemanager_fi_types::T_e8_PowerStatus__POWER_STATUS_INIT),
    _HW_WriteProtected (false),
    _Mounted (false),
    _SW_WriteProtected (false),
    _MountPoint (),
    _DeviceSerialNo (0u),
    _TotalSize (0u),
    _DevManufactureId (0u),
    _DevSpecVersion (0u),
    _SDCardSlot (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DevManager_SDCardInfo::T_DevManager_SDCardInfo (const T_DevManager_SDCardInfo &rhs)  :
    _CardIdentifierRegister (),
    _SDCardState (::mplay_devicemanager_fi_types::T_e8_DVM_MediaState__MEDIA_NOT_READY),
    _SDCardMedia (::mplay_devicemanager_fi_types::T_e8_DVM_MediaType__DATA_MEDIA),
    _PowerStatus (::mplay_devicemanager_fi_types::T_e8_PowerStatus__POWER_STATUS_INIT),
    _HW_WriteProtected (false),
    _Mounted (false),
    _SW_WriteProtected (false),
    _MountPoint (),
    _DeviceSerialNo (0u),
    _TotalSize (0u),
    _DevManufactureId (0u),
    _DevSpecVersion (0u),
    _SDCardSlot (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DevManager_SDCardInfo::T_DevManager_SDCardInfo (const T_DVM_CardIdentifierRegister& CardIdentifierRegister_, T_e8_DVM_MediaState SDCardState_, T_e8_DVM_MediaType SDCardMedia_, T_e8_PowerStatus PowerStatus_, bool HW_WriteProtected_, bool Mounted_, bool SW_WriteProtected_, const ::std::string& MountPoint_, uint32 DeviceSerialNo_, uint64 TotalSize_, uint8 DevManufactureId_, uint8 DevSpecVersion_, uint8 SDCardSlot_)  :
    _CardIdentifierRegister (CardIdentifierRegister_),
    _SDCardState (SDCardState_),
    _SDCardMedia (SDCardMedia_),
    _PowerStatus (PowerStatus_),
    _HW_WriteProtected (HW_WriteProtected_),
    _Mounted (Mounted_),
    _SW_WriteProtected (SW_WriteProtected_),
    _MountPoint (MountPoint_),
    _DeviceSerialNo (DeviceSerialNo_),
    _TotalSize (TotalSize_),
    _DevManufactureId (DevManufactureId_),
    _DevSpecVersion (DevSpecVersion_),
    _SDCardSlot (SDCardSlot_)
{
    #ifndef NDEBUG
    if (!(T_e8_DVM_MediaState_IsValid(SDCardState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SDCardState_, "T_e8_DVM_MediaState", "SDCardState", "T_DevManager_SDCardInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DVM_MediaType_IsValid(SDCardMedia_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SDCardMedia_, "T_e8_DVM_MediaType", "SDCardMedia", "T_DevManager_SDCardInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_PowerStatus_IsValid(PowerStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerStatus_, "T_e8_PowerStatus", "PowerStatus", "T_DevManager_SDCardInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DevManager_SDCardInfo::~T_DevManager_SDCardInfo() {
}

inline T_DevManager_SDCardInfo& T_DevManager_SDCardInfo::operator = (const T_DevManager_SDCardInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCardIdentifierRegister()) {
            setCardIdentifierRegister(rhs.getCardIdentifierRegister());
        } else {
            clearCardIdentifierRegister();
        }
        if (rhs.hasSDCardState()) {
            setSDCardState(rhs.getSDCardState());
        } else {
            clearSDCardState();
        }
        if (rhs.hasSDCardMedia()) {
            setSDCardMedia(rhs.getSDCardMedia());
        } else {
            clearSDCardMedia();
        }
        if (rhs.hasPowerStatus()) {
            setPowerStatus(rhs.getPowerStatus());
        } else {
            clearPowerStatus();
        }
        if (rhs.hasHW_WriteProtected()) {
            setHW_WriteProtected(rhs.getHW_WriteProtected());
        } else {
            clearHW_WriteProtected();
        }
        if (rhs.hasMounted()) {
            setMounted(rhs.getMounted());
        } else {
            clearMounted();
        }
        if (rhs.hasSW_WriteProtected()) {
            setSW_WriteProtected(rhs.getSW_WriteProtected());
        } else {
            clearSW_WriteProtected();
        }
        if (rhs.hasMountPoint()) {
            setMountPoint(rhs.getMountPoint());
        } else {
            clearMountPoint();
        }
        if (rhs.hasDeviceSerialNo()) {
            setDeviceSerialNo(rhs.getDeviceSerialNo());
        } else {
            clearDeviceSerialNo();
        }
        if (rhs.hasTotalSize()) {
            setTotalSize(rhs.getTotalSize());
        } else {
            clearTotalSize();
        }
        if (rhs.hasDevManufactureId()) {
            setDevManufactureId(rhs.getDevManufactureId());
        } else {
            clearDevManufactureId();
        }
        if (rhs.hasDevSpecVersion()) {
            setDevSpecVersion(rhs.getDevSpecVersion());
        } else {
            clearDevSpecVersion();
        }
        if (rhs.hasSDCardSlot()) {
            setSDCardSlot(rhs.getSDCardSlot());
        } else {
            clearSDCardSlot();
        }
    }
    return *this;
}

inline bool T_DevManager_SDCardInfo::operator == (const T_DevManager_SDCardInfo& rhs) const {
    return (((!hasCardIdentifierRegister() && !rhs.hasCardIdentifierRegister()) || getCardIdentifierRegister() == rhs.getCardIdentifierRegister()) &&
        ((!hasSDCardState() && !rhs.hasSDCardState()) || getSDCardState() == rhs.getSDCardState()) &&
        ((!hasSDCardMedia() && !rhs.hasSDCardMedia()) || getSDCardMedia() == rhs.getSDCardMedia()) &&
        ((!hasPowerStatus() && !rhs.hasPowerStatus()) || getPowerStatus() == rhs.getPowerStatus()) &&
        ((!hasHW_WriteProtected() && !rhs.hasHW_WriteProtected()) || getHW_WriteProtected() == rhs.getHW_WriteProtected()) &&
        ((!hasMounted() && !rhs.hasMounted()) || getMounted() == rhs.getMounted()) &&
        ((!hasSW_WriteProtected() && !rhs.hasSW_WriteProtected()) || getSW_WriteProtected() == rhs.getSW_WriteProtected()) &&
        ((!hasMountPoint() && !rhs.hasMountPoint()) || getMountPoint() == rhs.getMountPoint()) &&
        ((!hasDeviceSerialNo() && !rhs.hasDeviceSerialNo()) || getDeviceSerialNo() == rhs.getDeviceSerialNo()) &&
        ((!hasTotalSize() && !rhs.hasTotalSize()) || getTotalSize() == rhs.getTotalSize()) &&
        ((!hasDevManufactureId() && !rhs.hasDevManufactureId()) || getDevManufactureId() == rhs.getDevManufactureId()) &&
        ((!hasDevSpecVersion() && !rhs.hasDevSpecVersion()) || getDevSpecVersion() == rhs.getDevSpecVersion()) &&
        ((!hasSDCardSlot() && !rhs.hasSDCardSlot()) || getSDCardSlot() == rhs.getSDCardSlot()));
}

inline bool T_DevManager_SDCardInfo::operator != (const T_DevManager_SDCardInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DevManager_SDCardInfo::operator < (const T_DevManager_SDCardInfo& rhs) const {
    if (hasCardIdentifierRegister() || rhs.hasCardIdentifierRegister()) {
        if (getCardIdentifierRegister() < rhs.getCardIdentifierRegister()) return true;
        if (getCardIdentifierRegister() > rhs.getCardIdentifierRegister()) return false;
    }
    if (hasSDCardState() || rhs.hasSDCardState()) {
        if ((uint32)getSDCardState() < (uint32)rhs.getSDCardState()) return true;
        if ((uint32)getSDCardState() > (uint32)rhs.getSDCardState()) return false;
    }
    if (hasSDCardMedia() || rhs.hasSDCardMedia()) {
        if ((uint32)getSDCardMedia() < (uint32)rhs.getSDCardMedia()) return true;
        if ((uint32)getSDCardMedia() > (uint32)rhs.getSDCardMedia()) return false;
    }
    if (hasPowerStatus() || rhs.hasPowerStatus()) {
        if ((uint32)getPowerStatus() < (uint32)rhs.getPowerStatus()) return true;
        if ((uint32)getPowerStatus() > (uint32)rhs.getPowerStatus()) return false;
    }
    if (hasHW_WriteProtected() || rhs.hasHW_WriteProtected()) {
        if (getHW_WriteProtected() < rhs.getHW_WriteProtected()) return true;
        if (getHW_WriteProtected() > rhs.getHW_WriteProtected()) return false;
    }
    if (hasMounted() || rhs.hasMounted()) {
        if (getMounted() < rhs.getMounted()) return true;
        if (getMounted() > rhs.getMounted()) return false;
    }
    if (hasSW_WriteProtected() || rhs.hasSW_WriteProtected()) {
        if (getSW_WriteProtected() < rhs.getSW_WriteProtected()) return true;
        if (getSW_WriteProtected() > rhs.getSW_WriteProtected()) return false;
    }
    if (hasMountPoint() || rhs.hasMountPoint()) {
        if (getMountPoint() < rhs.getMountPoint()) return true;
        if (getMountPoint() > rhs.getMountPoint()) return false;
    }
    if (hasDeviceSerialNo() || rhs.hasDeviceSerialNo()) {
        if (getDeviceSerialNo() < rhs.getDeviceSerialNo()) return true;
        if (getDeviceSerialNo() > rhs.getDeviceSerialNo()) return false;
    }
    if (hasTotalSize() || rhs.hasTotalSize()) {
        if (getTotalSize() < rhs.getTotalSize()) return true;
        if (getTotalSize() > rhs.getTotalSize()) return false;
    }
    if (hasDevManufactureId() || rhs.hasDevManufactureId()) {
        if (getDevManufactureId() < rhs.getDevManufactureId()) return true;
        if (getDevManufactureId() > rhs.getDevManufactureId()) return false;
    }
    if (hasDevSpecVersion() || rhs.hasDevSpecVersion()) {
        if (getDevSpecVersion() < rhs.getDevSpecVersion()) return true;
        if (getDevSpecVersion() > rhs.getDevSpecVersion()) return false;
    }
    if (hasSDCardSlot() || rhs.hasSDCardSlot()) {
        if (getSDCardSlot() < rhs.getSDCardSlot()) return true;
        if (getSDCardSlot() > rhs.getSDCardSlot()) return false;
    }
    return false;
}

inline bool T_DevManager_SDCardInfo::operator > (const T_DevManager_SDCardInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DevManager_SDCardInfo::clear() {
    clearCardIdentifierRegister();
    clearSDCardState();
    clearSDCardMedia();
    clearPowerStatus();
    clearHW_WriteProtected();
    clearMounted();
    clearSW_WriteProtected();
    clearMountPoint();
    clearDeviceSerialNo();
    clearTotalSize();
    clearDevManufactureId();
    clearDevSpecVersion();
    clearSDCardSlot();
}

inline void T_DevManager_SDCardInfo::clearCardIdentifierRegister() {
    if (hasCardIdentifierRegister()) {
         clear_has_CardIdentifierRegister();
        _CardIdentifierRegister.clear();
     }
}

inline bool T_DevManager_SDCardInfo::hasCardIdentifierRegister () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_DVM_CardIdentifierRegister& T_DevManager_SDCardInfo::getCardIdentifierRegister () const {
    return _CardIdentifierRegister;
}

inline T_DVM_CardIdentifierRegister& T_DevManager_SDCardInfo::getCardIdentifierRegisterMutable () {
    set_has_CardIdentifierRegister();
    return _CardIdentifierRegister;
}

inline void T_DevManager_SDCardInfo::setCardIdentifierRegister (const T_DVM_CardIdentifierRegister& CardIdentifierRegister_) {
    set_has_CardIdentifierRegister();
    this->_CardIdentifierRegister = CardIdentifierRegister_;
}

inline void T_DevManager_SDCardInfo::clearSDCardState() {
    if (hasSDCardState()) {
         clear_has_SDCardState();
        _SDCardState = ::mplay_devicemanager_fi_types::T_e8_DVM_MediaState__MEDIA_NOT_READY;
     }
}

inline bool T_DevManager_SDCardInfo::hasSDCardState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_DVM_MediaState T_DevManager_SDCardInfo::getSDCardState () const {
    return _SDCardState;
}

inline void T_DevManager_SDCardInfo::setSDCardState (T_e8_DVM_MediaState SDCardState_) {
    #ifndef NDEBUG
    if (!(T_e8_DVM_MediaState_IsValid(SDCardState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SDCardState_, "T_e8_DVM_MediaState", "SDCardState", "T_DevManager_SDCardInfo");
    }
    #endif
    set_has_SDCardState();
    this->_SDCardState = SDCardState_;
}

inline void T_DevManager_SDCardInfo::clearSDCardMedia() {
    if (hasSDCardMedia()) {
         clear_has_SDCardMedia();
        _SDCardMedia = ::mplay_devicemanager_fi_types::T_e8_DVM_MediaType__DATA_MEDIA;
     }
}

inline bool T_DevManager_SDCardInfo::hasSDCardMedia () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_DVM_MediaType T_DevManager_SDCardInfo::getSDCardMedia () const {
    return _SDCardMedia;
}

inline void T_DevManager_SDCardInfo::setSDCardMedia (T_e8_DVM_MediaType SDCardMedia_) {
    #ifndef NDEBUG
    if (!(T_e8_DVM_MediaType_IsValid(SDCardMedia_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SDCardMedia_, "T_e8_DVM_MediaType", "SDCardMedia", "T_DevManager_SDCardInfo");
    }
    #endif
    set_has_SDCardMedia();
    this->_SDCardMedia = SDCardMedia_;
}

inline void T_DevManager_SDCardInfo::clearPowerStatus() {
    if (hasPowerStatus()) {
         clear_has_PowerStatus();
        _PowerStatus = ::mplay_devicemanager_fi_types::T_e8_PowerStatus__POWER_STATUS_INIT;
     }
}

inline bool T_DevManager_SDCardInfo::hasPowerStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_PowerStatus T_DevManager_SDCardInfo::getPowerStatus () const {
    return _PowerStatus;
}

inline void T_DevManager_SDCardInfo::setPowerStatus (T_e8_PowerStatus PowerStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_PowerStatus_IsValid(PowerStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerStatus_, "T_e8_PowerStatus", "PowerStatus", "T_DevManager_SDCardInfo");
    }
    #endif
    set_has_PowerStatus();
    this->_PowerStatus = PowerStatus_;
}

inline void T_DevManager_SDCardInfo::clearHW_WriteProtected() {
    if (hasHW_WriteProtected()) {
         clear_has_HW_WriteProtected();
        _HW_WriteProtected = false;
     }
}

inline bool T_DevManager_SDCardInfo::hasHW_WriteProtected () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_DevManager_SDCardInfo::getHW_WriteProtected () const {
    return _HW_WriteProtected;
}

inline void T_DevManager_SDCardInfo::setHW_WriteProtected (bool HW_WriteProtected_) {
    set_has_HW_WriteProtected();
    this->_HW_WriteProtected = HW_WriteProtected_;
}

inline void T_DevManager_SDCardInfo::clearMounted() {
    if (hasMounted()) {
         clear_has_Mounted();
        _Mounted = false;
     }
}

inline bool T_DevManager_SDCardInfo::hasMounted () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_DevManager_SDCardInfo::getMounted () const {
    return _Mounted;
}

inline void T_DevManager_SDCardInfo::setMounted (bool Mounted_) {
    set_has_Mounted();
    this->_Mounted = Mounted_;
}

inline void T_DevManager_SDCardInfo::clearSW_WriteProtected() {
    if (hasSW_WriteProtected()) {
         clear_has_SW_WriteProtected();
        _SW_WriteProtected = false;
     }
}

inline bool T_DevManager_SDCardInfo::hasSW_WriteProtected () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_DevManager_SDCardInfo::getSW_WriteProtected () const {
    return _SW_WriteProtected;
}

inline void T_DevManager_SDCardInfo::setSW_WriteProtected (bool SW_WriteProtected_) {
    set_has_SW_WriteProtected();
    this->_SW_WriteProtected = SW_WriteProtected_;
}

inline void T_DevManager_SDCardInfo::clearMountPoint() {
    if (hasMountPoint()) {
         clear_has_MountPoint();
        _MountPoint.clear();
     }
}

inline bool T_DevManager_SDCardInfo::hasMountPoint () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_DevManager_SDCardInfo::getMountPoint () const {
    return _MountPoint;
}

inline ::std::string& T_DevManager_SDCardInfo::getMountPointMutable () {
    set_has_MountPoint();
    return _MountPoint;
}

inline void T_DevManager_SDCardInfo::setMountPoint (const ::std::string& MountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MountPoint();
    this->_MountPoint = MountPoint_;
}

inline void T_DevManager_SDCardInfo::setMountPoint (const char* MountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MountPoint();
    this->_MountPoint.assign(MountPoint_);
}

inline void T_DevManager_SDCardInfo::setMountPoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MountPoint();
    this->_MountPoint.assign(value, size);
}

inline void T_DevManager_SDCardInfo::clearDeviceSerialNo() {
    if (hasDeviceSerialNo()) {
         clear_has_DeviceSerialNo();
        _DeviceSerialNo = 0u;
     }
}

inline bool T_DevManager_SDCardInfo::hasDeviceSerialNo () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_DevManager_SDCardInfo::getDeviceSerialNo () const {
    return _DeviceSerialNo;
}

inline void T_DevManager_SDCardInfo::setDeviceSerialNo (uint32 DeviceSerialNo_) {
    set_has_DeviceSerialNo();
    this->_DeviceSerialNo = DeviceSerialNo_;
}

inline void T_DevManager_SDCardInfo::clearTotalSize() {
    if (hasTotalSize()) {
         clear_has_TotalSize();
        _TotalSize = 0u;
     }
}

inline bool T_DevManager_SDCardInfo::hasTotalSize () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint64 T_DevManager_SDCardInfo::getTotalSize () const {
    return _TotalSize;
}

inline void T_DevManager_SDCardInfo::setTotalSize (uint64 TotalSize_) {
    set_has_TotalSize();
    this->_TotalSize = TotalSize_;
}

inline void T_DevManager_SDCardInfo::clearDevManufactureId() {
    if (hasDevManufactureId()) {
         clear_has_DevManufactureId();
        _DevManufactureId = 0u;
     }
}

inline bool T_DevManager_SDCardInfo::hasDevManufactureId () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 T_DevManager_SDCardInfo::getDevManufactureId () const {
    return _DevManufactureId;
}

inline void T_DevManager_SDCardInfo::setDevManufactureId (uint8 DevManufactureId_) {
    set_has_DevManufactureId();
    this->_DevManufactureId = DevManufactureId_;
}

inline void T_DevManager_SDCardInfo::clearDevSpecVersion() {
    if (hasDevSpecVersion()) {
         clear_has_DevSpecVersion();
        _DevSpecVersion = 0u;
     }
}

inline bool T_DevManager_SDCardInfo::hasDevSpecVersion () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint8 T_DevManager_SDCardInfo::getDevSpecVersion () const {
    return _DevSpecVersion;
}

inline void T_DevManager_SDCardInfo::setDevSpecVersion (uint8 DevSpecVersion_) {
    set_has_DevSpecVersion();
    this->_DevSpecVersion = DevSpecVersion_;
}

inline void T_DevManager_SDCardInfo::clearSDCardSlot() {
    if (hasSDCardSlot()) {
         clear_has_SDCardSlot();
        _SDCardSlot = 0u;
     }
}

inline bool T_DevManager_SDCardInfo::hasSDCardSlot () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint8 T_DevManager_SDCardInfo::getSDCardSlot () const {
    return _SDCardSlot;
}

inline void T_DevManager_SDCardInfo::setSDCardSlot (uint8 SDCardSlot_) {
    set_has_SDCardSlot();
    this->_SDCardSlot = SDCardSlot_;
}

inline void T_DevManager_SDCardInfo::set_has_CardIdentifierRegister () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DevManager_SDCardInfo::clear_has_CardIdentifierRegister () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DevManager_SDCardInfo::set_has_SDCardState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DevManager_SDCardInfo::clear_has_SDCardState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DevManager_SDCardInfo::set_has_SDCardMedia () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DevManager_SDCardInfo::clear_has_SDCardMedia () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DevManager_SDCardInfo::set_has_PowerStatus () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DevManager_SDCardInfo::clear_has_PowerStatus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DevManager_SDCardInfo::set_has_HW_WriteProtected () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DevManager_SDCardInfo::clear_has_HW_WriteProtected () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DevManager_SDCardInfo::set_has_Mounted () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DevManager_SDCardInfo::clear_has_Mounted () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DevManager_SDCardInfo::set_has_SW_WriteProtected () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DevManager_SDCardInfo::clear_has_SW_WriteProtected () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DevManager_SDCardInfo::set_has_MountPoint () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DevManager_SDCardInfo::clear_has_MountPoint () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DevManager_SDCardInfo::set_has_DeviceSerialNo () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DevManager_SDCardInfo::clear_has_DeviceSerialNo () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DevManager_SDCardInfo::set_has_TotalSize () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DevManager_SDCardInfo::clear_has_TotalSize () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DevManager_SDCardInfo::set_has_DevManufactureId () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DevManager_SDCardInfo::clear_has_DevManufactureId () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DevManager_SDCardInfo::set_has_DevSpecVersion () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DevManager_SDCardInfo::clear_has_DevSpecVersion () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_DevManager_SDCardInfo::set_has_SDCardSlot () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_DevManager_SDCardInfo::clear_has_SDCardSlot () {
    _has_bits_[0] &= ~ (1u << 12);
}

} // namespace mplay_devicemanager_fi_types

#endif // MPLAY_DEVICEMANAGER_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
