/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_DEVICEMANAGER_FIPROXY_H
#define MPLAY_DEVICEMANAGER_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "mplay_devicemanager_fi.h"
#include "mplay_devicemanager_fi_types.h"
#include "mplay_devicemanager_fi_typesConst.h"
#include "mplay_shared_fi_typesConst.h"
#include <string>
#include <vector>

namespace mplay_devicemanager_fi {

class Mplay_devicemanager_fiProxy;

class DevManagerAddExternalHubCallbackIF {
public:
    virtual ~DevManagerAddExternalHubCallbackIF() {}

    virtual void onDevManagerAddExternalHubError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerAddExternalHubError >& error) = 0;

    virtual void onDevManagerAddExternalHubResult(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerAddExternalHubResult >& result) = 0;
};

class DevManagerAddTelematicsBoxCallbackIF {
public:
    virtual ~DevManagerAddTelematicsBoxCallbackIF() {}

    virtual void onDevManagerAddTelematicsBoxError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerAddTelematicsBoxError >& error) = 0;

    virtual void onDevManagerAddTelematicsBoxResult(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerAddTelematicsBoxResult >& result) = 0;
};

class DevManagerDVDDriveInfoCallbackIF {
public:
    virtual ~DevManagerDVDDriveInfoCallbackIF() {}

    virtual void onDevManagerDVDDriveInfoError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerDVDDriveInfoError >& error) = 0;

    virtual void onDevManagerDVDDriveInfoStatus(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerDVDDriveInfoStatus >& status) = 0;
};

class DevManagerEjectOpticalDiscCallbackIF {
public:
    virtual ~DevManagerEjectOpticalDiscCallbackIF() {}

    virtual void onDevManagerEjectOpticalDiscError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerEjectOpticalDiscError >& error) = 0;

    virtual void onDevManagerEjectOpticalDiscResult(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerEjectOpticalDiscResult >& result) = 0;
};

class DevManagerGetAllConnectedDevicesCallbackIF {
public:
    virtual ~DevManagerGetAllConnectedDevicesCallbackIF() {}

    virtual void onDevManagerGetAllConnectedDevicesError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerGetAllConnectedDevicesError >& error) = 0;

    virtual void onDevManagerGetAllConnectedDevicesResult(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerGetAllConnectedDevicesResult >& result) = 0;
};

class DevManagerGetConfigurationValueCallbackIF {
public:
    virtual ~DevManagerGetConfigurationValueCallbackIF() {}

    virtual void onDevManagerGetConfigurationValueError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerGetConfigurationValueError >& error) = 0;

    virtual void onDevManagerGetConfigurationValueResult(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerGetConfigurationValueResult >& result) = 0;
};

class DevManagerGetDevPropertiesCallbackIF {
public:
    virtual ~DevManagerGetDevPropertiesCallbackIF() {}

    virtual void onDevManagerGetDevPropertiesError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerGetDevPropertiesError >& error) = 0;

    virtual void onDevManagerGetDevPropertiesResult(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerGetDevPropertiesResult >& result) = 0;
};

class DevManagerMountCDROMInternalCallbackIF {
public:
    virtual ~DevManagerMountCDROMInternalCallbackIF() {}

    virtual void onDevManagerMountCDROMInternalError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerMountCDROMInternalError >& error) = 0;

    virtual void onDevManagerMountCDROMInternalResult(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerMountCDROMInternalResult >& result) = 0;
};

class DevManagerNotifyCDInfoCallbackIF {
public:
    virtual ~DevManagerNotifyCDInfoCallbackIF() {}

    virtual void onDevManagerNotifyCDInfoError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerNotifyCDInfoError >& error) = 0;

    virtual void onDevManagerNotifyCDInfoStatus(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerNotifyCDInfoStatus >& status) = 0;
};

class DevManagerNotifyConnectionCallbackIF {
public:
    virtual ~DevManagerNotifyConnectionCallbackIF() {}

    virtual void onDevManagerNotifyConnectionError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerNotifyConnectionError >& error) = 0;

    virtual void onDevManagerNotifyConnectionStatus(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerNotifyConnectionStatus >& status) = 0;
};

class DevManagerNotifySDCardCallbackIF {
public:
    virtual ~DevManagerNotifySDCardCallbackIF() {}

    virtual void onDevManagerNotifySDCardError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerNotifySDCardError >& error) = 0;

    virtual void onDevManagerNotifySDCardStatus(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerNotifySDCardStatus >& status) = 0;
};

class DevManagerNotifySlotStateOpticalDiscCallbackIF {
public:
    virtual ~DevManagerNotifySlotStateOpticalDiscCallbackIF() {}

    virtual void onDevManagerNotifySlotStateOpticalDiscError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscError >& error) = 0;

    virtual void onDevManagerNotifySlotStateOpticalDiscStatus(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscStatus >& status) = 0;
};

class DevManagerOverTempCDCallbackIF {
public:
    virtual ~DevManagerOverTempCDCallbackIF() {}

    virtual void onDevManagerOverTempCDError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerOverTempCDError >& error) = 0;

    virtual void onDevManagerOverTempCDStatus(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerOverTempCDStatus >& status) = 0;
};

class DevManagerSetConfigurationValueCallbackIF {
public:
    virtual ~DevManagerSetConfigurationValueCallbackIF() {}

    virtual void onDevManagerSetConfigurationValueError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerSetConfigurationValueError >& error) = 0;

    virtual void onDevManagerSetConfigurationValueResult(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerSetConfigurationValueResult >& result) = 0;
};

class DevManagerTelematicsBoxAliveCallbackIF {
public:
    virtual ~DevManagerTelematicsBoxAliveCallbackIF() {}

    virtual void onDevManagerTelematicsBoxAliveError(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerTelematicsBoxAliveError >& error) = 0;

    virtual void onDevManagerTelematicsBoxAliveStatus(const ::boost::shared_ptr< Mplay_devicemanager_fiProxy >& proxy, const ::boost::shared_ptr< DevManagerTelematicsBoxAliveStatus >& status) = 0;
};

class Mplay_devicemanager_fiProxyCallback;

/**
 * Mplay_devicemanager_fiProxy is the client side representation of the
 * CCA Functional Interface 'mplay_devicemanager_fi' (specified in file
 * mplay_devicemanager_fi.xml).
 *
 * CCA Functional Interface 'mplay_devicemanager_fi'
 *
 * Fullname: VD_DeviceManager Functional Interface
 *
 * Version: $Revision: 1.3 $
 *
 * Author: Christian Koechling,Thomas Masczyk, Lars Fiebing,Rajeev Narayanan Sambhu
 *
 * Date: $Date: 08.11.2013 $
 *
 * Department: CM-AI/PJ-GM55
 *
 * Title: Devicemanager_fi
 *
 * <b>Description of 'mplay_devicemanager_fi':</b>
 */
class Mplay_devicemanager_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Mplay_devicemanager_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Mplay_devicemanager_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Mplay_devicemanager_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Mplay_devicemanager_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Mplay_devicemanager_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Mplay_devicemanager_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Mplay_devicemanager_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Mplay_devicemanager_fiProxy();

    // Method 'DevManagerMountCDROMInternal'

    /**
     * Call the method 'DevManagerMountCDROMInternal'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevManagerMountCDROMInternal'</b>:
     *
     * If a CDROM is inserted to the internal CDDrive then this method is used by diagnosis to mount it.
     * This command is especially used if the CDROM is a MixMode CD. This is use case in the production diagnosis.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Mount <p>TRUE:  Mount the CD ROM</p>
     * <p>FALSE: Unmount the CD ROM</p>
     *
     * @param BlockDevice <p>block device name of cdrom in project e.g. /dev/sr0  or /dev/sr1</p>
     * <p>VD_Devicemanager will try to mount it e.g. to /dev/media/cdrom_diag</p>
     * <p>Diag has to care to call  unmount as well to ensure stability within ignition cycle</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerMountCDROMInternalStart(DevManagerMountCDROMInternalCallbackIF& cb, bool mount, const ::std::string& blockDevice);

    // Method 'DevManagerEjectOpticalDisc'

    /**
     * Call the method 'DevManagerEjectOpticalDisc'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevManagerEjectOpticalDisc'</b>:
     *
     * Eject or insert optical disc
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param eCmdParam <p>T_e8_EjectParm is used to send insert or eject command</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerEjectOpticalDiscStart(DevManagerEjectOpticalDiscCallbackIF& cb, ::mplay_shared_fi_types::T_e8_EjectParmType eCmdParam);

    // Method 'DevManagerAddTelematicsBox'

    /**
     * Call the method 'DevManagerAddTelematicsBox'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevManagerAddTelematicsBox'</b>:
     *
     * Add or delete a Telematics box.
     * If this function is called VD_DVM uses datapool to store value permanently.
     * Although device might have been notified by udev - after the call of this
     * fi function VD_DVM will check again if such new added device is already connected to send the diagnosis info.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param VendorID <p>Vendor id of the telematics box</p>
     *
     * @param ProductID <p>Product id of the telematics box</p>
     *
     * @param USBPortNo <p>USB connector where the telematics box will be connected.
     * This value will influence the configuration of other Telematics boxes.</p>
     *
     * @param SpeedInfo <p>The expected device speed. If there is no expectation of device speed, the default value should be "UNKNOWN"</p>
     *
     * @param Add <p>FALSE: The Telematics Box with the specified details( with vendor id, product id) will be deleted from the datapool.
     * The diagnosis info for the telematics Box will not be send.
     * TRUE: The Telematics Box with the specified details( with vendor id, product id) will be added to the datapool.
     * The diagnosis info for the telematics Box will be send.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerAddTelematicsBoxStart(DevManagerAddTelematicsBoxCallbackIF& cb, uint32 vendorID, uint32 productID, uint32 uSBPortNo, ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb speedInfo, bool add);

    // Method 'DevManagerSetConfigurationValue'

    /**
     * Call the method 'DevManagerSetConfigurationValue'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevManagerSetConfigurationValue'</b>:
     *
     * Provides a way to alter the configuration of vd_devicemanager( see ConfigurationBase.h and ConfigurationBase.cpp )
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ConfigurationParam <p>Name of the configuration Parameter. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @param Value <p>Value of the configuration. Please check with ttfis command VD_DVM_SHOW_HELP_MANUAL to get the possible values of the
     * configuration parameter.
     * for eg: VD_DVM_SET_CONFIGURATION_VALUE_eCONF_ENABLE_FILESYSTEM_FAT supports 2 values
     * 00 or 01.</p>
     *
     * @param SettingsMode <p>The mode of the setting the values. It can be either Temporary(value will be set for the current ignition cycle),
     * Permanent(value will be set for the current and subsequent ignition cycles) or
     * Default(configuration parameter will fall back to the default configuration of the project)</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerSetConfigurationValueStart(DevManagerSetConfigurationValueCallbackIF& cb, const ::std::string& configurationParam, uint16 value, ::mplay_devicemanager_fi_types::T_e8_SettingsMode settingsMode);

    // Method 'DevManagerGetConfigurationValue'

    /**
     * Call the method 'DevManagerGetConfigurationValue'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevManagerGetConfigurationValue'</b>:
     *
     * Provides a way to  fetch the configuration of vd_devicemanager( see ConfigurationBase.h and ConfigurationBase.cpp)
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ConfigurationParam <p>Name of the configuration value. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerGetConfigurationValueStart(DevManagerGetConfigurationValueCallbackIF& cb, const ::std::string& configurationParam);

    // Method 'DevManagerAddExternalHub'

    /**
     * Call the method 'DevManagerAddExternalHub'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevManagerAddExternalHub'</b>:
     *
     * Add or delete an ExternalHub device.
     * If this function is called VD_DVM uses datapool to store value permanently.
     * Although device might have been notified by udev - after the call of this
     * fi function VD_DVM will check again if such new added device is already connected to send the diagnosis info.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param VendorID <p>Vendor id of the ExternalHub device</p>
     *
     * @param ProductID <p>Product id of the ExternalHub device</p>
     *
     * @param USBPortNo <p>USB connector where the ExternalHub device will be connected.
     * This value will influence the configuration of other ExternalHubs.</p>
     *
     * @param Add <p>FALSE: The ExternalHub device with the specified details( with vendor id, product id) will be deleted from the datapool.
     * The diagnosis info for the ExternalHub device will not be send.
     * TRUE: The ExternalHub device with the specified details( with vendor id, product id) will be added to the datapool.
     * The diagnosis info for the ExternalHub device will be send.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerAddExternalHubStart(DevManagerAddExternalHubCallbackIF& cb, uint32 vendorID, uint32 productID, uint32 uSBPortNo, bool add);

    // Method 'DevManagerGetDevProperties'

    /**
     * Call the method 'DevManagerGetDevProperties'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevManagerGetDevProperties'</b>:
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
     * This method provides device properties of a connected device as specified by the requesting registered FBlock based on the device serial number.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceSerialNo !!!Deprecated method used in Gen2 - kept for backward compatibility - use property T_DevManager_DeviceProperty and opcode Get!!!
     * The serial number of the device inserted or removed from the system.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerGetDevPropertiesStart(DevManagerGetDevPropertiesCallbackIF& cb, const ::std::string& deviceSerialNo);

    // Method 'DevManagerGetAllConnectedDevices'

    /**
     * Call the method 'DevManagerGetAllConnectedDevices'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevManagerGetAllConnectedDevices'</b>:
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
     * This method provides device properties of all connected device during power up. The CCA components after getting started can use this method to retrieve information of all connected devices
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerGetAllConnectedDevicesStart(DevManagerGetAllConnectedDevicesCallbackIF& cb);

    // Property 'DevManagerNotifyConnection'

    /**
     * Notify on the property 'DevManagerNotifyConnection'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifyConnection'</b>:
     *
     * This property provides notification about new device connection. The notification includes insertion of a new device into the system, device type of inserted device, device serial number, device version and mount point or user path where the device has been mounted.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerNotifyConnectionUpReg(DevManagerNotifyConnectionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DevManagerNotifyConnection'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifyConnection'</b>:
     *
     * This property provides notification about new device connection. The notification includes insertion of a new device into the system, device type of inserted device, device serial number, device version and mount point or user path where the device has been mounted.
     *
     * @param act The act which was previously returned by the
     * sendDevManagerNotifyConnectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevManagerNotifyConnectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevManagerNotifyConnection'.
     */
    void sendDevManagerNotifyConnectionRelUpRegAll ();

    /**
     * Returns the current value of the property 'DevManagerNotifyConnection'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDevManagerNotifyConnection() returns true.
     *
     * @return the previously received value of the property 'DevManagerNotifyConnection'.
     */
    const DevManagerNotifyConnectionStatus& getDevManagerNotifyConnection() const;

    /**
     * Determines whether a status message for the property 'DevManagerNotifyConnection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevManagerNotifyConnection() const;

    /**
     * Request the value of the property 'DevManagerNotifyConnection' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifyConnection'</b>:
     *
     * This property provides notification about new device connection. The notification includes insertion of a new device into the system, device type of inserted device, device serial number, device version and mount point or user path where the device has been mounted.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param Devicetype Provides the device connection status and properties associated with device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerNotifyConnectionGet(DevManagerNotifyConnectionCallbackIF& cb, const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& devicetype);

    // Property 'DevManagerNotifySDCard'

    /**
     * Notify on the property 'DevManagerNotifySDCard'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifySDCard'</b>:
     *
     * This property provides notification about new SD Card device insertion. The notification includes type and state of card, device serial number, Card Identifier Register, total size and further information.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerNotifySDCardUpReg(DevManagerNotifySDCardCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DevManagerNotifySDCard'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifySDCard'</b>:
     *
     * This property provides notification about new SD Card device insertion. The notification includes type and state of card, device serial number, Card Identifier Register, total size and further information.
     *
     * @param act The act which was previously returned by the
     * sendDevManagerNotifySDCardUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevManagerNotifySDCardRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevManagerNotifySDCard'.
     */
    void sendDevManagerNotifySDCardRelUpRegAll ();

    /**
     * Returns the current value of the property 'DevManagerNotifySDCard' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDevManagerNotifySDCard() returns true.
     *
     * @return the previously received value of the property 'DevManagerNotifySDCard'.
     */
    const DevManagerNotifySDCardStatus& getDevManagerNotifySDCard() const;

    /**
     * Determines whether a status message for the property 'DevManagerNotifySDCard' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevManagerNotifySDCard() const;

    /**
     * Request the value of the property 'DevManagerNotifySDCard' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifySDCard'</b>:
     *
     * This property provides notification about new SD Card device insertion. The notification includes type and state of card, device serial number, Card Identifier Register, total size and further information.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerNotifySDCardGet(DevManagerNotifySDCardCallbackIF& cb);

    // Property 'DevManagerOverTempCD'

    /**
     * Notify on the property 'DevManagerOverTempCD'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerOverTempCD'</b>:
     *
     * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerOverTempCDUpReg(DevManagerOverTempCDCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DevManagerOverTempCD'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerOverTempCD'</b>:
     *
     * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
     *
     * @param act The act which was previously returned by the
     * sendDevManagerOverTempCDUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevManagerOverTempCDRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevManagerOverTempCD'.
     */
    void sendDevManagerOverTempCDRelUpRegAll ();

    /**
     * Returns the current value of the property 'DevManagerOverTempCD' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDevManagerOverTempCD() returns true.
     *
     * @return the previously received value of the property 'DevManagerOverTempCD'.
     */
    const DevManagerOverTempCDStatus& getDevManagerOverTempCD() const;

    /**
     * Determines whether a status message for the property 'DevManagerOverTempCD' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevManagerOverTempCD() const;

    /**
     * Request the value of the property 'DevManagerOverTempCD' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DevManagerOverTempCD'</b>:
     *
     * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerOverTempCDGet(DevManagerOverTempCDCallbackIF& cb);

    /**
     * Set the value of the property 'DevManagerOverTempCD'. This method sends
     * a Set message to the CCA server.
     *
     * <b>Documentation of 'DevManagerOverTempCD'</b>:
     *
     * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param OverTemperature <p>FALSE: No over temperature.</p>
     * <p>TRUE:  Playing CDs should be blocked due to over temperature. This is done by informing MEdiaplayer via via T_DevManager_DeviceProperty</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerOverTempCDSet(DevManagerOverTempCDCallbackIF& cb, bool overTemperature);

    // Property 'DevManagerTelematicsBoxAlive'

    /**
     * Notify on the property 'DevManagerTelematicsBoxAlive'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerTelematicsBoxAlive'</b>:
     *
     * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
     * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
     * .
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerTelematicsBoxAliveUpReg(DevManagerTelematicsBoxAliveCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DevManagerTelematicsBoxAlive'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerTelematicsBoxAlive'</b>:
     *
     * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
     * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
     * .
     *
     * @param act The act which was previously returned by the
     * sendDevManagerTelematicsBoxAliveUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevManagerTelematicsBoxAliveRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevManagerTelematicsBoxAlive'.
     */
    void sendDevManagerTelematicsBoxAliveRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'DevManagerTelematicsBoxAlive' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasDevManagerTelematicsBoxAlive()
     * returns true.
     *
     * @return the previously received value of the property 'DevManagerTelematicsBoxAlive'.
     */
    const DevManagerTelematicsBoxAliveStatus& getDevManagerTelematicsBoxAlive() const;

    /**
     * Determines whether a status message for the property 'DevManagerTelematicsBoxAlive' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevManagerTelematicsBoxAlive() const;

    /**
     * Request the value of the property 'DevManagerTelematicsBoxAlive' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DevManagerTelematicsBoxAlive'</b>:
     *
     * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
     * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
     * .
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerTelematicsBoxAliveGet(DevManagerTelematicsBoxAliveCallbackIF& cb);

    /**
     * Set the value of the property 'DevManagerTelematicsBoxAlive'. This
     * method sends a Set message to the CCA server.
     *
     * <b>Documentation of 'DevManagerTelematicsBoxAlive'</b>:
     *
     * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
     * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
     * .
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param BTAConnectionStatus <p>FALSE: Upper layer communication to BTA telematics box is failed.</p>
     * <p>TRUE:  Upper layer communication to BTA telematics box is alive, ie connection is established.</p>
     *
     * @param TimoutBeforeSendingITC The timeout value is set by FC_ATP. The VD_DVM waits till this timeout value to send the BTA specific ITCs
     * IF FC_ATP sets this value to 0 this means it does not
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerTelematicsBoxAliveSet(DevManagerTelematicsBoxAliveCallbackIF& cb, bool bTAConnectionStatus, uint32 timoutBeforeSendingITC);

    // Property 'DevManagerNotifySlotStateOpticalDisc'

    /**
     * Notify on the property 'DevManagerNotifySlotStateOpticalDisc'. This
     * method sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifySlotStateOpticalDisc'</b>:
     *
     * Used to notify about the connection status of Optical disks.The VD_Devicemanager gets the information from
     * VD_Mediamanager component.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerNotifySlotStateOpticalDiscUpReg(DevManagerNotifySlotStateOpticalDiscCallbackIF& cb);

    /**
     * Remove the notifcation on property
     * 'DevManagerNotifySlotStateOpticalDisc'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifySlotStateOpticalDisc'</b>:
     *
     * Used to notify about the connection status of Optical disks.The VD_Devicemanager gets the information from
     * VD_Mediamanager component.
     *
     * @param act The act which was previously returned by the
     * sendDevManagerNotifySlotStateOpticalDiscUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevManagerNotifySlotStateOpticalDiscRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevManagerNotifySlotStateOpticalDisc'.
     */
    void sendDevManagerNotifySlotStateOpticalDiscRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'DevManagerNotifySlotStateOpticalDisc' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasDevManagerNotifySlotStateOpticalDisc() returns true.
     *
     * @return the previously received value of the property 'DevManagerNotifySlotStateOpticalDisc'.
     */
    const DevManagerNotifySlotStateOpticalDiscStatus& getDevManagerNotifySlotStateOpticalDisc() const;

    /**
     * Determines whether a status message for the property 'DevManagerNotifySlotStateOpticalDisc' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevManagerNotifySlotStateOpticalDisc() const;

    /**
     * Request the value of the property
     * 'DevManagerNotifySlotStateOpticalDisc' from the CCA server. This method
     * sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifySlotStateOpticalDisc'</b>:
     *
     * Used to notify about the connection status of Optical disks.The VD_Devicemanager gets the information from
     * VD_Mediamanager component.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerNotifySlotStateOpticalDiscGet(DevManagerNotifySlotStateOpticalDiscCallbackIF& cb);

    // Property 'DevManagerNotifyCDInfo'

    /**
     * Notify on the property 'DevManagerNotifyCDInfo'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifyCDInfo'</b>:
     *
     * This property gives Driver Version and Device State details about the Optical Device- CDMP3,CDDA .
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerNotifyCDInfoUpReg(DevManagerNotifyCDInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DevManagerNotifyCDInfo'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifyCDInfo'</b>:
     *
     * This property gives Driver Version and Device State details about the Optical Device- CDMP3,CDDA .
     *
     * @param act The act which was previously returned by the
     * sendDevManagerNotifyCDInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevManagerNotifyCDInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevManagerNotifyCDInfo'.
     */
    void sendDevManagerNotifyCDInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'DevManagerNotifyCDInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDevManagerNotifyCDInfo() returns true.
     *
     * @return the previously received value of the property 'DevManagerNotifyCDInfo'.
     */
    const DevManagerNotifyCDInfoStatus& getDevManagerNotifyCDInfo() const;

    /**
     * Determines whether a status message for the property 'DevManagerNotifyCDInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevManagerNotifyCDInfo() const;

    /**
     * Request the value of the property 'DevManagerNotifyCDInfo' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DevManagerNotifyCDInfo'</b>:
     *
     * This property gives Driver Version and Device State details about the Optical Device- CDMP3,CDDA .
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerNotifyCDInfoGet(DevManagerNotifyCDInfoCallbackIF& cb);

    // Property 'DevManagerDVDDriveInfo'

    /**
     * Notify on the property 'DevManagerDVDDriveInfo'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerDVDDriveInfo'</b>:
     *
     * This will give dvd drive info necessary for device
     * manager. Using this, Disctype and DriveMode of the DVD drive(info fetched from Driver) can be obtained.
     * Devicemanager operations based on this info can be done.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerDVDDriveInfoUpReg(DevManagerDVDDriveInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DevManagerDVDDriveInfo'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DevManagerDVDDriveInfo'</b>:
     *
     * This will give dvd drive info necessary for device
     * manager. Using this, Disctype and DriveMode of the DVD drive(info fetched from Driver) can be obtained.
     * Devicemanager operations based on this info can be done.
     *
     * @param act The act which was previously returned by the
     * sendDevManagerDVDDriveInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDevManagerDVDDriveInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DevManagerDVDDriveInfo'.
     */
    void sendDevManagerDVDDriveInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'DevManagerDVDDriveInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDevManagerDVDDriveInfo() returns true.
     *
     * @return the previously received value of the property 'DevManagerDVDDriveInfo'.
     */
    const DevManagerDVDDriveInfoStatus& getDevManagerDVDDriveInfo() const;

    /**
     * Determines whether a status message for the property 'DevManagerDVDDriveInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevManagerDVDDriveInfo() const;

    /**
     * Set the value of the property 'DevManagerDVDDriveInfo'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'DevManagerDVDDriveInfo'</b>:
     *
     * This will give dvd drive info necessary for device
     * manager. Using this, Disctype and DriveMode of the DVD drive(info fetched from Driver) can be obtained.
     * Devicemanager operations based on this info can be done.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param e8DVDDiscType This will inform whether the disc inserted is Data disc
     * or Non-Data Disc
     *
     * @param e8DVDDriveMode This will give the drive mode as either BackEnd Mode or
     * MassStorage Mode
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevManagerDVDDriveInfoSet(DevManagerDVDDriveInfoCallbackIF& cb, ::mplay_devicemanager_fi_types::T_e8_MDVDDiscType e8DVDDiscType, ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode e8DVDDriveMode);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Mplay_devicemanager_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'DevManagerNotifyConnection'

    ::asf::core::nullable< DevManagerNotifyConnectionStatus > _devManagerNotifyConnection;

    // Property 'DevManagerNotifySDCard'

    ::asf::core::nullable< DevManagerNotifySDCardStatus > _devManagerNotifySDCard;

    // Property 'DevManagerOverTempCD'

    ::asf::core::nullable< DevManagerOverTempCDStatus > _devManagerOverTempCD;

    // Property 'DevManagerTelematicsBoxAlive'

    ::asf::core::nullable< DevManagerTelematicsBoxAliveStatus > _devManagerTelematicsBoxAlive;

    // Property 'DevManagerNotifySlotStateOpticalDisc'

    ::asf::core::nullable< DevManagerNotifySlotStateOpticalDiscStatus > _devManagerNotifySlotStateOpticalDisc;

    // Property 'DevManagerNotifyCDInfo'

    ::asf::core::nullable< DevManagerNotifyCDInfoStatus > _devManagerNotifyCDInfo;

    // Property 'DevManagerDVDDriveInfo'

    ::asf::core::nullable< DevManagerDVDDriveInfoStatus > _devManagerDVDDriveInfo;

    DECLARE_CLASS_LOGGER();

    friend class Mplay_devicemanager_fiProxyCallback;
};

} // namespace mplay_devicemanager_fi

#endif // MPLAY_DEVICEMANAGER_FIPROXY_H
