/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "mplay_devicemanager_fi.h"
#include "mplay_devicemanager_fiJson.h"
#include "mplay_devicemanager_fi_types.h"
#include "mplay_devicemanager_fi_typesConst.h"
#include "mplay_devicemanager_fi_typesJsonPrivate.h"
#include "mplay_shared_fi_typesConst.h"
#include "mplay_shared_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "DevManagerNotifyConnectionStatus"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifyConnectionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevicetype()) {
        yajl_gen_string(g, (const unsigned char*)  "Devicetype" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& o1 = value.getDevicetype();
        {
            ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasUndervoltage()) {
        yajl_gen_string(g, (const unsigned char*)  "Undervoltage" , 12);
        yajl_gen_bool(g, (bool)value.getUndervoltage());
    }
    if (!isSparse || value.hasUSBPortList()) {
        yajl_gen_string(g, (const unsigned char*)  "USBPortList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& o3 = value.getUSBPortList();
        {
            ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifyConnectionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerNotifyConnectionGet"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifyConnectionGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevicetype()) {
        yajl_gen_string(g, (const unsigned char*)  "Devicetype" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& o5 = value.getDevicetype();
        {
            ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifyConnectionGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerNotifySDCardStatus"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifySDCardStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSDCardList()) {
        yajl_gen_string(g, (const unsigned char*)  "SDCardList" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& o7 = value.getSDCardList();
        {
            ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifySDCardStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerOverTempCDStatus"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerOverTempCDStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOverTemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "OverTemperature" , 15);
        yajl_gen_bool(g, (bool)value.getOverTemperature());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerOverTempCDStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerOverTempCDSet"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerOverTempCDSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOverTemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "OverTemperature" , 15);
        yajl_gen_bool(g, (bool)value.getOverTemperature());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerOverTempCDSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerTelematicsBoxAliveStatus"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBTAConnectionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "BTAConnectionStatus" , 19);
        yajl_gen_bool(g, (bool)value.getBTAConnectionStatus());
    }
    if (!isSparse || value.hasTimoutBeforeSendingITC()) {
        yajl_gen_string(g, (const unsigned char*)  "TimoutBeforeSendingITC" , 22);
        yajl_gen_integer(g, (long long)value.getTimoutBeforeSendingITC());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerTelematicsBoxAliveSet"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBTAConnectionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "BTAConnectionStatus" , 19);
        yajl_gen_bool(g, (bool)value.getBTAConnectionStatus());
    }
    if (!isSparse || value.hasTimoutBeforeSendingITC()) {
        yajl_gen_string(g, (const unsigned char*)  "TimoutBeforeSendingITC" , 22);
        yajl_gen_integer(g, (long long)value.getTimoutBeforeSendingITC());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerNotifySlotStateOpticalDiscStatus"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifySlotStateOpticalDiscStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOpticalDiscSlotState()) {
        yajl_gen_string(g, (const unsigned char*)  "OpticalDiscSlotState" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& o9 = value.getOpticalDiscSlotState();
        {
            ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                const char* s = ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType_Name((*o8));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o8));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifySlotStateOpticalDiscStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerNotifyCDInfoStatus"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifyCDInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCDInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "CDInfo" , 6);
        serializeJson(value.getCDInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerNotifyCDInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerDVDDriveInfoSet"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerDVDDriveInfoSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DVDDiscType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DVDDiscType" , 13);
        const char* s = ::mplay_devicemanager_fi_types::T_e8_MDVDDiscType_Name(value.getE8DVDDiscType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DVDDiscType());
    }
    if (!isSparse || value.hasE8DVDDriveMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DVDDriveMode" , 14);
        const char* s = ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode_Name(value.getE8DVDDriveMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DVDDriveMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerDVDDriveInfoSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerMountCDROMInternalStart"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerMountCDROMInternalStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMount()) {
        yajl_gen_string(g, (const unsigned char*)  "Mount" , 5);
        yajl_gen_bool(g, (bool)value.getMount());
    }
    if (!isSparse || value.hasBlockDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "BlockDevice" , 11);
        const char *s = value.getBlockDevice().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerMountCDROMInternalStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerMountCDROMInternalResult"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerMountCDROMInternalResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "Success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerMountCDROMInternalResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerEjectOpticalDiscStart"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerEjectOpticalDiscStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasECmdParam()) {
        yajl_gen_string(g, (const unsigned char*)  "eCmdParam" , 9);
        const char* s = ::mplay_shared_fi_types::T_e8_EjectParmType_Name(value.getECmdParam());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getECmdParam());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerEjectOpticalDiscStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerEjectOpticalDiscResult"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerEjectOpticalDiscResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasServiceStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceStatus" , 13);
        const char* s = ::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult_Name(value.getServiceStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getServiceStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerEjectOpticalDiscResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerAddTelematicsBoxStart"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerAddTelematicsBoxStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVendorID()) {
        yajl_gen_string(g, (const unsigned char*)  "VendorID" , 8);
        yajl_gen_integer(g, (long long)value.getVendorID());
    }
    if (!isSparse || value.hasProductID()) {
        yajl_gen_string(g, (const unsigned char*)  "ProductID" , 9);
        yajl_gen_integer(g, (long long)value.getProductID());
    }
    if (!isSparse || value.hasUSBPortNo()) {
        yajl_gen_string(g, (const unsigned char*)  "USBPortNo" , 9);
        yajl_gen_integer(g, (long long)value.getUSBPortNo());
    }
    if (!isSparse || value.hasSpeedInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "SpeedInfo" , 9);
        const char* s = ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb_Name(value.getSpeedInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSpeedInfo());
    }
    if (!isSparse || value.hasAdd()) {
        yajl_gen_string(g, (const unsigned char*)  "Add" , 3);
        yajl_gen_bool(g, (bool)value.getAdd());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerAddTelematicsBoxStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerAddTelematicsBoxResult"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerAddTelematicsBoxResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "Success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerAddTelematicsBoxResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerSetConfigurationValueStart"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerSetConfigurationValueStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfigurationParam()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigurationParam" , 18);
        const char *s = value.getConfigurationParam().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "Value" , 5);
        yajl_gen_integer(g, (long long)value.getValue());
    }
    if (!isSparse || value.hasSettingsMode()) {
        yajl_gen_string(g, (const unsigned char*)  "SettingsMode" , 12);
        const char* s = ::mplay_devicemanager_fi_types::T_e8_SettingsMode_Name(value.getSettingsMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSettingsMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerSetConfigurationValueStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerSetConfigurationValueResult"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerSetConfigurationValueResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "Success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerSetConfigurationValueResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerGetConfigurationValueStart"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetConfigurationValueStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfigurationParam()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigurationParam" , 18);
        const char *s = value.getConfigurationParam().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetConfigurationValueStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerGetConfigurationValueResult"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetConfigurationValueResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "Value" , 5);
        yajl_gen_integer(g, (long long)value.getValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetConfigurationValueResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerAddExternalHubStart"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerAddExternalHubStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVendorID()) {
        yajl_gen_string(g, (const unsigned char*)  "VendorID" , 8);
        yajl_gen_integer(g, (long long)value.getVendorID());
    }
    if (!isSparse || value.hasProductID()) {
        yajl_gen_string(g, (const unsigned char*)  "ProductID" , 9);
        yajl_gen_integer(g, (long long)value.getProductID());
    }
    if (!isSparse || value.hasUSBPortNo()) {
        yajl_gen_string(g, (const unsigned char*)  "USBPortNo" , 9);
        yajl_gen_integer(g, (long long)value.getUSBPortNo());
    }
    if (!isSparse || value.hasAdd()) {
        yajl_gen_string(g, (const unsigned char*)  "Add" , 3);
        yajl_gen_bool(g, (bool)value.getAdd());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerAddExternalHubStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerAddExternalHubResult"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerAddExternalHubResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "Success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerAddExternalHubResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerGetDevPropertiesStart"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetDevPropertiesStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceSerialNo()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceSerialNo" , 14);
        const char *s = value.getDeviceSerialNo().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetDevPropertiesStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerGetDevPropertiesResult"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetDevPropertiesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceProperty()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceProperty" , 14);
        serializeJson(value.getDeviceProperty(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetDevPropertiesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevManagerGetAllConnectedDevicesResult"

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetAllConnectedDevicesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevInfoArr()) {
        yajl_gen_string(g, (const unsigned char*)  "DevInfoArr" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& o11 = value.getDevInfoArr();
        {
            ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_devicemanager_fi::DevManagerGetAllConnectedDevicesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerNotifyConnectionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerNotifyConnectionGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerNotifySDCardStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerOverTempCDStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerOverTempCDSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerNotifySlotStateOpticalDiscStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerNotifyCDInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerDVDDriveInfoSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerMountCDROMInternalStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerMountCDROMInternalResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerEjectOpticalDiscStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerEjectOpticalDiscResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerAddTelematicsBoxStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerAddTelematicsBoxResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerSetConfigurationValueStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerSetConfigurationValueResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerGetConfigurationValueStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerGetConfigurationValueResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerAddExternalHubStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerAddExternalHubResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerGetDevPropertiesStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerGetDevPropertiesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi
using namespace ::asf::stream::json;

namespace mplay_devicemanager_fi {

std::ostream& operator<<(std::ostream& o, const ::mplay_devicemanager_fi::DevManagerGetAllConnectedDevicesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_devicemanager_fi

