#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_DEVICEMANAGER_FI_H
#define MPLAY_DEVICEMANAGER_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "mplay_devicemanager_fi_types.h"
#include "mplay_devicemanager_fi_typesConst.h"
#include "mplay_shared_fi_types.h"
#include "mplay_shared_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'mplay_devicemanager_fi'
 *
 * Fullname: VD_DeviceManager Functional Interface
 *
 * Version: $Revision: 1.3 $
 *
 * Author: Christian Koechling,Thomas Masczyk, Lars Fiebing,Rajeev Narayanan Sambhu
 *
 * Date: $Date: 08.11.2013 $
 *
 * Department: CM-AI/PJ-GM55
 *
 * Title: Devicemanager_fi
 *
 * <b>Description of 'mplay_devicemanager_fi':</b>
 */

namespace mplay_devicemanager_fi {

static const int SERVICE_ID = 94;

static const int FID_DevManagerNotifyConnection = 256;

static const int FID_DevManagerNotifySDCard = 257;

static const int FID_DevManagerOverTempCD = 258;

static const int FID_DevManagerTelematicsBoxAlive = 259;

static const int FID_DevManagerNotifySlotStateOpticalDisc = 260;

static const int FID_DevManagerNotifyCDInfo = 261;

static const int FID_DevManagerDVDDriveInfo = 262;

static const int FID_DevManagerMountCDROMInternal = 1024;

static const int FID_DevManagerEjectOpticalDisc = 1025;

static const int FID_DevManagerAddTelematicsBox = 1026;

static const int FID_DevManagerSetConfigurationValue = 1027;

static const int FID_DevManagerGetConfigurationValue = 1028;

static const int FID_DevManagerAddExternalHub = 1031;

static const int FID_DevManagerGetDevProperties = 1029;

static const int FID_DevManagerGetAllConnectedDevices = 1030;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 3;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class DevManagerNotifyConnectionStatus;

class DevManagerNotifyConnectionGet;

class DevManagerNotifySDCardStatus;

class DevManagerOverTempCDStatus;

class DevManagerOverTempCDSet;

class DevManagerTelematicsBoxAliveStatus;

class DevManagerTelematicsBoxAliveSet;

class DevManagerNotifySlotStateOpticalDiscStatus;

class DevManagerNotifyCDInfoStatus;

class DevManagerDVDDriveInfoSet;

class DevManagerMountCDROMInternalStart;

class DevManagerMountCDROMInternalResult;

class DevManagerEjectOpticalDiscStart;

class DevManagerEjectOpticalDiscResult;

class DevManagerAddTelematicsBoxStart;

class DevManagerAddTelematicsBoxResult;

class DevManagerSetConfigurationValueStart;

class DevManagerSetConfigurationValueResult;

class DevManagerGetConfigurationValueStart;

class DevManagerGetConfigurationValueResult;

class DevManagerAddExternalHubStart;

class DevManagerAddExternalHubResult;

class DevManagerGetDevPropertiesStart;

class DevManagerGetDevPropertiesResult;

class DevManagerGetAllConnectedDevicesResult;

// type definitions
/**
 * The upreg message of the property "DevManagerNotifyConnection"
 * This property provides notification about new device connection. The notification includes insertion of a new device into the system, device type of inserted device, device serial number, device version and mount point or user path where the device has been mounted.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifyConnectionUpReg;

/**
 * The relUpReg message of the property "DevManagerNotifyConnection"
 * This property provides notification about new device connection. The notification includes insertion of a new device into the system, device type of inserted device, device serial number, device version and mount point or user path where the device has been mounted.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifyConnectionRelUpReg;

/**
 * The error message of 'DevManagerNotifyConnection'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerNotifyConnectionError;

/**
 * The get message of the property "DevManagerNotifySDCard"
 * This property provides notification about new SD Card device insertion. The notification includes type and state of card, device serial number, Card Identifier Register, total size and further information.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifySDCardGet;

/**
 * The upreg message of the property "DevManagerNotifySDCard"
 * This property provides notification about new SD Card device insertion. The notification includes type and state of card, device serial number, Card Identifier Register, total size and further information.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifySDCardUpReg;

/**
 * The relUpReg message of the property "DevManagerNotifySDCard"
 * This property provides notification about new SD Card device insertion. The notification includes type and state of card, device serial number, Card Identifier Register, total size and further information.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifySDCardRelUpReg;

/**
 * The error message of 'DevManagerNotifySDCard'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerNotifySDCardError;

/**
 * The get message of the property "DevManagerOverTempCD"
 * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerOverTempCDGet;

/**
 * The upreg message of the property "DevManagerOverTempCD"
 * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerOverTempCDUpReg;

/**
 * The relUpReg message of the property "DevManagerOverTempCD"
 * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerOverTempCDRelUpReg;

/**
 * The error message of 'DevManagerOverTempCD'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerOverTempCDError;

/**
 * The get message of the property "DevManagerTelematicsBoxAlive"
 * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
 * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
 * .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerTelematicsBoxAliveGet;

/**
 * The upreg message of the property "DevManagerTelematicsBoxAlive"
 * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
 * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
 * .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerTelematicsBoxAliveUpReg;

/**
 * The relUpReg message of the property "DevManagerTelematicsBoxAlive"
 * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
 * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
 * .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerTelematicsBoxAliveRelUpReg;

/**
 * The error message of 'DevManagerTelematicsBoxAlive'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerTelematicsBoxAliveError;

/**
 * The get message of the property "DevManagerNotifySlotStateOpticalDisc"
 * Used to notify about the connection status of Optical disks.The VD_Devicemanager gets the information from
 * VD_Mediamanager component.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifySlotStateOpticalDiscGet;

/**
 * The upreg message of the property "DevManagerNotifySlotStateOpticalDisc"
 * Used to notify about the connection status of Optical disks.The VD_Devicemanager gets the information from
 * VD_Mediamanager component.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifySlotStateOpticalDiscUpReg;

/**
 * The relUpReg message of the property "DevManagerNotifySlotStateOpticalDisc"
 * Used to notify about the connection status of Optical disks.The VD_Devicemanager gets the information from
 * VD_Mediamanager component.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifySlotStateOpticalDiscRelUpReg;

/**
 * The error message of 'DevManagerNotifySlotStateOpticalDisc'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerNotifySlotStateOpticalDiscError;

/**
 * The get message of the property "DevManagerNotifyCDInfo"
 * This property gives Driver Version and Device State details about the Optical Device- CDMP3,CDDA .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifyCDInfoGet;

/**
 * The upreg message of the property "DevManagerNotifyCDInfo"
 * This property gives Driver Version and Device State details about the Optical Device- CDMP3,CDDA .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifyCDInfoUpReg;

/**
 * The relUpReg message of the property "DevManagerNotifyCDInfo"
 * This property gives Driver Version and Device State details about the Optical Device- CDMP3,CDDA .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerNotifyCDInfoRelUpReg;

/**
 * The error message of 'DevManagerNotifyCDInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerNotifyCDInfoError;

/**
 * The status message of the property "DevManagerDVDDriveInfo"
 * This will give dvd drive info necessary for device
 * manager. Using this, Disctype and DriveMode of the DVD drive(info fetched from Driver) can be obtained.
 * Devicemanager operations based on this info can be done.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerDVDDriveInfoStatus;

/**
 * The upreg message of the property "DevManagerDVDDriveInfo"
 * This will give dvd drive info necessary for device
 * manager. Using this, Disctype and DriveMode of the DVD drive(info fetched from Driver) can be obtained.
 * Devicemanager operations based on this info can be done.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerDVDDriveInfoUpReg;

/**
 * The relUpReg message of the property "DevManagerDVDDriveInfo"
 * This will give dvd drive info necessary for device
 * manager. Using this, Disctype and DriveMode of the DVD drive(info fetched from Driver) can be obtained.
 * Devicemanager operations based on this info can be done.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerDVDDriveInfoRelUpReg;

/**
 * The error message of 'DevManagerDVDDriveInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerDVDDriveInfoError;

/**
 * The abort error message of the method "DevManagerMountCDROMInternal"
 * If a CDROM is inserted to the internal CDDrive then this method is used by diagnosis to mount it.
 * This command is especially used if the CDROM is a MixMode CD. This is use case in the production diagnosis.
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerMountCDROMInternalAbortError;

/**
 * The error message of 'DevManagerMountCDROMInternal'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerMountCDROMInternalError;

/**
 * The abort error message of the method "DevManagerEjectOpticalDisc"
 * Eject or insert optical disc
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerEjectOpticalDiscAbortError;

/**
 * The error message of 'DevManagerEjectOpticalDisc'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerEjectOpticalDiscError;

/**
 * The abort error message of the method "DevManagerAddTelematicsBox"
 * Add or delete a Telematics box.
 * If this function is called VD_DVM uses datapool to store value permanently.
 * Although device might have been notified by udev - after the call of this
 * fi function VD_DVM will check again if such new added device is already connected to send the diagnosis info.
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerAddTelematicsBoxAbortError;

/**
 * The error message of 'DevManagerAddTelematicsBox'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerAddTelematicsBoxError;

/**
 * The abort error message of the method "DevManagerSetConfigurationValue"
 * Provides a way to alter the configuration of vd_devicemanager( see ConfigurationBase.h and ConfigurationBase.cpp )
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerSetConfigurationValueAbortError;

/**
 * The error message of 'DevManagerSetConfigurationValue'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerSetConfigurationValueError;

/**
 * The abort error message of the method "DevManagerGetConfigurationValue"
 * Provides a way to  fetch the configuration of vd_devicemanager( see ConfigurationBase.h and ConfigurationBase.cpp)
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerGetConfigurationValueAbortError;

/**
 * The error message of 'DevManagerGetConfigurationValue'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerGetConfigurationValueError;

/**
 * The abort error message of the method "DevManagerAddExternalHub"
 * Add or delete an ExternalHub device.
 * If this function is called VD_DVM uses datapool to store value permanently.
 * Although device might have been notified by udev - after the call of this
 * fi function VD_DVM will check again if such new added device is already connected to send the diagnosis info.
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerAddExternalHubAbortError;

/**
 * The error message of 'DevManagerAddExternalHub'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerAddExternalHubError;

/**
 * The abort error message of the method "DevManagerGetDevProperties"
 * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
 * This method provides device properties of a connected device as specified by the requesting registered FBlock based on the device serial number.
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerGetDevPropertiesAbortError;

/**
 * The error message of 'DevManagerGetDevProperties'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerGetDevPropertiesError;

/**
 * The start message of the method "DevManagerGetAllConnectedDevices"
 * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
 * This method provides device properties of all connected device during power up. The CCA components after getting started can use this method to retrieve information of all connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevManagerGetAllConnectedDevicesStart;

/**
 * The abort error message of the method "DevManagerGetAllConnectedDevices"
 * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
 * This method provides device properties of all connected device during power up. The CCA components after getting started can use this method to retrieve information of all connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerGetAllConnectedDevicesAbortError;

/**
 * The error message of 'DevManagerGetAllConnectedDevices'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError DevManagerGetAllConnectedDevicesError;


/**
 * The status message of the property "DevManagerNotifyConnection"
 * This property provides notification about new device connection. The notification includes insertion of a new device into the system, device type of inserted device, device serial number, device version and mount point or user path where the device has been mounted.
 */
class DevManagerNotifyConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerNotifyConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  DevManagerNotifyConnectionStatus (const DevManagerNotifyConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerNotifyConnectionStatus (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& Devicetype_, bool Undervoltage_, const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& USBPortList_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerNotifyConnectionStatus();

    /**
     * Assignment operator
     */
    inline DevManagerNotifyConnectionStatus& operator = (const DevManagerNotifyConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerNotifyConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerNotifyConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerNotifyConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerNotifyConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Devicetype"

    static const int kDevicetype = 0;

    /**
     * Clears the field "Devicetype".
     *
     * The field will be set to its default value. The hasDevicetype()
     * method will return false.
     */
    inline void clearDevicetype();

    /**
     * Checks whether the field "Devicetype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevicetype()). Otherwise it will return false.
     */
    inline bool hasDevicetype () const;

    /**
     * Returns the value of the member "Devicetype".
     *
     * List of device properties.
     * The  will behave differently based on the feature switch enabled in project.
     * In the first approach if the variant switch VARIANT_S_FTR_ENABLE_DEVMGR_IMPROVEDIF_NO_REDUNDAND_MSGS is not enabled, the device list will send as the following.
     * <p>index=0       : contains device property of last notified device. I.e. in this manner device removal can be observed</p>
     * <p>Index=1...last: holds device properties of all connected devices</p>
     * In the Second approach,if the variant switch VARIANT_S_FTR_ENABLE_DEVMGR_IMPROVEDIF_NO_REDUNDAND_MSGS is enabled, the device list will send as the following.
     * <p>Index=0...last: holds device properties of all connected devices. Ie, List will updated based on the order it is connected in system.
     * The last connected device will be at the end of the list</p>
     *
     * @return The value of the field "Devicetype"
     */
    inline const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& getDevicetype () const;

    /**
     * Retrieves the value of the field "Devicetype" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Devicetype".
     */
    inline ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& getDevicetypeMutable ();

    /**
     * Sets the value of the member "Devicetype".
     *
     * List of device properties.
     * The  will behave differently based on the feature switch enabled in project.
     * In the first approach if the variant switch VARIANT_S_FTR_ENABLE_DEVMGR_IMPROVEDIF_NO_REDUNDAND_MSGS is not enabled, the device list will send as the following.
     * <p>index=0       : contains device property of last notified device. I.e. in this manner device removal can be observed</p>
     * <p>Index=1...last: holds device properties of all connected devices</p>
     * In the Second approach,if the variant switch VARIANT_S_FTR_ENABLE_DEVMGR_IMPROVEDIF_NO_REDUNDAND_MSGS is enabled, the device list will send as the following.
     * <p>Index=0...last: holds device properties of all connected devices. Ie, List will updated based on the order it is connected in system.
     * The last connected device will be at the end of the list</p>
     *
     * @param Devicetype The value which will be set
     */
    inline void setDevicetype (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& Devicetype_);

    // API of field "Undervoltage"

    static const int kUndervoltage = 1;

    /**
     * Clears the field "Undervoltage".
     *
     * The field will be set to its default value. The hasUndervoltage()
     * method will return false.
     */
    inline void clearUndervoltage();

    /**
     * Checks whether the field "Undervoltage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUndervoltage()). Otherwise it will return false.
     */
    inline bool hasUndervoltage () const;

    /**
     * Returns the value of the member "Undervoltage".
     *
     * if under voltage is notified to VD_DeviceManager by platform this parameter is used to inform clients.
     * Connected clients like MediaPlayer listen to this value to react with appropriate user scenario.
     * Reference: https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-568086/DESIGN_13024UndervoltageVoltageHandling.doc
     *
     * @return The value of the field "Undervoltage"
     */
    inline bool getUndervoltage () const;

    /**
     * Sets the value of the member "Undervoltage".
     *
     * if under voltage is notified to VD_DeviceManager by platform this parameter is used to inform clients.
     * Connected clients like MediaPlayer listen to this value to react with appropriate user scenario.
     * Reference: https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-568086/DESIGN_13024UndervoltageVoltageHandling.doc
     *
     * @param Undervoltage The value which will be set
     */
    inline void setUndervoltage (bool Undervoltage_);

    // API of field "USBPortList"

    static const int kUSBPortList = 2;

    /**
     * Clears the field "USBPortList".
     *
     * The field will be set to its default value. The hasUSBPortList()
     * method will return false.
     */
    inline void clearUSBPortList();

    /**
     * Checks whether the field "USBPortList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBPortList()). Otherwise it will return false.
     */
    inline bool hasUSBPortList () const;

    /**
     * Returns the value of the member "USBPortList".
     *
     * List of physical usb ports. The number of such a port appears in T_DevManager_DeviceProperty in field USBPortNo.
     * T_DevManager_PortStates contains information e.g. about overcurrent of such port.
     *
     * @return The value of the field "USBPortList"
     */
    inline const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& getUSBPortList () const;

    /**
     * Retrieves the value of the field "USBPortList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "USBPortList".
     */
    inline ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& getUSBPortListMutable ();

    /**
     * Sets the value of the member "USBPortList".
     *
     * List of physical usb ports. The number of such a port appears in T_DevManager_DeviceProperty in field USBPortNo.
     * T_DevManager_PortStates contains information e.g. about overcurrent of such port.
     *
     * @param USBPortList The value which will be set
     */
    inline void setUSBPortList (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& USBPortList_);

    static const DevManagerNotifyConnectionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& getT_DevManager_DevicePropertyList_DefaultInstance ();

    static const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& getT_DevManager_PortStatesList_DefaultInstance ();

    inline void set_has_Devicetype ();

    inline void clear_has_Devicetype ();

    inline void set_has_Undervoltage ();

    inline void clear_has_Undervoltage ();

    inline void set_has_USBPortList ();

    inline void clear_has_USBPortList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty > _Devicetype;

    bool _Undervoltage;

    ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates > _USBPortList;

};

/**
 * The get message of the property "DevManagerNotifyConnection"
 * This property provides notification about new device connection. The notification includes insertion of a new device into the system, device type of inserted device, device serial number, device version and mount point or user path where the device has been mounted.
 */
class DevManagerNotifyConnectionGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerNotifyConnectionGet ();

    /**
     * Copy constructor
     */
    inline  DevManagerNotifyConnectionGet (const DevManagerNotifyConnectionGet &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerNotifyConnectionGet (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& Devicetype_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerNotifyConnectionGet();

    /**
     * Assignment operator
     */
    inline DevManagerNotifyConnectionGet& operator = (const DevManagerNotifyConnectionGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerNotifyConnectionGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerNotifyConnectionGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerNotifyConnectionGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerNotifyConnectionGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Devicetype"

    static const int kDevicetype = 0;

    /**
     * Clears the field "Devicetype".
     *
     * The field will be set to its default value. The hasDevicetype()
     * method will return false.
     */
    inline void clearDevicetype();

    /**
     * Checks whether the field "Devicetype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevicetype()). Otherwise it will return false.
     */
    inline bool hasDevicetype () const;

    /**
     * Returns the value of the member "Devicetype".
     *
     * Provides the device connection status and properties associated with device.
     *
     * @return The value of the field "Devicetype"
     */
    inline const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& getDevicetype () const;

    /**
     * Retrieves the value of the field "Devicetype" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Devicetype".
     */
    inline ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& getDevicetypeMutable ();

    /**
     * Sets the value of the member "Devicetype".
     *
     * Provides the device connection status and properties associated with device.
     *
     * @param Devicetype The value which will be set
     */
    inline void setDevicetype (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& Devicetype_);

    static const DevManagerNotifyConnectionGet &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& getT_DevManager_DevicePropertyList_DefaultInstance ();

    inline void set_has_Devicetype ();

    inline void clear_has_Devicetype ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty > _Devicetype;

};

/**
 * The status message of the property "DevManagerNotifySDCard"
 * This property provides notification about new SD Card device insertion. The notification includes type and state of card, device serial number, Card Identifier Register, total size and further information.
 */
class DevManagerNotifySDCardStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerNotifySDCardStatus ();

    /**
     * Copy constructor
     */
    inline  DevManagerNotifySDCardStatus (const DevManagerNotifySDCardStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerNotifySDCardStatus (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& SDCardList_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerNotifySDCardStatus();

    /**
     * Assignment operator
     */
    inline DevManagerNotifySDCardStatus& operator = (const DevManagerNotifySDCardStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerNotifySDCardStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerNotifySDCardStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerNotifySDCardStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerNotifySDCardStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SDCardList"

    static const int kSDCardList = 0;

    /**
     * Clears the field "SDCardList".
     *
     * The field will be set to its default value. The hasSDCardList()
     * method will return false.
     */
    inline void clearSDCardList();

    /**
     * Checks whether the field "SDCardList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDCardList()). Otherwise it will return false.
     */
    inline bool hasSDCardList () const;

    /**
     * Returns the value of the member "SDCardList".
     *
     * List of all SD Cards (via SD Card slot, not via USB SD Card adapter) of a device.
     *
     * @return The value of the field "SDCardList"
     */
    inline const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& getSDCardList () const;

    /**
     * Retrieves the value of the field "SDCardList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SDCardList".
     */
    inline ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& getSDCardListMutable ();

    /**
     * Sets the value of the member "SDCardList".
     *
     * List of all SD Cards (via SD Card slot, not via USB SD Card adapter) of a device.
     *
     * @param SDCardList The value which will be set
     */
    inline void setSDCardList (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& SDCardList_);

    static const DevManagerNotifySDCardStatus &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& getT_DevManager_SDCardInfoList_DefaultInstance ();

    inline void set_has_SDCardList ();

    inline void clear_has_SDCardList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo > _SDCardList;

};

/**
 * The status message of the property "DevManagerOverTempCD"
 * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
 */
class DevManagerOverTempCDStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerOverTempCDStatus ();

    /**
     * Copy constructor
     */
    inline  DevManagerOverTempCDStatus (const DevManagerOverTempCDStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerOverTempCDStatus (bool OverTemperature_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerOverTempCDStatus();

    /**
     * Assignment operator
     */
    inline DevManagerOverTempCDStatus& operator = (const DevManagerOverTempCDStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerOverTempCDStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerOverTempCDStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerOverTempCDStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerOverTempCDStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OverTemperature"

    static const int kOverTemperature = 0;

    /**
     * Clears the field "OverTemperature".
     *
     * The field will be set to its default value. The hasOverTemperature()
     * method will return false.
     */
    inline void clearOverTemperature();

    /**
     * Checks whether the field "OverTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOverTemperature()). Otherwise it will return false.
     */
    inline bool hasOverTemperature () const;

    /**
     * Returns the value of the member "OverTemperature".
     *
     * FALSE (default), if it's OK (from temperature point of view) to play an inserted CD.
     *
     * @return The value of the field "OverTemperature"
     */
    inline bool getOverTemperature () const;

    /**
     * Sets the value of the member "OverTemperature".
     *
     * FALSE (default), if it's OK (from temperature point of view) to play an inserted CD.
     *
     * @param OverTemperature The value which will be set
     */
    inline void setOverTemperature (bool OverTemperature_);

    static const DevManagerOverTempCDStatus &getDefaultInstance();

private:

    inline void set_has_OverTemperature ();

    inline void clear_has_OverTemperature ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _OverTemperature;

};

/**
 * The set message of the property "DevManagerOverTempCD"
 * Holds information about overtemperature. Origin of information is in FC-Heatcontrol.
 * <p>FC HeatCtrl uses this message to inform VD_DVM about the actual over temperature status.</p>
 */
class DevManagerOverTempCDSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerOverTempCDSet ();

    /**
     * Copy constructor
     */
    inline  DevManagerOverTempCDSet (const DevManagerOverTempCDSet &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerOverTempCDSet (bool OverTemperature_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerOverTempCDSet();

    /**
     * Assignment operator
     */
    inline DevManagerOverTempCDSet& operator = (const DevManagerOverTempCDSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerOverTempCDSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerOverTempCDSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerOverTempCDSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerOverTempCDSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OverTemperature"

    static const int kOverTemperature = 0;

    /**
     * Clears the field "OverTemperature".
     *
     * The field will be set to its default value. The hasOverTemperature()
     * method will return false.
     */
    inline void clearOverTemperature();

    /**
     * Checks whether the field "OverTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOverTemperature()). Otherwise it will return false.
     */
    inline bool hasOverTemperature () const;

    /**
     * Returns the value of the member "OverTemperature".
     *
     * <p>FALSE: No over temperature.</p>
     * <p>TRUE:  Playing CDs should be blocked due to over temperature. This is done by informing MEdiaplayer via via T_DevManager_DeviceProperty</p>
     *
     * @return The value of the field "OverTemperature"
     */
    inline bool getOverTemperature () const;

    /**
     * Sets the value of the member "OverTemperature".
     *
     * <p>FALSE: No over temperature.</p>
     * <p>TRUE:  Playing CDs should be blocked due to over temperature. This is done by informing MEdiaplayer via via T_DevManager_DeviceProperty</p>
     *
     * @param OverTemperature The value which will be set
     */
    inline void setOverTemperature (bool OverTemperature_);

    static const DevManagerOverTempCDSet &getDefaultInstance();

private:

    inline void set_has_OverTemperature ();

    inline void clear_has_OverTemperature ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _OverTemperature;

};

/**
 * The status message of the property "DevManagerTelematicsBoxAlive"
 * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
 * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
 * .
 */
class DevManagerTelematicsBoxAliveStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerTelematicsBoxAliveStatus ();

    /**
     * Copy constructor
     */
    inline  DevManagerTelematicsBoxAliveStatus (const DevManagerTelematicsBoxAliveStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerTelematicsBoxAliveStatus (bool BTAConnectionStatus_, uint32 TimoutBeforeSendingITC_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerTelematicsBoxAliveStatus();

    /**
     * Assignment operator
     */
    inline DevManagerTelematicsBoxAliveStatus& operator = (const DevManagerTelematicsBoxAliveStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerTelematicsBoxAliveStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerTelematicsBoxAliveStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerTelematicsBoxAliveStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerTelematicsBoxAliveStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTAConnectionStatus"

    static const int kBTAConnectionStatus = 0;

    /**
     * Clears the field "BTAConnectionStatus".
     *
     * The field will be set to its default value. The hasBTAConnectionStatus()
     * method will return false.
     */
    inline void clearBTAConnectionStatus();

    /**
     * Checks whether the field "BTAConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTAConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasBTAConnectionStatus () const;

    /**
     * Returns the value of the member "BTAConnectionStatus".
     *
     * FALSE (default), The connection status is failure by default.
     *
     * @return The value of the field "BTAConnectionStatus"
     */
    inline bool getBTAConnectionStatus () const;

    /**
     * Sets the value of the member "BTAConnectionStatus".
     *
     * FALSE (default), The connection status is failure by default.
     *
     * @param BTAConnectionStatus The value which will be set
     */
    inline void setBTAConnectionStatus (bool BTAConnectionStatus_);

    // API of field "TimoutBeforeSendingITC"

    static const int kTimoutBeforeSendingITC = 1;

    /**
     * Clears the field "TimoutBeforeSendingITC".
     *
     * The field will be set to its default value. The hasTimoutBeforeSendingITC()
     * method will return false.
     */
    inline void clearTimoutBeforeSendingITC();

    /**
     * Checks whether the field "TimoutBeforeSendingITC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimoutBeforeSendingITC()). Otherwise it will return false.
     */
    inline bool hasTimoutBeforeSendingITC () const;

    /**
     * Returns the value of the member "TimoutBeforeSendingITC".
     *
     * The timeout value is set by FC_ATP. VD_DVM has an internal default value if FC_ATP has not set this yet.
     * The VD_DVM waits till this timeout value exceeds before it sends the BTA specific ITCs e.g. ITC_LINK_DISABLED
     * IF FC_ATP sets this value to 0 this means it does not want to change the value at VD_DVM.
     *
     * @return The value of the field "TimoutBeforeSendingITC"
     */
    inline uint32 getTimoutBeforeSendingITC () const;

    /**
     * Sets the value of the member "TimoutBeforeSendingITC".
     *
     * The timeout value is set by FC_ATP. VD_DVM has an internal default value if FC_ATP has not set this yet.
     * The VD_DVM waits till this timeout value exceeds before it sends the BTA specific ITCs e.g. ITC_LINK_DISABLED
     * IF FC_ATP sets this value to 0 this means it does not want to change the value at VD_DVM.
     *
     * @param TimoutBeforeSendingITC The value which will be set
     */
    inline void setTimoutBeforeSendingITC (uint32 TimoutBeforeSendingITC_);

    static const DevManagerTelematicsBoxAliveStatus &getDefaultInstance();

private:

    inline void set_has_BTAConnectionStatus ();

    inline void clear_has_BTAConnectionStatus ();

    inline void set_has_TimoutBeforeSendingITC ();

    inline void clear_has_TimoutBeforeSendingITC ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _BTAConnectionStatus;

    uint32 _TimoutBeforeSendingITC;

};

/**
 * The set message of the property "DevManagerTelematicsBoxAlive"
 * Holds information about Connection status of Telematics Box.Origin of information is in FC_ATP.
 * Also the FC_ATP will set the timeout that the VD_DVM use to wait before sending the ITC specific to BTA
 * .
 * <p>FC_ATP will use this property (BTAConnectionStatus)   to announce to VD_DeviceManager if the application layer communication to BTA is still alive .</p>
 * <p>FC_ATP will use this property (TimoutBeforeSendingITC)to announce to VD_DeviceManager new value to wait before sending a ITC_LINK_DISABLED .</p>
 */
class DevManagerTelematicsBoxAliveSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerTelematicsBoxAliveSet ();

    /**
     * Copy constructor
     */
    inline  DevManagerTelematicsBoxAliveSet (const DevManagerTelematicsBoxAliveSet &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerTelematicsBoxAliveSet (bool BTAConnectionStatus_, uint32 TimoutBeforeSendingITC_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerTelematicsBoxAliveSet();

    /**
     * Assignment operator
     */
    inline DevManagerTelematicsBoxAliveSet& operator = (const DevManagerTelematicsBoxAliveSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerTelematicsBoxAliveSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerTelematicsBoxAliveSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerTelematicsBoxAliveSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerTelematicsBoxAliveSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTAConnectionStatus"

    static const int kBTAConnectionStatus = 0;

    /**
     * Clears the field "BTAConnectionStatus".
     *
     * The field will be set to its default value. The hasBTAConnectionStatus()
     * method will return false.
     */
    inline void clearBTAConnectionStatus();

    /**
     * Checks whether the field "BTAConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTAConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasBTAConnectionStatus () const;

    /**
     * Returns the value of the member "BTAConnectionStatus".
     *
     * <p>FALSE: Upper layer communication to BTA telematics box is failed.</p>
     * <p>TRUE:  Upper layer communication to BTA telematics box is alive, ie connection is established.</p>
     *
     * @return The value of the field "BTAConnectionStatus"
     */
    inline bool getBTAConnectionStatus () const;

    /**
     * Sets the value of the member "BTAConnectionStatus".
     *
     * <p>FALSE: Upper layer communication to BTA telematics box is failed.</p>
     * <p>TRUE:  Upper layer communication to BTA telematics box is alive, ie connection is established.</p>
     *
     * @param BTAConnectionStatus The value which will be set
     */
    inline void setBTAConnectionStatus (bool BTAConnectionStatus_);

    // API of field "TimoutBeforeSendingITC"

    static const int kTimoutBeforeSendingITC = 1;

    /**
     * Clears the field "TimoutBeforeSendingITC".
     *
     * The field will be set to its default value. The hasTimoutBeforeSendingITC()
     * method will return false.
     */
    inline void clearTimoutBeforeSendingITC();

    /**
     * Checks whether the field "TimoutBeforeSendingITC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimoutBeforeSendingITC()). Otherwise it will return false.
     */
    inline bool hasTimoutBeforeSendingITC () const;

    /**
     * Returns the value of the member "TimoutBeforeSendingITC".
     *
     * The timeout value is set by FC_ATP. The VD_DVM waits till this timeout value to send the BTA specific ITCs
     * IF FC_ATP sets this value to 0 this means it does not
     *
     * @return The value of the field "TimoutBeforeSendingITC"
     */
    inline uint32 getTimoutBeforeSendingITC () const;

    /**
     * Sets the value of the member "TimoutBeforeSendingITC".
     *
     * The timeout value is set by FC_ATP. The VD_DVM waits till this timeout value to send the BTA specific ITCs
     * IF FC_ATP sets this value to 0 this means it does not
     *
     * @param TimoutBeforeSendingITC The value which will be set
     */
    inline void setTimoutBeforeSendingITC (uint32 TimoutBeforeSendingITC_);

    static const DevManagerTelematicsBoxAliveSet &getDefaultInstance();

private:

    inline void set_has_BTAConnectionStatus ();

    inline void clear_has_BTAConnectionStatus ();

    inline void set_has_TimoutBeforeSendingITC ();

    inline void clear_has_TimoutBeforeSendingITC ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _BTAConnectionStatus;

    uint32 _TimoutBeforeSendingITC;

};

/**
 * The status message of the property "DevManagerNotifySlotStateOpticalDisc"
 * Used to notify about the connection status of Optical disks.The VD_Devicemanager gets the information from
 * VD_Mediamanager component.
 */
class DevManagerNotifySlotStateOpticalDiscStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerNotifySlotStateOpticalDiscStatus ();

    /**
     * Copy constructor
     */
    inline  DevManagerNotifySlotStateOpticalDiscStatus (const DevManagerNotifySlotStateOpticalDiscStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerNotifySlotStateOpticalDiscStatus (const ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& OpticalDiscSlotState_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerNotifySlotStateOpticalDiscStatus();

    /**
     * Assignment operator
     */
    inline DevManagerNotifySlotStateOpticalDiscStatus& operator = (const DevManagerNotifySlotStateOpticalDiscStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OpticalDiscSlotState"

    static const int kOpticalDiscSlotState = 0;

    /**
     * Clears the field "OpticalDiscSlotState".
     *
     * The field will be set to its default value. The hasOpticalDiscSlotState()
     * method will return false.
     */
    inline void clearOpticalDiscSlotState();

    /**
     * Checks whether the field "OpticalDiscSlotState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOpticalDiscSlotState()). Otherwise it will return false.
     */
    inline bool hasOpticalDiscSlotState () const;

    /**
     * Returns the value of the member "OpticalDiscSlotState".
     *
     * The Optical disk slot states.
     *
     * @return The value of the field "OpticalDiscSlotState"
     */
    inline const ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& getOpticalDiscSlotState () const;

    /**
     * Retrieves the value of the field "OpticalDiscSlotState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OpticalDiscSlotState".
     */
    inline ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& getOpticalDiscSlotStateMutable ();

    /**
     * Sets the value of the member "OpticalDiscSlotState".
     *
     * The Optical disk slot states.
     *
     * @param OpticalDiscSlotState The value which will be set
     */
    inline void setOpticalDiscSlotState (const ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& OpticalDiscSlotState_);

    static const DevManagerNotifySlotStateOpticalDiscStatus &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& getT_e8_SlotStateOpticalDiscTypeList_DefaultInstance ();

    inline void set_has_OpticalDiscSlotState ();

    inline void clear_has_OpticalDiscSlotState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType > _OpticalDiscSlotState;

};

/**
 * The status message of the property "DevManagerNotifyCDInfo"
 * This property gives Driver Version and Device State details about the Optical Device- CDMP3,CDDA .
 */
class DevManagerNotifyCDInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerNotifyCDInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DevManagerNotifyCDInfoStatus (const DevManagerNotifyCDInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerNotifyCDInfoStatus (const ::mplay_shared_fi_types::T_e8_CDInfo& CDInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerNotifyCDInfoStatus();

    /**
     * Assignment operator
     */
    inline DevManagerNotifyCDInfoStatus& operator = (const DevManagerNotifyCDInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerNotifyCDInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerNotifyCDInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerNotifyCDInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerNotifyCDInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CDInfo"

    static const int kCDInfo = 0;

    /**
     * Clears the field "CDInfo".
     *
     * The field will be set to its default value. The hasCDInfo()
     * method will return false.
     */
    inline void clearCDInfo();

    /**
     * Checks whether the field "CDInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCDInfo()). Otherwise it will return false.
     */
    inline bool hasCDInfo () const;

    /**
     * Returns the value of the member "CDInfo".
     *
     *
     *
     * @return The value of the field "CDInfo"
     */
    inline const ::mplay_shared_fi_types::T_e8_CDInfo& getCDInfo () const;

    /**
     * Retrieves the value of the field "CDInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CDInfo".
     */
    inline ::mplay_shared_fi_types::T_e8_CDInfo& getCDInfoMutable ();

    /**
     * Sets the value of the member "CDInfo".
     *
     *
     *
     * @param CDInfo The value which will be set
     */
    inline void setCDInfo (const ::mplay_shared_fi_types::T_e8_CDInfo& CDInfo_);

    static const DevManagerNotifyCDInfoStatus &getDefaultInstance();

private:

    inline void set_has_CDInfo ();

    inline void clear_has_CDInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_shared_fi_types::T_e8_CDInfo _CDInfo;

};

/**
 * The set message of the property "DevManagerDVDDriveInfo"
 * This will give dvd drive info necessary for device
 * manager. Using this, Disctype and DriveMode of the DVD drive(info fetched from Driver) can be obtained.
 * Devicemanager operations based on this info can be done.
 */
class DevManagerDVDDriveInfoSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerDVDDriveInfoSet ();

    /**
     * Copy constructor
     */
    inline  DevManagerDVDDriveInfoSet (const DevManagerDVDDriveInfoSet &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerDVDDriveInfoSet (::mplay_devicemanager_fi_types::T_e8_MDVDDiscType e8DVDDiscType_, ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode e8DVDDriveMode_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerDVDDriveInfoSet();

    /**
     * Assignment operator
     */
    inline DevManagerDVDDriveInfoSet& operator = (const DevManagerDVDDriveInfoSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerDVDDriveInfoSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerDVDDriveInfoSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerDVDDriveInfoSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerDVDDriveInfoSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DVDDiscType"

    static const int kE8DVDDiscType = 0;

    /**
     * Clears the field "e8DVDDiscType".
     *
     * The field will be set to its default value. The hasE8DVDDiscType()
     * method will return false.
     */
    inline void clearE8DVDDiscType();

    /**
     * Checks whether the field "e8DVDDiscType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DVDDiscType()). Otherwise it will return false.
     */
    inline bool hasE8DVDDiscType () const;

    /**
     * Returns the value of the member "e8DVDDiscType".
     *
     * This will inform whether the disc inserted is Data disc
     * or Non-Data Disc
     *
     * @return The value of the field "e8DVDDiscType"
     */
    inline ::mplay_devicemanager_fi_types::T_e8_MDVDDiscType getE8DVDDiscType () const;

    /**
     * Sets the value of the member "e8DVDDiscType".
     *
     * This will inform whether the disc inserted is Data disc
     * or Non-Data Disc
     *
     * @param e8DVDDiscType The value which will be set
     */
    inline void setE8DVDDiscType (::mplay_devicemanager_fi_types::T_e8_MDVDDiscType e8DVDDiscType_);

    // API of field "e8DVDDriveMode"

    static const int kE8DVDDriveMode = 1;

    /**
     * Clears the field "e8DVDDriveMode".
     *
     * The field will be set to its default value. The hasE8DVDDriveMode()
     * method will return false.
     */
    inline void clearE8DVDDriveMode();

    /**
     * Checks whether the field "e8DVDDriveMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DVDDriveMode()). Otherwise it will return false.
     */
    inline bool hasE8DVDDriveMode () const;

    /**
     * Returns the value of the member "e8DVDDriveMode".
     *
     * This will give the drive mode as either BackEnd Mode or
     * MassStorage Mode
     *
     * @return The value of the field "e8DVDDriveMode"
     */
    inline ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode getE8DVDDriveMode () const;

    /**
     * Sets the value of the member "e8DVDDriveMode".
     *
     * This will give the drive mode as either BackEnd Mode or
     * MassStorage Mode
     *
     * @param e8DVDDriveMode The value which will be set
     */
    inline void setE8DVDDriveMode (::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode e8DVDDriveMode_);

    static const DevManagerDVDDriveInfoSet &getDefaultInstance();

private:

    inline void set_has_e8DVDDiscType ();

    inline void clear_has_e8DVDDiscType ();

    inline void set_has_e8DVDDriveMode ();

    inline void clear_has_e8DVDDriveMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::mplay_devicemanager_fi_types::T_e8_MDVDDiscType _e8DVDDiscType;

    ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode _e8DVDDriveMode;

};

/**
 * The start message of the method "DevManagerMountCDROMInternal"
 * If a CDROM is inserted to the internal CDDrive then this method is used by diagnosis to mount it.
 * This command is especially used if the CDROM is a MixMode CD. This is use case in the production diagnosis.
 */
class DevManagerMountCDROMInternalStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerMountCDROMInternalStart ();

    /**
     * Copy constructor
     */
    inline  DevManagerMountCDROMInternalStart (const DevManagerMountCDROMInternalStart &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerMountCDROMInternalStart (bool Mount_, const ::std::string& BlockDevice_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerMountCDROMInternalStart();

    /**
     * Assignment operator
     */
    inline DevManagerMountCDROMInternalStart& operator = (const DevManagerMountCDROMInternalStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerMountCDROMInternalStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerMountCDROMInternalStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerMountCDROMInternalStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerMountCDROMInternalStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mount"

    static const int kMount = 0;

    /**
     * Clears the field "Mount".
     *
     * The field will be set to its default value. The hasMount()
     * method will return false.
     */
    inline void clearMount();

    /**
     * Checks whether the field "Mount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMount()). Otherwise it will return false.
     */
    inline bool hasMount () const;

    /**
     * Returns the value of the member "Mount".
     *
     * <p>TRUE:  Mount the CD ROM</p>
     * <p>FALSE: Unmount the CD ROM</p>
     *
     * @return The value of the field "Mount"
     */
    inline bool getMount () const;

    /**
     * Sets the value of the member "Mount".
     *
     * <p>TRUE:  Mount the CD ROM</p>
     * <p>FALSE: Unmount the CD ROM</p>
     *
     * @param Mount The value which will be set
     */
    inline void setMount (bool Mount_);

    // API of field "BlockDevice"

    static const int kBlockDevice = 1;

    /**
     * Clears the field "BlockDevice".
     *
     * The field will be set to its default value. The hasBlockDevice()
     * method will return false.
     */
    inline void clearBlockDevice();

    /**
     * Checks whether the field "BlockDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlockDevice()). Otherwise it will return false.
     */
    inline bool hasBlockDevice () const;

    /**
     * Returns the value of the member "BlockDevice".
     *
     * <p>block device name of cdrom in project e.g. /dev/sr0  or /dev/sr1</p>
     * <p>VD_Devicemanager will try to mount it e.g. to /dev/media/cdrom_diag</p>
     * <p>Diag has to care to call  unmount as well to ensure stability within ignition cycle</p>
     *
     * @return The value of the field "BlockDevice"
     */
    inline const ::std::string& getBlockDevice () const;

    /**
     * Retrieves the value of the field "BlockDevice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BlockDevice".
     */
    inline ::std::string& getBlockDeviceMutable ();

    /**
     * Sets the value of the member "BlockDevice".
     *
     * <p>block device name of cdrom in project e.g. /dev/sr0  or /dev/sr1</p>
     * <p>VD_Devicemanager will try to mount it e.g. to /dev/media/cdrom_diag</p>
     * <p>Diag has to care to call  unmount as well to ensure stability within ignition cycle</p>
     *
     * @param BlockDevice The value which will be set
     */
    inline void setBlockDevice (const ::std::string& BlockDevice_);

    /**
     * Sets the value of the member "BlockDevice".
     *
     * <p>block device name of cdrom in project e.g. /dev/sr0  or /dev/sr1</p>
     * <p>VD_Devicemanager will try to mount it e.g. to /dev/media/cdrom_diag</p>
     * <p>Diag has to care to call  unmount as well to ensure stability within ignition cycle</p>
     *
     * @param BlockDevice The value which will be set
     */
    inline void setBlockDevice (const char* BlockDevice_);

    /**
     * Sets the value of the member "BlockDevice".
     *
     * <p>block device name of cdrom in project e.g. /dev/sr0  or /dev/sr1</p>
     * <p>VD_Devicemanager will try to mount it e.g. to /dev/media/cdrom_diag</p>
     * <p>Diag has to care to call  unmount as well to ensure stability within ignition cycle</p>
     *
     * @param BlockDevice The value which will be set
     */
    inline void setBlockDevice (const char* value, size_t size);

    static const DevManagerMountCDROMInternalStart &getDefaultInstance();

private:

    inline void set_has_Mount ();

    inline void clear_has_Mount ();

    inline void set_has_BlockDevice ();

    inline void clear_has_BlockDevice ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _Mount;

    ::std::string _BlockDevice;

};

/**
 * The result message of the method "DevManagerMountCDROMInternal"
 * If a CDROM is inserted to the internal CDDrive then this method is used by diagnosis to mount it.
 * This command is especially used if the CDROM is a MixMode CD. This is use case in the production diagnosis.
 */
class DevManagerMountCDROMInternalResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerMountCDROMInternalResult ();

    /**
     * Copy constructor
     */
    inline  DevManagerMountCDROMInternalResult (const DevManagerMountCDROMInternalResult &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerMountCDROMInternalResult (bool Success_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerMountCDROMInternalResult();

    /**
     * Assignment operator
     */
    inline DevManagerMountCDROMInternalResult& operator = (const DevManagerMountCDROMInternalResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerMountCDROMInternalResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerMountCDROMInternalResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerMountCDROMInternalResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerMountCDROMInternalResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Success"

    static const int kSuccess = 0;

    /**
     * Clears the field "Success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "Success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "Success".
     *
     * <p>TRUE:  Successful (un-)mounted</p>
     * <p>FALSE: Failed to execute command</p>
     *
     * @return The value of the field "Success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "Success".
     *
     * <p>TRUE:  Successful (un-)mounted</p>
     * <p>FALSE: Failed to execute command</p>
     *
     * @param Success The value which will be set
     */
    inline void setSuccess (bool Success_);

    static const DevManagerMountCDROMInternalResult &getDefaultInstance();

private:

    inline void set_has_Success ();

    inline void clear_has_Success ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Success;

};

/**
 * The start message of the method "DevManagerEjectOpticalDisc"
 * Eject or insert optical disc
 */
class DevManagerEjectOpticalDiscStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerEjectOpticalDiscStart ();

    /**
     * Copy constructor
     */
    inline  DevManagerEjectOpticalDiscStart (const DevManagerEjectOpticalDiscStart &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerEjectOpticalDiscStart (::mplay_shared_fi_types::T_e8_EjectParmType eCmdParam_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerEjectOpticalDiscStart();

    /**
     * Assignment operator
     */
    inline DevManagerEjectOpticalDiscStart& operator = (const DevManagerEjectOpticalDiscStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerEjectOpticalDiscStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerEjectOpticalDiscStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerEjectOpticalDiscStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerEjectOpticalDiscStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eCmdParam"

    static const int kECmdParam = 0;

    /**
     * Clears the field "eCmdParam".
     *
     * The field will be set to its default value. The hasECmdParam()
     * method will return false.
     */
    inline void clearECmdParam();

    /**
     * Checks whether the field "eCmdParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setECmdParam()). Otherwise it will return false.
     */
    inline bool hasECmdParam () const;

    /**
     * Returns the value of the member "eCmdParam".
     *
     * <p>T_e8_EjectParm is used to send insert or eject command</p>
     *
     * @return The value of the field "eCmdParam"
     */
    inline ::mplay_shared_fi_types::T_e8_EjectParmType getECmdParam () const;

    /**
     * Sets the value of the member "eCmdParam".
     *
     * <p>T_e8_EjectParm is used to send insert or eject command</p>
     *
     * @param eCmdParam The value which will be set
     */
    inline void setECmdParam (::mplay_shared_fi_types::T_e8_EjectParmType eCmdParam_);

    static const DevManagerEjectOpticalDiscStart &getDefaultInstance();

private:

    inline void set_has_eCmdParam ();

    inline void clear_has_eCmdParam ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_shared_fi_types::T_e8_EjectParmType _eCmdParam;

};

/**
 * The result message of the method "DevManagerEjectOpticalDisc"
 * Eject or insert optical disc
 */
class DevManagerEjectOpticalDiscResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerEjectOpticalDiscResult ();

    /**
     * Copy constructor
     */
    inline  DevManagerEjectOpticalDiscResult (const DevManagerEjectOpticalDiscResult &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerEjectOpticalDiscResult (::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult ServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerEjectOpticalDiscResult();

    /**
     * Assignment operator
     */
    inline DevManagerEjectOpticalDiscResult& operator = (const DevManagerEjectOpticalDiscResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerEjectOpticalDiscResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerEjectOpticalDiscResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerEjectOpticalDiscResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerEjectOpticalDiscResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in VD Media Manager
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in VD Media Manager
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult ServiceStatus_);

    static const DevManagerEjectOpticalDiscResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult _ServiceStatus;

};

/**
 * The start message of the method "DevManagerAddTelematicsBox"
 * Add or delete a Telematics box.
 * If this function is called VD_DVM uses datapool to store value permanently.
 * Although device might have been notified by udev - after the call of this
 * fi function VD_DVM will check again if such new added device is already connected to send the diagnosis info.
 */
class DevManagerAddTelematicsBoxStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerAddTelematicsBoxStart ();

    /**
     * Copy constructor
     */
    inline  DevManagerAddTelematicsBoxStart (const DevManagerAddTelematicsBoxStart &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerAddTelematicsBoxStart (uint32 VendorID_, uint32 ProductID_, uint32 USBPortNo_, ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb SpeedInfo_, bool Add_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerAddTelematicsBoxStart();

    /**
     * Assignment operator
     */
    inline DevManagerAddTelematicsBoxStart& operator = (const DevManagerAddTelematicsBoxStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerAddTelematicsBoxStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerAddTelematicsBoxStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerAddTelematicsBoxStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerAddTelematicsBoxStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VendorID"

    static const int kVendorID = 0;

    /**
     * Clears the field "VendorID".
     *
     * The field will be set to its default value. The hasVendorID()
     * method will return false.
     */
    inline void clearVendorID();

    /**
     * Checks whether the field "VendorID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVendorID()). Otherwise it will return false.
     */
    inline bool hasVendorID () const;

    /**
     * Returns the value of the member "VendorID".
     *
     * <p>Vendor id of the telematics box</p>
     *
     * @return The value of the field "VendorID"
     */
    inline uint32 getVendorID () const;

    /**
     * Sets the value of the member "VendorID".
     *
     * <p>Vendor id of the telematics box</p>
     *
     * @param VendorID The value which will be set
     */
    inline void setVendorID (uint32 VendorID_);

    // API of field "ProductID"

    static const int kProductID = 1;

    /**
     * Clears the field "ProductID".
     *
     * The field will be set to its default value. The hasProductID()
     * method will return false.
     */
    inline void clearProductID();

    /**
     * Checks whether the field "ProductID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductID()). Otherwise it will return false.
     */
    inline bool hasProductID () const;

    /**
     * Returns the value of the member "ProductID".
     *
     * <p>Product id of the telematics box</p>
     *
     * @return The value of the field "ProductID"
     */
    inline uint32 getProductID () const;

    /**
     * Sets the value of the member "ProductID".
     *
     * <p>Product id of the telematics box</p>
     *
     * @param ProductID The value which will be set
     */
    inline void setProductID (uint32 ProductID_);

    // API of field "USBPortNo"

    static const int kUSBPortNo = 2;

    /**
     * Clears the field "USBPortNo".
     *
     * The field will be set to its default value. The hasUSBPortNo()
     * method will return false.
     */
    inline void clearUSBPortNo();

    /**
     * Checks whether the field "USBPortNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBPortNo()). Otherwise it will return false.
     */
    inline bool hasUSBPortNo () const;

    /**
     * Returns the value of the member "USBPortNo".
     *
     * <p>USB connector where the telematics box will be connected.
     * This value will influence the configuration of other Telematics boxes.</p>
     *
     * @return The value of the field "USBPortNo"
     */
    inline uint32 getUSBPortNo () const;

    /**
     * Sets the value of the member "USBPortNo".
     *
     * <p>USB connector where the telematics box will be connected.
     * This value will influence the configuration of other Telematics boxes.</p>
     *
     * @param USBPortNo The value which will be set
     */
    inline void setUSBPortNo (uint32 USBPortNo_);

    // API of field "SpeedInfo"

    static const int kSpeedInfo = 3;

    /**
     * Clears the field "SpeedInfo".
     *
     * The field will be set to its default value. The hasSpeedInfo()
     * method will return false.
     */
    inline void clearSpeedInfo();

    /**
     * Checks whether the field "SpeedInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedInfo()). Otherwise it will return false.
     */
    inline bool hasSpeedInfo () const;

    /**
     * Returns the value of the member "SpeedInfo".
     *
     * <p>The expected device speed. If there is no expectation of device speed, the default value should be "UNKNOWN"</p>
     *
     * @return The value of the field "SpeedInfo"
     */
    inline ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb getSpeedInfo () const;

    /**
     * Sets the value of the member "SpeedInfo".
     *
     * <p>The expected device speed. If there is no expectation of device speed, the default value should be "UNKNOWN"</p>
     *
     * @param SpeedInfo The value which will be set
     */
    inline void setSpeedInfo (::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb SpeedInfo_);

    // API of field "Add"

    static const int kAdd = 4;

    /**
     * Clears the field "Add".
     *
     * The field will be set to its default value. The hasAdd()
     * method will return false.
     */
    inline void clearAdd();

    /**
     * Checks whether the field "Add" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAdd()). Otherwise it will return false.
     */
    inline bool hasAdd () const;

    /**
     * Returns the value of the member "Add".
     *
     * <p>FALSE: The Telematics Box with the specified details( with vendor id, product id) will be deleted from the datapool.
     * The diagnosis info for the telematics Box will not be send.
     * TRUE: The Telematics Box with the specified details( with vendor id, product id) will be added to the datapool.
     * The diagnosis info for the telematics Box will be send.</p>
     *
     * @return The value of the field "Add"
     */
    inline bool getAdd () const;

    /**
     * Sets the value of the member "Add".
     *
     * <p>FALSE: The Telematics Box with the specified details( with vendor id, product id) will be deleted from the datapool.
     * The diagnosis info for the telematics Box will not be send.
     * TRUE: The Telematics Box with the specified details( with vendor id, product id) will be added to the datapool.
     * The diagnosis info for the telematics Box will be send.</p>
     *
     * @param Add The value which will be set
     */
    inline void setAdd (bool Add_);

    static const DevManagerAddTelematicsBoxStart &getDefaultInstance();

private:

    inline void set_has_VendorID ();

    inline void clear_has_VendorID ();

    inline void set_has_ProductID ();

    inline void clear_has_ProductID ();

    inline void set_has_USBPortNo ();

    inline void clear_has_USBPortNo ();

    inline void set_has_SpeedInfo ();

    inline void clear_has_SpeedInfo ();

    inline void set_has_Add ();

    inline void clear_has_Add ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _VendorID;

    uint32 _ProductID;

    uint32 _USBPortNo;

    ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb _SpeedInfo;

    bool _Add;

};

/**
 * The result message of the method "DevManagerAddTelematicsBox"
 * Add or delete a Telematics box.
 * If this function is called VD_DVM uses datapool to store value permanently.
 * Although device might have been notified by udev - after the call of this
 * fi function VD_DVM will check again if such new added device is already connected to send the diagnosis info.
 */
class DevManagerAddTelematicsBoxResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerAddTelematicsBoxResult ();

    /**
     * Copy constructor
     */
    inline  DevManagerAddTelematicsBoxResult (const DevManagerAddTelematicsBoxResult &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerAddTelematicsBoxResult (bool Success_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerAddTelematicsBoxResult();

    /**
     * Assignment operator
     */
    inline DevManagerAddTelematicsBoxResult& operator = (const DevManagerAddTelematicsBoxResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerAddTelematicsBoxResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerAddTelematicsBoxResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerAddTelematicsBoxResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerAddTelematicsBoxResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Success"

    static const int kSuccess = 0;

    /**
     * Clears the field "Success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "Success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "Success".
     *
     * <p>TRUE:  Successful</p>
     * <p>FALSE: Failed to store or delete the telematics box details</p>
     *
     * @return The value of the field "Success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "Success".
     *
     * <p>TRUE:  Successful</p>
     * <p>FALSE: Failed to store or delete the telematics box details</p>
     *
     * @param Success The value which will be set
     */
    inline void setSuccess (bool Success_);

    static const DevManagerAddTelematicsBoxResult &getDefaultInstance();

private:

    inline void set_has_Success ();

    inline void clear_has_Success ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Success;

};

/**
 * The start message of the method "DevManagerSetConfigurationValue"
 * Provides a way to alter the configuration of vd_devicemanager( see ConfigurationBase.h and ConfigurationBase.cpp )
 */
class DevManagerSetConfigurationValueStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerSetConfigurationValueStart ();

    /**
     * Copy constructor
     */
    inline  DevManagerSetConfigurationValueStart (const DevManagerSetConfigurationValueStart &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerSetConfigurationValueStart (const ::std::string& ConfigurationParam_, uint16 Value_, ::mplay_devicemanager_fi_types::T_e8_SettingsMode SettingsMode_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerSetConfigurationValueStart();

    /**
     * Assignment operator
     */
    inline DevManagerSetConfigurationValueStart& operator = (const DevManagerSetConfigurationValueStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerSetConfigurationValueStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerSetConfigurationValueStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerSetConfigurationValueStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerSetConfigurationValueStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigurationParam"

    static const int kConfigurationParam = 0;

    /**
     * Clears the field "ConfigurationParam".
     *
     * The field will be set to its default value. The hasConfigurationParam()
     * method will return false.
     */
    inline void clearConfigurationParam();

    /**
     * Checks whether the field "ConfigurationParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigurationParam()). Otherwise it will return false.
     */
    inline bool hasConfigurationParam () const;

    /**
     * Returns the value of the member "ConfigurationParam".
     *
     * <p>Name of the configuration Parameter. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @return The value of the field "ConfigurationParam"
     */
    inline const ::std::string& getConfigurationParam () const;

    /**
     * Retrieves the value of the field "ConfigurationParam" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConfigurationParam".
     */
    inline ::std::string& getConfigurationParamMutable ();

    /**
     * Sets the value of the member "ConfigurationParam".
     *
     * <p>Name of the configuration Parameter. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @param ConfigurationParam The value which will be set
     */
    inline void setConfigurationParam (const ::std::string& ConfigurationParam_);

    /**
     * Sets the value of the member "ConfigurationParam".
     *
     * <p>Name of the configuration Parameter. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @param ConfigurationParam The value which will be set
     */
    inline void setConfigurationParam (const char* ConfigurationParam_);

    /**
     * Sets the value of the member "ConfigurationParam".
     *
     * <p>Name of the configuration Parameter. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @param ConfigurationParam The value which will be set
     */
    inline void setConfigurationParam (const char* value, size_t size);

    // API of field "Value"

    static const int kValue = 1;

    /**
     * Clears the field "Value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "Value".
     *
     * <p>Value of the configuration. Please check with ttfis command VD_DVM_SHOW_HELP_MANUAL to get the possible values of the
     * configuration parameter.
     * for eg: VD_DVM_SET_CONFIGURATION_VALUE_eCONF_ENABLE_FILESYSTEM_FAT supports 2 values
     * 00 or 01.</p>
     *
     * @return The value of the field "Value"
     */
    inline uint16 getValue () const;

    /**
     * Sets the value of the member "Value".
     *
     * <p>Value of the configuration. Please check with ttfis command VD_DVM_SHOW_HELP_MANUAL to get the possible values of the
     * configuration parameter.
     * for eg: VD_DVM_SET_CONFIGURATION_VALUE_eCONF_ENABLE_FILESYSTEM_FAT supports 2 values
     * 00 or 01.</p>
     *
     * @param Value The value which will be set
     */
    inline void setValue (uint16 Value_);

    // API of field "SettingsMode"

    static const int kSettingsMode = 2;

    /**
     * Clears the field "SettingsMode".
     *
     * The field will be set to its default value. The hasSettingsMode()
     * method will return false.
     */
    inline void clearSettingsMode();

    /**
     * Checks whether the field "SettingsMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingsMode()). Otherwise it will return false.
     */
    inline bool hasSettingsMode () const;

    /**
     * Returns the value of the member "SettingsMode".
     *
     * <p>The mode of the setting the values. It can be either Temporary(value will be set for the current ignition cycle),
     * Permanent(value will be set for the current and subsequent ignition cycles) or
     * Default(configuration parameter will fall back to the default configuration of the project)</p>
     *
     * @return The value of the field "SettingsMode"
     */
    inline ::mplay_devicemanager_fi_types::T_e8_SettingsMode getSettingsMode () const;

    /**
     * Sets the value of the member "SettingsMode".
     *
     * <p>The mode of the setting the values. It can be either Temporary(value will be set for the current ignition cycle),
     * Permanent(value will be set for the current and subsequent ignition cycles) or
     * Default(configuration parameter will fall back to the default configuration of the project)</p>
     *
     * @param SettingsMode The value which will be set
     */
    inline void setSettingsMode (::mplay_devicemanager_fi_types::T_e8_SettingsMode SettingsMode_);

    static const DevManagerSetConfigurationValueStart &getDefaultInstance();

private:

    inline void set_has_ConfigurationParam ();

    inline void clear_has_ConfigurationParam ();

    inline void set_has_Value ();

    inline void clear_has_Value ();

    inline void set_has_SettingsMode ();

    inline void clear_has_SettingsMode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _ConfigurationParam;

    uint16 _Value;

    ::mplay_devicemanager_fi_types::T_e8_SettingsMode _SettingsMode;

};

/**
 * The result message of the method "DevManagerSetConfigurationValue"
 * Provides a way to alter the configuration of vd_devicemanager( see ConfigurationBase.h and ConfigurationBase.cpp )
 */
class DevManagerSetConfigurationValueResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerSetConfigurationValueResult ();

    /**
     * Copy constructor
     */
    inline  DevManagerSetConfigurationValueResult (const DevManagerSetConfigurationValueResult &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerSetConfigurationValueResult (bool Success_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerSetConfigurationValueResult();

    /**
     * Assignment operator
     */
    inline DevManagerSetConfigurationValueResult& operator = (const DevManagerSetConfigurationValueResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerSetConfigurationValueResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerSetConfigurationValueResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerSetConfigurationValueResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerSetConfigurationValueResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Success"

    static const int kSuccess = 0;

    /**
     * Clears the field "Success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "Success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "Success".
     *
     * <p>TRUE:  on successful setting of configuration value</p>
     * <p>FALSE: on failure to set the configuration value</p>
     *
     * @return The value of the field "Success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "Success".
     *
     * <p>TRUE:  on successful setting of configuration value</p>
     * <p>FALSE: on failure to set the configuration value</p>
     *
     * @param Success The value which will be set
     */
    inline void setSuccess (bool Success_);

    static const DevManagerSetConfigurationValueResult &getDefaultInstance();

private:

    inline void set_has_Success ();

    inline void clear_has_Success ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Success;

};

/**
 * The start message of the method "DevManagerGetConfigurationValue"
 * Provides a way to  fetch the configuration of vd_devicemanager( see ConfigurationBase.h and ConfigurationBase.cpp)
 */
class DevManagerGetConfigurationValueStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerGetConfigurationValueStart ();

    /**
     * Copy constructor
     */
    inline  DevManagerGetConfigurationValueStart (const DevManagerGetConfigurationValueStart &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerGetConfigurationValueStart (const ::std::string& ConfigurationParam_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerGetConfigurationValueStart();

    /**
     * Assignment operator
     */
    inline DevManagerGetConfigurationValueStart& operator = (const DevManagerGetConfigurationValueStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerGetConfigurationValueStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerGetConfigurationValueStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerGetConfigurationValueStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerGetConfigurationValueStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigurationParam"

    static const int kConfigurationParam = 0;

    /**
     * Clears the field "ConfigurationParam".
     *
     * The field will be set to its default value. The hasConfigurationParam()
     * method will return false.
     */
    inline void clearConfigurationParam();

    /**
     * Checks whether the field "ConfigurationParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigurationParam()). Otherwise it will return false.
     */
    inline bool hasConfigurationParam () const;

    /**
     * Returns the value of the member "ConfigurationParam".
     *
     * <p>Name of the configuration value. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @return The value of the field "ConfigurationParam"
     */
    inline const ::std::string& getConfigurationParam () const;

    /**
     * Retrieves the value of the field "ConfigurationParam" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConfigurationParam".
     */
    inline ::std::string& getConfigurationParamMutable ();

    /**
     * Sets the value of the member "ConfigurationParam".
     *
     * <p>Name of the configuration value. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @param ConfigurationParam The value which will be set
     */
    inline void setConfigurationParam (const ::std::string& ConfigurationParam_);

    /**
     * Sets the value of the member "ConfigurationParam".
     *
     * <p>Name of the configuration value. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @param ConfigurationParam The value which will be set
     */
    inline void setConfigurationParam (const char* ConfigurationParam_);

    /**
     * Sets the value of the member "ConfigurationParam".
     *
     * <p>Name of the configuration value. Please check with ttfis command VD_DVM_SHOW_CONFIGURATION or VD_DVM_PRINT_CONFIGURATION.
     * for eg: eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 or eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2</p>
     *
     * @param ConfigurationParam The value which will be set
     */
    inline void setConfigurationParam (const char* value, size_t size);

    static const DevManagerGetConfigurationValueStart &getDefaultInstance();

private:

    inline void set_has_ConfigurationParam ();

    inline void clear_has_ConfigurationParam ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _ConfigurationParam;

};

/**
 * The result message of the method "DevManagerGetConfigurationValue"
 * Provides a way to  fetch the configuration of vd_devicemanager( see ConfigurationBase.h and ConfigurationBase.cpp)
 */
class DevManagerGetConfigurationValueResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerGetConfigurationValueResult ();

    /**
     * Copy constructor
     */
    inline  DevManagerGetConfigurationValueResult (const DevManagerGetConfigurationValueResult &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerGetConfigurationValueResult (uint16 Value_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerGetConfigurationValueResult();

    /**
     * Assignment operator
     */
    inline DevManagerGetConfigurationValueResult& operator = (const DevManagerGetConfigurationValueResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerGetConfigurationValueResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerGetConfigurationValueResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerGetConfigurationValueResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerGetConfigurationValueResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Value"

    static const int kValue = 0;

    /**
     * Clears the field "Value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "Value".
     *
     * <p>Value of the configuration.</p>
     *
     * @return The value of the field "Value"
     */
    inline uint16 getValue () const;

    /**
     * Sets the value of the member "Value".
     *
     * <p>Value of the configuration.</p>
     *
     * @param Value The value which will be set
     */
    inline void setValue (uint16 Value_);

    static const DevManagerGetConfigurationValueResult &getDefaultInstance();

private:

    inline void set_has_Value ();

    inline void clear_has_Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Value;

};

/**
 * The start message of the method "DevManagerAddExternalHub"
 * Add or delete an ExternalHub device.
 * If this function is called VD_DVM uses datapool to store value permanently.
 * Although device might have been notified by udev - after the call of this
 * fi function VD_DVM will check again if such new added device is already connected to send the diagnosis info.
 */
class DevManagerAddExternalHubStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerAddExternalHubStart ();

    /**
     * Copy constructor
     */
    inline  DevManagerAddExternalHubStart (const DevManagerAddExternalHubStart &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerAddExternalHubStart (uint32 VendorID_, uint32 ProductID_, uint32 USBPortNo_, bool Add_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerAddExternalHubStart();

    /**
     * Assignment operator
     */
    inline DevManagerAddExternalHubStart& operator = (const DevManagerAddExternalHubStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerAddExternalHubStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerAddExternalHubStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerAddExternalHubStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerAddExternalHubStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VendorID"

    static const int kVendorID = 0;

    /**
     * Clears the field "VendorID".
     *
     * The field will be set to its default value. The hasVendorID()
     * method will return false.
     */
    inline void clearVendorID();

    /**
     * Checks whether the field "VendorID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVendorID()). Otherwise it will return false.
     */
    inline bool hasVendorID () const;

    /**
     * Returns the value of the member "VendorID".
     *
     * <p>Vendor id of the ExternalHub device</p>
     *
     * @return The value of the field "VendorID"
     */
    inline uint32 getVendorID () const;

    /**
     * Sets the value of the member "VendorID".
     *
     * <p>Vendor id of the ExternalHub device</p>
     *
     * @param VendorID The value which will be set
     */
    inline void setVendorID (uint32 VendorID_);

    // API of field "ProductID"

    static const int kProductID = 1;

    /**
     * Clears the field "ProductID".
     *
     * The field will be set to its default value. The hasProductID()
     * method will return false.
     */
    inline void clearProductID();

    /**
     * Checks whether the field "ProductID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductID()). Otherwise it will return false.
     */
    inline bool hasProductID () const;

    /**
     * Returns the value of the member "ProductID".
     *
     * <p>Product id of the ExternalHub device</p>
     *
     * @return The value of the field "ProductID"
     */
    inline uint32 getProductID () const;

    /**
     * Sets the value of the member "ProductID".
     *
     * <p>Product id of the ExternalHub device</p>
     *
     * @param ProductID The value which will be set
     */
    inline void setProductID (uint32 ProductID_);

    // API of field "USBPortNo"

    static const int kUSBPortNo = 2;

    /**
     * Clears the field "USBPortNo".
     *
     * The field will be set to its default value. The hasUSBPortNo()
     * method will return false.
     */
    inline void clearUSBPortNo();

    /**
     * Checks whether the field "USBPortNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBPortNo()). Otherwise it will return false.
     */
    inline bool hasUSBPortNo () const;

    /**
     * Returns the value of the member "USBPortNo".
     *
     * <p>USB connector where the ExternalHub device will be connected.
     * This value will influence the configuration of other ExternalHubs.</p>
     *
     * @return The value of the field "USBPortNo"
     */
    inline uint32 getUSBPortNo () const;

    /**
     * Sets the value of the member "USBPortNo".
     *
     * <p>USB connector where the ExternalHub device will be connected.
     * This value will influence the configuration of other ExternalHubs.</p>
     *
     * @param USBPortNo The value which will be set
     */
    inline void setUSBPortNo (uint32 USBPortNo_);

    // API of field "Add"

    static const int kAdd = 3;

    /**
     * Clears the field "Add".
     *
     * The field will be set to its default value. The hasAdd()
     * method will return false.
     */
    inline void clearAdd();

    /**
     * Checks whether the field "Add" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAdd()). Otherwise it will return false.
     */
    inline bool hasAdd () const;

    /**
     * Returns the value of the member "Add".
     *
     * <p>FALSE: The ExternalHub device with the specified details( with vendor id, product id) will be deleted from the datapool.
     * The diagnosis info for the ExternalHub device will not be send.
     * TRUE: The ExternalHub device with the specified details( with vendor id, product id) will be added to the datapool.
     * The diagnosis info for the ExternalHub device will be send.</p>
     *
     * @return The value of the field "Add"
     */
    inline bool getAdd () const;

    /**
     * Sets the value of the member "Add".
     *
     * <p>FALSE: The ExternalHub device with the specified details( with vendor id, product id) will be deleted from the datapool.
     * The diagnosis info for the ExternalHub device will not be send.
     * TRUE: The ExternalHub device with the specified details( with vendor id, product id) will be added to the datapool.
     * The diagnosis info for the ExternalHub device will be send.</p>
     *
     * @param Add The value which will be set
     */
    inline void setAdd (bool Add_);

    static const DevManagerAddExternalHubStart &getDefaultInstance();

private:

    inline void set_has_VendorID ();

    inline void clear_has_VendorID ();

    inline void set_has_ProductID ();

    inline void clear_has_ProductID ();

    inline void set_has_USBPortNo ();

    inline void clear_has_USBPortNo ();

    inline void set_has_Add ();

    inline void clear_has_Add ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _VendorID;

    uint32 _ProductID;

    uint32 _USBPortNo;

    bool _Add;

};

/**
 * The result message of the method "DevManagerAddExternalHub"
 * Add or delete an ExternalHub device.
 * If this function is called VD_DVM uses datapool to store value permanently.
 * Although device might have been notified by udev - after the call of this
 * fi function VD_DVM will check again if such new added device is already connected to send the diagnosis info.
 */
class DevManagerAddExternalHubResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerAddExternalHubResult ();

    /**
     * Copy constructor
     */
    inline  DevManagerAddExternalHubResult (const DevManagerAddExternalHubResult &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerAddExternalHubResult (bool Success_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerAddExternalHubResult();

    /**
     * Assignment operator
     */
    inline DevManagerAddExternalHubResult& operator = (const DevManagerAddExternalHubResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerAddExternalHubResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerAddExternalHubResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerAddExternalHubResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerAddExternalHubResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Success"

    static const int kSuccess = 0;

    /**
     * Clears the field "Success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "Success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "Success".
     *
     * <p>TRUE:  Successful</p>
     * <p>FALSE: Failed to store or delete the ExternalHub device details</p>
     *
     * @return The value of the field "Success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "Success".
     *
     * <p>TRUE:  Successful</p>
     * <p>FALSE: Failed to store or delete the ExternalHub device details</p>
     *
     * @param Success The value which will be set
     */
    inline void setSuccess (bool Success_);

    static const DevManagerAddExternalHubResult &getDefaultInstance();

private:

    inline void set_has_Success ();

    inline void clear_has_Success ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Success;

};

/**
 * The start message of the method "DevManagerGetDevProperties"
 * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
 * This method provides device properties of a connected device as specified by the requesting registered FBlock based on the device serial number.
 */
class DevManagerGetDevPropertiesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerGetDevPropertiesStart ();

    /**
     * Copy constructor
     */
    inline  DevManagerGetDevPropertiesStart (const DevManagerGetDevPropertiesStart &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerGetDevPropertiesStart (const ::std::string& DeviceSerialNo_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerGetDevPropertiesStart();

    /**
     * Assignment operator
     */
    inline DevManagerGetDevPropertiesStart& operator = (const DevManagerGetDevPropertiesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerGetDevPropertiesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerGetDevPropertiesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerGetDevPropertiesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerGetDevPropertiesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceSerialNo"

    static const int kDeviceSerialNo = 0;

    /**
     * Clears the field "DeviceSerialNo".
     *
     * The field will be set to its default value. The hasDeviceSerialNo()
     * method will return false.
     */
    inline void clearDeviceSerialNo();

    /**
     * Checks whether the field "DeviceSerialNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceSerialNo()). Otherwise it will return false.
     */
    inline bool hasDeviceSerialNo () const;

    /**
     * Returns the value of the member "DeviceSerialNo".
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property T_DevManager_DeviceProperty and opcode Get!!!
     * The serial number of the device inserted or removed from the system.
     *
     * @return The value of the field "DeviceSerialNo"
     */
    inline const ::std::string& getDeviceSerialNo () const;

    /**
     * Retrieves the value of the field "DeviceSerialNo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceSerialNo".
     */
    inline ::std::string& getDeviceSerialNoMutable ();

    /**
     * Sets the value of the member "DeviceSerialNo".
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property T_DevManager_DeviceProperty and opcode Get!!!
     * The serial number of the device inserted or removed from the system.
     *
     * @param DeviceSerialNo The value which will be set
     */
    inline void setDeviceSerialNo (const ::std::string& DeviceSerialNo_);

    /**
     * Sets the value of the member "DeviceSerialNo".
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property T_DevManager_DeviceProperty and opcode Get!!!
     * The serial number of the device inserted or removed from the system.
     *
     * @param DeviceSerialNo The value which will be set
     */
    inline void setDeviceSerialNo (const char* DeviceSerialNo_);

    /**
     * Sets the value of the member "DeviceSerialNo".
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property T_DevManager_DeviceProperty and opcode Get!!!
     * The serial number of the device inserted or removed from the system.
     *
     * @param DeviceSerialNo The value which will be set
     */
    inline void setDeviceSerialNo (const char* value, size_t size);

    static const DevManagerGetDevPropertiesStart &getDefaultInstance();

private:

    inline void set_has_DeviceSerialNo ();

    inline void clear_has_DeviceSerialNo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _DeviceSerialNo;

};

/**
 * The result message of the method "DevManagerGetDevProperties"
 * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
 * This method provides device properties of a connected device as specified by the requesting registered FBlock based on the device serial number.
 */
class DevManagerGetDevPropertiesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerGetDevPropertiesResult ();

    /**
     * Copy constructor
     */
    inline  DevManagerGetDevPropertiesResult (const DevManagerGetDevPropertiesResult &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerGetDevPropertiesResult (const ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty& DeviceProperty_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerGetDevPropertiesResult();

    /**
     * Assignment operator
     */
    inline DevManagerGetDevPropertiesResult& operator = (const DevManagerGetDevPropertiesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerGetDevPropertiesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerGetDevPropertiesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerGetDevPropertiesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerGetDevPropertiesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceProperty"

    static const int kDeviceProperty = 0;

    /**
     * Clears the field "DeviceProperty".
     *
     * The field will be set to its default value. The hasDeviceProperty()
     * method will return false.
     */
    inline void clearDeviceProperty();

    /**
     * Checks whether the field "DeviceProperty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceProperty()). Otherwise it will return false.
     */
    inline bool hasDeviceProperty () const;

    /**
     * Returns the value of the member "DeviceProperty".
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property T_DevManager_DeviceProperty and opcode Get!!!
     * Confirmation that the message is received in VD_DeviceManager
     *
     * @return The value of the field "DeviceProperty"
     */
    inline const ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty& getDeviceProperty () const;

    /**
     * Retrieves the value of the field "DeviceProperty" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceProperty".
     */
    inline ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty& getDevicePropertyMutable ();

    /**
     * Sets the value of the member "DeviceProperty".
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property T_DevManager_DeviceProperty and opcode Get!!!
     * Confirmation that the message is received in VD_DeviceManager
     *
     * @param DeviceProperty The value which will be set
     */
    inline void setDeviceProperty (const ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty& DeviceProperty_);

    static const DevManagerGetDevPropertiesResult &getDefaultInstance();

private:

    inline void set_has_DeviceProperty ();

    inline void clear_has_DeviceProperty ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty _DeviceProperty;

};

/**
 * The result message of the method "DevManagerGetAllConnectedDevices"
 * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
 * This method provides device properties of all connected device during power up. The CCA components after getting started can use this method to retrieve information of all connected devices
 */
class DevManagerGetAllConnectedDevicesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevManagerGetAllConnectedDevicesResult ();

    /**
     * Copy constructor
     */
    inline  DevManagerGetAllConnectedDevicesResult (const DevManagerGetAllConnectedDevicesResult &rhs);

    /**
     * All fields constructor
     */
    inline  DevManagerGetAllConnectedDevicesResult (const ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr& DevInfoArr_);

    /**
     * Destructor
     */
    inline virtual  ~DevManagerGetAllConnectedDevicesResult();

    /**
     * Assignment operator
     */
    inline DevManagerGetAllConnectedDevicesResult& operator = (const DevManagerGetAllConnectedDevicesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevManagerGetAllConnectedDevicesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevManagerGetAllConnectedDevicesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevManagerGetAllConnectedDevicesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevManagerGetAllConnectedDevicesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DevInfoArr"

    static const int kDevInfoArr = 0;

    /**
     * Clears the field "DevInfoArr".
     *
     * The field will be set to its default value. The hasDevInfoArr()
     * method will return false.
     */
    inline void clearDevInfoArr();

    /**
     * Checks whether the field "DevInfoArr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevInfoArr()). Otherwise it will return false.
     */
    inline bool hasDevInfoArr () const;

    /**
     * Returns the value of the member "DevInfoArr".
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
     * Confirmation that the message is received in VD_DeviceManager
     *
     * @return The value of the field "DevInfoArr"
     */
    inline const ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr& getDevInfoArr () const;

    /**
     * Retrieves the value of the field "DevInfoArr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DevInfoArr".
     */
    inline ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr& getDevInfoArrMutable ();

    /**
     * Sets the value of the member "DevInfoArr".
     *
     * !!!Deprecated method used in Gen2 - kept for backward compatibility - use property DevManagerNotifyConnection and opcode Get!!!
     * Confirmation that the message is received in VD_DeviceManager
     *
     * @param DevInfoArr The value which will be set
     */
    inline void setDevInfoArr (const ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr& DevInfoArr_);

    static const DevManagerGetAllConnectedDevicesResult &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& getT_DevManager_DevicePropertyList_DefaultInstance ();

    inline void set_has_DevInfoArr ();

    inline void clear_has_DevInfoArr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr _DevInfoArr;

};

inline  DevManagerNotifyConnectionStatus::DevManagerNotifyConnectionStatus ()  :
    _Devicetype (),
    _Undervoltage (false),
    _USBPortList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerNotifyConnectionStatus::DevManagerNotifyConnectionStatus (const DevManagerNotifyConnectionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Devicetype (),
    _Undervoltage (false),
    _USBPortList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerNotifyConnectionStatus::DevManagerNotifyConnectionStatus (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& Devicetype_, bool Undervoltage_, const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& USBPortList_)  :
    _Devicetype (Devicetype_),
    _Undervoltage (Undervoltage_),
    _USBPortList (USBPortList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerNotifyConnectionStatus::~DevManagerNotifyConnectionStatus() {
}

inline DevManagerNotifyConnectionStatus& DevManagerNotifyConnectionStatus::operator = (const DevManagerNotifyConnectionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevicetype()) {
            setDevicetype(rhs.getDevicetype());
        } else {
            clearDevicetype();
        }
        if (rhs.hasUndervoltage()) {
            setUndervoltage(rhs.getUndervoltage());
        } else {
            clearUndervoltage();
        }
        if (rhs.hasUSBPortList()) {
            setUSBPortList(rhs.getUSBPortList());
        } else {
            clearUSBPortList();
        }
    }
    return *this;
}

inline bool DevManagerNotifyConnectionStatus::operator == (const DevManagerNotifyConnectionStatus& rhs) const {
    return (((!hasDevicetype() && !rhs.hasDevicetype()) || getDevicetype() == rhs.getDevicetype()) &&
        ((!hasUndervoltage() && !rhs.hasUndervoltage()) || getUndervoltage() == rhs.getUndervoltage()) &&
        ((!hasUSBPortList() && !rhs.hasUSBPortList()) || getUSBPortList() == rhs.getUSBPortList()));
}

inline bool DevManagerNotifyConnectionStatus::operator != (const DevManagerNotifyConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerNotifyConnectionStatus::operator < (const DevManagerNotifyConnectionStatus& rhs) const {
    if (hasDevicetype() || rhs.hasDevicetype()) {
        if (getDevicetype() < rhs.getDevicetype()) return true;
        if (getDevicetype() > rhs.getDevicetype()) return false;
    }
    if (hasUndervoltage() || rhs.hasUndervoltage()) {
        if (getUndervoltage() < rhs.getUndervoltage()) return true;
        if (getUndervoltage() > rhs.getUndervoltage()) return false;
    }
    if (hasUSBPortList() || rhs.hasUSBPortList()) {
        if (getUSBPortList() < rhs.getUSBPortList()) return true;
        if (getUSBPortList() > rhs.getUSBPortList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerNotifyConnectionStatus::clone() {
    return new DevManagerNotifyConnectionStatus(*this);
}

inline bool DevManagerNotifyConnectionStatus::operator > (const DevManagerNotifyConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerNotifyConnectionStatus::clear() {
    clearDevicetype();
    clearUndervoltage();
    clearUSBPortList();
}

inline void DevManagerNotifyConnectionStatus::clearDevicetype() {
    if (hasDevicetype()) {
         clear_has_Devicetype();
        _Devicetype.clear();
     }
}

inline bool DevManagerNotifyConnectionStatus::hasDevicetype () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& DevManagerNotifyConnectionStatus::getDevicetype () const {
    return _Devicetype;
}

inline ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& DevManagerNotifyConnectionStatus::getDevicetypeMutable () {
    set_has_Devicetype();
    return _Devicetype;
}

inline void DevManagerNotifyConnectionStatus::setDevicetype (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& Devicetype_) {
    set_has_Devicetype();
    this->_Devicetype = Devicetype_;
}

inline void DevManagerNotifyConnectionStatus::clearUndervoltage() {
    if (hasUndervoltage()) {
         clear_has_Undervoltage();
        _Undervoltage = false;
     }
}

inline bool DevManagerNotifyConnectionStatus::hasUndervoltage () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool DevManagerNotifyConnectionStatus::getUndervoltage () const {
    return _Undervoltage;
}

inline void DevManagerNotifyConnectionStatus::setUndervoltage (bool Undervoltage_) {
    set_has_Undervoltage();
    this->_Undervoltage = Undervoltage_;
}

inline void DevManagerNotifyConnectionStatus::clearUSBPortList() {
    if (hasUSBPortList()) {
         clear_has_USBPortList();
        _USBPortList.clear();
     }
}

inline bool DevManagerNotifyConnectionStatus::hasUSBPortList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& DevManagerNotifyConnectionStatus::getUSBPortList () const {
    return _USBPortList;
}

inline ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& DevManagerNotifyConnectionStatus::getUSBPortListMutable () {
    set_has_USBPortList();
    return _USBPortList;
}

inline void DevManagerNotifyConnectionStatus::setUSBPortList (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_PortStates >& USBPortList_) {
    set_has_USBPortList();
    this->_USBPortList = USBPortList_;
}

inline void DevManagerNotifyConnectionStatus::set_has_Devicetype () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerNotifyConnectionStatus::clear_has_Devicetype () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevManagerNotifyConnectionStatus::set_has_Undervoltage () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevManagerNotifyConnectionStatus::clear_has_Undervoltage () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DevManagerNotifyConnectionStatus::set_has_USBPortList () {
    _has_bits_[0] |= 1u << 2;
}

inline void DevManagerNotifyConnectionStatus::clear_has_USBPortList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DevManagerNotifyConnectionGet::DevManagerNotifyConnectionGet ()  :
    _Devicetype ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerNotifyConnectionGet::DevManagerNotifyConnectionGet (const DevManagerNotifyConnectionGet &rhs)  :
    ::asf::core::Payload(rhs),
    _Devicetype ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerNotifyConnectionGet::DevManagerNotifyConnectionGet (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& Devicetype_)  :
    _Devicetype (Devicetype_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerNotifyConnectionGet::~DevManagerNotifyConnectionGet() {
}

inline DevManagerNotifyConnectionGet& DevManagerNotifyConnectionGet::operator = (const DevManagerNotifyConnectionGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevicetype()) {
            setDevicetype(rhs.getDevicetype());
        } else {
            clearDevicetype();
        }
    }
    return *this;
}

inline bool DevManagerNotifyConnectionGet::operator == (const DevManagerNotifyConnectionGet& rhs) const {
    return (((!hasDevicetype() && !rhs.hasDevicetype()) || getDevicetype() == rhs.getDevicetype()));
}

inline bool DevManagerNotifyConnectionGet::operator != (const DevManagerNotifyConnectionGet& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerNotifyConnectionGet::operator < (const DevManagerNotifyConnectionGet& rhs) const {
    if (hasDevicetype() || rhs.hasDevicetype()) {
        if (getDevicetype() < rhs.getDevicetype()) return true;
        if (getDevicetype() > rhs.getDevicetype()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerNotifyConnectionGet::clone() {
    return new DevManagerNotifyConnectionGet(*this);
}

inline bool DevManagerNotifyConnectionGet::operator > (const DevManagerNotifyConnectionGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerNotifyConnectionGet::clear() {
    clearDevicetype();
}

inline void DevManagerNotifyConnectionGet::clearDevicetype() {
    if (hasDevicetype()) {
         clear_has_Devicetype();
        _Devicetype.clear();
     }
}

inline bool DevManagerNotifyConnectionGet::hasDevicetype () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& DevManagerNotifyConnectionGet::getDevicetype () const {
    return _Devicetype;
}

inline ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& DevManagerNotifyConnectionGet::getDevicetypeMutable () {
    set_has_Devicetype();
    return _Devicetype;
}

inline void DevManagerNotifyConnectionGet::setDevicetype (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& Devicetype_) {
    set_has_Devicetype();
    this->_Devicetype = Devicetype_;
}

inline void DevManagerNotifyConnectionGet::set_has_Devicetype () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerNotifyConnectionGet::clear_has_Devicetype () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerNotifySDCardStatus::DevManagerNotifySDCardStatus ()  :
    _SDCardList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerNotifySDCardStatus::DevManagerNotifySDCardStatus (const DevManagerNotifySDCardStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SDCardList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerNotifySDCardStatus::DevManagerNotifySDCardStatus (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& SDCardList_)  :
    _SDCardList (SDCardList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerNotifySDCardStatus::~DevManagerNotifySDCardStatus() {
}

inline DevManagerNotifySDCardStatus& DevManagerNotifySDCardStatus::operator = (const DevManagerNotifySDCardStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSDCardList()) {
            setSDCardList(rhs.getSDCardList());
        } else {
            clearSDCardList();
        }
    }
    return *this;
}

inline bool DevManagerNotifySDCardStatus::operator == (const DevManagerNotifySDCardStatus& rhs) const {
    return (((!hasSDCardList() && !rhs.hasSDCardList()) || getSDCardList() == rhs.getSDCardList()));
}

inline bool DevManagerNotifySDCardStatus::operator != (const DevManagerNotifySDCardStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerNotifySDCardStatus::operator < (const DevManagerNotifySDCardStatus& rhs) const {
    if (hasSDCardList() || rhs.hasSDCardList()) {
        if (getSDCardList() < rhs.getSDCardList()) return true;
        if (getSDCardList() > rhs.getSDCardList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerNotifySDCardStatus::clone() {
    return new DevManagerNotifySDCardStatus(*this);
}

inline bool DevManagerNotifySDCardStatus::operator > (const DevManagerNotifySDCardStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerNotifySDCardStatus::clear() {
    clearSDCardList();
}

inline void DevManagerNotifySDCardStatus::clearSDCardList() {
    if (hasSDCardList()) {
         clear_has_SDCardList();
        _SDCardList.clear();
     }
}

inline bool DevManagerNotifySDCardStatus::hasSDCardList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& DevManagerNotifySDCardStatus::getSDCardList () const {
    return _SDCardList;
}

inline ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& DevManagerNotifySDCardStatus::getSDCardListMutable () {
    set_has_SDCardList();
    return _SDCardList;
}

inline void DevManagerNotifySDCardStatus::setSDCardList (const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_SDCardInfo >& SDCardList_) {
    set_has_SDCardList();
    this->_SDCardList = SDCardList_;
}

inline void DevManagerNotifySDCardStatus::set_has_SDCardList () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerNotifySDCardStatus::clear_has_SDCardList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerOverTempCDStatus::DevManagerOverTempCDStatus ()  :
    _OverTemperature (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerOverTempCDStatus::DevManagerOverTempCDStatus (const DevManagerOverTempCDStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _OverTemperature (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerOverTempCDStatus::DevManagerOverTempCDStatus (bool OverTemperature_)  :
    _OverTemperature (OverTemperature_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerOverTempCDStatus::~DevManagerOverTempCDStatus() {
}

inline DevManagerOverTempCDStatus& DevManagerOverTempCDStatus::operator = (const DevManagerOverTempCDStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOverTemperature()) {
            setOverTemperature(rhs.getOverTemperature());
        } else {
            clearOverTemperature();
        }
    }
    return *this;
}

inline bool DevManagerOverTempCDStatus::operator == (const DevManagerOverTempCDStatus& rhs) const {
    return (((!hasOverTemperature() && !rhs.hasOverTemperature()) || getOverTemperature() == rhs.getOverTemperature()));
}

inline bool DevManagerOverTempCDStatus::operator != (const DevManagerOverTempCDStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerOverTempCDStatus::operator < (const DevManagerOverTempCDStatus& rhs) const {
    if (hasOverTemperature() || rhs.hasOverTemperature()) {
        if (getOverTemperature() < rhs.getOverTemperature()) return true;
        if (getOverTemperature() > rhs.getOverTemperature()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerOverTempCDStatus::clone() {
    return new DevManagerOverTempCDStatus(*this);
}

inline bool DevManagerOverTempCDStatus::operator > (const DevManagerOverTempCDStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerOverTempCDStatus::clear() {
    clearOverTemperature();
}

inline void DevManagerOverTempCDStatus::clearOverTemperature() {
    if (hasOverTemperature()) {
         clear_has_OverTemperature();
        _OverTemperature = false;
     }
}

inline bool DevManagerOverTempCDStatus::hasOverTemperature () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerOverTempCDStatus::getOverTemperature () const {
    return _OverTemperature;
}

inline void DevManagerOverTempCDStatus::setOverTemperature (bool OverTemperature_) {
    set_has_OverTemperature();
    this->_OverTemperature = OverTemperature_;
}

inline void DevManagerOverTempCDStatus::set_has_OverTemperature () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerOverTempCDStatus::clear_has_OverTemperature () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerOverTempCDSet::DevManagerOverTempCDSet ()  :
    _OverTemperature (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerOverTempCDSet::DevManagerOverTempCDSet (const DevManagerOverTempCDSet &rhs)  :
    ::asf::core::Payload(rhs),
    _OverTemperature (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerOverTempCDSet::DevManagerOverTempCDSet (bool OverTemperature_)  :
    _OverTemperature (OverTemperature_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerOverTempCDSet::~DevManagerOverTempCDSet() {
}

inline DevManagerOverTempCDSet& DevManagerOverTempCDSet::operator = (const DevManagerOverTempCDSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOverTemperature()) {
            setOverTemperature(rhs.getOverTemperature());
        } else {
            clearOverTemperature();
        }
    }
    return *this;
}

inline bool DevManagerOverTempCDSet::operator == (const DevManagerOverTempCDSet& rhs) const {
    return (((!hasOverTemperature() && !rhs.hasOverTemperature()) || getOverTemperature() == rhs.getOverTemperature()));
}

inline bool DevManagerOverTempCDSet::operator != (const DevManagerOverTempCDSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerOverTempCDSet::operator < (const DevManagerOverTempCDSet& rhs) const {
    if (hasOverTemperature() || rhs.hasOverTemperature()) {
        if (getOverTemperature() < rhs.getOverTemperature()) return true;
        if (getOverTemperature() > rhs.getOverTemperature()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerOverTempCDSet::clone() {
    return new DevManagerOverTempCDSet(*this);
}

inline bool DevManagerOverTempCDSet::operator > (const DevManagerOverTempCDSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerOverTempCDSet::clear() {
    clearOverTemperature();
}

inline void DevManagerOverTempCDSet::clearOverTemperature() {
    if (hasOverTemperature()) {
         clear_has_OverTemperature();
        _OverTemperature = false;
     }
}

inline bool DevManagerOverTempCDSet::hasOverTemperature () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerOverTempCDSet::getOverTemperature () const {
    return _OverTemperature;
}

inline void DevManagerOverTempCDSet::setOverTemperature (bool OverTemperature_) {
    set_has_OverTemperature();
    this->_OverTemperature = OverTemperature_;
}

inline void DevManagerOverTempCDSet::set_has_OverTemperature () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerOverTempCDSet::clear_has_OverTemperature () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerTelematicsBoxAliveStatus::DevManagerTelematicsBoxAliveStatus ()  :
    _BTAConnectionStatus (false),
    _TimoutBeforeSendingITC (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerTelematicsBoxAliveStatus::DevManagerTelematicsBoxAliveStatus (const DevManagerTelematicsBoxAliveStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _BTAConnectionStatus (false),
    _TimoutBeforeSendingITC (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerTelematicsBoxAliveStatus::DevManagerTelematicsBoxAliveStatus (bool BTAConnectionStatus_, uint32 TimoutBeforeSendingITC_)  :
    _BTAConnectionStatus (BTAConnectionStatus_),
    _TimoutBeforeSendingITC (TimoutBeforeSendingITC_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerTelematicsBoxAliveStatus::~DevManagerTelematicsBoxAliveStatus() {
}

inline DevManagerTelematicsBoxAliveStatus& DevManagerTelematicsBoxAliveStatus::operator = (const DevManagerTelematicsBoxAliveStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBTAConnectionStatus()) {
            setBTAConnectionStatus(rhs.getBTAConnectionStatus());
        } else {
            clearBTAConnectionStatus();
        }
        if (rhs.hasTimoutBeforeSendingITC()) {
            setTimoutBeforeSendingITC(rhs.getTimoutBeforeSendingITC());
        } else {
            clearTimoutBeforeSendingITC();
        }
    }
    return *this;
}

inline bool DevManagerTelematicsBoxAliveStatus::operator == (const DevManagerTelematicsBoxAliveStatus& rhs) const {
    return (((!hasBTAConnectionStatus() && !rhs.hasBTAConnectionStatus()) || getBTAConnectionStatus() == rhs.getBTAConnectionStatus()) &&
        ((!hasTimoutBeforeSendingITC() && !rhs.hasTimoutBeforeSendingITC()) || getTimoutBeforeSendingITC() == rhs.getTimoutBeforeSendingITC()));
}

inline bool DevManagerTelematicsBoxAliveStatus::operator != (const DevManagerTelematicsBoxAliveStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerTelematicsBoxAliveStatus::operator < (const DevManagerTelematicsBoxAliveStatus& rhs) const {
    if (hasBTAConnectionStatus() || rhs.hasBTAConnectionStatus()) {
        if (getBTAConnectionStatus() < rhs.getBTAConnectionStatus()) return true;
        if (getBTAConnectionStatus() > rhs.getBTAConnectionStatus()) return false;
    }
    if (hasTimoutBeforeSendingITC() || rhs.hasTimoutBeforeSendingITC()) {
        if (getTimoutBeforeSendingITC() < rhs.getTimoutBeforeSendingITC()) return true;
        if (getTimoutBeforeSendingITC() > rhs.getTimoutBeforeSendingITC()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerTelematicsBoxAliveStatus::clone() {
    return new DevManagerTelematicsBoxAliveStatus(*this);
}

inline bool DevManagerTelematicsBoxAliveStatus::operator > (const DevManagerTelematicsBoxAliveStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerTelematicsBoxAliveStatus::clear() {
    clearBTAConnectionStatus();
    clearTimoutBeforeSendingITC();
}

inline void DevManagerTelematicsBoxAliveStatus::clearBTAConnectionStatus() {
    if (hasBTAConnectionStatus()) {
         clear_has_BTAConnectionStatus();
        _BTAConnectionStatus = false;
     }
}

inline bool DevManagerTelematicsBoxAliveStatus::hasBTAConnectionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerTelematicsBoxAliveStatus::getBTAConnectionStatus () const {
    return _BTAConnectionStatus;
}

inline void DevManagerTelematicsBoxAliveStatus::setBTAConnectionStatus (bool BTAConnectionStatus_) {
    set_has_BTAConnectionStatus();
    this->_BTAConnectionStatus = BTAConnectionStatus_;
}

inline void DevManagerTelematicsBoxAliveStatus::clearTimoutBeforeSendingITC() {
    if (hasTimoutBeforeSendingITC()) {
         clear_has_TimoutBeforeSendingITC();
        _TimoutBeforeSendingITC = 0u;
     }
}

inline bool DevManagerTelematicsBoxAliveStatus::hasTimoutBeforeSendingITC () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DevManagerTelematicsBoxAliveStatus::getTimoutBeforeSendingITC () const {
    return _TimoutBeforeSendingITC;
}

inline void DevManagerTelematicsBoxAliveStatus::setTimoutBeforeSendingITC (uint32 TimoutBeforeSendingITC_) {
    set_has_TimoutBeforeSendingITC();
    this->_TimoutBeforeSendingITC = TimoutBeforeSendingITC_;
}

inline void DevManagerTelematicsBoxAliveStatus::set_has_BTAConnectionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerTelematicsBoxAliveStatus::clear_has_BTAConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevManagerTelematicsBoxAliveStatus::set_has_TimoutBeforeSendingITC () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevManagerTelematicsBoxAliveStatus::clear_has_TimoutBeforeSendingITC () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DevManagerTelematicsBoxAliveSet::DevManagerTelematicsBoxAliveSet ()  :
    _BTAConnectionStatus (false),
    _TimoutBeforeSendingITC (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerTelematicsBoxAliveSet::DevManagerTelematicsBoxAliveSet (const DevManagerTelematicsBoxAliveSet &rhs)  :
    ::asf::core::Payload(rhs),
    _BTAConnectionStatus (false),
    _TimoutBeforeSendingITC (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerTelematicsBoxAliveSet::DevManagerTelematicsBoxAliveSet (bool BTAConnectionStatus_, uint32 TimoutBeforeSendingITC_)  :
    _BTAConnectionStatus (BTAConnectionStatus_),
    _TimoutBeforeSendingITC (TimoutBeforeSendingITC_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerTelematicsBoxAliveSet::~DevManagerTelematicsBoxAliveSet() {
}

inline DevManagerTelematicsBoxAliveSet& DevManagerTelematicsBoxAliveSet::operator = (const DevManagerTelematicsBoxAliveSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBTAConnectionStatus()) {
            setBTAConnectionStatus(rhs.getBTAConnectionStatus());
        } else {
            clearBTAConnectionStatus();
        }
        if (rhs.hasTimoutBeforeSendingITC()) {
            setTimoutBeforeSendingITC(rhs.getTimoutBeforeSendingITC());
        } else {
            clearTimoutBeforeSendingITC();
        }
    }
    return *this;
}

inline bool DevManagerTelematicsBoxAliveSet::operator == (const DevManagerTelematicsBoxAliveSet& rhs) const {
    return (((!hasBTAConnectionStatus() && !rhs.hasBTAConnectionStatus()) || getBTAConnectionStatus() == rhs.getBTAConnectionStatus()) &&
        ((!hasTimoutBeforeSendingITC() && !rhs.hasTimoutBeforeSendingITC()) || getTimoutBeforeSendingITC() == rhs.getTimoutBeforeSendingITC()));
}

inline bool DevManagerTelematicsBoxAliveSet::operator != (const DevManagerTelematicsBoxAliveSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerTelematicsBoxAliveSet::operator < (const DevManagerTelematicsBoxAliveSet& rhs) const {
    if (hasBTAConnectionStatus() || rhs.hasBTAConnectionStatus()) {
        if (getBTAConnectionStatus() < rhs.getBTAConnectionStatus()) return true;
        if (getBTAConnectionStatus() > rhs.getBTAConnectionStatus()) return false;
    }
    if (hasTimoutBeforeSendingITC() || rhs.hasTimoutBeforeSendingITC()) {
        if (getTimoutBeforeSendingITC() < rhs.getTimoutBeforeSendingITC()) return true;
        if (getTimoutBeforeSendingITC() > rhs.getTimoutBeforeSendingITC()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerTelematicsBoxAliveSet::clone() {
    return new DevManagerTelematicsBoxAliveSet(*this);
}

inline bool DevManagerTelematicsBoxAliveSet::operator > (const DevManagerTelematicsBoxAliveSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerTelematicsBoxAliveSet::clear() {
    clearBTAConnectionStatus();
    clearTimoutBeforeSendingITC();
}

inline void DevManagerTelematicsBoxAliveSet::clearBTAConnectionStatus() {
    if (hasBTAConnectionStatus()) {
         clear_has_BTAConnectionStatus();
        _BTAConnectionStatus = false;
     }
}

inline bool DevManagerTelematicsBoxAliveSet::hasBTAConnectionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerTelematicsBoxAliveSet::getBTAConnectionStatus () const {
    return _BTAConnectionStatus;
}

inline void DevManagerTelematicsBoxAliveSet::setBTAConnectionStatus (bool BTAConnectionStatus_) {
    set_has_BTAConnectionStatus();
    this->_BTAConnectionStatus = BTAConnectionStatus_;
}

inline void DevManagerTelematicsBoxAliveSet::clearTimoutBeforeSendingITC() {
    if (hasTimoutBeforeSendingITC()) {
         clear_has_TimoutBeforeSendingITC();
        _TimoutBeforeSendingITC = 0u;
     }
}

inline bool DevManagerTelematicsBoxAliveSet::hasTimoutBeforeSendingITC () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DevManagerTelematicsBoxAliveSet::getTimoutBeforeSendingITC () const {
    return _TimoutBeforeSendingITC;
}

inline void DevManagerTelematicsBoxAliveSet::setTimoutBeforeSendingITC (uint32 TimoutBeforeSendingITC_) {
    set_has_TimoutBeforeSendingITC();
    this->_TimoutBeforeSendingITC = TimoutBeforeSendingITC_;
}

inline void DevManagerTelematicsBoxAliveSet::set_has_BTAConnectionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerTelematicsBoxAliveSet::clear_has_BTAConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevManagerTelematicsBoxAliveSet::set_has_TimoutBeforeSendingITC () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevManagerTelematicsBoxAliveSet::clear_has_TimoutBeforeSendingITC () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DevManagerNotifySlotStateOpticalDiscStatus::DevManagerNotifySlotStateOpticalDiscStatus ()  :
    _OpticalDiscSlotState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerNotifySlotStateOpticalDiscStatus::DevManagerNotifySlotStateOpticalDiscStatus (const DevManagerNotifySlotStateOpticalDiscStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _OpticalDiscSlotState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerNotifySlotStateOpticalDiscStatus::DevManagerNotifySlotStateOpticalDiscStatus (const ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& OpticalDiscSlotState_)  :
    _OpticalDiscSlotState (OpticalDiscSlotState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerNotifySlotStateOpticalDiscStatus::~DevManagerNotifySlotStateOpticalDiscStatus() {
}

inline DevManagerNotifySlotStateOpticalDiscStatus& DevManagerNotifySlotStateOpticalDiscStatus::operator = (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOpticalDiscSlotState()) {
            setOpticalDiscSlotState(rhs.getOpticalDiscSlotState());
        } else {
            clearOpticalDiscSlotState();
        }
    }
    return *this;
}

inline bool DevManagerNotifySlotStateOpticalDiscStatus::operator == (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) const {
    return (((!hasOpticalDiscSlotState() && !rhs.hasOpticalDiscSlotState()) || getOpticalDiscSlotState() == rhs.getOpticalDiscSlotState()));
}

inline bool DevManagerNotifySlotStateOpticalDiscStatus::operator != (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerNotifySlotStateOpticalDiscStatus::operator < (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) const {
    if (hasOpticalDiscSlotState() || rhs.hasOpticalDiscSlotState()) {
        if (getOpticalDiscSlotState() < rhs.getOpticalDiscSlotState()) return true;
        if (getOpticalDiscSlotState() > rhs.getOpticalDiscSlotState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerNotifySlotStateOpticalDiscStatus::clone() {
    return new DevManagerNotifySlotStateOpticalDiscStatus(*this);
}

inline bool DevManagerNotifySlotStateOpticalDiscStatus::operator > (const DevManagerNotifySlotStateOpticalDiscStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerNotifySlotStateOpticalDiscStatus::clear() {
    clearOpticalDiscSlotState();
}

inline void DevManagerNotifySlotStateOpticalDiscStatus::clearOpticalDiscSlotState() {
    if (hasOpticalDiscSlotState()) {
         clear_has_OpticalDiscSlotState();
        _OpticalDiscSlotState.clear();
     }
}

inline bool DevManagerNotifySlotStateOpticalDiscStatus::hasOpticalDiscSlotState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& DevManagerNotifySlotStateOpticalDiscStatus::getOpticalDiscSlotState () const {
    return _OpticalDiscSlotState;
}

inline ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& DevManagerNotifySlotStateOpticalDiscStatus::getOpticalDiscSlotStateMutable () {
    set_has_OpticalDiscSlotState();
    return _OpticalDiscSlotState;
}

inline void DevManagerNotifySlotStateOpticalDiscStatus::setOpticalDiscSlotState (const ::std::vector< ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType >& OpticalDiscSlotState_) {
    set_has_OpticalDiscSlotState();
    this->_OpticalDiscSlotState = OpticalDiscSlotState_;
}

inline void DevManagerNotifySlotStateOpticalDiscStatus::set_has_OpticalDiscSlotState () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerNotifySlotStateOpticalDiscStatus::clear_has_OpticalDiscSlotState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerNotifyCDInfoStatus::DevManagerNotifyCDInfoStatus ()  :
    _CDInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerNotifyCDInfoStatus::DevManagerNotifyCDInfoStatus (const DevManagerNotifyCDInfoStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _CDInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerNotifyCDInfoStatus::DevManagerNotifyCDInfoStatus (const ::mplay_shared_fi_types::T_e8_CDInfo& CDInfo_)  :
    _CDInfo (CDInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerNotifyCDInfoStatus::~DevManagerNotifyCDInfoStatus() {
}

inline DevManagerNotifyCDInfoStatus& DevManagerNotifyCDInfoStatus::operator = (const DevManagerNotifyCDInfoStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCDInfo()) {
            setCDInfo(rhs.getCDInfo());
        } else {
            clearCDInfo();
        }
    }
    return *this;
}

inline bool DevManagerNotifyCDInfoStatus::operator == (const DevManagerNotifyCDInfoStatus& rhs) const {
    return (((!hasCDInfo() && !rhs.hasCDInfo()) || getCDInfo() == rhs.getCDInfo()));
}

inline bool DevManagerNotifyCDInfoStatus::operator != (const DevManagerNotifyCDInfoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerNotifyCDInfoStatus::operator < (const DevManagerNotifyCDInfoStatus& rhs) const {
    if (hasCDInfo() || rhs.hasCDInfo()) {
        if (getCDInfo() < rhs.getCDInfo()) return true;
        if (getCDInfo() > rhs.getCDInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerNotifyCDInfoStatus::clone() {
    return new DevManagerNotifyCDInfoStatus(*this);
}

inline bool DevManagerNotifyCDInfoStatus::operator > (const DevManagerNotifyCDInfoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerNotifyCDInfoStatus::clear() {
    clearCDInfo();
}

inline void DevManagerNotifyCDInfoStatus::clearCDInfo() {
    if (hasCDInfo()) {
         clear_has_CDInfo();
        _CDInfo.clear();
     }
}

inline bool DevManagerNotifyCDInfoStatus::hasCDInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::mplay_shared_fi_types::T_e8_CDInfo& DevManagerNotifyCDInfoStatus::getCDInfo () const {
    return _CDInfo;
}

inline ::mplay_shared_fi_types::T_e8_CDInfo& DevManagerNotifyCDInfoStatus::getCDInfoMutable () {
    set_has_CDInfo();
    return _CDInfo;
}

inline void DevManagerNotifyCDInfoStatus::setCDInfo (const ::mplay_shared_fi_types::T_e8_CDInfo& CDInfo_) {
    set_has_CDInfo();
    this->_CDInfo = CDInfo_;
}

inline void DevManagerNotifyCDInfoStatus::set_has_CDInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerNotifyCDInfoStatus::clear_has_CDInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerDVDDriveInfoSet::DevManagerDVDDriveInfoSet ()  :
    _e8DVDDiscType (::mplay_devicemanager_fi_types::T_e8_MDVDDiscType__e8NON_DISC_DATA),
    _e8DVDDriveMode (::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode__e8MASS_STORAGE_MODE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerDVDDriveInfoSet::DevManagerDVDDriveInfoSet (const DevManagerDVDDriveInfoSet &rhs)  :
    ::asf::core::Payload(rhs),
    _e8DVDDiscType (::mplay_devicemanager_fi_types::T_e8_MDVDDiscType__e8NON_DISC_DATA),
    _e8DVDDriveMode (::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode__e8MASS_STORAGE_MODE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerDVDDriveInfoSet::DevManagerDVDDriveInfoSet (::mplay_devicemanager_fi_types::T_e8_MDVDDiscType e8DVDDiscType_, ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode e8DVDDriveMode_)  :
    _e8DVDDiscType (e8DVDDiscType_),
    _e8DVDDriveMode (e8DVDDriveMode_)
{
    #ifndef NDEBUG
    if (!(::mplay_devicemanager_fi_types::T_e8_MDVDDiscType_IsValid(e8DVDDiscType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DVDDiscType_, "T_e8_MDVDDiscType", "e8DVDDiscType", "DevManagerDVDDriveInfoSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode_IsValid(e8DVDDriveMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DVDDriveMode_, "T_e8_MDVDDriveMode", "e8DVDDriveMode", "DevManagerDVDDriveInfoSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerDVDDriveInfoSet::~DevManagerDVDDriveInfoSet() {
}

inline DevManagerDVDDriveInfoSet& DevManagerDVDDriveInfoSet::operator = (const DevManagerDVDDriveInfoSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8DVDDiscType()) {
            setE8DVDDiscType(rhs.getE8DVDDiscType());
        } else {
            clearE8DVDDiscType();
        }
        if (rhs.hasE8DVDDriveMode()) {
            setE8DVDDriveMode(rhs.getE8DVDDriveMode());
        } else {
            clearE8DVDDriveMode();
        }
    }
    return *this;
}

inline bool DevManagerDVDDriveInfoSet::operator == (const DevManagerDVDDriveInfoSet& rhs) const {
    return (((!hasE8DVDDiscType() && !rhs.hasE8DVDDiscType()) || getE8DVDDiscType() == rhs.getE8DVDDiscType()) &&
        ((!hasE8DVDDriveMode() && !rhs.hasE8DVDDriveMode()) || getE8DVDDriveMode() == rhs.getE8DVDDriveMode()));
}

inline bool DevManagerDVDDriveInfoSet::operator != (const DevManagerDVDDriveInfoSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerDVDDriveInfoSet::operator < (const DevManagerDVDDriveInfoSet& rhs) const {
    if (hasE8DVDDiscType() || rhs.hasE8DVDDiscType()) {
        if ((uint32)getE8DVDDiscType() < (uint32)rhs.getE8DVDDiscType()) return true;
        if ((uint32)getE8DVDDiscType() > (uint32)rhs.getE8DVDDiscType()) return false;
    }
    if (hasE8DVDDriveMode() || rhs.hasE8DVDDriveMode()) {
        if ((uint32)getE8DVDDriveMode() < (uint32)rhs.getE8DVDDriveMode()) return true;
        if ((uint32)getE8DVDDriveMode() > (uint32)rhs.getE8DVDDriveMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerDVDDriveInfoSet::clone() {
    return new DevManagerDVDDriveInfoSet(*this);
}

inline bool DevManagerDVDDriveInfoSet::operator > (const DevManagerDVDDriveInfoSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerDVDDriveInfoSet::clear() {
    clearE8DVDDiscType();
    clearE8DVDDriveMode();
}

inline void DevManagerDVDDriveInfoSet::clearE8DVDDiscType() {
    if (hasE8DVDDiscType()) {
         clear_has_e8DVDDiscType();
        _e8DVDDiscType = ::mplay_devicemanager_fi_types::T_e8_MDVDDiscType__e8NON_DISC_DATA;
     }
}

inline bool DevManagerDVDDriveInfoSet::hasE8DVDDiscType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::mplay_devicemanager_fi_types::T_e8_MDVDDiscType DevManagerDVDDriveInfoSet::getE8DVDDiscType () const {
    return _e8DVDDiscType;
}

inline void DevManagerDVDDriveInfoSet::setE8DVDDiscType (::mplay_devicemanager_fi_types::T_e8_MDVDDiscType e8DVDDiscType_) {
    #ifndef NDEBUG
    if (!(::mplay_devicemanager_fi_types::T_e8_MDVDDiscType_IsValid(e8DVDDiscType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DVDDiscType_, "T_e8_MDVDDiscType", "e8DVDDiscType", "DevManagerDVDDriveInfoSet");
    }
    #endif
    set_has_e8DVDDiscType();
    this->_e8DVDDiscType = e8DVDDiscType_;
}

inline void DevManagerDVDDriveInfoSet::clearE8DVDDriveMode() {
    if (hasE8DVDDriveMode()) {
         clear_has_e8DVDDriveMode();
        _e8DVDDriveMode = ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode__e8MASS_STORAGE_MODE;
     }
}

inline bool DevManagerDVDDriveInfoSet::hasE8DVDDriveMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode DevManagerDVDDriveInfoSet::getE8DVDDriveMode () const {
    return _e8DVDDriveMode;
}

inline void DevManagerDVDDriveInfoSet::setE8DVDDriveMode (::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode e8DVDDriveMode_) {
    #ifndef NDEBUG
    if (!(::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode_IsValid(e8DVDDriveMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DVDDriveMode_, "T_e8_MDVDDriveMode", "e8DVDDriveMode", "DevManagerDVDDriveInfoSet");
    }
    #endif
    set_has_e8DVDDriveMode();
    this->_e8DVDDriveMode = e8DVDDriveMode_;
}

inline void DevManagerDVDDriveInfoSet::set_has_e8DVDDiscType () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerDVDDriveInfoSet::clear_has_e8DVDDiscType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevManagerDVDDriveInfoSet::set_has_e8DVDDriveMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevManagerDVDDriveInfoSet::clear_has_e8DVDDriveMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DevManagerMountCDROMInternalStart::DevManagerMountCDROMInternalStart ()  :
    _Mount (false),
    _BlockDevice ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerMountCDROMInternalStart::DevManagerMountCDROMInternalStart (const DevManagerMountCDROMInternalStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Mount (false),
    _BlockDevice ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerMountCDROMInternalStart::DevManagerMountCDROMInternalStart (bool Mount_, const ::std::string& BlockDevice_)  :
    _Mount (Mount_),
    _BlockDevice (BlockDevice_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BlockDevice_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerMountCDROMInternalStart::~DevManagerMountCDROMInternalStart() {
}

inline DevManagerMountCDROMInternalStart& DevManagerMountCDROMInternalStart::operator = (const DevManagerMountCDROMInternalStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMount()) {
            setMount(rhs.getMount());
        } else {
            clearMount();
        }
        if (rhs.hasBlockDevice()) {
            setBlockDevice(rhs.getBlockDevice());
        } else {
            clearBlockDevice();
        }
    }
    return *this;
}

inline bool DevManagerMountCDROMInternalStart::operator == (const DevManagerMountCDROMInternalStart& rhs) const {
    return (((!hasMount() && !rhs.hasMount()) || getMount() == rhs.getMount()) &&
        ((!hasBlockDevice() && !rhs.hasBlockDevice()) || getBlockDevice() == rhs.getBlockDevice()));
}

inline bool DevManagerMountCDROMInternalStart::operator != (const DevManagerMountCDROMInternalStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerMountCDROMInternalStart::operator < (const DevManagerMountCDROMInternalStart& rhs) const {
    if (hasMount() || rhs.hasMount()) {
        if (getMount() < rhs.getMount()) return true;
        if (getMount() > rhs.getMount()) return false;
    }
    if (hasBlockDevice() || rhs.hasBlockDevice()) {
        if (getBlockDevice() < rhs.getBlockDevice()) return true;
        if (getBlockDevice() > rhs.getBlockDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerMountCDROMInternalStart::clone() {
    return new DevManagerMountCDROMInternalStart(*this);
}

inline bool DevManagerMountCDROMInternalStart::operator > (const DevManagerMountCDROMInternalStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerMountCDROMInternalStart::clear() {
    clearMount();
    clearBlockDevice();
}

inline void DevManagerMountCDROMInternalStart::clearMount() {
    if (hasMount()) {
         clear_has_Mount();
        _Mount = false;
     }
}

inline bool DevManagerMountCDROMInternalStart::hasMount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerMountCDROMInternalStart::getMount () const {
    return _Mount;
}

inline void DevManagerMountCDROMInternalStart::setMount (bool Mount_) {
    set_has_Mount();
    this->_Mount = Mount_;
}

inline void DevManagerMountCDROMInternalStart::clearBlockDevice() {
    if (hasBlockDevice()) {
         clear_has_BlockDevice();
        _BlockDevice.clear();
     }
}

inline bool DevManagerMountCDROMInternalStart::hasBlockDevice () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DevManagerMountCDROMInternalStart::getBlockDevice () const {
    return _BlockDevice;
}

inline ::std::string& DevManagerMountCDROMInternalStart::getBlockDeviceMutable () {
    set_has_BlockDevice();
    return _BlockDevice;
}

inline void DevManagerMountCDROMInternalStart::setBlockDevice (const ::std::string& BlockDevice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BlockDevice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BlockDevice();
    this->_BlockDevice = BlockDevice_;
}

inline void DevManagerMountCDROMInternalStart::setBlockDevice (const char* BlockDevice_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BlockDevice_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BlockDevice();
    this->_BlockDevice.assign(BlockDevice_);
}

inline void DevManagerMountCDROMInternalStart::setBlockDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BlockDevice();
    this->_BlockDevice.assign(value, size);
}

inline void DevManagerMountCDROMInternalStart::set_has_Mount () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerMountCDROMInternalStart::clear_has_Mount () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevManagerMountCDROMInternalStart::set_has_BlockDevice () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevManagerMountCDROMInternalStart::clear_has_BlockDevice () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DevManagerMountCDROMInternalResult::DevManagerMountCDROMInternalResult ()  :
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerMountCDROMInternalResult::DevManagerMountCDROMInternalResult (const DevManagerMountCDROMInternalResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerMountCDROMInternalResult::DevManagerMountCDROMInternalResult (bool Success_)  :
    _Success (Success_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerMountCDROMInternalResult::~DevManagerMountCDROMInternalResult() {
}

inline DevManagerMountCDROMInternalResult& DevManagerMountCDROMInternalResult::operator = (const DevManagerMountCDROMInternalResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
    }
    return *this;
}

inline bool DevManagerMountCDROMInternalResult::operator == (const DevManagerMountCDROMInternalResult& rhs) const {
    return (((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()));
}

inline bool DevManagerMountCDROMInternalResult::operator != (const DevManagerMountCDROMInternalResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerMountCDROMInternalResult::operator < (const DevManagerMountCDROMInternalResult& rhs) const {
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerMountCDROMInternalResult::clone() {
    return new DevManagerMountCDROMInternalResult(*this);
}

inline bool DevManagerMountCDROMInternalResult::operator > (const DevManagerMountCDROMInternalResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerMountCDROMInternalResult::clear() {
    clearSuccess();
}

inline void DevManagerMountCDROMInternalResult::clearSuccess() {
    if (hasSuccess()) {
         clear_has_Success();
        _Success = false;
     }
}

inline bool DevManagerMountCDROMInternalResult::hasSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerMountCDROMInternalResult::getSuccess () const {
    return _Success;
}

inline void DevManagerMountCDROMInternalResult::setSuccess (bool Success_) {
    set_has_Success();
    this->_Success = Success_;
}

inline void DevManagerMountCDROMInternalResult::set_has_Success () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerMountCDROMInternalResult::clear_has_Success () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerEjectOpticalDiscStart::DevManagerEjectOpticalDiscStart ()  :
    _eCmdParam (::mplay_shared_fi_types::T_e8_EjectParmType__e8CMD_EJECT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerEjectOpticalDiscStart::DevManagerEjectOpticalDiscStart (const DevManagerEjectOpticalDiscStart &rhs)  :
    ::asf::core::Payload(rhs),
    _eCmdParam (::mplay_shared_fi_types::T_e8_EjectParmType__e8CMD_EJECT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerEjectOpticalDiscStart::DevManagerEjectOpticalDiscStart (::mplay_shared_fi_types::T_e8_EjectParmType eCmdParam_)  :
    _eCmdParam (eCmdParam_)
{
    #ifndef NDEBUG
    if (!(::mplay_shared_fi_types::T_e8_EjectParmType_IsValid(eCmdParam_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eCmdParam_, "T_e8_EjectParmType", "eCmdParam", "DevManagerEjectOpticalDiscStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerEjectOpticalDiscStart::~DevManagerEjectOpticalDiscStart() {
}

inline DevManagerEjectOpticalDiscStart& DevManagerEjectOpticalDiscStart::operator = (const DevManagerEjectOpticalDiscStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasECmdParam()) {
            setECmdParam(rhs.getECmdParam());
        } else {
            clearECmdParam();
        }
    }
    return *this;
}

inline bool DevManagerEjectOpticalDiscStart::operator == (const DevManagerEjectOpticalDiscStart& rhs) const {
    return (((!hasECmdParam() && !rhs.hasECmdParam()) || getECmdParam() == rhs.getECmdParam()));
}

inline bool DevManagerEjectOpticalDiscStart::operator != (const DevManagerEjectOpticalDiscStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerEjectOpticalDiscStart::operator < (const DevManagerEjectOpticalDiscStart& rhs) const {
    if (hasECmdParam() || rhs.hasECmdParam()) {
        if ((uint32)getECmdParam() < (uint32)rhs.getECmdParam()) return true;
        if ((uint32)getECmdParam() > (uint32)rhs.getECmdParam()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerEjectOpticalDiscStart::clone() {
    return new DevManagerEjectOpticalDiscStart(*this);
}

inline bool DevManagerEjectOpticalDiscStart::operator > (const DevManagerEjectOpticalDiscStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerEjectOpticalDiscStart::clear() {
    clearECmdParam();
}

inline void DevManagerEjectOpticalDiscStart::clearECmdParam() {
    if (hasECmdParam()) {
         clear_has_eCmdParam();
        _eCmdParam = ::mplay_shared_fi_types::T_e8_EjectParmType__e8CMD_EJECT;
     }
}

inline bool DevManagerEjectOpticalDiscStart::hasECmdParam () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::mplay_shared_fi_types::T_e8_EjectParmType DevManagerEjectOpticalDiscStart::getECmdParam () const {
    return _eCmdParam;
}

inline void DevManagerEjectOpticalDiscStart::setECmdParam (::mplay_shared_fi_types::T_e8_EjectParmType eCmdParam_) {
    #ifndef NDEBUG
    if (!(::mplay_shared_fi_types::T_e8_EjectParmType_IsValid(eCmdParam_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eCmdParam_, "T_e8_EjectParmType", "eCmdParam", "DevManagerEjectOpticalDiscStart");
    }
    #endif
    set_has_eCmdParam();
    this->_eCmdParam = eCmdParam_;
}

inline void DevManagerEjectOpticalDiscStart::set_has_eCmdParam () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerEjectOpticalDiscStart::clear_has_eCmdParam () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerEjectOpticalDiscResult::DevManagerEjectOpticalDiscResult ()  :
    _ServiceStatus (::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult__ACCEPTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerEjectOpticalDiscResult::DevManagerEjectOpticalDiscResult (const DevManagerEjectOpticalDiscResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ServiceStatus (::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult__ACCEPTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerEjectOpticalDiscResult::DevManagerEjectOpticalDiscResult (::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult ServiceStatus_)  :
    _ServiceStatus (ServiceStatus_)
{
    #ifndef NDEBUG
    if (!(::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult_IsValid(ServiceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ServiceStatus_, "T_e8_EjectOpticalDisc_MethodResult", "ServiceStatus", "DevManagerEjectOpticalDiscResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerEjectOpticalDiscResult::~DevManagerEjectOpticalDiscResult() {
}

inline DevManagerEjectOpticalDiscResult& DevManagerEjectOpticalDiscResult::operator = (const DevManagerEjectOpticalDiscResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasServiceStatus()) {
            setServiceStatus(rhs.getServiceStatus());
        } else {
            clearServiceStatus();
        }
    }
    return *this;
}

inline bool DevManagerEjectOpticalDiscResult::operator == (const DevManagerEjectOpticalDiscResult& rhs) const {
    return (((!hasServiceStatus() && !rhs.hasServiceStatus()) || getServiceStatus() == rhs.getServiceStatus()));
}

inline bool DevManagerEjectOpticalDiscResult::operator != (const DevManagerEjectOpticalDiscResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerEjectOpticalDiscResult::operator < (const DevManagerEjectOpticalDiscResult& rhs) const {
    if (hasServiceStatus() || rhs.hasServiceStatus()) {
        if ((uint32)getServiceStatus() < (uint32)rhs.getServiceStatus()) return true;
        if ((uint32)getServiceStatus() > (uint32)rhs.getServiceStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerEjectOpticalDiscResult::clone() {
    return new DevManagerEjectOpticalDiscResult(*this);
}

inline bool DevManagerEjectOpticalDiscResult::operator > (const DevManagerEjectOpticalDiscResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerEjectOpticalDiscResult::clear() {
    clearServiceStatus();
}

inline void DevManagerEjectOpticalDiscResult::clearServiceStatus() {
    if (hasServiceStatus()) {
         clear_has_ServiceStatus();
        _ServiceStatus = ::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult__ACCEPTED;
     }
}

inline bool DevManagerEjectOpticalDiscResult::hasServiceStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult DevManagerEjectOpticalDiscResult::getServiceStatus () const {
    return _ServiceStatus;
}

inline void DevManagerEjectOpticalDiscResult::setServiceStatus (::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult ServiceStatus_) {
    #ifndef NDEBUG
    if (!(::mplay_shared_fi_types::T_e8_EjectOpticalDisc_MethodResult_IsValid(ServiceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ServiceStatus_, "T_e8_EjectOpticalDisc_MethodResult", "ServiceStatus", "DevManagerEjectOpticalDiscResult");
    }
    #endif
    set_has_ServiceStatus();
    this->_ServiceStatus = ServiceStatus_;
}

inline void DevManagerEjectOpticalDiscResult::set_has_ServiceStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerEjectOpticalDiscResult::clear_has_ServiceStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerAddTelematicsBoxStart::DevManagerAddTelematicsBoxStart ()  :
    _VendorID (0u),
    _ProductID (0u),
    _USBPortNo (0u),
    _SpeedInfo (::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb__FULL_SPEED),
    _Add (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerAddTelematicsBoxStart::DevManagerAddTelematicsBoxStart (const DevManagerAddTelematicsBoxStart &rhs)  :
    ::asf::core::Payload(rhs),
    _VendorID (0u),
    _ProductID (0u),
    _USBPortNo (0u),
    _SpeedInfo (::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb__FULL_SPEED),
    _Add (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerAddTelematicsBoxStart::DevManagerAddTelematicsBoxStart (uint32 VendorID_, uint32 ProductID_, uint32 USBPortNo_, ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb SpeedInfo_, bool Add_)  :
    _VendorID (VendorID_),
    _ProductID (ProductID_),
    _USBPortNo (USBPortNo_),
    _SpeedInfo (SpeedInfo_),
    _Add (Add_)
{
    #ifndef NDEBUG
    if (!(::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb_IsValid(SpeedInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeedInfo_, "T_e8_DVM_DeviceSpeedUsb", "SpeedInfo", "DevManagerAddTelematicsBoxStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerAddTelematicsBoxStart::~DevManagerAddTelematicsBoxStart() {
}

inline DevManagerAddTelematicsBoxStart& DevManagerAddTelematicsBoxStart::operator = (const DevManagerAddTelematicsBoxStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVendorID()) {
            setVendorID(rhs.getVendorID());
        } else {
            clearVendorID();
        }
        if (rhs.hasProductID()) {
            setProductID(rhs.getProductID());
        } else {
            clearProductID();
        }
        if (rhs.hasUSBPortNo()) {
            setUSBPortNo(rhs.getUSBPortNo());
        } else {
            clearUSBPortNo();
        }
        if (rhs.hasSpeedInfo()) {
            setSpeedInfo(rhs.getSpeedInfo());
        } else {
            clearSpeedInfo();
        }
        if (rhs.hasAdd()) {
            setAdd(rhs.getAdd());
        } else {
            clearAdd();
        }
    }
    return *this;
}

inline bool DevManagerAddTelematicsBoxStart::operator == (const DevManagerAddTelematicsBoxStart& rhs) const {
    return (((!hasVendorID() && !rhs.hasVendorID()) || getVendorID() == rhs.getVendorID()) &&
        ((!hasProductID() && !rhs.hasProductID()) || getProductID() == rhs.getProductID()) &&
        ((!hasUSBPortNo() && !rhs.hasUSBPortNo()) || getUSBPortNo() == rhs.getUSBPortNo()) &&
        ((!hasSpeedInfo() && !rhs.hasSpeedInfo()) || getSpeedInfo() == rhs.getSpeedInfo()) &&
        ((!hasAdd() && !rhs.hasAdd()) || getAdd() == rhs.getAdd()));
}

inline bool DevManagerAddTelematicsBoxStart::operator != (const DevManagerAddTelematicsBoxStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerAddTelematicsBoxStart::operator < (const DevManagerAddTelematicsBoxStart& rhs) const {
    if (hasVendorID() || rhs.hasVendorID()) {
        if (getVendorID() < rhs.getVendorID()) return true;
        if (getVendorID() > rhs.getVendorID()) return false;
    }
    if (hasProductID() || rhs.hasProductID()) {
        if (getProductID() < rhs.getProductID()) return true;
        if (getProductID() > rhs.getProductID()) return false;
    }
    if (hasUSBPortNo() || rhs.hasUSBPortNo()) {
        if (getUSBPortNo() < rhs.getUSBPortNo()) return true;
        if (getUSBPortNo() > rhs.getUSBPortNo()) return false;
    }
    if (hasSpeedInfo() || rhs.hasSpeedInfo()) {
        if ((uint32)getSpeedInfo() < (uint32)rhs.getSpeedInfo()) return true;
        if ((uint32)getSpeedInfo() > (uint32)rhs.getSpeedInfo()) return false;
    }
    if (hasAdd() || rhs.hasAdd()) {
        if (getAdd() < rhs.getAdd()) return true;
        if (getAdd() > rhs.getAdd()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerAddTelematicsBoxStart::clone() {
    return new DevManagerAddTelematicsBoxStart(*this);
}

inline bool DevManagerAddTelematicsBoxStart::operator > (const DevManagerAddTelematicsBoxStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerAddTelematicsBoxStart::clear() {
    clearVendorID();
    clearProductID();
    clearUSBPortNo();
    clearSpeedInfo();
    clearAdd();
}

inline void DevManagerAddTelematicsBoxStart::clearVendorID() {
    if (hasVendorID()) {
         clear_has_VendorID();
        _VendorID = 0u;
     }
}

inline bool DevManagerAddTelematicsBoxStart::hasVendorID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DevManagerAddTelematicsBoxStart::getVendorID () const {
    return _VendorID;
}

inline void DevManagerAddTelematicsBoxStart::setVendorID (uint32 VendorID_) {
    set_has_VendorID();
    this->_VendorID = VendorID_;
}

inline void DevManagerAddTelematicsBoxStart::clearProductID() {
    if (hasProductID()) {
         clear_has_ProductID();
        _ProductID = 0u;
     }
}

inline bool DevManagerAddTelematicsBoxStart::hasProductID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DevManagerAddTelematicsBoxStart::getProductID () const {
    return _ProductID;
}

inline void DevManagerAddTelematicsBoxStart::setProductID (uint32 ProductID_) {
    set_has_ProductID();
    this->_ProductID = ProductID_;
}

inline void DevManagerAddTelematicsBoxStart::clearUSBPortNo() {
    if (hasUSBPortNo()) {
         clear_has_USBPortNo();
        _USBPortNo = 0u;
     }
}

inline bool DevManagerAddTelematicsBoxStart::hasUSBPortNo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 DevManagerAddTelematicsBoxStart::getUSBPortNo () const {
    return _USBPortNo;
}

inline void DevManagerAddTelematicsBoxStart::setUSBPortNo (uint32 USBPortNo_) {
    set_has_USBPortNo();
    this->_USBPortNo = USBPortNo_;
}

inline void DevManagerAddTelematicsBoxStart::clearSpeedInfo() {
    if (hasSpeedInfo()) {
         clear_has_SpeedInfo();
        _SpeedInfo = ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb__FULL_SPEED;
     }
}

inline bool DevManagerAddTelematicsBoxStart::hasSpeedInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb DevManagerAddTelematicsBoxStart::getSpeedInfo () const {
    return _SpeedInfo;
}

inline void DevManagerAddTelematicsBoxStart::setSpeedInfo (::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb SpeedInfo_) {
    #ifndef NDEBUG
    if (!(::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb_IsValid(SpeedInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeedInfo_, "T_e8_DVM_DeviceSpeedUsb", "SpeedInfo", "DevManagerAddTelematicsBoxStart");
    }
    #endif
    set_has_SpeedInfo();
    this->_SpeedInfo = SpeedInfo_;
}

inline void DevManagerAddTelematicsBoxStart::clearAdd() {
    if (hasAdd()) {
         clear_has_Add();
        _Add = false;
     }
}

inline bool DevManagerAddTelematicsBoxStart::hasAdd () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool DevManagerAddTelematicsBoxStart::getAdd () const {
    return _Add;
}

inline void DevManagerAddTelematicsBoxStart::setAdd (bool Add_) {
    set_has_Add();
    this->_Add = Add_;
}

inline void DevManagerAddTelematicsBoxStart::set_has_VendorID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerAddTelematicsBoxStart::clear_has_VendorID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevManagerAddTelematicsBoxStart::set_has_ProductID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevManagerAddTelematicsBoxStart::clear_has_ProductID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DevManagerAddTelematicsBoxStart::set_has_USBPortNo () {
    _has_bits_[0] |= 1u << 2;
}

inline void DevManagerAddTelematicsBoxStart::clear_has_USBPortNo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DevManagerAddTelematicsBoxStart::set_has_SpeedInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void DevManagerAddTelematicsBoxStart::clear_has_SpeedInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DevManagerAddTelematicsBoxStart::set_has_Add () {
    _has_bits_[0] |= 1u << 4;
}

inline void DevManagerAddTelematicsBoxStart::clear_has_Add () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  DevManagerAddTelematicsBoxResult::DevManagerAddTelematicsBoxResult ()  :
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerAddTelematicsBoxResult::DevManagerAddTelematicsBoxResult (const DevManagerAddTelematicsBoxResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerAddTelematicsBoxResult::DevManagerAddTelematicsBoxResult (bool Success_)  :
    _Success (Success_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerAddTelematicsBoxResult::~DevManagerAddTelematicsBoxResult() {
}

inline DevManagerAddTelematicsBoxResult& DevManagerAddTelematicsBoxResult::operator = (const DevManagerAddTelematicsBoxResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
    }
    return *this;
}

inline bool DevManagerAddTelematicsBoxResult::operator == (const DevManagerAddTelematicsBoxResult& rhs) const {
    return (((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()));
}

inline bool DevManagerAddTelematicsBoxResult::operator != (const DevManagerAddTelematicsBoxResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerAddTelematicsBoxResult::operator < (const DevManagerAddTelematicsBoxResult& rhs) const {
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerAddTelematicsBoxResult::clone() {
    return new DevManagerAddTelematicsBoxResult(*this);
}

inline bool DevManagerAddTelematicsBoxResult::operator > (const DevManagerAddTelematicsBoxResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerAddTelematicsBoxResult::clear() {
    clearSuccess();
}

inline void DevManagerAddTelematicsBoxResult::clearSuccess() {
    if (hasSuccess()) {
         clear_has_Success();
        _Success = false;
     }
}

inline bool DevManagerAddTelematicsBoxResult::hasSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerAddTelematicsBoxResult::getSuccess () const {
    return _Success;
}

inline void DevManagerAddTelematicsBoxResult::setSuccess (bool Success_) {
    set_has_Success();
    this->_Success = Success_;
}

inline void DevManagerAddTelematicsBoxResult::set_has_Success () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerAddTelematicsBoxResult::clear_has_Success () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerSetConfigurationValueStart::DevManagerSetConfigurationValueStart ()  :
    _ConfigurationParam (),
    _Value (0u),
    _SettingsMode (::mplay_devicemanager_fi_types::T_e8_SettingsMode__Default)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerSetConfigurationValueStart::DevManagerSetConfigurationValueStart (const DevManagerSetConfigurationValueStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigurationParam (),
    _Value (0u),
    _SettingsMode (::mplay_devicemanager_fi_types::T_e8_SettingsMode__Default)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerSetConfigurationValueStart::DevManagerSetConfigurationValueStart (const ::std::string& ConfigurationParam_, uint16 Value_, ::mplay_devicemanager_fi_types::T_e8_SettingsMode SettingsMode_)  :
    _ConfigurationParam (ConfigurationParam_),
    _Value (Value_),
    _SettingsMode (SettingsMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ConfigurationParam_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::mplay_devicemanager_fi_types::T_e8_SettingsMode_IsValid(SettingsMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SettingsMode_, "T_e8_SettingsMode", "SettingsMode", "DevManagerSetConfigurationValueStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerSetConfigurationValueStart::~DevManagerSetConfigurationValueStart() {
}

inline DevManagerSetConfigurationValueStart& DevManagerSetConfigurationValueStart::operator = (const DevManagerSetConfigurationValueStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigurationParam()) {
            setConfigurationParam(rhs.getConfigurationParam());
        } else {
            clearConfigurationParam();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
        if (rhs.hasSettingsMode()) {
            setSettingsMode(rhs.getSettingsMode());
        } else {
            clearSettingsMode();
        }
    }
    return *this;
}

inline bool DevManagerSetConfigurationValueStart::operator == (const DevManagerSetConfigurationValueStart& rhs) const {
    return (((!hasConfigurationParam() && !rhs.hasConfigurationParam()) || getConfigurationParam() == rhs.getConfigurationParam()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()) &&
        ((!hasSettingsMode() && !rhs.hasSettingsMode()) || getSettingsMode() == rhs.getSettingsMode()));
}

inline bool DevManagerSetConfigurationValueStart::operator != (const DevManagerSetConfigurationValueStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerSetConfigurationValueStart::operator < (const DevManagerSetConfigurationValueStart& rhs) const {
    if (hasConfigurationParam() || rhs.hasConfigurationParam()) {
        if (getConfigurationParam() < rhs.getConfigurationParam()) return true;
        if (getConfigurationParam() > rhs.getConfigurationParam()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    if (hasSettingsMode() || rhs.hasSettingsMode()) {
        if ((uint32)getSettingsMode() < (uint32)rhs.getSettingsMode()) return true;
        if ((uint32)getSettingsMode() > (uint32)rhs.getSettingsMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerSetConfigurationValueStart::clone() {
    return new DevManagerSetConfigurationValueStart(*this);
}

inline bool DevManagerSetConfigurationValueStart::operator > (const DevManagerSetConfigurationValueStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerSetConfigurationValueStart::clear() {
    clearConfigurationParam();
    clearValue();
    clearSettingsMode();
}

inline void DevManagerSetConfigurationValueStart::clearConfigurationParam() {
    if (hasConfigurationParam()) {
         clear_has_ConfigurationParam();
        _ConfigurationParam.clear();
     }
}

inline bool DevManagerSetConfigurationValueStart::hasConfigurationParam () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DevManagerSetConfigurationValueStart::getConfigurationParam () const {
    return _ConfigurationParam;
}

inline ::std::string& DevManagerSetConfigurationValueStart::getConfigurationParamMutable () {
    set_has_ConfigurationParam();
    return _ConfigurationParam;
}

inline void DevManagerSetConfigurationValueStart::setConfigurationParam (const ::std::string& ConfigurationParam_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ConfigurationParam_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ConfigurationParam();
    this->_ConfigurationParam = ConfigurationParam_;
}

inline void DevManagerSetConfigurationValueStart::setConfigurationParam (const char* ConfigurationParam_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ConfigurationParam_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ConfigurationParam();
    this->_ConfigurationParam.assign(ConfigurationParam_);
}

inline void DevManagerSetConfigurationValueStart::setConfigurationParam (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ConfigurationParam();
    this->_ConfigurationParam.assign(value, size);
}

inline void DevManagerSetConfigurationValueStart::clearValue() {
    if (hasValue()) {
         clear_has_Value();
        _Value = 0u;
     }
}

inline bool DevManagerSetConfigurationValueStart::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 DevManagerSetConfigurationValueStart::getValue () const {
    return _Value;
}

inline void DevManagerSetConfigurationValueStart::setValue (uint16 Value_) {
    set_has_Value();
    this->_Value = Value_;
}

inline void DevManagerSetConfigurationValueStart::clearSettingsMode() {
    if (hasSettingsMode()) {
         clear_has_SettingsMode();
        _SettingsMode = ::mplay_devicemanager_fi_types::T_e8_SettingsMode__Default;
     }
}

inline bool DevManagerSetConfigurationValueStart::hasSettingsMode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::mplay_devicemanager_fi_types::T_e8_SettingsMode DevManagerSetConfigurationValueStart::getSettingsMode () const {
    return _SettingsMode;
}

inline void DevManagerSetConfigurationValueStart::setSettingsMode (::mplay_devicemanager_fi_types::T_e8_SettingsMode SettingsMode_) {
    #ifndef NDEBUG
    if (!(::mplay_devicemanager_fi_types::T_e8_SettingsMode_IsValid(SettingsMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SettingsMode_, "T_e8_SettingsMode", "SettingsMode", "DevManagerSetConfigurationValueStart");
    }
    #endif
    set_has_SettingsMode();
    this->_SettingsMode = SettingsMode_;
}

inline void DevManagerSetConfigurationValueStart::set_has_ConfigurationParam () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerSetConfigurationValueStart::clear_has_ConfigurationParam () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevManagerSetConfigurationValueStart::set_has_Value () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevManagerSetConfigurationValueStart::clear_has_Value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DevManagerSetConfigurationValueStart::set_has_SettingsMode () {
    _has_bits_[0] |= 1u << 2;
}

inline void DevManagerSetConfigurationValueStart::clear_has_SettingsMode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DevManagerSetConfigurationValueResult::DevManagerSetConfigurationValueResult ()  :
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerSetConfigurationValueResult::DevManagerSetConfigurationValueResult (const DevManagerSetConfigurationValueResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerSetConfigurationValueResult::DevManagerSetConfigurationValueResult (bool Success_)  :
    _Success (Success_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerSetConfigurationValueResult::~DevManagerSetConfigurationValueResult() {
}

inline DevManagerSetConfigurationValueResult& DevManagerSetConfigurationValueResult::operator = (const DevManagerSetConfigurationValueResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
    }
    return *this;
}

inline bool DevManagerSetConfigurationValueResult::operator == (const DevManagerSetConfigurationValueResult& rhs) const {
    return (((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()));
}

inline bool DevManagerSetConfigurationValueResult::operator != (const DevManagerSetConfigurationValueResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerSetConfigurationValueResult::operator < (const DevManagerSetConfigurationValueResult& rhs) const {
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerSetConfigurationValueResult::clone() {
    return new DevManagerSetConfigurationValueResult(*this);
}

inline bool DevManagerSetConfigurationValueResult::operator > (const DevManagerSetConfigurationValueResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerSetConfigurationValueResult::clear() {
    clearSuccess();
}

inline void DevManagerSetConfigurationValueResult::clearSuccess() {
    if (hasSuccess()) {
         clear_has_Success();
        _Success = false;
     }
}

inline bool DevManagerSetConfigurationValueResult::hasSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerSetConfigurationValueResult::getSuccess () const {
    return _Success;
}

inline void DevManagerSetConfigurationValueResult::setSuccess (bool Success_) {
    set_has_Success();
    this->_Success = Success_;
}

inline void DevManagerSetConfigurationValueResult::set_has_Success () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerSetConfigurationValueResult::clear_has_Success () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerGetConfigurationValueStart::DevManagerGetConfigurationValueStart ()  :
    _ConfigurationParam ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerGetConfigurationValueStart::DevManagerGetConfigurationValueStart (const DevManagerGetConfigurationValueStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigurationParam ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerGetConfigurationValueStart::DevManagerGetConfigurationValueStart (const ::std::string& ConfigurationParam_)  :
    _ConfigurationParam (ConfigurationParam_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ConfigurationParam_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerGetConfigurationValueStart::~DevManagerGetConfigurationValueStart() {
}

inline DevManagerGetConfigurationValueStart& DevManagerGetConfigurationValueStart::operator = (const DevManagerGetConfigurationValueStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigurationParam()) {
            setConfigurationParam(rhs.getConfigurationParam());
        } else {
            clearConfigurationParam();
        }
    }
    return *this;
}

inline bool DevManagerGetConfigurationValueStart::operator == (const DevManagerGetConfigurationValueStart& rhs) const {
    return (((!hasConfigurationParam() && !rhs.hasConfigurationParam()) || getConfigurationParam() == rhs.getConfigurationParam()));
}

inline bool DevManagerGetConfigurationValueStart::operator != (const DevManagerGetConfigurationValueStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerGetConfigurationValueStart::operator < (const DevManagerGetConfigurationValueStart& rhs) const {
    if (hasConfigurationParam() || rhs.hasConfigurationParam()) {
        if (getConfigurationParam() < rhs.getConfigurationParam()) return true;
        if (getConfigurationParam() > rhs.getConfigurationParam()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerGetConfigurationValueStart::clone() {
    return new DevManagerGetConfigurationValueStart(*this);
}

inline bool DevManagerGetConfigurationValueStart::operator > (const DevManagerGetConfigurationValueStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerGetConfigurationValueStart::clear() {
    clearConfigurationParam();
}

inline void DevManagerGetConfigurationValueStart::clearConfigurationParam() {
    if (hasConfigurationParam()) {
         clear_has_ConfigurationParam();
        _ConfigurationParam.clear();
     }
}

inline bool DevManagerGetConfigurationValueStart::hasConfigurationParam () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DevManagerGetConfigurationValueStart::getConfigurationParam () const {
    return _ConfigurationParam;
}

inline ::std::string& DevManagerGetConfigurationValueStart::getConfigurationParamMutable () {
    set_has_ConfigurationParam();
    return _ConfigurationParam;
}

inline void DevManagerGetConfigurationValueStart::setConfigurationParam (const ::std::string& ConfigurationParam_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ConfigurationParam_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ConfigurationParam();
    this->_ConfigurationParam = ConfigurationParam_;
}

inline void DevManagerGetConfigurationValueStart::setConfigurationParam (const char* ConfigurationParam_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ConfigurationParam_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ConfigurationParam();
    this->_ConfigurationParam.assign(ConfigurationParam_);
}

inline void DevManagerGetConfigurationValueStart::setConfigurationParam (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ConfigurationParam();
    this->_ConfigurationParam.assign(value, size);
}

inline void DevManagerGetConfigurationValueStart::set_has_ConfigurationParam () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerGetConfigurationValueStart::clear_has_ConfigurationParam () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerGetConfigurationValueResult::DevManagerGetConfigurationValueResult ()  :
    _Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerGetConfigurationValueResult::DevManagerGetConfigurationValueResult (const DevManagerGetConfigurationValueResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerGetConfigurationValueResult::DevManagerGetConfigurationValueResult (uint16 Value_)  :
    _Value (Value_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerGetConfigurationValueResult::~DevManagerGetConfigurationValueResult() {
}

inline DevManagerGetConfigurationValueResult& DevManagerGetConfigurationValueResult::operator = (const DevManagerGetConfigurationValueResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool DevManagerGetConfigurationValueResult::operator == (const DevManagerGetConfigurationValueResult& rhs) const {
    return (((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool DevManagerGetConfigurationValueResult::operator != (const DevManagerGetConfigurationValueResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerGetConfigurationValueResult::operator < (const DevManagerGetConfigurationValueResult& rhs) const {
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerGetConfigurationValueResult::clone() {
    return new DevManagerGetConfigurationValueResult(*this);
}

inline bool DevManagerGetConfigurationValueResult::operator > (const DevManagerGetConfigurationValueResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerGetConfigurationValueResult::clear() {
    clearValue();
}

inline void DevManagerGetConfigurationValueResult::clearValue() {
    if (hasValue()) {
         clear_has_Value();
        _Value = 0u;
     }
}

inline bool DevManagerGetConfigurationValueResult::hasValue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 DevManagerGetConfigurationValueResult::getValue () const {
    return _Value;
}

inline void DevManagerGetConfigurationValueResult::setValue (uint16 Value_) {
    set_has_Value();
    this->_Value = Value_;
}

inline void DevManagerGetConfigurationValueResult::set_has_Value () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerGetConfigurationValueResult::clear_has_Value () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerAddExternalHubStart::DevManagerAddExternalHubStart ()  :
    _VendorID (0u),
    _ProductID (0u),
    _USBPortNo (0u),
    _Add (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerAddExternalHubStart::DevManagerAddExternalHubStart (const DevManagerAddExternalHubStart &rhs)  :
    ::asf::core::Payload(rhs),
    _VendorID (0u),
    _ProductID (0u),
    _USBPortNo (0u),
    _Add (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerAddExternalHubStart::DevManagerAddExternalHubStart (uint32 VendorID_, uint32 ProductID_, uint32 USBPortNo_, bool Add_)  :
    _VendorID (VendorID_),
    _ProductID (ProductID_),
    _USBPortNo (USBPortNo_),
    _Add (Add_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerAddExternalHubStart::~DevManagerAddExternalHubStart() {
}

inline DevManagerAddExternalHubStart& DevManagerAddExternalHubStart::operator = (const DevManagerAddExternalHubStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVendorID()) {
            setVendorID(rhs.getVendorID());
        } else {
            clearVendorID();
        }
        if (rhs.hasProductID()) {
            setProductID(rhs.getProductID());
        } else {
            clearProductID();
        }
        if (rhs.hasUSBPortNo()) {
            setUSBPortNo(rhs.getUSBPortNo());
        } else {
            clearUSBPortNo();
        }
        if (rhs.hasAdd()) {
            setAdd(rhs.getAdd());
        } else {
            clearAdd();
        }
    }
    return *this;
}

inline bool DevManagerAddExternalHubStart::operator == (const DevManagerAddExternalHubStart& rhs) const {
    return (((!hasVendorID() && !rhs.hasVendorID()) || getVendorID() == rhs.getVendorID()) &&
        ((!hasProductID() && !rhs.hasProductID()) || getProductID() == rhs.getProductID()) &&
        ((!hasUSBPortNo() && !rhs.hasUSBPortNo()) || getUSBPortNo() == rhs.getUSBPortNo()) &&
        ((!hasAdd() && !rhs.hasAdd()) || getAdd() == rhs.getAdd()));
}

inline bool DevManagerAddExternalHubStart::operator != (const DevManagerAddExternalHubStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerAddExternalHubStart::operator < (const DevManagerAddExternalHubStart& rhs) const {
    if (hasVendorID() || rhs.hasVendorID()) {
        if (getVendorID() < rhs.getVendorID()) return true;
        if (getVendorID() > rhs.getVendorID()) return false;
    }
    if (hasProductID() || rhs.hasProductID()) {
        if (getProductID() < rhs.getProductID()) return true;
        if (getProductID() > rhs.getProductID()) return false;
    }
    if (hasUSBPortNo() || rhs.hasUSBPortNo()) {
        if (getUSBPortNo() < rhs.getUSBPortNo()) return true;
        if (getUSBPortNo() > rhs.getUSBPortNo()) return false;
    }
    if (hasAdd() || rhs.hasAdd()) {
        if (getAdd() < rhs.getAdd()) return true;
        if (getAdd() > rhs.getAdd()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerAddExternalHubStart::clone() {
    return new DevManagerAddExternalHubStart(*this);
}

inline bool DevManagerAddExternalHubStart::operator > (const DevManagerAddExternalHubStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerAddExternalHubStart::clear() {
    clearVendorID();
    clearProductID();
    clearUSBPortNo();
    clearAdd();
}

inline void DevManagerAddExternalHubStart::clearVendorID() {
    if (hasVendorID()) {
         clear_has_VendorID();
        _VendorID = 0u;
     }
}

inline bool DevManagerAddExternalHubStart::hasVendorID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DevManagerAddExternalHubStart::getVendorID () const {
    return _VendorID;
}

inline void DevManagerAddExternalHubStart::setVendorID (uint32 VendorID_) {
    set_has_VendorID();
    this->_VendorID = VendorID_;
}

inline void DevManagerAddExternalHubStart::clearProductID() {
    if (hasProductID()) {
         clear_has_ProductID();
        _ProductID = 0u;
     }
}

inline bool DevManagerAddExternalHubStart::hasProductID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DevManagerAddExternalHubStart::getProductID () const {
    return _ProductID;
}

inline void DevManagerAddExternalHubStart::setProductID (uint32 ProductID_) {
    set_has_ProductID();
    this->_ProductID = ProductID_;
}

inline void DevManagerAddExternalHubStart::clearUSBPortNo() {
    if (hasUSBPortNo()) {
         clear_has_USBPortNo();
        _USBPortNo = 0u;
     }
}

inline bool DevManagerAddExternalHubStart::hasUSBPortNo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 DevManagerAddExternalHubStart::getUSBPortNo () const {
    return _USBPortNo;
}

inline void DevManagerAddExternalHubStart::setUSBPortNo (uint32 USBPortNo_) {
    set_has_USBPortNo();
    this->_USBPortNo = USBPortNo_;
}

inline void DevManagerAddExternalHubStart::clearAdd() {
    if (hasAdd()) {
         clear_has_Add();
        _Add = false;
     }
}

inline bool DevManagerAddExternalHubStart::hasAdd () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool DevManagerAddExternalHubStart::getAdd () const {
    return _Add;
}

inline void DevManagerAddExternalHubStart::setAdd (bool Add_) {
    set_has_Add();
    this->_Add = Add_;
}

inline void DevManagerAddExternalHubStart::set_has_VendorID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerAddExternalHubStart::clear_has_VendorID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevManagerAddExternalHubStart::set_has_ProductID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevManagerAddExternalHubStart::clear_has_ProductID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DevManagerAddExternalHubStart::set_has_USBPortNo () {
    _has_bits_[0] |= 1u << 2;
}

inline void DevManagerAddExternalHubStart::clear_has_USBPortNo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DevManagerAddExternalHubStart::set_has_Add () {
    _has_bits_[0] |= 1u << 3;
}

inline void DevManagerAddExternalHubStart::clear_has_Add () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DevManagerAddExternalHubResult::DevManagerAddExternalHubResult ()  :
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerAddExternalHubResult::DevManagerAddExternalHubResult (const DevManagerAddExternalHubResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerAddExternalHubResult::DevManagerAddExternalHubResult (bool Success_)  :
    _Success (Success_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerAddExternalHubResult::~DevManagerAddExternalHubResult() {
}

inline DevManagerAddExternalHubResult& DevManagerAddExternalHubResult::operator = (const DevManagerAddExternalHubResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
    }
    return *this;
}

inline bool DevManagerAddExternalHubResult::operator == (const DevManagerAddExternalHubResult& rhs) const {
    return (((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()));
}

inline bool DevManagerAddExternalHubResult::operator != (const DevManagerAddExternalHubResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerAddExternalHubResult::operator < (const DevManagerAddExternalHubResult& rhs) const {
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerAddExternalHubResult::clone() {
    return new DevManagerAddExternalHubResult(*this);
}

inline bool DevManagerAddExternalHubResult::operator > (const DevManagerAddExternalHubResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerAddExternalHubResult::clear() {
    clearSuccess();
}

inline void DevManagerAddExternalHubResult::clearSuccess() {
    if (hasSuccess()) {
         clear_has_Success();
        _Success = false;
     }
}

inline bool DevManagerAddExternalHubResult::hasSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DevManagerAddExternalHubResult::getSuccess () const {
    return _Success;
}

inline void DevManagerAddExternalHubResult::setSuccess (bool Success_) {
    set_has_Success();
    this->_Success = Success_;
}

inline void DevManagerAddExternalHubResult::set_has_Success () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerAddExternalHubResult::clear_has_Success () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerGetDevPropertiesStart::DevManagerGetDevPropertiesStart ()  :
    _DeviceSerialNo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerGetDevPropertiesStart::DevManagerGetDevPropertiesStart (const DevManagerGetDevPropertiesStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceSerialNo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerGetDevPropertiesStart::DevManagerGetDevPropertiesStart (const ::std::string& DeviceSerialNo_)  :
    _DeviceSerialNo (DeviceSerialNo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceSerialNo_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerGetDevPropertiesStart::~DevManagerGetDevPropertiesStart() {
}

inline DevManagerGetDevPropertiesStart& DevManagerGetDevPropertiesStart::operator = (const DevManagerGetDevPropertiesStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceSerialNo()) {
            setDeviceSerialNo(rhs.getDeviceSerialNo());
        } else {
            clearDeviceSerialNo();
        }
    }
    return *this;
}

inline bool DevManagerGetDevPropertiesStart::operator == (const DevManagerGetDevPropertiesStart& rhs) const {
    return (((!hasDeviceSerialNo() && !rhs.hasDeviceSerialNo()) || getDeviceSerialNo() == rhs.getDeviceSerialNo()));
}

inline bool DevManagerGetDevPropertiesStart::operator != (const DevManagerGetDevPropertiesStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerGetDevPropertiesStart::operator < (const DevManagerGetDevPropertiesStart& rhs) const {
    if (hasDeviceSerialNo() || rhs.hasDeviceSerialNo()) {
        if (getDeviceSerialNo() < rhs.getDeviceSerialNo()) return true;
        if (getDeviceSerialNo() > rhs.getDeviceSerialNo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerGetDevPropertiesStart::clone() {
    return new DevManagerGetDevPropertiesStart(*this);
}

inline bool DevManagerGetDevPropertiesStart::operator > (const DevManagerGetDevPropertiesStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerGetDevPropertiesStart::clear() {
    clearDeviceSerialNo();
}

inline void DevManagerGetDevPropertiesStart::clearDeviceSerialNo() {
    if (hasDeviceSerialNo()) {
         clear_has_DeviceSerialNo();
        _DeviceSerialNo.clear();
     }
}

inline bool DevManagerGetDevPropertiesStart::hasDeviceSerialNo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DevManagerGetDevPropertiesStart::getDeviceSerialNo () const {
    return _DeviceSerialNo;
}

inline ::std::string& DevManagerGetDevPropertiesStart::getDeviceSerialNoMutable () {
    set_has_DeviceSerialNo();
    return _DeviceSerialNo;
}

inline void DevManagerGetDevPropertiesStart::setDeviceSerialNo (const ::std::string& DeviceSerialNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceSerialNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceSerialNo();
    this->_DeviceSerialNo = DeviceSerialNo_;
}

inline void DevManagerGetDevPropertiesStart::setDeviceSerialNo (const char* DeviceSerialNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceSerialNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceSerialNo();
    this->_DeviceSerialNo.assign(DeviceSerialNo_);
}

inline void DevManagerGetDevPropertiesStart::setDeviceSerialNo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceSerialNo();
    this->_DeviceSerialNo.assign(value, size);
}

inline void DevManagerGetDevPropertiesStart::set_has_DeviceSerialNo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerGetDevPropertiesStart::clear_has_DeviceSerialNo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerGetDevPropertiesResult::DevManagerGetDevPropertiesResult ()  :
    _DeviceProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerGetDevPropertiesResult::DevManagerGetDevPropertiesResult (const DevManagerGetDevPropertiesResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerGetDevPropertiesResult::DevManagerGetDevPropertiesResult (const ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty& DeviceProperty_)  :
    _DeviceProperty (DeviceProperty_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerGetDevPropertiesResult::~DevManagerGetDevPropertiesResult() {
}

inline DevManagerGetDevPropertiesResult& DevManagerGetDevPropertiesResult::operator = (const DevManagerGetDevPropertiesResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceProperty()) {
            setDeviceProperty(rhs.getDeviceProperty());
        } else {
            clearDeviceProperty();
        }
    }
    return *this;
}

inline bool DevManagerGetDevPropertiesResult::operator == (const DevManagerGetDevPropertiesResult& rhs) const {
    return (((!hasDeviceProperty() && !rhs.hasDeviceProperty()) || getDeviceProperty() == rhs.getDeviceProperty()));
}

inline bool DevManagerGetDevPropertiesResult::operator != (const DevManagerGetDevPropertiesResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerGetDevPropertiesResult::operator < (const DevManagerGetDevPropertiesResult& rhs) const {
    if (hasDeviceProperty() || rhs.hasDeviceProperty()) {
        if (getDeviceProperty() < rhs.getDeviceProperty()) return true;
        if (getDeviceProperty() > rhs.getDeviceProperty()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerGetDevPropertiesResult::clone() {
    return new DevManagerGetDevPropertiesResult(*this);
}

inline bool DevManagerGetDevPropertiesResult::operator > (const DevManagerGetDevPropertiesResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerGetDevPropertiesResult::clear() {
    clearDeviceProperty();
}

inline void DevManagerGetDevPropertiesResult::clearDeviceProperty() {
    if (hasDeviceProperty()) {
         clear_has_DeviceProperty();
        _DeviceProperty.clear();
     }
}

inline bool DevManagerGetDevPropertiesResult::hasDeviceProperty () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty& DevManagerGetDevPropertiesResult::getDeviceProperty () const {
    return _DeviceProperty;
}

inline ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty& DevManagerGetDevPropertiesResult::getDevicePropertyMutable () {
    set_has_DeviceProperty();
    return _DeviceProperty;
}

inline void DevManagerGetDevPropertiesResult::setDeviceProperty (const ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty& DeviceProperty_) {
    set_has_DeviceProperty();
    this->_DeviceProperty = DeviceProperty_;
}

inline void DevManagerGetDevPropertiesResult::set_has_DeviceProperty () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerGetDevPropertiesResult::clear_has_DeviceProperty () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DevManagerGetAllConnectedDevicesResult::DevManagerGetAllConnectedDevicesResult ()  :
    _DevInfoArr ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevManagerGetAllConnectedDevicesResult::DevManagerGetAllConnectedDevicesResult (const DevManagerGetAllConnectedDevicesResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DevInfoArr ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevManagerGetAllConnectedDevicesResult::DevManagerGetAllConnectedDevicesResult (const ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr& DevInfoArr_)  :
    _DevInfoArr (DevInfoArr_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevManagerGetAllConnectedDevicesResult::~DevManagerGetAllConnectedDevicesResult() {
}

inline DevManagerGetAllConnectedDevicesResult& DevManagerGetAllConnectedDevicesResult::operator = (const DevManagerGetAllConnectedDevicesResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevInfoArr()) {
            setDevInfoArr(rhs.getDevInfoArr());
        } else {
            clearDevInfoArr();
        }
    }
    return *this;
}

inline bool DevManagerGetAllConnectedDevicesResult::operator == (const DevManagerGetAllConnectedDevicesResult& rhs) const {
    return (((!hasDevInfoArr() && !rhs.hasDevInfoArr()) || getDevInfoArr() == rhs.getDevInfoArr()));
}

inline bool DevManagerGetAllConnectedDevicesResult::operator != (const DevManagerGetAllConnectedDevicesResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DevManagerGetAllConnectedDevicesResult::operator < (const DevManagerGetAllConnectedDevicesResult& rhs) const {
    if (hasDevInfoArr() || rhs.hasDevInfoArr()) {
        if (getDevInfoArr() < rhs.getDevInfoArr()) return true;
        if (getDevInfoArr() > rhs.getDevInfoArr()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevManagerGetAllConnectedDevicesResult::clone() {
    return new DevManagerGetAllConnectedDevicesResult(*this);
}

inline bool DevManagerGetAllConnectedDevicesResult::operator > (const DevManagerGetAllConnectedDevicesResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevManagerGetAllConnectedDevicesResult::clear() {
    clearDevInfoArr();
}

inline void DevManagerGetAllConnectedDevicesResult::clearDevInfoArr() {
    if (hasDevInfoArr()) {
         clear_has_DevInfoArr();
        _DevInfoArr.clear();
     }
}

inline bool DevManagerGetAllConnectedDevicesResult::hasDevInfoArr () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr& DevManagerGetAllConnectedDevicesResult::getDevInfoArr () const {
    return _DevInfoArr;
}

inline ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr& DevManagerGetAllConnectedDevicesResult::getDevInfoArrMutable () {
    set_has_DevInfoArr();
    return _DevInfoArr;
}

inline void DevManagerGetAllConnectedDevicesResult::setDevInfoArr (const ::mplay_devicemanager_fi_types::T_DevManager_DevInfoStr& DevInfoArr_) {
    set_has_DevInfoArr();
    this->_DevInfoArr = DevInfoArr_;
}

inline void DevManagerGetAllConnectedDevicesResult::set_has_DevInfoArr () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevManagerGetAllConnectedDevicesResult::clear_has_DevInfoArr () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace mplay_devicemanager_fi

#endif // MPLAY_DEVICEMANAGER_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
