/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "mplay_appcontrol_fi_types.h"
#include "mplay_appcontrol_fi_typesConst.h"
#include "mplay_appcontrol_fi_typesJson.h"
#include "mplay_appcontrol_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_DiPODeviceInfoItem"

void serializeJson (const ::mplay_appcontrol_fi_types::T_DiPODeviceInfoItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasSDeviceName()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceName" , 11);
        const char *s = value.getSDeviceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8DeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceType" , 12);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPODeviceType_Name(value.getE8DeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceType());
    }
    if (!isSparse || value.hasSDeviceSerialNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceSerialNumber" , 19);
        const char *s = value.getSDeviceSerialNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBDeviceConnected()) {
        yajl_gen_string(g, (const unsigned char*)  "bDeviceConnected" , 16);
        yajl_gen_bool(g, (bool)value.getBDeviceConnected());
    }
    if (!isSparse || value.hasBDeviceActiveSource()) {
        yajl_gen_string(g, (const unsigned char*)  "bDeviceActiveSource" , 19);
        yajl_gen_bool(g, (bool)value.getBDeviceActiveSource());
    }
    if (!isSparse || value.hasBDiPOCapable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDiPOCapable" , 12);
        yajl_gen_bool(g, (bool)value.getBDiPOCapable());
    }
    if (!isSparse || value.hasBDiPOActive()) {
        yajl_gen_string(g, (const unsigned char*)  "bDiPOActive" , 11);
        yajl_gen_bool(g, (bool)value.getBDiPOActive());
    }
    if (!isSparse || value.hasSDiPOVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "sDiPOVersion" , 12);
        const char *s = value.getSDiPOVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8ConnectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConnectionType" , 16);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPOConnectionType_Name(value.getE8ConnectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConnectionType());
    }
    if (!isSparse || value.hasE8ConnectionState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConnectionState" , 17);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPOConnectionState_Name(value.getE8ConnectionState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConnectionState());
    }
    if (!isSparse || value.hasSMountPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "sMountPoint" , 11);
        const char *s = value.getSMountPoint().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSAccessoryName()) {
        yajl_gen_string(g, (const unsigned char*)  "sAccessoryName" , 14);
        const char *s = value.getSAccessoryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8DiPOCaps()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DiPOCaps" , 10);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPOCaps_Name(value.getE8DiPOCaps());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DiPOCaps());
    }
    if (!isSparse || value.hasE8DeviceState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceState" , 13);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPODeviceStatus_Name(value.getE8DeviceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceState());
    }
    if (!isSparse || value.hasSDeviceUUID()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceUUID" , 11);
        const char *s = value.getSDeviceUUID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDeviceBTMacAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceBTMacAddress" , 19);
        const char *s = value.getSDeviceBTMacAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDeviceUSBSerialNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceUSBSerialNumber" , 22);
        const char *s = value.getSDeviceUSBSerialNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_DiPODeviceInfoItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_DiPOLocationInfoType"

void serializeJson (const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getGPGGA()) {
        yajl_gen_string(g, (const unsigned char*)  "GPGGA" , 5);
        yajl_gen_bool(g, (bool)value.getGPGGA());
    }
    if (value.getGPRMC()) {
        yajl_gen_string(g, (const unsigned char*)  "GPRMC" , 5);
        yajl_gen_bool(g, (bool)value.getGPRMC());
    }
    if (value.getGPGSV()) {
        yajl_gen_string(g, (const unsigned char*)  "GPGSV" , 5);
        yajl_gen_bool(g, (bool)value.getGPGSV());
    }
    if (value.getGPHDT()) {
        yajl_gen_string(g, (const unsigned char*)  "GPHDT" , 5);
        yajl_gen_bool(g, (bool)value.getGPHDT());
    }
    if (value.getPASCD()) {
        yajl_gen_string(g, (const unsigned char*)  "PASCD" , 5);
        yajl_gen_bool(g, (bool)value.getPASCD());
    }
    if (value.getPAGCD()) {
        yajl_gen_string(g, (const unsigned char*)  "PAGCD" , 5);
        yajl_gen_bool(g, (bool)value.getPAGCD());
    }
    if (value.getPAACD()) {
        yajl_gen_string(g, (const unsigned char*)  "PAACD" , 5);
        yajl_gen_bool(g, (bool)value.getPAACD());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_DiPOGPRMCDataStatusValues"

void serializeJson (const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getGPRMCDataStatusValueA()) {
        yajl_gen_string(g, (const unsigned char*)  "GPRMCDataStatusValueA" , 21);
        yajl_gen_bool(g, (bool)value.getGPRMCDataStatusValueA());
    }
    if (value.getGPRMCDataStatusValueV()) {
        yajl_gen_string(g, (const unsigned char*)  "GPRMCDataStatusValueV" , 21);
        yajl_gen_bool(g, (bool)value.getGPRMCDataStatusValueV());
    }
    if (value.getGPRMCDataStatusValueX()) {
        yajl_gen_string(g, (const unsigned char*)  "GPRMCDataStatusValueX" , 21);
        yajl_gen_bool(g, (bool)value.getGPRMCDataStatusValueX());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_BTProfileItem"

void serializeJson (const ::mplay_appcontrol_fi_types::T_BTProfileItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceId" , 10);
        yajl_gen_integer(g, (long long)value.getU8DeviceId());
    }
    if (!isSparse || value.hasB32BTProfile()) {
        yajl_gen_string(g, (const unsigned char*)  "b32BTProfile" , 12);
        serializeJson(value.getB32BTProfile(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_BTProfileItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_BTProfileType"

void serializeJson (const ::mplay_appcontrol_fi_types::T_b32_BTProfileType& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getHandsFree()) {
        yajl_gen_string(g, (const unsigned char*)  "HandsFree" , 9);
        yajl_gen_bool(g, (bool)value.getHandsFree());
    }
    if (value.getPhoneBookAccess()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneBookAccess" , 15);
        yajl_gen_bool(g, (bool)value.getPhoneBookAccess());
    }
    if (value.getAudioVideoRemoteControl()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioVideoRemoteControl" , 23);
        yajl_gen_bool(g, (bool)value.getAudioVideoRemoteControl());
    }
    if (value.getAdvancedAudioDistribution()) {
        yajl_gen_string(g, (const unsigned char*)  "AdvancedAudioDistribution" , 25);
        yajl_gen_bool(g, (bool)value.getAdvancedAudioDistribution());
    }
    if (value.getHumanInterfaceDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "HumanInterfaceDevice" , 20);
        yajl_gen_bool(g, (bool)value.getHumanInterfaceDevice());
    }
    if (value.getIAP2Link()) {
        yajl_gen_string(g, (const unsigned char*)  "iAP2Link" , 8);
        yajl_gen_bool(g, (bool)value.getIAP2Link());
    }
    if (value.getPersonalAreaNetworkAccessPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "PersonalAreaNetworkAccessPoint" , 30);
        yajl_gen_bool(g, (bool)value.getPersonalAreaNetworkAccessPoint());
    }
    if (value.getMessageAccess()) {
        yajl_gen_string(g, (const unsigned char*)  "MessageAccess" , 13);
        yajl_gen_bool(g, (bool)value.getMessageAccess());
    }
    if (value.getPersonalAreaNetworkClient()) {
        yajl_gen_string(g, (const unsigned char*)  "PersonalAreaNetworkClient" , 25);
        yajl_gen_bool(g, (bool)value.getPersonalAreaNetworkClient());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_b32_BTProfileType& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DiPOCallStateItem"

void serializeJson (const ::mplay_appcontrol_fi_types::T_DiPOCallStateItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSRemoteID()) {
        yajl_gen_string(g, (const unsigned char*)  "sRemoteID" , 9);
        const char *s = value.getSRemoteID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDisplayName()) {
        yajl_gen_string(g, (const unsigned char*)  "sDisplayName" , 12);
        const char *s = value.getSDisplayName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "eStatus" , 7);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateStatus_Name(value.getEStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEStatus());
    }
    if (!isSparse || value.hasEDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "eDirection" , 10);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDirection_Name(value.getEDirection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEDirection());
    }
    if (!isSparse || value.hasSCallUUID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCallUUID" , 9);
        const char *s = value.getSCallUUID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSAddressBookID()) {
        yajl_gen_string(g, (const unsigned char*)  "sAddressBookID" , 14);
        const char *s = value.getSAddressBookID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sLabel" , 6);
        const char *s = value.getSLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEService()) {
        yajl_gen_string(g, (const unsigned char*)  "eService" , 8);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateService_Name(value.getEService());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEService());
    }
    if (!isSparse || value.hasBIsConferenced()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsConferenced" , 14);
        yajl_gen_bool(g, (bool)value.getBIsConferenced());
    }
    if (!isSparse || value.hasU8ConferenceGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ConferenceGroup" , 17);
        yajl_gen_integer(g, (long long)value.getU8ConferenceGroup());
    }
    if (!isSparse || value.hasEDisconnectReason()) {
        yajl_gen_string(g, (const unsigned char*)  "eDisconnectReason" , 17);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDisconnectReason_Name(value.getEDisconnectReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEDisconnectReason());
    }
    if (!isSparse || value.hasU64StartTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "u64StartTimestamp" , 17);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getU64StartTimestamp(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_DiPOCallStateItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_RouteGuidanceDisplayComponentItem"

void serializeJson (const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIdentifier()) {
        yajl_gen_string(g, (const unsigned char*)  "Identifier" , 10);
        yajl_gen_integer(g, (long long)value.getIdentifier());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "Name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMaxCurrentRoadNameLength()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxCurrentRoadNameLength" , 24);
        yajl_gen_integer(g, (long long)value.getMaxCurrentRoadNameLength());
    }
    if (!isSparse || value.hasMaxDestinationNameLength()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxDestinationNameLength" , 24);
        yajl_gen_integer(g, (long long)value.getMaxDestinationNameLength());
    }
    if (!isSparse || value.hasMaxAfterManeuverRoadNameLength()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxAfterManeuverRoadNameLength" , 30);
        yajl_gen_integer(g, (long long)value.getMaxAfterManeuverRoadNameLength());
    }
    if (!isSparse || value.hasMaxManeuverDescriptionLength()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxManeuverDescriptionLength" , 28);
        yajl_gen_integer(g, (long long)value.getMaxManeuverDescriptionLength());
    }
    if (!isSparse || value.hasMaxGuidanceManeuverCapacity()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxGuidanceManeuverCapacity" , 27);
        yajl_gen_integer(g, (long long)value.getMaxGuidanceManeuverCapacity());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_RouteGuidanceUpdate"

void serializeJson (const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBRouteGuidanceDisplayComponentIDsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bRouteGuidanceDisplayComponentIDsAvailable" , 42);
        yajl_gen_bool(g, (bool)value.getBRouteGuidanceDisplayComponentIDsAvailable());
    }
    if (!isSparse || value.hasRouteGuidanceDisplayComponentIDs()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteGuidanceDisplayComponentIDs" , 32);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o1 = value.getRouteGuidanceDisplayComponentIDs();
        {
            ::std::vector< uint16 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBRouteGuidanceStateAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bRouteGuidanceStateAvailable" , 28);
        yajl_gen_bool(g, (bool)value.getBRouteGuidanceStateAvailable());
    }
    if (!isSparse || value.hasE8RouteGuidanceState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RouteGuidanceState" , 20);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState_Name(value.getE8RouteGuidanceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8RouteGuidanceState());
    }
    if (!isSparse || value.hasBManeuverStateAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bManeuverStateAvailable" , 23);
        yajl_gen_bool(g, (bool)value.getBManeuverStateAvailable());
    }
    if (!isSparse || value.hasE8ManeuverState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ManeuverState" , 15);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_ManeuverState_Name(value.getE8ManeuverState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ManeuverState());
    }
    if (!isSparse || value.hasBCurrentRoadNameAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bCurrentRoadNameAvailable" , 25);
        yajl_gen_bool(g, (bool)value.getBCurrentRoadNameAvailable());
    }
    if (!isSparse || value.hasCurrentRoadName()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentRoadName" , 15);
        const char *s = value.getCurrentRoadName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBDestinationNameAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDestinationNameAvailable" , 25);
        yajl_gen_bool(g, (bool)value.getBDestinationNameAvailable());
    }
    if (!isSparse || value.hasDestinationName()) {
        yajl_gen_string(g, (const unsigned char*)  "DestinationName" , 15);
        const char *s = value.getDestinationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBEstimatedTimeOfArrivalAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bEstimatedTimeOfArrivalAvailable" , 32);
        yajl_gen_bool(g, (bool)value.getBEstimatedTimeOfArrivalAvailable());
    }
    if (!isSparse || value.hasEstimatedTimeOfArrival()) {
        yajl_gen_string(g, (const unsigned char*)  "EstimatedTimeOfArrival" , 22);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getEstimatedTimeOfArrival(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasBTimeRemainingToDestinationAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bTimeRemainingToDestinationAvailable" , 36);
        yajl_gen_bool(g, (bool)value.getBTimeRemainingToDestinationAvailable());
    }
    if (!isSparse || value.hasTimeRemainingToDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeRemainingToDestination" , 26);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTimeRemainingToDestination(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasBDistanceRemainingAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceRemainingAvailable" , 27);
        yajl_gen_bool(g, (bool)value.getBDistanceRemainingAvailable());
    }
    if (!isSparse || value.hasDistanceRemaining()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceRemaining" , 17);
        yajl_gen_integer(g, (long long)value.getDistanceRemaining());
    }
    if (!isSparse || value.hasBDistanceRemainingDisplayStrAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceRemainingDisplayStrAvailable" , 37);
        yajl_gen_bool(g, (bool)value.getBDistanceRemainingDisplayStrAvailable());
    }
    if (!isSparse || value.hasDistanceRemainingDisplayStr()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceRemainingDisplayStr" , 27);
        const char *s = value.getDistanceRemainingDisplayStr().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBDistanceRemainingDisplayUnitsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceRemainingDisplayUnitsAvailable" , 39);
        yajl_gen_bool(g, (bool)value.getBDistanceRemainingDisplayUnitsAvailable());
    }
    if (!isSparse || value.hasE8DistanceRemainingDisplayUnits()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DistanceRemainingDisplayUnits" , 31);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_Name(value.getE8DistanceRemainingDisplayUnits());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DistanceRemainingDisplayUnits());
    }
    if (!isSparse || value.hasBDistanceToNextManeuverAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceToNextManeuverAvailable" , 32);
        yajl_gen_bool(g, (bool)value.getBDistanceToNextManeuverAvailable());
    }
    if (!isSparse || value.hasDistanceToNextManeuver()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceToNextManeuver" , 22);
        yajl_gen_integer(g, (long long)value.getDistanceToNextManeuver());
    }
    if (!isSparse || value.hasBDistanceToNextManeuverDisplayStrAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceToNextManeuverDisplayStrAvailable" , 42);
        yajl_gen_bool(g, (bool)value.getBDistanceToNextManeuverDisplayStrAvailable());
    }
    if (!isSparse || value.hasDistanceToNextManeuverDisplayStr()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceToNextManeuverDisplayStr" , 32);
        const char *s = value.getDistanceToNextManeuverDisplayStr().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBDistanceToNextManeuverDisplayUnitsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceToNextManeuverDisplayUnitsAvailable" , 44);
        yajl_gen_bool(g, (bool)value.getBDistanceToNextManeuverDisplayUnitsAvailable());
    }
    if (!isSparse || value.hasE8DistanceToNextManeuverDisplayUnits()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DistanceToNextManeuverDisplayUnits" , 36);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_Name(value.getE8DistanceToNextManeuverDisplayUnits());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DistanceToNextManeuverDisplayUnits());
    }
    if (!isSparse || value.hasBRouteGuidanceManeuverCurrentListAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bRouteGuidanceManeuverCurrentListAvailable" , 42);
        yajl_gen_bool(g, (bool)value.getBRouteGuidanceManeuverCurrentListAvailable());
    }
    if (!isSparse || value.hasRouteGuidanceManeuverCurrentList()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteGuidanceManeuverCurrentList" , 32);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o3 = value.getRouteGuidanceManeuverCurrentList();
        {
            ::std::vector< uint16 >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                yajl_gen_integer(g, (long long)(*o2));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBRouteGuidanceManeuverCountAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bRouteGuidanceManeuverCountAvailable" , 36);
        yajl_gen_bool(g, (bool)value.getBRouteGuidanceManeuverCountAvailable());
    }
    if (!isSparse || value.hasRouteGuidanceManeuverCount()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteGuidanceManeuverCount" , 26);
        yajl_gen_integer(g, (long long)value.getRouteGuidanceManeuverCount());
    }
    if (!isSparse || value.hasBRouteGuidanceVisibleInAppAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bRouteGuidanceVisibleInAppAvailable" , 35);
        yajl_gen_bool(g, (bool)value.getBRouteGuidanceVisibleInAppAvailable());
    }
    if (!isSparse || value.hasRouteGuidanceVisibleInApp()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteGuidanceVisibleInApp" , 25);
        yajl_gen_bool(g, (bool)value.getRouteGuidanceVisibleInApp());
    }
    if (!isSparse || value.hasBSourceNameAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bSourceNameAvailable" , 20);
        yajl_gen_bool(g, (bool)value.getBSourceNameAvailable());
    }
    if (!isSparse || value.hasSourceName()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceName" , 10);
        const char *s = value.getSourceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBSourceSupportsRouteGuidanceAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bSourceSupportsRouteGuidanceAvailable" , 37);
        yajl_gen_bool(g, (bool)value.getBSourceSupportsRouteGuidanceAvailable());
    }
    if (!isSparse || value.hasSourceSupportsRouteGuidance()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceSupportsRouteGuidance" , 27);
        yajl_gen_bool(g, (bool)value.getSourceSupportsRouteGuidance());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_RouteGuidanceManeuverUpdate"

void serializeJson (const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBRouteGuidanceDisplayComponentIDsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bRouteGuidanceDisplayComponentIDsAvailable" , 42);
        yajl_gen_bool(g, (bool)value.getBRouteGuidanceDisplayComponentIDsAvailable());
    }
    if (!isSparse || value.hasRouteGuidanceDisplayComponentIDs()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteGuidanceDisplayComponentIDs" , 32);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o5 = value.getRouteGuidanceDisplayComponentIDs();
        {
            ::std::vector< uint16 >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                yajl_gen_integer(g, (long long)(*o4));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBIndexAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bIndexAvailable" , 15);
        yajl_gen_bool(g, (bool)value.getBIndexAvailable());
    }
    if (!isSparse || value.hasIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "Index" , 5);
        yajl_gen_integer(g, (long long)value.getIndex());
    }
    if (!isSparse || value.hasBManeuverDescriptionAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bManeuverDescriptionAvailable" , 29);
        yajl_gen_bool(g, (bool)value.getBManeuverDescriptionAvailable());
    }
    if (!isSparse || value.hasManeuverDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "ManeuverDescription" , 19);
        const char *s = value.getManeuverDescription().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBManeuverTypeAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bManeuverTypeAvailable" , 22);
        yajl_gen_bool(g, (bool)value.getBManeuverTypeAvailable());
    }
    if (!isSparse || value.hasE8ManeuverType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ManeuverType" , 14);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_ManeuverType_Name(value.getE8ManeuverType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ManeuverType());
    }
    if (!isSparse || value.hasBAfterManeuverRoadNameAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bAfterManeuverRoadNameAvailable" , 31);
        yajl_gen_bool(g, (bool)value.getBAfterManeuverRoadNameAvailable());
    }
    if (!isSparse || value.hasAfterManeuverRoadName()) {
        yajl_gen_string(g, (const unsigned char*)  "AfterManeuverRoadName" , 21);
        const char *s = value.getAfterManeuverRoadName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBDistanceBetweenManeuverAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceBetweenManeuverAvailable" , 33);
        yajl_gen_bool(g, (bool)value.getBDistanceBetweenManeuverAvailable());
    }
    if (!isSparse || value.hasDistanceBetweenManeuver()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceBetweenManeuver" , 23);
        yajl_gen_integer(g, (long long)value.getDistanceBetweenManeuver());
    }
    if (!isSparse || value.hasBDistanceBetweenManeuverDisplayStrAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceBetweenManeuverDisplayStrAvailable" , 43);
        yajl_gen_bool(g, (bool)value.getBDistanceBetweenManeuverDisplayStrAvailable());
    }
    if (!isSparse || value.hasDistanceBetweenManeuverDisplayStr()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceBetweenManeuverDisplayStr" , 33);
        const char *s = value.getDistanceBetweenManeuverDisplayStr().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBDistanceBetweenManeuverDisplayUnitsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDistanceBetweenManeuverDisplayUnitsAvailable" , 45);
        yajl_gen_bool(g, (bool)value.getBDistanceBetweenManeuverDisplayUnitsAvailable());
    }
    if (!isSparse || value.hasE8DistanceBetweenManeuverDisplayUnits()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DistanceBetweenManeuverDisplayUnits" , 37);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_Name(value.getE8DistanceBetweenManeuverDisplayUnits());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DistanceBetweenManeuverDisplayUnits());
    }
    if (!isSparse || value.hasBDrivingSideAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bDrivingSideAvailable" , 21);
        yajl_gen_bool(g, (bool)value.getBDrivingSideAvailable());
    }
    if (!isSparse || value.hasE8DrivingSide()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DrivingSide" , 13);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_DrivingSide_Name(value.getE8DrivingSide());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DrivingSide());
    }
    if (!isSparse || value.hasBJunctionTypeAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bJunctionTypeAvailable" , 22);
        yajl_gen_bool(g, (bool)value.getBJunctionTypeAvailable());
    }
    if (!isSparse || value.hasE8JunctionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8JunctionType" , 14);
        const char* s = ::mplay_appcontrol_fi_types::T_e8_JunctionType_Name(value.getE8JunctionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8JunctionType());
    }
    if (!isSparse || value.hasBJunctionElementAngleAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bJunctionElementAngleAvailable" , 30);
        yajl_gen_bool(g, (bool)value.getBJunctionElementAngleAvailable());
    }
    if (!isSparse || value.hasJunctionElementAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "JunctionElementAngle" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< int16 >& o7 = value.getJunctionElementAngle();
        {
            ::std::vector< int16 >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                yajl_gen_integer(g, (long long)(*o6));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBJunctionElementExitAngleAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bJunctionElementExitAngleAvailable" , 34);
        yajl_gen_bool(g, (bool)value.getBJunctionElementExitAngleAvailable());
    }
    if (!isSparse || value.hasJunctionElementExitAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "JunctionElementExitAngle" , 24);
        yajl_gen_integer(g, (long long)value.getJunctionElementExitAngle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CallControlsConfiguration"

void serializeJson (const ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getInitiateCall()) {
        yajl_gen_string(g, (const unsigned char*)  "InitiateCall" , 12);
        yajl_gen_bool(g, (bool)value.getInitiateCall());
    }
    if (value.getAcceptCall()) {
        yajl_gen_string(g, (const unsigned char*)  "AcceptCall" , 10);
        yajl_gen_bool(g, (bool)value.getAcceptCall());
    }
    if (value.getEndCall()) {
        yajl_gen_string(g, (const unsigned char*)  "EndCall" , 7);
        yajl_gen_bool(g, (bool)value.getEndCall());
    }
    if (value.getSwapCalls()) {
        yajl_gen_string(g, (const unsigned char*)  "SwapCalls" , 9);
        yajl_gen_bool(g, (bool)value.getSwapCalls());
    }
    if (value.getMergeCalls()) {
        yajl_gen_string(g, (const unsigned char*)  "MergeCalls" , 10);
        yajl_gen_bool(g, (bool)value.getMergeCalls());
    }
    if (value.getHoldStatusUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "HoldStatusUpdate" , 16);
        yajl_gen_bool(g, (bool)value.getHoldStatusUpdate());
    }
    if (value.getMuteStatusUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "MuteStatusUpdate" , 16);
        yajl_gen_bool(g, (bool)value.getMuteStatusUpdate());
    }
    if (value.getSendDTMF()) {
        yajl_gen_string(g, (const unsigned char*)  "SendDTMF" , 8);
        yajl_gen_bool(g, (bool)value.getSendDTMF());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AppInfo"

void serializeJson (const ::mplay_appcontrol_fi_types::T_AppInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSAppName()) {
        yajl_gen_string(g, (const unsigned char*)  "sAppName" , 8);
        const char *s = value.getSAppName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSProtocol()) {
        yajl_gen_string(g, (const unsigned char*)  "sProtocol" , 9);
        const char *s = value.getSProtocol().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSBundleID()) {
        yajl_gen_string(g, (const unsigned char*)  "sBundleID" , 9);
        const char *s = value.getSBundleID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_AppInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DeviceTimeUpdate"

void serializeJson (const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU64SecondsSinceReferenceDate()) {
        yajl_gen_string(g, (const unsigned char*)  "u64SecondsSinceReferenceDate" , 28);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getU64SecondsSinceReferenceDate(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasS16TimeZoneOffsetMinutes()) {
        yajl_gen_string(g, (const unsigned char*)  "s16TimeZoneOffsetMinutes" , 24);
        yajl_gen_integer(g, (long long)value.getS16TimeZoneOffsetMinutes());
    }
    if (!isSparse || value.hasS8DaylightSavingsOffsetMinutes()) {
        yajl_gen_string(g, (const unsigned char*)  "s8DaylightSavingsOffsetMinutes" , 30);
        yajl_gen_integer(g, (long long)value.getS8DaylightSavingsOffsetMinutes());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_DiPODeviceInfoItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_BTProfileItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_b32_BTProfileType& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_DiPOCallStateItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_AppInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types
using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

std::ostream& operator<<(std::ostream& o, const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace mplay_appcontrol_fi_types

